/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/NewsInfo","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Fragment","sap/ui/documentation/library","sap/m/library","sap/base/Log","sap/base/util/Version","sap/ui/core/Core","sap/ui/util/openWindow","sap/ui/documentation/sdk/model/formatter","sap/m/ResponsivePopover","sap/ui/documentation/sdk/controller/util/Highlighter","sap/m/Button","sap/m/Toolbar","sap/ui/documentation/sdk/util/Resources","sap/base/util/LoaderExtensions","sap/ui/documentation/sdk/controller/util/ThemePicker"],function(jQuery,e,t,i,o,n,s,a,r,h,u,l,c,g,p,d,f,_,v,S,m,w,y,P){"use strict";var b=function(e){return w.getResourcesVersion()&&!self["sap-ui-documentation-config"]?window.origin+e:w.getResourceOriginPath(e)};var D="Demo Kit - � SDK",C={topic:"Documentation - "+D,api:"API Reference - "+D,controls:"Samples - "+D,demoapps:"Demo Apps - "+D,tools:"Tools - "+D,home:D};var V=l.URLHelper,A=l.SplitAppMode,I=b("/neo-app.json"),M=b("/versionoverview.json"),T="about",R="change_version",N="settings",k="cookie_preferences",E="en",L="language",O="appearance",U="sitemap";return e.extend("sap.ui.documentation.sdk.controller.App",{formatter:f,_arrToTreeConverter:function(){var e,t=this._aNeoAppVersions.slice(),i=[],o=0,n="";for(var s=0;s<t.length;s++){n=t[s].groupTitle;o=0;e=[];while(t[s]&&t[s].groupTitle&&t[s].groupTitle===n){e.push(t[s]);o++;s++}s--;i.push({groupTitle:n,version:n+" ("+o+" versions)",nodes:e,path:e[0].path})}return i},onInit:function(){e.prototype.onInit.call(this);var o=new s({busy:false,delay:0,device:r,bPhoneSize:false,bDesktopSize:false,bShowVersionSwitchButton:false,bDarkThemeActive:false,bLandscape:r.orientation.landscape,bHasMaster:false,bSearchMode:false,bHideTopicSection:!!window["sap-ui-documentation-hideTopicSection"],bHideApiSection:!!window["sap-ui-documentation-hideApiSection"],sAboutInfoSAPUI5:"Looking for the Demo Kit for a specific SAPUI5 version? "+"Check at <a href = 'https://ui5.sap.com/versionoverview.html'>https://ui5.sap.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://ui5.sap.com/1.71.46/'>https://ui5.sap.com/1.71.46/</a>",sAboutInfoOpenUI5:"Looking for the Demo Kit for a specific OpenUI5 version? "+"Check at <a href = 'https://sdk.openui5.org/versionoverview.html'>https://sdk.openui5.org/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://sdk.openui5.org/1.71.46/'>https://sdk.openui5.org/1.71.46/</a>"});var n=this.getOwnerComponent(),h=this;P.init(h);this.MENU_LINKS_MAP={copyright:"https://www.sap.com/corporate/en/legal/copyright.html",trademark:"https://www.sap.com/corporate/en/legal/trademark.html",disclaimer:"https://help.sap.com/viewer/disclaimer",sitemap:"sitemap"};jQuery.extend(this.MENU_LINKS_MAP,e.LEGAL_LINKS);this.getOwnerComponent().loadVersionInfo().then(function(){var e;if(this.getModel("versionData").getProperty("/isOpenUI5")){e="OPENUI5"}else{e="SAPUI5"}D=D.replace("�",e);Object.keys(C).forEach(function(t){C[t]=C[t].replace("�",e)});if(this._sKey){this.appendPageTitle(null).appendPageTitle(C[this._sKey])}}.bind(this));this.oRouter=this.getRouter();this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));this.oRouter.attachBypassed(this.onRouteNotFound.bind(this));this._aNeoAppVersions=[];this._oView=this.getView();this.setModel(o,"appView");this._oNewsModel=new s;this.setModel(this._oNewsModel,"news");this._oSupportedLangModel=new s;this.setModel(this._oSupportedLangModel,"supportedLanguages");this.setModel(new s,"messagesData");this._demoKitPage=this.byId("demoKitPage");this._demoKitSubHeader=this.byId("demoKitSubHeader");this._demoKitSideNavigation=this.byId("demoKitSideNavigation");this._demoKitSplitApp=this.byId("splitApp");this._demoKitSplitApp._oDetailNav.setAutoFocus(false);this._demoKitSplitApp.attachEvent("afterMasterClose",function(e){o.setProperty("/bIsShownMaster",false)},this);this._requestVersionInfo();this.initSearch();i.init();this.setSurveyModelData();this.bus=p.getEventBus();this.bus.subscribe("newsChanged","onDemoKitNewsChanged",this._syncNewsModelWithNewsInfo,this);this.bus.subscribe("themeChanged","onThemeChanged",this._onThemeChanged,this);this._oConfigUtil=this.getOwnerComponent().getConfigUtil();this._oCookieNames=this._oConfigUtil.COOKIE_NAMES;this._sLocalStorageNewsName=this._oConfigUtil.LOCAL_STORAGE_NAMES["OLD_NEWS_IDS"];t.prepareNewsData(this._oConfigUtil);this._createConfigurationBasedOnURIInput();if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"&&this._aConfiguration.length>0){this._applyCookiesConfiguration(this._aConfiguration)}else{this._applyDefaultConfiguration(this._aConfiguration)}n.getCookiesManagement().then(function(e){e.enable(n.getRootControl())});a.register(this._demoKitPage,this.onPageResize.bind(this))},onBeforeRendering:function(){r.orientation.detachHandler(this._onOrientationChange,this)},onAfterRendering:function(){jQuery(document.body).addClass(this.getOwnerComponent().getContentDensityClass());r.orientation.attachHandler(this._onOrientationChange,this);this._syncNewsModelWithNewsInfo();this._adjustVersionSwitchButton()},onExit:function(){r.orientation.detachHandler(this._onOrientationChange,this);if(this.highlighter){this.highlighter.destroy()}},onRouteChange:function(e){if(!this.oRouter.getRoute(e.getParameter("name"))._oConfig.target){return}var t,i,o=r.system.phone,n=e.getParameter("name"),s=this.oRouter.getRoute(n)._oConfig.target[0]+"Tab",a=this._oView.byId(s),h=a?a.getKey():"home",u=this.getModel("appView"),l=this.getOwnerComponent().getConfigUtil().hasMasterView(n);this._setHeaderSelectedKey(h);this._setSelectedSectionTitle(h);u.setProperty("/bHasMaster",l);if(o&&l){t=this.getOwnerComponent().getConfigUtil().getMasterView(n);i=t&&t.getId();u.setProperty("/sMasterViewId",i)}this._demoKitSplitApp.hideMaster();u.setProperty("/bIsShownMaster",false);this.appendPageTitle(null).appendPageTitle(C[h])},toggleMaster:function(e){var t=this.getModel("appView"),i=t.getProperty("/sMasterViewId"),o=this._demoKitSplitApp.getMode()===A.ShowHideMode,n=this._demoKitSplitApp.getMode()===A.HideMode,s=r.system.phone,a=e.getParameter("pressed"),h;if(!s&&(o||n)){h=a?this._demoKitSplitApp.showMaster:this._demoKitSplitApp.hideMaster;h.call(this._demoKitSplitApp);return}if(s){if(a){this._demoKitSplitApp.to(i)}else{this._demoKitSplitApp.backDetail()}}},navigateToSection:function(e){var t=e.getParameter("key")||e.getParameter("item").getKey(),i=e.getSource().isA("sap.tnt.SideNavigation");if(r.system.phone&&i){this.onSideNavigationButtonPress()}if(t&&t!=="home"){this.getRouter().navTo(t,{})}else{this.getRouter().navTo("welcome",{});this._setHeaderSelectedKey("home")}},navigateToNews:function(){this.getRouter().navTo("news")},onNewsButtonPress:function(e){var t=e.getSource(),i=this.getView();if(this._oNewsModel.getProperty("/newsCount")===0){this.navigateToNews()}else if(!this._oNewsPopover){h.load({name:"sap.ui.documentation.sdk.view.NewsPopover",controller:this}).then(function(e){i.addDependent(e);this._oNewsPopover=e;this._oNewsPopover.openBy(t)}.bind(this))}else{this._oNewsPopover.openBy(t)}},handleShowAllPress:function(){this._oNewsPopover.close();this.navigateToNews()},handleDismissAllPress:function(){t.moveAllNewItemsToOld()},handleNewsItemClose:function(e){var i=e.getSource(),o=i.getCustomData()[0].getValue(),n=this._oNewsModel.getProperty("/items").find(function(e){return e.id===o});t.moveNewItemToOld(n)},handleVisitNewsLink:function(e){var t=e.getSource(),i=t.getCustomData()[0].getValue();V.redirect(i,true)},_syncNewsModelWithNewsInfo:function(){var e,i=t.getPreparationFailureMessage();if(!i){e=t.getNewNewsArray().slice();this._oNewsModel.setProperty("/items",e);this._oNewsModel.setProperty("/newsCount",e.length)}this._oNewsModel.setProperty("/newsPreparationFailureMessage",i)},onMenuButtonItemSelected:function(e){var t=e.getParameter("item").getKey(),i=this.MENU_LINKS_MAP[t];if(t===T){this.aboutDialogOpen()}else if(t===N){this.settingsDialogOpen()}else if(t===k){this.getOwnerComponent().getCookiesManagement().then(function(e){e.cookieSettingsDialogOpen({showCookieDetails:true},this.getView())}.bind(this))}else if(t===R){this.onChangeVersionButtonPress()}else if(P._getTheme()[t]){this._updateAppearance(t)}else if(i===U){this.onSiteMapPress()}else if(i){V.redirect(i,true)}this.sTarget=i},createSearchPopover:function(){var e=l.PlacementType,t=this.getView().byId("searchControl"),i=new _({showArrow:false,showHeader:false,contentWidth:"600px",placement:e.Vertical,horizontalScrolling:false,initialFocus:this.getView().byId("searchControl-searchField")}).addStyleClass("sapMSltPicker-CTX");i.open=function(){i.openBy(t)};this.getView().addDependent(i);return i},createSearchPicker:function(){var e=r.system.phone?this.createSearchDialog():this.createSearchPopover();this.createSearchPickerContent().then(function(t){e.addContent(t)});return e},createSearchDialog:function(){var e,t,i,o,n,s,a;var r=this.getView().byId("searchControl");function h(){var i=r.getValue();if(i!==t){r._updateValue(i);r.fireLiveChange({newValue:i})}else{r.fireLiveChange({newValue:t})}e.close();r._toggleOpen(false)}function u(e){if(typeof e.selectionStart=="number"){e.selectionStart=e.selectionEnd=e.value.length}else if(typeof e.createTextRange!="undefined"){e.focus();var t=e.createTextRange();t.collapse(false);t.select()}}i=new(sap.ui.require("sap/m/SearchField"))({liveChange:function(e){var t=e.getParameter("newValue");r._updateValue(t);r.fireLiveChange({newValue:t})},search:function(t){if(!t.getParameter("clearButtonPressed")){e.close();a=true}}});s=new S({icon:"sap-icon://decline",press:function(){h()}});o=new m({content:[i,s]});n=new S({text:p.getLibraryResourceBundle("sap.m").getText("MSGBOX_OK"),press:function(){h()}});e=new(sap.ui.require("sap/m/Dialog"))({stretch:true,customHeader:o,beginButton:n,beforeClose:function(){r._bSuggestionSuppressed=true},beforeOpen:function(){t=r.getValue();i._updateValue(t);a=false},afterOpen:function(){var e=i.$().find("input");e.trigger("focus");u(e.get(0))},afterClose:function(e){if(a){r.fireSearch({query:r.getValue(),clearButtonPressed:false})}r._toggleOpen(false)}});this.getView().addDependent(e);return e},openSearchPicker:function(){if(!this.oPicker){this.oPicker=this.createSearchPicker()}if(!this.oPicker.isOpen()){this.oPicker.open()}},createSearchPickerContent:function(){return h.load({name:"sap.ui.documentation.sdk.view.GlobalSearchPicker",controller:this}).then(function(e){var t=p.byId("shortList"),i=this,o;t.addEventDelegate({onAfterRendering:function(){var e={useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false};i.highlighter=new v(t.getDomRef(),e);o=i.getModel("searchData").getProperty("/query");o&&i.highlighter.highlight(o);t.removeEventDelegate(this)}});return e}.bind(this))},initSearch:function(){var e=this.getModel("searchData"),t={topics:["topic","topicId","subTopicId"],entity:["sample","controlsMaster","controls","code","entity"],apiref:["api","apiSpecialRoute","apiId"]};this.oRouter.attachRouteMatched(function(){e.setProperty("/preferencedCategory",null)});Object.keys(t).forEach(function(i){var o=t[i];o.forEach(function(t){this.oRouter.getRoute(t).attachPatternMatched(function(){e.setProperty("/preferencedCategory",i)})}.bind(this))}.bind(this))},getSearchPickerTitle:function(e){var t=p.getLibraryResourceBundle("sap.ui.documentation"),i;switch(this.getModel("searchData").getProperty("/preferencedCategory")){case"topics":i=t.getText("SEARCH_SUGGESTIONS_TITLE_DOCUMENTATION");break;case"apiref":i=t.getText("SEARCH_SUGGESTIONS_TITLE_API_REFERENCE");break;case"entity":i=t.getText("SEARCH_SUGGESTIONS_TITLE_SAMPLES");break;default:i=t.getText("SEARCH_SUGGESTIONS_TITLE_ALL")}return i},formatSuggestionTitle:function(e,t){var i=e||"";if(t){i+=": "+t}return i},onSearchResultsSummaryPress:function(e){var t=e.oSource.data("category");this.navToSearchResults(t)},onSearchPickerItemPress:function(e){var t=e.oSource.getBindingContextPath(),i=this.getModel("searchData").getProperty(t);if(i.external){d(new URL(i.path,document.baseURI).href)}else{this.getRouter().parsePath(i.path)}this.oPicker.close()},_updateAppearance:function(e){var t=this;P._updateAppearance(e,t)},_createConfigurationBasedOnURIInput:function(){var e=new URLSearchParams(window.location.search);this._aConfiguration=[];if(!(e.has("sap-ui-language")||e.has("sap-language"))){this._aConfiguration.push(L)}if(!(e.has("sap-ui-theme")||e.has("sap-theme"))){this._aConfiguration.push(O)}},_applyDefaultConfiguration:function(){this._aConfiguration.forEach(function(e){if(e===L){p.getConfiguration().setLanguage(E)}else if(e===O){this._updateAppearance(P._getTheme().auto)}},this);this._oSupportedLangModel.setProperty("/selectedLang",p.getConfiguration().getLanguage())},_applyCookiesConfiguration:function(){var e,t,i;for(i=0;i<this._aConfiguration.length;i++){t=this._aConfiguration[i];e=this._oConfigUtil.getCookieValue(t);if(e!==""){if(t===L){this._setSelectedLanguage(e)}else if(t===O){this._updateAppearance(e)}this._aConfiguration.splice(i,1);i--}}if(this._aConfiguration.length>0){this._applyDefaultConfiguration()}},_prepareSupportedLangModelData:function(){return p.getConfiguration().getLanguagesDeliveredWithCore().reduce(function(e,t){var i,o=t,n=t;if(typeof t==="string"&&t.length>0){switch(t){case"sh":o="sr_Latn";break;case"no":o="nb";break;case"iw":o="he";n="he";break;case"zh_TW":n="zh_Hant";break;case"zh_CN":n="zh_Hans";break}e.push(new Promise(function(e,s){y.loadResource("sap/ui/core/cldr/"+o+".json",{async:true}).then(function(o){i=o.languages[n];e({text:typeof i==="string"?i.charAt(0).toUpperCase()+i.substring(1):"Unknown",key:t})})}))}return e},[])},_setSelectedLanguage:function(e){this._oSupportedLangModel.setProperty("/selectedLang",e);p.getConfiguration().setLanguage(e);if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"){this._oConfigUtil.setCookie(L,e)}if(this._sKey){this._setSelectedSectionTitle(this._sKey)}},_getSelectedLanguage:function(){return this._oSupportedLangModel.getProperty("/selectedLang")},settingsDialogOpen:function(){var e;if(!this._oSettingsDialog){h.load({name:"sap.ui.documentation.sdk.view.globalSettingsDialog",controller:this}).then(function(e){this._oView.addDependent(e);this._oSettingsDialog=e;p.byId("LanguageSelect").setSelectedKey(this._getSelectedLanguage());this._oSettingsDialog.open()}.bind(this))}else{this._oSettingsDialog.open()}if(!this._oSupportedLangModel.getProperty("/langs")){e=this._oSupportedLangModel;e.setProperty("/selectBusy",true);Promise.all(this._prepareSupportedLangModelData()).then(function(t){e.setProperty("/selectBusy",false);e.setProperty("/langs",t)})}},handleCloseAppSettings:function(){this._oSettingsDialog.close()},handleSaveAppSettings:function(){var e=p.byId("LanguageSelect").getSelectedKey();this._oSettingsDialog.close();this._applyAppConfiguration(e)},_applyAppConfiguration:function(e){this._setSelectedLanguage(e)},getAboutDialog:function(){return new Promise(function(e,t){if(!this._oAboutDialog){h.load({id:"aboutDialogFragment",name:"sap.ui.documentation.sdk.view.AboutDialog",controller:this}).then(function(t){this._oAboutDialog=t;this._oView.addDependent(this._oAboutDialog);e(this._oAboutDialog)}.bind(this))}else{e(this._oAboutDialog)}}.bind(this))},aboutDialogOpen:function(){this.getAboutDialog().then(function(e){e.getContent()[0].backToTop();e.open()})},aboutDialogClose:function(e){this.getAboutDialog().then(function(e){e.close()})},onAboutVersionDetails:function(e){var t=this.getModel("appView"),i=t.getData(),o=this;u._loadAllLibInfo("","_getLibraryInfo","",function(e,n){var s={};var a=u._getLibraryInfoSingleton();for(var r=0,h=e.length;r<h;r++){e[r]=n[e[r]];e[r].libDefaultComponent=a._getDefaultComponent(e[r])}s.libs=e;i.oVersionInfo=s;t.setData(i);o.setModel(t,"appView")});var n=h.byId("aboutDialogFragment","aboutNavCon"),s=h.byId("aboutDialogFragment","aboutDetail");n.to(s)},onAboutThirdParty:function(e){var t=this.getModel("appView"),i=t.getData(),o=this;u._loadAllLibInfo("","_getThirdPartyInfo",function(e,n){if(!e){return}var s={};s.thirdparty=[];for(var a=0;a<e.length;a++){var r=n[e[a]];for(var h=0;h<r.libs.length;h++){var u=r.libs[h];u._lib=e[a];s.thirdparty.push(u)}}s.thirdparty.sort(function(e,t){var i=(e.displayName||"").toUpperCase();var o=(t.displayName||"").toUpperCase();if(i>o){return 1}else if(i<o){return-1}else{return 0}});i.oThirdPartyInfo=s;t.setData(i);o.setModel(t,"appView")});var n=h.byId("aboutDialogFragment","aboutNavCon"),s=h.byId("aboutDialogFragment","aboutThirdParty");n.to(s)},_getReleaseDialog:function(){return new Promise(function(e){if(!this._oReleaseDialog){h.load({id:"releaseDialogFragment",name:"sap.ui.documentation.sdk.view.ReleaseDialog",controller:this}).then(function(t){this._oReleaseDialog=t;this._oView.addDependent(this._oReleaseDialog);e(this._oReleaseDialog)}.bind(this))}else{e(this._oReleaseDialog)}}.bind(this))},_getNotesView:function(){var e;return new Promise(function(t){if(!this._oNotesView){e=new s;h.load({id:"notesView",name:"sap.ui.documentation.sdk.view.ReleaseNotesView",controller:this}).then(function(i){this._oNotesView=i;this._oNotesView.setModel(e);t(this._oNotesView)}.bind(this))}else{t(this._oNotesView)}}.bind(this))},onReleaseDialogOpen:function(e){var t=u._getLibraryInfoSingleton(),i=e.getSource().data("version"),o=e.getSource().data("library"),n=new s;Promise.all([this._getReleaseDialog(),this._getNotesView()]).then(function(e){var s=e[0],a=e[1],r={};t._getReleaseNotes(o,i,function(e,t){var i={};if(e&&e[t]&&e[t].notes&&e[t].notes.length>0){r=e[t]}else{i.noData=true}a.getModel().setData(r);i.library=o;n.setData(i)});s.setModel(n);s.addContent(a);s.open()})},onReleaseDialogClose:function(e){this._getReleaseDialog().then(function(e){e.close()})},onAboutNavBack:function(e){var t=h.byId("aboutDialogFragment","aboutNavCon");t.back()},onChangeVersionButtonPress:function(){this.getVersionSwitchDialog().then(function(e){e.open()})},onCloseVersionDialog:function(){this.getVersionSwitchDialog().then(function(e){e.close()})},onChangeVersionDialogSearch:function(e){var t=e.getParameter("newValue"),i=new o("version",n.Contains,t),s=p.byId("versionList"),a=s.getBinding("items");a.filter([i]);if(a.getChildCount()===1){a.expand(0)}else{s.collapseAll()}},onHeaderLogoPress:function(){this._demoKitPage.setSideExpanded(false);this.oRouter.navTo("welcome",{})},onSiteMapPress:function(){this.oRouter.navTo("sitemap",{})},onLatestVersionItemPress:function(){if(w.getResourcesVersion()){window.sessionStorage.removeItem("versionPrefixPath");window.location.reload()}else{window.location.href="/"}},onVersionItemPress:function(e){var t=p.byId("versionList").getSelectedItem(),i=t.getCustomData()[0];if(i&&i.getKey()==="path"){if(w.getHasProxy()){window.sessionStorage.setItem("versionPrefixPath",i.getValue());window.location.reload()}else{window.location.href=i.getValue()}}},getVersionSwitchDialog:function(){return new Promise(function(e){if(!this._oChangeVersionDialog){h.load({name:"sap.ui.documentation.sdk.view.ChangeVersionDialog",controller:this}).then(function(t){this._oChangeVersionDialog=t;this._oChangeVersionDialog.setModel(this._buildVersionDialogModel());this._oView.addDependent(this._oChangeVersionDialog);e(this._oChangeVersionDialog)}.bind(this))}else{e(this._oChangeVersionDialog)}}.bind(this))},versionSwitchCustomComparator:function(e,t){return g(e).compareTo(g(t))},_updateVersionSwitchVisibility:function(){this.getModel("appView").setProperty("/bShowVersionSwitchButton",!!this._aNeoAppVersions.length)},_buildVersionDialogModel:function(){var e=new s;e.setSizeLimit(1e3);e.setData(this._aNeoAppVersions);e.setData(this._arrToTreeConverter(this._aNeoAppVersions));return e},launchSurvey:function(e,t){var i=this.byId(!t?"surveyButton":"aboutMenuButton"),o=this.getView(),n=this.getModel("appView"),s=n.getProperty("/bShowLongSurvey");if(!s){this.shortSurveyRedirect()}else if(!this._oSurveyPopover){h.load({name:"sap.ui.documentation.sdk.view.SurveyPopover",controller:this}).then(function(e){o.addDependent(e);this._oSurveyPopover=e;if(r.system.phone){this.addSurveyPopoverCloseBtn()}this._oSurveyPopover.openBy(i)}.bind(this))}else{this._oSurveyPopover.openBy(i)}},closeSurveyPopover:function(e){this._oSurveyPopover.close()},shortSurveyRedirect:function(){var e="?Release_version="+this._getUI5Version()+"&Source="+this._getUI5Distribution()+"&Type="+this._getUI5VersionType()+"&product=SAPUI5%2FOpenUI5"+"&product_filter=UI5"+"&cluster=BTP"+"&page="+encodeURIComponent(document.location.href);var t="https://sapinsights.eu.qualtrics.com/jfe/form/SV_byI4QeS7Ic2Psyi"+e,i="https://sapinsights.eu.qualtrics.com/jfe/form/SV_3Epqk1MLAUQVrwy"+e,o=!this.getModel("versionData").getProperty("/isDevEnv");V.redirect(o?t:i,true)},longSurveyRedirect:function(){var e="https://sapinsights.eu.qualtrics.com/jfe/form/SV_7X5P63Zg5zXC5zE",t="?product=SAPUI5%2FOpenUI5"+"&product_filter=UI5"+"&cluster=BTP"+"&page="+encodeURIComponent(document.location.href),i=e+t,o=e+t+"&Q_CHL=preview&Q_SurveyVersionID=current",n=!this.getModel("versionData").getProperty("/isDevEnv");V.redirect(n?i:o,true)},setSurveyModelData:function(){var e=this.getModel("appView"),t=new Date,i=t.getFullYear(),o=[[new Date(i,1,1),new Date(i,1,21)],[new Date(i,4,1),new Date(i,4,21)],[new Date(i,7,1),new Date(i,7,21)],[new Date(i,10,1),new Date(i,10,21)]],n=false,s;o.forEach(function(e){var i=e[0],o=e[1];if(t>=i&&t<=o){n=true;s=o.toLocaleDateString();return}});e.setProperty("/bShowLongSurvey",n);if(n){e.setProperty("/sLongSurveyLastDate",s)}},addSurveyPopoverCloseBtn:function(){var e=this.getModel("i18n").getResourceBundle(),t=this.closeSurveyPopover.bind(this),i=new S({text:e.getText("SURVEY_POPOVER_CLOSE_BTN"),press:t});this._oSurveyPopover.setEndButton(i)},onSearch:function(e){var t=encodeURIComponent(e.getParameter("query"));if(!t){return}this.getRouter().navTo("search",{searchParam:t},false);this.oPicker.close()},navToSearchResults:function(e){var t=this.getModel("searchData").getProperty("/query"),i={searchParam:t};if(!t){return}if(e){i["?options"]={category:e}}this.getRouter().navTo("search",i,true);this.oPicker.close()},onSearchLiveChange:function(e){var t=this.getModel("searchData"),o=e.getParameter("newValue"),n=t.getProperty("/preferencedCategory"),s=t.getProperty("/includeDeprecated");if(!o&&r.system.desktop){if(this.oPicker.isOpen()){this.oPicker.close()}return}this.openSearchPicker();if(this.highlighter){this.highlighter.highlight(o)}t.setProperty("/query",o);i.search(o,{preferencedCategory:n,includeDeprecated:s}).then(function(e){t.setProperty("/matches",e.matches)})},onPageResize:function(e){var t=e.size.width,i=t>=r.media._predefinedRangeSets[r.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1],o=t<r.media._predefinedRangeSets[r.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0],n=this.getModel("appView");if(o!==n.getProperty("/bPhoneSize")){n.setProperty("/bPhoneSize",o);this._demoKitPage.setSideExpanded(false)}if(i!==n.getProperty("/bDesktopSize")){n.setProperty("/bDesktopSize",i);setTimeout(function(){this._updateSearchFieldState()}.bind(this),0)}},onSideNavigationButtonPress:function(){this._demoKitPage.setSideExpanded(!this._demoKitPage.getSideExpanded())},_onOrientationChange:function(){this.getModel("appView").setProperty("/bLandscape",r.orientation.landscape)},onToggleSearchMode:function(e){var t=e.getParameter("isOpen"),i=this.getModel("appView");i.setProperty("/bSearchMode",t);if(t){setTimeout(function(){if(r.system.desktop){this._oView.byId("searchControl").getAggregation("_searchField").getFocusDomRef().focus()}else{this.openSearchPicker()}}.bind(this),0)}},_getCurrentYear:function(){return(new Date).getFullYear()},_getCurrentQuarter:function(){var e=new Date,t=e.getMonth(),i=Math.floor(t/3)+1;return i},_filterVersionsPastEOCP:function(e){var t=e.patches;return t.filter(function(e){var t=e.extended_eocp||e.eocp||"";if(!t){return true}var i=/^Q[1-4]\/\d{4}$/i.test(t);if(!i){return true}var o=Number(t.substring(1,2)),n=Number(t.substring(3));return n>this._getCurrentYear()||n===this._getCurrentYear()&&o>=this._getCurrentQuarter()}.bind(this))},_processVersionOverview:function(e){var t=e.versions,i=[];if(Array.isArray(t)){t=t.filter(function(e){return!!e.hidden}).forEach(function(e){var t=e.hidden.split(",").map(function(e){return e.trim()});i=i.concat(t)})}return i},_processNeoAppJSON:function(e){var t=this.getModel("versionData"),i=t.getProperty("/isInternal"),o=t.getProperty("/isSnapshotVersion"),n=[];if(!(e&&e.routes)){c.warning("No versions were found");return}n=e.routes;n.pop();if(!i&&!o){n=n.filter(function(e){return e.target.version.indexOf("-beta")===-1})}n=n.map(function(e){var t=g(e.target.version),i={};i.patchVersion=t.getPatch();i.groupTitle=t.getMajor()+"."+t.getMinor();i.version=t.toString();i.path=e.path;return i});return n},_requestVersionInfo:function(){Promise.all([jQuery.ajax(I),jQuery.ajax(M)]).then(function(e){var t=this._processNeoAppJSON(e[0]),i=this._processVersionOverview(e[1]),o=this._filterVersionsPastEOCP(e[1]);if(Array.isArray(t)){t=t.filter(function(e){return i.indexOf(e.version)===-1});t=t.filter(function(e){return o.find(function(t){return t.version===e.version})});this._aNeoAppVersions=t;this._updateVersionSwitchVisibility();this.getModel("versionData").setProperty("/latestVersion",this._aNeoAppVersions[0].version)}else{this._aNeoAppVersions=[];c.warning("No multi-version environment detected")}}.bind(this),function(){c.warning("No neo-app.json or versionoverview.json was detected")})},_getFullVersion:function(){return this.getModel("versionData").getProperty("/fullVersion")},_getUI5Version:function(){return w.getResourcesVersion()?window.sessionStorage.getItem("versionPrefixPath"):this.getModel("versionData").getProperty("/version")},_getUI5VersionGav:function(){return this.getModel("versionData").getProperty("/versionGav")},_getUI5Distribution:function(){var e=this._getUI5VersionGav(),t="SAPUI5";if(e&&/openui5/i.test(e)){t="OpenUI5"}return t},_getUI5VersionType:function(){var e=this.getModel("versionData"),t=e.getProperty("/isInternal"),i=e.getProperty("/isSnapshotVersion"),o;switch(true){case i&&t:o="InternalSnapshot";break;case t:o="Internal";break;case i:o="Snapshot";break;default:o="Release"}return o},_getCurrentPageRelativeURL:function(){var e=window.location;return e.pathname+e.hash+e.search},_getCurrentURL:function(){var e=window.location;return e.href},_setHeaderSelectedKey:function(e){this._demoKitSubHeader.setSelectedKey(e);this._demoKitSideNavigation.setSelectedKey(e);this._sKey=e},_onThemeChanged:function(e,t,i){var o=this.getModel("appView"),n=i.sThemeActive,s=n&&(n.includes("dark")||n.includes("hcb"));o.setProperty("/bDarkThemeActive",s)},_updateSearchFieldState:function(){var e=this.getModel("appView"),t=e.getProperty("/bDesktopSize"),i=this.byId("searchControl").getAggregation("_closingButton");if(t){e.setProperty("/bSearchMode",false);i.setVisible(false)}else{i.setVisible(true)}},_setSelectedSectionTitle:function(e){var t=this.getModel("appView"),i=this.getModel("i18n").getResourceBundle();var o=[{key:"home",text:i.getText("APP_TABHEADER_ITEM_HOME")},{key:"topic",text:i.getText("APP_TABHEADER_ITEM_DOCUMENTATION")},{key:"api",text:i.getText("APP_TABHEADER_ITEM_API_REFERENCE")},{key:"controls",text:i.getText("APP_TABHEADER_ITEM_SAMPLES")},{key:"demoapps",text:i.getText("APP_TABHEADER_ITEM_DEMO_APPS")},{key:"tools",text:i.getText("APP_TABHEADER_ITEM_TOOLS")}];var n=o.find(function(t){return t.key===e});t.setProperty("/selectedSectionTitle",n.text)},_adjustVersionSwitchButton:function(){var e=this.byId("versionSwitchButton");if(e){e.addEventDelegate({onAfterRendering:function(){var t=e.getDomRef(),i=t.querySelector(".sapMBtnContent");if(i){if(!i.classList.contains("sapUiDemoKitHeaderActionsVersionSwitchTextContent")){i.classList.add("sapUiDemoKitHeaderActionsVersionSwitchTextContent")}}}})}}})});
//# sourceMappingURL=App.controller.js.map