/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/m/MessageBox","sap/m/MessageToast","sap/ui/Device","sap/ui/VersionInfo","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ResourceDownloadUtil","sap/ui/documentation/sdk/model/formatter","sap/ui/documentation/sdk/model/libraryData","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/thirdparty/jquery","sap/ui/core/Fragment"],function(e,t,n,i,o,a,r,s,l,d,u,c,h,jQuery,p){"use strict";return a.extend("sap.ui.documentation.sdk.controller.DemoApps",{formatter:s,onInit:function(){var e=new c,t=new h({bundleName:"sap.ui.documentation.messagebundle"});l.fillJSONModel(e).then(function(){return this.loadDemoAppsCellFragments(e)}.bind(this)).then(function(t){this._cellFragments=t;this.setModel(e)}.bind(this));this.getView().setModel(t,"i18n");this.setModel(new c({demoAppsHomeLink:"topic/a3ab54ecf7ac493b91904beb2095d208"}),"newWindowLinks");this.getRouter().getRoute("demoapps").attachPatternMatched(this._onMatched,this);o.load().then(function(e){var t=new c({isOpenUI5:e&&e.gav&&/openui5/i.test(e.gav)});this.getView().setModel(t,"appView")}.bind(this));this._onOrientationChange({landscape:i.orientation.landscape});this._onResize({name:i.resize.width<=600?"Phone":"NoPhone"})},onBeforeRendering:function(){this._deregisterOrientationChange()},onAfterRendering:function(){this._registerOrientationChange();this._registerResize()},onExit:function(){this._deregisterOrientationChange();this._deregisterResize()},_registerOrientationChange:function(){i.orientation.attachHandler(this._onOrientationChange,this)},_deregisterOrientationChange:function(){i.orientation.detachHandler(this._onOrientationChange,this)},_registerResize:function(){i.media.attachHandler(this._onResize,this)},_deregisterResize:function(){i.media.detachHandler(this._onResize,this)},_onOrientationChange:function(e){this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape",e.landscape)},_onResize:function(e){this.byId("phoneImage").setVisible(e.name==="Phone");this.byId("desktopImage").setVisible(e.name!=="Phone");this.byId("phoneImage").toggleStyleClass("phoneHeaderImageDesktop",e.name==="Phone")},_onMatched:function(){try{this.hideMasterSide()}catch(t){e.error(t)}},onDownloadButtonPress:function(e){var t=this.byId("downloadDialog"),n=this.byId("downloadDialogList");this._oDownloadButton=e.getSource();n.getBinding("items").filter([]);t.open()},onReadMoreButtonPress:function(){var e=s.formatHttpHrefForNewWindow(this.getModel("newWindowLinks").getProperty("/demoAppsHomeLink"));window.open(e,"_blank")},onSearch:function(e){var t=this.byId("downloadDialogList"),n=e.getParameter("newValue");t.getBinding("items").filter([new d("name",u.Contains,n)])},onCloseDialog:function(){var e=this.byId("downloadDialog"),t=this.byId("downloadDialogSearch");e.close();t.setValue("")},onDownloadPress:function(e){var t=e.getParameters().selectedItem,i=t?t:e.getSource().getParent();this._oDownloadButton.setBusy(true);sap.ui.require(["sap/ui/core/util/File","sap/ui/thirdparty/jszip"],function(e,t){var o=new t;jQuery.getJSON(i.data("config"),function(t){var a=t.files,s=[],l=[];a.forEach(function(e){var n=r.fetch(t.cwd+e);n.then(function(t){if(t.errorMessage){l.push(t.errorMessage)}else{if(!e.startsWith("../")){o.file(e,t,{base64:false,binary:true})}}});s.push(n)});
// add generic license file
var d=sap.ui.require.toUrl("LICENSE.txt").replace("resources/","");var u=r.fetch(d);var c=new Promise(function(e,t){u.then(function(t){o.file("LICENSE.txt",t);e()}).catch(function(){
// LICENSE.txt not available in SAPUI5, continue without it
e()})});s.push(c);Promise.all(s).then(function(){if(l.length){var t=l.reduce(function(e,t){return e+t+"\n"},"Could not locate the following download files:\n");this._handleError(t)}this._oDownloadButton.setBusy(false);n.show('Downloading for app "'+i.getLabel()+'" has been started');var a=o.generate({type:"blob"});this._createArchive(e,a,i.getLabel())}.bind(this))}.bind(this))}.bind(this))},loadDemoAppsCellFragments:function(e){var t={},n=this.createDemoAppCell.bind(this),i=e.getProperty("/demoAppsByCategory");function o(e){return Promise.all(e.rows.map(a))}function a(e){return Promise.all(e.map(function(e){return n(e).then(function(n){t[e.id]=n})}))}return new Promise(function(e,n){Promise.all(i.map(o)).then(function(){e(t)}).catch(function(e){n(e)})})},createDemoAppCellFactory:function(e,t){var n=t.getObject().id;return this._cellFragments[n]},onDemoAppCellCreated:function(e,t){var n=t[0],i=t[1];i.getContent()[0].addContent(n);sap.ui.loader.config({paths:{"test-resources":null}});n.addEventDelegate({onAfterRendering:function(){this.getParent().getDomRef().childNodes[1].setAttribute("aria-hidden","true")}.bind(n)});i.setBindingContext(e);return i},onDemoAppCellFailed:function(t,n){e.warning('Teaser for demo app "'+t.name+'" could not be loaded: '+n);return this.createNormalDemoAppCell(t)},createNormalDemoAppCell:function(e){return new Promise(function(t){p.load({id:e.id,name:"sap.ui.documentation.sdk.view.BlockLayoutCell",controller:this}).then(function(n){n.setBindingContext(e);t(n)})}.bind(this))},createDemoAppCellFromTeaser:function(e){sap.ui.loader.config({paths:{"test-resources":"test-resources"}});var t=sap.ui.require.toUrl(e.teaser),n=p.load({id:e.id,name:t,controller:this}),i=p.load({id:e.id,name:"sap.ui.documentation.sdk.view.BlockLayoutTeaserCell",controller:this}),o=this.onDemoAppCellCreated.bind(this,e),a=this.onDemoAppCellFailed.bind(this,e);return Promise.all([n,i]).then(function(e){return o(e)}).catch(function(e){return a(e)})},createDemoAppCell:function(e){if(e.teaser){return this.createDemoAppCellFromTeaser(e)}else{return this.createNormalDemoAppCell(e)}},_createArchive:function(e,t,n){e.save(t,n,"zip","application/zip")},_handleError:function(e){t.error(e)},handleLandingImageLoad:function(){this.byId("landingImageHeadline").setVisible(true)}})});
//# sourceMappingURL=DemoApps.controller.js.map