/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseController","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/controller/util/DocuInfo","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/ToolsInfo","sap/ui/documentation/sdk/model/libraryData"],function(t,e,o,a,n,i,s){"use strict";var r={API:"api",TOPIC:"topic",TOOLS:"tools",ENTITY:"entity",DEMO_APPS:"demoApps"};var u={};u[r.API]={getData:e.getIndexJsonPromise,formatNode:function(t){return{name:t.name,href:r.API+"/"+t.name,hidden:t.visibility!=="public"}}};u[r.TOPIC]={getData:function(t){return o.getDocuIndexPromise(t)},formatNode:function(t){return{name:t.text,href:r.TOPIC+"/"+t.key}}};u[r.ENTITY]={getData:n.loadData,formatNode:function(t){return{name:t.id,href:r.ENTITY+"/"+t.id}}};u[r.DEMO_APPS]={getData:s.getDemoAppsData,formatNode:function(t){return{name:t.name,href:t.ref}}};u[r.TOOLS]={getData:i.getToolsConfig,formatNode:function(t){return{name:t.text,href:t.href,hidden:!t.href}}};function d(t,e){var o=[],a,n;for(var i=0;i<t.length;i++){a=t[i];n=u[e].formatNode(a);if(n.hidden!==true){o.push(n)}}return o}return t.extend("sap.ui.documentation.sdk.controller.Sitemap",{onInit:function(){this.oPage=this.byId("sitemapPage");this.oModel=new a;this.getView().setModel(this.oModel);this._oData={};this.getRouter().getRoute("sitemap").attachPatternMatched(this._onMatched,this)},_onMatched:function(){this.hideMasterSide();this.oPage.setBusy(true);this._loadResources().then(function(){this.oPage.setBusy(false);this.oModel.setData(this._oData)}.bind(this)).catch(function(){this.onRouteNotFound()}.bind(this));this.appendPageTitle(this.getModel("i18n").getProperty("SITEMAP_TITLE"))},_loadResources:function(){var t=Object.keys(r).map(function(t){var e=r[t];return u[e].getData(this.getConfig()).then(function(t){this._onDataLoaded({data:t,type:e})}.bind(this))},this);return Promise.all(t)},_onDataLoaded:function(t){switch(t.type){case r.API:this._onApiRefData(t.data);break;case r.TOPIC:this._onTopicsData(t.data);break;case r.ENTITY:this._onSamplesData(t.data);break;case r.DEMO_APPS:this._onDemoAppsData(t.data);break;case r.TOOLS:this._onToolsData(t.data);break}},_getDocuIndexPromise:function(){return o.getDocuIndexPromise(this.getConfig())},_onApiRefData:function(t){var e=r.API,o;o=t.reduce(function(t,o){if(o.visibility==="public"&&o.nodes){return t.concat(d(o.nodes,e))}return t},[]);this._oData[e]=o},_onTopicsData:function(t){var e=r.TOPIC;this._oData[e]=d(t,e)},_onSamplesData:function(t){var e=r.ENTITY;this._oData[e]=d(t.entities,e)},_onDemoAppsData:function(t){var e=r.DEMO_APPS;this._oData[e]=d(t.demoApps,e)},_onToolsData:function(t){var e=r.TOOLS;this._oData[e]=d(t,e)},onNavButtonPress:function(){this.getRouter().myNavBack("welcome")}})});
//# sourceMappingURL=Sitemap.controller.js.map