/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define([],function(){"use strict";var e={};e.CURRENTLY_HIGHLIGHTED_DOM_REFS=[];e.MUTATION_OBSERVER=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;var t=function e(t,i){this._bIsCaseSensitive=!!i.isCaseSensitive;this._aPreviouslyHighlightedNodes=[];this._aPreviouslyOriginalNodes=[];this._aOldTerms=[];this._aRegExTerms=[];this._bUseExternalStyles=!!i.useExternalStyles;this._oObserver=null;if(Array.isArray(t)){this._oDomRef=t}else{this._oDomRef=[t]}this._oDomRef.forEach(this.validate,this);if(i.shouldBeObserved){this._addMutationObserver()}};t.prototype.validate=function(t){if(e.CURRENTLY_HIGHLIGHTED_DOM_REFS.indexOf(t)===-1){e.CURRENTLY_HIGHLIGHTED_DOM_REFS.forEach(function(e){if(this._bIsDomNodeDescendant(t,e)){throw new Error("Desired DOM Ref is parent of DOM Ref which is being highlighted.")}else if(this._bIsDomNodeDescendant(e,t)){throw new Error("Desired DOM Ref is child of DOM Ref which is being highlighted.")}},this);e.CURRENTLY_HIGHLIGHTED_DOM_REFS.push(t)}else{throw new Error("Highlighter instance is already created for this DOM Reference")}};t.prototype.highlight=function(e){var t;if(!e){this._restorePreviouslyHighlightedNodes();this._aRegExTerms=[];this._aOldTerms=[];return}t=this._formatTerms(e);if(!t||!t.length||this._isNewTermsSameAsOld(t)){return}this._aOldTerms=t;this._cacheRegExTerms();if(this._aPreviouslyHighlightedNodes&&this._aPreviouslyHighlightedNodes.length>0){this._restorePreviouslyHighlightedNodes()}this._toggleMutationObserver(false);this._oDomRef.forEach(function(e){this._highlightSubTree(e)},this);this._toggleMutationObserver(true)};t.prototype._cacheRegExTerms=function(){var e;this._aRegExTerms=[];this._aOldTerms.forEach(function(t){t=this._escapeRegExp(t);e=this._bIsCaseSensitive?new RegExp(t,"g"):new RegExp(t,"gi");this._aRegExTerms.push(e)},this)};t.prototype._escapeRegExp=function(e){return e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&")};t.prototype._isNewTermsSameAsOld=function(e){var t=this._aOldTerms.length,i;if(t!==e.length){return false}for(i=0;i<t;i++){if(this._aOldTerms[i]!==e[i]){return false}}return true};t.prototype._highlightSubTree=function(e){var t,i;for(i=0;i<e.childNodes.length;i++){t=e.childNodes[i];this._processNode(t)}};t.prototype._processNode=function(e){var t,i,s,r,o,n,h,a,l,u;if(e.nodeName==="IFRAME"){this._highlightSubTree(e.contentDocument.body);return}if(e.nodeType===document.ELEMENT_NODE){this._highlightSubTree(e)}else if(e.nodeType===document.TEXT_NODE){t=e.data;o=Object.create(null);a=[];for(s=0;s<this._aRegExTerms.length;s++){i=this._aRegExTerms[s];while((h=i.exec(t))!==null){l=h["index"];if(a.indexOf(l)===-1){n=h["0"];o[l]=n;for(r=l;r<l+n.length;r++){a.push(r)}}}}if(Object.keys(o).length!==0){u=this._createHighlightedNode(o,t);this._replaceNode(e,u)}}};t.prototype._formatTerms=function(e){var t=e&&e.replace(/\s+/g," ").trim().split(" "),i;i=t.reduce(function(e,t){if(e.indexOf(t)===-1){e.push(t)}return e},[]);return i.sort(function(e,t){return t.length-e.length})};t.prototype._replaceNode=function(e,t){if(e.parentNode){e.parentNode.replaceChild(t,e);this._aPreviouslyHighlightedNodes.push(t);this._aPreviouslyOriginalNodes.push(e)}};t.prototype._restorePreviouslyHighlightedNodes=function(){var e,t;this._toggleMutationObserver(false);for(var i=0;i<this._aPreviouslyHighlightedNodes.length;i++){e=this._aPreviouslyHighlightedNodes[i];t=this._aPreviouslyOriginalNodes[i];if(e.parentNode){e.parentNode.replaceChild(t,e)}}this._aPreviouslyHighlightedNodes=[];this._aPreviouslyOriginalNodes=[];this._toggleMutationObserver(true)};t.prototype._createHighlightedNode=function(e,t){var i=document.createElement("span"),s=[],r=function(e,t){return parseInt(e)>parseInt(t)},o=Object.keys(e).sort(r),n,h=0;for(var a=0;a<o.length;a++){var l=Number(o[a]),u=e[l],d=u.length,g=t.substring(h,l);if(g.length){s.push(g)}s.push(u);h=l+d}if(h<t.length){s.push(t.substring(h))}for(n in s){var f=document.createElement("span");f.innerText=s[n];if(Object.values(e).indexOf(s[n])>-1){f.classList.add("defaultHighlightedText")}i.appendChild(f)}return i};t.prototype._addMutationObserver=function(){this._instantiateMutationObserver();this._toggleMutationObserver(true)};t.prototype._removeMutationObserver=function(){this._toggleMutationObserver(false);this._oObserver=null;this._oDomRef=[]};t.prototype._toggleMutationObserver=function(e){if(e){this._oDomRef.forEach(function(e){this._oObserver.observe(e,this.oObserverConfig)},this)}else{this._oObserver.disconnect()}};t.prototype._bIsDomNodeDescendant=function(e,t){return e.contains(t)};t.prototype._instantiateMutationObserver=function(){this.oObserverConfig={attributes:false,childList:true,characterData:true,subtree:true};this._oObserver=new e.MUTATION_OBSERVER(this._onMutationDetectionCallback.bind(this))};t.prototype._onMutationDetectionCallback=function(e){var t,i;this._toggleMutationObserver(false);e.forEach(function(e){if(e.type==="childList"){t=e.addedNodes;for(var s=0;s<t.length;s++){i=t[s];this._processNode(i)}}else if(e.type==="characterData"){this._processNode(e.target)}},this);this._toggleMutationObserver(true)};t.prototype.destroy=function(){this._removeMutationObserver()};return t});
//# sourceMappingURL=Highlighter.js.map