/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/Lib","sap/ui/dt/OverlayRegistry"],function(e,t,i){"use strict";var r=e.extend("sap.ui.dt.Plugin",{metadata:{abstract:true,library:"sap.ui.dt",properties:{designTime:{type:"object",multiple:false},busy:{type:"boolean",defaultValue:false}},events:{processingStatusChange:{parameters:{processing:{type:"boolean"}}}}}});r.prototype._bProcessingCounter=0;r.prototype._oBusyPromise={};r.prototype.init=function(){};r.prototype.exit=function(){this.setDesignTime(null)};r.prototype.setDesignTime=function(e){var t=this.getDesignTime();if(t){this._deregisterOverlays(t)}this.setProperty("designTime",e);if(e){this._registerOverlays(e)}return this};r.prototype._registerOverlays=function(e){if(this.registerElementOverlay||this.registerAggregationOverlay){var t=e.getElementOverlays();this.setProcessingStatus(true);t.forEach(this.callElementOverlayRegistrationMethods.bind(this));this.setProcessingStatus(false)}};r.prototype._deregisterOverlays=function(e){if(this.deregisterElementOverlay||this.deregisterAggregationOverlay){var t=e.getElementOverlays();t.forEach(this._callElementOverlayDeregestrationMethods.bind(this))}};r.prototype.callAggregationOverlayRegistrationMethods=function(e){if(this.registerAggregationOverlay){var t=e.getChildren();t.forEach(this.registerAggregationOverlay.bind(this))}};r.prototype.callElementOverlayRegistrationMethods=function(e){if(this.registerElementOverlay){this.registerElementOverlay(e)}this.callAggregationOverlayRegistrationMethods(e)};r.prototype._callElementOverlayDeregestrationMethods=function(e){if(this.deregisterElementOverlay){this.deregisterElementOverlay(e)}if(this.deregisterAggregationOverlay){var t=e.getChildren();t.forEach(this.deregisterAggregationOverlay.bind(this))}};r.prototype._onElementOverlayCreated=function(e){var t=e.getParameter("elementOverlay");this.callElementOverlayRegistrationMethods(t)};r.prototype.getMenuItems=function(){return[]};r.prototype.getActionName=function(){};r.prototype.isBusy=r.prototype.getBusy;r.prototype.setBusy=function(e){if(e&&!this.getBusy()){this._oBusyPromise.promise=new Promise(function(e){this._oBusyPromise.resolveFunction=e}.bind(this))}else if(!e&&this.getBusy()&&this._oBusyPromise.resolveFunction){this._oBusyPromise.resolveFunction()}this.setProperty("busy",e);return this};r.prototype.waitForBusyAction=function(){return this._oBusyPromise.promise||Promise.resolve()};r.prototype.setProcessingStatus=function(e){this._bProcessingCounter=e?this._bProcessingCounter+1:this._bProcessingCounter-1;if(e===true&&this._bProcessingCounter===1||e===false&&this._bProcessingCounter===0){this.fireProcessingStatusChange({processing:e})}};r.prototype.getAction=function(e){return e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getAction(this.getActionName(),e.getElement()):null};r.prototype.getSelectedOverlays=function(){return this.getDesignTime().getSelectionManager().get()};r.prototype.getActionText=function(e,i,r){var n=i.name;var s=e.getElement();if(n){if(typeof n==="function"){return n(s)}return e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getLibraryText(s,n):""}return t.getResourceBundleFor("sap.ui.rta").getText(r)};r.prototype.isAvailable=function(){return false};r.prototype.handler=function(){};r.prototype.isEnabled=function(e){if(!Array.isArray(e)||e.length>1){return false}var t=e[0];var i=this.getAction(t);if(!i){return false}var r=t.getElement();if(i.isEnabled===undefined){return true}if(typeof i.isEnabled==="function"){return i.isEnabled(r)}return i.isEnabled};r.prototype._getMenuItems=function(e,t){var i=this.enhanceItemWithResponsibleElement({id:t.pluginId,handler:this.handler.bind(this),enabled:this.isEnabled.bind(this),rank:t.rank,icon:t.icon,group:t.group},e);var r=i.responsible||e;var n=r[0];var s=this.getAction(n);if(!s||!this.isAvailable(r)){return[]}i.text=this.getActionText(n,s,t.pluginId);return[i]};r.prototype.isResponsibleElementActionAvailable=function(e,t){var i=e.getDesignTimeMetadata();if(i){return i.isResponsibleActionAvailable(t||this.getActionName())}return false};r.prototype.getResponsibleElementOverlay=function(e){var t=e.getElement();var r=e.getDesignTimeMetadata();if(r){var n=r.getResponsibleElement(t);if(n){try{return i.getOverlay(n)}catch(t){return e}}}return e};r.prototype.enhanceItemWithResponsibleElement=function(e,t,i){var r=[];var n=i||[this.getActionName()];var s=n.some(function(e){if(this.isResponsibleElementActionAvailable(t[0],e)){r=t.map(this.getResponsibleElementOverlay.bind(this));return true}}.bind(this));return Object.assign(e,s&&{responsible:r})};return r});
//# sourceMappingURL=Plugin.js.map