//@ui5-bundle sap/ui/fl/library-preload-write.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FakeLrepConnector", ["sap/ui/fl/initial/_internal/FlexConfiguration","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils","sap/ui/fl/write/_internal/connectors/ObjectPathConnector"],function(e,t,r,i){"use strict";var n={};var a="sap.ui.fl";n.prototype={};n.enableFakeConnector=function(e){this.setFlexibilityServicesAndClearCache("LocalStorageConnector",e)};n.setFlexibilityServicesAndClearCache=function(r,n){this._oFlexibilityServices=e.getFlexibilityServices();var a=[];if(n){i.setJsonPath(n);a.push({connector:"ObjectPathConnector"})}a.push({connector:r});e.setFlexibilityServices(a);t.clearState()};n.disableFakeConnector=function(){n.prototype={};t.clearState();if(this._oFlexibilityServices){e.setFlexibilityServices(this._oFlexibilityServices);delete this._oFlexibilityServices}};n.forTesting={getNumberOfChanges(e,t){return e.loadFlexData({reference:t}).then(function(e){return e.reduce(function(e,t){return e+t.changes.length},0)})},spyMethod(e,t,r,i){var n=e.spy(r,i);return function(e,r){r||=0;var a=n.getCall(r).args[0].flexObjects.length;t.equal(a,e,`${i} was called ${e} times`)}},clear(e,r){t.clearState();return e.reset(r)},setStorage(e,t){e.storage=t},synchronous:{clearAll(e){var t=function(t){var r=t.includes(a);if(!r){return}e.removeItem(t)};Object.keys(e).map(t)},store(e,t,i){var n=r.createFlexKey(t);var a=JSON.stringify(i);e.setItem(n,a)},getNumberOfChanges(e,t){return Object.keys(e).filter(function(i){return i.includes(a)&&r.isSameReference(JSON.parse(e.getItem(i)),t)}).length}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FakeLrepConnectorLocalStorage", ["sap/ui/fl/FakeLrepConnector","sap/ui/fl/write/_internal/connectors/LocalStorageConnector"],function(e,n){"use strict";return{enableFakeConnector(n){var o=n?n.sInitialComponentJsonPath:undefined;e.setFlexibilityServicesAndClearCache("LocalStorageConnector",o)},disableFakeConnector(){e.disableFakeConnector()},forTesting:{spyWrite(o,r){return e.forTesting.spyMethod(o,r,n,"write")},getNumberOfChanges(o){return e.forTesting.getNumberOfChanges(n,o)},synchronous:{clearAll(){e.forTesting.synchronous.clearAll(window.localStorage)},store(n,o){e.forTesting.synchronous.store(window.localStorage,n,o)}}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FakeLrepConnectorSessionStorage", ["sap/ui/fl/FakeLrepConnector","sap/ui/fl/write/_internal/connectors/SessionStorageConnector"],function(e,n){"use strict";return{enableFakeConnector(n){var r=n?n.sInitialComponentJsonPath:undefined;e.setFlexibilityServicesAndClearCache("SessionStorageConnector",r)},disableFakeConnector(){e.disableFakeConnector()},forTesting:{spyWrite(r,t){return e.forTesting.spyMethod(r,t,n,"write")},getNumberOfChanges(r){return e.forTesting.getNumberOfChanges(n,r)},clear(r){return e.forTesting.clear(n,r)},setStorage(r){e.forTesting.setStorage(n,r)},synchronous:{clearAll(){e.forTesting.synchronous.clearAll(window.sessionStorage)},getNumberOfChanges(r){return e.forTesting.synchronous.getNumberOfChanges(n.storage,r)}}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/FakeLrepLocalStorage", ["sap/ui/fl/FakeLrepConnectorLocalStorage"],function(e){"use strict";return{deleteChanges(){return e.forTesting.synchronous.clearAll()}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory", ["sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/base/util/merge"],function(e,a,r){"use strict";function t(e,a,t){var n=r({},{changeType:e},{content:a});if(t){n.texts=t}return n}var n={};n.getDescriptorChangeTypes=function(){return a.getChangeTypes()};n.getCondensableDescriptorChangeTypes=function(){return a.getCondensableChangeTypes()};n.createNew=function(a,r,n){var p=t(a,r,n);return e.createNew(p)};n.createDescriptorInlineChange=function(a,r,n){var p=t(a,r,n);return e.createDescriptorInlineChange(p)};n.create_ovp_addNewCard=function(a,r){var n=t("appdescr_ovp_addNewCard",a,r);return e.create_ovp_addNewCard(n)};n.create_ovp_removeCard=function(a){var r=t("appdescr_ovp_removeCard",a);return e.create_ovp_removeCard(r)};n.create_ovp_changeCard=function(a,r){var n=t("appdescr_ovp_changeCard",a,r);return e.create_ovp_changeCard(n)};n.create_app_addNewInbound=function(a,r){var n=t("appdescr_app_addNewInbound",a,r);return e.create_app_addNewInbound(n)};n.create_app_removeInbound=function(a){var r=t("appdescr_app_removeInbound",a);return e.create_app_removeInbound(r)};n.create_app_removeAllInboundsExceptOne=function(a){var r=t("appdescr_app_removeAllInboundsExceptOne",a);return e.create_app_removeAllInboundsExceptOne(r)};n.create_app_changeInbound=function(a,r){var n=t("appdescr_app_changeInbound",a,r);return e.create_app_changeInbound(n)};n.create_app_addNewOutbound=function(a){var r=t("appdescr_app_addNewOutbound",a);return e.create_app_addNewOutbound(r)};n.create_app_removeOutbound=function(a){var r=t("appdescr_app_removeOutbound",a);return e.create_app_removeOutbound(r)};n.create_app_changeOutbound=function(a){var r=t("appdescr_app_changeOutbound",a);return e.create_app_changeOutbound(r)};n.create_app_addNewDataSource=function(a){var r=t("appdescr_app_addNewDataSource",a);return e.create_app_addNewDataSource(r)};n.create_app_removeDataSource=function(a){var r=t("appdescr_app_removeDataSource",a);return e.create_app_removeDataSource(r)};n.create_app_changeDataSource=function(a){var r=t("appdescr_app_changeDataSource",a);return e.create_app_changeDataSource(r)};var p={BEGINNING:"BEGINNING",END:"END"};n.create_app_addAnnotationsToOData=function(a){var r=t("appdescr_app_addAnnotationsToOData",a);return e.create_app_addAnnotationsToOData(r)};n.create_app_setTitle=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setTitle",a,r);return e.create_app_setTitle(n)};n.create_app_setSubTitle=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setSubTitle",a,r);return e.create_app_setSubTitle(n)};n.create_app_setShortTitle=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setShortTitle",a,r);return e.create_app_setShortTitle(n)};n.create_app_setDescription=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setDescription",a,r);return e.create_app_setDescription(n)};n.create_app_setInfo=function(a,r){if(!r){r={"":a};a={}}var n=t("appdescr_app_setInfo",a,r);return e.create_app_setInfo(n)};n.create_app_setAch=function(a){var r=t("appdescr_app_setAch",a);return e.create_app_setAch(r)};n.create_app_setDestination=function(a){var r=t("appdescr_app_setDestination",a);return e.create_app_setDestination(r)};n.create_app_setKeywords=function(a,r){var n=t("appdescr_app_setKeywords",a,r);return e.create_app_setKeywords(n)};n.create_app_addTechnicalAttributes=function(a){var r=t("appdescr_app_addTechnicalAttributes",a);return e.create_app_addTechnicalAttributes(r)};n.create_app_removeTechnicalAttributes=function(a){var r=t("appdescr_app_removeTechnicalAttributes",a);return e.create_app_removeTechnicalAttributes(r)};n.create_app_addCdsViews=function(a){var r=t("appdescr_app_addCdsViews",a);return e.create_app_addCdsViews(r)};n.create_app_removeCdsViews=function(a){var r=t("appdescr_app_removeCdsViews",a);return e.create_app_removeCdsViews(r)};n.create_flp_setConfig=function(a){var r=t("appdescr_flp_setConfig",a);return e.create_flp_setConfig(r)};n.create_ui5_addNewModel=function(a){var r=t("appdescr_ui5_addNewModel",a);return e.create_ui5_addNewModel(r)};n.create_ui5_removeModel=function(a){var r=t("appdescr_ui5_removeModel",a);return e.create_ui5_removeModel(r)};n.create_ui5_addNewModelEnhanceWith=function(a,r){var n=t("appdescr_ui5_addNewModelEnhanceWith",a,r);return e.create_ui5_addNewModelEnhanceWith(n)};n.create_ui5_replaceComponentUsage=function(a){var r=t("appdescr_ui5_replaceComponentUsage",a);return e.create_ui5_replaceComponentUsage(r)};n.create_ui5_addLibraries=function(a){var r=t("appdescr_ui5_addLibraries",a);return e.create_ui5_addLibraries(r)};n.create_ui5_setMinUI5Version=function(a){var r=t("appdescr_ui5_setMinUI5Version",a);return e.create_ui5_setMinUI5Version(r)};n.create_smb_addNamespace=function(a){var r=t("appdescr_smb_addNamespace",a);return e.create_smb_addNamespace(r)};n.create_smb_changeNamespace=function(a){var r=t("appdescr_smb_changeNamespace",a);return e.create_smb_changeNamespace(r)};n.create_ui_generic_app_setMainPage=function(a,r){var n=t("appdescr_ui_generic_app_setMainPage",a,r);return e.create_ui_generic_app_setMainPage(n)};n.create_ui_setIcon=function(a){var r=t("appdescr_ui_setIcon",a);return e.create_ui_setIcon(r)};n.create_ui_setDeviceTypes=function(a){var r=t("appdescr_ui_setDeviceTypes",a);return e.create_ui_setDeviceTypes(r)};n.create_url_setUri=function(a){var r=t("appdescr_url_setUri",a);return e.create_url_setUri(r)};n.create_fiori_setRegistrationIds=function(a){var r=t("appdescr_fiori_setRegistrationIds",a);return e.create_fiori_setRegistrationIds(r)};n.create_ui5_setFlexExtensionPointEnabled=function(a){var r=t("appdescr_ui5_setFlexExtensionPointEnabled",a);return e.create_ui5_setFlexExtensionPointEnabled(r)};n.create_fiori_setAbstract=function(a){var r=t("appdescr_fiori_setAbstract",a);return e.create_fiori_setAbstract(r)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory", ["sap/ui/fl/write/_internal/appVariant/AppVariantFactory"],function(e){"use strict";var r={};r.createNew=function(e){return r.createAppVariant(e)};r.createAppVariant=function(r){return e.prepareCreate(r)};r.createForExisting=function(r){return e.prepareUpdate({id:r})};r.createDeletion=function(r){return e.prepareDelete({id:r})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/BackendConnector", ["sap/ui/fl/initial/_internal/connectors/Utils","sap/base/util/restricted/_pick"],function(e,n){"use strict";return{xsrfToken:undefined,settings:undefined,sendRequest(t){var s=n(t,["version","allContexts"]);if(this.isLanguageInfoRequired){e.addLanguageInfo(s)}var i=e.getUrl(this.ROUTES.DATA,t,s);return e.sendRequest(i,"GET",{initialConnector:this,xsrfToken:this.xsrfToken}).then(function(e){var n=e.response;if(e.etag){n.cacheKey=e.etag}if(n.settings){this.settings=n.settings}return n}.bind(this))},loadFlexData(e){return this.sendRequest(e).then(function(e){e.changes=e.changes.concat(e.compVariants||[]);return e})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/KeyUserConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/Layer"],function(e,n,a){"use strict";var t="/flex/keyuser";var c="/v2";var r=e({},n,{layers:[a.CUSTOMER,a.PUBLIC],API_VERSION:c,ROUTES:{DATA:`${t+c}/data/`},isLanguageInfoRequired:true,loadFlexData(e){return n.sendRequest.call(r,e).then(function(e){e.contents.map(function(e,n,a){a[n].changes=(e.changes||[]).concat(e.compVariants)});e.contents.cacheKey=e.cacheKey;return e.contents})}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/LrepConnector", ["sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/Utils","sap/ui/dom/includeScript","sap/base/util/restricted/_pick"],function(e,t,i,s){"use strict";var n={DATA:"/flex/data/",MODULES:"/flex/modules/"};return{layers:["ALL"],xsrfToken:undefined,settings:undefined,_loadModules(e){return new Promise(function(t,s){i(e,undefined,t,s)})},_addClientInfo(e){var i=t.getUrlParameter("sap-client");if(!e&&i){e={}}if(i){e["sap-client"]=i}},loadFlexData(t){if(t.cacheKey==="<NO CHANGES>"){return Promise.resolve()}var i=s(t,["version","allContexts","adaptationId"]);this._addClientInfo(i);e.addSAPLogonLanguageInfo(i);var a;if(t.appDescriptor&&t.appDescriptor["sap.app"]){a=t.appDescriptor["sap.app"].id}if(t.preview){t.reference=t.preview.reference;i.upToLayerType=t.preview.maxLayer}var r=e.getUrl(n.DATA,t,i);return e.sendRequest(r,"GET",{initialConnector:this,xsrfToken:this.xsrfToken,siteId:t.siteId,sAppDescriptorId:a}).then(function(s){var a=s.response;if(s.etag){a.cacheKey=s.etag}else if(t.cacheKey){a.cacheKey=t.cacheKey}a.changes=a.changes.concat(a.compVariants||[]);if(a.settings){this.settings=a.settings;this.settings.isVariantAdaptationEnabled=!!this.settings.isPublicLayerAvailable;this.settings.isContextSharingEnabled=true;this.settings.isLocalResetEnabled=true}if(!a.loadModules){return a}var r=e.getUrl(n.MODULES,t,i);return this._loadModules(r).then(function(){return a})}.bind(this))}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/NeoLrepConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/LrepConnector"],function(e,n){"use strict";return e({},n,{})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/PersonalizationConnector", ["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/Layer"],function(a,e,n){"use strict";var i="/flex/personalization";var r="/v1";var t=a({},e,{layers:[n.USER],ROUTES:{DATA:`${i+r}/data/`}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/initial/_internal/connectors/Utils", ["sap/ui/core/Lib","sap/base/i18n/Localization","sap/base/security/encodeURLParameters"],function(e,s,t){"use strict";var r=2e4;var n=function(e,s){var t=new Error(e.statusText);t.status=e.status;t.userMessage=s;return t};var a=function(s){return e.getResourceBundleFor("sap.ui.fl").getText(s)};return{addLanguageInfo(e){if(!e){throw new Error("No parameters map were passed")}e["sap-language"]=s.getLanguage()},addSAPLogonLanguageInfo(e){if(!e){throw new Error("No parameters map were passed")}e["sap-language"]=s.getSAPLogonLanguage()},getUrl(e,s,r){if(!e||!s.url){throw new Error("Not all necessary parameters were passed")}var n=s.url+e;if(s.cacheKey){n+=`~${s.cacheKey}~/`}if(s.reference){n+=s.reference}else if(s.fileName){n+=s.fileName}if(r){Object.keys(r).forEach(function(e){if(r[e]===undefined){delete r[e]}});var a=t(r);if(a.length>0){n+=`?${a}`}}return n},sendRequest(e,s,t){s||="GET";s=s.toUpperCase();return new Promise(function(o,i){var p=new XMLHttpRequest;p.open(s,e);p.timeout=r;if((s==="GET"||s==="HEAD")&&(!t||!t.initialConnector||!t.initialConnector.xsrfToken)){p.setRequestHeader("X-CSRF-Token","fetch")}if((s==="POST"||s==="PUT"||s==="DELETE")&&t&&t.initialConnector&&t.initialConnector.xsrfToken){p.setRequestHeader("X-CSRF-Token",t.initialConnector.xsrfToken)}if(t&&t.contentType){p.setRequestHeader("Content-Type",t.contentType)}if(t&&t.siteId){p.setRequestHeader("X-LRep-Site-Id",t.siteId)}if(t&&t.sAppDescriptorId){p.setRequestHeader("X-LRep-AppDescriptor-Id",t.sAppDescriptorId)}if(t&&t.dataType){p.responseType=t.dataType}p.onload=function(){if(p.status>=200&&p.status<400){try{var s={};if(p.status!==204&&p.status!==205){if(!p.response&&p.responseText){p.response=p.responseText}s.response=p.response;if(s.response&&typeof s.response==="string"&&p.getResponseHeader("content-type")&&p.getResponseHeader("content-type").indexOf("json")>0){s.response=JSON.parse(s.response)}}s.status=p.status;if(p.getResponseHeader("X-CSRF-Token")){if(!e.match(/\/~.*~/g)){s.xsrfToken=p.getResponseHeader("X-CSRF-Token");if(t&&t.initialConnector){t.initialConnector.xsrfToken=s.xsrfToken}}}if(p.getResponseHeader("Etag")){s.etag=p.getResponseHeader("Etag")}o(s)}catch(e){e.userMessage=a("MSG_LOADING_SERVER_RESPONSE_ERROR");i(e)}}else{var r="";try{var f=typeof p.response==="string"?JSON.parse(p.response):p.response;if(Array.isArray(f.messages)&&f.messages.length){r=f.messages.reduce(function(e,s){return e.concat(s.severity==="Error"?`${s.text}\n`:"")},r)}}catch(e){}i(n(p,r))}};p.ontimeout=function(){i(n(p,a("MSG_CONNECTION_TIMEOUT_ERROR")))};p.onerror=function(){i(n(p,a("MSG_NETWORK_ERROR")))};p.addEventListener("error",function(){i(n(p,a("MSG_NETWORK_ERROR")))});if(t&&t.payload){p.send(t.payload)}else{p.send()}})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/util/resolveBinding", ["sap/ui/base/ManagedObject","sap/ui/fl/Utils"],function(e,t){"use strict";var n=e.extend("sap.ui.fl.util.HelperControl",{metadata:{library:"sap.ui.fl",properties:{resolved:{type:"any"}}}});return function(r,i){if(!t.isBinding(r)){return undefined}var o=t.getViewForControl(i);var a=o&&o.getController();var s=typeof r==="string"?e.bindingParser(r,a):Object.assign({},r);if(!s){return undefined}var d=new n;var l=s.parts||[s];l.forEach(function(e){var t=e.model;if(t){d.setModel(i.getModel(t),t);d.setBindingContext(i.getBindingContext(t),t)}else{d.setModel(i.getModel());d.setBindingContext(i.getBindingContext())}});d.bindProperty("resolved",s);var g=d.getResolved();d.destroy();return g}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/variants/context/Component", ["sap/ui/core/UIComponent"],function(e){"use strict";return e.extend("sap.ui.fl.variants.context.Component",{metadata:{manifest:"json"},onInit(){var e=this.getModel("selectedContexts");e.setProperty("/selected",[])},getSelectedContexts(){var e=this.getModel("selectedContexts").getProperty("/selected");var t=e.map(function(e){return e.id});return{role:t}},setEmptyListTextWithAdvice(){var e=this.getModel("selectedContexts");e.setProperty("/noDataText",this.getRootControl().getController().oI18n.getText("NO_SELECTED_ROLES_WITH_ADVICE"));e.refresh(true)},getSelectedContextsModel(){return this.getModel("selectedContexts")},setSelectedContexts(e){var t=e.role.map(function(e){return{id:e,description:""}});var s=this.getModel("selectedContexts");s.setProperty("/selected",t);s.refresh(true)},resetSelectedContexts(){var e=this.getModel("selectedContexts");e.setProperty("/selected",[]);e.refresh(true)},hasErrorsAndShowErrorMessage(){return false},showMessageStrip(e){var t=this.getModel("selectedContexts");t.setProperty("/showMessageStrip",e);t.refresh(true)}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/variants/context/controller/ContextVisibility.controller", ["sap/ui/core/mvc/Controller","sap/ui/core/Fragment","sap/ui/fl/write/_internal/Storage","sap/ui/fl/Layer","sap/base/util/restricted/_isEqual"],function(e,t,r,n,o){"use strict";function i(e){var t={layer:n.CUSTOMER,type:"role"};return Object.assign({},t,e)}function s(e){var t={layer:n.CUSTOMER,flexObjects:e};return r.loadContextDescriptions(t).then(function(t){if(t.role&&t.role.length===e.role.length){this.oSelectedContextsModel.setProperty("/selected",t.role)}}.bind(this))}function l(){return t.load({id:this.getView().getId(),name:"sap.ui.fl.variants.context.view.fragment.AddContextDialog",controller:this}).then(function(e){this.getView().addDependent(e);e._oList.attachUpdateStarted(this._updateStartedHandler.bind(this));e._oList.attachSelectionChange(this._onSelectionChange.bind(this));return e}.bind(this))}function a(e,t){return r.getContexts(i(e)).then(function(e){if(t){e.values=t.concat(e.values)}this.oContextsModel.setData(e);this.oContextsModel.refresh(true)}.bind(this))}function d(e){return{id:e.getTitle(),description:e.getDescription()}}return e.extend("sap.ui.fl.variants.context.controller.ContextVisibility",{onInit(){this.oSelectedContextsModel=this.getView().getModel("selectedContexts");this.oContextsModel=this.getView().getModel("contexts");this.oI18n=this.getView().getModel("i18n").getResourceBundle()},onBeforeRendering(){this.oSelectedContextsModel.refresh(true);if(!this.oSelectedContextsModel.getProperty("/noDataText")){this.oSelectedContextsModel.setProperty("/noDataText",this.oI18n.getText("NO_SELECTED_ROLES"));this.oSelectedContextsModel.refresh(true)}var e=this.getOwnerComponent().getSelectedContexts();var t=e.role.length>0;if(t){return s.call(this,e)}return Promise.resolve()},_onSelectionChange(e){var t=d(e.getParameter("listItem"));if(e.getParameter("selected")===true){this.oCurrentSelection.push(t)}else{this.oCurrentSelection=this.oCurrentSelection.filter(function(e){return!o(e,t)})}},isSelected(e,t){return t.some(function(t){return t.id===e.id})},formatTooltip(e){this.oI18n||=this.getView().getModel("i18n").getResourceBundle();return e.length===0?this.oI18n.getText("NO_DESCRIPTION"):e},_appendDataFromBackend(){var e=this.oContextsModel.getProperty("/values");if(this.oContextsModel.getProperty("/lastHitReached")===false){var t={$skip:e.length};return a.call(this,t,e)}return Promise.resolve(e)},_updateStartedHandler(e){if(e.getParameter&&e.getParameter("reason")==="Growing"){return this._appendDataFromBackend()}return Promise.resolve()},_addContexts(e){e.clearSelection();this.oCurrentSelection=this.oSelectedContextsModel.getProperty("/selected")||[];return a.call(this,{}).then(function(){return e.open()})},onAddContextsHandler(){this._oDialog||=l.call(this);return this._oDialog.then(function(e){return this._addContexts(e)}.bind(this))},onSearch(e){e.getSource().clearSelection();var t={$filter:e.getParameter("value")};return a.call(this,t)},onSelectContexts(){this.oSelectedContextsModel.setProperty("/selected",this.oCurrentSelection);this.oSelectedContextsModel.refresh(true);this.oCurrentSelection=[]},onDeleteContext(e){var t=this.oSelectedContextsModel.getProperty("/selected");var r=e.getParameter("listItem");var n=t.filter(function(e){return e.id!==r.getTitle()});this.oSelectedContextsModel.setProperty("/selected",n);var o=e.getSource();o.attachEventOnce("updateFinished",o.focus,o)},removeAll(){this.oSelectedContextsModel.setProperty("/selected",[])},isRemoveAllEnabled(e){return e&&e.length!==0},isMessageStripVisible(e,t){return t&&e.length===0}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/SaveAs", ["sap/base/util/restricted/_omit","sap/base/util/merge","sap/base/Log","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(e,t,r,n,a,i,o,s,c,u){"use strict";function p(e){return a.getInstance().then(function(t){if(!e.package&&(e.layer===c.VENDOR||e.layer===c.CUSTOMER_BASE&&!t.isAtoEnabled())){return Promise.reject("Package must be provided or is valid")}if(e.isForSmartBusiness&&(e.package!=="$TMP"&&e.package!=="")&&!e.transport&&!t.isAtoEnabled()){return Promise.reject("Transport must be provided")}if(e.isForSmartBusiness&&e.transport||e.package==="$TMP"){return Promise.resolve({packageName:e.package,transport:e.transport})}return Promise.resolve({packageName:"",transport:""})})}function l(e,t){var r=t.transport?e.setTransportRequest(t.transport):Promise.resolve();return r.then(function(){if(t.packageName){return e.setPackage(t.packageName)}return Promise.resolve()})}function f(e){var t=[];e.forEach(function(e){var r={changeType:e.getChangeType(),content:e.getContent()};if(e.getTexts()){r.texts=e.getTexts()}t.push(o.createNew(r))});return Promise.all(t)}function h(e,t){var r={reference:t.getId()};var n=u.createNamespace(r,"changes");var a=e.getFlexObjectMetadata();a.namespace=n;a.reference=t.getId();e.setFlexObjectMetadata(a)}function g(e,t){var r=[];e.forEach(function(e){e.replaceHostingIdForTextKey(t.getId(),t.getReference(),e.getContent(),e.getTexts());r.push(t.addDescriptorInlineChange(e))});return Promise.all(r)}function d(e){var t=s.createForSelector(e)._oChangePersistence;if(!t){return[]}return t.getDirtyChanges().filter(function(e){return n.getChangeTypes().includes(e.getChangeType())})}function A(e){var t=s.createForSelector(e)._oChangePersistence;if(!t){return[]}var r=t.getDirtyChanges();r=r.slice();return r}function m(e){var t=[];d(e).forEach(function(e){if(n.getChangeTypes().includes(e.getChangeType())){t.push(e)}});s.createForSelector(e)._oChangePersistence.deleteChanges(t)}function v(e,t){if(!e){throw new Error(`App variant with ID: ${t.id}does not exist`)}t.package=e.getPackage();t.layer=e.getDefinition().layer;return p(t).then(function(t){return l(e,t)}).then(function(){return e})}var P={saveAs(e){var a;var o;return i.prepareCreate(e).then(function(r){a=t({},r);return p(e)}).then(function(e){return l(a,e)}).then(function(){var t=[];A(e.selector).forEach(function(e){if(n.getChangeTypes().includes(e.getChangeType())){t.push(e)}else{h(e,a)}});return f(t)}).then(function(e){return g(e,a)}).then(function(){return a.submit().catch(function(e){e.messageKey="MSG_SAVE_APP_VARIANT_FAILED";throw e})}).then(function(r){o=t({},r);m(e.selector);var n=s.createForSelector(e.selector);var a=A(e.selector);if(a.length){return n.saveAll(u.getAppComponentForSelector(e.selector),true).catch(function(t){return this.deleteAppVariant({id:e.id}).then(function(){t.messageKey="MSG_COPY_UNSAVED_CHANGES_FAILED";throw t})}.bind(this))}return Promise.resolve()}.bind(this)).then(function(){return o}).catch(function(t){if(d(e.selector).length){m(e.selector)}r.error("the app variant could not be created.",t.message||t);throw t})},updateAppVariant(a){var o;var s;return i.prepareUpdate(e(a,"selector")).catch(function(e){e.messageKey="MSG_LOAD_APP_VARIANT_FAILED";throw e}).then(function(e){if(!e){throw new Error(`App variant with ID: ${a.id}does not exist`)}o=t({},e);a.package=o.getPackage();a.layer=o.getDefinition().layer;return p(a)}).then(function(e){return l(o,e)}).then(function(){var e=[];d(a.selector).forEach(function(t){if(n.getChangeTypes().includes(t.getChangeType())){e.push(t)}});return f(e)}).then(function(e){return g(e,o)}).then(function(){return o.submit().catch(function(e){if(a.isForSmartBusiness){m(a.selector);throw e}e.messageKey="MSG_UPDATE_APP_VARIANT_FAILED";throw e})}).then(function(e){s=t({},e);m(a.selector);return s}).catch(function(e){if(d(a.selector).length){m(a.selector)}r.error("the app variant could not be updated.",e.message||e);throw e})},deleteAppVariant(t){return i.prepareDelete(e(t,"selector")).catch(function(e){e.messageKey="MSG_LOAD_APP_VARIANT_FAILED";throw e}).then(function(e){return t.isForSmartBusiness?Promise.resolve(e):v(e,t)}).then(function(e){return e.submit().catch(function(e){if(e==="cancel"){return Promise.reject("cancel")}e.messageKey="MSG_DELETE_APP_VARIANT_FAILED";throw e})}).catch(function(e){if(e==="cancel"){return Promise.reject("cancel")}r.error("the app variant could not be deleted.",e.message||e);throw e})}};return P});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/appVariant/AppVariant", ["sap/ui/base/ManagedObject","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/base/util/merge","sap/base/Log","sap/base/util/isPlainObject"],function(e,i,t,n,o,r){"use strict";var s=e.extend("sap.ui.fl.write._internal.appVariant.AppVariant",{constructor:function(i){e.apply(this);if(!r(i)){o.error("Constructor : sap.ui.fl.write._internal.appVariant.AppVariant: mPropertyBag is not defined")}this._oDefinition=i;return this},metadata:{library:"sap.ui.fl",properties:{mode:{type:"string"}}}});s.modes={NEW:"NEW",EXISTING:"EXISTING",DELETION:"DELETION"};s.prototype._isValidMode=function(e){var i=false;Object.keys(s.modes).some(function(t){if(s.modes[t]===e){i=true}});return i};s.prototype.setMode=function(e){if(this._isValidMode(e)){this.setProperty("mode",e)}else{throw new Error("Provide a correct operation mode")}};s.prototype.setTransportRequest=function(e){try{i.checkTransportRequest(e)}catch(e){return Promise.reject(e)}this._oDefinition.transport=e;return Promise.resolve()};s.prototype.setReference=function(e){if(e===undefined||typeof e!=="string"){throw new Error("No parameter sReference of type string provided")}this._oDefinition.reference=e};s.prototype.setPackage=function(e){try{i.checkPackage(e)}catch(e){return Promise.reject(e)}this._oDefinition.packageName=e;return Promise.resolve()};s.prototype.getDefinition=function(){return this._oDefinition};s.prototype.getId=function(){return this._oDefinition.id};s.prototype.getNamespace=function(){return this._oDefinition.namespace||i.getNameAndNameSpace(this._oDefinition.id,this._oDefinition.reference).namespace};s.prototype.getFileName=function(){return this._oDefinition.fileName||i.getNameAndNameSpace(this._oDefinition.id,this._oDefinition.reference).fileName};s.prototype.getReference=function(){return this._oDefinition.reference};s.prototype.getPackage=function(){return this._oDefinition.packageName};s.prototype.getVersion=function(){return this._oDefinition.version};s.prototype.getTransportRequest=function(){return this._oDefinition.transport};s.prototype.getJson=function(){return n({},this._getMap())};s.prototype._getMap=function(){var e={};switch(this.getMode()){case s.modes.NEW:e={fileName:this.getFileName(),fileType:"appdescr_variant",namespace:this.getNamespace(),layer:this._oDefinition.layer,packageName:this._oDefinition.packageName?this._oDefinition.packageName:"",reference:this._oDefinition.reference,id:this._oDefinition.id,content:this._oDefinition.content||[]};if(this._oDefinition.referenceVersion){e.referenceVersion=this._oDefinition.referenceVersion}if(this._oDefinition.version){e.version=this._oDefinition.version}break;case s.modes.EXISTING:e={fileName:this._oDefinition.fileName,fileType:this._oDefinition.fileType,namespace:this._oDefinition.namespace,layer:this._oDefinition.layer,packageName:this._oDefinition.packageName,reference:this._oDefinition.reference,id:this._oDefinition.id,content:this._oDefinition.content};if(this._oDefinition.referenceVersion){e.referenceVersion=this._oDefinition.referenceVersion}if(this._oDefinition.version){e.version=this._oDefinition.version}break;case s.modes.DELETION:e={id:this._oDefinition.id};break;default:}return e};s.prototype.addDescriptorInlineChange=function(e){return new Promise(function(i){var t=function(e,i){if(e.setHostingIdForTextKey){e.setHostingIdForTextKey(i)}};t(e,this.getId());this._oDefinition.content.push(e.getMap());i(null)}.bind(this))};s.prototype.submit=function(){var e=this._getMap();var i={flexObject:{},appVariant:this};if(this._oDefinition.transport){i.transport=this._oDefinition.transport}if(this._oDefinition.skipIam){i.skipIam=this._oDefinition.skipIam}if(this._oDefinition.isForSmartBusiness){i.isForSmartBusiness=this._oDefinition.isForSmartBusiness}if(this._oDefinition.parentVersion){i.parentVersion=this._oDefinition.parentVersion}if(e.layer){i.layer=e.layer}i.url="/sap/bc/lrep";var n;switch(this.getMode()){case s.modes.NEW:Object.assign(i.flexObject,e);n=t.appVariant.create(i);break;case s.modes.EXISTING:i.reference=e.id;Object.assign(i.flexObject,e);n=t.appVariant.update(i);break;case s.modes.DELETION:i.reference=e.id;n=t.appVariant.remove(i);break;default:return Promise.reject("Please provide a valid operation.")}return n.then(function(e){return e})};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/appVariant/AppVariantFactory", ["sap/ui/fl/write/_internal/appVariant/AppVariant","sap/ui/fl/Layer","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/base/util/merge","sap/base/util/isPlainObject"],function(e,r,n,t,a,i){"use strict";function s(e){e.url||="/sap/bc/lrep";return t.appVariant.load(e)}var o={};o.load=function(r){if(r.id===undefined||typeof r.id!=="string"){throw new Error(`Parameter ${r.id} must be provided of type string`)}return s({reference:r.id}).then(function(n){var t=n.response;if(!i(t)){t=JSON.parse(t)}r=a({},r,t);return new e(r)})};o.prepareCreate=function(t){try{n.checkParameterAndType(t,"reference","string");n.checkParameterAndType(t,"id","string");if(t.version){n.checkParameterAndType(t,"version","string")}if(!t.layer){t.layer=r.CUSTOMER}else{n.checkParameterAndType(t,"layer","string")}if(t.skipIam){n.checkParameterAndType(t,"skipIam","boolean")}if(t.transport){n.checkTransportRequest(t.transport)}if(t.package){n.checkPackage(t.package)}}catch(e){return Promise.reject(e)}t.content=[];var a=new e(t);a.setMode("NEW");return Promise.resolve(a)};o.prepareUpdate=function(e){return o.load(e).then(function(e){e.setMode("EXISTING");return e})};o.prepareDelete=function(r){return(r.isForSmartBusiness?Promise.resolve(new e(r)):o.load(r)).then(function(e){e.setMode("DELETION");return e})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/BackendConnector", ["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/base/util/restricted/_pick"],function(e,t,n,r,i,s){"use strict";function a(e){var t={};if(e.parentVersion!==undefined){t.parentVersion=e.parentVersion}if(this.isLanguageInfoRequired){r.addLanguageInfo(t)}var n=r.getUrl(this.ROUTES.CHANGES,e,t);delete e.fileName;delete t["sap-language"];var s=r.getUrl(this.ROUTES.TOKEN,e,t);var a=i.getRequestOptions(this.initialConnector,s,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");return i.sendRequest(n,e.method,a)}function o(e){e.fileName=e.flexObject.fileName;return a.call(this,e)}var l=e({},t,{xsrfToken:null,reset(e){var t=["reference","generator"];var n=s(e,t);if(e.selectorIds){n.selector=e.selectorIds}if(e.changeTypes){n.changeType=e.changeTypes}delete e.reference;var a=r.getUrl(this.ROUTES.CHANGES,e,n);var o=r.getUrl(this.ROUTES.TOKEN,e);var l=i.getRequestOptions(this.initialConnector,o);return i.sendRequest(a,"DELETE",l)},write(e){e.method="POST";return a.call(this,e).then(function(e){if(e.response&&!Array.isArray(e.response)){e.response=[e.response]}return e})},update(e){e.method="PUT";return o.call(this,e)},remove(e){var t={namespace:e.flexObject.namespace};if(e.parentVersion!==undefined){t.parentVersion=e.parentVersion}e.fileName=e.flexObject.fileName;var n=r.getUrl(this.ROUTES.CHANGES,e,t);delete e.fileName;var s=r.getUrl(this.ROUTES.TOKEN,e);var a=i.getRequestOptions(this.initialConnector,s,undefined,"application/json; charset=utf-8","json");return i.sendRequest(n,"DELETE",a)},loadFeatures(e){if(this.initialConnector.settings){return Promise.resolve({response:this.initialConnector.settings})}var t=r.getUrl(this.ROUTES.SETTINGS,e);return r.sendRequest(t,"GET",{initialConnector:n}).then(function(e){return e.response})}});l.initialConnector=n;return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/JsObjectConnector", ["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(e,t){"use strict";var r={_itemsStoredAsObjects:true,_items:{},setItem(e,t){r._items[e]=t},removeItem(e){delete r._items[e]},clear(){r._items={}},getItem(e){return r._items[e]},getItems(){return r._items}};var i=e({},t,{storage:r});i.loadFeatures=function(...r){return t.loadFeatures.apply(this,r).then(function(t){return e({isPublicLayerAvailable:true,isVariantAdaptationEnabled:true},t)})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/KeyUserConnector", ["sap/base/util/merge","sap/ui/core/Lib","sap/ui/fl/Layer","sap/ui/fl/write/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/KeyUserConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/base/util/restricted/_pick","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/core/BusyIndicator","sap/base/Log","sap/m/MessageBox"],function(e,n,t,r,s,a,i,o,u,l,S,E){"use strict";var c="/flex/keyuser";var R=e({},r,{layers:[t.CUSTOMER,t.PUBLIC],ROUTES:{CHANGES:`${c+s.API_VERSION}/changes/`,SETTINGS:`${c+s.API_VERSION}/settings`,TOKEN:`${c+s.API_VERSION}/settings`,VERSIONS:{GET:`${c+s.API_VERSION}/versions/`,ACTIVATE:`${c+s.API_VERSION}/versions/activate/`,DISCARD:`${c+s.API_VERSION}/versions/draft/`,PUBLISH:`${c+s.API_VERSION}/versions/publish/`},TRANSLATION:{UPLOAD:`${c+s.API_VERSION}/translation/texts`,DOWNLOAD:`${c+s.API_VERSION}/translation/texts/`,GET_SOURCELANGUAGE:`${c+s.API_VERSION}/translation/sourcelanguages/`},CONTEXTS:`${c+s.API_VERSION}/contexts/`},isLanguageInfoRequired:true,loadFeatures(e){return r.loadFeatures.call(R,e).then(function(e){e.isContextSharingEnabled=true;return e})},getContexts(e){var n=["type","$skip","$filter"];var t=o(e,n);var r=a.getUrl(R.ROUTES.CONTEXTS,e,t);return a.sendRequest(r,"GET",{initialConnector:s}).then(function(e){return e.response})},loadContextDescriptions(e){var n={};a.addLanguageInfo(n);T(e);var t=a.getUrl(R.ROUTES.CONTEXTS,e,n);e.payload=JSON.stringify(e.flexObjects);e.dataType="json";e.contentType="application/json; charset=utf-8";return i.sendRequest(t,"POST",e).then(function(e){return e.response})},isContextSharingEnabled(){return Promise.resolve(true)},getFlexInfo(e){return u.get(e.selector)||{}}});function T(e){e.initialConnector=s;e.tokenUrl=R.ROUTES.TOKEN}function O(e){var n={title:e.title};e.payload=JSON.stringify(n);e.dataType="json";e.contentType="application/json; charset=utf-8"}function g(e){e.version=e.versionNumber.toString();delete e.versionNumber;return e}R.versions={load(e){T(e);var n={};a.addLanguageInfo(n);n.limit=e.limit;var t=a.getUrl(R.ROUTES.VERSIONS.GET,e,n);return a.sendRequest(t,"GET",e).then(function(e){return e.response.versions.map(function(e){return g(e)})})},activate(e){T(e);O(e);var n={version:e.version};a.addLanguageInfo(n);var t=a.getUrl(R.ROUTES.VERSIONS.ACTIVATE,e,n);return i.sendRequest(t,"POST",e).then(function(e){var n=e.response;return g(n)})},discardDraft(e){T(e);var n=a.getUrl(R.ROUTES.VERSIONS.DISCARD,e);return i.sendRequest(n,"DELETE",e)},publish(e){var t=n.getResourceBundleFor("sap.ui.fl");var r=function(n){l.hide();var r=t.getText("MSG_CF_PUBLISH_ERROR",n?[n.message||n]:undefined);var s=t.getText("HEADER_TRANSPORT_ERROR");S.error(`publish version error${n}`);E.show(r,{icon:E.Icon.ERROR,title:s,styleClass:e.styleClass});return"Error"};T(e);var s={version:e.version};var o=a.getUrl(R.ROUTES.VERSIONS.PUBLISH,e,s);return i.sendRequest(o,"POST",e).then(function(){l.hide();return t.getText("MSG_CF_PUBLISH_SUCCESS")}).catch(r)}};R.translation={getTexts(e){T(e);var n=o(e,["sourceLanguage","targetLanguage"]);var t=a.getUrl(R.ROUTES.TRANSLATION.DOWNLOAD,e,n);return a.sendRequest(t,"GET",e).then(function(e){return e.response})},getSourceLanguages(e){T(e);var n={};var t=a.getUrl(R.ROUTES.TRANSLATION.GET_SOURCELANGUAGE,e,n);return a.sendRequest(t,"GET",e).then(function(e){return e&&e.response&&e.response.sourceLanguages?e.response.sourceLanguages:[]})},postTranslationTexts(e){T(e);var n=a.getUrl(R.ROUTES.TRANSLATION.UPLOAD,e,{});return a.sendRequest(n,"POST",e)}};R.initialConnector=s;return R});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/LocalStorageConnector", ["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(e,a){"use strict";var t=e({},a,{storage:window.localStorage});t.loadFeatures=function(...t){return a.loadFeatures.apply(this,t).then(function(a){return e({isPublicLayerAvailable:true,isPublicFlVariantEnabled:true,isVariantAdaptationEnabled:true,isCondensingEnabled:false},a)})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/LrepConnector", ["sap/base/util/merge","sap/ui/core/Lib","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/write/_internal/transport/TransportSelection","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/BusyIndicator","sap/base/Log","sap/m/MessageBox","sap/base/util/restricted/_pick"],function(e,t,r,n,a,s,i,o,l,u,p,c,f,d,T){"use strict";var g={FLEX_INFO:"/flex/info/",PUBLISH:"/actions/make_changes_transportable/",CHANGES:"/changes/",CONDENSE:"/actions/condense/",VARIANTS:"/variants/",SETTINGS:"/flex/settings",TOKEN:"/actions/getcsrftoken/",APPVARIANTS:"/appdescr_variants/",APPVARIANTS_OVERVIEW:"/app_variant_overview/",UI2PERSONALIZATION:"/ui2personalization/",CONTEXTS:"/flex/contexts/",VERSIONS:{GET:"/flex/versions/",ACTIVATE:"/flex/versions/activate/",DISCARD:"/flex/versions/draft/",PUBLISH:"/flex/versions/publish/"},CONTEXT_BASED_ADAPTATION:"/flex/apps/",MANI_FIRST_SUPPORTED:"/sap/bc/ui2/app_index/ui5_app_mani_first_supported"};var v="/adaptations/";var E=function(e){var t;if(e.isLegacyVariant){t=g.VARIANTS}else if(e.isAppVariant){t=g.APPVARIANTS}else if(e.isContextSharing){t=g.CONTEXTS}else if(e.isCondensingEnabled){t=g.CONDENSE}else if(e.isContextBasedAdaptationEnabled){t=g.CONTEXT_BASED_ADAPTATION+e.appId+v}else{t=g.CHANGES}var r=e.transport?{changelist:e.transport}:{};if(e.skipIam){r.skipIam=e.skipIam}if(e.parentVersion){r.parentVersion=e.parentVersion}a.addSAPLogonLanguageInfo(r);n._addClientInfo(r);if(e.flexObject&&!e.isAppVariant){e.fileName=e.flexObject.fileName}var i=a.getUrl(t,e,r);delete e.reference;delete e.fileName;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");return s.sendRequest(i,e.method,l)};var O=function(e){var t=e.getDefinition().layer===l.VENDOR?e.getPackage():"";return{package:t,namespace:e.getNamespace(),name:e.getDefinition().fileName,type:e.getDefinition().fileType}};var R=function(e){var t;if(e.transport){t=Promise.resolve({transport:e.transport})}else if(e.isForSmartBusiness){return Promise.resolve()}else{var r=O(e.appVariant);t=(new i).openTransportSelection(r)}return t.then(function(e){if(e==="cancel"){return Promise.reject("cancel")}if(e&&e.transport!==undefined){return e.transport}return Promise.reject(new Error("Transport information could not be determined"))})};function S(e){e.version=e.versionId;delete e.versionId;return e}return e({},r,{initialConnector:n,layers:n.layers,reset(e){c.show(0);var t=[];var r=Promise.resolve();if(e.layer!==l.USER){t=e.changes;r=o.getInstance().then(function(r){if(!r.isProductiveSystem()){return(new i).setTransports(t,p.getComponentById(e.reference)).then(function(){t.some(function(t){if(t.getRequest()){e.changelist=t.getRequest();return true}return false})})}})}return r.then(function(){c.show(0);var t=["reference","layer","changelist","generator"];var r=T(e,t);n._addClientInfo(r);if(e.selectorIds){r.selector=e.selectorIds}if(e.changeTypes){r.changeType=e.changeTypes}delete e.reference;var i=a.getUrl(g.CHANGES,e,r);var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o);return s.sendRequest(i,"DELETE",l).then(function(e){if(e&&e.response){e.response.forEach(function(e){e.fileName=e.name;delete e.name})}c.hide();return e}).catch(function(e){c.hide();return Promise.reject(e)})})},publish(e){var r=t.getResourceBundleFor("sap.ui.fl");var n=function(t){c.hide();var n=r.getText("MSG_TRANSPORT_ERROR",t?[t.message||t]:undefined);var a=r.getText("HEADER_TRANSPORT_ERROR");f.error(`transport error: ${t}`);d.show(n,{icon:d.Icon.ERROR,title:a,styleClass:e.transportDialogSettings.styleClass});return"Error"};var a=new i;return a.openTransportSelection(null,e.transportDialogSettings.rootControl,e.transportDialogSettings.styleClass).then(function(t){if(a.checkTransportInfo(t)){c.show(0);var n={reference:e.reference,layer:e.layer};return a._prepareChangesForTransport(t,e.localChanges,e.appVariantDescriptors,n).then(function(){c.hide();if(t.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION")}return r.getText("MSG_TRANSPORT_SUCCESS")})}return"Cancel"}).catch(n)},getFlexInfo(e){var t=["layer"];var r=T(e,t);n._addClientInfo(r);var s=a.getUrl(g.FLEX_INFO,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},getContexts(e){var t=["type","$skip","$filter"];var r=T(e,t);n._addClientInfo(r);var s=a.getUrl(g.CONTEXTS,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},loadContextDescriptions(e){e.method="POST";e.isContextSharing=true;return E(e).then(function(e){return e.response})},isContextSharingEnabled(){return Promise.resolve(true)},loadFeatures(e){if(n.settings){return Promise.resolve(n.settings)}var t={};n._addClientInfo(t);var r=a.getUrl(g.SETTINGS,e,t);return a.sendRequest(r,"GET",{initialConnector:n}).then(function(e){e.response.isVariantAdaptationEnabled=!!e.response.isPublicLayerAvailable;e.response.isContextSharingEnabled=true;e.response.isLocalResetEnabled=true;return e.response})},write(e){e.method="POST";return E(e)},condense(e){e.method="POST";e.isCondensingEnabled=true;return E(e)},update(e){if(e.flexObject.fileType==="variant"){e.isLegacyVariant=true}e.method="PUT";return E(e)},remove(e){var t={namespace:e.flexObject.namespace,layer:e.flexObject.layer};if(e.transport){t.changelist=e.transport}if(e.parentVersion){t.parentVersion=e.parentVersion}n._addClientInfo(t);e.fileName=e.flexObject.fileName;var r=e.flexObject.fileType==="variant"?g.VARIANTS:g.CHANGES;var i=a.getUrl(r,e,t);i=decodeURIComponent(i);delete e.fileName;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,undefined,"application/json; charset=utf-8","json");return s.sendRequest(i,"DELETE",l)},appVariant:{getManifirstSupport(e){var t=`${g.MANI_FIRST_SUPPORTED}/?id=${e.appId}`;return a.sendRequest(t,"GET",{initialConnector:n}).then(function(e){return e.response})},getManifest(e){var t=e.appVarUrl;var r=s.getRequestOptions(n,u.getLrepUrl()+g.TOKEN,undefined,"application/json; charset=utf-8","json");return s.sendRequest(t,"GET",r)},load(e){var t=a.getUrl(g.APPVARIANTS,e);var r=s.getRequestOptions(n,u.getLrepUrl()+g.TOKEN,undefined,"application/json; charset=utf-8","json");return s.sendRequest(t,"GET",r)},create(e){e.method="POST";e.isAppVariant=true;return E(e)},assignCatalogs(e){var t={};t.action=e.action;delete e.action;t.assignFromAppId=e.assignFromAppId;delete e.assignFromAppId;var r=a.getUrl(g.APPVARIANTS,e,t);delete e.reference;var i=a.getUrl(g.TOKEN,e);var o=s.getRequestOptions(n,i,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"POST",o)},unassignCatalogs(e){var t={};t.action=e.action;delete e.action;var r=a.getUrl(g.APPVARIANTS,e,t);delete e.reference;var i=a.getUrl(g.TOKEN,e);var o=s.getRequestOptions(n,i,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"POST",o)},update(e){return R(e).then(function(t){if(t){e.transport=t}delete e.isForSmartBusiness;e.method="PUT";e.isAppVariant=true;return E(e)})},remove(e){return R(e).then(function(t){var r={};if(t){r.changelist=t}delete e.isForSmartBusiness;var i=a.getUrl(g.APPVARIANTS,e,r);delete e.reference;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,undefined,"application/json; charset=utf-8","json");return s.sendRequest(i,"DELETE",l)})},list(e){var t={};t.layer=e.layer;t["sap.app/id"]=e.reference;delete e.layer;delete e.reference;var r=a.getUrl(g.APPVARIANTS_OVERVIEW,e,t);var i=s.getRequestOptions(n,undefined,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"GET",i)}},contextBasedAdaptation:{create(e){e.isContextBasedAdaptationEnabled=true;e.method="POST";return E(e)},reorder(e){e.isContextBasedAdaptationEnabled=true;e.method="PUT";return E(e)},update(e){e.isContextBasedAdaptationEnabled=true;e.method="PUT";e.reference=e.adaptationId;return E(e)},load(e){var t=["version"];var r=T(e,t);n._addClientInfo(r);e.reference=e.appId+v;var s=a.getUrl(g.CONTEXT_BASED_ADAPTATION,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},remove(e){e.isContextBasedAdaptationEnabled=true;e.method="DELETE";e.reference=e.adaptationId;return E(e)}},ui2Personalization:{create(e){e.initialConnector=this.initialConnector;var t=u.getLrepUrl();var r=s.getRequestOptions(n,t+g.TOKEN,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");var a=t+g.UI2PERSONALIZATION;return s.sendRequest(a,"PUT",r)},remove(e){e.initialConnector=this.initialConnector;var t=a.getUrl(g.UI2PERSONALIZATION,{url:u.getLrepUrl()},{reference:e.reference,containerkey:e.containerKey,itemname:e.itemName});return s.sendRequest(t,"DELETE")}},versions:{load(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e));var r={};a.addSAPLogonLanguageInfo(r);r.limit=e.limit;var i=a.getUrl(g.VERSIONS.GET,e,r);return s.sendRequest(i,"GET",t).then(function(e){return e.response.versions.map(function(e){return S(e)})})},activate(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e),{title:e.title},"application/json; charset=utf-8","json");var r={version:e.version};a.addSAPLogonLanguageInfo(r);var i=a.getUrl(g.VERSIONS.ACTIVATE,e,r);return s.sendRequest(i,"POST",t).then(function(e){var t=e.response;return S(t)})},discardDraft(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e));var r=a.getUrl(g.VERSIONS.DISCARD,e);return s.sendRequest(r,"DELETE",t)},publish(e){var r=t.getResourceBundleFor("sap.ui.fl");var o=function(t){c.hide();var n=r.getText("MSG_TRANSPORT_ERROR",t?[t.message||t]:undefined);var a=r.getText("HEADER_TRANSPORT_ERROR");f.error(`transport error${t}`);d.show(n,{icon:d.Icon.ERROR,title:a,styleClass:e.styleClass});return"Error"};var l=new i;return l.openTransportSelection(null,e.rootControl,e.styleClass,false).then(function(t){if(l.checkTransportInfo(t)){c.show(0);if(!t.transport){return Promise.reject(new Error("no transport provided as attribute of mParameters"))}if(!e.reference){return Promise.reject(new Error("no reference provided as attribute of mParameters"))}if(!e.version){return Promise.reject(new Error("no version provided as attribute of mParameters"))}var i={transport:t.transport,version:e.version};var o=a.getUrl(g.VERSIONS.PUBLISH,{url:u.getLrepUrl(),reference:e.reference},i);var p=a.getUrl(g.TOKEN,{url:u.getLrepUrl()});var f=s.getRequestOptions(n,p,undefined,"application/json; charset=utf-8","json");return s.sendRequest(o,"POST",f).then(function(){c.hide();if(t.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION")}return r.getText("MSG_TRANSPORT_SUCCESS")})}return"Cancel"}).catch(o)}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/NeoLrepConnector", ["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/NeoLrepConnector","sap/ui/fl/initial/_internal/connectors/Utils"],function(e,t,n,r){"use strict";var i={SETTINGS:"/flex/settings"};return e({},t,{initialConnector:n,layers:n.layers,isContextSharingEnabled(){return Promise.resolve(false)},loadContextDescriptions(){return Promise.reject("loadContextsDescriptions is not implemented")},getContexts(){return Promise.reject("getContexts is not implemented")},contextBasedAdaptation:{create(){return Promise.reject("contextBasedAdaptation.create is not implemented")},reorder(){return Promise.reject("contextBasedAdaptation.reorder is not implemented")},load(){return Promise.reject("contextBasedAdaptation.load is not implemented")}},loadFeatures(e){if(n.settings){return Promise.resolve(n.settings)}var t={};var o=r.getUrl(i.SETTINGS,e,t);return r.sendRequest(o,"GET",{initialConnector:n}).then(function(e){e.response.isContextSharingEnabled=false;return e.response})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/ObjectPathConnector", ["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/StorageUtils","sap/base/util/LoaderExtensions"],function(e,t,n,r){"use strict";var a;return e({},t,{layers:[],setJsonPath(e){a=e},loadFlexData(e){var t=a||e.path;if(t){return r.loadResource({dataType:"json",url:t,async:true}).then(function(e){return Object.assign(n.getEmptyFlexDataResponse(),e)})}return Promise.resolve()},loadFeatures(e){var t=a||e.path;if(t){return r.loadResource({dataType:"json",url:t,async:true}).then(function(e,t){t.componentClassName=e;return t.settings||{}}.bind(null,e.flexReference))}return Promise.resolve({})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/ObjectStorageConnector", ["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(e,t){"use strict";var r=e({},t,{oStorage:undefined});r.storage=r.oStorage;return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/PersonalizationConnector", ["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/PersonalizationConnector"],function(e,n,r){"use strict";var t="/flex/personalization";var a="/v1";var i={isProductiveSystem:true,hasPersoConnector:true};var o=e({},n,{layers:r.layers,ROUTES:{CHANGES:`${t+a}/changes/`,TOKEN:`${t+a}/actions/getcsrftoken`},loadFeatures(){return Promise.resolve(i)}});o.initialConnector=r;return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/SessionStorageConnector", ["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(e,t){"use strict";var a=e({},t,{storage:window.sessionStorage});a.loadFeatures=function(...a){return t.loadFeatures.apply(this,a).then(function(t){return e({isPublicLayerAvailable:true,isVariantAdaptationEnabled:true},t)})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/connectors/Utils", ["sap/ui/fl/initial/_internal/connectors/Utils"],function(n){"use strict";function t(t,e,i){if(t.initialConnector){delete t.initialConnector.xsrfToken}return n.sendRequest(t.tokenUrl,"HEAD",{initialConnector:t.initialConnector}).then(n.sendRequest.bind(undefined,e,i,t))}function e(n,t,i){if(!t[i]){t[i]=n[i];return}if(Array.isArray(t[i])){t[i]=t[i].concat(n[i]);return}if(typeof t[i]==="object"){Object.keys(n[i]).forEach(function(r){e(n[i],t[i],r)})}t[i]=n[i]}return{getRequestOptions(n,t,e,i,r){var o={tokenUrl:t,initialConnector:n};if(e){o.payload=JSON.stringify(e)}if(i){o.contentType=i}if(r){o.dataType=r}return o},sendRequest(e,i,r){if(!r.initialConnector||!r.initialConnector.xsrfToken&&!(i==="GET")&&!(i==="HEAD")){return t(r,e,i)}return n.sendRequest(e,i,r).then(function(n){return n}).catch(function(n){if(n.status===403){return t(r,e,i)}throw n})},mergeResults(n){var t={};n.forEach(function(n){Object.keys(n).forEach(function(i){e(n,t,i)})});return t}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/delegates/ODataV4ReadDelegate", ["sap/ui/base/Object"],function(e){"use strict";function a(e){if(e&&e.$Type){if(e.$Type.toLowerCase().indexOf("edm")!==0){return true}}return false}function t(e,a){return a.some(function(a){if(e.startsWith(a)){return true}})}function r(r,i,o,n,v,u,s){var l={name:r,bindingPath:r,entityType:n};var d=o["@com.sap.vocabularies.UI.v1.DataFieldDefault"];var p=d&&d.Label||o["@com.sap.vocabularies.Common.v1.Label"];l.label=p||`[LABEL_MISSING: ${r}]`;var c=o["@com.sap.vocabularies.UI.v1.Hidden"];l.hideFromReveal=c;if(c&&c.$Path){l.hideFromReveal=v.getBindingContext().getProperty(c.$Path)}var m;if(!l.hideFromReveal){m=o["@com.sap.vocabularies.Common.v1.FieldControl"];if(m){l.hideFromReveal=m.$EnumMember==="com.sap.vocabularies.Common.v1.FieldControlType/Hidden"}}m=o["@com.sap.vocabularies.Common.v1.FieldControl"];var f=m&&m.Path;if(f&&!l.hideFromReveal){var g=e.isObjectA(v.getBinding(u),"sap/ui/model/ListBinding");if(!g){var b=v.getBindingContext().getProperty(f);l.hideFromReveal=b===0}}if(d&&(d.$Type==="com.sap.vocabularies.UI.v1.DataFieldForAction"||d.$Type==="com.sap.vocabularies.UI.v1.DataFieldForIntentBasedNavigation"||d.$Type==="com.sap.vocabularies.UI.v1.DataFieldWithAction"||d.$Type==="com.sap.vocabularies.UI.v1.DataFieldWithIntentBasedNavigation")){l.unsupported=true}if(t(r,s)||a(i)){l.unsupported=true}return l}function i(e,a,t,i,o){var n=[];var v="";var u=[];var s;for(v in e){s=e[v];if(s.$kind==="NavigationProperty"){u.push(v)}}for(v in e){s=e[v];if(s.$kind==="Property"){var l=t.getObject(`/${a}/${v}@`);var d=r(v,s,l,a,i,o,u);n.push(d)}}return n}function o(e,a){if(a.path){return a.path}var t=e.getBindingContext();if(t){return t.getPath()}}function n(e,a,t){var r=e.getModel(t.modelName);if(r){if(r.isA("sap.ui.model.odata.v4.ODataModel")){var n=r.getMetaModel();var v=o(e,t);if(v){var u=n.getMetaContext(v);var s=u.getObject();var l=u.getObject(s.$Type);return i(l,s.$Type,n,e,a)}}}return Promise.resolve([])}var v={getPropertyInfo(e){return Promise.resolve().then(function(){return n(e.element,e.aggregationName,e.payload)})}};return v});
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/fl/write/_internal/extensionPoint/Processor", ["sap/ui/fl/apply/_internal/extensionPoint/Processor","sap/base/util/merge"],function(n,t){"use strict";function e(i,o){var r=t({defaultContent:[]},i);return n.registerExtensionPoint(r).then(n.createDefaultContent.bind(this,i,o,e,[])).then(n.addDefaultContentToExtensionPointInfo.bind(this,r,o))}var i={applyExtensionPoint(n){return e(n,false)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/ABAPAccess", ["sap/ui/util/openWindow","sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariantFactory","sap/ui/fl/write/_internal/fieldExtensibility/ServiceValidation"],function(n,t,e){"use strict";var i=null;var r=null;function u(){if(!r){return t.getInstance(i).then(function(n){r=n;return n})}return Promise.resolve(r)}var o={};o.getTexts=function(){return u(i).then(function(n){return n.getTexts().then(function(n){return n})})};o.isExtensibilityEnabled=function(n){return u(n).then(function(n){return n.getNavigationUri().then(function(n){return Boolean(n)})})};o.getExtensionData=function(){return u(i).then(function(n){return n.getExtensionData().then(function(n){return n})})};o.onControlSelected=function(n){if(n!==i){i=n;r=null}};o.onTriggerCreateExtensionData=function(){return u().then(function(t){return t.getNavigationUri().then(function(t){if(t){n(t,"_blank")}})})};o.reset=function(){i=null;r=null};o.isServiceOutdated=function(n){return e.isServiceOutdated(n)};o.setServiceValid=function(n){e.setServiceValid(n)};o.setServiceInvalid=function(n){e.setServiceInvalid(n)};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant", ["sap/ui/base/Object"],function(e){"use strict";var t=e.extend("sap.ui.fl.write._internal.fieldExtensibility.ABAPExtensibilityVariant",{_sServiceUri:null,_mBindingInfo:null,_mServiceInfo:null,constructor:function(e,t,i){this._sServiceUri=e;this._mBindingInfo=i;this._mServiceInfo=t;this._oExtensionDataPromise=this._determineExtensionData()},getExtensionData(){return Promise.resolve(null)},getMetadata(){return this.getMetadata()},getNavigationUri(){return Promise.resolve(null)},getTexts(){return Promise.resolve(null)},isActive(){return Promise.resolve(true)}});t.prototype._determineExtensionData=function(){return Promise.resolve(null)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariantFactory", ["sap/base/Log","sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/MultiTenantABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/SingleTenantABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/Utils","sap/ui/fl/write/_internal/fieldExtensibility/UriParser"],function(e,r,t,i,n,a){"use strict";var s={};var u=new r;function o(e){return Promise.all([n.getBoundEntitySet(e),n.getBoundEntityType(e)]).then(function(e){return{entitySetName:e[0],entityTypeName:e[1]}})}function l(r){e.error("Error occurred:");if(r){if(Array.isArray(r.errorMessages)){r.errorMessages.forEach(function(r){e.error(r.text)})}else{e.error(r)}}}function f(e,r){try{var n=a.parseServiceUri(e);var s=new t(e,n,r);var o=new i(e,n,r);return Promise.all([s.isActive(),o.isActive()]).then(function(e){var r=u;if(e[0]===true){r=s}else if(e[1]===true){r=o}return r}).catch(function(e){l(e);return Promise.resolve(u)})}catch(e){l(e);return Promise.resolve(u)}}function c(e,r){if(s[e]){return s[e][r.entityTypeName]}return null}function y(e,r,t){s[e]||={};s[e][r.entityTypeName]=t}function v(e,r){var t=n.getServiceUri(e);var i=c(t,r);if(!i){return f(t,r).then(function(e){y(t,r,e);return Promise.resolve(e)})}return Promise.resolve(i)}var P={};P.getInstance=function(e){if(n.checkControlPrerequisites(e)){return o(e).then(function(r){return v(e,r).then(function(e){return e.getInterface()})}).catch(function(e){l(e);return Promise.resolve(u.getInterface())})}return Promise.resolve(u.getInterface())};P.reset=function(){s={}};return P});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/MultiTenantABAPExtensibilityVariant", ["sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/Utils"],function(t,e){"use strict";var i="/sap/opu/odata/sap/APS_PREDEFINED_FIELD_SRV/GetExtensionDataByResourcePath";var n={semanticObject:"PredefinedCustomField",action:"configure"};var s=t.extend("sap.ui.fl.write._internal.fieldExtensibility.MultiTenantABAPExtensibilityVariant",{getExtensionData(){return this._oExtensionDataPromise.then(function(t){if(this._containsData(t)){return this._convertExtensionData(t)}return null}.bind(this))},getNavigationUri(){return this._oExtensionDataPromise.then(function(t){if(this._containsData(t)){return e.getNavigationUriForIntent({target:n,params:{businessObjectNodeName:t.BusinessObjectNodeName,cdsEntityName:t.CdsEntityName,serviceVersion:this._mServiceInfo.serviceVersion,serviceName:this._mServiceInfo.serviceName}})}return null}.bind(this))},getTexts(){return this._oExtensionDataPromise.then(function(t){if(this._containsData(t)){return{tooltip:e.getText("BTN_ADD_FIELD"),headerText:e.getText("BUSINESS_OBJECT_NODE_TITLE")}}return null}.bind(this))},isActive(){return this._oExtensionDataPromise.then(function(t){return this._containsData(t)}.bind(this))},_containsData(t){return Boolean(t&&t.BusinessObjectNodeName&&t.CdsEntityName)},_convertExtensionData(t){return{extensionData:[{businessContext:t.BusinessObjectNodeName,description:t.BusinessObjectNodeDescription}]}},_determineExtensionData(){return new Promise(function(t,s){e.isNavigationSupportedForIntents([n]).then(function(n){var a=n.some(function(t){return t===true});if(a){e.executeRequest(i,{ResourcePath:this._sServiceUri,EntitySetName:this._mBindingInfo.entitySetName}).then(function(e){if(e.errorOccurred===false){t(this._extractExtensionDataFromResponse(e.result))}else{s(e)}}.bind(this))}else{t(null)}}.bind(this))}.bind(this))},_extractExtensionDataFromResponse(t){return t.GetExtensionDataByResourcePath}});return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/ServiceValidation", ["sap/ui/fl/Utils","sap/ui/util/Storage","sap/ui/fl/write/_internal/fieldExtensibility/UriParser"],function(e,r,t){"use strict";var i={};var n="sap.ui.fl.fieldExt.Access";var u=1*7*24*60*60*1e3;function a(){return Date.now()}function f(){return i.getLocalStorage()}function s(){return f()&&f().isSupported()}function c(){if(!s()){return{}}var e=f().get(n);if(!e){return{}}return JSON.parse(e)}function o(e){return e.expirationDate<=a()}function l(e){return c()[e.serviceKey]||null}function v(e){var r=a()+u;var t=S();var i=p(e);return{serviceKey:t.getName()+t.getClient()+i.serviceName+i.serviceVersion,expirationDate:r}}function p(e){if(typeof e==="string"){return t.parseServiceUri(e)}return e}function g(){return S()}function S(){var r=e.getUshellContainer();return r&&r.getLogonSystem()}function d(e){if(s()){f().put(n,JSON.stringify(e))}}i.getLocalStorage=function(){return new r(r.Type.local)};i.isServiceOutdated=function(e){if(!g()){return false}var r=l(v(e));if(r){if(o(r)){this.setServiceValid(e);return false}return true}return false};i.setServiceValid=function(e){if(g()){var r=c();delete r[v(e).serviceKey];d(r)}};i.setServiceInvalid=function(e){if(g()){var r=c();var t=v(e);r[t.serviceKey]=t;d(r)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/SingleTenantABAPExtensibilityVariant", ["sap/ui/fl/write/_internal/fieldExtensibility/ABAPExtensibilityVariant","sap/ui/fl/write/_internal/fieldExtensibility/UriParser","sap/ui/fl/write/_internal/fieldExtensibility/Utils"],function(e,t,i){"use strict";var n="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/";var s={None:-1,Both:0,Fields:1,Logic:2};var r=[{semanticObject:"CustomField",action:"develop"},{semanticObject:"CustomField",action:"manage"},{semanticObject:"CustomLogic",action:"develop"}];var o=["BTN_FREP_CCF","BTN_ADD_FIELD","BTN_ADD_LOGIC"];var a=e.extend("sap.ui.fl.write._internal.fieldExtensibility.SingleTenantABAPExtensibilityVariant",{_iExtensibilityType:s.None,getExtensionData(){return this._oExtensionDataPromise.then(function(e){if(this._containsData(e)){return this._convertBusinessContextsToExtensionData(e)}return null}.bind(this))},getNavigationUri(){return this._oExtensionDataPromise.then(function(e){if(this._containsData(e)&&this._iExtensibilityType!==s.None){return i.getNavigationUriForIntent({target:r[this._iExtensibilityType],params:{businessContexts:e.map(function(e){return e.BusinessContext}),serviceVersion:this._mServiceInfo.serviceVersion,serviceName:this._mServiceInfo.serviceName,entityType:this._mBindingInfo.entityTypeName}})}return Promise.resolve(null)}.bind(this))},getTexts(){return this._oExtensionDataPromise.then(function(e){if(this._containsData(e)){return{tooltip:i.getText(o[this._iExtensibilityType]),headerText:i.getText("BUSINESS_CONTEXT_TITLE")}}return null}.bind(this))},isActive(){return this._oExtensionDataPromise.then(function(e){return this._containsData(e)}.bind(this))},_adjustExtensibilityTypeByAuthorizations(e,t){if(e[t]){return t}else if(e[s.Both]){return s.Both}else if(t===s.Both){if(e[s.Fields]){return s.Fields}else if(e[s.Logic]){return s.Logic}}return s.None},_containsData(e){return Boolean(e&&e.length>0)},_convertBusinessContextsToExtensionData(e){var t=e.map(function(e){return{description:e.BusinessContextDescription,businessContext:e.BusinessContext}});return{extensionData:t}},_determineExtensionData(){return new Promise(function(e,n){i.isNavigationSupportedForIntents(r).then(function(r){var o=r.some(function(e){return e===true});if(o){i.executeRequest(this._getExtensionDataServiceUri(),this._getExtensionDataServiceParameters()).then(function(i){if(i.errorOccurred===false){var o=this._extractBusinessContextsFromResponse(i.result);this._iExtensibilityType=this._determineExtensibilityType(r,o);if(this._iExtensibilityType!==s.None){e(o)}else{e(null)}}else if(i.statusCode===404&&this._mServiceInfo.serviceType===t.mServiceType.v4){e(null)}else{n(i)}}.bind(this))}else{e(null)}}.bind(this))}.bind(this))},_determineExtensibilityType(e,t){var i=this._determineExtensibilityTypeFromBusinessContexts(t);if(i!==s.None){return this._adjustExtensibilityTypeByAuthorizations(e,i)}return i},_determineExtensibilityTypeFromBusinessContexts(e){var t=false;var i=false;e.forEach(function(e){if(e.hasOwnProperty("SupportsLogicEnhancements")===false||e.SupportsLogicEnhancements===true){t=true}if(e.hasOwnProperty("SupportsStructuralEnhancements")===false||e.SupportsStructuralEnhancements===true){i=true}});if(t&&i){return s.Both}else if(!t&&i){return s.Fields}else if(t&&!i){return s.Logic}return null},_extractBusinessContextsFromResponse(e){return e.results||[]},_getExtensionDataServiceParameters(){var e={EntitySetName:"",EntityTypeName:this._mBindingInfo.entityTypeName};if(this._mServiceInfo.serviceType===t.mServiceType.v4){e.ResourcePath=`${t.sODataV4ResourcePathPrefix+this._mServiceInfo.serviceName}/${this._mServiceInfo.serviceVersion}`}else{e.ServiceName=this._mServiceInfo.serviceName;e.ServiceVersion=this._mServiceInfo.serviceVersion}return e},_getExtensionDataServiceUri(){if(this._mServiceInfo.serviceType===t.mServiceType.v4){return`${n}GetBusinessContextsByResourcePath`}return`${n}GetBusinessContextsByEntityType`}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/UriParser", [],function(){"use strict";var e={v2:"v2",v4:"v4"};function r(r){var i=/.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;var a=/([^;]+);v=(\d{1,4})/i;var s="sap/opu/odata";var t;if(r.toLowerCase().indexOf(s)!==-1){var v=r.match(i);if(!v||v.length!==3){throw new Error("sap.ui.fl.fieldExt.UriParser.parseV2ServiceUri: Malformed service URI (Invalid service name)")}if(v[1].toLowerCase()!=="sap"){t=`/${v[1]}/${v[2]}`}else{[,,t]=v}}else{if(r.length>0&&r.lastIndexOf("/")+1===r.length){r=r.substring(0,r.length-1)}t=r.substring(r.lastIndexOf("/")+1)}if(t.indexOf(";v=")!==-1){var n=t.match(a);if(!n||n.length!==3){throw new Error("sap.ui.fl.fieldExt.UriParser.parseV2ServiceUri: Malformed service URI (Invalid version)")}return{serviceName:n[1],serviceVersion:n[2],serviceType:e.v2}}return{serviceName:t,serviceVersion:"0001",serviceType:e.v2}}function i(r){var i=/^\/?sap\/opu\/odata4((?:\/[^/]+){5})(\/[^/]+){1}(\/.*)?/i;var a=r.match(i);if(!a||a.length!==4){throw new Error("sap.ui.fl.fieldExt.UriParser.parseV4ServiceUri: Malformed service URI")}var s=a[1].split("/");s.splice(0,3);var t=/(\d{1,4})/i;var v=a[2].match(t);return{serviceName:s.join("/"),serviceVersion:v[1],serviceType:e.v4}}var a={};a.mServiceType=e;a.sODataV4ResourcePathPrefix="sap/opu/odata4/";a.parseServiceUri=function(e){if(e.toLowerCase().indexOf(this.sODataV4ResourcePathPrefix)!==-1){return i(e)}return r(e)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/Utils", ["sap/base/Log","sap/base/security/encodeURL","sap/ui/core/Lib","sap/ui/fl/Utils","sap/ui/thirdparty/jquery"],function(e,t,r,n,jQuery){"use strict";var a={v2:"v2",v4:"v4"};function i(e){if(e&&e.split){var t=e.split(".");return t[t.length-1]}return null}function u(e){var t=[];try{var r=JSON.parse(e.responseText);if(r&&r.error&&r.error.message&&r.error.message.value){t.push({severity:"error",text:r.error.message.value})}else{t.push({severity:"error",text:e.responseText})}}catch(e){}return t}function o(t){var r=i(v(t));if(!r){var n=t.getBindingContext?t.getBindingContext():null;if(n&&n.getPath){r=n.getPath()}}if(!r){e.warning("Control not bound to a path")}return r}function s(e,t,r){return e.metadataLoaded().then(function(){var n=null;if(r){var a=e.oMetadata._getEntityTypeByName(r);n=e.oMetadata._getEntitySetByType(a)}n||=e.oMetadata._getEntitySetByPath(t);return n?n.name:null})}function l(e,t){var r=e.getMetaModel();var n=r.getMetaPath(t);return r.requestObject(n).then(function(e){var t=r.fetchEntityContainer().getResult();var n=t[t.$EntityContainer];var a=Object.keys(n).filter(function(t){return n[t]===e});return a.length>0&&a[0]})}function f(e,t,r){return e.metadataLoaded().then(function(){var n=null;if(r){n=e.oMetadata._getEntityTypeByName(r)}n||=e.oMetadata._getEntityTypeByPath(t);return n?n.name:null})}function c(e,t){var r=e.getMetaModel();var n=r.getMetaPath(t);return r.requestObject(n).then(function(e){return i(e.$Type)})}function v(e){return e.getEntitySet?e.getEntitySet():null}function g(e){return e.getEntityType?e.getEntityType():null}function p(t){var r=null;if(t&&t.sServiceUrl){r=t.sServiceUrl}if(!r){e.warning("Model has no Service Uri")}return r}function d(e){if(e){if(e.isA("sap.ui.model.odata.v2.ODataModel")){return a.v2}else if(e.isA("sap.ui.model.odata.v4.ODataModel")){return a.v4}}return null}function y(t){if(t){var r=t.getModel?t.getModel():null;if(d(r)){return r}e.warning("Unsupported model type or protocol");return null}e.warning("No Control passed");return null}var h={};h.checkControlPrerequisites=function(t){if(t){var r=y(t);var n=p(r);var a=o(t);var i=g(t);return Boolean(n&&(a||i))}e.warning("No Control passed");return false};h.executeRequest=function(e,t){var r=e+this.getUriParameters(t);return new Promise(function(e){var t={type:"GET",async:true,dataType:"json"};jQuery.ajax(r,t).done(function(t){var r=t&&t.d;e({errorOccurred:false,result:r})}).fail(function(t){e({errorOccurred:true,errorMessages:u(t),statusCode:t.status})})})};h.getBoundEntitySet=function(e){var t=y(e);var r=d(t);if(r===a.v2){return s(t,o(e),g(e))}else if(r===a.v4){return l(t,o(e))}return Promise.resolve(null)};h.getBoundEntityType=function(e){var t=y(e);var r=d(t);if(r===a.v2){return f(t,o(e),g(e))}else if(r===a.v4){return c(t,o(e))}return Promise.resolve(null)};h.getNavigationUriForIntent=function(e){return n.getUShellService("CrossApplicationNavigation").then(function(t){if(t&&t.hrefForExternal){return t.hrefForExternal(e)}return Promise.resolve(null)})};h.getServiceUri=function(e){var t=y(e);return p(t)};h.getText=function(e){return r.getResourceBundleFor("sap.ui.fl").getText(e)};h.getUriParameters=function(e){if(!e){return""}var r=[];Object.keys(e).forEach(function(n){if(n){var a=`'${t(e[n]||"")}'`;r.push(`${t(n)}=${a}`)}});return r.length===0?"":`?${r.join("&")}`};h.isNavigationSupportedForIntents=function(e){return n.getUShellService("CrossApplicationNavigation").then(function(t){if(t&&t.isNavigationSupported){return t.isNavigationSupported(e).then(function(e){return e.map(function(e){return e&&e.supported===true})})}return Promise.resolve(e.map(function(){return false}))})};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/CAPAccess", ["sap/ui/core/Lib","sap/ui/fl/write/_internal/fieldExtensibility/ServiceValidation","sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog"],function(e,t,i){"use strict";var n=null;var r=null;var a=e.getResourceBundleFor("sap.ui.fl");var o={};o.getTexts=function(){return{headerText:a.getText("BUSINESS_CONTEXT_TITLE"),tooltip:a.getText("BTN_ADD_FIELD")}};o.isExtensibilityEnabled=function(){return true};o.getExtensionData=function(){var e=n.getModel();var t=n.getBindingContext().getPath();if(e.isA("sap.ui.model.odata.v2.ODataModel")){return Promise.reject()}else if(e.isA("sap.ui.model.odata.v4.ODataModel")){var i=e.getMetaModel();var r=i.getMetaPath(t);return i.requestObject(r).then(function(e){var t=i.fetchEntityContainer().getResult();var n=t[t.$EntityContainer];return{boundEntitySet:e,entityTypes:Object.values(n).map(function(e){return e.$Type}).filter(Boolean)}})}return Promise.reject()};o.onControlSelected=function(e){n=e};o.onTriggerCreateExtensionData=function(e,t){r||=new i;r.open(e,t)};o.isServiceOutdated=function(e){return t.isServiceOutdated(e)};o.setServiceValid=function(e){t.setServiceValid(e)};o.setServiceInvalid=function(e){t.setServiceInvalid(e)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog", ["sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/core/Lib","sap/m/MessageToast","sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/getEditorConfig","sap/base/util/ObjectPath","sap/base/util/deepClone","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel"],function(e,t,i,n,o,s,a,r,l){"use strict";var d=i.getResourceBundleFor("sap.ui.fl");function u(e,t,i){var n=e.getContent()[0];n.setJson(a(t));n.setConfig(o(i));return n}function p(e){if(!e||!e.element){return{}}var t=a(e);if(!s.get(["element","@Common.Label"],t)){var i=s.get(["element","name"],t);s.set(["element","@Common.Label"],i,t)}var n=s.get(["element","@assert.range"],t);if(s.get(["element","type"],t)==="cds.String"&&Array.isArray(n)){s.set(["element","enum"],n.reduce(function(e,t){e[t]={};return e},{}),t);s.set(["element","@assert.range"],true,t)}if(t.element.annotations){t.element=Object.assign({},t.element,t.element.annotations);delete t.element.annotations}var o={extend:t.extend,elements:{}};o.elements[t.element.name]=t.element;return o}var g=e.extend("sap.ui.fl.write._internal.fieldExtensibility.cap.dialog.CustomFieldCAPDialog",{metadata:{library:"sap.ui.fl",properties:{_dialog:{type:"sap.m.Dialog",visibility:"hidden"}}}});g.prototype.open=function(e,i){var n={element:{name:"NewField",type:"cds.String"},extend:e.boundEntitySet.$Type};var o=this.getProperty("_dialog");if(o){this._oEditor.setJson(a(n));o.open()}else{t.load({name:"sap.ui.fl.write._internal.fieldExtensibility.cap.dialog.CustomFieldCAPDialog",controller:this}).then(function(t){this._oDialogModel=new l({isValid:true});this._oDialogModel.setDefaultBindingMode("OneWay");t.setModel(this._oDialogModel,"dialog");t.setModel(new r({bundle:d}),"i18n");t.addStyleClass(i);this.setProperty("_dialog",t);this._oJson=a(n);this._oEditor=u(t,this._oJson,{entityTypes:e.entityTypes});this._oEditor.attachJsonChange(function(e){this._oJson=e.getParameter("json")}.bind(this));this._oEditor.attachValidationErrorChange(function(e){var t=e.getParameter("hasError");this._oDialogModel.setData({isValid:!t})}.bind(this));t.open()}.bind(this))}};g.prototype.exit=function(){var e=this.getProperty("_dialog");if(e){e.destroy()}if(this.oEditor){this.oEditor.destroy()}};g.prototype.onSave=function(){var e=p(this._oJson);var t={extensions:[JSON.stringify(e)]};var i=new Promise(function(e,i){var n=new XMLHttpRequest;n.open("POST","/-/cds/extensibility/addExtension");n.setRequestHeader("Content-Type","application/json");n.onload=function(){if(n.status>=200&&n.status<400){e(n.response)}else{i({status:n.status,message:n.statusText})}};n.send(JSON.stringify(t))});i.then(function(){n.show(d.getText("CAP_ADD_FIELD_SUCCESS"))});this.getProperty("_dialog").close()};g.prototype.onCancel=function(){this.getProperty("_dialog").close()};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/getEditorConfig", [],function(){"use strict";return function(e){return{context:"/element",properties:{entityType:{tags:["general"],label:"Entity Type",path:"/extend",type:"select",items:(e.entityTypes||[]).map(function(e){return{key:e}}),allowCustomValues:false,validators:{isRequired:{type:"isRequired"}}},name:{tags:["general"],label:"Name",path:"name",type:"string",validators:{isRequired:{type:"isRequired"},namePattern:{type:"pattern",errorMessage:"CAP_ERR_WHITESPACE",config:{pattern:"^\\S+$"}}}},label:{tags:["general"],label:"Label",path:"@Common.Label",type:"string",placeholder:"{/element/name}"},type:{tags:["general"],label:"Type",path:"type",type:"select",items:[{key:"cds.String",title:"String"},{key:"cds.Integer",title:"Integer"},{key:"cds.Decimal",title:"Decimal"},{key:"cds.Date",title:"Date"},{key:"cds.Time",title:"Time"},{key:"cds.DateTime",title:"DateTime"},{key:"cds.Boolean",title:"Boolean"}],allowCustomValues:false,validators:{isRequired:{type:"isRequired"}}},numberPrecision:{tags:["general"],label:"Precision",path:"precision",type:"number",defaultValue:"",visible:"{= ${/element/type} === 'cds.Decimal' }"},numberScale:{tags:["general"],label:"Scale",path:"scale",type:"number",defaultValue:"",visible:"{= ${/element/type} === 'cds.Decimal' }"},stringLength:{tags:["general"],label:"Length",path:"length",type:"number",defaultValue:"",visible:"{= ${/element/type} === 'cds.String' }"},defaultValue:{tags:["general"],label:"Default",path:"default/val",defaultValue:"",type:"{/element/type}"},readonly:{tags:["validation"],label:"Readonly",path:"@readonly",type:"bool"},mandatory:{tags:["validation"],label:"Mandatory",path:"@mandatory",type:"bool"},format:{tags:["validation"],label:"Format",path:"@assert.format",type:"string",defaultValue:"",visible:"{= ${/element/type} === 'cds.String' }"},stringRange:{tags:["validation"],label:"Allowed Values",path:"@assert.range",type:"list",visible:"{= ${/element/type} === 'cds.String' }",active:"{= ${/element/type} === 'cds.String' }"},arrayRange:{tags:["validation"],label:"Range",path:"@assert.range",type:"range",rangeType:"{/element/type}",visible:"{= ${/element/type} === 'cds.Integer' || ${/element/type} === 'cds.Decimal' || ${/element/type} === 'cds.DateTime' || ${/element/type} === 'cds.Date' || ${/element/type} === 'cds.Time'}",active:"{= ${/element/type} === 'cds.Integer' || ${/element/type} === 'cds.Decimal' || ${/element/type} === 'cds.DateTime' || ${/element/type} === 'cds.Date' || ${/element/type} === 'cds.Time'}"},annotations:{tags:["advanced"],label:"Additional Annotations",allowedTypes:["json"],path:"annotations",type:"map",allowTypeChange:false,addItemLabelI18n:"CAP_ADD_FIELD_EDITOR.ANNOTATION",defaultType:"json"}},layout:{form:{groups:[{label:"General",items:[{type:"tag",value:"general"}]},{label:"Input Validation",items:[{type:"tag",value:"validation"}]},{label:"Advanced",items:[{type:"tag",value:"advanced"}]}]}},propertyEditors:{select:"sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor",string:"sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor",integer:"sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor",number:"sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor",map:"sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor",list:"sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor",bool:"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor",range:"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor",json:"sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor","cds.String":"sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor","cds.Integer":"sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor","cds.Decimal":"sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","cds.Date":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","cds.Time":"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor","cds.DateTime":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor","cds.Boolean":"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor"},i18n:"sap/ui/fl/messagebundle.properties",validators:{isRequired:"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/validators/IsRequired"},propertyEditorConfigs:{"cds.Date":{pattern:"YYYY-MM-dd"},"cds.DateTime":{pattern:"YYYY-MM-dd'T'HH:mm:ss'Z'"}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor"],function(e){"use strict";var t=e.extend("sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.booleanEditor.BooleanEditor",{xmlFragment:"sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.booleanEditor.BooleanEditor",metadata:{library:"sap.ui.fl"},renderer:e.getMetadata().getRenderer().render});t.prototype._onChange=function(e){var t=!!e.getParameter("selected");this.setValue(t)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/model/json/JSONModel"],function(t,e){"use strict";var i=t.extend("sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.rangeEditor.RangeEditor",{xmlFragment:"sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.rangeEditor.RangeEditor",metadata:{library:"sap.ui.fl"},renderer:t.getMetadata().getRenderer().render});i.configMetadata=Object.assign({},t.configMetadata,{rangeType:{defaultValue:"string"}});i.prototype.init=function(...i){t.prototype.init.apply(this,i);this._oContentModel=new e;this._oContentModel.setDefaultBindingMode("OneWay");this.setModel(this._oContentModel,"contentModel")};i.prototype.getExpectedWrapperCount=function(){return 2};i.prototype.setConfig=function(...e){t.prototype.setConfig.apply(this,e);this.setValue(this.getValue())};i.prototype.setValue=function(...e){const[i]=e;t.prototype.setValue.apply(this,e);var n={type:this.getConfig().rangeType};var o=Array.isArray(i)?i:[];this._oContentModel.setData([{value:o[0],config:Object.assign({index:0},n)},{value:o[1],config:Object.assign({index:1},n)}])};i.prototype._onChange=function(t){var e=t.getParameter("value");var i=t.getSource().getConfig().index;var n=(this.getValue()||[]).slice();n[i]=e;this.setValue(n)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","sap/ui/core/format/DateFormat"],function(t,e,r){"use strict";var i=e.extend("sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.timeEditor.TimeEditor",{xmlFragment:"sap.ui.fl.write._internal.fieldExtensibility.cap.editor.propertyEditor.timeEditor.TimeEditor",metadata:{library:"sap.ui.fl"},renderer:t.getMetadata().getRenderer().render});i.configMetadata=Object.assign({},e.configMetadata,{pattern:{defaultValue:"HH:mm:ss"},utc:{defaultValue:false}});i.prototype.getDefaultValidators=function(){return Object.assign({},e.prototype.getDefaultValidators.call(this))};i.prototype.getFormatterInstance=function(t){return r.getTimeInstance(t||{pattern:"HH:mm:ss.SSSS"})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/validators/IsRequired", [],function(){"use strict";return{async:false,errorMessage:"CAP_ERR_REQUIRED",validate(e){return e===false||e===0||!!e}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/flexState/UI2Personalization/UI2PersonalizationState", ["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState","sap/ui/fl/write/_internal/connectors/LrepConnector"],function(e,n,t){"use strict";const o={};o.setPersonalization=async function(n){if(!n||!n.reference||!n.containerKey||!n.itemName||!n.content){throw new Error("not all mandatory properties were provided for the storage of the personalization")}const o=await t.ui2Personalization.create({flexObjects:n});const a=e.getUI2Personalization(o.response.reference);a[o.response.containerKey]||=[];a[o.response.containerKey].push(o.response);e.updateStorageResponse(o.response.reference,[{type:"ui2",newData:a}])};o.deletePersonalization=async function(o,a,r){if(!o||!a||!r){throw new Error("not all mandatory properties were provided for the storage of the personalization")}await t.ui2Personalization.remove({reference:o,containerKey:a,itemName:r});const i=e.getUI2Personalization(o);const s=i[a];const p=n.getPersonalization(o,a,r);const l=s.indexOf(p);s.splice(l,1);e.updateStorageResponse(o,[{type:"ui2",newData:i}])};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/TransportDialog", ["sap/m/List","sap/m/InputListItem","sap/m/Button","sap/m/ComboBox","sap/m/Dialog","sap/m/Input","sap/m/MessageToast","sap/ui/core/ListItem","sap/ui/core/Lib","sap/ui/fl/write/_internal/transport/Transports","sap/ui/core/library"],function(t,e,s,o,r,a,i,n,l,p,u){"use strict";var{ValueState:c}=u;var h=r.extend("sap.ui.fl.write._internal.transport.TransportDialog",{metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},localObjectVisible:{type:"boolean",group:"Misc",defaultValue:true},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},renderer:{apiVersion:2}});h.prototype.init=function(){r.prototype.init.apply(this);this._oResources=l.getResourceBundleFor("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();this.setEscapeHandler(function(t){this.fireCancel();t.resolve()}.bind(this))};h.prototype._createContentList=function(){this._oPackageListItem=new e({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new e({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new t({items:[this._oPackageListItem,this._oTransportListItem]})};h.prototype._createButtons=function(){var t=this;this._oLocalObjectButton=new s({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press(){t._onLocal()}});this.addButton(this._oLocalObjectButton);this.addButton(new s({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press(){t._onOkay()}}));this.addButton(new s({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press(){t.fireCancel();t.close();t.destroy()}}))};h.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy()};h.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy()}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(c.Error);this._oTransport.setValueStateText(this.getTitle())}};h.prototype._checkOkay=function(t){if(t){return true}return false};h.prototype._createTransportCombo=function(){var t=this;return new o({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(c.None)},change(e){var s=function(t){if(t&&e.mParameters.newValue!==t.getText()||!t){return true}return false};if(e&&e.mParameters&&e.mParameters.newValue){if(s(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(c.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"))}}}})};h.prototype._createPackageField=function(){var t=this;return new a({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change(){var e;var s;s=t._createObjectInfo();e=p.getTransports(s);e.then(function(e){t._onPackageChangeSuccess(e)},function(e){t._onPackageChangeError(e)})},liveChange(e){if(e.mParameters.liveValue&&e.mParameters.liveValue.length>3){t._oTransport.setEnabled(true)}}})};h.prototype._createObjectInfo=function(){var t;var e={package:this._oPackage.getValue()||""};t=this.getProperty("lrepObject");if(t){if(t.name){e.name=t.name}if(t.type){e.type=t.type}if(t.namespace){e.namespace=t.namespace}}return e};h.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true)}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t)}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(c.Error);this._oPackage.setValueStateText(this._oResources.getText(`TRANSPORT_DIALOG_${t.errorCode}`));this._setTransports(t)}else{i.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"))}}};h.prototype._setTransports=function(t){var e;var s;e=this._hasLock(t.transports);if(e){s=[e]}else{s=t.transports}this.setTransports(s);if(s&&s.length===1){this._oTransport.setValue(s[0].description,true);this.getButtons()[1].setEnabled(true)}if(!s||s.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(c.None);this.getButtons()[1].setEnabled(false)}};h.prototype._onPackageChangeError=function(t){i.show(t);this.setTransports([])};h.prototype._hasLock=function(t){var e;var s=t.length;while(s--){e=t[s];if(e.locked){return e}}return null};h.prototype.setLocalObjectVisible=function(t){this._oLocalObjectButton.setVisible(t);this.setProperty("localObjectVisible",t)};h.prototype.setPkg=function(t){if(t&&!this.getProperty("pkg")){this.setProperty("pkg",t);this._oPackage.setValue(t);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false)}return this};h.prototype.setTransports=function(t){var e;var s=0;var o;if(t){this.setProperty("transports",t);this._oTransport.removeAllItems();s=t.length;for(e=0;e<s;e++){o=t[e];this._oTransport.addItem(new n({key:o.transportId,text:o.transportId,additionalText:o.description}))}if(s===1){this._oTransport.setSelectedKey(t[0].transportId);this.getButtons()[1].setEnabled(true)}if(s>0){this._oTransport.setEnabled(true)}}return this};h.prototype.setLrepObject=function(t){if(t&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",t)}return this};h.prototype.setHidePackage=function(t){this.setProperty("hidePackage",t);this._oPackageListItem.setVisible(!t);if(t){this.getButtons()[0].setEnabled(t);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"))}return this};return h},true);
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/TransportSelection", ["sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/write/_internal/transport/Transports","sap/ui/fl/write/_internal/transport/TransportDialog","sap/ui/fl/registry/Settings","sap/ui/core/BusyIndicator"],function(e,t,a,r,n,s,o){"use strict";var i=function(){};i.prototype.selectTransport=function(n,o,i,c,p,l,u){if(!e.getLrepUrl()){o(this._createEventObject(n,{transportId:""}));return}var f=function(e,a,n,s,o,i){r.getTransports(e).then(function(r){if(this._checkDialog(r,i)){this._openDialog({hidePackage:!t.doesCurrentLayerRequirePackage(),pkg:e.package,transports:r.transports,localObjectVisible:u,lrepObject:this._toLREPObject(e)},a,n,s,o)}else{var c=!r.localonly&&i?{transportId:"ATO_NOTIFICATION"}:this._getTransport(r);a(this._createEventObject(e,c))}}.bind(this),function(e){n(e)})};var g=t.getCurrentLayer();if(g&&(g===a.CUSTOMER||g===a.CUSTOMER_BASE)){s.getInstance().then(function(e){if(e.isAtoEnabled()){if(!(n&&n.name&&n.namespace&&n.type)){var t={transportId:"ATO_NOTIFICATION"};o(this._createEventObject(n,t))}else{f.apply(this,[n,o,i,c,l,true])}}else{f.apply(this,[n,o,i,c,l,false])}}.bind(this))}else{f.apply(this,[n,o,i,c,l,false])}};i.prototype._createEventObject=function(e,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:e.package,dialog:false},getParameters(){return this.mParameters},getParameter(e){return this.mParameters[e]}}};i.prototype._toLREPObject=function(e){var t={};if(e.namespace){t.namespace=e.namespace}if(e.name){t.name=e.name}if(e.type){t.type=e.type}return t};i.prototype._openDialog=function(e,t,a,r,s){var i=new n(e);i.attachOk(t);i.attachCancel(a);i.addStyleClass(s);if(r){i.addStyleClass("sapUiSizeCompact")}else{i.removeStyleClass("sapUiSizeCompact")}i.open();o.hide();return i};i.prototype._getTransport=function(e){var t;if(!e.localonly){t=this._hasLock(e.transports)}else{t={transportId:""}}return t};i.prototype._checkDialog=function(e,t){if(e){if(e.localonly||this._hasLock(e.transports)||!e.localonly&&t){return false}}return true};i.prototype._hasLock=function(e){var t=e.length;while(t--){var a=e[t];if(a.locked){return a}}return false};i.prototype.setTransports=function(e,t){var a=e.length-1;var r=this;var n=function(e,t,a,s,o){if(t>=0){var i=e[t];if(o===true){if(i.getFlexObjectMetadata().packageName!=="$TMP"){i.setRequest(s)}t--;return n(e,t,a,s,o)}if(i.getFlexObjectMetadata().packageName!=="$TMP"){var c={name:i.getId(),type:i.getFileType(),package:i.getFlexObjectMetadata().packageName,namespace:i.getNamespace()};return r.openTransportSelection(c,a).then(function(r){if(r==="cancel"){return Promise.reject("cancel")}i.setRequest(r.transport);if(r.fromDialog===true){s=r.transport;o=true}t--;return n(e,t,a,s,o)},function(){return null})}t--;return n(e,t,a,s,o)}return Promise.resolve()};return n(e,a,t)};i.prototype.openTransportSelection=function(e,t,a,r){var n=this;return new Promise(function(s,o){var i=function(e){if(e&&e.getParameters){var t=e.getParameters().selectedTransport;var a=e.getParameters().selectedPackage;var r=e.getParameters().dialog;var n={transport:t,packageName:a,fromDialog:r};s(n)}else{s({})}};var c=function(e){if(e.sId==="cancel"){s(e.sId)}else{o(e)}};n.selectTransport(e||{},i,c,false,t,a,r)})};i.prototype.checkTransportInfo=function(e){return e&&e.transport&&e.packageName!=="$TMP"};i.prototype._prepareChangesForTransport=function(e,t,a,n){var s=r.convertToChangeTransportData(t,a);var o={};o.package=e.packageName;o.transportId=e.transport;o.changeIds=s;o.reference=n.reference;o.layer=n.layer;return r.makeChangesTransportable(o).then(function(){t.forEach(function(t){var a=t.getFlexObjectMetadata();if(a.packageName==="$TMP"){a.packageName=e.packageName;t.setFlexObjectMetadata(a)}})})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/_internal/transport/Transports", ["sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils"],function(e,r,t,n){"use strict";var a={ACTION_GET_TRANSPORTS:"/actions/gettransports/",ACTION_MAKE_CHANGE_TRANSPORTABLE:"/actions/make_changes_transportable/",ACTION_GET_TOKEN:"/actions/getcsrftoken/"};return{getTransports(e){if(r.getClient()){e["sap-client"]=r.getClient()}var n=t.getUrl(a.ACTION_GET_TRANSPORTS,{url:r.getLrepUrl()},e);n=decodeURIComponent(n);return t.sendRequest(n,"GET").then(function(e){if(e.response){e.response.localonly||=false;e.response.errorCode||="";return Promise.resolve(e.response)}return Promise.reject("response is empty")})},makeChangesTransportable(s){if(!s.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"))}if(!s.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"))}if(!s.reference){return Promise.reject(new Error("no reference provided as attribute of mParameters"))}var i=r.getClient()?{"sap-client":r.getClient()}:{};var o=t.getUrl(a.ACTION_MAKE_CHANGE_TRANSPORTABLE,{url:r.getLrepUrl()},i);var l=t.getUrl(a.ACTION_GET_TOKEN,{url:r.getLrepUrl()});var p=n.getRequestOptions(e,l,s,"application/json; charset=utf-8","json");return n.sendRequest(o,"POST",p)},convertToChangeTransportData(e,r){var t=[];var n;if(r&&r.length){for(n=0;n<r.length;n++){var a=r[n];var s={};s.namespace=a.getNamespace();s.fileName=a.getDefinition().fileName;s.fileType=a.getDefinition().fileType;t.push(s)}}var i=e.length;for(n=0;n<i;n++){var o=e[n];var l={};l.namespace=o.getNamespace();l.fileName=o.getId();l.fileType=o.getFileType();t.push(l)}return t}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/AppVariantWriteAPI", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/_internal/SaveAs","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/_internal/Versions"],function(e,r,t,i,a){"use strict";var n=function(r,i){if(!i.layer){return Promise.reject("Layer must be provided")}i.reference=e.getFlexReferenceForSelector(i.selector);i.url="/sap/bc/lrep";return t.appVariant[r](i)};var s={saveAs(t){if(!t.layer){return Promise.reject("Layer must be provided")}if(!t.id){return Promise.reject("App variant ID must be provided")}t.reference=e.getFlexReferenceForSelector(t.selector);return i.isVersioningEnabled(t.layer).then(function(e){if(e){t.parentVersion=a.getVersionsModel(t).getProperty("/displayedVersion")}return r.saveAs(t)})},deleteAppVariant(t){if(!t.layer){return Promise.reject("Layer must be provided")}t.id=e.getFlexReferenceForSelector(t.selector);return r.deleteAppVariant(t)},listAllAppVariants(e){if(!e.layer){return Promise.reject("Layer must be provided")}return n("list",e)},getManifest(e){if(!e.layer){return Promise.reject("Layer must be provided")}if(!e.appVarUrl){return Promise.reject("appVarUrl must be provided")}return t.appVariant.getManifest(e)},assignCatalogs(e){if(!e.layer){return Promise.reject("Layer must be provided")}if(!e.assignFromAppId){return Promise.reject("assignFromAppId must be provided")}if(!e.action){return Promise.reject("action must be provided")}return n("assignCatalogs",e)},unassignCatalogs(e){if(!e.layer){return Promise.reject("Layer must be provided")}if(!e.action){return Promise.reject("action must be provided")}return n("unassignCatalogs",e)}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ContextSharingAPI", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/variants/context/Component","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/core/ComponentContainer","sap/ui/fl/Layer","sap/ui/fl/registry/Settings"],function(e,t,n,r,a,o){"use strict";var i;var s={createComponent(s){if(s.layer!==a.CUSTOMER){return Promise.resolve()}var u=e.getFlexReferenceForControl(s.variantManagementControl);return o.getInstance().then(function(e){return e.isContextSharingEnabled()&&!n.adaptationExists({reference:u,layer:a.CUSTOMER})}).then(function(e){if(e){if(!i||i.bIsDestroyed){var n=new t("contextSharing");n.showMessageStrip(true);n.setSelectedContexts({role:[]});i=new r("contextSharingContainer",{component:n});return n.getRootControl().oAsyncState.promise.then(function(){return i})}return i}})}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/FieldExtensibility", ["sap/ui/fl/write/_internal/fieldExtensibility/ABAPAccess","sap/ui/fl/write/_internal/fieldExtensibility/cap/CAPAccess","sap/ui/base/ManagedObject","sap/ui/fl/Utils"],function(e,n,t,i){"use strict";var r={};var a;function s(r){if(!a){if(!(r instanceof t)){return undefined}var s=i.getAppComponentForControl(r);var o=s&&s.getManifestEntry("/sap.ui5/config")||{};var u=new URLSearchParams(window.location.search);if(o.experimentalCAPScenario||u.get("sap-ui-fl-xx-capScenario")==="true"){a=n}else{a=e}}return a}function o(...e){var n=e.shift();var t=s(...e);if(!t){return Promise.reject("Could not determine field extensibility scenario")}return Promise.resolve(t[n].apply(null,e))}r.onControlSelected=function(e){return o("onControlSelected",e)};r.isExtensibilityEnabled=function(e){return o("isExtensibilityEnabled",e)};r.isServiceOutdated=function(e){return o("isServiceOutdated",e)};r.setServiceValid=function(e){return o("setServiceValid",e)};r.getTexts=function(){return o("getTexts")};r.getExtensionData=function(){return o("getExtensionData")};r.onTriggerCreateExtensionData=function(e,n){return o("onTriggerCreateExtensionData",e,n)};r._resetCurrentScenario=function(){a=null};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/LocalResetAPI", ["sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/base/util/restricted/_union"],function(e,r,t,n,i,a,u){"use strict";var o={};function c(r,t,n){var i={includeDirtyChanges:true,layer:t};var u=a.getChangePersistenceForControl(r);return u.getAllUIChanges(i).filter(function(r){return r.getState()!==e.LifecycleState.DELETED&&r.getVariantReference()===(n||undefined)})}function s(e){var r=i.getAppComponentForControl(e);var t=[];var a=[];function o(r,n){var i=(n||[]).concat(r);if(r===e||t.includes(r)){t=u(t,i);return true}var c=r.getParent();if(a.includes(r)||!c){a=u(a,i);return false}return o(c,i)}function c(e){return e.getDependentSelectorList().map(function(e){return n.bySelector(e,r)}).filter(Boolean).some(function(e){return o(e)})}return c}o.resetChanges=function(e,a){var u=e.slice().reverse();var o=u.map(function(e){var r=n.bySelector(e.getSelector(),a);return function(){e.setQueuedForRevert();return t.revert({change:e,element:r})}});return r.remove({flexObjects:u,selector:a}).then(i.execPromiseQueueSequentially.bind(i,o))};o.restoreChanges=function(u,o){var c=u.map(function(r){return function(){r.restorePreviousState();var i=n.bySelector(r.getSelector(),o);if(r.getState()===e.LifecycleState.PERSISTED){var u=a.getChangePersistenceForControl(o);var c=u.getDirtyChanges();var s=c.indexOf(r);if(s>=0){c.splice(s,1)}}return t.apply({change:r,element:i,modifier:n})}});r.add({flexObjects:u,selector:o});return i.execPromiseQueueSequentially(c)};o.getNestedUIChangesForControl=function(e,r){var t=c(e,r.layer,r.currentVariant);var n=s(e);return t.filter(n)};o.isResetEnabled=function(e,r){var t=c(e,r.layer,r.currentVariant);var n=s(e);return t.some(n)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/PersistenceWriteAPI", ["sap/base/util/includes","sap/base/util/restricted/_omit","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/condenser/Condenser","sap/ui/fl/write/_internal/flexState/FlexObjectState","sap/ui/fl/write/_internal/Storage","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,r,t,n,a,s,o,i,l,c,u,g,f,h,p,d,C,y){"use strict";var v={};function b(r){return r._getMap&&e(s.getChangeTypes(),r._getMap().changeType)||r.getChangeType&&e(s.getChangeTypes(),r.getChangeType())}function m(e){e.includeCtrlVariants=true;e.invalidateCache=false;return v._getUIChanges(e).then(function(e){return e.length>0})}v.hasDirtyChanges=function(e){return c.hasDirtyFlexObjects(e)};v.hasHigherLayerChanges=function(e){e.upToLayer||=C.getCurrentLayer();return c.getFlexObjects(e).then(function(r){return r.filter(function(r){return C.isOverLayer(r.getLayer(),e.upToLayer)})}).then(function(e){return e.length>0})};v.save=function(e){return c.saveFlexObjects(e).then(function(r){if(r&&r.length!==0){return v.getResetAndPublishInfo(e).then(function(t){var n=f.get(e.selector)||{};f.set(Object.assign(n,t),e.selector);return r})}return r})};v.getResetAndPublishInfo=function(e){return Promise.all([m(e),g.isPublishAvailable()]).then(function(r){var n=r[0];var a=r[1];var s=e.layer!==d.USER&&e.layer!==d.PUBLIC;var o={isResetEnabled:n,isPublishEnabled:false,allContextsProvided:true};if(s){return u.getFlexInfo(e).then(function(e){o.allContextsProvided=e.allContextsProvided===undefined||e.allContextsProvided;o.isResetEnabled=e.isResetEnabled;o.isPublishEnabled=a&&e.isPublishEnabled;return o}).catch(function(e){t.error(`Sending request to flex/info route failed: ${e.message}`);return o})}return o})};v.getResetAndPublishInfoFromSession=function(e){var r=o.getFlexReferenceForControl(e)||"true";return JSON.parse(window.sessionStorage.getItem(`sap.ui.fl.info.${r}`))};v.reset=function(e){var r=y.getAppComponentForSelector(e.selector);var t=p.createForSelector(r);return t.resetChanges(e.layer,e.generator,r,e.selectorIds,e.changeTypes)};v.publish=function(e){e.styleClass||="";return h.getChangePersistenceForControl(y.getAppComponentForSelector(e.selector)).transportAllUIChanges({},e.styleClass,e.layer,e.appVariantDescriptors)};v.add=function(e){var r=y.getAppComponentForSelector(e.selector);var t=o.getFlexReferenceForSelector(e.selector);var n=h.getChangePersistenceForComponent(t);function a(e){if(b(e)){return e.store()}return n.addChange(e,r)}if(e.change&&e.flexObjects){throw new Error("Using 'flexObjects' and 'change' properties together not supported. Please use the 'flexObjects' property.")}if(e.change){return a(e.change)}var s=e.flexObjects.some(function(e){return b(e)});if(s){return e.flexObjects.map(a)}return n.addChanges(e.flexObjects,r)};v.remove=function(e){return Promise.resolve().then(function(){if(e.change&&e.flexObjects){return Promise.reject(new Error("Using 'flexObjects' and 'change' properties together not supported. Please use the 'flexObjects' property."))}if(!e.selector){return Promise.reject(new Error(`An invalid selector was passed so change could not be removed with id: ${e.change.getId()}`))}var r=y.getAppComponentForSelector(e.selector);if(!r){return Promise.reject(new Error(`Invalid application component for selector, change could not be removed with id: ${e.change.getId()}`))}var t=h.getChangePersistenceForControl(r);function s(e){var t=n.bySelector(e.getSelector(),r);if(t){a.destroyAppliedCustomData(t,e,n)}}if(e.change){if(!b(e.change)){s(e.change)}return t.deleteChange(e.change)}e.flexObjects.forEach(function(e){if(!b(e)){s(e)}});return t.deleteChanges(e.flexObjects)})};v.getChangesWarning=function(e){return this._getUIChanges(e).then(function(e){var r=e.some(function(e){return e.isChangeFromOtherSystem()});var t=i.getInstanceOrUndef();var n=t&&t.isProductiveSystemWithTransports();var a=e.length===0;var s={showWarning:false};if(r){s={showWarning:true,warningType:"mixedChangesWarning"}}if(n&&a){s={showWarning:true,warningType:"noChangesAndPSystemWarning"}}return s})};v._condense=function(e){return Promise.resolve().then(function(){if(!e.selector){throw Error("An invalid selector was passed")}var r=y.getAppComponentForSelector(e.selector);if(!r){throw Error("Invalid application component for selector")}if(!e.changes||e.changes&&!Array.isArray(e.changes)){throw Error("Invalid array of changes")}return l.condense(r,e.changes)})};v._getUIChanges=function(e){if(e.layer){e.currentLayer=e.layer}return c.getFlexObjects(e)};return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/ReloadInfoAPI", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/FlexInfoSession","sap/ui/fl/initial/api/Version","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils"],function(e,r,a,t,i,l,s,n,o,u){"use strict";var f={flp:{set(e,r,a){e[r]=[a];return e},get(e,r){return e[r]&&e[r][0]},remove(e,r){delete e[r];return e}},standalone:{set(e,r,a){return u.handleUrlParameters(e,r,a)},get(e,r){return u.getParameter(r)},remove(e,r,a){return u.handleUrlParameters(e,r,a)}}};function v(e){var r=!!u.getParameter(a.UrlParameter,e.URLParsingService);if(r){return Promise.resolve(false)}return i.isVersioningEnabled(e.layer).then(function(r){return r&&s.isDraftAvailable({control:e.selector,layer:e.layer})})}function m(e){var r=this.hasMaxLayerParameterWithValue({value:e.layer},e.URLParsingService);var a=e.layer===n.USER;if(a||r){return Promise.resolve(false)}return l.hasHigherLayerChanges({selector:e.selector,ignoreMaxLayerParameter:e.ignoreMaxLayerParameter,upToLayer:e.layer,includeCtrlVariants:e.includeCtrlVariants,includeDirtyChanges:true}).then(function(r){return r||c(e)})}function c(r){if(o.isOverLayer(n.USER,r.layer)){return t.checkSVMControlsForDirty(e.getFlexReferenceForControl(r.selector))}return false}function h(e){var a=r.get(e.selector);if(a&&a.initialAllContexts){return false}if(a===null||a.allContextsProvided===undefined){var t={selector:e.selector,layer:e.layer};return l.getResetAndPublishInfo(t).then(function(t){if(a===null||!a.initialAllContexts){t.initialAllContexts=true}r.set(t,e.selector);return!t.allContextsProvided})}a.initialAllContexts=true;r.set(a,e.selector);return!a.allContextsProvided}function P(e){var a=r.get(e);return a&&!a.allContextsProvided}function d(e){var a=r.get(e);return a&&a.isEndUserAdaptation===false}var A={getReloadReasonsForStart(e){return Promise.all([m.call(this,e),v(e),h(e)]).then(function(r){[e.hasHigherLayerChanges,e.isDraftAvailable,e.allContexts]=r;return e})},hasVersionParameterWithValue(e,r){return u.hasParameterAndValue(a.UrlParameter,e.value,r)},removeInfoSessionStorage(e){r.remove(e)},hasMaxLayerParameterWithValue(e,r){var a=o.FL_MAX_LAYER_PARAM;return u.hasParameterAndValue(a,e.value,r)},handleUrlParameters(e,t){var i=false;var l=r.get(e.selector)||{};if(!e.ignoreMaxLayerParameter&&e.hasHigherLayerChanges){e.parameters=f[t].remove(e.parameters,o.FL_MAX_LAYER_PARAM,e.layer);delete l.maxLayer;i=true}var s=f[t].get(e.parameters,a.UrlParameter);if(e.versionSwitch&&s!==e.version){e.parameters=f[t].remove(e.parameters,a.UrlParameter,s);e.parameters=f[t].set(e.parameters,a.UrlParameter,e.version);l.version=e.version;i=true}if(s&&e.removeVersionParameter||s===a.Number.Draft&&e.removeDraft){e.parameters=f[t].remove(e.parameters,a.UrlParameter,s);delete l.version;i=true}r.set(l,e.selector);return i},handleParametersOnStart(e,t){var i=false;var l=r.get(e.selector)||{};if(e.hasHigherLayerChanges){e.parameters=f[t].set(e.parameters,o.FL_MAX_LAYER_PARAM,e.layer);l.maxLayer=e.layer;i=true}if(e.isDraftAvailable){e.parameters=f[t].set(e.parameters,a.UrlParameter,a.Number.Draft);l.version=a.Number.Draft;i=true}r.set(l,e.selector);return i},initialDraftGotActivated(e){if(e.versioningEnabled){var r=this.hasVersionParameterWithValue({value:a.Number.Draft},e.URLParsingService);return!s.isDraftAvailable({control:e.selector,layer:e.layer})&&r}return false},getReloadMethod(e){var t={NOT_NEEDED:"NO_RELOAD",RELOAD_PAGE:"HARD_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION"};e.reloadMethod=t.NOT_NEEDED;e.isDraftAvailable||=A.hasVersionParameterWithValue({value:a.Number.Draft},e.URLParsingService);e.hasVersionUrlParameter=!!u.getParameter(a.UrlParameter,e.URLParsingService);if(e.activeVersion&&e.activeVersion!==a.Number.Original&&e.hasVersionUrlParameter){e.activeVersionNotSelected=!A.hasVersionParameterWithValue({value:e.activeVersion},e.URLParsingService)}e.hasHigherLayerChanges=A.hasMaxLayerParameterWithValue({value:e.layer},e.URLParsingService);e.initialDraftGotActivated=A.initialDraftGotActivated(e);if(e.initialDraftGotActivated){e.isDraftAvailable=false}e.allContexts=P(e.selector);e.switchEndUserAdaptation=d(e.selector);if(e.changesNeedReload||e.isDraftAvailable||e.hasHigherLayerChanges||e.initialDraftGotActivated||e.activeVersionNotSelected||e.allContexts||e.switchEndUserAdaptation){e.reloadMethod=t.RELOAD_PAGE;if(!e.changesNeedReload&&u.getUshellContainer()){e.reloadMethod=t.VIA_HASH}}r.remove(e.selector);return e}};return A});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/SmartBusinessWriteAPI", ["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/ui/fl/write/_internal/SaveAs","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI"],function(e,r,t,i,a,p,n){"use strict";function s(e,t){return r.getInstance().then(function(r){if(r.isAtoEnabled()){t.skipIam=true;t.transport="ATO_NOTIFICATION"}return a[e](t)})}function d(r){if(!r.appId){return Promise.reject("App Variant ID must be provided")}r.selector={appId:r.appId};r.id=e.getFlexReferenceForSelector(r.selector);r.isForSmartBusiness=true}var u={create(r){if(!r.layer){return Promise.reject("Layer must be provided")}if(!r.selector||!r.selector.appId){return Promise.reject("selector.appId must be provided")}if(!r.id){return Promise.reject("App variant ID must be provided")}r.reference=e.getFlexReferenceForSelector(r.selector);r.isForSmartBusiness=true;return s("saveAs",r)},update(e){d(e);return s("updateAppVariant",e)},remove(e){d(e);return s("deleteAppVariant",e)},getDesignTimeVariant(e){if(!e.id){return Promise.reject("App Variant ID must be provided")}return t.load(e)},getRunTimeVariant(e){if(!e.appId){return Promise.reject("Reference App ID must be provided")}if(!e.id){return Promise.reject("App Variant ID must be provided")}var r=`/sap/bc/lrep/content/apps/${e.appId}/appVariants/${e.id}/manifest.appdescr_variant`;return i.appVariant.getManifest({appVarUrl:r})},createDescriptorInlineChanges(e){if(!e.appId){return Promise.reject("appId must be provided")}if(!e.changeSpecificData){return Promise.reject("changeSpecificData must be provided")}e.selector={appId:e.appId};return p.create(e)},add(e){if(!e.appId){return Promise.reject("appId must be provided")}if(!e.change){return Promise.reject("Change instance must be provided")}e.selector={appId:e.appId};return n.add(e)}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/SmartVariantManagementWriteAPI", ["sap/ui/fl/apply/_internal/flexState/compVariants/Utils","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/transport/TransportSelection","sap/ui/fl/registry/Settings"],function(t,e,a,n,r,i){"use strict";function o(a,n){a.persistencyKey=t.getPersistencyKey(a.control);a.reference||=e.getFlexReferenceForControl(a.control);return n(a)}function c(t){var n=t.layer||t.changeSpecificData&&t.changeSpecificData.layer;if(n){t.changeSpecificData||={};t.reference||=e.getFlexReferenceForControl(t.control);var r={layer:n,control:t.control,reference:t.reference};if(a.hasAdaptationsModel(r)){t.changeSpecificData.adaptationId=a.getDisplayedAdaptationId(r)}}}var s={addVariant(t){c(t);return o(t,n.addVariant)},updateVariant(t){c(t);return o(t,n.updateVariant)},updateVariantContent(t){c(t);t.action=n.updateActionType.UPDATE;return o(t,n.updateVariant)},saveVariantContent(t){t.action=n.updateActionType.SAVE;return o(t,n.updateVariant)},discardVariantContent(t){t.action=n.updateActionType.DISCARD;return o(t,n.discardVariantContent)},updateVariantMetadata(t){c(t);t.action=n.updateActionType.UPDATE_METADATA;return o(t,n.updateVariant)},removeVariant(t){c(t);return o(t,n.removeVariant)},revert(t){return o(t,n.revert)},save(t){return o(t,n.persist)},setDefaultVariantId(t){c(t);return o(t,n.setDefault)},isVariantSharingEnabled(){return i.getInstance().then(function(t){return t.isVariantSharingEnabled()})},isVariantPersonalizationEnabled(){return i.getInstance().then(function(t){return t.isVariantPersonalizationEnabled()})},isVariantAdaptationEnabled(){return i.getInstance().then(function(t){return t.isVariantAdaptationEnabled()})},overrideStandardVariant(t){o(t,n.overrideStandardVariant)},revertSetDefaultVariantId(t){return o(t,n.revertSetDefaultVariantId)},_getTransportSelection(){function t(){var t=new URLSearchParams(window.location.search).get("sap-ui-layer")||"";return!!t}var e=new r;e.selectTransport=function(a,n,i,o,c,s){if(!t()){n(e._createEventObject(a,{transportId:""}));return}r.prototype.selectTransport.call(this,a,n,i,o,c,s)};return e}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/TranslationAPI", ["sap/ui/fl/write/_internal/flexState/FlexObjectState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/_internal/Storage","sap/base/util/isEmptyObject","sap/base/i18n/Localization","sap/ui/fl/Utils"],function(e,r,t,n,a,o){"use strict";var i={};i.hasTranslationRelevantDirtyChanges=function(r){return e.getDirtyFlexObjects(r).some(function(e){return!n(e.getTexts())})};i.getTexts=function(e){if(!e.selector){return Promise.reject("No selector was provided")}if(!e.sourceLanguage){return Promise.reject("No sourceLanguage was provided")}if(!e.targetLanguage){return Promise.reject("No targetLanguage was provided")}if(!e.layer){return Promise.reject("No layer was provided")}var n=o.getAppComponentForControl(e.selector);e.reference=r.getFlexReferenceForControl(n);return Promise.resolve().then(t.translation.getTexts.bind(undefined,e))};i.getSourceLanguages=function(e){if(!e.selector){return Promise.reject("No selector was provided")}if(!e.layer){return Promise.reject("No layer was provided")}var n=o.getAppComponentForControl(e.selector);e.reference=r.getFlexReferenceForControl(n);return t.translation.getSourceLanguages(e).then(function(r){var t=a.getLanguage();if(!r.includes(t)&&i.hasTranslationRelevantDirtyChanges(e)){r.push(t)}return r})};i.uploadTranslationTexts=function(e){if(!e.layer){return Promise.reject("No layer was provided")}if(!e.payload){return Promise.reject("No payload was provided")}return Promise.resolve().then(t.translation.postTranslationTexts.bind(undefined,e))};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/UI2PersonalizationWriteAPI", ["sap/ui/fl/write/_internal/flexState/UI2Personalization/UI2PersonalizationState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/base/util/restricted/_omit"],function(e,t,r,a){"use strict";var n={async create(n){n.reference=r.getFlexReferenceForSelector(n.selector);if(!n.reference||!n.containerKey||!n.itemName||!n.content||!n.category||!n.containerCategory){throw new Error("not all mandatory properties were provided for the storage of the personalization")}await t.initialize({componentId:n.selector.getId()});await e.setPersonalization(a(n,["selector"]))},async deletePersonalization(a){a.reference=r.getFlexReferenceForSelector(a.selector);if(!a.reference||!a.containerKey||!a.itemName){throw new Error("not all mandatory properties were provided for the deletion of the personalization")}await t.initialize({componentId:a.selector.getId()});await e.deletePersonalization(a.reference,a.containerKey,a.itemName)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/VersionsAPI", ["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/initial/api/Version","sap/ui/fl/write/_internal/Versions","sap/ui/fl/Utils","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/write/api/ContextBasedAdaptationsAPI"],function(e,r,t,n,o,i,a){"use strict";function l(e){var r=i.getFlexReferenceForControl(e);if(!r){throw Error("The application ID could not be determined")}return r}function s(e){if(!e.control){throw Error("No control was provided")}if(!e.layer){throw Error("No layer was provided")}var r=l(e.control);return t.getVersionsModel({nonNormalizedReference:r,reference:r,layer:e.layer})}function d(e){var r=l(e.control);var t=a.hasAdaptationsModel({layer:e.layer,reference:r});if(!e.adaptationId&&t){return a.refreshAdaptationModel(e)}else if(e.adaptationId&&t){var n=a.getAdaptationsModel(e);n.switchDisplayedAdaptation(e.adaptationId);return Promise.resolve(e.adaptationId)}return Promise.resolve()}var c={};c.initialize=function(e){if(!e.control){return Promise.reject("No control was provided")}if(!e.layer){return Promise.reject("No layer was provided")}var r=n.getAppComponentForControl(e.control);return t.initialize({reference:l(r),layer:e.layer})};c.clearInstances=function(){t.clearInstances()};c.isDraftAvailable=function(e){var t=s(e);var n=t.getProperty("/versions");var o=n.find(function(e){return e.version===r.Number.Draft});return!!o};c.isOldVersionDisplayed=function(e){var t=s(e);var n=t.getProperty("/displayedVersion");var o=t.getProperty("/activeVersion");return n!==r.Number.Draft&&n!==o};c.loadDraftForApplication=function(e){e.version=r.Number.Draft;return c.loadVersionForApplication(e)};c.loadVersionForApplication=function(t){if(!t.control){return Promise.reject("No control was provided")}if(!t.layer){return Promise.reject("No layer was provided")}var i=s(t);if(i){if(t.version===undefined){t.version=i.getProperty("/activeVersion")}i.setProperty("/displayedVersion",t.version);i.setProperty("/persistedVersion",t.version);if(t.version!==r.Number.Draft&&o.isPublishAvailable()){var a=i.getProperty("/versions");if(a.length){var c=a.find(function(e){return e.version===t.version});if(c){i.setProperty("/publishVersionEnabled",!c.isPublished)}}}}return d(t).then(function(r){var o=n.getAppComponentForControl(t.control);var i=l(o);return e.clearAndInitialize({componentId:o.getId(),reference:i,version:t.version,allContexts:t.allContexts,adaptationId:r})})};c.activate=function(e){if(!e.control){return Promise.reject("No control was provided")}if(!e.layer){return Promise.reject("No layer was provided")}if(!e.title){return Promise.reject("No version title was provided")}var r=l(e.control);return t.activate({nonNormalizedReference:r,reference:r,layer:e.layer,title:e.title,appComponent:n.getAppComponentForControl(e.control),displayedVersion:e.displayedVersion})};c.discardDraft=function(r){if(!r.control){return Promise.reject("No control was provided")}if(!r.layer){return Promise.reject("No layer was provided")}var o=n.getAppComponentForControl(r.control);var i=l(o);return t.discardDraft({nonNormalizedReference:i,reference:i,layer:r.layer}).then(function(t){if(t.backendChangesDiscarded){var n=a.hasAdaptationsModel({layer:r.layer,reference:i});if(n){return a.refreshAdaptationModel(r).then(function(r){return e.clearAndInitialize({componentId:o.getId(),reference:i,adaptationId:r}).then(function(){return t})})}return e.clearAndInitialize({componentId:o.getId(),reference:i}).then(function(){return t})}return t})};c.publish=function(e){if(!e.selector){return Promise.reject("No selector was provided")}if(!e.layer){return Promise.reject("No layer was provided")}if(!e.version){return Promise.reject("No version was provided")}e.styleClass||="";e.reference=l(e.selector);return t.publish(e)};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/connectors/FileListBaseConnector", ["sap/ui/fl/initial/_internal/StorageUtils","sap/base/util/LoaderExtensions"],function(e,t){"use strict";return{getFileList(){return Promise.reject("not implemented")},layers:[],loadFlexData(n){return this.getFileList(n.reference).then(function(n){return Promise.all(n.map(function(e){return t.loadResource({dataType:"json",url:e,async:true})})).then(function(t){var n=e.getGroupedFlexObjects(t);return e.filterAndSortResponses(n)})})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/api/connectors/ObjectStorageConnector", ["sap/base/strings/hash","sap/base/util/restricted/_uniqBy","sap/base/util/each","sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils"],function(e,t,r,n,a,i,s){"use strict";function o(e){var t=[];return s.forEachObjectInStorage(e,function(e){t.push(e.changeDefinition)}).then(function(){return t})}function c(e,t){var r=true;if(e.selectorIds){if(t.selector){r=e.selectorIds.indexOf(t.selector.id)>-1}else{r=false}}if(r&&e.changeTypes){r=e.changeTypes.indexOf(t.changeType)>-1}return r}function u(e,t){if(!e.creation){var r=Date.now()+t;e.creation=new Date(r).toISOString()}return e}function f(t){return e(t.reduce(function(e,t){return e+new Date(t.creation).getTime()},""))}function l(e,t){r(e,function(e,n){n.forEach(function(e){r(e,function(e,r){t(r,e)})})})}function g(e,t){var r=[];var n=0;l(e,function(e,a){var i=s.createFlexKey(a);var o=t.find(function(t){return t.getId()===e.fileName});if(!o.getCreation()){var c=Date.now()+n;n++;o.setCreation(new Date(c).toISOString())}r.push({key:i,value:o})});return r}function h(e,t){var r=[];l(e,function(e,n){var a=s.createFlexKey(n);var i;t.some(function(e){if(e.getId()===n){i=e;return true}});r.push({key:a,value:i})});return r}function v(e,t){var n=[];r(e,function(e,r){if(r.length<2){return}var a=t.filter(function(t){return t.getFileType()===e});a.forEach(function(e,t){if(r.indexOf(e.getId())>-1&&t<a.length-1){var i=a[t+1];var o=new Date(e.getCreation());var c=new Date(i.getCreation());if(i&&o>=c){var u=o.getTime()+1;i.setCreation(new Date(u).toISOString());var f=s.createFlexKey(i.getId());n.push({key:f,value:i})}}})});return n}function d(e){var t=[];if(e){Object.values(e).forEach(function(e){e.forEach(function(e){var r=s.createFlexKey(e);t.push(this.storage.removeItem(r))}.bind(this))}.bind(this))}return t}var b=n({},a,{storage:undefined,layers:["ALL"],loadFlexData(e){return o({storage:this.storage,reference:e.reference}).then(function(e){i.sortFlexObjects(e);var t=i.getGroupedFlexObjects(e);var r=i.filterAndSortResponses(t);if(r.length){r[0].cacheKey=f(e)}return r})},async write(e){let t=0;const r=[];for(const n of e.flexObjects){const e=s.createFlexObjectKey(n);const a=u(n,++t);const i=this.storage._itemsStoredAsObjects?a:JSON.stringify(a);await this.storage.setItem(e,i);r.push(a)}return{response:r}},update(e){var t=e.flexObject;var r=s.createFlexObjectKey(e.flexObject);var n=this.storage._itemsStoredAsObjects?t:JSON.stringify(t);var a=this.storage.setItem(r,n);return Promise.resolve(a)},reset(e){return s.forEachObjectInStorage({storage:this.storage,reference:e.reference,layer:e.layer},function(t){if(c(e,t.changeDefinition)){return Promise.resolve(this.storage.removeItem(t.key)).then(function(){return{fileName:t.changeDefinition&&t.changeDefinition.fileName}})}}.bind(this)).then(function(e){return{response:e.filter(function(e){return!!e})}})},remove(e){var t=s.createFlexObjectKey(e.flexObject);this.storage.removeItem(t);var r=this.storage.removeItem(t);return Promise.resolve(r)},loadFeatures(){return Promise.resolve({isKeyUser:true,isVariantSharingEnabled:true,isProductiveSystem:false,isCondensingEnabled:true,isContextSharingEnabled:false})},getFlexInfo(e){e.storage=this.storage;return s.getAllFlexObjects(e).then(function(e){return{isResetEnabled:e.length>0}})},condense(e){var r=e.flexObjects;var n=[];n=n.concat(g(r.create,e.condensedChanges));n=n.concat(h(r.update,e.condensedChanges));n=n.concat(v(r.reorder,e.condensedChanges));n=t(n,"key");var a=[];a=a.concat(d.call(this,r.delete));n.forEach(function(e){var t=e.value.convertToFileContent();var r=this.storage._itemsStoredAsObjects?t:JSON.stringify(t);a.push(this.storage.setItem(e.key,r))}.bind(this));return Promise.all(a)}});return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/fl/write/connectors/BaseConnector", [],function(){"use strict";var e={layers:[],write(){return Promise.reject("write is not implemented")},condense(){return Promise.reject("condense is not implemented")},update(){return Promise.reject("write is not implemented")},remove(){return Promise.reject("remove is not implemented")},reset(){return Promise.reject("reset is not implemented")},publish(){return Promise.reject("publish is not implemented")},getFlexInfo(){return Promise.resolve({})},getContexts(){return Promise.reject("getContexts is not implemented")},loadContextDescriptions(){return Promise.reject("loadContextDescriptions is not implemented")},isContextSharingEnabled(){return Promise.resolve(false)},loadFeatures(){return Promise.reject("loadFeatures is not implemented")},contextBasedAdaptation:{create(){return Promise.reject("contextBasedAdaptation.create is not implemented")},reorder(){return Promise.reject("contextBasedAdaptation.reorder is not implemented")},load(){return Promise.reject("contextBasedAdaptation.load is not implemented")},update(){return Promise.reject("contextBasedAdaptation.update is not implemented")},remove(){return Promise.reject("contextBasedAdaptation.remove is not implemented")}},versions:{load(){return Promise.reject("versions.load is not implemented")},activate(){return Promise.reject("versions.activate is not implemented")},discardDraft(){return Promise.reject("versions.discardDraft is not implemented")}},translation:{getSourceLanguages(){return Promise.reject("translation.getSourceLanguages is not implemented")},getTexts(){return Promise.reject("translation.getTexts is not implemented")},postTranslationTexts(){return Promise.reject("translation.postTranslationTexts is not implemented")}}};return e});
sap.ui.require.preload({
	"sap/ui/fl/variants/context/view/ContextVisibility.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.fl.variants.context.controller.ContextVisibility"\n\txmlns:mvc="sap.ui.core.mvc"\n\tdisplayBlock="true"\n\txmlns="sap.m"><Panel id="visibilityPanel"><headerToolbar><Toolbar id="visibilityToolbar"><Label id="visibilityToolbarLabel" labelFor="visibilityRadioButtonGroup" text="{i18n>RADIO_BUTTON_GROUP_LABEL}" design="Bold"  /></Toolbar></headerToolbar><content><MessageStrip\n\t\t\t\tid="visibilityMessageStrip"\n\t\t\t\ttext="{i18n>VISIBILITY}"\n\t\t\t\tvisible="{parts: [{path: \'selectedContexts>/selected\'}, {path: \'selectedContexts>/showMessageStrip\'} ], formatter: \'.isMessageStripVisible\'}"\n\t\t\t\ttype="Information"\n\t\t\t\tshowIcon="true"/><List\n\t\t\t\tid="selectedContextsList"\n\t\t\t\tnoDataText="{selectedContexts>/noDataText}"\n\t\t\t\tmode="Delete"\n\t\t\t\tdelete=".onDeleteContext"\n\t\t\t\tgrowing="true"\n\t\t\t\titems="{selectedContexts>/selected}"><headerToolbar><Toolbar style="Clear" id="restrictedToolbar"><Label labelFor="selectedContextsList" text="{i18n>SELECTED_CONTEXT_LIST_TITLE}" design="Bold" wrapping="true"/><ToolbarSpacer /><Button id="removeAllButton" text="{i18n>REMOVE_ALL_BUTTON}" press=".removeAll" enabled="{path: \'selectedContexts>/selected\', formatter: \'.isRemoveAllEnabled\'}"/><Button id="addContextsButton" ariaHasPopup="Dialog" text="{i18n>ADD_CONTEXTS_BUTTON}" press=".onAddContextsHandler"/></Toolbar></headerToolbar><StandardListItem\n\t\t\t\t\ttitle="{selectedContexts>id}"\n\t\t\t\t\ttooltip="{path: \'selectedContexts>description\', formatter: \'.formatTooltip\'}"/></List></content></Panel></mvc:View>',
	"sap/ui/fl/write/_internal/fieldExtensibility/cap/dialog/CustomFieldCAPDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:editor="sap.ui.integration.designtime.baseEditor"\n><Dialog\n\t\tclass="sapUiContentPadding"\n\t\ttitle="{i18n>CAP_ADD_FIELD_TITLE}"\n\t\tverticalScrolling="true"\n\t\tresizable="false"\n\t\tdraggable="true"\n\t\tcontentWidth="42rem"\n\t\tcontentHeight="80vh"\n\t><content><editor:BaseEditor layout="form" /></content><beginButton><Button\n\t\t\t\tenabled="{dialog>/isValid}"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{i18n>CAP_ADD_FIELD_CREATE}"\n\t\t\t\tpress="onSave"\n\t\t\t/></beginButton><endButton><Button\n\t\t\t\ttype="Transparent"\n\t\t\t\ttext="{i18n>CAP_ADD_FIELD_CANCEL}"\n\t\t\t\tpress="onCancel"\n\t\t\t/></endButton></Dialog></core:FragmentDefinition>\n',
	"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/booleanEditor/BooleanEditor.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n><CheckBox select="_onChange" /></core:FragmentDefinition>',
	"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/rangeEditor/RangeEditor.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:baseEditor="sap.ui.integration.designtime.baseEditor"\n><HBox><baseEditor:PropertyEditor\n\t\t\tinit="wrapperInit"\n\t\t\tconfig="{contentModel>/0/config}"\n\t\t\tvalue="{contentModel>/0/value}"\n\t\t\trenderLabel="false"\n\t\t\tvalueChange="_onChange"\n\t\t/><baseEditor:PropertyEditor\n\t\t\tinit="wrapperInit"\n\t\t\tconfig="{contentModel>/1/config}"\n\t\t\tvalue="{contentModel>/1/value}"\n\t\t\trenderLabel="false"\n\t\t\tvalueChange="_onChange"\n\t\t/></HBox></core:FragmentDefinition>',
	"sap/ui/fl/write/_internal/fieldExtensibility/cap/editor/propertyEditor/timeEditor/TimeEditor.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n><TimePicker\n\t\tvalue="{displayValue}"\n\t\tvalueFormat="HH:mm:ss.SSSS"\n\t\tchange="_onChange"\n\t/></core:FragmentDefinition>'
},"sap/ui/fl/library-preload-write");
//# sourceMappingURL=library-preload-write.js.map
