/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["../library","sap/ui/base/EventProvider","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/Configuration","sap/ui/core/Icon","./PaginatorRenderer"],function(t,e,i,n,a,s,r){"use strict";var o=i.getConfiguration().getAnimationMode(),d=o!==a.AnimationMode.none&&o!==a.AnimationMode.minimal,g=200,h=i.getLibraryResourceBundle("sap.m");var l=n.extend("sap.ui.integration.controls.Paginator",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},pageNumber:{type:"int",defaultValue:0},pageCount:{type:"int",defaultValue:0},pageSize:{type:"int",defaultValue:0},totalCount:{type:"int"},skip:{type:"int"}},aggregations:{_prevIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_nextIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{animationComplete:{}}},renderer:r});l.create=function(t,e){if(!e){return null}return new l({card:t,totalCount:e.totalCount,pageSize:e.pageSize,skip:e.skip,visible:e.visible})};l.prototype.init=function(){this._listUpdateFinishedHandler=this._listUpdateFinished.bind(this);this._dataChangedHandler=this._dataChanged.bind(this);this.setAggregation("_prevIcon",new s({src:"sap-icon://slim-arrow-left",useIconTooltip:false,decorative:false,tooltip:h.getText("PAGINGBUTTON_PREVIOUS"),press:this.previous.bind(this)}));this.setAggregation("_nextIcon",new s({src:"sap-icon://slim-arrow-right",useIconTooltip:false,decorative:false,tooltip:h.getText("PAGINGBUTTON_NEXT"),press:this.next.bind(this)}))};l.prototype.exit=function(){var t=this.getCard(),i,n;if(t){if(this._dataChangedHandler){t.detachEvent("_contentDataChange",this._dataChangedHandler)}i=t.getCardContent();if(i){n=i.getAggregation("_content");if(n&&e.hasListener(n,"updateFinished",this._listUpdateFinishedHandler)){n.detachEvent("updateFinished",this._listUpdateFinishedHandler)}}}delete this._listUpdateFinishedHandler;delete this._iPreviousStartIndex;delete this._oClonedContent};l.prototype.isServerSide=function(){return this.getTotalCount()};l.prototype._dataChanged=function(){var t=this.getCard(),i=t.getCardContent(),n,a,s;if(!i||!i.isA("sap.ui.integration.cards.BaseContent")||!i.hasData()){this.setPageCount(0);return}this.setModel(i.getModel());n=i.getAggregation("_content");s=e.hasListener(n,"updateFinished",this._listUpdateFinishedHandler);if(this._hasAnimation()&&!s){n.attachEvent("updateFinished",this._listUpdateFinishedHandler);if(this.isServerSide()){i.getAggregation("_loadingPlaceholder").addDelegate({onAfterRendering:this.onPlaceholderAfterRendering.bind(this)})}}if(s){this._clearAnimation(this)}a=this.getTotalCount()||i.getDataLength();this.setPageCount(Math.ceil(a/this.getPageSize()));this.setPageNumber(Math.min(Math.max(0,this.getPageNumber()),this._getLastPageNumber()));this.sliceData()};l.prototype.setCard=function(t){this.setProperty("card",t,true);if(t){t.attachEvent("_contentDataChange",this._dataChangedHandler)}return this};l.prototype.sliceData=function(){const t=this.getCard();if(!t){return}const e=this.getModel("paginator"),i=t.getCardContent(),n=t.getAggregation("_loadingProvider"),a=i.getAggregation("_loadingProvider"),s=this.getPageNumber()*this.getPageSize(),r=this._iPreviousStartIndex!==undefined&&this._iPreviousStartIndex!==s,o=this.isServerSide();e.setData({skip:s,size:this.getPageSize(),pageIndex:this.getPageNumber()});if(r){this._prepareAnimation(s)}if(o&&r){if(!e.getBindings().length){t.refreshAllData()}if(this._hasAnimation()){a.setAwaitPagination(true);n.setAwaitPagination(true)}}else if(!o&&i.isA("sap.ui.integration.cards.BaseContent")){i.sliceData(s,s+this.getPageSize())}this._iPreviousStartIndex=s};l.prototype.reset=function(){this.setPageNumber(0).sliceData()};l.prototype._prepareAnimation=function(t){if(!this._hasAnimation()||this._isSkeletonCard()){return}var e=this.getCard().getCardContent().getDomRef(),i=e.cloneNode(true);this._bActiveAnimation=true;this._bReverseAnimation=this._iPreviousStartIndex>t;i.removeAttribute("id");i.querySelectorAll("*[id]").forEach(function(t){t.removeAttribute("id")});i.classList.add("sapFCardContentCloned");if(this._bReverseAnimation){i.classList.add("sapFCardContentReverseAnim")}if(this.isServerSide()){this._oClonedContent=i}else{e.classList.add("sapFCardContentOriginal");if(this._bReverseAnimation){e.classList.add("sapFCardContentReverseAnim")}e.parentElement.insertBefore(i,e)}};l.prototype._clearAnimation=function(){if(!this._hasAnimation()||!this._bActiveAnimation||this._isSkeletonCard()){return}var t=this.getCard(),e=t.getCardContent(),i=e.getDomRef(),n=i.previousSibling,a,s;a=t.getAggregation("_loadingProvider");s=e.getAggregation("_loadingProvider");if(s.getAwaitPagination()){s.setAwaitPagination(false);a.setAwaitPagination(false)}else{if(n){n.parentNode.removeChild(n)}i.classList.remove("sapFCardContentOriginal");i.classList.remove("sapFCardContentTransition");i.classList.remove("sapFCardContentReverseAnim");e.hideLoadingPlaceholders();a.setLoading(false);this._bActiveAnimation=false}this.fireAnimationComplete()};l.prototype._listUpdateFinished=function(){if(!this._bActiveAnimation||this.isServerSide()||this._isSkeletonCard()){return}var t=this.getCard().getCardContent(),e=t.getDomRef(),i=e.previousSibling;if(!i){return}i.addEventListener("transitionend",function(){i.parentNode.removeChild(i);e.classList.remove("sapFCardContentOriginal");e.classList.remove("sapFCardContentTransition");e.classList.remove("sapFCardContentReverseAnim");this._bActiveAnimation=false}.bind(this));e.classList.add("sapFCardContentTransition");i.classList.add("sapFCardContentTransition")};l.prototype._isSkeletonCard=function(){return this.getCard().isSkeleton()};l.prototype.onPlaceholderAfterRendering=function(){if(!this._oClonedContent||this._isSkeletonCard()){return}var t=this.getCard(),e=t.getCardContent(),i=e.getDomRef(),n=this._oClonedContent;i.classList.add("sapFCardContentOriginal");i.parentElement.insertBefore(n,i);if(this._bReverseAnimation){i.classList.add("sapFCardContentReverseAnim")}this._oClonedContent.addEventListener("transitionend",function(){setTimeout(this._clearAnimation.bind(this),g)}.bind(this));this._oClonedContent=null;setTimeout(function(){n.classList.add("sapFCardContentTransition");i.classList.add("sapFCardContentTransition")},30)};l.prototype._getNavigationArrow=function(t){return this.getAggregation("_"+t+"Icon")};l.prototype._hasAnimation=function(){return d&&this.getCard().getCardContent().isA("sap.ui.integration.cards.ListContent")};l.prototype._hasActiveLoadingProvider=function(){var t=this.getCard();return t&&t.hasActiveLoadingProvider()};l.prototype.previous=function(){if(this._bActiveAnimation||this._hasActiveLoadingProvider()){return}this.setPageNumber(Math.max(0,this.getPageNumber()-1));this.sliceData()};l.prototype.next=function(){if(this._bActiveAnimation||this._hasActiveLoadingProvider()){return}this.setPageNumber(Math.min(this._getLastPageNumber(),this.getPageNumber()+1));this.sliceData()};l.prototype.onmousedown=function(t){var e=t.target,i=e.getAttribute("data-slide");if(i&&!e.classList.contains("sapMCrslActive")){this.setPageNumber(parseInt(i)-1);this.sliceData()}};l.prototype.getStaticConfiguration=function(){return{pageCount:this.getPageCount(),pageIndex:this.getPageNumber()}};l.prototype._getLastPageNumber=function(){return Math.max(0,this.getPageCount()-1)};return l});
//# sourceMappingURL=Paginator.js.map