//@ui5-bundle sap/ui/integration/designtime/library-preload.designtime.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/BaseEditor", ["sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/PropertyEditors","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding","sap/ui/integration/designtime/baseEditor/util/hasTag","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata","sap/ui/base/EventProvider","sap/ui/core/Control","sap/ui/model/resource/ResourceModel","sap/base/util/ObjectPath","sap/base/util/each","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_intersection","sap/base/util/restricted/_flatten","sap/base/util/restricted/_mergeWith","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/restricted/_union","sap/base/util/restricted/_isNil","sap/base/util/restricted/_castArray","sap/ui/model/json/JSONModel","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/integration/designtime/baseEditor/util/unset"],function(t,e,i,r,o,n,s,a,p,h,d,u,g,f,c,y,l,_,m,b,v,C,E,P,M,O,R,j,D){"use strict";var I="customProperty--";var S=h.extend("sap.ui.integration.designtime.baseEditor.BaseEditor",{metadata:{library:"sap.ui.integration",properties:{json:{type:"object"},config:{type:"object",defaultValue:{i18n:["sap/ui/integration/designtime/baseEditor/i18n/i18n.properties"]}},designtimeMetadata:{type:"object"},layout:{type:"string",defaultValue:"list"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}},events:{jsonChange:{parameters:{json:{type:"object"}}},designtimeMetadataChange:{parameters:{designtimeMetadata:{type:"object"}}},configChange:{parameters:{config:{type:"object"}}},propertyEditorsReady:{parameters:{propertyEditors:{type:"array"}}},validationErrorChange:{parameters:{hasError:{type:"boolean"}}}}},constructor:function(){this._oSetConfigPromise=Promise.resolve();this._mObservableConfig={};this._mPropertyEditors={};this._aCancelHandlers=[];this._oDataModel=this._createModel();this._oDesigntimeMetadataModel=this._createModel();this._bInitFinished=false;this._bValidatorsReady=false;this._setReady(false);h.prototype.constructor.apply(this,arguments);this._oDataModel.setData(this._prepareData(this.getJson()));this.attachJsonChange(function(t){var e=t.getParameter("json");this._oDataModel.setData(this._prepareData(e));this._checkReady()},this)},renderer:function(t,e){var i=e.getContent();t.openStart("div",e);t.openEnd();if(i.length){i.forEach(function(e){t.renderControl(e)})}else{e.getPropertyEditorsSync().forEach(function(e){t.renderControl(e)})}t.close("div")}});S.prototype.init=function(){};S.prototype.exit=function(){this._reset();this._oDataModel.destroy();this._oDesigntimeMetadataModel.destroy()};S.prototype._prepareData=function(t){var e=f(t);g(this._mObservableConfig,function(t,i){var r=i.path;if(r[0]==="/"){r=r.substr(1)}if(typeof u.get(r.split("/"),e)==="undefined"&&typeof i.defaultValue!=="undefined"){u.set(r.split("/"),f(i.defaultValue),e)}});return e};S.prototype.setJson=function(t){var e;if(typeof t==="string"){try{e=JSON.parse(t)}catch(t){j.error("sap.ui.integration.designtime.baseEditor.BaseEditor: invalid JSON string is specified")}}else if(y(t)){e=v({},t)}else{j.error("sap.ui.integration.designtime.baseEditor.BaseEditor: unsupported data type specified in setJson()")}if(e&&!c(this.getProperty("json"),e,100)){this.setProperty("json",e);this.fireJsonChange({json:e})}};S.prototype.setPreventInitialization=function(t){this._bPreventInitialization=t};S.prototype.setConfig=function(t,e){this._bIsDefaultConfig=e;t=t||{};this._oSetConfigPromise=this._oSetConfigPromise.then(this._registerPropertyEditorTypes.bind(this,t.propertyEditors)).then(this._setConfig.bind(this,t,e));return this._oSetConfigPromise};S.prototype._registerPropertyEditorTypes=function(t){e.deregisterAllTypes();return e.registerTypes(t||{})};S.prototype._setConfig=function(t,e,i){this._initValidators(t.validators||{});var r={propertyEditors:{},properties:{}};var o=B(r,t);if(this._oSpecificConfig){o=e?this._oSpecificConfig:A(o,this._oSpecificConfig,i)}o.i18n=E(o.i18n&&M(o.i18n),this.getMetadata().getProperty("config").getDefaultValue().i18n);this.setProperty("config",o,false);this.fireConfigChange({config:f(o)});this.initialize()};S.prototype.addConfig=function(t,e){this._bIsDefaultConfig=e;this._oSetConfigPromise=this._oSetConfigPromise.then(function(){t=B(this.getConfig(),t);return t.propertyEditors}.bind(this)).then(this._registerPropertyEditorTypes).then(function(i){this._setConfig(t,e,i)}.bind(this));return this._oSetConfigPromise};function B(t,e){var i=v({},t,e);i.i18n=[].concat(t.i18n||[],e.i18n||[]);return i}S.prototype._addSpecificConfig=function(t){var e;this._oSetConfigPromise=this._oSetConfigPromise.then(function(){this._oSpecificConfig=t;e=v({},this.getConfig());e.propertyEditors=V(e,t);return e.propertyEditors}.bind(this)).then(this._registerPropertyEditorTypes).then(function(t){this._setConfig(e,this._bIsDefaultConfig,t)}.bind(this));return this._oSetConfigPromise};function V(t,e){var i={};var r=t.propertyEditors||{};var o=e.propertyEditors||{};E(Object.keys(r),Object.keys(o)).forEach(function(t){i[t]=o[t]||r[t]});return i}function A(t,e,i){t.i18n=E(t.i18n,e.i18n);var r=Object.assign({},t,C(e,["properties","i18n","propertyEditors"]),C(t,["properties","i18n","propertyEditors"]));r.properties={};g(t.properties,function(o,n){var s=t.propertyEditors[n.type]&&t.propertyEditors[n.type].split("/").join(".");var a=s&&i[s].configMetadata;if(a&&e.properties[o]){g(n,function(t,i){var n;var s=a[t]&&a[t].mergeStrategy;if(s){if(s==="mostRestrictiveWins"){var p=a[t].mostRestrictiveValue||false;if(i===p){n=p}else{n=e.properties[o][t]}}else if(s==="intersection"){n=_(i,e.properties[o][t])}}else{n=i}r.properties[o]=r.properties[o]||{};r.properties[o][t]=n})}});return r}S.prototype.setDesigntimeMetadata=function(t,e){var i=f(t,15);if(!c(i,this.getDesigntimeMetadata())){this.setProperty("designtimeMetadata",i);this._oDesigntimeMetadataModel.setData(i);if(!e){this.fireDesigntimeMetadataChange({designtimeMetadata:this._formatExportedDesigntimeMetadata(i)})}}};S.prototype._formatExportedDesigntimeMetadata=function(t){var e={};var i=function(t,r){Object.keys(t).forEach(function(o){var n=t[o];if(o==="__value"){e[r.join("/")]=n}else if(y(n)){i(n,[].concat(r,o))}})};i(t||{},[]);return e};S.prototype._initValidators=function(t){i.deregisterAllValidators();i.registerValidators(t);i.ready().then(function(){this._bValidatorsReady=true;this._checkReady()}.bind(this))};S.prototype._reset=function(){this._bInitFinished=false;this._setReady(false);this._aCancelHandlers.forEach(function(t){t()});if(this._oI18nModel){this._oI18nModel.destroy();delete this._oI18nModel}if(this._oConfigObserver){this._oConfigObserver.destroy()}g(this._mPropertyEditors,function(t,e){e.forEach(function(e){this.deregisterPropertyEditor(e,t)},this)}.bind(this));if(this._oRootWrapper){this._oRootWrapper.destroy()}};S.prototype.initialize=function(){if(!this._bPreventInitialization){this._initialize()}};S.prototype._initialize=function(){this._reset();var t=this.getConfig();if(typeof this.getProperty("json")==="undefined"){this.attachEventOnce("jsonChange",this._initialize);return}if(t){this._oConfigObserver=new n;this._loadI18nBundles(t.i18n).then(function(e){this._oI18nModel=this._createI18nModel(e);this.setModel(this._oI18nModel,"i18n");this._oConfigObserver.addToIgnore(["template","itemLabel"]);this._oConfigObserver.setModel(this._oDataModel);this._oConfigObserver.setModel(this._oDesigntimeMetadataModel,"designtimeMetadata");this._oConfigObserver.setModel(this._oI18nModel,"i18n");var i=this._getContextPath();if(i){this._oConfigObserver.setModel(this._oDataModel,"context");this._oConfigObserver.setBindingContext(this._oDataModel.getContext(i),"context")}var r=o(t.properties,{i18n:this._oI18nModel});this._mObservableConfig=Object.assign(this._mObservableConfig,this._prepareConfig(r));this._oConfigObserver.setObject(this._mObservableConfig);this._oConfigObserver.attachChange(this._onConfigChange,this);var n=this.getContent();if(n.length===0||n.length===1&&n[0]===this._oRootWrapper){this.removeAllContent();this._createEditors(this._oConfigObserver.getObject())}this._bInitFinished=true;this._checkReady()}.bind(this))}};S.prototype._onConfigChange=function(t){var e=t.getParameter("changes").reduce(function(t,e){var i=f(e);i.path=i.path.split("/");i.propertyKey=i.path.shift();if(!t[i.propertyKey]){t[i.propertyKey]=[]}t[i.propertyKey].push(i);return t},{});var i=Object.keys(e).reduce(function(t,e){var i=(this.getPropertyEditorsByNameSync(e)||[]).map(function(t){return{editor:t,propertyName:e}});t=t.concat(i);return t}.bind(this),[]);var r=i.filter(function(t){return!this._oRootWrapper||!this._oRootWrapper._aEditorWrappers.includes(t.editor)}.bind(this));r.forEach(function(i){var r=i.propertyName;var o=t.getSource().getObject();var n=C(f(o[r]),"value");var s=false;var a=e[r]||[];a.forEach(function(t){if(t.path[0]==="value"){i.editor.setValue(t.value)}else{u.set(t.path,t.value,n);s=true}});if(s){i.editor.setConfig(n)}});if(r.length<i.length){var o=f(this._oRootWrapper.getConfig()).map(function(t){var i=e[t.__propertyName]||[];i.forEach(function(e){u.set(e.path,e.value,t)});return t});this._oRootWrapper.setConfig(o)}};S.prototype._createModel=function(){var t=new O;t.setDefaultBindingMode("OneWay");return t};S.prototype.getI18nProperty=function(t,e){if(this.getModel("i18n")){return this.getModel("i18n").getResourceBundle().getText(t,e)}return t};S.prototype._loadI18nBundles=function(t){return this._createPromise(function(e,i){Promise.all(t.map(function(t){return new Promise(function(e,i){R.create({url:sap.ui.require.toUrl(t),async:true}).then(e,i)})})).then(e,i)})};S.prototype._createI18nModel=function(t){var e=t.slice();var i=new d({bundle:e.shift()});i.setDefaultBindingMode("OneWay");e.forEach(function(t){i.enhance(t)});return i};S.prototype._prepareConfig=function(t){var e={};g(t,function(t,i){e[t]=Object.assign({},this._preparePropertyConfig(i),{__propertyName:t})}.bind(this));return e};S.prototype._preparePropertyConfig=function(t){var e=this._getContextPath();if(e&&!e.endsWith("/")){e=e+"/"}var i=t.path;if(!i.startsWith("/")&&e){i=e+i}return Object.assign({},t,{path:i,value:"{"+i+"}",designtime:"{designtimeMetadata>"+i+"}"})};S.prototype._createEditors=function(t){var e=u.get(["layout",this.getLayout()],this.getConfig());if(y(e)||Array.isArray(e)){e=o(e,{i18n:this._oI18nModel})}this._oRootWrapper=new r({config:Object.values(t),layout:this.getLayout(),layoutConfig:e});this.addContent(this._oRootWrapper);return Promise.all(Object.values(this._mPropertyEditors).reduce(function(t,e){return t.concat(e)},[]).map(function(t){return t.ready()})).then(this._checkReady.bind(this))};S.prototype._getRegistrationKey=function(t,e){if(typeof e!=="string"){if(t.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")&&!t.getConfig()&&!t.getBindingInfo("config")&&t.getPropertyName()){e=t.getPropertyName()}else{e=I+t.getId()}}return e};S.prototype._addCustomProperty=function(t,e){var i=Object.assign({},this._mObservableConfig);i[t]=this._preparePropertyConfig(e);this._mObservableConfig=i;this._oConfigObserver.setObject(i)};S.prototype._removeCustomProperty=function(t){var e=C(this._mObservableConfig,t);this._mObservableConfig=e;this._oConfigObserver.setObject(e)};S.prototype.registerPropertyEditor=function(t,e){e=this._getRegistrationKey(t,e);var i=Array.isArray(this._mPropertyEditors[e])?this._mPropertyEditors[e]:[];this._mPropertyEditors[e]=i.concat(t);if(e.startsWith(I)){this._addCustomProperty(e,t.getConfig())}var r=u.get([e],this._oConfigObserver.getObject()).value;t.setValue(r);t.attachValueChange(this._onValueChange,this);t.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);t.attachReady(this._checkReady,this);t.attachValidationErrorChange(function(){this.fireValidationErrorChange({hasError:this.hasError()})}.bind(this))};S.prototype.deregisterPropertyEditor=function(t,e){e=this._getRegistrationKey(t,e);var i=this._mPropertyEditors[e];if(e.startsWith(I)){this._removeCustomProperty(e)}t.detachValueChange(this._onValueChange,this);t.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);if(Array.isArray(i)){this._mPropertyEditors[e]=i.filter(function(e){return t!==e});if(this._mPropertyEditors[e].length===0){delete this._mPropertyEditors[e]}}};S.prototype._setReady=function(t){var e=this._bIsReady;this._bIsReady=t;if(e!==true&&t===true){this.firePropertyEditorsReady({propertyEditors:this.getPropertyEditorsSync()})}};S.prototype._checkReady=function(){var t=this.getContent().filter(function(t){return t.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||t.isA("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor")});t.forEach(function(t){if(!p.hasListener(t,"ready",this._checkReady,this)){t.attachReady(this._checkReady,this)}},this);var e=[].concat(t,this.getPropertyEditorsSync());var i=this._bInitFinished&&this._bValidatorsReady&&e.every(function(t){return t.isReady()});this._setReady(i)};S.prototype.isReady=function(){return this._bIsReady};S.prototype.ready=function(){return new Promise(function(t){if(this.isReady()){t()}else{this.attachEventOnce("propertyEditorsReady",t)}}.bind(this))};S.prototype.hasError=function(){return m(Object.values(this._mPropertyEditors||{})).some(function(t){return t.hasError()})};S.prototype._createPromise=function(e){var i=t(e);this._aCancelHandlers.push(i.cancel);var r=function(t,e){this._aCancelHandlers=this._aCancelHandlers.filter(function(e){return e!==t});return e}.bind(this,i.cancel);return i.promise.then(r,r)};S.prototype.getPropertyConfigByName=function(t){return C(u.get([t],this._oConfigObserver.getObject()),"value")};S.prototype.getPropertyEditorsByName=function(t){return new Promise(function(t){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",t)}else{t()}}.bind(this)).then(function(){return this.getPropertyEditorsByNameSync(t)}.bind(this))};S.prototype.getPropertyEditorsByNameSync=function(t){var e=this._mPropertyEditors[t];return Array.isArray(e)&&e.slice()||null};S.prototype.getPropertyEditorsByTag=function(t){return new Promise(function(t){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",t)}else{t()}}.bind(this)).then(function(){return this.getPropertyEditorsByTagSync(t)}.bind(this))};S.prototype.getConfigsByTag=function(t){var e=this.getConfig().properties;return Object.keys(e).filter(function(i){return s(e[i],t)}).map(function(t){return e[t]})};S.prototype.getPropertyEditorsByTagSync=function(t){return this.getPropertyEditorsSync().filter(function(e){return s(e.getConfig(),t)})};S.prototype.getPropertyEditorsSync=function(){return Object.values(this._mPropertyEditors).reduce(function(t,e){return t.concat(e)},[]).sort(function(t,e){return parseInt(t.getId().match(/\d+$/))-parseInt(e.getId().match(/\d+$/))})};S.prototype.getJson=function(){return v({},this.getProperty("json"))};S.prototype.getDesigntimeMetadata=function(){return v({},this.getProperty("designtimeMetadata"))};S.prototype._getContextPath=function(){var t=this.getConfig();var e=t&&t.context||null;if(e&&e[0]!=="/"){e="/"+e}return e};S.prototype._onValueChange=function(t){var e=t.getSource();var i=t.getParameter("path");var r=this.getJson()||{};var o=t.getParameter("value");if(i[0]==="/"){i=i.substr(1)}else{throw new Error("BaseEditor._onValueChange: unknown relative path - '"+i+"'")}var n=i.split("/");u.set(n,o,r);if(typeof o==="undefined"||c(o,e.getRuntimeConfig().defaultValue)||Array.isArray(o)&&o.length===0||y(o)&&l(o)){D(r,n)}this.setJson(r)};S.prototype._onDesigntimeMetadataChange=function(t){var e=t.getParameter("path");var i=this.getDesigntimeMetadata()||{};var r=t.getParameter("value");if(e[0]==="/"){e=e.substr(1)}else{throw new Error("BaseEditor._onDesigntimeMetadataChange: unknown relative path - '"+e+"'")}var o=e.split("/");u.set(o,r,i);a(i);this.setDesigntimeMetadata(i)};return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/PropertyEditor", ["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/escapeParameter","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/deepEqual"],function(t,e,i,r,o,n,a,s){"use strict";var p="config";var g="propertyName";var h=t.extend("sap.ui.integration.designtime.baseEditor.PropertyEditor",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{propertyName:{type:"string"},renderLabel:{type:"boolean"},value:{type:"any"},config:{type:"object"}},aggregations:{propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",multiple:false,visibility:"hidden"}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorChange:{parameters:{previousPropertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"},propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},propertyNameChange:{parameters:{previousPropertyName:{type:"string"},propertyName:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},init:{}}},_bEditorAutoDetect:false,_sCreatedBy:null,constructor:function(){t.prototype.constructor.apply(this,r(arguments,function(t,e){return e==="config"&&o.hasType(t.type)}));if(!this.getEditor()){this._bEditorAutoDetect=true}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(t){if(this._sCreatedBy){this._removePropertyEditor(t.getParameter("previousEditor"))}this._initPropertyEditor()});this.attachConfigChange(function(t){var e=t.getParameter("previousConfig");var i=t.getParameter("config");var r=this.getAggregation("propertyEditor");if(this._fnCancelInit||!r||!e||!i||e.type!==i.type||e.path!==i.path){this._removePropertyEditor(this.getEditor());this._initPropertyEditor()}else{r.setConfig(i);if(i.visible!==false&&e.visible===false){r.setValue(this.getValue())}}});this.attachPropertyNameChange(function(){if(this._sCreatedBy===g){this._removePropertyEditor(this.getEditor())}if(this._sCreatedBy!==p){this._initPropertyEditor()}});this._initPropertyEditor()},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("display","inline-block");t.style("width","100%");t.openEnd();t.renderControl(e.getAggregation("propertyEditor"));t.close("div")}}});h.prototype.init=function(){Promise.resolve().then(function(){this.fireInit()}.bind(this))};h.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"))};h.prototype._prepareConfig=function(t){var e=this.getEditor();var i=t.type&&e?(e.getConfig().propertyEditorConfigs||{})[t.type]:{};return n({},i,t)};h.prototype.setConfig=function(t){var e=this.getConfig();var i=t&&n({},{designtime:undefined},this._prepareConfig(t));if(!s(e,i)){this.setProperty("config",i);this.fireConfigChange({previousConfig:e,config:i})}};h.prototype.setPropertyName=function(t){var e=this.getPropertyName();if(e!==t){this.setProperty("propertyName",t);this.firePropertyNameChange({previousPropertyName:e,propertyName:t})}};h.prototype.setEditor=function(t){var e=this.getEditor();var i=typeof t==="string"?sap.ui.getCore().byId(t):t;if(e!==i){this.setAssociation("editor",t);var i=this.getEditor();this.fireEditorChange({previousEditor:e,editor:i});this.setConfig(this.getConfig())}};h.prototype.destroy=function(){this._removePropertyEditor(this.getEditor());t.prototype.destroy.apply(this,arguments)};h.prototype._cleanupCancelledInit=function(t){t.destroy()};h.prototype._removePropertyEditor=function(t){var e=this.getAggregation("propertyEditor");if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit}if(e){this.setAggregation("propertyEditor",null);e.detachReady(this._onPropertyEditorReady,this);e.detachValidationErrorChange(this._onPropertyEditorError,this);e.destroy();this._sCreatedBy=null;this.firePropertyEditorChange({propertyEditor:null})}if(t&&this._mConfig&&this._isAbsolutePath(this._mConfig.path)){t.deregisterPropertyEditor(this,this._mConfig.__propertyName)}};h.prototype.isReady=function(){var t=this.getAggregation("propertyEditor");return t&&t.isReady()||false};h.prototype.hasError=function(){var t=this.getAggregation("propertyEditor");return t&&t.hasError()};h.prototype.ready=function(){return new Promise(function(t){var e=function(e){e.ready().then(t)};var i=this.getAggregation("propertyEditor");if(i){e(i)}else{var r=function(t){var i=t.getParameter("propertyEditor");if(i){this.detachPropertyEditorChange(r,this);e(i)}};this.attachPropertyEditorChange(r,this)}}.bind(this))};h.prototype._onPropertyEditorReady=function(){this.fireReady()};h.prototype._onPropertyEditorError=function(t){this.fireValidationErrorChange({hasError:t.getParameter("hasError")})};h.prototype._initPropertyEditor=function(){if(!this.getEditor()){return}if(this.getConfig()||!this.getBindingInfo("config")&&this.getPropertyName()&&this.getEditor()){if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit}this._mConfig=this.getConfig()||this.getEditor().getPropertyConfigByName(this.getPropertyName());var t=this.getConfig()?p:g;var e=i(function(t,e){o.create(this._mConfig.type).then(t).catch(e)}.bind(this));this._fnCancelInit=e.cancel;if(this._isAbsolutePath(this._mConfig.path)){this.getEditor().registerPropertyEditor(this,this._mConfig.__propertyName)}e.promise.then(function(e){e.setModel(this.getEditor().getModel("i18n"),"i18n");e.setConfig(a(n({},this._mConfig),"__propertyName"));e.attachBeforeValueChange(function(t){this.fireBeforeValueChange(a(t.getParameters(),"id"))},this);e.attachValueChange(function(t){this.setValue(t.getParameter("value"));this.fireValueChange(a(t.getParameters(),"id"))},this);e.attachDesigntimeMetadataChange(function(t){this.fireDesigntimeMetadataChange(a(t.getParameters(),"id"))},this);e.setValue(this.getValue(),true);this._sCreatedBy=t;this.setAggregation("propertyEditor",e);var i=this.getRenderLabel();if(i!==undefined){e.setRenderLabel(i)}e.attachReady(this._onPropertyEditorReady,this);if(e.isReady()){this.fireReady()}e.attachValidationErrorChange(this._onPropertyEditorError,this);if(e.hasError()){this.fireValidationErrorChange({hasError:true})}this.firePropertyEditorChange({propertyEditor:e});delete this._fnCancelInit}.bind(this))}};h.prototype._isAbsolutePath=function(t){return t&&t.startsWith("/")};h.prototype._propagationListener=function(){var t=e(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(t){this.setEditor(t);this.removePropagationListener(this._propagationListener)}};h.prototype.setParent=function(i){t.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var r=e(i,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(r){this.setEditor(r)}else{this.addPropagationListener(this._propagationListener)}}};h.prototype.setRenderLabel=function(t){this.setProperty("renderLabel",t);var e=this.getAggregation("propertyEditor");if(e){e.setRenderLabel(t)}};h.prototype.getContent=function(){var t=this.getAggregation("propertyEditor");return t&&t.getContent()};h.prototype.setValue=function(t){this.setProperty("value",t);var e=this.getAggregation("propertyEditor");if(e){e.setValue(t,true)}};h.prototype.getRuntimeConfig=function(){return this._mConfig};h.prototype.enhanceAccessibilityState=function(t,e){var i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(this,e)}};h.prototype.getFocusDomRef=function(){var t=this.getAggregation("propertyEditor");if(t){return t.getFocusDomRef()}};h.prototype.getIdForLabel=function(){var t=this.getAggregation("propertyEditor");if(t){return t.getIdForLabel()}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/PropertyEditors", ["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/isTemplate","sap/ui/integration/designtime/baseEditor/util/StylesheetManager","sap/base/util/restricted/_intersection","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/base/ManagedObjectObserver"],function(t,e,i,r,o,s,a,n,p,h,d,u){"use strict";var y="config";var g="tags";var f={list:{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{responsiveGridLayout:{labelSpanXL:12,labelSpanL:12,labelSpanM:12,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false}}},form:{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{}}};var l=t.extend("sap.ui.integration.designtime.baseEditor.PropertyEditors",{metadata:{library:"sap.ui.integration",properties:{tags:{type:"string"},renderLabels:{type:"boolean"},config:{type:"array"},layout:{type:"string",defaultValue:"list"},layoutConfig:{type:"object"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor",visibility:"hidden"}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorsChange:{parameters:{previousPropertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"}}},init:{},configChange:{parameters:{previousConfig:{type:"array"},config:{type:"array"}}},tagsChange:{parameters:{previousTags:{type:"string"},tags:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},layoutChange:{parameters:{previousLayout:{type:"string"},layout:{type:"string"}}},layoutConfigChange:{parameters:{previousLayoutConfig:{type:"object"},layoutConfig:{type:"object"}}}}},_bEditorAutoDetect:false,_sCreatedBy:null,_bLayoutReady:false,constructor:function(){this._iExpectedWrapperCount=0;this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;t.prototype.constructor.apply(this,arguments);var e=new d;this.setModel(e);if(!this.getEditor()){this._bEditorAutoDetect=true}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(){if(this._sCreatedBy){this._removePropertyEditors()}this._initPropertyEditors()});this.attachConfigChange(function(t){var e=t.getParameter("previousConfig");var i=t.getParameter("config");if(this._fnCancelInit||this._sCreatedBy===g||!Array.isArray(e)||!Array.isArray(i)||e.length!==i.length){this._removePropertyEditors();this._initPropertyEditors()}else if(this._sCreatedBy){this._evaluateViewRecreation(e,i)}});this.attachTagsChange(function(){if(this._sCreatedBy===g){this._removePropertyEditors()}if(this._sCreatedBy!==y){this._initPropertyEditors()}});if(this.getMetadata().getProperty("layout").getDefaultValue()===this.getLayout()){this._initLayout(this.getLayout())}},renderer:function(t,e){t.openStart("div",e);t.openEnd();t.renderControl(e.getContent());t.close("div")}});l.prototype.init=function(){this.attachLayoutChange(function(t){var e=t.getParameter("previousLayout");this._removeStylesheet(this._getLayoutPath(e));var i=t.getParameter("layout");this._initLayout(i)},this);this.attachLayoutConfigChange(function(){if(this._sCreatedBy){this._removePropertyEditors()}this._initPropertyEditors()},this);Promise.resolve().then(function(){this._bInitFinished=true;this.fireInit()}.bind(this))};l.prototype.destroy=function(){this._bInitFinished=false;this._setReady(false);if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading()}this._removeStylesheet(this._getLayoutPath(this.getLayout()));t.prototype.destroy.apply(this,arguments)};l.prototype._loadFragment=function(t){return h.load({name:t,controller:this})};l.prototype._loadModule=function(t){return new Promise(function(e,i){sap.ui.require([t],e,i)})};l.prototype._loadStylesheet=function(t){this._bCssRequested=true;return o.add(t)};l.prototype._removeStylesheet=function(t){if(this._bCssRequested){o.remove(t);delete this._bCssRequested}};l.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"))};l.prototype.setConfig=function(t){var e=this.getConfig();if(!Array.isArray(e)||!Array.isArray(t)||JSON.stringify(e)!==JSON.stringify(t)){var i=p(t);this.setProperty("config",i);this.fireConfigChange({previousConfig:e,config:i})}};l.prototype.setTags=function(t){var e=this.getTags();var i=t;if(typeof t==="string"){i=t.split(",").sort().join(",")}if(e!==i){this.setProperty("tags",i);this.fireTagsChange({previousTags:e,tags:i})}};l.prototype.setEditor=function(t){var e=this.getEditor();var i=typeof t==="string"?sap.ui.getCore().byId(t):t;if(e!==i){this.setAssociation("editor",t);var i=this.getEditor();this.fireEditorChange({previousEditor:e,editor:i})}};l.prototype._removePropertyEditors=function(){var t=this.removeAllAssociation("propertyEditors").map(function(t){return sap.ui.getCore().byId(t)});this._iExpectedWrapperCount=0;this.getModel().setData({});this._sCreatedBy=null;if(t.length){this.firePropertyEditorsChange({previousPropertyEditors:t,propertyEditors:[]})}};l.prototype._initPropertyEditors=function(){if(this.getEditor()&&(this.getConfig()||!this.getBindingInfo("config")&&this.getTags())&&this._bLayoutReady){var t=this.getEditor();var e;if(this.getConfig()){e=this.getConfig();this._sCreatedBy=y}else{var i=this.getTags().split(",");e=t.getConfigsByTag(i);this._sCreatedBy=g}var r=(this._getPropertyEditors()||[]).slice();this._updateViewModel(e);this.ready().then(function(){this.firePropertyEditorsChange({previousPropertyEditors:r,propertyEditors:(this._getPropertyEditors()||[]).slice()})}.bind(this))}this._checkReadyState()};l.prototype._propagationListener=function(){var t=e(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(t){this.setEditor(t);this.removePropagationListener(this._propagationListener)}};l.prototype.setParent=function(i){t.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var r=e(i,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(r){this.setEditor(r)}else{this.addPropagationListener(this._propagationListener)}}};l.prototype.setLayout=function(t){var e=this.getLayout();if(e!==t){this.setProperty("layout",t);this.fireLayoutChange({previousLayout:e,layout:t})}};l.prototype.setLayoutConfig=function(t){var e=this.getLayoutConfig();if(!n(e,t)){this.setProperty("layoutConfig",t);this.fireLayoutConfigChange({previousLayoutConfig:e,layoutConfig:t})}};l.prototype._getLayoutConfig=function(){var t=this.getLayoutConfig();var e=this.getRenderLabels();var i;if(typeof e==="boolean"){i={renderLabels:e}}var r=f[this.getLayout()]&&f[this.getLayout()].defaultConfig||{};return Object.assign({},r,t,i)};l.prototype._getLayoutPath=function(t){return f.hasOwnProperty(t)?f[t].module:t};l.prototype._initLayout=function(t){this.destroyContent();var e=this._getLayoutPath(t);this._bLayoutReady=false;if(this._sCreatedBy){this._removePropertyEditors()}if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading()}var r=i(function(t,i){this._loadStylesheet(e);Promise.all([this._loadFragment(e),this._loadModule(e)]).then(t,i)}.bind(this));r.promise.then(function(t){delete this._fnCancelLayoutLoading;var e=t[0];var i=t[1];this._prepareData=i.prepareData;this._aUpdateDependencies=i.updateDependencies||[];this.setContent(e);this._bLayoutReady=true;this._initPropertyEditors()}.bind(this));this._fnCancelLayoutLoading=r.cancel};l.prototype._evaluateViewRecreation=function(t,e){var i=this._getPropertyEditors()||[];if(t.length!==e.length||e.length!==i.length||e.some(function(e,i){return this._aUpdateDependencies.some(function(r){return t[i][r]!==e[r]})}.bind(this))){this._updateViewModel(e)}else{i.map(function(t,i){var r=e[i];t.setConfig(a(p(r),"value"));if(r.hasOwnProperty("value")){t.setValue(r.value)}})}};l.prototype._updateViewModel=function(t){var e=this._prepareData(t,this._getLayoutConfig());this._iExpectedWrapperCount=e.count;if(this._iExpectedWrapperCount>0){this._checkReadyState()}this.getModel().setData(e)};l.prototype.ready=function(){return new Promise(function(t){if(this.isReady()){t()}else{this.attachEventOnce("ready",t)}}.bind(this))};l.prototype.isReady=function(){return!!this._bIsReady};l.prototype.hasError=function(){return this._aEditorWrappers.some(function(t){return t.hasError()})};l.prototype._setReady=function(t){var e=this._bIsReady;this._bIsReady=t;if(e!==true&&t===true){this.fireReady()}};l.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel()}if(!this._bInitFinished){this._setReady(false);return}if(!this._bLayoutReady){this._setReady(false);return}if(this._iExpectedWrapperCount===0){this._setReady(true);return}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(t){return t.isReady()})){this._setReady(true)}else{this._setReady(false);this._mWrapperReadyCheck=i(function(t){Promise.all(this._aEditorWrappers.map(function(t){return t.ready()})).then(t)}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck}.bind(this))}}else{this._setReady(false)}};l.prototype.wrapperInit=function(t){var e=t.getSource();if(r(e,this)){return}if(!e.getEditor()){e.setEditor(this.getEditor())}this._aEditorWrappers.push(e);this.addAssociation("propertyEditors",e);e.attachReady(function(){this._setReady(false);this._checkReadyState()}.bind(this));e.attachValidationErrorChange(function(){this.fireValidationErrorChange({hasError:this.hasError()})}.bind(this));if(!this._oWrapperObserver){this._oWrapperObserver=new u(function(t){this._aEditorWrappers=this._aEditorWrappers.filter(function(e){return e!==t.object});this.removeAssociation("propertyEditors",t.object)}.bind(this))}this._oWrapperObserver.observe(e,{destroy:true});this._checkReadyState()};l.prototype._getPropertyEditors=function(){var t=(this.getAssociation("propertyEditors")||[]).map(function(t){return sap.ui.getCore().byId(t)});return t.length&&t||null};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/layout/Form", ["sap/ui/integration/designtime/baseEditor/util/hasTag","sap/base/util/restricted/_omit"],function(e,n){"use strict";var a={labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false};function r(e){return{label:e.label,value:e.value,config:n(e,["label","value"])}}function i(n,a){var r=[];var i=0;while(i<n.length){var t=n[i];if(e(t,a)){r.push(t);n.splice(i,1)}else{i++}}return r}function t(e,n){var a=e.findIndex(function(e){return e.__propertyName===n});if(a>-1){return e.splice(a,1)[0]}}function l(e){return e.some(function(e){return typeof e.config.visible==="boolean"?e.config.visible:true})}function u(e,u){u=u||{};var s=e.slice();var o=u.groups||[];var c=u.responsiveGridLayout||a;var p=u.renderLabels!==false;var f={responsiveGridLayout:c};if(!p){s=s.map(function(e){return n(e,"label")})}if(o.length>0){f.groups=o.map(function(e){var n=[];e.items.forEach(function(e){switch(e.type){case"tag":n=n.concat(i(s,e.value).map(function(e){return r(e)}));break;case"propertyName":var a=t(s,e.value);if(a){n=n.concat(r(a))}break}});return{label:e.label,items:n,visible:l(n)}})}else{var v=s.splice(0,s.length).map(r);f.groups=[{items:v,visible:l(v)}]}f.groups=f.groups.filter(function(e){return e.items.length>0});f.count=e.length-s.length;return f}return{prepareData:u,updateDependencies:["visible","tags"]}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor", ["sap/ui/core/Control","./../util/isTemplate","sap/ui/model/json/JSONModel","sap/m/Label","sap/ui/core/Fragment","sap/base/util/restricted/_omit","sap/ui/base/ManagedObjectObserver","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/base/util/restricted/_CancelablePromise","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/isPlainObject","sap/base/util/each","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata"],function(t,e,i,r,a,n,s,o,p,u,h,g,l,f,d,c,y){"use strict";var m=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{renderLabel:{type:"boolean",defaultValue:true},value:{type:"any"},config:{type:"object"}},aggregations:{_label:{type:"sap.m.Label",visibility:"hidden",multiple:false},content:{type:"sap.ui.core.Control",multiple:false}},events:{beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},fragmentChange:{parameters:{previousFragment:{type:"string"},fragment:{type:"string"}}},ready:{},init:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}}}},xmlFragment:null,_currentXmlFragment:null,_bFragmentReady:false,constructor:function(){this._iExpectedWrapperCount=0;this._currentXmlFragment=this.xmlFragment;t.prototype.constructor.apply(this,arguments);this._oDefaultModel=new i({value:this.getValue(),config:this.getConfig(),displayValue:this._formatValue(this.getValue())});this._oDefaultModel.setDefaultBindingMode("OneWay");this.setBindingContext(this._oDefaultModel.getContext("/"));this.setModel(this._oDefaultModel);this.bindProperty("visible","config/visible");this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;this.attachBeforeValueChange(function(t){this._iExpectedWrapperCount=this.getExpectedWrapperCount(t.getParameter("nextValue"))},this);this.attachValueChange(function(t){var e=t.getParameter("value");this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{value:e,displayValue:this._formatValue(e)}));this._checkReadyState()},this);this.attachConfigChange(function(t){var e=t.getParameter("previousConfig");var i=t.getParameter("config");if(e&&i&&!g(e.validators,i.validators)){this._validate(this.getValue())}this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{config:i}))},this);this.asyncInit().then(function(){this._bInitFinished=true;this.fireInit();this._checkReadyState()}.bind(this));if(this.getFragment()){this._initFragment(this.getFragment())}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("display","inline-block");t.style("width","100%");t.openEnd();if(e.getRenderLabel()&&e.getLabel()){t.openStart("div");t.openEnd();t.renderControl(e.getLabel());t.close("div")}t.renderControl(e.getContent());t.close("div")}}});m.prototype.init=function(){this.attachFragmentChange(function(t){if(this.getContent()){this.getContent().destroy()}var e=t.getParameter("fragment");this._initFragment(e)},this)};m.prototype.asyncInit=function(){return Promise.resolve()};m.prototype.onFragmentReady=function(){};m.prototype.setValue=function(t,e){var i=this.getValue();var r=this.getConfig()||{};var a=t;if(r.type==="integer"&&Number.isInteger(Number(t))){a=parseInt(t)}if(r.visible===false){return}if(typeof a==="undefined"&&typeof r.defaultValue!=="undefined"){a=h(r.defaultValue)}this._validate(a,function(t){if((t||e)&&!g(a,i)){this.fireBeforeValueChange({path:r.path,value:i,nextValue:a});this.setProperty("value",a);this.fireValueChange({path:r.path,previousValue:i,value:a})}this.setHasOwnError(!t)}.bind(this))};m.prototype.setDesigntimeMetadata=function(t){var e=this.getDesigntimeMetadata();var i=t;y(i);var r=this.getConfig();if(!g(e,i)){this.fireDesigntimeMetadataChange({path:r.path,previousValue:e,value:i})}};m.prototype.getDesigntimeMetadata=function(){return(this.getConfig()||{}).designtime||{}};m.prototype.setDesigntimeMetadataValue=function(t){this.setDesigntimeMetadata(Object.assign({},this.getConfig().designtime,{__value:t}))};m.prototype.getNestedDesigntimeMetadata=function(t){var e=(this.getConfig()||{}).designtime||{};return e[t]};m.prototype.getNestedDesigntimeMetadataValue=function(t){return(this.getNestedDesigntimeMetadata(t)||{}).__value||{}};m.prototype.getDesigntimeMetadataValue=function(){var t=(this.getConfig()||{}).designtime||{};return t.__value||{}};m.prototype._getValidators=function(){var t=this.getConfig().validators||{};return Object.values(Object.assign({},this.getDefaultValidators(),t)).filter(function(t){return t.isEnabled!==false})};m.prototype.getDefaultValidators=function(){return{}};m.prototype._validate=function(t,e){var i=[];var r=this._getValidators();r=r.map(function(t){var e=d.hasValidator(t.type)?d.getValidator(t.type):this.getDefaultValidatorModules()[t.type];if(!e){throw new Error("Unknown validator: "+t.type)}var i={};var r=t.errorMessage||e.errorMessage;var a=[];var n=r;if(l(r)){a=r.placeholders(t.config);n=r.message}Object.keys(t.config||{}).forEach(function(e){var r=t.config[e];if(typeof r==="function"){r=r(this)}i[e]=r}.bind(this));return{validator:e,config:i,errorMessage:this.getI18nProperty(n,a),type:t.type}}.bind(this));var a=function(){var t=i.length===0;this.setInputState(!t,i[0]);if(typeof e==="function"){e(t)}}.bind(this);r.forEach(function(e){if(!e.validator.validate(t,e.config)){i.push(e.errorMessage)}});a()};m.prototype.setInputState=function(t,e){this._sErrorMessage=t&&e;if(this.isReady()){this._setInputState()}};m.prototype._setInputState=function(){var t=this.getContent();if(!t||!t.setValueState){return}var e=this._sErrorMessage;if(e){t.setValueState("Error");t.setValueStateText(e)}else{t.setValueState("None")}};m.prototype.getDefaultValidatorModules=function(){return c};m.prototype._formatValue=function(t){return this.formatValue(h(t))};m.prototype.formatValue=function(t){return t};m.prototype.getExpectedWrapperCount=function(){return 0};m.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel()}if(!this._bInitFinished){this._setReady(false);return}if(!this._bFragmentReady){this._setReady(false);return}if(this._iExpectedWrapperCount===0){this._setReady(true);return}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(t){return t.isReady()})){this._setReady(true)}else{this._setReady(false);this._mWrapperReadyCheck=p(function(t){Promise.all(this._aEditorWrappers.map(function(t){return t.ready()})).then(t)}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck}.bind(this))}}else{this._setReady(false)}};m.prototype.wrapperInit=function(t){if(!this._oWrapperObserver){this._oWrapperObserver=new s(function(t){var i=t.object;switch(t.type){case"destroy":this._aEditorWrappers=this._aEditorWrappers.filter(function(t){return t!==i});this._checkReadyState();this._checkForError();break;case"parent":b(i).forEach(function(t){if(!e(t,this)){this._registerWrapper(t)}else{_(this._oWrapperObserver,t)}}.bind(this));this._oWrapperObserver.unobserve(i);break;default:return}}.bind(this))}var i=t.getSource();if(e(i,this)){_(this._oWrapperObserver,i);return}this._registerWrapper(i)};function _(t,e){var i=v(e);if(!t.isObserved(i,{parent:true})){t.observe(i,{parent:true})}}function v(t){var e=t.getParent();return e?v(e):t}function b(t){return C(t)?[t]:t.findAggregatedObjects(true,function(t){return C(t)})}function C(t){return t.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||t.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")}m.prototype._registerWrapper=function(t){this._aEditorWrappers.push(t);t.attachReady(function(t){this._setReady(false);this._checkReadyState()}.bind(this));t.attachValidationErrorChange(this._checkForError.bind(this));if(t.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")){t.attachPropertyEditorChange(function(t){var e=t.getParameter("propertyEditor");if(!e){this._setReady(false)}},this)}this._oWrapperObserver.observe(t,{destroy:true});this._checkReadyState()};m.prototype._setReady=function(t){var e=this._bIsReady;this._bIsReady=t;if(e!==true&&t===true){this.fireReady()}};m.prototype.isReady=function(){return!!this._bIsReady};m.prototype.setHasOwnError=function(t){this._bHasOwnError=t;this._checkForError()};m.prototype._checkForError=function(){var t=this.hasError();if(t!==this._bHasError){this._bHasError=t;this.fireValidationErrorChange({hasError:t})}};m.prototype.hasError=function(){return!!this._bHasOwnError||this._aEditorWrappers.some(function(t){return t.hasError()})};m.prototype.ready=function(){return new Promise(function(t){if(this.isReady()){t()}else{this.attachEventOnce("ready",t)}}.bind(this))};m.prototype.setFragment=function(t,e){if(this._currentXmlFragment!==t){var i=this._currentXmlFragment;this._currentXmlFragment=t;if(typeof e==="function"){this.getExpectedWrapperCount=e}this.fireFragmentChange({previousFragment:i,fragment:t})}};m.prototype.getFragment=function(){return this._currentXmlFragment};m.prototype._initFragment=function(t){this._setReady(false);this._bFragmentReady=false;if(this._oFragmentPromise){this._oFragmentPromise.cancel()}var e=new u(function(e,i,r){r.shouldReject=false;this._loadFragment(t).then(e,i)}.bind(this));this._oFragmentPromise=e;return e.then(function(t){if(e.isCanceled){t.destroy();return}this._bFragmentReady=true;this.setContent(t);this.onFragmentReady();this._setInputState();this._checkReadyState()}.bind(this))};m.prototype._loadFragment=function(t){return a.load({name:t,controller:this})};m.prototype.clone=function(){this.destroyContent();return t.prototype.clone.apply(this,arguments)};m.prototype.exit=function(){this._oDefaultModel.destroy();if(this._oConfigBinding){this._oConfigBinding.destroy()}if(this._oWrapperObserver){this._oWrapperObserver.destroy()}if(this._oFragmentPromise){this._oFragmentPromise.cancel()}};m.configMetadata={visible:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.FALLBACK_TYPE"}};m.prototype.setConfig=function(t){var e=this.getConfig();var i={};var r=o.getByClassName(this.getMetadata().getName()).configMetadata;f(r,function(t,e){i[t]=e.defaultValue});var a=Object.assign({},i,t);a=this.onBeforeConfigChange(a);if(!g(e,a)){this.setProperty("config",a);this.fireConfigChange({previousConfig:e,config:a})}};m.prototype.onBeforeConfigChange=function(t){return t};m.prototype.getI18nProperty=function(t,e){if(this.getModel("i18n")){return this.getModel("i18n").getResourceBundle().getText(t,e)}return t};m.prototype.getLabel=function(){var t=this.getAggregation("_label");if(!t){t=new r({text:"{config/label}",design:"Bold"});this.setAggregation("_label",t)}return t};m.prototype.enhanceAccessibilityState=function(t,e){var i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(this,e)}};m.prototype.getFocusDomRef=function(){var t=this.getContent();if(t&&t.isA("sap.ui.core.IFormContent")){return t.getFocusDomRef()}};m.prototype.getIdForLabel=function(){var t=this.getContent();if(t&&t.isA("sap.ui.core.IFormContent")){return t.getIdForLabel()}};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory", [],function(){"use strict";var e={};var t={};var n={};e.registerTypes=function(e){Object.keys(e).forEach(function(r){if(!t[r]){t[r]=new Promise(function(t,n){sap.ui.require([e[r]],t,n)}).then(function(e){n[e.getMetadata().getName()]=e;return e})}});return Promise.all(Object.values(t)).then(function(){return n})};e.deregisterType=function(e){if(t[e]){delete t[e]}};e.deregisterAllTypes=function(){t={}};e.create=function(e){return new Promise(function(n,r){if(!e){r("No editor type was specified in the property configuration.");return}if(!t[e]){r("Editor type was not registered");return}t[e].then(function(e){return n(new e)}).catch(function(e){return r(e)})})};e.getByClassName=function(e){return n[e]};e.getTypes=function(){return Object.assign({},t)};e.hasType=function(t){return Object.keys(e.getTypes()).includes(t)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/arrayEditor/ArrayEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/ObjectPath","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/unset","sap/base/util/restricted/_isNil","sap/base/strings/formatMessage","sap/base/util/isEmptyObject"],function(e,t,a,i,r,s,n,o,l,p,u){"use strict";var g=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditor",metadata:{library:"sap.ui.integration",properties:{value:{type:"any"}}},renderer:e.getMetadata().getRenderer().render});g.configMetadata=Object.assign({},e.configMetadata,{allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},collapsibleItems:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},showItemLabel:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},template:{defaultValue:{}},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.ARRAY"}});g.prototype.init=function(){e.prototype.init.apply(this,arguments);this._itemsModel=new r;this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel")};g.prototype.setValue=function(t){t=Array.isArray(t)?t:[];e.prototype.setValue.call(this,t);this._handleValueChange(this.getValue())};g.prototype._handleValueChange=function(e){var a=this.getConfig();var o=[];(e||[]).forEach(function(l,u){var g=t(l);var d=this.getNestedDesigntimeMetadata(u);var h={itemLabel:a.itemLabel||this.getI18nProperty("BASE_EDITOR.ARRAY.ITEM_LABEL"),index:u,total:e.length,properties:Object.keys(a.template).map(function(r){var n=a.template[r];var o=u+"/"+n.path;var l=i.get(o.split("/"),e);if(typeof l==="undefined"){i.set(n.path.split("/"),t(n.defaultValue),g)}return s({},n,{path:o,value:l,designtime:(d||{})[r]})},this)};var m=new r(g);h.properties=n(h.properties,{"":m},{"":m.getContext("/")},["template","value","itemLabel"]);h.itemLabel=n({itemLabel:h.itemLabel},{"":m},{"":m.getContext("/")}).itemLabel||p(this.getI18nProperty("BASE_EDITOR.ARRAY.NEW_ITEM_LABEL"),[a.addItemLabel||this.getI18nProperty("BASE_EDITOR.ARRAY.ITEM_LABEL")]);m.destroy();o.push(h)},this);this._itemsModel.setData(o)};g.prototype.onBeforeConfigChange=function(e){if(!e.collapsibleItems){this.setFragment("sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditorPlain")}return e};g.prototype.getExpectedWrapperCount=function(e){return e.length};g.prototype._removeItem=function(e){var t=e.getSource().data("index");var a=(this.getValue()||[]).slice();a.splice(t,1);this.setValue(a)};g.prototype._addItem=function(){var e=this.getConfig();var t=(this.getValue()||[]).slice();var a={};Object.keys(e.template).forEach(function(t){var i=e.template[t];if(i.type==="array"){a[t]=[]}});t.push(a);this.setValue(t)};g.prototype._moveUp=function(e){var t=e.getSource().data("index");if(t>0){var a=this.getValue().slice();var i=a.splice(t,1)[0];a.splice(t-1,0,i);this.setValue(a)}};g.prototype._moveDown=function(e){var t=e.getSource().data("index");var a=this.getValue().slice();if(t<a.length-1){var i=a.splice(t,1)[0];a.splice(t+1,0,i);this.setValue(a)}};g.prototype._propertyEditorsChange=function(e){e.getParameter("previousPropertyEditors").forEach(function(e){e.detachValueChange(this._onPropertyValueChange,this);e.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this)},this);e.getParameter("propertyEditors").forEach(function(e){e.attachValueChange(this._onPropertyValueChange,this);e.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this)},this)};g.prototype._onPropertyValueChange=function(e){var r=e.getSource();var s=t(this.getValue()||[]);var n=e.getParameter("path");var l=n.split("/");var p=e.getParameter("value");i.set(l,p,s);if(typeof p==="undefined"||a(p,r.getConfig().defaultValue)){o(s,l,l.length-2)}this.setValue(s)};g.prototype._onDesigntimeMetadataChange=function(e){var t={};i.set(e.getParameter("path").split("/"),e.getParameter("value"),t);this.setDesigntimeMetadata(s({},this.getDesigntimeMetadata(),t));this.setValue(this.getValue())};g.prototype._isNewItem=function(e){return(e&&e.properties||[]).every(function(e){var t=e.value;return l(t)||Array.isArray(t)&&t.length===0||u(t)})};g.prototype.formatAddItemText=function(e,t,a){return p(e,[t||a])};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/booleanEditor/BooleanEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor"],function(e){"use strict";var t=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.booleanEditor.BooleanEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.booleanEditor.BooleanEditor",metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer().render});t.prototype.getDefaultValidators=function(){var t=this.getConfig();return Object.assign({},e.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:t.allowBindings},notABinding:{type:"notABinding",isEnabled:!t.allowBindings},isBoolean:{type:"isBoolean"}})};t.prototype._onChange=function(){var e=this.getContent();var t=e.getSelectedKey()||e.getValue();if(t==="false"){t=false}else if(t==="true"){t=true}this.setValue(t)};t.configMetadata=Object.assign({},e.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.BOOLEAN"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/codeEditor/CodeEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/Fragment"],function(BasePropertyEditor,Fragment){"use strict";function json2str(t){if(!t){return""}var e=Array.isArray(t);var o=[];var i=function(t){if(typeof t==="object"&&t!==null){return json2str(t)}if(typeof t==="function"){return t.toString().replaceAll("\t","")}if(typeof t==="string"){return'"'+t+'"'}return t};for(var r in t){var n=i(t[r]);if(!e){n='"'+r+'": '+n}o.push(n)}var a=o.join(",");if(e){a="["+a+"]"}else{a="{"+a+"}"}return a}var CodeEditor=BasePropertyEditor.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.codeEditor.CodeEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.codeEditor.CodeEditor",metadata:{library:"sap.ui.integration"},renderer:BasePropertyEditor.getMetadata().getRenderer().render});CodeEditor.configMetadata=Object.assign({},BasePropertyEditor.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.OBJECT"}});CodeEditor.prototype.setConfig=function(t){BasePropertyEditor.prototype.setConfig.apply(this,arguments);this._sCodeType=this.getConfig().codeType?this.getConfig().codeType:"json"};CodeEditor.prototype._onLiveChange=function(){var t=this.getContent();if(this._sCodeType==="json"){var e=this._parseJson(t.getValue());if(e instanceof Error){t.setValueState("Error");t.setValueStateText("Error: "+e)}else{t.setValueState("None");this.setValue(e)}}};CodeEditor.prototype._parseJson=function(t){try{var e=JSON.parse(t);return e}catch(t){return t}};CodeEditor.prototype.formatValue=function(t){t=json2str(t);return t};CodeEditor.prototype._openCodeEditor=function(){if(this._oDialog){this._oDialog.destroy()}return Fragment.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.codeEditor.CodeEditorDialog",controller:this}).then(function(t){this._oDialog=t;this._oEditor=this._oDialog.getContent()[0];this._oEditor.getInternalEditorInstance().getSession().on("changeAnnotation",this.onChangeAnnotation.bind(this));this._oDialog.attachAfterOpen(function(){this._oEditor.getInternalEditorInstance().focus();this._oEditor.getInternalEditorInstance().navigateFileEnd()},this);this.addDependent(this._oDialog);this._openDialog();return this._oDialog}.bind(this))};CodeEditor.prototype._openDialog=function(){var t=this.getContent().getValue();try{var e=JSON.stringify(JSON.parse(t),0,"\t");this._oEditor.setValue(e)}catch(e){this._oEditor.setValue(t)}this._oDialog.open();this._oEditor.prettyPrint()};CodeEditor.prototype.onClose=function(){this._oCode=null;this._oDialog.close()};CodeEditor.prototype.onBeautify=function(){try{var t=JSON.stringify(JSON.parse(this._oEditor.getValue()),0,"\t");this._oEditor.setValue(t)}catch(t){this._oEditor.prettyPrint()}};CodeEditor.prototype.onChangeAnnotation=function(){if(!this._oDialog.isOpen()){return}var t=(this._oEditor.getInternalEditorInstance().getSession().getAnnotations()||[]).filter(function(t){return t.type==="error"});if(t.length>0){this._oDialog.getBeginButton().setEnabled(false)}else{var e=this._oEditor.getInternalEditorInstance().getValue();if(e&&e!==""){this._oCode=e}else{this._oCode=undefined}this._oDialog.getBeginButton().setEnabled(true)}};CodeEditor.prototype.onSave=function(){var oInput=this.getContent();if(this._oCode&&this._oCode!==""){oInput.setValueState("None");if(this._oCode&&this._oCode!==""){this._oCode=eval("("+this._oCode+")")}}else{this._oCode=undefined}this.setValue(this._oCode);this._oDialog.close()};return CodeEditor});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/format/DateFormat"],function(t,e){"use strict";var r=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.dateEditor.DateEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.dateEditor.DateEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});r.prototype.getDefaultValidators=function(){var e=this.getConfig();return Object.assign({},t.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:e.allowBindings},notABinding:{type:"notABinding",isEnabled:!e.allowBindings},isDate:{type:"isDate",config:{formatterInstance:function(){var t=(this.getConfig()||{}).pattern;var e=t?{pattern:t}:undefined;return this.getFormatterInstance(e)}.bind(this)}}})};r.prototype.formatValue=function(t){var e=this._parse(t);return this._format(e,true)||t};r.configMetadata=Object.assign({},t.configMetadata,{allowBindings:{defaultValue:true},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.DATE"},pattern:{defaultValue:"YYYY-MM-dd'T'HH:mm:ss.SSS'Z'"},utc:{defaultValue:false}});r.prototype.onFragmentReady=function(){var t=this.getContent();t.onkeypress=function(t){if(!t.charCode||t.metaKey||t.ctrlKey){return}}};r.prototype._onChange=function(t){var e=t.getParameter("newValue");var r=this._parse(e,true);var a=this._format(r)||e;this.setValue(a)};r.prototype._parse=function(t,e){if(t==null||t===""){return t}var r=(this.getConfig()||{}).utc!==false;if(e){return this.getFormatterInstance().parse(t,r)}var a=(this.getConfig()||{}).pattern;if(a){var n=this.getFormatterInstance({pattern:a});return n.parse(t,r)}return undefined};r.prototype._format=function(t,e){if(!this._isValidDate(t)){return undefined}var r=(this.getConfig()||{}).utc!==false;if(e){return this.getFormatterInstance().format(t,r)}var a=(this.getConfig()||{}).pattern;if(a){var n=this.getFormatterInstance({pattern:a});return n.format(t,r)}return undefined};r.prototype._isValidDate=function(t){return t&&!isNaN(t.getTime())};r.prototype.getFormatterInstance=function(t){return e.getDateInstance(t||{pattern:"YYYY-MM-dd"})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","sap/ui/core/format/DateFormat"],function(t,e,r){"use strict";var i=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.dateTimeEditor.DateTimeEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.dateTimeEditor.DateTimeEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});i.prototype.getFormatterInstance=function(t){return r.getDateTimeInstance(t||{pattern:"YYYY-MM-dd'T'HH:mm:ss.SSSSZ"})};i.configMetadata=Object.assign({},e.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.DATETIME"},utc:{defaultValue:true}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor"],function(e){"use strict";var t=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.enumStringEditor.EnumStringEditor",{metadata:{library:"sap.ui.integration",deprecated:true},xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.enumStringEditor.EnumStringEditor",renderer:e.getMetadata().getRenderer().render});t.configMetadata=Object.assign({},e.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});t.prototype.getDefaultValidators=function(){var t=this.getConfig();return Object.assign({},e.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:t.allowBindings},notABinding:{type:"notABinding",isEnabled:!t.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(e){return e.getConfig().enum}},isEnabled:!t.allowCustomValues}})};t.prototype._onChange=function(){var e=this.getContent();var t=e.getSelectedKey();var i=e.getValue();this.setValue(t||i)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/groupEditor/GroupEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.groupEditor.GroupEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.groupEditor.GroupEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});i.configMetadata=Object.assign({},t.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.GROUP"}});i.prototype.getDefaultValidators=function(){var e=this.getConfig();return Object.assign({},t.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:e.allowBindings},notABinding:{type:"notABinding",isEnabled:!e.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof e.maxLength==="number",config:{maxLength:e.maxLength}}})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/ListItem","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/core/IconPool","sap/ui/base/BindingParser","./IsInIconPool.validator"],function(t,e,o,i,a,n,r,s,l){"use strict";var d=null;var g=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});g.configMetadata=Object.assign({},t.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.SIMPLEICON"}});g.prototype.onFragmentReady=function(){var t=this.getContent();this._oIconModel=this._getIconModel();t.setModel(this._oIconModel,"icons");t.bindAggregation("suggestionItems","icons>/",new e({text:"{icons>path}",additionalText:"{icons>name}"}))};g.prototype._getIconModel=function(){if(!d){d=new i(r.getIconNames().map(function(t){return{name:t,path:"sap-icon://"+t}}))}return d};g.prototype._onChange=function(t){var e=t.getParameter("value");this.setValue(e)};g.prototype._onSuggestionItemSelected=function(t){this.setValue(t.getParameter("selectedItem").getText())};g.prototype._getDefaultSearchValue=function(t){try{var e=s.complexParser(t);return e?"":t}catch(e){return t}};g.prototype._handleValueHelp=function(t){var e=t.getSource().getValue();if(!this._oDialog){return o.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditorDialog",controller:this}).then(function(t){this._oDialog=t;this.addDependent(this._oDialog);this._oDialog.setModel(this._oIconModel);this._filter(e);this._oDialog.open(this._getDefaultSearchValue(e));return this._oDialog}.bind(this))}else{this._filter(e);this._oDialog.open(this._getDefaultSearchValue(e));return Promise.resolve(this._oDialog)}};g.prototype.handleSearch=function(t){var e=t.getParameter("value");this._filter(e)};g.prototype._filter=function(t){var e=new a("path",n.Contains,t);var o=this._oDialog.getBinding("items");o.filter([e])};g.prototype.handleClose=function(t){var e=t.getParameter("selectedItem");if(e){this.setValue(e.getIcon())}t.getSource().getBinding("items").filter([])};g.prototype.getDefaultValidators=function(){return Object.assign({},t.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding"},isInIconPool:{type:"isInIconPool"}})};g.prototype.getDefaultValidatorModules=function(){return Object.assign({},t.prototype.getDefaultValidatorModules.apply(this,arguments),{isInIconPool:l})};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IsInIconPool.validator", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil","sap/ui/core/IconPool"],function(i,e,a){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_AN_ICON",validate:function(n){return e(n)||typeof n==="string"&&a.isIconURI(n)&&!!a.getIconInfo(n)||i.validate(n,{allowPlainStrings:false})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","sap/ui/core/format/NumberFormat"],function(t,e,r){"use strict";var i=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.integerEditor.IntegerEditor",{invalidInputError:"BASE_EDITOR.INTEGER.INVALID_BINDING_OR_INTEGER",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});i.prototype.getDefaultValidators=function(){return Object.assign({},t.prototype.getDefaultValidators.call(this),{isInteger:{type:"isInteger"}})};i.configMetadata=Object.assign({},e.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.INTEGER"}});i.prototype.validateNumber=function(t){return e.prototype.validateNumber.call(this,t)&&Number.isInteger(t)};i.prototype.getFormatterInstance=function(){return r.getIntegerInstance()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/Fragment"],function(t,e){"use strict";var o=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditor",metadata:{library:"sap.ui.integration"},_onLiveChange:function(){var t=this.getContent();var e=this._parseJson(t.getValue());if(e instanceof Error){this.setHasOwnError(true);t.setValueState("Error");t.setValueStateText("Error: "+e)}else{t.setValueState("None");this.setValue(e)}},_parseJson:function(t){try{var e=JSON.parse(t);return e}catch(t){return t}},_openJsonEditor:function(){if(!this._oDialog){return e.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditorDialog",controller:this}).then(function(t){this._oDialog=t;this._oErrorMsg=this._oDialog.getContent()[0];this._oEditor=this._oDialog.getContent()[1];this._oEditor.getInternalEditorInstance().getSession().on("changeAnnotation",this.onShowError.bind(this));this._oDialog.attachAfterOpen(function(){this._oEditor.getInternalEditorInstance().focus();this._oEditor.getInternalEditorInstance().navigateFileEnd()},this);this._oDialog.attachAfterClose(function(){this._oDialog.close();this._oDialog.destroy();this._oDialog=null},this);this.addDependent(this._oDialog);this._openDialog();return this._oDialog}.bind(this))}else{this._openDialog();return Promise.resolve(this._oDialog)}},_openDialog:function(){var t=this.getContent().getValue();try{var e=JSON.stringify(JSON.parse(t),0,"\t");this._oEditor.setValue(e)}catch(e){this._oEditor.setValue(t)}this._oDialog.open()},onClose:function(){this._oCode=null;this._oDialog.close()},onBeautify:function(){try{var t=JSON.stringify(JSON.parse(this._oEditor.getValue()),0,"\t");this._oEditor.setValue(t)}catch(t){}},onLiveChange:function(t){try{this._oCode=JSON.parse(t.getParameter("value"));this._oDialog.getBeginButton().setEnabled(true)}catch(t){this._oDialog.getBeginButton().setEnabled(false)}},onShowError:function(){var t=(this._oEditor.getInternalEditorInstance().getSession().getAnnotations()||[]).map(function(t){return"Line "+String(t.row)+": "+t.text}).join("\n");this._oErrorMsg.setText(t);this._oErrorMsg.setVisible(!!t)},onSave:function(){var t=this.getContent();if(this._oCode){this.setValue(this._oCode);t.setValueState("None");t.setValue(JSON.stringify(this._oCode))}this._oDialog.close()},renderer:t.getMetadata().getRenderer().render});o.configMetadata=Object.assign({},t.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.JSON"}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.listEditor.ListEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.listEditor.ListEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});i.prototype.onFragmentReady=function(){this.attachValueChange(function(){this.getContent().setValue("")}.bind(this))};i.prototype.getDefaultValidators=function(){return Object.assign({},t.prototype.getDefaultValidators.call(this),{isUniqueList:{type:"isUniqueList"},isStringList:{type:"isStringList"}})};i.configMetadata=Object.assign({},t.configMetadata);i.prototype._onTokenUpdate=function(t){this._setTokens(t.getParameter("addedTokens").map(function(t){return t.getText()}),t.getParameter("removedTokens").map(function(t){return t.getText()}))};i.prototype._onTokenSubmission=function(t){this._setTokens([t.getParameter("value")],[])};i.prototype._onLiveChange=function(t){var e=t.getParameter("newValue");this._validateInput(e)};i.prototype._setTokens=function(t,e){var i=(this.getValue()||[]).filter(function(t){return e.indexOf(t)<0});var n=i.concat(t);this.setValue(n)};i.prototype._validateInput=function(t){this.setInputState(!e.validate(t),this.getI18nProperty(e.errorMessage))};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/isPlainObject","sap/base/strings/formatMessage"],function(e,t,a,i,s,n,r,u,o){"use strict";var l=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",metadata:{library:"sap.ui.integration"},init:function(){e.prototype.init.apply(this,arguments);this._itemsModel=new s;this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel");this._supportedTypesModel=new s([]);this._supportedTypesModel.setDefaultBindingMode("OneWay");this.setModel(this._supportedTypesModel,"supportedTypes");this.attachModelContextChange(function(){if(this.getModel("i18n")){this._setSupportedTypesModel()}},this);this.attachConfigChange(this._setSupportedTypesModel,this);this._mTypes={}},setValue:function(t){t=u(t)?t:{};var a=this._getPositions(t);this.setDesigntimeMetadata(n({},this.getDesigntimeMetadata(),Object.keys(a).reduce(function(e,t){e[t]={__value:{position:a[t]}};return e},{})));e.prototype.setValue.call(this,t);var i=this._processValue(t);i=i.sort(function(e,t){return a[e.key]-a[t.key]}).map(function(e,t){e.index=t;e.total=i.length;return e});this._itemsModel.setData(i)},_processValue:function(e){return Object.keys(e).map(function(t){var i=this._prepareInputValue(e[t],t);this._mTypes[t]=i.type;var s={key:t,value:i,designtime:this.getNestedDesigntimeMetadata(t)};return this.getConfig().includeInvalidEntries||this._isValidItem(s,a(e[t]))?s:undefined},this).filter(Boolean)},_getPositions:function(e){var t=Object.keys(e);var a=t.map(function(e){var t=this.getNestedDesigntimeMetadataValue(e).position;return t>=0?t:-1}.bind(this));var i=a.reduce(function(e,t){return Math.max(e,t)},-1);var s={};a.forEach(function(e,a){s[t[a]]=e>=0?e:++i});return s},_prepareInputValue:function(e,t){var i=this.processInputValue(a(e),t);if(!i.type){i.type=this._mTypes[t]||this._getDesigntimeMetadataValue(t).type||this._getDefaultType(i.value)}return i},_getDesigntimeMetadataValue:function(e){var t=(this.getConfig()||{}).designtime||{};var a=t[e]||{};return a.__value||{}},_isValidItem:function(e){var t=e.value.type;return t&&this._getAllowedTypes().includes(t)},_getDefaultType:function(e){var t=this.getConfig().defaultType;if(t){return t}var a=this._getAllowedTypes();var i=typeof e;var s=a.includes(i)?i:undefined;if(!s&&a.includes("string")){s="string"}return s},_getAllowedTypes:function(){var e=this.getConfig();return e&&e.allowedTypes||l.configMetadata.allowedTypes.defaultValue},_setSupportedTypesModel:function(){var a=this._getAllowedTypes();var i=t.getTypes();Promise.all(a.map(function(t){return(i[t]||Promise.resolve(e)).then(function(e){return{key:t,editor:e}})})).then(function(e){var t=e.map(function(e){var t=e.editor.configMetadata.typeLabel.defaultValue;return{key:e.key,title:this.getI18nProperty(t)}}.bind(this));this._supportedTypesModel.setData(t)}.bind(this))},formatItemConfig:function(e){var t=e.key;var a=e.value.type;var i=e.value.value;if(a==="boolean"){i=e.value.value!==false}var s=(e.designtime||{}).__value;var n=this.getConfig();return[{label:this.getI18nProperty("BASE_EDITOR.MAP.KEY"),path:"key",value:t,type:"string",enabled:n.allowKeyChange,itemKey:t,allowBindings:false,validators:[{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue())}.bind(this),currentKey:function(e){return e.getValue()}}}]},{label:this.getI18nProperty("BASE_EDITOR.MAP.TYPE"),path:"type",value:a,type:"select",items:this._supportedTypesModel.getData(),visible:n.allowTypeChange,itemKey:t,allowBindings:false},{label:this.getI18nProperty("BASE_EDITOR.MAP.VALUE"),path:"value",value:i,type:a&&this._getAllowedTypes().includes(a)?a:this._getDefaultType(i),visible:a!=="group"&&a!=="separator",itemKey:t,designtime:(s||{}).value}]},getExpectedWrapperCount:function(e){return this._processValue(e).length},processInputValue:function(e){return{value:e}},processOutputValue:function(e){return e.value},_onRemoveElement:function(e){var t=e.getSource().getBindingContext("itemsModel").getObject().key;var i=this.getValue();this.setValue(r(i,t));var s=a(this.getDesigntimeMetadata());delete s[t];this.setDesigntimeMetadata(s)},_onAddElement:function(){var e=n({},this.getValue());var t=this._getUniqueKey(e);e[t]=this.processOutputValue(this._getItemTemplate());this.setValue(e)},_moveUp:function(e){var t=e.getSource().data("index");if(t>0){var a=this._itemsModel.getData();this._swapPositions(a[t].key,a[t-1].key)}},_moveDown:function(e){var t=e.getSource().data("index");var a=this._itemsModel.getData();if(t<a.length-1){this._swapPositions(a[t].key,a[t+1].key)}},_swapPositions:function(e,t){var a={};a[e]={__value:{position:this.getNestedDesigntimeMetadataValue(t).position}};a[t]={__value:{position:this.getNestedDesigntimeMetadataValue(e).position}};this.setDesigntimeMetadata(n({},this.getDesigntimeMetadata(),a));this.setValue(this.getValue())},_getItemTemplate:function(){return{value:"",type:"string"}},_isNewItem:function(e){return i(e.value,this._prepareInputValue(this.processOutputValue(this._getItemTemplate())))},_getUniqueKey:function(e){var t="key";var a=0;while(e.hasOwnProperty(t)){t="key"+ ++a}return t},_propertyEditorsChange:function(e){var t=e.getParameter("previousPropertyEditors");var a=e.getParameter("propertyEditors");if(Array.isArray(t)){t.forEach(function(e){e.detachValueChange(this._onItemChange,this);e.detachDesigntimeMetadataChange(this._onDesigntimeValueChange,this)},this)}if(Array.isArray(a)){a.forEach(function(e){e.attachValueChange(this._onItemChange,this);e.attachDesigntimeMetadataChange(this._onDesigntimeValueChange,this)},this)}},_onItemChange:function(e){var t=e.getSource().getConfig().itemKey;var a=e.getParameter("path");var i=this.getItemChangeHandlers()[a];if(typeof i!=="function"){i=this._onFieldChange}i.call(this,t,e)},_onDesigntimeValueChange:function(e){var t=e.getSource().getConfig().itemKey;var a=e.getParameter("path");if(a!=="value"){return}this._onDesigntimeChange(t,e)},_onDesigntimeChange:function(e,t){var a=n({},this.getConfig().designtime);var i={__value:{}};i.__value[t.getParameter("path")]=t.getParameter("value");a[e]=n({},a[e],i);this.setDesigntimeMetadata(a);this.setValue(this.getValue())},getItemChangeHandlers:function(){return{key:this._onKeyChange,type:this._onTypeChange}},_onKeyChange:function(e,t){if(t.getParameter("previousValue")===undefined){return}var a=n({},this.getValue());var i=t.getParameter("value");if(i!==e){var s={};Object.keys(a).forEach(function(t){var n=t===e?i:t;s[n]=a[t]});if(s[i]&&s[i].type!=="group"&&s[i].type!=="separator"&&s[i].manifestpath&&s[i].manifestpath.startsWith("/sap.card/configuration/parameters/")){s[i].manifestpath="/sap.card/configuration/parameters/"+i+"/value"}this._mTypes[i]=this._mTypes[e];delete this._mTypes[e];this.setValue(s);var r=n({},this.getConfig().designtime);if(r.hasOwnProperty(e)){r[i]=r[e];if(r[i].__value&&r[i].__value.type&&r[i].__value.type!=="group"&&r[i].__value.type!=="separator"&&r[i].__value.manifestpath){r[i].__value.manifestpath=r[i].__value.manifestpath.replace(e,i)}delete r[e];this.setDesigntimeMetadata(r)}}},_onTypeChange:function(e,t){if(t.getParameter("previousValue")===undefined){return}var a=n({},this.getValue());var i=t.getParameter("value");var s=t.getParameter("previousValue");if(i!==s){var r=this.processInputValue(a[e]);r.type=i;a[e]=this.processOutputValue(r);if(i==="simpleicon"){a[e].visualization={type:"IconSelect",settings:{value:"{currentSettings>value}",editable:"{currentSettings>editable}"}}}else{delete a[e].visualization}if(i!=="array"&&i!=="string"&&i!=="object"&&i!=="objectArray"){delete a[e].values}if(i==="object"&&typeof a[e].value!=="object"){delete a[e].value}if(i==="objectArray"&&!(a[e].value instanceof Array)){delete a[e].value}this._mTypes[e]=i;this.setValue(a);var u=n({},this.getConfig().designtime);if(u.hasOwnProperty(e)){if(i==="simpleicon"){u[e].__value.visualization={type:"IconSelect",settings:{value:"{currentSettings>value}",editable:"{currentSettings>editable}"}}}else{delete u[e].__value.visualization}if(i!=="array"&&i!=="string"&&i!=="object"&&i!=="objectArray"){delete u[e].__value.values}u[e].__value.type=i;this.setDesigntimeMetadata(u)}}},_onFieldChange:function(e,t){var a=n({},this.getValue());var i=t.getParameter("path");var s=t.getParameter("value");var r=this.processInputValue(a[e]);r[i]=s;a[e]=this.processOutputValue(r);this.setValue(a)},formatAddItemText:function(e,t){var a=this.getI18nProperty(t);return o(e,[a])},renderer:e.getMetadata().getRenderer().render});l.configMetadata=Object.assign({},e.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowTypeChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowedTypes:{defaultValue:["string"],mergeStrategy:"intersection"},defaultType:{defaultValue:null},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},includeInvalidEntries:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},addItemLabelI18n:{defaultValue:"BASE_EDITOR.MAP.DEFAULT_TYPE"}});return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/multiSelectEditor/MultiSelectEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor"],function(e){"use strict";var t=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.multiSelectEditor.MultiSelectEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.multiSelectEditor.MultiSelectEditor",metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer().render});t.configMetadata=Object.assign({},e.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});t.prototype.getDefaultValidators=function(){var t=this.getConfig();return Object.assign({},e.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:t.allowBindings},notABinding:{type:"notABinding",isEnabled:!t.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(e){return e.getConfig().items.map(function(e){return e.key})}},isEnabled:!t.allowCustomValues}})};t.prototype._onSelectionFinish=function(e){var t=e.getParameter("selectedItems");t=t.map(function(e){return e.getKey()});this.setValue(t)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/base/util/restricted/_isNil","sap/ui/core/format/NumberFormat"],function(t,e,r,a){"use strict";var i=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.numberEditor.NumberEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.numberEditor.NumberEditor",metadata:{library:"sap.ui.integration"},invalidInputError:"BASE_EDITOR.NUMBER.INVALID_BINDING_OR_NUMBER",renderer:t.getMetadata().getRenderer().render});i.prototype.getDefaultValidators=function(){return Object.assign({},t.prototype.getDefaultValidators.call(this),{isNumber:{type:"isNumber"}})};i.configMetadata=Object.assign({},t.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.NUMBER"}});i.prototype.formatValue=function(t){if(r(t)||e(t,false)){return t}var a=parseFloat(t);if(!this.validateNumber(a)){return t}return this.getFormatterInstance().format(a)};i.prototype._onLiveChange=function(e){var r=this._parseLocalized(e.getParameter("newValue"));t.prototype.setValue.call(this,r)};i.prototype.validateNumber=function(t){return!isNaN(t)};i.prototype.getFormatterInstance=function(){return a.getFloatInstance()};i.prototype._parseLocalized=function(t){if(!t||e(t,false)){return t}var r=this.getFormatterInstance().parse(t);return r};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/objectArrayEditor/ObjectArrayEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/codeEditor/CodeEditor","sap/base/util/restricted/_isNil"],function(e,t){"use strict";var r=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.objectArrayEditor.ObjectArrayEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.objectArrayEditor.ObjectArrayEditor",metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer().render});r.configMetadata=Object.assign({},e.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.OBJECTARRAY"}});r.prototype._onLiveChange=function(){var e=this.getContent();var t=e.getValue();if(!t||t===""){this.setValue(undefined)}else{try{var r=JSON.parse(t);if(!(r instanceof Array)){e.setValueState("Error");e.setValueStateText(this.getI18nProperty("BASE_EDITOR.VALIDATOR.NOT_AN_ARRAY_OF_JSONOBJECTS"));return}this.setValue(r)}catch(t){e.setValueState("Error");e.setValueStateText(this.getI18nProperty("BASE_EDITOR.VALIDATOR.NOT_A_JSONOBJECT"))}}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor"],function(e){"use strict";var t=e.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.selectEditor.SelectEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.selectEditor.SelectEditor",metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer().render});t.configMetadata=Object.assign({},e.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});t.prototype.getDefaultValidators=function(){var t=this.getConfig();return Object.assign({},e.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:t.allowBindings},notABinding:{type:"notABinding",isEnabled:!t.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(e){return e.getConfig().items.map(function(e){return e.key})}},isEnabled:!t.allowCustomValues}})};t.prototype._onChange=function(){var e=this.getContent();var t=e.getSelectedKey();var i=e.getValue();this.setValue(t||i)};t.prototype._getItemTitle=function(e){var t=this.getConfig()&&this.getConfig().items||[];var i=t.find(function(t){return t.key===e});return(i||{}).title||e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/separatorEditor/SeparatorEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.separatorEditor.SeparatorEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.separatorEditor.SeparatorEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});i.configMetadata=Object.assign({},t.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.SEPARATOR"}});i.prototype.getDefaultValidators=function(){var e=this.getConfig();return Object.assign({},t.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:e.allowBindings},notABinding:{type:"notABinding",isEnabled:!e.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof e.maxLength==="number",config:{maxLength:e.maxLength}}})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil","sap/base/util/isPlainObject"],function(t,e,i){"use strict";var a=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.stringEditor.StringEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.stringEditor.StringEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});a.configMetadata=Object.assign({},t.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.STRING"},enabled:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});a.prototype.getDefaultValidators=function(){var e=this.getConfig();return Object.assign({},t.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:e.allowBindings},notABinding:{type:"notABinding",isEnabled:!e.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof e.maxLength==="number",config:{maxLength:e.maxLength}}})};a.prototype.setValue=function(a){if(!e(a)&&!i(a)){arguments[0]=a.toString()}t.prototype.setValue.apply(this,arguments)};a.prototype._onLiveChange=function(){var t=this.getContent();this.setValue(t.getValue())};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/propertyEditor/textAreaEditor/TextAreaEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil"],function(t,e){"use strict";var a=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.textAreaEditor.TextAreaEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.textAreaEditor.TextAreaEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});a.configMetadata=Object.assign({},t.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.OBJECT"}});a.prototype.getDefaultValidators=function(){var e=this.getConfig();return Object.assign({},t.prototype.getDefaultValidators.call(this),{notABinding:{type:"notABinding",isEnabled:!e.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof e.maxLength==="number",config:{maxLength:e.maxLength}}})};a.prototype.formatValue=function(t){t=JSON.stringify(t,null,"\t");if(typeof t==="object"&&!t.length){t=t.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(t){return t.substring(3,t.length-3)})}return t};a.prototype._onLiveChange=function(){var t=this.getContent();var e=t.getValue();if(!e||e===""){this.setValue(undefined)}else{try{var a=JSON.parse(e);this.setValue(a)}catch(e){t.setValueState("Error");t.setValueStateText(this.getI18nProperty("BASE_EDITOR.VALIDATOR.NOT_A_JSONOBJECT"))}}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules", ["sap/ui/integration/designtime/baseEditor/validator/NotABinding","sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/ui/integration/designtime/baseEditor/validator/IsSelectedKey","sap/ui/integration/designtime/baseEditor/validator/IsUniqueKey","sap/ui/integration/designtime/baseEditor/validator/IsNumber","sap/ui/integration/designtime/baseEditor/validator/IsInteger","sap/ui/integration/designtime/baseEditor/validator/IsBoolean","sap/ui/integration/designtime/baseEditor/validator/IsDate","sap/ui/integration/designtime/baseEditor/validator/IsStringList","sap/ui/integration/designtime/baseEditor/validator/IsUniqueList","sap/ui/integration/designtime/baseEditor/validator/MaxLength","sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch"],function(i,t,e,a,n,s,r,d,o,g,u,l){"use strict";return{notABinding:i,isValidBinding:t,isSelectedKey:e,isUniqueKey:a,isNumber:n,isInteger:s,isBoolean:r,isDate:d,isUniqueList:g,isStringList:o,maxLength:u,pattern:l}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/StylesheetManager", ["sap/ui/dom/includeStylesheet","sap/base/util/uid"],function(e,n){"use strict";var r="SUCCESS";var t="FAIL";var i="PENDING";var s={};function u(u){var o={id:n(),status:i,counter:1};var c=new Promise(function(n,r){e(u,o.id,n,r)}).then(function(){var e=s[u];if(e.counter===0){a(u)}else{v(u,r)}}).catch(function(){v(u,t);return Promise.reject("File not found or some other network issue happened.")});o.promise=c;s=Object.assign({},s);s[u]=o;return o.promise}function a(e){var n=Object.assign({},s);var r=n[e];var t=document.getElementById(r.id);if(t&&t.parentNode){t.parentNode.removeChild(t)}delete n[e];s=n}function o(e){var n={};n[e]=Object.assign({},s[e]);n[e].counter++;s=Object.assign({},s,n);return s[e]}function c(e){var n={};n[e]=Object.assign({},s[e]);n[e].counter--;s=Object.assign({},s,n);return s[e]}function v(e,n){var r={};r[e]=Object.assign({},s[e]);r[e].status=n;s=Object.assign({},s,r);return s[e]}function f(e){return sap.ui.require.toUrl(e)+".css"}return{add:function(e){var n=f(e);var r=s[n];if(r){o(n);return r.promise}return u(n)},remove:function(e){var n=f(e);var t=s[n];if(t){var i=c(n);if(i.counter===0&&i.status===r){a(n)}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding", ["sap/ui/base/ManagedObject","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/base/BindingParser","sap/base/util/deepEqual"],function(t,i,e,n,r,s){"use strict";var o=t.extend("sap.ui.integration.designtime.baseEditor.util.ObjectBinding",{metadata:{library:"sap.ui.integration",properties:{object:{type:"object"},_value:{type:"any",hidden:true}},events:{change:{parameters:{path:{type:"string"},value:{type:"any"}}}}},_originalObject:null});o.prototype.init=function(){this._aIgnoreList=[];this._oModelMap={}};o.prototype.exit=function(){this._cleanup()};o.prototype.setObject=function(t){this._setOriginalObject(t);this._init();return this};o.prototype._setObject=function(t){var e=i(t,50);return this.setProperty("object",e)};o.prototype._setOriginalObject=function(t){this._originalObject=i(t,50)};o.prototype._getOriginalObject=function(){return this._originalObject};o.prototype.setModel=function(i,e){var n=false;var r=Object.keys(this.oModels||{}).find(function(t){if(this.oModels[t]===i){n=true;return true}return false}.bind(this));this._oModelMap[e]=n?this._oModelMap[r]:e;var s=t.prototype.setModel.apply(this,arguments);this._init();return s};o.prototype.setBindingContext=function(){var i=t.prototype.setBindingContext.apply(this,arguments);this._init();return i};o.prototype._init=function(){this._cleanup();var t=this._getOriginalObject();if(t){this._setObject(t);this._createPropertyBindings(t)}};o.prototype._cleanup=function(){if(this._mSimpleBindings){Object.keys(this._mSimpleBindings).forEach(function(t){var i=this._mSimpleBindings[t].binding;i.getModel().removeBinding(i);i.destroy()}.bind(this))}this._mSimpleBindings={}};o.prototype._createPropertyBindings=function(t,i){Object.keys(t).filter(function(t){return!this.isIgnored(t)},this).forEach(function(e){var s=i?i+"/"+e:e;if(typeof t[e]==="string"){var o=r.complexParser(t[e]);if(o){if(o.parts){if(!o.parts.find(function(t){return!this.getModel(t.model)}.bind(this))){o.parts.forEach(function(t){this._createSimpleBinding(t,s,o)}.bind(this))}else{return}}else if(this.getModel(o.model)){this._createSimpleBinding(o,s,o)}else{return}this._updateValue([{path:s,bindingInfo:o}])}}else if(t[e]&&(n(t[e])||Array.isArray(t[e]))){this._createPropertyBindings(t[e],s)}},this)};o.prototype._updateValue=function(t){var n=[];t.forEach(function(t){var r=this.getObject();var o=t.path.split("/");var a=o.pop();if(o.length){r=e.get(o,r)}this.bindProperty("_value",i(t.bindingInfo));var p=i(this.getProperty("_value"));this.unbindProperty("_value");if(p!==r[a]&&(a!=="value"||!(r.value===undefined&&s(p,r.defaultValue)))){r[a]=p;n.push({path:t.path,value:p})}}.bind(this));if(n.length){this.fireChange({changes:n})}};o.prototype._createSimpleBinding=function(t,i,e){var n=this.getBindingContext(t.model);var r=this._oModelMap[t.model];var s=this.oModels[t.model];var o=s.resolve(t.path,n);var a=r+">"+o;var p=this._mSimpleBindings[a];if(!p){p=this.getModel(t.model).bindProperty(t.path,n);this._mSimpleBindings[a]={binding:p,properties:[]};p.attachChange(function(){this._updateValue(this._mSimpleBindings[a].properties)}.bind(this))}this._mSimpleBindings[a].properties.push({path:i,bindingInfo:e});return p};o.prototype.addToIgnore=function(t){this._aIgnoreList=this._aIgnoreList.concat(t);this._init()};o.prototype.removeFromIgnore=function(t){this._aIgnoreList=this._aIgnoreList.filter(function(i){return i!==t});this._init()};o.prototype.isIgnored=function(t){return this._aIgnoreList.includes(t)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding", ["sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding"],function(e){"use strict";return function(n,t,i,o){var c=new e;i=i||{};o=o||[];o.forEach(function(e){c.addToIgnore(e)});Object.keys(t).forEach(function(e){c.setModel(t[e],e===""?undefined:e)});Object.keys(i).forEach(function(e){c.setBindingContext(i[e],e===""?undefined:e)});c.setObject(n);var d=c.getObject();c.destroy();return d}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata", ["sap/base/util/restricted/_isNil","sap/base/util/each","sap/base/util/isPlainObject","sap/base/util/isEmptyObject"],function(i,e,t,s){"use strict";function a(n){e(n,function(e,u){if(t(u)){a(u)}if(i(u)||Array.isArray(u)&&u.length===0||t(u)&&s(u)){delete n[e]}})}return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/createPromise", function(){"use strict";return function(i){var n=false;var e;var t;var r;var f=new Promise(function(e,f){i(function(){if(!n){e.apply(this,arguments)}else if(t){t.apply(this,arguments)}},function(){if(!n){f.apply(this,arguments)}else if(r){r.apply(this,arguments)}})});return{promise:f,cancel:function(){n=true;if(!e){e=new Promise(function(i,n){t=i;r=n})}return e}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/escapeParameter", ["sap/base/util/isPlainObject","sap/base/util/each"],function(t,e){"use strict";return function(i,n){n=n||function(){return true};var r=Array.from(i);var u=typeof r[0]!=="string"&&r[0]!==undefined?0:1;if(t(r[u])){var a=Object.assign({},r[u]);e(a,function(e,i){if(t(i)&&n(i,e)){a[e]=Object.assign({},i,{ui5object:true})}});r[u]=a}return r}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/findClosestInstance", function(){"use strict";return function(n,e){function t(n){if(n){if(n.isA(e)){return n}else{return t(n.getParent())}}}return t(n)}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/hasTag", ["sap/base/util/restricted/_intersection"],function(t){"use strict";return function r(e,n){var i=[].concat(n);return Array.isArray(e.tags)&&t(i,e.tags).length===i.length}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/isTemplate", function(){"use strict";function e(t,n){var r=t.sParentAggregationName;var a=t.getParent();if(n&&a===n){return false}if(a&&r){var i=a.getBindingInfo(r);if(i&&t instanceof i.template.getMetadata().getClass()){return false}else{return e(a,n)}}return true}return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/isValidBindingString", ["sap/ui/base/BindingParser"],function(r){"use strict";function n(e,i){var t;try{var a=e.replace(/{{([^{]*)}}/g,function(r,e){if(n(e)){return"${}"}throw"Invalid binding string"});t=r.complexParser(a)}catch(r){return false}return i!==false?true:!!t}return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/util/unset", ["sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/base/util/isEmptyObject"],function(e,t,i){"use strict";function a(r,s,n){var l=s.slice(0,-1);var u=l.length>0?e.get(l,r):r;var c=s[s.length-1];if(Array.isArray(u)){u.splice(c,1)}else{delete u[c]}return l.length>0&&!(n<=0)&&(Array.isArray(u)&&u.length===0||t(u)&&i(u))?a(r,l,n?n-1:undefined):r}return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsBoolean", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil"],function(i,e){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_A_BOOLEAN",validate:function(a){return e(a)||typeof a==="boolean"||i.validate(a,{allowPlainStrings:false})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsDate", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/ui/core/date/UI5Date"],function(e,a){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.INVALID_DATE",validate:function(t,i){var n=i.formatterInstance;var s=n&&n.parse(t)||a.getInstance(t);return t===undefined||e.validate(t,{allowPlainStrings:false})||s&&!isNaN(a.getInstance(s).getTime())}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsInteger", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_AN_INTEGER",validate:function(e){return e===undefined||i.validate(e,{allowPlainStrings:false})||!isNaN(e)&&Number.isInteger(e)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsNumber", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_A_NUMBER",validate:function(a){return a===undefined||i.validate(a,{allowPlainStrings:false})||!isNaN(a)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(e){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FAILED_PATTERN_TEST",validate:function(a,i){var t=i.modifiers||"";var r=new RegExp(i.pattern,t);var n=i.exactMatch!==false;if(a===undefined){return true}var s;if(n){var d=a.match(r);s=d&&a===d[0]}else{s=r.test(a)}return s||e.validate(a,{allowPlainStrings:false})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsSelectedKey", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(e){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FORBIDDEN_CUSTOM_VALUE",validate:function(i,a){if(Array.isArray(i)){var n=true;if(i.length>0){for(var r=0;r<i.length;r++){if(!(i[r]===undefined||(a.keys||[]).includes(i[r])||e.validate(i[r],{allowPlainStrings:false}))){n=false;break}}}return n}else{return i===undefined||(a.keys||[]).includes(i)||e.validate(i,{allowPlainStrings:false})}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsStringList", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(e){"use strict";return{async:false,errorMessage:e.errorMessage,validate:function(i){return i===undefined||i.every(function(i){return e.validate(i)})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsUniqueKey", [],function(){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.DUPLICATE_KEY",validate:function(e,n){return n.currentKey===undefined||!n.keys.includes(e)||e===undefined||e===n.currentKey}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsUniqueList", ["sap/base/util/restricted/_uniq"],function(e){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.DUPLICATE_ENTRY",validate:function(n){return n===undefined||n.length===e(n).length}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/IsValidBinding", ["sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.INVALID_BINDING",validate:function(n,e){var t=(e||{}).allowPlainStrings!==false;return n===undefined||n===""||i(n.toString(),t)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/MaxLength", ["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil"],function(e,i){"use strict";return{async:false,errorMessage:{message:"BASE_EDITOR.VALIDATOR.MAX_LENGTH",placeholders:function(e){return[e.maxLength]}},validate:function(t,a){return i(t)||typeof t==="string"&&t.length<=a.maxLength||e.validate(t,{allowPlainStrings:false})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/NotABinding", ["sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FORBIDDEN_BINDING",validate:function(e){return!i(e,false)}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry", ["sap/base/util/restricted/_CancelablePromise"],function(e){"use strict";var t={};var i={};var r={};t.registerValidators=function(t){Object.keys(t).forEach(function(n){if(!this.hasValidator(n)){r[n]=new e(function(e,i,a){a(function(){delete r[n]});a.shouldReject=false;sap.ui.require([t[n]],e,i)});r[n].then(function(e){i[n]=e;delete r[n]})}}.bind(this))};t.ready=function(){return Promise.all(Object.values(r))};t.deregisterValidator=function(e){if(i[e]){delete i[e]}if(r[e]){r[e].cancel()}};t.deregisterAllValidators=function(){Object.keys(r).forEach(function(e){this.deregisterValidator(e)}.bind(this));i={}};t.getValidator=function(e){var t=i[e];if(!t){throw new Error("Validator "+e+" was not registered.")}return t};t.hasValidator=function(e){return Object.keys(i).includes(e)};t.isRegistered=function(e){return Object.keys(r).includes(e)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/BASEditor", ["sap/base/util/restricted/_CancelablePromise","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/ObjectPath","./CardEditor","sap/ui/integration/designtime/baseEditor/BaseEditor","sap/ui/integration/Designtime","sap/ui/integration/util/CardMerger","sap/base/util/LoaderExtensions","sap/base/Log"],function(e,t,i,a,n,s,r,o,f,l,u,g,p){"use strict";var m="";m=g.loadResource("sap/ui/integration/designtime/cardEditor/ConfigurationTemplate.js",{dataType:"text",failOnError:false,async:false});function c(e,t){t=t||0;var i="\n";var a="\n\t";for(var n=0;n<t;n++){a+="\t";i+="\t"}if(!e){return""}var r=Array.isArray(e);var o=[];var f=function(e){if(s(e,{})){return"{}"}if(typeof e==="object"&&e!==null){return c(e,t+1)}if(typeof e==="function"){return e.toString()}if(typeof e==="string"){return'"'+e+'"'}if(typeof e==="undefined"){return undefined}return e};for(var n in e){var l=f(e[n]);if(typeof l!=="undefined"){if(!r){l='"'+n+'": '+l}o.push(l)}}var u=o.join(","+a);if(r){u="["+a+u+i+"]"}else{u="{"+a+u+i+"}"}return u}var d=o.extend("sap.ui.integration.designtime.cardEditor.BASEditor",{metadata:{library:"sap.ui.integration",events:{configurationChange:{},createConfiguration:{},error:{},designtimeInited:{}}},renderer:o.getMetadata().getRenderer()});d.prototype.getManifest=function(){return this._oCurrent.manifest};d.prototype.getConfigurationClass=function(){return this._oCurrent.configurationclass};d.prototype.getConfiguration=function(){return this._oCurrent.configuration};d.prototype.getConfigurationString=function(){return this._oCurrent.configurationstring};d.prototype._generateDesigntimeJSConfig=function(){var e=this._formatExportedDesigntimeMetadata(this.getDesigntimeMetadata());var i=this.getJson();if(this._eventTimeout){clearTimeout(this._eventTimeout);this._eventTimeout=null}this._eventTimeout=setTimeout(function(){var n={form:{items:{}}};var o=a(n,this._oDesigntimeJSConfig);var f={};var u=[];var g;if(!r.get(["sap.card","configuration"],i)){r.set(["sap.card","configuration"],{parameters:{}},i)}else if(!r.get(["sap.card","configuration","parameters"],i)){r.set(["sap.card","configuration","parameters"],{},i)}var p=r.get(["sap.card","configuration","parameters"],i);var m={};var c={};if(i){var d=r.get(["sap.card","configuration","parameters"],this._oDesigntimeMetadataModel.getData());if(s(p,{})&&!d){this._oDesigntimeJSConfig.form.items={};this._oCurrent={configuration:this._cleanConfig(this._oDesigntimeJSConfig),manifest:this._cleanJson(),configurationclass:this._fnDesigntime,configurationstring:this._cleanConfig(this._oDesigntimeJSConfig,true)};this.fireConfigurationChange(this._oCurrent);return}var h=Object.keys(p);for(var v in o.form.items){g=a({},o.form.items[v]);if(!p[v]){if(d[v]){if(g.type==="group"||g.type==="separator"){p[v]={}}else if(g.manifestpath&&!g.manifestpath.startsWith("/sap.card/configuration/parameters")){var _=g.manifestpath;if(_.startsWith("/")){_=_.substring(1)}var y=r.get(_.split("/"),i)||"";p[v]={value:y}}}else{delete o.form.items[v];continue}}else if(g.manifestpath&&!g.manifestpath.startsWith("/sap.card/configuration/parameters")){var _=g.manifestpath;if(_.startsWith("/")){_=_.substring(1)}var C=_.split("/");var y=r.get(C,i);var b=r.get(C,this._oInitialJson);if(!t(y,b)){p[v].value=y}else{r.set(C,p[v].value,i)}}var D=h.indexOf(v);if(D>-1){h.splice(D,1)}if(p[v].visualization){m[v]=p[v].visualization}if(p[v].values){c[v]=p[v].values}o.form.items[v]=a(g,p[v]);if(!d[v].__value.visualization){delete o.form.items[v].visualization}else if(m[v]){o.form.items[v].visualization=m[v];delete m[v]}if(!d[v].__value.values){delete o.form.items[v].values}else if(c[v]){o.form.items[v].values=c[v];delete c[v]}if(g.type==="group"||g.type==="separator"){delete o.form.items[v].manifestpath}else if(!o.form.items[v].manifestpath){d[v].manifestpath="/sap.card/configuration/parameters/"+v+"/value";d[v].__value.manifestpath="/sap.card/configuration/parameters/"+v+"/value";o.form.items[v].manifestpath="/sap.card/configuration/parameters/"+v+"/value"}}if(h.length>0){for(var J=0;J<h.length;J++){var S=h[J];var I=p[S];var E="string";if(I.type){E=I.type}else if(d[S]&&d[S].__value){E=d[S].__value.type}o.form.items[S]={manifestpath:"/sap.card/configuration/parameters/"+S+"/value",type:E,label:I.label,translatable:false,editable:I.editable,visible:I.visible}}p[S]=a(o.form.items[S],p[S])}}if(e){if(o){for(var v in e){var z=e[v];var M=v.substring(v.lastIndexOf("/")+1);if(!v.startsWith("sap.card/configuration/parameters")){continue}var j=o.form.items[M]||{};if(j.visualization){m[v]=j.visualization}if(j.values){c[v]=j.values}g=a(j,p[M]);if(z.hasOwnProperty("label")){g.label=z.label}if(z.hasOwnProperty("position")){g.position=z.position}if(g.editable==="false"){g.editable=false}else if(g.editable==="true"){g.editable=false}if(g.visible==="false"){g.visible=false}else if(g.visible==="true"){g.visible=false}if(g.type==="group"||g.type==="separator"){delete g.manifestpath}if(m[M]){g.visualization=m[M];delete m[M]}if(c[M]){g.values=c[M];delete c[M]}g.__key=M;u[g.position]=g}for(var J=0;J<u.length;J++){g=u[J];if(!g){continue}f[g.__key]=g;delete g.__key;delete g.position}o.form.items=f}}this._oDesigntimeJSConfig=o;var T=this._cleanConfig(this._oDesigntimeJSConfig);this._fnDesigntime=function(e){return new l(e)}.bind(this,T);this._oCurrent={configuration:T,manifest:this._cleanJson(i),configurationclass:this._fnDesigntime,configurationstring:this._cleanConfig(this._oDesigntimeJSConfig,true)};this._oDataModel.setData(this._prepareData(i));this.fireConfigurationChange(this._oCurrent);this._oInitialJson=i}.bind(this),500)};d.prototype.init=function(){o.prototype.init.apply(this,arguments);this._oCurrent={configuration:null,manifest:null,configurationclass:null}};d.prototype._applyDefaultValue=function(e){if(e.value===undefined||e.value===null){switch(e.type){case"boolean":e.value=false;break;case"integer":case"number":e.value=0;break;case"string[]":e.value=[];break;default:e.value=""}}};d.prototype.getJson=function(e){if(e===true){return this._cleanJson()}else{return f.prototype.getJson.apply(this,arguments)}};d.prototype._cleanJson=function(e,t){e=e||this.getJson();var i=v(r.get(["sap.card","configuration","editor"],e)||"");if(i===""){i=v(r.get(["sap.card","designtime"],e)||"")}if(!i){r.set(["sap.card","designtime"],"sap/ui/integration/designtime/cardEditor/ConfigurationTemplate",e)}e=n(e);var t=t!==false;if(t){var a=r.get(["sap.card","configuration","parameters"],e);for(var s in a){var o=a[s];if(o&&(o.type==="group"||o.type==="separator")){delete a[s];continue}if(this._oDesigntimeJSConfig&&this._oDesigntimeJSConfig.form&&this._oDesigntimeJSConfig.form.items){var f=this._oDesigntimeJSConfig.form.items[s]||{};if(f.type==="group"||f.type==="separator"){delete a[s];continue}if(f.manifestpath&&!f.manifestpath.startsWith("/sap.card/configuration/parameters")){var l=f.manifestpath;if(l.startsWith("/")){l=l.substring(1)}if(f.type==="simpleicon"){f.type="string"}if(f.type==="string[]"){f.type="array"}r.set(l.split("/"),f.value,e);delete a[s];continue}}a[s]={value:a[s].value}}}if(this._i18n){r.set(["sap.app","i18n"],this._i18n,e)}return e};d.prototype._cleanConfig=function(e,t){var i=a({},e);for(var n in i.form.items){var s=i.form.items[n];if(s.type==="simpleicon"){if(!s.visualization){s.visualization={type:"IconSelect",settings:{value:"{currentSettings>value}",editable:"{currentSettings>editable}"}}}s.type="string"}if(s.type==="array"){s.type="string[]"}if(s.type==="objectArray"){s.type="object[]"}if(s.type!=="string[]"&&s.type!="string"&&s.type!=="object[]"&&s.type!="object"){delete s.values}delete s.value}if(t){var r=c(i);r=r.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)});return r}return i};d.prototype._generateMetadataFromJSConfig=function(e){var t={};if(e){this._oDesigntimeJSConfig=a(this._oDesigntimeJSConfig,e)}if(this._oDesigntimeJSConfig){var i=this._oDesigntimeJSConfig.form.items;var n=0;for(var s in i){var o="sap.card/configuration/parameters/"+s,f=o.split("/"),l;t[o]=a({},i[s]);l=t[o];l.position=n++;if(l.visualization){if(l.visualization.type==="IconSelect"){l.type="simpleicon"}}if(l.type==="string[]"){l.type="array"}if(l.manifestpath&&(!l.manifestpath.startsWith("/sap.card/configuration/parameters/")||!r.get(f,this._oInitialJson))){r.set(f,l,this._oInitialJson)}if(!l.hasOwnProperty("type")){this.fireError({name:"Designtime Error",detail:{message:"Type of parameter "+s+" not exist"}})}else if(l.type===""){this.fireError({name:"Designtime Error",detail:{message:"Type of parameter "+s+" is Invalid"}})}if(l.type!=="group"&&l.type!=="separator"){if(!l.hasOwnProperty("value")){var u=l.manifestpath.substring(1).split("/"),g=r.get(u,this._oInitialJson);if(g!==undefined){l.value=g}else{this._applyDefaultValue(l)}}else{this._applyDefaultValue(l)}if(r.get(f,this._oInitialJson)){if(r.get(f,this._oInitialJson).value===undefined){r.get(f,this._oInitialJson).value=l.value}}}}}return t};d.prototype.setJson=function(t){if(!this._i18n){this._i18n=r.get(["sap.app","i18n"],t)}f.prototype.setJson.apply(this,arguments);if(!this.__generateDesigntimeJSConfigAttached){this.attachDesigntimeMetadataChange(this._generateDesigntimeJSConfig.bind(this));this.attachJsonChange(this._generateDesigntimeJSConfig.bind(this));this.__generateDesigntimeJSConfigAttached=true}var t=this.getJson();var i=r.get(["sap.app","id"],t);if(this._bDesigntimeInit&&this._bCardId!==i){if(this._oDesigntimePromise){this._oDesigntimePromise.cancel()}delete this._bCardId;delete this._bDesigntimeInit}if(!this._bDesigntimeInit){this.setPreventInitialization(true);this._bCardId=i;var a;var n=v(r.get(["sap.card","configuration","editor"],t)||"");if(n===""){n=v(r.get(["sap.card","designtime"],t)||"")}if(!n){var s=m;r.set(["sap.card","designtime"],"sap/ui/integration/designtime/cardEditor/ConfigurationTemplate",t);a="sap/ui/integration/designtime/cardEditor/ConfigurationTemplate";this.fireCreateConfiguration({file:"sap/ui/integration/designtime/cardEditor/ConfigurationTemplate.js",content:s,manifest:this._cleanJson(t,false)});return}var o=v(this.getBaseUrl()||""),l={},g=null,c=null,d=null,y=null;if(n&&n.indexOf("cardEditor/ConfigurationTemplate")>0){a=n;c=_(n);d=i.replace(/\./g,"/")+"/"+c;l[d]=c;l[d+"js"]=c.substring(0,c.lastIndexOf("/"));y=c.replace(l[d+"js"]+"/","")}else if(o&&n){g=v(o);c=_(n);var C=g+"/"+c;d=i.replace(/\./g,"/")+"/"+c;l[d]=C;l[d+"js"]=C.substring(0,C.lastIndexOf("/"));y=C.replace(l[d+"js"]+"/","")}if(o&&n){sap.ui.loader.config({paths:l});var b=this;this._oDesigntimePromise=new e(function(e){var t=d+"js"+"/"+y+".js";if(a){t=a+".js"}sap.ui.loader._.loadJSResourceAsync(t).then(function(t){if(!t){b.fireError({name:"Designtime Error",detail:{message:"Invalid file format"}})}else if(t){var i=new t;b._oDesigntimeJSConfig=i.getSettings();b._fnDesigntime=t;var a=b._generateMetadataFromJSConfig();t=i.getMetadata().getClass();e(a)}}).catch(function(e){p.error(e);b.fireError({name:"Designtime Error",detail:e})})});this._oDesigntimePromise.then(function(e){this.setPreventInitialization(false);var t=e;t=u.mergeCardDesigntimeMetadata(t,this.getDesigntimeChanges());this._oInitialDesigntimeMetadata=t;this.setDesigntimeMetadata(h(t),true);this._bDesigntimeInit=true;this.fireDesigntimeInited()}.bind(this))}else{this.setPreventInitialization(false)}}};d.prototype.initialize=function(){if(!this._bDesigntimeInit){this.attachEventOnce("designtimeInited",this.initialize);return}if(!this._bPreventInitialization){this._initialize()}};d.prototype.getConfigurationTemplate=function(){return m};d.prototype.updateDesigntimeMetadata=function(e,t){var i=this._generateMetadataFromJSConfig(e);this._oInitialDesigntimeMetadata=i;this.setDesigntimeMetadata(h(i),t)};d.prototype.setDestinations=function(e){if(Array.isArray(e)&&e.length>0){var t={properties:{destinations:{allowedValues:e}}};this.addConfig(t)}};function h(e){var t={};Object.keys(e).forEach(function(i){r.set(i.split("/"),{__value:n(e[i])},t)});return t}function v(e){return e.trim().replace(/\/*$/,"")}function _(e){return e.replace(/^\.\//,"")}return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/CardEditor", ["sap/base/util/restricted/_CancelablePromise","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/restricted/_castArray","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/ui/integration/designtime/baseEditor/BaseEditor","sap/ui/integration/util/CardMerger","sap/ui/thirdparty/jquery","./config/index"],function(t,e,i,a,n,s,r,o,u,p,d,g,jQuery,l){"use strict";var c=d.extend("sap.ui.integration.designtime.cardEditor.CardEditor",{metadata:{library:"sap.ui.integration",properties:{layout:{type:"string",defaultValue:"form"},designtimeChanges:{type:"array",defaultValue:[]},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},config:{type:"object",defaultValue:{i18n:[].concat(d.getMetadata().getProperty("config").getDefaultValue().i18n,"sap/ui/integration/designtime/cardEditor/i18n/i18n.properties")}}}},constructor:function(t){t=t||{};d.prototype.constructor.apply(this,arguments);if(!t["config"]){this.addConfig(l,true)}},renderer:d.getMetadata().getRenderer()});c.prototype.init=function(){d.prototype.init.apply(this,arguments);this.attachJsonChange(function(t){if(!this._oInitialJson){this._oInitialJson=t.getParameter("json")}},this)};c.prototype.setJson=function(){d.prototype.setJson.apply(this,arguments);var e=this.getJson();var i=u.get(["sap.app","id"],e);if(this._bDesigntimeInit&&this._bCardId!==i){if(this._oDesigntimePromise){this._oDesigntimePromise.cancel()}delete this._bCardId;delete this._bDesigntimeInit}if(!this._bDesigntimeInit){this.setPreventInitialization(true);this._bDesigntimeInit=true;this._bCardId=i;var n=f(u.get(["sap.card","configuration","editor"],e)||"");if(n===""){n=f(u.get(["sap.card","designtime"],e)||"")}var s=f(this.getBaseUrl()||"");if(s&&n){var o={};var l=f(s);var c=m(n);var b=l+"/"+c;var y=i.replace(/\./g,"/")+"/"+c;o[y]=b;sap.ui.loader.config({paths:o});var _=y+"/editor.config";var v=y+"/i18n/i18n.properties";var C=b+"/metadata.json";this._oDesigntimePromise=new t(function(t){Promise.all([new Promise(function(t){sap.ui.require([_],t,function(){t({})})}),new Promise(function(t){jQuery.getJSON(C).done(t).fail(function(){t({})})})]).then(t)});this._oDesigntimePromise.then(function(t){this.setPreventInitialization(false);var e=t[1];e=g.mergeCardDesigntimeMetadata(e,this.getDesigntimeChanges());this._oInitialDesigntimeMetadata=e;this.setDesigntimeMetadata(h(e),true);var i=t[0];if(p(i)){this.addConfig({i18n:v})}else{i=r({},i);i.i18n=i.i18n?a(i.i18n):[];i.i18n.push(v);this._addSpecificConfig(i)}}.bind(this))}else{this.setPreventInitialization(false);this.addConfig({})}}};c.prototype.setDesigntimeChanges=function(t){if(this._oInitialDesigntimeMetadata){throw Error("Designtime Changes can only be set initially")}this.setProperty("designtimeChanges",t)};function h(t){var e={};Object.keys(t).forEach(function(i){u.set(i.split("/"),{__value:o(t[i])},e)});return e}function f(t){return t.trim().replace(/\/*$/,"")}function m(t){return t.replace(/^\.\//,"")}return c});
// add your copyright here

/**
 * This module was created by the BASEditor
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/ConfigurationTemplate", ["sap/ui/integration/Designtime"], function (
	Designtime
) {
	"use strict";
	return function () {
		return new Designtime({
			"form": {
				"items": {
				}
			},
			"preview": {
				"modes": "Abstract"
			}
		});
	};
});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/PropertyEditor", ["sap/ui/integration/designtime/baseEditor/PropertyEditor"],function(i){"use strict";return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/PropertyEditors", ["sap/ui/integration/designtime/baseEditor/PropertyEditors"],function(i){"use strict";return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/AppConfig", function(){"use strict";return{appId:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.ID}",type:"string",maxLength:70,path:"/sap.app/id"},appVersion:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.VERSION}",type:"string",path:"/sap.app/applicationVersion/version"},appTitle:{tags:["app"],label:"{i18n>CARD_EDITOR.TITLE}",type:"string",path:"/sap.app/title"},appSubTitle:{tags:["app"],label:"{i18n>CARD_EDITOR.SUBTITLE}",type:"string",path:"/sap.app/subTitle"},appShortTitle:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.SHORTTITLE}",type:"string",path:"/sap.app/shortTitle"},appInfo:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.INFO}",type:"string",path:"/sap.app/info"},appIcon:{tags:["app"],label:"{i18n>CARD_EDITOR.ICON}",type:"simpleicon",path:"/sap.ui/icons/icon"},appDescription:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.DESCRIPTION}",type:"string",path:"/sap.app/description"},appI18n:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.I18N}",type:"string",path:"/sap.app/i18n",defaultValue:"i18n/i18n.properties"},appTagKeywords:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.TAGS.KEYWORDS}",type:"list",path:"/sap.app/tags/keywords"},appTagTechnicalAttributes:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.TAGS.TECHNICALATTRIBUTES}",type:"list",path:"/sap.app/tags/technicalAttributes",validators:{technicalAttributesPattern:{type:"patternList",config:{pattern:"^[A-Z0-9_\\-\\/]+$"}}}},mobile:{tags:["app"],label:"{i18n>CARD_EDITOR.APP.MOBILE}",type:"boolean",defaultValue:"",path:"/sap.platform.mobilecards/compatible"}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/FooterConfig", ["sap/ui/integration/designtime/cardEditor/config/generateFooterActionsStripConfig"],function(t){"use strict";return{items:t({tags:["footer"],path:"footer/actionsStrip"})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/HeaderConfig", ["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(e){"use strict";return{headerType:{tags:["header"],label:"{i18n>CARD_EDITOR.HEADERTYPE}",path:"header/type",type:"select",items:[{key:"Default",title:"{i18n>CARD_EDITOR.HEADERTYPE.DEFAULT}"},{key:"Numeric",title:"{i18n>CARD_EDITOR.HEADERTYPE.NUMERIC}"}],defaultValue:"Default"},headerPosition:{tags:["header"],label:"{i18n>CARD_EDITOR.HEADERPOSITION}",path:"headerPosition",type:"select",items:[{key:"Top",title:"{i18n>CARD_EDITOR.HEADERPOSITION.TOP}"},{key:"Bottom",title:"{i18n>CARD_EDITOR.HEADERPOSITION.BOTTOM}"}],defaultValue:"Top"},title:{tags:["header"],label:"{i18n>CARD_EDITOR.TITLE}",type:"string",path:"header/title"},subTitle:{tags:["header"],label:"{i18n>CARD_EDITOR.SUBTITLE}",type:"string",path:"header/subTitle"},actions:e({tags:["header"],path:"header/actions",maxItems:1}),statusText:{tags:["header","defaultHeader"],label:"{i18n>CARD_EDITOR.STATUS}",type:"string",path:"header/status/text"},icon:{tags:["header","defaultHeader"],label:"{i18n>CARD_EDITOR.ICON}",type:"icon",path:"header/icon",visible:"{= ${context>header/type} !== 'Numeric' }"},unitOfMeasurement:{tags:["header","numericHeader"],label:"{i18n>CARD_EDITOR.UOM}",type:"string",path:"header/unitOfMeasurement",visible:"{= ${context>header/type} === 'Numeric' }"},mainIndicatorNumber:{tags:["header","numericHeader","mainIndicator"],label:"{i18n>CARD_EDITOR.NUMBER}",type:"number",path:"header/mainIndicator/number",visible:"{= ${context>header/type} === 'Numeric' }"},mainIndicatorUnit:{tags:["header","numericHeader","mainIndicator"],label:"{i18n>CARD_EDITOR.MAIN_INDICATOR.UNIT}",type:"string",path:"header/mainIndicator/unit",visible:"{= ${context>header/type} === 'Numeric' }"},mainIndicatorTrend:{tags:["header","numericHeader","mainIndicator"],label:"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND}",type:"select",items:[{key:"Down",title:"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.DOWN}"},{key:"None",title:"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.NONE}"},{key:"Up",title:"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.UP}"}],allowBinding:true,path:"header/mainIndicator/trend",visible:"{= ${context>header/type} === 'Numeric' }"},mainIndicatorState:{tags:["header","numericHeader","mainIndicator"],label:"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE}",type:"select",items:[{key:"Critical",title:"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.CRITICAL}"},{key:"Error",title:"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.ERROR}"},{key:"Good",title:"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.GOOD}"},{key:"Neutral",title:"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.NEUTRAL}"}],allowBinding:true,path:"header/mainIndicator/state",visible:"{= ${context>header/type} === 'Numeric' }"},details:{tags:["header","numericHeader"],label:"{i18n>CARD_EDITOR.DETAILS}",type:"string",path:"header/details",visible:"{= ${context>header/type} === 'Numeric' }"},sideIndicators:{tags:["header","numericHeader"],label:"{i18n>CARD_EDITOR.SIDE_INDICATORS}",path:"header/sideIndicators",type:"array",itemLabel:"{title}",addItemLabel:"{i18n>CARD_EDITOR.SIDE_INDICATOR}",template:{title:{label:"{i18n>CARD_EDITOR.TITLE}",type:"string",path:"title"},number:{label:"{i18n>CARD_EDITOR.NUMBER}",type:"number",path:"number"},unit:{label:"{i18n>CARD_EDITOR.SIDE_INDICATOR.UNIT}",type:"string",path:"unit"}},maxItems:2,visible:"{= ${context>header/type} === 'Numeric' }"}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/ListCardConfig", ["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(t){"use strict";return{listMaxItems:{tags:["content"],label:"{i18n>CARD_EDITOR.MAXITEMS}",type:"integer",path:"content/maxItems",visible:"{= ${context>type} === 'List' }"},listItemTitle:{tags:["content","listItem"],label:"{i18n>CARD_EDITOR.TITLE}",type:"string",path:"content/item/title",visible:"{= ${context>type} === 'List' }"},listItemDescription:{tags:["content","listItem"],label:"{i18n>CARD_EDITOR.LIST_ITEM.DESCRIPTION}",type:"string",path:"content/item/description",visible:"{= ${context>type} === 'List' }"},listItemInfoValue:{tags:["content","listItem"],label:"{i18n>CARD_EDITOR.LIST_ITEM.INFO.VALUE}",type:"string",path:"content/item/info/value",visible:"{= ${context>type} === 'List' }"},listItemInfoState:{tags:["content","listItem"],label:"{i18n>CARD_EDITOR.LIST_ITEM.INFO.STATE}",type:"select",items:[{key:"Success",title:"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{key:"Error",title:"{i18n>CARD_EDITOR.STATE.ERROR}"},{key:"Warning",title:"{i18n>CARD_EDITOR.STATE.WARNING}"},{key:"None",title:"{i18n>CARD_EDITOR.STATE.NONE}"},{key:"Information",title:"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],defaultValue:"None",path:"content/item/info/state",visible:"{= ${context>type} === 'List' }"},listItemHighlight:{tags:["content","listItem"],label:"{i18n>CARD_EDITOR.LIST_ITEM.HIGHLIGHT}",type:"select",items:[{key:"Success",title:"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{key:"Error",title:"{i18n>CARD_EDITOR.STATE.ERROR}"},{key:"Warning",title:"{i18n>CARD_EDITOR.STATE.WARNING}"},{key:"None",title:"{i18n>CARD_EDITOR.STATE.NONE}"},{key:"Information",title:"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],defaultValue:"None",path:"content/item/highlight",visible:"{= ${context>type} === 'List' }"},listItemIcon:{tags:["content","listItem"],label:"{i18n>CARD_EDITOR.LIST_ITEM.ICON}",type:"simpleicon",path:"content/item/icon/src",visible:"{= ${context>type} === 'List' }"},listItemActions:t({tags:["content","listItem"],path:"content/item/actions",maxItems:1,visible:"{= ${context>type} === 'List' }"})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/ObjectCardConfig", ["sap/ui/integration/designtime/cardEditor/config/generateActionConfig","sap/ui/integration/designtime/cardEditor/util/CommonPatterns"],function(t,e){"use strict";return{objectGroups:{tags:["content"],label:"{i18n>CARD_EDITOR.OBJECT.GROUPS}",type:"array",path:"content/groups",itemLabel:"{title}",addItemLabel:"{i18n>CARD_EDITOR.OBJECT.GROUP}",template:{title:{label:"{i18n>CARD_EDITOR.TITLE}",type:"string",path:"title"},items:{tags:["content","objectGroup"],label:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEMS}",type:"array",path:"items",itemLabel:"{label}",addItemLabel:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM}",template:{icon:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.ICON}",type:"icon",path:"icon"},label:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.LABEL}",type:"string",path:"label"},value:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.VALUE}",type:"string",path:"value",validators:{emailPattern:{type:"pattern",config:{pattern:e.email,modifiers:"i"},errorMessage:"CARD_EDITOR.VALIDATOR.INVALID_EMAIL",isEnabled:"{= ${type} === 'email'}"}}},type:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.LABEL.TYPE}",type:"select",items:[{key:"phone",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.PHONE}"},{key:"email",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.EMAIL}"},{key:"link",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.LINK}"},{key:"text",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.TEXT}"},{key:"RatingIndicator",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.RATINGINDICATOR}"}],defaultValue:"text",path:"type"},url:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.LABEL.URL}",type:"string",path:"url",visible:"{= ${type} === 'link'}"},target:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.TARGET}",type:"select",items:[{key:"_blank",description:"{i18n>CARD_EDITOR.TARGET.BLANK}"},{key:"_self",description:"{i18n>CARD_EDITOR.TARGET.SELF}"}],defaultValue:"_blank",path:"target",visible:"{= ${type} === 'link' && !!${url}}"},emailSubject:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.EMAILSUBJECT}",type:"string",path:"emailSubject",visible:"{= ${type} === 'email'}"},maxValue:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.RATINGMAXVALUE}",type:"integer",path:"maxValue",defaultValue:5,visible:"{= ${type} === 'RatingIndicator'}"}}}},visible:"{= ${context>type} === 'Object' }"},objectActions:t({tags:["content"],path:"content/actions",maxItems:1,visible:"{= ${context>type} === 'Object' }"})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/TableCardConfig", ["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(t){"use strict";return{tableMaxItems:{tags:["content"],label:"{i18n>CARD_EDITOR.MAXITEMS}",type:"integer",path:"content/maxItems",visible:"{= ${context>type} === 'Table' }"},tableRowColumns:{tags:["content","tableRow"],label:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMNS}",type:"array",path:"content/row/columns",itemLabel:"{title}",addItemLabel:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN}",template:{title:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TITLE}",type:"string",path:"title"},width:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.WIDTH}",type:"string",path:"width"},value:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.VALUE}",type:"string",path:"value"},icon:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.ICON}",type:"icon",path:"icon",visible:false},state:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.STATE}",type:"select",items:[{key:"Success",title:"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{key:"Error",title:"{i18n>CARD_EDITOR.STATE.ERROR}"},{key:"Warning",title:"{i18n>CARD_EDITOR.STATE.WARNING}"},{key:"None",title:"{i18n>CARD_EDITOR.STATE.NONE}"},{key:"Information",title:"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],defaultValue:"None",path:"state"},url:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.LABEL.URL}",type:"string",path:"url"},target:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TARGET}",type:"select",items:[{key:"_blank",description:"{i18n>CARD_EDITOR.TARGET.BLANK}"},{key:"_self",description:"{i18n>CARD_EDITOR.TARGET.SELF}"}],defaultValue:"_blank",path:"target",visible:"{= !!${url}}"},identifier:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.IDENTIFIER}",type:"boolean",defaultValue:false,path:"identifier"},progressIndicatorState:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.STATE}",type:"select",items:[{key:"Success",title:"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{key:"Error",title:"{i18n>CARD_EDITOR.STATE.ERROR}"},{key:"Warning",title:"{i18n>CARD_EDITOR.STATE.WARNING}"},{key:"None",title:"{i18n>CARD_EDITOR.STATE.NONE}"},{key:"Information",title:"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],defaultValue:"None",path:"progressIndicator/state"},progressIndicatorPercent:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.PERCENT}",type:"number",path:"progressIndicator/percent"},progressIndicatorText:{tags:["content","tableRowColumn"],label:"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.TEXT}",type:"string",path:"progressIndicator/text"}},visible:"{= ${context>type} === 'Table' }"},tableRowActions:t({tags:["content","tableRow"],path:"content/row/actions",maxItems:1,visible:"{= ${context>type} === 'Table' }"})}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/generateActionConfig", ["sap/base/util/restricted/_merge"],function(e){"use strict";return function(t){return e({},{label:"{i18n>CARD_EDITOR.ACTIONS}",type:"array",itemLabel:"{type}",addItemLabel:"{i18n>CARD_EDITOR.ACTION}",template:{enabled:{label:"{i18n>CARD_EDITOR.ACTION.ENABLED}",type:"boolean",defaultValue:true,path:"enabled"},type:{label:"{i18n>CARD_EDITOR.LABEL.TYPE}",type:"select",items:[{key:"Navigation"},{key:"Custom"}],path:"type",visible:"{= !!${enabled}}"},service:{label:"{i18n>CARD_EDITOR.ACTION.SERVICE}",type:"string",path:"service",visible:false},parameters:{label:"{i18n>CARD_EDITOR.PARAMETERS}",type:"map",allowedTypes:["string","number","boolean"],path:"parameters",visible:"{= !!${enabled}}"},url:{label:"{i18n>CARD_EDITOR.LABEL.URL}",type:"string",path:"url",visible:"{= !!${enabled} && ${type} === 'Navigation'}"},target:{label:"{i18n>CARD_EDITOR.TARGET}",type:"select",items:[{key:"_blank",description:"{i18n>CARD_EDITOR.TARGET.BLANK}"},{key:"_self",description:"{i18n>CARD_EDITOR.TARGET.SELF}"}],defaultValue:"_blank",path:"target",visible:"{= !!${enabled} && ${type} === 'Navigation' && !!${url}}"}}},t)}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @function
 * @private
 * @experimental
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/generateDataConfig", function(){"use strict";return function(a,t,e){var s={DataRequestUrl:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.REQUEST.URL}",type:"string",defaultValue:"",path:t+"data/request/url"},DataRequestMode:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.REQUEST.MODE}",type:"select",items:[{key:"no-cors"},{key:"same-origin"},{key:"cors"}],defaultValue:"cors",path:t+"data/request/mode",visible:"{= !!${context>"+t+"data/request/url} }"},DataRequestMethod:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.REQUEST.METHOD}",type:"select",items:[{key:"GET"},{key:"POST"}],defaultValue:"GET",path:t+"data/request/method",visible:"{= !!${context>"+t+"data/request/url} }"},DataRequestParameters:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.REQUEST.PARAMETERS}",type:"map",path:t+"data/request/parameters",visible:"{= !!${context>"+t+"data/request/url} }"},DataRequestHeaders:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.REQUEST.HEADERS}",type:"map",path:t+"data/request/headers",visible:"{= !!${context>"+t+"data/request/url} }"},DataRequestWithCredentials:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.REQUEST.WITHCREDENTIALS}",type:"boolean",defaultValue:false,path:t+"data/request/withCredentials",visible:"{= !!${context>"+t+"data/request/url} }"},DataJson:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.JSON}",type:"json",path:t+"data/json",visible:"{= !${context>"+t+"data/request/url} }"},DataPath:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.PATH}",type:"string",path:t+"data/path",validators:{dataPathPattern:{type:"pattern",config:{pattern:"^[a-zA-Z0-9_\\.\\-/|\\@\\#]*$"}}}},DataServiceName:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.SERVICE.NAME}",type:"string",path:t+"data/service/name",visible:false},DataServiceParameters:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.SERVICE.PARAMETERS}",type:"map",path:t+"data/service/parameters",visible:false},DataUpdateInterval:{tags:a.concat(["data"]),label:"{i18n>CARD_EDITOR.DATA.UPDATEINTERVAL}",type:"number",path:t+"data/updateInterval"}};var r={};Object.keys(s).forEach(function(a){r[e+a]=s[a]});return r}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/generateFooterActionsStripConfig", ["sap/base/util/restricted/_merge","sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(e,t){"use strict";return function(i){return e({},{label:"{i18n>CARD_EDITOR.ACTIONS.STRIP}",type:"array",itemLabel:"{type}",addItemLabel:"{i18n>CARD_EDITOR.ACTION.STRIP}",template:{type:{label:"{i18n>CARD_EDITOR.ACTION.STRIP.TYPE}",type:"select",items:[{key:"Button"},{key:"ToolbarSpacer"}],path:"type"},actions:t({path:"actions"}),overflowPriority:{label:"{i18n>CARD_EDITOR.ACTION.STRIP.OVERFLOWPRIORITY}",type:"select",items:[{key:"Always"},{key:"AlwaysOverflow"},{key:"Disappear"},{key:"High"},{key:"Low"},{key:"Never"},{key:"NeverOverflow"}],path:"overflowPriority"},icon:{label:"{i18n>CARD_EDITOR.ACTION.STRIP.ICON}",type:"string",path:"icon"},text:{label:"{i18n>CARD_EDITOR.ACTION.TEXT}",type:"string",path:"text"},tooltip:{label:"{i18n>CARD_EDITOR.ACTION.STRIP.TOOLTIP}",type:"string",path:"tooltip"},buttonType:{label:"{i18n>CARD_EDITOR.ACTION.STRIP.BUTTON.TYPE}",type:"select",visible:"{= ${type} === 'Button'}",items:[{key:"Accept"},{key:"Attention"},{key:"Back"},{key:"Critical"},{key:"Default"},{key:"Emphasized"},{key:"Ghost"},{key:"Negative"},{key:"Neutral"},{key:"Reject"},{key:"Success"},{key:"Transparent"},{key:"Unstyled"},{key:"Up"}],path:"buttonType"},ariaHasPopup:{label:"{i18n>CARD_EDITOR.ACTION.ARIAHASPOPUP}",type:"select",items:[{key:"Dialog"},{key:"Grid"},{key:"ListBox"},{key:"Menu"},{key:"None"},{key:"Tree"}],path:"ariaHasPopup"},visible:{label:"{i18n>CARD_EDITOR.ACTION.VISIBLE}",type:"boolean",defaultValue:true,path:"visible"}}},i)}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/config/index", ["sap/ui/integration/designtime/cardEditor/config/AppConfig","sap/ui/integration/designtime/cardEditor/config/HeaderConfig","sap/ui/integration/designtime/cardEditor/config/ListCardConfig","sap/ui/integration/designtime/cardEditor/config/ObjectCardConfig","sap/ui/integration/designtime/cardEditor/config/TableCardConfig","sap/ui/integration/designtime/cardEditor/config/generateDataConfig","sap/ui/integration/designtime/cardEditor/config/FooterConfig"],function(t,i,e,r,a,o,n){"use strict";return{context:"sap.card",layout:{form:{groups:[{label:"{i18n>CARD_EDITOR.GROUP.METADATA}",items:[{type:"tag",value:"app"}]},{label:"{i18n>CARD_EDITOR.GROUP.GENERALCONFIGURATION}",items:[{type:"tag",value:"general"}]},{label:"{i18n>CARD_EDITOR.GROUP.DATA}",items:[{type:"propertyName",value:"appDataSources"},{type:"tag",value:["data","general-data"]}]},{label:"{i18n>CARD_EDITOR.GROUP.DATAHEADER}",items:[{type:"tag",value:["data","header"]}]},{label:"{i18n>CARD_EDITOR.GROUP.DATACONTENT}",items:[{type:"tag",value:["data","content"]}]},{label:"{i18n>CARD_EDITOR.GROUP.HEADER}",items:[{type:"tag",value:"header"}]},{label:"{i18n>CARD_EDITOR.GROUP.CONTENT}",items:[{type:"tag",value:"content"}]},{label:"{i18n>CARD_EDITOR.GROUP.FOOTER}",items:[{type:"tag",value:"footer"}]}]}},properties:Object.assign({},t,{type:{tags:["general"],label:"{i18n>CARD_EDITOR.TYPE}",type:"select",items:sap.ui.version.includes("SNAPSHOT")&&!window.location.host.includes("openui5nightly")?[{key:"List"},{key:"Analytical"},{key:"Table"},{key:"Object"},{key:"Timeline"},{key:"Component"},{key:"Calendar"},{key:"AdaptiveCard"}]:[{key:"List"},{key:"Table"},{key:"Object"}],path:"type"},parameters:{tags:["general"],label:"{i18n>CARD_EDITOR.PARAMETERS}",addItemLabel:"{i18n>CARD_EDITOR.ADD.PARAMETER}",path:"configuration/parameters",type:"parameters",allowedTypes:["string","array","number","boolean","integer","date","datetime","simpleicon","object","objectArray","group","separator"]},destinations:{tags:["general"],label:"{i18n>CARD_EDITOR.DESTINATIONS}",itemLabel:"{key}",addItemLabel:"{i18n>CARD_EDITOR.DESTINATION}",path:"configuration/destinations",type:"destinations",allowedValues:["Northwind","JAM"]},filters:{tags:["general"],label:"{i18n>CARD_EDITOR.FILTERS}",itemLabel:"{key}",addItemLabel:"{i18n>CARD_EDITOR.FILTER}",path:"configuration/filters",type:"filters",allowedTypes:["Select","DateRange","Search"]}},i,e,r,a,n,o(["general-data"],"","card"),o(["header"],"header/","header"),o(["content"],"content/","content")),propertyEditors:{enum:"sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor",select:"sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor",multiSelect:"sap/ui/integration/designtime/baseEditor/propertyEditor/multiSelectEditor/MultiSelectEditor",string:"sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor",simpleicon:"sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor",array:"sap/ui/integration/designtime/baseEditor/propertyEditor/arrayEditor/ArrayEditor",parameters:"sap/ui/integration/designtime/cardEditor/propertyEditor/parametersEditor/ParametersEditor",boolean:"sap/ui/integration/designtime/baseEditor/propertyEditor/booleanEditor/BooleanEditor",number:"sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor",integer:"sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor",json:"sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor",map:"sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor",list:"sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor",datetime:"sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor",date:"sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor",group:"sap/ui/integration/designtime/baseEditor/propertyEditor/groupEditor/GroupEditor",separator:"sap/ui/integration/designtime/baseEditor/propertyEditor/separatorEditor/SeparatorEditor",textArea:"sap/ui/integration/designtime/baseEditor/propertyEditor/textAreaEditor/TextAreaEditor",code:"sap/ui/integration/designtime/baseEditor/propertyEditor/codeEditor/CodeEditor",object:"sap/ui/integration/designtime/baseEditor/propertyEditor/codeEditor/CodeEditor",objectArray:"sap/ui/integration/designtime/baseEditor/propertyEditor/objectArrayEditor/ObjectArrayEditor",icon:"sap/ui/integration/designtime/cardEditor/propertyEditor/iconEditor/IconEditor",complexMap:"sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor",destinations:"sap/ui/integration/designtime/cardEditor/propertyEditor/destinationsEditor/DestinationsEditor",filters:"sap/ui/integration/designtime/cardEditor/propertyEditor/filtersEditor/FiltersEditor"},validators:{patternList:"sap/ui/integration/designtime/cardEditor/validator/IsPatternMatchList"},i18n:"sap/ui/integration/designtime/cardEditor/i18n/i18n.properties"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_omit","sap/base/util/restricted/_merge","sap/base/util/deepClone","sap/ui/integration/cards/filters/DateRangeFilter"],function(e,t,a,i,r){"use strict";var n=e.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.complexMapEditor.ComplexMapEditor",{xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.complexMapEditor.ComplexMapEditor",metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer().render});n.configMetadata=Object.assign({},e.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},keyLabel:{defaultValue:"{i18n>CARD_EDITOR.COMPLEX_MAP.KEY}"}});n.prototype.getExpectedWrapperCount=function(){return 1};n.prototype.onFragmentReady=function(){this._oNestedArrayEditor=this.getContent();this._oNestedArrayEditor.attachValueChange(function(e){var r=e.getParameter("previousValue")||[];var n=i(e.getParameter("value")||[]);var o={};var s=this.getDesigntimeProperties();n=n.map(function(e,a){if(typeof e.key==="undefined"){var r="key";var l=0;var u=function(e){return e.key===r};while(n.some(u)){r="key"+ ++l}e.key=r}var p={};s.forEach(function(t){p[t]=i(e[t])});o[e.key]={__value:p};return t(e,s)});var l=this._processOutputValue(n);r.forEach(function(e){var t=e.key;if(t!==undefined&&!l.hasOwnProperty(t)){o[t]=null}});this.setValue(l);this.setDesigntimeMetadata(a({},this.getConfig().designtime,o))},this)};n.prototype._processInputValue=function(e){var t=this.getDesigntimeProperties();if(!e){e={}}var a=Object.keys(e).map(function(a){var r=i(e[a]);r.key=a;var n=this.getNestedDesigntimeMetadataValue(a);t.forEach(function(e){r[e]=n[e]});return r}.bind(this));if(this.getConfig().type==="filters"){for(var r=0;r<a.length;r++){if(!a[r].options){var n=this._getDefaultFilterOptions();a[r].options=n}if(a[r].type===undefined){a[r].selectedOptions=[]}if(a[r].type==="Select"){a[r].sValue=a[r].value;delete a[r].value;a[r].selectedOptions=[]}else if(a[r].type==="DateRange"){if(!a[r].value){a[r].value={option:"today",values:[]}}a[r].dValue=a[r].value;delete a[r].value;var o=[];for(var s=0;s<a[r].options.length;s++){o.push({key:a[r].options[s],title:a[r].options[s]})}a[r].selectedOptions=o}else if(a[r].type==="Search"){delete a[r].options;delete a[r].selectedOptions;a[r].sValue=a[r].value;delete a[r].value}}}return a};n.prototype.getDesigntimeProperties=function(){return[]};n.prototype.onBeforeConfigChange=function(e){var t={};if(e["allowKeyChange"]){t={key:{label:e["keyLabel"],type:"string",path:"key",validators:{uniqueKey:{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue())}.bind(this),currentKey:function(e){return e.getValue()}}}}}}}var i=a({},{template:t,allowSorting:false},e,{type:"array",path:""});this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{nestedConfig:i}));return e};n.prototype.setValue=function(t){var a=this._processInputValue(t);this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{nestedValue:a}));e.prototype.setValue.call(this,t)};n.prototype._processOutputValue=function(e){if(this.getConfig().type==="filters"){for(var a=0;a<e.length;a++){if(e[a].type==="Select"){e[a].value=e[a].sValue;delete e[a].sValue}else if(e[a].type==="DateRange"&&e[a].selectedOptions){e[a].value=e[a].dValue;delete e[a].dValue;delete e[a].selectedOptions}else if(e[a].type==="Search"){e[a].value=e[a].sValue;delete e[a].sValue;delete e[a].dValue}}}var i={};e.forEach(function(e){i[e.key]=t(e,"key")});return i};n.prototype._getDefaultFilterOptions=function(){var e=new r;var t=e._getDefaultOptions();return t};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/propertyEditor/destinationsEditor/DestinationsEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","sap/base/util/restricted/_merge"],function(e,t,a){"use strict";var r=t.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.destinationsEditor.DestinationsEditor",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer().render});r.configMetadata=Object.assign({},t.configMetadata,{allowedValues:{defaultValue:[],mergeStrategy:"intersection"}});r.prototype.onBeforeConfigChange=function(e){var r={};if(e["allowKeyChange"]){r={template:{label:{label:this.getI18nProperty("CARD_EDITOR.LABEL"),type:"string",path:"label"},name:{label:this.getI18nProperty("CARD_EDITOR.DESTINATION.NAME"),type:"select",path:"name",items:(e["allowedValues"]||[]).map(function(e){return{key:e}}),allowCustomValues:true,allowBindings:false},defaultUrl:{label:this.getI18nProperty("CARD_EDITOR.DESTINATION.DEFAULT_URL"),type:"string",path:"defaultUrl"}}}}else{r={collapsibleItems:false,showItemLabel:false,template:{name:{label:"{= ${label} || ${key}}",type:"select",path:"name",items:(e["allowedValues"]||[]).map(function(e){return{key:e}}),allowCustomValues:false,allowBindings:false}}}}var i=a({},r,e);return t.prototype.onBeforeConfigChange.call(this,i)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/propertyEditor/filtersEditor/FiltersEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","sap/base/util/restricted/_merge","sap/ui/integration/util/DateRangeHelper"],function(e,t,i,a){"use strict";var l=t.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.filtersEditor.FiltersEditor",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer().render});l.configMetadata=Object.assign({},t.configMetadata,{allowedValues:{defaultValue:[],mergeStrategy:"intersection"}});l.prototype.onBeforeConfigChange=function(e){var a={};if(e["allowKeyChange"]){a={template:{key:{label:this.getI18nProperty("CARD_EDITOR.FILTER.KEY"),path:"key",type:"string",enabled:e.allowKeyChange,allowBindings:false,validators:[{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue())}.bind(this),currentKey:function(e){return e.getValue()}}}]},type:{label:this.getI18nProperty("CARD_EDITOR.FILTER.TYPE"),path:"type",type:"select",items:(e["allowedTypes"]||[]).map(function(e){return{key:e}}),allowCustomValues:true,allowBindings:false},label:{label:this.getI18nProperty("CARD_EDITOR.FILTER.LABEL"),path:"label",type:"string"},description:{label:this.getI18nProperty("CARD_EDITOR.FILTER.DESCRIPTION"),type:"string",path:"description",visible:"{= ${type} === 'Select' || ${type} === 'DateRange'}",allowCustomValues:true,allowBindings:false},value:{label:this.getI18nProperty("CARD_EDITOR.FILTER.NORMALVALUE"),path:"sValue",type:"string",visible:"{= ${type} === 'Select'}"},placeholder:{label:this.getI18nProperty("CARD_EDITOR.FILTER.PLACEHOLDER"),path:"placeholder",type:"string",visible:"{= ${type} === 'Search'}"},itemPath:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEM.PATH"),path:"item/path",type:"string",visible:"{= ${type} === 'Select'}",enabled:"{= ${items} === undefined || ${items} === null}"},itemTemplateKey:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEM.TEMPLATE.KEY"),path:"item/template/key",type:"string",visible:"{= ${type} === 'Select'}",enabled:"{= ${items} === undefined || ${items} === null}"},itemTemplateTitle:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEM.TEMPLATE.TITLE"),path:"item/template/title",type:"string",visible:"{= ${type} === 'Select'}",enabled:"{= ${items} === undefined || ${items} === null}"},itemData:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEM.DATA"),path:"data",type:"json",visible:"{= ${type} === 'Select'}",enabled:"{= ${items} === undefined || ${items} === null}"},items:{label:this.getI18nProperty("CARD_EDITOR.FILTER.ITEMS"),path:"items",type:"json",visible:"{= ${type} === 'Select'}",enabled:"{= ${item/template/key} === undefined || ${item/template/key} === ''}"},dateRangeOptions:{label:this.getI18nProperty("CARD_EDITOR.FILTER.OPTIONS"),path:"options",type:"multiSelect",items:this.getAllDateRangeOptions(),visible:"{= ${type} === 'DateRange'}"},dateRangeValueOption:{label:this.getI18nProperty("CARD_EDITOR.FILTER.VALUE.OPTION"),path:"dValue/option",type:"select",items:"{selectedOptions}",visible:"{= ${type} === 'DateRange'}"},dateRangeValues:{label:this.getI18nProperty("CARD_EDITOR.FILTER.VALUE.VALUES"),path:"dValue/values",type:"code",visible:"{= ${type} === 'DateRange'}"}}}}else{a={collapsibleItems:false,showItemLabel:false,template:{type:{label:this.getI18nProperty("CARD_EDITOR.FILTER.TYPE"),type:"select",path:"type",items:(e["allowedTypes"]||[]).map(function(e){return{key:e}}),allowCustomValues:false,allowBindings:false}}}}var l=i({},a,e);return t.prototype.onBeforeConfigChange.call(this,l)};l.prototype.getAllDateRangeOptions=function(){var e=a.getAllOptions();var t=[];for(var i in e){if(e.hasOwnProperty(i)){t.push({key:e[i],title:e[i]})}}return t};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/propertyEditor/iconEditor/IconEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/ui/core/Fragment","sap/ui/unified/ColorPickerPopover","sap/ui/unified/library","sap/ui/model/json/JSONModel","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_omit","sap/ui/core/IconPool"],function(t,e,o,i,s,a,n,r,l,g,p){"use strict";var c=t.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",{metadata:{library:"sap.ui.integration"},xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",renderer:t.getMetadata().getRenderer().render});c.configMetadata=Object.assign({},t.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.ICON"}});var d={config:{type:"simpleicon"},key:"src"};var u={config:{type:"string",maxLength:2,validators:{isAlphabetic:{type:"pattern",config:{pattern:"^[A-Za-z]*$"},errorMessage:"CARD_EDITOR.VALIDATOR.NOT_AN_ALPHABETIC"}}},key:"text"};var h={config:{type:"string"},key:"src"};var _={type:"icon",src:"",shape:"Circle",alt:"",text:"",backgroundColor:"",color:""};var f=s.ColorPickerMode;var y=s.ColorPickerDisplayMode;c.prototype.init=function(){this._oIconModel=new a(n(_));this._oIconModel.setDefaultBindingMode("OneWay");this.setModel(this._oIconModel,"icon");this._oConfigsModel=new a({selectConfig:{type:"select",items:[],allowBindings:false},valueConfig:d});this._oConfigsModel.setDefaultBindingMode("OneWay");this.setModel(this._oConfigsModel,"configs");this._oSettingsModel=new a({shapes:[],altVisible:true,backgroundColorVisible:false,colorVisible:false});this._oSettingsModel.setDefaultBindingMode("OneWay");this.setModel(this._oSettingsModel,"settings");this.attachModelContextChange(function(){if(this.getModel("i18n")){var t=n(this._oConfigsModel.getData());t.selectConfig.items=[{key:"icon",title:this.getI18nProperty("BASE_EDITOR.ICON.TYPE_ICON")},{key:"text",title:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_TEXT_LABEL")},{key:"picture",title:this.getI18nProperty("BASE_EDITOR.ICON.TYPE_PICTURE")}];this._oConfigsModel.setData(t);var e=n(this._oSettingsModel.getData());e.shapes=[{key:"Square",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_SQUARE")},{key:"Circle",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_CIRCLE")}];this._oSettingsModel.setData(e)}},this)};c.prototype.getExpectedWrapperCount=function(){return 2};c.prototype.setValue=function(e){var o=l(e)?undefined:e;t.prototype.setValue.call(this,o);this._oIconModel.setData(Object.assign({},this._oIconModel.getData(),e,{type:this.getDesigntimeMetadataValue().type||C(e)}))};function C(t){if(r(t)){if(t.src){if(t.backgroundColor||t.color||p.isIconURI(t.src)&&p.getIconInfo(t.src)||e(t.src,false)){return"icon"}else{return"picture"}}else if(t.text){return"text"}}return _.type}c.prototype._prepareValue=function(t,e){return e[t]};c.prototype._onTypeChange=function(t){var e;var o=t.getSource().getValue();switch(o){case"icon":e=d;this._oSettingsModel.setProperty("/altVisible",true);break;case"text":e=u;this._oSettingsModel.setProperty("/altVisible",false);break;case"picture":e=h;this._oSettingsModel.setProperty("/altVisible",true);break}this._oConfigsModel.setData(Object.assign({},this._oConfigsModel.getData(),{valueConfig:e}));this.setDesigntimeMetadataValue({type:o});this.setValue(this._processOutputValue(this._oIconModel.getData()))};c.prototype._updateValue=function(t){var e=this._oConfigsModel.getData().valueConfig.key;var o={};o[e]=t.getSource().getValue();var i=Object.assign({},this._oIconModel.getData(),o);this.setValue(this._processOutputValue(i))};c.prototype._handleSettings=function(){this._oOldData=n(this.getModel("icon").getData());if(!this._oSettingsDialog){return o.load({name:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditorSettingsDialog",controller:this}).then(function(t){this._oDialogModel=new a(this._oOldData);this._oSettingsDialog=t;this._oSettingsDialog.setModel(this._oDialogModel,"data");this.addDependent(this._oSettingsDialog);this._oSettingsDialog.open();return this._oSettingsDialog}.bind(this))}else{this._oSettingsDialog.open();this._oDialogModel.setData(this._oOldData);return Promise.resolve(this._oSettingsDialog)}};c.prototype._onSettingsSave=function(){this._oSettingsDialog.close();this.setValue(this._processOutputValue(this._oDialogModel.getData()))};c.prototype._onSettingsCancel=function(){this._oSettingsDialog.close()};c.prototype._processOutputValue=function(t){var e=this.getDesigntimeMetadataValue().type;var o=["type"];Object.keys(t).forEach(function(e){if(!t[e]||t[e]===_[e]){o.push(e)}});switch(e){case"icon":o.push("text");if(!t["src"]){o.push("shape","alt","backgroundColor","color")}break;case"picture":o.push("text","backgroundColor","color");if(!t["src"]){o.push("shape","alt")}break;case"text":o.push("src","alt");if(!t["text"]){o.push("shape","backgroundColor","color")}break}return g(t,o)};c.prototype._openColorPickerPopup=function(t){this._inputId=t.getSource().getId();if(!this.oColorPickerSimplifiedPopover){this.oColorPickerSimplifiedPopover=new i("oColorPickerSimpplifiedPopover",{colorString:"blue",displayMode:y.Simplified,mode:f.HSL,change:this._handleColorPickerChange.bind(this)})}this.oColorPickerSimplifiedPopover.openBy(t.getSource())};c.prototype._handleColorPickerChange=function(t){var e=sap.ui.getCore().byId(this._inputId);e.setValue(t.getParameter("hex"));e.setValueState("None");this._inputId=""};c.prototype.getFocusDomRef=function(){var t=this.getContent();if(t){return this.getContent().getItems()[0].getContent()[0].getFocusDomRef()}};c.prototype.getIdForLabel=function(){var t=this.getContent();if(t){return this.getContent().getItems()[0].getContent()[0].getIdForLabel()}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/propertyEditor/parametersEditor/ParametersEditor", ["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor","sap/base/util/restricted/_merge","sap/base/util/deepEqual"],function(e,t,a,r){"use strict";var i=t.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.parametersEditor.ParametersEditor",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer().render});i.configMetadata=Object.assign({},t.configMetadata,{allowLabelChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});i.prototype.getBoolenValue=function(e,t,a){if(typeof e==="boolean"){return e}if(typeof t==="boolean"){return t}return a};i.prototype.formatItemConfig=function(e){var a=t.prototype.formatItemConfig.apply(this,arguments);var r=e.key;var i=e.value.type;var l=this.getNestedDesigntimeMetadataValue(r);var o=this.getBoolenValue(e.value.visible,l.visible,true);var n=this.getBoolenValue(e.value.visibleToUser,l.visibleToUser,true);var s=this.getBoolenValue(e.value.editable,l.editable,true);var p=this.getBoolenValue(e.value.editableToUser,l.editableToUser,true);var u=e.value.maxLength||l.maxLength||0;var g=this.getBoolenValue(e.value.required,l.required,false);var E=this.getBoolenValue(e.value.expanded,l.expanded,true);var R=e.value.level||l.level||"0";var v=e.value.manifestpath||l.manifestpath||"";var y=e.value.description||l.description||"";var d=this.getBoolenValue(e.value.translatable,l.translatable,false);var A=this.getBoolenValue(e.value.allowSettings,l.allowSettings,true);var b=this.getBoolenValue(e.value.allowDynamicValues,l.allowDynamicValues,false);var h=e.value.visualization||l.visualization;var I=e.value.values||l.values;var T=e.value.properties||l.properties;var D=e.value.label||l.label;var m=e.value.placeholder||l.placeholder||"";var P=e.value.validations||l.validations;var c=e.value.hint||l.hint||"";var O=e.value.formatter||l.formatter;var C=e.value.layout||l.layout;a[2].visible=!(i==="group"||i==="array"||i==="separator");a.push({label:this.getI18nProperty("CARD_EDITOR.LABEL"),path:"label",value:D,placeholder:D?undefined:r,visible:i!=="separator",type:"string",enabled:this.getConfig().allowLabelChange,itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.LEVEL"),path:"level",value:R,type:"select",items:[{key:"0",title:"0"},{key:"1",title:"1"}],visible:i==="group",itemKey:r,allowBindings:true},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.DESCRIPTION"),path:"description",value:y,allowBindings:true,visible:i!=="group"&&i!=="separator",type:"string",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.HINT"),path:"hint",value:c,allowBindings:true,enabled:true,visible:i!=="separator",type:"string",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.FORMATTER"),path:"formatter",value:O,allowBindings:true,enabled:true,visible:i==="date"||i==="datetime"||i==="number"||i==="integer",type:"code",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.PLACEHOLDER"),path:"placeholder",value:m,allowBindings:true,visible:i==="string",type:"string",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.MANIFESTPATH"),path:"manifestpath",value:v,allowBindings:true,visible:i!=="group"&&i!=="separator",type:"string",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VISIBLE"),path:"visible",value:o,allowBindings:true,type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VISIBLETOUSER"),path:"visibleToUser",value:n,allowBindings:true,type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.EDITABLE"),path:"editable",allowBindings:true,value:s,enabled:true,visible:i!=="group"&&i!=="separator",type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.EDITABLETOUSER"),path:"editableToUser",allowBindings:true,value:p,enabled:true,visible:i!=="group"&&i!=="separator",type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.MAXLENGTH"),path:"maxLength",allowBindings:true,value:u,enabled:true,visible:i==="string",type:"integer",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.REQUIRED"),path:"required",allowBindings:true,value:g,visible:i==="string"||i==="number"||i==="integer",enabled:true,type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.EXPANDED"),path:"expanded",allowBindings:true,value:E,enabled:true,visible:i==="group",type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.TRANSLATABLE"),path:"translatable",value:d,enabled:true,visible:i==="string",type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.ALLOWDYNAMICVALUES"),path:"allowDynamicValues",allowBindings:true,enabled:true,value:b,visible:i!=="group"&&i!=="separator",type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.ALLOWSETTINGS"),path:"allowSettings",allowBindings:true,value:A,visible:i!=="group"&&i!=="separator",type:"boolean",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VISUALIZATION"),path:"visualization",allowBindings:true,value:h,visible:i!=="separator"&&i!=="object"&&i!=="objectArray",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VISUALIZATION.PLACEHOLDER"),type:"code",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VALIDATIONS"),path:"validations",allowBindings:true,value:P,visible:i==="string"||i==="number"||i==="integer"||i==="boolean",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VALIDATIONS.PLACEHOLDER"),type:"code",codeType:"javascript",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VALUES"),path:"values",allowBindings:true,value:I,visible:i==="string"||i==="array"||i==="object"||i==="objectArray",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.VALUES.PLACEHOLDER"),type:"code",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.PROPERTIES"),path:"properties",allowBindings:true,value:T,visible:i==="object"||i==="objectArray",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.PROPERTIES.PLACEHOLDER"),type:"code",itemKey:r},{label:this.getI18nProperty("CARD_EDITOR.PARAMETERS.LAYOUT"),path:"layout",allowBindings:true,value:C,visible:i!=="group"&&i!=="separator",placeholder:this.getI18nProperty("CARD_EDITOR.PARAMETERS.LAYOUT.PLACEHOLDER"),type:"code",itemKey:r});return a};i.prototype.processInputValue=function(e){return e};i.prototype.processOutputValue=function(e){return e};i.prototype._configItemsFormatter=function(e){return Array.isArray(e)?e.map(function(e){var t=this.getNestedDesigntimeMetadataValue(e.key);var r=a({},e.value,t);if(!r.label){r.label=e.key}r.itemKey=e.key;r.path="value";r.designtime=this.getNestedDesigntimeMetadata(e.key);return r}.bind(this)):[]};i.prototype.getItemChangeHandlers=function(){return Object.assign({},t.prototype.getItemChangeHandlers.apply(this,arguments),{label:this._onDesigntimeChange})};i.prototype.onBeforeConfigChange=function(e){if(!e.allowTypeChange&&!e.allowKeyChange){this.setFragment("sap.ui.integration.designtime.cardEditor.propertyEditor.parametersEditor.ParametersConfigurationEditor",function(){return 1})}return e};i.prototype._isValidItem=function(e,t){var a=t.type;var r=t.value;var i=this._getAllowedTypes();return a&&i.includes(a)||typeof r==="string"&&i.includes("string")};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/util/CommonPatterns", function(){"use strict";return{email:new RegExp(/^(?:(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>)|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*:(?:(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>)(?:,\s*(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>))*)?;\s*)$/).source}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/cardEditor/validator/IsPatternMatchList", ["sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch"],function(e){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FAILED_PATTERN_TEST",validate:function(t,a){return(t||[]).every(function(t){return e.validate(t,a)})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/editor/Card", ["./CardRenderer","sap/ui/integration/widgets/Card"],function(e,r){"use strict";var a=r.extend("sap.ui.integration.designtime.editor.Card",{metadata:{library:"sap.ui.integration",properties:{readonly:{type:"boolean",group:"Behavior",defaultValue:false},readonlyZIndex:{type:"int",group:"Behavior",defaultValue:1}}},renderer:e});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/editor/CardEditor", ["sap/ui/integration/editor/Editor","sap/ui/core/Core","sap/ui/integration/widgets/Card","sap/ui/integration/editor/Merger","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/ui/model/resource/ResourceModel","sap/ui/integration/library","sap/ui/integration/designtime/editor/CardPreview","sap/base/util/extend"],function(e,t,i,r,a,n,s,o,d,g){"use strict";var _=t.getLibraryResourceBundle("sap.ui.integration");var u=o.CardDataMode;var l=e.extend("sap.ui.integration.designtime.editor.CardEditor",{metadata:{library:"sap.ui.integration",properties:{card:{type:"any",defaultValue:null}},aggregations:{_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"}}},renderer:e.getMetadata().getRenderer().render});l.prototype.hasPreview=function(){var e=this.getAggregation("_preview");if(e){if(e.getSettings()&&e.getSettings().preview&&e.getSettings().preview.modes==="None"){return false}return true}return false};l.prototype.getSeparatePreview=function(){var e=this.getPreviewPosition();if(!this.isReady()||e!=="separate"){return null}return this._initPreview()};l.prototype._updatePreview=function(){var e=this.getAggregation("_preview");if(e&&e.update&&e._getCurrentMode()!=="None"){e.update()}};l.prototype.setCard=function(e,r){if(e===this.getProperty("card")){return this}if(this._oEditorCard){this._oEditorCard.destroy()}this.setProperty("card",e,r);if(typeof e==="string"){try{e=JSON.parse(e)}catch(i){var a=t.byId(e);if(!a){var n=document.getElementById(e);if(n&&n.tagName&&n.tagName.toUpperCase()==="ui-integration-card".toUpperCase()){a=n._getControl()}}e=a}}if(e&&e.isA&&e.isA("sap.ui.integration.widgets.Card")){e={manifest:e.getManifest(),manifestChanges:e.getManifestChanges(),host:e.getHost(),baseUrl:e.getBaseUrl(),dataMode:u.Active}}if(typeof e==="object"){if(!e.dataMode){e.dataMode=u.Active}this._oEditorCard=new i(e);this._oEditorCard.onBeforeRendering();this._oEditorCard.attachEventOnce("_dataReady",function(){this.propagateModels(this._oEditorCard,this,["i18n","context","contextflat"]);this.setJson(e,r)}.bind(this))}};l.prototype.propagateModels=function(e,t,i){var r=g({},e.oPropagatedProperties.oModels,e.oModels),a=Object.keys(r),n=e.getModel();if(n){t.setModel(n)}i=i||[];a.forEach(function(r){if(r==="undefined"){return}if(i.includes(r)){return}var a=e.getModel(r);if(a){t.setModel(a,r)}})};l.prototype.createManifest=function(e,t){this._isManifestReady=false;if(this._oEditorManifest){this._oEditorManifest.destroy()}this.destroyAggregation("_extension");var i=r.layers[this.getMode()];this._oEditorManifest=this._oEditorCard._oCardManifest;this._registerManifestModulePath();var o=this._oEditorManifest._oInitialJson;this._oInitialManifestModel=new a(o);this.setProperty("json",o,t);var d;if(this._beforeLayerManifestChanges){d=r.mergeDelta(o,[this._beforeLayerManifestChanges])}else{d=o}var g=n({},d);this._beforeManifestModel=new a(g);if(i<r.layers["translation"]&&this._currentLayerManifestChanges){d=r.mergeDelta(d,[this._currentLayerManifestChanges])}this._manifestModel=new a(d);this._isManifestReady=true;this.fireManifestReady();this._initResourceBundlesForMultiTranslation();this._createContextModel();if(this._oEditorManifest&&this._oEditorManifest.getResourceBundle()){var _=this._oEditorManifest.getResourceBundle();var u=new s({bundle:_});this.setModel(u,"i18n");if(this._oResourceBundle){u.enhance(this._oResourceBundle)}this._oResourceBundle=u.getResourceBundle()}return this._loadExtension().then(function(){this._initInternal()}.bind(this))};l.prototype._initPreview=function(){var e=this._oDesigntimeInstance.getSettings()||{};e.preview=e.preview||{};e.preview.position=this.getPreviewPosition();var t=new d({settings:e,card:this._oEditorCard,parentWidth:this.getWidth(),parentHeight:this.getHeight()});this.setAggregation("_preview",t);t.setAssociation("_editor",this);return t};l.prototype._loadExtension=function(){return new Promise(function(e,t){var i=this._oEditorCard.getAggregation("_extension");this.setAggregation("_extension",i);e()}.bind(this))};l.prototype._mergeContextData=function(e){var t={};t["empty"]=l._contextEntries.empty;for(var i in e){t[i]=e[i]}t["card.internal"]=l._contextEntries["card.internal"];return t};l._contextEntries={empty:{label:_.getText("CARDEDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:_.getText("CARDEDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"card.internal":{label:_.getText("CARDEDITOR_CONTEXT_CARD_INTERNAL_VAL"),todayIso:{type:"string",label:_.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),description:_.getText("CARDEDITOR_CONTEXT_CARD_TODAY_DESC"),tags:[],placeholder:_.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:_.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),description:_.getText("CARDEDITOR_CONTEXT_CARD_NOW_DESC"),tags:[],placeholder:_.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:_.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),description:_.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:_.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/editor/CardPreview", ["sap/ui/integration/library","sap/ui/core/Control","sap/m/HBox","sap/m/Image","sap/m/ToggleButton","./Card","sap/ui/core/Core","sap/ui/dom/includeStylesheet"],function(e,t,i,o,r,s,a,n){"use strict";var g=e.CardDataMode,l=e.CardPreviewMode;var d=t.extend("sap.ui.integration.designtime.editor.CardPreview",{metadata:{library:"sap.ui.integration",properties:{settings:{type:"any"},card:{type:"object"},parentWidth:{type:"sap.ui.core.CSSSize"},parentHeight:{type:"sap.ui.core.CSSSize"}},aggregations:{cardPreview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{_editor:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2,render:function(e,t){if(t._getCurrentMode()==="None"){e.openStart("div",t);e.openEnd();e.close("div");return}e.openStart("div",t);e.class("sapUiIntegrationDTPreview");if(u()){e.class("sapUiIntegrationDTPreviewDark")}var i=t.getSettings().preview.position;if(i==="separate"){e.class("sapUiIntegrationDTPreviewSeparate");document.body.style.setProperty("--sapUiIntegrationEditorPreviewWidth","100%");document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight","100%")}e.openEnd();e.openStart("div",t.getId()+"-card");if(!t.getSettings().preview||t.getSettings().preview.scaled!==false){if(t._getCurrentSize()!=="Full"){e.class("sapUiIntegrationDTPreviewScale");var o=a.getConfiguration().getLanguage().replaceAll("_","-");if(o.startsWith("ar")||o.startsWith("he")){e.class("withSpec")}else{e.class("noSpec")}}else{e.class("sapUiIntegrationDTPreviewNoScale")}}else{e.class("sapUiIntegrationDTPreviewNoScale")}e.openEnd();e.openStart("div",t.getId()+"-before");e.attr("tabindex","-1");e.openEnd();e.close("div");e.renderControl(t._getCardPreview());e.openStart("div",t.getId()+"-after");e.attr("tabindex","-1");e.openEnd();e.close("div");e.close("div");var r=t._getModes();if(r.indexOf("Abstract")>-1&&(r.indexOf("Live")>-1||r.indexOf("MockData")>-1)){e.renderControl(t._getModeToggleButton())}if(r!=="Abstract"&&(!i||i==="right"||i==="left")){e.renderControl(t._getResizeToggleButton())}if(i==="top"||i==="bottom"){document.body.style.setProperty("--sapUiIntegrationEditorPreviewWidth",t.getEditor().getWidth())}document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",t.getEditor().getHeight());e.close("div")}}});d.prototype.init=function(){this._oResourceBundle=a.getLibraryResourceBundle("sap.ui.integration");a.attachThemeChanged(function(){if(this.getDomRef()){if(u()){this.getDomRef().classList.add("sapUiIntegrationDTPreviewDark")}else{this.getDomRef().classList.remove("sapUiIntegrationDTPreviewDark")}}else{this.update()}}.bind(this))};d.prototype.destroy=function(){if(this._oModeToggleButton){this._oModeToggleButton.destroy()}if(this._oCardPreview){this._oCardPreview.destroy()}if(this._oImagePlaceholder){this._oImagePlaceholder.destroy()}if(this._oCardPlaceholder){this._oCardPlaceholder.destroy()}t.prototype.destroy.apply(this,arguments);document.body.style.removeProperty("--sapUiIntegrationEditorPreviewWidth");document.body.style.removeProperty("--sapUiIntegrationEditorPreviewHeight");document.body.style.removeProperty("--sapUiIntegrationEditorPreviewCardHeight")};d.prototype.onAfterRendering=function(){var e=this.getAggregation("cardPreview"),t=this._getModes();if((t.indexOf("Live")>-1||t.indexOf("MockData")>-1)&&e&&e.getDomRef()&&e.getDomRef().getElementsByClassName("sapVizFrame")){window.setTimeout(function(){try{var t=e.getDomRef().getElementsByClassName("sapVizFrame")[0].id;var i=a.byId(t);if(i.getVizProperties()&&i.getVizProperties().legendGroup.layout.position==="bottom"&&i.getVizProperties().legendGroup.layout.alignment==="center"){e.getDomRef().getElementsByClassName("v-m-legend")[0].transform.baseVal[0].matrix.e=110}}catch(e){}},500)}};d.prototype.getEditor=function(){var e=this.getAssociation("_editor");return a.byId(e)};d.prototype._getCardPreview=function(){var e=null;if(this._getCurrentMode()==="Abstract"&&this.getSettings().preview.src){e=this._getImagePlaceholder()}else if(this._getCurrentMode()!=="None"){e=this._getCardRealPreview()}if(e){this.setAggregation("cardPreview",e);e.removeStyleClass("sapUiIntegrationDTPreviewCard");e.addStyleClass("sapUiIntegrationDTPreviewCard")}return e};d.prototype.getTransformContentInfo=function(){return{transformStyle:"scale3d(0.45, 0.45, 1)",transformFactor:.45,transformOriginStyle:"0 0",widthStyle:"400px + 10rem",heightStyle:"700px - 1.5rem",zIndex:this.getEditor()._iZIndex}};d.prototype._getCardRealPreview=function(){var e=this;if(!this._oCardPreview){var t=!this.getSettings().preview.interactive;this._oCardPreview=new s({dataMode:g.Active,readonly:t,readonlyZIndex:this.getEditor()._iZIndex+1});this._oCardPreview.setBaseUrl(this.getCard().getBaseUrl());if(t){this._oCardPreview.onfocusin=this._onfocusin.bind(this)}this._oCardPreview.attachEvent("_ready",function(){var e=this._oCardPreview.getCardContent();if(e){e.addEventDelegate({onAfterRendering:function(){this._resetHeight()}},this)}}.bind(this));this._oCardPreview.onAfterRendering=function(){s.prototype.onAfterRendering.call(this);e._resetHeight()}}if(this._currentMode==="MockData"){this._oCardPreview.setPreviewMode(l.MockData)}else if(this._currentMode==="Abstract"){this._oCardPreview.setPreviewMode(l.Abstract)}else if(this._currentMode==="Live"){this._oCardPreview.setPreviewMode(l.Off)}this._initalChanges=this._initalChanges||this._oCardPreview.getManifestChanges()||[];var i=this._initalChanges.concat([this.getEditor().getCurrentSettings()]);this._oCardPreview.setManifestChanges(i);this._oCardPreview.setManifest(this.getCard()._oCardManifest._oManifest.getRawJson());this._oCardPreview.setHost(this.getCard().getHost());this._oCardPreview.refresh();this._oCardPreview.editor=this._oCardPreview.editor||{};this._oCardPreview.preview=this._oCardPreview.editor.preview=this;return this._oCardPreview};d.prototype._resetHeight=function(){var e=this._oCardPreview.getDomRef();if(e){var t=e.offsetHeight;if(this._getCurrentSize()!=="Full"){document.body.style.setProperty("--sapUiIntegrationEditorPreviewCardHeight",t*.45+"px")}else{document.body.style.setProperty("--sapUiIntegrationEditorPreviewCardHeight",t+"px")}}};d.prototype._getImagePlaceholder=function(){var e=this.getSettings();if(e.preview.src){if(!this._oImagePlaceholder){var t=new i;t.addStyleClass("sapFCard");var r=this.getCard().getBaseUrl();if(!r&&typeof this.getCard().getManifest()==="string"){r=this.getCard().getManifest();r=r.substring(0,r.lastIndexOf("/")+1)}var s=r+"/"+e.preview.src;var a=new o({src:s});a.addStyleClass("sapUiIntegrationDTPreviewImg");t.addItem(a);this._oImagePlaceholder=t}}return this._oImagePlaceholder};d.prototype._onfocusin=function(e){if(this._oModeToggleButton){if(e.srcControl!==this._oModeToggleButton&&e.relatedTarget!==this._oModeToggleButton.getDomRef()&&e.relatedTarget!==this.getDomRef("after")){this.getDomRef("after").focus()}else{this.getDomRef("before").focus()}}else if(this._oSizeToggleButton){if(e.srcControl!==this._oSizeToggleButton&&e.relatedTarget!==this._oSizeToggleButton.getDomRef()&&e.relatedTarget!==this.getDomRef("after")){this.getDomRef("after").focus()}else{this.getDomRef("before").focus()}}else if(e.srcControl.isA("sap.f.cards.BaseHeader")){this.getDomRef("after").focus()}else{this.getDomRef("before").focus()}};d.prototype._getModes=function(){var e=this.getSettings();e.preview=e.preview||{};e.preview.modes=e.preview.modes||"Abstract";var t=this.getCard().getManifestEntry("/sap.card/type");if(t!=="Component"){e.preview.modes=e.preview.modes.replace("MockData","Live")}return e.preview.modes};d.prototype._getCurrentMode=function(){var e=this._getModes();if(!this._currentMode){switch(e){case"Abstract":case"AbstractLive":case"AbstractMockData":this._currentMode="Abstract";break;case"Live":case"LiveAbstract":this._currentMode="Live";break;case"MockData":case"MockDataAbstract":this._currentMode="MockData";break;default:this._currentMode="None"}}return this._currentMode};d.prototype._toggleCurrentMode=function(){var e=this._getModes();if(e.indexOf("Abstract")>-1){if(e.indexOf("Live")>-1){this._currentMode=this._getCurrentMode()==="Abstract"?"Live":"Abstract"}else if(e.indexOf("MockData")>-1){this._currentMode=this._getCurrentMode()==="Abstract"?"MockData":"Abstract"}}};d.prototype._getModeToggleButton=function(){var e=a.getLibraryResourceBundle("sap.ui.integration");if(!this._oModeToggleButton){this._oModeToggleButton=new r;this._oModeToggleButton.setTooltip();this._oModeToggleButton.attachPress(function(){this._toggleCurrentMode();this.update()}.bind(this))}this._oModeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewModeButton");this._oModeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewModeButtonSpec");this._oModeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewModeButtonFull");this._oModeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewModeButtonFullSpec");this._oModeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewModeButtonVerticalFull");this._oModeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewModeButtonVerticalFullSpec");var t=a.getConfiguration().getLanguage().replaceAll("_","-");if(this._getCurrentSize()==="Full"){var i=this.getSettings().preview.position;if(t.startsWith("ar")||t.startsWith("he")){if(i==="top"||i==="bottom"||i==="separate"){this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewModeButtonVerticalFullSpec")}else{this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewModeButtonFullSpec")}}else if(i==="top"||i==="bottom"||i==="separate"){this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewModeButtonVerticalFull")}else{this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewModeButtonFull")}}else if(t.startsWith("ar")||t.startsWith("he")){this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewModeButtonSpec")}else{this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewModeButton")}var o=this._oModeToggleButton,s=this._getCurrentMode();if(s==="None"){o.setVisible(false)}if(s==="Abstract"){o.setIcon("sap-icon://media-play");o.setPressed(false);if(this._getModes().indexOf("MockData")>-1){o.setTooltip(e.getText("CARDEDITOR_PREVIEW_BTN_MOCKDATAPREVIEW"))}else{o.setTooltip(e.getText("CARDEDITOR_PREVIEW_BTN_LIVEPREVIEW"))}}else if(s==="Live"||s==="MockData"){o.setIcon("sap-icon://media-pause");o.setPressed(true);o.setTooltip(e.getText("CARDEDITOR_PREVIEW_BTN_SAMPLEPREVIEW"))}return this._oModeToggleButton};d.prototype._getCurrentSize=function(){this._currentSize=this._currentSize||"Normal";var e=this.getSettings();if(e.preview.position&&(e.preview.position==="top"||e.preview.position==="bottom"||e.preview.position==="separate")){this._currentSize="Full"}return this._currentSize};d.prototype._toggleCurrentSize=function(){this._currentSize=this._currentSize!=="Normal"?"Normal":"Full";if(this._currentSize==="Normal"){this.getEditor().setWidth(this.getParentWidth());document.body.style.removeProperty("--sapUiIntegrationEditorPreviewWidth")}else{this.getEditor().setWidth("0");document.body.style.setProperty("--sapUiIntegrationEditorPreviewWidth",this.getParentWidth())}};d.prototype._getResizeToggleButton=function(){var e=a.getLibraryResourceBundle("sap.ui.integration");if(!this._oSizeToggleButton){this._oSizeToggleButton=new r;this._oSizeToggleButton.setTooltip();this._oSizeToggleButton.attachPress(function(){this._toggleCurrentSize();this.update();this.getDomRef("before").focus()}.bind(this))}this._oSizeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewResizeButton");this._oSizeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewResizeButtonSpec");this._oSizeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewResizeButtonFull");this._oSizeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewResizeButtonFullSpec");this._oSizeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewResizeButtonOnly");this._oSizeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewResizeButtonOnlySpec");this._oSizeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewResizeButtonOnlyFull");this._oSizeToggleButton.removeStyleClass("sapUiIntegrationDTPreviewResizeButtonOnlyFullSpec");var t=a.getConfiguration().getLanguage().replaceAll("_","-");if(this._getModes()==="MockData"||this._getModes()==="Live"){if(this._getCurrentSize()==="Full"){if(t.startsWith("ar")||t.startsWith("he")){this._oSizeToggleButton.addStyleClass("sapUiIntegrationDTPreviewResizeButtonOnlyFullSpec")}else{this._oSizeToggleButton.addStyleClass("sapUiIntegrationDTPreviewResizeButtonOnlyFull")}}else if(t.startsWith("ar")||t.startsWith("he")){this._oSizeToggleButton.addStyleClass("sapUiIntegrationDTPreviewResizeButtonOnlySpec")}else{this._oSizeToggleButton.addStyleClass("sapUiIntegrationDTPreviewResizeButtonOnly")}}else{if(this._getCurrentSize()==="Full"){if(t.startsWith("ar")||t.startsWith("he")){this._oSizeToggleButton.addStyleClass("sapUiIntegrationDTPreviewResizeButtonFullSpec")}else{this._oSizeToggleButton.addStyleClass("sapUiIntegrationDTPreviewResizeButtonFull")}}else if(t.startsWith("ar")||t.startsWith("he")){this._oSizeToggleButton.addStyleClass("sapUiIntegrationDTPreviewResizeButtonSpec")}else{this._oSizeToggleButton.addStyleClass("sapUiIntegrationDTPreviewResizeButton")}}var i=this._oSizeToggleButton,o=this._getCurrentMode(),s=this._getCurrentSize();if(o==="None"){i.setVisible(false)}if(s==="Normal"){i.setIcon("sap-icon://full-screen");i.setPressed(false);i.setTooltip(e.getText("CARDEDITOR_PREVIEW_BTN_FULLSIZE"))}else if(s==="Full"){i.setIcon("sap-icon://exit-full-screen");i.setPressed(true);i.setTooltip(e.getText("CARDEDITOR_PREVIEW_BTN_NORMALSIZE"))}return this._oSizeToggleButton};d.prototype.update=function(){this.invalidate()};function u(e){e=e||window.getComputedStyle(document.body).backgroundColor;var t=/rgb\((\d+).*?(\d+).*?(\d+)\)/.exec(e);if(!t){return false}var i=parseInt(t[1]),o=parseInt(t[2]),r=parseInt(t[3]),s=(i*299+o*587+r*114)/1e3;return s<=128}d.init=function(){var e=sap.ui.require.toUrl("sap.ui.integration.designtime.editor.css.CardPreview".replace(/\./g,"/")+".css");n(e);this.init=function(){}};d.init();return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/designtime/editor/CardRenderer", ["sap/ui/integration/widgets/CardRenderer","sap/f/library"],function(e,t){"use strict";var r=t.cards.HeaderPosition;return e.extend("sap.ui.integration.designtime.editor.CardRenderer",{apiVersion:2,render:function(e,t){var n=t.getCardHeader(),i=n&&t.getCardHeaderPosition()===r.Top;e.openStart("div",t);this.renderContainerAttributes(e,t);e.openEnd();if(t.getReadonly()){e.openStart("div",t.getId()+"-readonly");e.attr("tabindex","-1");e.style("z-index",t.getReadonlyZIndex());e.style("position","absolute");e.style("width","100%");e.style("height","100%");e.style("opacity","0.01");e.style("background-color","rgba(222, 222, 222, 0.5)");e.openEnd();e.close("div")}if(i){e.renderControl(n)}this.renderContentSection(e,t);if(!i){e.renderControl(n)}this.renderFooterSection(e,t);e.renderControl(t._ariaText);e.renderControl(t._ariaContentText);e.close("div")}})});
//# sourceMappingURL=library-preload.designtime.js.map
