/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/AdaptFiltersController","sap/ui/mdc/filterbar/aligned/FilterContainer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/m/library","sap/m/Button","sap/base/util/merge","sap/base/Log","sap/ui/core/library","sap/ui/mdc/enums/FilterBarP13nMode"],function(t,e,i,r,n,o,s,a,l,p,u,d){"use strict";const h=u.aria.HasPopup;const _=n.extend("sap.ui.mdc.FilterBar",{metadata:{designtime:"sap/ui/mdc/designtime/filterbar/FilterBar.designtime",properties:{showAdaptFiltersButton:{type:"boolean",defaultValue:true},showClearButton:{type:"boolean",defaultValue:false},p13nMode:{type:"sap.ui.mdc.enums.FilterBarP13nMode[]"},_p13nModeItem:{type:"boolean",visibility:"hidden",defaultValue:false}}},renderer:o});const c=s.ButtonType;_.prototype._createInnerLayout=function(){this._cLayoutItem=r;this._oFilterBarLayout=new i;this._oFilterBarLayout.getInner().setParent(this);this._oFilterBarLayout.getInner().addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._addButtons()};_.prototype.setP13nMode=function(i){this.setProperty("p13nMode",i||[],false);const r={helper:this.getPropertyHelper(),controller:{}};let n=false;i&&i.forEach(function(t){if(t=="Item"){n=true;r.controller["Item"]=new e({control:this})}}.bind(this));this._setP13nModeItem(n);r.controller["Filter"]=new t({control:this});this.getEngine().register(this,r);return this};_.prototype.setFilterConditions=function(e,i){t.checkConditionOperatorSanity(e);if(this._oP13nFB){this._oP13nFB.setFilterConditions(l({},e))}this.setProperty("filterConditions",e,i);return this};_.prototype._getP13nModeItem=function(){return this._oModel.getProperty("/_p13nModeItem")};_.prototype._setP13nModeItem=function(t){this._oModel.setProperty("/_p13nModeItem",t,true)};_.prototype._addButtons=function(){if(this._oFilterBarLayout){this.setProperty("_filterCount",this._oRb.getText("filterbar.ADAPT"),false);this._btnAdapt=new a(this.getId()+"-btnAdapt",{type:c.Transparent,text:"{"+n.INNER_MODEL_NAME+">/_filterCount}",press:this.onAdaptFilters.bind(this)});this._btnAdapt.setAriaHasPopup(h.ListBox);this._btnAdapt.setModel(this._oModel,n.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:"/showAdaptFiltersButton",model:n.INNER_MODEL_NAME},{path:"/_p13nModeItem",model:n.INNER_MODEL_NAME}],formatter:function(t,e){return t&&e}});this._btnSearch=this._getSearchButton();this._btnSearch.setModel(this._oModel,n.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:"/showGoButton",model:n.INNER_MODEL_NAME},{path:"/liveMode",model:n.INNER_MODEL_NAME}],formatter:function(t,e){return t&&(this._isPhone()?true:!e)}.bind(this)});this._btnSearch.addStyleClass("sapUiMdcFilterBarBaseButtonPaddingRight");this._btnClear=new a(this.getId()+"-btnClear",{type:c.Transparent,visible:"{"+n.INNER_MODEL_NAME+">/showClearButton}",text:this._oRb.getText("filterbar.CLEAR"),press:function(t){this.onClear()}.bind(this)});this._btnClear.setModel(this._oModel,n.INNER_MODEL_NAME);this._oFilterBarLayout.addButton(this._btnSearch);this._oFilterBarLayout.addButton(this._btnClear);this._oFilterBarLayout.addButton(this._btnAdapt)}};_.prototype.onClear=function(){this._btnClear.setEnabled(false);this.awaitControlDelegate().then(function(t){t.clearFilters(this).catch(function(t){p.error(t)}).finally(function(){this._btnClear.setEnabled(true)}.bind(this))}.bind(this))};_.prototype.retrieveInbuiltFilter=function(){const t=n.prototype.retrieveInbuiltFilter.apply(this,arguments);return t.then(function(t){return t})};_.prototype.onAdaptFilters=function(t){return this._retrieveMetadata().then(function(){return this.getEngine().show(this,"Item",{reset:function(){this.getEngine().reset(this);this._getConditionModel().checkUpdate(true)}.bind(this)}).then(function(t){return t})}.bind(this))};_.prototype.getCurrentState=function(){const t=n.prototype.getCurrentState.apply(this,arguments);if(!this.getProperty("_p13nModeItem")){delete t.items}return t};_.prototype.setFocusOnFirstErroneousField=function(){return this._setFocusOnFirstErroneousField()};_.prototype.exit=function(){n.prototype.exit.apply(this,arguments);this._btnClear=undefined};return _});
//# sourceMappingURL=FilterBar.js.map