/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/DynamicDateOption","sap/m/DynamicDateValueHelpUIType","sap/m/Input","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/DateUtil","sap/ui/mdc/util/loadModules","sap/ui/model/json/JSONModel","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/core/library"],function(e,t,o,s,a,r,i,n,p,l,u,y,c){"use strict";const h=c.ValueState;let f;let d;const g=e.extend("sap.ui.mdc.condition.OperatorDynamicDateOption",{metadata:{library:"sap.ui.mdc",properties:{operator:{type:"object"},type:{type:"object"},baseType:{type:"sap.ui.mdc.enums.BaseType"}}}});g.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oModel){this._oModel.destroy();this._oModel=undefined;this._mChangeHandler=undefined}if(this._aUITypes){for(let e=0;e<this._aUITypes.length;e++){this._aUITypes[e].destroy()}this._aUITypes=undefined}};g.prototype.applySettings=function(){e.prototype.applySettings.apply(this,arguments);const t=[];const o=this.getBaseType();if(o===s.DateTime){if(!d){t.push("sap/m/DateTimePicker")}}else if(!f){t.push("sap/m/DatePicker")}if(t.length>0){return n(t).then(function(e){if(o===s.DateTime){d=e[0]}else{f=e[0]}})}};g.prototype.validateProperty=function(t,o){if(t==="operator"&&o&&(typeof o!=="object"||!o.isA||!o.isA("sap.ui.mdc.condition.Operator"))){throw new Error('"'+o+'" is of type '+typeof o+", expected "+'sap.ui.mdc.condition.Operator for property "'+t+'" of '+this)}else if(t==="type"&&o&&(typeof o!=="object"||!o.isA||!o.isA("sap.ui.model.Type"))){throw new Error('"'+o+'" is of type '+typeof o+", expected "+'sap.ui.model.Type for property "'+t+'" of '+this)}return e.prototype.validateProperty.apply(this,arguments)};g.prototype.isRange=function(){const e=this.getOperator();return e.isA("sap.ui.mdc.condition.RangeOperator")};g.prototype.getText=function(e){const t=this.getOperator();const o=this.getBaseType();return t.getLongText(o)};g.prototype.getValueHelpUITypes=function(e){if(!this._aUITypes){const e=this.getOperator();let o=this.getType();const a=this.getBaseType();this._aUITypes=[];for(let i=0;i<e.valueTypes.length;i++){const n=e.valueTypes[i];if(n===r.Self){let e;if(a===s.DateTime){e="datetime"}else{e="date"}this._aUITypes.push(new t({type:e}))}else if(!n||n===r.Static){continue}else{o=e._createLocalType(n,o);if(o.isA("sap.ui.model.type.Integer")||o.isA("sap.ui.model.odata.type.Int")){this._aUITypes.push(new t({type:"int"}))}else{this._aUITypes.push(new t({type:"custom"}))}}}}return this._aUITypes};g.prototype.createValueHelpUI=function(e,t){let a=e.getValue();const n=this.getOperator();let l=this.getType();const u=this.getKey();const y=e.getId();if(!a||a.operator!==u){a={operator:u,values:[]};if(n.valueDefaults){a.values=n.valueDefaults}}m.call(this,e);if(!e.aControlsByParameters){e.aControlsByParameters={}}e.aControlsByParameters[u]=[];let c=function(e){t(this)}.bind(this);for(let h=0;h<n.valueTypes.length;h++){const g=n.valueTypes[h];const m=this.getBaseType();let T;if(!g){continue}if(!e.aControlsByParameters[u][h]){if(n.createControl){if(!this._oModel){c=function(e){const t=e.getParameter("path");const o=t.split("/");const s=o[0]||o[1];if(this._mChangeHandler&&this._mChangeHandler[s]){this._mChangeHandler[s](this)}}.bind(this);this._oModel=new p;this._oModel.attachPropertyChange({},c,this);this._mChangeHandler={}}const o=this._oModel.getData();o[y]={value0:a&&a.values[0],value1:a&&a.values[1]};this._mChangeHandler[y]=t;if(g!==r.Self){l=n._createLocalType(g,l)}const s=n.createControl(l,"internal>/"+y+"/value"+h,h,y+"-"+h);s.setModel(this._oModel,"internal");e.aControlsByParameters[u].push(s)}else if(g===r.Self){if(a&&a.values[h]){T=i.typeToDate(a.values[h],l,m)}const t=l.getFormatOptions();let o;if(m===s.DateTime){o=d}else{o=f}const r=new o(y+"-"+h,{dateValue:T,displayFormat:t.style||t.pattern,displayFormatType:t.calendarType,change:c});e.aControlsByParameters[u].push(r)}else if(typeof g==="object"){l=n._createLocalType(n.valueTypes[h],l);const t=l.formatValue(a&&a.values[h],"string");const s=new o(y+"-"+h,{value:t,change:c});e.aControlsByParameters[u].push(s)}}}return e.aControlsByParameters[u]};g.prototype.validateValueHelpUI=function(e){const t=this.getKey();const o=this.getOperator();const s=this.getType();let a;let r=true;let i=h.None;let n;let p=0;try{a=this.getValueHelpOutput(e);for(p=0;p<a.values.length;p++){const e=a.values[p];if(e===undefined||e===null){r=false}}o.validate(a.values,s)}catch(e){r=false;i=h.Error;n=e.message;if(e&&!(e instanceof u)&&!(e instanceof y)){throw e}}if(!o.createControl){for(p=0;p<e.aControlsByParameters[t].length;p++){const o=e.aControlsByParameters[t][p];if(o.setValueState){o.setValueState(i);o.setValueStateText(n)}}}return r};g.prototype.getValueHelpOutput=function(e){const t=this.getKey();const o={operator:t,values:[]};const s=this.getOperator();let a=this.getType();const n=this.getBaseType();const p=e.getId();for(let l=0;l<s.valueTypes.length;l++){if(!s.valueTypes[l]){continue}const y=e.aControlsByParameters[t][l];if(y){let e;if(s.createControl){e=this._oModel?this._oModel.getProperty("/"+p+"/value"+l):null}else if(s.valueTypes[l]===r.Self){if(!y.isValidValue()){throw new u}e=y.getDateValue();if(e){e=i.dateToType(e,a,n)}}else{e=y.getValue();a=s._createLocalType(s.valueTypes[l],a);e=a.parseValue(e,"string")}o.values.push(e)}}return o};g.prototype.getGroupHeader=function(){const t=this.getOperator();if(t.group&&t.group.text){return t.group.text}return e.prototype.getGroupHeader.apply(this,arguments)};g.prototype.getGroup=function(){const t=this.getOperator();if(t.group){return t.group.id}return e.prototype.getGroup.apply(this,arguments)};g.prototype.toDates=function(e){const t=this.getOperator();const o=this.getType();const s=this.getBaseType();let a;let n=0;if(t.isA("sap.ui.mdc.condition.RangeOperator")){a=t._getRange(e&&e.values,o,s);for(n=0;n<a.length;n++){a[n]=i.typeToDate(a[n],o,s)}}else if(t.valueTypes.length===0){a=[]}else if(t.valueTypes[0]===r.Self){a=[];for(n=0;n<e.values.length;n++){a.push(e.values[n]?i.typeToDate(e.values[n],o,s):e.values[n])}if(a.length===1){a.push(a[0])}}else if([r.Self,r.Static].indexOf(t.valueTypes[0])===-1){throw new Error("Cannot convert to date, use RangeOperator")}return a};g.prototype.format=function(e){const t=this.getOperator();const o=this.getType();return t.format(e,o,a.Value)};g.prototype.parse=function(e){const t=this.getOperator();const o=this.getType();if(e&&t.parse(e)){const s={};s.operator=this.getKey();s.values=t.parse(e,o,a.Value);return s}};g.prototype.enhanceFormattedValue=function(e,t){return false};function m(e){const t=this.getKey();if(e&&e.aControlsByParameters&&e.aControlsByParameters[t]){for(let o=0;o<e.aControlsByParameters[t].length;o++){const s=e.aControlsByParameters[t][o];if(!s.bIsDestroyed){s.destroy()}}delete e.aControlsByParameters[t]}}return g});
//# sourceMappingURL=OperatorDynamicDateOption.js.map