/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/valuehelp/base/Container","sap/ui/mdc/util/loadModules","sap/ui/thirdparty/jquery","sap/ui/core/library"],function(t,e,jQuery,n){"use strict";let o,i,s,r,a,l;const p=n.ValueState;const u=t.extend("sap.ui.mdc.valuehelp.Popover",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContainer","sap.ui.mdc.valuehelp.IDialogContainer","sap.ui.core.PopupInterface"],properties:{opensOnClick:{type:"boolean",defaultValue:false},opensOnFocus:{type:"boolean",defaultValue:false}},defaultAggregation:"content"}});u.prototype.invalidate=function(e){if(e){const n=this.getAggregation("_container");const o=this._oCurrentContent;if(n&&o&&e===o&&!this.isDestroyStarted()){n.invalidate(e)}else{t.prototype.invalidate.apply(this,arguments)}}};u.prototype.getUIAreaForContent=function(){const e=this.getAggregation("_container");if(e){return e.getUIArea()}return t.prototype.getUIAreaForContent.apply(this,arguments)};u.prototype._getContent=function(){const t=this.getContent();return t&&t[0]};u.prototype.getContainerControl=function(){let t=this.getAggregation("_container");const n=function(t,e){if(t&&t.getValueState&&t.getValueState()!==p.None){e.setText(t.getValueStateText());e.setValueState(t.getValueState());e.setVisible(true)}else{e.setVisible(false)}};if(!t){return e(["sap/m/Popover","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/ValueStateHeader","sap/ui/core/InvisibleText"]).then(function(e){o=e[0];i=e[1];s=e[2];r=e[3];a=e[4];l=e[5];const p=new a;n(this.getControl(),p);t=new o(this.getId()+"-pop",{contentHeight:"auto",placement:i.PlacementType.VerticalPreferredBottom,showHeader:false,showArrow:false,title:this.getTitle(),titleAlignment:i.TitleAlignment.Center,afterOpen:this.handleOpened.bind(this),afterClose:this.handleClosed.bind(this),customHeader:p}).addStyleClass("sapMdcValueHelpPopover").addStyleClass("sapMComboBoxBasePicker").addStyleClass("sapMComboBoxBasePicker-CTX");this._oInvisibleText=new l({text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("valuehelp.POPOVER_AVALIABLE_VALUES")}).toStatic();t.addAriaLabelledBy(this._oInvisibleText);if(p){p.setPopup(t)}t.isPopupAdaptationAllowed=function(){return false};t.addStyleClass(this.isSingleSelect()?"sapMdcValueHelpSingleSelect":"sapMdcValueHelpMultiSelect");t.addDelegate({onsapshow:this.handleRequestSwitchToDialog.bind(this)});t._getAllContent=function(){const t=this.getParent();const e=[];if(t){if(this._oCurrentContent){e.push(this._oCurrentContent)}}return e}.bind(this);const u=this._getContent();const c=this.getContainerConfig(u);if(c){t.setShowArrow(!!c.showArrow);t.setShowHeader(!!c.showHeader);t.setResizable(!!c.resizable);if(c.getContentWidth){t.setContentWidth(c.getContentWidth())}}this.setAggregation("_container",t,true);return t}.bind(this))}n(this.getControl(),t.getCustomHeader());return t};u.prototype.providesScrolling=function(){return true};u.prototype.observeChanges=function(e){if(e.name==="content"){const t=e.child;if(e.mutation==="remove"){t.detachNavigated(this.handleNavigated,this)}}t.prototype.observeChanges.apply(this,arguments)};u.prototype.placeContent=function(t){const e=this._getContent();const n=e&&e.getContent();const o=this.getContainerConfig(e);const i=o&&o.getFooter&&o.getFooter();return Promise.all([n,i]).then(function(e){this._oCurrentContent=e[0];const n=e[1];if(n&&t.getFooter()!=n&&n.isA&&n.isA("sap.m.Toolbar")){t.setFooter(n);return t}if(n){if(!t.getFooter()){const e=[new r(this.getId()+"-Spacer")].concat(n);const o=new s(this.getId()+"-TB",{content:e}).setModel(this._oManagedObjectModel,"$help");t.setFooter(o)}else{}}else if(t.getFooter()){t.setFooter()}return t}.bind(this))};u.prototype.openContainer=function(e,n){if(e.isOpen()){return}t.prototype.openContainer.apply(this,arguments);const o=this._getContent();const i=this._retrievePromise("open");Promise.resolve(o&&o.onBeforeShow(true)).then(function(){const t=this.getValueHelpDelegate();const e=this.getValueHelp();return Promise.resolve(n?t.showTypeahead(e,o):true).then(function(t){return t&&!i.isCanceled()?true:Promise.reject()})}.bind(this)).then(function(){this._openContainerByTarget(e)}.bind(this)).catch(function(t){this._cancelPromise(i);if(t&&t instanceof Error){throw t}}.bind(this))};u.prototype._openContainerByTarget=function(t){const e=this.getControl();const n=e&&e.getFocusElementForValueHelp?e.getFocusElementForValueHelp(this.isTypeahead()):e;if(n&&n.getDomRef()){t.setContentMinWidth(jQuery(n.getDomRef()).outerWidth()+"px");if(!this.isFocusInHelp()){t.setInitialFocus(n)}t.openBy(n)}};u.prototype.closeContainer=function(){t.prototype.closeContainer.apply(this,arguments);const e=this.getAggregation("_container");if(e){e.close()}};u.prototype.handleOpened=function(t){this._resolvePromise("open");const e=this._getContent();let n;if(e){e.onContainerOpen();n=e.onShow(true)}this.fireOpened({itemId:n})};u.prototype.handleConfirmed=function(t){this.fireConfirm({close:t.getParameter("close")||this.isSingleSelect()})};u.prototype.handleClosed=function(e){const n=this._getContent();if(n){n.onHide();n.onContainerClose()}const o=this.getAggregation("_container");if(o){o._oPreviousFocus=null}t.prototype.handleClosed.apply(this,arguments)};u.prototype.removeFocus=function(){const t=this._getContent();if(t){t.removeFocus()}};u.prototype.navigateInContent=function(t){const e=this._getContent();if(e){e.navigate(t)}};u.prototype.getItemForValue=function(t){const e=this._getContent();if(e){return e.getItemForValue(t)}};u.prototype.isValidationSupported=function(t){const e=this._getContent();if(e){return e.isValidationSupported()}};u.prototype.getUseAsValueHelp=function(){const t=this._getContent();return t&&t.getUseAsValueHelp&&t.getUseAsValueHelp()};u.prototype.getValueHelpIcon=function(){const t=this._getContent();return t&&t.getValueHelpIcon()};u.prototype.getAriaAttributes=function(e){const n=this._getContent();const o=n&&n.getAriaAttributes(e);if(o){return{contentId:o.contentId,ariaHasPopup:o.ariaHasPopup,role:this.isDialog()?"combobox":null,roleDescription:o.roleDescription,valueHelpEnabled:o.valueHelpEnabled,autocomplete:o.autocomplete}}return t.prototype.getAriaAttributes.apply(this,arguments)};u.prototype.shouldOpenOnFocus=function(){return this.getOpensOnFocus()};u.prototype.shouldOpenOnClick=function(){const t=this._getContent();return this.isPropertyInitial("opensOnClick")?!!t&&t.shouldOpenOnClick():this.getOpensOnClick()};u.prototype.shouldOpenOnNavigate=function(){const t=this._getContent();this.bindContentToContainer(t);return!!t&&t.shouldOpenOnNavigate()};u.prototype.isNavigationEnabled=function(t){if(this.isOpen()||this.getUseAsValueHelp()){const e=this._getContent();return!!e&&e.isNavigationEnabled(t)}return false};u.prototype.isFocusInHelp=function(){const t=this._getContent();return!!t&&t.isFocusInHelp()};u.prototype.isMultiSelect=function(){const t=this._getContent();return!!t&&t.isMultiSelect()};u.prototype.isTypeaheadSupported=function(){const t=this._getContent();return t&&t.isSearchSupported()};u.prototype.exit=function(){if(this._oCurrentContent){if(!this._oCurrentContent.isDestroyed()){this._oCurrentContent.destroy()}this._oCurrentContent=null}if(this._oInvisibleText){this._oInvisibleText.destroy();delete this._oInvisibleText}t.prototype.exit.apply(this,arguments)};return u});
//# sourceMappingURL=Popover.js.map