/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/valuehelp/base/FilterableListContent","sap/ui/mdc/condition/FilterConverter","sap/ui/mdc/util/loadModules","sap/m/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/mdc/util/Common","sap/base/strings/formatMessage","sap/base/util/merge","sap/ui/mdc/enums/ValueHelpSelectionType","sap/base/Log","sap/ui/core/Element"],function(e,t,i,s,n,o,l,a,r,h,c,u,d){"use strict";const p=s.ListMode;const g=s.Sticky;const f=e.extend("sap.ui.mdc.valuehelp.content.MTable",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.ITypeaheadContent","sap.ui.mdc.valuehelp.IDialogContent"],properties:{},aggregations:{table:{type:"sap.m.Table",multiple:false}},events:{contentUpdated:{}},defaultAggregation:"table"}});f.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{aggregations:["table"]});this._addPromise("listBinding");this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._oMResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._iNavigateIndex=-1;this._oFirstItemResult={}};f.prototype.getValueHelpIcon=function(){if(this.getUseAsValueHelp()){return"sap-icon://slim-arrow-down"}else{return null}};function m(){if(this._oTable){const t=this._oTable.getItems();const i=this.getConditions();const s=this.isSingleSelect()&&!e.prototype.isSingleSelect.apply(this);const n=this.isTypeahead()&&!!this.getFilterValue()&&this._iNavigateIndex===-1&&!!this._oFirstItemResult.result&&(this.isSingleSelect()&&i.length===0||!this.isSingleSelect());const o=this._oFirstItemResult.result;t.forEach(function(e){const t=this._getListItemBindingContext(e);const l=this.isValueHelpDelegateInitialized()?this.getItemFromContext(t):{key:undefined};if(s){e.setSelected(false)}else{e.setSelected(this._isContextSelected(t,i))}if(this._oTable.indexOfItem(e)===this._iNavigateIndex||n&&l.key===o.key){e.addStyleClass("sapMLIBFocused").addStyleClass("sapMListFocus").addStyleClass("sapMLIBSelected");this._oFirstItemResult.index=this._oTable.indexOfItem(e)}else{e.removeStyleClass("sapMLIBFocused").removeStyleClass("sapMListFocus").removeStyleClass("sapMLIBSelected")}}.bind(this))}}f.prototype.onBeforeShow=function(t){if(t){return Promise.resolve(e.prototype.onBeforeShow.apply(this,arguments)).then(function(){const e=this.getListBinding();const t=this.getListBindingInfo();const i=e&&e.isSuspended();const s=!e&&t&&t.suspended;if((i||s)&&!this.isTypeahead()){return undefined}return this.applyFilters()}.bind(this))}return undefined};f.prototype.applyFilters=function(){if(this._iNavigateIndex>=0){this.setProperty("conditions",[],true);this._iNavigateIndex=-1}const e=function(){if(!this.isDestroyed()){return this.applyFilters()}}.bind(this);const t=this.getListBinding();const i=this.isValueHelpDelegateInitialized();let s;if(!t||!i){s=Promise.all([this._retrievePromise("listBinding"),this.awaitValueHelpDelegate()]).then(e)}if(!i||!this.isTypeahead()&&!this.isContainerOpen()&&t.isSuspended()){return undefined}if(!s){const e=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const n=this.getListBindingInfo();const o=n&&n.length;e.updateBindingInfo(i,this,n);e.updateBinding(i,t,n,this);s=Promise.resolve(e.checkListBindingPending(i,t,o))}this._addPromise("applyFilters",s);return s.catch(function(e){if(e.canceled){u.error("sap.ui.mdc.ValueHelp - Error during applyFilters:",e.message);return}throw e}).finally(function(){const e=this._retrievePromise("applyFilters");e?.getInternalPromise().then(e=>{const t=this.getValueHelpDelegate().getFirstMatch(this.getValueHelpInstance(),this);this._oFirstItemResult={result:this.getItemFromContext(t),filterValue:this.getFilterValue(),index:-1};T.call(this,t)});return e&&e.getInternalPromise()}.bind(this))};f.prototype._handleSelectionChange=function(e){const t=this.isTypeahead();if(!t||!this.isSingleSelect()){const i=e.getParameters();const s=i.listItems||i.listItem&&[i.listItem];const n=s.map(function(e){const t=this._getListItemBindingContext(e);const i=this.getItemFromContext(t);return i&&this.createCondition(i.key,i.description,i.payload)}.bind(this));this._fireSelect({type:i.selected?c.Add:c.Remove,conditions:n});if(t){this.fireConfirm()}}};f.prototype._handleItemPress=function(e){const t=e.getParameter("listItem");const i=this._getListItemBindingContext(t);const s=this.getItemFromContext(i);const n=this._getTable();const o=n.getMode()===p.SingleSelectMaster;const l=o?t.getSelected():!t.getSelected();t.setSelected(l);const a=l?c.Add:c.Remove;const r=this.createCondition(s.key,s.description,s.payload);this._fireSelect({type:a,conditions:[r]});if(this.isTypeahead()){this.fireConfirm({close:true})}};f.prototype._handleUpdateFinished=function(){m.apply(this);if(this._bScrollToSelectedItem){const e=this._getTable();if(e&&this.isTypeahead()&&this.isSingleSelect()){const t=this._iNavigateIndex>=0?e.getItems()[this._iNavigateIndex]:e.getSelectedItem();if(t){this._handleScrolling(t)}}this._bScrollToSelectedItem=false}};f.prototype._getTable=function(){return this._oTable};f.prototype.onShow=function(t){const i=this._getTable();if(i){if(!i.hasStyleClass("sapMComboBoxList")){i.addStyleClass("sapMComboBoxList")}let t=this.isTypeahead()?p.SingleSelectMaster:p.SingleSelectLeft;if(!e.prototype.isSingleSelect.apply(this)&&i.getMode()!==t){t=p.MultiSelect}if(i.getMode()===p.None){i.setMode(t)}if(i.getMode()!==t){throw new Error("Table selection mode needs to be "+t)}}e.prototype.onShow.apply(this,arguments);if(i&&this.isTypeahead()&&this.isSingleSelect()){let e;if(this._iNavigateIndex>=0){e=i.getItems()[this._iNavigateIndex]}else if(this._oFirstItemResult&&this._oFirstItemResult.index>=0){e=i.getItems()[this._oFirstItemResult.index]}else{e=i.getSelectedItem()}if(e){this._handleScrolling(e);return e.getId()}else{this._bScrollToSelectedItem=true}}};f.prototype.onHide=function(){e.prototype.onHide.apply(this,arguments);const t=this.getTable();if(t){this.removeFocus();if(t.hasStyleClass("sapMComboBoxList")){t.removeStyleClass("sapMComboBoxList")}}this._iNavigateIndex=-1;this._bScrollToSelectedItem=false};f.prototype.handleConditionsUpdate=function(e){m.call(this)};f.prototype.getContent=function(){if(!this.isTypeahead()){return this._retrievePromise("wrappedContent",function(){return i(["sap/ui/layout/FixFlex","sap/m/VBox","sap/m/Panel","sap/m/ScrollContainer","sap/ui/model/resource/ResourceModel"]).then(function(e){const t=e[0];const i=e[1];const s=e[2];const n=e[3];const o=e[4];if(!this._oContentLayout&&!this.isDestroyed()){this._oFilterBarVBox=new i(this.getId()+"-FilterBarBox");this._oFilterBarVBox.addStyleClass("sapMdcValueHelpPanelFilterbar");this._oFilterBarVBox._oWrapper=this;this._oFilterBarVBox.getItems=function(){return[this._oWrapper._getPriorityFilterBar.call(this._oWrapper)]};this.setModel(new o({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");const e=function(e){const t=0;if(t===0){e=this.getModel("$i18n").getResourceBundle().getText("valuehelp.TABLETITLENONUMBER")}return r(e,t)};this._oTablePanel=new s(this.getId()+"-TablePanel",{expanded:true,height:"100%",headerText:{parts:["$i18n>valuehelp.TABLETITLE"],formatter:e}});this._oTablePanel.addStyleClass("sapMdcTablePanel");this._oContentLayout=new t(this.getId()+"-FF",{minFlexSize:200,fixContent:this._oFilterBarVBox,flexContent:this._oTablePanel});this._oScrollContainer=new n(this.getId()+"-SC",{height:"100%",width:"100%",vertical:true});this._oScrollContainer._oWrapper=this;this._oScrollContainer.getContent=function(){const e=[];const t=this._oWrapper&&this._oWrapper._oTable;if(t){e.push(t)}return e};this._oTablePanel.addContent(this._oScrollContainer)}this.setAggregation("displayContent",this._oContentLayout);const l=this._getPriorityFilterBar();if(!l){return this._createDefaultFilterBar().then(function(){return this._oContentLayout}.bind(this))}return this._oContentLayout}.bind(this))}.bind(this))}return this._oTable};f.prototype.getItemForValue=function(e){if(!e.checkKey&&e.parsedValue&&!e.checkDescription){return null}if(e.checkKey&&!this.getKeyPath()){throw new Error("MTable: KeyPath missing! "+this.getId())}if(e.checkDescription&&!this.getDescriptionPath()){throw new Error("MTable: DescriptionPath missing! "+this.getId())}e.caseSensitive=e.caseSensitive||this.getCaseSensitive();const t=I.call(this);const i=this.getValueHelpDelegate();const s=this.getValueHelpInstance();const n=i&&i.getFilterConditions(s,this,e);return Promise.all([t,n]).then(function(t){const i=t[0];const s=t[1];let n;if(!i){const t=this.getTable();const i=t.getParent()?.getParent();if(t.getItems().length>0&&this.getUseFirstMatch()&&i?.isOpen()){n=this._oFirstItemResult.filterValue===e.value?this._oFirstItemResult.result:undefined}if(!n){n=_.call(this,e,t.getItems(),s)}}if(!n){n=this._loadItemForValue(e,s)}return n}.bind(this))};function _(e,t,i){if(t.length===0){return}const s=function(e,t){const i=e.isA("sap.ui.model.Context")?e:this._getListItemBindingContext(e);return i&&i.getProperty(t)}.bind(this);let n;let o;const a=y.call(this,e,i);const r=l.apply(t,a,s);if(r.length===1||r.length>1&&this.getUseFirstMatch()){const e=this._getListItemBindingContext(r[0]);const t=this.getItemFromContext(e,{inParameters:n,outParameters:o});return{key:t.key,description:t.description,payload:t.payload}}else if(r.length>1){if(!e.caseSensitive){const s=h({},e);s.caseSensitive=true;return _.call(this,s,t,i)}throw b.call(this,e.exception,true,e.parsedValue||e.value)}}function y(e,i){const s=e.caseSensitive;const l=this.getKeyPath();const a=this.getDescriptionPath();const r=[];if(e.checkKey&&e.hasOwnProperty("parsedValue")){r.push(new n({path:l,operator:o.EQ,value1:e.parsedValue,caseSensitive:s}))}if(e.checkDescription){if(e.hasOwnProperty("parsedDescription")&&e.parsedDescription!==undefined){r.push(new n({path:a,operator:o.EQ,value1:e.parsedDescription,caseSensitive:s}))}else if(e.value){r.push(new n({path:a,operator:o.EQ,value1:e.value,caseSensitive:s}))}}let h=r.length>1?new n({filters:r,and:false}):r[0];if(i){const e=this._getTypesForConditions(i);const s=t.createFilters(i,e,undefined,this.getCaseSensitive());if(s){h=new n({filters:[h,s],and:true})}}return h}function I(){return this._retrievePromise("listBinding").then(function(e){const t=this.getValueHelpDelegate();const i=this.getValueHelpInstance();const s=this.getListBindingInfo();const n=s&&s.length;if(e&&t){return t.checkListBindingPending(i,e,n)}else{return true}}.bind(this))}f.prototype.getListBinding=function(){const e=this._getTable();return e&&e.getBinding("items")};f.prototype.getListBindingInfo=function(){const e=this._getTable();return e&&e.getBindingInfo("items")};f.prototype._loadItemForValue=function(e,t){if(!e.checkKey&&e.parsedValue&&!e.checkDescription){return null}const i=this.getKeyPath();const s=this.getDescriptionPath();const n=this.getUseFirstMatch();const o=this._getTable();const l=o&&o.getBinding("items");const a=l&&l.getPath();const r=this.getValueHelpDelegate();const h=this.getValueHelpInstance();const c="loadItemForValue:"+JSON.stringify([a,i,e.parsedValue||e.value,e.context,e.bindingContext&&e.bindingContext.getPath(),t]);return this._retrievePromise(c,function(){const o=y.call(this,e,t);const c=l.getModel().bindList(a,l.getContext(),undefined,o);c.initialize();return r.executeFilter(h,c,2).then(function(t){const o=t.getContexts();setTimeout(function(){c.destroy()},0);if(o.length&&(o.length<2||n)){return this.getItemFromContext(o[0],{keyPath:i,descriptionPath:s,inParameters:undefined})}else if(e.checkKey&&e.parsedValue===""&&o.length===0){return null}else{const t=b.call(this,e.exception,o.length>1,e.value);throw t}}.bind(this))}.bind(this))};function b(e,t,i){let s;if(t){s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_UNIQUE",[i])}else{s=this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[i])}const n=new e(s);n._bNotUnique=t;return n}f.prototype.isValidationSupported=function(e){return true};f.prototype.navigate=function(e){const t=this.getParent().isOpen();if(!t&&this._iNavigateIndex<0){this.onShow(true)}const i=this.getListBinding();if(!i||!i.getLength()){return I.call(this).then(function(t){if(!t&&i.getLength()!==0){return this.navigate(e)}return false}.bind(this))}const s=this._getTable();const n=s.getItems();const o=this._iNavigateIndex>=0?n[this._iNavigateIndex]:s.getSelectedItem();const l=n.length;let a=0;let r=false;if(o){a=n.indexOf(o);a=a+e}else if(e>=0){a=e-1}else{a=l+e}if(e===9999){a=l-1}if(e===-9999){a=0}if(this.getMaxConditions()!==1){if(this.getParent().isOpen()&&s.getMode()===p.MultiSelect){s.focus();return}}s.addStyleClass("sapMListFocus");let h;if(a<0){a=0;h=true;r=true}else if(a>=l-1){a=l-1;h=false}else{h=e>=0}const c=function(){while(n[a]&&n[a].isA("sap.m.GroupHeaderListItem")){if(h){a++}else{a--}}};if(!t){c();if(a<0||a>l-1){h=!h;r=a<0;a=a<0?0:l-1;c()}}const u=n[a];if(u){let e;if(u!==o){this._iNavigateIndex=a;u.setSelected(true);if(t){this._handleScrolling(u);u.$().trigger("focusin")}if(u.isA("sap.m.GroupHeaderListItem")){this.setProperty("conditions",[],true);this.fireNavigated({condition:undefined,itemId:u.getId(),leaveFocus:false})}else{const t=this._getListItemBindingContext(u);const i=this.getItemFromContext(t);e=i&&this.createCondition(i.key,i.description,i.payload);this.setProperty("conditions",[e],true);this.fireNavigated({condition:e,itemId:u.getId(),leaveFocus:false})}}else if(r){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:r})}}};f.prototype.isNavigationEnabled=function(e){if(e===1||e===-1){return true}else{return false}};f.prototype._handleScrolling=function(e){const t=this.getScrollDelegate();if(t){const t=this._getTable();const i=!isNaN(e)?e:t.indexOfItem(e);t.scrollToIndex(i).catch(function(e){});return true}return false};f.prototype.getScrollDelegate=function(){if(this._oScrollContainer){return this._oScrollContainer.getScrollDelegate()}return e.prototype.getScrollDelegate.apply(this,arguments)};f.prototype.removeFocus=function(){const e=this.getTable();if(e){e.removeStyleClass("sapMListFocus")}};f.prototype.getAriaAttributes=function(e){const t=this.getTable();const i=this.isTypeahead();const s=this.getUseAsValueHelp();let n=null;if(e!==1&&(i&&s||!i)){const e=S.apply(this);n=e.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION")}return{contentId:t&&t.getId(),ariaHasPopup:"listbox",roleDescription:n,valueHelpEnabled:!i,autocomplete:this.getUseFirstMatch()?"both":"none"}};function S(){if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m")}return this._oResourceBundleM}f.prototype.getContainerConfig=function(){return{"sap.ui.mdc.valuehelp.Popover":{getContentHeight:function(){const e=this._getTable();const t=e&&e.getDomRef();return t&&Math.round(t.getBoundingClientRect().height)}.bind(this),getFooter:function(){return this._retrievePromise("footer",function(){return this._retrievePromise("listBinding").then(function(e){const t=this.getListBindingInfo();const s=this.getParent().hasDialog();if(s&&t&&t.length){return i(["sap/m/Button","sap/m/Toolbar","sap/m/ToolbarSpacer"]).then(function(e){const t=e[0];const i=e[1];const s=e[2];const n=new t(this.getId()+"-showAllItems",{text:this._oMResourceBundle.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){this.fireRequestSwitchToDialog()}.bind(this)});const o=[new s(this.getId()+"-Spacer")].concat(n);const l=new i(this.getId()+"-TB",{content:o});return l}.bind(this))}}.bind(this))}.bind(this))}.bind(this)}}};function C(){if(this._oTable&&this.getParent()){const e=this._oTable.getSticky();if(!e||e.length===0){this._oTable.setSticky([g.ColumnHeaders])}}}f.prototype.setParent=function(t){e.prototype.setParent.apply(this,arguments);C.call(this)};f.prototype.observeChanges=function(t){if(t.name==="config"){C.call(this)}if(t.name==="items"&&t.mutation==="ready"){this._resolvePromise("listBinding",t.bindingInfo.binding)}if(t.name==="table"){const e=t.child;this._oFirstItemResult={};if(t.mutation==="remove"){this._oObserver.unobserve(e);e.removeDelegate(this._oTableDelegate);this._oTable.detachItemPress(this._handleItemPress,this);this._oTable.detachSelectionChange(this._handleSelectionChange,this);this._oTable.detachUpdateFinished(this._handleUpdateFinished,this);this._oTable=null;this._removePromise("footer");this._addPromise("listBinding")}else{this._oTable=e;this._oTable.addStyleClass("sapMdcValueHelpMTable");C.call(this);this._oTable.attachItemPress(this._handleItemPress,this);this._oTable.attachSelectionChange(this._handleSelectionChange,this);this._oTable.attachUpdateFinished(this._handleUpdateFinished,this);this._oTableDelegate=this._oTableDelegate||{onsapprevious:this._handleTableEvent,onsapnext:this._handleTableEvent,cellClick:this._handleTableEvent};e.addDelegate(this._oTableDelegate,true,this);const i=e.getBinding("items");if(i){this._resolvePromise("listBinding",i)}else{this._oObserver.observe(t.child,{bindings:["items"]})}}}e.prototype.observeChanges.apply(this,arguments)};f.prototype._handleTableEvent=function(e){if(!this.isTypeahead()){return}const t=this._getTable();const i=d.closestTo(e.target);switch(e.type){case"sapprevious":if(i.isA("sap.m.ListItemBase")){if(t.indexOfItem(i)===0){this.fireNavigated({condition:undefined,itemId:undefined,leaveFocus:true});e.preventDefault();e.stopPropagation();e.stopImmediatePropagation(true)}}break;default:break}};f.prototype.isQuickSelectSupported=function(){return true};f.prototype.isSingleSelect=function(){const t=this._getTable();if(t&&t.getMode()!==p.None){if(t.getMode()===p.MultiSelect){return false}else{return true}}else{return e.prototype.isSingleSelect.apply(this,arguments)}};f.prototype.onConnectionChange=function(){this._iNavigateIndex=-1;this._oFirstItemResult={}};f.prototype.exit=function(){a.cleanup(this,["_sTableWidth","_oTable","_oScrollContainer","_oContentLayout","_oTablePanel","_oFilterBarVBox","_oMResourceBundle","_oResourceBundle","_oTableDelegate","_oFirstItemResult"]);e.prototype.exit.apply(this,arguments)};f.prototype.getRelevantContexts=function(e){const t=this.getListBinding();const i=t.getAllCurrentContexts?t.getAllCurrentContexts():t.getContexts();return i};function T(e){if(!this.getUseFirstMatch()||!this._oFirstItemResult||!this._oFirstItemResult.result||!this._oFirstItemResult.filterValue){return}const t=this.createCondition(this._oFirstItemResult.result.key,this._oFirstItemResult.result.description,this._oFirstItemResult.result.payload);const i=this._oTable.getItems();let s;for(let t=0;t<i.length;t++){const n=i[t];if(this._getListItemBindingContext(n)===e){s=n.getId();break}}this.fireTypeaheadSuggested({condition:t,filterValue:this._oFirstItemResult.filterValue,itemId:s})}return f});
//# sourceMappingURL=MTable.js.map