/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Context","./ODataParentBinding","./lib/_AggregationCache","./lib/_AggregationHelper","./lib/_Cache","./lib/_GroupLock","./lib/_Helper","./lib/_Parser","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/Sorter","sap/ui/model/odata/OperationMode"],function(e,t,i,n,r,s,o,a,h,d,u,f,c,l,p,g,C,x,v){"use strict";var P="sap.ui.model.odata.v4.ODataListBinding",m={AggregatedDataStateChange:true,change:true,createActivate:true,createCompleted:true,createSent:true,dataReceived:true,dataRequested:true,DataStateChange:true,patchCompleted:true,patchSent:true,refresh:true},y=C.extend("sap.ui.model.odata.v4.ODataListBinding",{constructor:E});function E(i,n,r,s,a,h){C.call(this,i,n);t.call(this);if(n.endsWith("/")){throw new Error("Invalid path: "+n)}h=o.clone(h)||{};this.checkBindingParameters(h,["$$aggregation","$$canonicalPath","$$getKeepAliveContext","$$groupId","$$operationMode","$$ownRequest","$$patchWithoutSideEffects","$$sharedRequest","$$updateGroupId"]);const d=o.toArray(a);if(h.$$aggregation&&d[0]===c.NONE){throw new Error("Cannot combine Filter.NONE with $$aggregation")}this.iActiveContexts=0;this.aApplicationFilters=d;this.sChangeReason=i.bAutoExpandSelect&&!o.isDataAggregation(h)?"AddVirtualContext":undefined;this.iCreatedContexts=0;this.iDeletedContexts=0;this.oDiff=undefined;this.aFilters=[];this.sGroupId=h.$$groupId;this.bHasAnalyticalInfo=false;this.oHeaderContext=this.bRelative?null:e.createNewContext(i,this,n);this.sOperationMode=h.$$operationMode||i.sOperationMode;this.mPreviousContextsByPath={};this.aPreviousData=null;this.bRefreshKeptElements=false;this.sResumeAction=undefined;this.bSharedRequest="$$sharedRequest"in h?h.$$sharedRequest:i.bSharedRequests;this.aSorters=o.toArray(s);this.sUpdateGroupId=h.$$updateGroupId;if(!this.sOperationMode&&(this.aSorters.length||this.aApplicationFilters.length)){throw new Error("Unsupported operation mode: "+this.sOperationMode)}this.applyParameters(h);if(!this.bRelative||r&&!r.fetchValue){this.createReadGroupLock(this.getGroupId(),true)}this.setContext(r);i.bindingCreated(this)}t(y.prototype);y.prototype.attachCreateActivate=function(e,t){return this.attachEvent("createActivate",e,t)};y.prototype.detachCreateActivate=function(e,t){return this.detachEvent("createActivate",e,t)};y.prototype.attachCreateCompleted=function(e,t){return this.attachEvent("createCompleted",e,t)};y.prototype.detachCreateCompleted=function(e,t){return this.detachEvent("createCompleted",e,t)};y.prototype.attachCreateSent=function(e,t){return this.attachEvent("createSent",e,t)};y.prototype.detachCreateSent=function(e,t){return this.detachEvent("createSent",e,t)};y.prototype.adjustPredicate=function(e,i,n){var r=this;function s(e,t){var i=r.aPreviousData?.indexOf(e);if(i>=0){r.aPreviousData[i]=t}}if(n){n.adjustPredicate(e,i,s)}else{t.prototype.adjustPredicate.apply(this,arguments);if(this.mCacheQueryOptions&&!this.oContext.getPath().includes("($uid=")){this.fetchCache(this.oContext,true)}this.oHeaderContext.adjustPredicate(e,i);this.aContexts.forEach(function(t){t.adjustPredicate(e,i,s)})}};y.prototype.applyParameters=function(e,t){var i,r=this.mParameters&&this.mParameters.$$aggregation,s=this.mQueryOptions&&this.mQueryOptions.$apply;if("$$getKeepAliveContext"in e&&"$apply"in e){throw new Error("Cannot combine $$getKeepAliveContext and $apply")}if("$$aggregation"in e){if("$apply"in e){throw new Error("Cannot combine $$aggregation and $apply")}if(!t){n.validateAggregationAndSetPath(e.$$aggregation,this.oModel.bAutoExpandSelect,this.oModel.oInterface.fetchMetadata,this.getResolvedPath())}i=n.buildApply(e.$$aggregation).$apply}this.mQueryOptions=this.oModel.buildQueryOptions(e,true);this.oQueryOptionsPromise=undefined;this.mParameters=e;if(i){this.mQueryOptions.$apply=i}if(t===""){if(this.mQueryOptions.$apply===s&&(!this.mParameters.$$aggregation||!r||this.isUnchangedParameter("$$aggregation",r))){return}t=this.bHasAnalyticalInfo?f.Change:f.Filter}if(this.isRootBindingSuspended()){this.setResumeChangeReason(t);return}this.removeCachesAndMessages("");this.fetchCache(this.oContext);this.reset(t);if(this.oHeaderContext){this.oHeaderContext.setSelected(false);this.oHeaderContext.checkUpdate()}};y.prototype.attachEvent=function(e,t,i,n){if(!(e in m)){throw new Error("Unsupported event '"+e+"': v4.ODataListBinding#attachEvent")}return C.prototype.attachEvent.apply(this,arguments)};y.prototype._checkDataStateMessages=function(e,t){if(t){e.setModelMessages(this.oModel.getMessagesByPath(t,true))}};y.prototype.checkDeepCreate=function(){if(!this.oModel.bAutoExpandSelect){throw new Error("Deep create is only supported with autoExpandSelect")}if(!this.oContext.isTransient()){throw new Error("Unexpected ODataContextBinding in deep create")}if(this.sPath.includes("/")){throw new Error("Invalid path '"+this.sPath+"' in deep create")}};y.prototype.checkKeepAlive=function(e,t){if(this.isRelative()&&!this.mParameters.$$ownRequest){throw new Error("Missing $$ownRequest at "+this)}if(e===this.oHeaderContext){throw new Error("Unsupported header context "+e)}if(o.isDataAggregation(this.mParameters)){throw new Error("Unsupported $$aggregation at "+this)}if(this.bSharedRequest){throw new Error("Unsupported $$sharedRequest at "+this)}if(!t&&e&&e.getIndex()===undefined&&e.isKeepAlive()&&!e.isDeleted()&&e.hasPendingChanges()){throw new Error("Not allowed due to pending changes: "+e)}};y.prototype.collapse=function(e,t){var i=this.aContexts,n=this.oCache.collapse(o.getRelativePath(e.getPath(),this.oHeaderContext.getPath())),r=e.getModelIndex(),s,a=this;if(n>0){i.splice(r+1,n).forEach(function(e){if(!e.created()){a.mPreviousContextsByPath[e.getPath()]=e}});for(s=r+1;s<i.length;s+=1){if(i[s]){i[s].iIndex=s}}this.iMaxLength-=n;if(!t){this._fireChange({reason:f.Change})}}};y.prototype.create=function(t,i,n,r){var s=this.mParameters.$$aggregation,a,h,d=this.fetchResourcePath(),u,c,l=this.getUpdateGroupId(),p,g=this.getResolvedPath(),C="($uid="+o.uid()+")",x=g+C,v,m=this;if(!g){throw new Error("Binding is unresolved: "+this)}this.checkSuspended();if(o.isDataAggregation(this.mParameters)){throw new Error("Cannot create in "+this+" when using data aggregation")}if(this.isTransient()){this.checkDeepCreate();if(r){throw new Error("Must not create an inactive context in a deep create: "+this)}}n=!!n;if(n&&!(this.bLengthFinal||this.mParameters.$count)){throw new Error("Must know the final length to create at the end. Consider setting $count")}if(this.bFirstCreateAtEnd&&!n){throw new Error("Cannot create at the start after creation at end")}if(r){if(this.isRelative()&&!this.mParameters.$$ownRequest){throw new Error("Missing $$ownRequest at "+this)}l="$inactive."+l}else if(!s){this.iActiveContexts+=1}if(this.bFirstCreateAtEnd===undefined){this.bFirstCreateAtEnd=n}c=o.publicClone(t,true)||{};if(s){if(!i){throw new Error("Missing bSkipRefresh")}if(arguments.length>2){throw new Error("Only the parameters oInitialData and bSkipRefresh are supported")}const e=t?.["@$ui5.node.parent"];if(e){a=this.aContexts.indexOf(e)+1;if(a<=0){throw new Error("Invalid parent context: "+e)}if(e.isExpanded()===false){throw new Error("Unsupported collapsed parent: "+e)}c["@$ui5.node.parent"]=e.getCanonicalPath().slice(1)}else{a=0}}else{this.iCreatedContexts+=1}p=this.lockGroup(l,true,true,function(){if(!m.aContexts.includes(h)){m.mPreviousContextsByPath[h.getPath()]=h;m.destroyPreviousContextsLater([h.getPath()]);return}h.setSelected(false);m.removeCreated(h);return Promise.resolve().then(function(){m._fireChange({reason:f.Remove})})});u=this.createInCache(p,d,g,C,c,this.bFirstCreateAtEnd!==n,function(e){m.oModel.reportError("POST on '"+d+"' failed; will be repeated automatically",P,e);m.fireEvent("createCompleted",{context:h,success:false})},function(){m.fireEvent("createSent",{context:h})}).then(function(e){var t,n,r;r=o.getPrivateAnnotation(e,"predicate");if(r){m.adjustPredicate(C,r,h);m.oModel.checkMessages()}m.fireEvent("createCompleted",{context:h,success:true});t=o.getPrivateAnnotation(e,"deepCreate");o.deletePrivateAnnotation(e,"deepCreate");n=m.getGroupId();if(m.oModel.isApiGroup(n)){n="$auto"}return i||t?h.updateAfterCreate(i,n):m.refreshSingle(h,m.lockGroup(n))},function(e){p.unlock(true);throw e});h=e.create(this.oModel,this,x,a??-this.iCreatedContexts,u,r);if(this.isTransient()){h.created().catch(this.oModel.getReporter())}h.fetchValue().then(function(e){if(e){o.setPrivateAnnotation(e,"context",h);o.setPrivateAnnotation(e,"firstCreateAtEnd",m.bFirstCreateAtEnd)}});if(a!==undefined){this.aContexts.splice(a,0,h);for(v=this.aContexts.length-1;v>a;v-=1){if(this.aContexts[v]){this.aContexts[v].iIndex+=1}}this.iMaxLength+=1}else if(this.bFirstCreateAtEnd!==n){this.aContexts.splice(this.iCreatedContexts-1,0,h);for(v=this.iCreatedContexts-1;v>=0;v-=1){this.aContexts[v].iIndex=v-this.iCreatedContexts}}else{this.aContexts.unshift(h)}this._fireChange({reason:f.Add});return h};y.prototype.createContexts=function(t,i){var n=false,r,s,a=i.$count,h,d=this.bLengthFinal,u=this.oModel,f=this.getResolvedPath(),c,l=t>this.aContexts.length,p,g=this;function C(){var e=g.iMaxLength+g.iCreatedContexts,t;if(e>=g.aContexts.length){return}for(t=e;t<g.aContexts.length;t+=1){if(g.aContexts[t]){g.aContexts[t].destroy()}}while(e>0&&!g.aContexts[e-1]){e-=1}g.aContexts.length=e;n=true}for(p=0;p<i.length;p+=1){if(this.aContexts[t+p]===undefined&&i[p]){n=true;h=t+p-this.iCreatedContexts;c=o.getPrivateAnnotation(i[p],"predicate");s=f+(c||"/"+h);r=this.mPreviousContextsByPath[s];if(r&&(!r.created()||r.isEffectivelyKeptAlive())){delete this.mPreviousContextsByPath[s];r.iIndex=h;r.checkUpdate()}else if(o.hasPrivateAnnotation(i[p],"context")){r=o.getPrivateAnnotation(i[p],"context");r.iIndex=h}else{r=e.create(u,this,s,h)}this.aContexts[t+p]=r}}this.destroyPreviousContextsLater(Object.keys(this.mPreviousContextsByPath));if(a!==undefined){this.bLengthFinal=true;this.iMaxLength=a-this.iActiveContexts;C()}else{if(!i.length){this.iMaxLength=t-this.iCreatedContexts;C()}else if(this.aContexts.length>this.iMaxLength+this.iCreatedContexts){this.iMaxLength=Infinity}if(!(l&&i.length===0)){this.bLengthFinal=this.aContexts.length===this.iMaxLength+this.iCreatedContexts}}if(this.bLengthFinal!==d){n=true}return n};y.prototype.delete=function(t,i,n,r,s,a){var h=false,d=this;if(this.mParameters.$$aggregation&&n.iIndex===undefined){throw new Error("Unsupported kept-alive context: "+n)}if(n.isDeleted()){return n.oDeletePromise}const u=n.isExpanded();if(u){this.collapse(n,true)}const c=n.iIndex<0;const l=n.iIndex===undefined?o.getRelativePath(n.getPath(),this.oHeaderContext.getPath()):String(n.getModelIndex());this.iDeletedContexts+=1;return n.doDelete(t,i,l,r,this,function(e,i){if(e!==undefined){if(i>0){delete d.mPreviousContextsByPath[n.getPath()];d.aContexts.splice(e,0,n);a()}else{d.mPreviousContextsByPath[n.getPath()]=n;d.aContexts.splice(e,1);n.iIndex=undefined;Promise.resolve().then(function(){d._fireChange({reason:f.Remove})})}if(c){d.iCreatedContexts+=i;d.iActiveContexts+=i}else{d.iMaxLength+=i}d.aContexts.forEach(function(e,t){e.iIndex=t-d.iCreatedContexts})}else if(i>0){h=true;a()}else if(d.bLengthFinal&&!s){d.oCache.requestCount(t&&!d.oModel.isApiGroup(t.getGroupId())?t.getUnlockedCopy():d.lockGroup("$auto")).then(function(e){var t=d.iMaxLength;d.iMaxLength=e-d.iActiveContexts;if(t!==d.iMaxLength){d._fireChange({reason:f.Remove})}})}}).then(function(){d.iDeletedContexts-=1;if(!d.iDeletedContexts&&!d.iCreatedContexts){d.bFirstCreateAtEnd=undefined}n.resetKeepAlive();n.iIndex=e.VIRTUAL;d.destroyPreviousContextsLater([n.getPath()])},function(e){d.iDeletedContexts-=1;a();if(h){d.oCache.reset(d.getKeepAlivePredicates());d.reset(f.Change)}else{if(u){d.expand(n,true).unwrap()}d._fireChange({reason:f.Add})}throw e})};y.prototype.destroy=function(){if(this.bHasAnalyticalInfo&&this.aContexts===undefined){return}this.aContexts.forEach(function(e){e.destroy()});this.destroyPreviousContexts();if(this.oHeaderContext){this.oHeaderContext.destroy()}this.oModel.bindingDestroyed(this);this.aApplicationFilters=undefined;this.aContexts=undefined;this.oDiff=undefined;this.aFilters=undefined;this.oHeaderContext=undefined;this.mPreviousContextsByPath=undefined;this.aPreviousData=undefined;this.mQueryOptions=undefined;this.oQueryOptionsPromise=undefined;this.aSorters=undefined;t.prototype.destroy.call(this);C.prototype.destroy.call(this)};y.prototype.destroyLater=function(e){if(this.iCurrentEnd){this.mPreviousContextsByPath[e.getPath()]=e}else{e.destroy()}};y.prototype.destroyPreviousContexts=function(e){var t=this.mPreviousContextsByPath,i=this;if(t){(e||Object.keys(t)).forEach(function(n){var r=t[n];if(r){if(e&&(r.isEffectivelyKeptAlive()||r.oDeletePromise&&r.oDeletePromise.isPending())){r.iIndex=undefined}else{if(!r.isTransient()){r.destroy();if(r.iIndex===undefined&&i.oCache){i.oCache.removeKeptElement(o.getRelativePath(n,i.oHeaderContext.getPath()))}}delete t[n]}}})}};y.prototype.destroyPreviousContextsLater=function(e){if(e.length){this.oModel.addPrerenderingTask(this.destroyPreviousContexts.bind(this,e))}};y.prototype.doCreateCache=function(e,t,n,r,s,o){var a,h,d;if(o&&o.getResourcePath()===e&&o.$deepResourcePath===r){h=this.getKeepAlivePredicates();if(this.iCreatedContexts||this.iDeletedContexts||h.length){o.reset(h,s,t,this.mParameters.$$aggregation,this.isGrouped());return o}}t=this.inheritQueryOptions(t,n);a=this.getCacheAndMoveKeepAliveContexts(e,t);if(a&&this.mParameters.$$aggregation){d={};h=this.getKeepAlivePredicates();h.forEach(function(e){d[e]=a.getValue(e)});a.setActive(false);a=undefined}a=a||i.create(this.oModel.oRequestor,e,r,t,this.mParameters.$$aggregation,this.oModel.bAutoExpandSelect,this.bSharedRequest,this.isGrouped());if(d){h.forEach(function(e){a.addKeptElement(d[e])})}else if(this.bSharedRequest){a.registerChangeListener("",this)}return a};y.prototype.doFetchOrGetQueryOptions=function(e){var t=e&&o.getMetaPath(e.getPath()),i=this;if(!(this.oQueryOptionsPromise&&this.oQueryOptionsPromise.$metaPath===t)){this.oQueryOptionsPromise=this.fetchResolvedQueryOptions(e).then(function(t){return i.fetchFilter(e,t.$filter).then(function(e){return o.mergeQueryOptions(t,i.getOrderby(t.$orderby),e)})});this.oQueryOptionsPromise.$metaPath=t}return this.oQueryOptionsPromise};y.prototype.doReplaceWith=function(t,i,n){var r=t.getModelIndex(),s,o=t.fnOnBeforeDestroy,a,h=this.oHeaderContext.getPath()+n,d=this.mPreviousContextsByPath[h];if(d){if(d===t){return d}if(d.iIndex!==undefined){throw new Error("Unexpected index: "+d)}d.iIndex=t.iIndex;delete this.mPreviousContextsByPath[h]}else{d=e.create(this.oModel,this,h,t.iIndex);s=true}if(r===undefined){this.mPreviousContextsByPath[h]=d;this.oCache.addKeptElement(i)}else{t.iIndex=undefined;this.aContexts[r]=d;this.oCache.doReplaceWith(r,i)}if(t.isKeepAlive()){this.mPreviousContextsByPath[t.getPath()]=t;if(s){if(o){a=(o.$original||o).bind(null,d);a.$original=o}d.setKeepAlive(true,a)}}else{this.destroyLater(t)}this._fireChange({reason:f.Change});return d};y.prototype.doSetProperty=function(){};y.prototype.expand=function(e,t){this.checkSuspended();let i=false;return this.oCache.expand(this.lockGroup(),o.getRelativePath(e.getPath(),this.oHeaderContext.getPath()),()=>{i=true;this.fireDataRequested()}).then(n=>{if(n){this.insertGap(e.getModelIndex(),n);if(!t){this._fireChange({reason:f.Change})}}if(i){this.fireDataReceived({})}},e=>{if(i){this.fireDataReceived({error:e})}throw e})};y.prototype.fetchContexts=function(e,t,i,n,r,s){var o,a=this;if(this.bFirstCreateAtEnd){e+=this.iCreatedContexts}if(!n){n=this.oReadGroupLock||this.lockGroup();this.oReadGroupLock=undefined}o=this.fetchData(e,t,i,n,s);if(r){o=Promise.resolve(o)}return o.then(function(t){var i;if(!a.aContexts){i=new Error("Binding already destroyed");i.canceled=true;throw i}return t&&a.createContexts(e,t.value)},function(e){n.unlock(true);throw e})};y.prototype.fetchData=function(e,t,i,n,r){var s=this.oContext,o=this;return this.oCachePromise.then(function(a){var h;if(o.bRelative&&s!==o.oContext){return undefined}if(a){if(!a.hasSentRequest()&&o.isRelative()&&y.isBelowCreated(s)){h=s.getAndRemoveCollection(o.sPath);if(h){a.setPersistedCollection(h)}}return a.read(e,t,i,n,r).then(function(e){o.assertSameCache(a);return e})}n.unlock();return s.fetchValue(o.sReducedPath).then(function(i){var n;i=i||[];n=i.$count;i=i.slice(e,e+t);i.$count=n;return{value:i}})})};y.prototype.fetchDownloadUrl=function(){var e=this.oModel.mUriParameters;this.checkTransient();if(!this.isResolved()){throw new Error("Binding is unresolved")}if(this.hasFilterNone()){return d.resolve(null)}return this.withCache(function(t,i){return t.getDownloadUrl(i,e)})};y.prototype.fetchFilter=function(e,t){var i,r,s,a;function h(e,t,i){var n,r,s,a;function h(e){return s?"tolower("+e+")":e}s=t==="Edm.String"&&e.bCaseSensitive===false;r=h(decodeURIComponent(e.sPath));a=h(o.formatLiteral(e.oValue1,t));switch(e.sOperator){case l.BT:n=r+" ge "+a+" and "+r+" le "+h(o.formatLiteral(e.oValue2,t));break;case l.NB:n=g(r+" lt "+a+" or "+r+" gt "+h(o.formatLiteral(e.oValue2,t)),i);break;case l.EQ:case l.GE:case l.GT:case l.LE:case l.LT:case l.NE:n=r+" "+e.sOperator.toLowerCase()+" "+a;break;case l.Contains:case l.EndsWith:case l.NotContains:case l.NotEndsWith:case l.NotStartsWith:case l.StartsWith:n=e.sOperator.toLowerCase().replace("not","not ")+"("+r+","+a+")";break;default:throw new Error("Unsupported operator: "+e.sOperator)}return n}function u(e,t,i){var n;if(!e){return d.resolve()}if(e.aFilters){return d.all(e.aFilters.map(function(i){return u(i,t,e.bAnd)})).then(function(t){return g(t.join(e.bAnd?" and ":" or "),i&&!e.bAnd)})}n=s.resolve(f(e.sPath,t),a);return s.fetchObject(n).then(function(r){var s,o,a;if(!r){throw new Error("Type cannot be determined, no metadata for path: "+n)}a=e.sOperator;if(a===l.All||a===l.Any){s=e.oCondition;o=e.sVariable;if(a===l.Any&&!s){return e.sPath+"/any()"}t=Object.create(t);t[o]=f(e.sPath,t);return u(s,t).then(function(t){return e.sPath+"/"+e.sOperator.toLowerCase()+"("+o+":"+t+")"})}return h(e,r.$Type,i)})}function f(e,t){var i=e.split("/");i[0]=t[i[0]];return i[0]?i.join("/"):e}function g(e,t){return t?"("+e+")":e}i=p.combineFilters(this.aFilters,this.aApplicationFilters);if(!i){return d.resolve([t])}if(i===c.NONE){return d.resolve(["false"])}r=n.splitFilter(i,this.mParameters.$$aggregation);s=this.oModel.getMetaModel();a=s.getMetaContext(this.oModel.resolve(this.sPath,e));return d.all([u(r[0],{},t).then(function(e){return e&&t?e+" and ("+t+")":e||t}),u(r[1],{})])};y.prototype.fetchOrGetParent=function(t,i){const n=this.mParameters.$$aggregation;if(!n||!n.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}if(this.aContexts[t.iIndex]!==t){throw new Error("Not currently part of a recursive hierarchy: "+t)}const r=this.oCache.getParentIndex(t.iIndex);if(r<0){return null}if(r===undefined&&i){return this.oCache.fetchParent(t.iIndex,this.lockGroup()).then(t=>{const i=this.getResolvedPath()+o.getPrivateAnnotation(t,"predicate");const n=e.create(this.oModel,this,i);this.mPreviousContextsByPath[i]=n;return n})}return i?this.requestContexts(r,1).then(e=>e[0]):this.aContexts[r]};y.prototype.fetchValue=function(e,t,i){var n=i&&this.oCache!==undefined?d.resolve(this.oCache):this.oCachePromise,r=this;return n.then(function(n){var o,a;if(n){o=i?s.$cached:r.lockGroup();a=r.getRelativePath(e);if(a!==undefined){return n.fetchValue(o,a,undefined,t)}}if(r.oContext){return r.oContext.fetchValue(e,t,i)}})};y.prototype.findContextForCanonicalPath=function(e){var t=Object.values(this.mPreviousContextsByPath).filter(function(e){return e.isEffectivelyKeptAlive()});function i(t){return t.find(function(t){var i;if(t){i=t.fetchCanonicalPath();i.caught();return i.getResult()===e}})}return i(t)||i(this.aContexts)};y.prototype.filter=function(e,t){var i=o.toArray(e);this.checkTransient();c.checkFilterNone(i);if(i[0]===c.NONE&&this.mParameters.$$aggregation){throw new Error("Cannot combine Filter.NONE with $$aggregation")}if(this.sOperationMode!==v.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server")}if(t===g.Control?o.deepEqual(i,this.aFilters):o.deepEqual(i,this.aApplicationFilters)){return this}if(this.hasPendingChanges(true)){throw new Error("Cannot filter due to pending changes")}if(t===g.Control){this.aFilters=i}else{this.aApplicationFilters=i}this.oQueryOptionsPromise=undefined;if(this.isRootBindingSuspended()){this.setResumeChangeReason(f.Filter);return this}this.createReadGroupLock(this.getGroupId(),true);this.removeCachesAndMessages("");this.fetchCache(this.oContext);this.reset(f.Filter);if(this.oHeaderContext){this.oHeaderContext.setSelected(false);this.oHeaderContext.checkUpdate()}return this};y.prototype.fireCreateActivate=function(e){if(this.fireEvent("createActivate",{context:e},true)){this.iActiveContexts+=1;return true}return false};y.prototype.getAggregation=function(e){return o.clone(this.mParameters.$$aggregation,function(t,i){return t[0]==="$"&&!(e&&["$DistanceFromRoot","$DrillState","$NodeProperty"].includes(t))?undefined:i})};y.prototype.getAllCurrentContexts=function(){var e;this.withCache(function(t,i){e=t.getAllElements(i)},"",true);if(e&&this.createContexts(0,e)){this._fireChange({reason:f.Change})}return this.aContexts.filter(function(e){return e}).concat(Object.values(this.mPreviousContextsByPath).filter(function(e){return e.isEffectivelyKeptAlive()}))};y.prototype.getCacheAndMoveKeepAliveContexts=function(e,t){var i,n,r=this;if(!this.mParameters.$$getKeepAliveContext){return undefined}i=this.oModel.releaseKeepAliveBinding("/"+e);if(!i){return undefined}Object.keys(i.mParameters).concat(Object.keys(this.mParameters)).forEach(function(e){if((e[0]!=="$"||e==="$$patchWithoutSideEffects"||e==="$$updateGroupId")&&r.mParameters[e]!==i.mParameters[e]){throw new Error(r+": parameter does not match getKeepAliveContext: "+e)}});this.mLateQueryOptions=o.clone(t);o.aggregateExpandSelect(this.mLateQueryOptions,i.mLateQueryOptions);this.mPreviousContextsByPath=i.mPreviousContextsByPath;Object.values(this.mPreviousContextsByPath).forEach(function(e){e.oBinding=r});n=i.oCache;n.setQueryOptions(t);i.oCache=null;i.oCachePromise=d.resolve(null);i.mPreviousContextsByPath={};i.destroy();return n};y.prototype.getContexts=function(t,i,n,r){var s,o,a=false,d=false,u,c,l=!!this.sChangeReason,p=this.getResolvedPath(),g,C=this;h.debug(this+"#getContexts("+t+", "+i+", "+n+")",undefined,P);this.checkSuspended();t=t||0;if(t!==0&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" iStart must be 0 if extended change detection is enabled, but is "+t)}if(this.bUseExtendedChangeDetection){if(n!==undefined){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" iMaximumPrefetchSize must not be set if extended change detection is"+" enabled")}if(r){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" must not use bKeepCurrent if extended change detection is enabled")}}if(n&&r){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" must not use both iMaximumPrefetchSize and bKeepCurrent")}if(!this.isResolved()){this.aPreviousData=null;return[]}s=this.sChangeReason||f.Change;this.sChangeReason=undefined;if(s==="AddVirtualContext"){this.oModel.addPrerenderingTask(function(){var e=C.bUseExtendedChangeDetection;if(C.aContexts&&!C.isRootBindingSuspended()){C.bUseExtendedChangeDetection=false;C.getContexts(t,i,n);C.bUseExtendedChangeDetection=e}C.oModel.addPrerenderingTask(function(){if(!C.isRootBindingSuspended()){C.sChangeReason="RemoveVirtualContext";C._fireChange({detailedReason:"RemoveVirtualContext",reason:f.Change});C.reset(f.Refresh)}})},true);g=e.create(this.oModel,this,p+"/"+e.VIRTUAL,e.VIRTUAL);C.mPreviousContextsByPath[g.getPath()]=g;return[g]}if(s==="RemoveVirtualContext"||this.oContext&&this.oContext.iIndex===e.VIRTUAL){return[]}i=i||this.oModel.iSizeLimit;if(!n||n<0){n=0}if(!this.oDiff){u=this.isRefreshWithoutBubbling();c=this.fetchContexts(t,i,n,undefined,l,function(){a=true;C.fireDataRequested(u)});this.resolveRefreshPromise(c).then(function(e){if(C.bUseExtendedChangeDetection){C.oDiff={aDiff:C.getDiff(i),iLength:i}}if(d){if(e||C.oDiff&&C.oDiff.aDiff?.length){C._fireChange({reason:s})}else{C.oDiff=undefined}}if(a){C.fireDataReceived({data:{}},u)}},function(e){if(a){C.fireDataReceived(e.canceled?{data:{}}:{error:e},u)}throw e}).catch(function(e){C.oModel.reportError("Failed to get contexts for "+C.oModel.sServiceUrl+p.slice(1)+" with start index "+t+" and length "+i,P,e)});d=true}if(!r){this.iCurrentBegin=t;this.iCurrentEnd=t+i}o=this.getContextsInViewOrder(t,i);if(this.bUseExtendedChangeDetection){if(this.oDiff&&i!==this.oDiff.iLength){throw new Error("Extended change detection protocol violation: Expected "+"getContexts(0,"+this.oDiff.iLength+"), but got getContexts(0,"+i+")")}o.dataRequested=!this.oDiff;o.diff=this.oDiff?this.oDiff.aDiff:[]}this.oDiff=undefined;return o};y.prototype.getContextsInViewOrder=function(e,t){var i,n,r;if(this.bFirstCreateAtEnd){i=[];n=Math.min(t,this.getLength()-e);for(r=0;r<n;r+=1){i[r]=this.aContexts[this.getModelIndex(e+r)]}}else{i=this.aContexts.slice(e,e+t)}return i};y.prototype.getCount=function(){var e=this.getHeaderContext();return e?e.getProperty("$count"):undefined};y.prototype.getCurrentContexts=function(){var e,t=Math.min(this.iCurrentEnd,this.iMaxLength+this.iCreatedContexts)-this.iCurrentBegin;e=this.getContextsInViewOrder(this.iCurrentBegin,t);if(t<Infinity){while(e.length<t){e.push(undefined)}}return e};y.prototype.getDependentBindings=function(){var e=this;return this.oModel.getDependentBindings(this).filter(function(t){return t.oContext.isEffectivelyKeptAlive()||!(t.oContext.getPath()in e.mPreviousContextsByPath)})};y.prototype.getDiff=function(e){var t=this.aPreviousData,i=this;this.aPreviousData=this.getContextsInViewOrder(0,e).map(function(e){return i.getContextData(e)});return t?this.diffData(t,this.aPreviousData):null};y.prototype.getDistinctValues=function(e){throw new Error("Unsupported operation: v4.ODataListBinding#getDistinctValues")};y.prototype.getDownloadUrl=o.createGetMethod("fetchDownloadUrl",true);y.prototype.getEntryData=function(e){return o.publicClone(e.getValue(),false,true)};y.prototype.getEntryKey=function(e){return e.getPath()};y.prototype.getFilterInfo=function(e){var t=p.combineFilters(this.aFilters,this.aApplicationFilters),i=null,n;if(t){i=t.getAST(e)}if(this.mQueryOptions.$filter){n={expression:this.mQueryOptions.$filter,syntax:"OData "+this.oModel.getODataVersion(),type:"Custom"};if(i){i={left:i,op:"&&",right:n,type:"Logical"}}else{i=n}}return i};y.prototype.getGeneration=function(){return this.oHeaderContext.getGeneration(true)||t.prototype.getGeneration.call(this)};y.prototype.getHeaderContext=function(){return this.isResolved()?this.oHeaderContext:null};y.prototype.getModelIndex=function(e){if(!this.bFirstCreateAtEnd){return e}if(!this.bLengthFinal){return this.aContexts.length-e-1}return e<this.getLength()-this.iCreatedContexts?e+this.iCreatedContexts:this.getLength()-e-1};y.prototype.getKeepAliveContext=function(t,i,n){var r=this.mPreviousContextsByPath[t]||this.aContexts.find(function(e){return e&&e.getPath()===t}),s=o.getPredicateIndex(t),a=this.getResolvedPath();this.checkKeepAlive();this.checkSuspended();this.checkTransient();o.checkGroupId(n);if(!r){if(!a){throw new Error("Binding is unresolved: "+this)}if(t.slice(0,s)!==a){throw new Error(this+": Not a valid context path: "+t)}r=e.create(this.oModel,this,t);this.mPreviousContextsByPath[t]=r;this.oCachePromise.then(function(e){var i={};o.setPrivateAnnotation(i,"predicate",t.slice(s));e.addKeptElement(i);if(n){o.setPrivateAnnotation(i,"groupId",n)}});this.oModel.getMetaModel().requestObject(o.getMetaPath(a)+"/").then(function(e){return r.requestProperty(e.$Key.map(function(e){return typeof e==="object"?Object.values(e)[0]:e}))}).catch(this.oModel.getReporter())}r.setKeepAlive(true,r.fnOnBeforeDestroy,i);return r};y.prototype.getKeepAlivePredicates=function(){var e;if(!this.getHeaderContext()){return[]}e=this.getHeaderContext().getPath();return Object.values(this.mPreviousContextsByPath).concat(this.aContexts).filter(function(e){return e.isEffectivelyKeptAlive()}).map(function(t){return o.getRelativePath(t.getPath(),e)})};y.prototype.getLength=function(){if(this.bLengthFinal){return this.iMaxLength+this.iCreatedContexts}return this.aContexts.length?this.aContexts.length+10:0};y.prototype.getOrderby=function(e){var t=[],i=this;this.aSorters.forEach(function(e){if(e instanceof x){t.push(e.sPath+(e.bDescending?" desc":""))}else{throw new Error("Unsupported sorter: "+e+" - "+i)}});if(e){t.push(e)}return t.join(",")};y.prototype.getQueryOptions=function(e){var t={},i=this;if(e){throw new Error("Unsupported parameter value: bWithSystemQueryOptions: "+e)}Object.keys(this.mQueryOptions).forEach(function(e){if(e[0]!=="$"){t[e]=o.clone(i.mQueryOptions[e])}});return t};y.prototype.getQueryOptionsFromParameters=function(){return this.mQueryOptions};y.prototype.hasFilterNone=function(){return this.aFilters[0]===c.NONE||this.aApplicationFilters[0]===c.NONE};y.prototype.hasPendingChangesForPath=function(e){if(this.oCache===undefined){return this.iActiveContexts>0}return t.prototype.hasPendingChangesForPath.apply(this,arguments)};y.prototype.inheritQueryOptions=function(e,t){var i;if(o.isEmptyObject(this.mParameters)){i=this.getQueryOptionsForPath("",t);if(e.$orderby&&i.$orderby){e.$orderby+=","+i.$orderby}if(e.$filter&&i.$filter){e.$filter="("+e.$filter+") and ("+i.$filter+")"}e=o.merge({},i,e);o.aggregateExpandSelect(e,i)}return e};y.prototype.initialize=function(){if(this.isResolved()){if(this.isRootBindingSuspended()){this.sResumeChangeReason=this.sChangeReason==="AddVirtualContext"?f.Change:f.Refresh}else if(this.sChangeReason==="AddVirtualContext"){this._fireChange({detailedReason:"AddVirtualContext",reason:f.Change})}else{this.sChangeReason=f.Refresh;this._fireRefresh({reason:f.Refresh})}}};y.prototype.insertGap=function(e,t){const i=this.aContexts;for(let n=i.length-1;n>e;n-=1){const e=i[n];if(e){e.iIndex+=t;i[n+t]=e;delete i[n]}}this.iMaxLength+=t};y.prototype.isAncestorOf=function(e,t){if(!this.mParameters.$$aggregation||!this.mParameters.$$aggregation.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}if(!t){return false}[e,t].forEach(e=>{if(this.aContexts[e.iIndex]!==e){throw new Error("Not currently part of a recursive hierarchy: "+e)}});return this.oCache.isAncestorOf(e.iIndex,t.iIndex)};y.prototype.isFirstCreateAtEnd=function(){return this.bFirstCreateAtEnd};y.prototype.isKeepAliveBindingFor=function(e){return this.mParameters.$$getKeepAliveContext&&this.getResolvedPath()===e&&(!this.isRootBindingSuspended()||this.aContexts.length||!o.isEmptyObject(this.mPreviousContextsByPath))};y.prototype.isLengthFinal=function(){return this.bLengthFinal};y.prototype.isUnchangedParameter=function(e,i){if(e==="$$aggregation"){i=o.clone(i);n.buildApply(i);return o.deepEqual(o.cloneNo$(this.mParameters.$$aggregation),o.cloneNo$(i))}return t.prototype.isUnchangedParameter.apply(this,arguments)};y.prototype.keepOnlyVisibleContexts=function(){const e=this.aContexts.slice(0,this.iCreatedContexts);const t=e.concat(this.getCurrentContexts().filter(t=>t&&!e.includes(t)));Object.keys(this.mPreviousContextsByPath).forEach(e=>{var i=this.mPreviousContextsByPath[e];if(i.isEffectivelyKeptAlive()){t.push(i)}});let i=0;function n(e,n,r){if(n.created()){t.push(n);i=e+r+1}else{delete this.aContexts[e+r];this.destroyLater(n)}}this.aContexts.slice(this.iCreatedContexts,this.iCurrentBegin).forEach(n.bind(this,this.iCreatedContexts));if(this.aContexts.length>this.iCurrentEnd&&this.iCurrentEnd>=this.iCreatedContexts){this.aContexts.slice(this.iCurrentEnd).forEach(n.bind(this,this.iCurrentEnd));this.aContexts.length=Math.max(i,this.iCurrentEnd)}return t.filter(e=>!e.getProperty("@$ui5.context.isTransient"))};y.prototype.move=function(e,t){const i=(e,t)=>{for(let i=e;i<=t;i+=1){if(this.aContexts[i]){this.aContexts[i].iIndex=i}}};const n=this.mParameters.$$aggregation;if(!n||!n.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}if(n.expandTo>1&&n.expandTo<999){throw new Error("Unsupported $$aggregation.expandTo: "+n.expandTo)}const r=e.isExpanded();if(r){this.collapse(e,true)}const s=e.getCanonicalPath().slice(1);const o=t?.getCanonicalPath().slice(1);const a=this.lockGroup(this.getUpdateGroupId(),true,true);return this.oCache.move(a,s,o).then(s=>{if(s>1){s-=1;this.insertGap(t.getModelIndex(),s)}const o=this.aContexts.indexOf(e);const a=this.aContexts.indexOf(t);if(o<a){this.aContexts.splice(a+1,0,e);this.aContexts.splice(o,1);i(o,a)}else if(o>a+1){this.aContexts.splice(o,1);this.aContexts.splice(a+1,0,e);i(a+1,o)}if(!e.created()&&!(n.expandTo>1)){e.setCreatedPersisted()}if(r){this.expand(e).unwrap()}else{this._fireChange({reason:f.Change})}},t=>{if(r){this.expand(e,true).unwrap()}throw t})};y.prototype.onChange=function(){var e,t=this;if(!this.oRefreshPromise){if(this.isRootBindingSuspended()){this.sResumeAction="onChange"}else{e=this.getDependentBindings();this.reset(f.Refresh);d.all(e.map(function(e){return e.refreshInternal("")})).then(function(){return t.oHeaderContext.checkUpdateInternal()}).catch(this.oModel.getReporter())}}};y.prototype.onKeepAliveChanged=function(e){if(!e.isDeleted()&&e.getPath()in this.mPreviousContextsByPath&&!e.isEffectivelyKeptAlive()){this.destroyPreviousContextsLater([e.getPath()])}};y.prototype.prepareDeepCreate=function(t,i){var n=this;if(!t){return!i}if(t.iIndex===e.VIRTUAL){return true}if(!t.getPath().includes("($uid=")){return!i}this.mCacheQueryOptions=i;if(!this.oModel.bAutoExpandSelect){return true}t.withCache(function(t,r){var s=t.addTransientCollection(r,i&&i.$select),a=n.getResolvedPath();n.aContexts=s.map(function(t,i){var r,h=o.getPrivateAnnotation(t,"transientPredicate"),d=o.getPrivateAnnotation(t,"promise");r=e.create(n.oModel,n,a+h,i-s.length,d,false,true);r.created().catch(n.oModel.getReporter());o.setPrivateAnnotation(t,"context",r);o.setPrivateAnnotation(t,"firstCreateAtEnd",false);o.deletePrivateAnnotation(t,"promise");return r});n.iCreatedContexts=n.iActiveContexts=n.aContexts.length;n.bFirstCreateAtEnd=false},this.sPath);return true};y.prototype.refreshInternal=function(e,t,i,n){var r=this;function s(i){return i.map(function(i){if(i.bIsBeingDestroyed||i.getContext().isEffectivelyKeptAlive()&&i.hasPendingChanges()){return}return i.refreshInternal(e,t,false,n)})}if(this.isRootBindingSuspended()){if(this.bSharedRequest){this.sResumeAction="resetCache"}else{this.refreshSuspended(t);this.bRefreshKeptElements=true}return d.all(s(r.getDependentBindings()))}this.createReadGroupLock(t,this.isRoot());return this.oCachePromise.then(function(i){var o=r.iActiveContexts,a=r.iCreatedContexts,h=r.aContexts.slice(0,a),u,c,l=r.oRefreshPromise;if(i&&!l){r.removeCachesAndMessages(e);if(r.bSharedRequest){l=r.createRefreshPromise();i.reset([])}else{r.fetchCache(r.oContext,false,true,n?t:undefined);c=r.refreshKeptElements(t);if(r.iCurrentEnd>0){l=r.createRefreshPromise(n).catch(function(e){if(!n||e.canceled){throw e}return r.fetchResourcePath(r.oContext).then(function(t){var n;if(!r.bRelative||i.getResourcePath()===t){if(r.oCache===i){i.restore(true)}else{i.setActive(true);r.oCache=i;r.oCachePromise=d.resolve(i)}r.iActiveContexts=o;r.iCreatedContexts=a;for(n=0;n<a;n+=1){h[n].iIndex=n-a;delete r.mPreviousContextsByPath[h[n].getPath()]}r.aContexts=h;r._fireChange({reason:f.Change})}throw e})}).finally(function(){if(i.restore){i.restore(false)}})}}}u=r.getDependentBindings();r.reset(f.Refresh,!i||(n?false:undefined),t);return d.all(s(u).concat(l,c)).then(function(){return r.oHeaderContext.checkUpdateInternal()})})};y.prototype.refreshKeptElements=function(e){var t=this;return this.oCachePromise.then(function(i){return i.refreshKeptElements(t.lockGroup(e),function e(i,n){var r=n>=0?t.aContexts[n]:t.mPreviousContextsByPath[t.getResolvedPath()+i];r.resetKeepAlive();if(n>=0){t.removeCreated(r)}})}).catch(function(e){t.oModel.reportError("Failed to refresh kept-alive elements",P,e);throw e})};y.prototype.refreshSingle=function(e,t,i,n,r){var s=e.getPath(),a=s.slice(1),h=this;if(e===this.oHeaderContext){throw new Error("Unsupported header context: "+e)}if(i&&r){throw new Error("Unsupported: bAllowRemoval && bWithMessages")}return this.withCache(function(u,c,l){var p=false,g=false,C=e.getModelIndex(),x=o.getRelativePath(s,h.oHeaderContext.getPath()),v=[];function m(e){if(p){h.fireDataReceived(e)}}function y(){p=true;h.fireDataRequested()}function E(t){var i=e.getModelIndex(),n;if(e.iIndex<0){if(t){h.mPreviousContextsByPath[s]=e}else{e.resetKeepAlive();g=true}h.removeCreated(e)}else{if(i===undefined){delete h.mPreviousContextsByPath[s]}else{h.aContexts.splice(i,1);h.iMaxLength-=1;for(n=i;n<h.aContexts.length;n+=1){if(h.aContexts[n]){h.aContexts[n].iIndex-=1}}if(t){h.mPreviousContextsByPath[s]=e}}if(!t){g=true;e.destroy()}}if(i!==undefined){h._fireChange({reason:f.Remove})}}if(C<0){throw new Error("Cannot refresh. Hint: Side-effects refresh in parallel? "+e)}v.push((i?u.refreshSingleWithRemove(t,c,C,x,e.isEffectivelyKeptAlive(),y,E):u.refreshSingle(t,c,C,x,e.isKeepAlive(),r,y)).then(function(){var r=[];m({data:{}});l.assertSameCache(u);if(!g){r.push(e.checkUpdateInternal());if(i){r.push(e.refreshDependentBindings(a,t.getGroupId(),false,n))}}return d.all(r)},function(e){m({error:e});throw e}).catch(function(i){t.unlock(true);h.oModel.reportError("Failed to refresh entity: "+e,P,i);if(!i.canceled){throw i}}));if(!i){v.push(e.refreshDependentBindings(a,t.getGroupId(),false,n))}return d.all(v)})};y.prototype.removeCreated=function(e){var t,i;if(this.mParameters.$$aggregation){this.iMaxLength-=1;t=this.aContexts.indexOf(e);for(i=this.aContexts.length-1;i>t;i-=1){if(this.aContexts[i]){this.aContexts[i].iIndex-=1}}}else{t=e.getModelIndex();this.iCreatedContexts-=1;if(!this.iCreatedContexts){this.bFirstCreateAtEnd=undefined}if(!e.isInactive()){this.iActiveContexts-=1}for(i=0;i<t;i+=1){this.aContexts[i].iIndex+=1}}this.aContexts.splice(t,1);if(!e.isEffectivelyKeptAlive()){this.destroyLater(e)}};y.prototype.requestContexts=function(e,t,i){var n=this;if(!this.isResolved()){throw new Error("Unresolved binding: "+this.sPath)}this.checkSuspended();o.checkGroupId(i);e=e||0;t=t||this.oModel.iSizeLimit;const r=i&&this.lockGroup(i,true);return Promise.resolve(this.fetchContexts(e,t,0,r)).then(function(i){if(i){n._fireChange({reason:f.Change})}return n.getContextsInViewOrder(e,t)},function(i){n.oModel.reportError("Failed to get contexts for "+n.oModel.sServiceUrl+n.getResolvedPath().slice(1)+" with start index "+e+" and length "+t,P,i);throw i})};y.prototype.requestDownloadUrl=o.createRequestMethod("fetchDownloadUrl");y.prototype.requestFilterForMessages=function(e){var t=this.oModel.getMetaModel(),i,n=this.oHeaderContext&&this.oHeaderContext.getPath(),r=this;this.checkTransient();if(!n){return Promise.resolve(null)}i=o.getMetaPath(n);return t.requestObject(i+"/").then(function(s){var o,a={},h=false;r.oModel.getMessagesByPath(n,true).filter(function(t){return!e||e(t)}).forEach(function(e){e.getTargets().forEach(function(e){var t=e.slice(n.length).split("/")[0];if(t){if(t.startsWith("($uid=")){h=true}else{a[t]=true}}})});o=Object.keys(a).map(function(e){return y.getFilterForPredicate(e,s,t,i)});if(o.length===0){return h?c.NONE:null}return o.length===1?o[0]:new c({filters:o})})};y.prototype.requestSideEffects=function(e,t,i){var r=this.oModel,s,a,h=i&&i!==this.oHeaderContext,u=this;function f(e){return e.catch(function(e){r.reportError("Failed to request side effects",P,e);if(!e.canceled){throw e}})}if(o.isDataAggregation(this.mParameters)){if(h){throw new Error("Must not request side effects when using data aggregation")}if(n.isAffected(this.mParameters.$$aggregation,this.aFilters.concat(this.aApplicationFilters),t)){return this.refreshInternal("",e,false,true)}return d.resolve()}if(!h&&this.oCache&&this.oCache.isDeletingInOtherGroup(e)){throw new Error("Must not request side effects when there is a pending delete in a"+" different batch group")}if(this.oCache&&this.oCache.getPendingRequestsPromise()){return d.resolve(this.oCache.getPendingRequestsPromise()).then(function(){return u.requestSideEffects(e,t,i)})}if(t.indexOf("")<0){s=o.getPredicates(h?[i]:this.keepOnlyVisibleContexts());if(s){a=this.oCache?[this.oCache.requestSideEffects(this.lockGroup(e),t,s,h,h)]:[];this.visitSideEffects(e,t,h?i:undefined,a);return d.all(a.map(f)).then(function(){return u.refreshDependentListBindingsWithoutCache()})}}if(h){return this.refreshSingle(i,this.lockGroup(e),false,true,true)}if(this.iCurrentEnd===0){return d.resolve()}return this.refreshInternal("",e,false,true)};y.prototype.reset=function(e,t,i){var n,r=0,s=this.iCurrentEnd===0,o=i&&i!==this.getUpdateGroupId(),a,h=this;if(t===true){this.iActiveContexts=0;this.iCreatedContexts=0}if(this.aContexts){this.aContexts.slice(this.iCreatedContexts).forEach(function(e){h.mPreviousContextsByPath[e.getPath()]=e});for(a=0;a<this.iCreatedContexts;a+=1){n=this.aContexts[a];if(t===false?o&&n.isTransient()||n.isInactive()!==undefined:n.isTransient()){this.aContexts[r]=n;r+=1}else{this.iActiveContexts-=1;this.mPreviousContextsByPath[n.getPath()]=n}}for(a=0;a<r;a+=1){this.aContexts[a].iIndex=a-r}this.aContexts.length=this.iCreatedContexts=r}else{this.aContexts=[]}if(!this.iCreatedContexts){this.bFirstCreateAtEnd=undefined}this.iCurrentBegin=this.iCurrentEnd=0;this.iMaxLength=Infinity;this.bLengthFinal=false;if(e&&!(s&&e===f.Change)){this.sChangeReason=e;this._fireRefresh({reason:e})}};y.prototype.resetKeepAlive=function(){var e=this.mPreviousContextsByPath;Object.keys(e).forEach(function(t){e[t].resetKeepAlive()});this.aContexts.forEach(function(e){e.resetKeepAlive()})};y.prototype.restoreCreated=function(){var e=this;this.withCache(function(t,i){if(e.aContexts.length){return}t.getCreatedElements(i).forEach(function(t,i){e.aContexts[i]=o.getPrivateAnnotation(t,"context");e.bFirstCreateAtEnd=o.getPrivateAnnotation(t,"firstCreateAtEnd");e.iCreatedContexts+=1;if(!t["@$ui5.context.isInactive"]){e.iActiveContexts+=1}})}).catch(this.oModel.getReporter())};y.prototype.resumeInternal=function(e,t){var i=this.sResumeAction,n=this.sResumeChangeReason,r=t||i||n,s=this;this.sResumeAction=undefined;this.sResumeChangeReason=undefined;if(r){this.removeCachesAndMessages("");if(i==="onChange"){this.onChange();return}if(i==="resetCache"){this.oCache.reset([]);return}this.reset();this.fetchCache(this.oContext,!t);if(this.bRefreshKeptElements){this.bRefreshKeptElements=false;s.refreshKeptElements(s.getGroupId())}}this.getDependentBindings().forEach(function(e){e.resumeInternal(!r,!!n&&!e.oContext.isEffectivelyKeptAlive())});if(this.sChangeReason==="AddVirtualContext"){this._fireChange({detailedReason:"AddVirtualContext",reason:n})}else if(n){this._fireRefresh({reason:n})}else{this.removeReadGroupLock()}this.oHeaderContext.checkUpdate()};y.prototype.setAggregation=function(e){var t;function i(e){return e&&!!e.hierarchyQualifier}this.checkTransient();if(this.hasFilterNone()){throw new Error("Cannot combine Filter.NONE with $$aggregation")}if(this.hasPendingChanges()){throw new Error("Cannot set $$aggregation due to pending changes")}if(i(this.mParameters.$$aggregation)!==i(e)&&this.getKeepAlivePredicates().length){throw new Error("Cannot set $$aggregation due to a kept-alive context")}t=Object.assign({},this.mParameters);if(e===undefined){delete t.$$aggregation}else{t.$$aggregation=o.clone(e)}this.applyParameters(t,"")};y.prototype.setContext=function(t){var i;if(this.oContext!==t){if(this.bRelative){this.checkSuspended(true);this.reset(undefined,true);this.resetKeepAlive();this.fetchCache(t);if(t){this.restoreCreated();i=this.oModel.resolve(this.sPath,t);if(this.oHeaderContext&&this.oHeaderContext.getPath()!==i){this.oHeaderContext.setSelected(false);this.mPreviousContextsByPath[this.oHeaderContext.getPath()]=this.oHeaderContext;this.oHeaderContext=null}if(!this.oHeaderContext){this.oHeaderContext=e.create(this.oModel,this,i)}if(this.mParameters.$$aggregation){n.setPath(this.mParameters.$$aggregation,i)}else if(this.bHasPathReductionToParent&&this.oModel.bAutoExpandSelect){this.mCanUseCachePromiseByChildPath={};this.sChangeReason="AddVirtualContext"}if(t.getBinding&&t.getBinding().isRootBindingSuspended()){this.oContext=t;this.setResumeChangeReason(f.Context);return}}u.prototype.setContext.call(this,t,{detailedReason:this.sChangeReason})}else{this.oContext=t}}};y.prototype.sort=function(e){var t=o.toArray(e);this.checkTransient();if(this.sOperationMode!==v.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server")}if(o.deepEqual(t,this.aSorters)){return this}if(this.hasPendingChanges(true)){throw new Error("Cannot sort due to pending changes")}this.aSorters=t;this.oQueryOptionsPromise=undefined;if(this.isRootBindingSuspended()){this.setResumeChangeReason(f.Sort);return this}this.createReadGroupLock(this.getGroupId(),true);this.removeCachesAndMessages("");this.fetchCache(this.oContext);this.reset(f.Sort);if(this.oHeaderContext){this.oHeaderContext.checkUpdate()}return this};y.prototype.updateAfterCreate=function(e,i){var n,r,a=this;if(this.iCreatedContexts){if(e){this.reset(f.Change,true)}else{this.reset(undefined,true);r=this.fetchContexts(0,Infinity,0,s.$cached).then(function(){a.iCurrentEnd=a.aContexts.length;return a.requestSideEffects(i,o.getMissingPropertyPaths(a.fetchValue("",null,true).getResult(),a.mAggregatedQueryOptions))}).then(function(){a._fireChange({reason:f.Change})})}n=d.all([r,t.prototype.updateAfterCreate.apply(this,arguments)])}else{n=this.refreshInternal("",i)}return n};y.prototype.updateAnalyticalInfo=function(e){var t={aggregate:{},group:{},search:this.mParameters.$$aggregation&&this.mParameters.$$aggregation.search},i=false,n=this;e.forEach(function(e){var n={};if("total"in e){if("grouped"in e){throw new Error("Both dimension and measure: "+e.name)}if(e.as){n.name=e.name;t.aggregate[e.as]=n}else{t.aggregate[e.name]=n}if(e.min){n.min=true;i=true}if(e.max){n.max=true;i=true}if(e.with){n.with=e.with}}else if(!("grouped"in e)||e.inResult||e.visible){t.group[e.name]=n}});this.bHasAnalyticalInfo=true;this.setAggregation(t);if(i){return{measureRangePromise:Promise.resolve(this.getRootBindingResumePromise().then(function(){return n.oCachePromise}).then(function(e){return e.getMeasureRangePromise()}))}}};y.getFilterForPredicate=function(e,t,i,n){var r,s=a.parseKeyPredicate(e);if(""in s){s[t.$Key[0]]=s[""];delete s[""]}r=t.$Key.map(function(e){var t,r;if(typeof e==="string"){r=t=e}else{t=Object.keys(e)[0];r=e[t]}return new c(r,l.EQ,o.parseLiteral(decodeURIComponent(s[t]),i.getObject(n+"/"+r+"/$Type"),r))});return r.length===1?r[0]:new c({and:true,filters:r})};y.isBelowCreated=function(e){var t;if(!(e&&e.getBinding)){return false}if(e.isTransient()===false){return true}t=e.getBinding();return t&&t.isRelative()&&y.isBelowCreated(t.getContext())};return y});
//# sourceMappingURL=ODataListBinding.js.map