/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnnotationHelper","./ValueListType","./lib/_Helper","sap/base/assert","sap/base/Log","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/ui/base/ManagedObject","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/Context","sap/ui/model/ContextBinding","sap/ui/model/MetaModel","sap/ui/model/PropertyBinding","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Boolean","sap/ui/model/odata/type/Byte","sap/ui/model/odata/type/Date","sap/ui/model/odata/type/DateTimeOffset","sap/ui/model/odata/type/Decimal","sap/ui/model/odata/type/Double","sap/ui/model/odata/type/Guid","sap/ui/model/odata/type/Int16","sap/ui/model/odata/type/Int32","sap/ui/model/odata/type/Int64","sap/ui/model/odata/type/Raw","sap/ui/model/odata/type/SByte","sap/ui/model/odata/type/Single","sap/ui/model/odata/type/Stream","sap/ui/model/odata/type/String","sap/ui/model/odata/type/TimeOfDay","sap/ui/thirdparty/URI"],function(e,t,n,i,r,o,a,s,u,f,l,c,d,p,h,g,y,m,v,$,b,C,O,M,P,E,w,x,U,T,S,A,j,L){"use strict";var R=s.extend("sap.ui.model.odata.v4._any",{metadata:{properties:{any:"any"}}}),D,I=new Map,V=r.Level.DEBUG,q=/\$\(/g,N=/^-?\d+$/,B="sap.ui.model.odata.v4.ODataMetaModel",k=/\(.*\)$/,W=new x,F=/\$\)/g,_=new Map,G={messageChange:true},K={"Edm.Boolean":{Type:m},"Edm.Byte":{Type:v},"Edm.Date":{Type:$},"Edm.DateTimeOffset":{constraints:{$Precision:"precision"},Type:b},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum/$Decimal":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum/$Decimal":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive",$Precision:"precision",$Scale:"scale"},Type:C},"Edm.Double":{Type:O},"Edm.Guid":{Type:M},"Edm.Int16":{Type:P},"Edm.Int32":{Type:E},"Edm.Int64":{Type:w},"Edm.SByte":{Type:U},"Edm.Single":{Type:T},"Edm.Stream":{Type:S},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence",$MaxLength:"maxLength"},Type:A},"Edm.TimeOfDay":{constraints:{$Precision:"precision"},Type:j}},z={},H="@com.sap.vocabularies.Common.v1.ValueList",Q="@com.sap.vocabularies.Common.v1.ValueListMapping",J="@com.sap.vocabularies.Common.v1.ValueListReferences",X="@com.sap.vocabularies.Common.v1.ValueListRelevantQualifiers",Y="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",Z=r.Level.WARNING,ee,te=h.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:de}),ne,ie;function re(e,t,n,i){var r,o=e.mSchema2MetadataUrl[t];if(!o){o=e.mSchema2MetadataUrl[t]={};o[n]=false}else if(!(n in o)){r=Object.keys(o)[0];if(o[r]){le(e,"A schema cannot span more than one document: "+t+" - expected reference URI "+r+" but instead saw "+n,i)}o[n]=false}}function oe(e,t,n,i){var r,o,a,s;function f(e){var r,a;if(!(n in e)){i(Z,o," does not contain ",n);return}i(V,"Including ",n," from ",o);for(a in e){if(a[0]!=="$"&&ce(a)===n){r=e[a];t[a]=r;fe(r,t.$Annotations)}}}if(n in t){return t[n]}s=e.mSchema2MetadataUrl[n];if(s){a=Object.keys(s);if(a.length>1){le(e,"A schema cannot span more than one document: "+"schema is referenced by following URLs: "+a.join(", "),n)}o=a[0];s[o]=true;i(V,"Namespace ",n," found in $Include of ",o);r=e.mMetadataUrl2Promise[o];if(!r){i(V,"Reading ",o);r=e.mMetadataUrl2Promise[o]=u.resolve(e.oRequestor.read(o)).then(e.validate.bind(e,o))}r=r.then(f);if(n in t){return t[n]}t[n]=r;return r}}function ae(e,t){if(e===t){return""}if(e.startsWith(t)&&e[t.length]==="#"&&!e.includes("@",t.length)){return e.slice(t.length+1)}}function se(e){var t=ae(e,Q);return t!==undefined?t:ae(e,H)}function ue(e,t){return t.some(function(t){return e==="$ReturnType"?t.$ReturnType:t.$Parameter&&t.$Parameter.some(function(t){return t.$Name===e})})}function fe(e,t,n){var i;function r(e,t){var i;for(i in t){if(n||!(i in e)){e[i]=t[i]}}}for(i in e.$Annotations){if(!(i in t)){t[i]={}}r(t[i],e.$Annotations[i])}delete e.$Annotations}function le(e,t,n){var i=new Error(n+": "+t);e.oModel.reportError(t,B,i);throw i}function ce(e){return e.slice(0,e.lastIndexOf(".")+1)}ee=p.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(e,t,n){i(!n||n.getModel()===e,"oContext must belong to this model");p.call(this,e,t,n)},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange()}},setContext:function(e){i(!e||e.getModel()===this.oModel,"oContext must belong to this model");if(e!==this.oContext){this.oContext=e;if(!this.bInitial){this.initialize()}}}});ne=c.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){c.apply(this,arguments)},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(e){var t=this.oList.length;this.update();if(e||this.oList.length!==t){this._fireChange({reason:l.Change})}},fetchContexts:function(){var e,t=this.getResolvedPath(),n=this;if(!t){return u.resolve([])}e=t.endsWith("@");if(!e&&!t.endsWith("/")){t+="/"}return this.oModel.fetchObject(t).then(function(i){if(!i){return[]}if(e){t=t.slice(0,-1)}return Object.keys(i).filter(function(t){return t[0]!=="$"&&e!==(t[0]!=="@")}).map(function(e){return new d(n.oModel,t+e)})})},getContexts:function(e,t){this.iCurrentStart=e||0;this.iCurrentLength=Math.min(t||Infinity,this.iLength-this.iCurrentStart);return this.getCurrentContexts()},getCurrentContexts:function(){var e=[],t,n=this.iCurrentStart+this.iCurrentLength;for(t=this.iCurrentStart;t<n;t+=1){e.push(this.oList[this.aIndices[t]])}if(this.oList.dataRequested){e.dataRequested=true}return e},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength()},update:function(){var e=[],t=this.fetchContexts(),n=this;if(t.isFulfilled()){e=t.getResult()}else{t.then(function(e){n.setContexts(e);n._fireChange({reason:l.Change})});e.dataRequested=true}this.setContexts(e)}});ie=g.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){g.apply(this,arguments);this.vValue=undefined},checkUpdate:function(e,t){var n,i=this;function r(n){if(e||n!==i.vValue){i.vValue=n;i._fireChange({reason:t||l.Change})}return n}n=this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters).then(r);if(this.mParameters&&this.mParameters.$$valueAsPromise&&n.isPending()){r(n.unwrap())}else if(n.isRejected()){n.unwrap()}},getValue:function(){return this.vValue},setContext:function(e){if(this.oContext!==e){this.oContext=e;if(this.bRelative){this.checkUpdate(false,l.Context)}}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue")}});function de(e,t,n,i,r,o){h.call(this);this.aAnnotationUris=n&&!Array.isArray(n)?[n]:n;this.sDefaultBindingMode=f.OneTime;this.mETags={};this.sLanguage=o;this.oLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=i;this.mMetadataUrl2Promise={};this.oRequestor=e;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={OneTime:true,OneWay:true};this.bSupportReferences=r!==false;this.mUnsupportedFilterOperators={All:true,Any:true};this.sUrl=t}te.prototype.$$valueAsPromise=true;te.prototype._mergeAnnotations=function(e,t){var n=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(t){if(e[t].$kind==="Schema"){re(n,t,n.sUrl);fe(e[t],e.$Annotations)}});t.forEach(function(t,i){var r,o;n.validate(n.aAnnotationUris[i],t);for(o in t){if(o[0]!=="$"){if(o in e){le(n,"A schema cannot span more than one document: "+o,n.aAnnotationUris[i])}r=t[o];e[o]=r;if(r.$kind==="Schema"){re(n,o,n.aAnnotationUris[i]);fe(r,e.$Annotations,true)}}}})};te.prototype.attachEvent=function(e,t,n,i){if(!(e in G)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent")}return h.prototype.attachEvent.apply(this,arguments)};te.prototype.bindContext=function(e,t){return new ee(this,e,t)};te.prototype.bindList=function(e,t,n,i){return new ne(this,e,t,n,i)};te.prototype.bindProperty=function(e,t,n){return new ie(this,e,t,n)};te.prototype.bindTree=function(e,t,n,i,r){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree")};te.prototype.fetchCanonicalPath=function(e){return this.fetchUpdateData("",e).then(function(t){if(!t.editUrl){throw new Error(e.getPath()+": No canonical path for transient entity")}if(t.propertyPath){throw new Error("Context "+e.getPath()+" does not point to an entity. It should be "+t.entityPath)}return"/"+t.editUrl})};te.prototype.fetchData=function(){return this.fetchEntityContainer().then(function(e){return JSON.parse(JSON.stringify(e))})};te.prototype.fetchEntityContainer=function(e){var t,n=this;if(!this.oMetadataPromise){t=[u.resolve(this.oRequestor.read(this.sUrl,false,e))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(i){t.push(u.resolve(n.oRequestor.read(i,true,e)))})}if(!e){this.oMetadataPromise=u.all(t).then(function(e){var t=e[0];n._mergeAnnotations(t,e.slice(1));return t})}}return this.oMetadataPromise};te.prototype.fetchObject=function(e,t,n){var i=this.resolve(e,t),s=this;if(!i){r.error("Invalid relative path w/o context",e,B);return u.resolve(null)}return this.fetchEntityContainer().then(function(f){var l,c,p,h,g,y,m,v,$,b;function C(e,t,n){var i,r,o,a,s="";if(t){r=t.indexOf("@@");if(r>0){t=t.slice(0,r)}}else{t=e}n=n||"";if(l){m=a=b.filter(P);if(a.length!==1){return E(Z,"Expected a single overload, but found "+a.length)}if(l!==z){s=a[0].$Parameter[0].$isCollection?"Collection("+l+")":l}o=$+"("+s+")"+n;if(f.$Annotations[o]){if(t==="@"){b=f.$Annotations[o];i=f.$Annotations[$+n];if(i){b=Object.assign({},i,b)}return false}if(t in f.$Annotations[o]){$=o;b=f;return true}}}$+=n;b=f;return true}function O(e,t){var i,r,u,f=e.indexOf("@",2);if(f>-1){return E(Z,"Unsupported path after ",e.slice(0,f))}e=e.slice(2);u=e.indexOf("(");if(u>0){if(!e.endsWith(")")){return E(Z,"Expected ')' instead of '",e.slice(-1),"'")}try{r=o.parseJS("["+e.slice(u+1,-1).replace(q,"{").replace(F,"}")+"]")}catch(e){return E(Z,e.message,": ",e.text.slice(1,e.at),"<--",e.text.slice(e.at,-1))}e=e.slice(0,u)}i=e[0]==="."?a.get(e.slice(1),n.scope):n&&a.get(e,n.scope)||(e==="requestCurrencyCodes"||e==="requestUnitsOfMeasure"?s[e].bind(s):a.get(e));if(typeof i!=="function"){return E(Z,e," is not a function but: "+i)}try{b=i(b,{$$valueAsPromise:n&&n.$$valueAsPromise,arguments:r,context:new d(s,t),schemaChildName:v,overload:m.length===1?m[0]:undefined})}catch(t){E(Z,"Error calling ",e,": ",t)}return true}function M(e,t){var n;if(e==="$ReturnType"){if(t.$ReturnType){b=t.$ReturnType;return true}}else if(e&&t.$Parameter){n=t.$Parameter.filter(function(t){return t.$Name===e});if(n.length){b=n[0];return true}}return false}function P(e){return!e.$IsBound&&l===z||e.$IsBound&&l===e.$Parameter[0].$Type}function E(e){var t;if(r.isLoggable(e,B)){t=Array.isArray(h)?h.join("/"):h;r[e===V?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(t?" at /"+t:""),i,B)}if(e===Z){b=undefined}return false}function w(e,t){var n;function i(){h=h||$&&t&&$+"/"+t;return E.apply(this,arguments)}l=b&&b.$Type||l;if(s.bSupportReferences&&!(e in f)){n=ce(e);b=oe(s,f,n,i)}if(e in f){$=g=v=e;b=m=f[v];if(!u.isThenable(b)){return true}}if(u.isThenable(b)&&b.isPending()){return i(V,"Waiting for ",n)}return i(Z,"Unknown qualified name ",e)}function x(e,t,n){var i,r,o;if(e==="$Annotations"){return E(Z,"Invalid segment: $Annotations")}e=e.replaceAll("%2F","/");if(t&&typeof b==="object"&&e in b){if(e[0]==="$"||N.test(e)){y=false}}else{i=e.indexOf("@@");if(i<0){if(e.endsWith("@sapui.name")){i=e.length-11}else{i=e.indexOf("@")}}if(i>0){if(!x(e.slice(0,i),t,n)){return false}e=e.slice(i);o=true;if(b&&(b.$kind==="EntitySet"||b.$kind==="Singleton")){c=b}}if(typeof b==="string"&&!(o&&(e==="@sapui.name"||e[1]==="@"))&&!(y&&m&&m.$kind==="EnumType")&&!U(b,n.slice(0,t))){return false}if(y){if(e[0]==="$"&&e!=="$Parameter"&&e!=="$ReturnType"||N.test(e)){y=false}else{r=typeof b==="object";if(o){}else if(e[0]!=="@"&&e.includes(".",1)){return w(e)}else if(r&&"$Type"in b){if(!w(b.$Type,"$Type")){return false}}else if(r&&"$Action"in b){if(!w(b.$Action,"$Action")){return false}l=z}else if(r&&"$Function"in b){if(!w(b.$Function,"$Function")){return false}l=z}else if(!t){$=g=v=v||f.$EntityContainer;b=m=m||f[v];if(Array.isArray(b)){if(l){b=b.filter(P)}if(M(e,b[0])){return true}}if(e&&e[0]!=="@"&&!(e in m)){return E(Z,"Unknown child ",e," of ",v)}}if(Array.isArray(b)){if(e==="$Parameter"){return true}if(e.startsWith("@$ui5.overload@")){e=e.slice(14);o=true}if(o){if(e[1]!=="@"&&!C(e)){return false}}else{if(e!==n[t]&&n[t][e.length+1]!=="@"&&ue(e,b)){g=e;return C(e,n[t].slice(e.length),"/"+g)}if(l){b=b.filter(P)}if(e==="@$ui5.overload"){return true}if(b.length!==1){return E(Z,"Expected a single overload, but found "+b.length)}if(M(e,b[0])){return true}b=b[0].$ReturnType;$+="/0/$ReturnType";if(b){if(e==="value"&&!(f[b.$Type]&&f[b.$Type].value)){g=undefined;return true}if(!w(b.$Type,"$Type")){return false}}if(!e){return true}}}}}if(!e){return t+1>=n.length||E(Z,"Invalid empty segment")}if(e[0]==="@"){if(e==="@sapui.name"){b=g;if(b===undefined){E(Z,"Unsupported path before @sapui.name")}else if(t+1<n.length){E(Z,"Unsupported path after @sapui.name")}return false}if(e[1]==="@"){if(t+1<n.length){return E(Z,"Unsupported path after ",e)}return O(e,[""].concat(n.slice(0,t),n[t].slice(0,i)).join("/"))}}if(y&&e[0]==="@"){l=b&&b.$Type||l;b=f.$Annotations[$]||{};y=false}else if(e==="$"&&t+1<n.length){return E(Z,"Unsupported path after $")}else if(!b||typeof b!=="object"){b=undefined;return!p&&E(V,"Invalid segment: ",e)}}if(e!=="@"&&e!=="$"){if(e[0]==="@"){p=true}g=y||e[0]==="@"?e:undefined;$=y?$+"/"+e:undefined;b=b[e]}return true}function U(e,t){var n;if(h){return E(Z,"Invalid recursion")}h=t;p=false;y=true;b=f;if(c){if(!e){b=c;c=h=undefined;return true}v=c.$Type;c=m=undefined}n=e.split("/").every(x);h=undefined;return n}if(!U(i.slice(1))&&u.isThenable(b)){b=b.then(function(){return s.fetchObject(e,t,n)})}return b})};te.prototype.fetchUI5Type=function(e,t){var i=this.getMetaContext(e),o=this;if(e.endsWith("/$count")){D=D||new w;return u.resolve(D)}return this.fetchObject(undefined,i).catch(this.oModel.getReporter()).then(function(a){var s=W,u;if(!a){r.warning("No metadata for path '"+e+"', using "+s.getName(),undefined,B);return s}if(t){if(n.isEmptyObject(t)){t=undefined}else if("parseKeepsEmptyString"in t&&a.$Type!=="Edm.String"){if(Object.keys(t).length===1){t=undefined}else{t=Object.assign({},t);delete t.parseKeepsEmptyString}}}if(!t&&a["$ui5.type"]){return a["$ui5.type"]}if(a.$isCollection){r.warning("Unsupported collection type, using "+s.getName(),e,B)}else{u=K[a.$Type];if(u){s=new u.Type(t,o.getConstraints(a,i.getPath()))}else{r.warning("Unsupported type '"+a.$Type+"', using "+s.getName(),e,B)}}if(!t){a["$ui5.type"]=s}return s})};te.prototype.fetchUpdateData=function(e,t,i){var r=t.getModel(),o=r.resolve(e,t),a=this;function s(e){var t=new Error(o+": "+e);r.reportError(e,B,t);throw t}return this.fetchObject(n.getMetaPath(o)).then(function(){return a.fetchEntityContainer()}).then(function(r){var a,f=r[r.$EntityContainer],l,c,d,p,h=false,g,y,m,v=false,$;function b(e){var t=e.indexOf("(");return t>=0?e.slice(t):""}function C(e){a.push({path:g,prefix:e})}function O(e){var t=e.indexOf("(");return t>=0?e.slice(0,t):e}m=o.slice(1).split("/");p=m.shift();g="/"+p;l=g;d=decodeURIComponent(O(p));c=f[d];if(!c){s("Not an entity set: "+d)}$=r[c.$Type];e="";y="";a=[p];v=p.includes("($uid=");m.forEach(function(t){var i,o;g+="/"+t;if(N.test(t)){C(a.pop());l+="/"+t}else{o=decodeURIComponent(O(t));y=n.buildPath(y,o);i=h?{}:$[o];if(!i){if(o.includes("@")){if(o.includes("@$ui5.")){s("Read-only path must not be updated")}h=true;i={}}else{s("Not a (navigation) property: "+o)}}$=r[i.$Type];if(t.includes("($uid=")){l=g;e="";v=true}else if(!v&&i.$kind==="NavigationProperty"){if(c.$NavigationPropertyBinding&&y in c.$NavigationPropertyBinding){d=c.$NavigationPropertyBinding[y];c=f[d];y="";a=[encodeURIComponent(d)+b(t)];if(!i.$isCollection){C(a.pop())}}else{a.push(t)}l=g;e=""}else{e=n.buildPath(e,t)}}});if(v||i){return u.resolve({editUrl:undefined,entityPath:l,propertyPath:e})}return u.all(a.map(function(e){if(typeof e==="string"){return e}return t.fetchValue(e.path).then(function(t){var i;if(!t){s("No instance to calculate key predicate at "+e.path)}i=n.getPrivateAnnotation(t,"predicate");if(!i){s("No key predicate known at "+e.path)}return e.prefix+i},function(t){s(t.message+" at "+e.path)})})).then(function(t){return{editUrl:t.join("/"),entityPath:l,propertyPath:e}})})};te.prototype.fetchValueListMappings=function(e,t,i,r){var o=this,a=e.getMetaModel();function s(){var e=r[0],n="";if(r.length!==1){throw new Error("Expected a single overload, but found "+r.length)}if(e.$IsBound){n=e.$Parameter[0].$isCollection?"Collection("+e.$Parameter[0].$Type+")":e.$Parameter[0].$Type}return t+"("+n+")"}return a.fetchEntityContainer().then(function(r){var u,f=r.$Annotations,l,c=n.namespace(t),d={},p=o===a,h,g;if(i.$Name){l=s()+"/"+i.$Name;g=t+"/"+i.$Name}h=Object.keys(f).filter(function(t){if(n.namespace(t)===c){if(l?t===l||t===g:o.getObject("/"+t)===i){return true}if(p||g&&n.getMetaPath(t)===g){return false}throw new Error("Unexpected annotation target '"+t+"' with namespace of data service in "+e.sServiceUrl)}return false});if(!h.length){throw new Error("No annotation '"+H.slice(1)+"' in "+e.sServiceUrl)}if(h.length===1){u=f[h[0]]}else{u=Object.assign({},f[g],f[l])}Object.keys(u).forEach(function(t){var n=se(t);if(n!==undefined){d[n]=u[t];["CollectionRoot","SearchSupported"].forEach(function(n){if(n in u[t]){throw new Error("Property '"+n+"' is not allowed in annotation '"+t.slice(1)+"' for target '"+h[0]+"' in "+e.sServiceUrl)}})}else if(!p){throw new Error("Unexpected annotation '"+t.slice(1)+"' for target '"+h[0]+"' with namespace of data service in "+e.sServiceUrl)}});return d})};te.prototype.fetchValueListType=function(e){var n=this.getMetaContext(e),i=this;return this.fetchObject(undefined,n).then(function(r){var o,a;if(!r){throw new Error("No metadata for "+e)}o=i.getObject("@",n);if(o[Y]){return t.Fixed}for(a in o){if(ae(a,J)!==undefined||ae(a,Q)!==undefined){return t.Standard}if(ae(a,H)!==undefined){return o[a].SearchSupported===false?t.Fixed:t.Standard}}return t.None})};te.prototype.getAbsoluteServiceUrl=function(e){var t=new L(this.sUrl).absoluteTo(document.baseURI).pathname().toString();return new L(e).absoluteTo(t).filename("").toString()};te.prototype.getAllPathReductions=function(e,t,i,r){var o=t.split("/").length,a,s={},u=e.split("/"),f=this;function l(e,t,a,u){var c,d,p;function h(n){if(!i){l(e,t,p-1,true)}if(u){t=t.slice();e=e.slice()}t.splice(p,n);e.splice(p,n);if(!i){s[e.join("/")]=true}}for(p=a;p>=o;p-=1){c=N.test(e[p+1])?p+2:p+1;if(c<e.length&&t[p].$Partner===e[c]&&!t[c].$isCollection&&t[c].$Partner===e[p].replace(k,"")){h(c-p+1)}else if(Array.isArray(t[p])&&e[p+1]==="$Parameter"){d=f.getObject(n.getMetaPath(e.slice(0,p+1).join("/")+"/@$ui5.overload"));if(d.length===1&&d[0].$Parameter[0].$Name===e[p+2]){h(3)}}else if(r&&t[p].$isCollection){break}}}a=u.map(function(e,t){return t<o||e[0]==="#"||e[0]==="@"||N.test(e)||e==="$Parameter"?{}:f.getObject(n.getMetaPath(u.slice(0,t+1).join("/")))||{}});s[e]=true;if(!(r&&a[u.length-1].$isCollection)){l(u,a,u.length-2)}return i?u.join("/"):Object.keys(s)};te.prototype.getConstraints=function(e,t){var n,i,r,o=K[e.$Type];function a(e,t){if(t!==undefined){i=i||{};i[e]=t}}if(o){r=o.constraints;for(n in r){a(r[n],n[0]==="@"?this.getObject(t+n):e[n])}if(e.$Nullable===false){a("nullable",false)}if(e.$Type==="Edm.DateTimeOffset"){a("V4",true)}}return i};te.prototype.getData=n.createGetMethod("fetchData");te.prototype.getETags=function(){return this.mETags};te.prototype.getLastModified=function(){return this.oLastModified};te.prototype.getMetaContext=function(e){return new d(this,n.getMetaPath(e))};te.prototype.getMetaPath=function(e){return n.getMetaPath(e)};te.prototype.getObject=n.createGetMethod("fetchObject");te.prototype.getOrCreateSharedModel=function(e,t,n){var i,r;e=this.getAbsoluteServiceUrl(e);i=!!n+e;r=_.get(i);if(!r){r=new this.oModel.constructor({autoExpandSelect:n,groupId:t,httpHeaders:this.oModel.getHttpHeaders(),metadataUrlParams:this.sLanguage&&{"sap-language":this.sLanguage},operationMode:y.Server,serviceUrl:e,sharedRequests:true});_.set(i,r)}return r};te.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty")};te.prototype.getProperty=te.prototype.getObject;te.prototype.getReducedPath=function(e,t){return this.getAllPathReductions(e,t,true,true)};te.prototype.getUI5Type=n.createGetMethod("fetchUI5Type",true);te.prototype.getUnitOrCurrencyPath=function(e){var t=this.getObject("@",this.getMetaContext(e)),n=t&&(t["@Org.OData.Measures.V1.Unit"]||t["@Org.OData.Measures.V1.ISOCurrency"]);return n&&n.$Path};te.prototype.getValueListType=n.createGetMethod("fetchValueListType",true);te.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList")};te.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh")};te.prototype.requestCodeList=function(e,t,i){var o=this.fetchEntityContainer().getResult(),a=o[o.$EntityContainer],s=this;if(i&&i.context){if(i.context.getModel()!==this||i.context.getPath()!=="/"){throw new Error("Unsupported context: "+i.context)}}if(t!==undefined&&t!==a){throw new Error("Unsupported raw value: "+t)}return this.requestObject("/@com.sap.vocabularies.CodeList.v1."+e).then(function(e){var t,i,o,a,u,f;if(!e){return null}f=n.setLanguage(e.Url,s.sLanguage);t=s.getAbsoluteServiceUrl(f)+"#"+e.CollectionPath;a=I.get(t);if(a){return a}o=s.getOrCreateSharedModel(f,"$direct");i=o.getMetaModel();u="/"+e.CollectionPath+"/";a=i.requestObject(u).then(function(t){var n=u+"@Org.OData.Core.V1.AlternateKeys",a=i.getObject(n),s,f=m(t.$Key),l=u+f+"@com.sap.vocabularies.Common.v1.",c,d,p=u+f+"@com.sap.vocabularies.CodeList.v1.StandardCode/$Path",h,g;function y(t,n){var i=n.getProperty(f),o={Text:n.getProperty(g),UnitSpecificScale:n.getProperty(d)};if(h){o.StandardCode=n.getProperty(h)}if(o.UnitSpecificScale===null){r.error("Ignoring customizing w/o unit-specific scale for code "+i+" from "+e.CollectionPath,e.Url,B)}else{t[i]=o}return t}function m(e){var t;if(e&&e.length===1){t=e[0]}else{throw new Error("Single key expected: "+u)}return typeof t==="string"?t:t[Object.keys(t)[0]]}if(a){if(a.length!==1){throw new Error("Single alternative expected: "+n)}else if(a[0].Key.length!==1){throw new Error("Single key expected: "+n+"/0/Key")}f=a[0].Key[0].Name.$PropertyPath}d=i.getObject(l+"UnitSpecificScale/$Path");g=i.getObject(l+"Text/$Path");c=[f,d,g];h=i.getObject(p);if(h){c.push(h)}s=o.bindList("/"+e.CollectionPath,null,null,null,{$select:c});return s.requestContexts(0,Infinity).then(function(t){if(!t.length){r.error("Customizing empty for ",o.sServiceUrl+e.CollectionPath,B)}return t.reduce(y,{})}).finally(function(){s.destroy()})});I.set(t,a);return a})};te.prototype.requestCurrencyCodes=function(e,t){return this.requestCodeList("CurrencyCodes",e,t)};te.prototype.requestData=n.createRequestMethod("fetchData");te.prototype.requestObject=n.createRequestMethod("fetchObject");te.prototype.requestUI5Type=n.createRequestMethod("fetchUI5Type");te.prototype.requestUnitsOfMeasure=function(e,t){return this.requestCodeList("UnitsOfMeasure",e,t)};te.prototype.requestValue4Annotation=function(t,i,r){let o;const a=n.getMetaPath(r.getPath());const s=i.indexOf("/",a.length+1);if(s>0){const e=this.getObject(i.slice(0,s)+"/$Partner");if(e){o={$IsBound:true,$Parameter:[{$Name:e}]}}}const u=new R({any:e.value(t,{context:this.createBindingContext(i),overload:o}),bindingContexts:r,models:r.getModel()});const f=u.getBinding("any");let l;if(f){if(f.getBindings){l=Promise.all(f.getBindings().map(function(e){return e.requestValue()}))}else{l=f.requestValue()}}else{l=Promise.resolve()}return l.then(function(){return u.getAny()})};te.prototype.requestValueListInfo=function(e,t,i){var r=n.getMetaPath(e),o=r.slice(0,r.lastIndexOf("/")).replace("/$Parameter",""),a=o.slice(o.lastIndexOf("/")+1),s=this;if(!a.includes(".")){a=undefined}return Promise.all([a||this.requestObject(o+"/@sapui.name"),this.requestObject(r),this.requestObject(r+"@"),this.requestObject(r+Y),this.requestObject(o+"/@$ui5.overload")]).then(function(o){var a=o[2],u=o[3],f={},l=o[1],c={};function d(i,r,o,a){if("CollectionRoot"in i){a=s.getOrCreateSharedModel(i.CollectionRoot,undefined,t);if(c[r]&&c[r].$model===a){f[r]=undefined}}if(f[r]){throw new Error("Annotations '"+H.slice(1)+"' with identical qualifier '"+r+"' for property "+e+" in "+f[r]+" and "+o)}f[r]=o;i=n.clone(i);i.$model=a;delete i.CollectionRoot;delete i.SearchSupported;c[r]=i}if(!l){throw new Error("No metadata for "+e)}return Promise.all(Object.keys(a).filter(function(e){return ae(e,J)!==undefined}).map(function(e){var n=a[e];return Promise.all(n.map(function(e){var n=s.getOrCreateSharedModel(e,undefined,t);return s.fetchValueListMappings(n,o[0],l,o[4]).then(function(e){return{valueListMappingByQualifier:e,$model:n}})})).then(function(e){n.forEach(function(t,n){var i=e[n].valueListMappingByQualifier;Object.keys(i).forEach(function(r){d(i[r],r,t,e[n].$model)})})})})).then(function(){var t=a[X];Object.keys(a).filter(function(e){return se(e)!==undefined}).forEach(function(e){d(a[e],se(e),s.sUrl,s.oModel)});if(n.isEmptyObject(c)){throw new Error("No annotation '"+J.slice(1)+"' for "+e)}return t&&i&&i.getBinding?s.filterValueListRelevantQualifiers(c,t,r+X,i):c}).then(function(t){var n,i;if(u){n=Object.keys(t);if(n.length!==1){throw new Error("Annotation '"+Y.slice(1)+"' but not exactly one '"+H.slice(1)+"' for property "+e)}i=t[n[0]];i.$qualifier=n[0];return{"":i}}return t})})};te.prototype.filterValueListRelevantQualifiers=function(e,t,n,i){return this.requestValue4Annotation(t,n,i).then(function(t){var n={};t.forEach(function(t){if(t in e){n[t]=e[t]}});return n})};te.prototype.requestValueListType=n.createRequestMethod("fetchValueListType");te.prototype.resolve=function(e,t){var n,i;if(!e){return t?t.getPath():undefined}i=e[0];if(i==="/"){return e}if(!t){return undefined}if(i==="."){if(e[1]!=="/"){throw new Error("Unsupported relative path: "+e)}e=e.slice(2)}n=t.getPath();return i==="@"||n.endsWith("/")?n+e:n+"/"+e};te.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax")};te.prototype.toString=function(){return B+": "+this.sUrl};te.prototype.validate=function(e,t){var n,i,r,o,a,s;if(!this.bSupportReferences){return t}for(a in t.$Reference){o=t.$Reference[a];a=new L(a).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in o){le(this,"Unsupported IncludeAnnotations",e)}for(s in o.$Include){r=o.$Include[s];if(r in t){le(this,"A schema cannot span more than one document: "+r+" - is both included and defined",e)}re(this,r,a,e)}}i=t.$LastModified?new Date(t.$LastModified):null;this.mETags[e]=t.$ETag?t.$ETag:i;n=t.$Date?new Date(t.$Date):new Date;i=i||n;if(this.oLastModified<i){this.oLastModified=i}delete t.$Date;delete t.$ETag;delete t.$LastModified;return t};return te});
//# sourceMappingURL=ODataMetaModel.js.map