/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/each","sap/base/util/isEmptyObject","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/SimpleType","sap/ui/model/ValidateException"],function(t,o,e,a,i,r,s){"use strict";var n=r.extend("sap.ui.model.type.Float",{constructor:function(){r.apply(this,arguments);this.sName="Float"}});n.prototype.formatValue=function(t,o){var e=t;if(t==undefined||t==null){return null}if(this.oInputFormat){e=this.oInputFormat.parse(t);if(e==null){throw new a("Cannot format float: "+t+" has the wrong format")}}switch(this.getPrimitiveType(o)){case"string":return this.oOutputFormat.format(e);case"int":return Math.floor(e);case"float":case"any":return e;default:throw new a("Don't know how to format Float to "+o)}};n.prototype.parseValue=function(t,o){var e,a;switch(this.getPrimitiveType(o)){case"string":e=this.oOutputFormat.parse(t);if(isNaN(e)){a=sap.ui.getCore().getLibraryResourceBundle();throw new i(a.getText("Float.Invalid"))}break;case"int":case"float":e=t;break;default:throw new i("Don't know how to parse Float from "+o)}if(this.oInputFormat){e=this.oInputFormat.format(e)}return e};n.prototype.validateValue=function(o){if(this.oConstraints){var e=sap.ui.getCore().getLibraryResourceBundle(),a=[],i=[],r=o,n=this;if(this.oInputFormat){r=this.oInputFormat.parse(o)}t(this.oConstraints,function(t,o){switch(t){case"minimum":if(r<o){a.push("minimum");i.push(e.getText("Float.Minimum",[n.oOutputFormat.format(o)]))}break;case"maximum":if(r>o){a.push("maximum");i.push(e.getText("Float.Maximum",[n.oOutputFormat.format(o)]))}break;default:break}});if(a.length>0){throw new s(this.combineMessages(i),a)}}};n.prototype.setFormatOptions=function(t){this.oFormatOptions=Object.assign(t.style!=="short"&&t.style!=="long"?{preserveDecimals:true}:{},t);this._createFormats()};n.prototype._handleLocalizationChange=function(){this._createFormats()};n.prototype._createFormats=function(){var t=this.oFormatOptions.source;this.oOutputFormat=e.getFloatInstance(this.oFormatOptions);if(t){if(o(t)){t={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."}}this.oInputFormat=e.getFloatInstance(t)}};return n});
//# sourceMappingURL=Float.js.map