/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_omit","sap/m/MessageBox","sap/ui/core/Element","sap/ui/core/EventBus","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/OverlayUtil","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/FieldExtensibility","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/rta/util/BindingsExtractor","sap/ui/rta/util/hasStableId"],function(e,t,n,r,i,a,o,l,s,u,c,g,d,f,v,y,m,p){"use strict";var h={};h.RESOLVED_PROMISE=Promise.resolve(true);h._sFocusableOverlayClass=".sapUiDtOverlaySelectable";h._sRtaStyleClassName="";h.getRtaStyleClassName=function(){return h._sRtaStyleClassName};h.setRtaStyleClassName=function(e){if(e===d.USER){h._sRtaStyleClassName=""}else if(f.getLayerIndex(e)>-1){h._sRtaStyleClassName="sapUiRTABorder"}};h.isServiceUpToDate=function(e){return g.isExtensibilityEnabled(e).then(function(t){if(t){var n=e.getModel();if(n&&n.sServiceUrl){return g.isServiceOutdated(n.sServiceUrl).then(function(e){if(e){g.setServiceValid(n.sServiceUrl);r.getInstance().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{})}})}}return undefined})};h.openRemoveConfirmationDialog=function(e,t){var n=a.getResourceBundleFor("sap.ui.rta");var r;return new Promise(function(e){r=n.getText("CTX_REMOVE_TITLE");var a={messageText:t,titleText:r,icon:"sap-icon://question-mark",removeText:n.getText("BTN_FREP_REMOVE"),cancelText:n.getText("BTN_FREP_CANCEL")};var o=new y;o.setData(a);var l;var s=function(){if(l){l.close();l.destroy();l=null}};var u={removeField(){s();e(true)},closeDialog(){s();e(false)}};if(!l){i.load({name:"sap.ui.rta.view.RemoveElementDialog",controller:u}).then(function(e){l=e;l.setModel(o);l.addStyleClass(h.getRtaStyleClassName());l.open()})}else{l.addStyleClass(h.getRtaStyleClassName());l.open()}})};h.isOverlaySelectable=function(e){return e.isSelectable()&&o.isVisible(e.getDomRef())};h.getPropertyValue=function(e,t){var n=e.getMetadata().getPropertyLikeSetting(t);var r=n._sGetter;return e[r]()};h.getOverlayInstanceForDom=function(e){var t=e.getAttribute("id");if(t){return n.getElementById(t)}return undefined};h.getFocusedOverlay=function(){if(document.activeElement){var e=n.getElementById(document.activeElement.id);if(e&&e.isA("sap.ui.dt.ElementOverlay")){return e}}return undefined};h.getFocusableParentOverlay=function(e){if(!e){return undefined}var t=e.getParentElementOverlay();while(t&&!t.getSelectable()){t=t.getParentElementOverlay()}return t};h.getFirstFocusableDescendantOverlay=function(e){return u.getFirstDescendantByCondition(e,this.isOverlaySelectable)};h.getLastFocusableDescendantOverlay=function(e){return u.getLastDescendantByCondition(e,this.isOverlaySelectable)};h.getNextFocusableSiblingOverlay=function(e){var t=true;var n=u.getNextSiblingOverlay(e);while(n&&!this.isOverlaySelectable(n)){n=u.getNextSiblingOverlay(n)}n||=this._findSiblingOverlay(e,t);return n};h.getPreviousFocusableSiblingOverlay=function(e){var t=false;var n=u.getPreviousSiblingOverlay(e);while(n&&!this.isOverlaySelectable(n)){n=u.getPreviousSiblingOverlay(n)}n||=this._findSiblingOverlay(e,t);return n};h._findSiblingOverlay=function(e,t){var n=e.getParentElementOverlay();if(n){var r=t?u.getNextSiblingOverlay(n):u.getPreviousSiblingOverlay(n);if(!r){return this._findSiblingOverlay(n,t)}var i=t?this.getFirstFocusableDescendantOverlay(r):this.getLastFocusableDescendantOverlay(r);return i}return undefined};h.getIndex=function(e,t,n,r){var i;if(r&&typeof r==="function"){i=r(e,t)}else{var a=e.getMetadata();var o=a.getAggregation(n);var l=o._sGetter;var s=e[l]();if(Array.isArray(s)&&t){i=s.indexOf(t)+1}else{i=0}}return i};h.createFieldLabelId=function(e,t,n){return`${e.getId()}_${t}_${n}`.replace("/","_")};h.getElementBindingPaths=function(e){var t={};if(e.mBindingInfos){for(var n in e.mBindingInfos){var r=e.mBindingInfos[n].parts[0].path?e.mBindingInfos[n].parts[0].path:"";r=r.split("/")[r.split("/").length-1];t[r]={valueProperty:n}}}return t};h.isOriginalFioriToolbarAccessible=function(){var e=h.getFiori2Renderer();return e&&e.getRootControl&&e.getRootControl().getShellHeader()};h.getFiori2Renderer=function(){var e=v.getUshellContainer()||{};return typeof e.getRenderer==="function"?e.getRenderer("fiori2"):undefined};h.extendWith=function(e,t,n){if(!(typeof n==="function")){throw new Error("In order to use extendWith() utility function fnCustomizer should be provided!")}for(var r in t){if(t.hasOwnProperty(r)){if(n(e[r],t[r],r,e,t)){e[r]=t[r]}}}};h.isElementInViewport=function(e){e=e.jquery?e.get(0):e;var t=e.getBoundingClientRect();return t.top>=0&&t.left>=0&&t.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&t.right<=(window.innerWidth||document.documentElement.clientWidth)};h.showMessageBox=function(n,r,i){var o=a.getResourceBundleFor("sap.ui.rta");i||={};var l=o.getText(r,i.error?[i.error.userMessage||i.error.message||i.error]:undefined);var s=i.titleKey&&o.getText(i.titleKey);var u=i.actionKeys&&i.actionKeys.map(function(e){return o.getText(e)});var c=i.emphasizedActionKey?o.getText(i.emphasizedActionKey):undefined;var g=i.showCancel;var d=e(i,["titleKey","error","actionKeys","emphasizedAction","emphasizedActionKey","showCancel"]);d.title=s;d.styleClass=h.getRtaStyleClassName();d.actions||=u;d.emphasizedAction=c||i.emphasizedAction;if(g){d.actions.push(t.Action.CANCEL)}return b(n,l,d)};function b(e,n,r){return new Promise(function(i){r.onClose=i;t[e](n,r)})}h.checkSourceTargetBindingCompatibility=function(e,t,n){n||=e.getModel();var r=m.collectBindingPaths(e,n);var i;var a;if(r.bindingPaths.length===0){return true}i=m.getBindingContextPath(e);a=m.getBindingContextPath(t);if(i===a){return true}return false};h.doIfAllControlsAreAvailable=function(e,t){if(e.every(function(e){return e&&!e._bIsBeingDestroyed})){return t()}return undefined};h.buildHashMapFromArray=function(e,t,n){return e.reduce(function(e,r){e[r[t]]=r[n];return e},{})};h.checkTargetZone=function(e,t,n,r){function i(e,t,n,r){var i=e.getDesignTimeMetadata();var a=i.getAction("move",t);if(!a){return Promise.resolve(false)}return r.hasChangeHandler(a.changeType,n)}return l.checkTargetZone(e,t,r).then(function(r){if(!r){return false}var a=t.getElement();var o=e.getParent();var l=t.getRelevantContainer();if(!a||!o){return false}var u=o.getElement();var c=e.getDesignTimeMetadata();var g=s.getRelevantContainerForPropagation(c.getData(),a);g||=u;if(!l||!g||!p(o)||l!==g){return false}if(t.getParent().getElement()!==u&&!h.checkSourceTargetBindingCompatibility(a,u)){return false}return i(e,a,g,n)})};h.checkDraftOverwrite=function(e,n){var r=e.getProperty("/backendDraft");var i=e.getProperty("/displayedVersion")===c.Number.Draft;if(i||!r||n){return Promise.resolve(false)}return h.showMessageBox("warning","MSG_DRAFT_DISCARD_AND_CREATE_NEW_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_DIALOG",actions:[t.Action.OK,t.Action.CANCEL],emphasizedAction:t.Action.OK}).then(function(e){if(e!==t.Action.OK){throw"cancel"}return true})};return h},true);
//# sourceMappingURL=Utils.js.map