/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/mvc/Controller","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/base/i18n/ResourceBundle","sap/m/MessageToast","sap/m/MenuItem"],function(e,t,r,n,a,i,o,s,u,p,A,g,l,_){"use strict";var c;var T;var d;var h;var f;var I;return e.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit(){c=this.getOwnerComponent().getIdRunningApp();T=this.getOwnerComponent().getIsOverviewForKeyUser();d=this.getOwnerComponent().getLayer();var e=r.getUshellContainer();if(!I){this._createResourceBundle()}A.show();return Promise.resolve().then(function(){if(e){return e.getServiceAsync("CrossApplicationNavigation").then(function(e){h=e})}return undefined}).then(i.getAppVariantOverview.bind(i,c,T)).then(function(e){A.hide();if(e.length){return this._arrangeOverviewDataAndBindToModel(e).then(function(e){return this._highlightNewCreatedAppVariant(e)}.bind(this))}a.closeOverviewDialog();return this._showMessageWhenNoAppVariantsExist()}.bind(this)).catch(function(e){a.closeOverviewDialog();var t=a.buildErrorInfo("MSG_MANAGE_APPS_FAILED",e);t.overviewDialog=true;A.hide();return a.showRelevantDialog(t,false)})},_createResourceBundle(){f=`${sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")}webapp`;I=g.create({url:`${f}/i18n/i18n.properties`})},_showMessageWhenNoAppVariantsExist(){return s.showMessageBox(o.Icon.INFORMATION,"MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER",{titleKey:"TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER"})},_highlightNewCreatedAppVariant(e){var t=this.byId("Table1");t.focus();e.forEach(function(e,r){if(e.currentStatus===I.getText("MAA_NEW_APP_VARIANT")||e.currentStatus===I.getText("MAA_OPERATION_IN_PROGRESS")){if(t.getItems().length>=r){t.getItems()[r].focus()}}});return Promise.resolve()},_arrangeOverviewDataAndBindToModel(e){var t=e.filter(function(e){return e.appId===c});var r=t[0];if(r&&r.appVarStatus!=="R"){r.currentStatus=I.getText("MAA_CURRENTLY_ADAPTING")}e=e.filter(function(e){return e.appId!==c});e.unshift(r);var a=e.filter(function(e){return e.isOriginal});var i=a[0];e=e.filter(function(e){return!e.isOriginal});e.unshift(i);var o={appVariants:e};var s=n.createModel(o);this.getView().setModel(s);return Promise.resolve(e)},formatRowHighlight(e){if(e===I.getText("MAA_CURRENTLY_ADAPTING")){return"Success"}else if(e===I.getText("MAA_NEW_APP_VARIANT")){return"Information"}else if(e===I.getText("MAA_OPERATION_IN_PROGRESS")){return"Warning"}return"None"},formatDelButtonTooltip(e,t){if(!I){this._createResourceBundle()}if(!e&&!t){return I.getText("TOOLTIP_DELETE_APP_VAR")}return undefined},formatAdaptUIButtonTooltip(e,t){if(!I){this._createResourceBundle()}if(!e){switch(t){case"R":return I.getText("TOOLTIP_ADAPTUI_STATUS_RUNNING");case"U":return I.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case"E":return I.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case"P":return I.getText("TOOLTIP_ADAPTUI_STATUS_PUBLISHED");case undefined:return I.getText("TOOLTIP_ADAPTUI_ON_PREMISE");default:}}},formatAdaptUIButtonVisibility(e,t){return e&&t},getModelProperty(e,t){return this.getView().getModel().getProperty(e,t)},onMenuAction(e){var t=e.getParameter("item");var r="";while(t instanceof _){r=`${t.getText()} > ${r}`;t=t.getParent()}r=r.substr(0,r.lastIndexOf(" > "));if(!I){this._createResourceBundle()}if(r===I.getText("MAA_DIALOG_ADAPT_UI")){return this.handleUiAdaptation(e)}else if(r===I.getText("MAA_DIALOG_COPY_ID")){return this.copyId(e)}else if(r===I.getText("MAA_DIALOG_DELETE_APPVAR")){return this.deleteAppVariant(e)}return undefined},handleUiAdaptation(e){var r=this.getModelProperty("semanticObject",e.getSource().getBindingContext());var n=this.getModelProperty("action",e.getSource().getBindingContext());var i=this.getModelProperty("params",e.getSource().getBindingContext());var o;if(r&&n&&i){o={target:{semanticObject:r,action:n},params:i,writeHistory:false};p.enableRestart(t.CUSTOMER);if(h){h.toExternal(o)}a.closeOverviewDialog();return true}return false},copyId(e){var t=this.getModelProperty("appId",e.getSource().getBindingContext());a.copyId(t);l.show(I.getText("MAA_COPY_ID_SUCCESS"))},deleteAppVariant(e){var t={};if(!I){this._createResourceBundle()}var r=I.getText("MSG_APP_VARIANT_DELETE_CONFIRMATION");t.text=r;t.deleteAppVariant=true;var n=this.getModelProperty("appId",e.getSource().getBindingContext());var i=this.getModelProperty("currentStatus",e.getSource().getBindingContext());var o=i===I.getText("MAA_CURRENTLY_ADAPTING");return a.showRelevantDialog(t).then(function(){return u.onDeleteFromOverviewDialog(n,o,d)}).catch(function(){return true})}})});
//# sourceMappingURL=ManageApps.controller.js.map