/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_intersection","sap/m/InstanceManager","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/events/KeyCodes","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(e,t,i,a,s,r,o,n){"use strict";var l=o.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"},isActive:{type:"boolean",defaultValue:true}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});function c(e){e.preventDefault();e.stopPropagation()}function u(t,i){var a=i.slice();t.forEach(function(t){a=e(a,t.getEditableByPlugins())});return a.length>0}function v(e){return e.every(function(t){return t.getRelevantContainer()===e[0].getRelevantContainer()})}function h(e){return e.every(function(t){return t.getParentElementOverlay()===e[0].getParentElementOverlay()})}function g(e){return e.every(function(t){return t.getElement().getMetadata().getName()===e[0].getElement().getMetadata().getName()})}l.prototype.init=function(...e){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);o.prototype.init.apply(this,e)};l.prototype._checkDeveloperMode=function(e,t){if(t){var i=this.getCommandFactory().getFlexSettings().developerMode;if(i&&this.hasStableId(e)){e.setEditable(true);e.setSelectable(true);this.fireElementEditableChange({editable:true});return true}}return false};l.prototype.setIsActive=function(e){this.setProperty("isActive",e);if(e===false){this._deselectOverlays()}};l.prototype.registerElementOverlay=function(e){var t=e.getDesignTimeMetadata();if(!t.markedAsNotAdaptable()&&!this._checkDeveloperMode(e,t)){e.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(e)}e.attachBrowserEvent("click",this._selectOverlay,this);e.attachBrowserEvent("contextmenu",this._selectOverlay,this);e.attachBrowserEvent("keydown",this._onKeyDown,this);e.attachBrowserEvent("mousedown",this._onMouseDown,this);e.attachBrowserEvent("mouseover",this._onMouseover,this);e.attachBrowserEvent("mouseleave",this._onMouseleave,this)};l.prototype._onEditableChange=function(e){var t=e.getSource();this._adaptSelectable(t)};l.prototype._adaptSelectable=function(e){var t=e.getEditable();if(e.getSelectable()!==t){e.setSelectable(t);if(!t){this._removePreviousHover()}this.fireElementEditableChange({editable:t})}};l.prototype.deregisterElementOverlay=function(e){e.detachBrowserEvent("click",this._selectOverlay,this);e.detachBrowserEvent("contextmenu",this._selectOverlay,this);e.detachBrowserEvent("keydown",this._onKeyDown,this);e.detachBrowserEvent("mousedown",this._onMouseDown,this);e.detachBrowserEvent("mouseover",this._onMouseover,this);e.detachBrowserEvent("mouseleave",this._onMouseleave,this);e.detachEditableChange(this._onEditableChange,this)};l.prototype._setFocusOnOverlay=function(e,t){if(e&&e.getSelectable()){e.focus();t.stopPropagation()}};l.prototype._onKeyDown=function(e){if(!this.getIsActive()){return}var t=n.getFocusedOverlay();if(e.keyCode===r.ENTER){this._selectOverlay(e)}else if(e.keyCode===r.ARROW_UP&&e.shiftKey===false&&e.altKey===false){if(t){var i=n.getFocusableParentOverlay(t);this._setFocusOnOverlay(i,e);e.preventDefault()}}else if(e.keyCode===r.ARROW_DOWN&&e.shiftKey===false&&e.altKey===false){if(t){var a=n.getFirstFocusableDescendantOverlay(t);this._setFocusOnOverlay(a,e);e.preventDefault()}}else if(e.keyCode===r.ARROW_LEFT&&e.shiftKey===false&&e.altKey===false){if(t){var s=n.getPreviousFocusableSiblingOverlay(t);this._setFocusOnOverlay(s,e);e.preventDefault()}}else if(e.keyCode===r.ARROW_RIGHT&&e.shiftKey===false&&e.altKey===false){if(t){var o=n.getNextFocusableSiblingOverlay(t);this._setFocusOnOverlay(o,e);e.preventDefault()}}else if(e.keyCode===r.ESCAPE){if(t){this._deselectOverlays()}}};l.prototype._deselectOverlays=function(){this.getDesignTime().getSelectionManager().reset()};l.prototype._selectOverlay=function(e){var t=a.getOverlay(e.currentTarget.id);if(!this.getIsActive()){if(t.isRoot()){c(e)}return}var i=e.metaKey||e.ctrlKey||e.shiftKey;var s=e.type==="contextmenu";if(t&&t.getSelectable()){if(t.isSelected()){if(!s){this.getDesignTime().getSelectionManager().remove(t)}}else if(i){this.getDesignTime().getSelectionManager().add(t)}else{this.getDesignTime().getSelectionManager().set(t)}c(e)}else if(t&&t.isRoot()){c(e)}};l.prototype._onMouseDown=function(e){if(!this.getIsActive()){var i=a.getOverlay(e.currentTarget.id);if(i.isRoot()){c(e)}t.getOpenPopovers().forEach(function(e){if(e._bOpenedByChangeIndicator){e.close()}});return}};l.prototype._onMouseover=function(e){var t=a.getOverlay(e.currentTarget.id);if(!this.getIsActive()||this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){if(t.isRoot()){c(e)}return}if(t.isSelectable()){s.setFirstParentMovable(t,false);if(t!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=t;t.addStyleClass("sapUiRtaOverlayHover")}c(e)}};l.prototype._onMouseleave=function(e){var t=a.getOverlay(e.currentTarget.id);if(!this.getIsActive()){if(t.isRoot()){c(e)}return}if(t.isSelectable()){s.setFirstParentMovable(t,true);this._removePreviousHover();c(e)}};l.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover")}delete this._oHoverTarget};l.prototype.setDesignTime=function(...e){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator)}o.prototype.setDesignTime.apply(this,e);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator)}};l.prototype._multiSelectionValidator=function(e){return e.length===1||u(e,this.getMultiSelectionRequiredPlugins())&&v(e)&&(h(e)||g(e))};return l});
//# sourceMappingURL=Selection.js.map