/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/format/DateFormat","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/core/StaticArea","sap/ui/events/KeyCodes","sap/ui/fl/util/resolveBinding","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/commands/getCommandVisualization","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(e,t,i,o,a,n,s,r,l,p,g,h,c){"use strict";var d=t.extend("sap.ui.rta.util.changeVisualization.ChangeIndicator",{metadata:{library:"sap.ui.rta",properties:{changes:{type:"array",defaultValue:[]},posX:{type:"int"},posY:{type:"int"},overlayId:{type:"string"},selectorId:{type:"string"}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},events:{selectChange:{parameters:{changeId:{type:"string"}}},keyPress:{parameters:{originalEvent:{type:"object"}}},detailPopoverOpened:{}}},renderer:{apiVersion:2,render(e,t){e.openStart("div",t);e.class("sapUiRtaChangeIndicator");e.class("sapUiRtaChangeIndicatorChange");var i=t.getTooltip_AsString();if(i){e.attr("title",i)}if(t.getChanges().length>4){e.class("sapUiRtaChangeIndicatorColorDark")}else if(t.getChanges().length>1){e.class("sapUiRtaChangeIndicatorColorMedium")}else{e.class("sapUiRtaChangeIndicatorColorLight")}e.openEnd();if(i){e.openStart("span",`${t.getId()}-tooltip`);e.class("sapUiInvisibleText");e.openEnd();e.text(i);e.close("span")}e.close("div")}},constructor:function(...e){this._oDetailModel=new p;this._oDetailModel.setDefaultBindingMode("OneWay");this._fnHoverTrue=this._setHoverStyleClasses.bind(this,true);this._fnHoverFalse=this._setHoverStyleClasses.bind(this,false);t.prototype.constructor.apply(this,e);this._bEventAttachedToElement=false}});function u(e,t){e[t]("click",this._onSelect,this);e[t]("tap",this._onSelect,this);e[t]("keydown",this._onKeyDown,this);e[t]("mouseover",this._fnHoverTrue);e[t]("focusin",this._fnHoverTrue)}function v(e,t){e[t]("click",this._onSelect,this);e[t]("tap",this._onSelect,this);e[t]("keydown",this._onKeyDown,this)}function f(e){var t=e.getDomRef();var o=i.getElementById(e.getOverlayId()).getDomRef().offsetHeight;var a=t.offsetHeight;if(o<a*5){e.addStyleClass("sapUiRtaChangeIndicatorVerticallyCentered")}else{e.removeStyleClass("sapUiRtaChangeIndicatorVerticallyCentered")}}function y(e,t,o){var a=i.getElementById(e.affectedElementId);var n=Object.keys(e.descriptionPayload||{}).reduce(function(t,i){var o=e.descriptionPayload[i];var n=l.isBinding(o);var s=n?r(o,a):o;t[i]=s;return t},{});var s={appComponent:l.getAppComponentForControl(a)};var p=i.getElementById(o);var h=p.getDesignTimeMetadata().getLabel(a);var d=g(e);var u=d&&d.getDescription(n,h,s)||{};var v=e.commandName;var f;var y;if(v==="settings"&&n.description){u.descriptionText=n.description;u.descriptionTooltip=n.descriptionTooltip}else if(e.changeCategory==="other"){v="other"}if(u.descriptionText){f=u.descriptionText;y=u.descriptionTooltip||""}else{var I=c.shortenString(h);var _=`TXT_CHANGEVISUALIZATION_CHANGE_${v.toUpperCase()}`;f=t.getText(_,[I]);y=t.getText(_,[h])}y=f.length<y.length?y:null;var C=u&&u.buttonText;var T=t.getText(`TXT_CHANGEVISUALIZATION_OVERVIEW_${e.changeCategory.toUpperCase()}`);return{description:f,tooltip:y,buttonText:C,iconTooltip:T}}function I(t,i){var o=t.change.getCreation();var a=new Date(o);var n=i.getText("TXT_CHANGEVISUALIZATION_CREATED_IN_SESSION_DATE");return{fullDate:o?e.getDateTimeInstance().format(a):n,relativeDate:o?e.getDateTimeInstance({relative:"true"}).format(a):n}}function _(e,t){var i=a.getResourceBundleFor("sap.ui.rta");var o=y(t,i,e);var n=I(t,i);return{id:t.id,change:t,description:o.description,descriptionTooltip:o.tooltip,fullDate:n.fullDate,relativeDate:n.relativeDate,detailButtonText:o.buttonText,icon:h.getIconForCategory(t.changeCategory),iconTooltip:o.iconTooltip}}d.prototype.init=function(){this._iOldTabIndex=0;v.call(this,this,"attachBrowserEvent")};d.prototype.setVisible=function(...e){const[o]=e;t.prototype.setVisible.apply(this,e);var a=i.getElementById(this.getOverlayId());if(a){if(o&&!this._bEventAttachedToElement){u.call(this,a,"attachBrowserEvent");this._bEventAttachedToElement=true}if(!o){u.call(this,a,"detachBrowserEvent");this._bEventAttachedToElement=false;if(this.getAggregation("_popover")){this.getAggregation("_popover").destroy()}}}return this};d.prototype.focus=function(...e){if(this.getDomRef()){t.prototype.focus.apply(this,e);this._bScheduledForFocus=false;return}this._bScheduledForFocus=true};d.prototype.setOverlayId=function(e){var t=this.getDomRef();if(t){t.parentNode.removeChild(t)}this.placeAt(n.getDomRef());this.setProperty("overlayId",e);return this};d.prototype.onAfterRendering=function(){var e=i.getElementById(this.getOverlayId());if(e){e.getDomRef().appendChild(this.getDomRef());f(this)}this.getDomRef().tabIndex=this._iOldTabIndex;if(this._bScheduledForFocus){this.focus();this._setHoverStyleClasses(true)}};d.prototype.exit=function(){var e=this.getDomRef();var t=i.getElementById(this.getOverlayId());if(e){e.parentNode.removeChild(e)}if(t){if(this.getAggregation("_popover")){this.getAggregation("_popover").destroy()}u.call(this,t,"detachBrowserEvent")}v.call(this,this,"detachBrowserEvent")};d.prototype.setChanges=function(e){var t=a.getResourceBundleFor("sap.ui.rta");this.setProperty("changes",e);this._oDetailModel.setData((e||[]).reverse().map(_.bind(this,this.getOverlayId())));if(e&&e.length===1){this.setTooltip(t.getText("TXT_CHANGEVISUALIZATION_INDICATOR_TOOLTIP_SING"))}else if(e){this.setTooltip(t.getText("TXT_CHANGEVISUALIZATION_INDICATOR_TOOLTIP_PLUR",[e.length]))}};d.prototype._onSelect=function(e){this.focus();e.stopPropagation();this._toggleDetailPopover()};d.prototype._onKeyDown=function(e){if(e.keyCode===s.ENTER){this._onSelect(e)}this.fireKeyPress({originalEvent:e})};d.prototype.onDetailPopoverOpened=function(e){e.preventDefault();this._setHoverStyleClasses(true)};d.prototype.onIndicatorBrowserInteraction=function(e,t){t.stopPropagation();t.preventDefault();this._setHoverStyleClasses(e)};d.prototype._setHoverStyleClasses=function(e){var t=i.getElementById(this.getOverlayId());if(t.getMetadata().getName()!=="sap.ui.dt.ElementOverlay"){return}var o=e?"addStyleClass":"removeStyleClass";t[o]("sapUiRtaChangeIndicatorHovered");this[o]("sapUiRtaHover")};d.prototype._toggleDetailPopover=function(){if(!this.getAggregation("_popover")){this._iOldTabIndex=this.getDomRef().getAttribute("tabindex");o.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorPopover",id:`${this.sId}Info`,controller:this}).then(function(e){e._bOpenedByChangeIndicator=true;this.setAggregation("_popover",e);e.setModel(this._oDetailModel,"details");e.openBy(this);this.fireDetailPopoverOpened()}.bind(this))}else{if(this.getAggregation("_popover").isOpen()){return this.getAggregation("_popover").close()}this.getAggregation("_popover").openBy(this);this.fireDetailPopoverOpened()}return undefined};d.prototype._showDependentElements=function(e){this.getAggregation("_popover").close();var t=this.getChanges().length>1?e.getSource().getBindingContext("details").getObject().id:this.getChanges()[0].id;this.fireSelectChange({changeId:t})};return d});
//# sourceMappingURL=ChangeIndicator.js.map