//@ui5-bundle sap/ui/support/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/Bootstrap", ["sap/base/Log"],function(t){"use strict";t.setLogEntriesLimit(Infinity);var e={initSupportRules:function(e,i){sap.ui.require(["sap/ui/support/supportRules/Main"],function(n){if(e[0].toLowerCase()==="true"||e[0].toLowerCase()==="silent"){var o=i&&i.onReady&&typeof i.onReady==="function";if(!n._pluginStarted){if(o){n.attachEvent("ready",i.onReady)}n.startPlugin(e)}else{if(o){i.onReady()}}t.logSupportInfo(true)}})}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/RuleAnalyzer", ["sap/ui/support/Bootstrap","sap/ui/support/supportRules/Main","sap/ui/support/supportRules/RuleSetLoader"],function(t,n,e){"use strict";var r={analyze:function(r,s,u){var i=new Promise(function(n){t.initSupportRules(["true","silent"],{onReady:function(){n()}})});return i.then(function(){if(e._bRulesCreated){return n.analyze(r,s,u)}return e._oMainPromise.then(function(){return n.analyze(r,s,u)})})},getLastAnalysisHistory:function(){return n.getLastAnalysisHistory()},getAnalysisHistory:function(){return n.getAnalysisHistory()},getFormattedAnalysisHistory:function(t){return n.getFormattedAnalysisHistory(t)},addRule:function(t){return n.addRule(t)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/library", ["sap/ui/core/library"],function(e){"use strict";var i=sap.ui.getCore().initLibrary({name:"sap.ui.support",dependencies:["sap.ui.core"],types:["sap.ui.support.Severity"],interfaces:[],controls:[],elements:[],noLibraryCSS:true,version:"1.120.10",extensions:{"sap.ui.support":{internalRules:true}}});i.Severity={Medium:"Medium",High:"High",Low:"Low"};i.Audiences={Control:"Control",Internal:"Internal",Application:"Application"};i.Categories={Accessibility:"Accessibility",Performance:"Performance",Memory:"Memory",Bindings:"Bindings",Consistency:"Consistency",FioriGuidelines:"FioriGuidelines",Functionality:"Functionality",Usability:"Usability",DataModel:"DataModel",Modularization:"Modularization",Usage:"Usage",Other:"Other"};i.HistoryFormats={Abap:"Abap",String:"String"};i.SystemPresets={Accessibility:{id:"Accessibility",title:"Accessibility",description:"Accessibility related rules",selections:[{ruleId:"dialogAriaLabelledBy",libName:"sap.m"},{ruleId:"onlyIconButtonNeedsTooltip",libName:"sap.m"},{ruleId:"inputNeedsLabel",libName:"sap.m"},{ruleId:"titleLevelProperty",libName:"sap.m"},{ruleId:"formTitleOrAriaLabel",libName:"sap.ui.layout"},{ruleId:"formTitleInToolbarAria",libName:"sap.ui.layout"},{ruleId:"formMissingLabel",libName:"sap.ui.layout"},{ruleId:"gridTableAccessibleLabel",libName:"sap.ui.table"},{ruleId:"gridTableColumnTemplateIcon",libName:"sap.ui.table"},{ruleId:"smartFormLabelOrAriaLabel",libName:"sap.ui.comp"},{ruleId:"icontabbarlabels",libName:"sap.m"},{ruleId:"labeltooltip",libName:"sap.m"},{ruleId:"labelfor",libName:"sap.m"},{ruleId:"labelInDisplayMode",libName:"sap.m"},{ruleId:"texttooltip",libName:"sap.m"},{ruleId:"rbText",libName:"sap.m"}]},Deprecations:{id:"Deprecations",title:"Deprecations",description:"Usage of deprecated controls, properties, aggregations and others",selections:[{ruleId:"deprecatedProperty",libName:"sap.ui.core"},{ruleId:"deprecatedElement",libName:"sap.ui.core"},{ruleId:"deprecatedAggregation",libName:"sap.ui.core"},{ruleId:"deprecatedAssociation",libName:"sap.ui.core"},{ruleId:"deprecatedEvent",libName:"sap.ui.core"},{ruleId:"globalApiUsage",libName:"sap.ui.core"},{ruleId:"jquerySapUsage",libName:"sap.ui.core"},{ruleId:"syncFactoryLoading",libName:"sap.ui.core"},{ruleId:"deprecatedApiUsage",libName:"sap.ui.core"},{ruleId:"jQueryThreeDeprecation",libName:"sap.ui.core"},{ruleId:"deprecatedJSViewUsage",libName:"sap.ui.core"},{ruleId:"smartTableDeprecatedModel",libName:"sap.ui.comp"}]}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/Analyzer", ["sap/base/Log","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/Constants","sap/ui/core/date/UI5Date"],function(e,t,i,s){"use strict";var n=function(){this.dStartedAt=null;this.dFinishedAt=null;this.iElapsedTime=0;this._iAllowedTimeout=1e4;this.reset()};n.prototype.reset=function(){this._iTotalProgress=0;this._iCompletedRules=0;this._iTotalRules=0;this._bRunning=false;this._aRulePromices=[]};n.prototype.running=function(){return this._bRunning};n.prototype.start=function(e,i,n){var o,r=this;this.dStartedAt=s.getInstance();this._iTotalRules=e.length;this._bRunning=true;e.forEach(function(e){r._aRulePromices.push(new Promise(function(s){try{o=t.createIssueManagerFacade(e);if(e.async){r._runAsyncRule(o,i,n,e,s)}else{e.check(o,i,n);s();r._updateProgress()}}catch(t){r._handleException(t,e.id,s)}}))});return Promise.all(this._aRulePromices).then(function(){r.reset();r.dFinishedAt=s.getInstance();r.iElapsedTime=r.dFinishedAt.getTime()-r.dStartedAt.getTime()})};n.prototype._handleException=function(t,s,n){var o=t.message||t;var r="["+i.SUPPORT_ASSISTANT_NAME+'] Error while execution rule "'+s+'": '+o;e.error(r);n();this._updateProgress()};n.prototype._updateProgress=function(){this._iCompletedRules++;this._iTotalProgress=Math.ceil(this._iCompletedRules/this._iTotalRules*100);if(this.onNotifyProgress){this.onNotifyProgress(this._iTotalProgress)}};n.prototype._runAsyncRule=function(e,t,i,s,n){var o=this,r=false;var u=setTimeout(function(){r=true;o._handleException("Check function timed out",s.id,n)},this._iAllowedTimeout);new Promise(function(n){s.check(e,t,i,n)}).then(function(){if(!r){clearTimeout(u);n();o._updateProgress()}}).catch(function(e){if(!r){clearTimeout(u);o._handleException(e,s.id,n)}})};n.prototype.getElapsedTimeString=function(){if(!this.iElapsedTime){return""}var e=s.getInstance(null);e.setHours(0,0,0,0);e.setMilliseconds(this.iElapsedTime);var t=[(e.getHours()<10?"0":"")+e.getHours(),(e.getMinutes()<10?"0":"")+e.getMinutes(),(e.getSeconds()<10?"0":"")+e.getSeconds(),e.getMilliseconds()];return t.join(":")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/CommunicationBus", ["sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBConfig"],function(u,i){"use strict";var r;var s=u.extend("sap.ui.support.supportRules.CommunicationBus",{constructor:function(){if(!r){var s=new i({modulePath:"sap/ui/support",receivingWindow:"supportTool",uriParams:{origin:"sap-ui-xx-support-origin",frameId:"sap-ui-xx-frame-identifier"}});u.call(this,s)}else{return r}}});r=new s;return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/Constants", [],function(){"use strict";return{TEMP_RULESETS_NAME:"temporary",SUPPORT_ASSISTANT_NAME:"Support Assistant",LOCAL_STORAGE_TEMP_RULES_KEY:"support-assistant-temprules",LOCAL_STORAGE_SELECTED_RULES_KEY:"support-assistant-selected-rules",LOCAL_STORAGE_SELECTED_CONTEXT_KEY:"support-assistant-settings-selected-context",LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY:"support-assistant-settings-selected-context-components",LOCAL_STORAGE_SELECTED_VISIBLE_COLUMN_KEY:"support-assistant-visible-column-setting",LOCAL_STORAGE_SELECTION_PRESETS_KEY:"support-assistant-selection-presets",LOCAL_STORAGE_CUSTOM_PRESETS_KEY:"support-assistant-custom-presets",LOCAL_STORAGE_TEMP_RULES_DISABLED_WARNED:"support-assistant-temp-rules-disabled-warned",COOKIE_NAME:"persistence-cookie",SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR:"#bb0000",SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR:"#e78c07",SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR:"#5e696e",SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:"Low",SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:"Medium",SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:"High",SUPPORT_ASSISTANT_EXTENSION:"sap.ui.support",MAX_VISIBLE_ISSUES_FOR_RULE:5,RULESET_LOADING:"Loading ruleset files:",FILTER_VALUE_ALL:"All",RULE_SELECTION_EXPORT_FILE_NAME:"sa-rule-preset",HIGHLIGHTER_ID:"ui5-highlighter"}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/CoreFacade", ["sap/ui/core/Component","sap/ui/core/UIArea"],function(t,e){"use strict";var n=null;function r(r){n=r;return{getMetadata:function(){return n.getMetadata()},getUIAreas:function(){return e.registry.all()},getComponents:function(){return t.registry.all()},getModels:function(){return n.oModels}}}return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ExecutionScope", ["sap/base/Log","sap/ui/core/Component","sap/ui/core/Element","sap/ui/core/UIArea"],function(e,t,n,r){"use strict";var a=null,o=[];var i={setScope:function(){o=n.registry.filter(function(){return true})}};var u={setScope:function(){var e=n.registry.get(a.parentId);o=e.findAggregatedObjects(true)}};var f={setScope:function(){var e={};a.components.forEach(function(n){var r=t.registry.get(n),a=r.findAggregatedObjects(true);a.forEach(function(t){e[t.getId()]=t})});for(var n in e){if(e.hasOwnProperty(n)){o.push(e[n])}}}};var s={global:i,subtree:u,components:f};function c(e){var t=e.getParent().getMetadata().getAggregation(e.sParentAggregationName);return!!t}function g(e){var t;if(e.isA("sap.ui.core.Component")){t=e.getRootControl()}else if(e.getContent()){t=e.getContent()[0]}if(t){return[t].concat(t.findAggregatedObjects(true,c))}return[]}function p(e){var t=e.sParentAggregationName,n=e.getParent();if(n&&t){var r=n.getBindingInfo(t);if(r&&e instanceof r.template.getMetadata().getClass()){return true}else{return p(n)}}return false}function l(e){var t=e.sParentAggregationName,n=e.getParent();if(n&&t){var r=n.getBindingInfo(t);if(r&&e instanceof r.template.getMetadata().getClass()){return n.getId()}else{return l(n)}}return null}function v(e,t){var n=[];for(var r=0,a=e.length;r<a;r++){for(var o=0,i=t.length;o<i;o++){if(e[r]===t[o]){n.push(e[r])}}}return n}function d(n,i){o=[];a=i;s[a.type].setScope();return{getElements:function(e){var t=this;var n={type:null,public:false,cloned:true};if(e&&Object.keys(e).length){var r=o;var a={};Object.keys(n).forEach(function(n){if(e.hasOwnProperty(n)){switch(n){case"type":var o=t.getElementsByClassName(e["type"]);r=v(r,o);break;case"public":if(e["public"]===true){var i=t.getPublicElements();r=v(r,i)}break;case"cloned":if(!e["cloned"]){r=r.filter(function(e){var t=p(e);if(t){var n=l(e);if(!a.hasOwnProperty(n)){a[n]=e}}return t===false})}break}}});Object.keys(a).forEach(function(e){r.push(a[e])});return r}return o},getPublicElements:function(){var e=[];var n=r.registry.all();t.registry.forEach(function(t){e=e.concat(g(t))});for(var a in n){e=e.concat(g(n[a]))}return e},getElementsByClassName:function(e){if(typeof e==="string"){return o.filter(function(t){return t.getMetadata().getName()===e})}if(typeof e==="function"){return o.filter(function(t){return t instanceof e})}},getLoggedObjects:function(t){var n=e.getLogEntries(),r=[],a;n.forEach(function(e){if(!e.supportInfo){return}if(!a){a=o.map(function(e){return e.getId()})}var n=!!e.supportInfo.elementId,i=e.supportInfo.type===t||t===undefined,u=!n||a.indexOf(e.supportInfo.elementId)>-1;if(typeof t==="function"&&t(e)&&u){r.push(e);return}if(i&&u){r.push(e)}});return r},getType:function(){return a.type},_getContext:function(){return a}}}d.possibleScopes=Object.getOwnPropertyNames(s);return d},true);
/**
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/support/supportRules/History", ["sap/ui/support/library","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/RuleSetLoader","sap/ui/support/supportRules/report/StringHistoryFormatter","sap/ui/support/supportRules/report/AbapHistoryFormatter","sap/ui/core/date/UI5Date"],function(e,t,s,r,a,o){"use strict";var i=[];var u=function(e,t){var s=null;if(e.rulePreset){s={id:e.rulePreset.id,title:e.rulePreset.title,description:e.rulePreset.description,dateExported:e.rulePreset.dateExported}}return{loadedLibraries:{},analysisInfo:{duration:e.analysisDuration,date:e.date,executionScope:e.scope.executionScope,rulePreset:s},analysisMetadata:e.analysisMetadata,applicationInfo:e.application,technicalInfo:e.technical,totalIssuesCount:0,issues:e.onlyIssues}};var n=function(e,t,s){e.loadedLibraries[t]={};var r=e.loadedLibraries[t];r["rules"]={};r["issueCount"]=s.rules[t].issueCount;r["allRulesSelected"]=true;e.totalIssuesCount+=s.rules[t].issueCount};var l=function(e,t,s,r){var a=r.rules[t][s];e.loadedLibraries[t]["rules"][s]={id:s,library:t,name:a.title,selected:a.selected,issuesCount:a.issueCount,issues:c(r,t,s),resolution:a.resolution,minVersion:a.minversion,categories:a.categories,audiences:a.audiences,description:a.description};if(a.selected===false){e.loadedLibraries[t]["allRulesSelected"]=false}};var c=function(e,t,s){var r=[];if(e.issues[t]&&e.issues[t][s]){e.issues[t][s].forEach(function(e){var t={context:e.context,details:e.details,name:e.name,severity:e.severity};r.push(t)})}return r};var p={getRuns:function(){return i.slice()},saveAnalysis:function(e){return e._oDataCollector.getTechInfoJSON().then(function(r){var a=t.groupIssues(t.getIssuesModel()),u=t.getIssues(),n=s.getRuleSets(),l=e._oSelectedRulesIds,c=e._oSelectedRulePreset;i.push({date:o.getInstance().toUTCString(),issues:a,onlyIssues:u,application:e._oDataCollector.getAppInfo(),technical:r,rules:t.getRulesViewModel(n,l,a),rulePreset:c,scope:{executionScope:{type:e._oExecutionScope.getType(),selectors:e._oExecutionScope._getContext().parentId||e._oExecutionScope._getContext().components}},analysisDuration:e._oAnalyzer.getElapsedTimeString(),analysisMetadata:e._oAnalysisMetadata||null})})},clearHistory:function(){i=[]},getHistory:function(){var e=[];i.forEach(function(t){var s=u(t);for(var r in t.rules){n(s,r,t);for(var a in t.rules[r]){l(s,r,a,t)}}e.push(s)});return e},getFormattedHistory:function(t){var s,o=this.getHistory();switch(t){case e.HistoryFormats.Abap:s=a.format(o);break;default:s=r.format(o)}return s}};return p},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/IssueManager", ["sap/base/util/deepExtend","sap/ui/base/Object","sap/ui/support/library","sap/ui/support/supportRules/Constants"],function(e,t,i,r){"use strict";var s=[];var u=function(e){var t=sap.ui.getCore().byId(e.context.id),i="";if(e.context.id==="WEBPAGE"){i="sap.ui.core"}else if(t){i=t.getMetadata().getName()}return{severity:e.severity,name:e.rule.title,description:e.rule.description,resolution:e.rule.resolution,resolutionUrls:e.rule.resolutionurls,audiences:e.rule.audiences,categories:e.rule.categories,details:e.details,ruleLibName:e.rule.libName,ruleId:e.rule.id,async:e.rule.async===true,minVersion:e.rule.minversion,context:{className:i,id:e.context.id}}};var n={addIssue:function(e){s.push(e)},walkIssues:function(e){s.forEach(e)},clearIssues:function(){s=[]},getIssues:function(){return s.slice()},getIssuesModel:function(){var e=[];this.walkIssues(function(t){e.push(u(t))});return e},getRulesViewModel:function(t,i,r){var s={},u=0,n={},o={},a={},l=e({},t),d=e({},r);for(n in l){s[n]=e({},l[n].ruleset._mRules);o=s[n];Object.defineProperty(o,"selected",{enumerable:false,configurable:true,writable:true,value:false});Object.defineProperty(o,"issueCount",{enumerable:false,configurable:true,writable:true,value:0});for(a in l[n].ruleset._mRules){o[a]=e([],o[a]);Object.defineProperty(o[a],"selected",{enumerable:false,configurable:true,writable:true,value:false});Object.defineProperty(o[a],"issueCount",{enumerable:false,configurable:true,writable:true,value:0});if(i[a]){o[a].selected=true;o.selected=true}if(d[n]&&d[n][a]){o[a].push.apply(o[a],d[n][a]);u=d[n][a].length;o[a].issueCount=u;o.issueCount+=u}}}return s},getTreeTableViewModel:function(e){var t=0,i={},r,s,u=[];r=this.getRulesViewModel(e,[],[]);for(var n in r){i[t]={name:n,id:n+" "+t,selected:true,type:"lib",nodes:u};for(var o in r[n]){s=r[n][o];u.push({name:s.title,description:s.description,id:s.id,audiences:s.audiences.toString(),categories:s.categories.toString(),minversion:s.minversion,resolution:s.resolution,title:s.title,libName:n,selected:true})}u=[];t++}return i},getIssuesViewModel:function(e){var t={},i=0,r=0,s=0,u,n=0,o=0,a=0;for(var l in e){t[i]={name:l,showAudiences:false,showCategories:false,type:"lib"};for(var d in e[l]){u=this._sortSeverityIssuesByPriority(e[l][d]);t[i][r]={formattedName:this._getFormattedName({name:e[l][d][0].name,highCount:u.high,mediumCount:u.medium,lowCount:u.low,highName:"H",mediumName:"M",lowName:"L"}),name:e[l][d][0].name,showAudiences:true,showCategories:true,categories:e[l][d][0].categories.join(", "),audiences:e[l][d][0].audiences.join(", "),issueCount:e[l][d].length,description:e[l][d][0].description,resolution:e[l][d][0].resolution,type:"rule",ruleLibName:e[l][d][0].ruleLibName,ruleId:e[l][d][0].ruleId,selected:e[l][d][0].selected,details:e[l][d][0].details,severity:e[l][d][0].severity};s+=e[l][d].length;r++;n+=u.high;o+=u.medium;a+=u.low}t[i].formattedName=this._getFormattedName({name:t[i].name,highCount:n,mediumCount:o,lowCount:a,highName:"High",mediumName:"Medium",lowName:"Low"});t[i].name+=" ("+s+" issues)";t[i].issueCount=s;s=0;r=0;i++;n=0;o=0;a=0}return t},_getFormattedName:function(e){var t="",i="",r="";if(e.highCount>0){t="issueSeverityHigh"}if(e.mediumCount>0){i="issueSeverityMedium"}if(e.lowCount>0){r="issueSeverityLow"}return e.name+' (<span class="'+t+'"> '+e.highCount+" "+e.highName+", </span> "+'<span class="'+i+'"> '+e.mediumCount+" "+e.mediumName+", </span> "+'<span class="'+r+'"> '+e.lowCount+" "+e.lowName+"</span> )"},_sortSeverityIssuesByPriority:function(e){var t=0,i=0,s=0;e.forEach(function(e){switch(e.severity){case r.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:s++;break;case r.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:i++;break;case r.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:t++;break}});return{high:t,medium:i,low:s}},convertToViewModel:function(e){var t=[];for(var i=0;i<e.length;i++){t.push(u(e[i]))}return t},groupIssues:function(e){var t={},i={};for(var r=0;r<e.length;r++){i=e[r];if(!t[i.ruleLibName]){t[i.ruleLibName]={}}if(!t[i.ruleLibName][i.ruleId]){t[i.ruleLibName][i.ruleId]=[]}t[i.ruleLibName][i.ruleId].push(i)}return t},createIssueManagerFacade:function(e){return new o(e)}};var o=function(e){this.oRule=e};o.prototype.addIssue=function(e){e.rule=this.oRule;if(!i.Severity[e.severity]){throw"The issue from rule "+this.oRule.title+" does not have proper severity defined. Allowed values can be found"+"in sap.ui.support.Severity"}if(!e.context||!e.context.id){throw"The issue from rule '"+this.oRule.title+"' should provide a context id."}if(!e.details){throw"The issue from rule '"+this.oRule.title+"' should provide details for the generated issue."}n.addIssue(e)};return n},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/support/supportRules/Main", ["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Component","sap/ui/core/Supportability","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/History","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSetLoader","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/library"],function(e,t,s,i,r,o,n,u,a,l,p,c,_,f,E,d,h,S,R){"use strict";var y=null;var g=null;var b=new l(d.HIGHLIGHTER_ID);var T=t.extend("sap.ui.support.Main",{constructor:function(){if(!g){this._oCore=null;this._oAnalyzer=new n;this._oAnalyzer.onNotifyProgress=function(e){p.publish(E.ON_PROGRESS_UPDATE,{currentProgress:e})};t.apply(this,arguments);var s=document.createEvent("CustomEvent");s.initCustomEvent("supportToolLoaded",true,true,{})}else{e.warning("Only one support tool allowed");return g}}});T.prototype.exit=function(){y._stop();this._pluginStarted=false;this._oCore=null;this._oCoreFacade=null;this._oDataCollector=null;this._oExecutionScope=null};T.prototype._isInIframe=function(){try{return window.self!==window.top}catch(e){return true}};T.prototype.startPlugin=function(e){if(this._pluginStarted){return}this._aSupportModeConfig=e;if(s.isInitialized()){this._initPlugin()}else{s.attachInit(this._initPlugin.bind(this))}};T.prototype._initPlugin=function(){var e=this._aSupportModeConfig;this._pluginStarted=true;this._supportModeConfig=e=e||o.getSupportSettings();p.bSilentMode=e.indexOf("silent")>-1;this._setCommunicationSubscriptions();var t=this._isInIframe()&&e.indexOf("frame-force-ui")!==-1;this._oCore=s;this._oDataCollector=new f(s);this._oCoreFacade=u(s);this._oExecutionScope=null;this._createElementSpies();s.attachLibraryChanged(h._onLibraryChanged.bind(h));if(!e||e.indexOf("silent")===-1||t){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(t){y=t;y.injectFrame(e);p.allowFrame(y.getCommunicationInfo())})}else{h.updateRuleSets(function(){this.fireEvent("ready")}.bind(this))}};T.prototype._createElementSpies=function(){var e=this,t=500;this._fnDirtyTimeoutHandle=null;var s=function(s){var r=i.prototype[s];i.prototype[s]=function(){r.apply(this,arguments);clearTimeout(e._fnDirtyTimeoutHandle);e._fnDirtyTimeoutHandle=setTimeout(function(){p.publish(E.ON_CORE_STATE_CHANGE)},t)}};s("register");s("deregister")};T.prototype._setCommunicationSubscriptions=function(){p.subscribe(E.VERIFY_CREATE_RULE,function(e){var t=S.deserialize(e),s=h.getRuleSet(d.TEMP_RULESETS_NAME).ruleset,i=s.addRule(t);p.publish(E.VERIFY_RULE_CREATE_RESULT,{result:i,newRule:S.serialize(t)})},this);p.subscribe(E.VERIFY_UPDATE_RULE,function(e){var t=S.deserialize(e.updateObj),s=h.getRuleSet(d.TEMP_RULESETS_NAME).ruleset,i=s.updateRule(e.oldId,t);p.publish(E.VERIFY_RULE_UPDATE_RESULT,{result:i,updateRule:S.serialize(t)})},this);p.subscribe(E.DELETE_RULE,function(e){var t=S.deserialize(e),s=h.getRuleSet(d.TEMP_RULESETS_NAME).ruleset;s.removeRule(t)},this);p.subscribe(E.OPEN_URL,function(e){var t=window.open(e,"_blank");t.opener=null;t.focus()},this);p.subscribe(E.ON_DOWNLOAD_REPORT_REQUEST,function(e){this._getReportData(e).then(function(e){sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(t){t.downloadReportZip(e)})})},this);p.subscribe(E.HIGHLIGHT_ELEMENT,function(e){var t=s.byId(e).$();t.css("background-color","red")},this);p.subscribe(E.TREE_ELEMENT_MOUSE_ENTER,function(e){b.highlight(e)},this);p.subscribe(E.TREE_ELEMENT_MOUSE_OUT,function(){b.hideHighLighter()},this);p.subscribe(E.TOGGLE_FRAME_HIDDEN,function(e){y.toggleHide(e)},this);p.subscribe(E.POST_UI_INFORMATION,function(e){this._oDataCollector.setSupportAssistantLocation(e.location);this._oDataCollector.setSupportAssistantVersion(e.version)},this);p.subscribe(E.GET_AVAILABLE_COMPONENTS,function(){p.publish(E.POST_AVAILABLE_COMPONENTS,Object.keys(r.registry.all()))},this);p.subscribe(E.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.rulePreset)},this);p.subscribe(E.ON_INIT_ANALYSIS_CTRL,function(){h.updateRuleSets(function(){this.fireEvent("ready")}.bind(this))},this);p.subscribe(E.ON_SHOW_REPORT_REQUEST,function(e){this._getReportData(e).then(function(e){sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(t){t.openReport(e)})})},this);p.subscribe(E.LOAD_RULESETS,function(e){h.loadAdditionalRuleSets(e.aLibNames)},this);p.subscribe(E.REQUEST_RULES_MODEL,function(e){if(e){p.publish(E.GET_RULES_MODEL,c.getTreeTableViewModel(e))}},this);p.subscribe(E.REQUEST_ISSUES,function(e){if(e){var t=c.groupIssues(e),s=c.getIssuesViewModel(t);p.publish(E.GET_ISSUES,{groupedIssues:t,issuesModel:s})}},this);p.subscribe(E.GET_NON_LOADED_RULE_SETS,function(e){h.fetchNonLoadedRuleSets(e.loadedRulesets)},this)};T.prototype.analyze=function(t,s,i){var r=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return}if(typeof s==="string"){s=R.SystemPresets[s];if(!s){e.error("System preset ID is not valid");return}}t=t||{type:"global"};if(i){this._oAnalysisMetadata=JSON.parse(JSON.stringify(i))}else{this._oAnalysisMetadata=null}var o;if(s&&s.selections){this._oSelectedRulePreset=s;o=s.selections;if(!s.id||!s.title){e.error("The preset must have an ID and a title");return}}else{this._oSelectedRulePreset=null;o=s}o=o||h.getAllRuleDescriptors();if(!this._isExecutionScopeValid(t)){p.publish(E.POST_MESSAGE,{message:"Set a valid element ID."});return}p.publish(E.ON_ANALYZE_STARTED);if(t.selectors){this._mapExecutionScope(t)}this._oAnalyzer.reset();this.setExecutionScope(t);c.clearIssues();this._setSelectedRules(o);return this._oAnalyzer.start(this._aSelectedRules,this._oCoreFacade,this._oExecutionScope).then(function(){return r._done()})};T.prototype._isExecutionScopeValid=function(t){var i=[],r=false,o;if(a.possibleScopes.indexOf(t.type)===-1){e.error("Invalid execution scope type. Type must be one of the following: "+a.possibleScopes.join(", "));return false}if(t.type==="subtree"){if(t.parentId){i.push(t.parentId)}else if(Array.isArray(t.selectors)){i=i.concat(t.selectors)}else if(t.selectors){i.push(t.selectors)}for(o=0;o<i.length;o++){if(s.byId(i[o])){r=true;break}}if(!r){return false}}return true};T.prototype.setExecutionScope=function(e){this._oExecutionScope=a(this._oCore,e)};T.prototype._setSelectedRules=function(t){this._aSelectedRules=[];this._oSelectedRulesIds={};if(!t){return}if(!Array.isArray(t)){t=[t]}t.forEach(function(t){var s,i;if(!t.libName||!t.ruleId){e.error("["+d.SUPPORT_ASSISTANT_NAME+"] Invalid Rule Descriptor.");return}s=h.getRuleSet(t.libName);if(!s||!s.ruleset){e.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Ruleset for library "+t.libName);return}i=s.ruleset.getRules();if(!i||!i[t.ruleId]){e.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Rule with id "+t.ruleId+" for library "+t.libName);return}this._aSelectedRules.push(i[t.ruleId]);this._oSelectedRulesIds[t.ruleId]=true},this)};T.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0]}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors]}else if(Array.isArray(e.selectors)){e.components=e.selectors}}delete e.selectors};T.prototype._done=function(){p.publish(E.ON_ANALYZE_FINISH,{issues:c.getIssuesModel(),elementTree:this._createElementTree(),elapsedTime:this._oAnalyzer.getElapsedTimeString()});return _.saveAnalysis(this)};T.prototype._createElementTree=function(){var e=this._copyElementsStructure(),t=[];this._setContextElementReferences(e);for(var s in e){if(e[s].skip){continue}t.push(e[s])}return[{content:t,id:"WEBPAGE",name:"WEBPAGE"}]};T.prototype._setContextElementReferences=function(e){var t=i.registry.all();for(var s in e){var r=e[s],o=t[s]==undefined?undefined:t[s].getParent();if(t[s]instanceof sap.ui.core.ComponentContainer){var n=t[s],u=n.getComponent();if(u){r.content.push(e[u]);e[u].skip=true}}if(o){var a=o.getId();if(!e[a]){continue}e[a].content.push(e[s]);e[s].skip=true}}};T.prototype._copyElementsStructure=function(){var e={};var t=function(t,s){for(var i in t){if(Object.hasOwn(t,i)){var r=t[i];var o={content:[],id:r.getId(),name:s==undefined?r.getMetadata().getName():s};e[r.getId()]=o}}};t(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(e){if(e instanceof sap.ui.core.ComponentContainer){var s=e.getComponent(),i=r.registry.get(s);if(i){t([i],"sap-ui-component")}}});switch(this._oExecutionScope.getType()){case"global":t(this._oCoreFacade.getUIAreas(),"sap-ui-area");t(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var s=this._oExecutionScope._getContext().parentId;t([i.registry.get(s)]);break;case"components":var o=this._oExecutionScope._getContext().components;o.forEach(function(e){t([r.registry.get(e)],"sap-ui-component")});break}return e};T.prototype._getReportData=function(e){return this._oDataCollector.getTechInfoJSON().then(function(t){var s=c.groupIssues(c.getIssuesModel()),i=h.getRuleSets(),r=this._oSelectedRulesIds,o=this._oSelectedRulePreset||null;return{issues:s,technical:t,application:this._oDataCollector.getAppInfo(),rules:c.getRulesViewModel(i,r,s),rulePreset:o,scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:e.executionScopes,executionScopeTitle:e.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:e.analysisDurationTitle,abap:_.getFormattedHistory(R.HistoryFormats.Abap),name:d.SUPPORT_ASSISTANT_NAME}}.bind(this))};T.prototype.getAnalysisHistory=function(){if(this._oAnalyzer.running()){return null}return _.getHistory()};T.prototype.getFormattedAnalysisHistory=function(e){if(this._oAnalyzer.running()){return""}return _.getFormattedHistory(e)};T.prototype.getLastAnalysisHistory=function(){var e=this.getAnalysisHistory();if(Array.isArray(e)&&e.length>0){return e[e.length-1]}else{return null}};T.prototype.addRule=function(e){if(!e){return"No rule provided."}e.selected=e.selected!==undefined?e.selected:true;e.async=e.async||false;var t=h.getRuleSet(d.TEMP_RULESETS_NAME).ruleset.addRule(e);p.publish(E.VERIFY_RULE_CREATE_RESULT,{result:t,newRule:S.serialize(e)});return t};var g=new T;return g},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/RuleSerializer", ["./util/EvalUtils"],function(e){"use strict";return{serialize:function e(i){var n=function(e,i){if(typeof i==="function"){return i.toString()}else{return i}};var t=JSON.stringify(i,n);return t},deserialize:function(i,n){var t;if(typeof i==="string"){t=JSON.parse(i)}else{t=i}if(!n&&t.check!==undefined){t.check=e.evalFunction(t.check)}return t}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/RuleSet", ["sap/base/Log","sap/base/util/Version","sap/ui/support/library","sap/ui/support/supportRules/Storage"],function(e,r,t,i){"use strict";var s={};var o=function(r){r=r||{};if(!r.name){e.error("Please provide a name for the RuleSet.")}if(s[r.name]){return s[r.name]}this._oSettings=r;this._mRules={};s[r.name]=this};o.clearAllRuleSets=function(){s={}};o.prototype.getRules=function(){return this._mRules};o.prototype.updateRule=function(e,r){var t=this._verifySettingsObject(r,true);if(t==="success"){delete this._mRules[e];this._mRules[r.id]=r}return t};o.prototype._verifySettingsObject=function(r,i){if(!r.id){e.error("Support rule needs an id.");return"Support rule needs an unique id."}if(!i&&this._mRules[r.id]){e.error("Support rule with the id "+r.id+" already exists.");return"Support rule with the id "+r.id+" already exists."}if(!r.check){e.error("Support rule with the id "+r.id+" needs a check function.");return"Support rule with the id "+r.id+" needs a check function."}if(!r.title){e.error("Support rule with the id "+r.id+" needs a title.");return"Support rule with the id "+r.id+" needs a title."}if(!r.description){e.error("Support rule with the id "+r.id+" needs a description.");return"Support rule with the id "+r.id+" needs a description."}if(!r.resolution&&(!r.resolutionurls||r.resolutionurls.length===0)){e.error("Support rule with the id "+r.id+" needs either a resolution or resolutionurls or should have a ticket handler function");return"Support rule with the id "+r.id+" needs either a resolution or resolutionurls or should have a ticket handler function"}if(!r.audiences||r.audiences.length===0){e.error("Support rule with the id "+r.id+" should have an audience. Applying audience ['Control']");r.audiences=[t.Audiences.Control]}if(r.audiences&&r.audiences.forEach){var s=false,o="";r.audiences.forEach(function(e){if(!t.Audiences[e]){s=true;o=e}});if(s){e.error("Audience "+o+" does not exist. Please use the audiences from sap.ui.support.Audiences");return"Audience "+o+" does not exist. Please use the audiences from sap.ui.support.Audiences"}}if(!r.categories||r.categories.length===0){e.error("Support rule with the id "+r.id+" should have a category. Applying category ['Performance']");r.categories=["Performance"]}if(r.categories&&r.categories.forEach){var u=false,n="";r.categories.forEach(function(e){if(!t.Categories[e]){u=true;n=e}});if(u){e.error("Category "+n+" does not exist. Please use the categories from sap.ui.support.Categories");return"Category "+n+" does not exist. Please use the categories from sap.ui.support.Categories"}}return"success"};o.prototype.addRule=function(e,t){var i=o.versionInfo?o.versionInfo.version:t.version;var s=e.minversion?e.minversion:"";if(s==="-"){s=""}if(s&&r(i).compareTo(s)<0){return"Rule "+e.id+" should be used with a version >= "+e.minversion}var u=this._verifySettingsObject(e);if(u==="success"){this._mRules[e.id]=e;e.libName=this._oSettings.name}return u};o.prototype.removeRule=function(e){if(this._mRules[e.id]){delete this._mRules[e.id]}};o.prototype.mergeRuleSet=function(e){var r=e;if(e instanceof o){r=e.getRules()}for(var t=0;t<r.length;t++){var i=r[t];if(Array.isArray(i)){for(var s=0;s<i.length;s++){this.addRule(i[s])}}else{this.addRule(i)}}};o.storeSelectionOfRules=function(e){var r=o._extractRulesSettingsToSave(e);i.setSelectedRules(r)};o.loadSelectionOfRules=function(e){var r=i.getSelectedRules();if(!r){return}for(var t=0;t<e.length;t+=1){var s=e[t].rules;var o=e[t].title;for(var u=0;u<s.length;u+=1){if(r[o]&&r[o].hasOwnProperty(s[u].id)){s[u].selected=r[o][s[u].id].selected}}}};o._extractRulesSettingsToSave=function(e){var r={};var t;var i=e.length;var s;var o;var u;for(var n=0;n<i;n+=1){o=e[n].title;r[o]={};t=e[n].rules;s=t.length;for(var a=0;a<s;a+=1){u={};u.id=t[a].id;u.selected=t[a].selected;r[o][u.id]=u}}return r};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/RuleSetLoader", ["sap/base/Log","sap/base/util/extend","sap/base/util/ObjectPath","sap/ui/VersionInfo","sap/ui/core/Supportability","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/util/EvalUtils","sap/ui/support/supportRules/util/Utils","sap/ui/thirdparty/jquery"],function(e,t,r,i,u,s,a,n,l,o,p,c,jQuery){"use strict";var f=function(){var e;return function(t){if(!e){e=document.createElement("a")}e.href=t;return e.href.replace(/\/$/,"")}}();var h="sprt";var R=sap.ui.require.toUrl("sap/ui/support");var b=R.replace("/sap/ui/support","");var S=f(b);var _={};_._mRuleSets={};_._mRequireLibraryRuleSet={};_.getRuleSets=function(){return this._mRuleSets};_.addRuleSet=function(e,t){this._mRuleSets[e]=t};_.getRuleSet=function(e){return this._mRuleSets[e]};_._fetchSupportRuleSets=function(e,t){var r=t||sap.ui.getCore().getLoadedLibraries(),u=this._fetchLibraryNamesWithSupportRules(r);return i.load({library:"sap.ui.core"}).then(function(e){s.versionInfo=e;return u}).then(function(e){return Promise.all(this._fetchLibraryFiles(e,this._fetchRuleSet))}.bind(this)).then(function(){this._bRulesCreated=true;a.publish(n.UPDATE_SUPPORT_RULES,{sRuleSet:l.serialize(this._mRuleSets),oVersionInfo:s.versionInfo});if(e&&typeof e==="function"){e()}}.bind(this))};_.loadAdditionalRuleSets=function(e){var t=this,r=t._fetchLibraryFiles(e,t._fetchRuleSet);Promise.all(r).then(function(){t._bRulesCreated=true;a.publish(n.UPDATE_SUPPORT_RULES,{sRuleSet:l.serialize(t._mRuleSets)})})};_._fetchLibraryNamesWithSupportRules=function(e){return new Promise(function(t){c.canLoadInternalRulesAsync().then(function(r){var i={publicRules:[],internalRules:[],allRules:[]};e=e||{};var u=[];Object.keys(e).forEach(function(e){var t=new Promise(function(t){var r=S+"/"+e.replace(/\./g,"/")+"/.supportrc";jQuery.ajax({type:"GET",dataType:"json",url:r,success:function(r){t({lib:e,rcData:r})},error:function(){t({lib:e,rcData:null})}})});u.push(t)});Promise.all(u).then(function(e){e.forEach(function(e){if(e.rcData){var u=false;if(e.rcData.publicRules){i.publicRules.push(e.lib);u=true}if(r&&e.rcData.internalRules){i.internalRules.push(e.lib);u=true}if(u&&i.allRules.indexOf(e.lib)<0){i.allRules.push(e.lib)}}t(i)})})})})};_._fetchLibraryFiles=function(e,t,r){var i=[],s=sap.ui.require.toUrl("sap/ui/support"),l=s.replace("sap/ui/support",""),o=c.canLoadInternalRules(),p=o&&e.internalRules.length>0,f=0,h=e.publicRules.length;var R=u.getSupportSettings();var b=R&&R.indexOf("silent")>-1;if(p){h+=e.internalRules.length}function S(){f+=1;var e=Math.ceil(f/h*100);a.publish(n.CURRENT_LOADING_PROGRESS,{value:e})}if(e.publicRules.length>0){e.publicRules.forEach(function(e){var u=this._registerLibraryPath(e,s,l).customizableLibName;if(this._mRequireLibraryRuleSet[u]){return}var a=this._requireRuleSet(u,t);if(!b&&!r){a.then(function(){S()})}this._mRequireLibraryRuleSet[u]=a;i.push(a)}.bind(this))}if(o&&e.internalRules.length>0){e.internalRules.forEach(function(e){var u=this._registerLibraryPath(e,s,l).internalLibName;if(this._mRequireLibraryRuleSet[u]){return}var a=this._requireRuleSet(u,t);if(!b&&!r){a.then(function(){S()})}this._mRequireLibraryRuleSet[u]=a;i.push(a)}.bind(this))}return i};_._registerLibraryPath=function(e,t,r){var i=e.replace(/\./g,"/");var u=i;var s=this._getLoadFromSupportOrigin();var a={};if(s){u+="/"+h;a[u]=r+i}var n=u+"/internal";var l=r.replace("resources/","")+"test-resources/"+i+"/internal";a[n]=l;sap.ui.loader.config({paths:a});return{internalLibName:n.replace(/\//g,"."),customizableLibName:u.replace(/\//g,".")}};_._requireRuleSet=function(e,t){var r=this;return new Promise(function(i){try{sap.ui.require([e.replace(/\./g,"/")+"/library.support"],function(u){t.call(r,e,u);i()},i)}catch(e){i()}})};_._fetchRuleSet=function(i,u){try{var a=i.replace("."+h,"").replace(".internal",""),n=this._mRuleSets[a];if(u==null){u=r.get(i).library.support;if(u){e.error(`The ruleset for library '${i}' could only be retrieved via globals.`+`This is deprecated and won't be supported in future releases`)}}if(!u){throw"The library.support file was not fetched successfully."}if(n){n.ruleset.mergeRuleSet(u.ruleset);return}if(u.ruleset instanceof s){n=t({},u)}else{n=this._createRuleSet(u)}this._mRuleSets[a]=n}catch(t){e.error("["+o.SUPPORT_ASSISTANT_NAME+"] Failed to load RuleSet for "+i+" library",t)}};_._getLoadFromSupportOrigin=function(){var e=new URL(sap.ui.require.toUrl("sap/ui/core"),document.baseURI);var t=new URL(sap.ui.require.toUrl("sap/ui/support"),document.baseURI);return e.origin!==t.origin};_.fetchNonLoadedRuleSets=function(e){i.load().then(function(e){var t={};e.libraries.forEach(function(e){t[e.name]=e});return this._fetchLibraryNamesWithSupportRules(t)}.bind(this)).then(function(t){var r=[];t.allRules.forEach(function(t){if(e.indexOf(t)<0){r.push(t)}});a.publish(n.POST_AVAILABLE_LIBRARIES,{libNames:r})})};_._onLibraryChanged=function(e){if(e.getParameter("stereotype")==="library"&&this._bRulesCreated){this._oMainPromise=this._fetchSupportRuleSets()}};_.updateRuleSets=function(e){this._oMainPromise=this._fetchSupportRuleSets(e)};_._createRuleSet=function(e){var t={name:e.name,niceName:e.niceName};var r=new s(t);r.mergeRuleSet(e.ruleset);return{lib:t,ruleset:r}};_.getAllRules=function(){var e={};Object.keys(this._mRuleSets).map(function(r){e=t(e,this._mRuleSets[r].ruleset.getRules())},this);return e};_.getAllRuleDescriptors=function(){var e=this.getAllRules();return Object.keys(e).map(function(t){return{libName:e[t].libName,ruleId:t}})};if(p.isEvalAllowed()){_.addRuleSet(o.TEMP_RULESETS_NAME,{lib:{name:o.TEMP_RULESETS_NAME},ruleset:new s({name:o.TEMP_RULESETS_NAME})})}return _},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/Storage", ["sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants"],function(e,t){"use strict";function E(e){return window.btoa(unescape(encodeURIComponent(e)))}function n(e){return decodeURIComponent(escape(window.atob(e)))}var _=localStorage,r={get cookie(){return document.cookie},set cookie(e){document.cookie=e}};return{getRules:function(){var E=[],r;try{r=_.getItem(t.LOCAL_STORAGE_TEMP_RULES_KEY);if(!r){return null}E=JSON.parse(n(r));E=E.map(function(t){return e.deserialize(t,true)})}catch(e){}return E},setRules:function(e){var n=E(JSON.stringify(e));_.setItem(t.LOCAL_STORAGE_TEMP_RULES_KEY,n)},getSelectedRules:function(){var e=_.getItem(t.LOCAL_STORAGE_SELECTED_RULES_KEY);if(!e){return null}return JSON.parse(e)},setSelectedRules:function(e){_.setItem(t.LOCAL_STORAGE_SELECTED_RULES_KEY,JSON.stringify(e))},setSelectedContext:function(e){_.setItem(t.LOCAL_STORAGE_SELECTED_CONTEXT_KEY,JSON.stringify(e))},getSelectedContext:function(){return JSON.parse(_.getItem(t.LOCAL_STORAGE_SELECTED_CONTEXT_KEY))},setSelectedScopeComponents:function(e){_.setItem(t.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY,JSON.stringify(e))},getSelectedScopeComponents:function(){var e=_.getItem(t.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);return JSON.parse(e)},removeSelectedRules:function(e){this.setRules(e)},setVisibleColumns:function(e){_.setItem(t.LOCAL_STORAGE_SELECTED_VISIBLE_COLUMN_KEY,JSON.stringify(e))},getVisibleColumns:function(){return JSON.parse(_.getItem(t.LOCAL_STORAGE_SELECTED_VISIBLE_COLUMN_KEY))},getSelectionPresets:function(){return JSON.parse(_.getItem(t.LOCAL_STORAGE_SELECTION_PRESETS_KEY))},getCustomPresets:function(){return JSON.parse(_.getItem(t.LOCAL_STORAGE_CUSTOM_PRESETS_KEY))},setSelectionPresets:function(e){_.setItem(t.LOCAL_STORAGE_SELECTION_PRESETS_KEY,JSON.stringify(e))},setCustomPresets:function(e){_.setItem(t.LOCAL_STORAGE_CUSTOM_PRESETS_KEY,JSON.stringify(e))},removeAllData:function(){_.removeItem(t.LOCAL_STORAGE_TEMP_RULES_KEY);_.removeItem(t.LOCAL_STORAGE_SELECTED_RULES_KEY);_.removeItem(t.LOCAL_STORAGE_SELECTED_CONTEXT_KEY);_.removeItem(t.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);_.removeItem(t.LOCAL_STORAGE_SELECTED_VISIBLE_COLUMN_KEY);_.removeItem(t.LOCAL_STORAGE_SELECTION_PRESETS_KEY);_.removeItem(t.LOCAL_STORAGE_CUSTOM_PRESETS_KEY);_.removeItem(t.LOCAL_STORAGE_CUSTOM_PRESETS_KEY);_.removeItem(t.LOCAL_STORAGE_TEMP_RULES_DISABLED_WARNED)},createPersistenceCookie:function(e,t){r.cookie=e+"="+t},readPersistenceCookie:function(e){var t=e+"=",E=decodeURIComponent(r.cookie),n=E.split(";"),_="";for(var o=0;o<n.length;o++){var S=n[o];while(S.charAt(0)==" "){S=S.substring(1)}if(S.indexOf(t)==0){_=S.substring(t.length,S.length);return _}}return _},deletePersistenceCookie:function(e){r.cookie=e+"=;expires=Thu, 01 Jan 1970 00:00:01 GMT;"},markTempRulesDisabledWarned:function(){_.setItem(t.LOCAL_STORAGE_TEMP_RULES_DISABLED_WARNED,true)},getTempRulesDisabledWarned:function(){return _.getItem(t.LOCAL_STORAGE_TEMP_RULES_DISABLED_WARNED)},_setStorage:function(e){_=e},_getStorage:function(){return _},_setCookieInterface:function(e){r=e},_getCookieInterface:function(){return r}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/WCBChannels", [],function(){"use strict";return{ON_CORE_STATE_CHANGE:"ON_CORE_STATE_CHANGE",ON_SHOW_REPORT_REQUEST:"ON_SHOW_REPORT_REQUEST",ON_DOWNLOAD_REPORT_REQUEST:"ON_DOWNLOAD_REPORT_REQUEST",ON_ANALYZE_REQUEST:"ON_ANALYZE_REQUEST",ON_INIT_ANALYSIS_CTRL:"ON_INIT_ANALYSIS_CTRL",ON_PROGRESS_UPDATE:"ON_PROGRESS_UPDATE",ON_ANALYZE_STARTED:"ON_ANALYZE_STARTED",ON_ANALYZE_FINISH:"ON_ANALYZE_FINISH",POST_UI_INFORMATION:"POST_UI_INFORMATION",VERIFY_CREATE_RULE:"VERIFY_CREATE_RULE",VERIFY_RULE_CREATE_RESULT:"VERIFY_RULE_CREATE_RESULT",VERIFY_UPDATE_RULE:"VERIFY_UPDATE_RULE",VERIFY_RULE_UPDATE_RESULT:"VERIFY_RULE_UPDATE_RESULT",DELETE_RULE:"DELETE_RULE",POST_AVAILABLE_LIBRARIES:"POST_AVAILABLE_LIBRARIES",LOAD_RULESETS:"LOAD_RULESETS",GET_AVAILABLE_COMPONENTS:"GET_AVAILABLE_COMPONENTS",POST_AVAILABLE_COMPONENTS:"POST_AVAILABLE_COMPONENTS",HIGHLIGHT_ELEMENT:"HIGHLIGHT_ELEMENT",OPEN_URL:"OPEN_URL",TREE_ELEMENT_MOUSE_ENTER:"TREE_ELEMENT_MOUSE_ENTER",TREE_ELEMENT_MOUSE_OUT:"TREE_ELEMENT_MOUSE_OUT",UPDATE_SUPPORT_RULES:"UPDATE_SUPPORT_RULES",EXTERNAL_MODULE_UPLOADED:"EXTERNAL_MODULE_UPLOADED",TOGGLE_FRAME_HIDDEN:"TOGGLE_FRAME_HIDDEN",ENSURE_FRAME_OPENED:"ENSURE_FRAME_OPENED",RESIZE_FRAME:"RESIZE_FRAME",REQUEST_RULES_MODEL:"REQUEST_RULES_MODEL",GET_RULES_MODEL:"GET_RULES_MODEL",REQUEST_ISSUES:"REQUEST_ISSUES",GET_ISSUES:"GET_ISSUES",POST_MESSAGE:"POST_MESSAGE",GET_NON_LOADED_RULE_SETS:"GET_NON_LOADED_RULE_SETS",CURRENT_LOADING_PROGRESS:"CURRENT_LOADING_PROGRESS"}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/WCBConfig", ["sap/ui/thirdparty/URI"],function(i){"use strict";var r="_unnamed_frame_-_use_message_origin_";var n=function(i){this._sModulePath=i.modulePath;this._sReceivingWindow=i.receivingWindow;if(i.uriParams){this._sURIOrigin=i.uriParams&&i.uriParams.origin;this._sURIFrameId=i.uriParams&&i.uriParams.frameId;this._sOrigin=this.getOriginURIParameter(i.uriParams.origin)}return this};n.prototype.getOrigin=function(){if(this._sOrigin){return this._sOrigin}var r=new i(sap.ui.require.toUrl(this._sModulePath));var n=r.protocol()||window.location.protocol.replace(":","");var t=r.host()||window.location.host;this._sOrigin=n+"://"+t;return this._sOrigin};n.prototype.getFrameId=function(){return new URLSearchParams(window.location.search).get(this._sURIFrameId)||r};n.prototype.getOriginURIParameter=function(){return new URLSearchParams(window.location.search).get(this._sURIOrigin)};n.prototype.getReceivingWindow=function(){if(window.communicationWindows&&window.communicationWindows.hasOwnProperty(this._sReceivingWindow)){return window.communicationWindows[this._sReceivingWindow]}return window.opener||window.parent};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/WindowCommunicationBus", ["sap/ui/base/Object","sap/base/Log","sap/base/util/isEmptyObject"],function(e,i,t){"use strict";var n=e.extend("sap.ui.support.supportRules.WindowCommunicationBus",{constructor:function(i){e.call(this);this.bSilentMode=false;this._channels={};this._frame={};this._oConfig=i;if(window.addEventListener){window.addEventListener("message",this._onmessage.bind(this),false)}else{window.attachEvent("onmessage",this._onmessage.bind(this))}}});n.prototype.subscribe=function(e,i,t){if(this.bSilentMode){return}this._channels[e]=this._channels[e]||[];this._channels[e].push({callback:i,context:t})};n.prototype.publish=function(e,i){if(this.bSilentMode){return}var t=this._oConfig.getReceivingWindow();var n={channelName:e,params:i,_frameIdentifier:this._getFrameIdentifier(),_origin:window.location.href};t.postMessage(n,this._oConfig.getOrigin())};n.prototype.allowFrame=function(e){this._frame={origin:e.origin,identifier:e.identifier,url:e.url}};n.prototype.destroyChannels=function(){this._channels={}};n.prototype._onmessage=function(e){if(!this._validate(e)){i.error("Message was received but failed validation");return}var t=this._channels[e.data.channelName]||[];t.forEach(function(i){i.callback.apply(i.context,[e.data.params])})};n.prototype._validate=function(e){if(t(this._frame)){return true}var i=e.data._frameIdentifier===this._frame.identifier;var n=new RegExp("^"+this._frame.origin+"$","i");var a=n.exec(e.origin);var r=this._frame.url.indexOf("?");var s=this._frame.url.substr(0,r).replace(/\.\.\//g,"").replace(/\.\//g,"")+this._frame.url.substr(r);var o=e.data._origin.indexOf(s)>-1;return i&&a&&o};n.prototype._getFrameIdentifier=function(){return this._frame.identifier||this._oConfig.getFrameId()};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/report/AbapHistoryFormatter", [],function(){"use strict";function e(e){var i=e.analysisInfo.rulePreset,r=e.technicalInfo.sapUi5Version&&e.technicalInfo.sapUi5Version.version||null;return{loadedLibraries:[],sapUi5Version:{name:r&&r.name||"",version:r&&r.version||"",buildTimestamp:r&&r.buildTimestamp||""},rulePreset:{id:i&&i.id||"",title:i&&i.title||"",description:i&&i.description||"",dateExported:i&&i.dateExported||""},analysisMetadata:e.analysisMetadata||null}}function i(e,i,r){e.loadedLibraries.push({id:i,rules:[],issueCount:r.loadedLibraries[i].issueCount,allRulesSelected:r.loadedLibraries[i].allRulesSelected})}function r(e,i,r,s){var a=s.loadedLibraries[i]["rules"][r];for(var n=0;n<e.loadedLibraries.length;n++){if(e.loadedLibraries[n].id===i){e.loadedLibraries[n].rules.push({id:r,library:i,name:a.name,selected:a.selected,issuesCount:a.issuesCount,issues:a.issues,resolution:a.resolution,minVersion:a.minVersion,categories:a.categories,audiences:a.audiences,description:a.description});break}}}function s(e,i){var r=[];i.applicationInfo.forEach(function(e){if(e.registrationIds){if(Array.isArray(e.registrationIds)){r=r.concat(e.registrationIds)}else if(typeof e.registrationIds==="string"){r.push(e.registrationIds)}}});if(r.length){e.registrationIds=r}}function a(a){var n=[];a.forEach(function(a){var t=e(a);for(var o in a.loadedLibraries){i(t,o,a);for(var d in a.loadedLibraries[o].rules){r(t,o,d,a)}}s(t,a);n.push(t)});return n}return{format:a}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/report/Archiver", ["sap/base/Log","sap/base/util/isPlainObject","sap/ui/thirdparty/jszip","sap/ui/core/util/File"],function(r,t,e,a){"use strict";var i=function(){this._mData={}};i.prototype.add=function(e,a,i){if(!e){r.error("Archiver: No name was given.");return false}if(!a){r.error("Archiver: No data was given.");return false}if(typeof a==="string"){this._mData[e]=a;return true}else if(i){if((i==="json"||i==="har")&&(t(a)||Array.isArray(a))){try{this._mData[e]=JSON.stringify(a);return true}catch(t){r.error("Archiver: JSON data could not be serialized for "+e)}}else{r.error("Archiver: JSON data could not be serialized for "+i+". Either the type is unknown or the data has a wrong format.")}}else{r.error("Archiver: Data could not be serialized for "+e+". Data is is not a string or has a an invalid type.");return false}return false};i.prototype.download=function(r){var t=new e;if(t){for(var i in this._mData){t.file(i,this._mData[i])}var n=t.generate({type:"blob"});a.save(n,r,"zip","application/zip")}};i.prototype.clear=function(){this._mData={};return true};i.prototype.hasData=function(r){if(r!==undefined){return this._mData.hasOwnProperty(r)}return Object.keys(this._mData).length>0};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/report/DataCollector", ["sap/ui/core/Core","sap/ui/VersionInfo","sap/base/util/LoaderExtensions","sap/base/security/encodeXML","sap/ui/core/Component","sap/ui/core/Configuration","sap/ui/core/theming/ThemeManager","sap/ui/core/support/ToolsAPI","sap/ui/thirdparty/URI"],function(o,t,n,i,e,s,r,a,u){"use strict";var p=function(){this._oSupportAssistantInfo={location:"",version:{},versionAsString:""}};p.prototype.setSupportAssistantLocation=function(o){this._oSupportAssistantInfo.location=o};p.prototype.setSupportAssistantVersion=function(o){this._oSupportAssistantInfo.version=o;this._oSupportAssistantInfo.versionAsString="not available";if(o){this._oSupportAssistantInfo.versionAsString=i(o.version||"");this._oSupportAssistantInfo.versionAsString+=" (built at "+i(o.buildTimestamp||"");this._oSupportAssistantInfo.versionAsString+=", last change "+i(o.scmRevision||"")+")"}};p.prototype.getSupportAssistantInfo=function(){return this._oSupportAssistantInfo};p.prototype.getAppInfo=function(){var o=[];e.registry.forEach(function(t){var n=t.getManifestEntry("sap.app"),i=t.getManifestEntry("sap.fiori");if(n){o.push(n)}if(i){o.push(i)}});return o};p.prototype.getTechInfoJSON=function(){var i=a.getFrameworkInformation();var e={sapUi5Version:null,version:i.commonInformation.version,build:i.commonInformation.buildTime,change:i.commonInformation.lastChange,jquery:i.commonInformation.jquery,useragent:i.commonInformation.userAgent,docmode:i.commonInformation.documentMode,debug:i.commonInformation.debugMode,bootconfig:i.configurationBootstrap,config:i.configurationComputed,libraries:i.libraries,loadedLibraries:i.loadedLibraries,modules:i.loadedModules,uriparams:i.URLParameters,appurl:i.commonInformation.applicationHREF,title:i.commonInformation.documentTitle,statistics:i.commonInformation.statistics,resourcePaths:[],themePaths:[],locationsearch:document.location.search,locationhash:document.location.hash,supportAssistant:this._oSupportAssistantInfo};var p=n.getAllRequiredModules();var c=[];for(var m=0;m<p.length;m++){c.push({moduleName:p[m],relativePath:sap.ui.require.toUrl(p[m]),absolutePath:u(sap.ui.require.toUrl(p[m])).absoluteTo(document.location.origin+document.location.pathname).toString()})}e.resourcePaths=c;var f=o.getLoadedLibraries();c=[];for(var l in f){if(l===""){continue}var h=r._getThemePath(l,s.getTheme());c.push({theme:s.getTheme(),library:l,relativePath:h,absolutePath:u(h).absoluteTo(document.location.origin+document.location.pathname).toString()})}e.themePaths=c;return t.load().then(function(o){e.sapUi5Version={version:o,path:sap.ui.require.toUrl("sap-ui-version.json")};return e})};return p},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/report/IssueRenderer", ["sap/base/Log","sap/base/security/encodeXML"],function(t,e){"use strict";function a(t){if(t){if(Array.isArray(t)){return e(t.join(", "))}else{return e(t)}}else{return""}}function r(t,e,r,s){var i="";var n="";var l=1;var d=0;for(var o in e){var u=e[o];d+=u.length;var c=u[0];n+='<tr id="'+r+"_rule_"+l+'" >';n+="<td>";n+='<div class="expandable-control collapsed-content" data-expandableElement="'+r+"_rule_"+l+'_content">';n+='<div class="expandable-title">'+l+". "+a(c.name)+' <span class="rule-issue-number">('+u.length+" issues)</span></div></div>";n+='<div class="sapUiIssueGroupContent" id="'+r+"_rule_"+l+'_content">';n+='<div><span class="sapUiSupportLabel">Description: </span>'+a(c.description)+"</div>";n+='<div><span class="sapUiSupportLabel">Min version: </span>'+a(c.minVersion)+"</div>";n+='<div><span class="sapUiSupportLabel">Async: </span>'+a(c.async.toString())+"</div>";n+='<div><span class="sapUiSupportLabel">Resolution: </span>'+a(c.resolution)+"</div>";n+="<div>";if(c.resolutionUrls){for(var p=0;p<c.resolutionUrls.length;p++){n+='<div><a href="'+a(c.resolutionUrls[p].href)+'" target="_blank">'+a(c.resolutionUrls[p].text)+"</a></div>"}}n+="</div>";n+='<table class="sapUiTable"><tr><th></th><th>Element Id</th><th>Class</th><th>Status</th><th>Details</th></tr>';for(var v=0;v<u.length;v++){n+='<tr class="filterable" data-severity="'+a(u[v].severity)+'"><td>'+(v+1)+"</td><td>"+a(u[v].context.id)+"</td>";n+="<td>"+a(u[v].context.className)+"</td>";n+='<td class="'+a(u[v].severity)+'">'+a(u[v].severity)+"</td>";n+="<td>"+a(u[v].details)+"</td></tr>"}n+="</table>";n+="</div></td>";n+="<td>"+a(c.categories)+"</td>";n+="<td>"+a(c.audiences)+"</td>";n+="</tr>";l++}var f="collapsed-content";if(s===1){f="expanded-content"}i+="<tr>";i+='<td colspan="100" class="expandable-control '+f+'" data-expandableElement="'+r+'" data-groupName="'+t+'" data-groupNumber="'+s+'">';i+='<span class="sapUiSupportLabel expandable-title">'+s+". "+t+" ("+(l-1)+" rules, "+d+" issues)</span>";i+='</td></tr><tbody id="'+r+'">';i+=n;i+="</tbody>";return i}function s(e){var a="";var s=1;if(!e){return a}try{a+='<table class="sapUiTable"><tr><th>Name</th><th>Categories</th><th>Audiences</th></tr>';for(var i in e){a+=r(i,e[i],"group"+s,s);s++}a+="</table>"}catch(e){t.warning("There was a problem extracting issues info.");a=""}return a}function i(t,e,a){if(!e){return""}var r=a?"filter-active":"";return'<div data-severity="'+t+'" class="filter '+r+" "+t+'">'+t+"("+e+")</div>"+" | "}function n(e){var a="",r={},s,n,l=0,d=[],o={},u={},c={};if(!e){return a}try{for(c in e){o=e[c];for(u in o){d=o[u];for(n=0;n<d.length;n++){s=d[n].severity;if(r[s]){r[s]++}else{r[s]=1}l++}}}a+=i("Total",l,true);a+=i("High",r["High"],false);a+=i("Medium",r["Medium"],false);a+=i("Low",r["Low"],false)}catch(e){t.warning("There was a problem creating severity filters.");a=""}return a}function l(t,e){var a="";if(e){a+='<div class="filters">'+n(t)+"<div>\n"}a+="<div>"+s(t)+"</div>";return"<div>"+a+"</div>"}return{render:l}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/report/ReportProvider", ["sap/ui/thirdparty/jquery","sap/base/Log","sap/base/security/encodeXML","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/ui/support/supportRules/report/Archiver","sap/ui/support/supportRules/report/IssueRenderer","sap/ui/core/date/UI5Date"],function(jQuery,e,t,a,n,s,i,r){"use strict";var o=sap.ui.require.toUrl("sap/ui/support/supportRules/report/resources");var p={line:function(e,a,n,s,i){e.push("<tr><td ",a?"align='right' ":"","valign='top'>","<label class='sapUiSupportLabel'>",t(s||""),"</label></td><td",n?" class='sapUiSupportTechInfoBorder'":"",">");var r=i;if(typeof i==="function"){r=i(e)}e.push(t(r||""));e.push("</td></tr>")},multiline:function(e,t,a,s,i){var r=this;r.line(e,t,a,s,function(e){e.push("<table border='0' cellspacing='0' cellpadding='3'>");jQuery.each(i,function(t,a){var s="";if(a){if(typeof a==="string"||typeof a==="string"||typeof a==="boolean"){s=a}else if(Array.isArray(a)||n(a)){s=JSON.stringify(a)}}r.line(e,false,false,t,""+s)});e.push("</table>")})},subheader:function(e,a){e.push("<tr class='sapUiSupportTitle'><td valign='top' colspan='2'>","<label class='sapUiSupportLabel'>",t(a||""),"</label></td></tr>")}};function l(e){return jQuery.ajax({type:"GET",url:o+"/"+e,dataType:"text"}).then(function(e){return e})}function u(n){var s="";if(!n){return s}try{n.modules.sort();var i=["<div class='sapUiSupportToolbar'>","<div><div class='sapUiSupportTechInfoCntnt'>","<table border='0' cellpadding='3'>"];p.subheader(i,"Support Assistant Information");p.line(i,true,true,"Location",n.supportAssistant.location);p.line(i,true,true,"Version",n.supportAssistant.versionAsString);p.subheader(i,"Application Information");p.line(i,true,true,"SAPUI5 Version",function(e){var a=n.sapUi5Version;if(a&&a.version){var s=a.version;var i=t(s.version||"");e.push(i," (built at ",t(s.buildTimestamp||""),", last change ",t(s.scmRevision||""),")")}else{e.push("not available")}});p.line(i,true,true,"Core Version",function(e){return n.version+" (built at "+n.build+", last change "+n.change+")"});p.line(i,true,true,"Loaded jQuery Version",function(e){return n.jquery});p.line(i,true,true,"User Agent",function(e){return n.useragent+(n.docmode?", Document Mode '"+n.docmode+"'":"")});p.line(i,true,true,"Application",n.appurl);p.multiline(i,true,true,"Configuration (bootstrap)",n.bootconfig);p.multiline(i,true,true,"Configuration (computed)",n.config);if(!a(n.libraries)){p.multiline(i,true,true,"Libraries",n.libraries)}p.multiline(i,true,true,"Loaded Libraries",n.loadedLibraries);p.line(i,true,true,"Loaded Modules",function(e){jQuery.each(n.modules,function(a,s){if(s.indexOf("sap.ui.core.support")<0){e.push("<span>",t(s||""),"</span>");if(a<n.modules.length-1){e.push(", ")}}})});p.multiline(i,true,true,"URI Parameters",n.uriparams);i.push("</table></div>");s=i.join("")}catch(t){e.warning("There was a problem extracting technical info.")}return s}function c(e){var a="<td>";if(e){a+=t(e)}a+="</td>";return a}function d(t){var a="";if(!t){return a}a+='<table class="sapUiTable"><tr><th>Component ID</th><th>Type</th><th>Title</th><th>Subtitle</th><th>Application version</th><th>Description</th><th>BCP Component</th></tr>';try{for(var n=0;n<t.length;n++){var s=t[n];a+="<tr>";a+=c(s.id);a+=c(s.type);a+=c(s.title);a+=c(s.subTitle);if(s.applicationVersion){a+=c(s.applicationVersion.version)}else{a+="<td></td>"}a+=c(s.description);a+=c(s.ach);a+="</tr>"}a+="</table>"}catch(t){e.warning("There was a problem extracting app info.");a=""}return a}function f(e){var t="";t+='<div><span class="sapUiSupportLabel">'+e.displayName+"</span>";t+="<span> ("+e.description+")</span></div>";return t}function h(e,t){var a="";a+='<div><span class="sapUiSupportLabel">'+t.displayName+" with id:</span> "+e;a+="<span> ("+t.description+")</span></div>";return a}function v(e,t){var a="";if(e.length>5){a+='<div class="expandable-control collapsed-content" data-expandableElement="execution-scope-components">';a+='<span class="expandable-title"><span class="sapUiSupportLabel">'+t.displayName+"</span>";a+="<span> ("+t.description+")</span></span></div>"}else{a+='<div><span class="sapUiSupportLabel">'+t.displayName+"</span>";a+="<span> ("+t.description+")</span></div>"}a+='<ol id="execution-scope-components" class="top-margin-xsmall">';for(var n=0;n<e.length;n++){a+="<li>"+e[n]+"</li>"}a+="</ol>";return a}function b(t){var a="";try{var n=t.executionScope.getType();var s=t.scopeDisplaySettings.executionScopes[n];var i=t.scopeDisplaySettings.executionScopeTitle;a+='<div class="sapUiSupportLabel">'+i+": </div>";switch(n){case"global":a+=f(s);break;case"subtree":a+=h(t.executionScope._getContext().parentId,s);break;case"components":a+=v(t.executionScope._getContext().components,s);break}}catch(t){e.warning("There was a problem extracting scope info.");a=""}return a}function m(t){var a="";if(!t){return a}try{var n=1;a+='<table class="sapUiTable"><tbody><tr><th>Name</th><th>Description</th><th>Categories</th><th>Audiences</th></tr></tbody>';for(var s in t){var i=t[s];var r="collapsed-content";if(n===1){r="expanded-content"}var o=t[s].selected?" ("+t[s].issueCount+" issues)":"";var p='<span class="'+(t[s].selected?"checked":"unchecked")+'"></span>';a+='<tbody><tr><td colspan="100" ';a+='class="expandable-control '+r+'" data-expandableElement="section-selected-rules-group'+n+'">'+p;a+='<span class="sapUiSupportLabel expandable-title">'+s+o+"</span>";a+="</td></tr></tbody>";var l="";for(var u in i){var c=i[u].selected?" ("+i[u].issueCount+" issues)":"";var d='<span class="'+(i[u].selected?"checked":"unchecked")+'"></span>';l+="<tr>";l+="<td>"+d+i[u].title+c+"</td>";l+="<td>"+i[u].description+"</td>";l+="<td>"+i[u].categories.join(", ")+"</td>";l+="<td>"+i[u].audiences.join(", ")+"</td>";l+="</tr>"}a+='<tbody id="section-selected-rules-group'+n+'">'+l+"</tbody>";n++}a+="</table>"}catch(t){e.warning("There was a problem extracting selected rules info.");a=""}return a}function g(e){return i.render(e,true)}function y(e){if(!e){return"none"}return"<strong>"+e.title+"/"+e.id+"</strong>"}function T(e,t){if(!t){t=o+"/"}return l("ReportTemplate.html").then(function(a){var n={baseUrl:t,technicalInfo:u(e.technical),issues:g(e.issues),appInfo:d(e.application),rules:m(e.rules),rulePreset:y(e.rulePreset),metadataTitle:e.name+" Analysis Results",metadataTitleTechnicalInfo:"Technical Information",metadataTitleIssues:"Issues",metadataTitleAppInfo:"Application Information",metadataTitleSelectedRules:'Available and (<span class="checked"></span>) Selected Rules',metadataTimestamp:r.getInstance(),metadataScope:b(e.scope),metadataAnalysisDuration:e.analysisDuration,metadataAnalysisDurationTitle:e.analysisDurationTitle};return x(a,n)})}function x(e,t){var a,n;for(a in t){n=t[a];e=e.replace(new RegExp("{{"+a+"}}","ig"),n)}return e}function S(e){var t=[this.getReportHtml(e,"./"),l("styles.css"),l("index.js"),l("images/checked.svg"),l("images/collapsed.svg"),l("images/expanded.svg"),l("images/unchecked.svg")];Promise.all(t).then(function(t){var a={issues:e.issues},n={appInfos:e.application},i={technicalInfo:e.technical},r=new s;r.add("technicalInfo.json",i,"json");r.add("issues.json",a,"json");r.add("appInfos.json",n,"json");r.add("report.html",t[0]);r.add("abap.json",e.abap,"json");r.add("styles.css",t[1],"css");r.add("index.js",t[2],"js");r.add("images/checked.svg",t[3],"svg");r.add("images/collapsed.svg",t[4],"svg");r.add("images/expanded.svg",t[5],"svg");r.add("images/unchecked.svg",t[6],"svg");r.download("SupportAssistantReport");r.clear()})}function I(e){var t="";var a=jQuery('<a class="sapUiHidden"></a>');a.on("click",function(){var e=window.open("","_blank");e.opener=null;jQuery(e.document).ready(function(){e.document.documentElement.innerHTML="";e.document.write(t)})});jQuery("body").append(a);this.getReportHtml(e).then(function(e){t=e;a[0].click();a.remove()})}return{getReportHtml:T,downloadReportZip:S,openReport:I}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/report/StringHistoryFormatter", [],function(){"use strict";var n=Array(196).join("-"),e="|";function r(n,e){var r="",n=n||"";if(!e){e=50}r=n.replace(/(\r\n|\n|\r)/gm," ").replace(/(\")/gm,"");if(r.length>e){r=r.substring(0,e-3)+"..."}else{while(r.length<e){r+=" "}}return r}function i(i){if(i.issues.length){var s=n+"\n";s+=e+r("rule id: "+i.id,193)+e+"\n";s+=e+r("name: "+i.name,193)+e+"\n";s+=e+r("library: "+i.library,193)+e+"\n";s+=e+r("categories: "+i.categories.join(", "),193)+e+"\n";s+=e+r("audiences: "+i.audiences.join(", "),193)+e+"\n";s+=e+r("description: "+i.description,193)+e+"\n";s+=e+r("resolution: "+i.resolution,193)+e+"\n";s+=n+"\n";s+=e+r("id",50);s+=e+r("class name",30);s+=e+r("status",10);s+=e+r("details",100);s+=e+"\n";s+=n+"\n";for(var t=0;t<i.issues.length;t++){s+=e+r(i.issues[t].context.id,50);s+=e+r(i.issues[t].context.className,30);s+=e+r(i.issues[t].severity,10);s+=e+r(i.issues[t].details,100);s+=e+"\n"}s+=n+"\n";return s}return""}function s(n){var e="";if(!n){return e}for(var r in n){if(n[r].issueCount){for(var s in n[r]["rules"]){e+=i(n[r]["rules"][s])}e+="\n"}}e+="\n";return e}function t(n){var e="Rule Preset / ID : ";if(n){e+=n.title+" / "+n.id}else{e+="none"}return e}function u(n){var e="";if(!n){return e}for(var r=0;r<n.length;r++){e+="\n";e+="Run "+(r+1)+" - executed on "+n[r].analysisInfo.date+"\n";e+=t(n[r].analysisInfo.rulePreset);e+="\n";e+=s(n[r].loadedLibraries);e+="\n"}return e}return{format:u}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/IFrameController", ["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/thirdparty/URI","sap/ui/core/date/UI5Date"],function(o,i,t,e,n,s,r){"use strict";var p=null;var u;var a;var l;function d(o){var i=new s(o);var t=(i.protocol()||window.location.protocol.replace(":",""))+"://"+(i.host()||window.location.host);return t}function c(){return""+ +r.getInstance()}function h(o){var i=document.createElement("IFRAME");var t=i.style;i.id="sap-ui-supportToolsFrame";i.src=o;t.width="100%";t.height="28px";t.position="absolute";t.left="0";t.bottom="0";t.border="none";t.borderRadius="1px";t.zIndex="1001";t.boxShadow="1px -10px 42px -4px #888";document.body.appendChild(i);setInterval(function(){if(i.parentNode.nodeName!=="BODY"){document.body.appendChild(i);window.communicationWindows.supportTool=i.contentWindow}},1e3);window.communicationWindows.supportTool=i.contentWindow}function m(o){window.communicationWindows.supportTool=window.open(o,"sapUiSupportTool","width=1024,height=400,status=no,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,scrollbars=no");window.communicationWindows.supportTool.window.onload=function(){window.communicationWindows.supportTool.document.title=n.SUPPORT_ASSISTANT_NAME}}var w=i.extend("sap.ui.support.IFrameController",{constructor:function(){if(!p){i.apply(this,arguments)}else{o.warning("Only one support tool allowed");return p}}});w.prototype._setCommunicationSubscriptions=function(){t.subscribe(e.ENSURE_FRAME_OPENED,function(){if(document.getElementById("sap-ui-supportToolsFrame").style.height==="28px"){this.resizeFrame(true);this.toggleHide()}},this);t.subscribe(e.RESIZE_FRAME,function(o){p.resizeFrame(o.bigger)})};w.prototype.injectFrame=function(o){a=c();l=sap.ui.require.toUrl("sap/ui/support/supportRules/ui/overlay.html")+"?sap-ui-xx-formfactor=compact&sap-ui-xx-support-origin="+window.location.protocol+"//"+window.location.host+"&"+"sap-ui-xx-frame-identifier="+a;u=d(l);window.communicationWindows=window.communicationWindows||{};if(o.indexOf("window")>-1){m(l)}else{h(l);this._setCommunicationSubscriptions()}};w.prototype.resizeFrame=function(o){var i=document.getElementById("sap-ui-supportToolsFrame").style;if(o){if(i.height==="50%"){i.height="100%"}else if(i.height==="28px"){i.height="50%"}}else{if(i.height==="100%"){i.height="50%"}else if(i.height==="50%"){i.height="28px"}}};w.prototype.toggleHide=function(o){var i=document.getElementById("sap-ui-supportToolsFrame").style;if(o){this._originalSize={width:i.width,height:i.height};i.width="170px";i.height="28px"}else{if(this._originalSize){i.width=this._originalSize.width;i.height=this._originalSize.height;this._originalSize=null}}};w.prototype._stop=function(){this._oCssLink.parentNode.removeChild(this._oCssLink);this._oDomRef.parentNode.removeChild(this._oCssLink);this._oCore=null};w.prototype.getCommunicationInfo=function(){return{origin:u,identifier:a,url:l}};p=new w;return p},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/Overlay", ["sap/ui/core/Core","sap/ui/core/mvc/XMLView","sap/m/Page"],function(e,a,i){"use strict";e.attachInit(function(){a.create({viewName:"sap.ui.support.supportRules.ui.views.Main"}).then(function(e){var a=new i("page",{showHeader:false,backgroundDesign:"Solid",content:[e]});a.placeAt("content")})})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/controllers/Analysis.controller", ["./BaseController","./PresetsController","../models/SharedModel","../models/TableSettingsModel","../models/SelectionUtils","../models/PresetsUtils","../models/CustomJSONListSelection","sap/base/util/deepExtend","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode","sap/ui/core/Fragment","sap/m/library","sap/m/MessageToast","sap/m/List","sap/m/StandardListItem","sap/m/table/columnmenu/Menu","sap/m/table/columnmenu/Item","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/util/EvalUtils"],function(e,t,i,s,o,r,n,l,u,a,d,c,h,p,g,m,f,S,R,y,b,P,E){"use strict";return e.extend("sap.ui.support.supportRules.ui.controllers.Analysis",{onInit:function(){this.model=i;this.setCommunicationSubscriptions();this.tempRulesLoaded=false;this.getView().setModel(this.model);this.treeTable=o.treeTable=this.byId("ruleList");this._oRuleSetsModel=new u;this.treeTable.setModel(this._oRuleSetsModel,"ruleSets");this.treeTable.setModel(s,"tableSettings");this.ruleSetView=this.byId("ruleSetsView");this.rulesViewContainer=this.byId("rulesNavContainer");this.bAdditionalViewLoaded=false;this.bAdditionalRulesetsLoaded=false;this.bInitFired=false;new n(this.treeTable,true,"id");S.subscribe(R.UPDATE_SUPPORT_RULES,function(){if(!this.bAdditionalViewLoaded){S.publish(R.RESIZE_FRAME,{bigger:true});this.bAdditionalViewLoaded=true;this.loadAdditionalUI()}},this);if(this.model.getProperty("/persistingSettings")){var e=P.getVisibleColumns()||[];if(e.length){this.setColumnVisibility(e,true)}}this.byId("presetVariant").addEventDelegate({onclick:this.onPresetVariantClick.bind(this)});this.byId("rowActionTemplate").setVisible(!this.model.getProperty("/tempRulesDisabled"));this._associateTableColumnsMenu()},onAfterRendering:function(){if(!this.bInitFired){var e=function(){S.publish(R.ON_INIT_ANALYSIS_CTRL);sap.ui.getCore().detachThemeChanged(e)};if(sap.ui.getCore().isThemeApplied()){S.publish(R.ON_INIT_ANALYSIS_CTRL)}else{sap.ui.getCore().attachThemeChanged(e)}this.bInitFired=true}},loadAdditionalUI:function(){if(!this._ruleDetails){this._ruleDetails=d.load({name:"sap.ui.support.supportRules.ui.views.RuleDetails",controller:this}).then(function(e){this.byId("rulesDisplayPage").addContentArea(e)}.bind(this))}if(!this._ruleCreateUpdatePages){this._ruleCreateUpdatePages=d.load({name:"sap.ui.support.supportRules.ui.views.RuleUpdate",controller:this}).then(function(e){e.forEach(function(e){this.byId("rulesNavContainer").insertPage(e)},this)}.bind(this))}this._updateRuleList()},onAsyncSwitch:function(e){var t=e.getSource();if(e.getParameter("selected")){var i=t.getCustomData()[0].getValue()==="true";var s=t.getProperty("groupName")==="asyncContext"?"/newRule":"/editRule";this.model.setProperty(s+"/async",i);this._updateCheckFunction(s,i)}},_updateCheckFunction:function(e,t){var i=this.model.getProperty(e+"/check");if(!i){return}var s=i.match(/function[^(]*\(([^)]*)\)/);if(!s){return}var o=s[1].trim().split(/\W+/);o[0]=o[0]||"oIssueManager";o[1]=o[1]||"oCoreFacade";o[2]=o[2]||"oScope";if(t){o[3]=o[3]||"fnResolve"}else{o=o.slice(0,3)}var r=i.replace(/function[^(]*\(([^)]*)\)/,"function ("+o.join(", ")+")");this.model.setProperty(e+"/check",r)},getTemporaryLib:function(){var e=this.model.getProperty("/libraries");for(var t=0;t<e.length;t++){if(e[t].title==b.TEMP_RULESETS_NAME){return l({},e[t])}}return null},setTemporaryLib:function(e){var t=this.model.getProperty("/libraries");for(var i=0;i<t.length;i++){if(t[i].title==b.TEMP_RULESETS_NAME){this.model.setProperty("/libraries/"+i,e);return}}},setCommunicationSubscriptions:function(){if(!this.model.getProperty("/tempRulesDisabled")){this._setTempRulesCommunicationSubscriptions()}S.subscribe(R.UPDATE_SUPPORT_RULES,this.updateSupportRules,this);S.subscribe(R.POST_AVAILABLE_LIBRARIES,function(e){this.bAdditionalRulesetsLoaded=true;this.model.setProperty("/availableLibrariesSet",e.libNames);this.rulesViewContainer.setBusy(false)},this);S.subscribe(R.POST_AVAILABLE_COMPONENTS,function(e){var t=[],i=this.model.getProperty("/executionScopeComponents"),s=P.getSelectedScopeComponents(),o;for(var r=0;r<e.length;r+=1){t.push({text:e[r]})}if(i&&i.length>0){for(o=0;o<t.length;o++){t[o].selected=this.checkIfComponentIsSelected(t[o],i)}}else if(s&&s.length>0){for(o=0;o<t.length;o++){t[o].selected=this.checkIfComponentIsSelected(t[o],s)}}this.model.setProperty("/executionScopeComponents",t)},this);S.subscribe(R.GET_RULES_MODEL,function(e){var t=P.readPersistenceCookie(b.COOKIE_NAME),i=this.model.getProperty("/loadingAdditionalRuleSets");if(i){o._syncSelectionAdditionalRuleSetsMainModel(e,this._oRuleSetsModel.getData());o._deselectAdditionalRuleSets(e,this.model.getProperty("/namesOfLoadedAdditionalRuleSets"))}if(t){this.initializeTempRules();var s=o.updateSelectedRulesFromLocalStorage(e);if(s){e=s}r.loadCustomPresets()}this._oRuleSetsModel.setData(e);if(t||i){this.treeTable.updateSelectionFromModel()}else{this.treeTable.selectAll()}this.model.setProperty("/selectedRulesCount",o.getSelectedRules().length);r.initializeSelectionPresets(o.getSelectedRules())},this);S.subscribe(R.POST_MESSAGE,function(e){h.show(e.message)},this);S.subscribe(R.ON_ANALYZE_STARTED,function(e){this.model.setProperty("/showProgressIndicator",true)},this)},checkIfComponentIsSelected:function(e,t){for(var i=0;i<t.length;i+=1){if(t[i].text==e.text&&t[i].selected){return true}}return false},onAnalyze:function(){var e=this.model.getProperty("/selectionPresetsCurrent"),t=this._getExecutionContext();if(e.selections.length===0){h.show("Select some rules to be analyzed.");return}if(t.type==="components"&&t.components.length===0){h.show("Please select some components to be analyzed.");return}S.publish(R.ON_ANALYZE_REQUEST,{rulePreset:e,executionContext:t})},_getExecutionContext:function(){var e={type:this.model.getProperty("/analyzeContext/key")};if(e.type==="subtree"){e.parentId=this.model.getProperty("/subtreeExecutionContextId")}if(e.type==="components"){var t=sap.ui.getCore().byId("componentsSelectionContainer"),i=t.getContent();e.components=[];i.forEach(function(t){if(t.getSelected()){e.components.push(t.getText())}})}return e},onSelectedRuleSets:function(e){var t=true,i=this.model.getProperty("/selectedRule"),s=e.getParameter("selectedKey")==="additionalRulesets";if(s||!i){t=false}if(!this.bAdditionalRulesetsLoaded&&s){this.rulesViewContainer.setBusyIndicatorDelay(0);this.rulesViewContainer.setBusy(true);S.publish(R.GET_NON_LOADED_RULE_SETS,{loadedRulesets:this._getLoadedRulesets()})}this.getView().getModel().setProperty("/showRuleProperties",t)},_getLoadedRulesets:function(){var e=this.treeTable.getModel("ruleSets").getData(),t=[];Object.keys(e).forEach(function(i){var s=e[i].name;if(s&&s!=="temporary"){t.push(s)}});return t},_applyTempRulesSelection:function(e){var t=l({},this._oRuleSetsModel.getData()),i,s,o,r,n,u,a=function(e){return e.id===s.id};for(var d in t){i=t[d];o=t[d].nodes;if(i.name!==b.TEMP_RULESETS_NAME){continue}t[d].nodes=[];for(var c in e.rules){s=e.rules[c];r=o[c]!==undefined?o[c].selected:true;if(this.tempRulesFromStorage){n=this.tempRulesFromStorage.filter(a);if(n.length>0){r=n[0].selected;u=this.tempRulesFromStorage.indexOf(n[0]);this.tempRulesFromStorage.splice(u,1);if(r===false){i.selected=false}}if(this.tempRulesFromStorage.length===0){this.tempRulesFromStorage.length=null}}i.nodes.push({name:s.title,description:s.description,id:s.id,audiences:s.audiences.toString(),categories:s.categories.toString(),minversion:s.minversion,resolution:s.resolution,title:s.title,selected:r,libName:i.name,check:s.check})}}this._oRuleSetsModel.setData(t)},_syncTreeTableVieModelTempRule:function(e,t){var i=this.model.getProperty("/editRuleSource");for(var s in t){if(t[s].name===b.TEMP_RULESETS_NAME){for(var o in t[s].nodes){if(t[s].nodes[o].id===i.id){t[s].nodes[o]={name:e.title,description:e.description,id:e.id,audiences:e.audiences,categories:e.categories,minversion:e.minversion,resolution:e.resolution,selected:t[s].nodes[o].selected,title:e.title,libName:t[s].name,check:e.check}}}}}},_hasSelectedComponent:function(){var e=sap.ui.getCore().byId("componentsSelectionContainer").getContent();function t(e){return e.getSelected()}return e.some(t)},onAnalyzeSettings:function(e){var t=e.getSource();S.publish(R.GET_AVAILABLE_COMPONENTS);if(!this._analyzeSettingsPopover){this._analyzeSettingsPopover=d.load({name:"sap.ui.support.supportRules.ui.views.AnalyzeSettings",controller:this}).then(function(e){this.getView().addDependent(e);return e}.bind(this))}this._analyzeSettingsPopover.then(function(e){e.openBy(t)})},onContextSelect:function(e){if(e.getParameter("selected")){var t=e.getSource(),i=t.getCustomData()[0].getValue(),s=this.model.getProperty("/executionScopes")[i];if(i==="components"&&!this._hasSelectedComponent()){var o=sap.ui.getCore().byId("componentsSelectionContainer").getContent();if(o.length>0){o[0].setSelected(true);this.onScopeComponentSelect(null)}}this.model.setProperty("/analyzeContext",s)}if(P.readPersistenceCookie(b.COOKIE_NAME)){this.persistExecutionScope()}},onExecutionContextChange:function(e){var t=e.getSource().getValue();if(t){this.model.setProperty("/subtreeExecutionContextId",t)}if(P.readPersistenceCookie(b.COOKIE_NAME)){this.persistExecutionScope()}},onScopeComponentSelect:function(e){var t=this.model.getProperty("/executionScopeComponents");if(P.readPersistenceCookie(b.COOKIE_NAME)){P.setSelectedScopeComponents(t)}},onBeforePopoverOpen:function(){if(this.model.getProperty("/executionScopeComponents").length===0){S.publish(R.GET_AVAILABLE_COMPONENTS)}},createNewRulePress:function(e){var t=this.model.getProperty("/newEmptyRule");this.model.setProperty("/selectedSetPreviewKey","availableRules");this.model.setProperty("/newRule",l({},t));this.model.setProperty("/tempLink",{href:"",text:""});this.goToCreateRule()},goToRuleProperties:function(){var e=this.byId("rulesNavContainer");e.to(this.byId("rulesDisplayPage"),"show")},createRuleString:function(e){if(!e){return""}var t="{\n",i=0,s=Object.keys(e).length;for(var o in e){var r=e[o];i++;t+="\t";t+=o+": ";if(o==="check"){t+=r.split("\n").join("\n\t")}else{t+=JSON.stringify(r)}if(i<s){t+=","}t+="\n"}t+="}";return t},updateRule:function(){var e=this.model.getProperty("/editRuleSource/id"),t=this.model.getProperty("/editRule");if(this.checkFunctionString(t.check)){S.publish(R.VERIFY_UPDATE_RULE,{oldId:e,updateObj:y.serialize(t)})}},updateSupportRules:function(e){e=y.deserialize(e.sRuleSet);S.publish(R.REQUEST_RULES_MODEL,e);var t=[],i=this;for(var s in e){var o=[],r=e[s].ruleset._mRules;for(var n in r){var l=r[n];l.libName=s;l.selected=true;o.push(l)}t.push({title:s,type:"library",rules:o,selected:true})}var u;if(t[0].rules[0]){u=t[0].rules[0]}else{u=t[1].rules[0]}i.placeTemporaryRulesetAtStart(t);i.model.setProperty("/selectedRuleStringify","");i.model.setProperty("/selectedRule",u);i.model.setProperty("/selectedRuleStringify",i.createRuleString(u));i.model.setProperty("/libraries",t);var a=i.model.getProperty("/loadingAdditionalRuleSets");if(a){h.show("Additional rule set(s) loaded!");this.ruleSetView.setSelectedKey("availableRules")}},initializeTempRules:function(){if(this.model.getProperty("/tempRulesDisabled")){return}var e=P.getRules(),t=this.model.getProperty("/loadingAdditionalRuleSets");if(e&&!t&&!this.tempRulesLoaded){this.tempRulesFromStorage=e;this.tempRulesLoaded=true;e.forEach(function(e){S.publish(R.VERIFY_CREATE_RULE,y.serialize(e))});this.persistedTempRulesCount=e.length}},placeTemporaryRulesetAtStart:function(e){for(var t=0;t<e.length;t++){var i=e[t];if(i.title===b.TEMP_RULESETS_NAME){var s=i;e.splice(t,1);e.unshift(s);return}}},addLinkToRule:function(e){var t=this.model.getProperty("/tempLink"),i=l({},t),s=e.getSource().getProperty("text"),o=s==="Add"?"/newRule":"/editRule",r=this.model.getProperty(o+"/resolutionurls");if(r){r.push(i)}else{this.model.setProperty(o+"/resolutionurls","");r.push(i)}this.model.setProperty("/tempLink",{href:"",text:""})},goToCreateRule:function(){var e=this.byId("rulesNavContainer");e.to(sap.ui.getCore().byId("rulesCreatePage"),"show")},checkFunctionString:function(e){try{E.evalFunction(e)}catch(e){h.show("Your check function contains errors, and can't be evaluated:"+e);return false}return true},addNewRule:function(){var e=this.model.getProperty("/newRule");if(this.checkFunctionString(e.check)){this.showRuleCreatedToast=true;S.publish(R.VERIFY_CREATE_RULE,y.serialize(e))}},rulesToolbarITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var t=this.model.getProperty("/newRule"),i=this.createRuleString(t);this.model.setProperty("/newRuleStringified",i)}},rulesToolbarEditITHSelect:function(e){if(e.getParameter("key")==="jsonOutput"){var t=this.model.getProperty("/editRule"),i=this.createRuleString(t);this.model.setProperty("/updateRuleStringified",i)}},loadMarkedSupportLibraries:function(){var e=this.byId("availableLibrariesSet"),t=[],i=this.model.getProperty("/availableLibrariesSet");t=e.getSelectedItems().map(function(e){return e.getTitle()});e.getItems().forEach(function(e){e.setSelected(false)});if(t.length>0){i=i.filter(function(e){return t.indexOf(e)<0});this.model.setProperty("/availableLibrariesSet",i);this.model.setProperty("/namesOfLoadedAdditionalRuleSets",t);S.publish(R.LOAD_RULESETS,{aLibNames:{publicRules:t,internalRules:t}});this.model.setProperty("/loadingAdditionalRuleSets",true);this.model.setProperty("/showRuleProperties",true)}else{h.show("Select additional RuleSet to be loaded.")}},onCellClick:function(e){if(e.getParameter("rowBindingContext")){var t=e.getParameter("rowBindingContext").getObject(),i,s="",o=false;if(t.id&&t.type!=="lib"){i=this.getMainModelFromTreeViewModel(t);s=this.createRuleString(i);o=true}this.model.setProperty("/selectedRuleStringify",s);this.model.setProperty("/selectedRule",i);this.model.setProperty("/showRuleProperties",o)}},onRowSelectionChange:function(e){if(e.getParameter("userInteraction")){r.syncCurrentSelectionPreset(o.getSelectedRules())}},getMainModelFromTreeViewModel:function(e){var t=this.model.getProperty("/libraries"),i=null;t.forEach(function(s,o){t[o].rules.forEach(function(t){if(e.id===t.id){i=t}})});return i},_generateRuleId:function(e){var t=0,i=this.getTemporaryLib(),s=i.rules,o,r=function(i){return i.id===e+t};while(++t){o=s.some(r);if(!o){return e+t}}},duplicateRule:function(e){var t=e.getSource().getBindingContext("ruleSets").getPath(),i=this.treeTable.getBinding().getModel().getProperty(t),s=this.getMainModelFromTreeViewModel(i),o=l({},s);o.id=this._generateRuleId(o.id);this.model.setProperty("/newRule",o);this.goToCreateRule()},editRule:function(e){var t=e.getSource().getBindingContext("ruleSets").getPath(),i=this.treeTable.getBinding().getModel().getProperty(t),s=this.getMainModelFromTreeViewModel(i);this.model.setProperty("/editRuleSource",s);this.model.setProperty("/editRule",l({},s));var o=this.byId("rulesNavContainer");o.to(sap.ui.getCore().byId("ruleUpdatePage"),"show")},deleteTemporaryRule:function(e){var t=this.getObjectOnTreeRow(e),i=l({},this._oRuleSetsModel.getData()),s=this.model.getProperty("/libraries"),n;s.forEach(function(e){if(e.title===b.TEMP_RULESETS_NAME){n=e.rules.filter(function(e){return e.id!==t.id});e.rules=n}});for(var u in i){if(i[u].name===b.TEMP_RULESETS_NAME){for(var a in i[u].nodes){if(i[u].nodes[a].id===t.id){i[u].nodes.splice(a,1)}}}}this._oRuleSetsModel.setData(i);S.publish(R.DELETE_RULE,y.serialize(t));this._updateRuleList();r.syncCurrentSelectionPreset(o.getSelectedRules());if(P.readPersistenceCookie(b.COOKIE_NAME)){P.removeSelectedRules(n);o.persistSelection()}},getObjectOnTreeRow:function(e){var t=e.getSource().getBindingContext("ruleSets").getPath(),i=this.treeTable.getBinding().getModel().getProperty(t),s=this.model.getProperty("/libraries");s.forEach(function(e,t){e.rules.forEach(function(e){if(e.id===i.id){i.check=e.check}})});return i},_updateRuleList:function(){var e=this.getView().byId("ruleList"),t=this.getTemporaryLib(),i=t?t["rules"]:[];if(!i.length){e.setRowActionCount(1)}else{e.setRowActionCount(2)}},setColumnVisibility:function(e,t){var i=this.treeTable.getColumns();i.forEach(function(i){i.setVisible(!t);e.forEach(function(e){if(i.sId.includes(e)){i.setVisible(t)}})})},onPresetVariantClick:function(){if(!this._PresetsController){this._PresetsController=new t(this.model,this.getView())}this._PresetsController.openPresetVariant()},_setTempRulesCommunicationSubscriptions:function(){S.subscribe(R.VERIFY_RULE_CREATE_RESULT,function(e){var t=e.result,i=y.deserialize(e.newRule,true),s=this.getTemporaryLib();if(t=="success"){s.rules.push(i);this.setTemporaryLib(s);this._applyTempRulesSelection(s);r.syncCurrentSelectionPreset(o.getSelectedRules());if(P.readPersistenceCookie(b.COOKIE_NAME)){o.persistSelection();P.setRules(s.rules);if(this.showRuleCreatedToast){h.show('Your temporary rule "'+i.id+'" was persisted in the local storage');this.showRuleCreatedToast=false}}var n=this.model.getProperty("/newEmptyRule");this.model.setProperty("/newRule",l({},n));this.goToRuleProperties();this.model.setProperty("/selectedRule",i);this._updateRuleList();this.treeTable.updateSelectionFromModel()}else{h.show("Add rule failed because: "+t)}},this);S.subscribe(R.VERIFY_RULE_UPDATE_RESULT,function(e){var t=e.result,i=y.deserialize(e.updateRule,true),s=this;if(t==="success"){var r=this.model.getProperty("/editRuleSource"),n=this._oRuleSetsModel.getData(),l=this.model.getProperty("/libraries");l.forEach(function(e,t){if(e.title===b.TEMP_RULESETS_NAME){e.rules.forEach(function(t,o){if(t.id===r.id){e.rules[o]=i;if(s.model.getProperty("/persistingSettings")){P.setRules(e.rules)}}});s._syncTreeTableVieModelTempRule(i,n)}});this._oRuleSetsModel.setData(n);this.model.setProperty("/selectedRule",i);o.getSelectedRules();this.treeTable.updateSelectionFromModel();this.goToRuleProperties()}else{h.show("Update rule failed because: "+t)}},this)},_associateTableColumnsMenu:function(){const e=s.getProperty("/columns");const t=new p({mode:c.ListMode.MultiSelect});t.setModel(s,"tableSettings");for(const i in e){if(e[i].visibilityConfigurable){t.addItem(new g({title:`{tableSettings>/columns/${i}/title}`,selected:{model:"tableSettings",path:`/columns/${i}/visible`,mode:a.OneWay}}))}}const i=new m("tableColumnMenu",{beforeOpen:function(){t.getItems().forEach(function(e){e.setSelected(e.getBinding("selected").getValue())})},items:[new f({label:"Columns",content:t,showResetButton:false,confirm:function(){t.getItems().forEach(function(e){s.setProperty(e.getBinding("selected").getPath(),e.getSelected())});if(this.model.getProperty("/persistingSettings")){this.persistVisibleColumns()}}.bind(this)})]});this.getView().addDependent(i);for(const t in e){this.byId(t+"Column").setHeaderMenu(i)}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/controllers/BaseController", ["sap/ui/core/mvc/Controller","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/ui/models/SelectionUtils"],function(e,t,s,o){"use strict";return e.extend("sap.ui.support.supportRules.ui.controllers.BaseController",{persistExecutionScope:function(){var e={analyzeContext:this.model.getProperty("/analyzeContext"),subtreeExecutionContextId:this.model.getProperty("/subtreeExecutionContextId")},s=this.model.getProperty("/executionScopeComponents");t.setSelectedScopeComponents(s);t.setSelectedContext(e)},persistVisibleColumns:function(){var e=[],s=o.treeTable.getColumns();s.forEach(function(t){if(t.getVisible()){e.push(t.sId)}});t.setVisibleColumns(e)},deletePersistedData:function(){t.deletePersistenceCookie(s.COOKIE_NAME);this.getView().getModel().setProperty("/persistingSettings",false);t.removeAllData()}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/controllers/Issues.controller", ["sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/formatter","sap/ui/support/supportRules/Constants","sap/m/OverflowToolbarAssociativePopoverControls","sap/base/util/deepExtend"],function(e,t,s,i,o,r,l,n,u){"use strict";var a={severityIcons:{High:"sap-icon://message-error",Medium:"sap-icon://message-warning",Low:"sap-icon://message-information",All:"sap-icon://multiselect-all"}};return e.extend("sap.ui.support.supportRules.ui.controllers.Issues",{ISSUES_LIMIT:1e3,formatter:r,onInit:function(){this.model=s;this.setCommunicationSubscriptions();this.getView().setModel(this.model);this.clearFilters();this._initElementTree();this.treeTable=this.byId("issuesList");this.issueTable=this.byId("issueTable");this.toolHeader=this.byId("toolHeader");this.toolHeader.removeStyleClass("sapTntToolHeader sapContrast sapContrastPlus");this.model.setProperty("/bEnabledFilterButton",false);var e=this.toolHeader._getPopover();e.removeStyleClass("sapTntToolHeaderPopover sapContrast sapContrastPlus");n._mSupportedControls["sap.ui.layout.VerticalLayout"]={canOverflow:true,listenForEvents:[],noInvalidationProps:[]}},setCommunicationSubscriptions:function(){t.subscribe(o.ON_ANALYZE_FINISH,function(e){var t=this;var s={};t.data=e;e.issues.forEach(function(e){if(!e.context||!e.context.id){return}if(!s[e.context.id]){s[e.context.id]=[e.name]}else{s[e.context.id].push(e.name)}});this.model.setSizeLimit(this.ISSUES_LIMIT);this.model.setProperty("/issues",e.issues);this.model.setProperty("/analyzePressed",true);this.model.setProperty("/issuesCount",this.data.issues.length);this.model.setProperty("/selectedIssue",null);this.elementTree.setData({controls:e.elementTree,issuesIds:s});this.clearFilters()},this);t.subscribe(o.GET_ISSUES,function(e){this.structuredIssuesModel=e.groupedIssues;this.model.setProperty("/issues",e.issuesModel);if(e.issuesModel[0]){this._setSelectedRule(e.issuesModel[0][0]);this.treeTable.setSelectedIndex(1);this.issueTable.setSelectedIndex(0)}},this)},_initElementTree:function(){var e=this;this.elementTree=new i(null,{onIssueCountClicked:function(t){e.clearFilters();e.model.setProperty("/elementFilter",t);e.updateIssuesVisibility()},onHoverChanged:function(e){t.publish(o.TREE_ELEMENT_MOUSE_ENTER,e)},onMouseOut:function(){t.publish(o.TREE_ELEMENT_MOUSE_OUT)}})},onAfterRendering:function(){this.elementTree.setContainerId(this.byId("elementTreeContainer").getId())},clearFilters:function(){this.model.setProperty("/severityFilter",l.FILTER_VALUE_ALL);this.model.setProperty("/categoryFilter",l.FILTER_VALUE_ALL);this.model.setProperty("/elementFilter",l.FILTER_VALUE_ALL);this.model.setProperty("/audienceFilter",l.FILTER_VALUE_ALL);if(this.data){this.model.setProperty("/issues",this.data.issues);this.setToolbarHeight()}this.model.setProperty("/bEnabledFilterButton",false);this.updateIssuesVisibility()},clearFiltersAndElementSelection:function(){this.clearFilters();this.elementTree.clearSelection()},onIssuePressed:function(e){var t=this.model.getProperty("/selectedIssue");this.elementTree.setSelectedElement(t.context.id,false)},onRowSelectionChanged:function(e){if(e.getParameter("rowContext")){var t=e.getParameter("rowContext").getObject(),s=l.MAX_VISIBLE_ISSUES_FOR_RULE;if(t.type==="rule"){this._setSelectedRule(t)}else{this.model.setProperty("/selectedIssue",null)}if(t.issueCount<s){s=t.issueCount}this.model.setProperty("/visibleRowCount",s)}},openDocumentation:function(e){var s=sap.ui.getCore().byId(e.mParameters.id),i=s.getBindingContext().getProperty("href");t.publish(o.OPEN_URL,i)},updateIssuesVisibility:function(){if(this.data){var e=this.data.issues.filter(this.filterIssueListItems,this);t.publish(o.REQUEST_ISSUES,e);this.model.setProperty("/visibleIssuesCount",e.length)}this.setToolbarHeight()},filterIssueListItems:function(e){var t=this.model.getProperty("/severityFilter"),s=e.severity===t||t===l.FILTER_VALUE_ALL,i=this.model.getProperty("/categoryFilter"),o=e.categories&&e.categories.indexOf(i)>-1||i===l.FILTER_VALUE_ALL,r=this.model.getProperty("/elementFilter"),n=r===e.context.id||r===l.FILTER_VALUE_ALL,u=this.model.getProperty("/audienceFilter"),a=e.audiences&&e.audiences.indexOf(u)>-1||u===l.FILTER_VALUE_ALL,d=t===l.FILTER_VALUE_ALL&&i===l.FILTER_VALUE_ALL&&u===l.FILTER_VALUE_ALL&&r===l.FILTER_VALUE_ALL;this.model.setProperty("/bEnabledFilterButton",!d);return s&&o&&n&&a},setToolbarHeight:function(){this.model.setProperty("/filterBarHeight","4rem")},onReportPress:function(e){var s=e.getParameter("item"),i=s.getText(),r=this._getReportData();if(i==="View"){t.publish(o.ON_SHOW_REPORT_REQUEST,r)}else{t.publish(o.ON_DOWNLOAD_REPORT_REQUEST,r)}},_getReportData:function(){return{executionScopes:this.model.getProperty("/executionScopes"),executionScopeTitle:this.model.getProperty("/executionScopeTitle"),analysisDurationTitle:this.model.getProperty("/analysisDurationTitle")}},onRowSelection:function(e){if(e.getParameter("rowContext")){var t=e.getParameter("rowContext").getObject();this.elementTree.setSelectedElement(t.context.id,false);this.model.setProperty("/selectedIssue/details",t.details)}},_setSelectedRule:function(e){var t,s;if(this.model.getProperty("/visibleIssuesCount")>0){t=this.structuredIssuesModel[e.ruleLibName][e.ruleId];s=u({},e);s.issues=t;s.resolutionUrls=t[0].resolutionUrls;this.issueTable.setSelectedIndex(0);this.model.setProperty("/selectedIssue/details",s.details);this.model.setProperty("/selectedIssue",s);this._setIconAndColorToIssue(s.issues)}else{this.model.setProperty("/selectedIssue",null)}},_setIconAndColorToIssue:function(e){e.forEach(function(e){switch(e.severity){case l.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:e.severityIcon=a.severityIcons.Low;e.severityColor=l.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR;break;case l.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:e.severityIcon=a.severityIcons.Medium;e.severityColor=l.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR;break;case l.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:e.severityIcon=a.severityIcons.High;e.severityColor=l.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR;break}})}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/controllers/Main.controller", ["./BaseController","../models/SharedModel","../models/Documentation","../models/SelectionUtils","../models/PresetsUtils","sap/ui/core/Fragment","sap/ui/core/mvc/XMLView","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/util/EvalUtils","sap/ui/VersionInfo","sap/m/library"],function(e,t,s,i,o,n,r,a,u,p,l,d,c,h){"use strict";var g=h.ButtonType;return e.extend("sap.ui.support.supportRules.ui.controllers.Main",{onInit:function(){this.model=t;this.getView().setModel(this.model);this.resizeDown();this.setCommunicationSubscriptions();this.initSettingsPopoverModel();this.hidden=false;this.model.setProperty("/hasNoOpener",window.opener?false:true);this.model.setProperty("/constants",p);this.updateShowButton();this._setContextSettings();this._zoomUI();this.bAdditionalViewLoaded=false;a.subscribe(u.UPDATE_SUPPORT_RULES,function(){if(!this.bAdditionalViewLoaded){this.bAdditionalViewLoaded=true;this.loadAdditionalUI()}},this)},_zoomUI:function(){try{var e=window.localStorage.getItem("support-assistant-zoom-ui");var t="100%";switch(e){case"S":t="90%";break;default:}document.querySelector("html").style.fontSize=t}catch(e){}},loadAdditionalUI:function(){r.create({id:this.getView().getId()+"--issues",viewName:"sap.ui.support.supportRules.ui.views.Issues"}).then(function(e){this.byId("navCon").insertPage(e)}.bind(this))},onAfterRendering:function(){c.load({library:"sap.ui.core"}).then(function(e){a.publish(u.POST_UI_INFORMATION,{version:e,location:new URL(sap.ui.require.toUrl("sap/ui/support"),window.location.origin+window.location.pathname).toString()})});this._checkTempRules()},initSettingsPopoverModel:function(){c.load().then(function(e){var t=new URL(sap.ui.require.toUrl("sap/ui/support"),window.location.origin+window.location.pathname).toString(),s=e.version;this.model.setProperty("/supportAssistantOrigin",t);this.model.setProperty("/supportAssistantVersion",s)}.bind(this))},copySupportAssistantOriginToClipboard:function(e){var t=this.model.getProperty("/supportAssistantOrigin"),s=function(e){if(e.clipboardData){e.clipboardData.setData("text/plain",t)}else{e.originalEvent.clipboardData.setData("text/plain",t)}e.preventDefault()};if(window.clipboardData){window.clipboardData.setData("text",t)}else{document.addEventListener("copy",s);document.execCommand("copy");document.removeEventListener("copy",s)}},setCommunicationSubscriptions:function(){var e;a.subscribe(u.CURRENT_LOADING_PROGRESS,function(t){var s=t.value,i=this.byId("progressIndicator");if(t.value<100){this.model.setProperty("/showProgressIndicator",true);clearTimeout(e);e=setTimeout(function(){this.model.setProperty("/showProgressIndicator",false)}.bind(this),2500)}else{setTimeout(function(){this.model.setProperty("/showProgressIndicator",false)}.bind(this),2e3)}i.setDisplayValue(p.RULESET_LOADING+" "+s+"%");this.model.setProperty("/progress",s)},this);a.subscribe(u.ON_ANALYZE_FINISH,function(e){this._clearProcessIndicator();this.ensureOpened();this.model.setProperty("/showProgressIndicator",false);this.model.setProperty("/coreStateChanged",false);this.model.setProperty("/lastAnalysisElapsedTime",e.elapsedTime);this.goToIssues();this.model.setProperty("/analyzedFinish",true)},this);a.subscribe(u.ON_PROGRESS_UPDATE,function(e){var t=e.currentProgress,s=this.byId("progressIndicator");s.setDisplayValue(t+"/"+100);this.model.setProperty("/progress",t)},this);a.subscribe(u.ON_CORE_STATE_CHANGE,function(){this.model.setProperty("/coreStateChanged",true)},this)},resizeUp:function(){a.publish(u.RESIZE_FRAME,{bigger:true})},ensureOpened:function(){a.publish(u.ENSURE_FRAME_OPENED)},resizeDown:function(){a.publish(u.RESIZE_FRAME,{bigger:false})},onSettings:function(e){a.publish(u.ENSURE_FRAME_OPENED);this._openSettingsPopover(e.getSource())},onPersistedSettingSelect:function(){if(this.model.getProperty("/persistingSettings")){l.createPersistenceCookie(p.COOKIE_NAME,true);this.model.getProperty("/libraries").forEach(function(e){if(e.title===p.TEMP_RULESETS_NAME){l.setRules(e.rules)}});this.persistExecutionScope();this.persistVisibleColumns();i.persistSelection();o.persistSelectionPresets();o.persistCustomPresets()}else{l.deletePersistenceCookie(p.COOKIE_NAME);this.deletePersistedData()}},onSettingsPopoverClose:function(){if(this.model.getProperty("/persistingSettings")&&!this.model.getProperty("/tempRulesDisabledWarned")){this.model.setProperty("/tempRulesDisabledWarned",true);l.markTempRulesDisabledWarned()}},goToAnalysis:function(e){this._setActiveView("analysis")},goToIssues:function(e){this._setActiveView("issues")},goToWiki:function(){s.openTopic("57ccd7d7103640e3a187ed55e1d2c163")},updateShowButton:function(){this.byId("sapSTShowButtonBar").setVisible(this.hidden)},toggleHide:function(){this.hidden=!this.hidden;this.updateShowButton();a.publish(u.TOGGLE_FRAME_HIDDEN,this.hidden)},_clearProcessIndicator:function(){var e=this.byId("progressIndicator");e.setDisplayValue("None");this.model.setProperty("/progress",.1)},_setContextSettings:function(){var e=l.readPersistenceCookie(p.COOKIE_NAME);if(e){this.model.setProperty("/persistingSettings",true);var t=l.getSelectedContext();if(t){this.model.setProperty("/analyzeContext",t.analyzeContext);this.model.setProperty("/subtreeExecutionContextId",t.subtreeExecutionContextId)}else{this.model.setProperty("/analyzeContext",this.model.getProperty("/analyzeContext"));this.model.setProperty("/subtreeExecutionContextId","")}}},_setActiveView:function(e){this.byId("issuesBtn").setType(g.Default);this.byId("analysisBtn").setType(g.Default);this.byId(e+"Btn").setType(g.Emphasized);this.byId("navCon").to(this.byId(e),"show");this.ensureOpened()},_checkTempRules:function(){if(!d.isEvalAllowed()&&!this.model.getProperty("/tempRulesDisabledWarned")){this._openSettingsPopover()}},_openSettingsPopover:function(){if(!this._settingsPopover){this._settingsPopover=n.load({name:"sap.ui.support.supportRules.ui.views.StorageSettings",controller:this}).then(function(e){this.getView().addDependent(e);return e}.bind(this))}this._settingsPopover.then(function(e){e.openBy(this.byId("settingsIcon"))}.bind(this))},_isSettingsPopoverOpen:function(){return this._settingsPopover&&this._settingsPopover.isOpen()}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/controllers/PresetsController", ["sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/support/supportRules/ui/models/SelectionUtils","sap/ui/support/supportRules/ui/models/PresetsUtils","sap/ui/core/Fragment","sap/m/MessageToast","sap/m/MessageBox","sap/ui/support/supportRules/ui/models/Documentation","sap/ui/support/supportRules/util/Utils","sap/m/GroupHeaderListItem","sap/base/util/deepExtend","sap/ui/core/library","sap/ui/core/date/UI5Date"],function(e,t,r,o,s,i,p,n,a,l,u,d){"use strict";var c=u.ValueState;var I={SELECT_FRAGMENT_ID:"presetsSelect",EXPORT_FRAGMENT_ID:"presetExport",IMPORT_FRAGMENT_ID:"presetImport",PRESET_GROUP_NONE:"None",PRESET_GROUP_SYSTEM:"System Presets",PRESET_GROUP_CUSTOM:"Custom Presets"};var P=e.extend("sap.ui.support.supportRules.ui.controllers.PresetsController",{constructor:function(t,r){e.call(this);this.oModel=t;this.oView=r}});P.prototype.openPresetVariant=function(){var e=this.oView.byId("presetVariantBtn");e.focus();if(!this._oPresetsPopover){this._oPresetsPopover=o.load({id:I.SELECT_FRAGMENT_ID,name:"sap.ui.support.supportRules.ui.views.Presets",controller:this}).then(function(e){this.oView.addDependent(e);return e}.bind(this))}this._oPresetsPopover.then(function(t){if(!t.isOpen()){t.setInitialFocus(o.byId(I.SELECT_FRAGMENT_ID,"select").getSelectedItem().getId());t.openBy(e)}else{t.close()}})};P.prototype.onPresetChange=function(e){var t=e.getParameter("listItem").getBindingContext().getPath();this._applyPreset(this.oModel.getProperty(t))};P.prototype.onPresetItemPress=function(){o.byId(I.SELECT_FRAGMENT_ID,"presetsPopover").close()};P.prototype.onPresetItemDelete=function(e){var t=e.getSource().getBindingContext().getPath(),o=this.oModel.getProperty(t),s=this.oModel.getProperty("/customPresets"),i=e.getSource().$().closest(".sapMLIB").attr("id");var p=this.oModel.getProperty("/selectionPresets");var n=p.indexOf(o);if(n!==-1){p.splice(n,1)}if(o.selected){p[0].selected=true;this._applyPreset(p[0])}this.oModel.setProperty("/selectionPresets",p);if(o.isCustomPreset){s=s.filter(function(e){return e.id!==o.id});this.oModel.setProperty("/customPresets",s)}if(r.isPersistingAllowed()){r.persistSelectionPresets();r.persistCustomPresets()}if(n!==p.length){var a=sap.ui.getCore().byId(i),l=a.ontap;a.ontap=function(){a.ontap=l}}};P.prototype.onPresetItemReset=function(e){var t=e.getSource().getBindingContext().getPath(),o=this.oModel.getProperty(t),s=o.isSystemPreset?r.getSystemPresets():this.oModel.getProperty("/customPresets"),i=e.getSource().getParent().getParent().getParent();i.focus();s.forEach(function(e){if(e.id===o.id){this.oModel.setProperty(t+"/title",e.title);this.oModel.setProperty(t+"/selections",e.selections);this.oModel.setProperty(t+"/isModified",false)}}.bind(this));if(o.selected){this._applyPreset(o)}};P.prototype.onImportPress=function(){if(!this._oImportDialog){this._oImportDialog=o.load({id:I.IMPORT_FRAGMENT_ID,name:"sap.ui.support.supportRules.ui.views.PresetImport",controller:this}).then(function(e){this.oView.addDependent(e);return e}.bind(this))}this._oImportDialog.then(function(e){e.open()})};P.prototype.onImportFileChange=function(e){var t=e.getSource(),r=new FileReader;if(!t.getValue()){return}this._clearImportErrors();r.onloadend=this.onImportFileLoaded.bind(this);r.onerror=this.onImportFileError.bind(this);r.readAsText(e.getParameter("files")[0],"UTF-8")};P.prototype.onImportFileMismatch=function(e){this._clearImportErrors();this._reportImportFileError('Invalid file type "'+e.getParameter("mimeType")+'". Please, import a valid "application/json" file.',e.getParameter("fileName"))};P.prototype.onImportFileError=function(e){this._reportImportFileError('Error while reading file: "'+e.target.error+'".')};P.prototype.onImportFileLoaded=function(e){var t=this._tryParseImportFile(e.target.result);if(t){this._clearImportErrors();if(!t.id){t.id=n.generateUuidV4()}if(t.dateExported){t.dateExported=d.getInstance(t.dateExported)}this.oModel.setProperty("/currentImportData",t);if(!this._isAlreadyImported(t.id)){o.byId(I.IMPORT_FRAGMENT_ID,"importBtn").setEnabled(true)}}};P.prototype.onImportCancelPress=function(){o.byId(I.IMPORT_FRAGMENT_ID,"importDialog").close()};P.prototype.onImportFinalizePress=function(){var e=this.oModel.getProperty("/currentImportData"),t="";this._importPreset(e);t='The Rule Preset "'+e.title+'" was successfully imported.';if(!r.isPersistingAllowed()){t+=" This import can be stored for your next visit if you check "+'"I agree to use local storage persistency" from Support Assistant settings.'}o.byId(I.IMPORT_FRAGMENT_ID,"importDialog").close();s.show(t,{width:"50%"})};P.prototype.onImportDialogClose=function(){this._clearImportErrors();o.byId(I.IMPORT_FRAGMENT_ID,"fileUpload").setValue(null);this.oModel.setProperty("/currentImportData",null);o.byId(I.IMPORT_FRAGMENT_ID,"importBtn").setEnabled(false)};P.prototype.onExportPress=function(){var e=this.oModel.getProperty("/selectionPresetsCurrent");if(!e.selections.length){i.error("Cannot export Rule Preset without selections.");return}this.oModel.setProperty("/currentExportData",{id:e.isMySelection||e.isSystemPreset?"":e.id,title:e.title,descriptionValue:e.description,dateExportedForDisplay:d.getInstance(),isMySelection:e.isMySelection});if(!this._oExportDialog){this._oExportDialog=o.load({id:I.EXPORT_FRAGMENT_ID,name:"sap.ui.support.supportRules.ui.views.PresetExport",controller:this}).then(function(e){this.oView.addDependent(e);return e}.bind(this))}this._oExportDialog.then(function(e){e.open()})};P.prototype.initializeExportValidations=function(){var e=this._getInputsToValidate();e.forEach(function(e){o.byId(I.EXPORT_FRAGMENT_ID,e.id).attachChange(function(t){this._changeHandler(t,e.validateMessage)}.bind(this))},this)};P.prototype._changeHandler=function(e,t){this._validateInput(e.getSource(),t)};P.prototype._validateForm=function(){var e=true,t=this._getInputsToValidate();t.forEach(function(t){var r=o.byId(I.EXPORT_FRAGMENT_ID,t.id);if(!this._validateInput(r,t.validateMessage)){e=false}},this);return e};P.prototype._validateInput=function(e,t){var r=e.getBinding("value"),o=c.None,s=true;try{if(e.getRequired()&&!e.getValue().trim()){throw{name:"RequiredException",message:e.getLabels()[0].getText()+" is required."}}if(r&&r.getType()){r.getType().validateValue(e.getValue())}}catch(r){var i=r.message;if(r.name==="ValidateException"&&t){i=t}e.setValueStateText(i);o=c.Error;s=false}e.setValueState(o);return s};P.prototype._getInputsToValidate=function(){return[{id:"title"},{id:"presetId",validateMessage:"Invalid value. Possible characters are: a-z A-Z 0-9 - . _"}]};P.prototype._clearValidationState=function(){var e=this._getInputsToValidate();e.forEach(function(e){o.byId(I.EXPORT_FRAGMENT_ID,e.id).setValueState(c.None)})};P.prototype.onExportCancelPress=function(){o.byId(I.EXPORT_FRAGMENT_ID,"exportDialog").close()};P.prototype.onExportFinalizePress=function(){var e=o.byId(I.EXPORT_FRAGMENT_ID,"presetId").getValue(),i=o.byId(I.EXPORT_FRAGMENT_ID,"title").getValue(),p=o.byId(I.EXPORT_FRAGMENT_ID,"description").getValue();if(!this._validateForm()){return}if(!e){e=n.generateUuidV4()}r.exportSelectionsToFile(e,i,p,t.getSelectedRules());s.show('The Rule Preset "'+i+'" was successfully exported.',{width:"50%"});o.byId(I.EXPORT_FRAGMENT_ID,"exportDialog").close()};P.prototype.openHelp=function(){p.openTopic("3fc864acf926406194744375aa464fe7")};P.prototype._reportImportFileError=function(e,t){var r=o.byId(I.IMPORT_FRAGMENT_ID,"fileError"),s=o.byId(I.IMPORT_FRAGMENT_ID,"fileUpload"),i=o.byId(I.IMPORT_FRAGMENT_ID,"fileName"),p=o.byId(I.IMPORT_FRAGMENT_ID,"importBtn");r.setText(e).setVisible(true);i.addStyleClass("sapUiSupportToolError");this.oModel.setProperty("/currentImportData",{fileName:t||s.getValue()});p.setEnabled(false)};P.prototype._isAlreadyImported=function(e){var t=this.oModel.getProperty("/selectionPresets"),r=t.some(function(t){return t.id===e});if(r){o.byId(I.IMPORT_FRAGMENT_ID,"duplicateIdError").setText("A preset with ID '"+e+"' is already imported.").setVisible(true);o.byId(I.IMPORT_FRAGMENT_ID,"presetId").addStyleClass("sapUiSupportToolError");return true}else{return false}};P.prototype._clearImportErrors=function(){o.byId(I.IMPORT_FRAGMENT_ID,"fileError").setText("").setVisible(false);o.byId(I.IMPORT_FRAGMENT_ID,"fileName").removeStyleClass("sapUiSupportToolError");o.byId(I.IMPORT_FRAGMENT_ID,"duplicateIdError").setText("").setVisible(false);o.byId(I.IMPORT_FRAGMENT_ID,"presetId").removeStyleClass("sapUiSupportToolError")};P.prototype._tryParseImportFile=function(e){var t={};var s='The file cannot be uploaded. Please, choose an "application/json" file exported from the Support Assistant.';try{t=JSON.parse(e)}catch(e){this._reportImportFileError(s);return false}var i=[];if(!r.isValidSelectionImport(t,i)){this._reportImportFileError(s);return false}t.fileName=o.byId(I.IMPORT_FRAGMENT_ID,"fileUpload").getValue();return t};P.prototype._importPreset=function(e){var t=this.oModel.getProperty("/selectionPresets"),o=this.oModel.getProperty("/customPresets");var s={id:e.id,title:e.title,description:e.description,dateExported:e.dateExported,version:e.version,selections:e.selections};t.forEach(function(e){e.selected=false});s.selected=true;s.isCustomPreset=true;t.push(s);o.push(l({},s));if(r.isPersistingAllowed()){r.persistCustomPresets()}this._applyPreset(s)};P.prototype._applyPreset=function(e){this.oModel.setProperty("/selectionPresetsCurrent",e);t.setSelectedRules(e.selections);if(r.isPersistingAllowed()){r.persistSelectionPresets()}};P.prototype.grouper=function(e){if(e.getProperty("isSystemPreset")){return I.PRESET_GROUP_SYSTEM}if(e.getProperty("isCustomPreset")){return I.PRESET_GROUP_CUSTOM}return I.PRESET_GROUP_NONE};P.prototype.getGroupHeader=function(e){var t=!(e.key===I.PRESET_GROUP_NONE);return new a({title:e.key,visible:t}).addStyleClass("sapUiSupportToolGHLI")};return P});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/external/ElementTree", ["sap/base/Log","sap/ui/thirdparty/jquery"],function(e,jQuery){"use strict";function t(e){return typeof e==="object"&&!Array.isArray(e)&&e!==null}function r(e){return"<ul "+e.attributes.join(" ")+">"}function n(){return"</ul>"}function i(e,t){var r='<li data-id="'+e.id+'" ';if(t){r+="issue"}r+=">";return r}function o(){return"</li>"}function s(e,t){var r='<offset data-indent="'+t+'" >';if(e.content.length>0){r+='<arrow down="true"></arrow>'}else{r+="<place-holder></place-holder>"}r+="</offset>";return r}function a(e,t){var r=e.name.split(".");var n=r[r.length-1];var i=e.name.replace(n,"");var o=t>0?"showNumbOfIssues":"hideNumbOfIssues";return'<tag data-search="'+e.name+e.id+'">'+"&#60;"+"<namespace>"+i+"</namespace>"+n+'<attribute>&#32;id="<attribute-value>'+e.id+'</attribute-value>"</attribute>'+"&#62;"+"</tag>"+"<span class = "+o+">["+t+"  issue(s)] </span>"}function u(e,t){while(e.nodeName!==t){if(e.nodeName==="CONTROL-TREE"){break}e=e.parentNode}return e}function l(e,r){var n=t(r);var i;if(n){i=r}else{i={}}this._ElementTreeContainer=document.getElementById(e);this.onIssueCountClicked=i.onIssueCountClicked?i.onIssueCountClicked:function(){};this.onSelectionChanged=i.onSelectionChanged?i.onSelectionChanged:function(e){};this.onContextMenu=i.onContextMenu?i.onContextMenu:function(e){};this.onHoverChanged=i.onHoverChanged?i.onHoverChanged:function(e){};this.onMouseOut=i.onMouseOut?i.onMouseOut:function(){};this.onInitialRendering=i.onInitialRendering?i.onInitialRendering:function(){};this.filterOptions=jQuery.extend({issues:true,namespaces:true,attributes:true,search:false},i.filter);this.setData(i.data)}l.prototype.init=function(){if(!this._ElementTreeContainer){return}this._createHTML();this._createHandlers();this.onInitialRendering()};l.prototype.getData=function(){return this._data};l.prototype.setData=function(r){var n=this.getData();var i=t(r);if(i===false){e.warning("The parameter should be an Object");return}if(JSON.stringify(n)===JSON.stringify(r)){return}this._data=r;if(this._isFirstRendering===undefined){this.init();this._isFirstRendering=true}else{this._createTree()}return this};l.prototype.setContainerId=function(e){this._ElementTreeContainer=document.getElementById(e);this.init()};l.prototype.getSelectedElement=function(){return this._selectedElement};l.prototype.setSelectedElement=function(t,r){var n;if(typeof t!=="string"){e.warning("Please use a valid string parameter");return}n=this._ElementTreeContainer.querySelector("[data-id='"+t+"']");if(n===null){e.warning("The selected element is not a child of the ElementTree");return}this._selectedElement=n;this._selectTreeElement(n,r);return this};l.prototype.clearSelection=function(){var e=this._ElementTreeContainer.querySelector("[selected]");if(e){e.removeAttribute("selected")}};l.prototype._createHTML=function(){var e;e=this._createFilter();e+=this._createTreeContainer();this._ElementTreeContainer.innerHTML=e;this._setReferences();if(this.getData()!==undefined){this._createTree()}};l.prototype._createFilter=function(){return"<filter>"+"<end>"+(this.filterOptions.search?'<input type="text" search placeholder="Search by ID or type">':"")+(this.filterOptions.search?'<label><input type="checkbox" filter>Filter results <results>(0)</results></label>':"")+(this.filterOptions.issues?'<label><input type="checkbox" issues checked>Issues</label>':"")+(this.filterOptions.namespaces?'<label><input type="checkbox" namespaces checked>Namespaces</label>':"")+(this.filterOptions.attributes?'<label><input type="checkbox" attributes>Attributes</label>':"")+"</end>"+"</filter>"};l.prototype._createTreeContainer=function(){return"<tree show-namespaces show-problematic-elements></tree>"};l.prototype._createTree=function(){var e=this.getData().controls;this._treeContainer.innerHTML=this._createTreeHTML(e);this._provideIndentation()};l.prototype._provideIndentation=function(){var e=this._treeContainer.getElementsByTagName("offset"),t,r;for(r=0;r<e.length;r++){t=e[r];if(t.dataset&&t.dataset.indent){t.style.paddingLeft=t.dataset.indent+"px"}}};l.prototype._createTreeHTML=function(e,t){if(e===undefined||e.length===0){return""}var u="";var l=t||0;var h=++l*10;var c=this;var f=this.getData().issuesIds;e.forEach(function(e){u+=r({attributes:['expanded="true"']});var t=f&&f[e.id]!==undefined?true:false;var p=t?f[e.id].length:0;u+=i({id:e.id},t);u+=s(e,h);u+=a(e,p);u+=o();u+=c._createTreeHTML(e.content,l);u+=n()});return u};l.prototype._toggleCollapse=function(e){var t=u(e.parentNode,"UL");if(e.getAttribute("right")==="true"){e.removeAttribute("right");e.setAttribute("down","true");t.setAttribute("expanded","true")}else if(e.getAttribute("down")==="true"){e.removeAttribute("down");t.removeAttribute("expanded");e.setAttribute("right","true")}};l.prototype._selectTreeElement=function(e,t){var r=u(e,"LI");var n=r.attributes["data-id"];if(!n){return}var i=n.value;if(i===this._ElementTreeContainer.id){return}this._scrollToElement(r,window);if(t){this.onSelectionChanged(i)}this.clearSelection();r.setAttribute("selected","true");if(t){this.onIssueCountClicked(i)}};l.prototype._scrollToElement=function(e,t){var r=this._treeContainer.offsetHeight-this._treeContainer.offsetTop+this._treeContainer.scrollTop;if(e.offsetTop>r||e.offsetTop<this._treeContainer.scrollTop){this._treeContainer.scrollTop=e.offsetTop-t.innerHeight/6}};l.prototype._searchInTree=function(e){var t=this._ElementTreeContainer.querySelectorAll("[data-search]");var r=e.toLocaleLowerCase();var n;for(var i=0;i<t.length;i++){n=t[i].getAttribute("data-search").toLocaleLowerCase();if(n.indexOf(r)!==-1){t[i].parentNode.setAttribute("matching",true)}else{t[i].parentNode.removeAttribute("matching")}}};l.prototype._removeAttributesFromSearch=function(){var e=this._treeContainer.querySelectorAll("[matching]");for(var t=0;t<e.length;t++){e[t].removeAttribute("matching")}};l.prototype._setSearchResultCount=function(e){this._filterContainer.querySelector("results").innerHTML="("+e+")"};l.prototype._onArrowClick=function(e){var t=jQuery(e.target);var r=t.prop("nodeName");if(r==="ARROW"){this._toggleCollapse(e.target)}else{this._selectTreeElement(e.target,true)}};l.prototype._onContextMenu=function(e){e.preventDefault();var t=jQuery(e.target).prop("nodeName");if(t!=="ARROW"){var r=u(e.target,"LI");var n=r.attributes["data-id"];if(n){this.clearSelection();r.setAttribute("selected","true");this.onContextMenu({domElementId:n.value,location:{x:e.pageX,y:e.pageY}})}}};l.prototype._onSearchInput=function(e){var t=e.target;var r;if(t.getAttribute("search")!==null){if(t.value.length!==0){this._searchInTree(t.value)}else{this._removeAttributesFromSearch("matching")}r=this._treeContainer.querySelectorAll("[matching]").length;this._setSearchResultCount(r)}};l.prototype._onSearchEvent=function(e){var t;if(e.target.value.length===0){this._removeAttributesFromSearch("matching");t=this._treeContainer.querySelectorAll("[matching]").length;this._setSearchResultCount(t)}};l.prototype._onOptionsChange=function(e){var t=e.target;if(t.getAttribute("filter")!==null){if(t.checked){this._treeContainer.setAttribute("show-filtered-elements",true)}else{this._treeContainer.removeAttribute("show-filtered-elements");var r=this._ElementTreeContainer.querySelector("[selected]");if(r){this._scrollToElement(r,window)}}}if(t.getAttribute("issues")!==null){if(t.checked){this._treeContainer.setAttribute("show-problematic-elements",true)}else{this._treeContainer.removeAttribute("show-problematic-elements")}}if(t.getAttribute("namespaces")!==null){if(t.checked){this._treeContainer.setAttribute("show-namespaces",true)}else{this._treeContainer.removeAttribute("show-namespaces")}}if(t.getAttribute("attributes")!==null){if(t.checked){this._treeContainer.setAttribute("show-attributes",true)}else{this._treeContainer.removeAttribute("show-attributes")}}};l.prototype._onTreeElementMouseHover=function(e){var t=u(e.target,"LI");var r=this._ElementTreeContainer.querySelector("[hover]");if(r){r.removeAttribute("hover")}t.setAttribute("hover","true");var n=t.attributes["data-id"];this.onHoverChanged(n&&n.value)};l.prototype._onTreeElementMouseOut=function(e){this.onMouseOut()};l.prototype._createHandlers=function(){this._treeContainer.onclick=this._onArrowClick.bind(this);this._treeContainer.oncontextmenu=this._onContextMenu.bind(this);this._filterContainer.onkeyup=this._onSearchInput.bind(this);this._filterContainer.onsearch=this._onSearchEvent.bind(this);this._filterContainer.onchange=this._onOptionsChange.bind(this);this._ElementTreeContainer.onmouseover=this._onTreeElementMouseHover.bind(this);this._ElementTreeContainer.onmouseout=this._onTreeElementMouseOut.bind(this)};l.prototype._setReferences=function(){this._filterContainer=this._ElementTreeContainer.querySelector("filter");this._treeContainer=this._ElementTreeContainer.querySelector("tree")};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/external/Highlighter", [],function(){"use strict";var t=function(t){this._sId=t;this._highLighter=document.getElementById(this._sId)||null};t.prototype.highlight=function(t){if(this._highLighter){this.showHighLighter()}else{this._createHighLighter()}var e=this._highLighter.firstElementChild;var i=document.getElementById(t);if(i){var h=i.getBoundingClientRect();e.style.top=h.top+"px";e.style.left=h.left+"px";e.style.height=h.height+"px";e.style.width=h.width+"px"}return this};t.prototype.hideHighLighter=function(){this._highLighter.style.display="none"};t.prototype.showHighLighter=function(){this._highLighter.style.display="block"};t.prototype._createHighLighter=function(){var t=document.createElement("div");t.style.cssText="box-sizing: border-box;border:1px solid blue;background: rgba(20, 20, 200, 0.4);position: absolute";var e=document.createElement("div");e.id=this._sId;e.style.cssText="position: fixed;top:0;right:0;bottom:0;left:0;z-index: 1000;overflow: hidden;";e.appendChild(t);document.body.appendChild(e);e.onmousemove=this.hideHighLighter.bind(this);this._highLighter=e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/models/CustomJSONListSelection", ["./CustomListSelection","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/ui/models/SelectionUtils","sap/ui/support/supportRules/Constants"],function(e,t,i,n){"use strict";var o=e.extend("sap.ui.support.supportRules.ui.models.CustomJSONListSelection",{constructor:function(t,i,n){e.call(this,t,n);this._dependent=i},_updateModelAfterSelectionChange:function(e){var o=this._getBinding();var s=o.getModel();var r=e.getParameter("rowIndices")||[];var l=this._getSelectionModel();var a=this;function u(e,t,i){var n=s.getProperty(e+"/nodes");if(a._isTree()&&a._dependent){if(n&&n.length){for(var o=0;o<n.length;o++){u(e+"/nodes/"+o+"",t,true);a.updateModelAfterChangedSelection(s,e,t)}}else{if(!t&&!i){var r=e.split("/");r.pop();r.pop();var l=r.join("/");a._setSelectionForContext(s,s.createBindingContext(l),t)}}}a.updateModelAfterChangedSelection(s,e,t);a._setSelectionForContext(s,s.createBindingContext(e),t)}for(var d=0;d<r.length;d++){var p=this._getContextByIndex(r[d]);if(p){u(p.getPath(),l.isSelectedIndex(r[d]))}}this.syncParentNodeSelectionWithChildren(o.getModel("ruleSets"));this._finalizeSelectionUpdate();i.getSelectedRules();if(t.readPersistenceCookie(n.COOKIE_NAME)){i.persistSelection();var c=t.getRules();i.getRulesSelectionState().forEach(function(e){if(e.libName==="temporary"){c.forEach(function(t){if(e.ruleId===t.id){t.selected=e.selected}})}});t.setRules(c)}}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/models/CustomListSelection", ["sap/base/util/deepExtend","sap/ui/base/EventProvider","sap/ui/model/SelectionModel"],function(e,t,n){"use strict";function i(e,t){if(!e||!t){return false}var n=sap.ui.require(t);return!!(n&&e instanceof n)}var o={isIndexSelected:function(e){return this._isSelectedInModel(e)},setSelectedIndex:function(e){},getSelectedIndices:function(){return[]},setSelectionInterval:function(e,t){this._doChangeSelection("setSelectionInterval",arguments)},addSelectionInterval:function(e,t){this._doChangeSelection("addSelectionInterval",arguments)},removeSelectionInterval:function(e,t){this._doChangeSelection("removeSelectionInterval",arguments)},selectAll:function(){this._doChangeSelection("selectAll",[this._getBinding().getLength()-1])},getSelectedIndex:function(){return this._getSelectionModel().getLeadSelectedIndex()},clearSelection:function(){if(this._ignoreClearSelection){this._initializeSelectionModel();return}this._doChangeSelection("clearSelection",arguments)},_getSelectedIndicesCount:function(){return this._getSelectionModel().getSelectedIndices().length},_initializeSelectionModel:function(){return this._initializeSelectionModel()},updateSelectionFromModel:function(){return this.updateSelectionFromModel()},syncParentNodeSelectionWithChildren:function(e){return this.syncParentNodeSelectionWithChildren(e)}};function l(e,t){return function(){return o[e].apply(t,arguments)}}var r=t.extend("sap.ui.support.supportRules.ui.models.CustomListSelection",{constructor:function(e,n){t.call(this);var r=this;this._keys={};this._key=n;this._control=e;this._UITable=i(this._control,"sap/ui/table/Table");this._tree=i(this._control,"sap/ui/table/TreeTable")||i(this._control,"sap/m/Tree");if(this._UITable){this._aggregation="rows";for(var s in o){this._control[s]=l(s,this)}this._control.__onBindingChange=this._control._onBindingChange;this._control._onBindingChange=function(e){r._ignoreClearSelection=true;this.__onBindingChange.apply(this,arguments);if(e.getParameter("reason")!=="filter"&&e.getParameter("reason")!=="sort"){r._ignoreClearSelection=false}};this.attachEvent("selectionChange",function(e){r._getControl()._onSelectionChanged(e)})}else{this._aggregation="items";this._control.attachSelectionChange(function(t){var n=r._getSelectionModel();var i=t.getParameter("listItems");var o=[];for(var l=0;l<i.length;l++){var s=i[l].getSelected();var c=e.indexOfItem(i[l]);o.push(c);if(s){n.addSelectionInterval(c,c)}else{n.removeSelectionInterval(c,c)}}var t=r.oEventPool.borrowObject("selectionChanged",r,{rowIndices:o});r._updateModelAfterSelectionChange(t);r.oEventPool.returnObject(t);r._initializeSelectionModel()});this._control.attachUpdateFinished(function(){r._getSelectionModel(true)});this._doAfterInitSelectionModel=function(){var e=this._getControl().getItems();for(var t=0;t<e.length;t++){e[t].setSelected(this._isSelectedInModel(t),true)}}}if(this._isTree()){e.attachToggleOpenState(function(){r._getSelectionModel(true)})}},attachRowSelectionChange:function(e){this.attachEvent("selectionChange",e)},getSelectedKeys:function(){var e=[];for(var t in this._keys){if(this._keys[t]){e.push(t)}}return e},_getControl:function(){return this._control},_isUITable:function(){return this._UITable},_isTree:function(){return this._tree},_getBinding:function(){return this._getControl().getBinding(this._aggregation)},_getContextByIndex:function(e){return this._getBinding().getContexts(e,1,undefined,true)[0]},_getSelectionModel:function(e){if(!this.selectionmodel||e){this._initializeSelectionModel()}return this.selectionmodel},_getSelectedIndicesFromModel:function(){var e=this._getBinding();var t=[];if(e){var n=e.getModel();var i=e.getLength();for(var o=0;o<i;o++){var l=this._getContextByIndex(o);if(!l){return t}if(this._checkSelectionForContext(n,l)){t.push(o)}}}return t},_updateModelAfterSelectionChange:function(e){},updateSelectionFromModel:function(){var e=this._getBinding();var t=e.getModel();var n=t.getData();var i=this._getAllIndicesInModel();var o=this;function l(e,i,r){var s=t.getProperty(e+"/nodes");if(o._isTree()&&o._dependent){if(s&&s.length){for(var c=0;c<s.length;c++){var a=e.split("");l(e+"/nodes/"+c+"",t.getData()[a[1]].nodes[c].selected,true)}}else{var a=e.split("/");o.bTempSelected=true;a.pop();a.pop();var d=a.join("/"),h=d.split("/");if(n[h[1]]){o.bTempSelected=n[h[1]].selected}o._setSelectionForContext(t,t.createBindingContext(d),o.bTempSelected)}}o._setSelectionForContext(t,t.createBindingContext(e),i)}for(var r=0;r<i.length;r++){var s=this._getContextByIndex(i[r]),c=s.getPath(),a=c.split("/"),d=true;if(a[2]){if(n[a[1]].nodes[a[3]]){d=n[a[1]].nodes[a[3]].selected}}else{d=n[a[1]].selected}l(c,d)}this._finalizeSelectionUpdate()},_getAllIndicesInModel:function(){var e=this._getBinding();var t=[];if(e){var n=e.getLength();for(var i=0;i<n;i++){t.push(i)}}return t},_isSelectedInModel:function(e){var t=this._getBinding();var n=t?t.getLength():0;if(!t||e>=n){return false}return this._checkSelectionForContext(t.getModel(),this._getContextByIndex(e))},_finalizeSelectionUpdate:function(){this._initializeSelectionModel();this._getSelectionModel();this._fireRowSelectionChange()},_checkSelectionForContext:function(e,t){var n;if(this._key==="$PATH"){n=t.getPath()}else{n=e.getProperty(this._key,t)}return!!this._keys[n]},_setSelectionForContext:function(e,t,n){var i;if(this._key==="$PATH"){i=t.getPath()}else{i=e.getProperty(this._key,t)}if(n){this._keys[i]=true}else{delete this._keys[i]}},_initializeSelectionModel:function(){if(!this.selectionmodel){this.selectionmodel=new n(n.MULTI_SELECTION)}else{this.selectionmodel.clearSelection()}var e=this._getSelectedIndicesFromModel();for(var t=0;t<e.length;t++){this.selectionmodel.addSelectionInterval(e[t],e[t])}if(this._doAfterInitSelectionModel){this._doAfterInitSelectionModel()}},_doUpdateModelAfterSelectionChange:function(e){this._getSelectionModel().detachSelectionChanged(this._doUpdateModelAfterSelectionChange,this);this._updateModelAfterSelectionChange(e)},_doChangeSelection:function(e,t){var n=this._getSelectionModel();n.attachSelectionChanged(this._doUpdateModelAfterSelectionChange,this);n[e].apply(n,t)},_fireRowSelectionChange:function(){this.fireEvent("selectionChange",{selectedKeys:this.getSelectedKeys()})},syncParentNodeSelectionWithChildren:function(t){var n=e({},t.getData());Object.keys(n).forEach(function(e){var t=true;n[e].nodes.forEach(function(i){if(!i.selected){t=false;n[e].selected=false}else if(t){n[e].selected=true}})});t.setData(n)},updateModelAfterChangedSelection:function(e,t,n){var i=t.split("/"),o=i[1];if(i[2]){if(e.getProperty("/"+o+"/nodes")!==0){e.setProperty("/"+o+"/nodes/"+i[3]+"/selected",n)}}else{e.setProperty("/"+o+"/selected",n)}}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/models/Documentation", ["sap/base/Log","sap/base/util/Version","sap/ui/thirdparty/jquery","sap/m/library","sap/ui/VersionInfo"],function(i,t,jQuery,n,r){"use strict";var e={openTopic:function(i){r.load({library:"sap.ui.core"}).then(function(n){var r="",e="",o=n.version,a=t(o).getMajor(),s=t(o).getMinor(),u=window.location.origin;if(s%2!==0){s--}e+=String(a)+"."+String(s);if(u.indexOf("veui5infra")!==-1){r=u+"/sapui5-sdk-internal/#/topic/"+i}else{r=u+"/demokit-"+e+"/#/topic/"+i}this._redirectToUrlWithFallback(r,i)}.bind(this))},_redirectToUrlWithFallback:function(t,r){this._pingUrl(t).then(function i(){n.URLHelper.redirect(t,true)},function e(){i.info("Support Assistant tried to load documentation link in "+t+"but fail");t="https://ui5.sap.com/#/topic/"+r;n.URLHelper.redirect(t,true)})},_pingUrl:function(i){return jQuery.ajax({type:"HEAD",async:true,context:this,url:i})}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/models/PresetsUtils", ["sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/ui/models/SelectionUtils","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/core/util/File","sap/base/util/extend","sap/ui/support/library","sap/ui/core/date/UI5Date"],function(e,t,s,i,r,o,n,l){"use strict";var u={model:i,getSystemPresets:function(){var e=[],t;for(t in n.SystemPresets){e.push(n.SystemPresets[t])}return e},initializeSelectionPresets:function(t){if(this.model.getProperty("/persistingSettings")){var i=e.getSelectionPresets();if(i){this.model.setProperty("/selectionPresets",i)}}var r=this.model.getProperty("/selectionPresets"),n=0;this.getSystemPresets().forEach(function(e){var t=r.some(function(t){if(e.id===t.id){if(!t.isModified){var i=t.selected;t=o({},e);t.selected=i;if(i){s.setSelectedRules(t.selections)}}return true}});if(!t){var i={disableDelete:true,isSystemPreset:true};r.splice(n+1,0,o(i,e))}n++});var l=null;r.some(function(e){if(e.selected){l=e;return true}});if(l.isMySelection){l.selections=t}this.model.setProperty("/selectionPresetsCurrent",l)},syncCurrentSelectionPreset:function(e){var t=this.model.getProperty("/selectionPresetsCurrent");t.selections=e;if(!(t.isModified||t.isMySelection)){t.isModified=true;t.title=t.title+" *"}this.model.setProperty("/selectionPresetsCurrent",t);if(u.isPersistingAllowed()){u.persistSelectionPresets()}},exportSelectionsToFile:function(e,s,i,o){var n={id:e,title:s,description:i,dateExported:l.getInstance().toISOString(),version:"1.0",selections:o};var u=JSON.stringify(n);r.save(u,t.RULE_SELECTION_EXPORT_FILE_NAME,"json","text/plain")},isValidSelectionImport:function(e){var t=true;if(!e.hasOwnProperty("title")){t=false}if(!e.hasOwnProperty("selections")){t=false}else if(!Array.isArray(e.selections)){t=false}else{for(var s=0;s<e.selections.length;s++){var i=e.selections[s];if(!i.hasOwnProperty("ruleId")||!i.hasOwnProperty("libName")){t=false;break}}}return t},persistSelectionPresets:function(){e.setSelectionPresets(this.model.getProperty("/selectionPresets"))},persistCustomPresets:function(){e.setCustomPresets(this.model.getProperty("/customPresets"))},isPersistingAllowed:function(){return!!e.readPersistenceCookie(t.COOKIE_NAME)},loadCustomPresets:function(){var t=e.getCustomPresets();if(t){this.model.setProperty("/customPresets",t)}}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/models/SelectionUtils", ["sap/base/util/deepExtend","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/ui/models/SharedModel"],function(e,t,n,s){"use strict";var i={model:s,getRulesSelectionState:function(){var e=this.treeTable.getBinding().getModel(),t=e.getData(),n=[];Object.keys(t).forEach(function(e){t[e].nodes.forEach(function(e){n.push({ruleId:e.id,selected:e.selected,libName:e.libName})})});return n},getSelectedRules:function(){var e=this.treeTable.getBinding().getModel(),t=e.getData(),n=[];if(!t){return}Object.keys(t).forEach(function(e){t[e].nodes.forEach(function(e){if(e.selected){n.push({ruleId:e.id,libName:e.libName})}})});this.model.setProperty("/selectedRulesCount",n.length);return n},updateSelectedRulesFromLocalStorage:function(e){var t=n.getSelectedRules();if(!t){return null}if(!e){return null}t.forEach(function(t){Object.keys(e).forEach(function(n){e[n].nodes.forEach(function(s){if(s.id===t.ruleId){s.selected=t.selected;if(!s.selected){e[n].selected=false}}})})});return e},persistSelection:function(){var e=this.getRulesSelectionState();n.setSelectedRules(e)},setSelectedRules:function(s){var i=e({},this.treeTable.getModel("ruleSets").getData());Object.keys(i).forEach(function(e){i[e].nodes.forEach(function(e){e.selected=false})});s.forEach(function(e){Object.keys(i).forEach(function(t){i[t].nodes.forEach(function(t){if(t.id===e.ruleId){t.selected=true}})})});this.treeTable.getModel("ruleSets").setData(i);this.treeTable.syncParentNodeSelectionWithChildren(this.treeTable.getModel("ruleSets"));this.treeTable.updateSelectionFromModel();this.getSelectedRules();if(n.readPersistenceCookie(t.COOKIE_NAME)){this.persistSelection()}},_syncSelectionAdditionalRuleSetsMainModel:function(e,t){Object.keys(e).forEach(function(n){Object.keys(t).forEach(function(n){if(e[n].id===t[n].id){e[n]=t[n]}})})},_deselectAdditionalRuleSets:function(e,t){if(!t){return}t.forEach(function(t){Object.keys(e).forEach(function(n){if(e[n].name===t){e[n].selected=false;e[n].nodes.forEach(function(e){e.selected=false})}})})}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/models/SharedModel", ["sap/ui/support/library","sap/ui/support/supportRules/Storage","sap/ui/support/supportRules/util/EvalUtils","sap/ui/model/json/JSONModel"],function(e,t,s,l){"use strict";var i=e.Audiences,n=e.Categories,o=e.Severity,a={global:{key:"global",displayName:"Global",description:"The Rules will be / are executed on the complete application with all loaded elements and components, including all previously loaded pages"},subtree:{key:"subtree",displayName:"Sub-tree",description:"The Rules will be / are executed on the specified sub-tree root element, including all child elements (aggregated sub-elements)"},components:{key:"components",displayName:"Component(s)",description:"The Rules will be / are executed on the selected components from the list of currently loaded components (or fragments)"}};var r=new l({selectedRule:null,libraries:null,selectedIssue:null,issues:[],progress:.1,showProgressIndicator:false,coreStateChanged:true,analyzePressed:false,selectedRulePreviewKey:"ruleProperties",selectedRuleCreateKey:"ruleProperties",selectedRuleEditKey:"ruleProperties",selectedSetPreviewKey:"availableRules",newRule:{},newRuleStringified:"",updateRuleStringified:"",subtreeExecutionContextId:"",availableComponents:[],audiences:i,categories:n,severities:o,audiencesFilter:["All"].concat(Object.keys(i)),categoriesFilter:["All"].concat(Object.keys(n)),severitiesFilter:["All"].concat(Object.keys(o)),newEmptyRule:{libName:"",id:"",categories:[n.Other],audiences:[i.Internal],title:"",description:"",resolution:"",resolutionurls:[],check:"function (oIssueManager, oCoreFacade, oScope) {\n\t/* \n\t oIssueManager - allows you to add new issues with the addIssue() method \n\t oCoreFacade - gives you access to state of the core: getMetadata(), getUIAreas(), getComponents(), getModels() \n\t oScope - retrieves elements in the scope with these methods: getElements(), getElementsByClassName(className), getLoggedObjects(type) \n\t fnResolve - optional, passed when the rule property async is set to true \n\t*/ \n}",selected:true,async:false},editRule:null,tempLink:{href:"",text:""},resolveDescription:"Make sure to resolve your async rule by using the passed fnResolve function",selectedRuleStringify:"",analyzeContext:a.global,executionScopes:a,executionScopeTitle:"Execution scope",lastAnalysisElapsedTime:"",analysisDurationTitle:"Last analysis duration",constants:"",executionScopeComponents:[],persistingSettings:false,loadingAdditionalRuleSets:false,analyzedFinish:false,selectedRules:true,filteredIssues:null,issuesCount:0,selectedRulesCount:0,visibleRowCount:5,supportAssistantOrigin:"",supportAssistantVersion:"",initialRulesLoading:true,selectionPresets:[{id:"MySelectionPreset",title:"My Selection",description:"My Current/Last Selection",isMySelection:true,selected:true,disableDelete:true}],customPresets:[],selectionPresetsCurrent:null,tempRulesDisabled:!s.isEvalAllowed(),tempRulesDisabledWarned:!!t.getTempRulesDisabledWarned()});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/models/TableSettingsModel", ["sap/ui/model/json/JSONModel"],function(i){"use strict";return new i({columns:{rules:{title:"Rules",visible:true,visibilityConfigurable:false},categories:{title:"Categories",visible:true,visibilityConfigurable:true},audience:{title:"Audience",visible:false,visibilityConfigurable:true},ruleId:{title:"RuleID",visible:false,visibilityConfigurable:true}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/ui/models/formatter", ["sap/ui/support/supportRules/Constants"],function(e){"use strict";return{resolutionUrl:function(e,t){var n=e.indexOf(t)===e.length-1?"":",  ";return t.text+n},hasResolutionUrls:function(e){if(e&&e.length>0){return true}return false},filteredText:function(t,n,r,u){var i="Filtered by: ";i+=t===e.FILTER_VALUE_ALL?"":"Severity - "+t+";";i+=n===e.FILTER_VALUE_ALL?"":" Category    - "+n+";";i+=r===e.FILTER_VALUE_ALL?"":" Audience - "+r+";";i+=u===e.FILTER_VALUE_ALL?"":" Control Element - "+u+";";return i}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/util/RuleValidator", [],function(){"use strict";var t={validateVersion:function(t){if(!t||typeof t!=="string"){return false}var e=/^\*$|^\-$|^\d\.\d+$/;if(t.match(e)){return true}return false},validateRuleCollection:function(t,e){if(t&&Array.isArray(t)&&t.length){for(var r=0;r<t.length;r++){if(e.hasOwnProperty(t[r])){continue}else{return false}}return true}return false},validateId:function(t){var e=/^[a-z][a-zA-Z]+$/;if(!t||typeof t!=="string"){return false}if(t.match(e)&&this.validateStringLength(t,6,50)){return true}return false},validateStringLength:function(t,e,r){return e<=t.length&&t.length<=r}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/util/StringAnalyzer", [],function(){"use strict";var r={calculateLevenshteinDistance:function(r,a){var n=r.length;var e=a.length;if(n===0){return e}if(e===0){return n}var t=new Array(e+1);var v;for(v=0;v<=e;v++){t[v]=new Array(n+1);t[v][0]=v}var i;for(i=0;i<=n;i++){t[0][i]=i}var f=0;var u;var c;for(u=1;u<=e;u++){for(c=1;c<=n;c++){var o=t[u-1][c]+1;var s=t[u][c-1]+1;var h=t[u-1][c-1];if(r[c]!==a[u]){h+=1}f=Math.min(o,s,h);t[u][c]=f}}return f}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/support/supportRules/util/Utils", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var n=sap.ui.require.toUrl("sap/ui/support").replace(/(^|\/)resources\//,"$1test-resources/")+"/internal/.ping";var e={bCanLoadInternalRules:null,isDistributionOpenUI5:function(n){var e=false,a="";try{a=n.gav?n.gav:n.name;e=a.indexOf("openui5")!==-1?true:false}catch(n){return e}return e},canLoadInternalRules:function(){var e=this;if(e.bCanLoadInternalRules!==null){return e.bCanLoadInternalRules}jQuery.ajax({type:"HEAD",async:false,url:n,success:function(){e.bCanLoadInternalRules=true},error:function(){e.bCanLoadInternalRules=false}});return e.bCanLoadInternalRules},canLoadInternalRulesAsync:function(){var e=this;var a=new Promise(function(a){if(e.bCanLoadInternalRules!==null){a(e.bCanLoadInternalRules);return}jQuery.ajax({type:"HEAD",url:n,success:function(){e.bCanLoadInternalRules=true;a(e.bCanLoadInternalRules)},error:function(){e.bCanLoadInternalRules=false;a(e.bCanLoadInternalRules)}})});return a},generateUuidV4:function(){var n="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(n){var e=Math.random()*16|0;if(n==="y"){e=e&3|8}return e.toString(16)});return n}};return e});
sap.ui.require.preload({
	"sap/ui/support/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.support","type":"library","embeds":[],"applicationVersion":{"version":"1.120.10"},"title":"UI5 library: sap.ui.support","description":"UI5 library: sap.ui.support","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":[]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.10"}}},"library":{"i18n":false,"css":false,"content":{"controls":[],"elements":[],"types":["sap.ui.support.Severity"],"interfaces":[]}}}}',
	"sap/ui/support/supportRules/report/resources/index.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
window.sapUiSupportReport=window.sapUiSupportReport||{};window.sapUiSupportReport.collapseExpand=function(){"use strict";function e(e){var t=this.getAttribute("data-expandableElement");var a=document.getElementById(t);var i=a.classList.contains("collapsed");if(i){a.classList.remove("collapsed");a.classList.add("expanded");this.classList.remove("collapsed-content");this.classList.add("expanded-content")}else{a.classList.remove("expanded");a.classList.add("collapsed");this.classList.remove("expanded-content");this.classList.add("collapsed-content")}}function t(){try{var t=document.getElementsByClassName("expandable-control");if(!t){return}for(var a=0;a<t.length;a++){t[a].addEventListener("click",e);var i=t[a].getAttribute("data-expandableElement");var r=document.getElementById(i);if(t[a].classList.contains("collapsed-content")){r.classList.add("collapsed")}else{r.classList.add("expanded")}}}catch(e){console.log("There was a problem initializing collapse/expand functionality.")}}return{init:t}}();window.sapUiSupportReport=window.sapUiSupportReport||{};window.sapUiSupportReport.filter=function(){"use strict";function e(){var e=document.querySelectorAll("[data-groupName]");for(var t=0;t<e.length;t++){var a=e[t];var i=a.getAttribute("data-expandableElement");var r=a.getAttribute("data-groupName");var s=a.getAttribute("data-groupNumber");var l=document.querySelectorAll("#"+i+" > tr");var n=0;var o=0;for(var c=0;c<l.length;c++){var d=l[c];var p=d.querySelectorAll("tr.filterable:not(.filtered)");var u=p.length;if(u===0){d.classList.add("filtered")}else{o++;n+=u;d.querySelector("span.rule-issue-number").innerText="("+u+" issues)"}}if(o===0){a.classList.add("filtered")}else{a.classList.remove("filtered");a.querySelector("span").innerText=" "+s+". "+r+" ("+o+" rules, "+n+" issues)"}}}function t(e){if(e.classList.contains("filter-active")){return}var t=document.getElementsByClassName("filter-active");for(var a=0;a<t.length;a++){t[a].classList.remove("filter-active")}e.classList.add("filter-active")}function a(){var e=document.querySelectorAll(".filtered");for(var t=0;t<e.length;t++){e[t].classList.remove("filtered")}}function i(e){a();if(e==="Total"){return}var t=document.querySelectorAll('.filterable:not([data-severity="'+e+'"])');for(var i=0;i<t.length;i++){t[i].classList.add("filtered")}}function r(a){t(this);var r=this.getAttribute("data-severity");i(r);e()}function s(){try{var e=document.getElementsByClassName("filter");if(!e){return}for(var t=0;t<e.length;t++){if(e[t].classList.contains("filter-initialized")){continue}e[t].addEventListener("click",r);e[t].classList.add("filter-initialized")}}catch(e){console.log("There was a problem initializing filters.")}}return{init:s}}();window.sapUiSupportReport.collapseExpand.init();window.sapUiSupportReport.filter.init();
},
	"sap/ui/support/supportRules/ui/views/Analysis.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.support.supportRules.ui.controllers.Analysis"\n\t\theight="100%"\n\t\txmlns="sap.ui.table"\n\t\txmlns:m="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:t="sap.ui.table"\n\t\txmlns:layout="sap.ui.layout"><m:NavContainer\n\t\t\tid="rulesNavContainer"\n\t\t\tautoFocus="{= ${/tempRulesDisabled} === ${/tempRulesDisabledWarned} }"><l:Splitter id="rulesDisplayPage"><l:contentAreas><m:Page\n\t\t\t\t\t\tshowHeader="true"\n\t\t\t\t\t\tshowSubHeader="{= ${/selectedSetPreviewKey} === \'availableRules\' }"><m:headerContent><m:Bar><m:contentMiddle><m:HBox fitContainer="true" renderType="Bare" class="customHBox"><m:items><m:IconTabHeader\n\t\t\t\t\t\t\t\t\t\t\t\tid="ruleSetsView"\n\t\t\t\t\t\t\t\t\t\t\t\tselect="onSelectedRuleSets"\n\t\t\t\t\t\t\t\t\t\t\t\tselectedKey="{/selectedSetPreviewKey}"\n\t\t\t\t\t\t\t\t\t\t\t\tclass="customIconTabHeader"><m:layoutData><m:FlexItemData growFactor="1" minWidth="0"></m:FlexItemData></m:layoutData><m:items><m:IconTabFilter id="availableRulesId" key="availableRules" text="Available Rulesets" /><m:IconTabFilter key="additionalRulesets" text="Additional Rulesets" /></m:items></m:IconTabHeader><m:Button class="supportAnalyzeButton" text="Analyze" press="onAnalyze" type="Emphasized"/><m:Button class="supportSettingsButton" icon="sap-icon://settings" press="onAnalyzeSettings" type="Emphasized"/></m:items></m:HBox></m:contentMiddle></m:Bar></m:headerContent><m:subHeader><m:Bar><m:contentLeft><m:HBox renderType="Bare" width="100%"><m:Label text="Rule Preset:" labelFor="presetVariant" class="presetVariantLabel"><m:layoutData><m:FlexItemData shrinkFactor="0" /></m:layoutData></m:Label><m:HBox id="presetVariant" class="sapUiSupportToolVariantCont" renderType="Bare"><m:layoutData><m:FlexItemData growFactor="1" minWidth="0"/></m:layoutData><m:FormattedText\n\t\t\t\t\t\t\t\t\t\t\t\tid="presetVariantTxt"\n\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSupportToolVariantTxt"\n\t\t\t\t\t\t\t\t\t\t\t\thtmlText="{= ${/selectionPresetsCurrent/isModified} ?\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\'&lt;em&gt;\' + ${/selectionPresetsCurrent/title} + \'&lt;/em&gt;\' :\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t${/selectionPresetsCurrent/title} }"\n\t\t\t\t\t\t\t\t\t\t\t\ttooltip="Select a Rule Preset"></m:FormattedText><m:Button\n\t\t\t\t\t\t\t\t\t\t\t\tid="presetVariantBtn"\n\t\t\t\t\t\t\t\t\t\t\t\ticon="sap-icon://slim-arrow-down"\n\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSupportToolVariantBtn"\n\t\t\t\t\t\t\t\t\t\t\t\ttooltip="Select a Rule Preset"><m:layoutData><m:FlexItemData shrinkFactor="0" /></m:layoutData></m:Button></m:HBox></m:HBox></m:contentLeft><m:contentRight><m:Button\n\t\t\t\t\t\t\t\t\t\tid="createRuleBtn"\n\t\t\t\t\t\t\t\t\t\ttext="Create Rule"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://add"\n\t\t\t\t\t\t\t\t\t\tvisible="{= !${/tempRulesDisabled}}"\n\t\t\t\t\t\t\t\t\t\tpress="createNewRulePress"/></m:contentRight></m:Bar></m:subHeader><t:TreeTable\n\t\t\t\t\t\t\t\tid="ruleList"\n\t\t\t\t\t\t\t\tselectionMode="MultiToggle"\n\t\t\t\t\t\t\t\trows="{\n\t\t\t\t\t\t\t\t\tpath: \'ruleSets>/\',\n\t\t\t\t\t\t\t\t\tparameters: {numberOfExpandedLevels: 1}\n\t\t\t\t\t\t\t\t}"\n\t\t\t\t\t\t\t\tenableColumnReordering="false"\n\t\t\t\t\t\t\t\tclass="sapUiSizeCondensed"\n\t\t\t\t\t\t\t\trowMode="Auto"\n\t\t\t\t\t\t\t\tselectionBehavior="RowSelector"\n\t\t\t\t\t\t\t\trowActionCount="1"\n\t\t\t\t\t\t\t\tvisible="{= ${/selectedSetPreviewKey} === \'availableRules\' }"\n\t\t\t\t\t\t\t\tcellClick="onCellClick"\n\t\t\t\t\t\t\t\trowSelectionChange="onRowSelectionChange"\n\t\t\t\t\t\t\t\t><t:columns><t:Column id="rulesColumn"\n\t\t\t\t\t\t\t\t\t\t  sortProperty="name"\n\t\t\t\t\t\t\t\t\t\t  filterProperty="name"\n\t\t\t\t\t\t\t\t\t\t  visible="{tableSettings>/columns/rules/visible}"><m:Label text="Rules ({/selectedRulesCount} selected)"/><t:template><m:Text text="{ruleSets>name}" wrapping="false"/></t:template></t:Column><t:Column id="categoriesColumn"\n\t\t\t\t\t\t\t\t\t\t  width="10rem"\n\t\t\t\t\t\t\t\t\t\t  sortProperty="categories"\n\t\t\t\t\t\t\t\t\t\t  filterProperty="categories"\n\t\t\t\t\t\t\t\t\t\t  visible="{tableSettings>/columns/categories/visible}"><m:Label text="{tableSettings>/columns/categories/title}"/><t:template><m:Text text="{ruleSets>categories}" wrapping="false"/></t:template></t:Column><t:Column id="audienceColumn"\n\t\t\t\t\t\t\t\t\t\t  sortProperty="audiences"\n\t\t\t\t\t\t\t\t\t\t  filterProperty="audiences"\n\t\t\t\t\t\t\t\t\t\t  visible="{tableSettings>/columns/audience/visible}"><m:Label text="{tableSettings>/columns/audience/title}"/><t:template><m:Text text="{ruleSets>audiences}" wrapping="false"/></t:template></t:Column><t:Column id="ruleIdColumn"\n\t\t\t\t\t\t\t\t\t\t  width="10rem"\n\t\t\t\t\t\t\t\t\t\t  sortProperty="id"\n\t\t\t\t\t\t\t\t\t\t  filterProperty="id"\n\t\t\t\t\t\t\t\t\t\t  visible="{tableSettings>/columns/ruleId/visible}"><m:Label text="{tableSettings>/columns/ruleId/title}"/><t:template><m:Text text="{ruleSets>id}" wrapping="false"/></t:template></t:Column></t:columns><t:rowActionTemplate><t:RowAction id="rowActionTemplate"><t:items><t:RowActionItem icon="sap-icon://edit" text="Edit" press="editRule"  visible="{= ${ruleSets>libName} === \'temporary\'}" /><t:RowActionItem icon="sap-icon://delete" text="Delete" press="deleteTemporaryRule" visible="{= ${ruleSets>libName} === \'temporary\'}" /><t:RowActionItem icon="sap-icon://copy" text="Copy" press="duplicateRule" visible="{= !${/tempRulesDisabled} &amp;&amp; ${ruleSets>libName} !== \'temporary\' &amp;&amp; ${ruleSets>type} !== \'lib\'}" /></t:items></t:RowAction></t:rowActionTemplate></t:TreeTable><l:VerticalLayout id="librarySetContainer" width="100%" visible="{= ${/selectedSetPreviewKey} === \'additionalRulesets\' }"><m:Text class="sapUiSupportToolAdditionRuleSetNote" text="The list of available rules is dynamic and changes based on the libraries currently required by your application.\n\t\t\t\t\t\t\t\tIn the table below, you can select and load rulesets from the additional libraries."/><m:Link class="sapUiSupportToolAdditionRuleSetNote" text="See more here" href="https://ui5.sap.com/#/topic/3fc864acf926406194744375aa464fe7" target="_blank"/><m:List\n\t\t\t\t\t\t\tid="availableLibrariesSet"\n\t\t\t\t\t\t\tmode = "MultiSelect"\n\t\t\t\t\t\t\tincludeItemInSelection= "true"\n\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\tpath: \'/availableLibrariesSet\'\n\t\t\t\t\t\t\t}"><m:StandardListItem\n\t\t\t\t\t\t\t\ttitle="{}"/></m:List><m:Button class="customMargin" text="Load" type="Emphasized" press="loadMarkedSupportLibraries" /></l:VerticalLayout></m:Page></l:contentAreas></l:Splitter></m:NavContainer></mvc:View>\n',
	"sap/ui/support/supportRules/ui/views/AnalyzeSettings.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:l="sap.ui.layout"\n\txmlns:core="sap.ui.core"><Popover\n\t\ttitle="{/executionScopeTitle}"\n\t\tcontentMinWidth="250px"\n\t\tclass="sapUiContentPadding"\n\t\tbeforeOpen="onBeforePopoverOpen"\n\t\tplacement="Bottom"><content><VBox><RadioButton groupName="analyzeContext"\n\t\t\t\t\t\t\t text="{/executionScopes/global/displayName}"\n\t\t\t\t\t\t\t select="onContextSelect"\n\t\t\t\t\t\t\t selected="{= ${/analyzeContext/key} === \'global\'}"\n\t\t\t\t\t\t\t tooltip="{/executionScopes/global/description}"><customData><core:CustomData key="analyzeContext" value="global" /></customData></RadioButton><RadioButton groupName="analyzeContext"\n\t\t\t\t\t\t\t text="{/executionScopes/subtree/displayName}"\n\t\t\t\t\t\t\t select="onContextSelect"\n\t\t\t\t\t\t\t selected="{= ${/analyzeContext/key} === \'subtree\'}"\n\t\t\t\t\t\t\t tooltip="{/executionScopes/subtree/description}"><customData><core:CustomData key="analyzeContext" value="subtree" /></customData></RadioButton><l:VerticalLayout\n\t\t\t\t\tclass="sapUiSupportToolSettingsPopoverPadding"><Input\n\t\t\t\t\t\tplaceholder="Input sub-root ID"\n\t\t\t\t\t\tenabled="{= ${/analyzeContext/key} === \'subtree\'}"\n\t\t\t\t\t\tvalue="{/subtreeExecutionContextId}"\n\t\t\t\t\t\twidth="300px"\n\t\t\t\t\t\tliveChange="onExecutionContextChange"/></l:VerticalLayout><RadioButton groupName="analyzeContext"\n\t\t\t\t\t\t\t text="{/executionScopes/components/displayName}"\n\t\t\t\t\t\t\t select="onContextSelect"\n\t\t\t\t\t\t\t selected="{= ${/analyzeContext/key} === \'components\'}"\n\t\t\t\t\t\t\t tooltip="{/executionScopes/components/description}"><customData><core:CustomData key="analyzeContext" value="components" /></customData></RadioButton><l:VerticalLayout\n\t\t\t\t\tid="componentsSelectionContainer"\n\t\t\t\t\tcontent="{/executionScopeComponents}"\n\t\t\t\t\tclass="sapUiSupportToolSettingsPopoverPadding"><CheckBox text="{text}"\n\t\t\t\t\t\t\t  enabled="{= ${/analyzeContext/key} === \'components\'}"\n\t\t\t\t\t\t\t  select="onScopeComponentSelect"\n\t\t\t\t\t\t\t  selected="{selected}"\n\t\t\t\t\t/></l:VerticalLayout></VBox></content></Popover></core:FragmentDefinition>\n',
	"sap/ui/support/supportRules/ui/views/Issues.view.xml":'<mvc:View\n\txmlns="sap.m"\n\tcontrollerName="sap.ui.support.supportRules.ui.controllers.Issues"\n\theight="100%"\n\txmlns:l="sap.ui.layout"\n\txmlns:tnt="sap.tnt"\n\txmlns:c="sap.ui.core"\n\txmlns:f="sap.ui.layout.form"\n\txmlns:t="sap.ui.table"\n\txmlns:trm="sap.ui.table.rowmodes"\n\txmlns:mvc="sap.ui.core.mvc"><l:Splitter><l:contentAreas><Page class="sapUiSupportToolIssuesPage"><customHeader><Toolbar id="filtersBar" height="{/filterBarHeight}" class="sapUiSupportToolToolbar"><tnt:ToolHeader id="toolHeader" class="sapUiSupportToolIssueHeader" height="4rem"  width="100%"><l:VerticalLayout><l:layoutData><OverflowToolbarLayoutData priority="Low" /></l:layoutData><Label text="Severity:" class="customMargin" /><Select id=\'severityFilter\'\n\t\t\t\t\t\t\t\t\t\t\tchange="updateIssuesVisibility"\n\t\t\t\t\t\t\t\t\t\t\tselectedKey="{/severityFilter}"\n\t\t\t\t\t\t\t\t\t\t\titems="{/severitiesFilter}"\n\t\t\t\t\t\t\t\t\t\t\tclass="customMargin" ><c:ListItem key="{}" text="{}" /></Select></l:VerticalLayout><l:VerticalLayout><l:layoutData><OverflowToolbarLayoutData priority="Low" /></l:layoutData><Label text="Category:" class="customMargin" /><Select id=\'categoryFilter\'\n\t\t\t\t\t\t\t\t\t\t\tchange="updateIssuesVisibility"\n\t\t\t\t\t\t\t\t\t\t\tselectedKey="{/categoryFilter}"\n\t\t\t\t\t\t\t\t\t\t\titems="{/categoriesFilter}"\n\t\t\t\t\t\t\t\t\t\t\tclass="customMargin"><c:ListItem key="{}" text="{}" /></Select></l:VerticalLayout><l:VerticalLayout><l:layoutData><OverflowToolbarLayoutData priority="Low" /></l:layoutData><Label text="Audiences:" class="customMargin" /><Select id=\'audiencesFilter\'\n\t\t\t\t\t\t\t\t\t\t\tchange="updateIssuesVisibility"\n\t\t\t\t\t\t\t\t\t\t\tselectedKey="{/audienceFilter}"\n\t\t\t\t\t\t\t\t\t\t\titems="{/audiencesFilter}"\n\t\t\t\t\t\t\t\t\t\t\tclass="customMargin" ><c:ListItem key="{}" text="{}" /></Select></l:VerticalLayout><l:VerticalLayout><l:layoutData><OverflowToolbarLayoutData priority="Low" /></l:layoutData><Label text="" class="customMargin" /></l:VerticalLayout><ToolbarSpacer /></tnt:ToolHeader><l:VerticalLayout><Label text="" class="customMargin" /><MenuButton id=\'ReportMenuButton\' text="Report" icon="sap-icon://order-status" visible="{= ${/analyzePressed}}"><menu><Menu itemSelected="onReportPress"><items><MenuItem text="View" /><MenuItem text="Download" /></items></Menu></menu></MenuButton></l:VerticalLayout></Toolbar></customHeader><subHeader><Toolbar\n\t\t\t\t\t\tid="messegeStrip"><FlexBox\n\t\t\t\t\t\t\talignItems="Center"\n\t\t\t\t\t\t\tjustifyContent="Start"><items><l:VerticalLayout><Text  text="{= \'Displaying: \' + ${/visibleIssuesCount} + \' out of \' + ${/issuesCount} + \' (scope: \' + ${/analyzeContext/displayName} + \')\' }"/></l:VerticalLayout></items></FlexBox></Toolbar></subHeader><content><FlexBox\n\t\t\t\t\t\talignItems="Center"\n\t\t\t\t\t\tjustifyContent="End"><items><Text text="{\n\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\'/severityFilter\',\n\t\t\t\t\t\t\t\t\'/categoryFilter\',\n\t\t\t\t\t\t\t\t\'/audienceFilter\',\n\t\t\t\t\t\t\t\t\'/elementFilter\'\n\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\tformatter: \'.formatter.filteredText\'\n\t\t\t\t\t\t\t\t}"><layoutData><FlexItemData growFactor="2" /></layoutData></Text><Button icon="sap-icon://clear-filter"  press="clearFiltersAndElementSelection" enabled="{/bEnabledFilterButton}"><layoutData><FlexItemData growFactor="0" /></layoutData></Button></items></FlexBox><t:TreeTable\n\t\t\t\t\t\t\tid="issuesList"\n\t\t\t\t\t\t\tclass="sapUiSupportToolIssuesTreeTable"\n\t\t\t\t\t\t\tselectionMode="Single"\n\t\t\t\t\t\t\tselectionBehavior="RowOnly"\n\t\t\t\t\t\t\tenableColumnReordering="false"\n\t\t\t\t\t\t\trows="{path: \'/issues\'}"\n\t\t\t\t\t\t\trowSelectionChange="onRowSelectionChanged"><t:rowMode><trm:Auto rowContentHeight="24"/></t:rowMode><t:columns><t:Column resizable="false"><Label text="Issues"/><t:template><FormattedText htmlText="{formattedName}"/></t:template></t:Column></t:columns></t:TreeTable></content></Page><Page enableScrolling="false"><customHeader><Bar class="selectedRuleTitle"><contentLeft><Title text="{/selectedIssue/name}"/></contentLeft></Bar></customHeader><content><Panel visible="{= ${/selectedIssue} !== null}" height="100%"><Text text="{/selectedIssue/description}" class="sapUiTinyMarginBeginEnd sapUiTinyMarginBottom" /><t:Table\n\t\t\t\t\t\t\trows="{path: \'/selectedIssue/issues\'}"\n\t\t\t\t\t\t\tselectionMode="Single"\n\t\t\t\t\t\t\tselectionBehavior="RowOnly"\n\t\t\t\t\t\t\tenableColumnReordering="false"\n\t\t\t\t\t\t\trowSelectionChange="onRowSelection"\n\t\t\t\t\t\t\tid="issueTable"><t:rowMode><trm:Fixed rowContentHeight="24" rowCount="{/visibleRowCount}"/></t:rowMode><t:columns><t:Column\n\t\t\t\t\t\t\t\t\twidth="36px"\n\t\t\t\t\t\t\t\t\tresizable="false"><t:template><c:Icon class="issuesSeverityIcon"\n\t\t\t\t\t\t\t\t\t\t\t\tcolor="{severityColor}"\n\t\t\t\t\t\t\t\t\t\t\t\tsrc="{severityIcon}"><c:layoutData><FlexItemData growFactor="1" /></c:layoutData></c:Icon></t:template></t:Column><t:Column\n\t\t\t\t\t\t\t\t\tsortProperty="context/id"\n\t\t\t\t\t\t\t\t\tfilterProperty="context/id"\n\t\t\t\t\t\t\t\t\tresizable="false"><Label text="Control Id"/><t:template><Text text="{context/id}" wrapping="false" tooltip="{context/id}"></Text></t:template></t:Column><t:Column\n\t\t\t\t\t\t\t\t\tsortProperty="context/className"\n\t\t\t\t\t\t\t\t\tfilterProperty="context/className"\n\t\t\t\t\t\t\t\t\tresizable="false"><Label text="Class name"/><t:template><Text text="{context/className}" wrapping="false" tooltip="{context/className}"></Text></t:template></t:Column></t:columns></t:Table><f:Form\n\t\t\t\t\t\t\teditable="true"\n\t\t\t\t\t\t\tvisible="{= ${/visibleIssuesCount} > 0}"><f:layout><f:ColumnLayout /></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement label="Details"><f:fields><Text\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{/selectedIssue/details}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{= ${/selectedIssue/details} !== \'\'}"/></f:fields></f:FormElement><f:FormElement label="Resolution"><f:fields><Text text="{/selectedIssue/resolution}" /></f:fields></f:FormElement><f:FormElement label="URLs"\n\t\t\t\t\t\t\t\t\t\t\t\t\t   visible="{\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\'/selectedIssue/resolutionUrls\'\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatter.hasResolutionUrls\'\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t   fields="{/selectedIssue/resolutionUrls}"><f:fields><Link text="{\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tparts: [\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\'/selectedIssue/resolutionUrls\',\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\'\'\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatter.resolutionUrl\'\n\t\t\t\t\t\t\t\t\t\t\t\t\t}" press="openDocumentation"><layoutData><f:ColumnElementData cellsLarge="8" cellsSmall="12" /></layoutData></Link></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form></Panel></content></Page><c:HTML id="elementTreeContainer" content=\'&lt;control-tree&gt;  &lt;/control-tree&gt;\'></c:HTML></l:contentAreas></l:Splitter></mvc:View>\n',
	"sap/ui/support/supportRules/ui/views/Main.view.xml":'<mvc:View\n\t\theight="100%"\n\t\tviewName="sap.ui.support.supportRules.ui.views.Main"\n\t\tcontrollerName="sap.ui.support.supportRules.ui.controllers.Main"\n\t\txmlns="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:c= "sap.ui.core"><Page showHeader="false"><l:FixFlex><l:fixContent><Bar class="sapContrast" design="SubHeader" id="sapSTShowButtonBar"><contentMiddle><Text text="{/constants/SUPPORT_ASSISTANT_NAME}" class="STCustomHeaderInfo" /><c:Icon src="sap-icon://full-screen" press="toggleHide" class="STCustomHeaderInfo" /></contentMiddle></Bar><Bar id="supportAssistantHeader" class="sapContrast" design="SubHeader"><contentLeft><Image src="../ui/images/Logo_O_22x22.png" densityAware="false"></Image><Text text="{/constants/SUPPORT_ASSISTANT_NAME}" class="STCustomHeaderInfo" /></contentLeft><contentMiddle><FlexBox\n\t\t\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\t\t\twidth="500px"\n\t\t\t\t\t\t\t\talignItems="Center"\n\t\t\t\t\t\t\t\tjustifyContent="Center"><ProgressIndicator\n\t\t\t\t\t\t\t\t\tid="progressIndicator"\n\t\t\t\t\t\t\t\t\tpercentValue="{/progress}"\n\t\t\t\t\t\t\t\t\tdisplayValue="None"\n\t\t\t\t\t\t\t\t\tshowValue="true"\n\t\t\t\t\t\t\t\t\tstate="Success"\n\t\t\t\t\t\t\t\t\tvisible="{/showProgressIndicator}"><layoutData><FlexItemData growFactor="1" /></layoutData></ProgressIndicator><Text\tid="coreStateLabel"\n\t\t\t\t\t\t\t\t\tvisible="{= ${/analyzePressed} === true &amp;&amp; ${/coreStateChanged} === true &amp;&amp; ${/showProgressIndicator} === false }"\n\t\t\t\t\t\t\t\t\ttext=\'Application state has changed and issues view is not in sync. Analyze again. \'></Text><Text\tid="elapsedTimeLabel"\n\t\t\t\t\t\t\t\t\tvisible="{= ${/analyzePressed} === true &amp;&amp; ${/coreStateChanged} === false &amp;&amp; ${/showProgressIndicator} === false }"\n\t\t\t\t\t\t\t\t\ttext=\'{/analysisDurationTitle}: {/lastAnalysisElapsedTime}\'></Text><Text      id="persistingSettingLbl"\n\t\t\t\t\t\t\t\t\t visible="{= ${/persistingSettings} === true &amp;&amp;  ${/analyzePressed} === false &amp;&amp; ${/showProgressIndicator} === false }"\n\t\t\t\t\t\t\t\t\t text=\'There are settings persisted from your previous session\'></Text></FlexBox></contentMiddle><contentRight><Toolbar\n\t\t\t\t\t\t\tid="navToolbar"><Button id="issuesBtn" text="Issues ({/issuesCount})" enabled="{= ${/analyzedFinish} === true}" press="goToIssues"/><Button id="analysisBtn" text="Rules ({/selectedRulesCount})" press="goToAnalysis" type="Emphasized"/><c:Icon id="settingsIcon" src="sap-icon://settings" press="onSettings" class="STCustomHeaderInfo STHelpIcon sapUiTinyMargin"/><c:Icon src="sap-icon://sys-help" press="goToWiki" class="STCustomHeaderInfo STHelpIcon sapUiTinyMargin" tooltip="Open Documentation" /><c:Icon src="sap-icon://minimize" press="toggleHide" class="STCustomHeaderInfo sapUiTinyMargin" visible="{/hasNoOpener}"/><Button icon="sap-icon://down" press="resizeDown"  visible="{/hasNoOpener}"/><Button icon="sap-icon://up" press="resizeUp"  visible="{/hasNoOpener}"/></Toolbar></contentRight></Bar></l:fixContent><l:flexContent><NavContainer id="navCon"><mvc:XMLView id="analysis" viewName="sap.ui.support.supportRules.ui.views.Analysis" async="true"></mvc:XMLView></NavContainer></l:flexContent></l:FixFlex></Page></mvc:View>\n',
	"sap/ui/support/supportRules/ui/views/PresetExport.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:f="sap.ui.layout.form"><Dialog\n\t\tid="exportDialog"\n\t\ttitle="Export a Rule Preset"\n\t\tresizable="true"\n\t\tcontentWidth="550px"\n\t\tcontentHeight="250px"><f:SimpleForm\n\t\t\teditable="true"\n\t\t\tbinding="{/currentExportData}"\n\t\t\tlayout="ResponsiveGridLayout"\n\t\t\tlabelSpanXL="3"\n\t\t\tlabelSpanL="3"\n\t\t\tlabelSpanM="3"\n\t\t\tlabelSpanS="3"><f:content><Label text="Title" labelFor="title" class="sapUiTinyMarginBottom" /><Input id="title" required="true" value="{title}" maxLength="80" class="sapUiTinyMarginBottom" valueState="None" valueLiveUpdate="true"/><Label text="ID" labelFor="presetId" class="sapUiTinyMarginBottom" /><Input\n\t\t\t\t\tid="presetId"\n\t\t\t\t\tmaxLength="50"\n\t\t\t\t\tvalueState="None"\n\t\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\t\tplaceholder="Enter a custom ID or a system one will be generated"\n\t\t\t\t\tvalue="{\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\ttype: \'sap.ui.model.type.String\',\n\t\t\t\t\t\tconstraints: {\n\t\t\t\t\t\t\tsearch: \'^[a-zA-Z0-9\\\\.\\\\-\\\\_]*$\'\n\t\t\t\t\t\t}\n\t\t\t\t\t}"/><Label text="Description" labelFor="description" class="sapUiTinyMarginBottom" /><TextArea id="description" width="100%" value="{descriptionValue}" class="sapUiTinyMarginBottom" /><Label text="Date" labelFor="dateExportedForDisplay" class="sapUiTinyMarginBottom" /><Text\n\t\t\t\t\tid="dateExportedForDisplay"\n\t\t\t\t\ttext="{\n\t\t\t\t\t\tpath: \'dateExportedForDisplay\',\n\t\t\t\t\t\ttype: \'sap.ui.model.type.DateTime\',\n\t\t\t\t\t\tformatOptions: {\n\t\t\t\t\t\t\tstyle: \'medium\'\n\t\t\t\t\t\t}\n\t\t\t\t\t}"\n\t\t\t\t\tclass="sapUiTinyMarginBottom" /></f:content></f:SimpleForm><beginButton><Button id="cancel" text="Cancel" press="onExportCancelPress" /></beginButton><endButton><Button id="exportBtn" text="Export" type="Emphasized" press="onExportFinalizePress" class="sapUiTinyMarginEnd" /></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/support/supportRules/ui/views/PresetImport.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:f="sap.ui.layout.form"\n\txmlns:l="sap.ui.layout"\n\txmlns:unified="sap.ui.unified"><Dialog\n\t\tid="importDialog"\n\t\ttitle="Import a Rule Preset"\n\t\tbeforeClose="onImportDialogClose"\n\t\tresizable="true"\n\t\tcontentWidth="650px"\n\t\tcontentHeight="400px"><f:SimpleForm\n\t\t\teditable="false"\n\t\t\tbinding="{/currentImportData}"\n\t\t\tlayout="ResponsiveGridLayout"\n\t\t\tlabelSpanXL="4"\n\t\t\tlabelSpanL="4"\n\t\t\tlabelSpanM="4"\n\t\t\tlabelSpanS="4"><f:content><Label text="Choose file" labelFor="fileUpload" class="sapUiTinyMarginTopBottom" /><unified:FileUploader\n\t\t\t\t\tid="fileUpload"\n\t\t\t\t\tbuttonOnly="true"\n\t\t\t\t\tbuttonText="Browse ..."\n\t\t\t\t\tchange="onImportFileChange"\n\t\t\t\t\ttypeMissmatch="onImportFileMismatch"\n\t\t\t\t\tfileType="json"\n\t\t\t\t\tmimeType="application/json"\n\t\t\t\t\tclass="sapUiTinyMarginBottom"></unified:FileUploader><Label text="File" labelFor="fileName" class="sapUiTinyMarginBottom" /><VBox class="sapUiTinyMarginBottom"><HBox><Text id="fileName" text="{fileName}" /><Text\n\t\t\t\t\t\t\tid="rulesCount"\n\t\t\t\t\t\t\ttext=" ({= ${selections} ? ${selections}.length : 0} rules selected)"\n\t\t\t\t\t\t\tvisible="{= ${selections} ? true : false}"\n\t\t\t\t\t\t\trenderWhitespace="true"/></HBox><MessageStrip\n\t\t\t\t\t\tid="fileError"\n\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\tclass="sapUiTinyMarginTop" /></VBox><Label text="Title" labelFor="title" class="sapUiTinyMarginBottom" /><Text id="title" text="{title}" class="sapUiTinyMarginBottom" /><Label text="ID" labelFor="presetId" class="sapUiTinyMarginBottom" /><VBox class="sapUiTinyMarginBottom"><Text id="presetId" text="{id}" /><MessageStrip\n\t\t\t\t\t\tid="duplicateIdError"\n\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\tclass="sapUiTinyMarginTop" /></VBox><Label text="Date" labelFor="dateExported" class="sapUiTinyMarginBottom" /><Text\n\t\t\t\t\tid="dateExported"\n\t\t\t\t\ttext="{\n\t\t\t\t\t\tpath: \'dateExported\',\n\t\t\t\t\t\ttype: \'sap.ui.model.type.DateTime\',\n\t\t\t\t\t\tformatOptions: {\n\t\t\t\t\t\t\tstyle: \'medium\'\n\t\t\t\t\t\t}\n\t\t\t\t\t}"\n\t\t\t\t\tclass="sapUiTinyMarginBottom" /><Label text="Description" labelFor="description" class="sapUiTinyMarginBottom" /><ScrollContainer horizontal="false" vertical="true" class="sapUiSupportToolImportDescr sapUiTinyMarginBottom"><Text id="description" renderWhitespace="true" text="{description}" /></ScrollContainer></f:content></f:SimpleForm><beginButton><Button id="cancel" text="Cancel" press="onImportCancelPress" /></beginButton><endButton><Button id="importBtn" type="Emphasized" text="Import" enabled="false" press="onImportFinalizePress" class="sapUiTinyMarginEnd" /></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/support/supportRules/ui/views/Presets.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"><ResponsivePopover\n\t\tid="presetsPopover"\n\t\ttitle="Selection Preset"\n\t\tplacement="Bottom"\n\t\tcontentWidth="400px"\n\t\tcontentHeight="300px"><customHeader><Bar design="Header"><contentMiddle><Title id="rulePresetsTitle" text="Rule Presets" /></contentMiddle><contentRight><core:Icon id="help" width="18px" src="sap-icon://sys-help" decorative="false" press="openHelp" /></contentRight></Bar></customHeader><Page showHeader="false"><List\n\t\t\t\tid="select"\n\t\t\t\titems="{\n\t\t\t\t\tpath: \'/selectionPresets\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'\',\n\t\t\t\t\t\tgroup: \'.grouper\'\n\t\t\t\t\t},\n\t\t\t\t\tgroupHeaderFactory: \'.getGroupHeader\'\n\t\t\t\t}"\n\t\t\t\titemPress="onPresetItemPress"\n\t\t\t\tselectionChange="onPresetChange"\n\t\t\t\tmode="SingleSelectMaster"><CustomListItem selected="{selected}" type="Active" tooltip="{description}"><HBox\n\t\t\t\t\t\talignItems="Start"\n\t\t\t\t\t\tjustifyContent="SpaceBetween"><FormattedText\n\t\t\t\t\t\t\tclass="sapUiTinyMargin sapUiSupportToolPresetTitle"\n\t\t\t\t\t\t\thtmlText="{= ${isModified} ? \'&lt;em&gt;\' + ${title} + \'&lt;/em&gt;\' : ${title} }"/><HBox\n\t\t\t\t\t\t\talignItems="Start"\n\t\t\t\t\t\t\tjustifyContent="SpaceBetween"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginEnd"><Button\n\t\t\t\t\t\t\t\tid="undoButton"\n\t\t\t\t\t\t\t\ttooltip="Return to default selection"\n\t\t\t\t\t\t\t\ticon="sap-icon://refresh"\n\t\t\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\t\t\tpress="onPresetItemReset"\n\t\t\t\t\t\t\t\tvisible="{= ${isModified} ? true : false}"/><Button\n\t\t\t\t\t\t\t\ttooltip="Delete Preset"\n\t\t\t\t\t\t\t\ticon="sap-icon://sys-cancel"\n\t\t\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\t\t\tpress="onPresetItemDelete"\n\t\t\t\t\t\t\t\tvisible="{= ${disableDelete} ? false : true}" /></HBox></HBox></CustomListItem></List><footer><Toolbar><ToolbarSpacer /><Button id="presetImport" text="Import" press="onImportPress" /><Button id="presetExport" text="Export" press="onExportPress" /></Toolbar></footer></Page></ResponsivePopover></core:FragmentDefinition>',
	"sap/ui/support/supportRules/ui/views/RuleDetails.fragment.xml":'<core:FragmentDefinition\n\t\txmlns:m="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:f="sap.ui.layout.form"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:t="sap.ui.table"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:tools="sap.ui.codeeditor"><m:Page id="ruleDetailsPage" showHeader="false" visible="{/showRuleProperties}"><m:Bar><m:contentLeft><m:HBox fitContainer="true" renderType="Bare" class="customHBox"><m:Title text="{= ${/selectedRule/libName} + \' > \' + ${/selectedRule/title}}" visible="{= ${/selectedRule} !== undefined &amp;&amp; ${/selectedSetPreviewKey} !== \'additionalRulesets\'}" titleStyle="H6" class="customMarginLeft" /><m:IconTabHeader\n\t\t\t\t\t\t\tselectedKey="{/selectedRulePreviewKey}"\n\t\t\t\t\t\t\tclass="customIconTabHeader"><m:layoutData><m:FlexItemData growFactor="1" minWidth="0"></m:FlexItemData></m:layoutData><m:items><m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="ruleProperties" text="Rule properties" /><m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="checkFunction" text="Check function" /><m:IconTabFilter enabled="{= ${/selectedRule} !== undefined}" key="jsonOutput" text="Code" /></m:items></m:IconTabHeader></m:HBox></m:contentLeft></m:Bar><f:Form\n\t\t\t\tvisible="{= ${/selectedRule/type} !== \'library\'  &amp;&amp; ${/selectedRulePreviewKey} === \'ruleProperties\' &amp;&amp; ${/selectedRule} !== undefined &amp;&amp; ${/selectedSetPreviewKey} !== \'additionalRulesets\'}"><f:layout><f:ColumnLayout /></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement label="ID"><f:fields><m:Text text="{/selectedRule/id}" id="ruleID"  /></f:fields></f:FormElement><f:FormElement label="Title"><f:fields><m:Text text="{/selectedRule/title}" id="ruleTitle"  /></f:fields></f:FormElement><f:FormElement label="Async"><f:fields><m:Text text="{= ${/selectedRule/async} === true }" id="ruleAsync"  /></f:fields></f:FormElement><f:FormElement label="Audiences"><f:fields><m:Text text="{/selectedRule/audiences}" id="ruleAudience"  /></f:fields></f:FormElement><f:FormElement label="Categories"><f:fields><m:Text id="ruleCategory" text="{/selectedRule/categories}" /></f:fields></f:FormElement><f:FormElement label="Min version"><f:fields><m:Text id="ruleMinVersion" text="{/selectedRule/minversion}" /></f:fields></f:FormElement><f:FormElement label="Description"><f:fields><m:Text id="ruleDescription" text="{/selectedRule/description}" /></f:fields></f:FormElement><f:FormElement label="Resolution"><f:fields><m:Text id="ruleResolution" text="{/selectedRule/resolution}" /></f:fields></f:FormElement><f:FormElement label="Resolution URLs" fields="{/selectedRule/resolutionurls}"><f:fields><m:Link target="_blank"\n\t\t\t\t\t\t\t\t\t\t\ttext="{text}"\n\t\t\t\t\t\t\t\t\t\t\thref="{href}"><m:layoutData><f:ColumnElementData cellsLarge="8" cellsSmall="12" /></m:layoutData></m:Link></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form><m:Panel\n\t\t\t\twidth="100%"\n\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\tvisible="{= ${/selectedRulePreviewKey} === \'checkFunction\' }"><tools:CodeEditor\n\t\t\t\t\tid="codeEditorPreview"\n\t\t\t\t\tsyntaxHints="false"\n\t\t\t\t\twidth="100%"\n\t\t\t\t\theight="100%"\n\t\t\t\t\tvalue="{/selectedRule/check}"\n\t\t\t\t\teditable="false"></tools:CodeEditor></m:Panel><m:Panel\n\t\t\t\t\twidth="100%"\n\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\tvisible="{= ${/selectedRulePreviewKey} === \'jsonOutput\' }"><tools:CodeEditor\n\t\t\t\t\tid="codeEditorJson1"\n\t\t\t\t\tsyntaxHints="false"\n\t\t\t\t\twidth="100%"\n\t\t\t\t\theight="100%"\n\t\t\t\t\tvalue="{/selectedRuleStringify}"\n\t\t\t\t\teditable="false"\n\t\t\t\t\ttype="javascript"></tools:CodeEditor></m:Panel></m:Page></core:FragmentDefinition>\n',
	"sap/ui/support/supportRules/ui/views/RuleUpdate.fragment.xml":'<c:FragmentDefinition\n\t\txmlns:m="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:f="sap.ui.layout.form"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:t="sap.ui.table"\n\t\txmlns:c="sap.ui.core"\n\t\txmlns:tools="sap.ui.codeeditor"><m:Page\n\t\t\tid="ruleUpdatePage"\n\t\t\tshowHeader="false"><m:content><m:Bar><m:contentLeft><m:Button\n\t\t\t\t\t\t\ticon="sap-icon://arrow-left"\n\t\t\t\t\t\t\tpress="goToRuleProperties"\n\t\t\t\t\t\t\ttext="Back"/></m:contentLeft><m:contentMiddle><m:IconTabHeader\n\t\t\t\t\t\t\tselect="rulesToolbarEditITHSelect"\n\t\t\t\t\t\t\tselectedKey="{/selectedRuleEditKey}"\n\t\t\t\t\t\t\tclass="customIconTabHeader"><m:items><m:IconTabFilter key="ruleProperties" text="Rule properties" /><m:IconTabFilter key="checkFunction" text="Check function" /><m:IconTabFilter key="jsonOutput" text="Code" /></m:items></m:IconTabHeader></m:contentMiddle></m:Bar><f:Form\n\t\t\t\t\teditable="true"\n\t\t\t\t\tvisible="{= ${/selectedRuleEditKey} === \'ruleProperties\' }"><f:layout><f:ColumnLayout /></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement label="ID"><f:fields><m:Input value="{/editRule/id}" required = "true" /></f:fields></f:FormElement><f:FormElement label="Async"><f:fields><m:RadioButton groupName="asyncEditContext" text="true" selected="{= ${/editRule/async} === true }" select="onAsyncSwitch"><m:customData><c:CustomData key="asyncEditContext" value="true" /></m:customData></m:RadioButton><m:RadioButton groupName="asyncEditContext" text="false" selected="{= ${/editRule/async} !== true }" select="onAsyncSwitch"><m:customData><c:CustomData key="asyncEditContext" value="false" /></m:customData></m:RadioButton><c:Icon\n\t\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://message-warning"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBegin sapUiTinyMarginEnd"\n\t\t\t\t\t\t\t\t\t\t\tcolor="#E09D00"\n\t\t\t\t\t\t\t\t\t\t\tvisible="{= ${/editRule/async} === true }"><c:layoutData><m:FlexItemData alignSelf="Center" /></c:layoutData></c:Icon><m:Text text="{/resolveDescription}" visible="{= ${/editRule/async} === true }"><m:layoutData><m:FlexItemData alignSelf="Center" /></m:layoutData></m:Text></f:fields></f:FormElement><f:FormElement label="Categories"><f:fields><m:MultiComboBox selectedKeys="{/editRule/categories}" items="{/categories}"  required = "true"><c:Item key="{}" text="{}" /></m:MultiComboBox></f:fields></f:FormElement><f:FormElement label="Audiences"><f:fields><m:MultiComboBox selectedKeys="{/editRule/audiences}" items="{/audiences}"  required = "true"><c:Item key="{}" text="{}" /></m:MultiComboBox></f:fields></f:FormElement><f:FormElement label="Title"><f:fields><m:Input value="{/editRule/title}"  required = "true" /></f:fields></f:FormElement><f:FormElement label="Description"><f:fields><m:TextArea value="{/editRule/description}" required = "true"/></f:fields></f:FormElement><f:FormElement label="Resolution"><f:fields><m:TextArea value="{/editRule/resolution}" required = "true"/></f:fields></f:FormElement><f:FormElement label="Min version"><f:fields><m:TextArea value="{/editRule/minversion}" required = "true"/></f:fields></f:FormElement><f:FormElement label="Resolution URLS"><f:fields><m:Input placeholder="Text" value="{/tempLink/text}" /><m:Input placeholder="Href" value="{/tempLink/href}" /><m:Button text="Add Link" press="addLinkToRule" icon="sap-icon://add" /></f:fields></f:FormElement><f:FormElement label="" fields="{/editRule/resolutionurls}"><f:fields><m:Link text="{text}" href="{href}" target="_blank"><m:layoutData><f:ColumnElementData cellsLarge="8" cellsSmall="12" /></m:layoutData></m:Link></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form><m:Panel width="100%"\n\t\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\t\tvisible="{= ${/selectedRuleEditKey} === \'checkFunction\' }"><tools:CodeEditor\n\t\t\t\t\t\tid="codeEditorUpdate"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\tvalue="{/editRule/check}"\n\t\t\t\t\t\teditable="true"></tools:CodeEditor></m:Panel><m:Panel width="100%"\n\t\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\t\tvisible="{= ${/selectedRuleEditKey} === \'jsonOutput\' }"><tools:CodeEditor\n\t\t\t\t\t\tsyntaxHints="false"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\tvalue="{/updateRuleStringified}"\n\t\t\t\t\t\teditable="false"\n\t\t\t\t\t\ttype="javascript"></tools:CodeEditor></m:Panel></m:content><m:footer><m:Bar><m:contentRight><m:Button\n\t\t\t\t\t\t\tpress="updateRule"\n\t\t\t\t\t\t\ttext="Update"\n\t\t\t\t\t\t\ttype="Emphasized" /></m:contentRight></m:Bar></m:footer></m:Page><m:Page\n\t\t\tid="rulesCreatePage"\n\t\t\tshowHeader="false"><m:content><m:Bar><m:contentLeft><m:Button\n\t\t\t\t\t\t\ticon="sap-icon://arrow-left"\n\t\t\t\t\t\t\tpress="goToRuleProperties"\n\t\t\t\t\t\t\ttext="Back"/></m:contentLeft><m:contentMiddle><m:IconTabHeader\n\t\t\t\t\t\t\tselect="rulesToolbarITHSelect"\n\t\t\t\t\t\t\tselectedKey="{/selectedRuleCreateKey}"\n\t\t\t\t\t\t\tclass="customIconTabHeader"><m:items><m:IconTabFilter key="ruleProperties" text="Rule properties" /><m:IconTabFilter key="checkFunction" text="Check function" /><m:IconTabFilter key="jsonOutput" text="Code" /></m:items></m:IconTabHeader></m:contentMiddle></m:Bar><f:Form\n\t\t\t\t\teditable="true"\n\t\t\t\t\tvisible="{= ${/selectedRuleCreateKey} === \'ruleProperties\' }"><f:layout><f:ColumnLayout /></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement label="ID"><f:fields><m:Input value="{/newRule/id}" required = "true" /></f:fields></f:FormElement><f:FormElement label="Async"><f:fields><m:RadioButton groupName="asyncContext" text="true" selected="{= ${/newRule/async} === true }" select="onAsyncSwitch"><m:customData><c:CustomData key="asyncContext" value="true" /></m:customData></m:RadioButton><m:RadioButton groupName="asyncContext" text="false" selected="{= ${/newRule/async} !== true }" select="onAsyncSwitch"><m:customData><c:CustomData key="asyncContext" value="false" /></m:customData></m:RadioButton><c:Icon\n\t\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://message-warning"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBegin sapUiTinyMarginEnd"\n\t\t\t\t\t\t\t\t\t\t\tcolor="#E09D00"\n\t\t\t\t\t\t\t\t\t\t\tvisible="{= ${/newRule/async} === true }"><c:layoutData><m:FlexItemData alignSelf="Center" /></c:layoutData></c:Icon><m:Text text="{/resolveDescription}" visible="{= ${/newRule/async} === true }"><m:layoutData><m:FlexItemData alignSelf="Center" /></m:layoutData></m:Text></f:fields></f:FormElement><f:FormElement label="Categories"><f:fields><m:MultiComboBox selectedKeys="{/newRule/categories}" items="{/categories}"  required = "true"><c:Item key="{}" text="{}" /></m:MultiComboBox></f:fields></f:FormElement><f:FormElement label="Audiences"><f:fields><m:MultiComboBox selectedKeys="{/newRule/audiences}" items="{/audiences}"  required = "true"><c:Item key="{}" text="{}" /></m:MultiComboBox></f:fields></f:FormElement><f:FormElement label="Title"><f:fields><m:Input value="{/newRule/title}"  required = "true" /></f:fields></f:FormElement><f:FormElement label="Description"><f:fields><m:TextArea value="{/newRule/description}" required = "true"/></f:fields></f:FormElement><f:FormElement label="Resolution"><f:fields><m:TextArea value="{/newRule/resolution}" required = "true"/></f:fields></f:FormElement><f:FormElement label="Min version"><f:fields><m:TextArea value="{/newRule/minversion}" required = "true"/></f:fields></f:FormElement><f:FormElement label="Resolution URLS"><f:fields><m:Input placeholder="Text" value="{/tempLink/text}" /><m:Input placeholder="Href" value="{/tempLink/href}" /><m:Button text="Add" press="addLinkToRule" icon="sap-icon://add" /></f:fields></f:FormElement><f:FormElement label="" fields="{/newRule/resolutionurls}"><f:fields><m:Link text="{text}" ><m:layoutData><f:ColumnElementData cellsLarge="8" cellsSmall="12" /></m:layoutData></m:Link></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form><m:Panel width="100%"\n\t\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\t\tvisible="{= ${/selectedRuleCreateKey} === \'checkFunction\' }"><tools:CodeEditor\n\t\t\t\t\t\tid="codeEditorCreate"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\tvalue="{/newRule/check}"\n\t\t\t\t\t\teditable="true"></tools:CodeEditor></m:Panel><m:Panel width="100%"\n\t\t\t\t\t\theight="calc(100% - 2rem)"\n\t\t\t\t\t\tvisible="{= ${/selectedRuleCreateKey} === \'jsonOutput\' }"><tools:CodeEditor\n\t\t\t\t\t\tid="codeEditorJson"\n\t\t\t\t\t\tsyntaxHints="false"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\tvalue="{/newRuleStringified}"\n\t\t\t\t\t\teditable="false"\n\t\t\t\t\t\ttype="javascript"></tools:CodeEditor></m:Panel></m:content><m:footer><m:Bar><m:contentRight><m:Button\n\t\t\t\t\t\t\tpress="addNewRule"\n\t\t\t\t\t\t\ttext="Add Rule"\n\t\t\t\t\t\t\ttype="Emphasized" /></m:contentRight></m:Bar></m:footer></m:Page></c:FragmentDefinition>\n',
	"sap/ui/support/supportRules/ui/views/StorageSettings.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"><Popover\n\t\t\tid="storageSettings"\n\t\t\ttitle="Settings"\n\t\t\tcontentMinWidth="250px"\n\t\t\tclass="sapUiContentPadding"\n\t\t\tplacement="Bottom"\n\t\t\tafterClose=".onSettingsPopoverClose"><content><FlexBox\n\t\t\talignContent="Center"\n\t\t\tjustifyContent="Center"><l:VerticalLayout><MessageStrip\n\t\t\t\t\t\tvisible="{/tempRulesDisabled}"\n\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\ttext="Temporary rules cannot be used in the current environment due to CSP restrictions."/><l:HorizontalLayout><CheckBox\n\t\t\t\t\t\t\tid="persistChB"\n\t\t\t\t\t\t\ttext="I agree to use local storage persistency for:"\n\t\t\t\t\t\t\tselect= ".onPersistedSettingSelect"\n\t\t\t\t\t\t\tselected="{/persistingSettings}"/></l:HorizontalLayout><FlexBox\n\t\t\t\t\t\t\talignContent="Center"\n\t\t\t\t\t\t\tjustifyContent="Start"><l:VerticalLayout class="customSettingsPadding"><Text text="  Execution Scope"></Text><Text text="  Temporary Rules"></Text><Text text="  Selected Rules and Presets"></Text><Text text="  Filtered Columns in Rules"></Text><Button text="Delete Persisted Data" press=".deletePersistedData"></Button><l:HorizontalLayout class="customSettingsInfo"><Text text="Support Assistant Location : " renderWhitespace="true"></Text></l:HorizontalLayout><l:HorizontalLayout><Text text="{/supportAssistantOrigin} " renderWhitespace="true"></Text><core:Icon\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginLeft"\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://copy"\n\t\t\t\t\t\t\t\t\ttooltip="Copy Location"\n\t\t\t\t\t\t\t\t\tpress="copySupportAssistantOriginToClipboard" /></l:HorizontalLayout><l:HorizontalLayout class="sapUiTinyMarginTop"><Text text="Support Assistant Version : {/supportAssistantVersion}" renderWhitespace="true"></Text></l:HorizontalLayout></l:VerticalLayout></FlexBox></l:VerticalLayout></FlexBox></content></Popover></core:FragmentDefinition>\n'
});
//# sourceMappingURL=library-preload.js.map
