/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnalyticalColumn","./Column","./Table","./TreeTable","./TableRenderer","./library","sap/ui/model/analytics/ODataModelAdapter","sap/ui/unified/MenuItem","./utils/TableUtils","./plugins/BindingSelection","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/model/controlhelper/TreeBindingProxy","sap/ui/core/library"],function(e,t,o,n,r,i,a,s,u,p,l,jQuery,d,m){"use strict";var f=i.GroupEventType;var c=i.TreeAutoExpandMode;var h=u.createWeakMapFacade();var g=o.extend("sap.ui.table.AnalyticalTable",{metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}},events:{group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.AnalyticalColumn"}}}},designtime:"sap/ui/table/designtime/AnalyticalTable.designtime"},renderer:r});g.prototype._getFixedBottomRowContexts=function(){var e=this.getBinding();return e?[e.getGrandTotalNode()]:[]};g.prototype._getContexts=function(e,t,o){var n=this.getBinding();if(n){return n.getNodes(e,t,o)}else{return[]}};g.prototype._getRowContexts=n.prototype._getRowContexts;g.prototype.init=function(){o.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:false});this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;this._mGroupHeaderMenuItems=null;u.Grouping.setToDefaultGroupMode(this);u.Hook.register(this,u.Hook.Keys.Row.UpdateState,y,this);u.Hook.register(this,u.Hook.Keys.Table.OpenMenu,G,this);u.Hook.register(this,u.Hook.Keys.Row.Expand,_,this);u.Hook.register(this,u.Hook.Keys.Row.Collapse,v,this);this._oProxy=new d(this,"rows")};g.prototype.exit=function(){o.prototype.exit.apply(this,arguments);this._cleanupGroupHeaderMenuItems()};g.prototype._adaptLocalization=function(e,t){return o.prototype._adaptLocalization.apply(this,arguments).then(function(){if(t){this._cleanupGroupHeaderMenuItems()}}.bind(this))};g.prototype.setFixedRowCount=function(){l.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this};g.prototype.setFixedBottomRowCount=function(){l.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this};g.prototype.setDirty=function(e){l.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",e,true);this.setShowOverlay(this.getDirty());return this};g.prototype.setEnableGrouping=function(){l.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this};g.prototype.setGroupBy=function(){l.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this};g.prototype.getModel=function(e){var t=o.prototype.getModel.apply(this,arguments);var n=this.getBindingInfo("rows");if(t&&n&&n.model==e){a.apply(t)}return t};g.prototype.updateRows=function(e){o.prototype.updateRows.apply(this,arguments);if(e!=="sort"){this._invalidateColumnMenus()}};g.prototype._bindRows=function(e){delete h(this).bPendingRequest;this._applyAnalyticalBindingInfo(e);o.prototype._bindRows.call(this,e)};g.prototype._bindAggregation=function(e,t){if(e==="rows"){this._invalidateColumnMenus();this._applyODataModelAnalyticalAdapter(t.model);this._setFirstVisibleRowIndex(0,{onlySetProperty:true})}o.prototype._bindAggregation.call(this,e,t);if(e==="rows"){this._updateTotalRow(true);u.Binding.metadataLoaded(this).then(function(){this._updateColumns(true)}.bind(this))}};g.prototype._applyAnalyticalBindingInfo=function(e){e.parameters=e.parameters||{};e.parameters.analyticalInfo=this._getColumnInformation();if(!e.parameters.hasOwnProperty("sumOnTop")){e.parameters.sumOnTop=this.getSumOnTop()}if(!e.parameters.hasOwnProperty("numberOfExpandedLevels")){e.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels()}if(e.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){e.parameters.numberOfExpandedLevels=0}if(!e.parameters.hasOwnProperty("autoExpandMode")){var t=this.getAutoExpandMode();if(t!=c.Bundled&&t!=c.Sequential){t=c.Bundled}e.parameters.autoExpandMode=t}};g.prototype._applyODataModelAnalyticalAdapter=function(e){if(e){a.apply(e)}};g.prototype._getColumnInformation=function(){var t=[],o=this.getColumns();for(var n=0;n<this._aGroupedColumns.length;n++){var r=sap.ui.getCore().byId(this._aGroupedColumns[n]);if(!r){continue}t.push({name:r.getLeadingProperty(),visible:r.getVisible(),grouped:r.getGrouped(),total:r.getSummed(),inResult:r.getInResult(),formatter:r.getGroupHeaderFormatter()})}for(var n=0;n<o.length;n++){var r=o[n];if(this._aGroupedColumns.indexOf(r.getId())>-1){continue}if(!(r instanceof e)){l.error("You have to use AnalyticalColumns for the Analytical table")}t.push({name:r.getLeadingProperty(),visible:r.getVisible(),grouped:r.getGrouped(),total:r.getSummed(),inResult:r.getInResult(),formatter:r.getGroupHeaderFormatter()})}return t};function y(e){var t=this.getBinding();var o=this.getBindingInfo("rows");var n=e.context;e.context=n.context;if(!e.context){return}if(t.nodeHasChildren(n)){e.type=e.Type.GroupHeader;e.expandable=true}else if(n.nodeState.sum){e.type=e.Type.Summary}e.level=n.level+(e.type===e.Type.Summary?1:0);e.expanded=n.nodeState.expanded;e.contentHidden=e.expanded&&!o.parameters.sumOnTop;e.title=e.type===e.Type.GroupHeader?t.getGroupName(n.context,n.level):""}function _(e){this.expand(e.getIndex())}function v(e){this.collapse(e.getIndex())}g.prototype.onRowsUpdated=function(e){o.prototype.onRowsUpdated.apply(this,arguments);var n=this.getRows();var r=this.getBinding();var i=this._getVisibleColumns()[0];for(var a=0;a<n.length;a++){var s=n[a];var u=s.getCells();var p=u.length;for(var l=0;l<p;l++){var d=t.ofCell(u[l]);var m=r?r.isMeasure(d.getLeadingProperty()):false;var f=jQuery(u[l].$().closest("td"));var c=false;if(s.isSummary()&&m){c=!d.getSummed()}else if(s.isGroupHeader()&&d===i){c=!m}f.toggleClass("sapUiTableCellHidden",c)}}};function G(e,t){var o=e.isOfType(u.CELLTYPE.ANYCONTENTCELL)?this.getRows()[e.rowIndex]:null;if(!o||!o.isGroupHeader()){this._removeGroupHeaderMenuItems(t);return}this._iGroupedLevel=o.getLevel();this._addGroupHeaderMenuItems(t)}g.prototype._addGroupHeaderMenuItems=function(e){var t=this;function o(){var e=t._iGroupedLevel-1;if(t._aGroupedColumns[e]){var o=t.getColumns().filter(function(o){return t._aGroupedColumns[e]===o.getId()})[0];return{column:o,index:e}}else{return undefined}}if(!this._mGroupHeaderMenuItems){this._mGroupHeaderMenuItems={}}if(!this._mGroupHeaderMenuItems["visibility"]){this._mGroupHeaderMenuItems["visibility"]=new s({text:u.getResourceText("TBL_SHOW_COLUMN"),select:function(){var e=o();if(e){var n=e.column,r=n.getShowIfGrouped();n.setShowIfGrouped(!r);t.fireGroup({column:n,groupedColumns:n.getParent()._aGroupedColumns,type:!r?f.showGroupedColumn:f.hideGroupedColumn})}}})}e.addItem(this._mGroupHeaderMenuItems["visibility"]);if(!this._mGroupHeaderMenuItems["ungroup"]){this._mGroupHeaderMenuItems["ungroup"]=new s({text:u.getResourceText("TBL_UNGROUP"),select:function(){var e=o();if(e&&e.column){var n=e.column;n.setGrouped(false);t.fireGroup({column:n,groupedColumns:t._aGroupedColumns,type:f.ungroup})}}})}e.addItem(this._mGroupHeaderMenuItems["ungroup"]);if(!this._mGroupHeaderMenuItems["ungroupall"]){this._mGroupHeaderMenuItems["ungroupall"]=new s({text:u.getResourceText("TBL_UNGROUP_ALL"),select:function(){var e=t.getColumns();t.suspendUpdateAnalyticalInfo();for(var o=0;o<e.length;o++){e[o].setGrouped(false)}t.resumeUpdateAnalyticalInfo();t.fireGroup({column:undefined,groupedColumns:[],type:f.ungroupAll})}})}e.addItem(this._mGroupHeaderMenuItems["ungroupall"]);if(!this._mGroupHeaderMenuItems["moveup"]){this._mGroupHeaderMenuItems["moveup"]=new s({text:u.getResourceText("TBL_MOVE_UP"),select:function(){var e=o();if(e){var n=e.column;var r=t._aGroupedColumns.indexOf(n.getId());if(r>0){t._aGroupedColumns[r]=t._aGroupedColumns.splice(r-1,1,t._aGroupedColumns[r])[0];t.updateAnalyticalInfo();t.fireGroup({column:n,groupedColumns:n.getParent()._aGroupedColumns,type:f.moveUp})}}},icon:"sap-icon://arrow-top"})}e.addItem(this._mGroupHeaderMenuItems["moveup"]);if(!this._mGroupHeaderMenuItems["movedown"]){this._mGroupHeaderMenuItems["movedown"]=new s({text:u.getResourceText("TBL_MOVE_DOWN"),select:function(){var e=o();if(e){var n=e.column;var r=t._aGroupedColumns.indexOf(n.getId());if(r<t._aGroupedColumns.length){t._aGroupedColumns[r]=t._aGroupedColumns.splice(r+1,1,t._aGroupedColumns[r])[0];t.updateAnalyticalInfo();t.fireGroup({column:n,groupedColumns:n.getParent()._aGroupedColumns,type:f.moveDown})}}},icon:"sap-icon://arrow-bottom"})}e.addItem(this._mGroupHeaderMenuItems["movedown"]);if(!this._mGroupHeaderMenuItems["sortasc"]){this._mGroupHeaderMenuItems["sortasc"]=new s({text:u.getResourceText("TBL_SORT_ASC"),select:function(){o()?.column._sort(m.SortOrder.Ascending)},icon:"sap-icon://up"})}e.addItem(this._mGroupHeaderMenuItems["sortasc"]);if(!this._mGroupHeaderMenuItems["sortdesc"]){this._mGroupHeaderMenuItems["sortdesc"]=new s({text:u.getResourceText("TBL_SORT_DESC"),select:function(){o()?.column._sort(m.SortOrder.Descending)},icon:"sap-icon://down"})}e.addItem(this._mGroupHeaderMenuItems["sortdesc"]);if(!this._mGroupHeaderMenuItems["collapse"]){this._mGroupHeaderMenuItems["collapse"]=new s({text:u.getResourceText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding().collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection()}})}e.addItem(this._mGroupHeaderMenuItems["collapse"]);if(!this._mGroupHeaderMenuItems["collapseall"]){this._mGroupHeaderMenuItems["collapseall"]=new s({text:u.getResourceText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding().collapseToLevel(0);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection()}})}e.addItem(this._mGroupHeaderMenuItems["collapseall"]);if(!this._mGroupHeaderMenuItems["expand"]){this._mGroupHeaderMenuItems["expand"]=new s({text:u.getResourceText("TBL_EXPAND_LEVEL"),select:function(){t.getBinding().expandToLevel(t._iGroupedLevel);t.setFirstVisibleRow(0);t._getSelectionPlugin().clearSelection()}})}e.addItem(this._mGroupHeaderMenuItems["expand"]);if(!this._mGroupHeaderMenuItems["expandall"]){this._mGroupHeaderMenuItems["expandall"]=new s({text:u.getResourceText("TBL_EXPAND_ALL"),select:function(){t.expandAll()}})}e.addItem(this._mGroupHeaderMenuItems["expandall"]);var n=o();if(n){var r=n.column;if(r.getShowIfGrouped()){this._mGroupHeaderMenuItems["visibility"].setText(u.getResourceText("TBL_HIDE_COLUMN"))}else{this._mGroupHeaderMenuItems["visibility"].setText(u.getResourceText("TBL_SHOW_COLUMN"))}this._mGroupHeaderMenuItems["moveup"].setEnabled(n.index>0);this._mGroupHeaderMenuItems["movedown"].setEnabled(n.index<this._aGroupedColumns.length-1)}else{this._mGroupHeaderMenuItems["moveup"].setEnabled(true);this._mGroupHeaderMenuItems["movedown"].setEnabled(true)}};g.prototype._removeGroupHeaderMenuItems=function(e){if(!this._mGroupHeaderMenuItems){return}for(var t in this._mGroupHeaderMenuItems){e.removeItem(this._mGroupHeaderMenuItems[t])}};g.prototype._cleanupGroupHeaderMenuItems=function(){for(var e in this._mGroupHeaderMenuItems){this._mGroupHeaderMenuItems[e].destroy()}this._mGroupHeaderMenuItems=null};g.prototype.getContextByIndex=function(e){return this._oProxy.getContextByIndex(e)};g.prototype.getContextInfoByIndex=function(e){return this._oProxy.getNodeByIndex(e)};g.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true};g.prototype.resumeUpdateAnalyticalInfo=function(e,t){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(e,t)};g.prototype.addColumn=function(e,t){var n=this._getColumn(e);if(n.getGrouped()){this._addGroupedColumn(n.getId())}o.prototype.addColumn.call(this,n,t);this._updateColumns(t);return this};g.prototype.insertColumn=function(e,t,n){var r=this._getColumn(e);if(r.getGrouped()){this._addGroupedColumn(r.getId())}o.prototype.insertColumn.call(this,r,t,n);this._updateColumns(n);return this};g.prototype.removeColumn=function(e,t){var n=o.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=jQuery.grep(this._aGroupedColumns,function(t){if(e.getId){return t!=e.getId()}else{return t==e}})}this.updateAnalyticalInfo(t);return n};g.prototype.removeAllColumns=function(e){this._aGroupedColumns=[];var t=o.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(e);return t};g.prototype._getColumn=function(t){if(typeof t==="string"){var o=new e({leadingProperty:t,template:t,managed:true});return o}else if(t instanceof e){return t}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject")}};g.prototype._updateColumns=function(e,t){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(e,t);if(this.bOutput){this.invalidate()}}};g.prototype.updateAnalyticalInfo=function(e,t){if(this._bSuspendUpdateAnalyticalInfo){return}var o=this.getBinding();if(o){var n=this._getColumnInformation();var r=o.getNumberOfExpandedLevels()||0;if(r>this._aGroupedColumns.length){o.setNumberOfExpandedLevels(0)}o.updateAnalyticalInfo(n,t);this._updateTotalRow(e);if(!e){this._getRowContexts()}}};g.prototype.refreshRows=function(){o.prototype.refreshRows.apply(this,arguments);this._updateTotalRow()};g.prototype._updateTotalRow=function(e){var t=this.getBinding();this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:t?t.providesGrandTotal()&&t.hasTotaledMeasures():false},e)};g.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return}var e=this.getBinding(),t=e&&e.getAnalyticalQueryResult();if(t){var o=this.getColumns(),n=[],r=[],i=[],a={},s,u;for(var p=0;p<o.length;p++){s=o[p];s._isLastGroupableLeft=false;s._bLastGroupAndGrouped=false;s._bDependendGrouped=false;if(!s.getVisible()){continue}var l=s.getLeadingProperty();u=t.findDimensionByPropertyName(l);if(u){var d=u.getName();if(!a[d]){a[d]={dimension:u,columns:[s]}}else{a[d].columns.push(s)}if(s.getGrouped()&&n.indexOf(d)==-1){n.push(d)}if(i.indexOf(d)==-1){i.push(d)}}}r=jQuery.grep(i,function(e){return n.indexOf(n,e)==-1});if(n.length>0){jQuery.each(n,function(e,t){jQuery.each(a[t].columns,function(e,t){if(!t.getGrouped()){t._bDependendGrouped=true}})});if(n.length==i.length){u=t.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var m=a[u.getName()].columns;jQuery.each(m,function(e,t){t._bLastGroupAndGrouped=true})}}if(r.length==1){jQuery.each(a[r[0]].columns,function(e,t){t._isLastGroupableLeft=true})}}};g.prototype._getFirstMeasureColumnIndex=function(){var e=this.getBinding(),t=e&&e.getAnalyticalQueryResult(),o=this._getVisibleColumns();if(!t){return-1}for(var n=0;n<o.length;n++){var r=o[n],i=r.getLeadingProperty();if(t.findMeasureByName(i)||t.findMeasureByPropertyName(i)){return n}}};g.prototype._getTotalRowCount=function(){var e=o.prototype._getTotalRowCount.apply(this,arguments);if(e===1){var t=this.getBinding();var n=t?t.providesGrandTotal()&&t.hasTotaledMeasures():false;if(n){e=0}}return e};g.prototype.getTotalSize=function(){var e=this.getBinding();if(e){return e.getTotalSize()}return 0};g.prototype._onPersoApplied=function(){o.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var e=this.getColumns();for(var t=0,n=e.length;t<n;t++){if(e[t].getGrouped()){this._addGroupedColumn(e[t].getId())}}this._updateColumns()};g.prototype._addGroupedColumn=function(e){if(this._aGroupedColumns.indexOf(e)===-1){this._aGroupedColumns.push(e)}};g.prototype._removeGroupedColumn=function(e){var t=this._aGroupedColumns.indexOf(e);if(t>=0){this._aGroupedColumns.splice(t,1)}};g.prototype.getGroupedColumns=function(){return this._aGroupedColumns};g.prototype.setCollapseRecursive=function(e){this._oProxy.setCollapseRecursive(e);this.setProperty("collapseRecursive",!!e,true);return this};g.prototype.expand=n.prototype.expand;g.prototype.collapse=n.prototype.collapse;g.prototype.expandAll=function(){this._oProxy.expandToLevel(this._aGroupedColumns.length);this.setFirstVisibleRow(0);this._getSelectionPlugin().clearSelection();return this};g.prototype.collapseAll=n.prototype.collapseAll;g.prototype.isExpanded=n.prototype.isExpanded;g.prototype.getAnalyticalInfoOfRow=function(e){var t=this.getBinding();var o=e?e.getRowBindingContext():null;if(!u.isA(e,"sap.ui.table.Row")||e.getParent()!==this||!t||!o){return null}var n=o===t.getGrandTotalContext();var r=null;var i=-1;if(n){r=t.getGrandTotalContextInfo();i=0}else{r=this.getContextInfoByIndex(e.getIndex());if(r){i=r.level}}var a=r&&t.nodeHasChildren&&t.nodeHasChildren(r);var s=!a&&!n&&r&&r.nodeState&&r.nodeState.sum;var p=[];if(s||a){var l=this.getGroupedColumns();if(l.length>0&&i>0&&i<=l.length){for(var d=0;d<i;d++){p.push(l[d])}}}return{grandTotal:n,group:a,groupTotal:s,level:i,context:o,groupedColumns:p}};g.prototype._createLegacySelectionPlugin=function(){return new p};g.prototype._setRowCountConstraints=function(){};g.prototype._onBindingDataRequested=function(e){if(e.getParameter("__simulateAsyncAnalyticalBinding")){return}var t=this.getBinding();if(!t.bUseBatchRequests){h(this).bPendingRequest=true}o.prototype._onBindingDataRequested.apply(this,arguments)};g.prototype._onBindingDataReceived=function(e){if(e.getParameter("__simulateAsyncAnalyticalBinding")){return}var t=this.getBinding();if(!t.bUseBatchRequests){h(this).bPendingRequest=false}o.prototype._onBindingDataReceived.apply(this,arguments)};g.prototype._hasPendingRequests=function(){if(h(this).hasOwnProperty("bPendingRequest")){return h(this).bPendingRequest}else{return o.prototype._hasPendingRequests.apply(this,arguments)}};return g});
//# sourceMappingURL=AnalyticalTable.js.map