/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./RowMode","../utils/TableUtils"],function(t,e){"use strict";var o=t.extend("sap.ui.table.rowmodes.Fixed",{metadata:{library:"sap.ui.table",properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance",visibility:"hidden"}}},constructor:function(e){Object.defineProperty(this,"bLegacy",{value:typeof e==="boolean"?e:false});t.apply(this,arguments)}});var i={};o.prototype.attachEvents=function(){t.prototype.attachEvents.apply(this,arguments);e.addDelegate(this.getTable(),i,this)};o.prototype.detachEvents=function(){t.prototype.detachEvents.apply(this,arguments);e.removeDelegate(this.getTable(),i)};o.prototype.registerHooks=function(){t.prototype.registerHooks.apply(this,arguments);e.Hook.register(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.deregisterHooks=function(){t.prototype.deregisterHooks.apply(this,arguments);e.Hook.deregister(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0}return this.getProperty("rowCount")};o.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};o.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};o.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};o.prototype.setHideEmptyRows=function(t){this.setProperty("hideEmptyRows",t);if(t){this.disableNoData()}else{this.enableNoData()}return this};o.prototype.getHideEmptyRows=function(){return this.getProperty("hideEmptyRows")};o.prototype.getMinRequestLength=function(){return Math.max(0,this.getRowCount())};o.prototype.updateTable=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){var e=this.getRowCount();if(e>0){this.getRowContexts(e)}}return t.prototype.updateTable.apply(this,arguments)};o.prototype.getComputedRowCounts=function(){var t=this.getRowCount();var e=this.getFixedTopRowCount();var o=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){t=Math.min(t,this.getTotalRowCountOfTable())}return this.computeStandardizedRowCounts(t,e,o)};o.prototype.getTableStyles=function(){return{height:"auto"}};o.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined}var t=Math.max(0,this.getRowCount()-this.getComputedRowCounts().count);return{height:t*this.getBaseRowHeightOfTable()+"px"}};o.prototype.getRowContainerStyles=function(){var t=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!e.isVariableRowHeightEnabled(this.getTable())){return{minHeight:t}}return{height:t}};o.prototype.renderRowStyles=function(t){var e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};o.prototype.renderCellContentStyles=function(t){var e=this.getRowContentHeight();if(this.bLegacy){return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};o.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};o.prototype._onTableRefreshRows=function(){var t=this.getRowCount();if(t>0){if(e.isVariableRowHeightEnabled(this.getTable())){t++}this.initTableRowsAfterDataRequested(t);this.getRowContexts(t)}};i.onAfterRendering=function(t){var o=this.getTable();var i=t&&t.isMarked("renderRows");if(!i&&o.getRows().length>0){this.fireRowsUpdated(e.RowsUpdateReason.Render)}};return o});
//# sourceMappingURL=Fixed.js.map