/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_GroupingUtils","./_ColumnUtils","./_MenuUtils","./_BindingUtils","./_HookUtils","../library","sap/ui/base/Object","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/ui/core/theming/Parameters","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/model/ChangeReason","sap/ui/thirdparty/jquery","sap/base/util/restricted/_throttle","sap/base/Log"],function(e,t,n,i,a,o,r,l,s,u,d,c,f,jQuery,g,p){"use strict";var C=o.SelectionBehavior;var v=o.SelectionMode;var m=s.MessageType;var R;var _=null;var h={DATACELL:1<<1,COLUMNHEADER:1<<2,ROWHEADER:1<<3,ROWACTION:1<<4,COLUMNROWHEADER:1<<5,PSEUDO:1<<6};h.ANYCONTENTCELL=h.ROWHEADER|h.DATACELL|h.ROWACTION;h.ANYCOLUMNHEADER=h.COLUMNHEADER|h.COLUMNROWHEADER;h.ANYROWHEADER=h.ROWHEADER|h.COLUMNROWHEADER;h.ANY=h.ANYCONTENTCELL|h.ANYCOLUMNHEADER;var w={sapUiSizeCozy:48,sapUiSizeCompact:32,sapUiSizeCondensed:24,undefined:32};var b=1;var I=1;var S={sapUiSizeCozy:w.sapUiSizeCozy+I,sapUiSizeCompact:w.sapUiSizeCompact+I,sapUiSizeCondensed:w.sapUiSizeCondensed+I,undefined:w.undefined+I};var T={navigationIcon:"navigation-right-arrow",deleteIcon:"sys-cancel",clearSelectionIcon:"clear-all",navIndicatorWidth:3};var E={Render:"Render",VerticalScroll:"VerticalScroll",FirstVisibleRowChange:"FirstVisibleRowChange",Unbind:"Unbind",Animation:"Animation",Resize:"Resize",Zoom:"Zoom",Unknown:"Unknown"};for(var y in f){E[y]=f[y]}var x=":sapTabbable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)";var U={Grouping:e,Column:t,Menu:n,Binding:i,Hook:a,CELLTYPE:h,BaseSize:w,BaseBorderWidth:b,RowHorizontalFrameSize:I,DefaultRowHeight:S,RowsUpdateReason:E,INTERACTIVE_ELEMENT_SELECTORS:x,ThemeParameters:T,hasRowHeader:function(t){return t.getSelectionMode()!==v.None&&t.getSelectionBehavior()!==C.RowOnly||e.isInGroupMode(t)},hasSelectAll:function(e){var t=e?e.getSelectionMode():v.None;return t===v.MultiToggle&&e.getEnableSelectAll()},hasRowHighlights:function(e){if(!e){return false}var t=e.getRowSettingsTemplate();if(!t){return false}var n=t.getHighlight();return t.isBound("highlight")||n!=null&&n!==m.None},hasRowNavigationIndicators:function(e){if(!e){return false}var t=e.getRowSettingsTemplate();if(!t){return false}var n=t.getNavigated();return t.isBound("navigated")||n},hasRowActions:function(e){var t=e?e.getRowActionTemplate():null;return t!=null&&(t.isBound("visible")||t.getVisible())&&e.getRowActionCount()>0},isRowSelectionAllowed:function(e){return e.getSelectionMode()!==v.None&&(e.getSelectionBehavior()===C.Row||e.getSelectionBehavior()===C.RowOnly)},isRowSelectorSelectionAllowed:function(e){return e.getSelectionMode()!==v.None&&U.hasRowHeader(e)},isNoDataVisible:function(e){return!e._isNoDataDisabled()&&!U.hasData(e)||U.getVisibleColumnCount(e)===0},hasData:function(e){return e._getTotalRowCount()>0},isBusyIndicatorVisible:function(e){if(!e||!e.getDomRef()){return false}return e.getDomRef().querySelector('[id="'+e.getId()+'-sapUiTableGridCnt"] > .sapUiLocalBusyIndicator')!=null},isA:function(e,t){return r.isObjectA(e,t)},toggleRowSelection:function(e,t,n,i){var a;if(U.isA(t,"sap.ui.table.Row")){a=t}else if(typeof t==="number"){a=e.getRows()[t]}else{var o=jQuery(t);var r=U.getCellInfo(o[0]);var l=U.isRowSelectionAllowed(e);if(!U.Grouping.isInGroupHeaderRow(o[0])&&(r.isOfType(U.CELLTYPE.DATACELL|U.CELLTYPE.ROWACTION)&&l||r.isOfType(U.CELLTYPE.ROWHEADER)&&U.isRowSelectorSelectionAllowed(e))){a=e.getRows()[r.rowIndex]}}if(!a||a.isEmpty()){return}e._iSourceRowIndex=a.getIndex();if(i){i(a)}else{var s=e._getSelectionPlugin();s.setSelected(a,typeof n==="boolean"?n:!s.isSelected(a))}delete e._iSourceRowIndex},getNoContentMessage:function(e){if(U.getVisibleColumnCount(e)>0){return e.getNoData()||U.getResourceText("TBL_NO_DATA")}else{return e.getAggregation("_noColumnsMessage")||U.getResourceText("TBL_NO_COLUMNS")}},getVisibleColumnCount:function(e){return e._getVisibleColumns().length},getHeaderRowCount:function(e){if(e._iHeaderRowCount===undefined){if(!e.getColumnHeaderVisible()){e._iHeaderRowCount=0}else{var t=1;var n=e.getColumns();for(var i=0;i<n.length;i++){if(n[i].shouldRender()){t=Math.max(t,n[i].getMultiLabels().length)}}e._iHeaderRowCount=t}}return e._iHeaderRowCount},isVariableRowHeightEnabled:function(e){var t=e._getRowCounts();return e&&e._bVariableRowHeightEnabled&&!t.fixedTop&&!t.fixedBottom},getNonEmptyRowCount:function(e){return Math.min(e._getRowCounts().count,e._getTotalRowCount())},getFocusedItemInfo:function(e){var t=e._getItemNavigation();if(!t){return null}return{cell:t.getFocusedIndex(),columnCount:t.iColumns,cellInRow:t.getFocusedIndex()%t.iColumns,row:Math.floor(t.getFocusedIndex()/t.iColumns),cellCount:t.getItemDomRefs().length,domRef:t.getFocusedDomRef()}},getRowIndexOfFocusedCell:function(e){var t=U.getFocusedItemInfo(e);return t.row-U.getHeaderRowCount(e)},isFixedColumn:function(e,t){return t<e.getComputedFixedColumnCount()},hasFixedColumns:function(e){return e.getComputedFixedColumnCount()>0},focusItem:function(e,t,n){var i=e._getItemNavigation();if(i){i.focusItem(t,n)}},scrollTableToIndex:function(e,t,n){if(!e){return Promise.resolve()}var i=e.getFirstVisibleRow();var a=e._getRowCounts();var o=i+a.scrollable-1;var r=false;if(t<i||t>o){var l=n?t-a.fixedTop-1:t-a.scrollable-a.fixedTop+2;r=e._setFirstVisibleRowIndex(Math.max(0,l))}return new Promise(function(t){if(r){e.attachEventOnce("rowsUpdated",t)}else{t()}})},showNotificationPopoverAtIndex:function(e,t,n){var i=e._oNotificationPopover;var a=e.getRows()[t-e._getFirstRenderedRowIndex()];var o=U.getResourceText("TBL_SELECT_LIMIT_TITLE");var r=U.getResourceText("TBL_SELECT_LIMIT",[n]);return new Promise(function(t){sap.ui.require(["sap/m/Popover","sap/m/Bar","sap/m/Title","sap/m/Text","sap/m/HBox","sap/ui/core/library","sap/m/library"],function(n,l,s,u,c,f,g){if(!i){i=new n(e.getId()+"-notificationPopover",{customHeader:[new l({contentMiddle:[new c({items:[new d({src:"sap-icon://message-warning",color:f.IconColor.Critical}).addStyleClass("sapUiTinyMarginEnd"),new s({text:o,level:f.TitleLevel.H2})],renderType:g.FlexRendertype.Bare,justifyContent:g.FlexJustifyContent.Center,alignItems:g.FlexAlignItems.Center})]})],content:new u({text:r})});i.addStyleClass("sapUiContentPadding");e._oNotificationPopover=i;e.addAggregation("_hiddenDependents",e._oNotificationPopover)}else{i.getContent()[0].setText(r)}e.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);e.attachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);var p=a.getDomRefs().rowSelector;if(p){i.attachEventOnce("afterOpen",t);i.openBy(p)}else{t()}}.bind(this))}.bind(this))},onFirstVisibleRowChange:function(e){var t=e.getSource();if(!t._oNotificationPopover){return}if(t){t.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this)}t._oNotificationPopover.close()},loadContexts:function(e,t,n){var i=e.getContexts(t,n,0,true);var a=i.length===Math.min(n,e.getLength())&&!i.includes(undefined);if(a){return Promise.resolve(i)}return new Promise(function(i){e.attachEventOnce("dataReceived",function(){i(this.loadContexts(e,t,n))}.bind(this))}.bind(this))},getCellInfo:function(e){var t;var n=jQuery(e);var i;var a;var o;var r;var l;t={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};if(n.hasClass("sapUiTableDataCell")){i=n.attr("data-sap-ui-colid");a=sap.ui.getCore().byId(i);t.type=U.CELLTYPE.DATACELL;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=a.getIndex();t.columnSpan=1}else if(n.hasClass("sapUiTableHeaderDataCell")){o=/_([\d]+)/;i=n.attr("id");r=o.exec(i);l=r&&r[1]!=null?parseInt(r[1]):0;t.type=U.CELLTYPE.COLUMNHEADER;t.rowIndex=l;t.columnIndex=parseInt(n.attr("data-sap-ui-colindex"));t.columnSpan=parseInt(n.attr("colspan")||1)}else if(n.hasClass("sapUiTableRowSelectionCell")){t.type=U.CELLTYPE.ROWHEADER;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=-1;t.columnSpan=1}else if(n.hasClass("sapUiTableRowActionCell")){t.type=U.CELLTYPE.ROWACTION;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=-2;t.columnSpan=1}else if(n.hasClass("sapUiTableRowSelectionHeaderCell")){t.type=U.CELLTYPE.COLUMNROWHEADER;t.columnIndex=-1;t.columnSpan=1}else if(n.hasClass("sapUiTablePseudoCell")){i=n.attr("data-sap-ui-colid");a=sap.ui.getCore().byId(i);t.type=U.CELLTYPE.PSEUDO;t.rowIndex=-1;t.columnIndex=a?a.getIndex():-1;t.columnSpan=1}if(t.type!==0){t.cell=n}t.isOfType=function(e){if(e==null){return false}return(this.type&e)>0};return t},getRowColCell:function(e,t,n,i){var a=e.getRows()[t]||null;var o=i?e.getColumns():e._getVisibleColumns();var r=o[n]||null;var l;var s=null;if(a&&r){if(!l){var u=r.getMetadata();while(u.getName()!=="sap.ui.table.Column"){u=u.getParent()}l=u.getClass()}s=a.getCells().find(function(e){return r===l.ofCell(e)})||null}return{row:a,column:r,cell:s}},getCell:function(e,t,n){n=n===true;if(!e||!t){return null}var i=jQuery(t);var a=e.getDomRef();var o=".sapUiTableCell";if(!n){o+=":not(.sapUiTablePseudoCell)"}var r=i.closest(o,a);if(r.length>0){return r}return null},getParentCell:function(e,t,n){n=n===true;var i=jQuery(t);var a=U.getCell(e,t,n);if(!a||a[0]===i[0]){return null}else{return a}},registerResizeHandler:function(e,t,n,i,a){i=i==null?"":i;a=a===true;if(!e||typeof t!=="string"||typeof n!=="function"){return undefined}var o=e.getDomRef(i);U.deregisterResizeHandler(e,t);if(!e._mResizeHandlerIds){e._mResizeHandlerIds={}}if(a&&o){o=o.parentNode}if(o){e._mResizeHandlerIds[t]=l.register(o,n)}return e._mResizeHandlerIds[t]},deregisterResizeHandler:function(e,t){var n=[];if(!e._mResizeHandlerIds){return}if(typeof t==="string"){n.push(t)}else if(t===undefined){for(var i in e._mResizeHandlerIds){if(typeof i=="string"&&e._mResizeHandlerIds.hasOwnProperty(i)){n.push(i)}}}else if(Array.isArray(t)){n=t}for(var a=0;a<n.length;a++){var o=n[a];if(e._mResizeHandlerIds[o]){l.deregister(e._mResizeHandlerIds[o]);e._mResizeHandlerIds[o]=undefined}}},isFirstScrollableRow:function(e,t){if(isNaN(t)){var n=jQuery(t);t=parseInt(n.add(n.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"))}return t==e._getRowCounts().fixedTop},isLastScrollableRow:function(e,t){if(isNaN(t)){var n=jQuery(t);t=parseInt(n.add(n.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"))}var i=e._getRowCounts();return t==i.count-i.fixedBottom-1},getContentDensity:function(e){var t;var n=["sapUiSizeCondensed","sapUiSizeCompact","sapUiSizeCozy"];var i=function(e,t){if(!t[e]){return}for(var i=0;i<n.length;i++){if(t[e](n[i])){return n[i]}}};var a=e.$();if(a.length>0){t=i("hasClass",a)}else{t=i("hasStyleClass",e)}if(t){return t}var o=null;var r=e.getParent();if(r){do{t=i("hasStyleClass",r);if(t){return t}if(r.getDomRef){o=r.getDomRef()}else if(r.getRootNode){o=r.getRootNode()}if(!o&&r.getParent){r=r.getParent()}else{r=null}}while(r&&!o)}a=jQuery(o||document.body);t=i("hasClass",a.closest("."+n.join(",.")));return t},isVariableWidth:function(e){return!e||e=="auto"||e.toString().match(/%$/)},getFirstFixedBottomRowIndex:function(e){var t=e._getRowCounts();if(!e.getBinding()||t.fixedBottom===0){return-1}var n=-1;var i=e.getFirstVisibleRow();var a=e._getTotalRowCount();if(a>=t.count){n=t.count-t.fixedBottom}else{var o=a-t.fixedBottom-i;if(o>=0&&i+o<a){n=o}}return n},getResourceBundle:function(e){e=jQuery.extend({async:false,reload:false},e);if(R&&e.reload!==true){if(e.async===true){return Promise.resolve(R)}else{return R}}var t=c.getResourceBundleFor("sap.ui.table");R=t;if(e.async===true){t=Promise.resolve(R)}return t},getResourceText:function(e,t){return R?R.getText(e,t):""},dynamicCall:function(e,t,n){var i=typeof e==="function"?e():e;if(!i||!t){return undefined}n=n||i;if(typeof t==="function"){t.call(n,i);return undefined}else{var a;var o=[];for(var r in t){if(typeof i[r]==="function"){a=t[r];o.push(i[r].apply(n,a))}else{o.push(undefined)}}if(o.length===1){return o[0]}else{return o}}},throttle:function(e,t,n){n=Object.assign({leading:true,asyncLeading:false,trailing:true},n);var i;var a=false;var o={};var r;var l;if(n.leading&&n.asyncLeading){r=function(){if(a){var t=Promise.resolve().then(function(){if(!t.canceled){e.apply(o.context,o.args)}i=null});t.cancel=function(){t.canceled=true};i=t}else{e.apply(this,arguments)}}}else{r=e}var s=g(r,t,{leading:n.leading,trailing:n.trailing});if(n.leading&&n.asyncLeading){var u=s.cancel;s.cancel=function(){if(i){i.cancel()}u()};l=Object.assign(function(){o={context:this,args:arguments};a=true;s.apply(this,arguments);a=false},s)}else{l=s}return l},throttleFrameWise:function(e){var t=null;var n=function(){n.cancel();t=window.requestAnimationFrame(function(t){e.apply(this,t)}.bind(this,arguments))};n.cancel=function(){window.cancelAnimationFrame(t);t=null};return n},getInteractiveElements:function(e){if(!e){return null}var t=jQuery(e);var n=U.getCellInfo(t);if(n.isOfType(h.ANY|h.PSEUDO)){var i=t.find(x);if(i.length>0){return i}}return null},getFirstInteractiveElement:function(e,t){if(!e){return null}var n=e.getTable();var i=e.getCells();if(t===true&&U.hasRowActions(n)){i.push(e.getRowAction())}for(var a=0;a<i.length;a++){var o=i[a].getDomRef();var r=U.getCell(n,o,true);var l=U.getInteractiveElements(r);if(l){return l[0]}}return null},convertCSSSizeToPixel:function(e,t){var n;if(typeof e!=="string"){return null}if(e.endsWith("px")){n=parseFloat(e)}else if(e.endsWith("em")||e.endsWith("rem")){n=parseFloat(e)*U.getBaseFontSize()}else{return null}if(t){return n+"px"}else{return n}},getBaseFontSize:function(){if(_==null){var e=document.documentElement;if(e){_=parseInt(window.getComputedStyle(e).fontSize)}}return _==null?16:_},readThemeParameters:function(){var e=u.get({name:["_sap_ui_table_BaseSize","_sap_ui_table_BaseSizeCozy","_sap_ui_table_BaseSizeCompact","_sap_ui_table_BaseSizeCondensed","_sap_ui_table_BaseBorderWidth","_sap_ui_table_NavigationIcon","_sap_ui_table_DeleteIcon","_sap_ui_table_ClearSelectionIcon","_sap_ui_table_NavIndicatorWidth"]});function t(t){return U.convertCSSSizeToPixel(e[t])}w.undefined=t("_sap_ui_table_BaseSize");w.sapUiSizeCozy=t("_sap_ui_table_BaseSizeCozy");w.sapUiSizeCompact=t("_sap_ui_table_BaseSizeCompact");w.sapUiSizeCondensed=t("_sap_ui_table_BaseSizeCondensed");b=t("_sap_ui_table_BaseBorderWidth");I=b;S.undefined=w.undefined+I;S.sapUiSizeCozy=w.sapUiSizeCozy+I;S.sapUiSizeCompact=w.sapUiSizeCompact+I;S.sapUiSizeCondensed=w.sapUiSizeCondensed+I;T.navigationIcon=e["_sap_ui_table_NavigationIcon"];T.deleteIcon=e["_sap_ui_table_DeleteIcon"];T.clearSelectionIcon=e["_sap_ui_table_ClearSelectionIcon"];T.navIndicatorWidth=t("_sap_ui_table_NavIndicatorWidth")},addDelegate:function(e,t,n){if(e&&t){e.addDelegate(t,false,n?n:t,false)}},removeDelegate:function(e,t){if(e&&t){e.removeDelegate(t)}},createWeakMapFacade:function(){var e=new window.WeakMap;return function(t){if(!t||!(typeof t==="object")){return null}if(!e.has(t)){e.set(t,{})}return e.get(t)}},_getTableTemplateHelper:function(e){var t="An automatic control and template generation for the sap.ui.table.Table is not supported "+"anymore for the aggragations footer and title and the aggregations label and template of "+"the sap.ui.table.Columns. Use concrete controls for those aggregations instead of altType string.";if(o.TableHelper){if(!e){p.warning(t)}return o.TableHelper}throw new Error(t)}};e.TableUtils=U;t.TableUtils=U;n.TableUtils=U;i.TableUtils=U;a.TableUtils=U;return U},true);
//# sourceMappingURL=TableUtils.js.map