/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/commons/DropdownBox","sap/ui/commons/MenuButton","sap/ui/commons/SearchField","sap/ui/commons/ToggleButton","sap/ui/core/Control","./Feeder","./library","./FeedRenderer","sap/ui/commons/Menu","sap/ui/core/theming/Parameters","./FeedChunk"],function(t,e,o,i,s,r,n,u,l,h,a){"use strict";var d=n.FeederType;var p=s.extend("sap.ui.ux3.Feed",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},live:{type:"boolean",group:"Behavior",defaultValue:true},title:{type:"string",group:"Data",defaultValue:null}},aggregations:{filterItems:{type:"sap.ui.core.ListItem",multiple:true,singularName:"filterItem",bindable:"bindable"},chunks:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"chunk",bindable:"bindable"},toolsMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"toolsMenuItem",bindable:"bindable"}},events:{filterChange:{parameters:{newValue:{type:"string"}}},search:{parameters:{query:{type:"string"}}},chunkAdded:{parameters:{chunk:{type:"sap.ui.ux3.FeedChunk"}}},toolsItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}},toggleLive:{parameters:{live:{type:"boolean"}}}}}});p.prototype.init=function(){this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.data("sap-ui-fastnavgroup","true",true);this.oFeeder=new r(this.getId()+"-Feeder",{type:d.Medium}).setParent(this);this.oFeeder.attachEvent("submit",this.handleFeederSubmit,this);this.oLiveButton=new i(this.getId()+"-liveButton",{text:this.rb.getText("FEED_LIVE"),pressed:this.getLive(),lite:true}).setParent(this);this.oLiveButton.attachEvent("press",this.handleLiveButtonPress,this);this.oFilter=new t(this.getId()+"-filter").setParent(this);this.oFilter.attachEvent("change",this.handleFilterChange,this);this.oSearchField=new o(this.getId()+"-search",{enableListSuggest:false}).setParent(this);this.oSearchField.attachEvent("search",this.handleSearchFieldSearch,this)};p.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new e(this.getId()+"-toolsButton",{tooltip:this.rb.getText("FEED_TOOLS"),lite:true,menu:new l(this.getId()+"-toolsMenu")}).setParent(this);this.oToolsButton.attachEvent("itemSelected",this.handleLtoolsButtonSelected,this);var t=h._getThemeImage("_sap_ui_ux3_Feed_ToolsIconUrl");var o=h._getThemeImage("_sap_ui_ux3_Feed_ToolsIconHoverUrl");if(t){this.oToolsButton.setProperty("icon",t,true)}if(o){this.oToolsButton.setProperty("iconHovered",o,true)}}};p.prototype.exit=function(){if(this.oFeeder){this.oFeeder.destroy();delete this.oFeeder}if(this.oLiveButton){this.oLiveButton.destroy();delete this.oLiveButton}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton}if(this.oFilter){this.oFilter.destroy();delete this.oFilter}if(this.oSearchField){this.oSearchField.destroy();delete this.oSearchField}this.rb=undefined};p.prototype.handleFeederSubmit=function(t){var e=new Date;var o=String(e);var i=new a(this.getId()+"-new-"+this.getChunks().length,{text:t.getParameter("text"),commentChunk:false,deletionAllowed:true,timestamp:o,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.insertChunk(i,0);this.fireChunkAdded({chunk:i})};p.prototype.handleLiveButtonPress=function(t){var e=t.getParameter("pressed");this.setProperty("live",e,true);this.fireToggleLive({live:e})};p.prototype.handleLtoolsButtonSelected=function(t){this.fireToolsItemSelected(t.mParameters)};p.prototype.handleFilterChange=function(t){this.fireFilterChange(t.mParameters)};p.prototype.handleSearchFieldSearch=function(t){this.fireSearch(t.mParameters)};p.prototype.setFeederThumbnailSrc=function(t){this.setProperty("feederThumbnailSrc",t,true);this.oFeeder.setThumbnailSrc(t);return this};p.prototype.setLive=function(t){this.setProperty("live",t,true);this.oLiveButton.setPressed(t);return this};p.prototype.getToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().getItems()}};p.prototype.insertToolsMenuItem=function(t,e){this.initToolsButton();this.oToolsButton.getMenu().insertItem(t,e);return this};p.prototype.addToolsMenuItem=function(t){this.initToolsButton();this.oToolsButton.getMenu().addItem(t);return this};p.prototype.removeToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(t)}};p.prototype.removeAllToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().removeAllItems()}};p.prototype.indexOfToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().indexOfItem(t)}};p.prototype.destroyToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().destroyItems()}return this};p.prototype.bindToolsMenuItems=function(t,e,o,i){this.initToolsButton();this.oToolsButton.getMenu().bindItems(t,e,o,i);return this};p.prototype.unbindToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems()}return this};p.prototype.getFilterItems=function(){return this.oFilter.getItems()};p.prototype.insertFilterItem=function(t,e){this.oFilter.insertItem(t,e);return this};p.prototype.addFilterItem=function(t){this.oFilter.addItem(t);return this};p.prototype.removeFilterItem=function(t){return this.oFilter.removeItem(t)};p.prototype.removeAllFilterItems=function(){return this.oFilter.removeAllItems()};p.prototype.indexOfFilterItem=function(t){return this.oFilter.indexOfItem(t)};p.prototype.destroyFilterItems=function(){this.oFilter.destroyItems();return this};p.prototype.bindFilterItems=function(t,e,o,i){this.oFilter.bindItems(t,e,o,i);return this};p.prototype.unbindFilterItems=function(){this.oFilter.unbindItems();return this};return p});
//# sourceMappingURL=Feed.js.map