/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./library","./NavigationBarRenderer","sap/ui/commons/Menu","sap/ui/commons/MenuItem","sap/ui/core/Popup","sap/ui/events/jquery/EventSimulation","sap/ui/dom/denormalizeScrollLeftRTL","sap/ui/util/ActivityDetection","sap/ui/Device","sap/base/assert","sap/ui/core/Configuration","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL"],function(jQuery,t,e,i,r,o,a,s,n,l,u,c,f,h){"use strict";var v=s.Dock;var d=t.extend("sap.ui.ux3.NavigationBar",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{toplevelVariant:{type:"boolean",group:"Misc",defaultValue:false},overflowItemsToUpperCase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"item"},overflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.ux3.NavigationItem",multiple:false},associatedItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"associatedItem"}},events:{select:{allowPreventDefault:true,parameters:{itemId:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"}}}}}});d.SCROLL_STEP=250;d.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iLastArrowPos=-100;this._bRtl=h.getRTL();this.allowTextSelection(false);this.startScrollX=0;this.startTouchX=0;var t=this;this._oItemNavigation=(new e).setCycling(false);this.addDelegate(this._oItemNavigation);this.data("sap-ui-fastnavgroup","true",true);if(n.touchEventMode==="ON"){var i=function(e){e.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId)}t.startScrollX=t.getDomRef("list").scrollLeft;t.startTouchX=e.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=(new Date).getTime()};var r=function(e){var i=e.touches[0].pageX-t.startTouchX;var r=t.getDomRef("list");var o=r.scrollLeft;var a=t.startScrollX-i;r.scrollLeft=a;t._bTouchNotMoved=false;var s=(new Date).getTime()-t._lastMoveTime;t._lastMoveTime=(new Date).getTime();if(s>0){t._velocity=(a-o)/s}e.preventDefault()};var o=function(e){if(t._bTouchNotMoved===false){e.preventDefault();var i=t.getDomRef("list");var r=50;var o=Math.abs(t._velocity/10);t._iInertiaIntervalId=setInterval(function(){t._velocity=t._velocity*.8;var e=t._velocity*r;i.scrollLeft=i.scrollLeft+e;if(Math.abs(t._velocity)<o){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined}},r)}else if(t._bTouchNotMoved===true){t.onclick(e);e.preventDefault()}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined};this.ontouchstart=i;this.ontouchend=o;this.ontouchmove=r}};d.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}if(this._checkOverflowIntervalId){clearInterval(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null}};d.prototype.onBeforeRendering=function(){if(this._checkOverflowIntervalId){clearInterval(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null}this._iSoredScrollPosition=this.$("list").scrollLeft();if(c.browser.firefox){this.$().off("DOMMouseScroll",this._handleScroll)}else{this.$().off("mousewheel",this._handleScroll)}var t=this.getDomRef("arrow");this._iLastArrowPos=t?parseInt(this._bRtl?t.style.right:t.style.left):-100};d.prototype.invalidate=function(e){if(e instanceof sap.ui.ux3.NavigationItem){this._menuInvalid=true}t.prototype.invalidate.apply(this,arguments)};d.prototype._calculatePositions=function(){var t=this.getDomRef();this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._checkOverflow(t.firstChild,this.getDomRef("ofb"),this.getDomRef("off"))};d.prototype.onThemeChanged=function(){if(this.getDomRef()){this._calculatePositions()}};d.prototype.onAfterRendering=function(){var t=this.getDomRef();var e=t.firstChild;var i=this.getDomRef("ofb");var r=this.getDomRef("off");this._checkOverflowIntervalId=setInterval(this._checkOverflow.bind(this,e,i,r),350);if(c.browser.firefox){jQuery(t).on("DOMMouseScroll",jQuery.proxy(this._handleScroll,this))}else{jQuery(t).on("mousewheel",jQuery.proxy(this._handleScroll,this))}this._calculatePositions();this._updateItemNavigation();var o=this.$();o.on("scroll",function(){o.children().scrollTop(0);o.scrollTop(0)});if(this._iSoredScrollPosition){this.$("list").scrollLeft(this._iSoredScrollPosition)}};d.prototype._updateItemNavigation=function(){var t=this.getDomRef();if(t){var e=-1;var i=this.getSelectedItem();var r=jQuery(t).children().children("li").children().not(".sapUiUx3NavBarDummyItem");r.each(function(t,r){if(r.id==i){e=t}});this._oItemNavigation.setRootDomRef(t);this._oItemNavigation.setItemDomRefs(r.toArray());this._oItemNavigation.setSelectedIndex(e)}};d.prototype.onsapspace=function(t){this._handleActivation(t)};d.prototype.onclick=function(t){this._handleActivation(t)};d.prototype.setOverflowItemsToUpperCase=function(t){this._getOverflowMenu().toggleStyleClass("sapUiUx3NavBarUpperCaseText",t);return this.setProperty("overflowItemsToUpperCase",t)};d.prototype._handleActivation=function(t){var e=t.target.id;if(e){var i=this.getId();t.preventDefault();if(e==i+"-ofb"){this._scroll(-d.SCROLL_STEP,500)}else if(e==i+"-off"){this._scroll(d.SCROLL_STEP,500)}else if(e==i+"-oflt"||e==i+"-ofl"){this._showOverflowMenu()}else{var r=sap.ui.getCore().byId(e);if(r&&e!=this.getSelectedItem()&&sap.ui.getCore().byId(e)instanceof sap.ui.ux3.NavigationItem){if(this.fireSelect({item:r,itemId:e})){this.setAssociation("selectedItem",r,true);this._updateSelection(e)}}}}};d.prototype._getOverflowMenu=function(){var t=this.getAggregation("overflowMenu");if(!t||this._menuInvalid){if(t){t.destroyAggregation("items",true)}else{t=new o}var e=this._getCurrentItems();var i=this;var r=this.getSelectedItem();for(var s=0;s<e.length;++s){var n=e[s];var l=new a(n.getId()+"-overflowItem",{text:n.getText(),visible:n.getVisible(),icon:r==n.getId()?"sap-icon://accept":null,select:function(t){return function(e){i._handleActivation({target:{id:t.getId()},preventDefault:function(){}})}}(n)});t.addAggregation("items",l,true)}this.setAggregation("overflowMenu",t,true);this._menuInvalid=false}return t};d.prototype._getCurrentItems=function(){var t=this.getItems();if(t.length<1){t=this.getAssociatedItems();var e=sap.ui.getCore();for(var i=0;i<t.length;++i){t[i]=e.byId(t[i])}}return t};d.prototype._showOverflowMenu=function(){var t=this._getOverflowMenu();var e=this.$("ofl").get(0);t.open(true,e,v.EndTop,v.CenterCenter,e)};d.prototype._updateSelection=function(t){this._menuInvalid=true;var e=jQuery(document.getElementById(t));e.attr("tabindex","0").attr("aria-checked","true");e.parent().addClass("sapUiUx3NavBarItemSel");e.parent().parent().children().each(function(){var e=this.firstChild;if(e&&e.id!=t&&e.className.indexOf("Dummy")==-1){jQuery(e).attr("tabindex","-1");jQuery(e).parent().removeClass("sapUiUx3NavBarItemSel");jQuery(e).attr("aria-checked","false")}});var i=e.parent().index();if(i>0){i--}this._oItemNavigation.setSelectedIndex(i);var r=this.$("arrow");var o=r.outerWidth();var a=d._getArrowTargetPos(t,o,this._bRtl);r.stop();var s=this._bRtl?{right:a+"px"}:{left:a+"px"};r.animate(s,500,"linear");var n=this;window.setTimeout(function(){a=d._getArrowTargetPos(t,o,n._bRtl);r.stop();var e=n._bRtl?{right:a+"px"}:{left:a+"px"};r.animate(e,200,"linear",function(){var e=t?window.document.getElementById(t):null;n._scrollItemIntoView(e)})},300)};d.prototype._scrollItemIntoView=function(t){if(!t){return}var e=jQuery(t.parentNode);var i=e.parent();var r;var o=h.getRTL();var a=e.index()-1;if(a==0){r=o?i[0].scrollWidth-i.innerWidth()+20:0}else if(a==e.siblings().length-2){r=o?0:i[0].scrollWidth-i.innerWidth()+20}else{var s=e.position().left;var n=o?i.scrollLeftRTL():i.scrollLeft();if(s<0){r=n+s}else{var u=i.innerWidth()-(s+e.outerWidth(true));if(u<0){r=n-u;r=Math.min(r,n+s)}}}if(r!==undefined){if(o){r=l(r,i.get(0))}i.stop(true,true).animate({scrollLeft:r})}};d._getArrowTargetPos=function(t,e,i){var r=jQuery(document.getElementById(t));if(r.length>0){var o=r.outerWidth();var a=Math.round(r[0].offsetLeft+o/2-e/2);if(!i){return a}else{return r.parent().parent().innerWidth()-a-e}}else{return-100}};d.prototype._handleScroll=function(t){if(t.type=="DOMMouseScroll"){var e=t.originalEvent.detail*40;this._scroll(e,50)}else{var e=-t.originalEvent.wheelDelta;this._scroll(e,50)}t.preventDefault()};d.prototype._scroll=function(t,e){var i=this.$()[0].firstChild;var r=i.scrollLeft;if(!c.browser.msie&&this._bRtl){t=-t}var o=r+t;jQuery(i).stop(true,true).animate({scrollLeft:o},e)};d.prototype._checkOverflow=function(t,e,i){function r(){return c.os.macintosh&&c.browser.chrome}if(t&&this.getDomRef()&&u.isActive()){var o=t.scrollLeft;var a=false;var s=false;var n=t.scrollWidth;var l=t.clientWidth;var f=r()?5:0;if(Math.abs(n-l)==1){n=l}if(!this._bRtl){if(o>f){a=true}if(n>l&&n-(o+l)>f){s=true}}else{var h=jQuery(t);if(h.scrollLeftRTL()>f){s=true}if(h.scrollRightRTL()>f){a=true}}if(s!=this._bPreviousScrollForward||a!=this._bPreviousScrollBack){this._bPreviousScrollForward=s;this._bPreviousScrollBack=a;this.$().toggleClass("sapUiUx3NavBarScrollBack",a).toggleClass("sapUiUx3NavBarScrollForward",s);if(!d._bMenuLoaded&&(a||s)){d._bMenuLoaded=true}}var v=sap.ui.getCore().byId(this.getSelectedItem());if(v){var p=this.$("arrow");var m=p.outerWidth();var g=d._getArrowTargetPos(v.getId(),m,this._bRtl)+"px";if(!this._bRtl){if(p[0].style.left!=g){p[0].style.left=g}}else{if(p[0].style.right!=g){p[0].style.right=g}}}}};d.prototype.setSelectedItem=function(t){this.setAssociation("selectedItem",t,true);if(this.getDomRef()){var e=!t||typeof t=="string"?t:t.getId();this._updateSelection(e)}return this};d.prototype.addItem=function(t){this._menuInvalid=true;return this.addAggregation("items",t)};d.prototype.destroyItems=function(){this._menuInvalid=true;return this.destroyAggregation("items")};d.prototype.insertItem=function(t,e){this._menuInvalid=true;return this.insertAggregation("items",t,e)};d.prototype.removeItem=function(t){this._menuInvalid=true;return this.removeAggregation("items",t)};d.prototype.removeAllItems=function(){this._menuInvalid=true;return this.removeAllAggregation("items")};d.prototype.addAssociatedItem=function(t){this._menuInvalid=true;return this.addAssociation("associatedItems",t)};d.prototype.removeAssociatedItem=function(t){this._menuInvalid=true;return this.removeAssociation("associatedItems",t)};d.prototype.removeAllAssociatedItems=function(){this._menuInvalid=true;return this.removeAllAssociation("associatedItems")};d.prototype.setAssociatedItems=function(t){f(Array.isArray(t),"aItems must be an array");var e=this.getDomRef("list");this.removeAllAssociation("associatedItems",true);for(var i=0;i<t.length;i++){this.addAssociation("associatedItems",t[i],true)}if(e){var o=jQuery(e).find(":focus");var a=o.length>0?o.attr("id"):null;if(arguments.length>1&&typeof arguments[1]==="boolean"){this._iLastArrowPos=-100}else{var s=this.getDomRef("arrow");this._iLastArrowPos=parseInt(this._bRtl?s.style.right:s.style.left)}e.innerHTML="";var n=sap.ui.getCore().createRenderManager();r.renderItems(n,this);n.flush(e,true);n.destroy();var l=a?document.getElementById(a):null;if(l){l.focus()}this._updateSelection(this.getSelectedItem());this._updateItemNavigation()}return this};d.prototype.isSelectedItemValid=function(){var t=this.getSelectedItem();if(!t){return false}var e=this.getItems();if(!e||e.length==0){e=this.getAssociatedItems();for(var i=0;i<e.length;i++){if(e[i]==t){return true}}}else{for(var i=0;i<e.length;i++){if(e[i].getId()==t){return true}}}return false};return d});
//# sourceMappingURL=NavigationBar.js.map