sap.ui.define(["exports","sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/decorators/customElement","sap/ui/webc/common/thirdparty/base/decorators/property","sap/ui/webc/common/thirdparty/base/decorators/event","sap/ui/webc/common/thirdparty/base/Keys","sap/ui/webc/common/thirdparty/base/types/CSSColor","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/types/Float","sap/ui/webc/common/thirdparty/base/i18nBundle","sap/ui/webc/common/thirdparty/base/CustomElementsScope","sap/ui/webc/common/thirdparty/base/util/ColorConversion","./generated/templates/ColorPickerTemplate.lit","./Input","./Slider","./Label","./generated/i18n/i18n-defaults","./generated/themes/ColorPicker.css"],function(e,t,o,s,r,i,a,l,n,h,u,d,c,f,_,p,g,C,b){"use strict";Object.defineProperty(e,"__esModule",{value:true});e.default=void 0;t=m(t);o=m(o);s=m(s);r=m(r);a=m(a);l=m(l);n=m(n);h=m(h);f=m(f);_=m(_);p=m(p);g=m(g);b=m(b);function m(e){return e&&e.__esModule?e:{default:e}}var y=void 0&&(void 0).__decorate||function(e,t,o,s){var r=arguments.length,i=r<3?t:s===null?s=Object.getOwnPropertyDescriptor(t,o):s,a;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")i=Reflect.decorate(e,t,o,s);else for(var l=e.length-1;l>=0;l--)if(a=e[l])i=(r<3?a(i):r>3?a(t,o,i):a(t,o))||i;return r>3&&i&&Object.defineProperty(t,o,i),i};var w;const E=6.5;let v=w=class e extends t.default{static async onDefine(){w.i18nBundle=await(0,u.getI18nBundle)("@ui5/webcomponents")}constructor(){super();this._selectedCoordinates={x:256-E,y:256-E};this._mainColor={r:255,g:0,b:0};this.selectedHue=0;this.mouseDown=false;this.mouseIn=false}onBeforeRendering(){this._color=(0,c.getRGBColor)(this.color);const e=`rgba(${this._color.r}, ${this._color.g}, ${this._color.b}, 1)`;this._setHex();this._setValues();this.style.setProperty((0,d.getScopedVarName)("--ui5_Color_Picker_Progress_Container_Color"),e)}_handleMouseDown(e){this.mouseDown=true;this.mouseIn=true;this._changeSelectedColor(e.offsetX,e.offsetY)}_handleMouseUp(){this.mouseDown=false}_handleMouseOut(e){if(!this.mouseIn||!this.mouseDown){return}const t=e.target;const o=t.offsetHeight;const s=t.offsetWidth;const r=e.offsetX<=0;const i=e.offsetY<=0;const a=e.offsetY>=t.offsetHeight;const l=e.offsetX>=t.offsetWidth;let n,h;if(r){n=0}else if(l){n=s}else{n=e.offsetX}if(i){h=0}else if(a){h=o}else{h=e.offsetY}this._changeSelectedColor(n,h);this.mouseIn=false;this.mouseDown=false}_handleMouseMove(e){if(!this.mouseDown||!this.mouseIn){return}this._changeSelectedColor(e.offsetX,e.offsetY)}_handleAlphaInput(e){const t=e.target.value;this._alpha=parseFloat(t);this._setColor(this._color)}_handleHueInput(e){this.selectedHue=e.target.value;this._hue=this.selectedHue;this._setMainColor(this._hue);this._isHueValueChanged=true;const t=this._selectedCoordinates.x+E;const o=this._selectedCoordinates.y+E;const s=this._calculateColorFromCoordinates(t,o);if(s){this._setColor((0,c.HSLToRGB)(s))}}_handleHEXChange(e){const t=new RegExp("^[<0-9 abcdef]+$");const o=e.target;let s=o.value.toLowerCase();if(s.length===3){s=`${s[0]}${s[0]}${s[1]}${s[1]}${s[2]}${s[2]}`}const r=s.length===6&&t.test(s);if(r&&o.value!==s){this._wrongHEX=false;o.value=s}if(s===this.hex){return}this.hex=s;if(!r){this._wrongHEX=true}else{this._wrongHEX=false;this._setColor((0,c.HEXToRGB)(this.hex))}}_handleRGBInputsChange(e){const t=e.target;const o=parseInt(t.value)||0;let s;switch(t.id){case"red":s={...this._color,r:o};break;case"green":s={...this._color,g:o};break;case"blue":s={...this._color,b:o};break;default:s={...this._color}}this._setColor(s)}_setMainColor(e){if(e<=255){this._mainColor={r:255,g:e,b:0}}else if(e<=510){this._mainColor={r:255-(e-255),g:255,b:0}}else if(e<=765){this._mainColor={r:0,g:255,b:e-510}}else if(e<=1020){this._mainColor={r:0,g:765-(e-255),b:255}}else if(e<=1275){this._mainColor={r:e-1020,g:0,b:255}}else{this._mainColor={r:255,g:0,b:1275-(e-255)}}}_handleAlphaChange(){this._alpha=this._alpha<0?0:this._alpha;this._alpha=this._alpha>1?1:this._alpha}_changeSelectedColor(e,t){this._selectedCoordinates={x:e-E,y:t-E};this._isSelectedColorChanged=true;const o=this._calculateColorFromCoordinates(e,t);if(o){this._setColor((0,c.HSLToRGB)(o))}}_onkeydown(e){if((0,i.isEnter)(e)){this._handleHEXChange(e)}}_calculateColorFromCoordinates(e,t){const o=this._hue/4.25;const s=1-+(Math.round(parseFloat(t/256+"e+2"))+"e-2");const r=+(Math.round(parseFloat(e/256+"e+2"))+"e-2");if(!s||!r){return}return{h:o,s:s,l:r}}_setColor(e={r:0,g:0,b:0}){this.color=`rgba(${e.r}, ${e.g}, ${e.b}, ${this._alpha})`;this._wrongHEX=!this.isValidRGBColor(e);this.fireEvent("change")}isValidRGBColor(e){return e.r>=0&&e.r<=255&&e.g>=0&&e.g<=255&&e.b>=0&&e.b<=255}_setHex(){let e=this._color.r.toString(16),t=this._color.g.toString(16),o=this._color.b.toString(16);if(e.length===1){e=`0${e}`}if(t.length===1){t=`0${t}`}if(o.length===1){o=`0${o}`}this.hex=e+t+o}_setValues(){const e=(0,c.RGBToHSL)(this._color);this._selectedCoordinates={x:Math.round(e.l*100)*2.56-E,y:256-Math.round(e.s*100)*2.56-E};if(this._isSelectedColorChanged){this._isSelectedColorChanged=false}else if(this._isHueValueChanged){this._isHueValueChanged=false;this._hue=this.selectedHue?this.selectedHue:this._hue}else{this._hue=Math.round(e.h*4.25)}this._setMainColor(this._hue)}get hueSliderLabel(){return w.i18nBundle.getText(C.COLORPICKER_HUE_SLIDER)}get alphaSliderLabel(){return w.i18nBundle.getText(C.COLORPICKER_ALPHA_SLIDER)}get hexInputLabel(){return w.i18nBundle.getText(C.COLORPICKER_HEX)}get redInputLabel(){return w.i18nBundle.getText(C.COLORPICKER_RED)}get greenInputLabel(){return w.i18nBundle.getText(C.COLORPICKER_GREEN)}get blueInputLabel(){return w.i18nBundle.getText(C.COLORPICKER_BLUE)}get alphaInputLabel(){return w.i18nBundle.getText(C.COLORPICKER_ALPHA)}get inputsDisabled(){return this._wrongHEX?true:undefined}get hexInputErrorState(){return this._wrongHEX?"Error":undefined}get styles(){return{mainColor:{"background-color":`rgb(${this._mainColor.r}, ${this._mainColor.g}, ${this._mainColor.b})`},circle:{left:`${this._selectedCoordinates.x}px`,top:`${this._selectedCoordinates.y}px`},colorSpan:{"background-color":`rgba(${this._color.r}, ${this._color.g}, ${this._color.b}, ${this._alpha})`}}}};y([(0,s.default)({validator:a.default,defaultValue:"rgba(255, 255, 255, 1)"})],v.prototype,"color",void 0);y([(0,s.default)({defaultValue:"ffffff",noAttribute:true})],v.prototype,"hex",void 0);y([(0,s.default)({type:Object})],v.prototype,"_mainColor",void 0);y([(0,s.default)({type:Object})],v.prototype,"_color",void 0);y([(0,s.default)({type:Object})],v.prototype,"_selectedCoordinates",void 0);y([(0,s.default)({validator:h.default,defaultValue:1})],v.prototype,"_alpha",void 0);y([(0,s.default)({validator:n.default,defaultValue:0})],v.prototype,"_hue",void 0);y([(0,s.default)({type:Boolean})],v.prototype,"_isSelectedColorChanged",void 0);y([(0,s.default)({type:Boolean})],v.prototype,"_isHueValueChanged",void 0);y([(0,s.default)({type:Boolean})],v.prototype,"_wrongHEX",void 0);v=w=y([(0,o.default)({tag:"ui5-color-picker",renderer:l.default,styles:b.default,template:f.default,dependencies:[_.default,p.default,g.default]}),(0,r.default)("change")],v);v.define();var R=v;e.default=R});
//# sourceMappingURL=ColorPicker.js.map