sap.ui.define(["exports","sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/decorators/customElement","sap/ui/webc/common/thirdparty/base/decorators/property","sap/ui/webc/common/thirdparty/base/decorators/event","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","sap/ui/webc/common/thirdparty/base/types/Float","sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/delegate/ResizeHandler","sap/ui/webc/common/thirdparty/base/Device","sap/ui/webc/common/thirdparty/icons/direction-arrows","sap/ui/webc/common/thirdparty/base/Keys","./generated/themes/SliderBase.css"],function(e,t,i,s,r,n,o,a,l,u,d,c,h){"use strict";Object.defineProperty(e,"__esModule",{value:true});e.default=void 0;t=p(t);i=p(i);s=p(s);r=p(r);n=p(n);o=p(o);a=p(a);l=p(l);h=p(h);function p(e){return e&&e.__esModule?e:{default:e}}var f=void 0&&(void 0).__decorate||function(e,t,i,s){var r=arguments.length,n=r<3?t:s===null?s=Object.getOwnPropertyDescriptor(t,i):s,o;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")n=Reflect.decorate(e,t,i,s);else for(var a=e.length-1;a>=0;a--)if(o=e[a])n=(r<3?o(n):r>3?o(t,i,n):o(t,i))||n;return r>3&&n&&Object.defineProperty(t,i,n),n};var _;let m=_=class e extends t.default{constructor(){super();this.notResized=false;this._isUserInteraction=false;this._isInnerElementFocusing=false;this._labelWidth=0;this._resizeHandler=this._handleResize.bind(this);this._moveHandler=this._handleMove.bind(this);this._upHandler=this._handleUp.bind(this);this._stateStorage={step:undefined,min:undefined,max:undefined,labelInterval:undefined};const e=e=>{this._onmousedown(e)};this._ontouchstart={handleEvent:e,passive:true}}_handleMove(e){}_handleUp(){}_onmousedown(e){}_handleActionKeyPress(e){}static get ACTION_KEYS(){return[c.isLeft,c.isRight,c.isUp,c.isDown,c.isLeftCtrl,c.isRightCtrl,c.isUpCtrl,c.isDownCtrl,c.isPlus,c.isMinus,c.isHome,c.isEnd,c.isPageUp,c.isPageDown,c.isEscape]}static get MIN_SPACE_BETWEEN_TICKMARKS(){return 8}static get TOOLTIP_VISIBILITY(){return{VISIBLE:"visible",HIDDEN:"hidden"}}get classes(){return{root:{"ui5-slider-root-phone":(0,u.isPhone)()},labelContainer:{"ui5-slider-hidden-labels":this._labelsOverlapping}}}onEnterDOM(){l.default.register(this,this._resizeHandler)}onExitDOM(){l.default.deregister(this,this._resizeHandler)}onAfterRendering(){if(this.notResized){this._resizeHandler()}}_onmouseover(){if(this.showTooltip){this._tooltipVisibility=_.TOOLTIP_VISIBILITY.VISIBLE}}_onmouseout(){if(this.showTooltip&&!this.shadowRoot.activeElement){this._tooltipVisibility=_.TOOLTIP_VISIBILITY.HIDDEN}}_onkeydown(e){if(this.disabled||this._effectiveStep===0){return}if(_._isActionKey(e)){e.preventDefault();this._isUserInteraction=true;this._handleActionKeyPress(e)}}_onkeyup(){if(this.disabled){return}this._isUserInteraction=false}_preserveFocus(e){this._isInnerElementFocusing=e}_isFocusing(){return this._isInnerElementFocusing}_preventFocusOut(){this.focusInnerElement()}focusInnerElement(){this.focus()}_handleResize(){if(!this.showTickmarks){return}this.notResized=false;const e=this._spaceBetweenTickmarks();if(e<_.MIN_SPACE_BETWEEN_TICKMARKS){this._hiddenTickmarks=true;this._labelsOverlapping=true}else{this._hiddenTickmarks=false}if(this.labelInterval<=0||this._hiddenTickmarks){return}const t=this.shadowRoot.querySelectorAll(".ui5-slider-labels li");this._labelsOverlapping=[...t].some(e=>e.scrollWidth>e.clientWidth)}handleDownBase(e){const t=this._effectiveMin;const i=this._effectiveMax;const s=this.getBoundingClientRect();const r=this.directionStart;const n=this._effectiveStep;const o=_.getValueFromInteraction(e,n,t,i,s,r);this._isUserInteraction=true;window.addEventListener("mouseup",this._upHandler);window.addEventListener("touchend",this._upHandler);if((0,u.supportsTouch)()&&e instanceof TouchEvent){window.addEventListener("touchmove",this._moveHandler)}else{window.addEventListener("mousemove",this._moveHandler)}this._handleFocusOnMouseDown(e);return o}_handleFocusOnMouseDown(e){const t=this.shadowRoot.activeElement;if(!t||t!==e.target){this._preserveFocus(true);this.focusInnerElement()}}handleUpBase(){window.removeEventListener("mouseup",this._upHandler);window.removeEventListener("touchend",this._upHandler);window.removeEventListener("mousemove",this._moveHandler);window.removeEventListener("touchmove",this._moveHandler);this._isUserInteraction=false;this._preserveFocus(false)}updateStateStorageAndFireInputEvent(e){this.storePropertyState(e);if(this._isUserInteraction){this.fireEvent("input")}}static _isActionKey(e){return this.ACTION_KEYS.some(t=>t(e))}static clipValue(e,t,i){e=Math.min(Math.max(e,t),i);return e}static getValueFromInteraction(e,t,i,s,r,n){const o=this.getPageXValueFromEvent(e);const a=this.computedValueFromPageX(o,i,s,r,n);const l=this.getSteppedValue(a,t,i);return this.clipValue(l,i,s)}static getSteppedValue(e,t,i){const s=Math.abs((e-i)%t);if(t===0||s===0){return e}e=s*2>=t?e+t-s:e-s;const r=_._getDecimalPrecisionOfNumber(t);return Number(e.toFixed(r))}static getPageXValueFromEvent(e){if((0,u.supportsTouch)()&&e instanceof TouchEvent){if(e.targetTouches&&e.targetTouches.length>0){return e.targetTouches[0].pageX}return 0}return e.pageX}static computedValueFromPageX(e,t,i,s,r){const n=r==="left"?e-s[r]:s[r]-e;const o=n/s.width;return t+o*(i-t)}static _getDecimalPrecisionOfNumber(e){if(Number.isInteger(e)){return 0}const t=String(e).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);if(!t||t.length<2){return 0}return Math.max(0,(t[1]?t[1].length:0)-(t[2]?Number(t[2]):0))}isCurrentStateOutdated(){return Object.entries(this._stateStorage).some(([e,t])=>this[e]!==t)}getStoredPropertyState(e){return this._stateStorage[e]}isPropertyUpdated(...e){return e.some(e=>this.getStoredPropertyState(e)!==this[e])}storePropertyState(...e){e.forEach(e=>{this._stateStorage[e]=this[e]})}get directionStart(){return this.effectiveDir==="rtl"?"right":"left"}_createLabels(){if(!this.labelInterval||!this.showTickmarks){return}const e=this.labelInterval;const t=this._effectiveStep;const i=(this._effectiveMax-this._effectiveMin)/(t*e);if(i===this._oldNumberOfLabels){return}this._oldNumberOfLabels=i;this._labelWidth=100/i;this._labelValues=[];const s=_._getDecimalPrecisionOfNumber(t);for(let r=0;r<=i;r++){const i=(r*t*e+this._effectiveMin).toFixed(s);this._labelValues.push(i)}}_handleActionKeyPressBase(e,t){const i=_._isIncreaseValueAction(e);const s=_._isBigStepAction(e);const r=this[t];const n=this._effectiveMin;const o=this._effectiveMax;let a=this.effectiveDir==="rtl"?-this._effectiveStep:this._effectiveStep;a=s&&(o-n)/a>10?(o-n)/10:a;if((0,c.isEnd)(e)){return o-r}if((0,c.isHome)(e)){return(r-n)*-1}return i?a:a*-1}static _isDecreaseValueAction(e){return(0,c.isDown)(e)||(0,c.isDownCtrl)(e)||(0,c.isLeft)(e)||(0,c.isLeftCtrl)(e)||(0,c.isMinus)(e)||(0,c.isPageDown)(e)}static _isIncreaseValueAction(e){return(0,c.isUp)(e)||(0,c.isUpCtrl)(e)||(0,c.isRight)(e)||(0,c.isRightCtrl)(e)||(0,c.isPlus)(e)||(0,c.isPageUp)(e)}static _isBigStepAction(e){return(0,c.isDownCtrl)(e)||(0,c.isUpCtrl)(e)||(0,c.isLeftCtrl)(e)||(0,c.isRightCtrl)(e)||(0,c.isPageUp)(e)||(0,c.isPageDown)(e)}get _tickmarksCount(){return(this._effectiveMax-this._effectiveMin)/this._effectiveStep}_spaceBetweenTickmarks(){return this.getBoundingClientRect().width/this._tickmarksCount}_validateStep(e){if(e===0){console.warn("The 'step' property must be a positive float number")}if(e<0){console.warn("The 'step' property must be a positive float number. The provided negative number has been converted to its positve equivalent")}if(Number.isNaN(e)){console.warn("The 'step' property must be a positive float number. It has been set to its default value of 1")}}get _labels(){return this._labelValues||[]}get _effectiveStep(){let e=this.step;if(e<0){e=Math.abs(e)}if(Number.isNaN(e)){e=1}return e}get _effectiveMin(){return Math.min(this.min,this.max)}get _effectiveMax(){return Math.max(this.min,this.max)}get _tabIndex(){return this.disabled?"-1":"0"}get _ariaLabelledByHandleRefs(){return[`${this._id}-accName`,`${this._id}-sliderDesc`].join(" ").trim()}};f([(0,s.default)({validator:o.default,defaultValue:0})],m.prototype,"min",void 0);f([(0,s.default)({validator:o.default,defaultValue:100})],m.prototype,"max",void 0);f([(0,s.default)({validator:o.default,defaultValue:1})],m.prototype,"step",void 0);f([(0,s.default)({validator:a.default,defaultValue:0})],m.prototype,"labelInterval",void 0);f([(0,s.default)({type:Boolean})],m.prototype,"showTickmarks",void 0);f([(0,s.default)({type:Boolean})],m.prototype,"showTooltip",void 0);f([(0,s.default)({type:Boolean})],m.prototype,"disabled",void 0);f([(0,s.default)()],m.prototype,"accessibleName",void 0);f([(0,s.default)({defaultValue:"hidden"})],m.prototype,"_tooltipVisibility",void 0);f([(0,s.default)({type:Boolean})],m.prototype,"_labelsOverlapping",void 0);f([(0,s.default)({type:Boolean})],m.prototype,"_hiddenTickmarks",void 0);m=_=f([(0,i.default)({renderer:n.default,styles:h.default}),(0,r.default)("change"),(0,r.default)("input")],m);var v=m;e.default=v});
//# sourceMappingURL=SliderBase.js.map