/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/base/util/array/diff","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/events/KeyCodes","sap/ui/dom/getFirstEditableInput","sap/ui/dom/units/Rem","sap/ui/base/Object"],function(jQuery,e,t,i,o,n,r,s,a,l,h,c,d,g,u,_,p,f,S,b,y,T,H,A,C,I,P,v,B){"use strict";var O=p.TitleLevel;var L=p.AccessibleLandmarkRole;var E=f.ObjectPageSubSectionLayout;var m=["toggleAnchorBar","_moveHeader"];var R=o.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:E.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:O.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},headerContentPinned:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"}},events:{headerContentPinnedStateChange:{parameters:{pinned:{type:"boolean"}}},toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},sectionChange:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},editHeaderButtonPress:{},beforeNavigate:{allowPreventDefault:true,parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}},subSectionVisibilityChange:{parameters:{visibleSubSections:{type:"object"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"},renderer:S});R.HEADER_CALC_DELAY=350;R.DOM_CALC_DELAY=200;R.MAX_SNAP_POSITION_OFFSET=20;R.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=.6;R.TITLE_LEVEL_AS_ARRAY=Object.keys(O);R.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};R.BREAK_POINTS={DESKTOP:1439,TABLET:1024,PHONE:600};R.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop",DESKTOP_XL:"sapUxAPObjectPageLayout-Std-Desktop-XL"};R.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop",DESKTOP_XL:"sapFDynamicPage-Std-Desktop-XL"};R.DIV="div";R.HEADER="header";R.FOOTER="section";R.HEADER_CONTENT_PADDING_BOTTOM=v.toPx("1rem");R.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";R.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";R.NO_NAVIGATION_CLASS_NAME="sapUxAPObjectPageNoNavigation";R.ARIA={LABEL_TOOLBAR_FOOTER_ACTIONS:"ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS"};R.prototype._getFirstEditableInput=function(e){var t=this.getDomRef(e);return P(t)};R.prototype._focusFirstEditableInput=function(e){this._getFirstEditableInput(e).focus()};R._getNextTitleLevelEntry=function(e){var t=R.TITLE_LEVEL_AS_ARRAY.indexOf(e),i=t!==-1,o=i&&t!==R.TITLE_LEVEL_AS_ARRAY.length-1;if(!i){return O.Auto}return R.TITLE_LEVEL_AS_ARRAY[o?t+1:t]};R._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap")};R.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._oVisibleSubSections=0;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iHeaderContentPaddingBottom=0;this._oScrollContainerLastState={};this._iREMSize=parseInt(jQuery("body").css("font-size"));this._iOffset=parseInt(.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new u(this);this._initializeScroller();this._attachSnapListeners()};R.prototype.onBeforeRendering=function(){var e,t;this._deregisterScreenSizeListener();this._deregisterTitleSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy()}this._oLazyLoading=new g(this);this._deregisterCustomEvents();if(!this.getVisible()){return}if(!this.getSelectedSection()){this._bHeaderExpanded=true}this._bMobileScenario=f.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=f.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();if(!A(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false}this._bStickyAnchorBar=this._shouldPreserveHeaderInTitleArea();this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();e=this._getHeaderContent();if(e&&e.supportsPinUnpin()){t=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(t);if(t){this._attachPinPressHandler()}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);if(r.system.desktop){this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this)}if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter())}this._$titleArea=[];this._setFooterAriaLabelledBy()};R.prototype._setFooterAriaLabelledBy=function(){var e=this.getFooter();if(e&&!e.getAriaLabelledBy().length){this._oInvisibleText=new n({id:e.getId()+"-FooterActions-InvisibleText",text:R._getLibraryResourceBundle().getText(R.ARIA.LABEL_TOOLBAR_FOOTER_ACTIONS)}).toStatic();e.addAriaLabelledBy(this._oInvisibleText)}};R.prototype._destroyInvisibleText=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};R.prototype.setBackgroundDesignAnchorBar=function(e){var t=this.getBackgroundDesignAnchorBar();if(t===e){return this}this.setProperty("backgroundDesignAnchorBar",e);this._oABHelper._getAnchorBar().setBackgroundDesign(e);return this};R.prototype.setToggleHeaderOnTitleClick=function(e){var t=this.getHeaderTitle(),i=this.setProperty("toggleHeaderOnTitleClick",e,true);if(!t||!t.supportsToggleHeaderOnTitleClick()){b.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return i}e=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return i};R.prototype._attachTitlePressHandler=function(){var e=this.getHeaderTitle();if(D(e)&&!this._bAlreadyAttachedTitlePressHandler){e.attachEvent(R.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true}};R.prototype._attachSnapListeners=function(){m.forEach(function(e){this.attachEvent(e,function(){this.fireEvent("_snapChange")})},this)};R.prototype._toggleHeaderVisibility=function(e){var t=this._getHeaderContent();if(D(t)){t.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!e)}};R.prototype._snapHeader=function(e,t){var i,o=this._getHeaderContent();if(o&&o.supportsPinUnpin()&&this._bPinned){this._unPin(t);o.getAggregation("_pinButton").setPressed(false);e=true}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(e);this._moveAnchorBarToTitleArea();if(e){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);i=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1;if(i){this._scrollTo(this._getSnapPosition()+1)}return}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout()};R.prototype._expandHeader=function(e){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(e){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0);this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea())}};R.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return}var e=!this._bHeaderExpanded,t,i,o;if(e){t=this._$opWrapper.scrollTop()<=this._getSnapPosition()+1;i=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!t);this._expandHeader(i);if(!i){this._scrollTo(0,0)}}else{o=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(o,true)}this.getHeaderTitle()._getFocusSpan().trigger("focus")};R.prototype._attachPinPressHandler=function(){var e=this._getHeaderContent();if(D(e)&&!this._bAlreadyAttachedPinPressHandler){e.attachEvent(R.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true}};R.prototype._handleExpandButtonPressEventLifeCycle=function(e){var t=this.getHeaderTitle(),i=this._hasDynamicTitle(),o;if(t&&!i){o=t.getAggregation("_expandButton");if(o){o[e?"attachPress":"detachPress"](this._handleExpandButtonPress,this)}}};R.prototype._adjustSelectedSectionByUXRules=function(){var e=this.oCore.byId(this.getSelectedSection()),t=e&&this._sectionCanBeRenderedByUXRules(e);if(!t){if(this._oFirstVisibleSection){e=this._oFirstVisibleSection;this.setAssociation("selectedSection",e.getId(),true)}else{this.setAssociation("selectedSection",null,true);return}}};R.prototype._sectionCanBeRenderedByUXRules=function(e){if(!(e instanceof l)){return false}var t=e.getBindingInfo("subSections");if(!t&&(!e.getVisible()||!e._getInternalVisible())){return false}var i=this._aSectionBases.map(function(e){return e.getId()});return i.indexOf(e.getId())>-1};R.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var e=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&e){return[e]}else{return this.getSections()}};R.prototype._preloadSectionsOnBeforeFirstRendering=function(){var e=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(e);if(this.getEnableLazyLoading()){e.forEach(function(e){this.fireEvent("subSectionPreload",{subSection:e})},this)}};R.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var e,t,i;if(!this.getEnableLazyLoading()){return this._getSectionsToRender()}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases())}this._adjustSelectedSectionByUXRules();t=this.oCore.byId(this.getSelectedSection());if(!t||t===this._oFirstVisibleSection){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases)}i=this.indexOfSection(t);var o=function(e){var t=e.isA("sap.uxap.ObjectPageSection")?e:e.getParent();return this.indexOfSection(t)>=i}.bind(this);e=this._aSectionBases.filter(o);return this._oLazyLoading.getSubsectionsToPreload(e)};R.prototype._grepCurrentTabSectionBases=function(){var e=[],t,i,o,n;this._adjustSelectedSectionByUXRules();t=this.oCore.byId(this.getSelectedSection());if(t){i=t.getId();this._aSectionBases.forEach(function(t){o=t.getParent();n=o&&o.getId();if(t.getId()===i||n===i){e.push(t)}})}return e};R.prototype.onAfterRendering=function(){var e=this._getHeaderContent(),i=this._getWidth(this);this._bInvalidatedAndNotRerendered=false;this._ensureCorrectParentHeight();this._cacheDomElements();this._iResizeId=t.register(this,this._onUpdateScreenSize.bind(this));this._iTitleResizeId=t.register(this._$titleArea.get(0),this._adjustTitlePositioning.bind(this));if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle")}if(i>0){this._updateMedia(i,R.MEDIA)}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady()}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout)}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());this._adjustTitlePositioning()}if(e&&e.supportsPinUnpin()){this._updatePinButtonState()}this._handleExpandButtonPressEventLifeCycle(true)};R.prototype._onAfterRenderingDomReady=function(){var e,t,i,o=this._getWidth(this);if(this._bIsBeingDestroyed){return}this._adjustSelectedSectionByUXRules();e=this.getSelectedSection();t=this.oCore.byId(e);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(e){if(this.getUseIconTabBar()){this._setSelectedSectionId(e);this._setCurrentTabSection(t);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(t);this._checkSubSectionVisibilityChange()}else{this.scrollToSection(e,0)}}this._toggleScrolling(this._shouldAllowScrolling());this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}if(!this._bHeaderExpanded){i=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(i)}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(o,R.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(o,R.DYNAMIC_HEADERS_MEDIA)}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady")};R.prototype._toggleScrolling=function(e){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=e?"auto":"hidden"}};R.prototype._shouldAllowScrolling=function(){return!this._bAllContentFitsContainer||!this._getFirstVisibleSubSection()?._hasRestrictedHeight()};R.prototype._shiftFooter=function(){var e=this.$("footerWrapper"),t=this._calculateShiftOffset();e.css(t.sStyleAttribute,t.iMarginalsOffset+"px")};R.prototype._calculateShiftOffset=function(){var e=0,t=this.oCore.getConfiguration().getRTL()?"left":"right",i=this._hasVerticalScrollBar(),o=this._iOffset,n;if(r.system.desktop){n=T().width;e=n;if(!i){e=0;o+=n}}return{sStyleAttribute:t,iActionsOffset:o,iMarginalsOffset:e}};R.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?R.HEADER_CALC_DELAY:0};R.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._oLazyLoading){this._oLazyLoading.destroy();this._oLazyLoading=null}this._destroyInvisibleText();this._deregisterScreenSizeListener();this._deregisterTitleSizeListener();if(this._iContentResizeId){t.deregister(this._iContentResizeId)}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout)}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null};R.prototype.setShowOnlyHighImportance=function(e){var t=this.getShowOnlyHighImportance();if(t!==e){this.setProperty("showOnlyHighImportance",e,true);this.getSections().forEach(function(e){e._updateImportance()})}return this};R.prototype.setIsHeaderContentAlwaysExpanded=function(e){var t=this.getAlwaysShowContentHeader();var i=r.system.phone||r.system.tablet;if(t!==e){this.setProperty("alwaysShowContentHeader",e,i)}return this};R.prototype.setShowEditHeaderButton=function(e){var t=this.getShowEditHeaderButton(),i=this.getAggregation("_headerContent");if(t!==e){this.setProperty("showEditHeaderButton",e,true);i&&i.invalidate()}return this};R.prototype._initializeScroller=function(){if(this._oScroller){return}this._oScroller=new a(this,this.getId()+"-scroll",{horizontal:false,vertical:true});this._oScroller.setOnAfterScrollToElement(this._onAfterScrollToElement.bind(this))};R.prototype._onAfterScrollToElement=function(){var e=this._$opWrapper.scrollTop(),t=this._bStickyAnchorBar;this._onScroll({target:{scrollTop:e}});if(this._bStickyAnchorBar&&!t&&this._$opWrapper.scrollTop()===e){this._$opWrapper.scrollTop(e-this.iAnchorBarHeight)}};R.prototype.setSelectedSection=function(e){var t,i;if(e instanceof l){e=e.getId()}else if(e!=null&&typeof e!=="string"){H(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this}if(e===this.getSelectedSection()){return this}if(e===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._selectFirstVisibleSection();return this}this.scrollToSection(e);t=h._getClosestSection(e);i=t instanceof h?t.getId():t;this.setDirectScrollingToSection(i);return this.setAssociation("selectedSection",i,true)};R.prototype._selectFirstVisibleSection=function(){if(this.getUseIconTabBar()&&this._oFirstVisibleSection){this._adjustSelectedSectionByUXRules();this._setCurrentTabSection(this._oFirstVisibleSection);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(this._oFirstVisibleSection);this._preloadSectionsOnBeforeScroll(this._oFirstVisibleSection);this._updateSelectionOnScroll(0);this._checkSubSectionVisibilityChange()}else if(this.$().is(":visible")){this._scrollTo(0,0);if(!this._bInvalidatedAndNotRerendered){this._sScrolledSectionId=null;this._updateSelectionOnScroll(0)}}};R.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%")}this._bCorrectParentHeightIsSet=true};R.prototype._cacheDomElements=function(){this._$footerWrapper=this.$("footerWrapper");this._$titleArea=this.$("headerTitle");this._$anchorBar=this.$("anchorBar");this._$stickyAnchorBar=this.$("stickyAnchorBar");this._$opWrapper=this.$("opwrapper");this._$spacer=this.$("spacer");this._$headerContent=this.$("headerContent");this._$stickyHeaderContent=this.$("stickyHeaderContent");this._$contentContainer=this.$("scroll");this._$sectionsContainer=this.$("sectionsContainer");this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true};R.prototype._handleExpandButtonPress=function(e){this._expandHeader(true)};R.prototype._toggleHeaderTitle=function(e,t){var i=this.getHeaderTitle(),o=this._oABHelper._getAnchorBar();if(this._$titleArea.length){this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!e);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!e)}if(e){i&&i.unSnap(t)}else{i&&i.snap(t)}o.scrollToCurrentlySelectedSection()};R.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this.fireEvent("_moveHeader",{fixed:true});this._bSupressModifyOnScrollOnce=true};R.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;this.fireEvent("_moveHeader",{fixed:false})}};R.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar()}};R.prototype._applyUxRules=function(e){var t,i,o,n,r,s,a,l,h,d,g,u,_={};t=this.getSections()||[];n=0;s=this.getShowAnchorBar();a=this.getUseIconTabBar();l=null;this._cleanMemory();t.forEach(function(t){if(!t.getVisible()){return true}this._registerSectionBaseInfo(t);i=t.getSubSections()||[];o=0;h=null;i.forEach(function(t){if(!t.getVisible()){return true}this._registerSectionBaseInfo(t);r=t.getVisibleBlocksCount();if(r===0){t._setInternalVisible(false,e);b.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+t.getTitle()+" forced to hidden")}else{t._setInternalVisible(true,e);_[t.getId()]=true;o++;if(!h){h=t}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t,!l),e)}}},this);if(o>1){i.forEach(function(e){e._setBorrowedTitleDomId("")})}if(o==0){t._setInternalVisible(false,e);b.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+t.getTitle()+" forced to hidden")}else{t._setInternalVisible(true,e);_[t.getId()]=true;if(!l){l=t;u=o}if(this.getSubSectionLayout()===E.TitleOnTop&&o===1&&h.getTitle().trim()!==""){b.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+t.getTitle()+" is taking its single subsection title "+h.getTitle());t._setInternalTitle(h.getTitle(),e);_[h.getId()]=false;h._setBorrowedTitleDomId(t.getId()+"-title")}else{t._setInternalTitle("",e)}if(o===1&&!h.getTitle().trim()){h._setBorrowedTitleDomId(t.getId()+"-title")}if(this._shouldApplySectionTitleLevel(t)){t._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(t),e)}n++}if(a){_[t.getId()]=false}},this);if(n<=1){s=false;b.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");if(a&&l){_[l.getId()]=true}}else if(l&&s){d=true;_[l.getId()]=false;b.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+l.getTitle()+" title forced to hidden")}this.toggleStyleClass(R.NO_NAVIGATION_CLASS_NAME,n<=1);Object.keys(_).forEach(function(t){this.oCore.byId(t)._setInternalTitleVisible(_[t],e)}.bind(this));if(s){this._oABHelper._buildAnchorBar()}this._setInternalAnchorBarVisible(s,e);this._oFirstVisibleSection=l;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(l);this._bAllContentFitsContainer=n===1&&o===1&&this._oFirstVisibleSubSection.hasStyleClass(c.FIT_CONTAINER_CLASS);if(d&&u===1){g=this.getAggregation("_anchorBar").getContent();if(g.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(g[0].getId()+"-content")}}this._checkSubSectionVisibilityChange()};R.prototype._checkSubSectionVisibilityChange=function(){var e=this.getUseIconTabBar(),t=e&&sap.ui.getCore().byId(this.getSelectedSection()),i=t?[t]:this._getVisibleSections(),o={},n;i.forEach(function(e){e.getSubSections().forEach(function(e){n=e.getVisible()&&e._getInternalVisible();if(n){o[e.getId()]=e}})});if(y(Object.keys(this._oVisibleSubSections),Object.keys(o)).length){this._oVisibleSubSections=o;this.fireEvent("subSectionVisibilityChange",{visibleSubSections:o})}};R.prototype.setUseIconTabBar=function(e){var t=this.getUseIconTabBar();if(e!=t){this._applyUxRules()}this.setProperty("useIconTabBar",e);this.toggleStyleClass("sapUxAPObjectPageLayoutIconTabBar",e);return this};R.prototype._setCurrentTabSection=function(e,t){if(!e){return}var i;if(B.isObjectA(e,"sap.uxap.ObjectPageSubSection")){i=e;e=e.getParent()}else{i=this._getFirstVisibleSubSection(e)}if(this._oCurrentTabSection!==e){this._renderSection(e);this._oCurrentTabSection=e}this._oCurrentTabSubSection=i};R.prototype._renderSection=function(e){var t=this.$().find(".sapUxAPObjectPageContainer"),i;if(e&&t.length){i=this.oCore.createRenderManager();this.getSections().forEach(function(t){if(t.getId()===e.getId()){i.renderControl(e)}else{i.cleanupControlWithoutRendering(t)}});i.flush(t[0]);i.destroy()}};R.prototype.setShowAnchorBarPopover=function(e,t){var i=this.getProperty("showAnchorBarPopover"),e=this.validateProperty("showAnchorBarPopover",e),o=this.getSelectedSection();if(e===i){return this}this._oABHelper._getAnchorBar().setShowPopover(e);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(o);return this.setProperty("showAnchorBarPopover",e,true)};R.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible};R.prototype._setInternalAnchorBarVisible=function(e,t){if(e!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=e;if(t===true){this.invalidate()}}};R.prototype.setUpperCaseAnchorBar=function(e){this._oABHelper._getAnchorBar().setProperty("upperCase",e);return this.setProperty("upperCaseAnchorBar",e,true)};R.prototype._requestAdjustLayout=function(e){if(!this._oLayoutTask){this._oLayoutTask=new _(this._updateScreenHeightSectionBasesAndSpacer,R.DOM_CALC_DELAY,this)}if(!e){b.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+R.DOM_CALC_DELAY+" ms because of dom modifications")}return this._oLayoutTask.reSchedule(e,{}).catch(function(e){})};R.prototype._requestAdjustLayoutAndUxRules=function(e){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new _(this._adjustLayoutAndUxRules,R.DOM_CALC_DELAY,this)}if(!e){b.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+R.DOM_CALC_DELAY+" ms because of dom modifications")}return this._oUxRulesTask.reSchedule(e,{}).catch(function(e){})};R.prototype._adjustLayoutAndUxRules=function(){var e,t,i;b.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();e=this.getSelectedSection();t=this.oCore.byId(e);if(t){this._setSelectedSectionId(e);if(this.getUseIconTabBar()){this._setCurrentTabSection(t);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(t)}this._requestAdjustLayout(true);if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading.doLazyLoading()}if(!this._isClosestScrolledSection(e)||this._hasOngoingScrollToSection()){i=e;if(t.indexOfSubSection(this.oCore.byId(this.getOngoingScrollToSectionBaseId()))>-1){i=this.getOngoingScrollToSectionBaseId()}this.scrollToSection(i,null,0,false,true)}}};R.prototype._isClosestScrolledSection=function(e){var t=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,i=this.iScreenHeight,o=this._getClosestScrolledSectionBaseId(t,i),n=this.oCore.byId(o),r=h._getClosestSection(n);return r&&e===r.getId()};R.prototype._hasOngoingScrollToSection=function(e){return this._oScroller._$Container&&this._oScroller._$Container.is(":animated")&&this.getOngoingScrollToSectionBaseId()};R.prototype._setSelectedSectionId=function(e){var t=this.getAggregation("_anchorBar"),i=e&&this._oSectionInfo[e];if(!i){return}if(t&&i.buttonId){t.setSelectedButton(i.buttonId);this.setAssociation("selectedSection",e,true)}};R.prototype.isFirstRendering=function(){return this._bFirstRendering};R.prototype._cleanMemory=function(){var e=this.getAggregation("_anchorBar");if(e){e._resetControl()}this._oSectionInfo={};this._aSectionBases=[]};R.prototype._registerSectionBaseInfo=function(e){this._oSectionInfo[e.getId()]={$dom:[],positionTop:0,buttonId:"",isSection:e instanceof h,sectionReference:e};this._aSectionBases.push(e)};R.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents()}};R.prototype.scrollToSection=function(e,t,o,n,r){var s=this.oCore.byId(e),a,l,d=i.getAnimationMode()!==i.AnimationMode.none,g,u,_,p;if(!this.getDomRef()){b.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return}if(!s){b.warning("scrollToSection aborted: unknown section",e,this);return}if(!this._oSectionInfo[e]||!s._getInternalVisible()){b.warning("scrollToSection aborted: section is hidden by UX rules",e,this);return}if(this.bIsDestroyed){b.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return}if(this.getUseIconTabBar()){var f=h._getClosestSection(s);var S=this._bAllContentFitsContainer,y;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(f);y=this._bAllContentFitsContainer!==S;if(y&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false)}f._allowPropagationToLoadedViews(true);this._setCurrentTabSection(s);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[f.getId()].buttonId);this.setAssociation("selectedSection",f.getId(),true);this._checkSubSectionVisibilityChange()}l=s instanceof c?s:this._getFirstVisibleSubSection(s);if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators()}o=o||0;s._expandSection();this._requestAdjustLayout(true);t=this._computeScrollDuration(t,s);g=d&&t>0;var T=this._computeScrollPosition(s);if(this._sCurrentScrollId!=e||r){this._sCurrentScrollId=e;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false)}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined}.bind(this),t)}this._preloadSectionsOnBeforeScroll(s);T+=o;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(T)){a=this._getSnapPosition();this._scrollTo(a,0);if(a===0){this._toggleHeader(true)}}u=g&&this.getEnableLazyLoading()&&this._oLazyLoading;_=function(e,t,i){t&&this.setOngoingScrollToSectionBaseId(e);i&&this._oLazyLoading.suppress()}.bind(this,e,g,u);p=function(e){if(e===this.getOngoingScrollToSectionBaseId()){this.setOngoingScrollToSectionBaseId(null);this._resumeLazyLoading()}}.bind(this,e);this._scrollTo(T,t,_,p);if(n){this.fireNavigate({section:h._getClosestSection(s),subSection:l})}}};R.prototype.onAnchorBarTabPress=function(e){var t=sap.ui.getCore().byId(e.getParameter("sectionBaseId")),i=t instanceof f.ObjectPageSubSection,o,n;if(!t){return}o=i?t.getParent():t;n=i?t:this._getFirstVisibleSubSection(t);var r=this.fireBeforeNavigate({section:o,subSection:n});if(!r){return}this.setDirectScrollingToSection(o.getId());this.scrollToSection(t.getId(),null,0,true);o.setAssociation("selectedSubSection",n,true);this.setAssociation("selectedSection",o,true)};R.prototype._hasSingleVisibleFullscreenSubSection=function(e){var t=e.getSubSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()&&e.getBlocks().length>0});return t.length===1&&t[0].hasStyleClass(c.FIT_CONTAINER_CLASS)};R.prototype._computeScrollDuration=function(e,t){var i=parseInt(e);i=i>=0?i:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&(t instanceof h||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){i=0}return i};R.prototype._computeScrollPosition=function(e){var t=this._oSectionInfo[e.getId()].positionTop,i=!this._bStickyAnchorBar;if(i&&this._isFirstVisibleSectionBase(e)){t=0}return t};R.prototype._preloadSectionsOnBeforeScroll=function(e){var t=e.getId(),i;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){i=e instanceof h?e:e.getParent();this._connectModelsForSections([i])}if(this.getEnableLazyLoading()){var o=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;i=this._oLazyLoading.getSubsectionsToPreload(o,t);if(r.system.desktop){setTimeout(function(){this._connectModelsForSections(i);this._fireSubSectionEnteredViewPortEvent(i)}.bind(this),50)}else{this._connectModelsForSections(i);this._fireSubSectionEnteredViewPortEvent(i)}}};R.prototype._fireSubSectionEnteredViewPortEvent=function(e){e.forEach(function(e){this.fireEvent("subSectionEnteredViewPort",{subSection:e})},this)};R.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId};R.prototype.setDirectScrollingToSection=function(e){this.sDirectSectionId=e};R.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId};R.prototype.setOngoingScrollToSectionBaseId=function(e){this.sOngoingScrollToSectionBaseId=e};R.prototype.getOngoingScrollToSectionBaseId=function(){return this.sOngoingScrollToSectionBaseId};R.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null};R.prototype._scrollTo=function(e,t,i,o){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){b.debug("ObjectPageLayout :: scrolling to "+e);if(t===0&&this._shouldSnapHeaderOnScroll(e)){this._toggleHeader(true)}i&&i();this._oScroller.scrollTo(0,e,t,o)}return this};R.prototype._resumeLazyLoading=function(){if(this._oLazyLoading){this._oLazyLoading.resume();this._oLazyLoading.lazyLoadDuringScroll(true)}};R.prototype._scrollBelowCollapseVisualIndicator=function(){var e=this._getHeaderContent(),t,i,o,n;if(!D(e)||!D(this._$opWrapper)){return}t=e._getCollapseButton().getDomRef();i=t.getBoundingClientRect().height;o=this._$opWrapper[0].getBoundingClientRect().height;n=t.offsetTop+i-o;this._scrollTo(n)};R.prototype._updateMedia=function(e,t){if(!e){return}var i=function(e){Object.keys(t).forEach(function(i){var o=t[i],n=e===o;this.toggleStyleClass(o,n)},this)}.bind(this),o=R.BREAK_POINTS;if(e<=o.PHONE){i(t.PHONE)}else if(e<=o.TABLET){i(t.TABLET)}else if(e<=o.DESKTOP){i(t.DESKTOP)}else{i(t.DESKTOP_XL)}};R.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var e,t,i,o,n,r,s=this._bHeaderInTitleArea||!this._bHeaderExpanded,a,l,d,g=this.getDomRef(),u=this.getUseIconTabBar(),_=this.oCore.byId(this.getSelectedSection());if(!g||!this._bDomReady){return false}b.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(g);if(this.iScreenHeight===0){return}if(u&&_){this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(_)}this.iFooterHeight=this._getFooterHeight();var p=-1;this._aSectionBases.forEach(function(e){var i=this._oSectionInfo[e.getId()],r=e.$(),s=false,g;if(!i||!r.length){return}if(!i.isSection){p++}i.$dom=r;var _=f.Utilities.getChildPosition(r,this._$contentContainer).top;i.positionTop=Math.ceil(_);if(!i.isSection&&(g=e.getParent())){s=e._getTitleDomId()===g.getId()+"-title";if(s){var S=g.$().position().top;i.positionTop=Math.ceil(S)}}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){i.positionTop-=this.iAnchorBarHeight}i.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",s);if(this._bMobileScenario){var b=e.getParent();if(b instanceof h&&b._getIsHidden()){return}if(n){this._oSectionInfo[n].positionBottom=i.positionTop}n=e.getId();t=e}else{if(i.isSection){if(n){this._oSectionInfo[n].positionBottom=i.positionTop;if(o){this._oSectionInfo[o].positionBottom=i.positionTop}}n=e.getId();o=null}else{if(o){this._oSectionInfo[o].positionBottom=i.positionTop}o=e.getId();t=e}}if(!i.isSection){l=u||e.getParent()===this._oFirstVisibleSection;a=l&&p===0;d=e.hasStyleClass(c.FIT_CONTAINER_CLASS);e._setHeight(this._computeSubSectionHeight(a,d,e))}},this);if(t){e=this._computeLastVisibleHeight(t);if(this._bMobileScenario&&n){this._oSectionInfo[n].positionBottom=this._oSectionInfo[n].positionTop+e}else{if(o){this._oSectionInfo[o].positionBottom=this._oSectionInfo[o].positionTop+e}if(n&&o){this._oSectionInfo[n].positionBottom=this._oSectionInfo[o].positionTop+e}}r=this._bStickyAnchorBar||p>0||this._checkContentBottomRequiresSnap(t);if(this._bAllContentFitsContainer){r=false}if(r&&!this._shouldPreserveHeaderInTitleArea()){s=true}i=this._computeSpacerHeight(t,e,r,s);this._$spacer.height(i+"px");b.debug("ObjectPageLayout :: bottom spacer is now "+i+"px");C(this._oScrollContainerLastState,{iScrollableContentLength:Math.round(this._getScrollableContentLength()),iSpacerHeight:i})}this._adjustTitlePositioning();this._setSectionInfoIsDirty(false);this._updateSelectionOnScroll(this._$opWrapper.scrollTop());this._toggleScrolling(this._shouldAllowScrolling());return true};R.prototype._computeSubSectionHeight=function(e,t,i){var o,n,r,s,a,l;if(!t){return""}var h=this._bAllContentFitsContainer?this._bHeaderExpanded:e;o=this._getSectionsContainerHeight(h);if(this._bAllContentFitsContainer){n=this._$sectionsContainer[0].getBoundingClientRect();r=i.getDomRef().getBoundingClientRect();s=r.top-n.top;a=this.iFooterHeight+this._iREMSize;l=s+a;o-=l}return o+"px"};R.prototype._computeScrollableContentSize=function(e){var t=0;if(this._$contentContainer&&this._$contentContainer.length){t=this._$contentContainer[0].scrollHeight}if(!this._bStickyAnchorBar&&e){t-=this.iAnchorBarHeight}if(this._bStickyAnchorBar&&!e){t+=this.iAnchorBarHeight}return t};R.prototype._computeLastVisibleHeight=function(e){var t=this._bStickyAnchorBar||this._bHeaderInTitleArea;var i=this._getSectionPositionTop(e,t);return Math.floor(this._$spacer.position().top)-i};R.prototype._getStickyAreaHeight=function(e){if(e){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight}return this.iHeaderTitleHeight};R.prototype._getScrollableViewportHeight=function(e){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(e)};R.prototype._getSectionsContainerHeight=function(e){var t=!e,i=this._getScrollableViewportHeight(t);if(!t&&!this._bHeaderInTitleArea){i-=this.iHeaderContentHeight+this.iAnchorBarHeight}return i};R.prototype._getSectionPositionTop=function(e,t){var i=this._oSectionInfo[e.getId()].positionTop;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){i+=this.iAnchorBarHeight}return i};R.prototype._getSectionPositionBottom=function(e,t){var i=this._oSectionInfo[e.getId()].positionBottom;if(!t){i+=this.iAnchorBarHeight}return i};R.prototype._determineSectionBaseInternalTitleLevel=function(e,t){var i=this.getSectionTitleLevel(),o=e instanceof h;if(i===O.Auto){if(o||t&&!o){return O.H3}return O.H4}return o?i:R._getNextTitleLevelEntry(i)};R.prototype._shouldApplySectionTitleLevel=function(e){return e.getTitleLevel()===O.Auto};R.prototype._checkContentBottomRequiresSnap=function(e){var t=false;return this._getSectionPositionBottom(e,t)>this._getScrollableViewportHeight(t)+this._getSnapPosition()};R.prototype._computeSpacerHeight=function(e,t,i,o){var n,r;if(Object.keys(this._oVisibleSubSections).length===1&&this._bHeaderExpanded){n=0}else{r=this._getScrollableViewportHeight(o);if(i){r=Math.ceil(r);t=Math.floor(t)}else{t=this._$spacer.position().top}if(t<r){n=r-t}else{n=0}}if(this.iFooterHeight>n){n+=this.iFooterHeight}return n};R.prototype._isFirstVisibleSectionBase=function(e){var t,i,o,n=this.getSelectedSection(),r=this.getUseIconTabBar();if(!e||!e.getParent()){return}t=e.getId();if(r&&t===n){return true}if(r&&e.getParent().getId()===n){i=sap.ui.getCore().byId(n);o=this._getFirstVisibleSubSection(i);return o&&o.getId()===t}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return t===this._oFirstVisibleSection.getId()||t===this._oFirstVisibleSubSection.getId()}return false};R.prototype._getFirstVisibleSubSection=function(e){if(!e){e=this.getUseIconTabBar()?this._oCurrentTabSection:this._oFirstVisibleSection;if(!e){return}}var t;this._aSectionBases.every(function(i){if(i.getParent()&&i.getParent().getId()===e.getId()){t=i;return false}return true});return t};R.prototype._initAnchorBarScroll=function(){var e=this.oCore.byId(this.getSelectedSection()),t;this._requestAdjustLayout(true);t=e?this._computeScrollPosition(e):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:t}},true)};R.prototype._setAsCurrentSection=function(e){var t,i,o,n;if(this._sScrolledSectionId===e){return}b.debug("ObjectPageLayout :: current section is "+e);this._sScrolledSectionId=e;t=this.getAggregation("_anchorBar");n=t&&this._getInternalAnchorBarVisible();i=this.oCore.byId(e);o=i&&i instanceof c&&(i.getTitle().trim()===""||!i._getInternalTitleVisible()||i.getParent()._getIsHidden());if(o){e=i.getParent().getId();b.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+e)}if(i&&this._oSectionInfo[e]){n&&t.setSelectedButton(this._oSectionInfo[e].buttonId);this.setAssociation("selectedSection",h._getClosestSection(e).getId(),true);this._setSectionsFocusValues(e)}};R.prototype._registerOnContentResize=function(){var e=this._$contentContainer.length&&this._$contentContainer[0];if(!e){return}if(this._iContentResizeId){t.deregister(this._iContentResizeId)}this._iContentResizeId=t.register(e,this._onUpdateContentSize.bind(this))};R.prototype._onUpdateContentSize=function(e){var t=e.size;this.iContentHeight=t.height;if(t.height===0||t.width===0){b.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}if(this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}this._adjustHeaderHeights();this._requestAdjustLayout(true)};R.prototype.triggerPendingLayoutUpdates=function(){if(this._hasPendingLayoutUpdate()){this._requestAdjustLayout(true)}};R.prototype._hasPendingLayoutUpdate=function(){return this._oLayoutTask&&this._oLayoutTask.isPending()||this._$contentContainer.length&&this._$contentContainer.get(0).offsetHeight!==this.iContentHeight};R.prototype._adjustTitlePositioning=function(e){if(!this._$titleArea.length||!this._$opWrapper.length){return}var t=this._$opWrapper.get(0),i=this._$titleArea.get(0),o=i.getBoundingClientRect().height,n=i.getBoundingClientRect().width,r=T().width,s;t.style.paddingTop=o+"px";t.style.scrollPaddingTop=o+"px";if(this._oScroller){this._oScroller.setScrollPaddingTop(o)}s="polygon(0px "+o+"px, "+Math.floor(n)+"px "+o+"px, "+Math.floor(n)+"px 0, 100% 0, 100% 100%, 0 100%)";if(this.oCore.getConfiguration().getRTL()){s="polygon(0px 0px, "+r+"px 0px, "+r+"px "+o+"px, 100% "+o+"px, 100% 100%, 0 100%)"}t.style.clipPath=s;this.getHeaderTitle()&&this._shiftHeaderTitle()};R.prototype._onUpdateScreenSize=function(e){var t=this.getHeaderTitle(),i=this._getHeaderContent(),o=e.size.width,n=e.size.height,r=e.oldSize.height,s=n!==r,a,l=i&&i.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(e.size.height===0||e.size.width===0){b.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}this._bMobileScenario=f.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=f.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(!this._bDomReady){b.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){if(l&&this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader()){this.invalidate()}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){if(this._isHeaderPinnable()){this._updatePinButtonState()}this._expandHeader(false);this._scrollTo(0,0)}else if(this._isHeaderPinnable()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._updatePinButtonState()}if(t&&t.isDynamic()){t._onResize(o);this._updateMedia(o,R.DYNAMIC_HEADERS_MEDIA)}this._updateMedia(o,R.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter()}a=this.getSelectedSection();if(r===0&&s&&!this._isClosestScrolledSection(a)){a!==null?this.scrollToSection(a,0):this._selectFirstVisibleSection()}this._scrollTo(this._$opWrapper.scrollTop(),0);if(r===0&&s&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading()}}.bind(this),this._getDOMCalculationDelay())};R.prototype._onUpdateHeaderTitleSize=function(e){if(e.size.height===0||e.size.width===0){b.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return}if(!this._bDomReady){b.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return}this._adjustHeaderHeights();this._requestAdjustLayout()};R.prototype._applyContextualSettings=function(e){var t=e.contextualWidth;if(this._hasDynamicTitle()){this._updateMedia(t,R.DYNAMIC_HEADERS_MEDIA)}this._updateMedia(t,R.MEDIA);return s.prototype._applyContextualSettings.call(this,e)};R.prototype._shouldSnapHeaderOnScroll=function(e){return e>0&&e>=this._getSnapPosition()&&!this._shouldPreserveHeaderInTitleArea()};R.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0};R.prototype._isContentScrolledToBottom=function(){return this._oScrollContainerLastState.iScrollableContentLength<=this._oScrollContainerLastState.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight};R.prototype._isContentLengthDecreased=function(e){if(e){return e.iScrollableContentLength>this._oScrollContainerLastState.iScrollableContentLength&&e.iSpacerHeight===this._oScrollContainerLastState.iSpacerHeight}};R.prototype._canReachScrollTop=function(e,t){var i;t=t||0;i=this._oScrollContainerLastState.iScrollableContentLength+t+this._$contentContainer.get(0).offsetTop-this._oScrollContainerLastState.iScrollableViewportHeight;return i>=e};R.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL")}};R.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){t.deregister(this._iResizeId);this._iResizeId=null}};R.prototype._deregisterTitleSizeListener=function(){if(this._iTitleResizeId){t.deregister(this._iTitleResizeId);this._iTitleResizeId=null}};R.prototype._onScroll=function(e,t){var i=Math.max(Math.ceil(e.target.scrollTop),0),o=this._$opWrapper.length&&this._$opWrapper[0],n=this._$spacer.length&&this._$spacer[0],r=this._$spacer.height(),s,a=this.getHeaderTitle(),l=this._shouldSnapHeaderOnScroll(i),h=this._shouldPreserveHeaderInTitleArea(),c=false,d=this._oScrollContainerLastState;this._oScrollContainerLastState={iScrollTop:i,iScrollableContentLength:Math.round(this._getScrollableContentLength()),iScrollableViewportHeight:o.offsetHeight,iSpacerHeight:r};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;if(!t){return}}if(!o||!n){return}s=this.iScreenHeight;if(s===0){return}if(this._getSectionInfoIsDirty()){return}if(d&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(d)){var g=d.iScrollableContentLength-this._oScrollContainerLastState.iScrollableContentLength;if(!this._canReachScrollTop(d.iScrollTop)&&this._canReachScrollTop(d.iScrollTop,g)){var u=d.iScrollTop+this._oScrollContainerLastState.iScrollableViewportHeight,_=this._oScrollContainerLastState.iScrollableContentLength,p=u-_,f;if(p>0){f=r+p;this._$spacer.height(f+"px");this._scrollTo(d.iScrollTop);return}}}if(l&&!h){s-=this.iAnchorBarHeight+this.iHeaderTitleHeightStickied}if(this._bHeaderInTitleArea&&!h){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout()}if(!h&&(a&&this.getShowHeaderContent()||this.getShowAnchorBar())){this._toggleHeader(l,!!(e&&e.type==="scroll"))}if(!h){this._adjustHeaderTitleBackgroundPosition(i)}b.debug("ObjectPageLayout :: lazy loading : Scrolling at "+i,"----------------------------------------");this._updateSelectionOnScroll(i);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(t,i,e.timeStamp,s)}if(a&&a.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&a.getShowTitleSelector()){if(i===0){this.$("scroll").css("z-index","1000");c=false}else if(!c){c=true;this.$("scroll").css("z-index","0")}}};R.prototype._updateSelectionOnScroll=function(e){var t=this.iScreenHeight,i,o,n,r;if(t===0){return}i=this._getClosestScrolledSectionBaseId(e,t);o=h._getClosestSection(i);n=o?o.getId():null;r=this._getClosestScrolledSectionBaseId(e,t,true);if(i){var s=this.getDirectScrollingToSection(),a=this.oCore.byId(s);if(i!==this._sScrolledSectionId){b.debug("ObjectPageLayout :: closest id "+i,"----------------------------------------");var s=this.getDirectScrollingToSection();if(s&&s!==n&&(a&&a.getDomRef()&&!this.isFirstRendering())){return}this.clearDirectScrollingToSection();this._setAsCurrentSection(i)}else if(n===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection()}if(r!==this._sScrolledSubSectionId){var l=h._getClosestSection(i),c=this.oCore.byId(r);this._sScrolledSubSectionId=r;this.fireEvent("_sectionChange",{section:l,subSection:c});this.fireEvent("sectionChange",{section:l,subSection:c})}}};R.prototype._getSnapPosition=function(){var e=this.iHeaderContentHeight,t=this._getTitleHeightDelta();e-=Math.max(t,this._iHeaderContentPaddingBottom);return e};R.prototype._getTitleHeightDelta=function(){var e=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;e=Math.max(e,0);e=Math.min(e,R.MAX_SNAP_POSITION_OFFSET);return e};R.prototype._getClosestScrolledSectionBaseId=function(e,t,i){i=!!i;e=Math.ceil(e);var o=e+t,n,r=i||this._bMobileScenario;jQuery.each(this._oSectionInfo,function(t,s){var a,l,c,d,g,u=this.getSelectedSection();a=s.sectionReference;l=a.getParent();c=l instanceof h&&l._getIsHidden();if(this.getUseIconTabBar()&&u){g=this.oCore.byId(u);if(!g){return}if(s.isSection&&s.sectionReference!=g){return true}if(!s.isSection&&g.indexOfSubSection(s.sectionReference)<0){return true}}if(s.isSection||r&&!c){if(!n&&s.sectionReference._getInternalVisible()===true){d=this._getFirstVisibleSubSection(s.sectionReference);if(s.isSection&&i&&d){n=d.getId()}else{n=t}}if(s.isSection&&i){return true}if(s.positionTop<=o&&e<=s.positionBottom){if(s.positionTop<=e+1&&s.positionBottom>e){n=t}}}}.bind(this));return this.oCore.byId(n)?n:null};R.prototype._toggleHeader=function(e,t){var i;if(e===this._bStickyAnchorBar){return}i=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!e,t)}if(!this._bStickyAnchorBar&&e){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);i&&i.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators()}else if(this._bStickyAnchorBar&&!e){this._restoreFocusAfter(this._moveAnchorBarToContentArea);i&&i.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(this._isHeaderPinnable()){this._getHeaderContent()._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea())}}};R.prototype._restoreFocusAfter=function(e){var t=this.oCore.byId(this.oCore.getCurrentFocusedControlId());e.call(this);if(r.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){t&&t.$().trigger("focus")}}return this};R.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize()}return this};R.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var e=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(e);this._toggleHeaderStyleRules(false)}return this};R.prototype._toggleHeaderStyleRules=function(e){e=!!e;var t=e?"hidden":"inherit";this._bStickyAnchorBar=e;this._$headerContent.css("overflow",t);this._$headerContent.toggleClass("sapContrastPlus",!e);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",e);this._$anchorBar.css("visibility",t);if(D(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!e)}this.fireToggleAnchorBar({fixed:e});if(!e&&!this.iAnchorBarHeight){this._requestAdjustLayout()}};R.prototype.getScrollDelegate=function(){return this._oScroller};R.prototype.setHeaderTitle=function(t,i){if(t&&typeof t.addEventDelegate==="function"){t.addEventDelegate({onAfterRendering:this._onAfterHeaderTitleRendering.bind(this)})}this.setAggregation("headerTitle",t,i);this._oObserver&&this._oObserver.disconnect();this._oObserver=new e(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(t,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(t){this._createHeaderContent()}if(this._hasDynamicTitle()){this._iHeaderContentPaddingBottom=R.HEADER_CONTENT_PADDING_BOTTOM}return this};R.prototype._onAfterHeaderTitleRendering=function(){var e=this.getHeaderTitle(),t=e&&e.$(),i;if(!e||!t.length){return}i=t.height();if(i!==this._iCachedHeaderTitleHeight){this._adjustHeaderHeights();this._iCachedHeaderTitleHeight=i}};R.prototype._onModifyHeaderTitle=function(e){var t=this.getAggregation("_headerContent");t&&e.current&&t.setBackgroundDesign(e.current)};R.prototype.invalidate=function(e){this._bInvalidatedAndNotRerendered=true;if(this.getUseIconTabBar()&&e&&e instanceof h&&!e.isActive()&&this._oSectionInfo[e.getId()]){return}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);this._iAfterRenderingDomReadyTimeout=null}o.prototype.invalidate.apply(this,arguments)};R.prototype._createHeaderContent=function(){var e=this.getHeaderTitle(),t=this.getAggregation("_headerContent"),i,o;var n=e?e.getCompatibleHeaderContentClass():d;if(!(t instanceof n)){i=this.getAggregation("_headerContent");if(i){i.destroy()}o=n.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),"",this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");o.getContent().forEach(this._replaceHeaderContentParent,this);this.setAggregation("_headerContent",o,true)}};R.prototype._adjustHeaderBackgroundSize=function(){var e=this.getHeaderTitle();if(e&&e.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px")}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px")}e.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0)}};R.prototype._adjustHeaderTitleBackgroundPosition=function(e){var t=this.getHeaderTitle();if(t&&t.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){t.$().css("background-position","0px "+(this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1+"px")}else{if(this._shouldPreserveHeaderInTitleArea()){t.$().css("background-position","0px 0px")}else{t.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-e)+"px")}}}};R.prototype._adjustHeaderHeights=function(){var e=this.getHeaderTitle(),t=true;if(e&&!e.supportsAdaptLayoutForDomElement()){t=false}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.round(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(t)}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(t)}this._adjustHeaderBackgroundSize();this._adjustTitlePositioning();b.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight)}else{b.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered")}};R.prototype._appendTitleCloneToDOM=function(e){var t=this.getHeaderTitle().$(),i=t.clone();i.css({left:"-10000px",top:"-10000px",width:t.width()+"px",position:"absolute"});i.toggleClass("sapUxAPObjectPageHeaderStickied",e);i.appendTo(this._$titleArea.parent());if(e){this.getHeaderTitle()&&this.getHeaderTitle()._adaptObjectPageHeaderIndentifierLine(i)}return i};R.prototype._obtainSnappedTitleHeight=function(e){var t=this.getHeaderTitle(),i,o;if(!t){return 0}if(e){i=this._appendTitleCloneToDOM(true);o=i.height();i.remove()}else if(t.snap){o=this._obtainTitleHeightViaStateChange(true)}return o};R.prototype._obtainExpandedTitleHeight=function(e){var t=this.getHeaderTitle(),i,o;if(!t){return 0}if(e){i=this._appendTitleCloneToDOM(false);o=i.is(":visible")?i.height():0;i.remove()}else if(t.unSnap){o=this._obtainTitleHeightViaStateChange(false)}return o};R.prototype._obtainTitleHeightViaStateChange=function(e){var t=this.getHeaderTitle(),i,o=this._$sectionsContainer.height(),n,r=e?t.snap:t.unSnap,s=e?t.unSnap:t.snap;r.call(t,false);i=t.$().outerHeight();s.call(t,false);n=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(o,n);return i};R.prototype._adjustSpacerHeightUponUnsnapping=function(e,t){var i;if(e!=t){i=this._$spacer.height()-(t-e);this._$spacer.height(i)}};R.prototype._getHeaderDesign=function(){var e=this.getHeaderTitle(),t=f.ObjectPageHeaderDesign.Light;if(e!=null){t=e.getHeaderDesign()}return t};R.prototype._getVisibleSections=function(){return this.getSections().filter(function(e){return e.getVisible()&&e._getInternalVisible()})};R.prototype._setSectionsFocusValues=function(e){var t=this._getVisibleSections()||[],i,o="0",n="-1",r="tabindex",s,a=t[0];t.forEach(function(t){i=t.$();if(e===t.getId()){i.attr(r,o);s=t;t._setSubSectionsFocusValues()}else{i.attr(r,n);t._disableSubSectionsFocus()}});if(!s&&t.length>0){a.$().attr(r,o);a._setSubSectionsFocusValues();s=a}return s};R.prototype.setShowHeaderContent=function(e){var t=this.getShowHeaderContent(),i;if(t!==e){if(t&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false)}this.setProperty("showHeaderContent",e,true);this._updateTitleVisualState();i=this._getHeaderContent();this.$().toggleClass("sapUxAPObjectPageLayoutNoHeaderContent",!e||!i);if(i){i.setProperty("visible",e)}}return this};R.prototype._headerTitleChangeHandler=function(e){var t;if(!this.getShowTitleInHeaderContent()){return}if(e){this._getHeaderContent()._destroyObjectImage(true)}t=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(t,this);this._getHeaderContent().invalidate();t.destroy()};R.prototype._replaceHeaderContentParent=function(e){if(e.getParent().isA(["sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageDynamicHeaderContent"])){if(e.isA(["sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageDynamicHeaderContent"])){return}if(e._sOriginalParentAggregationName){return}e._sOriginalParentAggregationName=e.sParentAggregationName;e.sParentAggregationName="headerContent";e.getParent=function(){return this}.bind(this);e.destroy=function(){this._restoreParent(e);e.getMetadata().getClass().prototype.destroy.apply(e,arguments)}.bind(this)}};R.prototype._restoreParent=function(e){if(e&&e._sOriginalParentAggregationName){e.sParentAggregationName=e._sOriginalParentAggregationName;e.getParent=e.getMetadata().getClass().prototype.getParent;e.destroy=e.getMetadata().getClass().prototype.destroy;e._sOriginalParentAggregationName=null}};R.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[])}return this._getHeaderContent().getAggregation("content",[])};R.prototype.insertHeaderContent=function(e,t,i){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",e,t,i)}this._getHeaderContent().insertAggregation("content",e,t,i);this._replaceHeaderContentParent(e);return this};R.prototype.addHeaderContent=function(e,t){if(!this._getHeaderContent()){return this.addAggregation("headerContent",e,t)}this._getHeaderContent().addAggregation("content",e,t);this._replaceHeaderContentParent(e);return this};R.prototype.removeAllHeaderContent=function(e){var t;if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",e)}t=this._getHeaderContent().removeAllAggregation("content",e);t.forEach(function(e){this._restoreParent(e)},this);return t};R.prototype.removeHeaderContent=function(e,t){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",e,t)}this._getHeaderContent().removeAggregation("content",e,t);this._restoreParent(e);return this};R.prototype.destroyHeaderContent=function(e){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",e)}return this._getHeaderContent().destroyAggregation("content",e)};R.prototype.indexOfHeaderContent=function(e){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",e)}return this._getHeaderContent().indexOfAggregation("content",e)};R.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent")};R.prototype._getHeaderContentDomRef=function(){var e=this._getHeaderContent();if(!e||!this.getShowHeaderContent()){return null}if(this._bStickyAnchorBar&&!this._bHeaderInTitleArea){return this.$().find(".sapUxAPObjectPageHeaderTitle .sapUxAPObjectPageHeaderDetails").get(0)}return e.getDomRef()};R.prototype._connectModelsForSections=function(e){e=e||[];e.forEach(function(e){e.connectToModels()})};R.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()}};R.prototype._hasVerticalScrollBar=function(){var e=this._$opWrapper.length&&this._$opWrapper.get(0);return e&&e.scrollHeight>e.offsetHeight};R.prototype._shiftHeaderTitle=function(){var e=this._calculateShiftOffset(),t=e.sStyleAttribute,i=e.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css(t,i+"px")};R.prototype._isFirstSection=function(e){var t=this._getVisibleSections();if(e===t[0]){return true}return false};R.prototype._isValidStoredSubSectionInfo=function(){var e=this.getSelectedSection(),t=this.oCore.byId(e),i;if(!t||!this._oStoredScrolledSubSectionInfo){return false}i=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return i&&this._sectionCanBeRenderedByUXRules(i)&&t.indexOfSubSection(i)>=0};R.prototype._restoreScrollPosition=function(){var e=this._isValidStoredSubSectionInfo(),t;if(e){t=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(t,0)}else{this.scrollToSection(this.getSelectedSection(),0)}};R.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return}this.triggerPendingLayoutUpdates();var e=this._$opWrapper.scrollTop(),t=this._getClosestScrolledSectionBaseId(this._oScroller.getScrollTop(),this.iScreenHeight,true),i;if(t){i=e-this._computeScrollPosition(this.oCore.byId(t))}this._iStoredScrollTop=e;this._oStoredScrolledSubSectionInfo={sSubSectionId:t,iOffset:i};this._oCurrentTabSection=null};R.prototype.onkeyup=function(e){var t,i;if(e.which===I.TAB){t=this.oCore.getCurrentFocusedControlId();i=t&&this.oCore.byId(t);if(i&&this._isFirstSection(i)){this._scrollTo(0,0)}}};R.prototype.setShowFooter=function(e){var t=this.setProperty("showFooter",e,true);this._toggleFooter(e);this.$().toggleClass("sapUxAPObjectPageLayoutFooterVisible",e);return t};R.prototype.destroyFooter=function(){this._destroyInvisibleText();return this.destroyAggregation("footer")};R.prototype._toggleFooter=function(e){var t,o=this.getFooter(),n=this.oCore.getConfiguration().getAnimationMode();if(!D(o)||!D(this._$footerWrapper)){return}t=n!==i.AnimationMode.none&&n!==i.AnimationMode.minimal;if(t){this._toggleFooterAnimation(e,o)}else{this._$footerWrapper.toggleClass("sapUiHidden",!e)}this._requestAdjustLayout()};R.prototype._toggleFooterAnimation=function(e,t){this._$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,t));this._bIsFooterAanimationGoing=true;if(e){this._$footerWrapper.removeClass("sapUiHidden")}t.toggleStyleClass(R.SHOW_FOOTER_CLASS_NAME,e);t.toggleStyleClass(R.HIDE_FOOTER_CLASS_NAME,!e)};R.prototype._onToggleFooterAnimationEnd=function(e){this._$footerWrapper.off("webkitAnimationEnd animationend");if(e.hasStyleClass(R.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");e.removeStyleClass(R.HIDE_FOOTER_CLASS_NAME)}else{e.removeStyleClass(R.SHOW_FOOTER_CLASS_NAME)}this._bIsFooterAanimationGoing=false};R.prototype.clone=function(){var e,t,i;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);e=o.prototype.clone.apply(this,arguments);t=this._getHeaderContent();i=e._getHeaderContent();if(i){i.destroy()}if(t){e.setAggregation("_headerContent",t.clone(),true)}return e};R.prototype._cloneProxiedAggregations=function(e){var t=this.mAggregations[e];if(Array.isArray(t)&&t.length===0){t=this["get"+e.charAt(0).toUpperCase()+e.slice(1)]()}this.mAggregations[e]=t};R.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader()};R.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader()};R.prototype._headerBiggerThanAllowedToBeFixed=function(){var e=this._getOwnHeight();return this._getEntireHeaderHeight()>R.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*e};R.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight()};R.prototype._getOwnHeight=function(){return this._getHeight(this)};R.prototype._getHeight=function(e){return!(e instanceof o)?0:e.$().outerHeight()||0};R.prototype._getEntireHeaderHeight=function(){var e=0,t=0,i=this.getHeaderTitle(),o=this._getHeaderContent();if(D(i)){e=i.$().outerHeight()}if(D(o)){t=o.$().outerHeight()}return e+t};R.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin(true)}else{this._pin(true);this._restorePinButtonFocus()}};R.prototype._restorePinButtonFocus=function(){var e=this._getHeaderContent();if(D(e)&&e.supportsPinUnpin()){e._focusPinButton()}};R.prototype._pin=function(e){if(this._bPinned){return}this._bPinned=true;if(e){this.setProperty("headerContentPinned",true,true);this.fireEvent("headerContentPinnedStateChange",{pinned:true})}this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._updateToggleHeaderVisualIndicators();this.addStyleClass("sapUxAPObjectPageLayoutHeaderPinned")};R.prototype._unPin=function(e){if(!this._bPinned){return}this._bPinned=false;if(e){this.setProperty("headerContentPinned",false,true);this.fireEvent("headerContentPinnedStateChange",{pinned:false})}this._updateToggleHeaderVisualIndicators();this.removeStyleClass("sapUxAPObjectPageLayoutHeaderPinned")};R.prototype._isHeaderPinnable=function(){var e=this._getHeaderContent();return e&&e.supportsPinUnpin()&&e.getPinnable()};R.prototype._shouldPinUnpinHeader=function(){return this._bHeaderExpanded&&!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToBeExpandedInTitleArea()};R.prototype._updatePinButtonState=function(){var e=this._isHeaderPinnable(),t=e&&this.getHeaderContentPinned()&&this._shouldPinUnpinHeader(),i=this._getHeaderContent();i._togglePinButton(t);this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",e);i._getPinButton().setVisible(!this._headerBiggerThanAllowedToBeExpandedInTitleArea());if(t){this._pin()}else{this._unPin()}};R.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight};R.prototype._overridePreserveHeaderStateOnScroll=function(){var e=this._bHeaderBiggerThanAllowedHeight,t;this._bHeaderBiggerThanAllowedHeight=this._headerBiggerThanAllowedToBeFixed();t=e!==this._bHeaderBiggerThanAllowedHeight;if(!this._bHeaderBiggerThanAllowedHeight||!t){return}if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true)}else{this._snapHeader(true)}this._adjustHeaderHeights();this._requestAdjustLayout()};R.prototype._hasDynamicTitle=function(){var e=this.getHeaderTitle();return e&&e.isDynamic()};R.prototype._attachVisualIndicatorsPressHandlers=function(e,t){var i=this.getHeaderTitle(),o=this._getHeaderContent();if(D(i)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){i.attachEvent(R.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){e.call(t);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator()}this._focusCollapseVisualIndicator()},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true}if(D(o)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){o.attachEvent(R.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){e.call(t);this._focusExpandVisualIndicator()},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true}};R.prototype._hasVisibleDynamicTitleAndHeader=function(){var e=this.getHeaderTitle(),t=this.getHeaderContent();return this._hasVisibleDynamicTitle(e)&&this._hasVisibleHeaderContent(t)};R.prototype._hasVisibleDynamicTitle=function(e){return D(e)&&e.isDynamic()&&e.getVisible()};R.prototype._hasVisibleHeaderContent=function(e){return D(e)&&e.length>0&&this.getShowHeaderContent()};R.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var e=this.getHeaderTitle();return D(e)&&e.isDynamic()&&!!e.getSnappedTitleOnMobile()&&r.system.phone};R.prototype._updateToggleHeaderVisualIndicators=function(){var e,t,i,o=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!o){t=false;i=false}else{e=this._bHeaderExpanded;t=e;i=!e&&!this._hasDynamicTitleWithSnappedTitleOnMobile()}this._toggleCollapseVisualIndicator(t);this._toggleExpandVisualIndicator(i)};R.prototype._updateTitleVisualState=function(){var e=this.getHeaderTitle(),t=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",t);if(D(e)){e._toggleFocusableState(t)}};R.prototype._focusCollapseVisualIndicator=function(){var e=this._getHeaderContent();if(D(e)){e._focusCollapseButton()}};R.prototype._focusExpandVisualIndicator=function(){var e=this.getHeaderTitle();if(D(e)){e._focusExpandButton()}};R.prototype._toggleExpandVisualIndicator=function(e){var t=this.getHeaderTitle();if(D(t)){t._toggleExpandButton(e)}};R.prototype._toggleCollapseVisualIndicator=function(e){var t=this._getHeaderContent();if(D(t)){t._toggleCollapseButton(e)}};R.prototype._attachVisualIndicatorMouseOverHandlers=function(e,t,i){var o=this._getHeaderContent();if(D(o)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){o.attachEvent(R.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,e,i);o.attachEvent(R.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,t,i);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true}};R.prototype._attachTitleMouseOverHandlers=function(e,t,i){var o=this.getHeaderTitle();if(D(o)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){o.attachEvent(R.EVENTS.TITLE_MOUSE_OVER,e,i);o.attachEvent(R.EVENTS.TITLE_MOUSE_OUT,t,i);this._bAlreadyAttachedTitleMouseOverOutHandler=true}};R.prototype._suppressScroll=function(){this._bSuppressScroll=true};R.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0)}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}})}};R.prototype._addHoverClass=function(){var e=this.$();if(e){e.addClass("sapUxAPObjectPageLayoutTitleForceHovered")}};R.prototype._removeHoverClass=function(){var e=this.$();if(e){e.removeClass("sapUxAPObjectPageLayoutTitleForceHovered")}};R.prototype._getHeight=function(e){return!(e instanceof o)?0:e.$().outerHeight()||0};R.prototype._getWidth=function(e){var t=e.getDomRef();return!(e instanceof o)?0:t&&t.offsetWidth||0};R.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty};R.prototype._setSectionInfoIsDirty=function(e){this.bSectionInfoIsDirty=e};R.prototype._getAriaLabelText=function(e,t){var i=this.getHeaderTitle(),o=i?i.getTitleText():null,n;if(i&&o&&e!=="ROOT"){n=o;if(t){n+=" "+R._getLibraryResourceBundle().getText(e+"_ARIA_LABEL_WITH_TITLE")}}else{n=R._getLibraryResourceBundle().getText(e+"_ARIA_LABEL_WITHOUT_TITLE")}return n};R.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){var e=this.$("footerWrapper").get(0),t=this._getDOMRefHeight(e),i=e?parseFloat(getComputedStyle(e).marginBottom):0;return t+i}return 0};R.prototype._getDOMRefHeight=function(e){return e&&e.parentElement?e.getBoundingClientRect().height:0};R.prototype._updateAriaLabels=function(){var e=this.getLandmarkInfo(),t=this._getAriaLabelText("ROOT",true),i=this._getAriaLabelText("HEADER",true),o=this._getAriaLabelText("NAVIGATION",false),n=this._getAriaLabelText("NAVTOOLBAR",true),r=e&&e.getHeaderLabel(),s=e&&e.getRootLabel(),a=e&&e.getNavigationLabel();if(!s){this.$().attr("aria-label",t)}if(!r){this.$("headerTitle").attr("aria-label",i)}if(!a){this.$("anchorBar").attr("aria-label",o);this.$("stickyAnchorBar").attr("aria-label",o)}this.$("anchBar").attr("aria-label",n)};R.prototype._formatLandmarkInfo=function(e,t){if(e){var i=e["get"+t+"Role"]()||"",o=e["get"+t+"Label"]()||"";if(i===L.None){i=""}return{role:i.toLowerCase(),label:o}}return{}};R.prototype._getHeaderTag=function(e){if(e&&e.getHeaderRole()!==L.None){return R.DIV}return R.HEADER};R.prototype._getFooterTag=function(e){if(e&&e.getFooterRole()!==L.None){return R.DIV}return R.FOOTER};function D(e){if(arguments.length===1){return Array.isArray(e)?e.length>0:!!e}return Array.prototype.slice.call(arguments).every(function(e){return D(e)})}return R});
//# sourceMappingURL=ObjectPageLayout.js.map