//@ui5-bundle Library-preload.js
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/base/i18n/Formatting", ["sap/base/assert","sap/base/config","sap/base/Eventing","sap/base/Log","sap/base/i18n/Localization","sap/base/i18n/LanguageTag","sap/base/i18n/date/CalendarType","sap/base/i18n/date/CalendarWeekNumbering","sap/base/util/deepEqual","sap/base/util/extend","sap/base/util/isEmptyObject"],(e,t,a,r,n,s,i,o,u,m,l)=>{"use strict";const d=new a;const g=t.getWritableInstance();const p={};let c;let y;const f={"":{pattern:null},1:{pattern:"dd.MM.yyyy"},2:{pattern:"MM/dd/yyyy"},3:{pattern:"MM-dd-yyyy"},4:{pattern:"yyyy.MM.dd"},5:{pattern:"yyyy/MM/dd"},6:{pattern:"yyyy-MM-dd"},7:{pattern:"Gyy.MM.dd"},8:{pattern:"Gyy/MM/dd"},9:{pattern:"Gyy-MM-dd"},A:{pattern:"yyyy/MM/dd"},B:{pattern:"yyyy/MM/dd"},C:{pattern:"yyyy/MM/dd"}};const b={"":{short:null,medium:null,dayPeriods:null},0:{short:"HH:mm",medium:"HH:mm:ss",dayPeriods:null},1:{short:"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["AM","PM"]},2:{short:"hh:mm a",medium:"hh:mm:ss a",dayPeriods:["am","pm"]},3:{short:"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["AM","PM"]},4:{short:"KK:mm a",medium:"KK:mm:ss a",dayPeriods:["am","pm"]}};const C={"":{groupingSeparator:null,decimalSeparator:null}," ":{groupingSeparator:".",decimalSeparator:","},X:{groupingSeparator:",",decimalSeparator:"."},Y:{groupingSeparator:" ",decimalSeparator:","}};function A(e,t){if(!e){throw new TypeError(t)}}function P(e,a){t._.invalidate();const r=p[e];if(a!=null){p[e]=a}else{delete p[e]}if((r!=null||a!=null)&&!u(r,a)){const t=!c;c??={};c[e]=a;if(t){S()}}}function h(e){let t;if(e&&typeof e==="string"){try{t=new s(e)}catch(e){}}else if(e instanceof s){t=e}return t}const T={attachChange(e){d.attachEvent("change",e)},detachChange(e){d.detachEvent("change",e)},getLanguageTag(){function e(){let e=new s(n.getLanguage());if(!l(p)||T.getCalendarWeekNumbering()!==o.Default){let t=e.toString();if(t.indexOf("-x-")<0){t+="-x-sapufmt"}else if(t.indexOf("-sapufmt")<=t.indexOf("-x-")){t+="-sapufmt"}e=new s(t)}return e}return g.get({name:"sapUiFormatLocale",type:function(e){return new s(e)},defaultValue:e,external:true})},setLanguageTag(e){const t=h(e);A(e==null||t,"vLanguageTag must be a BCP47 language tag or Java Locale id or null");const a=T.getLanguageTag();g.set("sapUiFormatLocale",t?.toString());const r=T.getLanguageTag();if(a.toString()!==r.toString()){const e=!c;c??={};c.languageTag=r.toString();if(e){S()}}},_set:P,getCustomUnits(){return p["units"]?.["short"]},setCustomUnits(e){let t=null;if(e){t={short:e}}P("units",t)},addCustomUnits(e){const t=T.getCustomUnits();if(t){e=m({},t,e)}T.setCustomUnits(e)},setUnitMappings(e){P("unitMappings",e)},addUnitMappings(e){const t=T.getUnitMappings();if(t){e=m({},t,e)}T.setUnitMappings(e)},getUnitMappings(){return p["unitMappings"]},getDatePattern(t){e(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");return p["dateFormats-"+t]},setDatePattern(e,t){A(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");P("dateFormats-"+e,t)},getTimePattern(t){e(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");return p["timeFormats-"+t]},setTimePattern(e,t){A(e=="short"||e=="medium"||e=="long"||e=="full","sStyle must be short, medium, long or full");P("timeFormats-"+e,t)},getNumberSymbol(t){e(["group","decimal","plusSign","minusSign"].includes(t),"sType must be decimal, group, plusSign or minusSign");return p["symbols-latn-"+t]},setNumberSymbol(e,t){A(["group","decimal","plusSign","minusSign"].includes(e),"sType must be decimal, group, plusSign or minusSign");P("symbols-latn-"+e,t)},getCustomCurrencies(){return p["currency"]},setCustomCurrencies(e){A(typeof e==="object"||e==null,"mCurrencyDigits must be an object");Object.keys(e||{}).forEach(function(t){A(typeof t==="string");A(typeof e[t]==="object")});P("currency",e)},addCustomCurrencies(e){const t=T.getCustomCurrencies();if(t){e=m({},t,e)}T.setCustomCurrencies(e)},_setDayPeriods(t,a){e(t=="narrow"||t=="abbreviated"||t=="wide","sWidth must be narrow, abbreviated or wide");P("dayPeriods-format-"+t,a)},getABAPDateFormat(){const e=g.get({name:"sapUiABAPDateFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyDateFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPDateFormat(e){e=e?String(e).toUpperCase():"";A(f.hasOwnProperty(e),"sFormatId must be one of ['1','2','3','4','5','6','7','8','9','A','B','C'] or empty");const t=!c;const a=T.getABAPDateFormat();if(a!==e){c??={};g.set("sapUiABAPDateFormat",e);c.ABAPDateFormat=e;T.setDatePattern("short",f[e].pattern);T.setDatePattern("medium",f[e].pattern);if(t){S()}}},getABAPTimeFormat(){const e=g.get({name:"sapUiABAPTimeFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyTimeFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPTimeFormat(e){e=e||"";A(b.hasOwnProperty(e),"sFormatId must be one of ['0','1','2','3','4'] or empty");const t=!c;const a=T.getABAPTimeFormat();if(a!==e){c??={};g.set("sapUiABAPTimeFormat",e);c.ABAPTimeFormat=e;T.setTimePattern("short",b[e]["short"]);T.setTimePattern("medium",b[e]["medium"]);T._setDayPeriods("abbreviated",b[e].dayPeriods);if(t){S()}}},getABAPNumberFormat(){const e=g.get({name:"sapUiABAPNumberFormat",type:t.Type.String,defaultValue:g.get({name:"sapUiLegacyNumberFormat",type:t.Type.String,external:true}),external:true});return e?e.toUpperCase():undefined},setABAPNumberFormat(e){e=e?e.toUpperCase():"";A(C.hasOwnProperty(e),"sFormatId must be one of [' ','X','Y'] or empty");const t=!c;const a=T.getABAPNumberFormat();if(a!==e){c??={};g.set("sapUiABAPNumberFormat",e);c.ABAPNumberFormat=e;T.setNumberSymbol("group",C[e].groupingSeparator);T.setNumberSymbol("decimal",C[e].decimalSeparator);if(t){S()}}},setCustomIslamicCalendarData(e){A(Array.isArray(e),"aCustomCalendarData must be an Array");const t=!c;c??={};y=c.customIslamicCalendarData=e.slice();if(t){S()}},getCustomIslamicCalendarData(){return y?.slice()??undefined},setTrailingCurrencyCode(e){A(typeof e==="boolean","bTrailingCurrencyCode must be a boolean");g.set("sapUiTrailingCurrencyCode",e)},getTrailingCurrencyCode(){return g.get({name:"sapUiTrailingCurrencyCode",type:t.Type.Boolean,defaultValue:true,external:true})},getCustomLocaleData(){return p},getCalendarWeekNumbering(){let e=o.Default;try{e=g.get({name:"sapUiCalendarWeekNumbering",type:o,defaultValue:o.Default,external:true})}catch(e){}return e},setCalendarWeekNumbering(e){t._.checkEnum(o,e,"calendarWeekNumbering");const a=g.get({name:"sapUiCalendarWeekNumbering",type:o,defaultValue:o.Default,external:true});if(a!==e){const t=!c;c??={};g.set("sapUiCalendarWeekNumbering",e);c.calendarWeekNumbering=e;if(t){S()}}},getCalendarType(){let e,a=g.get({name:"sapUiCalendarType",type:t.Type.String,external:true});a??=null;if(a){for(e in i){if(e.toLowerCase()===a.toLowerCase()){return e}}r.warning("Parameter 'calendarType' is set to "+a+" which isn't a valid value and therefore ignored. The calendar type is determined from format setting and current locale")}const s=T.getABAPDateFormat();switch(s){case"1":case"2":case"3":case"4":case"5":case"6":return i.Gregorian;case"7":case"8":case"9":return i.Japanese;case"A":case"B":return i.Islamic;case"C":return i.Persian;default:return n.getPreferredCalendarType()}},setCalendarType(e){const t=T.getCalendarType();g.set("sapUiCalendarType",e);const a=T.getCalendarType();if(t!==a){const e=!c;c??={};c.calendarType=a;if(e){S()}}}};function S(){d.fireEvent("change",c);c=undefined}function F(){const e=T.getABAPDateFormat();if(e!==undefined){T.setABAPDateFormat(e)}const t=T.getABAPNumberFormat();if(t!==undefined){T.setABAPNumberFormat(t)}const a=T.getABAPTimeFormat();if(a!==undefined){T.setABAPTimeFormat(a)}}F();return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/i18n/ResourceBundle", ["sap/base/assert","sap/base/Log","sap/base/i18n/Localization","sap/base/strings/formatMessage","sap/base/util/Properties","sap/base/util/merge"],function(e,r,n,t,i,a){"use strict";var o=/^((?:[A-Z]{2,3}(?:-[A-Z]{3}){0,3})|[A-Z]{4}|[A-Z]{5,8})(?:-([A-Z]{4}))?(?:-([A-Z]{2}|[0-9]{3}))?((?:-[0-9A-Z]{5,8}|-[0-9][0-9A-Z]{3})*)((?:-[0-9A-WYZ](?:-[0-9A-Z]{2,8})+)*)(?:-(X(?:-[0-9A-Z]{1,8})+))?$/i;var s={he:"iw",yi:"ji",nb:"no"};var l={iw:"he",ji:"yi",no:"nb"};var u={en_US_saptrc:"1Q",en_US_sappsd:"2Q",en_US_saprigi:"3Q"};var f="en";var c=/(?:^|-)(saptrc|sappsd|saprigi)(?:-|$)/i;function h(e,r){var n;if(typeof e==="string"&&(n=o.exec(e.replace(/_/g,"-")))){var t=n[1].toLowerCase();if(!r){t=s[t]||t}var i=n[2]?n[2].toLowerCase():undefined;var a=n[3]?n[3].toUpperCase():undefined;var l=n[4]?n[4].slice(1):undefined;var u=n[6];if(u&&(n=c.exec(u))||l&&(n=c.exec(l))){return"en_US_"+n[1].toLowerCase()}if(t==="zh"&&!a){if(i==="hans"){a="CN"}else if(i==="hant"){a="TW"}}if(t==="sr"&&i==="latn"){if(r){t="sr_Latn"}else{t="sh"}}return t+(a?"_"+a+(l?"_"+l.replace("-","_"):""):"")}}function p(e,r){if(e===""){return e}var n=h(e,r);if(n===undefined){throw new TypeError("Locale '"+e+"' is not a valid BCP47 language tag")}return n}function d(e){var r;r=n.getLanguage();r=h(r);return r||e}function g(e,r){var n;if(typeof e==="string"&&(n=o.exec(e.replace(/_/g,"-")))){var t=n[1].toLowerCase();var i=n[2]?n[2].toLowerCase():undefined;if(r&&t==="sh"&&!i){t="sr_Latn"}else if(!r&&t==="sr"&&i==="latn"){t="sh"}t=l[t]||t;return t+(n[3]?"-"+n[3].toUpperCase()+(n[4]?"-"+n[4].slice(1).replace("_","-"):""):"")}}var b=/^((?:[^?#]*\/)?[^\/?#]*)(\.[^.\/?#]+)((?:\?([^#]*))?(?:#(.*))?)$/;var y=[".properties",".hdbtextbundle"];function v(e){var r=b.exec(e);if(!r||y.indexOf(r[2])<0){throw new Error("resource URL '"+e+"' has unknown type (should be one of "+y.join(",")+")")}return{url:e,prefix:r[1],ext:r[2],query:r[4],hash:r[5]||"",suffix:r[2]+(r[3]||"")}}function _(e,r,t,i,a,o,s){this.sLocale=h(r)||d(o===undefined?f:o);this.oUrlInfo=v(e);this.bIncludeInfo=t;this.bAsync=i;this.aCustomBundles=[];this.aPropertyFiles=[];this.aPropertyOrigins=[];this.aLocales=[];this._aFallbackLocales=C(this.sLocale,a||n.getSupportedLanguages(),o," of the bundle '"+this.oUrlInfo.url+"'",s);if(i){var l=function(){return this}.bind(this);return m(this).then(l,l)}L(this)}_.prototype._enhance=function(e){if(e instanceof _){this.aCustomBundles.push(e)}else{r.error("Custom resource bundle is either undefined or not an instanceof sap/base/i18n/ResourceBundle. Therefore this custom resource bundle will be ignored!")}};_.prototype.getText=function(r,n,t){var i=this._getTextFromProperties(r,n);if(i!=null){return i}i=this._getTextFromFallback(r,n);if(i!=null){return i}if(t){return undefined}else{e(false,"could not find any translatable text for key '"+r+"' in bundle file(s): '"+this.aPropertyOrigins.join("', '")+"'");return this._formatValue(r,r,n)}};_.prototype._formatValue=function(e,n,i){if(typeof e==="string"){if(i!==undefined&&!Array.isArray(i)){r.error("sap/base/i18n/ResourceBundle: value for parameter 'aArgs' is not of type array")}if(i){e=t(e,i)}if(this.bIncludeInfo){e=new String(e);e.originInfo={source:"Resource Bundle",url:this.oUrlInfo.url,locale:this.sLocale,key:n}}}return e};_.prototype._getTextFromFallback=function(e,r){var n,t;for(t=this.aCustomBundles.length-1;t>=0;t--){n=this.aCustomBundles[t]._getTextFromFallback(e,r);if(n!=null){return n}}while(typeof n!=="string"&&this._aFallbackLocales.length){var i=L(this);if(i){n=i.getProperty(e);if(typeof n==="string"){return this._formatValue(n,e,r)}}}return null};_.prototype._getTextFromProperties=function(e,r){var n=null,t;for(t=this.aCustomBundles.length-1;t>=0;t--){n=this.aCustomBundles[t]._getTextFromProperties(e,r);if(n!=null){return n}}for(t=0;t<this.aPropertyFiles.length;t++){n=this.aPropertyFiles[t].getProperty(e);if(typeof n==="string"){return this._formatValue(n,e,r)}}return null};_.prototype.hasText=function(e){return this.aPropertyFiles.length>0&&typeof this.aPropertyFiles[0].getProperty(e)==="string"};_.prototype._recreate=function(){if(!this._mCreateFactoryParams){var e=new Error("ResourceBundle instance can't be recreated as it has not been created by the ResourceBundle.create factory.");if(this.bAsync){return Promise.reject(e)}else{throw e}}else{return _.create(this._mCreateFactoryParams)}};function m(e){if(e._aFallbackLocales.length){return x(e,true).then(function(r){return r||m(e)})}return Promise.resolve(null)}function L(e){while(e._aFallbackLocales.length){var r=x(e,false);if(r){return r}}return null}function x(e,r){var n=e._aFallbackLocales.shift();if(n!=null){var t=e.oUrlInfo,a,o;if(t.ext===".hdbtextbundle"){if(u[n]){a=t.prefix+t.suffix+"?"+(t.query?t.query+"&":"")+"sap-language="+u[n]+(t.hash?"#"+t.hash:"")}else{a=t.url}o={"Accept-Language":g(n)||"*"}}else{a=t.prefix+(n?"_"+n:"")+t.suffix}var s=i.create({url:a,headers:o,async:!!r,returnNullIfMissing:true});var l=function(r){if(r){e.aPropertyFiles.push(r);e.aPropertyOrigins.push(a);e.aLocales.push(n)}return r};return r?s.then(l):l(s)}return r?Promise.resolve(null):null}_._getUrl=function(e,r){var n=e;if(r){r=r.replace(/\./g,"/");n=sap.ui.require.toUrl(r)+".properties"}return n};function P(e,r,n,t,i,a,o){if(!r){return[]}var s=[];r.forEach(function(r){if(r.fallbackLocale===undefined){r.fallbackLocale=a}if(r.supportedLocales===undefined){r.supportedLocales=o}var l=_._getUrl(r.bundleUrl,r.bundleName);var u=new _(l,n,t,i,r.supportedLocales,r.fallbackLocale);s.push(u);if(r.terminologies){s=s.concat(w(e,r.terminologies,n,t,i))}});return s}function w(e,r,n,t,i){if(!e){return[]}e=e.filter(function(e){return r.hasOwnProperty(e)});e.reverse();return e.map(function(e){var a=r[e];var o=_._getUrl(a.bundleUrl,a.bundleName);var s=a.supportedLocales;return new _(o,n,t,i,s,null,true)})}_.create=function(e){var r=a({},e);e=a({url:"",includeInfo:false},e);if(e.bundleUrl||e.bundleName){e.url=e.url||_._getUrl(e.bundleUrl,e.bundleName)}e=_._enrichBundleConfig(e);var n=new _(e.url,e.locale,e.includeInfo,!!e.async,e.supportedLocales,e.fallbackLocale);if(n instanceof Promise){n=n.then(function(e){e._mCreateFactoryParams=r;return e})}else{n._mCreateFactoryParams=r}var t=[];if(e.terminologies){t=t.concat(w(e.activeTerminologies,e.terminologies,e.locale,e.includeInfo,!!e.async))}if(e.enhanceWith){t=t.concat(P(e.activeTerminologies,e.enhanceWith,e.locale,e.includeInfo,!!e.async,e.fallbackLocale,e.supportedLocales))}if(t.length){if(n instanceof Promise){n=n.then(function(e){return Promise.all(t).then(function(r){r.forEach(e._enhance,e)}).then(function(){return e})})}else{t.forEach(n._enhance,n)}}return n};_._enrichBundleConfig=function(e){return e};function F(e,r){if(!r||r.length===0||r.includes(e)){return e}e=g(e,true);if(e){e=h(e,true)}if(r.includes(e)){return e}return undefined}function C(e,n,t,i,a){n=n&&n.map(function(e){return p(e,true)});if(!a){var o=t!==undefined;t=o?t:f;t=p(t);if(t!==""&&!F(t,n)){var s="The fallback locale '"+t+"' is not contained in the list of supported locales ['"+n.join("', '")+"']"+i+" and will be ignored.";if(o){throw new Error(s)}r.error(s)}}var l=[],u;while(e!=null){u=F(e,n);if(u!==undefined&&l.indexOf(u)===-1){l.push(u)}if(!e){e=null}else if(e==="zh_HK"){e="zh_TW"}else if(e.lastIndexOf("_")>=0){e=e.slice(0,e.lastIndexOf("_"))}else if(a){e=null}else if(t){e=t;t=null}else{e=""}}return l}_._getFallbackLocales=function(e,r,n){return C(h(e),r,n,"")};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/i18n/date/CalendarWeekNumbering", [],function(){"use strict";var e={Default:"Default",ISO_8601:"ISO_8601",MiddleEastern:"MiddleEastern",WesternTraditional:"WesternTraditional"};Object.defineProperty(e,"getWeekConfigurationValues",{value:function(t){switch(t){case e.ISO_8601:return{firstDayOfWeek:1,minimalDaysInFirstWeek:4};case e.MiddleEastern:return{firstDayOfWeek:6,minimalDaysInFirstWeek:1};case e.WesternTraditional:return{firstDayOfWeek:0,minimalDaysInFirstWeek:1};default:return undefined}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/camelize", [],function(){"use strict";var r=/-(.)/gi;var e=function(e){return e.replace(r,function(r,e){return e.toUpperCase()})};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/formatMessage", ["sap/base/assert"],function(r){"use strict";var e=/('')|'([^']+(?:''[^']*)*)(?:'|$)|\{([0-9]+(?:\s*,[^{}]*)?)\}|[{}]/g;var t=function(t,n){r(typeof t==="string"||t instanceof String,"pattern must be string");if(arguments.length>2||n!=null&&!Array.isArray(n)){n=Array.prototype.slice.call(arguments,1)}n=n||[];return t.replace(e,function(r,e,t,s,a){if(e){return"'"}else if(t){return t.replace(/''/g,"'")}else if(s){return String(n[parseInt(s)])}throw new Error("formatMessage: pattern syntax error at pos. "+a)})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/ObjectPath", [],function(){"use strict";var r={};var e=window;function t(r){return Array.isArray(r)?r.slice():r.split(".")}r.create=function(r,n){var a=n||e;var o=t(r);for(var i=0;i<o.length;i++){var u=o[i];if(a[u]===null||a[u]!==undefined&&(typeof a[u]!=="object"&&typeof a[u]!=="function")){throw new Error("Could not set object-path for '"+o.join(".")+"', path segment '"+u+"' already exists.")}a[u]=a[u]||{};a=a[u]}return a};r.get=function(r,n){var a=n||e;var o=t(r);var i=o.pop();for(var u=0;u<o.length&&a;u++){a=a[o[u]]}return a?a[i]:undefined};r.set=function(n,a,o){o=o||e;var i=t(n);var u=i.pop();var f=r.create(i,o);f[u]=a};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/Properties", ["sap/base/util/LoaderExtensions"],function(e){"use strict";var r=function(){this.mProperties={};this.aKeys=null};r.prototype.getProperty=function(e,r){var t=this.mProperties[e];if(typeof t=="string"){return t}else if(r){return r}return null};r.prototype.getKeys=function(){if(!this.aKeys){this.aKeys=Object.keys(this.mProperties)}return this.aKeys};r.prototype.setProperty=function(e,r){if(typeof r!="string"){return}if(typeof this.mProperties[e]!="string"&&this.aKeys){this.aKeys.push(String(e))}this.mProperties[e]=r};r.prototype.clone=function(){var e=new r;e.mProperties=Object.assign({},this.mProperties);return e};var t=typeof chrome==="object"||typeof v8==="object"?function(e,r){if(r>2&&40*r>e.length){Number(e)}return e}:function(e){return e};var n=/(?:\r\n|\r|\n|^)[ \t\f]*/;var i=/(\\u[0-9a-fA-F]{0,4})|(\\.)|(\\$)|([ \t\f]*[ \t\f:=][ \t\f]*)/g;var s=/(\\u[0-9a-fA-F]{0,4})|(\\.)|(\\$)/g;var o={"\\f":"\f","\\n":"\n","\\r":"\r","\\t":"\t"};function f(e,r){var f=e.split(n),u,l,a,c,p,h,y,g;function d(e){if(c){c=c+e;g++}else{c=e;g=0}}r.mProperties={};for(p=0;p<f.length;p++){u=f[p];if(u===""||u.charAt(0)==="#"||u.charAt(0)==="!"){continue}l=i;l.lastIndex=y=0;a=null;c="";while((h=l.exec(u))!==null){if(y<h.index){d(u.slice(y,h.index))}y=l.lastIndex;if(h[1]){if(h[1].length!==6){throw new Error("Incomplete Unicode Escape '"+h[1]+"'")}d(String.fromCharCode(parseInt(h[1].slice(2),16)))}else if(h[2]){d(o[h[2]]||h[2].slice(1))}else if(h[3]){u=f[++p];l.lastIndex=y=0}else if(h[4]){a=c;c="";l=s;l.lastIndex=y}}if(y<u.length){d(u.slice(y))}if(a==null){a=c;c=""}r.mProperties[a]=t(c,c?g:0)}}r.create=function(t){t=Object.assign({url:undefined,headers:{}},t);var n=!!t.async,i=new r,s;function o(e){if(typeof e==="string"){f(e,i);return i}return t.returnNullIfMissing?null:i}if(typeof t.url==="string"){s=e.loadResource({url:t.url,dataType:"text",headers:t.headers,failOnError:false,async:n})}if(n){if(!s){return Promise.resolve(o(null))}return s.then(function(e){return o(e)},function(e){throw e instanceof Error?e:new Error("Problem during loading of property file '"+t.url+"': "+e)})}return o(s)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/Version", [],function(){"use strict";var t=/^[0-9]+(?:\.([0-9]+)(?:\.([0-9]+))?)?(.*)$/;function n(r,i,e,o){if(r instanceof n){return r}if(!(this instanceof n)){return new n(r,i,e,o)}var u;if(typeof r==="string"){u=t.exec(r)}else if(Array.isArray(r)){u=r}else{u=arguments}u=u||[];function f(t){t=parseInt(t);return isNaN(t)?0:t}r=f(u[0]);i=f(u[1]);e=f(u[2]);o=String(u[3]||"");this.toString=function(){return r+"."+i+"."+e+o};this.getMajor=function(){return r};this.getMinor=function(){return i};this.getPatch=function(){return e};this.getSuffix=function(){return o};this.compareTo=function(){var t=n.apply(window,arguments);return r-t.getMajor()||i-t.getMinor()||e-t.getPatch()||(o<t.getSuffix()?-1:o===t.getSuffix()?0:1)}}n.prototype.inRange=function(t,n){return this.compareTo(t)>=0&&this.compareTo(n)<0};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/array/uniqueSort", ["sap/base/assert"],function(r){"use strict";var a=function(a){r(Array.isArray(a),"uniqueSort: input parameter must be an Array");var e=a.length;if(e>1){a.sort();var i=0;for(var t=1;t<e;t++){if(a.indexOf(a[t])===t){a[++i]=a[t]}}if(++i<e){a.splice(i,e-i)}}return a};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/deepEqual", ["sap/base/Log"],function(e){"use strict";var r=function(t,n,f,a,u){if(typeof f=="boolean"){a=f;f=undefined}if(!u){u=0}if(!f){f=10}if(u>f){e.warning("deepEqual comparison exceeded maximum recursion depth of "+f+". Treating values as unequal");return false}if(t===n||Number.isNaN(t)&&Number.isNaN(n)){return true}if(Array.isArray(t)&&Array.isArray(n)){if(!a&&t.length!==n.length){return false}if(t.length>n.length){return false}for(var i=0;i<t.length;i++){if(!r(t[i],n[i],f,a,u+1)){return false}}return true}if(typeof t=="object"&&typeof n=="object"){if(!t||!n){return false}if(t.constructor!==n.constructor){return false}if(!a&&Object.keys(t).length!==Object.keys(n).length){return false}if(t instanceof Node){return t.isEqualNode(n)}if(t instanceof Date){return t.valueOf()===n.valueOf()}for(var i in t){if(!r(t[i],n[i],f,a,u+1)){return false}}return true}return false};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/deepExtend", ["./_merge"],function(r){"use strict";var u=function(){var u=[true,true];u.push.apply(u,arguments);return r.apply(null,u)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/isEmptyObject", [],function(){"use strict";var r=function r(n){for(var e in n){return false}return true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/merge", ["./_merge"],function(e){"use strict";var r=function(){var r=[true,false];r.push.apply(r,arguments);return e.apply(null,r)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/resolveReference", ["sap/base/util/ObjectPath"],function(t){"use strict";var n=Object.create(null);function e(e,i,o){var r,f;if(i&&e[0]in i){f=e.length>1?t.get(e.slice(0,-1),i):i;r=f&&f[e[e.length-1]];if(typeof r==="function"&&o.bindContext){r=r.bind(o.rootContext||f)}return r}return n}var i=function(i,o,r){o=o||{};r=r||{};r.bindContext=r.bindContext!==false;r.bindDotContext=r.bindDotContext!==false;var f=i.split("."),u=f.shift()||".",d=u===".",b=n;f.unshift(u);if(r.preferDotContext&&!d){b=e(f,o["."],{bindContext:r.bindContext&&r.bindDotContext,rootContext:o["."]})}if(b===n){b=e(f,o,{bindContext:r.bindContext&&(d?r.bindDotContext:f.length>1),rootContext:d?o["."]:undefined})}if(!d){if(b===n&&r.useProbingRequire){b=sap.ui.require(i.replace(/\./g,"/"));if(b===undefined){b=n}}if(b===n){b=t.get(i)}}return b===n?undefined:b};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/Global", ["sap/ui/VersionInfo","sap/base/Log","sap/base/assert","sap/base/util/ObjectPath"],function(e,a,n,t){"use strict";if(window.OpenAjax&&window.OpenAjax.hub){OpenAjax.hub.registerLibrary("sap","http://www.sap.com/","0.1",{})}var r;if(typeof window.sap!=="object"&&typeof window.sap!=="function"){window.sap={}}if(typeof window.sap.ui!=="object"){window.sap.ui={}}sap.ui=Object.assign(sap.ui,{version:"1.120.22",buildinfo:{lastchange:"",buildtime:"20241024-1020"}});var o=sap.ui.loader._.getSyncCallBehavior();sap.ui.getVersionInfo=function(n){if(n&&n.async){a.info("Do not use deprecated function 'sap.ui.getVersionInfo'. Use"+" 'sap/ui/VersionInfo' module's asynchronous .load function instead")}else{a.warning("Do not use deprecated function 'sap.ui.getVersionInfo' synchronously! Use"+" 'sap/ui/VersionInfo' module's asynchronous .load function instead","Deprecation",null,function(){return{type:"sap.ui.getVersionInfo",name:"Global"}})}return e._load(n)};sap.ui.namespace=function(e){n(false,"sap.ui.namespace is long time deprecated and shouldn't be used");return t.create(e)};sap.ui.lazyRequire=function(e,s,i){n(typeof e==="string"&&e,"lazyRequire: sClassName must be a non-empty string");n(!s||typeof s==="string","lazyRequire: sMethods must be empty or a string");if(o===2){a.error("[nosync] lazy stub creation ignored for '"+e+"'");return}var u=e.replace(/\//gi,"."),c=u.lastIndexOf("."),p=u.substr(0,c),l=u.substr(c+1),f=t.create(p),y=f[l],d=(s||"new").split(" "),b=d.indexOf("new");i=i||u;if(!y){if(b>=0){y=function(){if(o){if(o===1){a.error("[nosync] lazy stub for constructor '"+u+"' called")}}else{a.debug("lazy stub for constructor '"+u+"' called.")}sap.ui.requireSync(i.replace(/\./g,"/"));var t=f[l];n(typeof t==="function","lazyRequire: oRealClass must be a function after loading");if(t._sapUiLazyLoader){throw new Error("lazyRequire: stub '"+u+"'has not been replaced by module '"+i+"'")}var s=Object.create(t.prototype);if(!(this instanceof y)){r=r||sap.ui.require("sap/ui/base/Object");if(r&&s instanceof r){a.error("Constructor "+e+' has been called without "new" operator!',null,null,function(){try{throw new Error}catch(e){return e}})}}var c=t.apply(s,arguments);if(c&&(typeof c==="function"||typeof c==="object")){s=c}return s};y._sapUiLazyLoader=true;d.splice(b,1)}else{y={}}f[l]=y}d.forEach(function(e){if(!y[e]){y[e]=function(){if(o){if(o===1){a.error("[no-sync] lazy stub for method '"+u+"."+e+"' called")}}else{a.debug("lazy stub for method '"+u+"."+e+"' called.")}sap.ui.requireSync(i.replace(/\./g,"/"));var t=f[l];n(typeof t==="function"||typeof t==="object","lazyRequire: oRealClass must be a function or object after loading");n(typeof t[e]==="function","lazyRequire: method must be a function");if(t[e]._sapUiLazyLoader){throw new Error("lazyRequire: stub '"+u+"."+e+"' has not been replaced by loaded module '"+i+"'")}return t[e].apply(t,arguments)};y[e]._sapUiLazyLoader=true}})};sap.ui.lazyRequire._isStub=function(e){n(typeof e==="string"&&e,"lazyRequire._isStub: sClassName must be a non-empty string");var a=e.lastIndexOf("."),r=e.slice(0,a),o=e.slice(a+1),s=t.get(r||"");return!!(s&&typeof s[o]==="function"&&s[o]._sapUiLazyLoader)};sap.ui.resource=function(e,a){n(typeof e==="string","sLibraryName must be a string");n(typeof a==="string","sResourcePath must be a string");return sap.ui.require.toUrl((String(e).replace(/\./g,"/")+"/"+a).replace(/^\/*/,""))};sap.ui.localResources=function(e){n(e,"sNamespace must not be empty");var a={};a[e.replace(/\./g,"/")]="./"+e.replace(/\./g,"/");sap.ui.loader.config({paths:a})};return sap.ui});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/VersionInfo", ["sap/base/util/LoaderExtensions"],function(n){"use strict";var e={};e.load=function(n){n=n||{};n.async=true;return e._load(n)};var r=null;var i;var a;var t;function s(n){i=n;a=null;t=null}Object.defineProperty(sap.ui,"versioninfo",{configurable:true,enumerable:true,get:function(){return i},set:function(n){s(n)}});e._load=function(a){if(typeof a!=="object"){a={library:a}}a.async=a.async===true;a.failOnError=a.failOnError!==false;if(!i){if(a.async&&r instanceof Promise){return r.then(function(){return e._load(a)})}var t=function(n){r=null;if(n===null){return undefined}s(n);return e._load(a)};var o=function(n){r=null;throw n};var f=n.loadResource("sap-ui-version.json",{async:a.async,failOnError:a.async||a.failOnError});if(f instanceof Promise){r=f;return f.then(t,o)}else{return t(f)}}else{var u;if(typeof a.library!=="undefined"){var c=i.libraries;if(c){for(var l=0,d=c.length;l<d;l++){if(c[l].name===a.library){u=c[l];break}}}}else{u=i}return a.async?Promise.resolve(u):u}};function o(){if(i){if(i.libraries&&!a){a={};i.libraries.forEach(function(n,e){a[n.name]={};var r=n.manifestHints&&n.manifestHints.dependencies&&n.manifestHints.dependencies.libs;for(var i in r){if(!r[i].lazy){a[n.name][i]=true}}})}if(i.components&&!t){t={};Object.keys(i.components).forEach(function(n){var e=i.components[n];t[n]={library:e.library,hasOwnPreload:e.hasOwnPreload||false,dependencies:[]};var r=e.manifestHints&&e.manifestHints.dependencies&&e.manifestHints.dependencies.libs;for(var a in r){if(!r[a].lazy){t[n].dependencies.push(a)}}})}}}e._getTransitiveDependencyForLibraries=function(n){o();if(a){var e=n.reduce(function(n,e){n[e]=true;return Object.assign(n,a[e])},{});n=Object.keys(e)}return n};e._getTransitiveDependencyForComponent=function(n){o();if(t){return t[n]}};e._reset=function(){s()};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/DataType", ["sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/resolveReference"],function(e,t,n,r,a){"use strict";var i=function(){throw new Error};i.prototype.getName=function(){return undefined};i.prototype.getBaseType=function(){return undefined};i.prototype.getPrimitiveType=function(){var e=this;while(e.getBaseType()){e=e.getBaseType()}return e};i.prototype.getComponentType=function(){return undefined};i.prototype.getDefaultValue=function(){return undefined};i.prototype.isArrayType=function(){return false};i.prototype.isEnumType=function(){return false};i.prototype.getEnumValues=function(){return undefined};i.prototype.parseValue=function(e){return e};i.prototype.isValid=undefined;i.prototype.setNormalizer=function(e){t(typeof e==="function","DataType.setNormalizer: fnNormalizer must be a function");this._fnNormalizer=typeof e==="function"?e:undefined};i.prototype.normalize=function(e){return this._fnNormalizer?this._fnNormalizer(e):e};function u(e,t,n){t=t||{};var r=n||i.prototype;var a=Object.create(r);a.getName=function(){return e};if(t.hasOwnProperty("defaultValue")){var u=t.defaultValue;a.getDefaultValue=function(){return u}}if(t.isValid){var o=t.isValid;a.isValid=r.isValid?function(e){if(!r.isValid(e)){return false}return o(e)}:o}if(t.parseValue){a.parseValue=t.parseValue}a.getBaseType=function(){return n};return a}var o={any:u("any",{defaultValue:null,isValid:function(e){return true}}),boolean:u("boolean",{defaultValue:false,isValid:function(e){return typeof e==="boolean"},parseValue:function(e){return e=="true"}}),int:u("int",{defaultValue:0,isValid:function(e){return typeof e==="number"&&(isNaN(e)||Math.floor(e)==e)},parseValue:function(e){return parseInt(e)}}),float:u("float",{defaultValue:0,isValid:function(e){return typeof e==="number"},parseValue:function(e){return parseFloat(e)}}),string:u("string",{defaultValue:"",isValid:function(e){return typeof e==="string"||e instanceof String},parseValue:function(e){return e}}),object:u("object",{defaultValue:null,isValid:function(e){return typeof e==="object"||typeof e==="function"},parseValue:function(e){return e?JSON.parse(e):null}}),function:u("function",{defaultValue:null,isValid:function(e){return e==null||typeof e==="function"},parseValue:function(e,t){if(e===""){return undefined}if(!/^\.?[A-Z_\$][A-Z0-9_\$]*(\.[A-Z_\$][A-Z0-9_\$]*)*$/i.test(e)){throw new Error("Function references must consist of dot separated "+"simple identifiers (A-Z, 0-9, _ or $) only, but was '"+e+"'")}var n,r=t&&t.context,i=t&&t.locals;n=a(e,Object.assign({".":r},i));if(n&&this.isValid(n)){return n}throw new TypeError("The string '"+e+"' couldn't be resolved to a function")}})};var s=u("array",{defaultValue:[]});function f(e){t(e instanceof i,"DataType.<createArrayType>: componentType must be a DataType");var n=Object.create(i.prototype);n.getName=function(){return e.getName()+"[]"};n.getComponentType=function(){return e};n.isValid=function(t){if(t===null){return true}if(Array.isArray(t)){for(var n=0;n<t.length;n++){if(!e.isValid(t[n])){return false}}return true}return false};n.parseValue=function(t){var n=t.split(",");for(var r=0;r<n.length;r++){n[r]=e.parseValue(n[r])}return n};n.isArrayType=function(){return true};n.getBaseType=function(){return s};return n}const p=Object.create(null);function l(e,t){var n={},r;for(var a in t){var u=t[a];if(!r){r=u}if(typeof u!=="string"){throw new Error("Value "+u+" for enum type "+e+" is not a string")}if(!n.hasOwnProperty(u)||a==u){n[u]=a}}var s=Object.create(i.prototype);s.getName=function(){return e};s.isValid=function(e){return typeof e==="string"&&n.hasOwnProperty(e)};s.parseValue=function(e){return t[e]};s.getDefaultValue=function(){return r};s.getBaseType=function(){return o.string};s.isEnumType=function(){return true};s.getEnumValues=function(){return t};return s}i.getType=function(a){t(a&&typeof a==="string","sTypeName must be a non-empty string");var u=o[a];if(!(u instanceof i)){if(a.indexOf("[]",a.length-2)>0){var s=a.slice(0,-2),y=this.getType(s);u=y&&f(y);if(u){o[a]=u}}else if(a!=="array"){u=p[a];if(u==null){u=e.get(a);if(u!=null){n.error(`The type '${a}' was accessed via globals. Defining enums via globals is deprecated. Please require the module 'sap/ui/base/DataType' and call the static 'DataType.registerEnum' API.`)}}if(u instanceof i){o[a]=u}else if(r(u)){u=o[a]=l(a,u);delete p[a]}else if(u){n.warning("[FUTURE FATAL] '"+a+"' is not a valid data type. Falling back to type 'any'.");u=o.any}else{n.error("[FUTURE FATAL] data type '"+a+"' could not be found.");u=undefined}}}return u};i.createType=function(e,r,a){t(typeof e==="string"&&e,"DataType.createType: type name must be a non-empty string");t(a==null||a instanceof i||typeof a==="string"&&a,"DataType.createType: base type must be empty or a DataType or a non-empty string");if(/[\[\]]/.test(e)){n.error("[FUTURE FATAL] DataType.createType: array types ('something[]') must not be created with createType, "+"they're created on-the-fly by DataType.getType")}if(typeof a==="string"){a=i.getType(a)}a=a||o.any;if(a.isArrayType()||a.isEnumType()){n.error("[FUTURE FATAL] DataType.createType: base type must not be an array- or enum-type")}if(e==="array"||o[e]instanceof i){if(e==="array"||o[e].getBaseType()==null){throw new Error("DataType.createType: primitive or hidden type "+e+" can't be re-defined")}n.warning("[FUTURE FATAL] DataTypes.createType: type "+e+" is redefined. "+"This is an unsupported usage of DataType and might cause issues.")}var s=o[e]=u(e,r,a);return s};var y=new Set;i.registerInterfaceTypes=function(t){t.forEach(function(t){y.add(t);e.set(t,t)})};i.registerEnum=function(e,t){p[e]=t};i._isEnumCandidate=function(e){return!Object.keys(e).some(t=>{const n=typeof e[t];return n==="object"||n==="function"})};i.isInterfaceType=function(e){return y.has(e)};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/DesignTime", ["sap/base/config"],e=>{"use strict";const t={isDesignModeEnabled(){return e.get({name:"sapUiXxDesignMode",type:e.Type.Boolean,external:true,freeze:true})},isControllerCodeDeactivationSuppressed(){return e.get({name:"sapUiXxSuppressDeactivationOfControllerCode",type:e.Type.Boolean,external:true,freeze:true})},isControllerCodeDeactivated(){return t.isDesignModeEnabled()&&!t.isControllerCodeDeactivationSuppressed()}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Event", ["./Object","sap/base/assert"],function(t,e){"use strict";var r=t.extend("sap.ui.base.Event",{constructor:function(e,r,n){t.apply(this);if(arguments.length>0){this.init(e,r,n)}}});r.prototype.init=function(r,n,s){e(typeof r==="string","Event.init: sId must be a string");e(t.isObjectA(n,"sap.ui.base.EventProvider"),"Event.init: oSource must be an EventProvider");this.sId=r;this.oSource=n;this.mParameters=s||{};this.bCancelBubble=false;this.bPreventDefault=false};r.prototype.reset=function(){this.sId="";this.oSource=null;this.mParameters=null;this.bCancelBubble=false;this.bPreventDefault=false};r.prototype.getId=function(){return this.sId};r.prototype.getSource=function(){return this.oSource};r.prototype.getParameters=function(){return this.mParameters};r.prototype.getParameter=function(t){e(typeof t==="string"&&t,"Event.getParameter: sName must be a non-empty string");return this.mParameters[t]};r.prototype.cancelBubble=function(){this.bCancelBubble=true};r.prototype.preventDefault=function(){this.bPreventDefault=true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/EventProvider", ["./Event","./Object","sap/base/assert","sap/base/Log"],function(t,e,n,i){"use strict";var r=e.extend("sap.ui.base.EventProvider",{constructor:function(){e.call(this);this.mEventRegistry={}}});var o="EventHandlerChange";r.M_EVENTS={EventHandlerChange:o};r.prototype.attachEvent=function(t,e,i,r){var a=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.attachEvent: sEventId must be a non-empty string");if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEvent: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.attachEvent: oListener must be empty or an object");r=r===this?undefined:r;var s=a[t];if(!Array.isArray(s)){s=a[t]=[]}s.push({oListener:r,fFunction:i,oData:e});if(a[o]){this.fireEvent(o,{EventId:t,type:"listenerAttached",listener:r,func:i,data:e})}return this};r.prototype.attachEventOnce=function(t,e,i,r){if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEventOnce: fnFunction must be a function");var o=function(){this.detachEvent(t,o);i.apply(r||this,arguments)};o.oOriginal={fFunction:i,oListener:r,oData:e};this.attachEvent(t,e,o,undefined);return this};r.prototype.detachEvent=function(t,e,i){var r=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.detachEvent: sEventId must be a non-empty string");n(typeof e==="function","EventProvider.detachEvent: fnFunction must be a function");n(!i||typeof i==="object","EventProvider.detachEvent: oListener must be empty or an object");var a=r[t];if(!Array.isArray(a)){return this}var s,f;i=i===this?undefined:i;for(var v=0,u=a.length;v<u;v++){if(a[v].fFunction===e&&a[v].oListener===i){s=a[v];a.splice(v,1);break}}if(!s){for(var v=0,u=a.length;v<u;v++){f=a[v].fFunction.oOriginal;if(f&&f.fFunction===e&&f.oListener===i){s=f;a.splice(v,1);break}}}if(a.length==0){delete r[t]}if(s&&r[o]){this.fireEvent(o,{EventId:t,type:"listenerDetached",listener:s.oListener,func:s.fFunction,data:s.oData})}return this};r.prototype.fireEvent=function(e,n,r,o){if(typeof n==="boolean"){o=r;r=n}var a=this,s=false,f,v,u,c,h;do{f=a.mEventRegistry[e];if(Array.isArray(f)){f=f.slice();v=new t(e,this,n);for(u=0,c=f.length;u<c;u++){h=f[u];const t=h.fFunction.call(h.oListener||a,v,h.oData);if(typeof t?.then==="function"){t.catch?.(t=>{i.error(`EventProvider.fireEvent: Event Listener for event '${e}' failed during execution.`,t)})}}o=o&&!v.bCancelBubble}a=a.getEventingParent()}while(o&&a);if(v){s=v.bPreventDefault}return r?!s:this};r.prototype.hasListeners=function(t){return!!this.mEventRegistry[t]};r.getEventList=function(t){return t.mEventRegistry};r.hasListener=function(t,e,i,r){n(typeof e==="string"&&e,"EventProvider.hasListener: sEventId must be a non-empty string");n(typeof i==="function","EventProvider.hasListener: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.hasListener: oListener must be empty or an object");var o=t&&t.mEventRegistry[e];if(o){for(var a=0,s=o.length;a<s;a++){if(o[a].fFunction===i&&o[a].oListener===r){return true}}}return false};r.prototype.getEventingParent=function(){return null};r.prototype.toString=function(){if(this.getMetadata){return"EventProvider "+this.getMetadata().getName()}else{return"EventProvider"}};r.prototype.destroy=function(){this.mEventRegistry={};e.prototype.destroy.apply(this,arguments)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Metadata", ["sap/base/util/ObjectPath","sap/base/assert","sap/base/Log","sap/base/util/array/uniqueSort"],function(t,e,a,s){"use strict";function r(t){return typeof t==="function"}var n=function(a,s){e(typeof a==="string"&&a,"Metadata: sClassName must be a non-empty string");e(typeof s==="object","Metadata: oClassInfo must be empty or an object");if(!s||typeof s.metadata!=="object"){s={metadata:s||{},constructor:t.get(a)};s.metadata.__version=1}s.metadata.__version=s.metadata.__version||2;if(!r(s.constructor)){throw Error("constructor for class "+a+" must have been declared before creating metadata for it")}this._sClassName=a;this._oClass=s.constructor;this.extend(s)};n.prototype.extend=function(t){this.applySettings(t);this.afterApplySettings()};n.prototype.applySettings=function(s){var o=this,i=s.metadata,p;if(i.baseType){var c;if(r(i.baseType)){c=i.baseType;if(!r(c.getMetadata)){throw new TypeError("baseType must be a UI5 class with a static getMetadata function")}}else{c=t.get(i.baseType);if(!r(c)){a.fatal("base class '"+i.baseType+"' does not exist")}}if(c.getMetadata){this._oParent=c.getMetadata();e(c===c.getMetadata().getClass(),"Metadata: oParentClass must match the class in the parent metadata")}else{this._oParent=new n(i.baseType,{})}}else{this._oParent=undefined}this._bAbstract=!!i["abstract"];this._bFinal=!!i["final"];this._sStereotype=i.stereotype||(this._oParent?this._oParent._sStereotype:"object");this._bDeprecated=!!i["deprecated"];this._aInterfaces=i.interfaces||[];this._aPublicMethods=i.publicMethods||[];this._bInterfacesUnique=false;p=this._oClass.prototype;for(var u in s){if(u!=="metadata"&&u!=="constructor"){p[u]=s[u];if(!u.match(/^_|^on|^init$|^exit$/)){o._aPublicMethods.push(u)}}}};n.prototype.afterApplySettings=function(){if(this._oParent){this._aAllPublicMethods=this._oParent._aAllPublicMethods.concat(this._aPublicMethods);this._bInterfacesUnique=false}else{this._aAllPublicMethods=this._aPublicMethods}};n.prototype.getStereotype=function(){return this._sStereotype};n.prototype.getName=function(){return this._sClassName};n.prototype.getClass=function(){return this._oClass};n.prototype.getParent=function(){return this._oParent};n.prototype._dedupInterfaces=function(){if(!this._bInterfacesUnique){s(this._aInterfaces);s(this._aPublicMethods);s(this._aAllPublicMethods);this._bInterfacesUnique=true}};n.prototype.getPublicMethods=function(){this._dedupInterfaces();return this._aPublicMethods};n.prototype.getAllPublicMethods=function(){this._dedupInterfaces();return this._aAllPublicMethods};n.prototype.getInterfaces=function(){this._dedupInterfaces();return this._aInterfaces};n.prototype.isInstanceOf=function(t){if(this._oParent){if(this._oParent.isInstanceOf(t)){return true}}var e=this._aInterfaces;for(var a=0,s=e.length;a<s;a++){if(e[a]===t){return true}}return false};Object.defineProperty(n.prototype,"_mImplementedTypes",{get:function(){if(this===n.prototype){throw new Error("sap.ui.base.Metadata: The '_mImplementedTypes' property must not be accessed on the prototype")}var t=Object.create(this._oParent?this._oParent._mImplementedTypes:null);t[this._sClassName]=true;var e=this._aInterfaces,a=e.length;while(a-- >0){if(!t[e[a]]){t[e[a]]=true}}Object.defineProperty(this,"_mImplementedTypes",{value:Object.freeze(t),writable:false,configurable:false});return t},configurable:true});n.prototype.isA=function(t){var e=this._mImplementedTypes;if(Array.isArray(t)){for(var a=0;a<t.length;a++){if(t[a]in e){return true}}return false}return t in e};n.prototype.isAbstract=function(){return this._bAbstract};n.prototype.isFinal=function(){return this._bFinal};n.prototype.isDeprecated=function(){return this._bDeprecated};n.prototype.addPublicMethods=function(t){var e=t instanceof Array?t:arguments;Array.prototype.push.apply(this._aPublicMethods,e);Array.prototype.push.apply(this._aAllPublicMethods,e);this._bInterfacesUnique=false};n.createClass=function(s,o,i,p){if(typeof s==="string"){p=i;i=o;o=s;s=null}e(!s||r(s));e(typeof o==="string"&&!!o);e(!i||typeof i==="object");e(!p||r(p));p=p||n;if(r(p.preprocessClassInfo)){i=p.preprocessClassInfo(i)}i=i||{};i.metadata=i.metadata||{};if(!i.hasOwnProperty("constructor")){i.constructor=undefined}var c=i.constructor;e(!c||r(c));if(s){if(!c){if(i.metadata.deprecated){c=function(){a.warning("Usage of deprecated class: "+o);s.apply(this,arguments)}}else{c=function(){s.apply(this,arguments)}}}c.prototype=Object.create(s.prototype);c.prototype.constructor=c;i.metadata.baseType=s}else{c=c||function(){};delete i.metadata.baseType}i.constructor=c;t.set(o,c);var u=new p(o,i);c.getMetadata=c.prototype.getMetadata=function(){return u};if(!c.getMetadata().isFinal()){c.extend=function(t,e,a){return n.createClass(c,t,e,a||p)}}return c};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Object", ["./Metadata","sap/base/Log"],function(t,e){"use strict";var n=t.createClass("sap.ui.base.Object",{constructor:function(){if(!(this instanceof n)){throw Error('Cannot instantiate object: "new" is missing!')}}});n.prototype.destroy=function(){};n.prototype.getInterface=function(){var t=new n._Interface(this,this.getMetadata().getAllPublicMethods());this.getInterface=function(){return t};return t};n.defineClass=function(n,r,a){var i=new(a||t)(n,r);var s=i.getClass();s.getMetadata=s.prototype.getMetadata=function(){return i};if(!i.isFinal()){s.extend=function(e,n,r){return t.createClass(s,e,n,r||a)}}e.debug("defined class '"+n+"'"+(i.getParent()?" as subclass of "+i.getParent().getName():""));return i};n.prototype.isA=function(t){return this.getMetadata().isA(t)};n.isA=function(t,e){return t instanceof n&&t.isA(e)};n.isObjectA=function(t,e){return t instanceof n&&t.isA(e)};n._Interface=function(t,e,r){if(!t){return t}function a(t,e){return function(){var a=t[e].apply(t,arguments);if(r){return this}else{return a instanceof n?a.getInterface():a}}}if(!e){return{}}var i;for(var s=0,o=e.length;s<o;s++){i=e[s];if(!t[i]||typeof t[i]==="function"){this[i]=a(t,i)}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/AnimationMode", [],function(){"use strict";var i={full:"full",basic:"basic",minimal:"minimal",none:"none"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Configuration", ["sap/base/assert","sap/base/config","sap/base/Event","sap/base/Log","sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/base/util/Version","sap/ui/base/DesignTime","sap/ui/base/Object","sap/ui/core/AnimationMode","sap/ui/core/ControlBehavior","sap/ui/core/getCompatibilityVersion","sap/ui/core/Locale","sap/ui/core/Supportability","sap/ui/core/Theming","sap/ui/security/Security"],function(e,t,n,a,i,r,o,s,u,g,l,c,p,m,f,d){"use strict";var y=new o("1.120.22");var C;var b;var h;function A(){h=h||{__count:0};h.__count++;return h}function T(){if(h&&--h.__count===0){var e=h;delete h.__count;h=undefined;b?.fireLocalizationChanged(e)}}var S=u.extend("sap.ui.core.Configuration",{constructor:function(){u.call(this);a.error("Configuration is designed as a singleton and should not be created manually! "+"Please require 'sap/ui/core/Configuration' instead and use the module export directly without using 'new'.");return S}});Object.assign(S,{getVersion:function(){return y},getCompatibilityVersion:c,getTheme:f.getTheme,setTheme:function(e){f.setTheme(e);return this},getLanguage:r.getLanguage,setLanguage:function(){r.setLanguage.apply(r,arguments);return S},getLanguageTag:function(){return r.getLanguageTag().toString()},getSAPLogonLanguage:r.getSAPLogonLanguage,getTimezone:r.getTimezone,setTimezone:function(){r.setTimezone.apply(r,arguments);return S},getCalendarType:i.getCalendarType,getCalendarWeekNumbering:i.getCalendarWeekNumbering,getRTL:r.getRTL,setRTL:function(){r.setRTL.apply(r,arguments);return S},getLocale:function(){var e=r.getLanguageTag();return p._getCoreLocale(e)},setCalendarType:function(e){i.setCalendarType.apply(i,arguments);return this},setCalendarWeekNumbering:function(e){i.setCalendarWeekNumbering.apply(i,arguments);return this},getFormatLocale:function(){return i.getLanguageTag().toString()},setFormatLocale:function(e){i.setLanguageTag.apply(i,arguments);return this},getLanguagesDeliveredWithCore:r.getLanguagesDeliveredWithCore,getSupportedLanguages:r.getSupportedLanguages,getAccessibility:l.isAccessibilityEnabled,getAutoAriaBodyRole:function(){return t.get({name:"sapUiAutoAriaBodyRole",type:t.Type.Boolean})},getAnimation:function(){var e=S.getAnimationMode();return e!==S.AnimationMode.minimal&&e!==S.AnimationMode.none},getAnimationMode:l.getAnimationMode,setAnimationMode:l.setAnimationMode,getFiori2Adaptation:function(){var e=t.get({name:"sapUiXxFiori2Adaptation",type:t.Type.StringArray,external:true}),n;if(e.length===0||e.length===1&&e[0]==="false"){n=false}else if(e.length===1&&e[0]==="true"){n=true}return n===undefined?e:n},getDebug:m.isDebugModeEnabled,getInspect:m.isControlInspectorEnabled,getOriginInfo:m.collectOriginInfo,getNoDuplicateIds:function(){return t.get({name:"sapUiNoDuplicateIds",type:t.Type.Boolean,defaultValue:true,external:true})},getUIDPrefix:function(){var e=sap.ui.require("sap/ui/base/ManagedObjectMetadata");return e.getUIDPrefix()},getDesignMode:s.isDesignModeEnabled,getSuppressDeactivationOfControllerCode:s.isControllerCodeDeactivationSuppressed,getControllerCodeDeactivated:s.isControllerCodeDeactivated,getApplication:function(){return t.get({name:"sapUiApplication",type:t.Type.String,external:true})},getRootComponent:function(){return t.get({name:"sapUiRootComponent",type:t.Type.String})},getAppCacheBuster:function(){return t.get({name:"sapUiAppCacheBuster",type:t.Type.StringArray,external:true,freeze:true})},getAppCacheBusterMode:function(){return t.get({name:"sapUiXxAppCacheBusterMode",type:t.Type.String,defaultValue:"sync",external:true,freeze:true})},getDisableCustomizing:function(){return t.get({name:"sapUiXxDisableCustomizing",type:t.Type.Boolean})},getManifestFirst:function(){return t.get({name:"sapUiManifestFirst",type:t.Type.Boolean,external:true})},getFlexibilityServices:function(){var e=sap.ui.require("sap/ui/fl/initial/_internal/FlexConfiguration");var n;if(e){n=e.getFlexibilityServices()}else{const e=[{url:"/sap/bc/lrep",connector:"LrepConnector"}];n=t.get({name:"sapUiFlexibilityServices",type:t=>{if(t&&typeof t==="string"){if(t[0]==="/"){e[0].url=t;t=e}else{t=JSON.parse(t)}}return t||[]},defaultValue:e,external:true})}return n},getFormatSettings:function(){return C},getFrameOptions:d.getFrameOptions,getWhitelistService:d.getAllowlistService,getAllowlistService:d.getAllowlistService,getFileShareSupport:function(){return t.get({name:"sapUiFileShareSupport",type:t.Type.String,defaultValue:undefined})},getStatistics:S.getStatisticsEnabled,getStatisticsEnabled:m.isStatisticsEnabled,getNoNativeScroll:function(){return false},getActiveTerminologies:r.getActiveTerminologies,getSecurityTokenHandlers:d.getSecurityTokenHandlers,setSecurityTokenHandlers:d.setSecurityTokenHandlers,applySettings:function(t){function n(e,t){var i,r;for(i in t){r="set"+i.slice(0,1).toUpperCase()+i.slice(1);if(i==="formatSettings"&&C){n(C,t[i])}else if(typeof e[r]==="function"){e[r](t[i])}else{a.warning("Configuration.applySettings: unknown setting '"+i+"' ignored")}}}e(typeof t==="object","mSettings must be an object");A();n(S,t);T();return this},setCore:function(e){b=e}});S.AnimationMode=g;function L(e,t){if(!e){throw new Error(t)}}var D=u.extend("sap.ui.core.Configuration.FormatSettings",{constructor:function(){u.call(this);this.mSettings={}},getFormatLocale:function(){var e=i.getLanguageTag();return p._getCoreLocale(e)},_set:i._set,getCustomUnits:i.getCustomUnits,setCustomUnits:function(){i.setCustomUnits.apply(i,arguments);return this},addCustomUnits:function(){i.addCustomUnits.apply(i,arguments);return this},setUnitMappings:function(){i.setUnitMappings.apply(i,arguments);return this},addUnitMappings:function(){i.addUnitMappings.apply(i,arguments);return this},getUnitMappings:i.getUnitMappings,getDatePattern:i.getDatePattern,setDatePattern:function(){i.setDatePattern.apply(i,arguments);return this},getTimePattern:i.getTimePattern,setTimePattern:function(){i.setTimePattern.apply(i,arguments);return this},getNumberSymbol:i.getNumberSymbol,setNumberSymbol:function(){i.setNumberSymbol.apply(i,arguments);return this},getCustomCurrencies:i.getCustomCurrencies,setCustomCurrencies:function(){i.setCustomCurrencies.apply(i,arguments);return this},addCustomCurrencies:function(){i.addCustomCurrencies.apply(i,arguments);return this},setFirstDayOfWeek:function(e){L(typeof e=="number"&&e>=0&&e<=6,"iValue must be an integer value between 0 and 6");i._set("weekData-firstDay",e);return this},_setDayPeriods:i._setDayPeriods,getLegacyDateFormat:i.getABAPDateFormat,setLegacyDateFormat:function(){i.setABAPDateFormat.apply(i,arguments);return this},getLegacyTimeFormat:i.getABAPTimeFormat,setLegacyTimeFormat:function(){i.setABAPTimeFormat.apply(i,arguments);return this},getLegacyNumberFormat:i.getABAPNumberFormat,setLegacyNumberFormat:function(){i.setABAPNumberFormat.apply(i,arguments);return this},setLegacyDateCalendarCustomizing:function(){i.setCustomIslamicCalendarData.apply(i,arguments);return this},getLegacyDateCalendarCustomizing:i.getCustomIslamicCalendarData,setTrailingCurrencyCode:function(){i.setTrailingCurrencyCode.apply(i,arguments);return this},getTrailingCurrencyCode:i.getTrailingCurrencyCode,getCustomLocaleData:i.getCustomLocaleData});C=new D(this);r.attachChange(function(e){if(!h&&b){b.fireLocalizationChanged(n.getParameters(e))}else if(h){Object.assign(h,n.getParameters(e))}});i.attachChange(function(e){const t=n.getParameters(e);Object.keys(e).forEach(e=>{if(["ABAPDateFormat","ABAPTimeFormat","ABAPNumberFormat"].includes(e)){t[e.replace("ABAP","legacy")]=t[e];delete t[e]}else if(e==="customIslamicCalendarData"){t["legacyDateCalendarCustomizing"]=t[e];delete t[e]}});if(!h&&b){b.fireLocalizationChanged(t)}else if(h){Object.assign(h,t)}});return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ControlBehavior", ["sap/base/config","sap/base/Eventing","sap/ui/core/AnimationMode"],(e,n,t)=>{"use strict";const a=e.getWritableInstance();const i=new n;const o={attachChange:e=>{i.attachEvent("change",e)},detachChange:e=>{i.detachEvent("change",e)},isAccessibilityEnabled:()=>a.get({name:"sapUiAccessibility",type:e.Type.Boolean,defaultValue:true,external:true}),getAnimationMode:()=>{let n=a.get({name:"sapUiAnimationMode",type:t,defaultValue:undefined,external:true});const i=a.get({name:"sapUiAnimation",type:e.Type.Boolean,defaultValue:true,external:true});if(n===undefined){if(i){n=t.full}else{n=t.minimal}}e._.checkEnum(t,n,"animationMode");return n},setAnimationMode:n=>{e._.checkEnum(t,n,"animationMode");const i=a.get({name:"sapUiAnimationMode",type:t,defaultValue:undefined,external:true});a.set("sapUiAnimationMode",n);if(i!=n){s({animationMode:n})}}};function s(e){i.fireEvent("change",e)}return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Lib", ["sap/base/assert","sap/base/config","sap/base/i18n/Localization","sap/base/i18n/ResourceBundle","sap/base/Log","sap/base/util/deepExtend","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/LoaderExtensions","sap/base/util/fetch","sap/base/util/mixedFetch","sap/base/util/ObjectPath","sap/base/util/Version","sap/base/util/array/uniqueSort","sap/ui/Global","sap/ui/VersionInfo","sap/ui/base/DataType","sap/ui/base/EventProvider","sap/ui/base/Object","sap/ui/base/SyncPromise","sap/ui/core/Configuration","sap/ui/core/_UrlResolver"],function(e,n,t,r,i,a,s,o,u,l,c,f,d,p,h,g,y,m,b,v,_,S){"use strict";var L={};var j={};var P=new Set(["sap.suite.ui.generic.template","sap.ui.comp","sap.ui.layout","sap.ui.unified"]);function T(e,n){return sap.ui.require.toUrl(e.replace(/\./g,"/")+n)}function w(e,n){u.registerResourcePath(e.replace(/\./g,"/"),n)}function E(e,n){var t=e.modules,r=function(e){return/^jquery\.sap\./.test(e)?e:e.replace(/\./g,"/")};if(d(e.version||"1.0").compareTo("2.0")<0){t={};for(var i in e.modules){t[r(i)+".js"]=e.modules[i]}}sap.ui.require.preload(t,e.name,n)}var O={};n.get({name:"sapUiXxLibraryPreloadFiles",type:n.Type.StringArray,external:true}).forEach(function(e){var n=String(e).trim().split(/\s*:\s*/),t=n[0],r=n[1];if(n.length===1){r=t;t=""}if(/^(?:none|js|json|both)$/.test(r)){O[t]=r}});var C=[];var A;function F(e){var n=sap.ui.require("sap/ui/core/theming/ThemeManager");if(!A){if(!n){A=new Promise(function(e,n){sap.ui.require(["sap/ui/core/theming/ThemeManager"],function(n){e(n)},n)})}else{A=Promise.resolve(n)}}if(n&&e){n.reset()}return A}var R=Symbol("sap.ui.core.Lib");var z={configurable:true,enumerable:true,writable:false};function B(e){z.value=e;return z}function U(e){if(e&&typeof e==="object"&&!Object.isFrozen(e)){Object.freeze(e);for(var n in e){if(Object.hasOwn(e,n)){U(e[n])}}}}function x(){var e=n.get({name:"sapUiPreloadLibCss",type:n.Type.StringArray,external:true});if(e.length>0){if(e[0].startsWith("!")){e[0]=e[0].slice(1)}if(e[0]==="*"){e.shift();Object.keys(L).forEach(function(n){if(!e.includes(n)){e.unshift(n)}})}}return e}var M=b.extend("sap.ui.core.Lib",{constructor:function(n){b.call(this);e(typeof n==="object","A settings object must be given to the constructor of sap/ui/base/Library");e(typeof n.name==="string"&&n.name,"The settings object that is given to the constructor of sap/ui/base/Library must contain a 'name' property which is a non-empty string");if(n._key!==R){throw new Error("The constructor of sap/ui/core/Lib is restricted to the internal usage. To get an instance of Library with name '"+n.name+"', use the static method 'get' from sap/ui/core/Lib instead.")}this.name=n.name;var t=["dependencies","types","interfaces","controls","elements"];t.forEach(function(e){Object.defineProperty(this,e,B([]))}.bind(this));Object.defineProperty(this,"_resourceBundles",{value:{},writable:true});Object.defineProperty(this,"_loadingStatus",{value:null,writable:true});Object.defineProperty(this,"_settingsEnhanced",{value:false,writable:true});Object.defineProperty(this,"_manifestFailed",{value:false,writable:true})},getInterface:function(){return this},isSettingsEnhanced:function(){return this._settingsEnhanced},enhanceSettings:function(e){if(this._settingsEnhanced){return this}this._settingsEnhanced=true;var n,t,r;for(n in e){t=e[n];r=undefined;if(t!==undefined){if(Array.isArray(this[n])){if(this[n].length===0){r=t}else{r=p(this[n].concat(t))}}else if(this[n]===undefined){r=t}else if(n!="name"){i.warning("[FUTURE FATAL] library info setting ignored: "+n+"="+t)}if(r!==undefined){Object.defineProperty(this,n,B(r))}}}return this},_getFileType:function(e){var n;var t=O[this.name]||O[""]||"both";if(e===true){n="json"}else if(e===false){n="js"}else{n=t}if(t!=="both"&&n!=="both"&&t!==n){n="none"}return n},preload:function(e){if(e&&(e.hasOwnProperty("async")||e.hasOwnProperty("sync"))){i.error("[FUTURE FATAL] The 'preload' function of class sap/ui/core/Lib only support preloading a library asynchronously. The given 'async' or 'sync' setting is ignored.")}if(e&&e.hasOwnProperty("json")){i.error("[FUTURE FATAL] The 'preload' function of class sap/ui/core/Lib only support preloading in JS Format. The given 'json' setting is ignored.")}return this._preload(["url","lazy"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{}))},_preload:function(e){e=e||{};var n=this._getFileType(e.json),t=this.name.replace(/\./g,"/"),r=!!sap.ui.loader._.getModuleState(t+"/library.js"),a=M.isDepCacheEnabled();if(n==="none"){return e.sync?this:Promise.resolve(this)}if(this._loadingStatus==null&&e.url){w(this.name,e.url)}this._loadingStatus=this._loadingStatus||{};if(this._loadingStatus.pending){if(e.sync){if(e.lazy){return this}else if(this._loadingStatus.async){i.warning("request to load "+this.name+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller")}else{i.warning("request to load "+this.name+" synchronously while sync loading is pending (cycle, ignored)");return this}}else if(this._loadingStatus.preloadFinished){return Promise.resolve(this)}}if(e.sync&&this._loadingStatus.pending===false||!e.sync&&this._loadingStatus.promise){return e.sync?this:this._loadingStatus.promise}if(e.lazy){i.debug("Lazy dependency to '"+this.name+"' encountered, loading library-preload-lazy.js");if(e.sync){try{sap.ui.requireSync(t+"/library-preload-lazy")}catch(e){i.error("failed to load '"+t+"/library-preload-lazy.js"+"' synchronously ("+(e&&e.message||e)+")")}return this}return sap.ui.loader._.loadJSResourceAsync(t+"/library-preload-lazy.js",true)}this._loadingStatus.pending=true;this._loadingStatus.async=!e.sync;var s;if(r){s=(e.sync?v:Promise).resolve()}else{s=n!=="json"?this._preloadJSFormat({fallbackToJSON:n!=="js",http2:a,sync:e.sync}):this._preloadJSONFormat({sync:e.sync})}this._loadingStatus.promise=s.then(function(n){n=n||this._getDependencies();this._loadingStatus.preloadFinished=true;var t=this.getManifest(),r;if(n&&n.length){if(!e.sync){var i=[],a=[];n.forEach(function(e){if(e.lazy){a.push(e)}else{i.push(e.name)}});i=g._getTransitiveDependencyForLibraries(i).map(function(e){return{name:e}});n=i.concat(a)}r=n.map(function(n){var t=M._get(n.name,true);return t._preload({sync:e.sync,lazy:n.lazy})})}else{r=[]}if(!e.sync&&t&&d(t._version).compareTo("1.9.0")>=0){r.push(this.loadResourceBundle())}var s=e.sync?v.all(r):Promise.all(r);return s.then(function(){this._loadingStatus.pending=false;return this}.bind(this))}.bind(this));return e.sync?this._loadingStatus.promise.unwrap():this._loadingStatus.promise},_preloadJSFormat:function(e){e=e||{};var n=this;var t=this.name.replace(/\./g,"/")+(e.http2?"/library-h2-preload":"/library-preload")+(e.sync?"":".js");var r;if(e.sync){r=v.resolve().then(function(){sap.ui.requireSync(t)})}else{r=sap.ui.loader._.loadJSResourceAsync(t)}return r.catch(function(r){if(e.fallbackToJSON){var a;if(e.sync){var s=r;while(s&&s.cause){s=s.cause}a=s&&s.name==="XHRLoadError"}else{a=true}if(a){i.error("failed to load '"+t+"' ("+(r&&r.message||r)+"), falling back to library-preload.json");return n._preloadJSONFormat({sync:e.sync})}}})},_preloadJSONFormat:function(e){e=e||{};var n=T(this.name,"/library-preload.json");l=c?c:l;return l(n,{headers:{Accept:l.ContentTypes.JSON}},e.sync).then(function(e){if(e.ok){return e.json().then(function(e){if(e){E(e,n);if(Array.isArray(e.dependencies)){return e.dependencies.map(function(e){return{name:e.replace(/\.library-preload$/,"")}})}else{return e.dependencies}}})}else{throw Error(e.statusText||e.status)}}).catch(function(e){i.error("failed to load '"+n+"': "+e.message)})},getManifest:function(e){if(!this.oManifest){var n=this.name.replace(/\./g,"/")+"/manifest.json";if(sap.ui.loader._.getModuleState(n)||e&&!this._manifestFailed){try{this.oManifest=u.loadResource(n,{dataType:"json",async:false,failOnError:!this.isSettingsEnhanced()});if(this._oManifest){U(this.oManifest)}else{this._manifestFailed=true}}catch(e){this._manifestFailed=true}}}return this.oManifest},_getDependencies:function(){var e=this.getManifest();var n=[];var t=e&&e["sap.ui5"]&&e["sap.ui5"].dependencies&&e["sap.ui5"].dependencies.libs;if(t){return Object.keys(t).reduce(function(e,n){if(!t[n].lazy){e.push({name:n})}else if(P.has(n)){e.push({name:n,lazy:true})}return e},n)}else{return n}},_getI18nSettings:function(){var e=this.getManifest(),n;if(e&&d(e._version).compareTo("1.9.0")>=0){n=e["sap.ui5"]&&e["sap.ui5"].library&&e["sap.ui5"].library.i18n}n=this._normalizeI18nSettings(n);return n},_normalizeI18nSettings:function(e){if(e==null||e===true){e={bundleUrl:"messagebundle.properties"}}else if(typeof e==="string"){e={bundleUrl:e}}else if(typeof e==="object"){e=a({},e)}return e},_includeTheme:function(e,n){var t=this.name,r=x().indexOf(t)!==-1;C.push({name:t,version:this.version,variant:e,preloadedCss:r});F().then(function(r){r.includeLibraryTheme(t,e,n)})},getResourceBundle:function(e){return this._loadResourceBundle(e,true)},loadResourceBundle:function(e){return this._loadResourceBundle(e)},_loadResourceBundle:function(n,i){var a=this,s=this.getManifest(i),o=!!s,u,l,c,f;e(n===undefined||typeof n==="string","sLocale must be a string or omitted");n=n||t.getLanguage();c=n+"/manifest-not-available";if(o){f=n;delete this._resourceBundles[c]}else{f=c}u=this._resourceBundles[f];if(!u||i&&u instanceof Promise){l=this._getI18nSettings();if(l){var d=T(this.name+"/",l.bundleUrl);j[d]=this;u=r.create({bundleUrl:d,supportedLocales:l.supportedLocales,fallbackLocale:l.fallbackLocale,locale:n,async:!i,activeTerminologies:t.getActiveTerminologies()});if(u instanceof Promise){u=u.then(function(e){a._resourceBundles[f]=e;return e})}this._resourceBundles[f]=u}}return i?u:Promise.resolve(u)}});M.getAllInstancesRequiringCss=function(){return C.slice()};M.isLoaded=function(e){return L[e]?true:false};M._get=function(e,n){var t=L[e];if(!t&&n){L[e]=t=new M({name:e,_key:R})}return t};M._getByBundleUrl=function(e){if(e){if(j[e]){return j[e]}var n=sap.ui.loader._.guessResourceName(e);if(n){for(var t in L){if(!L[t].isSettingsEnhanced()){continue}var r=t.replace(/\./g,"/");var i=L[t];if(r!==""&&n.startsWith(r+"/")){var a=n.replace(r+"/","");var s=i._getI18nSettings();if(s){var o=T(r,"/"+s.bundleUrl);a=T(r,"/"+a);if(a===o){j[e]=i;return i}j[e]=false}}}}}};M.all=function(){return M._all(false)};M._all=function(e){var n={};Object.keys(L).forEach(function(t){if(e||L[t].isSettingsEnhanced()){n[t]=L[t]}});return n};const q=Symbol("isProxy");function k(e,n){const t=new WeakMap;t.set(n,`${e}.`);const r={set(e,n,a){if(o(a)&&!a[q]){const o=s(a);let u=o;if(!o){if(y._isEnumCandidate(a)){e[n]=a;const r=t.get(e);y.registerEnum(`${r}${n}`,a);i.debug(`[Library API-Version 2] If you intend to use API-Version 2 in your library, make sure to call 'sap/ui/base/DataType.registerEnum' for ${r}${n}.`)}else{const t=n.charAt(0);if(t===t.toLowerCase()&&t!==t.toUpperCase()){u=true}else{e[n]=a}}}if(u){e[n]=new Proxy(a,r);const i=`${t.get(e)}${n}.`;t.set(a,i)}}else{e[n]=a}return true},get(e,n){if(n===q){return true}return e[n]}};return r}M.init=function(n){if(!sap.ui.require("sap/ui/core/Core")){throw new Error("Library "+n.name+": Library must not be used before the core is ready!")}e(typeof n==="object","mSettings given to 'sap/ui/core/Lib.init' must be an object");e(typeof n.name==="string"&&n.name,"mSettings given to 'sap/ui/core/Lib.init' must have the 'name' property set");var t="sap/ui/core/Lib.init";i.debug("Analyzing Library "+n.name,null,t);var r=M._get(n.name,true);r.enhanceSettings(n);var a=Object.create(null),s;a=f.create(n.name);const o=n.apiVersion??1;if(o<2){const e=k(n.name,a);a=new Proxy(a,e);f.set(n.name,a)}for(s=0;s<r.dependencies.length;s++){var u=r.dependencies[s];var l=M._get(u,true);i.debug("resolve Dependencies to "+u,null,t);if(!l.isSettingsEnhanced()){i.warning("Dependency from "+n.name+" to "+u+" has not been resolved by library itself",null,t);M._load({name:u},{sync:true})}}y.registerInterfaceTypes(r.interfaces);for(s=0;s<r.types.length;s++){if(!/^(any|boolean|float|int|string|object|void)$/.test(r.types[s])){const e=r.types[s];const n=r.name.replace(/\./g,"/")+"/library";sap.ui.loader._.declareModule(e.replace(/\./g,"/")+".js",`Deprecation: Importing the type '${e}' as a pseudo module is deprecated. Please import the type from the module '${n}'. You can then reference this type via the library's module export. `+`For more information, see documentation under 'Best Practices for Loading Modules'.`);var c=e.substring(0,e.lastIndexOf("."));if(f.get(c)===undefined){f.create(c)}}}(()=>{var e=r.controls.concat(r.elements);for(s=0;s<e.length;s++){sap.ui.lazyRequire(e[s],"new extend getMetadata")}})();if(!r.noLibraryCSS){var d={name:r.name,version:r.version,preloadedCss:x().indexOf(r.name)!==-1};C.push(d);F(!d.preloadedCss).then(function(e){e._includeLibraryThemeAndEnsureThemeRoot(d)})}r.sName=r.name;r.aControls=r.controls;M.fireLibraryChanged({name:n.name,stereotype:"library",operation:"add",metadata:r});return a};function I(e){return e.map(function(e){return e.name.replace(/\./g,"/")+"/library"})}function D(e){var n=I(e);return new Promise(function(t,r){sap.ui.require(n,function(){t(e)},r)})}M.load=function(e){if(typeof e==="string"){e={name:e}}else{e=["name","url"].reduce(function(n,t){if(e&&e.hasOwnProperty(t)){n[t]=e[t]}return n},{})}return M._load(e).then(function(e){return e[0]})};M._load=function(e,n){n=n||{};if(!Array.isArray(e)){e=[e]}var t={};var r=[];e.forEach(function(e){if(typeof e==="object"){if(e.hasOwnProperty("url")||e.hasOwnProperty("json")){t[e.name]=e}r.push(e.name)}else{r.push(e)}});var a=M.getPreloadMode()==="sync"||M.getPreloadMode()==="async",s=!n.preloadOnly;if(!n.sync){r=g._getTransitiveDependencyForLibraries(r)}var o=r.map(function(e){var n=M._get(e,true);if(n._loadingStatus==null&&t[e]&&t[e].url){w(e,t[e].url)}return n});if(n.sync){if(a){o.forEach(function(e){var n={sync:true};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}e._preload(n)})}if(s){I(o).forEach(function(e,n){if(o[n].isSettingsEnhanced()){return}sap.ui.requireSync(e);if(!o[n].isSettingsEnhanced()){i.warning("library "+o[n].name+" didn't initialize itself");M.init({name:o[n].name})}})}return o}const u=a?Promise.all(o.map(function(e){const n={};if(t[e.name]&&t[e.name].hasOwnProperty("json")){n.json=t[e.name].json}return e._preload(n)})):Promise.resolve(o);return s?u.then(D):u};M.getResourceBundleFor=function(e,n){var t=M._get(e,true);return t.getResourceBundle(n)};M._registerElement=function(e){var n=e.getName(),t=e.getLibraryName()||"",r=M._get(t),a=e.isA("sap.ui.core.Control")?"controls":"elements";if(!r){f.create(t);r=M._get(t,true)}if(r[a].indexOf(n)<0){r[a].push(n);i.debug("Class "+n+" registered for library "+t);M.fireLibraryChanged({name:n,stereotype:e.getStereotype(),operation:"add",metadata:e})}};var $=new m;M.attachLibraryChanged=function(e,n){$.attachEvent("LibraryChanged",e,n)};M.detachLibraryChanged=function(e,n){$.detachEvent("LibraryChanged",e,n)};M.fireLibraryChanged=function(e){$.fireEvent("LibraryChanged",e)};r._enrichBundleConfig=function(e){if(!e.terminologies||!e.enhanceWith){var n=M._getByBundleUrl(e.url);if(n){var r=n._getI18nSettings();if(r){var i=n.name.replace(/\./g,"/");i=i.endsWith("/")?i:i+"/";i=sap.ui.require.toUrl(i);S._processResourceConfiguration(r,{alreadyResolvedOnRoot:true,relativeTo:i});e.fallbackLocale=e.fallbackLocale||r.fallbackLocale;e.supportedLocales=e.supportedLocales||r.supportedLocales;e.terminologies=e.terminologies||r.terminologies;e.enhanceWith=e.enhanceWith||r.enhanceWith;e.activeTerminologies=e.activeTerminologies||t.getActiveTerminologies()}}}return e};M.getVersionedLibCss=function(){return n.get({name:"sapUiVersionedLibCss",type:n.Type.Boolean,external:true})};M.isDepCacheEnabled=function(){return n.get({name:"sapUiXxDepCache",type:n.Type.Boolean,external:true})};M.getPreloadMode=function(){if(_.getDebug()===true){return""}let e=n.get({name:"sapUiPreload",type:n.Type.String,defaultValue:"auto",external:true});if(e==="auto"){if(window["sap-ui-optimized"]){e=sap.ui.loader.config().async?"async":"sync"}else{e=""}}return e};return M});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Locale", ["sap/base/assert","sap/ui/base/Object","sap/base/i18n/Localization","sap/base/i18n/LanguageTag"],function(t,n,e,a){"use strict";var i=Object.create(null);var s=n.extend("sap.ui.core.Locale",{constructor:function(t){n.apply(this);if(t instanceof a){this.oLanguageTag=t;this.sLocaleId=this.oLanguageTag.toString()}else{this.oLanguageTag=new a(t);this.sLocaleId=t}Object.assign(this,this.oLanguageTag);this.sLanguage=this.language},getLanguage:function(){return this.language},getScript:function(){return this.script},getRegion:function(){return this.region},getVariant:function(){return this.variant},getVariantSubtags:function(){return this.variantSubtags},getExtension:function(){return this.extension},getExtensionSubtags:function(){return this.extensionSubtags},getPrivateUse:function(){return this.privateUse},getPrivateUseSubtags:function(){return this.privateUseSubtags},hasPrivateUseSubtag:function(n){t(n&&n.match(/^[0-9A-Z]{1,8}$/i),"subtag must be a valid BCP47 private use tag");return this.privateUseSubtags.indexOf(n)>=0},toString:function(){return this.oLanguageTag.toString()},getSAPLogonLanguage:function(){return e._getSAPLogonLanguage(this)}});s._getCoreLocale=function(t){if(t instanceof a){t=i[t.toString()]||new s(t);i[t.toString()]=t}return t};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Supportability", ["sap/base/config"],e=>{"use strict";const t={isDebugModeEnabled(){let t=window["sap-ui-debug"]===true||e.get({name:"sapUiDebug",type:e.Type.Boolean,external:true});try{t=t||/^(?:true|x|X)$/.test(window.localStorage.getItem("sap-ui-debug"))}catch(e){}return t},isControlInspectorEnabled(){return e.get({name:"sapUiInspect",type:e.Type.Boolean,external:true})},isStatisticsEnabled(){var t=e.get({name:"sapUiStatistics",type:e.Type.Boolean,defaultValue:e.get({name:"sapStatistics",type:e.Type.Boolean,external:true}),external:true});try{t=t||window.localStorage.getItem("sap-ui-statistics")=="X"}catch(e){}return t},getSupportSettings(){return e.get({name:"sapUiSupport",type:e.Type.StringArray,defaultValue:null,external:true})},getTestRecorderSettings(){return e.get({name:"sapUiTestRecorder",type:e.Type.StringArray,defaultValue:null,external:true})},collectOriginInfo(){return e.get({name:"sapUiOriginInfo",type:e.Type.Boolean,external:true})}};return t});
/*!
 * copyright
 */
sap.ui.predefine("sap/ui/core/Theming", ["sap/base/assert","sap/base/config","sap/base/Event","sap/base/Eventing","sap/base/Log","sap/base/i18n/Localization","sap/base/util/deepEqual","sap/ui/core/theming/ThemeHelper"],function(e,t,n,a,i,o,s,h){"use strict";const l=t.getWritableInstance();const c=new a;let r;let g;const m={getTheme:()=>{let e=l.get({name:"sapTheme",type:l.Type.String,defaultValue:l.get({name:"sapUiTheme",type:l.Type.String,external:true}),external:true});if(e===""){const t=h.getDefaultThemeInfo();e=`${t.DEFAULT_THEME}${t.DARK_MODE?"_dark":""}`}const t=e.indexOf("@");if(t>=0){const n=T(e.slice(t+1));e=t>0?e.slice(0,t):e;if(n!==m.getThemeRoot(e)){m.setThemeRoot(e,n)}}e=h.validateAndFallbackTheme(e,m.getThemeRoot(e));return e},setTheme:e=>{if(e){if(e.indexOf("@")!==-1){throw new TypeError("Providing a theme root as part of the theme parameter is not allowed.")}const t=!r;r??={};const n=m.getTheme();l.set("sapTheme",e);const a=m.getTheme();const i=n!==a;if(i){r.theme={new:a,old:n}}else{r=undefined}if(t){p(r)}if(!g&&i){f({theme:a})}}},getThemeRoot:(e,t)=>{const n=l.get({name:"sapUiThemeRoots",type:l.Type.MergedObject});let a;e??=m.getTheme();if(n[e]&&typeof n[e]==="string"){a=n[e]}else if(n[e]&&typeof n[e]==="object"){a=n[e][t]||n[e][""]}return a},setThemeRoot:(t,n,a,i)=>{e(typeof t==="string","sThemeName must be a string");e(typeof n==="string","sThemeBaseUrl must be a string");const o=!r;r??={};const h={name:"sapUiThemeRoots",type:l.Type.MergedObject};const c=l.get(Object.assign(h,{defaultValue:{}}));const g=l.get(Object.assign(h,{defaultValue:{}}));if(typeof a==="boolean"){i=a;a=undefined}g[t]??={};if(typeof g[t]==="string"){g[t]={"":g[t]};c[t]={"":c[t]}}if(a){for(let e=0;e<a.length;e++){const i=a[e];g[t][i]=n}}else{g[t][""]=n}if(!s(c,g)){l.set("sapUiThemeRoots",g);if(a){r.themeRoots={new:Object.assign({},g[t]),old:Object.assign({},c[t])}}else{r.themeRoots={new:n,old:c[t]?.[""]}}r.themeRoots.forceUpdate=i&&t===m.getTheme()}else{r=undefined}if(o){p()}},attachAppliedOnce:e=>{const t="applied";if(g){if(g.themeLoaded){e.call(null,new n(t,{theme:m.getTheme()}))}else{c.attachEventOnce(t,e)}}else{e.call(null,new n(t,{theme:m.getTheme()}))}},attachApplied:e=>{const t="applied";c.attachEvent(t,e);if(g){if(g.themeLoaded){e.call(null,new n(t,{theme:m.getTheme()}))}}else{e.call(null,new n(t,{theme:m.getTheme()}))}},detachApplied:e=>{c.detachEvent("applied",e)},attachChange:e=>{c.attachEvent("change",e)},detachChange:e=>{c.detachEvent("change",e)},attachThemeScopingChanged:e=>{c.attachEvent("themeScopingChanged",e)},detachThemeScopingChanged:e=>{c.detachEvent("themeScopingChanged",e)},fireThemeScopingChanged:e=>{c.fireEvent("themeScopingChanged",e)},notifyContentDensityChanged:()=>{f({theme:m.getTheme()})},registerThemeManager:e=>{g=e;g._attachThemeApplied(function(e){f(n.getParameters(e))});o.attachChange(function(e){var t=e.rtl;if(t!==undefined){g._updateThemeUrls(m.getTheme())}})}};function p(){if(r){c.fireEvent("change",r);r=undefined}}function f(e){c.fireEvent("applied",e)}function d(e,t){const n=l.get({name:"sapAllowedThemeOrigins",type:l.Type.String});return!!n?.split(",").some(n=>{try{n=t&&!n.startsWith("//")?"//"+n:n;return n==="*"||e===new URL(n.trim(),globalThis.location.href).origin}catch(e){i.error("[FUTURE FATAL] sapAllowedThemeOrigin provides invalid theme origin: "+n);return false}})}function T(e){const t=e.startsWith("//");let n,a;try{n=new URL(e,globalThis.location.href);n.search="";if(n.origin&&d(n.origin,t)){a=n.toString()}else{n=new URL(n.pathname,globalThis.location.href);a=n.toString()}if(t){a=a.replace(n.protocol,"")}a+=(a.endsWith("/")?"":"/")+"UI5/"}catch(e){}return a}return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/_UrlResolver", ["sap/ui/thirdparty/URI"],function(e){"use strict";var r={};r._processResourceConfiguration=function(e,a){a=a||{};var i=a.alreadyResolvedOnRoot||false;var n=e.bundleUrlRelativeTo||a.relativeTo;var o;if(n==="manifest"){o=a.manifestBaseURI}else if(n==="component"){o=a.baseURI}else{o=n||a.baseURI}Object.keys(e).forEach(function(s){if(s==="bundleUrl"&&!i){var t=e[s];var f=r._resolveUri(t,o);e[s]=f&&f.toString()}if(s==="terminologies"){var u=e[s];for(var l in u){r._processResourceConfiguration(u[l],{relativeTo:n,baseURI:a.baseURI,manifestBaseURI:a.manifestBaseURI})}}if(s==="enhanceWith"){var v=e[s]||[];for(var R=0;R<v.length;R++){r._processResourceConfiguration(v[R],{relativeTo:n,baseURI:a.baseURI,manifestBaseURI:a.manifestBaseURI})}}})};function a(r){if(r&&r instanceof e){return r}return new e(r)}r._resolveUri=function(e,i){return r._resolveUriRelativeTo(a(e),a(i))};r._resolveUriRelativeTo=function(r,a){if(r.is("absolute")||r.path()&&r.path()[0]==="/"){return r}var i=new e(document.baseURI).search("");a=a.absoluteTo(i);return r.absoluteTo(a).relativeTo(i)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/getCompatibilityVersion", ["sap/base/config","sap/base/util/Version","sap/base/strings/camelize"],(e,t,s)=>{"use strict";const a=t("1.14");const n="1.120.22";var i={"xx-test":"1.15",flexBoxPolyfill:"1.14",sapMeTabContainer:"1.14",sapMeProgessIndicator:"1.14",sapMGrowingList:"1.14",sapMListAsTable:"1.14",sapMDialogWithPadding:"1.14",sapCoreBindingSyntax:"1.24"};const o=o=>{const r="sapUiCompatVersion";const p=e.get({name:r,type:e.Type.String});function g(o){var g=!o?p||a.toString():e.get({name:s(r+"-"+o.toLowerCase()),type:e.Type.String})||p||i[o]||a.toString();g=t(g.toLowerCase()==="edge"?n:g);return t(g.getMajor(),g.getMinor())}return i.hasOwnProperty(o)?g(o):g()};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/theming/ThemeHelper", ["sap/base/Log"],function(e){"use strict";var r={};const t="sap_horizon";const a=window.matchMedia("(prefers-color-scheme: dark)").matches;const n=/^([a-zA-Z0-9_]*)(_(hcb|hcw|dark))$/g;const s=["sap_horizon","sap_horizon_dark","sap_horizon_hcb","sap_horizon_hcw","sap_fiori_3","sap_fiori_3_dark","sap_fiori_3_hcb","sap_fiori_3_hcw","sap_belize","sap_belize_plus","sap_belize_hcb","sap_belize_hcw","sap_bluecrystal","sap_hcb"];const i={};var l={};l.reset=function(){r={}};l.getMetadata=function(t){if(!t){return null}var a=t.replace("sap-ui-theme-","").replace(/\./g,"-");if(r[a]){return r[a]}var n=document.createElement("span");n.classList.add("sapThemeMetaData-UI5-"+a);document.documentElement.appendChild(n);var s=window.getComputedStyle(n).getPropertyValue("background-image");document.documentElement.removeChild(n);var i=/\(["']?data:text\/plain;utf-8,(.*?)['"]?\)/i.exec(s);if(!i||i.length<2){return null}var l=i[1];if(l.charAt(0)!=="{"&&l.charAt(l.length-1)!=="}"){try{l=decodeURI(l)}catch(e){}}l=l.replace(/\\"/g,'"');var c=l.replace(/%20/g," ");var o;try{o=JSON.parse(c);r[a]=o}catch(r){e.error("[FUTURE FATAL] Could not parse theme metadata for library "+a+".")}return o};l.checkAndRemoveStyle=function(r){var t=r.prefix||"",a=r.id;var n=function(r,t){var a=document.getElementById(r);try{var n=false,s=false,i=false,c=false;n=!a;s=!!(a&&(a.getAttribute("data-sap-ui-ready")==="true"||a.getAttribute("data-sap-ui-ready")==="false"));i=!!(a&&a.sheet&&a.sheet.href===a.href&&l.hasSheetCssRules(a.sheet));c=!!(a&&a.innerHTML&&a.innerHTML.length>0);var o=n||i||c||s;if(t){e.debug("ThemeHelper: "+r+": "+o+" (noLinkElement: "+n+", sheet: "+i+", innerHtml: "+c+", linkElementFinishedLoading: "+s+")")}return o}catch(a){if(t){e.error("[FUTURE FATAL] ThemeHelper: "+r+": Error during check styles '"+r+"'",a)}}return false};var s=n(t+a,true);if(s){var i=document.querySelectorAll("link[data-sap-ui-foucmarker='"+t+a+"']");if(i.length>0){for(var c=0,o=i.length;c<o;c++){i[c].remove()}e.debug("ThemeManager: Old stylesheets removed for library: "+a)}}return s};l.safeAccessSheetCssRules=function(e){try{return e.cssRules}catch(e){return null}};l.hasSheetCssRules=function(e){var r=l.safeAccessSheetCssRules(e);return!!r&&r.length>0};l.validateAndFallbackTheme=function(r,a){if(a==null&&i[r]){return i[r]}let l=r;if(a==null&&r.startsWith("sap_")&&s.indexOf(r)==-1){const a=n.exec(r)||[];const s=a[2];if(s){l=`${t}${s}`}else{l=t}i[r]=l;e.warning(`The configured theme '${r}' is not yet or no longer supported in this version. The valid fallback theme is '${l}'.`,"Theming")}return l};l.getDefaultThemeInfo=function(){return{DEFAULT_THEME:t,DARK_MODE:a}};return l});
/*!
 * copyright
 */
sap.ui.predefine("sap/ui/security/Security", ["sap/base/config"],function(e){"use strict";const t=e.getWritableInstance();const i=()=>{let e=true;let i=t.get({name:"sapUiAllowlistService",type:t.Type.String,defaultValue:t.get({name:"sapUiWhitelistService",type:t.Type.String,defaultValue:undefined})});if(!i){i=t.get({name:"sapAllowlistService",type:t.Type.String,defaultValue:t.get({name:"sapWhitelistService",type:t.Type.String})});e=false}return{allowlistService:i,globalProvider:e}};const r={getAllowlistService:()=>i().allowlistService,getFrameOptions(){var e=t.get({name:"sapUiFrameOptions",type:t.Type.String,defaultValue:"default"});if(e==="default"){const t=i();e=t.allowlistService&&!t.globalProvider?"trusted":"allow"}return e},getSecurityTokenHandlers(){return t.get({name:"sapUiSecurityTokenHandlers",type:t.Type.FunctionArray})},setSecurityTokenHandlers(e){e.forEach(function(e){if(typeof e!=="function"){throw new Error("Not a function: "+e)}});t.set("sapUiSecurityTokenHandlers",e.slice())}};return r});
sap.ui.require.preload({
	"sap/ui/thirdparty/URI.js":function(){
/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */
(function(e,t){"use strict";if(typeof module==="object"&&module.exports){module.exports=t(require("./punycode"),require("./IPv6"),require("./SecondLevelDomains"))}else if(typeof define==="function"&&define.amd){e.URI=t(e.punycode,e.IPv6,e.SecondLevelDomains,e);define("sap/ui/thirdparty/URI",[],function(){return e.URI})}else{e.URI=t(e.punycode,e.IPv6,e.SecondLevelDomains,e)}})(this,function(e,t,r,n){"use strict";var i=n&&n.URI;function s(e,t){var r=arguments.length>=1;var n=arguments.length>=2;if(!(this instanceof s)){if(r){if(n){return new s(e,t)}return new s(e)}return new s}if(e===undefined){if(r){throw new TypeError("undefined is not a valid argument for URI")}if(typeof location!=="undefined"){e=location.href+""}else{e=""}}if(e===null){if(r){throw new TypeError("null is not a valid argument for URI")}}this.href(e);if(t!==undefined){return this.absoluteTo(t)}return this}function a(e){return/^[0-9]+$/.test(e)}s.version="1.19.11";var o=s.prototype;var u=Object.prototype.hasOwnProperty;function h(e){return e.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function f(e){if(e===undefined){return"Undefined"}return String(Object.prototype.toString.call(e)).slice(8,-1)}function p(e){return f(e)==="Array"}function l(e,t){var r={};var n,i;if(f(t)==="RegExp"){r=null}else if(p(t)){for(n=0,i=t.length;n<i;n++){r[t[n]]=true}}else{r[t]=true}for(n=0,i=e.length;n<i;n++){var s=r&&r[e[n]]!==undefined||!r&&t.test(e[n]);if(s){e.splice(n,1);i--;n--}}return e}function c(e,t){var r,n;if(p(t)){for(r=0,n=t.length;r<n;r++){if(!c(e,t[r])){return false}}return true}var i=f(t);for(r=0,n=e.length;r<n;r++){if(i==="RegExp"){if(typeof e[r]==="string"&&e[r].match(t)){return true}}else if(e[r]===t){return true}}return false}function d(e,t){if(!p(e)||!p(t)){return false}if(e.length!==t.length){return false}e.sort();t.sort();for(var r=0,n=e.length;r<n;r++){if(e[r]!==t[r]){return false}}return true}function m(e){var t=/^\/+|\/+$/g;return e.replace(t,"")}s._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:s.preventInvalidHostname,duplicateQueryParameters:s.duplicateQueryParameters,escapeQuerySpace:s.escapeQuerySpace}};s.preventInvalidHostname=false;s.duplicateQueryParameters=false;s.escapeQuerySpace=true;s.protocol_expression=/^[a-z][a-z0-9.+-]*$/i;s.idn_expression=/[^a-z0-9\._-]/i;s.punycode_expression=/(xn--)/i;s.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;s.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;s.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/gi;s.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g};s.leading_whitespace_expression=/^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;s.ascii_tab_whitespace=/[\u0009\u000A\u000D]+/g;s.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"};s.hostProtocols=["http","https"];s.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/;s.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"};s.getDomAttribute=function(e){if(!e||!e.nodeName){return undefined}var t=e.nodeName.toLowerCase();if(t==="input"&&e.type!=="image"){return undefined}return s.domAttributes[t]};function g(e){return escape(e)}function _(e){return encodeURIComponent(e).replace(/[!'()*]/g,g).replace(/\*/g,"%2A")}s.encode=_;s.decode=decodeURIComponent;s.iso8859=function(){s.encode=escape;s.decode=unescape};s.unicode=function(){s.encode=_;s.decode=decodeURIComponent};s.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/gi,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/gi,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/gi,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}};s.encodeQuery=function(e,t){var r=s.encode(e+"");if(t===undefined){t=s.escapeQuerySpace}return t?r.replace(/%20/g,"+"):r};s.decodeQuery=function(e,t){e+="";if(t===undefined){t=s.escapeQuerySpace}try{return s.decode(t?e.replace(/\+/g,"%20"):e)}catch(t){return e}};var v={encode:"encode",decode:"decode"};var y;var b=function(e,t){return function(r){try{return s[t](r+"").replace(s.characters[e][t].expression,function(r){return s.characters[e][t].map[r]})}catch(e){return r}}};for(y in v){s[y+"PathSegment"]=b("pathname",v[y]);s[y+"UrnPathSegment"]=b("urnpath",v[y])}var w=function(e,t,r){return function(n){var i;if(!r){i=s[t]}else{i=function(e){return s[t](s[r](e))}}var a=(n+"").split(e);for(var o=0,u=a.length;o<u;o++){a[o]=i(a[o])}return a.join(e)}};s.decodePath=w("/","decodePathSegment");s.decodeUrnPath=w(":","decodeUrnPathSegment");s.recodePath=w("/","encodePathSegment","decode");s.recodeUrnPath=w(":","encodeUrnPathSegment","decode");s.encodeReserved=b("reserved","encode");s.parse=function(e,t){var r;if(!t){t={preventInvalidHostname:s.preventInvalidHostname}}e=e.replace(s.leading_whitespace_expression,"");e=e.replace(s.ascii_tab_whitespace,"");r=e.indexOf("#");if(r>-1){t.fragment=e.substring(r+1)||null;e=e.substring(0,r)}r=e.indexOf("?");if(r>-1){t.query=e.substring(r+1)||null;e=e.substring(0,r)}e=e.replace(/^(https?|ftp|wss?)?:+[/\\]*/i,"$1://");e=e.replace(/^[/\\]{2,}/i,"//");if(e.substring(0,2)==="//"){t.protocol=null;e=e.substring(2);e=s.parseAuthority(e,t)}else{r=e.indexOf(":");if(r>-1){t.protocol=e.substring(0,r)||null;if(t.protocol&&!t.protocol.match(s.protocol_expression)){t.protocol=undefined}else if(e.substring(r+1,r+3).replace(/\\/g,"/")==="//"){e=e.substring(r+3);e=s.parseAuthority(e,t)}else{e=e.substring(r+1);t.urn=true}}}t.path=e;return t};s.parseHost=function(e,t){if(!e){e=""}e=e.replace(/\\/g,"/");var r=e.indexOf("/");var n;var i;if(r===-1){r=e.length}if(e.charAt(0)==="["){n=e.indexOf("]");t.hostname=e.substring(1,n)||null;t.port=e.substring(n+2,r)||null;if(t.port==="/"){t.port=null}}else{var a=e.indexOf(":");var o=e.indexOf("/");var u=e.indexOf(":",a+1);if(u!==-1&&(o===-1||u<o)){t.hostname=e.substring(0,r)||null;t.port=null}else{i=e.substring(0,r).split(":");t.hostname=i[0]||null;t.port=i[1]||null}}if(t.hostname&&e.substring(r).charAt(0)!=="/"){r++;e="/"+e}if(t.preventInvalidHostname){s.ensureValidHostname(t.hostname,t.protocol)}if(t.port){s.ensureValidPort(t.port)}return e.substring(r)||"/"};s.parseAuthority=function(e,t){e=s.parseUserinfo(e,t);return s.parseHost(e,t)};s.parseUserinfo=function(e,t){var r=e;var n=e.indexOf("\\");if(n!==-1){e=e.replace(/\\/g,"/")}var i=e.indexOf("/");var a=e.lastIndexOf("@",i>-1?i:e.length-1);var o;if(a>-1&&(i===-1||a<i)){o=e.substring(0,a).split(":");t.username=o[0]?s.decode(o[0]):null;o.shift();t.password=o[0]?s.decode(o.join(":")):null;e=r.substring(a+1)}else{t.username=null;t.password=null}return e};s.parseQuery=function(e,t){if(!e){return{}}e=e.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"");if(!e){return{}}var r={};var n=e.split("&");var i=n.length;var a,o,h;for(var f=0;f<i;f++){a=n[f].split("=");o=s.decodeQuery(a.shift(),t);h=a.length?s.decodeQuery(a.join("="),t):null;if(o==="__proto__"){continue}else if(u.call(r,o)){if(typeof r[o]==="string"||r[o]===null){r[o]=[r[o]]}r[o].push(h)}else{r[o]=h}}return r};s.build=function(e){var t="";var r=false;if(e.protocol){t+=e.protocol+":"}if(!e.urn&&(t||e.hostname)){t+="//";r=true}t+=s.buildAuthority(e)||"";if(typeof e.path==="string"){if(e.path.charAt(0)!=="/"&&r){t+="/"}t+=e.path}if(typeof e.query==="string"&&e.query){t+="?"+e.query}if(typeof e.fragment==="string"&&e.fragment){t+="#"+e.fragment}return t};s.buildHost=function(e){var t="";if(!e.hostname){return""}else if(s.ip6_expression.test(e.hostname)){t+="["+e.hostname+"]"}else{t+=e.hostname}if(e.port){t+=":"+e.port}return t};s.buildAuthority=function(e){return s.buildUserinfo(e)+s.buildHost(e)};s.buildUserinfo=function(e){var t="";if(e.username){t+=s.encode(e.username)}if(e.password){t+=":"+s.encode(e.password)}if(t){t+="@"}return t};s.buildQuery=function(e,t,r){var n="";var i,a,o,h;for(a in e){if(a==="__proto__"){continue}else if(u.call(e,a)){if(p(e[a])){i={};for(o=0,h=e[a].length;o<h;o++){if(e[a][o]!==undefined&&i[e[a][o]+""]===undefined){n+="&"+s.buildQueryParameter(a,e[a][o],r);if(t!==true){i[e[a][o]+""]=true}}}}else if(e[a]!==undefined){n+="&"+s.buildQueryParameter(a,e[a],r)}}}return n.substring(1)};s.buildQueryParameter=function(e,t,r){return s.encodeQuery(e,r)+(t!==null?"="+s.encodeQuery(t,r):"")};s.addQuery=function(e,t,r){if(typeof t==="object"){for(var n in t){if(u.call(t,n)){s.addQuery(e,n,t[n])}}}else if(typeof t==="string"){if(e[t]===undefined){e[t]=r;return}else if(typeof e[t]==="string"){e[t]=[e[t]]}if(!p(r)){r=[r]}e[t]=(e[t]||[]).concat(r)}else{throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")}};s.setQuery=function(e,t,r){if(typeof t==="object"){for(var n in t){if(u.call(t,n)){s.setQuery(e,n,t[n])}}}else if(typeof t==="string"){e[t]=r===undefined?null:r}else{throw new TypeError("URI.setQuery() accepts an object, string as the name parameter")}};s.removeQuery=function(e,t,r){var n,i,a;if(p(t)){for(n=0,i=t.length;n<i;n++){e[t[n]]=undefined}}else if(f(t)==="RegExp"){for(a in e){if(t.test(a)){e[a]=undefined}}}else if(typeof t==="object"){for(a in t){if(u.call(t,a)){s.removeQuery(e,a,t[a])}}}else if(typeof t==="string"){if(r!==undefined){if(f(r)==="RegExp"){if(!p(e[t])&&r.test(e[t])){e[t]=undefined}else{e[t]=l(e[t],r)}}else if(e[t]===String(r)&&(!p(r)||r.length===1)){e[t]=undefined}else if(p(e[t])){e[t]=l(e[t],r)}}else{e[t]=undefined}}else{throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter")}};s.hasQuery=function(e,t,r,n){switch(f(t)){case"String":break;case"RegExp":for(var i in e){if(u.call(e,i)){if(t.test(i)&&(r===undefined||s.hasQuery(e,i,r))){return true}}}return false;case"Object":for(var a in t){if(u.call(t,a)){if(!s.hasQuery(e,a,t[a])){return false}}}return true;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(f(r)){case"Undefined":return t in e;case"Boolean":var o=Boolean(p(e[t])?e[t].length:e[t]);return r===o;case"Function":return!!r(e[t],t,e);case"Array":if(!p(e[t])){return false}var h=n?c:d;return h(e[t],r);case"RegExp":if(!p(e[t])){return Boolean(e[t]&&e[t].match(r))}if(!n){return false}return c(e[t],r);case"Number":r=String(r);case"String":if(!p(e[t])){return e[t]===r}if(!n){return false}return c(e[t],r);default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}};s.joinPaths=function(){var e=[];var t=[];var r=0;for(var n=0;n<arguments.length;n++){var i=new s(arguments[n]);e.push(i);var a=i.segment();for(var o=0;o<a.length;o++){if(typeof a[o]==="string"){t.push(a[o])}if(a[o]){r++}}}if(!t.length||!r){return new s("")}var u=new s("").segment(t);if(e[0].path()===""||e[0].path().slice(0,1)==="/"){u.path("/"+u.path())}return u.normalize()};s.commonPath=function(e,t){var r=Math.min(e.length,t.length);var n;for(n=0;n<r;n++){if(e.charAt(n)!==t.charAt(n)){n--;break}}if(n<1){return e.charAt(0)===t.charAt(0)&&e.charAt(0)==="/"?"/":""}if(e.charAt(n)!=="/"||t.charAt(n)!=="/"){n=e.substring(0,n).lastIndexOf("/")}return e.substring(0,n+1)};s.withinString=function(e,t,r){r||(r={});var n=r.start||s.findUri.start;var i=r.end||s.findUri.end;var a=r.trim||s.findUri.trim;var o=r.parens||s.findUri.parens;var u=/[a-z0-9-]=["']?$/i;n.lastIndex=0;while(true){var h=n.exec(e);if(!h){break}var f=h.index;if(r.ignoreHtml){var p=e.slice(Math.max(f-3,0),f);if(p&&u.test(p)){continue}}var l=f+e.slice(f).search(i);var c=e.slice(f,l);var d=-1;while(true){var m=o.exec(c);if(!m){break}var g=m.index+m[0].length;d=Math.max(d,g)}if(d>-1){c=c.slice(0,d)+c.slice(d).replace(a,"")}else{c=c.replace(a,"")}if(c.length<=h[0].length){continue}if(r.ignore&&r.ignore.test(c)){continue}l=f+c.length;var _=t(c,f,l,e);if(_===undefined){n.lastIndex=l;continue}_=String(_);e=e.slice(0,f)+_+e.slice(l);n.lastIndex=f+_.length}n.lastIndex=0;return e};s.ensureValidHostname=function(t,r){var n=!!t;var i=!!r;var a=false;if(i){a=c(s.hostProtocols,r)}if(a&&!n){throw new TypeError("Hostname cannot be empty, if protocol is "+r)}else if(t&&t.match(s.invalid_hostname_characters)){if(!e){throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available')}if(e.toASCII(t).match(s.invalid_hostname_characters)){throw new TypeError('Hostname "'+t+'" contains characters other than [A-Z0-9.-:_]')}}};s.ensureValidPort=function(e){if(!e){return}var t=Number(e);if(a(t)&&t>0&&t<65536){return}throw new TypeError('Port "'+e+'" is not a valid port')};s.noConflict=function(e){if(e){var t={URI:this.noConflict()};if(n.URITemplate&&typeof n.URITemplate.noConflict==="function"){t.URITemplate=n.URITemplate.noConflict()}if(n.IPv6&&typeof n.IPv6.noConflict==="function"){t.IPv6=n.IPv6.noConflict()}if(n.SecondLevelDomains&&typeof n.SecondLevelDomains.noConflict==="function"){t.SecondLevelDomains=n.SecondLevelDomains.noConflict()}return t}else if(n.URI===this){n.URI=i}return this};o.build=function(e){if(e===true){this._deferred_build=true}else if(e===undefined||this._deferred_build){this._string=s.build(this._parts);this._deferred_build=false}return this};o.clone=function(){return new s(this)};o.valueOf=o.toString=function(){return this.build(false)._string};function Q(e){return function(t,r){if(t===undefined){return this._parts[e]||""}else{this._parts[e]=t||null;this.build(!r);return this}}}function A(e,t){return function(r,n){if(r===undefined){return this._parts[e]||""}else{if(r!==null){r=r+"";if(r.charAt(0)===t){r=r.substring(1)}}this._parts[e]=r;this.build(!n);return this}}}o.protocol=Q("protocol");o.username=Q("username");o.password=Q("password");o.hostname=Q("hostname");o.port=Q("port");o.query=A("query","?");o.fragment=A("fragment","#");o.search=function(e,t){var r=this.query(e,t);return typeof r==="string"&&r.length?"?"+r:r};o.hash=function(e,t){var r=this.fragment(e,t);return typeof r==="string"&&r.length?"#"+r:r};o.pathname=function(e,t){if(e===undefined||e===true){var r=this._parts.path||(this._parts.hostname?"/":"");return e?(this._parts.urn?s.decodeUrnPath:s.decodePath)(r):r}else{if(this._parts.urn){this._parts.path=e?s.recodeUrnPath(e):""}else{this._parts.path=e?s.recodePath(e):"/"}this.build(!t);return this}};o.path=o.pathname;o.href=function(e,t){var r;if(e===undefined){return this.toString()}this._string="";this._parts=s._parts();var n=e instanceof s;var i=typeof e==="object"&&(e.hostname||e.path||e.pathname);if(e.nodeName){var a=s.getDomAttribute(e);e=e[a]||"";i=false}if(!n&&i&&e.pathname!==undefined){e=e.toString()}if(typeof e==="string"||e instanceof String){this._parts=s.parse(String(e),this._parts)}else if(n||i){var o=n?e._parts:e;for(r in o){if(r==="query"){continue}if(u.call(this._parts,r)){this._parts[r]=o[r]}}if(o.query){this.query(o.query,false)}}else{throw new TypeError("invalid input")}this.build(!t);return this};o.is=function(e){var t=false;var n=false;var i=false;var a=false;var o=false;var u=false;var h=false;var f=!this._parts.urn;if(this._parts.hostname){f=false;n=s.ip4_expression.test(this._parts.hostname);i=s.ip6_expression.test(this._parts.hostname);t=n||i;a=!t;o=a&&r&&r.has(this._parts.hostname);u=a&&s.idn_expression.test(this._parts.hostname);h=a&&s.punycode_expression.test(this._parts.hostname)}switch(e.toLowerCase()){case"relative":return f;case"absolute":return!f;case"domain":case"name":return a;case"sld":return o;case"ip":return t;case"ip4":case"ipv4":case"inet4":return n;case"ip6":case"ipv6":case"inet6":return i;case"idn":return u;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return h}return null};var x=o.protocol;var P=o.port;var I=o.hostname;o.protocol=function(e,t){if(e){e=e.replace(/:(\/\/)?$/,"");if(!e.match(s.protocol_expression)){throw new TypeError('Protocol "'+e+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]")}}return x.call(this,e,t)};o.scheme=o.protocol;o.port=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e!==undefined){if(e===0){e=null}if(e){e+="";if(e.charAt(0)===":"){e=e.substring(1)}s.ensureValidPort(e)}}return P.call(this,e,t)};o.hostname=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e!==undefined){var r={preventInvalidHostname:this._parts.preventInvalidHostname};var n=s.parseHost(e,r);if(n!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}e=r.hostname;if(this._parts.preventInvalidHostname){s.ensureValidHostname(e,this._parts.protocol)}}return I.call(this,e,t)};o.origin=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){var r=this.protocol();var n=this.authority();if(!n){return""}return(r?r+"://":"")+this.authority()}else{var i=s(e);this.protocol(i.protocol()).authority(i.authority()).build(!t);return this}};o.host=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){return this._parts.hostname?s.buildHost(this._parts):""}else{var r=s.parseHost(e,this._parts);if(r!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}this.build(!t);return this}};o.authority=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){return this._parts.hostname?s.buildAuthority(this._parts):""}else{var r=s.parseAuthority(e,this._parts);if(r!=="/"){throw new TypeError('Hostname "'+e+'" contains characters other than [A-Z0-9.-]')}this.build(!t);return this}};o.userinfo=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){var r=s.buildUserinfo(this._parts);return r?r.substring(0,r.length-1):r}else{if(e[e.length-1]!=="@"){e+="@"}s.parseUserinfo(e,this._parts);this.build(!t);return this}};o.resource=function(e,t){var r;if(e===undefined){return this.path()+this.search()+this.hash()}r=s.parse(e);this._parts.path=r.path;this._parts.query=r.query;this._parts.fragment=r.fragment;this.build(!t);return this};o.subdomain=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var r=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,r)||""}else{var n=this._parts.hostname.length-this.domain().length;var i=this._parts.hostname.substring(0,n);var a=new RegExp("^"+h(i));if(e&&e.charAt(e.length-1)!=="."){e+="."}if(e.indexOf(":")!==-1){throw new TypeError("Domains cannot contain colons")}if(e){s.ensureValidHostname(e,this._parts.protocol)}this._parts.hostname=this._parts.hostname.replace(a,e);this.build(!t);return this}};o.domain=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e==="boolean"){t=e;e=undefined}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var r=this._parts.hostname.match(/\./g);if(r&&r.length<2){return this._parts.hostname}var n=this._parts.hostname.length-this.tld(t).length-1;n=this._parts.hostname.lastIndexOf(".",n-1)+1;return this._parts.hostname.substring(n)||""}else{if(!e){throw new TypeError("cannot set domain empty")}if(e.indexOf(":")!==-1){throw new TypeError("Domains cannot contain colons")}s.ensureValidHostname(e,this._parts.protocol);if(!this._parts.hostname||this.is("IP")){this._parts.hostname=e}else{var i=new RegExp(h(this.domain())+"$");this._parts.hostname=this._parts.hostname.replace(i,e)}this.build(!t);return this}};o.tld=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e==="boolean"){t=e;e=undefined}if(e===undefined){if(!this._parts.hostname||this.is("IP")){return""}var n=this._parts.hostname.lastIndexOf(".");var i=this._parts.hostname.substring(n+1);if(t!==true&&r&&r.list[i.toLowerCase()]){return r.get(this._parts.hostname)||i}return i}else{var s;if(!e){throw new TypeError("cannot set TLD empty")}else if(e.match(/[^a-zA-Z0-9-]/)){if(r&&r.is(e)){s=new RegExp(h(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(s,e)}else{throw new TypeError('TLD "'+e+'" contains characters other than [A-Z0-9]')}}else if(!this._parts.hostname||this.is("IP")){throw new ReferenceError("cannot set TLD on non-domain host")}else{s=new RegExp(h(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(s,e)}this.build(!t);return this}};o.directory=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined||e===true){if(!this._parts.path&&!this._parts.hostname){return""}if(this._parts.path==="/"){return"/"}var r=this._parts.path.length-this.filename().length-1;var n=this._parts.path.substring(0,r)||(this._parts.hostname?"/":"");return e?s.decodePath(n):n}else{var i=this._parts.path.length-this.filename().length;var a=this._parts.path.substring(0,i);var o=new RegExp("^"+h(a));if(!this.is("relative")){if(!e){e="/"}if(e.charAt(0)!=="/"){e="/"+e}}if(e&&e.charAt(e.length-1)!=="/"){e+="/"}e=s.recodePath(e);this._parts.path=this._parts.path.replace(o,e);this.build(!t);return this}};o.filename=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(typeof e!=="string"){if(!this._parts.path||this._parts.path==="/"){return""}var r=this._parts.path.lastIndexOf("/");var n=this._parts.path.substring(r+1);return e?s.decodePathSegment(n):n}else{var i=false;if(e.charAt(0)==="/"){e=e.substring(1)}if(e.match(/\.?\//)){i=true}var a=new RegExp(h(this.filename())+"$");e=s.recodePath(e);this._parts.path=this._parts.path.replace(a,e);if(i){this.normalizePath(t)}else{this.build(!t)}return this}};o.suffix=function(e,t){if(this._parts.urn){return e===undefined?"":this}if(e===undefined||e===true){if(!this._parts.path||this._parts.path==="/"){return""}var r=this.filename();var n=r.lastIndexOf(".");var i,a;if(n===-1){return""}i=r.substring(n+1);a=/^[a-z0-9%]+$/i.test(i)?i:"";return e?s.decodePathSegment(a):a}else{if(e.charAt(0)==="."){e=e.substring(1)}var o=this.suffix();var u;if(!o){if(!e){return this}this._parts.path+="."+s.recodePath(e)}else if(!e){u=new RegExp(h("."+o)+"$")}else{u=new RegExp(h(o)+"$")}if(u){e=s.recodePath(e);this._parts.path=this._parts.path.replace(u,e)}this.build(!t);return this}};o.segment=function(e,t,r){var n=this._parts.urn?":":"/";var i=this.path();var s=i.substring(0,1)==="/";var a=i.split(n);if(e!==undefined&&typeof e!=="number"){r=t;t=e;e=undefined}if(e!==undefined&&typeof e!=="number"){throw new Error('Bad segment "'+e+'", must be 0-based integer')}if(s){a.shift()}if(e<0){e=Math.max(a.length+e,0)}if(t===undefined){return e===undefined?a:a[e]}else if(e===null||a[e]===undefined){if(p(t)){a=[];for(var o=0,u=t.length;o<u;o++){if(!t[o].length&&(!a.length||!a[a.length-1].length)){continue}if(a.length&&!a[a.length-1].length){a.pop()}a.push(m(t[o]))}}else if(t||typeof t==="string"){t=m(t);if(a[a.length-1]===""){a[a.length-1]=t}else{a.push(t)}}}else{if(t){a[e]=m(t)}else{a.splice(e,1)}}if(s){a.unshift("")}return this.path(a.join(n),r)};o.segmentCoded=function(e,t,r){var n,i,a;if(typeof e!=="number"){r=t;t=e;e=undefined}if(t===undefined){n=this.segment(e,t,r);if(!p(n)){n=n!==undefined?s.decode(n):undefined}else{for(i=0,a=n.length;i<a;i++){n[i]=s.decode(n[i])}}return n}if(!p(t)){t=typeof t==="string"||t instanceof String?s.encode(t):t}else{for(i=0,a=t.length;i<a;i++){t[i]=s.encode(t[i])}}return this.segment(e,t,r)};var S=o.query;o.query=function(e,t){if(e===true){return s.parseQuery(this._parts.query,this._parts.escapeQuerySpace)}else if(typeof e==="function"){var r=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);var n=e.call(this,r);this._parts.query=s.buildQuery(n||r,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);this.build(!t);return this}else if(e!==undefined&&typeof e!=="string"){this._parts.query=s.buildQuery(e,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);this.build(!t);return this}else{return S.call(this,e,t)}};o.setQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if(typeof e==="string"||e instanceof String){n[e]=t!==undefined?t:null}else if(typeof e==="object"){for(var i in e){if(u.call(e,i)){n[i]=e[i]}}}else{throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")}this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.addQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);s.addQuery(n,e,t===undefined?null:t);this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.removeQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);s.removeQuery(n,e,t);this._parts.query=s.buildQuery(n,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);if(typeof e!=="string"){r=t}this.build(!r);return this};o.hasQuery=function(e,t,r){var n=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return s.hasQuery(n,e,t,r)};o.setSearch=o.setQuery;o.addSearch=o.addQuery;o.removeSearch=o.removeQuery;o.hasSearch=o.hasQuery;o.normalize=function(){if(this._parts.urn){return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build()}return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build()};o.normalizeProtocol=function(e){if(typeof this._parts.protocol==="string"){this._parts.protocol=this._parts.protocol.toLowerCase();this.build(!e)}return this};o.normalizeHostname=function(r){if(this._parts.hostname){if(this.is("IDN")&&e){this._parts.hostname=e.toASCII(this._parts.hostname)}else if(this.is("IPv6")&&t){this._parts.hostname=t.best(this._parts.hostname)}this._parts.hostname=this._parts.hostname.toLowerCase();this.build(!r)}return this};o.normalizePort=function(e){if(typeof this._parts.protocol==="string"&&this._parts.port===s.defaultPorts[this._parts.protocol]){this._parts.port=null;this.build(!e)}return this};o.normalizePath=function(e){var t=this._parts.path;if(!t){return this}if(this._parts.urn){this._parts.path=s.recodeUrnPath(this._parts.path);this.build(!e);return this}if(this._parts.path==="/"){return this}t=s.recodePath(t);var r;var n="";var i,a;if(t.charAt(0)!=="/"){r=true;t="/"+t}if(t.slice(-3)==="/.."||t.slice(-2)==="/."){t+="/"}t=t.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/");if(r){n=t.substring(1).match(/^(\.\.\/)+/)||"";if(n){n=n[0]}}while(true){i=t.search(/\/\.\.(\/|$)/);if(i===-1){break}else if(i===0){t=t.substring(3);continue}a=t.substring(0,i).lastIndexOf("/");if(a===-1){a=i}t=t.substring(0,a)+t.substring(i+3)}if(r&&this.is("relative")){t=n+t.substring(1)}this._parts.path=t;this.build(!e);return this};o.normalizePathname=o.normalizePath;o.normalizeQuery=function(e){if(typeof this._parts.query==="string"){if(!this._parts.query.length){this._parts.query=null}else{this.query(s.parseQuery(this._parts.query,this._parts.escapeQuerySpace))}this.build(!e)}return this};o.normalizeFragment=function(e){if(!this._parts.fragment){this._parts.fragment=null;this.build(!e)}return this};o.normalizeSearch=o.normalizeQuery;o.normalizeHash=o.normalizeFragment;o.iso8859=function(){var e=s.encode;var t=s.decode;s.encode=escape;s.decode=decodeURIComponent;try{this.normalize()}finally{s.encode=e;s.decode=t}return this};o.unicode=function(){var e=s.encode;var t=s.decode;s.encode=_;s.decode=unescape;try{this.normalize()}finally{s.encode=e;s.decode=t}return this};o.readable=function(){var t=this.clone();t.username("").password("").normalize();var r="";if(t._parts.protocol){r+=t._parts.protocol+"://"}if(t._parts.hostname){if(t.is("punycode")&&e){r+=e.toUnicode(t._parts.hostname);if(t._parts.port){r+=":"+t._parts.port}}else{r+=t.host()}}if(t._parts.hostname&&t._parts.path&&t._parts.path.charAt(0)!=="/"){r+="/"}r+=t.path(true);if(t._parts.query){var n="";for(var i=0,a=t._parts.query.split("&"),o=a.length;i<o;i++){var u=(a[i]||"").split("=");n+="&"+s.decodeQuery(u[0],this._parts.escapeQuerySpace).replace(/&/g,"%26");if(u[1]!==undefined){n+="="+s.decodeQuery(u[1],this._parts.escapeQuerySpace).replace(/&/g,"%26")}}r+="?"+n.substring(1)}r+=s.decodeQuery(t.hash(),true);return r};o.absoluteTo=function(e){var t=this.clone();var r=["protocol","username","password","hostname","port"];var n,i,a;if(this._parts.urn){throw new Error("URNs do not have any generally defined hierarchical components")}if(!(e instanceof s)){e=new s(e)}if(t._parts.protocol){return t}else{t._parts.protocol=e._parts.protocol}if(this._parts.hostname){return t}for(i=0;a=r[i];i++){t._parts[a]=e._parts[a]}if(!t._parts.path){t._parts.path=e._parts.path;if(!t._parts.query){t._parts.query=e._parts.query}}else{if(t._parts.path.substring(-2)===".."){t._parts.path+="/"}if(t.path().charAt(0)!=="/"){n=e.directory();n=n?n:e.path().indexOf("/")===0?"/":"";t._parts.path=(n?n+"/":"")+t._parts.path;t.normalizePath()}}t.build();return t};o.relativeTo=function(e){var t=this.clone().normalize();var r,n,i,a,o;if(t._parts.urn){throw new Error("URNs do not have any generally defined hierarchical components")}e=new s(e).normalize();r=t._parts;n=e._parts;a=t.path();o=e.path();if(a.charAt(0)!=="/"){throw new Error("URI is already relative")}if(o.charAt(0)!=="/"){throw new Error("Cannot calculate a URI relative to another relative URI")}if(r.protocol===n.protocol){r.protocol=null}if(r.username!==n.username||r.password!==n.password){return t.build()}if(r.protocol!==null||r.username!==null||r.password!==null){return t.build()}if(r.hostname===n.hostname&&r.port===n.port){r.hostname=null;r.port=null}else{return t.build()}if(a===o){r.path="";return t.build()}i=s.commonPath(a,o);if(!i){return t.build()}var u=n.path.substring(i.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");r.path=u+r.path.substring(i.length)||"./";return t.build()};o.equals=function(e){var t=this.clone();var r=new s(e);var n={};var i={};var a={};var o,h,f;t.normalize();r.normalize();if(t.toString()===r.toString()){return true}o=t.query();h=r.query();t.query("");r.query("");if(t.toString()!==r.toString()){return false}if(o.length!==h.length){return false}n=s.parseQuery(o,this._parts.escapeQuerySpace);i=s.parseQuery(h,this._parts.escapeQuerySpace);for(f in n){if(u.call(n,f)){if(!p(n[f])){if(n[f]!==i[f]){return false}}else if(!d(n[f],i[f])){return false}a[f]=true}}for(f in i){if(u.call(i,f)){if(!a[f]){return false}}}return true};o.preventInvalidHostname=function(e){this._parts.preventInvalidHostname=!!e;return this};o.duplicateQueryParameters=function(e){this._parts.duplicateQueryParameters=!!e;return this};o.escapeQuerySpace=function(e){this._parts.escapeQuerySpace=!!e;return this};return s});
}
});
//# sourceMappingURL=Library-preload.js.map
