/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/f/library","sap/m/library","sap/ui/core/InvisibleText","sap/ui/core/Core","sap/m/BadgeEnabler","sap/f/CardRenderer"],function(e,t,i,a,r,n,o){"use strict";var s=i.BadgeState;var d=3e3;var p=e.extend("sap.f.CardBase",{metadata:{library:"sap.f",interfaces:["sap.f.ICard","sap.m.IBadge"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"}},aggregations:{}},renderer:o});n.call(p.prototype);p.prototype.init=function(){this._oRb=r.getLibraryResourceBundle("sap.f");this._ariaContentText=new a({id:this.getId()+"-ariaContentText"});this._ariaContentText.setText(this._oRb.getText("ARIA_LABEL_CARD_CONTENT"));this._ariaText=new a({id:this.getId()+"-ariaText"});this._ariaText.setText(this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD"));this.initBadgeEnablement()};p.prototype.exit=function(){this._oRb=null;if(this._ariaContentText){this._ariaContentText.destroy();this._ariaContentText=null}if(this._ariaText){this._ariaText.destroy();this._ariaText=null}};p.prototype.setAggregation=function(t,i){var a;if(t==="header"||t==="_header"){a=this.getAggregation(t);if(a){a.detachEvent("_change",this._onHeaderVisibilityChange,this)}if(i){i.attachEvent("_change",this._onHeaderVisibilityChange,this)}}return e.prototype.setAggregation.apply(this,arguments)};p.prototype._onHeaderVisibilityChange=function(e){if(e.getParameters().name==="visible"){setTimeout(function(){this.invalidate()}.bind(this),0)}};p.prototype.getCardHeader=function(){return null};p.prototype.getCardHeaderPosition=function(){return null};p.prototype.getCardContent=function(){return null};p.prototype.getFocusDomRef=function(){return this.getCardHeader()?this.getCardHeader().getFocusDomRef():this.getDomRef()};p.prototype.onmousedown=function(){this._hideBadge()};p.prototype.onsapenter=function(){this._hideBadge()};p.prototype.onfocusin=function(){this._startBadgeHiding()};p.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),d)};p.prototype._hideBadge=function(){var e=this.getBadgeCustomData();if(e){e.setVisible(false)}this._iHideBadgeTimeout=null};p.prototype.onBadgeUpdate=function(e,t,i){var a=this.getCardHeader(),r,n;if(a){r=a.getFocusDomRef()}else{r=this.getDomRef("contentSection")}if(!r){return}n=r.getAttribute("aria-labelledby")||"";switch(t){case s.Appear:n=i+" "+n;r.setAttribute("aria-labelledby",n);break;case s.Disappear:n=n.replace(i,"").trim();r.setAttribute("aria-labelledby",n);break}};p.prototype.getAriaLabelBadgeText=function(){return this.getBadgeCustomData().getValue()};p.prototype._getAriaLabelledIds=function(){var e=this.getCardHeader();if(e){if(this._isInsideGridContainer()){return e._getAriaLabelledBy()}if(e._getTitle&&e._getTitle()){return e._getTitle().getId()}}return this._ariaText.getId()};p.prototype._isInsideGridContainer=function(){var e=this.getParent();return e&&e.isA("sap.f.GridContainer")};p.prototype.getAriaRoleDescription=function(){var e=this.getCardHeader();if(e){return e.getAriaRoleDescription()}return null};return p});
//# sourceMappingURL=CardBase.js.map