/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/Device","sap/ui/core/Control","sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/theming/Parameters","sap/m/ToggleButton","sap/m/Button","./DynamicPageHeaderRenderer","sap/ui/core/InvisibleMessage"],function(t,e,n,o,i,s,a,r,u,p){"use strict";var l=o.InvisibleMessageMode;var g=n.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_collapseButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPageHeader.designtime"},renderer:u});g._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f")};g.UNPRESSED_PIN_ICON="sap-icon://pushpin-off";g.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_LABEL:"aria-label",LABEL_EXPANDED:g._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_COLLAPSED:g._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:g._getResourceBundle().getText("PIN_HEADER"),TOOLTIP_COLLAPSE_BUTTON:g._getResourceBundle().getText("COLLAPSE_HEADER_BUTTON_TOOLTIP"),STATE_TRUE:"true",STATE_FALSE:"false"};g.prototype.init=function(){this._bShowCollapseButton=true;this._oInvisibleMessage=null};g.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();if(!this._oInvisibleMessage){this._oInvisibleMessage=p.getInstance()}if(this.getPinnable()){this._setPressedStatePinIcon()}};g.prototype._togglePinButton=function(t){this._getPinButton().setPressed(t);this._getPinButton().setIcon(t?this._sPressedStatePinIconURI:g.UNPRESSED_PIN_ICON)};g.prototype._setShowPinBtn=function(t){this._getPinButton().$().toggleClass("sapUiHidden",!t)};g.prototype._pinUnpinFireEvent=function(t){this.fireEvent("_pinUnpinPress");this._togglePinButton(t.getSource().getPressed())};g.prototype._onCollapseButtonPress=function(){this.fireEvent("_headerVisualIndicatorPress")};g.prototype._onCollapseButtonMouseOver=function(){this.fireEvent("_visualIndicatorMouseOver")};g.prototype._onCollapseButtonMouseOut=function(){this.fireEvent("_visualIndicatorMouseOut")};g.prototype._initARIAState=function(){var t=this.$();t.attr(g.ARIA.ARIA_LABEL,g.ARIA.LABEL_EXPANDED)};g.prototype._initPinButtonARIAState=function(){var t;if(this.getPinnable()){t=this._getPinButtonJQueryRef();t.attr(g.ARIA.ARIA_CONTROLS,this.getId())}};g.prototype._updateARIAState=function(t){var e=this.$();if(t){e.attr(g.ARIA.ARIA_LABEL,g.ARIA.LABEL_EXPANDED)}else{e.attr(g.ARIA.ARIA_LABEL,g.ARIA.LABEL_COLLAPSED)}};g.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var t=new a({id:this.getId()+"-pinBtn",icon:g.UNPRESSED_PIN_ICON,tooltip:g.ARIA.LABEL_PINNED,press:this._pinUnpinFireEvent.bind(this)}).addStyleClass("sapFDynamicPageHeaderPinButton");this.setAggregation("_pinButton",t,true)}return this.getAggregation("_pinButton")};g.prototype._getCollapseButton=function(){if(!this.getAggregation("_collapseButton")){var t=new r({id:this.getId()+"-collapseBtn",icon:"sap-icon://slim-arrow-up",press:this._onCollapseButtonPress.bind(this),tooltip:g.ARIA.TOOLTIP_COLLAPSE_BUTTON}).addStyleClass("sapFDynamicPageToggleHeaderIndicator");t.onmouseover=this._onCollapseButtonMouseOver.bind(this);t.onmouseout=this._onCollapseButtonMouseOut.bind(this);this.setAggregation("_collapseButton",t,true)}return this.getAggregation("_collapseButton")};g.prototype._toggleCollapseButton=function(t){this._setShowCollapseButton(t);this._getCollapseButton().toggleStyleClass("sapUiHidden",!t)};g.prototype._getShowCollapseButton=function(){return this._bShowCollapseButton&&!!this.getContent().length};g.prototype._setShowCollapseButton=function(t){this._bShowCollapseButton=!!t};g.prototype._focusCollapseButton=function(){var t=g._getResourceBundle().getText("EXPANDED_HEADER");this._getCollapseButton().$().trigger("focus");this._oInvisibleMessage.announce(t,l.Polite)};g.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().trigger("focus")};g.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$()};g.prototype._getState=function(){var t=this.getContent(),n=t.length>0,o=this.getPinnable()&&n&&!e.system.phone,i=this._getPinButton(),s=this._getCollapseButton();s.toggleStyleClass("sapUiHidden",!this._getShowCollapseButton());return{content:t,headerHasContent:n,headerPinnable:o,hasContent:t.length>0,pinButton:i,collapseButton:s}};g.prototype.onThemeChanged=function(){this._setPressedStatePinIcon()};g.prototype._setPressedStatePinIcon=function(){this._sPressedStatePinIconURI=i.getIconURI(s.get({name:"_sap_f_DynamicPageHeader_PinButton_Icon"}))};return g});
//# sourceMappingURL=DynamicPageHeader.js.map