/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","sap/ui/core/dnd/DropInfo","sap/f/dnd/GridDragOver","sap/base/Log"],function(r,t,e,o){"use strict";var n=t.extend("sap.f.dnd.GridDropInfo",{metadata:{library:"sap.f",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{dropIndicatorSize:{type:"function",invalidate:false,parameters:{draggedControl:{type:"sap.ui.core.Control"}}}},events:{}}});n.prototype.isDroppable=function(r,e){if(!this._shouldEnhance()){return t.prototype.isDroppable.apply(this,arguments)}if(!this.getEnabled()){return false}if(!r||!e){return false}var o=this.getDropTarget();if(!o){return false}var n=o.getDomRefForSetting(this.getTargetAggregation());if(n&&n.contains(e.target)){e.setMark("DragWithin",this.getTargetAggregation());return true}if(!n&&o===r){return true}return false};n.prototype.fireDragEnter=function(r){if(!this._shouldEnhance()||this._isKeyboardEvent(r)){return t.prototype.fireDragEnter.apply(this,arguments)}if(!r||!r.dragSession||!r.dragSession.getDragControl()){return null}var o=e.getInstance(),n=r.dragSession.getDragControl();if(this.getDropIndicatorSize()){o.setDropIndicatorSize(this.getDropIndicatorSize()(n))}o.setCurrentContext(r.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation(),r.dragSession);var i=o.getSuggestedDropPosition();var s=this.fireEvent("dragEnter",{dragSession:r.dragSession,browserEvent:r.originalEvent,target:i?i.targetControl:null},true);if(s){o.handleDragOver(r)}return s};n.prototype.fireDragOver=function(r){if(!this._shouldEnhance()||this._isKeyboardEvent(r)){return t.prototype.fireDragOver.apply(this,arguments)}if(!r||!r.dragSession||!r.dragSession.getDragControl()){return null}var e=this._suggestDropPosition(r);if(e&&r.dragSession&&e.targetControl){r.dragSession.setDropControl(e.targetControl)}return this.fireEvent("dragOver",{dragSession:r.dragSession,browserEvent:r.originalEvent,target:e?e.targetControl:null,dropPosition:e?e.position:null})};n.prototype.fireDrop=function(r){if(!this._shouldEnhance()||this._isKeyboardEvent(r)){return t.prototype.fireDrop.apply(this,arguments)}if(!r||!r.dragSession||!r.dragSession.getDragControl()){return null}var o=r.dragSession,n=e.getInstance(),i;n.setCurrentContext(o.getDragControl(),this.getDropTarget(),this.getTargetAggregation(),o);i=n.getSuggestedDropPosition();this.fireEvent("drop",{dragSession:r.dragSession,browserEvent:r.originalEvent,dropPosition:i?i.position:null,draggedControl:o.getDragControl(),droppedControl:i?i.targetControl:null});n.scheduleEndDrag()};n.prototype._shouldEnhance=function(){if(this._bShouldEnhance===undefined){if(!this.getParent().isA("sap.f.dnd.IGridDroppable")){o.error("The control which uses 'sap.f.dnd.GridDropInfo' has to implement 'sap.f.dnd.IGridDroppable'.","sap.f.dnd.GridDropInfo");this._bShouldEnhance=false;return this._bShouldEnhance}this._bShouldEnhance=this.getDropPosition()===r.dnd.DropPosition.Between&&this.getDropLayout()===r.dnd.DropLayout.Horizontal}return this._bShouldEnhance};n.prototype._isKeyboardEvent=function(r){return r.originalEvent.type==="keydown"};n.prototype._suggestDropPosition=function(r){if(!r.dragSession||!r.dragSession.getDragControl()){return null}var t=e.getInstance();t.setCurrentContext(r.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation(),r.dragSession);t.handleDragOver(r);return t.getSuggestedDropPosition()};return n});
//# sourceMappingURL=GridDropInfo.js.map