//@ui5-bundle sap/f/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/Avatar", ["sap/m/Avatar","sap/m/AvatarRenderer","./library"],function(e,r){"use strict";var t=e.extend("sap.f.Avatar",{metadata:{library:"sap.f",deprecated:true,properties:{},designtime:"sap/f/designtime/Avatar.designtime"},renderer:r});t.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("AVATAR_TOOLTIP")};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/AvatarGroup", ["./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/dom/units/Rem","./AvatarGroupRenderer","sap/m/Button","sap/m/library","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","sap/ui/core/Core"],function(t,e,i,o,r,a,s,n,u,h){"use strict";var p=t.AvatarGroupType;var l=s.AvatarColor;var v=s.AvatarSize;var _={XS:2,S:3,M:4,L:5,XL:7};var g={XS:.75,S:1.25,M:1.625,L:2,XL:2.75};var f={XS:.0625,S:.125,M:.125,L:.125,XL:.25,Custom:.125};var y=e.extend("sap.f.AvatarGroup",{metadata:{library:"sap.f",properties:{groupType:{type:"sap.f.AvatarGroupType",group:"Appearance",defaultValue:p.Group},avatarDisplaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:v.S},avatarCustomDisplaySize:{type:"sap.ui.core.AbsoluteCSSSize",group:"Appearance",defaultValue:"3rem"},avatarCustomFontSize:{type:"sap.ui.core.AbsoluteCSSSize",group:"Appearance",defaultValue:"1.125rem"},_interactive:{type:"boolean",group:"Behavior",defaultValue:true,visibility:"hidden"}},defaultAggregation:"items",aggregations:{items:{type:"sap.f.AvatarGroupItem",multiple:true}},events:{press:{parameters:{groupType:{type:"string"},overflowButtonPressed:{type:"boolean"},avatarsDisplayed:{type:"int"}}}}},renderer:r});y.prototype.init=function(){this._oShowMoreButton=new a;this._oShowMoreButton.addStyleClass("sapFAvatarGroupMoreButton");this._oShowMoreButton.addStyleClass("sapFAvatarGroupMoreButton"+this.getAvatarDisplaySize());this._bFirstRendering=true;this._onResizeRef=this._onResize.bind(this);this._iCurrentAvatarColorNumber=1;this._bShowMoreButton=false};y.prototype.exit=function(){this._detachResizeHandlers();this._destroyItemNavigation();this._oShowMoreButton.destroy();this._oShowMoreButton=null};y.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null}};y.prototype.onBeforeRendering=function(){if(this._bFirstRendering){this._iAvatarsToShow=this.getItems().length;this._bFirstRendering=false}};y.prototype.onAfterRendering=function(){var t=this.getProperty("_interactive"),e,o=[];if(!this._oItemNavigation&&t){this._oItemNavigation=new i(null,null);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addEventDelegate(this._oItemNavigation)}if(t){e=this.getDomRef();this._oItemNavigation.setRootDomRef(e)}if(t&&this.getGroupType()===p.Individual){this.getItems().forEach(function(t){o.push(t.getDomRef())});this._oItemNavigation.setItemDomRefs(o)}this._detachResizeHandlers();this._attachResizeHandlers();if(h.isThemeApplied()){this._onResize()}if(this._shouldShowMoreButton()){this._oShowMoreButton.$().attr("role","button");if(this.getGroupType()===p.Group){this._oShowMoreButton.$().attr("tabindex","-1")}else{this._oShowMoreButton.$().attr("aria-label",this._getResourceBundle().getText("AVATARGROUP_POPUP"))}}this._updateAccState()};y.prototype.onThemeChanged=function(){if(!this.getDomRef()){return}this._onResize()};y.prototype._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f")};y.prototype._updateAccState=function(){var t=this._getResourceBundle(),e=t.getText("AVATARGROUP_NUMBER_OF_AVATARS",[this._iAvatarsToShow,this.getItems().length-this._iAvatarsToShow]),i=t.getText("AVATARGROUP_POPUP");if(this.getGroupType()===p.Group){this.$().attr("aria-label",i+" "+e)}};y.prototype._attachResizeHandlers=function(){this._iResizeHandlerId=n.register(this,this._onResizeRef)};y.prototype._detachResizeHandlers=function(){if(this._iResizeHandlerId){n.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}};y.prototype.setGroupType=function(t){this.getItems().forEach(function(e){e._setGroupType(t)});return this.setProperty("groupType",t)};y.prototype.addItem=function(t){t._setDisplaySize(this.getAvatarDisplaySize());t._setCustomDisplaySize(this.getAvatarCustomDisplaySize());t._setCustomFontSize(this.getAvatarCustomFontSize());t._setAvatarColor(l["Accent"+this._iCurrentAvatarColorNumber]);t._setGroupType(this.getGroupType());t._setInteractive(this.getProperty("_interactive"));this.addAggregation("items",t);this._iAvatarsToShow=this.getItems().length;this._iCurrentAvatarColorNumber++;if(this._iCurrentAvatarColorNumber>10){this._iCurrentAvatarColorNumber=1}return this};y.prototype.setAvatarDisplaySize=function(t){var e=this.getAvatarDisplaySize();this._oShowMoreButton.removeStyleClass("sapFAvatarGroupMoreButton"+e);this._oShowMoreButton.addStyleClass("sapFAvatarGroupMoreButton"+t);if(e===t){return this}this.getItems().forEach(function(e){e._setDisplaySize(t)});return this.setProperty("avatarDisplaySize",t)};y.prototype.setAvatarCustomDisplaySize=function(t){var e=this.getAvatarCustomDisplaySize();if(e===t){return this}this.setProperty("avatarCustomDisplaySize",t);this.getItems().forEach(function(e){e._setCustomDisplaySize(t)});return this};y.prototype.setAvatarCustomFontSize=function(t){var e=this.getAvatarCustomFontSize();if(e===t){return this}this.setProperty("avatarCustomFontSize",t);this.getItems().forEach(function(e){e._setCustomFontSize(t)});return this};y.prototype.ontap=function(t){if(!this.getProperty("_interactive")){return}var e=t.srcControl;this.firePress({groupType:this.getGroupType(),eventSource:e,overflowButtonPressed:e===this._oShowMoreButton,avatarsDisplayed:this._iAvatarsToShow})};y.prototype.onsapspace=function(t){this.ontap(t)};y.prototype.onsapenter=function(t){this.ontap(t)};y.prototype.onkeyup=function(t){if(t.shiftKey&&t.keyCode==u.ENTER||t.shiftKey&&t.keyCode==u.SPACE){t.preventDefault()}};y.prototype._getAvatarMargin=function(t){var e=this.getGroupType(),i=this.getAvatarDisplaySize(),o;if(i===v.Custom&&e===p.Group){o=this._getAvatarWidth(v.Custom)*.4}else if(e===p.Group){o=g[t]}else{o=f[t]}return o};y.prototype._getAvatarWidth=function(t){var e,i=this.getAvatarCustomDisplaySize(),r=/.*[pP][xX]/.test(i);if(t!==v.Custom){e=_[t]}else{e=parseFloat(r?o.fromPx(i):i)}return e};y.prototype._getAvatarNetWidth=function(t,e){var i=this.getGroupType();if(i===p.Group){return t-e}else{return t+e}};y.prototype._getAvatarsToShow=function(t,e,i){var r=o.toPx(1),a=t-e*r,s=Math.floor(a/(i*r));return s+1};y.prototype._adjustAvatarsToShow=function(t){if(t-this._iAvatarsToShow>99){this._iAvatarsToShow-=2}else{this._iAvatarsToShow--}};y.prototype._getWidth=function(){return Math.ceil(this.$().width())};y.prototype._onResize=function(){var t=this._getWidth(),e=this.getItems(),i=e.length,o=this.getAvatarDisplaySize(),r=this._getAvatarWidth(o),a=this._getAvatarMargin(o),s=this._getAvatarNetWidth(r,a),n=this.$().children(".sapFAvatarGroupItem").length;if(t===0){return}this._iAvatarsToShow=this._getAvatarsToShow(t,r,s);if(o===v.Custom){this.getDomRef().style.setProperty("--sapUiAvatarGroupCustomMarginRight",r*-.4+"rem")}if(i>this._iAvatarsToShow&&i>0){this._bShowMoreButton=true;this._bAutoWidth=false;this._adjustAvatarsToShow(i);if(n!=this._iAvatarsToShow){this._oShowMoreButton.setText("+"+(i-this._iAvatarsToShow));this.invalidate()}}else{this._bAutoWidth=true;this.getDomRef().style.width="auto";if(this._bShowMoreButton){this._bShowMoreButton=false;this.invalidate()}}};y.prototype._setInteractive=function(t){if(!t){this._destroyItemNavigation()}this.getItems().forEach(function(e){e._setInteractive(t)});return this.setProperty("_interactive",t)};y.prototype._shouldShowMoreButton=function(){return this._bShowMoreButton};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/AvatarGroupItem", ["./library","sap/ui/base/ManagedObject","sap/ui/core/Control","sap/m/Avatar","./AvatarGroupItemRenderer"],function(t,e,i,r,o){"use strict";var s=i.extend("sap.f.AvatarGroupItem",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},fallbackIcon:{type:"string",group:"Data",defaultValue:null}}},renderer:o});s.prototype.onBeforeRendering=function(){this._getAvatar()};s.prototype.destroy=function(){if(this._oAvatar){this._oAvatar.destroy();this._oAvatar=null}if(this._oPopover){this._oPopover.destroy();this._oPopover=null}e.prototype.destroy.apply(this)};s.prototype.setSrc=function(t){if(this.getSrc()===t){return this}this._getAvatar().setSrc(t);return this.setProperty("src",t)};s.prototype.setInitials=function(t){if(this.getInitials()===t){return this}this._getAvatar().setInitials(t);return this.setProperty("initials",t)};s.prototype.setFallbackIcon=function(t){if(this.getFallbackIcon()===t){return this}this._getAvatar().setFallbackIcon(t);return this.setProperty("fallbackIcon",t)};s.prototype.getAvatarColor=function(){return this._sAvatarColor};s.prototype._setGroupType=function(t){this._sGroupType=t;this.invalidate()};s.prototype._getGroupType=function(){return this._sGroupType};s.prototype._setInteractive=function(t){if(this._bInteractive===t){return}this._bInteractive=t;this.invalidate()};s.prototype._getInteractive=function(){return this._bInteractive};s.prototype._setAvatarColor=function(t){this._sAvatarColor=t;this._getAvatar().setBackgroundColor(t)};s.prototype._setDisplaySize=function(t){this._sAvatarDisplaySize=t;this._getAvatar().setDisplaySize(t)};s.prototype._getDisplaySize=function(){return this._sAvatarDisplaySize};s.prototype._setCustomDisplaySize=function(t){this._sAvatarCustomDisplaySize=t;this._getAvatar().setCustomDisplaySize(t)};s.prototype._getCustomDisplaySize=function(){return this._sAvatarCustomDisplaySize};s.prototype._setCustomFontSize=function(t){this._sAvatarCustomFontSize=t;this._getAvatar().setCustomFontSize(t)};s.prototype._getCustomFontSize=function(){return this._sAvatarCustomFontSize};s.prototype._getAvatar=function(){if(!this._oAvatar){this._oAvatar=new r({src:this.getSrc(),initials:this.getInitials(),fallbackIcon:this.getFallbackIcon(),backgroundColor:this.getAvatarColor(),showBorder:true,displaySize:this._getDisplaySize(),customDisplaySize:this._getCustomDisplaySize(),customFontSize:this._getCustomFontSize()})}return this._oAvatar};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/AvatarGroupItemRenderer", ["sap/f/library"],function(t){"use strict";var r={apiVersion:2};r.render=function(t,r){var a=r.getTooltip_AsString();t.openStart("div",r).class("sapFAvatarGroupItem").class("sapFAvatarGroupItem"+r._sAvatarDisplaySize);if(r._getInteractive()&&r._getGroupType()==="Individual"){t.attr("tabindex",0)}if(a){t.attr("title",a)}t.openEnd();t.renderControl(r._getAvatar());t.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/AvatarGroupRenderer", ["sap/m/AvatarSize"],function(t){"use strict";var e={apiVersion:2};e.render=function(e,r){var o="sapFAvatarGroup",a=r.getGroupType(),i=r.getAvatarDisplaySize(),s=r.getAvatarCustomDisplaySize(),n=r.getAvatarCustomFontSize(),u=o+a,l=r.getItems(),p=r._shouldShowMoreButton(),v=r.getProperty("_interactive");e.openStart("div",r).class(o).class(u).class(o+i);if(p){e.class("sapFAvatarGroupShowMore")}if(!v){e.class("sapFAvatarGroupNonInteractive")}if(r._bAutoWidth){e.style("width","auto")}if(a==="Group"){e.attr("role","button")}if(i===t.Custom){e.style("height",s);e.style("min-width",s);e.style("font-size",n);e.style("line-height",s)}e.openEnd();for(var h=0;h<r._iAvatarsToShow;h++){e.renderControl(l[h])}if(p){e.renderControl(r._oShowMoreButton)}e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/CalendarAppointmentInCard", ["sap/ui/unified/CalendarAppointment"],function(e){"use strict";var t=e.extend("sap.f.CalendarAppointmentInCard",{metadata:{library:"sap.f",properties:{clickable:{type:"boolean",group:"Data",defaultValue:false}},events:{press:{}}}});t.prototype.ontap=function(){this._firePress()};t.prototype.onsapenter=function(){this._firePress()};t.prototype._firePress=function(){if(this.getClickable()){this.$().addClass("sapUiCalendarAppSel");setTimeout(function(){this.$().removeClass("sapUiCalendarAppSel")}.bind(this),180);this.firePress({})}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/CalendarInCard", ["sap/m/Button","sap/m/Toolbar","sap/ui/core/Core","sap/ui/core/format/DateFormat","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/unified/Calendar","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","./CalendarInCardRenderer","sap/ui/core/date/UI5Date"],function(t,e,a,i,r,o,s,n,h,c,_){"use strict";var p=s.extend("sap.f.CalendarInCard",{metadata:{library:"sap.f"},renderer:c});p.prototype.init=function(){s.prototype.init.apply(this,arguments);this.setProperty("_currentPicker","month")};p.prototype.onBeforeRendering=function(){var t=this.getAggregation("month"),e=this._getFocusedDate().toLocalJSDate();t[0].displayDate(e);this._iSize=0;switch(this._iMode){case 0:this._oPickerBtn.setText(this._formatPickerText(e));break;case 1:this._oPickerBtn.setText(this._formatMonthPickerText());break;case 2:case 3:this._oPickerBtn.setText(this._formatYearPickerText());break}this._updateTodayButtonState()};p.prototype.onAfterRendering=function(t){};p.prototype.onsaptabnext=function(t){};p.prototype.onsaptabprevious=function(t){};p.prototype._initializeHeader=function(){var i=this.getId()+"--Head",s=a.getLibraryResourceBundle("sap.f"),n=new t(i+"-PrevBtn",{icon:r.getIconURI("slim-arrow-left"),tooltip:s.getText("CALENDAR_BTN_PREV"),type:"Transparent",press:function(){this._handlePrevious()}.bind(this)}),h=new t({icon:r.getIconURI("slim-arrow-right"),tooltip:s.getText("CALENDAR_BTN_NEXT"),type:"Transparent",press:function(){this._handleNext()}.bind(this)}),c=new e(i,{ariaLabelledBy:o.getStaticId("sap.f","CALENDAR_NAVIGATION")});this._oTodayBtn=new t({text:s.getText("CALENDAR_TODAY"),ariaLabelledBy:o.getStaticId("sap.f","CALENDAR_NAVIGATE_TO_TODAY"),type:"Transparent",press:function(){this._handleTodayPress()}.bind(this)});this._oPickerBtn=new t({type:"Transparent",ariaLabelledBy:o.getStaticId("sap.f","CALENDAR_SELECT_RANGE"),press:function(){this._handlePickerButtonPress()}.bind(this)});c.addContent(n).addContent(this._oTodayBtn).addContent(h).addContent(this._oPickerBtn);this.setAggregation("header",c)};p.prototype._handlePickerButtonPress=function(){switch(this._iMode){case 0:this._showMonthPicker();this._oPickerBtn.getDomRef().focus();break;case 1:this._showYearPicker();this._oPickerBtn.getDomRef().focus();break;case 2:this._showYearRangePicker();break}};p.prototype._handleTodayPress=function(){var t=_.getInstance(),e=n.fromLocalJSDate(t);this.getAggregation("month")[0].setDate(t);this.getSelectedDates()[0].setStartDate(t);this._setFocusedDate(e);if(this._iMode===3){t.setFullYear(t.getFullYear()-this._getYearRangePicker().getRangeSize()/2);this._getYearRangePicker().setDate(t);this._oPickerBtn.setText(this._formatYearPickerText())}else if(this._iMode===2){this._getYearPicker().setDate(t);this._oPickerBtn.setText(this._formatYearPickerText())}else if(this._iMode===1){this.displayDate(t);this._getMonthPicker()._iYear=t.getFullYear();this._getMonthPicker().setMonth(t.getMonth());this._oPickerBtn.setText(this._formatMonthPickerText())}else{this._oPickerBtn.setText(this._formatPickerText())}this._addMonthFocusDelegate();this._updateTodayButtonState();this.fireStartDateChange();this.fireSelect()};p.prototype._formatPickerText=function(t){var e=t?t:this.getSelectedDates()[0].getStartDate(),r=a.getConfiguration().getRTL(),o=i.getDateInstance({format:"yMMMM"}),s=o.format(e),n,h;if(!r){n=s;if(h){n+=" - "+h}}else{if(h){n=h+" - "+s}else{n=s}}return n};p.prototype._formatYearPickerText=function(){var t=this._getYearPicker().getDate().getFullYear(),e=this._getYearPicker().getYears(),a=t-Math.floor(e/2),i=t+e/2-1;return""+a+" - "+i};p.prototype._formatMonthPickerText=function(){return i.getDateInstance({format:"y"}).format(this.getStartDate())};p.prototype._showMonthPicker=function(t){var e=this._getFocusedDate(),a=this._getMonthPicker();this.setProperty("_currentPicker","monthPicker");a._setYear(e.getYear());a._setDate(e);if(!t){a.setMonth(e.getMonth());this._setDisabledMonths(e.getYear(),a)}this._iMode=1;this._togglePrevNext(e,false);this._oPickerBtn.setText(this._formatMonthPickerText())};p.prototype._showYearPicker=function(){var t=this._getFocusedDate(),e=this._getYearPicker();this.setProperty("_currentPicker","yearPicker");this._togglePrevNexYearPicker();this._iMode=2;e.setDate(t.toLocalJSDate());this._oPickerBtn.setText(this._formatYearPickerText())};p.prototype._showYearRangePicker=function(){s.prototype._showYearRangePicker.apply(this,arguments);this._oPickerBtn.setVisible(false)};p.prototype._selectMonth=function(){s.prototype._selectMonth.apply(this,arguments);this._oPickerBtn.setText(this._formatPickerText());this._updateTodayButtonState()};p.prototype._selectYear=function(){s.prototype._selectYear.apply(this,arguments);this._oPickerBtn.setText(this._formatMonthPickerText());this._showMonthPicker();this._updateTodayButtonState()};p.prototype._selectYearRange=function(){var t=this.getAggregation("yearRangePicker"),e=t.getRangeSize(),a=this.getPrimaryCalendarType(),i=n.fromLocalJSDate(t.getDate(),a),r=this._getFocusedDate();i.setMonth(r.getMonth(),r.getDate());i.setYear(i.getYear()+Math.floor(e/2));r.setYear(i.getYear());this._setFocusedDate(r);this._showYearPicker();this._oPickerBtn.setVisible(true).setText(this._formatYearPickerText());this._updateTodayButtonState()};p.prototype._handlePrevious=function(){s.prototype._handlePrevious.apply(this,arguments);this._handleArrowNavigation(-1)};p.prototype._handleNext=function(){s.prototype._handleNext.apply(this,arguments);this._handleArrowNavigation(1)};p.prototype._handleArrowNavigation=function(t){var e,a,i;if(this._iMode===3){i=this._getYearRangePicker();i.getDate().setFullYear(i.getDate().getFullYear()+t*i.getYears());this._oPickerBtn.setText(this._formatYearPickerText())}else if(this._iMode===2){a=this._getYearPicker();a.getDate().setFullYear(a.getDate().getFullYear()+t*a.getYears());this._oPickerBtn.setText(this._formatYearPickerText())}else if(this._iMode===1){e=this._getMonthPicker();this._getFocusedDate().setYear(e._iYear);this.getAggregation("month")[0].getDate().setYear(e._iYear);this._oPickerBtn.setText(this._formatMonthPickerText())}else{this._oPickerBtn.setText(this._formatPickerText(this._getFocusedDate().toLocalJSDate()))}this._updateTodayButtonState()};p.prototype._dateMatchesVisibleRange=function(){var t=n.fromLocalJSDate(_.getInstance()),e,a,i,r,o;switch(this._iMode){case 0:e=this.getSelectedDates().length?this.getSelectedDates()[0].getStartDate():this.getStartDate();a=e.getDate()===t.getDate();return a&&h._isSameMonthAndYear(n.fromLocalJSDate(this.getStartDate()),t);case 1:return h._isSameMonthAndYear(n.fromLocalJSDate(this.getStartDate()),t);case 2:return h._isSameMonthAndYear(n.fromLocalJSDate(this._getYearPicker().getDate()),t);case 3:i=this._getYearRangePicker();r=i.getDate();o=_.getInstance(r.getFullYear()+i.getRangeSize()/2,r.getMonth(),r.getDate());return h._isSameMonthAndYear(n.fromLocalJSDate(o),t)}};p.prototype._updateTodayButtonState=function(){if(this._oTodayBtn){this._oTodayBtn.setEnabled(!this._dateMatchesVisibleRange())}};p.prototype._updateHeader=function(){};p.prototype.onsapescape=function(){this.fireCancel();this._closePickers();this._oPickerBtn.setVisible(true);this._oPickerBtn.setText(this._formatPickerText())};p.prototype._updateHeadersButtons=function(){};p.prototype._togglePrevNext=function(){};p.prototype._togglePrevNexYearPicker=function(){};p.prototype._initializeSecondMonthHeader=function(){};p.prototype._updateHeadersYearPrimaryText=function(){};p.prototype._updateHeadersYearAdditionalText=function(){};p.prototype._updateActiveHeaderYearButtonVisibility=function(){};p.prototype._setHeaderText=function(){};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/CalendarInCardRenderer", ["sap/ui/core/Renderer","sap/ui/unified/CalendarRenderer"],function(e,t){"use strict";var r=e.extend(t);r.apiVersion=2;r.render=function(e,t){var r=t.getId(),a=t.getTooltip_AsString(),n=t.getAggregation("month"),i=t.getWidth(),o=sap.ui.getCore().getLibraryResourceBundle("sap.f"),s={labelledby:{value:"",append:false}};e.openStart("div",t);e.class("sapUiCal");if(n.length>1){e.class("sapUiCalMulti")}e.accessibilityState(t,s);if(a){e.attr("title",a)}if(i){e.class("sapUiCalWidth");e.style("width",i)}if(t._getSecondaryCalendarType()){e.class("sapUiCalSecType")}e.openEnd();var l=t.getAggregation("header");e.renderControl(l);e.openStart("div",r+"-content");e.class("sapUiCalContent");e.openEnd();switch(t.getProperty("_currentPicker")){case"month":e.renderControl(n[0]);break;case"monthPicker":e.renderControl(t._getMonthPicker());break;case"yearPicker":e.renderControl(t._getYearPicker());break;case"yearRangePicker":e.renderControl(t._getYearRangePicker());break}e.close("div");if(!t._bSkipCancelButtonRendering){e.openStart("button",r+"-cancel");e.class("sapUiCalCancel");e.attr("tabindex","-1");e.openEnd();e.text(o.getText("CALENDAR_CANCEL"));e.close("button")}this.renderCalContentAndArrowsOverlay(e,t,r);e.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/Card", ["sap/f/library","./CardBase","sap/f/CardRenderer"],function(e,r,t){"use strict";var a=e.cards.HeaderPosition;var n=r.extend("sap.f.Card",{metadata:{library:"sap.f",properties:{headerPosition:{type:"sap.f.cards.HeaderPosition",group:"Appearance",defaultValue:a.Top}},aggregations:{header:{type:"sap.f.cards.IHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false}}},renderer:t});n.prototype.getCardHeader=function(){return this.getHeader()};n.prototype.getCardHeaderPosition=function(){return this.getHeaderPosition()};n.prototype.getCardContent=function(){return this.getContent()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/CardBase", ["sap/ui/core/Control","sap/f/library","sap/m/library","sap/ui/core/InvisibleText","sap/ui/core/Core","sap/m/BadgeEnabler","sap/f/CardRenderer"],function(e,t,i,a,r,n,o){"use strict";var s=i.BadgeState;var d=3e3;var p=e.extend("sap.f.CardBase",{metadata:{library:"sap.f",interfaces:["sap.f.ICard","sap.m.IBadge"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"}},aggregations:{}},renderer:o});n.call(p.prototype);p.prototype.init=function(){this._oRb=r.getLibraryResourceBundle("sap.f");this._ariaContentText=new a({id:this.getId()+"-ariaContentText"});this._ariaContentText.setText(this._oRb.getText("ARIA_LABEL_CARD_CONTENT"));this._ariaText=new a({id:this.getId()+"-ariaText"});this._ariaText.setText(this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD"));this.initBadgeEnablement()};p.prototype.exit=function(){this._oRb=null;if(this._ariaContentText){this._ariaContentText.destroy();this._ariaContentText=null}if(this._ariaText){this._ariaText.destroy();this._ariaText=null}};p.prototype.setAggregation=function(t,i){var a;if(t==="header"||t==="_header"){a=this.getAggregation(t);if(a){a.detachEvent("_change",this._onHeaderVisibilityChange,this)}if(i){i.attachEvent("_change",this._onHeaderVisibilityChange,this)}}return e.prototype.setAggregation.apply(this,arguments)};p.prototype._onHeaderVisibilityChange=function(e){if(e.getParameters().name==="visible"){setTimeout(function(){this.invalidate()}.bind(this),0)}};p.prototype.getCardHeader=function(){return null};p.prototype.getCardHeaderPosition=function(){return null};p.prototype.getCardContent=function(){return null};p.prototype.getFocusDomRef=function(){return this.getCardHeader()?this.getCardHeader().getFocusDomRef():this.getDomRef()};p.prototype.onmousedown=function(){this._hideBadge()};p.prototype.onsapenter=function(){this._hideBadge()};p.prototype.onfocusin=function(){this._startBadgeHiding()};p.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),d)};p.prototype._hideBadge=function(){var e=this.getBadgeCustomData();if(e){e.setVisible(false)}this._iHideBadgeTimeout=null};p.prototype.onBadgeUpdate=function(e,t,i){var a=this.getCardHeader(),r,n;if(a){r=a.getFocusDomRef()}else{r=this.getDomRef("contentSection")}if(!r){return}n=r.getAttribute("aria-labelledby")||"";switch(t){case s.Appear:n=i+" "+n;r.setAttribute("aria-labelledby",n);break;case s.Disappear:n=n.replace(i,"").trim();r.setAttribute("aria-labelledby",n);break}};p.prototype.getAriaLabelBadgeText=function(){return this.getBadgeCustomData().getValue()};p.prototype._getAriaLabelledIds=function(){var e=this.getCardHeader();if(e){if(this._isInsideGridContainer()){return e._getAriaLabelledBy()}if(e._getTitle&&e._getTitle()){return e._getTitle().getId()}}return this._ariaText.getId()};p.prototype._isInsideGridContainer=function(){var e=this.getParent();return e&&e.isA("sap.f.GridContainer")};p.prototype.getAriaRoleDescription=function(){var e=this.getCardHeader();if(e){return e.getAriaRoleDescription()}return null};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/CardRenderer", ["sap/ui/core/Renderer","sap/f/library"],function(e,t){"use strict";var r=t.cards.HeaderPosition;var n=e.extend("sap.f.CardRenderer",{apiVersion:2});n.render=function(e,t){var n=t.getCardHeader(),a=n&&t.getCardHeaderPosition()===r.Top;e.openStart("div",t);this.renderContainerAttributes(e,t);e.openEnd();if(a){e.renderControl(n)}this.renderContentSection(e,t);if(!a){e.renderControl(n)}this.renderFooterSection(e,t);e.renderControl(t._ariaText);e.renderControl(t._ariaContentText);e.close("div")};n.renderContainerAttributes=function(e,t){var n=t.getHeight(),a=t.getCardHeader(),i=t.getCardContent(),o=!!(a&&a.getVisible()),d=!!i,s=o&&t.getCardHeaderPosition()===r.Bottom,l=t.getTooltip_AsString();e.class("sapFCard").style("width",t.getWidth());if(!o){e.class("sapFCardNoHeader")}if(!d){e.class("sapFCardNoContent")}if(o&&a.isInteractive&&a.isInteractive()||d&&i.isInteractive&&i.isInteractive()){e.class("sapFCardSectionInteractive")}if(s){e.class("sapFCardBottomHeader")}if(n&&n!=="auto"){e.style("height",n)}if(l){e.attr("title",l)}e.accessibilityState(t,{role:"region",labelledby:{value:t._getAriaLabelledIds(),append:true}})};n.renderContentSection=function(e,t){var r=t.getCardContent();if(r){e.openStart("div",t.getId()+"-contentSection").class("sapFCardContent").accessibilityState(t,{role:"group",labelledby:{value:t.getId()+"-ariaContentText",append:true}}).openEnd();e.renderControl(r);e.close("div")}};n.renderFooterSection=function(e,t){};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/DynamicPage", ["./library","sap/ui/core/Control","sap/ui/core/Core","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/InvisibleText","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/ui/base/ManagedObject","sap/ui/dom/getScrollbarSize","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","./DynamicPageRenderer","sap/base/Log","sap/ui/dom/units/Rem","sap/ui/core/library"],function(e,t,i,r,a,s,n,o,l,d,h,p,_,g,c,u,f,S){"use strict";var H=r.PageBackgroundDesign;var y=t.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},headerPinned:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:H.Standard},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{stickySubheaderProvider:{type:"sap.f.IDynamicPageStickyContent",multiple:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.f.DynamicPageAccessibleLandmarkInfo",multiple:false}},events:{pinnedStateChange:{parameters:{pinned:{type:"boolean"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/DynamicPage.designtime"},renderer:c});function T(e){if(arguments.length===1){return e&&"length"in e?e.length>0:!!e}return Array.prototype.slice.call(arguments).every(function(e){return T(e)})}function A(e){var t;if(!e){return false}t=e.getBoundingClientRect();return!!(t.width&&t.height)}var E=S.AccessibleLandmarkRole;y.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=.6;y.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=.6;y.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE=.3;y.BREAK_POINTS={DESKTOP:1439,TABLET:1024,PHONE:600};y.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};y.MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop",DESKTOP_XL:"sapFDynamicPage-Std-Desktop-XL"};y.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",HEADER:"_sHeaderResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};y.DIV="div";y.HEADER="header";y.FOOTER="footer";y.HEADER_CONTENT_PADDING_BOTTOM=f.toPx("1rem");y.SHOW_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlShow";y.HIDE_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlHide";y.NAVIGATION_CLASS_NAME="sapFDynamicPageNavigation";y.ARIA_ROLE_DESCRIPTION="DYNAMIC_PAGE_ROLE_DESCRIPTION";y.ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS="ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS";y.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._bSuppressToggleHeaderOnce=false;this._headerBiggerThanAllowedHeight=false;this._oStickySubheader=null;this._bStickySubheaderInTitleArea=false;this._bIsLastToggleUserInitiated=false;this._oScrollHelper=new l(this,this.getId()+"-content",{horizontal:false,vertical:true});this._oStickyHeaderObserver=null;this._oHeaderObserver=null;this._oTitleObserver=null;this._oSubHeaderAfterRenderingDelegate={onAfterRendering:function(){this._bStickySubheaderInTitleArea=false;this._cacheDomElements();this._adjustStickyContent()}};this._setAriaRoleDescription(i.getLibraryResourceBundle("sap.f").getText(y.ARIA_ROLE_DESCRIPTION))};y.prototype.onBeforeRendering=function(){if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler()}this._attachTitlePressHandler();this._attachVisualIndicatorsPressHandlers();if(d.system.desktop){this._attachVisualIndicatorMouseOverHandlers();this._attachTitleMouseOverHandlers()}this._attachHeaderObserver();this._attachTitleObserver();this._addStickySubheaderAfterRenderingDelegate();this._detachScrollHandler();this._detachResizeHandlers();this._toggleAdditionalNavigationClass();this._setFooterAriaLabelledBy()};y.prototype.onAfterRendering=function(){var e,t;if(this.getPreserveHeaderStateOnScroll()){setTimeout(this._overridePreserveHeaderStateOnScroll.bind(this),0)}this._cacheDomElements();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateTitlePositioning();this._attachPageChildrenAfterRenderingDelegates();this._updatePinButtonState();this._hidePinButtonIfNotApplicable();if(!this.getHeaderExpanded()){this._snapHeader(false);e=this.getHeader()&&!this.getPreserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();if(e){t=this.$wrapper.scrollTop();this._setScrollPosition(t?t:this._getSnappingHeight())}else{this._toggleHeaderVisibility(false);this._moveHeaderToTitleArea()}}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState()};y.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy()}if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect()}if(this._oHeaderObserver){this._oHeaderObserver.disconnect()}if(this._oTitleObserver){this._oTitleObserver.disconnect()}if(this._oStickySubheader){this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate)}this._destroyInvisibleText()};y.prototype.setShowFooter=function(e){var t=this.setProperty("showFooter",e,true);this._toggleFooter(e);return t};y.prototype.setHeader=function(e){var t=this.getHeader();if(e===t){return this}this._detachHeaderEventListeners();return this.setAggregation("header",e)};y.prototype.destroyHeader=function(){this._detachHeaderEventListeners();return this.destroyAggregation("header")};y.prototype.destroyFooter=function(){this._destroyInvisibleText();return this.destroyAggregation("footer")};y.prototype._detachHeaderEventListeners=function(){var e=this.getHeader();if(e){if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect()}if(this._oHeaderObserver){this._oHeaderObserver.disconnect()}this._deRegisterResizeHandler(y.RESIZE_HANDLER_ID.HEADER);e.detachEvent(y.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress);this._bAlreadyAttachedPinPressHandler=false;e.detachEvent(y.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress);this._bAlreadyAttachedHeaderIndicatorPressHandler=false;e.detachEvent(y.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver);e.detachEvent(y.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=false;this._bAlreadyAttachedStickyHeaderObserver=false;this._bAlreadyAttachedHeaderObserver=false}};y.prototype.setStickySubheaderProvider=function(e){var t,r=this.getStickySubheaderProvider();if(e===r){return this}t=i.byId(r);if(this._oStickySubheader&&t){t._returnStickyContent();t._setStickySubheaderSticked(false);this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=false;this._oStickySubheader=null}this.setAssociation("stickySubheaderProvider",e);return this};y.prototype.setHeaderExpanded=function(e){e=this.validateProperty("headerExpanded",e);if(this._bPinned){return this}if(this.getHeaderExpanded()===e){return this}if(this.getDomRef()){this._titleExpandCollapseWhenAllowed()}this.setProperty("headerExpanded",e,true);this._updatePinButtonState();return this};y.prototype.setToggleHeaderOnTitleClick=function(e){var t=this.getHeaderExpanded(),i=this.setProperty("toggleHeaderOnTitleClick",e,true);e=this.getProperty("toggleHeaderOnTitleClick");this._updateTitleVisualState();this._updateToggleHeaderVisualIndicators();this._updateARIAStates(t);return i};y.prototype.setFitContent=function(e){var t=this.setProperty("fitContent",e,true);if(T(this.$())){this._toggleScrollingStyles()}return t};y.prototype.getScrollDelegate=function(){return this._oScrollHelper};y.prototype._overridePreserveHeaderStateOnScroll=function(){if(this.$().width()===0||this.$().height()===0){return}var e=this._headerBiggerThanAllowedHeight,t;this._headerBiggerThanAllowedHeight=this._headerBiggerThanAllowedToBeFixed();t=e!==this._headerBiggerThanAllowedHeight;if(!this._headerBiggerThanAllowedHeight||!t){return}if(this.getHeaderExpanded()){this._moveHeaderToContentArea()}else{this._adjustSnap()}this._updateTitlePositioning()};y.prototype._toggleFooter=function(e){var t=this.getFooter(),r,a;if(!T(this.$())||!T(t)||!T(this.$footerWrapper)){return}a=i.getConfiguration().getAnimationMode();r=a!==n.AnimationMode.none&&a!==n.AnimationMode.minimal;if(T(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",e)}this.$().toggleClass("sapFDynamicPageFooterVisible",e);if(r){this._toggleFooterAnimation(e,t)}else{this.$footerWrapper.toggleClass("sapUiHidden",!e)}this._updateTitlePositioning()};y.prototype._toggleFooterAnimation=function(e,t){this.$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,t));if(e){this.$footerWrapper.removeClass("sapUiHidden")}t.toggleStyleClass(y.SHOW_FOOTER_CLASS_NAME,e);t.toggleStyleClass(y.HIDE_FOOTER_CLASS_NAME,!e)};y.prototype._onToggleFooterAnimationEnd=function(e){this.$footerWrapper.off("webkitAnimationEnd animationend");if(e.hasStyleClass(y.HIDE_FOOTER_CLASS_NAME)){this.$footerWrapper.addClass("sapUiHidden");e.removeStyleClass(y.HIDE_FOOTER_CLASS_NAME)}else{e.removeStyleClass(y.SHOW_FOOTER_CLASS_NAME)}};y.prototype._toggleHeaderInTabChain=function(e){var t=this.getTitle(),i=this.getHeader();if(!T(t)||!T(i)){return}i.$().css("visibility",e?"visible":"hidden");i.$().css("height",e?"":this._getHeaderHeight()+"px");i.$().css("overflow",e?"":"hidden")};y.prototype._snapHeader=function(e,t){var i=this.getTitle();if(this._bPinned&&!t){u.debug("DynamicPage :: aborted snapping, header is pinned",this);return}u.debug("DynamicPage :: snapped header",this);if(this._bPinned&&t){this._unPin(t);this._togglePinButtonPressedState(false)}if(T(i)){i._toggleState(false,t);if(e&&this._bHeaderInTitleArea){this._moveHeaderToContentArea(true)}}if(!T(this.$titleArea)){u.warning("DynamicPage :: couldn't snap header. There's no title.",this);return}this.setProperty("headerExpanded",false,true);this._bIsLastToggleUserInitiated=!!t;this._adjustStickyContent();if(this._hasVisibleTitleAndHeader()){this.$titleArea.addClass(d.system.phone&&i.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();this._togglePinButtonVisibility(false);this._updateTitlePositioning()}this._toggleHeaderInTabChain(false);this._updateARIAStates(false);this._toggleHeaderBackground(true)};y.prototype._expandHeader=function(e,t){var i=this.getTitle();u.debug("DynamicPage :: expand header",this);if(T(i)){i._toggleState(true,t);if(e){this._moveHeaderToTitleArea(true)}}if(!T(this.$titleArea)){u.warning("DynamicPage :: couldn't expand header. There's no title.",this);return}this.setProperty("headerExpanded",true,true);this._bIsLastToggleUserInitiated=!!t;this._adjustStickyContent();if(this._hasVisibleTitleAndHeader()){this.$titleArea.removeClass(d.system.phone&&i.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();if(!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToPin()){this._togglePinButtonVisibility(true)}this._updateTitlePositioning()}this._toggleHeaderInTabChain(true);this._updateARIAStates(true);this._toggleHeaderBackground(false)};y.prototype._toggleHeaderVisibility=function(e,t){var i=this.getHeaderExpanded(),r=this.getTitle(),a=this.getHeader();if(this._bPinned&&!t){u.debug("DynamicPage :: header toggle aborted, header is pinned",this);return}if(T(r)){r._toggleState(i)}if(T(a)){a.$().toggleClass("sapFDynamicPageHeaderHidden",!e);this._updateTitlePositioning()}};y.prototype._toggleHeaderBackground=function(e){this.$headerInContentWrapper.toggleClass("sapFDynamicPageHeaderSolid",e)};y.prototype._moveHeaderToContentArea=function(e){var t=this.getHeader();if(T(t)){t.$().prependTo(this.$headerInContentWrapper);this._bHeaderInTitleArea=false;if(e){this._offsetContentOnMoveHeader()}this.fireEvent("_moveHeader")}};y.prototype._moveHeaderToTitleArea=function(e){var t=this.getHeader();if(T(t)){t.$().prependTo(this.$stickyPlaceholder);this._bHeaderInTitleArea=true;if(e){this._offsetContentOnMoveHeader()}this.fireEvent("_moveHeader")}};y.prototype._offsetContentOnMoveHeader=function(){var e=Math.ceil(this._getHeaderHeight()),t=this.$wrapper.scrollTop(),i;if(!e){return}i=this._bHeaderInTitleArea?t-e:t+e;i=Math.max(i,0);this._setScrollPosition(i,true)};y.prototype._isHeaderPinnable=function(){var e=this.getHeader();return e&&e.getPinnable()&&this.getHeaderExpanded()&&!this.getPreserveHeaderStateOnScroll()};y.prototype._updatePinButtonState=function(){var e=this.getHeaderPinned()&&this._isHeaderPinnable();this._togglePinButtonPressedState(e);if(e){this._pin()}else{this._unPin()}};y.prototype._pin=function(e){if(this._bPinned){return}this._bPinned=true;if(e){this.setProperty("headerPinned",true,true);this.fireEvent("pinnedStateChange",{pinned:true})}if(!this._bHeaderInTitleArea){this._moveHeaderToTitleArea(true);this._updateTitlePositioning()}this._updateToggleHeaderVisualIndicators();this.addStyleClass("sapFDynamicPageHeaderPinned")};y.prototype._unPin=function(e){if(!this._bPinned){return}this._bPinned=false;if(e){this.setProperty("headerPinned",false,true);this.fireEvent("pinnedStateChange",{pinned:false})}this._updateToggleHeaderVisualIndicators();this.removeStyleClass("sapFDynamicPageHeaderPinned")};y.prototype._togglePinButtonVisibility=function(e){var t=this.getHeader();if(T(t)){t._setShowPinBtn(e)}};y.prototype._togglePinButtonPressedState=function(e){var t=this.getHeader();if(T(t)){t._togglePinButton(e)}};y.prototype._hidePinButtonIfNotApplicable=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false)}};y.prototype._isHeaderPinnable=function(){var e=this.getHeader();return e&&e.getPinnable()&&this.getHeaderExpanded()&&!this.getPreserveHeaderStateOnScroll()};y.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton()};y.prototype._getScrollPosition=function(){return T(this.$wrapper)?Math.ceil(this.$wrapper.scrollTop()):0};y.prototype._setAriaRoleDescription=function(e){this._sAriaRoleDescription=e;return this};y.prototype._getAriaRoleDescription=function(){return this._sAriaRoleDescription};y.prototype._setScrollPosition=function(e,t){if(!T(this.$wrapper)){return}if(this._getScrollPosition()===e){return}if(t){this._bSuppressToggleHeaderOnce=true}if(!this.getScrollDelegate()._$Container){this.getScrollDelegate()._$Container=this.$wrapper}this.getScrollDelegate().scrollTo(0,e)};y.prototype._shouldSnapOnScroll=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>=this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned};y.prototype._shouldExpandOnScroll=function(){var e=this._needsVerticalScrollBar(),t=this._getScrollPosition(),i=t===0||t<this._getSnappingHeight();return!this._preserveHeaderStateOnScroll()&&i&&!this.getHeaderExpanded()&&!this._bPinned&&e};y.prototype._shouldStickStickyContent=function(){return!this.getHeaderExpanded()||this._preserveHeaderStateOnScroll()||this._bHeaderInTitleArea};y.prototype._headerScrolledOut=function(){return this._getScrollPosition()>=this._getSnappingHeight()};y.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned};y.prototype._canSnapHeaderOnScroll=function(){return this._getMaxScrollPosition()>this._getSnappingHeight()};y.prototype._getSnappingHeight=function(){var e=this.getTitle(),t=e&&e.$expandWrapper,i=e&&e.$snappedWrapper,r=e&&e.$expandHeadingWrapper,a=e&&e.$snappedHeadingWrapper,s=t&&t.length?t.height():0,n=a&&a.length?a.height():0,o=r&&r.length?r.height():0,l=i&&i.length?i.height():0,d=Math.ceil(this._getHeaderHeight()||s+l+n+o)-y.HEADER_CONTENT_PADDING_BOTTOM;return d>0?d:0};y.prototype._getMaxScrollPosition=function(){var e,t;if(T(this.$wrapper)){e=this.$wrapper[0];t=Math.max(e.clientHeight,Math.ceil(e.getBoundingClientRect().height));return e.scrollHeight-t}return 0};y.prototype._needsVerticalScrollBar=function(){return Math.floor(this._getMaxScrollPosition())>1};y.prototype._getOwnHeight=function(){return this._getHeight(this)};y.prototype._getEntireHeaderHeight=function(){var e=0,t=0,i=this.getTitle(),r=this.getHeader();if(T(i)){e=i.$().outerHeight()}if(T(r)){t=r.$().outerHeight()}return e+t};y.prototype._headerBiggerThanAllowedToPin=function(e){if(!(typeof e==="number"&&!isNaN(parseInt(e)))){e=this._getOwnHeight()}return this._getEntireHeaderHeight()>y.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*e};y.prototype._headerBiggerThanAllowedToBeFixed=function(){var e=this._getOwnHeight();return this._getEntireHeaderHeight()>y.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*e};y.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){var e=this._getEntireHeaderHeight(),t=this._getOwnHeight();if(t===0){return false}return d.system.phone?e>=y.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE*t:e>=t};y.prototype._updateTitlePositioning=function(){if(!T(this.$wrapper)||!T(this.$titleArea)||this._getHeight(this)===0){return}var e=this._needsVerticalScrollBar(),t=this.$wrapper.get(0),r=this.$titleArea.get(0).getBoundingClientRect().height,a=this._getTitleAreaWidth(),s=p().width,n;t.style.paddingTop=r+"px";t.style.scrollPaddingTop=r+"px";this._oScrollHelper.setScrollPaddingTop(r);n="polygon(0px "+Math.floor(r)+"px, "+a+"px "+Math.floor(r)+"px, "+a+"px 0, 100% 0, 100% 100%, 0 100%)";if(i.getConfiguration().getRTL()){n="polygon(0px 0px, "+s+"px 0px, "+s+"px "+r+"px, 100% "+r+"px, 100% 100%, 0 100%)"}t.style.clipPath=n;this.toggleStyleClass("sapFDynamicPageWithScroll",e);setTimeout(this._toggleScrollingStyles.bind(this),0)};y.prototype._toggleScrollingStyles=function(e){var t=typeof e!=="undefined"?!e:!this._needsVerticalScrollBar();this.toggleStyleClass("sapFDynamicPageWithScroll",!t);this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t)};y.prototype._updateHeaderARIAState=function(e){var t=this.getHeader();if(T(t)){t._updateARIAState(e)}};y.prototype._updateTitleARIAState=function(e){var t=this.getTitle();if(T(t)){t._updateARIAState(e)}};y.prototype._updateARIAStates=function(e){this._updateHeaderARIAState(e);this._updateTitleARIAState(e)};y.prototype._applyContextualSettings=function(e){var t=e.contextualWidth;this._updateMedia(t);return h.prototype._applyContextualSettings.call(this,e)};y.prototype._updateMedia=function(e){if(!e){return}if(e<=y.BREAK_POINTS.PHONE){this._updateMediaStyle(y.MEDIA.PHONE)}else if(e<=y.BREAK_POINTS.TABLET){this._updateMediaStyle(y.MEDIA.TABLET)}else if(e<=y.BREAK_POINTS.DESKTOP){this._updateMediaStyle(y.MEDIA.DESKTOP)}else{this._updateMediaStyle(y.MEDIA.DESKTOP_XL)}};y.prototype._updateMediaStyle=function(e){Object.keys(y.MEDIA).forEach(function(t){var i=e===y.MEDIA[t];this.toggleStyleClass(y.MEDIA[t],i)},this)};y.prototype._toggleExpandVisualIndicator=function(e){var t=this.getTitle();if(T(t)){t._toggleExpandButton(e)}};y.prototype._focusExpandVisualIndicator=function(){var e=this.getTitle();if(T(e)){e._focusExpandButton()}};y.prototype._toggleCollapseVisualIndicator=function(e){var t=this.getHeader();if(T(t)){t._toggleCollapseButton(e)}};y.prototype._focusCollapseVisualIndicator=function(){var e=this.getHeader();if(T(e)){e._focusCollapseButton()}};y.prototype._updateToggleHeaderVisualIndicators=function(){var e,t,i,r=this._hasVisibleTitleAndHeader(),a=this.getHeader(),s=false;if(T(a)){s=!!a.getContent().length}if(!this.getToggleHeaderOnTitleClick()||!r){t=false;i=false}else{e=this.getHeaderExpanded();t=e;i=d.system.phone&&this.getTitle().getAggregation("snappedTitleOnMobile")?false:!e}i=i&&s;t=t&&s;this._toggleCollapseVisualIndicator(t);this._toggleExpandVisualIndicator(i);this._updateTitleVisualState()};y.prototype._updateHeaderVisualState=function(e,t){var i=this.getHeader();if(e&&this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll()}if(!this._preserveHeaderStateOnScroll()&&i){if(this._headerBiggerThanAllowedToPin(t)||d.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false)}else{this._togglePinButtonVisibility(true);this._updatePinButtonState()}if(this.getHeaderExpanded()&&this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._setScrollPosition(0)}}else if(this._preserveHeaderStateOnScroll()&&i){this._togglePinButtonVisibility(false)}};y.prototype._updateTitleVisualState=function(){var e=this.getTitle(),t=this._hasVisibleTitleAndHeader()&&this.getToggleHeaderOnTitleClick();this.$().toggleClass("sapFDynamicPageTitleClickEnabled",t&&!d.system.phone);if(T(e)){e._toggleFocusableState(t)}};y.prototype._scrollBellowCollapseVisualIndicator=function(){var e=this.getHeader(),t,i,r,a;if(T(e)){t=this.getHeader()._getCollapseButton().getDomRef();i=t.getBoundingClientRect().height;r=this.$wrapper[0].getBoundingClientRect().height;a=t.offsetTop+i-r+this._getTitleHeight();this._setScrollPosition(a)}};y.prototype._hasVisibleTitleAndHeader=function(){var e=this.getTitle();return T(e)&&e.getVisible()&&this._hasVisibleHeader()};y.prototype._hasVisibleHeader=function(){var e=this.getHeader();return T(e)&&e.getVisible()&&T(e.getContent())};y.prototype._getHeight=function(e){var i;if(!(e instanceof t)){return 0}i=e.getDomRef();return i?i.getBoundingClientRect().height:0};y.prototype._getWidth=function(e){return!(e instanceof t)?0:e.$().outerWidth()||0};y.prototype._getTitleAreaHeight=function(){return T(this.$titleArea)?this.$titleArea.outerHeight()||0:0};y.prototype._getTitleAreaWidth=function(){return T(this.$titleArea)?this.$titleArea.width()||0:0};y.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle())};y.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader())};y.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight};y.prototype._cacheDomElements=function(){var e=this.getFooter();if(T(e)){this.$footer=e.$();this.$footerWrapper=this.$("footerWrapper")}this.$wrapper=this.$("contentWrapper");this.$headerInContentWrapper=this.$("headerWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this.$stickyPlaceholder=this.$("stickyPlaceholder");this._cacheTitleDom();this._cacheHeaderDom()};y.prototype._cacheTitleDom=function(){var e=this.getTitle();if(T(e)){this.$title=e.$()}};y.prototype._cacheHeaderDom=function(){var e=this.getHeader();if(T(e)){this.$header=e.$()}};y.prototype._adjustSnap=function(){var e,t,i,r,a,s,n=this.$();if(!T(n)){return}if(!A(n[0])){return}e=this.getHeader();t=!this.getHeaderExpanded();if(!e||!t){return}i=!this._preserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();r=t&&e.$().hasClass("sapFDynamicPageHeaderHidden");if(i&&r){this._toggleHeaderVisibility(true);this._moveHeaderToContentArea(true);return}if(!i&&!r){this._moveHeaderToTitleArea(true);this._toggleHeaderVisibility(false);return}if(i){a=this._getScrollPosition();s=this._getSnappingHeight();if(a<s){this._setScrollPosition(s)}}};y.prototype.ontouchmove=function(e){e.setMarked()};y.prototype._onChildControlAfterRendering=function(e){var t=e.srcControl;if(t instanceof _){this._cacheTitleDom();this._deRegisterResizeHandler(y.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(y.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this))}else if(t instanceof g&&t.getDomRef()!==this.$header.get(0)){this._cacheHeaderDom();this._deRegisterResizeHandler(y.RESIZE_HANDLER_ID.HEADER);this._registerResizeHandler(y.RESIZE_HANDLER_ID.HEADER,this.$header[0],this._onChildControlsHeightChange.bind(this))}setTimeout(this._updateTitlePositioning.bind(this),0)};y.prototype._onChildControlsHeightChange=function(e){var t=this._needsVerticalScrollBar(),i=this.getHeader(),r,a;if(t){this._toggleScrollingStyles(t)}this._adjustSnap();if(!this._bExpandingWithAClick){this._updateTitlePositioning()}this._bExpandingWithAClick=false;if(i&&e.target.id===i.getId()){r=e.size.height;a=e.oldSize.height;this._updateHeaderVisualState(r!==a);this._adaptScrollPositionOnHeaderChange(r,a)}};y.prototype._onResize=function(e){var t=this.getTitle(),i=e.size.width,r=e.size.height,a=r!==e.oldSize.height;this._updateHeaderVisualState(a,r);if(T(t)){t._onResize(i)}if(this._shouldAutoExpandHeaderOnResize(e)){this._expandHeader(true,false)}this._adjustSnap();this._updateTitlePositioning();this._updateMedia(i)};y.prototype._shouldAutoExpandHeaderOnResize=function(e){var t=this.getHeader(),i=T(t)&&!this.getHeaderExpanded()&&this._bIsLastToggleUserInitiated,r=e.target===this.getDomRef(),a=this._canSnapHeaderOnScroll.bind(this);return!this._preserveHeaderStateOnScroll()&&i&&r&&!this.getToggleHeaderOnTitleClick()&&!a()};y.prototype._toggleHeaderOnScroll=function(){if(this._bSuppressToggleHeaderOnce){this._bSuppressToggleHeaderOnce=false;return}if(d.system.desktop&&this._bExpandingWithAClick){return}if(this._preserveHeaderStateOnScroll()){return}if(this._shouldSnapOnScroll()){this._snapHeader(true,true)}else if(this._shouldExpandOnScroll()){this._expandHeader(false,true);this._toggleHeaderVisibility(true)}else if(!this._bPinned&&this._bHeaderInTitleArea){var e=this._getScrollPosition()>=this._getSnappingHeight();this._moveHeaderToContentArea(e);this._adjustStickyContent();this._updateTitlePositioning()}};y.prototype._adjustStickyContent=function(){if(!this._oStickySubheader){return}var e,t=this._shouldStickStickyContent(),r,a=this.getStickySubheaderProvider();if(t===this._bStickySubheaderInTitleArea){return}r=i.byId(a);if(!T(r)){return}e=document.activeElement;r._setStickySubheaderSticked(t);if(t){this._oStickySubheader.$().appendTo(this.$stickyPlaceholder)}else{r._returnStickyContent()}e.focus();this._bStickySubheaderInTitleArea=t};y.prototype._adaptScrollPositionOnHeaderChange=function(e,t){var i=e-t,r=this.getHeader();if(i&&(!this.getHeaderExpanded()&&r.$().css("visibility")!=="hidden")&&!this._bHeaderInTitleArea&&this._needsVerticalScrollBar()){this._setScrollPosition(this._getScrollPosition()+i)}};y.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()&&this._hasVisibleTitleAndHeader()){if(!this.getHeaderExpanded()&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&!this._preserveHeaderStateOnScroll()){this._moveHeaderToContentArea(true)}this._titleExpandCollapseWhenAllowed(true);this.getTitle()._focus()}};y.prototype._onExpandHeaderVisualIndicatorPress=function(){this._onTitlePress();if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBellowCollapseVisualIndicator()}this._focusCollapseVisualIndicator()};y.prototype._onCollapseHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusExpandVisualIndicator()};y.prototype._onVisualIndicatorMouseOver=function(){var e=this.$();if(T(e)){e.addClass("sapFDynamicPageTitleForceHovered")}};y.prototype._onVisualIndicatorMouseOut=function(){var e=this.$();if(T(e)){e.removeClass("sapFDynamicPageTitleForceHovered")}};y.prototype._onTitleMouseOver=y.prototype._onVisualIndicatorMouseOver;y.prototype._onTitleMouseOut=y.prototype._onVisualIndicatorMouseOut;y.prototype._titleExpandCollapseWhenAllowed=function(e){var t,i;if(this._bPinned&&!e){return this}if(this._preserveHeaderStateOnScroll()||!this._canSnapHeaderOnScroll()||!this.getHeader()){if(!this.getHeaderExpanded()){this._expandHeader(false,e);this._toggleHeaderVisibility(true,e)}else{this._snapHeader(false,e);this._toggleHeaderVisibility(false,e)}}else if(!this.getHeaderExpanded()){t=!this._headerBiggerThanAllowedToBeExpandedInTitleArea();this._bExpandingWithAClick=true;this._expandHeader(t,e);this.getHeader().$().removeClass("sapFDynamicPageHeaderHidden");if(!t){this._setScrollPosition(0)}this._bExpandingWithAClick=false}else{var r=this._bHeaderInTitleArea;this._snapHeader(r,e);if(!r){i=this._getSnappingHeight();this._setScrollPosition(i?i+y.HEADER_CONTENT_PADDING_BOTTOM:0)}}};y.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin(true)}else{this._pin(true);this._restorePinButtonFocus()}};y.prototype._attachResizeHandlers=function(){var e=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(y.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(T(this.$title)){this._registerResizeHandler(y.RESIZE_HANDLER_ID.TITLE,this.$title[0],e)}if(T(this.$header)){this._registerResizeHandler(y.RESIZE_HANDLER_ID.HEADER,this.$header[0],e)}if(T(this.$contentFitContainer)){this._registerResizeHandler(y.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],e)}};y.prototype._registerResizeHandler=function(e,t,i){if(!this[e]){this[e]=s.register(t,i)}};y.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(y.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(y.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(y.RESIZE_HANDLER_ID.HEADER);this._deRegisterResizeHandler(y.RESIZE_HANDLER_ID.CONTENT)};y.prototype._deRegisterResizeHandler=function(e){if(this[e]){s.deregister(this[e]);this[e]=null}};y.prototype._attachPageChildrenAfterRenderingDelegates=function(){var e=this.getTitle(),t=this.getHeader(),i=this.getContent(),r=this._onChildControlAfterRendering.bind(this),a={onAfterRendering:r};if(T(e)){e.addEventDelegate(a)}if(T(i)){i.addEventDelegate(a)}if(T(t)){t.addEventDelegate(a)}};y.prototype._attachTitlePressHandler=function(){var e=this.getTitle();if(T(e)&&!this._bAlreadyAttachedTitlePressHandler){e.attachEvent(y.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true}};y.prototype._attachPinPressHandler=function(){var e=this.getHeader();if(T(e)&&!this._bAlreadyAttachedPinPressHandler){e.attachEvent(y.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true}};y.prototype._attachStickyHeaderObserver=function(){var e=this.getHeader();if(T(e)&&!this._bAlreadyAttachedStickyHeaderObserver){if(!this._oStickyHeaderObserver){this._oStickyHeaderObserver=new a(this._onHeaderPropertyChange.bind(this))}this._oStickyHeaderObserver.observe(e,{properties:["visible"]});this._bAlreadyAttachedStickyHeaderObserver=true}};y.prototype._onHeaderPropertyChange=function(e){var t=this.getHeader();this._adjustStickyContent();if(t&&e.name==="visible"&&e.current===false){t.invalidate();this._updateTitlePositioning()}};y.prototype._attachHeaderObserver=function(){var e=this.getHeader();if(T(e)&&!this._bAlreadyAttachedHeaderObserver){if(!this._oHeaderObserver){this._oHeaderObserver=new a(this._onHeaderFieldChange.bind(this))}this._oHeaderObserver.observe(e,{aggregations:["content"],properties:["visible","pinnable"]});this._bAlreadyAttachedHeaderObserver=true}};y.prototype._attachTitleObserver=function(){var e=this.getTitle();if(T(e)&&!this._bAlreadyAttachedTitleObserver){if(!this._oTitleObserver){this._oTitleObserver=new a(this._onTitleFieldChange.bind(this))}this._oTitleObserver.observe(e,{properties:["visible"]});this._bAlreadyAttachedTitleObserver=true}};y.prototype._onHeaderFieldChange=function(e){if(e.type==="property"&&e.name==="pinnable"){this._updatePinButtonState();return}this._updateToggleHeaderVisualIndicators()};y.prototype._onTitleFieldChange=function(e){if(e.type==="property"&&e.name==="visible"){this.invalidate();return}};y.prototype._attachVisualIndicatorsPressHandlers=function(){var e=this.getTitle(),t=this.getHeader();if(T(e)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){e.attachEvent(y.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,this._onExpandHeaderVisualIndicatorPress,this);this._bAlreadyAttachedTitleIndicatorPressHandler=true}if(T(t)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){t.attachEvent(y.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress,this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true}};y.prototype._addStickySubheaderAfterRenderingDelegate=function(){var e,t=this.getStickySubheaderProvider(),r;e=i.byId(t);if(T(e)&&!this._bAlreadyAddedStickySubheaderAfterRenderingDelegate){r=e.getMetadata().getInterfaces().indexOf("sap.f.IDynamicPageStickyContent")!==-1;if(r){this._oStickySubheader=e._getStickyContent();this._oStickySubheader.addEventDelegate(this._oSubHeaderAfterRenderingDelegate,this);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=true;this._attachStickyHeaderObserver()}}};y.prototype._attachVisualIndicatorMouseOverHandlers=function(){var e=this.getHeader();if(T(e)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){e.attachEvent(y.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver,this);e.attachEvent(y.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut,this);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true}};y.prototype._attachTitleMouseOverHandlers=function(){var e=this.getTitle();if(T(e)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){e.attachEvent(y.EVENTS.TITLE_MOUSE_OVER,this._onTitleMouseOver,this);e.attachEvent(y.EVENTS.TITLE_MOUSE_OUT,this._onTitleMouseOut,this);this._bAlreadyAttachedTitleMouseOverOutHandler=true}};y.prototype._attachScrollHandler=function(){this._toggleHeaderOnScrollReference=this._toggleHeaderOnScroll.bind(this);this.$wrapper.on("scroll",this._toggleHeaderOnScrollReference)};y.prototype._toggleAdditionalNavigationClass=function(){var e=this._bStickySubheaderProviderExists();this.toggleStyleClass(y.NAVIGATION_CLASS_NAME,e)};y.prototype._bStickySubheaderProviderExists=function(){var e=i.byId(this.getStickySubheaderProvider());return!!e&&e.isA("sap.f.IDynamicPageStickyContent")};y.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.off("scroll",this._toggleHeaderOnScrollReference)}};y.prototype._formatLandmarkInfo=function(e,t){if(e){var i=e["get"+t+"Role"]()||"",r=e["get"+t+"Label"]()||"";if(i===E.None){i=""}return{role:i.toLowerCase(),label:r}}return{}};y.prototype._getHeaderTag=function(e){if(e&&e.getHeaderRole()!==E.None){return y.DIV}return y.HEADER};y.prototype._getFooterTag=function(e){if(e&&e.getFooterRole()!==E.None){return y.DIV}return y.FOOTER};y.prototype._setFooterAriaLabelledBy=function(){var e=this.getFooter();if(e&&!e.getAriaLabelledBy().length){this._oInvisibleText=new o({id:e.getId()+"-FooterActions-InvisibleText",text:i.getLibraryResourceBundle("sap.f").getText(y.ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS)}).toStatic();e.addAriaLabelledBy(this._oInvisibleText)}};y.prototype._destroyInvisibleText=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/DynamicPageAccessibleLandmarkInfo", ["sap/ui/core/Element","./library"],function(e,a){"use strict";var l=e.extend("sap.f.DynamicPageAccessibleLandmarkInfo",{metadata:{library:"sap.f",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},contentLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},headerLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},footerLabel:{type:"string",defaultValue:null}}}});return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/DynamicPageHeader", ["./library","sap/ui/Device","sap/ui/core/Control","sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/theming/Parameters","sap/m/ToggleButton","sap/m/Button","./DynamicPageHeaderRenderer","sap/ui/core/InvisibleMessage"],function(t,e,n,o,i,s,a,r,u,p){"use strict";var l=o.InvisibleMessageMode;var g=n.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_collapseButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPageHeader.designtime"},renderer:u});g._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f")};g.UNPRESSED_PIN_ICON="sap-icon://pushpin-off";g.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_LABEL:"aria-label",LABEL_EXPANDED:g._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_COLLAPSED:g._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:g._getResourceBundle().getText("PIN_HEADER"),TOOLTIP_COLLAPSE_BUTTON:g._getResourceBundle().getText("COLLAPSE_HEADER_BUTTON_TOOLTIP"),STATE_TRUE:"true",STATE_FALSE:"false"};g.prototype.init=function(){this._bShowCollapseButton=true;this._oInvisibleMessage=null};g.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();if(!this._oInvisibleMessage){this._oInvisibleMessage=p.getInstance()}if(this.getPinnable()){this._setPressedStatePinIcon()}};g.prototype._togglePinButton=function(t){this._getPinButton().setPressed(t);this._getPinButton().setIcon(t?this._sPressedStatePinIconURI:g.UNPRESSED_PIN_ICON)};g.prototype._setShowPinBtn=function(t){this._getPinButton().$().toggleClass("sapUiHidden",!t)};g.prototype._pinUnpinFireEvent=function(t){this.fireEvent("_pinUnpinPress");this._togglePinButton(t.getSource().getPressed())};g.prototype._onCollapseButtonPress=function(){this.fireEvent("_headerVisualIndicatorPress")};g.prototype._onCollapseButtonMouseOver=function(){this.fireEvent("_visualIndicatorMouseOver")};g.prototype._onCollapseButtonMouseOut=function(){this.fireEvent("_visualIndicatorMouseOut")};g.prototype._initARIAState=function(){var t=this.$();t.attr(g.ARIA.ARIA_LABEL,g.ARIA.LABEL_EXPANDED)};g.prototype._initPinButtonARIAState=function(){var t;if(this.getPinnable()){t=this._getPinButtonJQueryRef();t.attr(g.ARIA.ARIA_CONTROLS,this.getId())}};g.prototype._updateARIAState=function(t){var e=this.$();if(t){e.attr(g.ARIA.ARIA_LABEL,g.ARIA.LABEL_EXPANDED)}else{e.attr(g.ARIA.ARIA_LABEL,g.ARIA.LABEL_COLLAPSED)}};g.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var t=new a({id:this.getId()+"-pinBtn",icon:g.UNPRESSED_PIN_ICON,tooltip:g.ARIA.LABEL_PINNED,press:this._pinUnpinFireEvent.bind(this)}).addStyleClass("sapFDynamicPageHeaderPinButton");this.setAggregation("_pinButton",t,true)}return this.getAggregation("_pinButton")};g.prototype._getCollapseButton=function(){if(!this.getAggregation("_collapseButton")){var t=new r({id:this.getId()+"-collapseBtn",icon:"sap-icon://slim-arrow-up",press:this._onCollapseButtonPress.bind(this),tooltip:g.ARIA.TOOLTIP_COLLAPSE_BUTTON}).addStyleClass("sapFDynamicPageToggleHeaderIndicator");t.onmouseover=this._onCollapseButtonMouseOver.bind(this);t.onmouseout=this._onCollapseButtonMouseOut.bind(this);this.setAggregation("_collapseButton",t,true)}return this.getAggregation("_collapseButton")};g.prototype._toggleCollapseButton=function(t){this._setShowCollapseButton(t);this._getCollapseButton().toggleStyleClass("sapUiHidden",!t)};g.prototype._getShowCollapseButton=function(){return this._bShowCollapseButton&&!!this.getContent().length};g.prototype._setShowCollapseButton=function(t){this._bShowCollapseButton=!!t};g.prototype._focusCollapseButton=function(){var t=g._getResourceBundle().getText("EXPANDED_HEADER");this._getCollapseButton().$().trigger("focus");this._oInvisibleMessage.announce(t,l.Polite)};g.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().trigger("focus")};g.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$()};g.prototype._getState=function(){var t=this.getContent(),n=t.length>0,o=this.getPinnable()&&n&&!e.system.phone,i=this._getPinButton(),s=this._getCollapseButton();s.toggleStyleClass("sapUiHidden",!this._getShowCollapseButton());return{content:t,headerHasContent:n,headerPinnable:o,hasContent:t.length>0,pinButton:i,collapseButton:s}};g.prototype.onThemeChanged=function(){this._setPressedStatePinIcon()};g.prototype._setPressedStatePinIcon=function(){this._sPressedStatePinIconURI=i.getIconURI(s.get({name:"_sap_f_DynamicPageHeader_PinButton_Icon"}))};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/DynamicPageHeaderRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,n){var a=n._getState(),t="sapFDynamicPageHeader",r=n.getBackgroundDesign();e.openStart("section",n);e.accessibilityState({role:"region"});e.class("sapContrastPlus");e.class(t);if(a.headerHasContent){e.class("sapFDynamicPageHeaderWithContent")}if(a.headerPinnable){e.class("sapFDynamicPageHeaderPinnable")}if(r){e.class(t+r)}e.openEnd();this._renderHeaderContent(e,a);e.renderControl(a.collapseButton);if(a.headerPinnable){e.renderControl(a.pinButton)}e.close("section")};e._renderHeaderContent=function(e,n){if(n.headerHasContent){e.openStart("div");e.class("sapFDynamicPageHeaderContent");e.openEnd();n.content.forEach(e.renderControl,e);e.close("div")}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/DynamicPageRenderer", ["sap/ui/Device"],function(e){"use strict";var a={apiVersion:2};a.render=function(t,n){var o=n.getTitle(),r=n.getHeader(),i=n.getFooter(),s=n.getContent(),c=n.getHeaderExpanded(),l=r?r.getContent():[],p=l.length>0,d=n.getShowFooter(),g=n._preserveHeaderStateOnScroll(),F=g||n._bHeaderInTitleArea,f=n.getLandmarkInfo(),m=n._getHeaderTag(f),C=n._getFooterTag(f);t.openStart("article",n);t.class("sapFDynamicPage");if(n.getToggleHeaderOnTitleClick()){t.class("sapFDynamicPageTitleClickEnabled")}if(i&&d){t.class("sapFDynamicPageFooterVisible")}t.attr("aria-roledescription",n._getAriaRoleDescription());t.accessibilityState(n,n._formatLandmarkInfo(f,"Root"));t.openEnd();t.openStart(m,n.getId()+"-header");t.class("sapContrastPlus");t.class("sapFDynamicPageTitleWrapper");if(!c){t.class(e.system.phone&&o&&o.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped")}if(!p){t.class("sapFDynamicPageTitleOnly")}t.accessibilityState(n,n._formatLandmarkInfo(f,"Header"));t.attr("data-sap-ui-customfastnavgroup",true);t.openEnd();t.renderControl(o);t.openStart("div",n.getId()+"-stickyPlaceholder");t.openEnd();if(F){t.renderControl(r)}t.close("div");t.close(m);t.openStart("div",n.getId()+"-contentWrapper");t.class("sapFDynamicPageContentWrapper");if(n.getBackgroundDesign()){t.class("sapFDynamicPageContentWrapper"+n.getBackgroundDesign())}t.openEnd();t.openStart("div",n.getId()+"-headerWrapper");t.class("sapFDynamicPageHeaderWrapper");t.openEnd();if(!F){t.renderControl(r)}t.close("div");t.openStart("div",n.getId()+"-content");t.class("sapFDynamicPageContent");t.accessibilityState(n,n._formatLandmarkInfo(f,"Content"));t.openEnd();t.openStart("div",n.getId()+"-contentFitContainer");if(n.getFitContent()){t.class("sapFDynamicPageContentFitContainer")}if(i&&d){t.class("sapFDynamicPageContentFitContainerFooterVisible")}t.openEnd();t.renderControl(s);t.close("div");t.close("div");t.close("div");a.renderFooter(t,n,i,d,C,f);t.close("article")};a.renderFooter=function(e,a,t,n,o,r){if(t){e.openStart(o,a.getId()+"-footerWrapper");e.class("sapContrast").class("sapContrastPlus").class("sapFDynamicPageFooter").class("sapMFooter-CTX");if(!n){e.class("sapUiHidden")}e.accessibilityState(a,a._formatLandmarkInfo(r,"Footer"));e.openEnd();t.addStyleClass("sapFDynamicPageActualFooterControl");e.renderControl(t);e.close(o)}};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/DynamicPageTitle", ["./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSeparator","sap/m/OverflowToolbar","sap/m/Button","sap/ui/core/InvisibleText","./DynamicPageTitleRenderer","sap/base/Log","sap/ui/core/Icon","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/core/InvisibleMessage","sap/ui/core/Core"],function(t,e,i,n,a,o,s,r,p,c,h,g,l,d,u,A,_){"use strict";var f=t.DynamicPageTitleArea;var b=a.ToolbarStyle;var y=e.InvisibleMessageMode;var v=i.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",properties:{primaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:f.Begin,deprecated:true},areaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},aggregations:{heading:{type:"sap.ui.core.Control",multiple:false},snappedHeading:{type:"sap.ui.core.Control",multiple:false},expandedHeading:{type:"sap.ui.core.Control",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},navigationActions:{type:"sap.m.Button",multiple:true,singularName:"navigationAction"},content:{type:"sap.ui.core.Control",multiple:true},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},snappedTitleOnMobile:{type:"sap.m.Title",multiple:false},breadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navActionsToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_navActionsToolbarSeparator:{type:"sap.m.ToolbarSeparator",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_snappedTitleOnMobileIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{stateChange:{parameters:{isExpanded:{type:"boolean"}}}},designtime:"sap/f/designtime/DynamicPageTitle.designtime"},renderer:h});function S(t){if(arguments.length===1){return t&&"length"in t?t.length>0:!!t}return Array.prototype.slice.call(arguments).every(function(t){return S(t)})}v.NAV_ACTIONS_PLACEMENT_BREAK_POINT=1280;v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS={headingAreaShrinkFactor:1.6,contentAreaShrinkFactor:1,actionsAreaShrinkFactor:1.6};v.TOGGLE_HEADER_TEXT_ID=c.getStaticId("sap.f","TOGGLE_HEADER");v.DEFAULT_HEADER_TEXT_ID=c.getStaticId("sap.f","DEFAULT_HEADER_TEXT");v._getResourceBundle=function(){return _.getLibraryResourceBundle("sap.f")};v.ARIA={TOOLBAR_HEADER_ACTIONS:v._getResourceBundle().getText("ARIA_LABEL_TOOLBAR_HEADER_ACTIONS")};v._renderControl=function(t,e){var i;if(!e||!t){return}i=_.createRenderManager();i.renderControl(e);i.flush(t);i.destroy()};function T(t){return typeof t==="function"}v.prototype.init=function(){this._bExpandedState=true;this._bShowExpandButton=false;this._bIsFocusable=true;this._bNavigationActionsInTopArea=false;this._oInvisibleMessage=null;this._aCachedInvisibleTexts=[];this._fnActionSubstituteParentFunction=function(){return this}.bind(this);this._oObserver=new n(v.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content","_actionsToolbar"]})};v.prototype.onBeforeRendering=function(){this._getActionsToolbar();this._observeControl(this.getBreadcrumbs());this._detachFocusSpanHandlers()};v.prototype.onAfterRendering=function(){this._cacheDomElements();this._attachFocusSpanHandlers();this._toggleState(this._bExpandedState);this._toggleFocusableState(this._bIsFocusable);this._doNavigationActionsLayout();this._updateTopAreaVisibility();if(this._getFocusSpan().is(":focus")){this._addFocusClass()}if(!this._oInvisibleMessage){this._oInvisibleMessage=A.getInstance()}};v.prototype.exit=function(){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}this._destroyInvisibleTexts()};v.prototype.setPrimaryArea=function(t){var e=this.getAreaShrinkRatio(),i=this._getShrinkFactorsObject(),n=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(!this.getDomRef()){return this.setProperty("primaryArea",t,true)}if(e!==n){return this.setProperty("primaryArea",t,true)}if(t===f.Begin){this._setShrinkFactors(i.headingAreaShrinkFactor,i.contentAreaShrinkFactor,i.actionsAreaShrinkFactor)}else{this._setShrinkFactors(v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor,v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor,v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor)}return this.setProperty("primaryArea",t,true)};v.prototype.setAreaShrinkRatio=function(t){t=this.validateProperty("areaShrinkRatio",t);this.setProperty("areaShrinkRatio",t,true);var e=this._getShrinkFactorsObject();if(this.getPrimaryArea()===f.Middle){g.warning("DynamicPageTitle :: Property primaryArea is disregarded when areaShrinkRatio is set.",this)}if(e.headingAreaShrinkFactor>1&&e.contentAreaShrinkFactor>1&&e.actionsAreaShrinkFactor>1){g.warning("DynamicPageTitle :: One of the shrink factors should be set to 1.",this)}this._setShrinkFactors(e.headingAreaShrinkFactor,e.contentAreaShrinkFactor,e.actionsAreaShrinkFactor);return this};v.prototype.ontap=function(t){var e=t.srcControl;if(e===this||e===this.getAggregation("_actionsToolbar")||e===this.getAggregation("breadcrumbs")||e===this.getAggregation("snappedTitleOnMobile")){this.fireEvent("_titlePress")}};v.prototype.onmouseover=function(){if(this._bTitleMouseOverFired){return}this.fireEvent("_titleMouseOver");this._bTitleMouseOverFired=true};v.prototype.onmouseout=function(t){if(t&&this.getDomRef().contains(t.relatedTarget)){return}this.fireEvent("_titleMouseOut");this._bTitleMouseOverFired=false};v.prototype.onkeyup=function(t){if(t&&t.which===u.SPACE&&!t.shiftKey){this.onsapenter(t)}};v.prototype.onsapspace=function(t){if(t.srcControl===this){t.preventDefault()}};v.prototype.onsapenter=function(t){if(t.srcControl===this){this.fireEvent("_titlePress")}};["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(t){v.prototype[t]=function(e){var i=this._getActionsToolbar(),n=t.replace(/Actions?/,"Content"),a=true,o;if(t==="addAction"||t==="insertAction"){if(!this._actionExists(e,"actions")){i[n].apply(i,arguments);this._preProcessAction(e,"actions")}o=this}else if(t==="removeAction"){this._postProcessAction(e)}else if(t==="removeAllActions"){this.getActions().forEach(this._postProcessAction,this)}else if(t==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);i[n].apply(i,arguments);o=this}else if(t==="getActions"){a=false}o=o||i[n].apply(i,arguments);a&&this._updateSeparatorVisibility();return o}});["addNavigationAction","insertNavigationAction","removeNavigationAction","indexOfNavigationAction","removeAllNavigationActions","destroyNavigationActions","getNavigationActions"].forEach(function(t){v.prototype[t]=function(e){var i=this._getNavigationActionsToolbar(),n=t.replace(/NavigationActions?/,"Content"),a=true,o;if(t==="addNavigationAction"||t==="insertNavigationAction"){if(!this._actionExists(e,"navigationActions")){i[n].apply(i,arguments);this._preProcessAction(e,"navigationActions")}o=this}else if(t==="removeNavigationAction"){this._postProcessAction(e)}else if(t==="removeAllNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this)}else if(t==="destroyNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);i[n].apply(i,arguments);o=this}else if(t==="getNavigationActions"){a=false}o=o||i[n].apply(i,arguments);a&&this._updateTopAreaVisibility();return o}});v.prototype.clone=function(t,e,n){var a=i.prototype.clone.apply(this,arguments),o=true;if(n){o=!!n.cloneChildren}if(!o){return a}var s=function(t){if(!this.isBound(t)){var e=this.getMetadata().getAggregation(t);e.get(this).forEach(function(t){e.add(a,t.clone())},this)}}.bind(this);s("actions");s("navigationActions");return a};v.prototype._getInvisibleText=function(t,e){var i=new c({id:t+"-InvisibleText",text:e}).toStatic();this._aCachedInvisibleTexts.push(i);return i};v.prototype._destroyInvisibleTexts=function(){this._aCachedInvisibleTexts.forEach(function(t){t.destroy()});this._aCachedInvisibleTexts=[]};v.prototype._actionExists=function(t,e){return this.getMetadata().getAggregation(e).get(this).indexOf(t)>-1};v.prototype._cacheDomElements=function(){this.$topNavigationActionsArea=this.$("topNavigationArea");this.$mainNavigationActionsArea=this.$("mainNavigationArea");this.$beginArea=this.$("left-inner");this.$topArea=this.$("top");this.$mainArea=this.$("main");this.$middleArea=this.$("content");this.$snappedTitleOnMobileWrapper=this.$("snapped-title-on-mobile-wrapper");this.$snappedHeadingWrapper=this.$("snapped-heading-wrapper");this.$expandHeadingWrapper=this.$("expand-heading-wrapper");this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");this._$focusSpan=this.$("focusSpan")};v.prototype._getActionsToolbar=function(){var t=this.getId()+"-_actionsToolbar";if(!this.getAggregation("_actionsToolbar")){this.setAggregation("_actionsToolbar",new r({id:t,style:b.Clear,ariaLabelledBy:this._getInvisibleText(t,v.ARIA.TOOLBAR_HEADER_ACTIONS)}).addStyleClass("sapFDynamicPageTitleActionsBar"),true)}return this.getAggregation("_actionsToolbar")};v.prototype._getNavigationActionsToolbar=function(){var t=this.getId()+"-navActionsToolbar";if(!this.getAggregation("_navActionsToolbar")){this.setAggregation("_navActionsToolbar",new o({id:t,style:b.Clear,ariaLabelledBy:this._getInvisibleText(t,v.ARIA.TOOLBAR_HEADER_ACTIONS)}).addStyleClass("sapFDynamicPageTitleActionsBar"),true)}return this.getAggregation("_navActionsToolbar")};v.prototype._getToolbarSeparator=function(){if(!this.getAggregation("_navActionsToolbarSeparator")){this.setAggregation("_navActionsToolbarSeparator",new s({id:this.getId()+"-separator"}),true)}return this.getAggregation("_navActionsToolbarSeparator")};v.prototype._toggleFocusableState=function(t){var e;this._bIsFocusable=t;e=this._getFocusSpan();if(e){t?e.show():e.hide()}};v.prototype._preProcessAction=function(t,e){if(T(t._fnOriginalGetParent)){return}this._observeControl(t);t._fnOriginalGetParent=t.getParent;t.getParent=this._fnActionSubstituteParentFunction;t._sOriginalParentAggregationName=t.sParentAggregationName;t.sParentAggregationName=e};v.prototype._postProcessAction=function(t){if(!T(t._fnOriginalGetParent)){return}this._unobserveControl(t);t.getParent=t._fnOriginalGetParent;t._fnOriginalGetParent=null;t.sParentAggregationName=t._sOriginalParentAggregationName;t._sOriginalParentAggregationName=null};v.prototype.onLayoutDataChange=function(t){var e=t.srcControl,i=e&&typeof e._fnOriginalGetParent==="function"&&e._fnOriginalGetParent();if(i){i.onLayoutDataChange(t)}};v.prototype._observeControl=function(t){this._oObserver.observe(t,{properties:["visible"]})};v.prototype._unobserveControl=function(t){this._oObserver.unobserve(t,{properties:["visible"]})};v.prototype._doNavigationActionsLayout=function(){var t,e,i;if(this.getNavigationActions().length===0){return}i=this._getNavigationActionsToolbar();t=this._shouldRenderNavigationActionsInTopArea();if(t){e=this.$topNavigationActionsArea[0]}else{e=this.$mainNavigationActionsArea[0]}this._bNavigationActionsInTopArea=t;v._renderControl(e,i);this._updateSeparatorVisibility()};v.prototype._updateTopAreaVisibility=function(t){var e=this._areNavigationActionsInTopArea(),i=this._shouldRenderNavigationActionsInTopArea(t),n=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible(),a=d.system.phone&&this.getSnappedTitleOnMobile()&&!this._bExpandedState,o=(n||i)&&!a,s=this.getNavigationActions().length>0&&i^e,r=this.$topArea;this._toggleTopAreaVisibility(o);r&&r.toggleClass("sapFDynamicPageTitleTopBreadCrumbsOnly",n&&!i);if(s){this._toggleNavigationActionsPlacement(i)}else{this._updateSeparatorVisibility()}};v.prototype._onResize=function(t){this._updateTopAreaVisibility(t)};v.prototype._toggleNavigationActionsPlacement=function(t){this["_showNavigationActionsIn"+(t?"Top":"Main")+"Area"]();this._updateSeparatorVisibility()};v.prototype._showNavigationActionsInTopArea=function(){var t=this._getNavigationActionsToolbar(),e;if(this.$topNavigationActionsArea&&this.$topNavigationActionsArea.length>0){e=document.activeElement;this.$topNavigationActionsArea.html(t.$());e&&e.focus()}this._bNavigationActionsInTopArea=true};v.prototype._showNavigationActionsInMainArea=function(){var t=this._getNavigationActionsToolbar(),e;if(this.$mainNavigationActionsArea&&this.$mainNavigationActionsArea.length>0){e=document.activeElement;this.$mainNavigationActionsArea.html(t.$());e&&e.focus()}this._bNavigationActionsInTopArea=false};v.prototype._areNavigationActionsInTopArea=function(){return this._bNavigationActionsInTopArea};v.prototype._updateSeparatorVisibility=function(){if(this.getDomRef()){this._getToolbarSeparator().toggleStyleClass("sapUiHidden",!this._shouldShowSeparator())}};v.prototype._toggleTopAreaVisibility=function(t){if(this.getDomRef()){this.$("top").toggleClass("sapUiHidden",!t)}};v.prototype._shouldShowSeparator=function(){var t,e;if(this._bNavigationActionsInTopArea){return false}t=this._getVisibleActions().length>0;e=this._getVisibleNavigationActions().length>0;return t&&e};v.prototype._getVisibleActions=function(){return this.getActions().filter(function(t){return t.getVisible()})};v.prototype._getVisibleNavigationActions=function(){return this.getNavigationActions().filter(function(t){return t.getVisible()})};v.prototype._setShrinkFactors=function(t,e,i){this.$("left-inner").css("flex-shrink",t);this.$("content").css("flex-shrink",e);this.$("mainActions").css("flex-shrink",i)};v.prototype._shouldRenderNavigationActionsInTopArea=function(t){var e,i,n;if(this._getVisibleNavigationActions().length===0){return false}e=t?t:this._getWidth();i=this._getVisibleActions().length>0;n=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible();return e<v.NAV_ACTIONS_PLACEMENT_BREAK_POINT&&(n||i)};v.prototype._toggleState=function(t,e){var i=this._bExpandedState;this._bExpandedState=t;if(!this.getDomRef()){return}if(d.system.phone&&this.getSnappedTitleOnMobile()){this.$snappedTitleOnMobileWrapper.toggleClass("sapUiHidden",t);this.$topArea.toggleClass("sapUiHidden",!t);this.$mainArea.toggleClass("sapUiHidden",!t);this.$().toggleClass("sapContrast",!t)}else{if(S(this.getSnappedHeading())){this.$snappedHeadingWrapper.toggleClass("sapUiHidden",t)}if(S(this.getExpandedHeading())){this.$expandHeadingWrapper.toggleClass("sapUiHidden",!t)}if(e&&i!==t){this.fireEvent("stateChange",{isExpanded:t})}}if(S(this.getSnappedContent())){this.$snappedWrapper.toggleClass("sapUiHidden",t);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageTitleMainSnapContentVisible",!t)}if(S(this.getExpandedContent())){this.$expandWrapper.toggleClass("sapUiHidden",!t);this.$expandWrapper.parent().toggleClass("sapFDynamicPageTitleMainExpandContentVisible",t)}};v.prototype._getExpandButton=function(){if(!this.getAggregation("_expandButton")){var t=new p({id:this.getId()+"-expandBtn",icon:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this),tooltip:v._getResourceBundle().getText("EXPAND_HEADER_BUTTON_TOOLTIP")}).addStyleClass("sapFDynamicPageToggleHeaderIndicator sapUiHidden");this.setAggregation("_expandButton",t,true)}return this.getAggregation("_expandButton")};v.prototype._getSnappedTitleOnMobileIcon=function(){if(!this.getAggregation("_snappedTitleOnMobileIcon")){var t=new l({id:this.getId()+"-snappedTitleOnMobileIcon",src:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this)});this.setAggregation("_snappedTitleOnMobileIcon",t,true)}return this.getAggregation("_snappedTitleOnMobileIcon")};v.prototype._onExpandButtonPress=function(){this.fireEvent("_titleVisualIndicatorPress")};v.prototype._toggleExpandButton=function(t){this._setShowExpandButton(t);this._getExpandButton().toggleStyleClass("sapUiHidden",!t)};v.prototype._getShowExpandButton=function(){return this._bShowExpandButton};v.prototype._setShowExpandButton=function(t){this._bShowExpandButton=!!t};v.prototype._focusExpandButton=function(){var t=v._getResourceBundle().getText("SNAPPED_HEADER");this._getExpandButton().$().trigger("focus");this._oInvisibleMessage.announce(t,y.Polite)};v.prototype._getWidth=function(){return this.$().outerWidth()};v.prototype.getFocusDomRef=function(){return this._getFocusSpan()[0]||null};v.prototype._getState=function(){var t=this.getActions().length>0,e=this.getNavigationActions().length>0,i=this.getContent(),n=this.getSnappedContent(),a=this.getExpandedContent(),o=a.length>0,s=n.length>0,r=this._getShrinkFactorsObject(),p=this._getExpandButton(),c=this._getFocusSpan(),h=this.getBreadcrumbs(),g=this.getSnappedTitleOnMobile(),l=this._getSnappedTitleOnMobileIcon(),u=g&&d.system.phone,A=h||e,_=!!(h&&!e),b=e&&!h,y=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue(),S=this.getAreaShrinkRatio()===y;S=S&&this.getPrimaryArea()===f.Middle;if(S){r.headingAreaShrinkFactor=v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor;r.contentAreaShrinkFactor=v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor;r.actionsAreaShrinkFactor=v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor}p.toggleStyleClass("sapUiHidden",!this._getShowExpandButton());return{id:this.getId(),actionBar:this._getActionsToolbar(),navigationBar:this._getNavigationActionsToolbar(),hasActions:t,hasNavigationActions:e,content:i,hasContent:i.length>0,heading:this.getHeading(),snappedHeading:this.getSnappedHeading(),expandedHeading:this.getExpandedHeading(),expandButton:p,focusSpan:c,snappedTitleOnMobileContext:g,snappedTitleOnMobileIcon:l,snappedContent:n,expandedContent:a,hasSnappedContent:s,hasExpandedContent:o,hasSnappedTitleOnMobile:u,hasAdditionalContent:o||s&&!u,isSnapped:!this._bExpandedState,headingAreaShrinkFactor:r.headingAreaShrinkFactor,contentAreaShrinkFactor:r.contentAreaShrinkFactor,actionsAreaShrinkFactor:r.actionsAreaShrinkFactor,breadcrumbs:this.getBreadcrumbs(),separator:this._getToolbarSeparator(),hasTopContent:A,hasOnlyBreadcrumbs:_,hasOnlyNavigationActions:b,contentAreaHasContent:this._bContentAreaHasContent,actionsAreaHasContent:this._bActionsAreaHasContent,isFocusable:this._bIsFocusable,actionsAreaMinWidth:this._sActionsAreaMinWidth,contentAreaMinWidth:this._sContentAreaMinWidth}};v.prototype._getShrinkFactorsObject=function(){var t={},e=this.getAreaShrinkRatio().split(":");t.headingAreaShrinkFactor=parseFloat(e[0]);t.contentAreaShrinkFactor=parseFloat(e[1]);t.actionsAreaShrinkFactor=parseFloat(e[2]);return t};v.prototype._observeChanges=function(t){var e=t.object,i=t.name;if(e===this){if(i==="content"||i==="_actionsToolbar"){this._observeContentChanges(t)}}else if(i==="visible"){this._updateTopAreaVisibility()}};v.prototype._observeContentChanges=function(t){var e=t.child,i=t.mutation,n=e.$().parent();if(!(e instanceof r)){return}if(i==="insert"){e.attachEvent("_contentSizeChange",this._onContentSizeChange,this);e.attachEvent("_minWidthChange",this._onContentMinWidthChange,this)}else if(i==="remove"){e.detachEvent("_contentSizeChange",this._onContentSizeChange,this);e.detachEvent("_minWidthChange",this._onContentMinWidthChange,this);this._setContentAreaFlexBasis(0,n);n.css({"min-width":""})}};v.prototype._onContentSizeChange=function(t){var e=t.getParameter("contentSize");this._setContentAreaFlexBasis(e,t.getSource().$().parent())};v.prototype._onContentMinWidthChange=function(t){var e=t.getParameter("minWidth"),i=e>0?e+"px":"",n=t.getSource().$().parent();n.css({"min-width":i});if(n.hasClass("sapFDynamicPageTitleMainContent")){this._sContentAreaMinWidth=i}else if(n.hasClass("sapFDynamicPageTitleMainActions")){this._sActionsAreaMinWidth=i}};v.prototype._setContentAreaFlexBasis=function(t,e){var i;t=parseInt(t);i=t&&t>1;if(e.hasClass("sapFDynamicPageTitleMainContent")){this._bContentAreaHasContent=i;e.toggleClass("sapFDynamicPageTitleMainContentHasContent",i)}else if(e.hasClass("sapFDynamicPageTitleMainActions")){this._bActionsAreaHasContent=i;e.toggleClass("sapFDynamicPageTitleMainActionsHasContent",i)}};v.prototype._updateARIAState=function(t){var e=this._getARIALabelReferences(t),i=this._getFocusSpan();if(i){i.attr("aria-labelledby",e);i.attr("aria-expanded",t)}return this};v.prototype._getARIALabelReferences=function(t){var e="",i,n,a=this.getHeading()||(t?this.getExpandedHeading():this.getSnappedHeading());if(a){i=a.getTitle&&a.getTitle();if(i&&i.getId){n=i.getId()}e+=n||a.getId()}return e||v.DEFAULT_HEADER_TEXT_ID};v.prototype._focus=function(){this._getFocusSpan().trigger("focus")};v.prototype._getAriaDescribedByReferences=function(){var t=this.getAriaDescribedBy(),e=v.TOGGLE_HEADER_TEXT_ID;if(t.length>0){e+=" "+t.join(" ")}return e};v.prototype._attachFocusSpanHandlers=function(){this._$focusSpan.on("focusin",this._addFocusClass.bind(this));this._$focusSpan.on("focusout",this._removeFocusClass.bind(this))};v.prototype._detachFocusSpanHandlers=function(){if(this._$focusSpan){this._$focusSpan.off("focusin");this._$focusSpan.off("focusout")}};v.prototype._getFocusSpan=function(){return this._$focusSpan};v.prototype._addFocusClass=function(){this.$().addClass("sapFDynamicPageTitleFocus")};v.prototype._removeFocusClass=function(){this.$().removeClass("sapFDynamicPageTitleFocus")};return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/DynamicPageTitleRenderer", ["./library","sap/ui/Device"],function(e,n){"use strict";var a={apiVersion:2};a.render=function(e,n){var a=n._getState(),i="sapFDynamicPageTitle",t=n.getBackgroundDesign(),r=n._getARIALabelReferences(n._bExpandedState),d=n._getAriaDescribedByReferences();e.openStart("div",n);e.class(i);if(t){e.class(i+t)}e.openEnd();e.openStart("span",n.getId()+"-focusSpan").class("sapFDynamicPageTitleFocusSpan").attr("role","button").attr("aria-expanded",n._bExpandedState).attr("aria-labelledby",r).attr("aria-describedby",d).attr("tabindex",0);e.openEnd().close("span");this._renderTopArea(e,a);this._renderMainArea(e,a);this._renderSnappedExpandedContentArea(e,a);if(a.hasSnappedTitleOnMobile){this._renderSnappedTitleOnMobile(e,a)}e.renderControl(a.expandButton);e.close("div")};a._renderTopArea=function(e,n){if(n.hasTopContent){e.openStart("div",n.id+"-top");e.class("sapFDynamicPageTitleTop");if(n.hasOnlyBreadcrumbs){e.class("sapFDynamicPageTitleTopBreadCrumbsOnly")}if(n.hasOnlyNavigationActions){e.class("sapFDynamicPageTitleTopNavActionsOnly")}e.openEnd();this._renderTopBreadcrumbsArea(e,n);this._renderTopNavigationArea(e,n);e.close("div")}};a._renderTopBreadcrumbsArea=function(e,n){if(n.breadcrumbs){e.openStart("div",n.id+"-breadcrumbs");e.class("sapFDynamicPageTitleTopLeft");e.openEnd();e.renderControl(n.breadcrumbs);e.close("div")}};a._renderTopNavigationArea=function(e,n){if(n.hasNavigationActions){e.openStart("div",n.id+"-topNavigationArea");e.class("sapFDynamicPageTitleTopRight");e.openEnd();e.close("div")}};a._renderMainArea=function(e,n){e.openStart("div",n.id+"-main");e.class("sapFDynamicPageTitleMain");if(!n.hasContent){e.class("sapFDynamicPageTitleMainNoContent")}e.openEnd();e.openStart("div");e.class("sapFDynamicPageTitleMainInner");e.openEnd();this._renderMainHeadingArea(e,n);this._renderMainContentArea(e,n);this._renderMainActionsArea(e,n);e.close("div");this._renderMainNavigationArea(e,n);e.close("div")};a._renderMainHeadingArea=function(e,n){e.openStart("div",n.id+"-left-inner");e.class("sapFDynamicPageTitleMainHeading");e.style("flex-shrink",n.headingAreaShrinkFactor.toString());e.openEnd();e.openStart("div");e.class("sapFDynamicPageTitleHeading-CTX");e.class("sapFDynamicPageTitleMainHeadingInner");e.openEnd();if(n.heading){e.renderControl(n.heading)}else{if(n.snappedHeading){a._renderSnappedHeading(e,n)}if(n.expandedHeading){a._renderExpandHeading(e,n)}}e.close("div");e.close("div")};a._renderMainContentArea=function(e,n){e.openStart("div",n.id+"-content");e.class("sapFDynamicPageTitleMainContent");e.class("sapFDynamicPageTitleContent-CTX");e.style("flex-shrink",n.contentAreaShrinkFactor.toString());if(n.contentAreaMinWidth){e.style("min-width",n.contentAreaMinWidth)}if(n.contentAreaHasContent){e.class("sapFDynamicPageTitleMainContentHasContent")}e.openEnd();n.content.forEach(e.renderControl,e);e.close("div")};a._renderMainActionsArea=function(e,n){e.openStart("div",n.id+"-mainActions");e.class("sapFDynamicPageTitleMainActions");e.style("flex-shrink",n.actionsAreaShrinkFactor.toString());if(n.actionsAreaMinWidth){e.style("min-width",n.actionsAreaMinWidth)}if(n.actionsAreaHasContent){e.class("sapFDynamicPageTitleMainActionsHasContent")}e.openEnd();if(n.hasActions){e.renderControl(n.actionBar)}e.close("div")};a._renderMainNavigationArea=function(e,n){if(n.hasNavigationActions){e.openStart("div",n.id+"-mainNavigationAreaWrapper");e.class("sapFDynamicPageTitleMainNavigationArea");e.openEnd();e.renderControl(n.separator);e.openStart("div",n.id+"-mainNavigationArea");e.class("sapFDynamicPageTitleMainNavigationAreaInner");e.openEnd();e.close("div");e.close("div")}};a._renderSnappedExpandedContentArea=function(e,n){if(n.hasAdditionalContent){e.openStart("div");e.class("sapFDynamicPageTitleMainHeadingSnappedExpandContent");e.openEnd();if(n.hasSnappedContent&&!n.hasSnappedTitleOnMobile){a._renderSnappedContent(e,n)}if(n.hasExpandedContent){a._renderExpandContent(e,n)}e.close("div")}};a._renderExpandHeading=function(e,n){e.openStart("div",n.id+"-expand-heading-wrapper");e.openEnd();e.renderControl(n.expandedHeading);e.close("div")};a._renderSnappedHeading=function(e,a){e.openStart("div",a.id+"-snapped-heading-wrapper");if(!a.isSnapped||a.hasSnappedTitleOnMobile&&n.system.phone){e.class("sapUiHidden")}e.openEnd();e.renderControl(a.snappedHeading);e.close("div")};a._renderExpandContent=function(e,n){e.openStart("div",n.id+"-expand-wrapper");e.class("sapFDynamicPageTitleExpanded");e.openEnd();n.expandedContent.forEach(e.renderControl,e);e.close("div")};a._renderSnappedContent=function(e,n){e.openStart("div",n.id+"-snapped-wrapper");if(!n.isSnapped){e.class("sapUiHidden")}e.class("sapFDynamicPageTitleSnapped");e.openEnd();n.snappedContent.forEach(e.renderControl,e);e.close("div")};a._renderSnappedTitleOnMobile=function(e,n){e.openStart("div",n.id+"-snapped-title-on-mobile-wrapper");if(!n.isSnapped){e.class("sapUiHidden")}e.class("sapFDynamicPageTitleSnappedTitleOnMobile");e.openEnd();e.renderControl(n.snappedTitleOnMobileContext);e.renderControl(n.snappedTitleOnMobileIcon);e.close("div")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/FlexibleColumnLayout", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/util/Storage","sap/m/library","sap/m/NavContainer","sap/ui/core/Configuration","sap/ui/dom/units/Rem","./FlexibleColumnLayoutRenderer","sap/base/Log","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge","sap/ui/core/InvisibleMessage","sap/ui/dom/jquery/Focusable"],function(jQuery,e,t,o,n,i,s,r,a,u,l,d,h,m,p,g,C){"use strict";var c=e.LayoutType;var f=t.InvisibleMessageMode;var _=i.extend("sap.f.FlexibleColumnLayout",{metadata:{interfaces:["sap.ui.core.IPlaceholderSupport"],properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},layout:{type:"sap.f.LayoutType",defaultValue:c.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:r.BackgroundDesign.Transparent},restoreFocusOnBackNavigation:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getBeginColumn",aggregation:"pages"}},midColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getMidColumn",aggregation:"pages"}},endColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getEndColumn",aggregation:"pages"}},landmarkInfo:{type:"sap.f.FlexibleColumnLayoutAccessibleLandmarkInfo",multiple:false},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},columnResize:{parameters:{beginColumn:{type:"boolean"},midColumn:{type:"boolean"},endColumn:{type:"boolean"}}}}},renderer:d});_.DEFAULT_COLUMN_LABELS={FirstColumn:"FCL_BEGIN_COLUMN_REGION_TEXT",MiddleColumn:"FCL_MID_COLUMN_REGION_TEXT",LastColumn:"FCL_END_COLUMN_REGION_TEXT"};_.COLUMN_RESIZING_ANIMATION_DURATION=560;_.PINNED_COLUMN_CLASS_NAME="sapFFCLPinnedColumn";_.ANIMATED_COLUMN_CLASS_NAME="sapFFCLAnimatedColumn";_.COLUMN_ORDER=["begin","mid","end"];_.COLUMN_SEPARATOR_WIDTH=l.toPx("1rem");_.prototype.init=function(){this._iWidth=0;this._oColumnFocusInfo={begin:{},mid:{},end:{}};this._initNavContainers();this._oLayoutHistory=new y;this._oAnimationEndListener=new v;this._oRenderedColumnPagesBoolMap={};this._oColumnWidthInfo={begin:0,mid:0,end:0};this._keyListeners={increase:this._resizeColumnOnKeypress.bind(this,"inc",1),decrease:this._resizeColumnOnKeypress.bind(this,"dec",1),increaseMore:this._resizeColumnOnKeypress.bind(this,"incMore",2),decreaseMore:this._resizeColumnOnKeypress.bind(this,"decMore",2),max:this._resizeColumnOnKeypress.bind(this,"max",1),min:this._resizeColumnOnKeypress.bind(this,"min",1)};this._enableKeyboardListeners();this._oInvisibleMessage=null;this._boundColumnSeparatorMove=this._onColumnSeparatorMove.bind(this);this._boundColumnSeparatorMoveEnd=this._onColumnSeparatorMoveEnd.bind(this);this._oLocalStorage={};this._bNeverRendered=true};_.prototype._getLocalStorage=function(e){if(!e){e=this.getMaxColumnsCount()}var t=e===3?"desktop":"tablet";if(!this._oLocalStorage[t]){var o=t==="desktop"?_.STORAGE_PREFIX_DESKTOP:_.STORAGE_PREFIX_TABLET;this._oLocalStorage[t]=new s(s.Type.local,o)}return this._oLocalStorage[t]};_.prototype._announceMessage=function(e){var t=_._getResourceBundle().getText(e);if(this._oInvisibleMessage){this._oInvisibleMessage.announce(t,f.Polite)}};_.prototype._enableKeyboardListeners=function(){this.onsaprightmodifiers=this._keyListeners.increase;this.onsapleftmodifiers=this._keyListeners.decrease;this.onsapright=this._keyListeners.increaseMore;this.onsapleft=this._keyListeners.decreaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true};_.prototype._onNavContainerRendered=function(e){var t=e.srcControl,o=t.getPages().length>0,n=this._hasAnyColumnPagesRendered();this._setColumnPagesRendered(t.getId(),o);if(this._hasAnyColumnPagesRendered()!==n){this._hideShowColumnSeparators()}};_.prototype._createNavContainer=function(e){var t=e.charAt(0).toUpperCase()+e.slice(1);var o=new a(this.getId()+"-"+e+"ColumnNav",{autoFocus:this.getAutoFocus(),navigate:function(t){this._handleNavigationEvent(t,false,e)}.bind(this),afterNavigate:function(t){this._handleNavigationEvent(t,true,e)}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+t+"Column"]()});o.addDelegate({onAfterRendering:this._onNavContainerRendered},this);this["_"+e+"ColumnFocusOutDelegate"]={onfocusout:function(t){this._oColumnFocusInfo[e]=t.target}};o.addEventDelegate(this["_"+e+"ColumnFocusOutDelegate"],this);return o};_.prototype._formatColumnLandmarkInfo=function(e,t){var o=null;if(e){o=e["get"+t+"Label"]()}return{role:"region",label:o||_._getResourceBundle().getText(_.DEFAULT_COLUMN_LABELS[t])}};_.prototype._handleNavigationEvent=function(e,t,o){var n,i;if(t){n="after"+(o.charAt(0).toUpperCase()+o.slice(1))+"ColumnNavigate"}else{n=o+"ColumnNavigate"}i=this.fireEvent(n,e.mParameters,true);if(!i){e.preventDefault()}};_.prototype._getColumnByStringName=function(e){if(e==="end"){return this._getEndColumn()}else if(e==="mid"){return this._getMidColumn()}else{return this._getBeginColumn()}};_.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav")};_.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav")};_.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav")};_.prototype._flushColumnContent=function(e){var t=this.getAggregation("_"+e+"ColumnNav"),o=sap.ui.getCore().createRenderManager();o.renderControl(t);o.flush(this._$columns[e].find(".sapFFCLColumnContent")[0],undefined,true);o.destroy()};_.prototype.setLayout=function(e){e=this.validateProperty("layout",e);var t=this.getLayout();if(t===e){return this}var o=this.setProperty("layout",e,true);this._oLayoutHistory.addEntry(e);this._resizeColumns();return o};_.prototype.setAutoFocus=function(e){e=this.validateProperty("autoFocus",e);var t=this.getAutoFocus();if(t===e){return this}this._getNavContainers().forEach(function(t){t.setAutoFocus(e)});return this.setProperty("autoFocus",e,true)};_.prototype.onBeforeRendering=function(){var e=this._$columns;if(!this._oInvisibleMessage){this._oInvisibleMessage=C.getInstance()}this._deregisterResizeHandler();this._oAnimationEndListener.cancelAll();if(this.$().length){_.COLUMN_ORDER.slice().forEach(function(t){e&&e[t]&&e[t].removeClass(_.ANIMATED_COLUMN_CLASS_NAME)})}};_.prototype.onAfterRendering=function(){this._measureControlWidth();this._registerResizeHandler();this._cacheDOMElements();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);this._bNeverRendered=false};_.prototype.onmousedown=function(e){if(this._ignoreMouse){return}var t=this._getColumnSeparator(e.target);if(!t){return}this._ignoreTouch=true;this._onColumnSeparatorMoveStart(e,t)};_.prototype.ontouchstart=function(e){if(this._ignoreTouch){return}var t=this._getColumnSeparator(e.target);if(!t){return}if(!e.changedTouches||!e.changedTouches[0]){return}this._ignoreMouse=true;this._onColumnSeparatorMoveStart(e.changedTouches[0],t,true)};_.prototype._restoreFocusToColumn=function(e){var t=this._oColumnFocusInfo[e],o=this._getColumnByStringName(e);if(this._isFocusInCurrentColumn(o)){return}if(!t||p(t)){t=this._getFirstFocusableElement(e)}jQuery(t).trigger("focus")};_.prototype._getFirstFocusableElement=function(e){var t=this._getColumnByStringName(e),o=t.getCurrentPage();if(o){return o.$().firstFocusableDomRef()}return null};_.prototype._isFocusInSomeOfThePreviousColumns=function(e){var t=this._getLastVisibleColumnForLayout(e),o=_.COLUMN_ORDER.indexOf(t)-1,n;for(;o>=0;o--){n=this._getColumnByStringName(_.COLUMN_ORDER[o]);if(n&&n._isFocusInControl(n)){return true}}return false};_.prototype._isFocusInCurrentColumn=function(e){return e._isFocusInControl(e)};_.prototype._getControlWidth=function(){if(this._iWidth===0){this._measureControlWidth()}return this._iWidth};_.prototype._measureControlWidth=function(){if(this.$().is(":visible")){this._iWidth=this.$().width()}else{this._iWidth=0}};_.prototype.exit=function(){this._removeNavContainersFocusOutDelegate();this._oRenderedColumnPagesBoolMap=null;this._oColumnFocusInfo=null;this._oLocalStorage=null;this._deregisterResizeHandler();this._handleEvent(jQuery.Event("Destroy"))};_.prototype._removeNavContainersFocusOutDelegate=function(){_.COLUMN_ORDER.forEach(function(e){this._getColumnByStringName(e).removeEventDelegate(this["_"+e+"ColumnFocusOutDelegate"])},this)};_.prototype._registerResizeHandler=function(){m(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=n.register(this,this._onResize.bind(this))};_.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){n.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}};_.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true)};_.prototype._getNavContainers=function(){return[this._getBeginColumn(),this._getMidColumn(),this._getEndColumn()]};_.prototype._cacheDOMElements=function(){this._cacheColumns();if(!o.system.phone){this._cacheColumnSeparators();this._$overlay=this.$("overlay");this._$overlaySeparator=this.$("overlaySeparator")}};_.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")}};_.prototype._cacheColumnSeparators=function(){this._oColumnSeparators={begin:this.$("separator-begin"),end:this.$("separator-end")}};_.prototype._getVisibleColumnsCount=function(e){return this._getVisibleColumnsForLayout(e).length};_.prototype._getVisibleColumnsForLayout=function(e){return _.COLUMN_ORDER.filter(function(t){return this._getColumnSizeForLayout(t,e)>0},this)};_.prototype._getVisibleColumnSeparatorsCount=function(){if(!this._oColumnSeparators){return 0}return Object.keys(this._oColumnSeparators).filter(function(e){return this._oColumnSeparators[e].data("visible")},this).length};_.prototype._getTotalColumnsWidth=function(e){var t=this._getRequiredColumnSeparatorsForLayout(e).length;return this._getControlWidth()-t*_.COLUMN_SEPARATOR_WIDTH};_.prototype._resizeColumns=function(e){var t=_.COLUMN_ORDER.slice(),o,n,i,s,r,a,u,l,d;if(!this.isActive()){return}e=g(this._getDefaultResizeOptions(),e);n=e.layout;s=this._getVisibleColumnsCount(n);if(s===0){return}o=e.hasAnimations;i=e.previousLayout;u=s===3&&n===c.ThreeColumnsEndExpanded;r=e.columnWidths||this._getAllColumnSizesForLayout(n,true);a=this._getLastVisibleColumnForLayout(n);l=e.restoreFocusOnBackNavigation&&i&&this._isNavigatingBackward(n,i)&&!this._isFocusInSomeOfThePreviousColumns(i);d=o&&i?this._getAnimationEndStatusForColumns():{};if(o&&i){this._pinColumnsBeforeResize(n,i,r);this._oAnimationEndListener.cancelAll()}t.slice().forEach(function(e){this._$columns[e].removeClass(_.ANIMATED_COLUMN_CLASS_NAME)}.bind(this));this._hideShowColumnSeparators();t.forEach(function(t){var s=r[t],h=o&&this._shouldRevealColumn(t,n,i),m=o&&this._shouldConcealColumn(t,n,i);this._resizeColumn(t,{width:s,shouldRestoreFocus:l&&t===a,shouldInsetColumn:u&&t==="mid",shouldRevealColumn:h,shouldConcealColumn:m,hidden:s===0&&this._oColumnWidthInfo[t]===0,autoSize:s>0&&t==="mid",hasAnimations:o,previousAnimationCompleted:!d[this._$columns[t]],updateContextualSettings:e.updateContextualSettings,updateMediaCSSClases:e.updateMediaCSSClases})},this);if(e.updateDetailedActiveClasses){this._addDetailedActiveClasses(n)}};_.prototype._resizeColumn=function(e,t){var i=this._$columns[e],s=i.get(0),r=t.width,a=E(r,this._getControlWidth(),t.shouldInsetColumn),u=t.autoSize,l=t.hasAnimations,d=t.shouldRevealColumn||t.shouldConcealColumn,h=this._canResizeColumnWithAnimation(e,t),m=l&&(h||u)&&!d,p=this._afterColumnResize.bind(this,e,g(t,{resumeResizeHandler:m})),C=function(){n.resume(s);s.querySelector(".sapFFCLColumnContent").style.width=""};if(u){a=""}i.toggleClass("sapFFCLColumnActive",r>0||t.shouldConcealColumn);i.toggleClass("sapFFCLColumnInset",t.shouldInsetColumn);i.removeClass("sapFFCLColumnHidden sapFFCLColumnOnlyActive sapFFCLColumnLastActive sapFFCLColumnFirstActive");if(m){n.suspend(s)}if(h){i.addClass(_.ANIMATED_COLUMN_CLASS_NAME);i.width(a);this._attachAfterColumnResizedOnce(e,p,C)}else if(u&&l){i.width(a);this._attachAfterAllColumnsResizedOnce(p,C)}else{i.width(a);p()}if(t.updateContextualSettings&&!o.system.phone){this._updateColumnContextualSettings(e,r)}if(t.updateMediaCSSClases&&!o.system.phone){this._updateColumnCSSClasses(e,r)}};_.prototype._afterColumnResize=function(e,t){var o=this._$columns[e],i=t.shouldRevealColumn,s=t.shouldConcealColumn,r=t.width,a=t.shouldRestoreFocus;if(i||s){o[0].querySelector(".sapFFCLColumnContent").style.width=""}o.toggleClass(_.PINNED_COLUMN_CLASS_NAME,false);o.toggleClass(_.ANIMATED_COLUMN_CLASS_NAME,false);if(s){o.removeClass("sapFFCLColumnActive")}o.toggleClass("sapFFCLColumnHidden",r===0);if(t.resumeResizeHandler){n.resume(o[0])}this._cacheColumnWidth(e,r);if(a){this._restoreFocusToColumn(e)}};_.prototype._pinColumnsBeforeResize=function(e,t,o){_.COLUMN_ORDER.slice().forEach(function(n){var i=this._shouldConcealColumn(n,e,t),s=this._shouldRevealColumn(n,e,t),r=i||s,a=this._$columns[n],u=a[0];a.toggleClass(_.PINNED_COLUMN_CLASS_NAME,r);if(s){u.querySelector(".sapFFCLColumnContent").style.width=E(o[n],this._getControlWidth())}else if(i){u.querySelector(".sapFFCLColumnContent").style.width=u.offsetWidth+"px"}},this)};_.prototype._getAnimationEndStatusForColumns=function(){var e={};_.COLUMN_ORDER.slice().forEach(function(t){e[t]=this._oAnimationEndListener.isWaitingForColumnResizeEnd(this._$columns[t])},this);return e};_.prototype._getAllColumnSizesForLayout=function(e,t){var o={};_.COLUMN_ORDER.slice().forEach(function(t){var n=this._getColumnSizeForLayout(t,e),i=this._convertColumnPercentWidthToPx(n,e);o[t]=i},this);if(t){this._normalizeColumnWidths(o,this._getVisibleColumnsForLayout(e))}return o};_.prototype._getDefaultResizeOptions=function(){var e=u.getAnimationMode();return{layout:this.getLayout(),previousLayout:this._getPreviousLayout(),restoreFocusOnBackNavigation:this.getRestoreFocusOnBackNavigation(),updateDetailedActiveClasses:true,updateContextualSettings:true,updateMediaCSSClases:true,hasAnimations:e!==u.AnimationMode.none&&e!==u.AnimationMode.minimal}};_.prototype._getPreviousLayout=function(){return this._getLayoutHistory().getEntry(1,true)||c.OneColumn};_.prototype._addDetailedActiveClasses=function(e){var t=_.COLUMN_ORDER.slice(),o=u.getRTL(),n=t.filter(function(t){return this._getColumnSizeForLayout(t,e)>0},this);if(o){t.reverse()}if(n.length===1){this._$columns[n[0]].addClass("sapFFCLColumnOnlyActive")}if(n.length>1){this._$columns[n[0]].addClass("sapFFCLColumnFirstActive");this._$columns[n[n.length-1]].addClass("sapFFCLColumnLastActive")}};_.prototype._resizeColumnOnKeypress=function(e,t,o){var n=this._getColumnSeparator(o.target),i,s;if(!n){return}var r=this._getControlWidth();var a=0;switch(e){case"inc":a=t;break;case"incMore":a=t*10;break;case"dec":a=0-t;break;case"decMore":a=0-t*10;break;case"max":a=r;break;case"min":a=0-r;break;default:h.warn("[FlexibleColumnLayout] Invalid keyboard resize type");break}i=n&&n.getBoundingClientRect().x;s=i+a;this._onColumnSeparatorMoveStart({pageX:i},n);this._onColumnSeparatorMove({pageX:s});this._onColumnSeparatorMoveEnd({pageX:s})};_.prototype._onColumnSeparatorMoveStart=function(e,t,o){var n=u.getRTL(),i=this._getDraggedSeparatorStartOffset(t,n);this._oMoveInfo={cursorStartX:e.pageX,cursorX:e.pageX,columnWidths:{begin:this._$columns.begin.get(0).offsetWidth,mid:this._$columns.mid.get(0).offsetWidth,end:this._$columns.end.get(0).offsetWidth},separator:t,separatorPosition:{x:i,direction:n?"right":"left"},layout:this.getLayout(),rtl:n};this._enterInteractiveResizeMode(o)};_.prototype._getDraggedSeparatorStartOffset=function(e,t){if(t){return this.getDomRef().clientWidth-e.offsetLeft-e.offsetWidth}return e.offsetLeft};_.prototype._onColumnSeparatorMove=function(e){if(e.preventDefault&&!e.changedTouches){e.preventDefault()}var t=T(e);this._previewResizedColumnsOnMoveSeparator(t)};_.prototype._onColumnSeparatorMoveEnd=function(e){var t=T(e);this._previewResizedColumnsOnMoveSeparator(t,true);this._saveResizedColumWidths();if(this._oMoveInfo.layout!==this.getLayout()){this.setLayout(this._oMoveInfo.layout);this._fireStateChange(true,false)}this._exitInteractiveResizeMode()};_.prototype._getColumnSeparator=function(e){var t=e,o=this.getId();if(t.classList.contains("sapFFCLColumnSeparatorGripIcon")){t=e.parentElement}if(t.classList.contains("sapFFCLColumnSeparatorDecorationBefore")||t.classList.contains("sapFFCLColumnSeparatorDecorationAfter")||t.classList.contains("sapFFCLColumnSeparatorGrip")){t=t.parentElement}if(!t.id||t.id.indexOf(o+"-separator")!==0){return null}return t};_.prototype._enterInteractiveResizeMode=function(e){var t=this._oMoveInfo.separatorPosition;this.toggleStyleClass("sapFFLActiveResize",true);this._$overlaySeparator.css(t.direction,t.x);this._oMoveInfo.separator.style.visibility="hidden";if(e){document.addEventListener("touchend",this._boundColumnSeparatorMoveEnd);document.addEventListener("touchmove",this._boundColumnSeparatorMove)}else{document.addEventListener("mouseup",this._boundColumnSeparatorMoveEnd);document.addEventListener("mousemove",this._boundColumnSeparatorMove)}};_.prototype._exitInteractiveResizeMode=function(){this.toggleStyleClass("sapFFLActiveResize",false);this._oMoveInfo.separator.style.visibility="";this._oMoveInfo.separator.focus();this._ignoreMouse=false;this._ignoreTouch=false;this._oMoveInfo=null;document.removeEventListener("mouseup",this._boundColumnSeparatorMoveEnd);document.removeEventListener("mousemove",this._boundColumnSeparatorMove);document.removeEventListener("touchend",this._boundColumnSeparatorMoveEnd);document.removeEventListener("touchmove",this._boundColumnSeparatorMove)};_.prototype._previewResizedColumnsOnMoveSeparator=function(e,t){var o=function(t){var o=e-t;return this._oMoveInfo.rtl?-o:o}.bind(this);this._oMoveInfo.offsetFromPreviousPosition=o(this._oMoveInfo.cursorX);this._oMoveInfo.offsetFromStartPosition=o(this._oMoveInfo.cursorStartX);this._oMoveInfo.cursorX=e;if(!this._oMoveInfo.offsetFromStartPosition){return}if(!this._oMoveInfo.offsetFromPreviousPosition&&!t){return}var n=b(this._oMoveInfo.separator,this._oMoveInfo.layout,this.getMaxColumnsCount()),i=M(this._oMoveInfo.separator),s=this._oMoveInfo.offsetFromStartPosition>0,r=n[s?0:1],a=this._getVisibleColumnSeparatorsCount(),u=0,l=0,d,h=this._oMoveInfo.layout,m,p,C,c;this._oMoveInfo.columnWidths[n[0]]+=this._oMoveInfo.offsetFromPreviousPosition;this._oMoveInfo.columnWidths[n[1]]-=this._oMoveInfo.offsetFromPreviousPosition;this._oMoveInfo.columnEnlargedByDragging=r;C=g({},this._oMoveInfo.columnWidths);this._normalizeColumnWidths(C,n);d=this._oMoveInfo.columnWidths[n[1]]-C[n[1]];this._offsetDraggedColumnSeparator(this._oMoveInfo.offsetFromPreviousPosition+d);this._toggleColumnVisibility(r,true);m=this._getNextLayoutOnResizeByDrag(C,h,i,s,t);p=m!==h;if(p){this._hideShowColumnSeparators(m);u=a-this._getRequiredColumnSeparatorsForLayout(m).length;if(u){l=_.COLUMN_SEPARATOR_WIDTH*u;C.mid+=l}c=_.COLUMN_ORDER.some(function(e){return this._shouldRevealColumn(e,m,h)||this._shouldConcealColumn(e,m,h)},this);C=this._mergeColumnWidthsOnInteractiveLayoutChange({oldWidths:this._getAllColumnSizesForLayout(m,true),newWidths:{[n[0]]:C[n[0]],[n[1]]:C[n[1]]},layout:m,columnEnlargedByDragging:r});this._oMoveInfo.layout=m;this._oMoveInfo.cursorStartX=e}this._oMoveInfo.columnWidths=C;if(c){this._resizeColumns({columnWidths:C,layout:m,previousLayout:h,updateContextualSettings:false,updateMediaCSSClases:false,updateDetailedActiveClasses:false,restoreFocusOnBackNavigation:false})}else{this._$columns.begin.css("width",this._oMoveInfo.columnWidths.begin+"px");this._$columns.end.css("width",this._oMoveInfo.columnWidths.end+"px");n.forEach(function(e){this._updateColumnContextualSettings(e,this._oMoveInfo.columnWidths[e])},this)}if(p){this.fireEvent("_liveStateChange",{layout:m,maxColumnsCount:this.getMaxColumnsCount()})}};_.prototype._mergeColumnWidthsOnInteractiveLayoutChange=function(e){var t=e.oldWidths,o=e.newWidths,n=e.layout,i=e.columnEnlargedByDragging,s=Object.keys(o),r=this._getTotalColumnsWidth(n),a=function(e){return o[e]>=_.COLUMN_MIN_WIDTH},u=function(e){e.mid=r-e.begin-e.end;return e},l;if(s.indexOf("mid")>-1){l=s.find(e=>e!=="mid")}else{l=i}if(!a(l)){return t}return u(g(t,{[l]:o[l]}))};_.prototype._offsetDraggedColumnSeparator=function(e){this._oMoveInfo.separatorPosition.x+=e;this._$overlaySeparator.css(this._oMoveInfo.separatorPosition.direction,this._oMoveInfo.separatorPosition.x)};_.prototype._toggleColumnVisibility=function(e,t){this._$columns[e].toggleClass("sapFFCLColumnHidden",!t);this._$columns[e].toggleClass("sapFFCLColumnActive",t)};_.prototype._normalizeColumnWidths=function(e,t){var o=t.length;if(o<2){return}var n=function(t){if(this._isColumnAllowedToHaveBelowMinWidth(t)){return}var o=e[t]-_.COLUMN_MIN_WIDTH,n,s;if(o<0){e[t]=_.COLUMN_MIN_WIDTH;n=i(t);s=e[n];e[n]=s-Math.abs(o)}}.bind(this);function i(n){if(o===2){return t.find(function(e){return e!==n})}if(["begin","end"].indexOf(n)>-1){return"mid"}return e.begin>e.end?"begin":"end"}t.forEach(n)};_.prototype._isColumnAllowedToHaveBelowMinWidth=function(e){if(!this._oMoveInfo){return false}if(e===this._oMoveInfo.columnEnlargedByDragging){return true}return!this._isColumnAdjacentToDraggedSeparator(e)};_.prototype._convertColumnPercentWidthToPx=function(e,t){if(!e){return 0}var o=this._getTotalColumnsWidth(t);return Math.round(o*e/100)};_.prototype._convertColumnPxWidthToPercent=function(e,t){if(!e){return 0}var o=this._getTotalColumnsWidth(t),n=function(e){return e/o*100};if(typeof e==="number"){return n(e)}if(typeof e==="object"){var i=Object.assign({},e);Object.keys(i).forEach(function(e){var t=i[e];if(t){i[e]=n(t)}},this);return i}return null};_.prototype._isValidWidthDistributionForLayout=function(e,t){var o=e.split("/").map(e=>parseFloat(e)),n=o.reduce(function(e,t){return parseFloat(e)+t}),i;if(Math.round(n)!==100){return false}i=o.map(function(e){return this._convertColumnPercentWidthToPx(e,t)},this);if(i.some(function(e){return e>0&&e<_.COLUMN_MIN_WIDTH})){return false}return this._verifyColumnWidthsMatchLayout({begin:i[0],mid:i[1],end:i[2]},t)};_.prototype._saveResizedColumWidths=function(){var e=this._oMoveInfo.layout,t=this._convertColumnPxWidthToPercent(this._oMoveInfo.columnWidths,e),o=Object.values(t).join("/");if(this._isValidWidthDistributionForLayout(o,e)){this._getLocalStorage().put(e,o)}};_.prototype._getNextLayoutOnResizeByDrag=function(e,t,o,n,i){function s(e){return e.from===t&&e.separator===o&&e.forward===n}var r=e.begin,a=Math.ceil(this._convertColumnPxWidthToPercent(r,t)),u=this.getMaxColumnsCount(),l=u===2;if(s({from:c.TwoColumnsMidExpanded,separator:"begin",forward:true})&&e.begin>=e.mid){return c.TwoColumnsBeginExpanded}if(s({from:c.TwoColumnsBeginExpanded,separator:"begin",forward:false})&&e.begin<e.mid){return c.TwoColumnsMidExpanded}if(s({from:c.ThreeColumnsMidExpanded,separator:"begin",forward:true})&&a>=33){return c.ThreeColumnsMidExpandedEndHidden}if(s({from:c.ThreeColumnsMidExpandedEndHidden,separator:"begin",forward:false})&&a<33){return c.ThreeColumnsMidExpanded}if(s({from:c.ThreeColumnsMidExpandedEndHidden,separator:"end",forward:false})&&(e.end>=_.COLUMN_MIN_WIDTH||i)){return c.ThreeColumnsMidExpanded}if(s({from:c.ThreeColumnsMidExpanded,separator:"end",forward:false})&&e.mid<e.end){return c.ThreeColumnsEndExpanded}if(s({from:c.ThreeColumnsEndExpanded,separator:"end",forward:true})&&e.mid>=e.end){return c.ThreeColumnsMidExpanded}if(s({from:c.ThreeColumnsMidExpandedEndHidden,separator:"begin",forward:true})&&e.begin>=e.mid){return c.ThreeColumnsBeginExpandedEndHidden}if(s({from:c.ThreeColumnsBeginExpandedEndHidden,separator:"begin",forward:false})&&e.begin<e.mid){return c.ThreeColumnsMidExpandedEndHidden}if(s({from:c.ThreeColumnsMidExpanded,separator:"begin",forward:true})&&l&&(r>=_.COLUMN_MIN_WIDTH||i)){return c.ThreeColumnsMidExpandedEndHidden}if(s({from:c.TwoColumnsMidExpandedEndHidden,separator:"end",forward:false})&&l&&(e.end>=_.COLUMN_MIN_WIDTH||i)){return c.ThreeColumnsMidExpanded}return t};_.prototype._verifyColumnWidthsMatchLayout=function(e,t){var o=this.getMaxColumnsCount(),n=e.begin,i=Math.ceil(this._convertColumnPxWidthToPercent(n,t)),s={[c.TwoColumnsBeginExpanded]:function(){return e.begin>=e.mid},[c.TwoColumnsMidExpanded]:function(){return e.mid>e.begin},[c.ThreeColumnsEndExpanded]:function(){return e.end>e.mid&&i<33},[c.ThreeColumnsBeginExpandedEndHidden]:function(){return e.begin>=e.mid&&e.end===0},[c.ThreeColumnsMidExpanded]:function(){return e.mid>=e.end&&(o===3&&i<33||o===2&&i===0)},[c.ThreeColumnsMidExpandedEndHidden]:function(){return e.mid>e.begin&&e.end===0&&(o===3&&i>=33||o===2&&n>=_.COLUMN_MIN_WIDTH)}};return s[t]()};_.prototype._getColumnWidth=function(e){var t=this._$columns[e].get(0),o=t.style.width,n=parseInt(o),i;if(/px$/.test(o)){return n}i=/%$/.test(o);if(i&&n===100){return this._getControlWidth()}if(i&&n===0){return 0}return t.offsetWidth};_.prototype._cacheColumnWidth=function(e,t){var o;if(this._oColumnWidthInfo[e]!==t){o={};_.COLUMN_ORDER.forEach(function(t){o[t+"Column"]=t===e});this.fireColumnResize(o)}this._oColumnWidthInfo[e]=t};_.prototype._getLastVisibleColumnForLayout=function(e){var t=_.COLUMN_ORDER.slice(),o=this._getMaxColumnsCountForLayout(e,_.DESKTOP_BREAKPOINT);if(o>1){return t[o-1]}if(e===c.OneColumn){return"begin"}if(e===c.MidColumnFullScreen){return"mid"}if(e===c.EndColumnFullScreen){return"end"}};_.prototype._isNavigatingBackward=function(e,t){return[c.MidColumnFullScreen,c.EndColumnFullScreen].indexOf(t)>-1||_.COLUMN_ORDER.indexOf(this._getLastVisibleColumnForLayout(t))>_.COLUMN_ORDER.indexOf(this._getLastVisibleColumnForLayout(e))};_.prototype._shouldRevealColumn=function(e,t,o){var n=this._getMaxColumnsCountForLayout(t,_.DESKTOP_BREAKPOINT),i=this._getLastVisibleColumnForLayout(t),s=e===i,r=this._getMaxColumnsCountForLayout(o,_.DESKTOP_BREAKPOINT),a=o===c.MidColumnFullScreen||o===c.EndColumnFullScreen;return n>r&&!a&&s};_.prototype._isInteractivelyResizedColumn=function(e){return this._oMoveInfo&&this._isColumnAdjacentToDraggedSeparator(e)};_.prototype._isColumnAdjacentToDraggedSeparator=function(e){return this._oMoveInfo&&this._oMoveInfo.separator&&(this._$columns[e][0]===this._oMoveInfo.separator.previousElementSibling||this._$columns[e][0]===this._oMoveInfo.separator.nextElementSibling)};_.prototype._shouldConcealColumn=function(e,t,o){var n=this._getMaxColumnsCountForLayout(t,_.DESKTOP_BREAKPOINT),i=this._getMaxColumnsCountForLayout(o,_.DESKTOP_BREAKPOINT),s=this._getLastVisibleColumnForLayout(o),r=o===c.MidColumnFullScreen||o===c.EndColumnFullScreen;return n<i&&e===s&&!r&&this._getColumnSizeForLayout(e,t)===0};_.prototype._canResizeColumnWithAnimation=function(e,t){var o,n=t.width,i=t.hasAnimations,s=t.hidden,r=!t.previousAnimationCompleted;if(!i||s){return false}if(this._isInteractivelyResizedColumn(e)){return false}o=this._$columns[e];if(r){return o.width()!==n}if(this._bNeverRendered||t.autoSize){return false}return this._getColumnWidth(e)!==n};_.prototype._propagateContextualSettings=function(){};_.prototype._updateColumnContextualSettings=function(e,t){var o,n;o=this.getAggregation("_"+e+"ColumnNav");if(!o){return}n=o._getContextualSettings();if(!n||n.contextualWidth!==t){o._applyContextualSettings({contextualWidth:t})}};_.prototype._updateColumnCSSClasses=function(e,t){var n="";this._$columns[e].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(t<o.media._predefinedRangeSets[o.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){n="Narrow"}else if(t<o.media._predefinedRangeSets[o.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){n="Medium"}else if(t<o.media._predefinedRangeSets[o.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){n="Wide"}else{n="ExtraWide"}this._$columns[e].addClass("sapUiContainer-"+n)};_.prototype._getColumnSizeForLayout=function(e,t){var o=this._getColumnWidthDistributionForLayout(t),n=o.split("/"),i={begin:0,mid:1,end:2},s=n[i[e]];return parseFloat(s)};_.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth())};_.prototype._getMaxColumnsCountForWidth=function(e){if(e>=_.DESKTOP_BREAKPOINT){return 3}if(e>=_.TABLET_BREAKPOINT&&e<_.DESKTOP_BREAKPOINT){return 2}if(e>0){return 1}return 0};_.prototype._getMaxColumnsCountForLayout=function(e,t){var o=this._getMaxColumnsCountForWidth(t),n=this._getColumnWidthDistributionForLayout(e,false,o),i=n.split("/"),s={begin:0,mid:1,end:2},r,a,u=0;Object.keys(s).forEach(function(e){r=i[s[e]];a=parseInt(r);if(a){u++}});return u};_.prototype._onResize=function(e){var t=e.oldSize.width,o=e.size.width,n,i;this._iWidth=o;if(o===0){return}n=this._getMaxColumnsCountForWidth(t);i=this._getMaxColumnsCountForWidth(o);this._resizeColumns();if(i!==n){this._fireStateChange(false,true)}};_.prototype._setColumnPagesRendered=function(e,t){this._oRenderedColumnPagesBoolMap[e]=t};_.prototype._hasAnyColumnPagesRendered=function(){return Object.keys(this._oRenderedColumnPagesBoolMap).some(function(e){return this._oRenderedColumnPagesBoolMap[e]},this)};_.prototype._getRequiredColumnSeparatorsForLayout=function(e){var t={},n=[],i;if(o.system.phone){return[]}i=this.getMaxColumnsCount();if(i>1){t[c.TwoColumnsBeginExpanded]=["begin"];t[c.TwoColumnsMidExpanded]=["begin"];t[c.ThreeColumnsMidExpanded]=["begin","end"];t[c.ThreeColumnsEndExpanded]=["end"];t[c.ThreeColumnsMidExpandedEndHidden]=["begin","end"];t[c.ThreeColumnsBeginExpandedEndHidden]=["begin"];if(typeof t[e]==="object"){n=t[e]}}return n};_.prototype._hideShowColumnSeparators=function(e){var t=[],n;if(!this.isActive()||o.system.phone){return}e||(e=this.getLayout());t=this._getRequiredColumnSeparatorsForLayout(e);n=this._hasAnyColumnPagesRendered();Object.keys(this._oColumnSeparators).forEach(function(e){this._toggleSeparator(e,t.indexOf(e)!==-1,n)},this)};_.prototype._toggleSeparator=function(e,t,o){this._oColumnSeparators[e].toggle(t&&o);this._oColumnSeparators[e].data("visible",t)};_.prototype._fireStateChange=function(e,t){if(this._getControlWidth()===0){return}this.fireStateChange({isNavigationArrow:e,isResize:t,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()})};_.prototype.setInitialBeginColumnPage=function(e){this._getBeginColumn().setInitialPage(e);this.setAssociation("initialBeginColumnPage",e,true);return this};_.prototype.setInitialMidColumnPage=function(e){this._getMidColumn().setInitialPage(e);this.setAssociation("initialMidColumnPage",e,true);return this};_.prototype.setInitialEndColumnPage=function(e){this._getEndColumn().setInitialPage(e);this.setAssociation("initialEndColumnPage",e,true);return this};_.prototype.to=function(e,t,o,n){if(this._getBeginColumn().getPage(e)){this._getBeginColumn().to(e,t,o,n)}else if(this._getMidColumn().getPage(e)){this._getMidColumn().to(e,t,o,n)}else{this._getEndColumn().to(e,t,o,n)}return this};_.prototype.backToPage=function(e,t,o){if(this._getBeginColumn().getPage(e)){this._getBeginColumn().backToPage(e,t,o)}else if(this._getMidColumn().getPage(e)){this._getMidColumn().backToPage(e,t,o)}else{this._getEndColumn().backToPage(e,t,o)}return this};_.prototype._safeBackToPage=function(e,t,o,n){if(this._getBeginColumn().getPage(e)){this._getBeginColumn()._safeBackToPage(e,t,o,n)}else if(this._getMidColumn().getPage(e)){this._getMidColumn()._safeBackToPage(e,t,o,n)}else{this._getEndColumn()._safeBackToPage(e,t,o,n)}};_.prototype.toBeginColumnPage=function(e,t,o,n){this._getBeginColumn().to(e,t,o,n);return this};_.prototype.toMidColumnPage=function(e,t,o,n){this._getMidColumn().to(e,t,o,n);return this};_.prototype.toEndColumnPage=function(e,t,o,n){this._getEndColumn().to(e,t,o,n);return this};_.prototype.backBeginColumn=function(e,t){return this._getBeginColumn().back(e,t)};_.prototype.backMidColumn=function(e,t){return this._getMidColumn().back(e,t)};_.prototype.backEndColumn=function(e,t){return this._getEndColumn().back(e,t)};_.prototype.backBeginColumnToPage=function(e,t,o){return this._getBeginColumn().backToPage(e,t,o)};_.prototype.backMidColumnToPage=function(e,t,o){return this._getMidColumn().backToPage(e,t,o)};_.prototype.backEndColumnToPage=function(e,t,o){return this._getEndColumn().backToPage(e,t,o)};_.prototype.backToTopBeginColumn=function(e,t){this._getBeginColumn().backToTop(e,t);return this};_.prototype.backToTopMidColumn=function(e,t){this._getMidColumn().backToTop(e,t);return this};_.prototype.backToTopEndColumn=function(e,t){this._getEndColumn().backToTop(e,t);return this};_.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage()};_.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage()};_.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage()};_.prototype.setDefaultTransitionNameBeginColumn=function(e){this.setProperty("defaultTransitionNameBeginColumn",e,true);this._getBeginColumn().setDefaultTransitionName(e);return this};_.prototype.setDefaultTransitionNameMidColumn=function(e){this.setProperty("defaultTransitionNameMidColumn",e,true);this._getMidColumn().setDefaultTransitionName(e);return this};_.prototype.setDefaultTransitionNameEndColumn=function(e){this.setProperty("defaultTransitionNameEndColumn",e,true);this._getEndColumn().setDefaultTransitionName(e);return this};_.prototype._getLayoutHistory=function(){return this._oLayoutHistory};_.prototype._getColumnWidthDistributionForLayout=function(e,t,o){var n=this._getLocalStorage(o).get(e),i;o||(o=this.getMaxColumnsCount());if(o===0){i="0/0/0"}else if(o>1&&n){i=n}else{i=this._getDefaultColumnWidthDistributionForLayout(e,o)}if(t){i=i.split("/").map(function(e){return parseInt(e)})}return i};_.prototype._getDefaultColumnWidthDistributionForLayout=function(e,t){var o={};o[c.OneColumn]="100/0/0";o[c.MidColumnFullScreen]="0/100/0";o[c.EndColumnFullScreen]="0/0/100";if(t===1){o[c.TwoColumnsBeginExpanded]="0/100/0";o[c.TwoColumnsMidExpanded]="0/100/0";o[c.ThreeColumnsMidExpanded]="0/0/100";o[c.ThreeColumnsEndExpanded]="0/0/100";o[c.ThreeColumnsMidExpandedEndHidden]="0/0/100";o[c.ThreeColumnsBeginExpandedEndHidden]="0/0/100"}else{o[c.TwoColumnsBeginExpanded]="67/33/0";o[c.TwoColumnsMidExpanded]="33/67/0";o[c.ThreeColumnsMidExpanded]=t===2?"0/67/33":"25/50/25";o[c.ThreeColumnsEndExpanded]=t===2?"0/33/67":"25/25/50";o[c.ThreeColumnsMidExpandedEndHidden]="33/67/0";o[c.ThreeColumnsBeginExpandedEndHidden]="67/33/0"}return o[e]};_.prototype._attachAfterColumnResizedOnce=function(e,t,o){this._oAnimationEndListener.waitForColumnResizeEnd(this._$columns[e]).then(t).catch(function(){o&&o()})};_.prototype._attachAfterAllColumnsResizedOnce=function(e,t){this._oAnimationEndListener.waitForAllColumnsResizeEnd().then(e).catch(function(){t&&t()})};_.DESKTOP_BREAKPOINT=1280;_.TABLET_BREAKPOINT=960;_.COLUMN_MIN_WIDTH=312;_.STORAGE_PREFIX_TABLET="sap-f-fcl-tablet-column-width-distributions";_.STORAGE_PREFIX_DESKTOP="sap-f-fcl-desktop-column-width-distributions";_._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f")};_.prototype.showPlaceholder=function(e){var t=sap.ui.require("sap/ui/core/Placeholder");if(!t||!t.isEnabled()){return}switch(e&&e.aggregation){case"beginColumnPages":return this.getAggregation("_beginColumnNav").showPlaceholder(e);case"midColumnPages":return this.getAggregation("_midColumnNav").showPlaceholder(e);default:return this.getAggregation("_endColumnNav").showPlaceholder(e)}};_.prototype.hidePlaceholder=function(e){switch(e.aggregation){case"beginColumnPages":this.getAggregation("_beginColumnNav").hidePlaceholder(e);break;case"midColumnPages":this.getAggregation("_midColumnNav").hidePlaceholder(e);break;default:this.getAggregation("_endColumnNav").hidePlaceholder(e)}};_.prototype.needPlaceholder=function(e,t){var o;switch(e){case"beginColumnPages":o=this.getAggregation("_beginColumnNav");break;case"midColumnPages":o=this.getAggregation("_midColumnNav");break;default:o=this.getAggregation("_endColumnNav")}return!t||o.getCurrentPage()!==t};function y(){this._aLayoutHistory=[]}y.prototype.addEntry=function(e){if(typeof e!=="undefined"){this._aLayoutHistory.push(e)}};y.prototype.getEntry=function(e,t){var o=this._aLayoutHistory;if(t){o=this._aLayoutHistory.slice().reverse()}return o[e]};y.prototype.getClosestEntryThatMatches=function(e){var t;for(t=this._aLayoutHistory.length-1;t>=0;t--){if(e.indexOf(this._aLayoutHistory[t])!==-1){return this._aLayoutHistory[t]}}};function v(){this._oListeners={};this._aPendingPromises=[];this._oPendingPromises={};this._oCancelPromises={};this._oPendingPromiseAll=null}v.prototype.waitForColumnResizeEnd=function(e){var t=e.get(0).id,o;if(!this._oPendingPromises[t]){o=new Promise(function(o,n){h.debug("FlexibleColumnLayout","wait for column "+t+" to resize");this._attachTransitionEnd(e,function(){h.debug("FlexibleColumnLayout","completed column "+t+" resize");this._cleanUp(e);o()}.bind(this));this._oCancelPromises[t]={cancel:function(){h.debug("FlexibleColumnLayout","cancel column "+t+" resize");this._cleanUp(e);n()}.bind(this)}}.bind(this));this._aPendingPromises.push(o);this._oPendingPromises[t]=o}return this._oPendingPromises[t]};v.prototype.waitForAllColumnsResizeEnd=function(){if(!this._oPendingPromiseAll){this._oPendingPromiseAll=new Promise(function(e,t){this.iTimer=setTimeout(function(){Promise.all(this._aPendingPromises).then(function(){h.debug("FlexibleColumnLayout","completed all columns resize");e()},0).catch(function(){t()});this.iTimer=null}.bind(this))}.bind(this))}return this._oPendingPromiseAll};v.prototype.isWaitingForColumnResizeEnd=function(e){var t=e.get(0).id;return!!this._oListeners[t]};v.prototype.cancelAll=function(){Object.keys(this._oCancelPromises).forEach(function(e){this._oCancelPromises[e].cancel()},this);this._oPendingPromises={};this._aPendingPromises=[];this._oCancelPromises={};this._oPendingPromiseAll=null;this._oListeners={};if(this.iTimer){clearTimeout(this.iTimer);this.iTimer=null}h.debug("FlexibleColumnLayout","detached all listeners for columns resize")};v.prototype._attachTransitionEnd=function(e,t){var o=e.get(0).id;if(!this._oListeners[o]){e.on("webkitTransitionEnd transitionend",t);this._oListeners[o]=t}};v.prototype._detachTransitionEnd=function(e){var t=e.get(0).id;if(this._oListeners[t]){e.off("webkitTransitionEnd transitionend",this._oListeners[t]);this._oListeners[t]=null}};v.prototype._cleanUp=function(e){if(e.length){var t=e.get(0).id;this._detachTransitionEnd(e);delete this._oPendingPromises[t];delete this._oCancelPromises[t]}};function E(e,t,o){var n;if(e===t){return"100%"}n=o?e-_.COLUMN_SEPARATOR_WIDTH:e;return n+"px"}function M(e){return e.classList.contains("sapFFCLColumnSeparatorBegin")?"begin":"end"}function b(e,t,o){var n=e.classList.contains("sapFFCLColumnSeparatorBegin");if(o===2&&t==c.ThreeColumnsMidExpandedEndHidden){return n?["begin","mid"]:["begin","end"]}if(o===2&&t==c.ThreeColumnsMidExpanded){return n?["begin","end"]:["mid","end"]}return n?["begin","mid"]:["mid","end"]}function T(e){var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}return t.pageX}return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/FlexibleColumnLayoutAccessibleLandmarkInfo", ["sap/ui/core/Element","./library"],function(l,e){"use strict";var a=l.extend("sap.f.FlexibleColumnLayoutAccessibleLandmarkInfo",{metadata:{library:"sap.f",properties:{firstColumnLabel:{type:"string",defaultValue:null},middleColumnLabel:{type:"string",defaultValue:null},lastColumnLabel:{type:"string",defaultValue:null},firstColumnBackArrowLabel:{type:"string",defaultValue:null},middleColumnForwardArrowLabel:{type:"string",defaultValue:null},middleColumnBackArrowLabel:{type:"string",defaultValue:null},lastColumnForwardArrowLabel:{type:"string",defaultValue:null}}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/FlexibleColumnLayoutRenderer", ["sap/ui/Device","sap/ui/core/Core","sap/m/library"],function(e,n,r){"use strict";var a=n.getLibraryResourceBundle("sap.f");var o={apiVersion:2};o.render=function(e,n){var a=n.getBackgroundDesign(),t=n.getLandmarkInfo();e.openStart("div",n);e.class("sapFFCL");if(a!==r.BackgroundDesign.Transparent){e.class("sapFFCLBackgroundDesign"+a)}e.openEnd();o.renderBeginColumn(e,n,t);o.renderSeparator(e,n.getId()+"-separator-begin","sapFFCLColumnSeparatorBegin");o.renderMidColumn(e,n,t);o.renderSeparator(e,n.getId()+"-separator-end","sapFFCLColumnSeparatorEnd");o.renderEndColumn(e,n,t);o.renderOverlay(e,n);e.close("div")};o.renderBeginColumn=function(e,n,r){e.openStart("div",n.getId()+"-beginColumn");e.accessibilityState(n,n._formatColumnLandmarkInfo(r,"FirstColumn"));e.class("sapFFCLColumn");e.class("sapFFCLColumnBegin");e.class("sapFFCLColumnActive");e.openEnd();o.renderColumnContentWrapper(e);e.close("div")};o.renderMidColumn=function(e,n,r){e.openStart("div",n.getId()+"-midColumn");e.accessibilityState(n,n._formatColumnLandmarkInfo(r,"MiddleColumn"));e.class("sapFFCLColumn");e.class("sapFFCLColumnMid");e.openEnd();o.renderColumnContentWrapper(e);e.close("div")};o.renderEndColumn=function(e,n,r){e.openStart("div",n.getId()+"-endColumn");e.accessibilityState(n,n._formatColumnLandmarkInfo(r,"LastColumn"));e.class("sapFFCLColumn");e.class("sapFFCLColumnEnd");e.openEnd();o.renderColumnContentWrapper(e);e.close("div")};o.renderSeparator=function(n,r,t){if(!e.system.phone){n.openStart("div",r).attr("role","separator").attr("title",a.getText("FCL_SEPARATOR_MOVE")).attr("aria-orientation","vertical").attr("tabindex",0).class("sapFFCLColumnSeparator").class("sapContrastPlus").class(t).openEnd();o.renderSeparatorGripAndDecorations(n);n.close("div")}};o.renderSeparatorGripAndDecorations=function(e){e.openStart("div").class("sapFFCLColumnSeparatorDecorationBefore").openEnd().close("div");e.openStart("div").class("sapFFCLColumnSeparatorGrip").openEnd().icon("sap-icon://vertical-grip",["sapFFCLColumnSeparatorGripIcon"]).close("div");e.openStart("div").class("sapFFCLColumnSeparatorDecorationAfter").openEnd().close("div")};o.renderColumnContentWrapper=function(e){e.openStart("div");e.class("sapFFCLColumnContent");e.openEnd();e.close("div")};o.renderOverlay=function(n,r){if(!e.system.phone){n.openStart("div",r.getId()+"-overlay").class("sapFFCLOverlay").openEnd();o.renderSeparator(n,r.getId()+"-overlaySeparator","sapFFCLOverlaySeparator");n.close("div")}};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/FlexibleColumnLayoutSemanticHelper", ["./library","./FlexibleColumnLayout","sap/base/assert"],function(e,n,t){"use strict";var o=e.LayoutType;var u=function(e,n){var t={Normal:3,MasterDetail:2,SingleColumn:1},u,l;n||(n={});this._oFCL=e;this._defaultLayoutType=o.OneColumn;this._defaultTwoColumnLayoutType=[o.TwoColumnsBeginExpanded,o.TwoColumnsMidExpanded].indexOf(n.defaultTwoColumnLayoutType)!==-1?n.defaultTwoColumnLayoutType:o.TwoColumnsBeginExpanded;this._defaultThreeColumnLayoutType=[o.ThreeColumnsMidExpanded,o.ThreeColumnsEndExpanded].indexOf(n.defaultThreeColumnLayoutType)!==-1?n.defaultThreeColumnLayoutType:o.ThreeColumnsMidExpanded;if(["Normal","MasterDetail","SingleColumn"].indexOf(n.mode)!==-1&&!n.maxColumnsCount){l=t[n.mode]}else{l=n.maxColumnsCount?parseInt(n.maxColumnsCount):3;if(l<1||l>3){l=3}}this._maxColumnsCount=l;u=n.initialColumnsCount?parseInt(n.initialColumnsCount):1;if(u<1||u>2||this._maxColumnsCount===1){u=1}this._initialColumnsCount=u};u._oInstances={};u.getInstanceFor=function(e,o){t(e instanceof n,"Passed control is not FlexibleColumnLayout");var l=e.getId();if(typeof u._oInstances[l]==="undefined"){u._oInstances[l]=new u(e,o);var i={onDestroy:function(){delete u._oInstances[l]}};e.addEventDelegate(i)}return u._oInstances[l]};u.prototype.getCurrentUIState=function(){var e=this._oFCL.getLayout();return this._getUIStateForLayout(e)};u.prototype.getNextUIState=function(e){var n=this._oFCL.getLayout(),t=this._initialColumnsCount,u;if(e===0){if(t===2&&this._canShowTwoColumns()){u=this._defaultTwoColumnLayoutType}else{u=o.OneColumn}}if(e===1){if(this._maxColumnsCount===1){u=o.MidColumnFullScreen}else{if([o.TwoColumnsBeginExpanded,o.TwoColumnsMidExpanded].indexOf(n)!==-1){u=n}else if([o.MidColumnFullScreen,o.EndColumnFullScreen].indexOf(n)!==-1){u=o.MidColumnFullScreen}else{u=this._defaultTwoColumnLayoutType}}}if(e===2){if(this._maxColumnsCount<3){u=o.EndColumnFullScreen}else{if([o.ThreeColumnsMidExpandedEndHidden,o.ThreeColumnsBeginExpandedEndHidden].indexOf(n)!==-1){u=this._defaultThreeColumnLayoutType}else if([o.ThreeColumnsMidExpanded,o.ThreeColumnsEndExpanded].indexOf(n)!==-1){u=n}else if([o.MidColumnFullScreen,o.EndColumnFullScreen].indexOf(n)!==-1){u=o.EndColumnFullScreen}else{u=this._defaultThreeColumnLayoutType}}}if(e>2){u=o.EndColumnFullScreen}return this._getUIStateForLayout(u)};u.prototype._getUIStateForLayout=function(e){var n=this._oFCL._getColumnWidthDistributionForLayout(e,true),t=this._oFCL.getMaxColumnsCount(),o=this._oFCL._getDefaultColumnWidthDistributionForLayout(e,t);return{layout:e,maxColumnsCount:t,columnsSizes:this._getColumnsSizes(n),columnsVisibility:this._getColumnsVisibility(n),isFullScreen:this._getIsFullScreen(n),isLogicallyFullScreen:this._getIsLogicallyFullScreen(e),actionButtonsInfo:this._getActionButtonsInfo(o,t)}};u.prototype._getColumnsSizes=function(e){return{beginColumn:e[0],midColumn:e[1],endColumn:e[2]}};u.prototype._getColumnsVisibility=function(e){return{beginColumn:e[0]!==0,midColumn:e[1]!==0,endColumn:e[2]!==0}};u.prototype._getIsFullScreen=function(e){return e.indexOf(100)!==-1};u.prototype._getIsLogicallyFullScreen=function(e){return[o.OneColumn,o.MidColumnFullScreen,o.EndColumnFullScreen].indexOf(e)!==-1};u.prototype._getActionButtonsInfo=function(e,n){var t={fullScreen:null,exitFullScreen:null,closeColumn:null},u={fullScreen:null,exitFullScreen:null,closeColumn:null},l,i;if(this._maxColumnsCount===1){return{midColumn:t,endColumn:u}}if(n===1){t.closeColumn=this._defaultLayoutType;u.closeColumn=this._defaultTwoColumnLayoutType}else{if(e==="67/33/0"||e==="33/67/0"){t.fullScreen=o.MidColumnFullScreen;t.closeColumn=this._defaultLayoutType}if(e==="25/50/25"||e==="25/25/50"||e==="0/67/33"||e==="0/33/67"){u.fullScreen=o.EndColumnFullScreen;u.closeColumn=this._defaultTwoColumnLayoutType}if(e==="0/100/0"){l=[o.TwoColumnsBeginExpanded,o.TwoColumnsMidExpanded,o.ThreeColumnsBeginExpandedEndHidden,o.ThreeColumnsMidExpandedEndHidden];i=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(l)||this._defaultTwoColumnLayoutType;t.exitFullScreen=i;t.closeColumn=this._defaultLayoutType}if(e==="0/0/100"){if(this._maxColumnsCount!==2){l=[o.ThreeColumnsMidExpanded,o.ThreeColumnsEndExpanded];i=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(l)||this._defaultThreeColumnLayoutType;u.exitFullScreen=i;u.closeColumn=this._defaultTwoColumnLayoutType}}}return{midColumn:t,endColumn:u}};u.prototype.getDefaultLayouts=function(){return{defaultLayoutType:this._defaultLayoutType,defaultTwoColumnLayoutType:this._defaultTwoColumnLayoutType,defaultThreeColumnLayoutType:this._defaultThreeColumnLayoutType}};u.prototype._canShowTwoColumns=function(){var e=this._oFCL._getControlWidth(),n=this._oFCL._getMaxColumnsCountForWidth(e||window.innerWidth);return n>1};u.prototype.isReady=function(){return this.isDOMReady()};u.prototype.isDOMReady=function(){return this._oFCL.getDomRef()!==null};u.prototype.whenReady=function(){var e=this;return new Promise(function(n,t){e.whenDOMReady().then(function(){n()}).catch(function(e){t(e)})})};u.prototype.whenDOMReady=function(){var e=this;var n=new Promise(function(n,t){if(!e._oFCL||e._oFCL.bIsDestroyed){t("FlexibleColumnLayout reference missing. Please make sure FlexibleColumnLayoutSemanticHelper is properly initialized.")}if(e._oFCL.getDomRef()){n()}else{var o={onAfterRendering:function(){e._oFCL.removeEventDelegate(o);n()}};e._oFCL.addEventDelegate(o)}});return n};return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridContainer", ["./GridContainerRenderer","./GridContainerSettings","./GridContainerUtils","./GridNavigationMatrix","./delegate/GridContainerItemNavigation","./library","./dnd/GridKeyboardDragAndDrop","sap/base/strings/capitalize","sap/ui/core/delegate/ItemNavigation","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/core/InvisibleMessage","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(e,t,i,r,s,n,o,a,u,l,p,h,g,d,c,f,m,jQuery){"use strict";var y={"sap.f.Card":function(e){return e.getCardHeader()||e.getCardContent()},"sap.ui.integration.widgets.Card":function(e){return e.getCardHeader()||e.getCardContent()},"sap.m.GenericTile":function(){return true}};function _(e){var t=e.getLayoutData();return t?t.getColumns():1}function v(e){var t=e.getLayoutData();return t?t.getActualRows():1}function I(e){var t=e.getLayoutData();return t?t.hasAutoHeight():true}var C=p.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},minHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"2rem"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",multiple:false},layoutS:{type:"sap.f.GridContainerSettings",multiple:false},layoutM:{type:"sap.f.GridContainerSettings",multiple:false},layoutL:{type:"sap.f.GridContainerSettings",multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{layoutChange:{parameters:{layout:{type:"string"}}},columnsChange:{parameters:{columns:{type:"int"}}},borderReached:{parameters:{event:{type:"jQuery.Event"},direction:{type:"sap.f.NavigationDirection"},row:{type:"int"},column:{type:"int"}}}},dnd:{draggable:false,droppable:true}},renderer:e});C.prototype.bUseExtendedChangeDetection=true;C.prototype.getActiveLayoutSettings=function(){var e=this.getAggregation(this._sActiveLayout);if(!e&&this._sActiveLayout==="layoutXS"){e=this.getAggregation("layoutS")}if(!e){e=this.getAggregation("layout")||this.getAggregation("_defaultLayout")}return e};C.prototype._onBeforeItemRendering=function(){var e=this.getParent();if(e._resizeListeners[this.getId()]){d.deregister(e._resizeListeners[this.getId()]);delete e._resizeListeners[this.getId()]}e._reflectItemVisibilityToWrapper(this)};C.prototype._onAfterItemRendering=function(){var e=this.getParent();e._checkOwnVisualFocus(this);e._resizeListeners[this.getId()]=d.register(this,e._resizeItemHandler);e._setItemNavigationItems();e._applyItemAutoRows(this)};C.prototype._onItemWrapperFocusIn=function(e){var t=this._oItemNavigation.getFocusedDomRef(),i,r;if(!t||!t.firstChild){return}i=g.closestTo(t.firstChild);if(!i||!i.getAriaRoleDescription){return}r=i.getAriaRoleDescription();if(r){c.getInstance().announce(r)}};C.prototype._reflectItemVisibilityToWrapper=function(e){var t=i.getItemWrapper(e),r;if(!t){return}r=jQuery(t);if(e.getVisible()&&r.hasClass("sapFGridContainerInvisiblePlaceholder")){r.removeClass("sapFGridContainerInvisiblePlaceholder")}else if(!e.getVisible()&&!r.hasClass("sapFGridContainerInvisiblePlaceholder")){r.addClass("sapFGridContainerInvisiblePlaceholder")}};C.prototype._onItemChange=function(e){if(e.name!=="items"||!e.child){return}if(e.mutation==="insert"){e.child.addEventDelegate(this._itemDelegate,e.child)}else if(e.mutation==="remove"){e.child.removeEventDelegate(this._itemDelegate,e.child)}};C.prototype._deregisterResizeListeners=function(){var e,t;for(e in this._resizeListeners){t=this._resizeListeners[e];d.deregister(t)}delete this._resizeListeners;f.resize.detachHandler(this._resizeDeviceHandler)};C.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return}var e=this,t=[];if(!e._oItemNavigation){e._oItemNavigation=(new s).setCycling(false).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"]}).setTableMode(true,true).setFocusedIndex(0).attachEvent(u.Events.AfterFocus,this._onItemWrapperFocusIn.bind(this));e.addDelegate(this._oItemNavigation)}e.$().children().map(function(e,i){if(i.getAttribute("class").indexOf("sapFGridContainerItemWrapper")>-1){t.push(i)}});e._oItemNavigation.setRootDomRef(e.getDomRef());e._oItemNavigation.setItemDomRefs(t)};C.prototype._detectActiveLayout=function(){var e=this.getContainerQuery()&&this.getDomRef()?this._getComputedWidth():f.resize.width,t=f.media.getCurrentRange("GridContainerRangeSet",e),i="layout"+t.name,r=this.getActiveLayoutSettings(),s=false;if(!e){return false}if(this._sActiveLayout!==i){this.addStyleClass("sapFGridContainer"+a(i));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+a(this._sActiveLayout))}this._sActiveLayout=i;s=r!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout})}return s};C.prototype._detectColumnsChange=function(){var e=this.getActiveLayoutSettings(),t=this.$().innerWidth(),i;if(!e){return}i=e.getComputedColumnsCount(t);if(this._iColumns!==i){this.fireColumnsChange({columns:i});this._iColumns=i}};C.prototype._getActiveGridStyles=function(){var e=this.getActiveLayoutSettings(),t=e.getColumns()||"auto-fill",i=e.getColumnSize(),r=e.getMinColumnSize(),s=e.getMaxColumnSize(),n={"grid-gap":e.getGap()};if(r&&s){n["grid-template-columns"]="repeat("+t+", minmax("+r+", "+s+"))"}else{n["grid-template-columns"]="repeat("+t+", "+i+")"}if(this.getInlineBlockLayout()){n["grid-auto-rows"]="min-content"}else{n["grid-auto-rows"]=e.getRowSize()}return n};C.prototype.init=function(){this._oRb=h.getLibraryResourceBundle("sap.f");this.setAggregation("_defaultLayout",new t);this._initRangeSet();this._resizeListeners={};this._oItemNavigation=null;this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new l(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);this._resizeDeviceHandler=this._resizeDevice.bind(this);f.resize.attachHandler(this._resizeDeviceHandler);this._resizeItemHandler=this._resizeItem.bind(this)};C.prototype.insertItem=function(e,t){this.insertAggregation("items",e,t,true);if(!this.getDomRef()||!e.getVisible()){this.invalidate();return this}var r=h.createRenderManager(),s=this._createItemWrapper(e),n=this._getItemAt(t+1),o=this.getDomRef();if(n){o.insertBefore(s,i.getItemWrapper(n))}else{o.insertBefore(s,o.lastChild)}r.render(e,s);r.destroy();return this};C.prototype.removeItem=function(e){var t=this.removeAggregation("items",e,true),i=this.getDomRef(),r=t.getDomRef();if(!i||!r){this.invalidate();return t}i.removeChild(r.parentElement);return t};C.prototype.onBeforeRendering=function(){this._detectActiveLayout();var e=this._resizeListeners[this.getId()];if(e){d.deregister(e)}c.getInstance();this._isRenderingFinished=false;this._lastGridWidth=null;this._lastViewportWidth=null};C.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=d.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);if(this.getItems().length===1&&this._forceFocus){this.focusItem(0);this._forceFocus=false}};C.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;this._oItemNavigation=null}this._forceFocus=null;if(this._checkColumnsTimeout){clearTimeout(this._checkColumnsTimeout);this._checkColumnsTimeout=null}};C.prototype._initRangeSet=function(){if(!f.media.hasRangeSet("GridContainerRangeSet")){f.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"])}};C.prototype._resize=function(){if(!this._isWidthChanged()){return}var e=this._detectActiveLayout();this._applyLayout(e)};C.prototype._resizeDevice=function(){if(!this.getContainerQuery()){this._resize()}};C.prototype._isWidthChanged=function(){var e=this._getComputedWidth(),t=f.resize.width;if(this._lastGridWidth===e&&this._lastViewportWidth===t){return false}this._lastGridWidth=e;this._lastViewportWidth=t;return true};C.prototype._getComputedWidth=function(){if(!this.getDomRef()){return null}return this.getDomRef().getBoundingClientRect().width};C.prototype._resizeItem=function(e){this._applyItemAutoRows(e.control)};C.prototype._applyLayout=function(e){if(!this._isRenderingFinished){return}if(e){this.$().css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this))}this._checkColumns()};C.prototype._checkColumns=function(){if(this._checkColumnsTimeout){clearTimeout(this._checkColumnsTimeout);this._checkColumnsTimeout=null}this._checkColumnsTimeout=setTimeout(function(){this._detectColumnsChange();this._enforceMaxColumns()}.bind(this),0)};C.prototype._applyItemAutoRows=function(e){if(!this._isRenderingFinished){return}if(this.getInlineBlockLayout()){return}if(I(e)){var t=e.$(),i=this.getActiveLayoutSettings(),r=e.getDomRef()?e.getDomRef().getBoundingClientRect().height:0,s=i.calculateRowsForItem(Math.round(r));if(!s){return}t.parent().css({"grid-row":"span "+Math.max(s,v(e))})}};C.prototype._enforceMaxColumns=function(){var e=this.getActiveLayoutSettings(),t;if(!e){return}t=e.getComputedColumnsCount(this.$().innerWidth());if(!t){return}this.getItems().forEach(function(e){e.$().parent().css("grid-column","span "+Math.min(_(e),t))})};C.prototype._getItemAt=function(e){var t=this.getItems(),i;if(e<0){e=0}if(t.length&&t[e]){i=t[e]}return i};C.prototype._createItemWrapper=function(t){var i=e.getStylesForItemWrapper(t,this),r=i.styles,s=i.classes,n=document.createElement("div");n.setAttribute("id",e.generateWrapperId(t,this));n.setAttribute("tabindex","0");r.forEach(function(e,t){n.style.setProperty(t,e)});s.forEach(function(e){n.classList.add(e)});return n};C.prototype.onItemNavigationBorderReached=function(e){this.fireEvent("borderReached",e)};["onkeypress","onkeyup","onkeydown","onsapenter","onsapselect","onsapspace"].forEach(function(e){C.prototype[e]=function(t){if(!this._isItemWrapper(t.target)){return}if(e==="onsapspace"){t.preventDefault()}var i=g.closestTo(t.target.firstChild);if(i){var r=i.getFocusDomRef(),s=g.closestTo(r);if(s&&s[e]){s[e].call(s,t)}}}});C.prototype._checkOwnVisualFocus=function(e){var t=e.getMetadata().getName(),r;if(y[t]&&y[t](e)){r=e.getFocusDomRef();if(r.getAttribute("tabindex")==="0"){r.setAttribute("tabindex",-1);r.tabIndex=-1}i.getItemWrapper(e).classList.add("sapFGridContainerItemWrapperNoVisualFocus")}};C.prototype._moveItem=function(e){if(!e.ctrlKey){return}if(!this._isItemWrapper(e.target)){return}var t=g.closestTo(e.target.firstElementChild),r=this.getItems().length,s=this.indexOfItem(t),n=-1,a,u=[];switch(e.keyCode){case m.ARROW_RIGHT:n=h.getConfiguration().getRTL()?s-1:s+1;if(n>=0&&n<r){a=i.createConfig(this,this.getItems()[n]);a.dropPosition="After";u=[a]}break;case m.ARROW_LEFT:n=h.getConfiguration().getRTL()?s+1:s-1;if(n>=0&&n<r){a=i.createConfig(this,this.getItems()[n]);a.dropPosition="Before";u=[a]}break;case m.ARROW_UP:u=i.findDropTargetsAbove(this,t);u.forEach(function(e){e.dropPosition="Before"});break;case m.ARROW_DOWN:u=i.findDropTargetsBelow(this,t);u.forEach(function(e){e.dropPosition=this.indexOfItem(e.item)!==-1?"After":"Before"}.bind(this));break;default:break}e.stopPropagation();o.fireDnD(t,u,e);this._setItemNavigationItems()};C.prototype.onsapincreasemodifiers=C.prototype._moveItem;C.prototype.onsapdecreasemodifiers=C.prototype._moveItem;C.prototype.focusItem=function(e){var t,i=this._oItemNavigation;this._forceFocus=true;this._setItemNavigationItems();t=i.getItemDomRefs();if(t[e]){i.focusItem(e)}};C.prototype.focusItemByDirection=function(e,t,i){this._oItemNavigation.focusItemByDirection(this,e,t,i)};C.prototype.getNavigationMatrix=function(){if(!h.isThemeApplied()){return null}var e=this.getItems().reduce(function(e,t){if(t.getVisible()){e.push(i.getItemWrapper(t))}return e},[]);return r.create(this.getDomRef(),e)};C.prototype._isItemWrapper=function(e){return e.classList.contains("sapFGridContainerItemWrapper")};return C});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridContainerItemLayoutData", ["sap/ui/core/LayoutData"],function(t){"use strict";var e=t.extend("sap.f.GridContainerItemLayoutData",{metadata:{library:"sap.f",properties:{columns:{type:"int",group:"Misc",defaultValue:1},minRows:{type:"int",group:"Misc"},rows:{type:"int",group:"Misc"}}}});e.prototype.hasAutoHeight=function(){return!this.getRows()};e.prototype.getActualRows=function(){return Math.max(this.getRows()||1,this.getMinRows()||1)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridContainerRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var i=t.getId(),r=t.getItems(),n=t.getTooltip_AsString();e.openStart("div",t).class("sapFGridContainer");this.setGridStyles(e,t._getActiveGridStyles());e.accessibilityState(t,{role:"list",roledescription:t._oRb.getText("GRIDCONTAINER_ROLEDESCRIPTION")});if(t.getSnapToRow()){e.class("sapFGridContainerSnapToRow")}if(t.getAllowDenseFill()){e.class("sapFGridContainerDenseFill")}if(t.getWidth()){e.style("width",t.getWidth())}if(t.getMinHeight()){e.style("min-height",t.getMinHeight())}if(n){e.attr("title",n)}e.openEnd();this.renderDummyArea(e,i,"before",r.length>0?0:-1);r.forEach(function(i,r){this.renderItem(e,i,t,r)}.bind(this));this.renderDummyArea(e,i,"after",0);e.close("div")};e.setGridStyles=function(e,t){for(var i in t){e.style(i,t[i])}};e.renderItem=function(e,t,i,r){var n=this.getStylesForItemWrapper(t,i),s=n.styles,a=n.classes,o={role:"listitem"};if(t.getAriaRoleDescription){o.roledescription=t.getAriaRoleDescription()}e.openStart("div",this.generateWrapperId(t,i)).attr("tabindex","0").accessibilityState(i,o);s.forEach(function(t,i){e.style(i,t)});a.forEach(function(t){e.class(t)});e.openEnd();e.renderControl(t);e.close("div")};e.getStylesForItemWrapper=function(e,t){var i=new Map,r=["sapFGridContainerItemWrapper"],n=e.getLayoutData(),s,a;if(n){s=n.getColumns();a=t.getActiveLayoutSettings().getColumns();if(s&&a){s=Math.min(s,a)}if(s){i.set("grid-column","span "+s)}if(t.getInlineBlockLayout()){i.set("grid-row","span 1")}else if(n.getRows()||n.getMinRows()){i.set("grid-row","span "+n.getActualRows())}if(!n.hasAutoHeight()){r.push("sapFGridContainerItemFixedRows")}}if(!e.getVisible()){r.push("sapFGridContainerInvisiblePlaceholder")}return{styles:i,classes:r}};e.generateWrapperId=function(e,t){return t.getId()+"-item-"+e.getId()};e.renderDummyArea=function(e,t,i,r){e.openStart("div",t+"-"+i).class("sapFGridContainerDummyArea").attr("tabindex",r).attr("role","none").openEnd().close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridContainerSettings", ["sap/ui/base/ManagedObject","sap/ui/dom/units/Rem","sap/base/Log"],function(e,t,i){"use strict";function n(e){if(e===null||e===undefined){return e}if(e===0||e==="0"){return 0}var n=e.match(/^(\d+(\.\d+)?)(px|rem)$/),r;if(n){if(n[3]==="px"){r=parseFloat(n[1])}else{r=t.toPx(parseFloat(n[1]))}}else{i.error("Css size '"+e+"' is not supported for some features in GridContainer. Only 'px' and 'rem' are supported.");r=NaN}return Math.ceil(r)}var r=e.extend("sap.f.GridContainerSettings",{metadata:{library:"sap.f",properties:{columns:{type:"int"},columnSize:{type:"sap.ui.core.CSSSize",defaultValue:"80px"},minColumnSize:{type:"sap.ui.core.CSSSize"},maxColumnSize:{type:"sap.ui.core.CSSSize"},rowSize:{type:"sap.ui.core.CSSSize",defaultValue:"80px"},gap:{type:"sap.ui.core.CSSSize",defaultValue:"16px"}}}});r.prototype.getColumnSizeInPx=function(){return n(this.getColumnSize())};r.prototype.getRowSizeInPx=function(){return n(this.getRowSize())};r.prototype.getGapInPx=function(){return n(this.getGap())};r.prototype.getComputedColumnsCount=function(e){if(this.getColumns()){return this.getColumns()}var t=this.getGapInPx(),i=this.getColumnSizeInPx();return Math.floor((e+t)/(i+t))};r.prototype.calculateRowsForItem=function(e){var t=this.getGapInPx(),i=this.getRowSizeInPx();return Math.ceil((e+t)/(i+t))};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridContainerUtils", ["sap/base/Log","sap/ui/core/Element","sap/ui/core/InvisibleRenderer"],function(e,t,i){"use strict";return{findDropTargetsAbove:function(e,t){return this._findDropTargets(e,t,this._isAbove)},findDropTargetsBelow:function(e,t){return this._findDropTargets(e,t,this._isBelow)},getItemWrapper:function(e){var t=e.getDomRef(),n;if(t){return t.parentElement}n=document.getElementById(i.createInvisiblePlaceholderId(e));if(n){return n.parentElement}return null},createConfig:function(e,t){return{grid:e,item:t}},_findDropTargets:function(e,i,n){var r=[],o=this.getItemWrapper(i),s=e.getItems().filter(function(e){return n(o,this.getItemWrapper(e))}.bind(this)),u=this.createConfig(e,this._findClosest(i,s),i,n);if(u.item){r.push(u)}else{r=Array.from(document.querySelectorAll(".sapFGridContainer")).filter(function(e){return n(o,e)}).map(function(e){var r=t.closestTo(e);var o=this.createConfig(r,this._findClosest(i,r.getItems()),i,n);o.distFromItemToGrid=this._getDistance(i,r,n);return o}.bind(this)).sort(function(e,t){return e.distFromItemToGrid-t.distFromItemToGrid})}return r},_findClosest:function(e,t,i){var n=null,r=Number.POSITIVE_INFINITY;t.forEach(function(t){var o=this._getDistance(e,t,i);if(o<r){n=t;r=o}}.bind(this));return n},_getDistance:function(t,i,n){var r=t.getDomRef().getBoundingClientRect(),o=i.getDomRef().getBoundingClientRect();var s={x:o.left};if(n===this._isAbove){s.y=o.top+o.height}else{s.y=o.top}var u={x:s.x+o.width,y:s.y};var a={x:r.left+r.width/2,y:r.top+r.height/2};var f=(u.x-s.x)*(u.x-s.x)+(u.y-s.y)*(u.y-s.y);var c=((a.x-s.x)*(u.x-s.x)+(a.y-s.y)*(u.y-s.y))/f;var g={};if(c<0){g.x=s.x;g.y=s.y}else if(c>1){g.x=u.x;g.y=u.y}else{g.x=s.x+c*(u.x-s.x);g.y=s.y+c*(u.y-s.y)}var l=g.x-a.x,d=g.y-a.y,m=l*l+d*d;if(m>Number.MAX_SAFE_INTEGER){e.warning("Maximum safe integer value exceeded.",m,"GridContainerUtils")}return m},_isAbove:function(e,t){var i=e.getBoundingClientRect().top,n=t.getBoundingClientRect().top;return n-i<0},_isBelow:function(e,t){var i=e.getBoundingClientRect().top,n=t.getBoundingClientRect().top;return n-i>0}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridList", ["./delegate/GridItemNavigation","./GridListRenderer","./GridNavigationMatrix","./library","sap/m/ListBase","sap/ui/base/ManagedObjectObserver","sap/ui/core/Core","sap/ui/Device","sap/ui/layout/cssgrid/GridLayoutDelegate","sap/ui/layout/cssgrid/GridLayoutBase"],function(t,e,i,o,a,r,s,n,d,p){"use strict";var u=o.NavigationDirection;var g=a.extend("sap.f.GridList",{metadata:{library:"sap.f",interfaces:["sap.ui.layout.cssgrid.IGridConfigurable","sap.f.dnd.IGridDroppable"],aggregations:{customLayout:{type:"sap.ui.layout.cssgrid.GridLayoutBase",multiple:false}},events:{borderReached:{parameters:{event:{type:"jQuery.Event"},direction:{type:"sap.f.NavigationDirection"},row:{type:"int"},column:{type:"int"}}}}},renderer:e});g.prototype.init=function(){a.prototype.init.apply(this,arguments);this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._addGridLayoutDelegate();this._oGridObserver=new r(g.prototype._onGridChange.bind(this));this._oGridObserver.observe(this,{aggregations:["items"]})};g.prototype.exit=function(){this._removeGridLayoutDelegate();if(this._oGridObserver){this._oGridObserver.disconnect();this._oGridObserver=null}a.prototype.exit.apply(this,arguments)};g.prototype.onAfterPageLoaded=function(){a.prototype.onAfterPageLoaded.apply(this,arguments);if(this._oItemNavigation){this._oItemNavigation.resetFocusPosition()}};g.prototype.onItemNavigationBorderReached=function(t){var e=this.getGrowingInfo();if(t.direction===u.Down&&e&&e.actual!==e.total){return}this.fireEvent("borderReached",t)};g.prototype.getGridDomRefs=function(){return[this.getItemsContainerDomRef()]};g.prototype.focusItemByDirection=function(t,e,i){this._oItemNavigation.focusItemByDirection(this,t,e,i)};g.prototype.getNavigationMatrix=function(){if(!s.isThemeApplied()){return null}var t=this.getItems().reduce(function(t,e){if(e.getDomRef()){t.push(e.getDomRef())}return t},[]);return i.create(this.getItemsContainerDomRef(),t)};g.prototype.getGridLayoutConfiguration=g.prototype.getCustomLayout;g.prototype._startItemNavigation=function(e){if(!n.system.desktop){return}if(!this._oItemNavigation){this._oItemNavigation=new t;this._oItemNavigation.setCycling(false).setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]}).setFocusedIndex(0);this.addDelegate(this._oItemNavigation)}a.prototype._startItemNavigation.apply(this,arguments)};g.prototype._addGridLayoutDelegate=function(){if(!this.oGridLayoutDelegate){this.oGridLayoutDelegate=new d;this.addEventDelegate(this.oGridLayoutDelegate,this)}};g.prototype._removeGridLayoutDelegate=function(){if(this.oGridLayoutDelegate){this.removeEventDelegate(this.oGridLayoutDelegate);this.oGridLayoutDelegate.destroy();this.oGridLayoutDelegate=null}};g.prototype._onGridChange=function(t){var e;if(t.name!=="items"||!t.child){return}if(t.mutation==="insert"){e=!t.child.isA("sap.ui.core.HTML");t.child.addDelegate(this._oItemDelegate,e,t.child)}else if(t.mutation==="remove"){t.child.removeEventDelegate(this._oItemDelegate,t.child)}};g.prototype._onAfterItemRendering=function(){p.setItemStyles(this)};g.prototype.updateItems=function(){a.prototype.updateItems.apply(this,arguments);this.invalidate()};g.prototype.onLayoutDataChange=function(t){p.setItemStyles(t.srcControl)};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridListItem", ["sap/m/ListItemBase","./GridListItemRenderer"],function(t,e){"use strict";var n=t.extend("sap.f.GridListItem",{metadata:{library:"sap.f",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}},renderer:e});n.prototype.getContentAnnouncement=function(){return this.getContent().map(function(e){return t.getAccessibilityText(e)}).join(" ").trim()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridListItemRenderer", ["sap/m/ListItemBaseRenderer","sap/ui/core/Renderer","sap/m/library"],function(e,r,t){"use strict";var n=t.ListType;var o=t.ListMode;var a=-1;var i=r.extend(e);i.apiVersion=2;i.renderLIAttributes=function(e,r){e.class("sapFGLI")};i.renderContentFormer=function(e,r){this.renderHighlight(e,r)};i.renderLIContentWrapper=function(r,t){r.openStart("div").class("sapFGLIWrapper").openEnd();this.renderToolbar(r,t);e.renderLIContentWrapper.apply(this,arguments);r.close("div")};i.renderContentLatter=function(e,r){};i.renderToolbar=function(r,t){var i=t.getMode(),s=i===o.Delete,d=t.getType();if(!t.getCounter()&&(i===""||i===o.None||i===o.SingleSelectMaster)&&(d===n.Inactive||d===n.Active)){return}r.openStart("div",t.getId()+"-gridListItemToolbar");r.class("sapFGLIToolbar");r.openEnd();if(!s){this.renderMode(r,t,a)}this.renderToolbarSpacer(r);e.renderContentLatter.apply(this,arguments);r.close("div")};i.renderLIContent=function(e,r){r.getContent().forEach(e.renderControl,e)};i.renderToolbarSpacer=function(e){e.openStart("div").class("sapFGLIToolbarSpacer").openEnd().close("div")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridListRenderer", ["sap/ui/core/Renderer","sap/m/ListBaseRenderer"],function(t,r){"use strict";var e=t.extend(r);e.apiVersion=2;e.getNoDataAriaRole=function(){return"listitem"};e.renderContainerAttributes=function(t,e){r.renderContainerAttributes.apply(this,arguments);t.class("sapFGridList")};e.renderListStartAttributes=function(t,e){r.renderListStartAttributes.apply(this,arguments);this.renderGridAttributes(t,e)};e.renderGridAttributes=function(t,r){var e=r.getGridLayoutConfiguration();if(e){e.addGridStyles(t)}else{t.class("sapFGridListDefault")}if(r.isGrouped()){t.class("sapFGridListGroup")}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/GridNavigationMatrix", ["sap/ui/core/Configuration"],function(t){"use strict";return{EMPTY_CELL:false,create:function(t,o){const n=window.getComputedStyle(t);const e={columns:n.gridTemplateColumns.split(/\s+/),rows:n.gridTemplateRows.split(/\s+/),rowGap:parseFloat(n.rowGap),columnGap:parseFloat(n.columnGap),paddingTop:parseFloat(n.paddingTop),paddingLeft:parseFloat(n.paddingLeft),paddingRight:parseFloat(n.paddingRight)};const r=Array.from(new Array(e.rows.length),function(){return new Array(e.columns.length).fill(this.EMPTY_CELL)}.bind(this));o.forEach(function(o){const n=this._getPosition(t,o,e);this._addToMatrix(r,n,o)}.bind(this));return r},_getPosition:function(t,o,n){const e=t.getBoundingClientRect();const r=o.getBoundingClientRect();const i=this._getGridRow(e,r,n);const a=this._getGridCol(e,r,n);return{xFrom:i.start,xTo:i.end,yFrom:a.start,yTo:a.end}},_getGridRow:function(t,o,n){let e=-1,r=0,i=0;const a=o.top-t.top-n.paddingTop;const s=a+o.height;for(let t=0;t<n.rows.length;t++){i+=parseFloat(n.rows[t]);if(e===-1&&a<i){e=t}i+=n.rowGap;if(Math.round(s)<=Math.round(i)){r=t+1;break}}return{start:e,end:r}},_getGridCol:function(o,n,e){let r,i,a=0,s,l;if(t.getRTL()){i=-1;r=e.columns.length-1;l=o.right-e.paddingRight-n.right;s=l+n.width;for(let t=e.columns.length;t>0;t--){a+=parseFloat(e.columns[t-1]);if(i===-1&&l<a){i=t}a+=e.columnGap;if(Math.round(s)<=Math.round(a)){r=t-1;break}}}else{r=-1;i=0;s=n.left-o.left-e.paddingLeft;l=s+n.width;for(let t=0;t<e.columns.length;t++){a+=parseFloat(e.columns[t]);if(r===-1&&s<a){r=t}a+=e.columnGap;if(Math.round(l)<=Math.round(a)){i=t+1;break}}}return{start:r,end:i}},_addToMatrix:function(t,o,n){for(let e=o.xFrom;e<o.xTo;e++){for(let r=o.yFrom;r<o.yTo;r++){t[e][r]=n}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/IllustratedMessage", ["sap/m/IllustratedMessage","sap/m/IllustratedMessageRenderer","./library"],function(e,r){"use strict";var a=e.extend("sap.f.IllustratedMessage",{metadata:{library:"sap.f",deprecated:true,properties:{}},renderer:r});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/Illustration", ["sap/m/Illustration","sap/m/IllustrationRenderer","./library"],function(r,e){"use strict";var t=r.extend("sap.f.Illustration",{metadata:{library:"sap.f",deprecated:true,properties:{}},renderer:e});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/IllustrationPool", ["sap/m/IllustrationPool"],function(t){"use strict";return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/PlanningCalendarInCardLegend", ["sap/m/PlanningCalendarLegend","sap/ui/unified/CalendarLegendItem","./PlanningCalendarInCardLegendRenderer","sap/ui/core/Core"],function(e,t,n,i){"use strict";var r=e.extend("sap.f.PlanningCalendarInCardLegend",{metadata:{library:"sap.f",properties:{visibleLegendItemsCount:{type:"int",group:"Data",defaultValue:2}}},renderer:n});r.prototype.exit=function(){e.prototype.exit.call(this,arguments);if(this._oItemsLink){this._oItemsLink.destroy();this._oItemsLink=null}};r.prototype._getMoreItemsText=function(e){if(!this._oItemsLink){var n=i.getLibraryResourceBundle("sap.f");this._oItemsLink=new t({text:n.getText("CALENDAR_LEGEND_MORE")+" ("+e+")"})}return this._oItemsLink};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/PlanningCalendarInCardLegendRenderer", ["sap/m/PlanningCalendarLegendRenderer","sap/ui/core/Renderer"],function(e,t){"use strict";var n=t.extend(e);n.apiVersion=2;n.renderItemsHeader=function(e,t){};n.renderAppointmentsItemsHeader=function(e,t){};n.renderAdditionalContent=function(e,t){};n.renderAdditionalItems=function(e,t){var n=t.getAppointmentItems(),i=t.getVisibleLegendItemsCount(),r,s;if(t.getItems().length>=i){r=0}else if(t.getItems().length+t.getAppointmentItems().length>i){r=i-t.getItems().length}else{r=t.getAppointmentItems().length}for(s=0;s<r;s++){this.renderLegendItem(e,"sapUiCalLegDayType"+t._getItemType(n[s],n).slice(4),n[s],["sapUiUnifiedLegendSquareColor","sapMPlanCalLegendAppCircle"])}if(t.getItems().length+t.getAppointmentItems().length>i){this.renderLegendItem(e,"sapUiCalLegMoreText",t._getMoreItemsText(t.getItems().length+t.getAppointmentItems().length-i),[])}};n.defineItemsLength=function(e,t){var n=e.getVisibleLegendItemsCount();if(t>=n){return n}else{return t}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/ProductSwitch", ["sap/ui/core/Core","sap/ui/core/Control","sap/f/GridContainer","sap/f/GridContainerSettings","sap/f/ProductSwitchItem","sap/f/ProductSwitchRenderer"],function(t,e,i,r,n,s){"use strict";var o=e.extend("sap.f.ProductSwitch",{metadata:{library:"sap.f",aggregations:{_gridContainer:{type:"sap.f.GridContainer",visibility:"hidden",multiple:false},items:{type:"sap.f.ProductSwitchItem",multiple:true,singularName:"item",forwarding:{getter:"_getGridContainer",aggregation:"items"}}},associations:{selectedItem:{type:"sap.f.ProductSwitchItem",multiple:false}},events:{change:{parameters:{itemPressed:{type:"sap.f.ProductSwitchItem"}}}}},renderer:s});o.COLUMNS={THREE_COLUMNS:3,FOUR_COLUMNS:4};o.prototype.init=function(){this._oCurrentSelectedItem=null};o.prototype.exit=function(){this._oCurrentSelectedItem=null};o.prototype._gridContainerItemsUpdate=function(){var t=this._getGridContainer().getLayout();t.setColumns(this.getItems().length<=6?o.COLUMNS.THREE_COLUMNS:o.COLUMNS.FOUR_COLUMNS)};o.prototype._changeLayoutHandler=function(t){var e=t.getParameter("layout"),i=e==="layoutS"||e==="layoutXS";this._getGridContainer().toggleStyleClass("sapFProductSwitch-Popover-CTX",!i)};o.prototype._getGridContainer=function(){var t=this.getAggregation("_gridContainer");if(!t){t=new i({layoutChange:this._changeLayoutHandler.bind(this)}).setLayout(new r({columnSize:"11.25rem",rowSize:"7rem",gap:"0.5rem",columns:4})).setLayoutM(new r({columnSize:"11.25rem",rowSize:"7rem",gap:"0.5rem",columns:3})).setLayoutS(new r({columnSize:"100%",rowSize:"5rem",gap:"0",columns:1}));this.setAggregation("_gridContainer",t)}return t};o.prototype._onItemPress=function(t){this.setSelectedItem(t.oSource);this.fireChange({itemPressed:t.oSource})};o.prototype._setSelection=function(t){if(this._oCurrentSelectedItem){this._oCurrentSelectedItem.removeStyleClass("sapFPSItemSelected");this._oCurrentSelectedItem.$().removeAttr("aria-checked")}this._oCurrentSelectedItem=t;if(this._oCurrentSelectedItem){this._oCurrentSelectedItem.addStyleClass("sapFPSItemSelected");this._oCurrentSelectedItem.$().attr("aria-checked","true")}};o.prototype.setSelectedItem=function(e){if(typeof e==="string"){e=t.byId(e)}if(!(e instanceof n)&&e!==null){return this}this._setSelection(e);return this.setAssociation("selectedItem",e,true)};o.prototype.addItem=function(t){this.addAggregation("items",t);if(t){t.attachEvent("_itemPress",this._onItemPress,this)}this._gridContainerItemsUpdate();return this};o.prototype.insertItem=function(t,e){this.insertAggregation("items",t,e);if(t){t.attachEvent("_itemPress",this._onItemPress,this)}this._gridContainerItemsUpdate();return this};o.prototype.removeItem=function(t){var e=this.removeAggregation("items",t).detachEvent("_itemPress",this._onItemPress,this);this._gridContainerItemsUpdate();return e};o.prototype.removeAllItems=function(){var t=this.getItems(),e;t.forEach(function(t){t.detachEvent("_itemPress",this._onItemPress,this)},this);e=this.removeAllAggregation("items");this._gridContainerItemsUpdate();return e};o.prototype.destroyItems=function(){var t=this.getItems(),e;t.forEach(function(t){t.detachEvent("_itemPress",this._onItemPress,this)},this);e=this.destroyAggregation("items");this._gridContainerItemsUpdate();return e};o.prototype._getItemsCount=function(){return this.getItems().length};o.prototype._getItemPosition=function(t){var e=this.getItems(),i;e.forEach(function(e,r){if(e===t){i=r+1}});return i};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/ProductSwitchItem", ["sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/library","sap/m/Text","sap/ui/events/KeyCodes","sap/f/ProductSwitchItemRenderer"],function(e,t,i,s,r,n){"use strict";var o=i.TextAlign;var a=e.extend("sap.f.ProductSwitchItem",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",defaultValue:null},title:{type:"string",defaultValue:null},subTitle:{type:"string",defaultValue:null},targetSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{_icon:{type:"sap.ui.core.Icon",visibility:"hidden",multiple:false},_title:{type:"sap.m.Text",visibility:"hidden",multiple:false}}},renderer:n});a.prototype.init=function(){this._bSpaceEnterPressed=false;this._bEscapeShiftKeyPress=false};a.prototype.setTitle=function(e){this.setProperty("title",e);this._getTitle().setText(e);return this};a.prototype.setSrc=function(e){this.setProperty("src",e);this._getIcon().setSrc(e);return this};a.prototype.setSubTitle=function(e){this.setProperty("subTitle",e);this._getTitle().setMaxLines(e?1:2);return this};a.prototype._getIcon=function(){var e=this.getAggregation("_icon");if(!e){e=new t;if(this.getSrc()){e.setSrc(this.getSrc())}this.setAggregation("_icon",e)}return e};a.prototype._getTitle=function(){var e=this.getAggregation("_title");if(!e){e=new s({text:this.getTitle(),maxLines:2,textAlign:o.Initial}).addStyleClass("sapFPSItemMainTitle").addStyleClass("sapFPSItemTitle");this.setAggregation("_title",e)}return e};a.prototype._getProductSwitch=function(){return this.getParent().getParent()};a.prototype.onkeyup=function(e){if(e.keyCode===r.SPACE&&!this._bEscapeShiftKeyPress){this.fireEvent("_itemPress")}if(e.keyCode===r.SPACE||e.keyCode===r.ENTER){this._bSpaceEnterPressed=false;this._bEscapeShiftKeyPress=false}};a.prototype.ontap=function(){this.fireEvent("_itemPress")};a.prototype.onkeydown=function(e){if((e.keyCode===r.ESCAPE||e.keyCode===r.SHIFT)&&this._bSpaceEnterPressed){this._bEscapeShiftKeyPress=true}if(e.keyCode===r.SPACE||e.keyCode===r.ENTER){this._bSpaceEnterPressed=true;if(e.keyCode===r.ENTER&&!this._bEscapeShiftKeyPress){this.fireEvent("_itemPress")}e.preventDefault()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/ProductSwitchItemRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var i=t._getProductSwitch(),n={role:"menuitemradio"},s=t.getTooltip_AsString();if(i){n.setsize=i._getItemsCount();n.posinset=i._getItemPosition(t);n.checked=t.getId()===i.getSelectedItem()?"true":undefined}e.openStart("div",t);e.class("sapFPSItemContainer");if(s){e.attr("title",s)}e.accessibilityState(t,n);e.openEnd();e.openStart("span");e.class("sapFPSItemIconPlaceholder");e.class("sapUiTinyMarginBottom");e.openEnd();if(t.getSrc()){e.renderControl(t._getIcon())}e.close("span");e.openStart("div");e.class("sapFPSItemTextSection");e.openEnd();if(t.getTitle()){e.renderControl(t._getTitle())}if(t.getSubTitle()){e.openStart("div");e.class("sapFPSItemSubTitle");e.class("sapFPSItemTitle");e.openEnd();e.text(t.getSubTitle());e.close("div")}e.close("div");e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/ProductSwitchRenderer", ["sap/ui/core/Core"],function(e){"use strict";return{apiVersion:2,render:function(r,t){var n=e.getLibraryResourceBundle("sap.f");r.openStart("div",t);r.attr("role","menu");r.attr("aria-label",n.getText("PRODUCTSWITCH_CONTAINER_LABEL"));r.openEnd();r.renderControl(t._getGridContainer());r.close("div")}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/SearchManager", ["sap/ui/core/Element","sap/ui/base/ManagedObjectObserver","./shellBar/Search"],function(e,t,r){"use strict";var i=sap.ui.getCore().getLibraryResourceBundle("sap.m");var a=e.extend("sap.f.SearchManager",{metadata:{library:"sap.f",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},placeholder:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},enabled:{type:"boolean",group:"Behavior",defaultValue:true},enableSuggestions:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{suggestionItems:{type:"sap.m.SuggestionItem",multiple:true,forwarding:{getter:"_getSearchField",aggregation:"suggestionItems"},singularName:"suggestionItem"}},events:{search:{parameters:{query:{type:"string"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}}});a.prototype.init=function(){this.setProperty("placeholder",i.getText("FACETFILTER_SEARCH"),true);this._oConfigObserver=new t(this._synchronizePropertiesWithConfig.bind(this));this._oConfigObserver.observe(this,{properties:Object.keys(this.getMetadata().getProperties())});this._initShellBarManagedSearch()};a.prototype._synchronizePropertiesWithConfig=function(){var e=this._oSearch._getSearchField(),t=e.getMetadata(),r=this.getMetadata(),i,a;Object.keys(r.getAllProperties()).forEach(function(s){i=t.hasProperty(s);if(i){a=r.getProperty(s).get(this);t.getProperty(s).set(e,a)}},this)};a.prototype._initShellBarManagedSearch=function(){if(!this._oSearch){this._oSearch=new r({search:this._onSearch.bind(this),liveChange:this._onLiveChange.bind(this),suggest:this._onSuggest.bind(this)})}};a.prototype.exit=function(){if(this._oConfigObserver){this._oConfigObserver.disconnect();this._oConfigObserver=null}if(this._oSearch){this._oSearch.destroy()}};a.prototype._onLiveChange=function(e){var t=e.getParameters(),r=e.getParameter("newValue");t.id=this.getId();this.setProperty("value",r,true);this.fireLiveChange(t)};a.prototype._onSearch=function(e){var t=e.getParameters();t.id=this.getId();this.fireSearch(t)};a.prototype._onSuggest=function(e){var t=e.getParameters();t.id=this.getId();this.fireSuggest(t)};a.prototype.suggest=function(e){this._getSearchField().suggest(e)};a.prototype._getSearchField=function(){return this._oSearch._getSearchField()};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/ShellBar", ["sap/ui/core/Control","./shellBar/Factory","./shellBar/AdditionalContentSupport","./shellBar/ResponsiveHandler","./shellBar/Accessibility","sap/m/BarInPageEnabler","sap/m/BadgeCustomData","sap/m/Button","sap/ui/Device","sap/m/library","./ShellBarRenderer"],function(t,e,o,i,a,s,r,n,l,h,p){"use strict";var d=h.AvatarSize;var u=t.extend("sap.f.ShellBar",{metadata:{library:"sap.f",interfaces:["sap.f.IShellBar","sap.m.IBar","sap.tnt.IToolHeader"],properties:{title:{type:"string",group:"Appearance",defaultValue:""},secondTitle:{type:"string",group:"Appearance",defaultValue:""},homeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},homeIconTooltip:{type:"string",group:"Appearance",defaultValue:""},showMenuButton:{type:"boolean",group:"Appearance",defaultValue:false},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showCopilot:{type:"boolean",group:"Appearance",defaultValue:false},showSearch:{type:"boolean",group:"Appearance",defaultValue:false},showNotifications:{type:"boolean",group:"Appearance",defaultValue:false},showProductSwitcher:{type:"boolean",group:"Appearance",defaultValue:false},notificationsNumber:{type:"string",group:"Appearance",defaultValue:""}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,forwarding:{getter:"_getMenu",aggregation:"menu"}},searchManager:{type:"sap.f.SearchManager",multiple:false},profile:{type:"sap.m.Avatar",multiple:false},additionalContent:{type:"sap.f.IShellBar",multiple:true,singularName:"additionalContent"},_overflowToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_additionalBox:{type:"sap.m.HBox",multiple:false,visibility:"hidden"}},events:{homeIconPressed:{parameters:{icon:{type:"sap.m.Image"}}},menuButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},navButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},copilotPressed:{parameters:{image:{type:"sap.m.Image"},button:{type:"sap.m.Button"}}},searchButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},notificationsPressed:{parameters:{button:{type:"sap.m.Button"}}},productSwitcherPressed:{parameters:{button:{type:"sap.m.Button"}}},avatarPressed:{parameters:{avatar:{type:"sap.m.Avatar"}}}}},renderer:p});o.apply(u.prototype);var _="ShellBarRangeSet";l.media.initRangeSet(_,[600,1024,1440,1920],"px",["Phone","Tablet","Desktop","LargeDesktop","ExtraLargeDesktop"],true);u.prototype.init=function(){this._oFactory=new e(this);this._bOTBUpdateNeeded=true;this._bLeftBoxUpdateNeeded=true;this._bRightBoxUpdateNeeded=true;this._oOverflowToolbar=this._oFactory.getOverflowToolbar();this._oAdditionalBox=this._oFactory.getAdditionalBox();this._aControls=[];this._aAdditionalContent=[];this.setAggregation("_overflowToolbar",this._oOverflowToolbar);this.setAggregation("_additionalBox",this._oAdditionalBox);this._oToolbarSpacer=this._oFactory.getToolbarSpacer();this._oResponsiveHandler=new i(this);this._oAcc=new a(this);this._sRangeSet=_};u.prototype.onBeforeRendering=function(){this._assignControls()};u.prototype.onAfterRendering=function(){if(!this.sCurrentRange){this._assignSearch();this.invalidate()}};u.prototype.exit=function(){this._aLeftControls=[];this._aRightControls=[];this._aControls=[];this._oResponsiveHandler.exit();this._oFactory.destroy();this._oAcc.exit()};u.prototype.setHomeIcon=function(t){if(t){if(!this._oHomeIcon){this._oHomeIcon=this._oFactory.getHomeIcon()}this._oHomeIcon.setSrc(t)}else{this._oHomeIcon=null}this._bLeftBoxUpdateNeeded=true;return this.setProperty("homeIcon",t)};u.prototype.setProfile=function(t){this.validateAggregation("profile",t,false);if(t){t.setDisplaySize(d.XS);t.setTooltip(this._oAcc.getEntityTooltip("PROFILE"));t.attachPress(function(){this.fireEvent("avatarPressed",{avatar:t})},this);t.addStyleClass("sapFShellBarProfile")}return this.setAggregation("profile",t)};u.prototype.setHomeIconTooltip=function(t){var e=this._oAcc.getEntityTooltip("LOGO");if(!this._oHomeIcon){this._oHomeIcon=this._oFactory.getHomeIcon()}if(t){this._oHomeIcon.setTooltip(t)}else{this._oHomeIcon.setTooltip(e)}return this.setProperty("homeIconTooltip",t,true)};u.prototype.setTitle=function(t){this._sTitle=t;if(!t){this._oPrimaryTitle=null;this._oMegaMenu=null}else{if(!this._oMegaMenu){this._oMegaMenu=this._oFactory.getMegaMenu()}this._oMegaMenu.setText(t);if(!this._oPrimaryTitle){this._oPrimaryTitle=this._oFactory.getPrimaryTitle()}this._oPrimaryTitle.setText(t)}this._bLeftBoxUpdateNeeded=true;return this.setProperty("title",t)};u.prototype.setSecondTitle=function(t){if(t){if(!this._oSecondTitle){this._oSecondTitle=this._oFactory.getSecondTitle()}this._oSecondTitle.setText(t)}else{this._oSecondTitle=null}this._bLeftBoxUpdateNeeded=true;return this.setProperty("secondTitle",t)};u.prototype.setShowCopilot=function(t){if(t){if(!this._oCopilot){this._oCopilot=this._oFactory.getCopilot()}}else{this._oCopilot=null}this._bOTBUpdateNeeded=true;this._bLeftBoxUpdateNeeded=true;this._bRightBoxUpdateNeeded=true;return this.setProperty("showCopilot",t)};u.prototype.setShowSearch=function(t){if(t){if(!this._oSearch){this._oSearch=this._oFactory.getSearch()}}else{this._oSearch=null}this._bOTBUpdateNeeded=true;return this.setProperty("showSearch",t)};u.prototype.setSearchManager=function(t){this.setAggregation("searchManager",t);if(t){if(!this._oManagedSearch){this._oManagedSearch=this._oFactory.getManagedSearch();this.addStyleClass("sapFShellBarWithSearch",true)}}else{this._oManagedSearch=null;this.addStyleClass("sapFShellBarWithSearch",false)}this._bOTBUpdateNeeded=true;return this};u.prototype.setShowNotifications=function(t){var e=this,o;if(t){if(!this._oNotifications){o=this.getParent();this._oNotifications=this._oFactory.getNotifications();this._oNotifications._onBeforeEnterOverflow=function(){var t=o&&o._getOverflowButton().getBadgeCustomData();this._bInOverflow=true;t&&t.setVisible(this.getBadgeCustomData().getVisible())};this._oNotifications._onAfterExitOverflow=function(){var t=o&&o._getOverflowButton().getBadgeCustomData();this._bInOverflow=false;t&&t.setVisible(false)};this._oNotifications.onBadgeUpdate=function(t,o){n.prototype.onBadgeUpdate.apply(this,arguments);if(!this._bInOverflow){e._oAcc.updateNotificationsNumber(t)}else{e._oAcc.updateNotificationsNumber("")}}}}else{this._oNotifications=null}this._bOTBUpdateNeeded=true;return this.setProperty("showNotifications",t)};u.prototype.setShowProductSwitcher=function(t){if(t){if(!this._oProductSwitcher){this._oProductSwitcher=this._oFactory.getProductSwitcher()}}else{this._oProductSwitcher=null}this._bRightBoxUpdateNeeded=true;return this.setProperty("showProductSwitcher",t)};u.prototype.setShowNavButton=function(t){if(t){if(!this._oNavButton){this._oNavButton=this._oFactory.getNavButton()}}else{this._oNavButton=null}this._bLeftBoxUpdateNeeded=true;return this.setProperty("showNavButton",t)};u.prototype.setShowMenuButton=function(t){if(t){if(!this._oMenuButton){this._oMenuButton=this._oFactory.getMenuButton()}}else{this._oMenuButton=null}this._bLeftBoxUpdateNeeded=true;return this.setProperty("showMenuButton",t)};u.prototype.setNotificationsNumber=function(t){if(this.getShowNotifications()){this._updateNotificationsIndicators(t)}return this.setProperty("notificationsNumber",t,true)};u.prototype._addDataToControl=function(t){t.addStyleClass("sapFShellBarItem");if(this._aControls.indexOf(t)===-1){this._aControls.push(t)}return t};u.prototype._assignControls=function(){if(!this._bOTBUpdateNeeded&&!this._bLeftBoxUpdateNeeded&&!this._bRightBoxUpdateNeeded){return}if(this._bLeftBoxUpdateNeeded){this._aLeftControls=[];if(this._oNavButton){this.addControlToCollection(this._oNavButton,this._aLeftControls)}if(this._oMenuButton){this.addControlToCollection(this._oMenuButton,this._aLeftControls)}if(this._oHomeIcon){this.addControlToCollection(this._oHomeIcon,this._aLeftControls)}this._assignControlsToAdditionalBox();this._aLeftControls.push(this._oAdditionalBox)}if(this._oCopilot){this._addDataToControl(this._oCopilot)}if(this._bRightBoxUpdateNeeded||this._bOTBUpdateNeeded){this._aRightControls=[];if(this._bOTBUpdateNeeded){this._assignControlsToOverflowToolbar()}this._aRightControls.push(this._oOverflowToolbar)}this._bLeftBoxUpdateNeeded=false;this._bRightBoxUpdateNeeded=false;this._bOTBUpdateNeeded=false};u.prototype._assignControlsToAdditionalBox=function(){this._oAdditionalBox.removeAllItems();this._oTitleControl=null;if(this.getShowMenuButton()){if(this._oPrimaryTitle){this.addControlToCollection(this._oPrimaryTitle,this._oAdditionalBox);this._oTitleControl=this._oPrimaryTitle}}else if(this._oMegaMenu){if(this._oMegaMenu.getMenu()&&this._oMegaMenu.getMenu().getItems().length){this.addControlToCollection(this._oMegaMenu,this._oAdditionalBox);this._oTitleControl=this._oMegaMenu}else if(this._oPrimaryTitle){this.addControlToCollection(this._oPrimaryTitle,this._oAdditionalBox);this._oTitleControl=this._oPrimaryTitle}}if(this._oSecondTitle){this.addControlToCollection(this._oSecondTitle,this._oAdditionalBox)}return this._oAdditionalBox};u.prototype._assignControlsToOverflowToolbar=function(){var t,e=this._getCurrentMediaRange();this.sCurrentRange=e;if(!this._oOverflowToolbar){return}this._oOverflowToolbar.removeAllContent();this.addControlToCollection(this._oToolbarSpacer,this._oOverflowToolbar);this._assignSearch();if(this._oSearch){this.addControlToCollection(this._oSearch,this._oOverflowToolbar)}if(this._oCopilot){this.addControlToCollection(this._oCopilot,this._oOverflowToolbar)}if(this._oNotifications){this.addControlToCollection(this._oNotifications,this._oOverflowToolbar)}t=this.getAdditionalContent();if(t){t.forEach(function(t){this.addControlToCollection(t,this._oOverflowToolbar)},this)}this._bOTBUpdateNeeded=false;return this._oOverflowToolbar};u.prototype._assignSearch=function(){var t=this._getCurrentMediaRange();this.sCurrentRange=t;if(this._oManagedSearch&&this.sCurrentRange!=="ExtraLargeDesktop"){this.addControlToCollection(this._oManagedSearch,this._oOverflowToolbar);this._oManagedSearch._switchOpenStateOnSearch()}else if(this._oManagedSearch&&this.sCurrentRange==="ExtraLargeDesktop"){this._oManagedSearch.setIsOpen(true);this.removeControlFromCollection(this._oManagedSearch,this._oOverflowToolbar)}};u.prototype._getCurrentMediaRange=function(){return this.$().length&&l.media.getCurrentRange(this._sRangeSet,this.$().outerWidth()).name};u.prototype.addControlToCollection=function(t,e){var o;if(Array.isArray(e)){o="push"}else{o=e===this._oAdditionalBox?"addItem":"addContent"}this._addDataToControl(t);e[o](t)};u.prototype.removeControlFromCollection=function(t,e){var o;if(!Array.isArray(e)){o=e===this._oAdditionalBox?"removeItem":"removeContent"}e[o](t)};u.prototype._updateNotificationsIndicators=function(t){var e;if(!this.getShowNotifications()){return}e=this._oOverflowToolbar._getOverflowButton();this._addOrUpdateBadges(e,t);if(!this._oNotifications._bInOverflow){this._oOverflowToolbar._getOverflowButton().getBadgeCustomData().setVisible(false)}this._addOrUpdateBadges(this._oNotifications,t)};u.prototype._addOrUpdateBadges=function(t,e){if(t.getBadgeCustomData()){t.getBadgeCustomData().setValue(e)}else{t.addCustomData(new r({value:e,animation:"Update"}))}};u.prototype._getMenu=function(){if(!this._oMegaMenu){this._oMegaMenu=this._oFactory.getMegaMenu()}return this._oMegaMenu};u.prototype.onThemeChanged=function(){this._oResponsiveHandler._handleResize()};u.prototype._getOverflowToolbar=function(){return this._oOverflowToolbar};u.prototype.getContext=s.prototype.getContext;u.prototype.isContextSensitive=s.prototype.isContextSensitive;u.prototype.setHTMLTag=s.prototype.setHTMLTag;u.prototype.getHTMLTag=s.prototype.getHTMLTag;u.prototype.applyTagAndContextClassFor=s.prototype.applyTagAndContextClassFor;u.prototype._applyContextClassFor=s.prototype._applyContextClassFor;u.prototype._applyTag=s.prototype._applyTag;u.prototype._getContextOptions=s.prototype._getContextOptions;u.prototype._setRootAccessibilityRole=s.prototype._setRootAccessibilityRole;u.prototype._getRootAccessibilityRole=s.prototype._getRootAccessibilityRole;u.prototype._setRootAriaLevel=s.prototype._setRootAriaLevel;u.prototype._getRootAriaLevel=s.prototype._getRootAriaLevel;return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/ShellBarRenderer", [],function(){"use strict";return{apiVersion:2,render:function(e,t){var o=t._oAcc,r=o.getRootAttributes(),a=t.getTitle(),l=t.getProfile(),n=a&&!t.getShowMenuButton();e.openStart("div",t);e.class("sapFShellBar");if(t.getShowNotifications()){e.class("sapFShellBarNotifications")}if(t.getShowCopilot()){e.class("sapFShellBarCopilot")}e.accessibilityState({role:r.role,label:r.label});e.openEnd();if(n){e.openStart("div",t.getId()+"-titleHidden").class("sapFShellBarTitleHidden").attr("role","heading").attr("aria-level","1").openEnd();e.text(a).close("div")}if(t._aLeftControls&&t._aLeftControls.length){e.openStart("div").class("sapFShellBarOLHB").openEnd();t._aLeftControls.forEach(e.renderControl,e);e.close("div")}if(t._oManagedSearch&&t.sCurrentRange==="ExtraLargeDesktop"){e.renderControl(t._oManagedSearch)}if(t._aRightControls&&t._aRightControls.length){e.openStart("div").class("sapFShellBarORHB").openEnd();t._aRightControls.forEach(e.renderControl,e);e.close("div")}if(l){e.renderControl(l)}if(t._oProductSwitcher){e.renderControl(t._oProductSwitcher)}e.close("div")},shouldAddIBarContext:function(){return false}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/SidePanel", ["sap/ui/Device","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/Icon","sap/ui/core/Popup","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/delegate/ItemNavigation","sap/ui/dom/containsOrEquals","sap/m/Title","sap/m/Button","sap/m/Menu","sap/m/MenuItem","sap/ui/core/InvisibleMessage","./SidePanelItem","./SidePanelRenderer","./library","sap/ui/core/library","sap/ui/events/F6Navigation","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes"],function(e,t,i,n,s,o,a,r,l,h,d,u,p,c,f,g,_,S,m,jQuery,y){"use strict";var v=sap.ui.getCore().getLibraryResourceBundle("sap.f"),I=S.InvisibleMessageMode,P=_.SidePanelPosition;var E=0,b=1,w=2;var A=560;var R=t.extend("sap.f.SidePanel",{metadata:{library:"sap.f",properties:{actionBarExpanded:{type:"boolean",group:"Appearance",defaultValue:false},ariaLabel:{type:"string",group:"Accessibility",defaultValue:"Side Panel"},sidePanelResizable:{type:"boolean",group:"Appearance",defaultValue:false},sidePanelWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"20rem"},sidePanelMinWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"15rem"},sidePanelMaxWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"90%"},sidePanelResizeStep:{type:"int",group:"Appearance",defaultValue:10},sidePanelResizeLargerStep:{type:"int",group:"Appearance",defaultValue:100},sideContentExpanded:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},sidePanelPosition:{type:"sap.f.SidePanelPosition",group:"Appearance",defaultValue:P.Right}},aggregations:{mainContent:{type:"sap.ui.core.Control",multiple:true},items:{type:"sap.f.SidePanelItem",multiple:true,singularName:"item"},_arrowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_overflowItem:{type:"sap.f.SidePanelItem",multiple:false,visibility:"hidden"},_overflowMenu:{type:"sap.m.Menu",multiple:false,visibility:"hidden"},_contextMenu:{type:"sap.m.Menu",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.f.SidePanelItem",multiple:false}},events:{toggle:{allowPreventDefault:true,parameters:{item:{type:"sap.f.SidePanelItem"},expanded:{type:"boolean"}}}}},renderer:g});R.prototype.init=function(){this.setAggregation("_arrowButton",new d(this.getId()+"-expandCollapseButton",{type:"Transparent",press:this._toggleActionBarExpanded.bind(this)}).addStyleClass("sapFSPExpandCollapse"));this.setAggregation("_overflowItem",new f({icon:"sap-icon://overflow",text:v.getText("SIDEPANEL_MORE_ACTIONS_TEXT")}));if(!e.system.phone){var t=new u({itemSelected:function(e){var t=e.getParameter("item");if(this._mOverflowItemsMap[t.getId()]){this._toggleItemSelection(this._mOverflowItemsMap[t.getId()])}}.bind(this),closed:function(){setTimeout(function(){this._setOverflowItemSelection(false)}.bind(this),100)}.bind(this)}).addStyleClass("sapFSPOverflowMenu");this.setAggregation("_overflowMenu",t)}this._fnOnResizeRef=this._onResize.bind(this);this._fnOnMainScroll=this._handleScroll.bind(this);this._fnOnMainFocusOut=this._onMainFocusOut.bind(this);this._fnOnTouchStart=this._onTouchStart.bind(this);this._fnOnTouchEnd=this._onTouchEnd.bind(this);this._fnOnTouchMove=this._onTouchMove.bind(this);this._fnOnDblClick=this._onDblClick.bind(this);this._iLastScrollPosition=0;this._iSidePanelPosition=b;this._bShouldAttachGlobalHandlers=true;this._iVisibleItems=0;this._bOverflowMenuOpened=false;this._mOverflowItemsMap={};this._oItemNavigation=null};R.prototype.exit=function(){this._detachResizeHandlers();this._detachScrollHandler();this._detachMainFocusOutHandler();this._detachResizableHandlers()};R.prototype.setSidePanelWidth=function(e){this.setProperty("sidePanelWidth",e);if(this.getDomRef()){this._sSidePanelWidth=this._getSidePanelWidth()}return this};R.prototype.setSelectedItem=function(e){var t=this.getSelectedItem(),n,s;if(typeof e==="string"){n=e;s=i.byId(e)}else if(e&&e.isA("sap.f.SidePanelItem")){n=e.getId();s=e}if(!n){t&&this._toggleItemSelection(i.byId(t))}else if(s&&s.getEnabled()&&n!==t&&n!==this.getAggregation("_overflowItem").getId()){this._toggleItemSelection(s);this.setAssociation("selectedItem",s,true)}return this};R.prototype.onBeforeRendering=function(){var e=this.getAggregation("_arrowButton"),t=this.getActionBarExpanded(),i=v.getText("SIDEPANEL_EXPAND_BUTTON_TEXT")+"/"+v.getText("SIDEPANEL_COLLAPSE_BUTTON_TEXT"),n;if(P.Right===this.getSidePanelPosition()){n=t?"right":"left"}else{n=t?"left":"right"}e.setIcon("sap-icon://navigation-"+n+"-arrow");e.setTooltip(i);this._detachResizeHandlers();this._attachResizeHandlers();this._detachScrollHandler();this._detachMainFocusOutHandler();this._detachResizableHandlers();this._oInvisibleMessage=c.getInstance();if(this._isSingleItem()){var s=t?this.getItems()[0]:null;this.setProperty("sideContentExpanded",t);this.setAssociation("selectedItem",s,true)}};R.prototype.onAfterRendering=function(){var t=this._isSingleItem()&&this.getActionBarExpanded()?this.getAggregation("_closeButton"):this.getAggregation("_arrowButton"),i;if(!e.system.phone){i=t.getDomRef();i&&i.setAttribute("aria-expanded",this.getActionBarExpanded()?"true":"false")}!this._getSideContentExpanded()&&this._attachScrollHandler();this._attachMainFocusOutHandler();this._attachResizableHandlers();if(!e.system.phone){this._determineVisibleItems();if(!this._isSingleItem()&&this._iVisibleItems>0){this._initItemNavigation()}if(this._getSideContentExpanded()){this.getItems().length&&this._fixSidePanelWidth()}}else{if(this.getDomRef().querySelector(".sapFSPMain").scrollTop===0){this.setActionBarExpanded(true)}}if(!this._sSidePanelWidth){this._sSidePanelWidth=this._getSidePanelWidth()}};R.prototype.oncontextmenu=function(e){var t=document.activeElement===this.getDomRef().querySelector(".sapFSPSplitterBar");if(t||e.target.closest(".sapFSPSide.sapFSPResizable")){e.preventDefault();if(t){this._bContextMenuFromSplitter=true}this._showResizeContextMenu(e)}};R.prototype.onkeydown=function(e){var t=e.target,n=this.getDomRef().querySelector(".sapFSPActionBarList"),s=this._getSideContentExpanded(),o=this.getActionBarExpanded()||s,a=e.ctrlKey||e.metaKey,r=document.activeElement===this.getDomRef().querySelector(".sapFSPSplitterBar");if(a&&e.which===y.ARROW_LEFT){e.preventDefault();if(s){this._focusSideContent()}}else if(a&&e.which===y.ARROW_RIGHT&&s){if(s){this._contentControlToFocus=i.getCurrentFocusedControlId()}this._oItemNavigation.getFocusedDomRef().focus()}else if(a&&e.shiftKey&&e.which===y.P){e.preventDefault();this._toggleActionBarExpanded();if(!o){this._oItemNavigation.getFocusedDomRef().focus()}else{s&&this.setActionBarExpanded(false);this._closeSideContent();this._focusMain()}}else if(e.which===y.ESCAPE){e.preventDefault();this.setActionBarExpanded(false);this._closeSideContent();this._focusMain()}else if(r){switch(e.which){case y.ENTER:this._setSidePanelResizePosition(b);break;case y.END:this._setSidePanelResizePosition(w);break;case y.HOME:this._setSidePanelResizePosition(E);break;case y.ARROW_LEFT:case y.ARROW_UP:this._moveSidePanelResizePositionWith(e.shiftKey?this.getSidePanelResizeLargerStep():this.getSidePanelResizeStep());break;case y.ARROW_RIGHT:case y.ARROW_DOWN:this._moveSidePanelResizePositionWith(e.shiftKey?-this.getSidePanelResizeLargerStep():-this.getSidePanelResizeStep());break;case y.F10:if(e.shiftKey){e.preventDefault();this._bContextMenuFromSplitter=true;this._showResizeContextMenu(e)}break}}if(!l(n,t)||t===n){return}switch(e.which){case y.ENTER:e.preventDefault();this._toggleItemSelection(e.srcControl);break;case y.SPACE:e.preventDefault();break}};R.prototype.onkeyup=function(e){var t=e.target,i=this.getDomRef().querySelector(".sapFSPActionBarList");if(!l(i,t)||t===i){return}if(e.which===y.SPACE){this._toggleItemSelection(e.srcControl)}};R.prototype.ontap=function(e){var t,n=e.target,s=this.getDomRef().querySelector(".sapFSPActionBarList");if(!l(s,n)||n===s){return}t=n;while(t.tagName!=="LI"){t=t.parentElement}if(!t){return}this._toggleItemSelection(i.byId(t.id))};R.prototype.onsapskipforward=function(e){e.preventDefault();this._handleGroupNavigation(e,false)};R.prototype.onsapskipback=function(e){this._handleGroupNavigation(e,true)};R.prototype._getContextMenu=function(){var e=this.getAggregation("_contextMenu");if(!e){e=new u({items:[new p({text:v.getText("SIDEPANEL_CONTEXTMENU_MAXIMUM_WIDTH"),press:function(){this._setSidePanelResizePosition(w)}.bind(this)}),new p({text:v.getText("SIDEPANEL_CONTEXTMENU_MINIMUM_WIDTH"),press:function(){this._setSidePanelResizePosition(E)}.bind(this)}),new p({text:v.getText("SIDEPANEL_CONTEXTMENU_DEFAULT_WIDTH"),press:function(){this._setSidePanelResizePosition(b)}.bind(this)})],closed:function(e){if(this._bContextMenuFromSplitter){this._bContextMenuFromSplitter=false;this.getDomRef().querySelector(".sapFSPSplitterBar").focus()}}.bind(this)});this.setAggregation("_contextMenu",e)}return e};R.prototype._getSideContentExpanded=function(){return this.getProperty("sideContentExpanded")};R.prototype._setSideContentExpanded=function(e){this._isSingleItem()&&this.setActionBarExpanded(e);return this.setProperty("sideContentExpanded",e)};R.prototype._getFocusDomRef=function(e){return e.getDomRef()};R.prototype._focusMain=function(){if(this._oPreviousFocusedMainElement){this._oPreviousFocusedMainElement.focus()}else{var e=this.getMainContent();for(let t=0;t<e.length;++t){if(e[t].isFocusable()){e[t].focus();break}}}};R.prototype._focusSideContent=function(){var e=this._contentControlToFocus?i.byId(this._contentControlToFocus):this.getAggregation("_closeButton");e&&e.focus()};R.prototype._closeSideContent=function(){var e=i.byId(this.getSelectedItem()),t=true;if(e){t=this._fireToggle({item:e,expanded:false})}if(t){this._setSideContentExpanded(false);this.setAssociation("selectedItem",null);if(this._isSingleItem()){setTimeout(function(){var e=this.getAggregation("_arrowButton");e&&e.focus()}.bind(this),0)}}};R.prototype._toggleActionBarExpanded=function(){var e;if(this._isSingleItem()){e=!this.getActionBarExpanded()?this.getItems()[0]:null;if(e){var t=this._fireToggle({item:e,expanded:!!e});if(!t){return}}this.setAssociation("selectedItem",e);this._setSideContentExpanded(!!e);setTimeout(function(){var e=this.getAggregation("_closeButton");e&&e.focus()}.bind(this),0)}else{this.setActionBarExpanded(!this.getActionBarExpanded())}};R.prototype._fireToggle=function(e){this._contentControlToFocus=undefined;return this.fireToggle(e)};R.prototype._initItemNavigation=function(){var e=this.getItems(),t=[],i=e.length>this._iVisibleItems,n=i?this._iVisibleItems-1:e.length,s=this.getAggregation("_overflowItem"),o=this.getAggregation("_overflowMenu"),a,l,h;if(!e.length||!this._iVisibleItems){return}else{l=e[0].getDomRef().parentElement;o.destroyItems();this._mOverflowItemsMap={}}e.forEach(function(e,i){if(i<n){if(e.getEnabled()){a=this._getFocusDomRef(e);a.setAttribute("tabindex","-1");t.push(a)}e.$().css("display","flex")}else{e.$().css("display","none");h=new p({text:e.getText(),icon:e.getIcon(),enabled:e.getEnabled()});o.addItem(h);this._mOverflowItemsMap[h.getId()]=e}}.bind(this));if(i){s.$().css("visibility","visible");a=this._getFocusDomRef(s);a.setAttribute("tabindex","-1");t.push(a)}else{s.$().css("visibility","hidden")}if(!this._oItemNavigation){this._oItemNavigation=(new r).setCycling(false).attachEvent(r.Events.AfterFocus,this._onItemNavigationAfterFocus,this).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"]});this.addDelegate(this._oItemNavigation);this._bAnnounceSelected=true}this._oItemNavigation.setRootDomRef(l).setItemDomRefs(t).setPageSize(n);if(this._oItemNavigation.getFocusedIndex()===-1){this._oItemNavigation.setFocusedIndex(0)}};R.prototype._onItemNavigationAfterFocus=function(e){var t=this.getSelectedItem();if(t===this._oItemNavigation.getFocusedDomRef().id&&this._bAnnounceSelected){this._oInvisibleMessage.announce(v.getText("SIDEPANEL_NAV_ITEM_SELECTED"),I.Polite)}this._bAnnounceSelected=true};R.prototype._attachResizeHandlers=function(){this._iResizeHandlerId=o.register(this,this._fnOnResizeRef)};R.prototype._detachResizeHandlers=function(){if(this._iResizeHandlerId){o.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}};R.prototype._determineVisibleItems=function(){var e=this.getDomRef(),t=e&&e.querySelector(".sapFSPActionBarList");if(!t){return}var i=window.getComputedStyle(t),n=parseInt(i.gap),s=parseInt(i.marginBottom),o=parseInt(i.marginTop),a=e.querySelector(".sapFSPOverflowItem"),r=a&&a.clientHeight,l;if(!this._isSingleItem()){l=e.querySelector(".sapFSPSideInner").clientHeight-s-o;this._iVisibleItems=parseInt((l+n)/(r+n))}};R.prototype._onResize=function(t){if(!this.getItems().length||e.system.phone){return}this._determineVisibleItems();if(!this._isSingleItem()&&this._iVisibleItems>0){this._initItemNavigation()}if(this._getSideContentExpanded()){this._fixSidePanelWidth()}};R.prototype._fixSidePanelWidth=function(){var e=this.getDomRef(),t=e.querySelector(".sapFSPSide"),i=this._getControlWidth(),n=parseInt(window.getComputedStyle(t).width),s=i<n;t.style.width=s?i+"px":this._getSidePanelWidth();t.style.minWidth=s?i+"px":this._getSidePanelMinWidth();t.style.maxWidth=this._getSidePanelMaxWidth();this._updateSplitViewClass(t);this.getSidePanelResizable()&&this._updateAriaValues()};R.prototype._updateSplitViewClass=function(e){var t=parseInt(window.getComputedStyle(e).width);if(t>A){e.classList.add("sapFSPSplitView")}else{e.classList.remove("sapFSPSplitView")}};R.prototype._updateAriaValues=function(){var e=this.getDomRef(),t=e.querySelector(".sapFSPSplitterBar"),i=this._getControlWidth(),n=parseInt(window.getComputedStyle(e.querySelector(".sapFSPSide")).width);t.setAttribute("aria-valuenow",Math.round(n/i*100));t.setAttribute("aria-valuemin",Math.round(parseInt(window.getComputedStyle(e.querySelector(".sapFSPMinWidth")).width)/i*100));t.setAttribute("aria-valuemax",Math.round(parseInt(window.getComputedStyle(e.querySelector(".sapFSPMaxWidth")).width)/i*100))};R.prototype._setOverflowItemSelection=function(e){var t=this.getAggregation("_overflowItem"),i;if(!t||!t.getDomRef()){return}this._bOverflowMenuOpened=e;i=this._getOverflowItemText();t.setText(i,false);t.$().find(".sapFSPItemText").text(i)};R.prototype._getAriaLabelText=function(){var e=this.getAriaLabel();return e?e:v.getText("SIDEPANEL_DEFAULT_ARIA_LABEL")};R.prototype._getOverflowItemText=function(){return this._bOverflowMenuOpened?v.getText("SIDEPANEL_SHOW_LESS_TEXT"):v.getText("SIDEPANEL_MORE_ACTIONS_TEXT")};R.prototype._getSideContentAriaLabel=function(){return v.getText("SIDEPANEL_CONTENT_ARIA_LABEL")};R.prototype._getSplitterTitle=function(){return v.getText("SIDEPANEL_RESIZE_SPLITTER_TITLE")};R.prototype._toggleItemSelection=function(t){var n,s=this.getSelectedItem(),o=t.getDomRef(),a=t.getId()!==s,r,l=true;if(o&&o.classList.contains("sapFSPOverflowItem")){this._toggleOverflowMenu(o);return}if(!t.getEnabled()){return}if(s&&(!r||a)){l=this._fireToggle({item:a?i.byId(s):t,expanded:false})}if(!l){return}n=a?t:null;r=!!n;this.setAssociation("selectedItem",n);if(n){this._bAnnounceSelected=false;l=this._fireToggle({item:n,expanded:true});if(!l){this._setSideContentExpanded(false);return}}!e.system.phone&&this.getActionBarExpanded()&&this.setActionBarExpanded(false);this._setSideContentExpanded(r)};R.prototype._toggleOverflowMenu=function(e){var t=this.getAggregation("_overflowMenu"),i={onkeydown:this._overflowMenuOnkeydown.bind(this)};if(!e){if(this._bOverflowMenuOpened){this._bOverflowMenuOpened=false}return}if(this._bOverflowMenuOpened){this._setOverflowItemSelection(false);t.close()}else{this._setOverflowItemSelection(true);setTimeout(function(){var n=!t.getAggregation("_menu");t.openBy(e,false,s.Dock.BeginBottom,s.Dock.EndBottom,"3 0");t._getMenu().getPopup().setExtraContent([this.getAggregation("_overflowItem")]);n&&t.getAggregation("_menu").addEventDelegate(i)}.bind(this),0)}};R.prototype._overflowMenuOnkeydown=function(e){var t=this.getAggregation("_overflowItem");e.preventDefault();if(e.which===y.ARROW_RIGHT){this._closeOverflowMenu();t&&t.focus()}else if(e.which===y.ARROW_LEFT&&!(e.ctrlKey||e.metaKey)){this._closeOverflowMenu();this.setActionBarExpanded(false);this._focusMain()}};R.prototype._getSelectedItem=function(){return i.byId(this.getSelectedItem())};R.prototype._getSideContentHeaderTitle=function(){var e=this._getSelectedItem();if(!this._contentHeaderTitle){this._contentHeaderTitle=new h}e&&this._contentHeaderTitle.setText(e.getText())&&this._contentHeaderTitle.setTooltip(e.getText());return this._contentHeaderTitle};R.prototype._getSideContentHeaderIcon=function(){var e=this._getSelectedItem();if(!this._contentHeaderIcon){this._contentHeaderIcon=new n}e&&this._contentHeaderIcon.setSrc(e.getIcon());return this._contentHeaderIcon};R.prototype._getSideContentHeaderCloseBtn=function(){var t,i=this.getAggregation("_closeButton");if(this._isSingleItem()){t=e.system.phone?"sap-icon://navigation-down-arrow":"sap-icon://navigation-"+this.getSidePanelPosition().toLowerCase()+"-arrow"}else{t="sap-icon://decline"}if(!i){i=new d(this.getId()+"-closeButton",{type:"Transparent",tooltip:v.getText("SIDEPANEL_CLOSE_BUTTON_TEXT"),icon:t,press:function(){var e=this._getSelectedItem(),t=this.getAggregation("_overflowItem");this._bAnnounceSelected=false;if(!this._isSingleItem()){if(this.getDomRef().querySelector("#"+e.getId()).style.display==="none"){t&&t.focus()}else{e&&e.focus()}}this._closeSideContent()}.bind(this)});this.setAggregation("_closeButton",i)}else{i.setIcon(t)}return i};R.prototype._attachScrollHandler=function(){if(!e.system.phone||!this.getDomRef()){return}this.getDomRef().querySelector(".sapFSPMain").addEventListener("scroll",this._fnOnMainScroll)};R.prototype._detachScrollHandler=function(){if(!e.system.phone||!this.getDomRef()){return}this.getDomRef().querySelector(".sapFSPMain").removeEventListener("scroll",this._fnOnMainScroll)};R.prototype._closeOverflowMenu=function(){if(this._bOverflowMenuOpened){this._setOverflowItemSelection(false);this.getAggregation("_overflowMenu").close()}};R.prototype._attachMainFocusOutHandler=function(){if(!e.system.phone){var t=this.getDomRef();t&&t.querySelector(".sapFSPMain").addEventListener("focusout",this._fnOnMainFocusOut,false)}};R.prototype._detachMainFocusOutHandler=function(){if(!e.system.phone){var t=this.getDomRef();t&&t.querySelector(".sapFSPMain").removeEventListener("focusout",this._fnOnMainFocusOut,false)}};R.prototype._onMainFocusOut=function(e){this._oPreviousFocusedMainElement=e.target};R.prototype._handleScroll=function(e){var t,i,n;if(!this.bScrolling){this.bScrolling=true;t=parseInt(e.target.scrollTop);setTimeout(function(){i=t>this._iLastScrollPosition;n=t<this._iLastScrollPosition;this.setActionBarExpanded(!i||n);this._iLastScrollPosition=t;this.bScrolling=false}.bind(this),100)}};R.prototype._handleGroupNavigation=function(e,t){var i=new jQuery.Event("keydown");this.$().trigger("focus");i.target=e.target;i.key="F6";i.shiftKey=t;m.handleF6GroupNavigation(i)};R.prototype._isSingleItem=function(){return this.getItems().length===1};R.prototype._calculatePixelWidth=function(e){if(typeof e==="string"){e=e.replace(/\s/g,"");if(e.slice(-1)==="%"){e=parseInt(this._getControlWidth()*parseFloat(e)/100)+"px"}}else{e=e.toString()+"px"}return e};R.prototype._getControlWidth=function(){return parseInt(window.getComputedStyle(this.getDomRef()).width)};R.prototype._getSidePanelWidth=function(){return this._calculatePixelWidth(this.getSidePanelWidth())};R.prototype._getSidePanelMinWidth=function(){return this._calculatePixelWidth(this.getSidePanelMinWidth())};R.prototype._getSidePanelMaxWidth=function(){return this._calculatePixelWidth(this.getSidePanelMaxWidth())};R.prototype._isResizable=function(){return this.getSidePanelResizable()&&!e.system.phone&&(this.getActionBarExpanded()||this._getSideContentExpanded())};R.prototype._attachResizableHandlers=function(){var t=this.getDomRef(),i=t&&t.querySelector(".sapFSPSplitterBar");if(!i){return}if(e.system.combi||e.system.phone||e.system.tablet){i.addEventListener("touchstart",this._fnOnTouchStart);i.addEventListener("touchend",this._fnOnTouchEnd);i.addEventListener("touchmove",this._fnOnTouchMove)}if(e.system.desktop||e.system.combi){i.addEventListener("dblclick",this._fnOnDblClick);i.addEventListener("mousedown",this._fnOnTouchStart);t.addEventListener("mouseup",this._fnOnTouchEnd);t.addEventListener("mousemove",this._fnOnTouchMove)}};R.prototype._detachResizableHandlers=function(){var t=this.getDomRef(),i=t&&t.querySelector(".sapFSPSplitterBar");if(!i){return}if(e.system.combi||e.system.phone||e.system.tablet){i.removeEventListener("touchstart",this._fnOnTouchStart);i.removeEventListener("touchend",this._fnOnTouchEnd);i.removeEventListener("touchmove",this._fnOnTouchMove)}if(e.system.desktop||e.system.combi){i.removeEventListener("dblclick",this._fnOnDblClick);i.removeEventListener("mousedown",this._fnOnTouchStart);t.removeEventListener("mouseup",this._fnOnTouchEnd);t.removeEventListener("mousemove",this._fnOnTouchMove)}};R.prototype._onTouchStart=function(t){t.preventDefault();if(t.button===0||t.type==="touchstart"){if((e.system.desktop||e.system.combi)&&!(e.system.tablet||e.system.phone)){this.getDomRef().querySelector(".sapFSPSplitterBar").focus()}this._bResizeStarted=true;this._iStartPositionX=t.touches?t.touches[0].pageX:t.pageX}};R.prototype._onTouchEnd=function(e){this._bResizeStarted&&e.preventDefault();this._bResizeStarted=false};R.prototype._onTouchMove=function(e){if(!this._bResizeStarted){return}var t=e.touches?e.touches[0].pageX:e.pageX,i=this._iStartPositionX-t,n=this.getDomRef().querySelector(".sapFSPSide"),s=parseInt(window.getComputedStyle(n)["width"]);e.preventDefault();if(s){s+=i;this.setProperty("sidePanelWidth",s+"px",true);n.style.width=s+"px";this._iStartPositionX=t;this._updateSplitViewClass(n);this._updateAriaValues()}};R.prototype._onDblClick=function(e){e.preventDefault();this._iSidePanelPosition++;if(this._iSidePanelPosition>w){this._iSidePanelPosition=E}this._setSidePanelResizePosition(this._iSidePanelPosition)};R.prototype._setSidePanelResizePosition=function(e){var t=[this._getSidePanelMinWidth(),this._sSidePanelWidth,this._getSidePanelMaxWidth()];this.setProperty("sidePanelWidth",t[e],true);this._fixSidePanelWidth()};R.prototype._moveSidePanelResizePositionWith=function(e){var t=this.getDomRef().querySelector(".sapFSPSide"),i=parseInt(window.getComputedStyle(t)["width"]);if(e&&i){i+=e;this.setProperty("sidePanelWidth",i+"px",true);t.style.width=i+"px";this._updateAriaValues()}};R.prototype._showResizeContextMenu=function(e){var t=this._getContextMenu();this._bResizeStarted=false;this._bContextMenuFromSplitter&&t.openBy(this.getDomRef().querySelector(".sapFSPSplitterBarGrip"))||t.openAsContextMenu(e,this)};return R});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/SidePanelItem", ["sap/ui/core/Item"],function(e){"use strict";var t=e.extend("sap.f.SidePanelItem",{metadata:{library:"sap.f",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/SidePanelRenderer", ["sap/ui/Device","sap/ui/core/IconPool","./library"],function(e,t,n){"use strict";var a={apiVersion:2};a.render=function(t,r){var i=r.getActionBarExpanded();var o=r.getSidePanelPosition();t.openStart("div",r);t.class("sapFSP");if(!e.system.phone&&n.SidePanelPosition.Left===o){t.class("sapFSPLeft")}r._isSingleItem()&&t.class("sapFSPSingleItem");i&&r.getItems().length!==1&&t.class("sapFSPActionBarExpanded");r._getSideContentExpanded()&&t.class("sapFSPSideContentExpanded");t.openEnd();a.renderMain(t,r);r.getItems().length&&a.renderSide(t,r);!e.system.phone&&a.renderMeasureHelpers(t,r);t.close("div")};a.renderItem=function(n,a,r,i,o){var s=a.getSelectedItem(),d=a._isSingleItem(),l=e.system.phone,p=i===null,c=s===r.getId(),S=p?"aria-expanded":"aria-selected",g=p?a._getOverflowItemText():r.getText();n.openStart("li",r);!o&&n.attr("title",g);n.class("sapFSPItem");if(!r.getEnabled()){n.class("sapFSPDisabled")}if(!p&&c||p&&a._bOverflowMenuOpened){n.class("sapFSPSelected");n.attr(S,"true")}else{n.attr(S,"false")}p&&n.class("sapFSPOverflowItem")&&n.attr("aria-haspopup","menu");n.attr("role",p?"button":"option");!p&&n.attr("aria-posinset",i+1);n.openEnd();n.renderControl(t.createControlByURI({src:i===0&&d&&l?"sap-icon://navigation-up-arrow":r.getIcon(),useIconTooltip:false}));if(d&&l||!d&&o){n.openStart("span");n.class("sapFSPItemText");n.openEnd();n.text(g);n.close("span")}n.close("li")};a.renderMain=function(e,t){var n=t.getMainContent(),a;e.openStart("div");e.class("sapFSPMain");e.attr("data-sap-ui-fastnavgroup","true");e.openEnd();for(a=0;a<n.length;a++){e.renderControl(n[a])}e.close("div")};a.renderSide=function(t,n){var r=e.system.phone,i=n._isResizable();t.openStart("aside");t.class("sapFSPSide");i&&t.class("sapFSPResizable");t.attr("data-sap-ui-fastnavgroup","true");t.attr("role","region");t.attr("aria-label",n._getAriaLabelText());n._getSideContentExpanded()&&!r&&t.style("width",n._getSidePanelWidth());t.openEnd();t.openStart("div");t.class("sapFSPSideInner");t.openEnd();a.renderActionBar(t,n);n.getSelectedItem()&&a.renderSideContent(t,n);i&&a.renderSplitterBar(t,n);t.close("div");t.close("aside")};a.renderSideContent=function(e,t){var n=t._getSelectedItem().getContent(),r;if(t._getSideContentExpanded()){e.openStart("div");e.class("sapFSPSideContent");e.attr("data-sap-ui-fastnavgroup","true");e.attr("role","region");e.attr("aria-label",t._getSideContentHeaderTitle().getText());e.openEnd();a.renderSideContentHeader(e,t);e.openStart("div");e.class("sapFSPSideContentInner");e.attr("aria-labelledby",t.getId()+"-header");e.openEnd();for(r=0;r<n.length;r++){e.renderControl(n[r])}e.close("div");e.close("div")}};a.renderSideContentHeader=function(e,t){e.openStart("div",t.getId()+"-header");e.class("sapFSPSideContentHeader");e.openEnd();e.renderControl(t._getSideContentHeaderIcon());e.renderControl(t._getSideContentHeaderTitle());e.renderControl(t._getSideContentHeaderCloseBtn());e.close("div")};a.renderActionBar=function(t,n){var r=n.getItems(),i=n.getActionBarExpanded(),o=r.length===1,s=e.system.phone,d=n.getAggregation("_arrowButton"),l;t.openStart("div");t.class("sapFSPActionBar");t.openEnd();if(!s){o&&d.setTooltip(n.getItems()[0].getText());t.renderControl(d)}if(r.length){t.openStart("div");t.class("sapFSPActionBarListWrapper");i&&t.class("sapFSPExpanded");t.attr("role","toolbar");t.openEnd();t.openStart("ul",n.getId()+"-ActionBarList");t.class("sapFSPActionBarList");r.length<4&&t.class("sapFSPCenteredItems");t.attr("aria-multiselectable","false");t.attr("aria-label","Actions");t.attr("role","listbox");t.openEnd();if(s||r.length>1){for(l=0;l<r.length;l++){a.renderItem(t,n,r[l],l,i)}if(!s){a.renderItem(t,n,n.getAggregation("_overflowItem"),null,i)}}t.close("ul");t.close("div")}t.close("div")};a.renderSplitterBar=function(e,t){e.openStart("div",t.getId()+"-resizeSplitter");e.class("sapFSPSplitterBar");e.attr("tabindex",0);e.attr("role","separator");e.attr("aria-orientation","vertical");e.attr("aria-roledescription","splitter");e.attr("title",t._getSplitterTitle());e.openEnd();e.openStart("div");e.class("sapFSPSplitterBarDecorationBefore");e.openEnd();e.close("div");e.openStart("div");e.class("sapFSPSplitterBarGrip");e.openEnd();e.icon("sap-icon://vertical-grip",["sapFSPSplitterBarGripIcon"]);e.close("div");e.openStart("div");e.class("sapFSPSplitterBarDecorationAfter");e.openEnd();e.close("div");e.close("div")};a.renderMeasureHelpers=function(e,t){e.openStart("div");e.class("sapFSPMinWidth");e.style("width",t.getSidePanelMinWidth());e.openEnd();e.close("div");e.openStart("div");e.class("sapFSPMaxWidth");e.style("width",t.getSidePanelMaxWidth());e.openEnd();e.close("div")};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/BaseHeader", ["sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/IntervalTrigger","sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/core/library","sap/m/Text"],function(e,t,a,i,s,r,o){"use strict";var n=6e4;var p=r.TextAlign;var m=e.extend("sap.f.cards.BaseHeader",{metadata:{library:"sap.f",abstract:true,properties:{dataTimestamp:{type:"string",defaultValue:""},statusVisible:{type:"boolean",defaultValue:true},dataTimestampUpdating:{type:"boolean",defaultValue:false,visibility:"hidden"},focusable:{type:"boolean",defaultValue:true,visibility:"hidden"},useTileLayout:{type:"boolean",group:"Appearance",visibility:"hidden"}},aggregations:{_dataTimestamp:{type:"sap.m.Text",multiple:false,visibility:"hidden"},toolbar:{type:"sap.ui.core.Control",multiple:false},_error:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},bannerLines:{type:"sap.m.Text",group:"Appearance",multiple:true}}}});m.prototype.init=function(){this._oRb=t.getLibraryResourceBundle("sap.f");this._oToolbarDelegate={onfocusin:this._onToolbarFocusin,onfocusout:this._onToolbarFocusout}};m.prototype.exit=function(){this._removeTimestampListener();if(this._oToolbarDelegate){this._oToolbarDelegate=null}this._oRb=null};m.prototype.onBeforeRendering=function(){var e=this.getToolbar(),t=this.getBannerLines();if(e){e.addStyleClass("sapFCardHeaderToolbar");e.removeEventDelegate(this._oToolbarDelegate,this)}if(t){t.forEach(e=>{e.setTextAlign(p.End)})}};m.prototype.onAfterRendering=function(){var e=this.getToolbar();if(e){e.addEventDelegate(this._oToolbarDelegate,this)}};m.prototype.getFocusDomRef=function(){return this.getDomRef("focusable")};m.prototype.ontap=function(e){if(this.isInteractive()&&!this._isInsideToolbar(e.target)){this.firePress()}};m.prototype.onsapselect=function(e){if(this.isInteractive()&&!this._isInsideToolbar(e.target)){this.firePress()}};m.prototype._onToolbarFocusin=function(){var e=this.getDomRef();if(e){this.getDomRef().classList.add("sapFCardHeaderToolbarFocused")}};m.prototype._onToolbarFocusout=function(){var e=this.getDomRef();if(e){this.getDomRef().classList.remove("sapFCardHeaderToolbarFocused")}};m.prototype.setDataTimestamp=function(e){var t=this.getDataTimestamp();if(t&&!e){this.destroyAggregation("_dataTimestamp");this._removeTimestampListener()}this.setProperty("dataTimestamp",e);if(e){this._updateDataTimestamp();this._addTimestampListener()}return this};m.prototype.setDataTimestampUpdating=function(e){var t=this._createDataTimestamp();this.setProperty("dataTimestampUpdating",e);if(e){t.setText("updating...");t.addStyleClass("sapFCardDataTimestampUpdating");this._removeTimestampListener()}else{t.removeStyleClass("sapFCardDataTimestampUpdating")}return this};m.prototype._createDataTimestamp=function(){var e=this.getAggregation("_dataTimestamp");if(!e){e=new o({wrapping:false,textAlign:"End"});e.addStyleClass("sapFCardDataTimestamp");this.setAggregation("_dataTimestamp",e)}return e};m.prototype._updateDataTimestamp=function(){var e=this._createDataTimestamp(),t=this.getDataTimestamp(),a,r,o;if(!t){e.setText("");return}a=i.getDateTimeInstance({relative:true});r=new s(t);o=a.format(r);if(r.getTime()+59e3>Date.now()){o="now"}e.setText(o);e.removeStyleClass("sapFCardDataTimestampUpdating")};m.prototype._addTimestampListener=function(){m.getTimestampIntervalTrigger().addListener(this._updateDataTimestamp,this);this._bHasTimestampListener=true};m.prototype._removeTimestampListener=function(){if(!this._bHasTimestampListener){return}m.getTimestampIntervalTrigger().removeListener(this._updateDataTimestamp,this);this._bHasTimestampListener=false};m.getTimestampIntervalTrigger=function(){if(!m._oTimestampIntervalTrigger){m._oTimestampIntervalTrigger=new a(n)}return m._oTimestampIntervalTrigger};m.prototype.getTitleAriaRole=function(){return"heading"};m.prototype.getFocusableElementAriaRole=function(){return this.hasListeners("press")?"button":"group"};m.prototype.getAriaHeadingLevel=function(){return"3"};m.prototype.getAriaRoleDescription=function(){return this.hasListeners("press")?this._oRb.getText("ARIA_ROLEDESCRIPTION_INTERACTIVE_CARD_HEADER"):this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER")};m.prototype._getBannerLinesIds=function(){return this.getBannerLines().map(e=>e.getId()).join(" ")};m.prototype._isInsideGridContainer=function(){var e=this.getParent();if(!e){return false}e=e.getParent();if(!e){return false}return e.isA("sap.f.GridContainer")};m.prototype.isInteractive=function(){return this.hasListeners("press")};m.prototype._isInsideToolbar=function(e){var t=this.getToolbar();return t&&t.getDomRef()&&t.getDomRef().contains(e)};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/BaseHeaderRenderer", [],function(){"use strict";var n={apiVersion:2};n.renderAvatar=function(n,e){var r=e.getAggregation("_avatar"),a=e.mBindingInfos,i=e.shouldShowIcon();if(i&&(!e.isPropertyInitial("iconSrc")||!e.isPropertyInitial("iconInitials"))){n.openStart("div").class("sapFCardHeaderImage").openEnd();if(a.iconSrc&&a.iconSrc.binding&&!a.iconSrc.binding.getValue()){r.addStyleClass("sapFCardHeaderItemBinded")}n.renderControl(r);n.renderControl(e._oAriaAvatarText);n.close("div")}};n.renderBanner=function(n,e){const r=e.getBannerLines()||[];const a=r.filter(n=>n.getVisible());if(!a.length){return}n.openStart("div").class("sapFCardHeaderBanner").openEnd();n.openStart("div").class("sapFCardHeaderBannerInner").openEnd();r.forEach(e=>{n.openStart("div").class("sapFCardHeaderBannerLine").openEnd();n.renderControl(e);n.close("div")});n.close("div");n.close("div")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/Header", ["./BaseHeader","sap/m/library","sap/f/library","sap/m/Text","sap/m/Avatar","sap/f/cards/HeaderRenderer","sap/ui/core/InvisibleText"],function(t,e,i,a,s,r,n){"use strict";const o=e.AvatarShape;const l=e.AvatarColor;const p=e.AvatarImageFitType;const u=e.AvatarSize;var g=t.extend("sap.f.cards.Header",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{type:"string",defaultValue:""},titleMaxLines:{type:"int",defaultValue:3},subtitle:{type:"string",defaultValue:""},subtitleMaxLines:{type:"int",defaultValue:2},statusText:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:o.Circle},iconSrc:{type:"sap.ui.core.URI",defaultValue:""},iconInitials:{type:"string",defaultValue:""},iconAlt:{type:"string",defaultValue:""},iconBackgroundColor:{type:"sap.m.AvatarColor",defaultValue:l.Transparent},iconVisible:{type:"boolean",defaultValue:true},iconSize:{type:"sap.m.AvatarSize",defaultValue:u.S}},aggregations:{_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:r});g.prototype.init=function(){t.prototype.init.apply(this,arguments);this.data("sap-ui-fastnavgroup","true",true);this._oAriaAvatarText=new n({id:this.getId()+"-ariaAvatarText"});this._oAriaAvatarText.setText(this._oRb.getText("ARIA_HEADER_AVATAR_TEXT"))};g.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oAriaAvatarText.destroy();this._oAriaAvatarText=null};g.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new a(this.getId()+"-title").addStyleClass("sapFCardTitle");this.setAggregation("_title",t)}return t};g.prototype._getSubtitle=function(){var t=this.getAggregation("_subtitle");if(!t){t=(new a).addStyleClass("sapFCardSubtitle");this.setAggregation("_subtitle",t)}return t};g.prototype._getAvatar=function(){var t=this.getAggregation("_avatar");if(!t){t=new s({imageFitType:p.Contain}).addStyleClass("sapFCardIcon");this.setAggregation("_avatar",t)}return t};g.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);this._getTitle().setText(this.getTitle()).setMaxLines(this.getTitleMaxLines());this._getSubtitle().setText(this.getSubtitle()).setMaxLines(this.getSubtitleMaxLines());this._getAvatar().setDisplayShape(this.getIconDisplayShape()).setSrc(this.getIconSrc()).setInitials(this.getIconInitials()).setTooltip(this.getIconAlt()).setBackgroundColor(this.getIconBackgroundColor()).setDisplaySize(this.getIconSize())};g.prototype.shouldShowIcon=function(){return this.getIconVisible()};g.prototype.enhanceAccessibilityState=function(t,e){if(t===this.getAggregation("_title")){e.role=this.getTitleAriaRole();e.level=this.getAriaHeadingLevel()}};g.prototype._getAriaLabelledBy=function(){const t=[];if(this.getParent()&&this.getParent()._ariaText){t.push(this.getParent()._ariaText.getId())}if(this.getTitle()){t.push(this._getTitle().getId())}if(this.getSubtitle()){t.push(this._getSubtitle().getId())}if(this.getStatusText()){t.push(this.getId()+"-status")}if(this.getIconSrc()||this.getIconInitials()){t.push(this.getId()+"-ariaAvatarText")}t.push(this._getBannerLinesIds());return t.filter(t=>!!t).join(" ")};g.prototype.isLoading=function(){return false};g.prototype.attachPress=function(){var e=Array.prototype.slice.apply(arguments);e.unshift("press");t.prototype.attachEvent.apply(this,e);this.invalidate();return this};g.prototype.detachPress=function(){var e=Array.prototype.slice.apply(arguments);e.unshift("press");t.prototype.detachEvent.apply(this,e);this.invalidate();return this};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/HeaderRenderer", ["sap/f/cards/BaseHeaderRenderer","sap/ui/core/Renderer"],function(e,a){"use strict";var t=a.extend(e);t.apiVersion=2;t.render=function(a,t){var r=t.getId(),i=t.mBindingInfos,s=t.getStatusText(),d=t.getAggregation("_title"),n=t.getAggregation("_subtitle"),o=t.getSubtitle()||i.subtitle,l=t.getAggregation("_dataTimestamp"),p=t.getDataTimestamp()||i.dataTimestamp,c=t.isLoading(),g=t.getAggregation("_error"),f=t.getToolbar(),u=t.getProperty("useTileLayout");a.openStart("div",t).class("sapFCardHeader");if(c){a.class("sapFCardHeaderLoading")}if(t.isInteractive()){a.class("sapFCardSectionClickable")}if(t.getIconSrc()&&t.getIconVisible()){a.class("sapFCardHeaderHasIcon")}a.openEnd();a.openStart("div").attr("id",r+"-focusable").class("sapFCardHeaderWrapper");if(t.getProperty("focusable")&&!t._isInsideGridContainer()){a.attr("tabindex","0")}if(!t._isInsideGridContainer()){a.accessibilityState({labelledby:{value:t._getAriaLabelledBy(),append:true},role:t.getFocusableElementAriaRole(),roledescription:t.getAriaRoleDescription()})}a.openEnd();if(g){a.renderControl(g);a.close("div");a.close("div");return}if(!u){e.renderAvatar(a,t)}a.openStart("div").class("sapFCardHeaderText").openEnd();if(t.getTitle()||i.title){a.openStart("div").class("sapFCardHeaderTextFirstLine").openEnd();if(i.title){d.addStyleClass("sapFCardHeaderItemBinded")}a.renderControl(d);if(s&&t.getStatusVisible()){a.openStart("span",r+"-status").class("sapFCardStatus");if(i.statusText){a.class("sapFCardHeaderItemBinded")}a.openEnd().text(s).close("span")}a.close("div");if(o||p){a.openStart("div").class("sapFCardHeaderTextSecondLine");if(p){a.class("sapFCardHeaderLineIncludesDataTimestamp")}a.openEnd();if(o){if(i.subtitle){n.addStyleClass("sapFCardHeaderItemBinded")}a.renderControl(n)}if(p){a.renderControl(l)}a.close("div")}}a.close("div");if(u){e.renderAvatar(a,t)}e.renderBanner(a,t);a.close("div");if(f){a.openStart("div").class("sapFCardHeaderToolbarCont").openEnd();a.renderControl(f);a.close("div")}a.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/NumericHeader", ["./BaseHeader","./NumericIndicators","sap/base/Log","sap/m/library","sap/m/Text","sap/m/ObjectStatus","sap/f/cards/NumericHeaderRenderer","sap/ui/core/library","sap/m/Avatar","sap/ui/core/InvisibleText"],function(t,e,i,a,s,r,n,o,p,l){"use strict";const u=o.ValueState;const g=a.AvatarShape;const d=a.AvatarColor;const c=a.AvatarImageFitType;const h=a.AvatarSize;var f=t.extend("sap.f.cards.NumericHeader",{metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{type:"string",group:"Appearance"},titleMaxLines:{type:"int",defaultValue:3},subtitle:{type:"string",group:"Appearance"},subtitleMaxLines:{type:"int",defaultValue:2},statusText:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:g.Circle},iconSrc:{type:"sap.ui.core.URI",defaultValue:""},iconInitials:{type:"string",defaultValue:""},iconAlt:{type:"string",defaultValue:""},iconBackgroundColor:{type:"sap.m.AvatarColor",defaultValue:d.Transparent},iconVisible:{type:"boolean",defaultValue:true},iconSize:{type:"sap.m.AvatarSize",defaultValue:h.S},unitOfMeasurement:{type:"string",group:"Data"},number:{type:"string",group:"Data"},numberSize:{type:"string",group:"Appearance",defaultValue:"L"},numberVisible:{type:"boolean",defaultValue:true},scale:{type:"string",group:"Data"},trend:{type:"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},details:{type:"string",group:"Appearance"},detailsState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:u.None},detailsMaxLines:{type:"int",defaultValue:1},sideIndicatorsAlignment:{type:"sap.f.cards.NumericHeaderSideIndicatorsAlignment",group:"Appearance",defaultValue:"Begin"}},aggregations:{sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true,forwarding:{getter:"_getNumericIndicators",aggregation:"sideIndicators"}},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_unitOfMeasurement:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_details:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_numericIndicators:{type:"sap.f.cards.NumericIndicators",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:n});f.prototype.init=function(){t.prototype.init.apply(this,arguments);this.data("sap-ui-fastnavgroup","true",true);this._oAriaAvatarText=new l({id:this.getId()+"-ariaAvatarText"});this._oAriaAvatarText.setText(this._oRb.getText("ARIA_HEADER_AVATAR_TEXT"))};f.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oAriaAvatarText.destroy();this._oAriaAvatarText=null};f.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);this._getTitle().setText(this.getTitle()).setMaxLines(this.getTitleMaxLines());this._getSubtitle().setText(this.getSubtitle()).setMaxLines(this.getSubtitleMaxLines());this._getUnitOfMeasurement().setText(this.getUnitOfMeasurement());this._getAvatar().setDisplayShape(this.getIconDisplayShape()).setSrc(this.getIconSrc()).setInitials(this.getIconInitials()).setTooltip(this.getIconAlt()).setBackgroundColor(this.getIconBackgroundColor()).setDisplaySize(this.getIconSize());if(!this.isPropertyInitial("detailsState")&&!this.isPropertyInitial("detailsMaxLines")){i.error("Both details state and details max lines can not be used at the same time. Max lines setting will be ignored.")}if(!this.isPropertyInitial("detailsState")){this._createDetails(true).setText(this.getDetails()).setState(this.getDetailsState())}else{this._createDetails().setText(this.getDetails()).setMaxLines(this.getDetailsMaxLines())}this._getNumericIndicators().setNumber(this.getNumber()).setNumberSize(this.getNumberSize()).setScale(this.getScale()).setTrend(this.getTrend()).setState(this.getState()).setSideIndicatorsAlignment(this.getSideIndicatorsAlignment()).setNumberVisible(this.getNumberVisible())};f.prototype.shouldShowIcon=function(){return this.getIconVisible()};f.prototype.enhanceAccessibilityState=function(t,e){if(t===this.getAggregation("_title")){e.role=this.getTitleAriaRole();e.level=this.getAriaHeadingLevel()}};f.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new s({id:this.getId()+"-title",wrapping:true,maxLines:this.getTitleMaxLines()});this.setAggregation("_title",t)}return t};f.prototype._getSubtitle=function(){var t=this.getAggregation("_subtitle");if(!t){t=new s({id:this.getId()+"-subtitle",wrapping:true,maxLines:this.getSubtitleMaxLines()});this.setAggregation("_subtitle",t)}return t};f.prototype._getAvatar=function(){var t=this.getAggregation("_avatar");if(!t){t=new p({imageFitType:c.Contain}).addStyleClass("sapFCardIcon");this.setAggregation("_avatar",t)}return t};f.prototype._getUnitOfMeasurement=function(){var t=this.getAggregation("_unitOfMeasurement");if(!t){t=new s({id:this.getId()+"-unitOfMeasurement",wrapping:false});this.setAggregation("_unitOfMeasurement",t)}return t};f.prototype._createDetails=function(t){var e=this.getAggregation("_details");if(e?.isA("sap.m.Text")&&t){e.destroy()}else if(e){return e}var i={id:this._getDetailsId()};if(t){e=new r(i)}else{e=new s(i)}this.setAggregation("_details",e);return e};f.prototype._getDetails=function(){return this.getAggregation("_details")};f.prototype._getDetailsId=function(){return this.getId()+"-details"};f.prototype._getNumericIndicators=function(){var t=this.getAggregation("_numericIndicators");if(!t){t=new e;this.setAggregation("_numericIndicators",t)}return t};f.prototype._getAriaLabelledBy=function(){const t=[];if(this.getParent()&&this.getParent()._ariaText){t.push(this.getParent()._ariaText.getId())}if(this.getTitle()){t.push(this._getTitle().getId())}if(this.getSubtitle()){t.push(this._getSubtitle().getId())}if(this.getStatusText()){t.push(this.getId()+"-status")}t.push(this._getUnitOfMeasurement().getId());if(this.getIconSrc()||this.getIconInitials()){t.push(this.getId()+"-ariaAvatarText")}if(this.getNumber()||this.getScale()){t.push(this._getNumericIndicators()._getMainIndicator().getId())}t.push(this._getSideIndicatorIds());if(this.getDetails()){t.push(this._getDetailsId())}t.push(this._getBannerLinesIds());return t.filter(t=>!!t).join(" ")};f.prototype._getSideIndicatorIds=function(){return this.getSideIndicators().map(function(t){return t.getId()}).join(" ")};f.prototype.isLoading=function(){return false};f.prototype.attachPress=function(){var e=Array.prototype.slice.apply(arguments);e.unshift("press");t.prototype.attachEvent.apply(this,e);this.invalidate();return this};f.prototype.detachPress=function(){var e=Array.prototype.slice.apply(arguments);e.unshift("press");t.prototype.detachEvent.apply(this,e);this.invalidate();return this};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/NumericHeaderRenderer", ["sap/f/cards/BaseHeaderRenderer","sap/ui/core/Renderer"],function(e,a){"use strict";var r=a.extend(e);r.apiVersion=2;r.render=function(a,t){var d=t.isLoading(),n=t.getAggregation("_error");a.openStart("div",t).class("sapFCardHeader").class("sapFCardNumericHeader");if(d){a.class("sapFCardHeaderLoading")}if(t.isInteractive()){a.class("sapFCardSectionClickable")}if(t.getIconSrc()&&t.getIconVisible()){a.class("sapFCardHeaderHasIcon")}if(t.getNumber()&&t.getNumberVisible()){a.class("sapFCardHeaderHasNumber")}a.openEnd();a.openStart("div").attr("id",t.getId()+"-focusable").class("sapFCardHeaderContent");if(t.getProperty("focusable")&&!t._isInsideGridContainer()){a.attr("tabindex","0")}if(!t._isInsideGridContainer()){a.accessibilityState({labelledby:{value:t._getAriaLabelledBy(),append:true},role:t.getFocusableElementAriaRole(),roledescription:t.getAriaRoleDescription()})}a.openEnd();if(n){a.renderControl(n)}else{r.renderHeaderText(a,t);r.renderAvatarAndIndicatorsLine(a,t);r.renderDetails(a,t);e.renderBanner(a,t)}a.close("div");if(!n){r.renderToolbar(a,t)}a.close("div")};r.renderToolbar=function(e,a){var r=a.getToolbar();if(r){e.openStart("div").class("sapFCardHeaderToolbarCont").openEnd();e.renderControl(r);e.close("div")}};r.renderHeaderText=function(e,a){var t=a.getAggregation("_title"),d=a.getStatusText(),n=a.mBindingInfos;e.openStart("div").class("sapFCardHeaderText").openEnd();e.openStart("div").class("sapFCardHeaderTextFirstLine").openEnd();if(t){if(n.title){t.addStyleClass("sapFCardHeaderItemBinded")}t.addStyleClass("sapFCardTitle");e.renderControl(t)}if(d&&a.getStatusVisible()){e.openStart("span",a.getId()+"-status").class("sapFCardStatus");if(n.statusText){e.class("sapFCardHeaderItemBinded")}e.openEnd().text(d).close("span")}e.close("div");r.renderSubtitle(e,a);e.close("div")};r.renderSubtitle=function(e,a){var r=a.mBindingInfos,t=a.getAggregation("_subtitle"),d=a.getAggregation("_unitOfMeasurement"),n=t&&t.getText()||r&&r.subtitle,s=d&&d.getText()||r&&r.unitOfMeasurement;if(n||s){e.openStart("div").class("sapFCardSubtitle");if(n&&d){e.class("sapFCardSubtitleAndUnit")}e.openEnd();if(t){if(r.subtitle){t.addStyleClass("sapFCardHeaderItemBinded")}e.renderControl(t)}if(d){d.addStyleClass("sapFCardHeaderUnitOfMeasurement");if(r.unitOfMeasurement){d.addStyleClass("sapFCardHeaderItemBinded")}e.renderControl(d)}e.close("div")}};r.renderAvatarAndIndicatorsLine=function(a,t){a.openStart("div").class("sapFCardAvatarAndIndicatorsLine").openEnd();e.renderAvatar(a,t);r.renderIndicators(a,t);a.close("div")};r.renderIndicators=function(e,a){if(!a.getNumber()&&!a.isBound("number")&&a.getSideIndicators().length===0){return}var r=a._getNumericIndicators(),t=r._getMainIndicator();if(a.isBound("scale")||a.isBound("number")||a.isBound("trend")||a.isBound("state")){t.addStyleClass("sapFCardHeaderItemBinded")}else{t.removeStyleClass("sapFCardHeaderItemBinded")}e.renderControl(r)};r.renderDetails=function(e,a){var r=a.mBindingInfos,t=a.getAggregation("_details"),d=a.getDetails()||r.details,n=a.getAggregation("_dataTimestamp"),s=a.getDataTimestamp()||r.dataTimestamp;if(!d&&!s){return}e.openStart("div").class("sapFCardHeaderDetailsWrapper");if(s){e.class("sapFCardHeaderLineIncludesDataTimestamp")}e.openEnd();if(d){if(r.details){t.addStyleClass("sapFCardHeaderItemBinded")}t.addStyleClass("sapFCardHeaderDetails");e.renderControl(t)}if(s){e.renderControl(n)}e.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/NumericIndicators", ["./NumericIndicatorsRenderer","sap/ui/core/Control","sap/m/NumericContent"],function(e,t,a){"use strict";var i=t.extend("sap.f.cards.NumericIndicators",{metadata:{library:"sap.f",properties:{number:{type:"string",group:"Data"},numberSize:{type:"string",group:"Appearance",defaultValue:"L"},numberVisible:{type:"boolean",defaultValue:true},scale:{type:"string",group:"Data"},trend:{type:"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},sideIndicatorsAlignment:{type:"sap.f.cards.NumericHeaderSideIndicatorsAlignment",group:"Appearance",defaultValue:"Begin"}},aggregations:{sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true},_mainIndicator:{type:"sap.m.NumericContent",multiple:false,visibility:"hidden"}}},renderer:e});i.prototype.onBeforeRendering=function(){this._getMainIndicator().setValue(this.getNumber()).setScale(this.getScale()).setIndicator(this.getTrend()).setValueColor(this.getState()).setVisible(this.getNumberVisible())};i.prototype._getMainIndicator=function(){var e=this.getAggregation("_mainIndicator");if(!e){e=new a({id:this.getId()+"-mainIndicator",withMargin:false,nullifyValue:false,animateTextChange:false,truncateValueTo:100});this.setAggregation("_mainIndicator",e)}return e};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/NumericIndicatorsRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,i){var n=i.getAggregation("_mainIndicator"),r=i.getSideIndicators(),a=r.some(function(e){return e.getVisible()});e.openStart("div",i).class("sapFCardNumericIndicators").class("sapFCardNumericIndicatorsSideAlign"+i.getSideIndicatorsAlignment());if(i.getNumberSize()==="S"){e.class("sapMTileSmallPhone")}e.openEnd();if(n&&i.getNumberVisible()){e.openStart("div").class("sapFCardNumericIndicatorsMain").openEnd().renderControl(n).close("div");e.openStart("div").class("sapFCardNumericIndicatorsGap").openEnd().close("div")}if(r.length!==0&&a){e.openStart("div").class("sapFCardNumericIndicatorsSide").openEnd();r.forEach(function(i){e.renderControl(i)});e.close("div")}e.close("div")};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/NumericSideIndicator", ["sap/ui/core/Control","sap/m/Text","sap/f/cards/NumericSideIndicatorRenderer"],function(t,e,i){"use strict";var r=t.extend("sap.f.cards.NumericSideIndicator",{metadata:{library:"sap.f",properties:{title:{type:"string",group:"Appearance"},number:{type:"string",group:"Data"},unit:{type:"string",group:"Data"},state:{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"None"}},aggregations:{_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_number:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unit:{type:"sap.m.Text",multiple:false,visibility:"hidden"}}},renderer:i});r.prototype.setTitle=function(t){this.setProperty("title",t,true);this._getTitle().setText(t);return this};r.prototype.setNumber=function(t){this.setProperty("number",t,true);this._getNumber().setText(t);return this};r.prototype.setUnit=function(t){this.setProperty("unit",t,true);this._getUnit().setText(t);return this};r.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new e({id:this.getId()+"-title",wrapping:false});this.setAggregation("_title",t)}return t};r.prototype._getNumber=function(){var t=this.getAggregation("_number");if(!t){t=new e({id:this.getId()+"-number"});this.setAggregation("_number",t)}return t};r.prototype._getUnit=function(){var t=this.getAggregation("_unit");if(!t){t=new e({id:this.getId()+"-unit"});this.setAggregation("_unit",t)}return t};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/NumericSideIndicatorRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,r){var a=r.mBindingInfos;e.openStart("div",r).class("sapFCardHeaderSideIndicator").class("sapFCardHeaderSideIndicatorState"+r.getState());if(a.title||a.number||a.unit){e.class("sapFCardHeaderItemBinded")}e.openEnd();var t=r.getAggregation("_title");if(t){t.addStyleClass("sapFCardHeaderSITitle");e.renderControl(t)}e.openStart("div").class("sapFCardHeaderSINumber");if(a.title||a.number||a.unit||a.state){e.class("sapFCardHeaderItemBinded")}e.openEnd();var n=r.getAggregation("_number");if(n){e.renderControl(n)}var d=r.getAggregation("_unit");if(d){e.renderControl(d)}e.close("div");e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/AnalyticalPlaceholder", ["sap/f/cards/loading/PlaceholderBase","./AnalyticalPlaceholderRenderer"],function(e,a){"use strict";var r=e.extend("sap.f.cards.loading.AnalyticalPlaceholder",{metadata:{library:"sap.f",properties:{chartType:{type:"string",defaultValue:""},minHeight:{type:"string",defaultValue:""}}},renderer:a});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/AnalyticalPlaceholderRenderer", ["sap/ui/core/Renderer","./PlaceholderBaseRenderer"],function(C,e){"use strict";var H=C.extend(e);H.apiVersion=2;H.CSS_CLASS_PLACEHOLDER="sapFCardContentAnalyticalPlaceholder";H.renderSVG=function(C,e){var H=C.getChartType().toLowerCase();e.openStart("svg").class("sapFCardLoadingShimmer").attr("width","100%").attr("height","100%").attr("xmlns","http://www.w3.org/2000/svg").attr("version","1.1");if(H.indexOf("line")>-1){e.attr("viewBox","0 0 262 191")}else if(H.indexOf("bar")>-1){e.attr("viewBox","0 0 268 186")}else if(H.indexOf("pie")>-1||H.indexOf("donut")>-1){e.attr("viewBox","0 0 263 165")}else{e.attr("viewBox","0 0 266 188")}e.class("sapFCardSVG").openEnd();e.openStart("path");if(H.indexOf("line")>-1){e.attr("d","M262 0H0V191H262V0ZM3 5C3 3.89543 3.89543 3 5 3H11C12.1046 3 13 3.89543 13 5V7C13 8.10457 12.1046 9 11 9H5C3.89543 9 3 8.10457 3 7V5ZM18 6C18 5.44772 18.4477 5 19 5H258C258.552 5 259 5.44772 259 6C259 6.55228 258.552 7 258 7H19C18.4477 7 18 6.55228 18 6ZM18 42C18 41.4477 18.4477 41 19 41H236.084L239.727 38.3375C239.26 37.3217 239 36.1913 239 35C239 30.5817 242.582 27 247 27C251.418 27 255 30.5817 255 35C255 37.3894 253.952 39.5341 252.292 41H258C258.552 41 259 41.4477 259 42C259 42.5523 258.552 43 258 43H247H240.127L215.092 61.2945C215.672 62.4023 216 63.6629 216 65C216 69.4183 212.418 73 208 73C204.96 73 202.316 71.3044 200.962 68.8073L175.988 75.4461C175.958 75.9797 175.877 76.4993 175.748 77H258C258.552 77 259 77.4477 259 78C259 78.5523 258.552 79 258 79H174.93C173.547 81.3912 170.961 83 168 83C165.69 83 163.608 82.0207 162.148 80.4546L135.905 92.7659C135.968 93.1681 136 93.5803 136 94C136 98.4183 132.418 102 128 102C126.483 102 125.066 101.578 123.857 100.845L111.391 113H258C258.552 113 259 113.448 259 114C259 114.552 258.552 115 258 115H109.339L94.9479 129.032C95.6173 130.201 96 131.556 96 133C96 137.418 92.4183 141 88 141C86.2836 141 84.6935 140.459 83.3905 139.539L72.0664 149H258C258.552 149 259 149.448 259 150C259 150.552 258.552 151 258 151H69.6725L55.3905 162.932C55.7832 163.877 56 164.913 56 166C56 170.418 52.4183 174 48 174C45.9336 174 44.0501 173.217 42.6305 171.93L23.5663 183H257C258.105 183 259 183.895 259 185C259 186.105 258.105 187 257 187H5C3.89543 187 3 186.105 3 185C3 183.895 3.89543 183 5 183H16.129L15.9957 182.77L40.4267 168.585C40.1501 167.774 40 166.904 40 166C40 161.582 43.5817 158 48 158C49.8812 158 51.6107 158.649 52.9767 159.736L63.4335 151H19C18.4477 151 18 150.552 18 150C18 149.448 18.4477 149 19 149H65.8275L80.8 136.491C80.2875 135.436 80 134.252 80 133C80 128.582 83.5817 125 88 125C89.5231 125 90.9468 125.426 92.1587 126.164L103.609 115H19C18.4477 115 18 114.552 18 114C18 113.448 18.4477 113 19 113H105.661L121.061 97.9844C120.386 96.8113 120 95.4507 120 94C120 89.5817 123.582 86 128 86C130.569 86 132.854 87.2105 134.318 89.0922L155.83 79H19C18.4477 79 18 78.5523 18 78C18 77.4477 18.4477 77 19 77H160.094L160.235 76.9335C160.082 76.3144 160 75.6667 160 75C160 70.5817 163.582 67 168 67C171.169 67 173.908 68.843 175.203 71.5157L200 64.9241C200.041 60.5408 203.607 57 208 57C209.622 57 211.132 57.4829 212.393 58.3128L233.347 43H19C18.4477 43 18 42.5523 18 42ZM5 39C3.89543 39 3 39.8954 3 41V43C3 44.1046 3.89543 45 5 45H11C12.1046 45 13 44.1046 13 43V41C13 39.8954 12.1046 39 11 39H5ZM3 77C3 75.8954 3.89543 75 5 75H11C12.1046 75 13 75.8954 13 77V79C13 80.1046 12.1046 81 11 81H5C3.89543 81 3 80.1046 3 79V77ZM5 111C3.89543 111 3 111.895 3 113V115C3 116.105 3.89543 117 5 117H11C12.1046 117 13 116.105 13 115V113C13 111.895 12.1046 111 11 111H5ZM3 149C3 147.895 3.89543 147 5 147H11C12.1046 147 13 147.895 13 149V151C13 152.105 12.1046 153 11 153H5C3.89543 153 3 152.105 3 151V149Z")}else if(H.indexOf("bar")>-1){e.attr("d","M0 0H268V186H0V0ZM7 2C5.89543 2 5 2.89544 5 4.00001V180C5 181.105 5.89543 182 7 182C7.17265 182 7.34019 181.978 7.5 181.937C7.65981 181.978 7.82735 182 8 182H261C262.105 182 263 181.105 263 180C263 178.895 262.105 178 261 178H9V4C9 2.89543 8.10457 2 7 2ZM25 10C23.8954 10 23 10.8954 23 12V33C23 34.1046 23.8954 35 25 35H249C250.105 35 251 34.1046 251 33V12C251 10.8954 250.105 10 249 10H25ZM23 44C23 42.8954 23.8954 42 25 42H188C189.105 42 190 42.8954 190 44V65C190 66.1046 189.105 67 188 67H25C23.8954 67 23 66.1046 23 65V44ZM25 74C23.8954 74 23 74.8954 23 76V97C23 98.1046 23.8954 99 25 99H212C213.105 99 214 98.1046 214 97V76C214 74.8954 213.105 74 212 74H25ZM23 108C23 106.895 23.8954 106 25 106H191C192.105 106 193 106.895 193 108V129C193 130.105 192.105 131 191 131H25C23.8954 131 23 130.105 23 129V108ZM25 138C23.8954 138 23 138.895 23 140V161C23 162.105 23.8954 163 25 163H171C172.105 163 173 162.105 173 161V140C173 138.895 172.105 138 171 138H25Z")}else if(H.indexOf("pie")>-1||H.indexOf("donut")>-1){e.attr("d","M263 0H0V165H263V0ZM178 5C176.895 5 176 5.89543 176 7V21C176 22.1046 176.895 23 178 23H258C259.105 23 260 22.1046 260 21V7C260 5.89543 259.105 5 258 5H178ZM176 30C176 28.8954 176.895 28 178 28H240C241.105 28 242 28.8954 242 30V44C242 45.1046 241.105 46 240 46H178C176.895 46 176 45.1046 176 44V30ZM178 51C176.895 51 176 51.8954 176 53V67C176 68.1046 176.895 69 178 69H258C259.105 69 260 68.1046 260 67V53C260 51.8954 259.105 51 258 51H178ZM176 76C176 74.8954 176.895 74 178 74H240C241.105 74 242 74.8954 242 76V90C242 91.1046 241.105 92 240 92H178C176.895 92 176 91.1046 176 90V76ZM178 97C176.895 97 176 97.8954 176 99V113C176 114.105 176.895 115 178 115H258C259.105 115 260 114.105 260 113V99C260 97.8954 259.105 97 258 97H178ZM176 122C176 120.895 176.895 120 178 120H240C241.105 120 242 120.895 242 122V136C242 137.105 241.105 138 240 138H178C176.895 138 176 137.105 176 136V122ZM84 161.961V121.92C104.098 120.632 120 103.923 120 83.5C120 69.1297 112.127 56.5982 100.459 49.9838L120.206 15.1903C143.97 28.6843 160 54.2201 160 83.5C160 126.018 126.197 160.641 84 161.961ZM81 121.997V161.998C37.8758 161.729 3 126.688 3 83.5C3 59.3758 13.8821 37.7933 31.0052 23.3933L56.6947 54.0549C48.32 61.1173 43 71.6874 43 83.5C43 104.596 59.9675 121.729 81 121.997ZM117.569 13.7589L97.7909 48.6064C92.8434 46.2926 87.3226 45 81.5 45C73.128 45 65.3802 47.6722 59.0629 52.2102L33.3379 21.5062C46.6349 11.1611 63.3479 5 81.5 5C94.5039 5 106.769 8.16194 117.569 13.7589Z")}else{e.attr("d","M266 0H0V188H266V0ZM4 5.00001C4 3.89544 4.89543 3 6 3C7.10457 3 8 3.89543 8 5V179H260C261.105 179 262 179.895 262 181C262 182.105 261.105 183 260 183H6C4.89543 183 4 182.105 4 181V5.00001ZM46 33C47.1046 33 48 33.8954 48 35V161C48 162.105 47.1046 163 46 163H26C24.8954 163 24 162.105 24 161V35C24 33.8954 24.8954 33 26 33H46ZM88 25C88 23.8954 87.1046 23 86 23H66C64.8954 23 64 23.8954 64 25V161C64 162.105 64.8954 163 66 163H86C87.1046 163 88 162.105 88 161V25ZM126 46C127.105 46 128 46.8954 128 48V161C128 162.105 127.105 163 126 163H106C104.895 163 104 162.105 104 161V48C104 46.8954 104.895 46 106 46H126ZM168 61C168 59.8954 167.105 59 166 59H146C144.895 59 144 59.8954 144 61V161C144 162.105 144.895 163 146 163H166C167.105 163 168 162.105 168 161V61ZM206 72C207.105 72 208 72.8954 208 74V161C208 162.105 207.105 163 206 163H186C184.895 163 184 162.105 184 161V74C184 72.8954 184.895 72 186 72H206ZM248 61C248 59.8954 247.105 59 246 59H226C224.895 59 224 59.8954 224 61V161C224 162.105 224.895 163 226 163H246C247.105 163 248 162.105 248 161V61Z")}e.attr("fill-rule","evenodd").attr("clip-rule","evenodd").openEnd().close("path");e.close("svg")};H.renderContent=function(C,e){e.openStart("div").openEnd();this.renderSVG(C,e);e.close("div")};H.addOuterAttributes=function(C,t){e.addOuterAttributes.apply(this,arguments);t.class(H.CSS_CLASS_PLACEHOLDER);t.style("min-height",C.getMinHeight())};return H},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/CalendarPlaceholder", ["sap/f/cards/loading/ListPlaceholder","./CalendarPlaceholderRenderer"],function(e,a){"use strict";var r=e.extend("sap.f.cards.loading.CalendarPlaceholder",{metadata:{library:"sap.f",properties:{maxLegendItems:{type:"int",group:"Misc"},item:{type:"any"},legendItem:{type:"any"}}},renderer:a});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/CalendarPlaceholderRenderer", ["sap/ui/core/Renderer","./PlaceholderBaseRenderer"],function(e,a){"use strict";var t=e.extend(a);t.apiVersion=2;t.CSS_CLASS_PLACEHOLDER="sapFCardContentCalendarPlaceholder";t.renderTextRow=function(e){e.openStart("div").class("sapFCardListPlaceholderRow").class("sapFCardListPlaceholderTextRow").class("sapFCardLoadingShimmer");e.openEnd().close("div")};t.renderRow=function(e,a){e.openStart("div").class("sapFCardListPlaceholderRow").class("sapFCardLoadingShimmer");if(a){e.class("sapFCardListPlaceholderRowCombined")}e.openEnd().close("div")};t.renderContent=function(e,a){var t=e.getMinItems(),s=e.getMaxLegendItems(),d=e.getItem(),r=e.getLegendItem(),o;a.openStart("div").class("sapFCalCardPlaceholderLeftSide").attr("tabindex","0");a.openEnd();a.openStart("div").class("sapFCardContentCalendarPartPlaceholder").class("sapFCardLoadingShimmer").attr("tabindex","0");a.openEnd();a.close("div");a.openStart("div").class("sapFCardContentListPlaceholder").class("sapFCardContentLegendItemsListPlaceholder").attr("tabindex","0");a.openEnd();for(o=0;o<s;o++){a.openStart("div").class("sapFCardListPlaceholderLegendItem").class("sapFCardListPlaceholderItem").style("height",e.getItemHeight()).openEnd();if(r){a.openStart("div").class("sapFCardListPlaceholderImg").class("sapFCardLoadingShimmer").openEnd().close("div");a.openStart("div").class("sapFCardListPlaceholderRows").openEnd();this.renderRow(a);a.close("div")}a.close("div")}a.close("div");a.close("div");a.openStart("div").class("sapFCardContentListPlaceholder").class("sapFCardContentItemsListPlaceholder").class("sapFCalCardPlaceholderRightSide").attr("tabindex","0");a.openEnd();for(o=0;o<t;o++){a.openStart("div").class("sapFCardListPlaceholderItem").style("height",e.getItemHeight()).openEnd();a.openStart("div").class("sapFCardListPlaceholderFromTo").class("sapFCardLoadingShimmer").openEnd().close("div");a.openStart("div").class("sapFCardListPlaceholderRows").openEnd();if(d){if(d.title){this.renderRow(a)}if(d.text){this.renderTextRow(a)}}a.close("div");a.close("div")}a.close("div")};t.addOuterAttributes=function(e,s){a.addOuterAttributes.apply(this,arguments);s.class(t.CSS_CLASS_PLACEHOLDER)};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/GenericPlaceholder", ["sap/f/cards/loading/PlaceholderBase","./GenericPlaceholderRenderer"],function(e,r){"use strict";var a=e.extend("sap.f.cards.loading.GenericPlaceholder",{metadata:{library:"sap.f"},renderer:r});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/GenericPlaceholderRenderer", ["sap/ui/core/Renderer","./PlaceholderBaseRenderer"],function(t,e){"use strict";var r=t.extend(e);r.apiVersion=2;r.CSS_CLASS_PLACEHOLDER="sapFCardContentGenericPlaceholder";r.renderSVG=function(t){t.openStart("svg").attr("height","100%").attr("xmlns","http://www.w3.org/2000/svg").attr("version","1.1").attr("viewBox","0 0 144 144").class("sapFCardSVG").openEnd();t.openStart("g").openEnd();t.openStart("path").attr("d","M0,0v144h144V0H0z M36.4,114h-8.8V87.8h8.8V114z M50.3,114h-9.2V80.8h9.2V114z M64.1,114h-9.2V99.9h9.2V114z M66.9,64.9 c0,1.6-0.8,2.4-2.2,2.4H26.8c-1.6,0-2.4-0.8-2.4-2.4V26.4c0-1.6,0.8-2.4,2.4-2.4h37.9c1.5,0,2.2,0.8,2.2,2.4V64.9z M119.6,117.6 c0,1.6-0.8,2.4-2.2,2.4H79.1c-1.6,0-2.4-0.8-2.4-2.4V79.1c0-1.6,0.8-2.4,2.4-2.4h38.2c1.5,0,2.2,0.8,2.2,2.4V117.6z M119.6,64.7 c0,0.6-0.2,1.2-0.7,1.8c-0.4,0.6-1,0.8-1.6,0.8H79.1c-0.6,0-1.2-0.3-1.7-0.8c-0.5-0.6-0.8-1.2-0.8-1.8V26.4c0-0.6,0.3-1.2,0.8-1.7 c0.6-0.5,1.2-0.8,1.8-0.8h38.1c1.5,0,2.2,0.8,2.2,2.4V64.7z").openEnd().close("path");t.openStart("path").attr("d","M92.3,104.8l-6.6-5.1l-4.5,6l9.6,7.3c0.2,0.4,0.9,0.7,2.1,0.9c1.4,0,2.5-0.6,3.4-1.7L114,87l-6.2-4.3L92.3,104.8z").openEnd().close("path");t.openStart("rect").attr("x","32.8").attr("y","43.1").attr("width","25.9").attr("height","5.2").openEnd().close("rect");t.openStart("rect").attr("x","32.8").attr("y","52.5").attr("width","25.9").attr("height","5.2").openEnd().close("rect");t.openStart("path").attr("d","M115.9,27.2H81c-0.8,0-1.1,0.4-1.1,1.1v34.9c0,0.6,0.4,0.9,1.1,0.9h34.9c0.6,0,0.9-0.3,0.9-0.9V28.3 C116.8,27.6,116.5,27.2,115.9,27.2z M93.8,35.3c1.2-0.9,2.7-1.4,4.4-1.4c1.9,0,3.4,0.5,4.5,1.6c1.1,1.1,1.7,2.7,1.7,4.8 c0,1.9-0.7,3.3-2,4.2s-2.7,1.4-4.2,1.4c-1.8,0-3.2-0.5-4.4-1.5c-1.2-1-1.8-2.6-1.8-4.7C92.1,37.8,92.7,36.3,93.8,35.3z M108.8,59.6 H87.4v-5.8c0-1.6,0.3-2.9,1-3.8c0.7-0.9,1.6-1.7,2.6-2.2c1.1-0.5,2.2-0.8,3.4-0.9c1.2-0.1,2.3-0.2,3.3-0.2h1.1 c2.6,0,4.9,0.4,6.9,1.3c2,0.9,3,2.8,3,5.8V59.6z").openEnd().close("path");t.openStart("rect").attr("x","32.8").attr("y","33.8").attr("width","25.9").attr("height","5.1").openEnd().close("rect");t.close("g");t.close("svg")};r.renderContent=function(t,e){e.openStart("div").class("sapFCardLoadingShimmer").openEnd();this.renderSVG(e);e.close("div")};r.addOuterAttributes=function(t,c){e.addOuterAttributes.apply(this,arguments);c.class(r.CSS_CLASS_PLACEHOLDER)};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/ListPlaceholder", ["sap/f/cards/loading/PlaceholderBase","./ListPlaceholderRenderer"],function(e,t){"use strict";var a=e.extend("sap.f.cards.loading.ListPlaceholder",{metadata:{library:"sap.f",properties:{minItems:{type:"int",group:"Misc"},hasIcon:{type:"boolean"},hasDescription:{type:"boolean"},attributesLength:{type:"int",defaultValue:0},hasChart:{type:"boolean"},hasActionsStrip:{type:"boolean"},itemHeight:{type:"sap.ui.core.CSSSize"}}},renderer:t});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/ListPlaceholderRenderer", ["sap/ui/core/Renderer","./PlaceholderBaseRenderer"],function(e,t){"use strict";var r=e.extend(t);r.apiVersion=2;r.CSS_CLASS_PLACEHOLDER="sapFCardContentListPlaceholder";r.renderTitleAndDescription=function(e,t){if(t.getAttributesLength()>0&&t.getHasDescription()){this.renderRow(e,true);return}this.renderRow(e);if(t.getHasDescription()){this.renderRow(e)}};r.renderRow=function(e,t){e.openStart("div").class("sapFCardListPlaceholderRow").class("sapFCardLoadingShimmer");if(t){e.class("sapFCardListPlaceholderRowCombined")}e.openEnd().close("div")};r.renderAttributes=function(e,t){if(t<1){return}var r=Math.floor(t/2+1);for(var s=0;s<r;s++){e.openStart("div").class("sapFCardListPlaceholderRow").openEnd();var i=s===r-1?1:2;for(var a=0;a<i;a++){e.openStart("div").class("sapFCardListPlaceholderAttr").class("sapFCardLoadingShimmer").openEnd().close("div")}e.close("div")}};r.renderContent=function(e,t){var r=e.getMinItems();for(var s=0;s<r;s++){t.openStart("div").class("sapFCardListPlaceholderItem").style("height",e.getItemHeight()).openEnd();if(e.getHasIcon()){t.openStart("div").class("sapFCardListPlaceholderImg").class("sapFCardLoadingShimmer").openEnd().close("div")}t.openStart("div").class("sapFCardListPlaceholderRows").openEnd();this.renderTitleAndDescription(t,e);this.renderAttributes(t,e.getAttributesLength());if(e.getHasChart()){this.renderRow(t)}if(e.getHasActionsStrip()){this.renderRow(t)}t.close("div");t.close("div")}};r.addOuterAttributes=function(e,s){t.addOuterAttributes.apply(this,arguments);s.class(r.CSS_CLASS_PLACEHOLDER)};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/ObjectPlaceholder", ["sap/f/cards/loading/PlaceholderBase","./ObjectPlaceholderRenderer","sap/ui/core/ResizeHandler","sap/ui/dom/units/Rem"],function(e,i,t,s){"use strict";var r=400;var n=s.toPx(3.25);var o=e.extend("sap.f.cards.loading.ObjectPlaceholder",{metadata:{library:"sap.f",properties:{groups:{type:"object"},configuration:{type:"object"}},aggregations:{_rootLayout:{multiple:false,visibility:"hidden"}}},renderer:i});o.prototype.init=function(){this._iColsCnt=1;this._iRowsCnt=0};o.prototype.exit=function(){this._deregisterResizeHandler()};o.prototype.onBeforeRendering=function(){this._deregisterResizeHandler()};o.prototype.onAfterRendering=function(){this._sResizeListenerId=t.register(this.getDomRef(),this._handleResize.bind(this));this._handleResize()};o.prototype._handleResize=function(){var e=this.$().height();var i=Math.floor(e/n);var t=this.$().width()>r?2:1;if(this._iRowsCnt!==i||this._iColsCnt!==t){this._iRowsCnt=i;this._iColsCnt=t;this.invalidate()}};o.prototype._deregisterResizeHandler=function(){if(this._sResizeListenerId){t.deregister(this._sResizeListenerId);this._sResizeListenerId=""}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/ObjectPlaceholderRenderer", ["sap/ui/core/Renderer","./PlaceholderBaseRenderer"],function(e,r){"use strict";var n=e.extend(r);n.apiVersion=2;n.CSS_CLASS_PLACEHOLDER="sapFCardContentObjectPlaceholder";n.renderColumn=function(e,r){e.openStart("div").class("sapFCardObjectPlaceholderColumn").openEnd();for(var n=0;n<r;n++){this.renderRow(e,"First",false);this.renderRow(e,"Second",n===r)}e.close("div")};n.renderRow=function(e,r,n){e.openStart("div").class("sapFCardLoadingShimmer").class("sapFCardObjectPlaceholderGroup"+r+"Row");if(n){e.class("sapFCardObjectPlaceholderGroupLastRow")}e.openEnd().close("div")};n.renderContent=function(e,r){for(var n=0;n<e._iColsCnt;n++){this.renderColumn(r,e._iRowsCnt)}};n.addOuterAttributes=function(e,t){r.addOuterAttributes.apply(this,arguments);t.class(n.CSS_CLASS_PLACEHOLDER)};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/PlaceholderBase", ["sap/ui/core/Control","sap/ui/core/Core","sap/f/cards/loading/PlaceholderBaseRenderer"],function(e,a,r){"use strict";var o=e.extend("sap.f.cards.loading.PlaceholderBase",{metadata:{library:"sap.f",properties:{renderTooltip:{type:"boolean",defaultValue:true},hasContent:{type:"boolean",defaultValue:true}}},renderer:r});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/PlaceholderBaseRenderer", ["sap/ui/core/Core"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,r){var n=e.getLibraryResourceBundle("sap.ui.core"),i=n.getText("BUSY_TEXT");if(!r.getHasContent()){return}t.openStart("div",r).class("sapFCardContentPlaceholder").attr("tabindex","0");this.addOuterAttributes(r,t);if(r.getRenderTooltip()){t.attr("title",i)}t.accessibilityState(r,{role:"progressbar",valuemin:"0",valuemax:"100"});t.openEnd();this.renderContent(r,t);t.close("div")};t.addOuterAttributes=function(e,t){};t.renderContent=function(e,t){};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/TablePlaceholder", ["sap/f/cards/loading/PlaceholderBase","./TablePlaceholderRenderer"],function(e,r){"use strict";var a=e.extend("sap.f.cards.loading.TablePlaceholder",{metadata:{library:"sap.f",properties:{minItems:{type:"int",group:"Misc"},itemHeight:{type:"sap.ui.core.CSSSize"},columns:{type:"int",group:"Misc"}}},renderer:r});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/TablePlaceholderRenderer", ["sap/ui/core/Renderer","./PlaceholderBaseRenderer"],function(e,a){"use strict";var r=e.extend(a);r.apiVersion=2;r.CSS_CLASS_PLACEHOLDER="sapFCardContentTablePlaceholder";r.renderContent=function(e,a){var r=e.getMinItems(),t=e.getColumns();for(var s=0;s<r+1;s++){a.openStart("div").class("sapFCardTablePlaceholderItem").style("height",e.getItemHeight()).openEnd();a.openStart("div").class("sapFCardTablePlaceholderRows").openEnd();if(t>1){for(var n=0;n<t;n++){a.openStart("div").class("sapFCardTablePlaceholderColumns").class("sapFCardLoadingShimmer").openEnd();a.close("div")}}a.close("div");a.close("div")}};r.addOuterAttributes=function(e,t){a.addOuterAttributes.apply(this,arguments);t.class(r.CSS_CLASS_PLACEHOLDER)};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/TimelinePlaceholder", ["sap/f/cards/loading/PlaceholderBase","./TimelinePlaceholderRenderer"],function(e,i){"use strict";var r=e.extend("sap.f.cards.loading.TimelinePlaceholder",{metadata:{library:"sap.f",properties:{minItems:{type:"int",group:"Misc"},item:{type:"any"},itemHeight:{type:"sap.ui.core.CSSSize"}}},renderer:i});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/cards/loading/TimelinePlaceholderRenderer", ["sap/ui/core/Renderer","./PlaceholderBaseRenderer"],function(e,a){"use strict";var i=e.extend(a);i.apiVersion=2;i.CSS_CLASS_PLACEHOLDER="sapFCardContentTimelinePlaceholder";i.renderRow=function(e,a){e.openStart("div").class("sapFCardTimelinePlaceholderRow").class("sapFCardTimelinePlaceholderRow"+a).class("sapFCardLoadingShimmer").openEnd().close("div")};i.renderContent=function(e,a){var i=e.getMinItems(),r=e.getItem();for(var n=0;n<i;n++){a.openStart("div").class("sapFCardTimelinePlaceholderItem").style("height",e.getItemHeight()).openEnd();if(r){a.openStart("div").class("sapFCardTimelineNavGroup").openEnd();a.openStart("div").class("sapFCardTimelinePlaceholderImg").class("sapFCardLoadingShimmer").openEnd().close("div");if(n!==i-1){a.openStart("div").class("sapFCardTimelinePlaceholderLine").class("sapFCardLoadingShimmer").openEnd().close("div")}a.close("div")}a.openStart("div").class("sapFCardTimelinePlaceholderRows").openEnd();if(r){this.renderRow(a,100);this.renderRow(a,40);this.renderRow(a,60)}a.close("div");a.close("div")}};i.addOuterAttributes=function(e,r){a.addOuterAttributes.apply(this,arguments);r.class(i.CSS_CLASS_PLACEHOLDER)};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/changeHandler/MoveDynamicPageTitleActions", ["sap/ui/fl/changeHandler/condenser/Classification"],function(e){"use strict";var t={};var n="actions";t.applyChange=function(e,t,r){var o=r.modifier;var a=r.view;var g=r.appComponent;var i=e.getContent().movedElements[0];var s=i.targetIndex;var v;var d=i.sourceIndex;return Promise.resolve().then(o.bySelector.bind(o,i.selector,g,a)).then(function(e){v=e;return o.getAggregation(t,n)}).then(function(r){var i;r.some(function(e,r){if(o.getId(e)===o.getId(v)){i=Promise.resolve().then(o.removeAggregation.bind(o,t,n,e)).then(o.insertAggregation.bind(o,t,"dependents",e,undefined,a));return true}return false});return i.then(function(){e.setRevertData({index:d,sourceParent:o.getSelector(t,g),aggregation:n});return o.insertAggregation(t,n,v,s,a)})})};t.revertChange=function(e,t,r){var o=r.modifier;var a=r.view;var g=r.appComponent;var i=e.getContent().movedElements[0];var s=e.getRevertData();var v;var d;var c;v=o.bySelector(i.selector,g,a);d=s?s.index:i.targetIndex;c=i.sourceIndex;return Promise.resolve().then(o.removeAggregation.bind(o,t,n,v,d,a)).then(o.insertAggregation.bind(o,t,n,v,c,a))};t.completeChangeContent=function(e,t,n){var r=n.modifier,o=n.appComponent;var a={movedElements:[],targetAggregation:t.target.aggregation,targetContainer:t.selector};t.movedElements.forEach(function(e){var t=e.element||r.bySelector(e.id,o);a.movedElements.push({selector:r.getSelector(t,o),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex})});e.setContent(a)};t.getCondenserInfo=function(t){var n=t.getContent();var r=t.getRevertData();return{affectedControl:n.movedElements[0].selector,classification:e.Move,sourceContainer:r.sourceParent,targetContainer:n.targetContainer,sourceIndex:r.index,sourceAggregation:r.aggregation,targetAggregation:n.targetAggregation,setTargetIndex:function(e,t){e.getContent().movedElements[0].targetIndex=t},getTargetIndex:function(e){return e.getContent().movedElements[0].targetIndex},setIndexInRevertData:function(e,t){var n=e.getRevertData();n.index=t;e.setRevertData(n)}}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/delegate/GridContainerItemNavigation", ["sap/ui/core/Element","sap/ui/core/delegate/ItemNavigation","./GridItemNavigation","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(t,e,o,s,jQuery){"use strict";function i(t){if(t.onfocusin){t.onfocusin()}}var n=o.extend("sap.f.delegate.GridContainerItemNavigation",{constructor:function(){o.apply(this,arguments);this.attachEvent(e.Events.FocusLeave,this._onFocusLeave,this)}});n.prototype._onFocusLeave=function(t){var e=this.getFocusedDomRef();this.getItemDomRefs().forEach(function(t,o){if(e===t){var s=o++;this.setFocusedIndex(s)}}.bind(this))};n.prototype.forwardTab=function(t){var e=this._getRootDomRefId()+"-"+(t?"after":"before");document.getElementById(e).focus()};n.prototype._getRootDomRefId=function(t){return this.getRootDomRef().getAttribute("id")};n.prototype.onsaptabnext=function(e){var o=this.getItemDomRefs(),s=this.getFocusedIndex(),i=jQuery(o[s]),n=[];var r=i.find(":sapTabbable");r.map(function(t,e){if(e.className.indexOf("DummyArea")===-1&&e.className.indexOf("sapMListUl")===-1){n.push(e)}});var a=n.length-1;if(a===-1||t.closestTo(n[a])&&t.closestTo(n[a]).getId()===e.target.id){this._lastFocusedElement=e.target;this.forwardTab(true)}};n.prototype.onsaptabprevious=function(t){if(!t.target.classList.contains("sapFGridContainerItemWrapper")){this._lastFocusedElement=t.target;return}var e=t.target.id;if(e===this._getRootDomRefId()+"-nodata"){this.forwardTab(false)}this._lastFocusedElement=null;this.forwardTab(false)};n.prototype.onmousedown=function(t){this._bIsMouseDown=true;e.prototype.onmousedown.call(this,t)};n.prototype.onmouseup=function(e){var o=jQuery(e.target).closest(".sapFGridContainerItemWrapperNoVisualFocus"),s;if(o.length){s=t.closestTo(o.children()[0]);if(s&&s.getFocusDomRef()===document.activeElement){this._lastFocusedElement=null;o.trigger("focus");i(s)}}this._bIsMouseDown=false};n.prototype.ondragend=function(){this._bIsMouseDown=false};n.prototype.ondrop=function(){this._bIsMouseDown=false};n.prototype.onfocusin=function(e){o.prototype.onfocusin.call(this,e);if(e.target===this._getGridInstance().getDomRef("before")&&!this.getRootDomRef().contains(e.relatedTarget)){var s=this._lastFocusedElement||this.getItemDomRefs()[this.getFocusedIndex()];if(s){s.focus()}return}if(e.target===this._getGridInstance().getDomRef("after")&&!this.getRootDomRef().contains(e.relatedTarget)){this._focusPrevious(e);return}var n=jQuery(e.target).closest(".sapFGridContainerItemWrapperNoVisualFocus"),r;if(n.length){r=t.closestTo(n.children()[0]);if(r){i(r);if(!this._bIsMouseDown&&r.getFocusDomRef()===e.target){this._lastFocusedElement=null;n.trigger("focus");return}}}};n.prototype._focusPrevious=function(t){var e=this.getItemDomRefs();var o=this.getFocusedIndex();if(!e.length){return}var s;if(o<0){s=e[0];this.setFocusedIndex(0)}else{s=e[o]}var i=jQuery(s);var n=i.find(":sapTabbable");i.add(n).eq(-1).focus()};n.prototype.focusItem=function(o,s){var i,n,r;if(o===this.iFocusedIndex&&this.aItemDomRefs[this.iFocusedIndex]===document.activeElement){this.fireEvent(e.Events.FocusAgain,{index:o,event:s});return}this.fireEvent(e.Events.BeforeFocus,{index:o,event:s});this.setFocusedIndex(o);this.bISetFocus=true;if(s&&jQuery(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot")){i=jQuery(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot");i._sFocusEvent=s.type}if(!s){this.resetFocusPosition()}if(!this._bIsMouseDown&&this.aItemDomRefs.length){this.aItemDomRefs[this.iFocusedIndex].focus();n=t.closestTo(this.aItemDomRefs[this.iFocusedIndex].firstChild);if(n){r=n.getFocusDomRef();if(r){this.scrollIntoViewIfNeeded(r)}}}this.fireEvent(e.Events.AfterFocus,{index:o,event:s})};n.prototype.scrollIntoViewIfNeeded=function(t){var e=t.parentElement,o,s;while(e&&e.offsetWidth>=e.scrollWidth&&e.offsetHeight>=e.scrollHeight){e=e.parentElement}if(!e){return}e=e.parentElement;if(!e){return}o=e.getBoundingClientRect();s=t.getBoundingClientRect();if(s.top<o.top||s.bottom>o.bottom||s.right>o.right||s.left<o.left){t.scrollIntoView()}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/delegate/GridItemNavigation", ["sap/ui/core/Element","sap/ui/core/delegate/ItemNavigation","sap/ui/events/KeyCodes","sap/base/Log","sap/f/library","sap/f/GridNavigationMatrix"],function(o,t,e,i,n,s){"use strict";const r=n.NavigationDirection;const c=10;var u=t.extend("sap.f.delegate.GridItemNavigation");u.prototype.onfocusin=function(o){t.prototype.onfocusin.call(this,o);if(o.target===this.oDomRef){this.resetFocusPosition()}};u.prototype.onsapfocusleave=function(o){t.prototype.onsapfocusleave.call(this,o);if(o.target===this.oDomRef){this.resetFocusPosition()}};u.prototype.onsapnext=function(o){this._moveFocus(o)};u.prototype.onsapprevious=function(o){this._moveFocus(o)};u.prototype.onsappageup=function(o){this._moveFocus(o)};u.prototype.onsappagedown=function(o){this._moveFocus(o)};u.prototype.resetFocusPosition=function(){this._mCurrentPosition=null};u.prototype.setFocusPosition=function(o){this._mCurrentPosition=o;i.info("Grid matrix position: ("+this._mCurrentPosition.row+", "+this._mCurrentPosition.column+")")};u.prototype.ontap=function(){this.resetFocusPosition()};u.prototype._moveFocus=function(o){const t=o.target;if(this.getItemDomRefs().indexOf(t)===-1){return}o.preventDefault();const i=this._getGridInstance().getNavigationMatrix();if(!i){return}const n=this._findPositionInMatrix(i,t);if(!this._mCurrentPosition){this.setFocusPosition({...n})}switch(o.keyCode){case e.ARROW_DOWN:this._moveFocusDown(n,i,t,o);break;case e.ARROW_RIGHT:this._moveFocusRight(n,i,t,o);break;case e.ARROW_UP:this._moveFocusUp(n,i,t,o);break;case e.ARROW_LEFT:this._moveFocusLeft(n,i,t,o);break;case e.PAGE_DOWN:this._moveFocusDown(n,i,t,o,c);break;case e.PAGE_UP:this._moveFocusUp(n,i,t,o,c);break;default:break}};u.prototype._moveFocusDown=function(o,t,e,i,n=1){const r={row:o.row,column:this._mCurrentPosition.column};const c={...r};let u=t[c.row][c.column];while(r.row<t.length-1&&(u===e||r.row-o.row<n)){r.row+=1;if(t[r.row][r.column]!==s.EMPTY_CELL){u=t[r.row][r.column];c.row=r.row}}if(u===e){this._onBorderReached(i);return}this.setFocusPosition(c);this.focusItem(this.getItemDomRefs().indexOf(u),i)};u.prototype._moveFocusRight=function(o,t,e,i){o.row=this._mCurrentPosition.row;let n=t[o.row][o.column];while(o.column<t[o.row].length-1&&n===e){o.column+=1;if(t[o.row][o.column]!==s.EMPTY_CELL){n=t[o.row][o.column]}}if(n===e){this._onBorderReached(i);return}this.setFocusPosition(o);this.focusItem(this.getItemDomRefs().indexOf(n),i)};u.prototype._moveFocusUp=function(o,t,e,i,n=1){const r={row:o.row,column:this._mCurrentPosition.column};const c={...r};let u=t[c.row][c.column];while(r.row>0&&(u===e||o.row-r.row<n)){r.row-=1;if(t[r.row][r.column]!==s.EMPTY_CELL){u=t[r.row][r.column];c.row=r.row}}if(u===e){this._onBorderReached(i);return}while(c.row>0&&t[c.row-1][c.column]===u){c.row-=1}this.setFocusPosition(c);this.focusItem(this.getItemDomRefs().indexOf(u),i)};u.prototype._moveFocusLeft=function(o,t,e,i){o.row=this._mCurrentPosition.row;let n=t[o.row][o.column];while(o.column>0&&n===e){o.column-=1;if(t[o.row][o.column]!==s.EMPTY_CELL){n=t[o.row][o.column]}}if(n===e){this._onBorderReached(i);return}while(o.column>0&&t[o.row][o.column-1]===n){o.column-=1}this.setFocusPosition(o);this.focusItem(this.getItemDomRefs().indexOf(n),i)};u.prototype._findPositionInMatrix=function(o,t){let e=null;o.some(function(o,i){const n=o.indexOf(t);if(n!==-1){e={};e.row=i;e.column=n;return true}return false});return e};u.prototype._onBorderReached=function(o){let t;switch(o.keyCode){case e.ARROW_RIGHT:t=r.Right;break;case e.ARROW_LEFT:t=r.Left;break;case e.ARROW_DOWN:case e.PAGE_DOWN:t=r.Down;break;case e.ARROW_UP:case e.PAGE_UP:t=r.Up;break}this._getGridInstance().onItemNavigationBorderReached({event:o,row:this._mCurrentPosition.row,column:this._mCurrentPosition.column,direction:t})};u.prototype.focusItemByDirection=function(o,t,e,i){const n=o.getNavigationMatrix();let s,c,u,a;switch(t){case r.Right:u=e;a=-1;c=n[e];if(c){do{s=c[++a]}while(!s)}break;case r.Left:u=e;a=n[0].length;c=n[e];if(c){do{s=c[--a]}while(!s)}if(s){while(a>0&&n[e][a-1]===s){a--}}break;case r.Down:u=-1;a=i;while(!s&&n[++u]&&n[u][i]!==undefined){s=n[u][i]}break;case r.Up:u=n.length;a=i;while(!s&&n[--u]&&n[u][i]!==undefined){s=n[u][i]}if(s){while(u>0&&n[u-1][i]===s){u--}}break;default:break}if(!s){return}this.setFocusPosition({column:a,row:u});s.focus()};u.prototype._getGridInstance=function(){return o.closestTo(this.oDomRef)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/dnd/GridDragOver", ["sap/ui/base/Object","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/core/Configuration","sap/ui/core/Element"],function(t,jQuery,i,e,o){"use strict";var r=t.extend("sap.f.dnd.GridDragOver",{_iTimeoutBeforeDrop:200,_$indicator:jQuery("<div class='sapUiDnDGridIndicator'></div>"),constructor:function(){this._oDragControlDelegate={ondragend:this.scheduleEndDrag};this._oDropContainerDelegate={ondragleave:this._onDragLeave,onBeforeRendering:this._onDropContainerBeforeRendering,onAfterRendering:this._onDropContainerAfterRendering}},destroy:function(){this._oDragEndDelegate=null}});r.prototype.setCurrentContext=function(t,i,e,o){if(this._oDragControl===t&&this._oDropContainer===i&&this._sTargetAggregation===e){return this}if(this._oDragControl&&this._oDragControl!==t){this.endDrag()}this._oDragControl=t;this._oDragContainer=t.getParent();this._oDropContainer=i;this._sTargetAggregation=e;this._oCoreDragSession=o;this._mDragItemDimensions=this._getDimensions(t);this._bIsInSameContainer=this._oDragContainer===this._oDropContainer;if(this._bIsInSameContainer){this._iDragFromIndex=i.indexOfAggregation(e,t)}else{this._iDragFromIndex=null}i.getAggregation(e).forEach(function(t){t.addStyleClass("sapUiDnDGridControl")});this._attachEventDelegates();this._hideCoreDefaultIndicator();return this};r.prototype.handleDragOver=function(t){if(this._shouldFreeze(t.pageX,t.pageY)){return}this._hideCoreDefaultIndicator();var i=this._calculateDropPosition(t);if(!i){return}if(this._timeoutOnSamePosition(i)){if(i.targetControl===this._oDragControl){return}this._hideDraggedItem();this._showIndicator(i,t);this._freezeCurrentPosition(t.pageX,t.pageY)}};r.prototype.getSuggestedDropPosition=function(){return this._mLastDropPosition};r.prototype.setDropIndicatorSize=function(t){if(!t){this._mDropIndicatorSize=null;return}if(!t.rows||!t.columns){i.error("Custom indicator size for grid drag and drop is not valid. It must be an object with rows and columns properties: '{rows: <int>, columns: <int>}'.");this._mDropIndicatorSize=null;return}this._mDropIndicatorSize=t};r.prototype.scheduleEndDrag=function(){if(!this._isDragActive()){return}var t=this._oDropContainer.getBindingInfo(this._sTargetAggregation);if(t&&t.template){setTimeout(this.endDrag.bind(this),0)}else{this.endDrag()}};r.prototype.endDrag=function(){if(!this._isDragActive()){return}this._hideIndicator();this._showDraggedItem();this._removeEventDelegates();this._resetCoreDefaultIndicator();this._mDropIndicatorSize=null;this._oDragControl=null;this._oDropContainer=null;this._sTargetAggregation=null;this._iDragFromIndex=null;this._iDropPositionHoldStart=null;this._mLastDropPosition=null;this._mFreezePosition=null;this._oCoreDragSession=null};r.prototype._isDragActive=function(){return this._oDragControl&&this._oDropContainer};r.prototype._showIndicator=function(t,i){var e=this._oDropContainer,o=e.getDomRefForSetting(this._sTargetAggregation)||e.getDomRef(),r=t.targetControl,n=e.indexOfAggregation(this._sTargetAggregation,r),s,a,g;if(r){s=this._findContainingGridItem(r);a=s||r.$()}if(this._mDropIndicatorSize){g={"grid-row-start":"span "+this._mDropIndicatorSize.rows,"grid-column-start":"span "+this._mDropIndicatorSize.columns}}else{g={"grid-column-start":this._mDragItemDimensions.columnsSpan,"grid-row-start":this._mDragItemDimensions.rowsSpan}}if(g){this._$indicator.css(g)}if(a&&t.position=="Before"){this._$indicator.insertBefore(a)}else if(a){this._$indicator.insertAfter(a);n+=1}else{o.appendChild(this._$indicator[0])}this._$indicator.show();this._iDragFromIndex=n};r.prototype._hideIndicator=function(){this._$indicator.detach();this._$indicator.attr("style","")};r.prototype._hideDraggedItem=function(){this._oDragControl.$().hide();var t=this._findContainingGridItem(this._oDragControl);if(t&&this._bIsInSameContainer){t.hide()}};r.prototype._showDraggedItem=function(){if(this._oDragControl.getDomRef()){this._oDragControl.$().show()}var t=this._findContainingGridItem(this._oDragControl);if(t){t.show()}};r.prototype._hideCoreDefaultIndicator=function(){var t=this._oCoreDragSession.getIndicator(),i={visibility:"hidden",position:"relative"};this._oCoreDragSession.setIndicatorConfig(i);if(t){jQuery(t).css(i)}};r.prototype._resetCoreDefaultIndicator=function(){var t=this._oCoreDragSession.getIndicator(),i={visibility:"visible",position:"absolute"};this._oCoreDragSession.setIndicatorConfig(i);if(t){jQuery(t).css(i)}};r.prototype._timeoutOnSamePosition=function(t){if(!this._mLastDropPosition||t.targetControl!==this._mLastDropPosition.targetControl||t.position!=this._mLastDropPosition.position){this._iDropPositionHoldStart=Date.now();this._mLastDropPosition=t;return false}return Date.now()-this._iDropPositionHoldStart>this._iTimeoutBeforeDrop};r.prototype._shouldFreeze=function(t,i){var e=20;return this._mFreezePosition&&Math.abs(this._mFreezePosition.pageX-t)<e&&Math.abs(this._mFreezePosition.pageY-i)<e};r.prototype._freezeCurrentPosition=function(t,i){this._mFreezePosition={pageX:t,pageY:i}};r.prototype._calculateDropPosition=function(t){var i=this._findItemFromPoint(t.pageX,t.pageY),e,r,n;if(!i){e=this._findClosestItem(t.pageX,t.pageY)}if(e){i=e.target}if(e&&e.direction==="Left"){n="After"}if(!i){i=this._getLastItem();n="After"}if(!i){return{targetControl:null,position:"After"}}if(i.hasClass("sapUiDnDGridIndicator")){return null}r=o.closestTo(i[0],true);if(!n){n=this._calculateDropBeforeOrAfter(r,t)}return{targetControl:r,position:n}};r.prototype._calculateDropBeforeOrAfter=function(t,i){var e=this._getDimensions(t),o=e.rect;if(this._oDragControl===t){return"Before"}if(this._mDragItemDimensions.rect.width*1.5<o.width){var r=window.pageXOffset,n={left:o.left+r,width:o.width},s=i.pageX-n.left;return s<n.width*.5?"Before":"After"}if(this._iDragFromIndex===null){return"Before"}var a=this._oDropContainer.indexOfAggregation(this._sTargetAggregation,t);if(this._iDragFromIndex>a){return"Before"}return"After"};r.prototype._getDimensions=function(t){var i=this._findContainingGridItem(t);if(i){return{rect:i[0].getBoundingClientRect(),columnsSpan:i.css("grid-column-start"),rowsSpan:i.css("grid-row-start")}}return{rect:t.getDomRef().getBoundingClientRect(),columnsSpan:"span 1",rowsSpan:"span 1"}};r.prototype._findContainingGridItem=function(t){var i=t.$(),e=i.parent().css("display");if(e==="grid"||e==="inline-grid"){return i}e=i.parent().parent().css("display");if(e==="grid"||e==="inline-grid"){return i.parent()}return null};r.prototype._getLastItem=function(){var t=this._oDropContainer.getAggregation(this._sTargetAggregation),i;if(t&&t.length){i=t[t.length-1].$()}return i};r.prototype._findItemFromPoint=function(t,i){var e=document.elementFromPoint(t-window.pageXOffset,i-window.pageYOffset),o=jQuery(e).closest(".sapUiDnDGridControl, .sapUiDnDGridIndicator");if(o.hasClass("sapUiDnDGridIndicator")){return o}if(o.hasClass("sapUiDnDGridControl")){return o}return null};r.prototype._findClosestItem=function(t,i){var o=e.getRTL(),r=o?-1:1,n=80*r,s=20,a,g,h=0,d=t-n;while(!a&&d>0&&h<4){a=this._findItemFromPoint(d,i);d-=n;h++}if(a){g="Left"}if(!a&&i-s>0){a=this._findItemFromPoint(t,i-20);g="Top"}return{target:a,direction:g}};r.prototype._removeEventDelegates=function(){if(this._oDropContainer){this._oDropContainer.removeEventDelegate(this._oDropContainerDelegate)}if(this._oDragControl){this._oDragControl.removeEventDelegate(this._oDragControlDelegate)}};r.prototype._attachEventDelegates=function(){this._removeEventDelegates();this._oDragControl.addEventDelegate(this._oDragControlDelegate,this);this._oDropContainer.addEventDelegate(this._oDropContainerDelegate,this)};r.prototype._onDragLeave=function(t){var i=document.elementFromPoint(t.pageX-window.pageXOffset,t.pageY-window.pageYOffset),e=this._oDropContainer.getDomRef().contains(i);if(!e){this.scheduleEndDrag()}};r.prototype._onDropContainerBeforeRendering=function(){if(!this._isDragActive()){return}this._hideIndicator()};r.prototype._onDropContainerAfterRendering=function(){if(!this._isDragActive()){return}this._hideDraggedItem();if(this._mLastDropPosition){this._showIndicator(this._mLastDropPosition)}};var n;r.getInstance=function(){if(!n){n=new r}return n};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/dnd/GridDropInfo", ["sap/ui/core/library","sap/ui/core/dnd/DropInfo","sap/f/dnd/GridDragOver","sap/base/Log"],function(r,t,e,o){"use strict";var n=t.extend("sap.f.dnd.GridDropInfo",{metadata:{library:"sap.f",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{dropIndicatorSize:{type:"function",invalidate:false,parameters:{draggedControl:{type:"sap.ui.core.Control"}}}},events:{}}});n.prototype.isDroppable=function(r,e){if(!this._shouldEnhance()){return t.prototype.isDroppable.apply(this,arguments)}if(!this.getEnabled()){return false}if(!r||!e){return false}var o=this.getDropTarget();if(!o){return false}var n=o.getDomRefForSetting(this.getTargetAggregation());if(n&&n.contains(e.target)){e.setMark("DragWithin",this.getTargetAggregation());return true}if(!n&&o===r){return true}return false};n.prototype.fireDragEnter=function(r){if(!this._shouldEnhance()||this._isKeyboardEvent(r)){return t.prototype.fireDragEnter.apply(this,arguments)}if(!r||!r.dragSession||!r.dragSession.getDragControl()){return null}var o=e.getInstance(),n=r.dragSession.getDragControl();if(this.getDropIndicatorSize()){o.setDropIndicatorSize(this.getDropIndicatorSize()(n))}o.setCurrentContext(r.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation(),r.dragSession);var i=o.getSuggestedDropPosition();var s=this.fireEvent("dragEnter",{dragSession:r.dragSession,browserEvent:r.originalEvent,target:i?i.targetControl:null},true);if(s){o.handleDragOver(r)}return s};n.prototype.fireDragOver=function(r){if(!this._shouldEnhance()||this._isKeyboardEvent(r)){return t.prototype.fireDragOver.apply(this,arguments)}if(!r||!r.dragSession||!r.dragSession.getDragControl()){return null}var e=this._suggestDropPosition(r);if(e&&r.dragSession&&e.targetControl){r.dragSession.setDropControl(e.targetControl)}return this.fireEvent("dragOver",{dragSession:r.dragSession,browserEvent:r.originalEvent,target:e?e.targetControl:null,dropPosition:e?e.position:null})};n.prototype.fireDrop=function(r){if(!this._shouldEnhance()||this._isKeyboardEvent(r)){return t.prototype.fireDrop.apply(this,arguments)}if(!r||!r.dragSession||!r.dragSession.getDragControl()){return null}var o=r.dragSession,n=e.getInstance(),i;n.setCurrentContext(o.getDragControl(),this.getDropTarget(),this.getTargetAggregation(),o);i=n.getSuggestedDropPosition();this.fireEvent("drop",{dragSession:r.dragSession,browserEvent:r.originalEvent,dropPosition:i?i.position:null,draggedControl:o.getDragControl(),droppedControl:i?i.targetControl:null});n.scheduleEndDrag()};n.prototype._shouldEnhance=function(){if(this._bShouldEnhance===undefined){if(!this.getParent().isA("sap.f.dnd.IGridDroppable")){o.error("The control which uses 'sap.f.dnd.GridDropInfo' has to implement 'sap.f.dnd.IGridDroppable'.","sap.f.dnd.GridDropInfo");this._bShouldEnhance=false;return this._bShouldEnhance}this._bShouldEnhance=this.getDropPosition()===r.dnd.DropPosition.Between&&this.getDropLayout()===r.dnd.DropLayout.Horizontal}return this._bShouldEnhance};n.prototype._isKeyboardEvent=function(r){return r.originalEvent.type==="keydown"};n.prototype._suggestDropPosition=function(r){if(!r.dragSession||!r.dragSession.getDragControl()){return null}var t=e.getInstance();t.setCurrentContext(r.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation(),r.dragSession);t.handleDragOver(r);return t.getSuggestedDropPosition()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/dnd/GridKeyboardDragAndDrop", [],function(){"use strict";var r={};function n(r,n,t,e){return{setIndicatorConfig:function(){},getDragControl:function(){return n},getDropControl:function(){return t},getDropPosition:function(){return e}}}function t(r){var n=r.getParent(),t=r.getDragDropConfig?r.getDragDropConfig():[],e=n&&n.getDragDropConfig?n.getDragDropConfig():[];return t.concat(e)}function e(r){var n=t(r);return n.filter(function(n){return n.isDraggable(r)})}function i(r,n,e){var i=t(r);n=n||[];return i.filter(function(r){return!r.isA("sap.ui.core.dnd.IDragInfo")}).concat(n).filter(function(t){if(!t.isDroppable(r,e)){return false}var i=t.getGroupName();if(!i){return true}return n.some(function(r){return r.getGroupName()==i})})}r._filterDragInfos=function(r,n){return r.filter(function(r){return r.fireDragStart(n)})};r._filterDropInfos=function(r,n){return r.filter(function(r){return r.fireDragEnter(n)})};r._fireDrop=function(r,n){r.forEach(function(r){r.fireDrop(n)})};r.fireDnD=function(r,t,o){var f=e(r);if(!f.length){return}for(var u=0;u<t.length;u++){o.dragSession=n(o,r,t[u].item,t[u].dropPosition);f=o.isMarked("NonDraggable")?[]:this._filterDragInfos(f,o);if(!f.length){continue}var a=i(t[u].grid,f,o);a=this._filterDropInfos(a,o);if(a.length>0){this._fireDrop(a,o);break}}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/flexibility/Avatar.flexibility", ["sap/ui/thirdparty/jquery","sap/m/flexibility/Avatar.flexibility"],function(jQuery,i){"use strict";return jQuery.extend(i,{})},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/flexibility/DynamicPageTitle.flexibility", ["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(e,n,a){"use strict";return{hideControl:"default",unhideControl:"default",combineButtons:{changeHandler:e,layers:{CUSTOMER:false}},splitMenuButton:{changeHandler:n,layers:{CUSTOMER:false}},moveActions:{changeHandler:a},moveControls:"default"}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/library", ["sap/ui/base/DataType","sap/m/AvatarShape","sap/m/AvatarSize","sap/m/AvatarType","sap/m/AvatarColor","sap/m/AvatarImageFitType","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/m/library","sap/ui/Global","sap/ui/core/library","sap/ui/layout/library"],function(a,e,i,s,n,t,r,p){"use strict";var d=sap.ui.getCore().initLibrary({name:"sap.f",version:"1.120.22",dependencies:["sap.ui.core","sap.m","sap.ui.layout"],designtime:"sap/f/designtime/library.designtime",interfaces:["sap.f.cards.IHeader","sap.f.ICard","sap.f.IShellBar","sap.f.IDynamicPageStickyContent","sap.f.dnd.IGridDroppable"],types:["sap.f.AvatarImageFitType","sap.f.AvatarShape","sap.f.AvatarSize","sap.f.AvatarType","sap.f.AvatarColor","sap.f.AvatarGroupType","sap.f.cards.HeaderPosition","sap.f.cards.NumericHeaderSideIndicatorsAlignment","sap.f.DynamicPageTitleArea","sap.f.DynamicPageTitleShrinkRatio","sap.f.IllustratedMessageSize","sap.f.IllustratedMessageType","sap.f.LayoutType"],controls:["sap.f.Avatar","sap.f.AvatarGroup","sap.f.AvatarGroupItem","sap.f.cards.Header","sap.f.cards.NumericHeader","sap.f.cards.NumericIndicators","sap.f.cards.NumericSideIndicator","sap.f.CalendarInCard","sap.f.Card","sap.f.GridContainer","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.IllustratedMessage","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage","sap.f.GridList","sap.f.GridListItem","sap.f.PlanningCalendarInCardLegend","sap.f.ProductSwitch","sap.f.ProductSwitchItem","sap.f.ShellBar","sap.f.SidePanel","sap.f.Illustration"],elements:["sap.f.DynamicPageAccessibleLandmarkInfo","sap.f.GridContainerItemLayoutData","sap.f.FlexibleColumnLayoutAccessibleLandmarkInfo","sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.EditAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MainAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction","sap.f.SearchManager","sap.f.SidePanelItem"],extensions:{flChangeHandlers:{"sap.f.Avatar":"sap/f/flexibility/Avatar","sap.f.DynamicPageHeader":{hideControl:"default",unhideControl:"default",moveControls:"default"},"sap.f.DynamicPageTitle":"sap/f/flexibility/DynamicPageTitle","sap.f.semantic.SemanticPage":{moveControls:"default"}},"sap.ui.support":{publicRules:true,internalRules:true}}});d.DynamicPageTitleArea={Begin:"Begin",Middle:"Middle"};d.DynamicPageTitleShrinkRatio=a.createType("sap.f.DynamicPageTitleShrinkRatio",{isValid:function(a){return/^(([0-9]\d*)(\.\d)?:([0-9]\d*)(\.\d)?:([0-9]\d*)(\.\d)?)$/.test(a)}},a.getType("string"));d.LayoutType={OneColumn:"OneColumn",TwoColumnsBeginExpanded:"TwoColumnsBeginExpanded",TwoColumnsMidExpanded:"TwoColumnsMidExpanded",MidColumnFullScreen:"MidColumnFullScreen",ThreeColumnsMidExpanded:"ThreeColumnsMidExpanded",ThreeColumnsEndExpanded:"ThreeColumnsEndExpanded",ThreeColumnsMidExpandedEndHidden:"ThreeColumnsMidExpandedEndHidden",ThreeColumnsBeginExpandedEndHidden:"ThreeColumnsBeginExpandedEndHidden",EndColumnFullScreen:"EndColumnFullScreen"};d.AvatarShape=e;d.AvatarSize=i;d.AvatarType=s;d.AvatarColor=n;d.AvatarImageFitType=t;d.AvatarGroupType={Group:"Group",Individual:"Individual"};d.cards=d.cards||{};d.cards.HeaderPosition={Top:"Top",Bottom:"Bottom"};d.cards.NumericHeaderSideIndicatorsAlignment={Begin:"Begin",End:"End"};d.NavigationDirection={Up:"Up",Down:"Down",Left:"Left",Right:"Right"};d.SidePanelPosition={Left:"Left",Right:"Right"};d.IllustratedMessageType=r;d.IllustratedMessageSize=p;(function(){sap.ui.lazyRequire("sap.f.routing.Router");sap.ui.lazyRequire("sap.f.routing.Target");sap.ui.lazyRequire("sap.f.routing.TargetHandler");sap.ui.lazyRequire("sap.f.routing.Targets")})();return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/routing/Router", ["sap/ui/core/routing/Router","./TargetHandler","./Targets"],function(t,e,r){"use strict";var a=t.extend("sap.f.routing.Router",{constructor:function(){this._oTargetHandler=new e;t.prototype.constructor.apply(this,arguments)},destroy:function(){t.prototype.destroy.apply(this,arguments);this._oTargetHandler.destroy();this._oTargetHandler=null},getTargetHandler:function(){return this._oTargetHandler},_createTargets:function(t,e){return new r({views:this._oViews,config:t,targets:e,targetHandler:this._oTargetHandler})},fireRouteMatched:function(e){var r=this.getRoute(e.name),a;if(r._oTarget){a=r._oTarget._oOptions;this._oTargetHandler.addNavigation({navigationIdentifier:e.name,transition:a.transition,transitionParameters:a.transitionParameters,eventData:e.arguments,targetControl:e.targetControl,view:e.view,layout:r._oConfig.layout})}return t.prototype.fireRouteMatched.apply(this,arguments)},fireRoutePatternMatched:function(e){var r=e.name,a;if(this._oTargets&&this._oTargets._oLastDisplayedTarget){a=this._oTargets._getLevel(this._oTargets._oLastDisplayedTarget)}this._oTargetHandler.navigate({navigationIdentifier:r,level:a,askHistory:true});return t.prototype.fireRoutePatternMatched.apply(this,arguments)}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/routing/Target", ["sap/ui/core/routing/Target","sap/f/FlexibleColumnLayout","./async/Target"],function(t,a,o){"use strict";var r=t.extend("sap.f.routing.Target",{constructor:function(a,r,e,n){this._oTargetHandler=n;t.prototype.constructor.apply(this,arguments);var i=o;this._super={};for(var s in i){this._super[s]=this[s];this[s]=i[s]}},_beforePlacingViewIntoContainer:function(o){var r=o.container;var e=o.data&&o.data.routeConfig;if(r instanceof a&&e&&e.layout){r.setLayout(e.layout)}t.prototype._beforePlacingViewIntoContainer.apply(this,arguments)}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/routing/TargetHandler", ["sap/m/InstanceManager","sap/f/FlexibleColumnLayout","sap/ui/base/Object","sap/ui/core/routing/History","sap/base/Log"],function(e,t,i,o,n){"use strict";var r=i.extend("sap.f.routing.TargetHandler",{constructor:function(e){this._aQueue=[];this._oNavigationOrderPromise=Promise.resolve();if(e===undefined){this._bCloseDialogs=true}else{this._bCloseDialogs=!!e}}});r.prototype.setCloseDialogs=function(e){this._bCloseDialogs=!!e;return this};r.prototype.getCloseDialogs=function(){return this._bCloseDialogs};r.prototype.addNavigation=function(e){this._aQueue.push(e)};r.prototype.navigate=function(e){var t=this._createResultingNavigations(e.navigationIdentifier),i=false,o=this._getDirection(e),n;while(t.length){n=this._applyNavigationResult(t.shift().oParams,o);i=i||n}if(i||o){this._closeDialogs()}};r.prototype._chainNavigation=function(e,t){var i=this._oNavigationOrderPromise.then(e);this._oNavigationOrderPromise=i.catch(function(e){n.error("The following error occurred while displaying routing target with name '"+t+"': "+e)});return i};r.prototype._getDirection=function(e){var t=e.level,i=o.getInstance(),n=false;if(e.direction==="Backwards"){n=true}else if(isNaN(t)||isNaN(this._iCurrentLevel)||t===this._iCurrentLevel){if(e.askHistory){n=i.getDirection()==="Backwards"}}else{n=t<this._iCurrentLevel}this._iCurrentLevel=t;return n};r.prototype._createResultingNavigations=function(e){var t,i,o,n,r=[],s;while(this._aQueue.length){i=this._aQueue.shift();o=i.targetControl;n={oContainer:o,oParams:i,placeholderConfig:i.placeholderConfig};if(!a(o)){continue}for(t=0;t<r.length;t++){s=r[t];if(s.oContainer!==o){continue}}r.push(n)}return r};r.prototype._applyNavigationResult=function(e,i){var o=e.targetControl,r=e.eventData,a=e.placeholderShown?"show":e.transition||"",s=e.transitionParameters,l=e.view.getId(),u,g=o instanceof t,c=false,h=e.placeholderConfig;if(g){u=[o.getCurrentBeginColumnPage(),o.getCurrentMidColumnPage(),o.getCurrentEndColumnPage()];c=u.some(function(e){return e&&e.getId()===l})}if(c){if(h.autoClose){o.hidePlaceholder(h)}n.info("navigation to view with id: "+l+" is skipped since it already is displayed by its targetControl","sap.f.routing.TargetHandler");return false}n.info("navigation to view with id: "+l+" the targetControl is "+o.getId()+" backwards is "+i);if(i){o._safeBackToPage(l,a,r,s)}else{o.to(l,a,r,s)}if(h.autoClose){o.hidePlaceholder(h)}return true};r.prototype._closeDialogs=function(){if(!this._bCloseDialogs){return}if(e.hasOpenPopover()){e.closeAllPopovers()}if(e.hasOpenDialog()){e.closeAllDialogs()}if(e.hasOpenLightBox()){e.closeAllLightBoxes()}};function a(e){return e&&e.isA(["sap.m.NavContainer","sap.m.SplitContainer","sap.f.FlexibleColumnLayout"])}r.prototype.showPlaceholder=function(e){var t=e.container,i=true,o;if(e.object&&!(e.object instanceof Promise)){o=e.object}if(e.container&&typeof e.container.needPlaceholder==="function"){i=e.container.needPlaceholder(e.aggregation,o)}if(i){return t.showPlaceholder(e)}else{return Promise.resolve()}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/routing/Targets", ["sap/ui/core/routing/Targets","./TargetHandler","./Target","./async/Targets"],function(t,e,r,n){"use strict";var a=t.extend("sap.f.routing.Targets",{constructor:function(r){r.config._async=true;if(r.targetHandler){this._oTargetHandler=r.targetHandler}else{this._oTargetHandler=new e;this._bHasOwnTargetHandler=true}t.prototype.constructor.apply(this,arguments);var a=n;this._super={};for(var s in a){this._super[s]=this[s];this[s]=a[s]}},destroy:function(){t.prototype.destroy.apply(this,arguments);if(this._bHasOwnTargetHandler){this._oTargetHandler.destroy()}this._oTargetHandler=null},getTargetHandler:function(){return this._oTargetHandler},_constructTarget:function(t,e){return new r(t,this.getViews(),e,this._oTargetHandler)},_getLevel:function(t){var e;do{e=t._oOptions.hasOwnProperty("level")?t._oOptions.level:t._oOptions.viewLevel;if(e!==undefined){return e}t=t._oParent}while(t);return e}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/routing/async/Target", [],function(){"use strict";return{_place:function(t){var n=this._super._place.apply(this,arguments),e=t&&t.routeConfig||{},i=this;return this._oTargetHandler._chainNavigation(function(){return n.then(function(n){i._oTargetHandler.addNavigation({navigationIdentifier:i._oOptions._name,transition:i._oOptions.transition,transitionParameters:i._oOptions.transitionParameters,eventData:t,targetControl:n.control,view:n.view,layout:e.layout,placeholderConfig:n.placeholderConfig});return n})},this._oOptions._name)},showPlaceholder:function(t){return this._oTargetHandler.showPlaceholder(t)},hidePlaceholder:function(t){}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/routing/async/Targets", [],function(){"use strict";return{display:function(){var t,i;this._oLastDisplayedTarget=null;var e=this._super.display.apply(this,arguments);return e.then(function(e){if(this._oLastDisplayedTarget){t=this._getLevel(this._oLastDisplayedTarget);i=this._oLastDisplayedTarget._oOptions._name}this._oTargetHandler.navigate({level:t,navigationIdentifier:i});return e}.bind(this))},_displaySingleTarget:function(t){var i=this.getTarget(t.name);return this._super._displaySingleTarget.apply(this,arguments).then(function(t){if(i){this._oLastDisplayedTarget=i}return t}.bind(this))}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/AddAction", ["sap/f/semantic/SemanticButton"],function(t){"use strict";var a=t.extend("sap.f.semantic.AddAction",{metadata:{library:"sap.f"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/CloseAction", ["./SemanticButton"],function(t){"use strict";var a=t.extend("sap.f.semantic.CloseAction",{metadata:{library:"sap.f"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/CopyAction", ["./SemanticButton"],function(t){"use strict";var a=t.extend("sap.f.semantic.CopyAction",{metadata:{library:"sap.f"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/DeleteAction", ["sap/f/semantic/SemanticButton"],function(t){"use strict";var e=t.extend("sap.f.semantic.DeleteAction",{metadata:{library:"sap.f"}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/DiscussInJamAction", ["sap/f/semantic/SemanticButton"],function(a){"use strict";var t=a.extend("sap.f.semantic.DiscussInJamAction",{metadata:{library:"sap.f"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/EditAction", ["./SemanticButton"],function(t){"use strict";var a=t.extend("sap.f.semantic.EditAction",{metadata:{library:"sap.f"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/ExitFullScreenAction", ["./SemanticButton"],function(t){"use strict";var e=t.extend("sap.f.semantic.ExitFullScreenAction",{metadata:{library:"sap.f"}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/FavoriteAction", ["./SemanticToggleButton"],function(t){"use strict";var a=t.extend("sap.f.semantic.FavoriteAction",{metadata:{library:"sap.f"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/FlagAction", ["./SemanticToggleButton"],function(t){"use strict";var a=t.extend("sap.f.semantic.FlagAction",{metadata:{library:"sap.f"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/FooterMainAction", ["./MainAction"],function(a){"use strict";var t=a.extend("sap.f.semantic.FooterMainAction",{metadata:{library:"sap.f"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/FullScreenAction", ["./SemanticButton"],function(t){"use strict";var e=t.extend("sap.f.semantic.FullScreenAction",{metadata:{library:"sap.f"}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/MainAction", ["sap/f/semantic/SemanticButton"],function(t){"use strict";var a=t.extend("sap.f.semantic.MainAction",{metadata:{library:"sap.f",abstract:true,properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/MessagesIndicator", ["./SemanticButton"],function(a){"use strict";var t=a.extend("sap.f.semantic.MessagesIndicator",{metadata:{library:"sap.f"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/NegativeAction", ["sap/f/semantic/SemanticButton"],function(t){"use strict";var e=t.extend("sap.f.semantic.NegativeAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/PositiveAction", ["sap/f/semantic/SemanticButton"],function(t){"use strict";var e=t.extend("sap.f.semantic.PositiveAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/PrintAction", ["sap/f/semantic/SemanticButton"],function(t){"use strict";var a=t.extend("sap.f.semantic.PrintAction",{metadata:{library:"sap.f"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticButton", ["sap/m/semantic/SemanticButton","sap/f/semantic/SemanticConfiguration"],function(t,a){"use strict";var e=t.extend("sap.f.semantic.SemanticButton",{metadata:{library:"sap.f",abstract:true}});e.prototype._getConfiguration=function(){return a.getConfiguration(this.getMetadata().getName())};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticConfiguration", ["sap/ui/base/Object","sap/ui/core/IconPool","sap/m/library","sap/m/OverflowToolbarLayoutData"],function(e,t,n,i){"use strict";var r=n.OverflowToolbarPriority;var o=n.ButtonType;var a=e.extend("sap.f.semantic.SemanticConfiguration",{getInterface:function(){return this}});a._Placement={titleText:"titleText",titleIcon:"titleIcon",footerLeft:"footerLeft",footerRight:"footerRight",shareMenu:"shareMenu"};a.isKnownSemanticType=function(e){return a.getConfiguration(e)!==null};a.getConfiguration=function(e){return a._oTypeConfigs[e]||null};a.getSettings=function(e){if(a.isKnownSemanticType(e)){return a._oTypeConfigs[e].getSettings()}return null};a.getConstraints=function(e){if(a.isKnownSemanticType(e)){return a._oTypeConfigs[e].constraints||null}return null};a.getPlacement=function(e){if(a.isKnownSemanticType(e)){return a._oTypeConfigs[e].placement}return null};a.getOrder=function(e){if(a.isKnownSemanticType(e)){return a._oTypeConfigs[e].order}return null};a.shouldBePreprocessed=function(e){if(a.isKnownSemanticType(e)){return a._oTypeConfigs[e].needPreprocesing||false}return false};a.isMainAction=function(e){if(a.isKnownSemanticType(e)){return a._oTypeConfigs[e].mainAction||false}return false};a.isNavigationAction=function(e){if(a.isKnownSemanticType(e)){return a._oTypeConfigs[e].navigation||false}return false};a._oTypeConfigs=function(){var e={},n=sap.ui.getCore().getLibraryResourceBundle("sap.f");e["sap.f.semantic.TitleMainAction"]={placement:a._Placement.titleText,order:0,mainAction:true,getSettings:function(){return{type:o.Emphasized,layoutData:new i({priority:r.NeverOverflow})}}};e["sap.f.semantic.EditAction"]={placement:a._Placement.titleText,order:1,getSettings:function(){return{text:n.getText("SEMANTIC_CONTROL_EDIT"),tooltip:n.getText("SEMANTIC_CONTROL_EDIT"),type:o.Transparent}}};e["sap.f.semantic.DeleteAction"]={placement:a._Placement.titleText,order:2,getSettings:function(){return{text:n.getText("SEMANTIC_CONTROL_DELETE"),type:o.Transparent}}};e["sap.f.semantic.CopyAction"]={placement:a._Placement.titleText,order:3,getSettings:function(){return{text:n.getText("SEMANTIC_CONTROL_COPY"),type:o.Transparent}}};e["sap.f.semantic.AddAction"]={placement:a._Placement.titleText,order:4,getSettings:function(){return{text:n.getText("SEMANTIC_CONTROL_ADD"),tooltip:n.getText("SEMANTIC_CONTROL_ADD"),type:o.Transparent}}};e["sap.f.semantic.FavoriteAction"]={placement:a._Placement.titleIcon,order:0,constraints:"IconOnly",getSettings:function(){return{icon:t.getIconURI("favorite"),text:n.getText("SEMANTIC_CONTROL_FAVORITE"),type:o.Transparent}}};e["sap.f.semantic.FlagAction"]={placement:a._Placement.titleIcon,order:1,constraints:"IconOnly",getSettings:function(){return{icon:t.getIconURI("flag"),text:n.getText("SEMANTIC_CONTROL_FLAG"),type:o.Transparent}}};e["sap.f.semantic.FullScreenAction"]={placement:a._Placement.titleIcon,order:0,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:t.getIconURI("full-screen"),tooltip:n.getText("SEMANTIC_CONTROL_FULL_SCREEN"),layoutData:new i({priority:r.NeverOverflow}),type:o.Transparent}}};e["sap.f.semantic.ExitFullScreenAction"]={placement:a._Placement.titleIcon,order:1,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:t.getIconURI("exit-full-screen"),tooltip:n.getText("SEMANTIC_CONTROL_EXIT_FULL_SCREEN"),layoutData:new i({priority:r.NeverOverflow}),type:o.Transparent}}};e["sap.f.semantic.CloseAction"]={placement:a._Placement.titleIcon,order:2,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:t.getIconURI("decline"),tooltip:n.getText("SEMANTIC_CONTROL_CLOSE"),layoutData:new i({priority:r.NeverOverflow}),type:o.Transparent}}};e["sap.f.semantic.MessagesIndicator"]={placement:a._Placement.footerLeft,order:0,mainAction:false,getSettings:function(){return{icon:t.getIconURI("message-popup"),text:{path:"message>/",formatter:function(e){return e.length||0}},tooltip:n.getText("SEMANTIC_CONTROL_MESSAGES_INDICATOR"),type:o.Emphasized,visible:{path:"message>/",formatter:function(e){return e&&e.length>0}},models:{message:sap.ui.getCore().getMessageManager().getMessageModel()},layoutData:new i({priority:r.NeverOverflow})}}};e["sap.m.DraftIndicator"]={placement:a._Placement.footerRight,order:0,needPreprocesing:true,mainAction:false,getSettings:function(){return{layoutData:new i({shrinkable:false})}}};e["sap.f.semantic.FooterMainAction"]={placement:a._Placement.footerRight,order:1,mainAction:true,getSettings:function(){return{type:o.Emphasized,text:n.getText("SEMANTIC_CONTROL_SAVE"),layoutData:new i({priority:r.NeverOverflow})}}};e["sap.f.semantic.PositiveAction"]={placement:a._Placement.footerRight,order:2,mainAction:false,getSettings:function(){return{type:o.Accept,text:n.getText("SEMANTIC_CONTROL_ACCEPT"),layoutData:new i({priority:r.NeverOverflow})}}};e["sap.f.semantic.NegativeAction"]={placement:a._Placement.footerRight,order:3,mainAction:false,getSettings:function(){return{type:o.Reject,text:n.getText("SEMANTIC_CONTROL_REJECT"),layoutData:new i({priority:r.NeverOverflow})}}};e["sap.f.semantic.SendEmailAction"]={placement:a._Placement.shareMenu,order:0,constraints:"IconOnly",getSettings:function(){return{icon:t.getIconURI("email"),text:n.getText("SEMANTIC_CONTROL_SEND_EMAIL"),type:o.Transparent}}};e["sap.f.semantic.DiscussInJamAction"]={placement:a._Placement.shareMenu,order:1,constraints:"IconOnly",getSettings:function(){return{icon:t.getIconURI("discussion-2"),text:n.getText("SEMANTIC_CONTROL_DISCUSS_IN_WORK_ZONE"),type:o.Transparent}}};e["sap.f.semantic.ShareInJamAction"]={placement:a._Placement.shareMenu,order:2,constraints:"IconOnly",getSettings:function(){return{icon:t.getIconURI("share-2"),text:n.getText("SEMANTIC_CONTROL_SHARE_ON_WORK_ZONE"),type:o.Transparent}}};e["sap.f.semantic.SendMessageAction"]={placement:a._Placement.shareMenu,order:3,constraints:"IconOnly",getSettings:function(){return{icon:t.getIconURI("discussion"),text:n.getText("SEMANTIC_CONTROL_SEND_MESSAGE"),type:o.Transparent}}};e["saveAsTileAction"]={placement:a._Placement.shareMenu,order:4,constraints:"IconOnly"};e["sap.f.semantic.PrintAction"]={placement:a._Placement.shareMenu,order:5,constraints:"IconOnly",getSettings:function(){return{icon:t.getIconURI("print"),text:n.getText("SEMANTIC_CONTROL_PRINT"),type:o.Transparent}}};return e}();return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticContainer", ["sap/ui/base/EventProvider","./SemanticConfiguration","sap/base/Log"],function(t,e,n){"use strict";var r=t.extend("sap.f.semantic.SemanticContainer",{constructor:function(e,r){if(!e){n.error("SemanticContainer :: missing argument - container reference",this);return}t.apply(this,arguments);this._oContainer=e;this._oParent=r},getInterface:function(){return this}});r.prototype._getContainer=function(){return this._oContainer};r.prototype._getParent=function(){return this._oParent};r.prototype._shouldBePreprocessed=function(t){var n=t._getType&&t._getType()||t.getMetadata().getName();return e.shouldBePreprocessed(n)};r.prototype._getControlOrder=function(t){var n=t._getType&&t._getType()||t.getMetadata().getName();return e.getOrder(n)};r.prototype._getConstraints=function(t){return e.getConstraints(t.getMetadata().getName())};r.prototype._getControl=function(t){return t._getControl?t._getControl():t};r.prototype._isMainAction=function(t){return e.isMainAction(t.getMetadata().getName())};r.prototype._isNavigationAction=function(t){return e.isNavigationAction(t.getMetadata().getName())};r.prototype._callContainerAggregationMethod=function(t){return this._getContainer()[t].apply(this._getContainer(),Array.prototype.slice.call(arguments).slice(1))};r.prototype._sortControlByOrder=function(t,e){return this._getControlOrder(t)-this._getControlOrder(e)};r.prototype.destroy=function(){this._oParent=null;this._oContainer=null};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticControl", ["sap/ui/thirdparty/jquery","sap/ui/core/Element","./SemanticConfiguration"],function(jQuery,t,e){"use strict";var o=t.extend("sap.f.semantic.SemanticControl",{metadata:{library:"sap.f",abstract:true,properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_control:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});o.prototype.setProperty=function(e,o,r){t.prototype.setProperty.call(this,e,o,true);this._applyProperty(e,o,r);return this};o.prototype.updateAggregation=function(t){this._getControl().updateAggregation(t)};o.prototype.refreshAggregation=function(t){this._getControl().refreshAggregation(t)};o.prototype.setAggregation=function(e,o,r){if(e==="_control"){return t.prototype.setAggregation.call(this,e,o,r)}return this._getControl().setAggregation(e,o,r)};o.prototype.getAggregation=function(e,o){if(e==="_control"){return t.prototype.getAggregation.call(this,e,o)}return this._getControl().getAggregation(e,o)};o.prototype.indexOfAggregation=function(t,e){return this._getControl().indexOfAggregation(t,e)};o.prototype.insertAggregation=function(t,e,o,r){return this._getControl().insertAggregation(t,e,o,r)};o.prototype.addAggregation=function(t,e,o){return this._getControl().addAggregation(t,e,o)};o.prototype.removeAggregation=function(t,e,o){return this._getControl().removeAggregation(t,e,o)};o.prototype.removeAllAggregation=function(t,e){return this._getControl().removeAllAggregation(t,e)};o.prototype.destroyAggregation=function(t,e){return this._getControl().destroyAggregation(t,e)};o.prototype.bindAggregation=function(t,e){return this._getControl().bindAggregation(t,e)};o.prototype.unbindAggregation=function(t,e){return this._getControl().unbindAggregation(t,e)};o.prototype.clone=function(e,o){var r=t.prototype.clone.apply(this,arguments);var n=this._getControl().clone(e,o);r.setAggregation("_control",n);return r};o.prototype.destroy=function(){var e=t.prototype.destroy.apply(this,arguments);if(this.getAggregation("_control")){this.getAggregation("_control").destroy()}return e};o.prototype.getDomRef=function(t){return this._getControl().getDomRef(t)};o.prototype.addEventDelegate=function(t,e){jQuery.each(t,function(o,r){if(typeof r==="function"){t[o]=function(t){t.srcControl=this;r.call(e,t)}.bind(this)}}.bind(this));this._getControl().addEventDelegate(t,e);return this};o.prototype.removeEventDelegate=function(t){this._getControl().removeEventDelegate(t);return this};o.prototype._getConfiguration=function(){return e.getConfiguration(this.getMetadata().getName())};o.prototype._applyProperty=function(t,e,o){var n=this._getControl(),i;if(n){i="set"+r(t);this._getControl()[i](e,o)}};function r(t){return t.charAt(0).toUpperCase()+t.slice(1)}return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticFooter", ["sap/m/ToolbarSpacer","sap/m/library","./SemanticContainer"],function(t,n,e){"use strict";var o=n.ButtonType;var i=e.extend("sap.f.semantic.SemanticFooter",{constructor:function(t,n){e.call(this,t,n);this._aCustomContent=[];this._aSemanticLeftContent=[];this._aSemanticRightContent=[];this._iSemanticLeftContentCount=1;this._fnParentSubstitute=function(){return this._oParent}.bind(this);this._insertSpacer()}});i.mPlacementMethodMap={footerLeft:"LeftContent",footerRight:"RightContent"};i.prototype.addCustomAction=function(t){t.setType(o.Transparent);this._callContainerAggregationMethod("addContent",t);this._aCustomContent.push(t);return this};i.prototype.insertCustomAction=function(t,n){var e=this._getCustomContentInsertIndex(n);t.setType(o.Transparent);this._callContainerAggregationMethod("insertContent",t,e);this._aCustomContent.splice(n,0,t);return this};i.prototype.getCustomActions=function(){return this._aCustomContent.slice()};i.prototype.indexOfCustomAction=function(t){return this._aCustomContent.indexOf(t)};i.prototype.removeCustomAction=function(t){var n=this._callContainerAggregationMethod("removeContent",t);this._aCustomContent.splice(this._aCustomContent.indexOf(t),1);return n};i.prototype.removeAllCustomActions=function(){var t=[];this._aCustomContent.forEach(function(n){var e=this._callContainerAggregationMethod("removeContent",n);if(e){t.push(n)}},this);this._aCustomContent=[];return t};i.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(t){t.destroy()});return this};i.prototype.addContent=function(t,n){this["_insertSemantic"+i.mPlacementMethodMap[n]].call(this,t);return this};i.prototype.removeContent=function(t,n){this["_removeSemantic"+i.mPlacementMethodMap[n]].call(this,t);return this};i.prototype.destroy=function(){this._aCustomContent=null;this._aSemanticLeftContent=null;this._aSemanticRightContent=null;this._oSpacer=null;return e.prototype.destroy.call(this)};i.prototype._insertSemanticLeftContent=function(t){var n=this._getControl(t),e=this._getControlOrder(t),o=this._getSemanticLeftContentInsertIndex(e);this._callContainerAggregationMethod("insertContent",n,o);this._iSemanticLeftContentCount++;this._aSemanticLeftContent.push(t);return this};i.prototype._insertSemanticRightContent=function(t){var n=this._getControl(t);this._aSemanticRightContent.push(t);this._callContainerAggregationMethod("insertContent",n,this._getSemanticRightContentInsertIndex(t));if(this._shouldBePreprocessed(t)){this._preProcessControl(n)}return this};i.prototype._removeSemanticLeftContent=function(t){var n=this._getControl(t);this._callContainerAggregationMethod("removeContent",n);this._iSemanticLeftContentCount--;this._aSemanticLeftContent.splice(this._aSemanticLeftContent.indexOf(n),1);return t};i.prototype._removeSemanticRightContent=function(t){var n=this._getControl(t);this._callContainerAggregationMethod("removeContent",n);this._aSemanticRightContent.splice(this._aSemanticRightContent.indexOf(t),1);this._postProcessControl(n);return t};i.prototype._getSemanticLeftContentInsertIndex=function(t){return this._iSemanticLeftContentCount>1?t:0};i.prototype._getSemanticRightContentInsertIndex=function(t){this._aSemanticRightContent.sort(this._sortControlByOrder.bind(this));return this._iSemanticLeftContentCount+this._aSemanticRightContent.indexOf(t)};i.prototype._getCustomContentInsertIndex=function(t){return t+this._iSemanticLeftContentCount+this._aSemanticRightContent.length};i.prototype._insertSpacer=function(){this._callContainerAggregationMethod("addContent",this._getSpacer());return this};i.prototype._getSpacer=function(){if(!this._oSpacer){this._oSpacer=new t}return this._oSpacer};i.prototype._preProcessControl=function(t){if(!(typeof t._fnOriginalGetParent==="function")){t._fnOriginalGetParent=t.getParent;t.getParent=this._fnParentSubstitute}};i.prototype._postProcessControl=function(t){if(t._fnOriginalGetParent){t.getParent=t._fnOriginalGetParent;delete t._fnOriginalGetParent}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticPage", ["sap/ui/core/Control","sap/ui/core/Shortcut","sap/f/library","sap/f/DynamicPage","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","sap/m/OverflowToolbar","sap/m/ActionSheet","./SemanticTitle","./SemanticFooter","./SemanticShareMenu","./SemanticConfiguration","./SemanticPageRenderer"],function(t,e,i,n,o,a,r,s,l,c,g,p,u){"use strict";var h=i.DynamicPageTitleArea;var _=t.extend("sap.f.semantic.SemanticPage",{metadata:{library:"sap.f",properties:{headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},headerPinnable:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},titlePrimaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:h.Begin,deprecated:true},titleAreaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{titleHeading:{type:"sap.ui.core.Control",multiple:false,forwarding:{getter:"_getTitle",aggregation:"heading"}},titleExpandedHeading:{type:"sap.ui.core.Control",multiple:false,forwarding:{getter:"_getTitle",aggregation:"expandedHeading"}},titleSnappedHeading:{type:"sap.ui.core.Control",multiple:false,forwarding:{getter:"_getTitle",aggregation:"snappedHeading"}},titleBreadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false,forwarding:{getter:"_getTitle",aggregation:"breadcrumbs"}},titleSnappedOnMobile:{type:"sap.m.Title",multiple:false,forwarding:{getter:"_getTitle",aggregation:"snappedTitleOnMobile"}},titleSnappedContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"snappedContent"}},titleExpandedContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"expandedContent"}},titleContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"content"}},titleMainAction:{type:"sap.f.semantic.TitleMainAction",multiple:false},editAction:{type:"sap.f.semantic.EditAction",multiple:false},deleteAction:{type:"sap.f.semantic.DeleteAction",multiple:false},copyAction:{type:"sap.f.semantic.CopyAction",multiple:false},addAction:{type:"sap.f.semantic.AddAction",multiple:false},flagAction:{type:"sap.f.semantic.FlagAction",multiple:false},favoriteAction:{type:"sap.f.semantic.FavoriteAction",multiple:false},fullScreenAction:{type:"sap.f.semantic.FullScreenAction",multiple:false},exitFullScreenAction:{type:"sap.f.semantic.ExitFullScreenAction",multiple:false},closeAction:{type:"sap.f.semantic.CloseAction",multiple:false},titleCustomTextActions:{type:"sap.m.Button",multiple:true},titleCustomIconActions:{type:"sap.m.OverflowToolbarButton",multiple:true},headerContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getHeader",aggregation:"content"}},content:{type:"sap.ui.core.Control",multiple:false},footerMainAction:{type:"sap.f.semantic.FooterMainAction",multiple:false},messagesIndicator:{type:"sap.f.semantic.MessagesIndicator",multiple:false},draftIndicator:{type:"sap.m.DraftIndicator",multiple:false},positiveAction:{type:"sap.f.semantic.PositiveAction",multiple:false},negativeAction:{type:"sap.f.semantic.NegativeAction",multiple:false},footerCustomActions:{type:"sap.m.Button",multiple:true},discussInJamAction:{type:"sap.f.semantic.DiscussInJamAction",multiple:false},saveAsTileAction:{type:"sap.m.Button",multiple:false},shareInJamAction:{type:"sap.f.semantic.ShareInJamAction",multiple:false},sendMessageAction:{type:"sap.f.semantic.SendMessageAction",multiple:false},sendEmailAction:{type:"sap.f.semantic.SendEmailAction",multiple:false},printAction:{type:"sap.f.semantic.PrintAction",multiple:false},customShareActions:{type:"sap.m.Button",multiple:true},landmarkInfo:{type:"sap.f.DynamicPageAccessibleLandmarkInfo",multiple:false,forwarding:{getter:"_getPage",aggregation:"landmarkInfo"}},_dynamicPage:{type:"sap.f.DynamicPage",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/SemanticPage.designtime"},renderer:u});_._EVENTS={SHARE_MENU_CONTENT_CHANGED:"_shareMenuContentChanged"};_._SAVE_AS_TILE_ACTION="saveAsTileAction";_.CONTENT_PADDING_CLASSES_TO_FORWARD={sapUiNoContentPadding:true,sapUiContentPadding:true,sapUiResponsiveContentPadding:true};_.ARIA_ROLE_DESCRIPTION="SEMANTIC_PAGE_ROLE_DESCRIPTION";_.prototype.init=function(){this._bSPBeingDestroyed=false;this._initDynamicPage();this._attachShareMenuButtonChange();this._fnActionSubstituteParentFunction=function(){return this}.bind(this)};_.prototype.exit=function(){this._bSPBeingDestroyed=true;this._cleanMemory()};_.prototype.setHeaderExpanded=function(t){this._getPage().setHeaderExpanded(t);return this};_.prototype.getHeaderExpanded=function(){return this._getPage().getHeaderExpanded()};_.prototype.setHeaderPinnable=function(t){var e=this._getPage(),i=e.getHeader();i.setPinnable(t);return this.setProperty("headerPinnable",i.getPinnable(),true)};_.prototype.setPreserveHeaderStateOnScroll=function(t){var e=this._getPage();e.setPreserveHeaderStateOnScroll(t);return this.setProperty("preserveHeaderStateOnScroll",e.getPreserveHeaderStateOnScroll(),true)};_.prototype.setToggleHeaderOnTitleClick=function(t){this._getPage().setToggleHeaderOnTitleClick(t);return this.setProperty("toggleHeaderOnTitleClick",t,true)};_.prototype.setShowFooter=function(t){this._getPage().setShowFooter(t);return this.setProperty("showFooter",t,true)};_.prototype.setTitlePrimaryArea=function(t){var e=this._getTitle();e.setPrimaryArea(t);return this.setProperty("titlePrimaryArea",e.getPrimaryArea(),true)};_.prototype.setTitleAreaShrinkRatio=function(t){var e=this._getTitle();e.setAreaShrinkRatio(t);return this.setProperty("titleAreaShrinkRatio",e.getAreaShrinkRatio(),true)};_.prototype.setFitContent=function(t){this._getPage().setFitContent(t);return this.setProperty("fitContent",t,true)};_.prototype.addStyleClass=function(e,i){var n=this.getAggregation("_dynamicPage");if(_.CONTENT_PADDING_CLASSES_TO_FORWARD[e]){n.addStyleClass(e,true)}return t.prototype.addStyleClass.call(this,e,i)};_.prototype.removeStyleClass=function(e,i){var n=this.getAggregation("_dynamicPage");if(_.CONTENT_PADDING_CLASSES_TO_FORWARD[e]){n.removeStyleClass(e,true)}return t.prototype.removeStyleClass.call(this,e,i)};_.prototype.clone=function(){var e=t.prototype.clone.apply(this,arguments),i=this.getAggregation("_dynamicPage").getContent();e.setContent(i.clone());return e};_.prototype.setAggregation=function(e,i,n){var o=this.mAggregations[e],a,r;if(o===i){return this}i=this.validateAggregation(e,i,false);if(e===_._SAVE_AS_TILE_ACTION){a=_._SAVE_AS_TILE_ACTION}else{a=this.getMetadata().getManagedAggregation(e).type}if(p.isKnownSemanticType(a)){r=p.getPlacement(a);if(o){this._onRemoveAggregation(o,a);this._getSemanticContainer(r).removeContent(o,r)}if(i){i._getType=function(){return a};this._getSemanticContainer(r).addContent(i,r);this._onAddAggregation(i,a)}return t.prototype.setAggregation.call(this,e,i,true)}return t.prototype.setAggregation.call(this,e,i,n)};_.prototype.destroyAggregation=function(e,i){var n=this.getMetadata().getAggregations()[e],o,a,r;if(e===_._SAVE_AS_TILE_ACTION){r=_._SAVE_AS_TILE_ACTION}else{r=n&&n.type}if(r&&p.isKnownSemanticType(r)){o=t.prototype.getAggregation.call(this,e);if(o){a=p.getPlacement(r);this._onRemoveAggregation(o,r);!this._bSPBeingDestroyed&&this._getSemanticContainer(a).removeContent(o,a)}}return t.prototype.destroyAggregation.call(this,e,i)};_.prototype.onBeforeRendering=function(){var t=this._getShareMenu(),e=t._getVisibleActions(),i=e.length;t._getShareMenuButton().setVisible(i>1);if(i===1){this._showSingleVisibleAction()}if(this._iVisibleShareMenuAction===1&i>1){this._hideSingleVisibleAction();this._iVisibleShareMenuAction=i}};_.prototype._addShareMenuSingleAction=function(t){if(t){var e=p.isKnownSemanticType(t.getMetadata().getName());t._bIsSingleAction=true;this._getSemanticTitle().addContent(t,e?p._Placement.titleIcon:p._Placement.titleText);this._iVisibleShareMenuAction=1;this._oSingleVisibleAction=t}};["getContent","setContent","destroyContent"].forEach(function(t){var e=/^(set|destroy)/.test(t);_.prototype[t]=function(i){var n=this._getPage();var o=n[t].apply(n,arguments);return e?this:o}},this);["addTitleCustomTextAction","insertTitleCustomTextAction","indexOfTitleCustomTextAction","removeTitleCustomTextAction","removeAllTitleCustomTextActions","destroyTitleCustomTextActions","getTitleCustomTextActions"].forEach(function(t){var e=/^(add|insert|destroy)/.test(t);_.prototype[t]=function(){var i=this._getSemanticTitle(),n=t.replace(/TitleCustomTextAction?/,"CustomTextAction"),o;o=i[n].apply(i,arguments);return e?this:o}},this);["addTitleCustomIconAction","insertTitleCustomIconAction","indexOfTitleCustomIconAction","removeTitleCustomIconAction","removeAllTitleCustomIconActions","destroyTitleCustomIconActions","getTitleCustomIconActions"].forEach(function(t){var e=/^(add|insert|destroy)/.test(t);_.prototype[t]=function(){var i=this._getSemanticTitle(),n=t.replace(/TitleCustomIconAction?/,"CustomIconAction"),o;o=i[n].apply(i,arguments);return e?this:o}},this);["addFooterCustomAction","insertFooterCustomAction","indexOfFooterCustomAction","removeFooterCustomAction","removeAllFooterCustomActions","destroyFooterCustomActions","getFooterCustomActions"].forEach(function(t){var e=/^(add|insert|destroy)/.test(t);_.prototype[t]=function(){var i=this._getSemanticFooter(),n=t.replace(/FooterCustomAction?/,"CustomAction"),o;o=i[n].apply(i,arguments);return e?this:o}},this);["addCustomShareAction","insertCustomShareAction","indexOfCustomShareAction","removeCustomShareAction","removeAllCustomShareActions","destroyCustomShareActions","getCustomShareActions"].forEach(function(t){var e=/^(add|insert|destroy)/.test(t);_.prototype[t]=function(){var i=this._getShareMenu(),n=t.replace(/CustomShareAction?/,"CustomAction"),o;o=i[n].apply(i,arguments);return e?this:o}},this);_.prototype._onAddAggregation=function(t,e){if(e===_._SAVE_AS_TILE_ACTION){this._replaceParent(t)}};_.prototype._onRemoveAggregation=function(t,e){if(e===_._SAVE_AS_TILE_ACTION){this._restoreParent(t)}if(t._getType){delete t._getType}};_.prototype._replaceParent=function(t){if(t._fnOriginalGetParent){return}t._fnOriginalGetParent=t.getParent;t.getParent=this._fnActionSubstituteParentFunction};_.prototype._restoreParent=function(t){if(t&&t._fnOriginalGetParent){t.getParent=t._fnOriginalGetParent}};_.prototype._attachShareMenuButtonChange=function(){this.attachEvent(_._EVENTS.SHARE_MENU_CONTENT_CHANGED,this._onShareMenuContentChanged,this)};_.prototype._onShareMenuContentChanged=function(t){var e=t.getParameter("bEmpty"),i=this._getSemanticTitle(),n=this._getShareMenu(),o=n._getShareMenuButton();if(!o.getParent()){i.addContent(o,"shareIcon");return}o.setVisible(!e)};_.prototype._getPage=function(){if(!this.getAggregation("_dynamicPage")){this._initDynamicPage()}return this.getAggregation("_dynamicPage")};_.prototype._initDynamicPage=function(){var t=new n(this.getId()+"-page",{title:this._getTitle(),header:this._getHeader(),footer:this._getFooter()}),e=sap.ui.getCore().getLibraryResourceBundle("sap.f").getText(_.ARIA_ROLE_DESCRIPTION);t._setAriaRoleDescription(e);this.setAggregation("_dynamicPage",t,true)};_.prototype._getTitle=function(){if(!this._oDynamicPageTitle){this._oDynamicPageTitle=this._getSemanticTitle()._getContainer();e.register(this._oDynamicPageTitle,"Ctrl+Shift+S",this._openShareMenu.bind(this))}return this._oDynamicPageTitle};_.prototype._getHeader=function(){if(!this._oDynamicPageHeader){this._oDynamicPageHeader=new a(this.getId()+"-pageHeader")}return this._oDynamicPageHeader};_.prototype._getFooter=function(){if(!this._oDynamicPageFooter){this._oDynamicPageFooter=this._getSemanticFooter()._getContainer()}return this._oDynamicPageFooter};_.prototype._getSemanticTitle=function(){if(!this._oSemanticTitle){this._oSemanticTitle=new l(new o(this.getId()+"-pageTitle"),this)}return this._oSemanticTitle};_.prototype._getShareMenu=function(){if(!this._oShareMenu){this._oShareMenu=new g(this._getActionSheet(),this);this.addDependent(this._oShareMenu._oContainer);this._oShareMenu.attachEvent("_visibleActionsChanged",this._onShareMenuActionsChanged.bind(this))}return this._oShareMenu};_.prototype._onShareMenuActionsChanged=function(t){var e=t.getParameter("visibleActionsCount");if(this._iVisibleShareMenuAction!==e){if(e===1){this._showSingleVisibleAction()}if(e!==1){this._hideSingleVisibleAction()}}this._iVisibleShareMenuAction=e};_.prototype._showSingleVisibleAction=function(){var t=this._getShareMenu(),e=t._getVisibleActions(),i=t._aShareMenuActions.concat(t._aCustomShareActions),n;if(e.length===1){n=i.filter(function(t){return t._getControl&&t._getControl()===e[0]||t===e[0]})[0];var o=n._getControl&&n._getControl();if(o){var a="sapMActionSheet";o.aCustomStyleClasses.filter(function(t){return t.indexOf(a)>-1}).forEach(function(t){o.removeStyleClass(t)})}this._addShareMenuSingleAction(n)}};_.prototype._hideSingleVisibleAction=function(){var t=p._Placement.shareMenu,e=this._getSemanticContainer(t),i;if(this._oSingleVisibleAction){i=p.isKnownSemanticType(this._oSingleVisibleAction.getMetadata().getName());this._oSingleVisibleAction._bIsSingleAction=false;this._getSemanticTitle().removeContent(this._oSingleVisibleAction,i?p._Placement.titleIcon:p._Placement.titleText);i?e.addContent(this._oSingleVisibleAction):e.insertCustomAction(this._oSingleVisibleAction,0);this._onAddAggregation(this._oSingleVisibleAction,t);this._oSingleVisibleAction=null}};_.prototype._openShareMenu=function(){var t=this._getShareMenu()._getShareMenuButton(),e=this._getTitle().getAggregation("_actionsToolbar")._getOverflowButton();if(t.getVisible()){this._getActionSheet().openBy(!t._bInOverflow?t:e)}};_.prototype._getActionSheet=function(){if(!this._oActionSheet){this._oActionSheet=new s(this.getId()+"-shareMenu")}return this._oActionSheet};_.prototype._getSemanticFooter=function(){if(!this._oSemanticFooter){this._oSemanticFooter=new c(this._getOverflowToolbar(),this)}return this._oSemanticFooter};_.prototype._getOverflowToolbar=function(){if(!this._oOverflowToolbar){this._oOverflowToolbar=new r(this.getId()+"-pageFooter")}return this._oOverflowToolbar};_.prototype._getSemanticContainer=function(t){var e=p._Placement;if(t===e.titleText||t===e.titleIcon){return this._getSemanticTitle()}else if(t===e.footerLeft||t===e.footerRight){return this._getSemanticFooter()}else if(t===e.shareMenu){return this._getShareMenu()}return null};_.prototype._cleanMemory=function(){if(this._oShareMenu){this._oShareMenu.destroy();this._oShareMenu=null}if(this._oActionSheet){this._oActionSheet.destroy();this._oActionSheet=null}if(this._oSemanticTitle){this._oSemanticTitle.destroy();this._oSemanticTitle=null}if(this._oDynamicPageTitle){this._oDynamicPageTitle.destroy();this._oDynamicPageTitle=null}if(this._oDynamicPageHeader){this._oDynamicPageHeader.destroy();this._oDynamicPageHeader=null}if(this._oSemanticFooter){this._oSemanticFooter.destroy();this._oSemanticFooter=null}if(this._oDynamicPageFooter){this._oDynamicPageFooter.destroy();this._oDynamicPageFooter=null}if(this._oOverflowToolbar){this._oOverflowToolbar.destroy();this._oOverflowToolbar=null}};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticPageRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,n){e.openStart("div",n);e.class("sapFSemanticPage");e.openEnd();e.renderControl(n._getPage());e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticShareMenu", ["sap/ui/core/IconPool","sap/ui/base/EventProvider","sap/ui/base/ManagedObjectObserver","sap/ui/Device","sap/ui/core/ShortcutHintsMixin","sap/ui/core/library","sap/m/library","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","./SemanticContainer"],function(t,e,o,n,i,r,s,a,h,u){"use strict";var c=s.ButtonType;var _=r.aria.HasPopup;var l=u.extend("sap.f.semantic.SemanticShareMenu",{constructor:function(t,e){u.call(this,t,e);this._aShareMenuActions=[];this._aCustomShareActions=[];this._oObserver=new o(l.prototype._onShareMenuButtonChanges.bind(this));this._onShareButtonClickRef=this._onShareButtonClick.bind(this);this._setMode(l._Mode.initial)}});l._Mode={initial:"initial",menu:"menu"};l.prototype.addCustomAction=function(t){this._onControlAdded(t);this._oObserver.observe(t,{properties:["visible"]});this._callContainerAggregationMethod("insertButton",t,this._getCustomActionInsertIndex());this._aCustomShareActions.push(t);return this};l.prototype.insertCustomAction=function(t,e){if(this._aCustomShareActions.indexOf(t)<0){this._onControlAdded(t);this._oObserver.observe(t,{properties:["visible"]});this._aCustomShareActions.splice(e,0,t)}this._callContainerAggregationMethod("insertButton",t,this._getCustomActionInsertIndex(e));return this};l.prototype.getCustomActions=function(){return this._aCustomShareActions.slice()};l.prototype.indexOfCustomAction=function(t){return this._aCustomShareActions.indexOf(t)};l.prototype.removeCustomAction=function(t){var e=this._callContainerAggregationMethod("removeButton",t);this._oObserver.unobserve(t,{properties:["visible"]});this._aCustomShareActions.splice(this._aCustomShareActions.indexOf(t),1);this._onControlRemoved();return e};l.prototype.removeAllCustomActions=function(){var t=[];this._aCustomShareActions.forEach(function(e){var o=this._callContainerAggregationMethod("removeButton",e);if(o){t.push(e)}},this);this._aCustomShareActions=[];this._onControlRemoved();return t};l.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(t){t.destroy()});return this};l.prototype.addContent=function(t){var e=this._getControl(t);if(this._aShareMenuActions.indexOf(t)<0){this._onControlAdded(e);this._oObserver.observe(e,{properties:["visible"]});this._aShareMenuActions.push(t)}this._preProcessOverflowToolbarButton(e);this._callContainerAggregationMethod("insertButton",e,this._getSemanticActionInsertIndex(t));return this};l.prototype.removeContent=function(t){var e=this._getControl(t);this._oObserver.unobserve(e,{properties:["visible"]});this._callContainerAggregationMethod("removeButton",e);this._aShareMenuActions.splice(this._aShareMenuActions.indexOf(t),1);this._postProcessOverflowToolbarButton(t);this._onControlRemoved();return this};l.prototype.destroy=function(){if(this._oShareMenuBtn){this._oShareMenuBtn.destroy()}this._oShareMenuBtn=null;this._aShareMenuActions=null;this._aCustomShareActions=null;return u.prototype.destroy.call(this)};l.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=null};l.prototype._getMode=function(){return this._mode};l.prototype._setMode=function(t){if(this._getMode()===t){return this}if(t===l._Mode.initial){if(this._getMode()){this._fireContentChanged(true)}this._mode=l._Mode.initial;return this}if(t===l._Mode.menu){this._mode=l._Mode.menu;this._fireContentChanged(false)}return this};l.prototype._fireContentChanged=function(t){e.prototype.fireEvent.call(this._getParent(),"_shareMenuContentChanged",{bEmpty:t})};l.prototype._onShareButtonClick=function(){var t=this._getContainer();t.openBy(this._oShareMenuBtn)};l.prototype._getVisibleActions=function(){var t=this._aShareMenuActions.concat(this._aCustomShareActions),e=t.map(function(t){return this._getControl(t)},this).filter(function(t){return t.getVisible()});return e};l.prototype._onShareMenuButtonChanges=function(){var t=this._getVisibleActions();this._getShareMenuButton().setVisible(t.length>1);this.fireEvent("_visibleActionsChanged",{visibleActionsCount:t.length})};l.prototype._getShareMenuButton=function(){var e,o,r;if(!this._oShareMenuBtn){e=this._getContainer();o=sap.ui.getCore().getLibraryResourceBundle("sap.f");r="SEMANTIC_CONTROL_ACTION_SHARE_SHORTCUT";if(n.os.macintosh){r+="_MAC"}this._oShareMenuBtn=new a(e.getId()+"-shareButton",{ariaHasPopup:_.Menu,icon:t.getIconURI("action"),tooltip:o.getText("SEMANTIC_CONTROL_ACTION_SHARE"),layoutData:new h({closeOverflowOnInteraction:false}),text:o.getText("SEMANTIC_CONTROL_ACTION_SHARE"),type:c.Transparent,press:this._onShareButtonClickRef});i.addConfig(this._oShareMenuBtn,{addAccessibilityLabel:true,message:o.getText(r)})}return this._oShareMenuBtn};l.prototype._getCustomActionInsertIndex=function(t){var e=this._aCustomShareActions.length;if(t===undefined){return this._aShareMenuActions.length+e}t=t>=e?e:t;t+=this._aShareMenuActions.length;return t};l.prototype._getSemanticActionInsertIndex=function(t){this._aShareMenuActions.sort(this._sortControlByOrder.bind(this));return this._aShareMenuActions.indexOf(t)};l.prototype._onControlAdded=function(t){if(this._isInitialMode()){this._setMode(l._Mode.menu,t)}};l.prototype._onControlRemoved=function(){var t=this._aShareMenuActions.length,e=this._aCustomShareActions.length,o=t+e===0;if(this._isMenuMode()&&o){this._setMode(l._Mode.initial)}};l.prototype._preProcessOverflowToolbarButton=function(t){if(t instanceof a){t._bInOverflow=true}};l.prototype._postProcessOverflowToolbarButton=function(t){if(t instanceof a){delete t._bInOverflow}};l.prototype._isInitialMode=function(){return this._getMode()===l._Mode.initial};l.prototype._isMenuMode=function(){return this._getMode()===l._Mode.menu};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticTitle", ["sap/m/library","./SemanticContainer"],function(t,n){"use strict";var i=t.ButtonType;var o=n.extend("sap.f.semantic.SemanticTitle",{constructor:function(t,i){n.call(this,t,i);this._iMainActionCount=0;this._aSemanticTextActions=[];this._aSemanticSimpleIconActions=[];this._aSemanticNavIconActions=[];this._aCustomTextActions=[];this._aCustomIconActions=[]}});o.mPlacementMethodMap={titleText:"TextContent",titleIcon:"IconContent",shareIcon:"ShareContent"};o.prototype.addContent=function(t,n){this["_insertSemantic"+o.mPlacementMethodMap[n]].call(this,t);return this};o.prototype.removeContent=function(t,n){this["_removeSemantic"+o.mPlacementMethodMap[n]].call(this,t);return this};o.prototype.destroy=function(){this._aSemanticSimpleIconActions=null;this._aSemanticTextActions=null;this._aCustomTextActions=null;this._aCustomIconActions=null;this._aSemanticNavIconActions=null;return n.prototype.destroy.call(this)};o.prototype.addCustomTextAction=function(t){t.setType(i.Transparent);this._callContainerAggregationMethod("insertAction",t,this._getCustomTextActionInsertIndex());this._aCustomTextActions.push(t);return this};o.prototype.insertCustomTextAction=function(t,n){t.setType(i.Transparent);this._callContainerAggregationMethod("insertAction",t,this._getCustomTextActionInsertIndex(n));this._aCustomTextActions.splice(n,0,t);return this};o.prototype.indexOfCustomTextAction=function(t){return this._aCustomTextActions.indexOf(t)};o.prototype.removeCustomTextAction=function(t){var n=this._aCustomTextActions.indexOf(t),i=this._callContainerAggregationMethod("removeAction",t);this._aCustomTextActions.splice(n,1);return i};o.prototype.removeAllCustomTextActions=function(){var t=[];this._aCustomTextActions.forEach(function(n){var i=this._callContainerAggregationMethod("removeAction",n);if(i){t.push(n)}},this);this._aCustomTextActions=[];return t};o.prototype.destroyCustomTextActions=function(){this.removeAllCustomTextActions().forEach(function(t){t.destroy()});return this};o.prototype.getCustomTextActions=function(){return this._aCustomTextActions.slice()};o.prototype.addCustomIconAction=function(t){t.setType(i.Transparent);this._callContainerAggregationMethod("insertAction",t,this._getCustomIconActionInsertIndex());this._aCustomIconActions.push(t);return this};o.prototype.insertCustomIconAction=function(t,n){t.setType(i.Transparent);this._callContainerAggregationMethod("insertAction",t,this._getCustomIconActionInsertIndex(n));this._aCustomIconActions.splice(n,0,t);return this};o.prototype.indexOfCustomIconAction=function(t){return this._aCustomIconActions.indexOf(t)};o.prototype.removeCustomIconAction=function(t){var n=this._aCustomIconActions.indexOf(t),i=this._callContainerAggregationMethod("removeAction",t);this._aCustomIconActions.splice(n,1);return i};o.prototype.removeAllCustomIconActions=function(){var t=[];this._aCustomIconActions.forEach(function(n){var i=this._callContainerAggregationMethod("removeAction",n);if(i){t.push(n)}},this);this._aCustomIconActions=[];return t};o.prototype.destroyCustomIconActions=function(){this.removeAllCustomIconActions().forEach(function(t){t.destroy()});return this};o.prototype.getCustomIconActions=function(){return this._aCustomIconActions.slice()};o.prototype._insertSemanticTextContent=function(t){var n=this._getControl(t),i=this._isMainAction(t),o;if(t._bIsSingleAction){n._bInOverflow=false}if(this._aSemanticTextActions.indexOf(t)<0){this._aSemanticTextActions.push(t)}if(i){this._iMainActionCount++;o=this._getSemanticTextMainActionInsertIndex()}else{o=this._getSemanticTextActionInsertIndex(t)}this._callContainerAggregationMethod("insertAction",n,o);return this};o.prototype._removeSemanticTextContent=function(t){var n=this._getControl(t),i=this._aSemanticTextActions.indexOf(t),o=this._isMainAction(t);if(o){this._iMainActionCount--}this._aSemanticTextActions.splice(i,1);this._callContainerAggregationMethod("removeAction",n);return this};o.prototype._insertSemanticIconContent=function(t){var n=this._getControl(t),i,o;if(t._bIsSingleAction){n._bInOverflow=false}if(this._isNavigationAction(t)){this._aSemanticNavIconActions.push(t);o=this._getSemanticNavIconActionInsertIndex(t);i="insertNavigationAction"}else{if(this._aSemanticSimpleIconActions.indexOf(t)<0){this._aSemanticSimpleIconActions.push(t)}o=this._getSemanticSimpleIconActionInsertIndex(t);i="insertAction"}this._callContainerAggregationMethod(i,n,o);return this};o.prototype._removeSemanticIconContent=function(t){var n=this._getControl(t),i,o;if(this._isNavigationAction(t)){o=this._aSemanticNavIconActions.indexOf(t);this._aSemanticNavIconActions.splice(o,1);i="removeNavigationAction"}else{o=this._aSemanticTextActions.indexOf(t);this._aSemanticSimpleIconActions.splice(o,1);i="removeAction"}this._callContainerAggregationMethod(i,n);return this};o.prototype._insertSemanticShareContent=function(t){var n=this._getControl(t),i=this._getSemanticShareMenuInsertIndex();this._callContainerAggregationMethod("insertAction",n,i);return this};o.prototype._removeSemanticShareContent=function(t){var n=this._getControl(t);this._callContainerAggregationMethod("removeAction",n);return this};o.prototype._getSemanticTextMainActionInsertIndex=function(){return 0};o.prototype._getCustomTextActionInsertIndex=function(t){var n=this._aCustomTextActions.length;if(t===undefined){return this._iMainActionCount+n}t=t>=n?n:t;t+=this._iMainActionCount;return t};o.prototype._getSemanticTextActionInsertIndex=function(t){this._aSemanticTextActions.sort(this._sortControlByOrder.bind(this));return this._getCustomTextActionInsertIndex()+this._aSemanticTextActions.indexOf(t)-this._iMainActionCount};o.prototype._getCustomIconActionInsertIndex=function(t){var n=this._aCustomIconActions.length,i=this._aCustomTextActions.length+this._aSemanticTextActions.length;if(t===undefined){return i+n}t=t>=n?n:t;t+=i;return t};o.prototype._getSemanticSimpleIconActionInsertIndex=function(t){this._aSemanticSimpleIconActions.sort(this._sortControlByOrder.bind(this));return this._getCustomIconActionInsertIndex()+this._aSemanticSimpleIconActions.indexOf(t)};o.prototype._getSemanticNavIconActionInsertIndex=function(t){this._aSemanticNavIconActions.sort(this._sortControlByOrder.bind(this));return this._aSemanticNavIconActions.indexOf(t)};o.prototype._getSemanticShareMenuInsertIndex=function(){return this._callContainerAggregationMethod("getActions").length};o.prototype._getContainerBar=function(){var t=this._getContainer();if(t){return t.getAggregation("_overflowToolbar")}return null};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SemanticToggleButton", ["sap/m/semantic/SemanticToggleButton","sap/f/semantic/SemanticConfiguration"],function(t,a){"use strict";var e=t.extend("sap.f.semantic.SemanticToggleButton",{metadata:{library:"sap.f",abstract:true}});e.prototype._getConfiguration=function(){return a.getConfiguration(this.getMetadata().getName())};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SendEmailAction", ["sap/f/semantic/SemanticButton"],function(a){"use strict";var t=a.extend("sap.f.semantic.SendEmailAction",{metadata:{library:"sap.f"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/SendMessageAction", ["sap/f/semantic/SemanticButton"],function(a){"use strict";var e=a.extend("sap.f.semantic.SendMessageAction",{metadata:{library:"sap.f"}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/ShareInJamAction", ["sap/f/semantic/SemanticButton"],function(a){"use strict";var t=a.extend("sap.f.semantic.ShareInJamAction",{metadata:{library:"sap.f"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/semantic/TitleMainAction", ["./MainAction"],function(a){"use strict";var i=a.extend("sap.f.semantic.TitleMainAction",{metadata:{library:"sap.f"}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/Accessibility", ["sap/ui/core/library","sap/ui/core/Core"],function(t,e){"use strict";var o=t.aria.HasPopup;var i=function(t){if(t){this._oControl=t;this._oControl.addDelegate(this._controlDelegate,false,this)}this.oRb=e.getLibraryResourceBundle("sap.f")};i.AriaHasPopup={MENU:o.Menu,PRODUCTS:o.Menu,PROFILE:o.Menu,NOTIFICATIONS:o.Dialog};i.prototype._controlDelegate={onBeforeRendering:function(){this.attachDelegates()}};i.prototype.attachDelegates=function(){var t=this._oControl.getProfile();this._oDelegateSecondTitle={onAfterRendering:this.onAfterRenderingSecondTitle};this._oDelegateSearch={onAfterRendering:this.onAfterRenderingSearch};this._oDelegateAvatar={onAfterRendering:this.onAfterRenderingAvatar};this._oDelegateProducts={onAfterRendering:this.onAfterRenderingProducts};this._oDelegateNavButton={onAfterRendering:this.onAfterRenderingNavButton};this._oDelegateMenuButton={onAfterRendering:this.onAfterRenderingMenuButton};if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.addDelegate(this._oDelegateSecondTitle,false,this)}if(this._oControl._oSearch){this._oControl._oSearch.addDelegate(this._oDelegateSearch,false,this)}if(t){t.addDelegate(this._oDelegateAvatar,false,this)}if(this._oControl._oProductSwitcher){this._oControl._oProductSwitcher.addDelegate(this._oDelegateProducts,false,this)}if(this._oControl._oNavButton){this._oControl._oNavButton.addDelegate(this._oDelegateNavButton,false,this)}if(this._oControl._oMenuButton){this._oControl._oMenuButton.addDelegate(this._oDelegateMenuButton,false,this)}};i.prototype.getRootAttributes=function(){return{role:"banner",label:this.oRb.getText("SHELLBAR_CONTAINER_LABEL")}};i.prototype.getCoPilotAttributes=function(){return{role:"button",label:this.oRb.getText("SHELLBAR_COPILOT_TOOLTIP")}};i.prototype.getEntityTooltip=function(t){return this.oRb.getText("SHELLBAR_"+t+"_TOOLTIP")||""};i.prototype.updateNotificationsNumber=function(t){var e=this.getEntityTooltip("NOTIFICATIONS"),o=t?t+" "+e:e;this._oControl._oNotifications.setTooltip(o)};i.prototype.onAfterRenderingSecondTitle=function(){var t=this._oControl._oSecondTitle.$();t.attr("role","heading");t.attr("aria-level","2")};i.prototype.onAfterRenderingSearch=function(){this._oControl._oSearch.$().attr("aria-label",this.getEntityTooltip("SEARCH"))};i.prototype.onAfterRenderingAvatar=function(){var t=this._oControl.getProfile().$();t.attr("aria-label",this.getEntityTooltip("PROFILE"));t.attr("aria-haspopup","menu")};i.prototype.onAfterRenderingProducts=function(){var t=this._oControl._oProductSwitcher.$();t.attr("aria-label",this.getEntityTooltip("PRODUCTS"))};i.prototype.onAfterRenderingNavButton=function(){this._oControl._oNavButton.$().attr("aria-label",this.getEntityTooltip("BACK"))};i.prototype.onAfterRenderingMenuButton=function(){var t=this._oControl._oMenuButton.$();t.attr("aria-label",this.getEntityTooltip("MENU"))};i.prototype.exit=function(){var t=this._oControl.getProfile();if(this._oControl){this._oControl.removeDelegate(this._controlDelegate)}if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.removeDelegate(this._oDelegateSecondTitle)}if(this._oControl._oSearch){this._oControl._oSearch.removeDelegate(this._oDelegateSearch)}if(t){t.removeDelegate(this._oDelegateAvatar)}if(this._oControl._oProductSwitcher){this._oControl._oProductSwitcher.removeDelegate(this._oDelegateProducts)}if(this._oControl._oNavButton){this._oControl._oNavButton.removeDelegate(this._oDelegateNavButton)}if(this._oControl._oMenuButton){this._oControl._oMenuButton.removeDelegate(this._oDelegateMenuButton)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/AdditionalContentSupport", ["sap/m/OverflowToolbarLayoutData","sap/base/Log","sap/m/library"],function(t,n,i){"use strict";var e=i.OverflowToolbarPriority;var a=function(){if(!this.isA("sap.ui.core.Element")){return}this._prepareNewAdditionalControl=function(n){if(!n.getLayoutData()){n.setLayoutData(new t({priority:e.Low}))}return n};this.addAdditionalContent=function(t){this.validateAggregation("additionalContent",t,true);if(this.indexOfAdditionalContent(t)!==-1){n.warning("Object"+t+" is already added to ShellBar");return this}this._aAdditionalContent.push(this._prepareNewAdditionalControl(t));this._updateParent();return this};this.insertAdditionalContent=function(t,i){this.validateAggregation("additionalContent",t,true);if(this.indexOfAdditionalContent(t)!==-1){n.warning("Object"+t+" is already added to ShellBar");return this}this._aAdditionalContent.splice(i,0,t);this._updateParent();return this};this.indexOfAdditionalContent=function(t){for(var n=0;n<this._aAdditionalContent.length;n++){if(this._aAdditionalContent[n]===t){return n}}return-1};this.removeAdditionalContent=function(t){var i,e,a=t;if(typeof a==="string"){for(e=0;e<this._aAdditionalContent.length;e++){if(this._aAdditionalContent[e]&&this._aAdditionalContent[e].getId()===a){a=e;break}else if(e===this._aAdditionalContent.length-1){a=-1}}}if(typeof a==="object"){for(e=0;e<this._aAdditionalContent.length;e++){if(this._aAdditionalContent[e]===a){a=e;break}else if(e===this._aAdditionalContent.length-1){a=-1}}}if(typeof a==="number"){if(a<0||a>=this._aAdditionalContent.length){n.warning("ShellBar.removeAggregation AdditionalContent called with invalid parameter for "+"non-existing object:, "+t);return null}else{i=this._aAdditionalContent[a];this._aAdditionalContent.splice(a,1);i.setParent(null);this._updateParent();return i}}else{return null}};this.removeAllAdditionalContent=function(){var t,n=this._aAdditionalContent,i;if(!n){return[]}this._aAdditionalContent=[];for(i=0;i<n.length;i++){t=n[i];t.setParent(null)}this._updateParent();return n};this.destroyAdditionalContent=function(){this._aAdditionalContent.forEach(this._destroyAllAdditionalContent,this);this._aAdditionalContent=[];this._updateParent();return this};this._destroyAllAdditionalContent=function(t){return t.destroy()};this.getAdditionalContent=function(){return this._aAdditionalContent};this._updateParent=function(){this._bOTBUpdateNeeded=true;this.invalidate()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/CoPilot", ["sap/ui/core/Control","sap/ui/core/Configuration","sap/f/shellBar/CoPilotRenderer"],function(e,t,n){"use strict";var r=e.extend("sap.f.shellBar.CoPilot",{metadata:{library:"sap.f",events:{press:{}}},renderer:n});r.prototype.ontap=function(e){e.setMarked();this.firePress({})};r.prototype.getAnimation=function(){return t.getAnimationMode()!==t.AnimationMode.none};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/CoPilotRenderer", ["sap/base/security/encodeXML","./Accessibility"],function(e,t){"use strict";var a={apiVersion:2};a.render=function(a,r){var i=new t,s=i.getCoPilotAttributes(),o=r.getTooltip_AsString(),l="";a.openStart("div",r);a.attr("tabindex","0");if(o){a.attr("title",o);l=' alt="'+e(o)+'"'}a.accessibilityState({role:s.role,label:s.label});a.class("CPImage");a.openEnd();if(r.getAnimation()){a.unsafeHtml('<svg focusable="false"'+l+' role="presentation" version="1.1" width="48" height="48" viewBox="-150 -150 300 300"><defs><linearGradient id="grad1" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1 opacity7" offset="0%"/><stop class="color2 opacity7" offset="80%"/></linearGradient><linearGradient id="grad2" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1 opacity36" offset="0%"/><stop class="color2 opacity36" offset="80%"/></linearGradient><linearGradient id="grad3" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1 opacity2" offset="0%"/><stop class="color2 opacity2" offset="80%"/></linearGradient><mask id="innerCircle"><circle cx="0" cy="0" r="120" fill="white" /><circle cx="0" cy="0" r="76" fill="black" /></mask><path id="path" d="M 102 0 C 102 17.85 86.87 29.53 77.94 44.99 C 69.01 60.46 66.46 79.4 51 88.33 C 35.53 97.26 17.85 90 5.51000e-15 90 C -17.85 90 -35.53 97.26 -50.99 88.33 C -66.46 79.4 -69.01 60.46 -77.94 45 C -86.87 29.53 -102 17.85 -102 1.24000e-14 C -102 -17.85 -86.87 -29.53 -77.94 -44.99 C -69.01 -60.46 -66.46 -79.4 -51 -88.33 C -35.53 -97.26 -17.85 -89.99 -1.65000e-14 -90 C 17.85 -90 35.53 -97.26 50.99 -88.33 C 66.46 -79.4 69.01 -60.46 77.94 -45 C 86.87 -29.53 102 -17.85 102 0 Z M 97.27 0 C 98.58 17.55 94.29 34.2 84.09 48.54 C 74.21 62.42 58.47 67.23 43.57 75.46 C 28.94 83.54 16.64 93.54 5.81000e-15 95 C -17.27 96.5 -33.78 93.13 -48.19 83.47 C -62.26 74.04 -68.01 58.82 -76.14 43.96 C -84.09 29.4 -92 16.48 -93.8 1.14000e-14 C -95.7 -17.53 -94.76 -34.35 -86.34 -49.84 C -77.83 -65.5 -64.53 -76.31 -48.31 -83.67 C -32.81 -90.7 -17 -88.78 -1.63000e-14 -89 C 17.21 -89.21 34.09 -93.47 49 -84.87 C 63.91 -76.28 68.61 -59.49 77.12 -44.53 C 85.58 -29.66 95.99 -17.05 97.27 0 Z" dur="30s" repeatCount="indefinite"><animateTransform attributeName="transform" type="scale" values="1;1.05;1.05;1.02;1" dur="0.15s" begin="click_area.mousedown" repeatCount="1" additive="sum"/></path></defs><g mask="url(#innerCircle)"><g fill="url(#grad3)" transform="rotate(54)"><use href="#path"><animateTransform id="animate1" attributeName="transform" type="rotate" from="54" to="416" dur="15s" repeatCount="indefinite"/></use></g><g fill="url(#grad2)" transform="rotate(74)"><use href="#path" /></g><g fill="url(#grad1)" transform="rotate(90)"><use href="#path"><animateTransform id="animate2" attributeName="transform" type="rotate" from="90" to="450" dur="30s" repeatCount="indefinite"/></use></g></g><circle cx="0" cy="0" r="76" fill="transparent" id="click_area"/></svg>')}else{a.unsafeHtml('<svg focusable="false"'+l+' role="presentation" version="1.1" width="48" height="48" viewBox="-150 -150 300 300"><defs><linearGradient id="grad1" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1 opacity7" offset="0%"/><stop class="color2 opacity7" offset="80%"/></linearGradient><linearGradient id="grad2" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1 opacity36" offset="0%"/><stop class="color2 opacity36" offset="80%"/></linearGradient><linearGradient id="grad3" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1 opacity2" offset="0%"/><stop class="color2 opacity2" offset="80%"/></linearGradient><mask id="innerCircle"><circle cx="0" cy="0" r="120" fill="white" /><circle cx="0" cy="0" r="76" fill="black" /></mask><path id="path" d="M 98.1584 0 C 98.3156 17.3952 89.0511 31.3348 79.5494 45.9279 C 70.339 60.0814 60.6163 71.2177 46.1724 79.9729 C 31.4266 88.9178 17.2493 94.3909 5.77261e-15 94.2739 C -17.1547 94.1581 -30.8225 87.6907 -45.7979 79.3244 C -61.0143 70.8266 -73.5583 62.554 -83.0507 47.9493 C -92.6677 33.1579 -98.4872 17.5705 -97.1793 1.19010e-14 C -95.9465 -16.9777 -84.488 -29.0862 -76.1351 -43.9566 C -67.6795 -59.0155 -63.8629 -76.1085 -49.262 -85.3243 C -34.502 -94.6464 -17.4328 -93.0037 -1.69174e-14 -92.0939 C 16.8967 -91.214 31.8608 -89.0341 46.4198 -80.4014 C 60.872 -71.8326 69.6003 -59.5351 78.6792 -45.4254 C 88.0511 -30.9104 98.015 -17.2766 98.1584 0 Z"/></defs><g mask="url(#innerCircle)"><g fill="url(#grad3)" transform="rotate(54)"><use href="#path"/></g><g fill="url(#grad2)" transform="rotate(74)"><use href="#path" /></g><g fill="url(#grad1)" transform="rotate(90)"><use href="#path"/></g></g><circle cx="0" cy="0" r="76" fill="transparent" id="click_area"/></svg>')}a.close("div")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/ControlSpacer", ["sap/ui/core/Control","sap/f/shellBar/ControlSpacerRenderer"],function(e,r){"use strict";var t=e.extend("sap.f.shellBar.ControlSpacer",{metadata:{library:"sap.f",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""}}},renderer:r});t.prototype.setWidth=function(e){if(this.$().length){this.$().width(e)}return this.setProperty("width",e,true)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/ControlSpacerRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){e.openStart("div",t);e.class("sapMTBSpacer");e.style("width",t.getWidth());e.openEnd().close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/Factory", ["sap/m/Title","sap/m/Image","sap/m/MenuButton","sap/m/OverflowToolbar","sap/m/OverflowToolbarButton","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","sap/m/FlexItemData","./Accessibility","sap/m/library","sap/ui/core/library","sap/m/HBox"],function(t,o,e,n,i,s,r,a,l,p,c,h){"use strict";var u=p.OverflowToolbarPriority;var C=p.ToolbarDesign;var d=p.ButtonType;var _=c.TitleLevel;var f=function(t){this._oContext=t;this._oControls={};this._oAcc=new l};f.prototype.getOverflowToolbar=function(){var t=this._oAcc;if(!this._oControls.oOverflowToolbar){this._oControls.oOverflowToolbar=new n({design:C.Transparent,style:"Clear"}).addStyleClass("sapFShellBarOTB").setLayoutData(new a({growFactor:1,shrinkFactor:1,minWidth:"0px",maxWidth:"100%"}))._setEnableAccessibilty(false);this._oControls.oOverflowToolbar._getOverflowButton().addStyleClass("sapFShellBarItem sapFShellBarOverflowButton")}this._oControls.oOverflowToolbar._getOverflowButton()._updateBadgeInvisibleText=function(o){this._getBadgeInvisibleText().setText(o+t.getEntityTooltip("NOTIFICATIONS"))};return this._oControls.oOverflowToolbar};f.prototype.getAdditionalBox=function(){if(!this._oControls.oAdditionalBox){this._oControls.oAdditionalBox=new h({alignItems:"Center"}).addStyleClass("sapFShellBarOAHB")}return this._oControls.oAdditionalBox};f.prototype.getToolbarSpacer=function(){if(!this._oControls.oToolbarSpacer){this._oControls.oToolbarSpacer=new s}return this._oControls.oToolbarSpacer};f.prototype.getSecondTitle=function(){if(!this._oControls.oSecondTitle){this._oControls.oSecondTitle=new t({titleStyle:_.H6}).addStyleClass("sapFShellBarSecondTitle").setLayoutData(new a({shrinkFactor:2,minWidth:"1px"}))}return this._oControls.oSecondTitle};f.prototype.getHomeIcon=function(){if(!this._oControls.oHomeIcon){this._oControls.oHomeIcon=new o({densityAware:false,tooltip:this._oAcc.getEntityTooltip("LOGO"),press:function(){this._oContext.fireEvent("homeIconPressed",{icon:this._oControls.oHomeIcon})}.bind(this)}).addStyleClass("sapFShellBarHomeIcon")}return this._oControls.oHomeIcon};f.prototype.getMegaMenu=function(){if(!this._oControls.oMegaMenu){this._oControls.oMegaMenu=new e({type:d.Transparent,iconDensityAware:false,layoutData:new a({shrinkFactor:0,minWidth:"0px",maxWidth:"100%"})}).addStyleClass("sapFSHMegaMenu")}return this._oControls.oMegaMenu};f.prototype.getPrimaryTitle=function(){if(!this._oControls.oPrimaryTitle){this._oControls.oPrimaryTitle=new t({titleStyle:_.H6,level:_.H1}).setLayoutData(new a({shrinkFactor:0,minWidth:"0px",maxWidth:"100%"})).addStyleClass("sapFShellBarPrimaryTitle")}return this._oControls.oPrimaryTitle};f.prototype.getCopilot=function(){if(!this._oControls.oCopilot){this._oControls.oCopilot=new i({tooltip:this._oAcc.getEntityTooltip("COPILOT"),text:this._oAcc.getEntityTooltip("COPILOT"),icon:"sap-icon://da",type:d.Transparent,press:function(t){var o=t.getSource();o.getIcon()==="sap-icon://da"?o.setIcon("sap-icon://da-2"):o.setIcon("sap-icon://da");this._oContext.fireEvent("copilotPressed",{image:null,button:this._oControls.oCopilot})}.bind(this)}).setLayoutData(new r({priority:u.Low}))}return this._oControls.oCopilot};f.prototype.getSearch=function(){if(!this._oControls.oSearch){this._oControls.oSearch=new i({text:this._oAcc.getEntityTooltip("SEARCH"),icon:"sap-icon://search",type:d.Transparent,tooltip:this._oAcc.getEntityTooltip("SEARCH"),press:function(){this._oContext.fireEvent("searchButtonPressed",{button:this._oControls.oSearch})}.bind(this)}).setLayoutData(new r({priority:u.Low}))}return this._oControls.oSearch};f.prototype.getManagedSearch=function(){if(!this._oControls.oManagedSearch){this._oControls.oManagedSearch=this._oContext.getSearchManager()._oSearch}return this._oControls.oManagedSearch};f.prototype.getNavButton=function(){if(!this._oControls.oNavButton){this._oControls.oNavButton=new i({icon:"sap-icon://nav-back",type:d.Transparent,tooltip:this._oAcc.getEntityTooltip("BACK"),press:function(){this._oContext.fireEvent("navButtonPressed",{button:this._oControls.oNavButton})}.bind(this)})}return this._oControls.oNavButton};f.prototype.getMenuButton=function(){if(!this._oControls.oMenuButton){this._oControls.oMenuButton=new i({ariaHasPopup:l.AriaHasPopup.MENU,icon:"sap-icon://menu2",type:d.Transparent,tooltip:this._oAcc.getEntityTooltip("MENU"),press:function(){this._oContext.fireEvent("menuButtonPressed",{button:this._oControls.oMenuButton})}.bind(this)})}return this._oControls.oMenuButton};f.prototype.getNotifications=function(){var t=this._oAcc;if(!this._oControls.oNotifications){this._oControls.oNotifications=new i({ariaHasPopup:l.AriaHasPopup.NOTIFICATIONS,text:t.getEntityTooltip("NOTIFICATIONS"),icon:"sap-icon://bell",type:d.Transparent,tooltip:t.getEntityTooltip("NOTIFICATIONS"),press:function(){this._oContext.fireEvent("notificationsPressed",{button:this._oControls.oNotifications})}.bind(this)}).addStyleClass("sapFButtonNotifications").setLayoutData(new r({priority:u.Low}));this._oControls.oNotifications._updateBadgeInvisibleText=function(o){this._getBadgeInvisibleText().setText(o+t.getEntityTooltip("NOTIFICATIONS"))}}return this._oControls.oNotifications};f.prototype.getProductSwitcher=function(){if(!this._oControls.oProductSwitcher){this._oControls.oProductSwitcher=new i({ariaHasPopup:l.AriaHasPopup.PRODUCTS,text:"My products",icon:"sap-icon://grid",type:d.Transparent,tooltip:this._oAcc.getEntityTooltip("PRODUCTS"),press:function(){this._oContext.fireEvent("productSwitcherPressed",{button:this._oControls.oProductSwitcher})}.bind(this)}).addStyleClass("sapFShellBarGridButton").addStyleClass("sapFShellBarItem")}return this._oControls.oProductSwitcher};f.prototype.destroy=function(){Object.keys(this._oControls).forEach(function(t){var o=this._oControls[t];if(o){o.destroy()}}.bind(this))};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/ResponsiveHandler", ["sap/m/OverflowToolbarLayoutData","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/dom/units/Rem","sap/m/library"],function(t,o,e,a,r){"use strict";var n=r.OverflowToolbarPriority;var i=12;var s=function(t){this._oControl=t;this._oDelegate={onAfterRendering:this.onAfterRendering,onBeforeRendering:this.onBeforeRendering};this._oControl.addDelegate(this._oDelegate,false,this);this.sCurrentRange="";this._bAttachedManagedSearchHandler=false;this._oControl._iResizeHandlerId=e.register(this._oControl,this._handleResize.bind(this));this._iMinSearchWidth=a.toPx(i)};s.prototype.onAfterRendering=function(){var t=o.media.getCurrentRange(this._oControl._sRangeSet,this._oControl.$().outerWidth(true)).name==="Phone";this._oButton=this._oControl._oMegaMenu&&this._oControl._oMegaMenu.getAggregation("_button");this._oDomRef=this._oControl.getDomRef();this.bIsMegaMenuConfigured=this._oControl._oTitleControl&&this._oControl._oTitleControl===this._oControl._oMegaMenu;if(this._oControl._oManagedSearch&&!this._bAttachedManagedSearchHandler){this._oControl._oManagedSearch.attachEvent("_updateVisualState",this._switchOpenStateOnSearch,this);this._bAttachedManagedSearchHandler=true}if(t){this._transformTitleControlMobile()}this._handleResize()};s.prototype.exit=function(){if(this._oControl._iResizeHandlerId){e.deregister(this._oControl._iResizeHandlerId);this._oControl._iResizeHandlerId=null}};s.prototype._handleResize=function(){if(!this._oDomRef){return}var t=this._oControl.$(),e=t.outerWidth(),a=o.media.getCurrentRange(this._oControl._sRangeSet,e),r;if(this.sCurrentRange!==a.name){this._oControl._bOTBUpdateNeeded=true;this.sCurrentRange=a.name;this._oControl._oManagedSearch&&this._oControl._oManagedSearch._setMedia(this.sCurrentRange)}if(a){r=this.sCurrentRange==="Phone";t.toggleClass("sapFShellBarSizeExtraLargeDesktop",this.sCurrentRange==="ExtraLargeDesktop");t.toggleClass("sapFShellBarSizeLargeDesktop",this.sCurrentRange==="LargeDesktop");t.toggleClass("sapFShellBarSizeDesktop",this.sCurrentRange==="Desktop");t.toggleClass("sapFShellBarSizeTablet",this.sCurrentRange==="Tablet");t.toggleClass("sapFShellBarSizePhone",r)}if(this._oControl._oManagedSearch&&!this._oControl._oManagedSearch.getIsOpen()){this._oControl._bSearchPlaceHolder=false}if(this.sCurrentRange==="ExtraLargeDesktop"){this._oControl._oManagedSearch&&this._oControl._oManagedSearch.setIsOpen(true);setTimeout(this._adaptSearch.bind(this),100)}if(this.sCurrentRange!=="ExtraLargeDesktop"&&this._oControl._oManagedSearch&&this._oControl._oManagedSearch.getIsOpen()){if(!this._oControl._oManagedSearch._bUserOpened){this._oControl._oManagedSearch.setIsOpen(false)}else{setTimeout(this._adaptSearch.bind(this),100)}}this._oControl._bOTBUpdateNeeded&&this._oControl.invalidate();if(this._iPreviousWidth===e){return}this._iPreviousWidth=e;if(!this._oControl._oNavButton&&!this._oControl._oMenuButton&&!this._oControl._oHomeIcon&&!this._oControl._oMegaMenu&&!this._oControl._oSecondTitle&&!this._oControl._oManagedSearch&&!this._oControl._oCopilot){return}if(r&&!this.bWasInPhoneRange){this._transformToPhoneState()}else if(!r&&this.bWasInPhoneRange){this._transformToRegularState()}};s.prototype._switchOpenStateOnSearch=function(){var t=this._oControl._oManagedSearch;if(!t){return}if(this.bWasInPhoneRange){this._transformToPhoneState()}else{this._transformToRegularState()}this._oControl.toggleStyleClass("sapFShellBarSearchIsOpen",t.getIsOpen())};s.prototype._transformToPhoneState=function(){var o=this._oControl._oManagedSearch,e=this._oControl._getOverflowToolbar().getContent(),a=this._oControl._oToolbarSpacer;if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(false)}this._transformTitleControlMobile();if(!this._bControlsLayoutDataCached){this._cacheControlsLayoutData();this._bControlsLayoutDataCached=true}e.forEach(function(o){if(o===a){return}o.setLayoutData(new t({priority:n.AlwaysOverflow}))});this.bWasInPhoneRange=true;if(o){o.setPhoneMode(true);if(o.getIsOpen()){this._toggleAllControlsExceptSearch(true);this._bSearchWasOpen=true}else if(this._bSearchWasOpen){this._toggleAllControlsExceptSearch(false);this._bSearchWasOpen=false}}this._oControl.invalidate()};s.prototype._transformToRegularState=function(){var t=this._oControl._oManagedSearch;this._toggleAllControlsExceptSearch(false);if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(true)}if(this._oControl._oHomeIcon){if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setText(this._oControl._sTitle).setIcon("")}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setText(this._oControl._sTitle)}if(this.bIsMegaMenuConfigured){this._oControl._oHomeIcon.setVisible(true)}}if(this._bControlsLayoutDataCached){this._restoreControlsLayoutData();this._bControlsLayoutDataCached=false}this.bWasInPhoneRange=false;if(t){t.setPhoneMode(false);this._oControl._bSearchPlaceHolder=false}this._oControl.invalidate()};s.prototype._transformTitleControlMobile=function(){var t;if(!this._oControl._oHomeIcon){return this.bIsMegaMenuConfigured?this._oControl._oMegaMenu.setText(this._oControl.getTitle()).setIcon(""):false}t=this.bIsMegaMenuConfigured&&this._oControl._oHomeIcon.getVisible()||!this.bIsMegaMenuConfigured&&!this._oControl._oHomeIcon.getVisible();if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setText("").setIcon(this._oControl.getHomeIcon())}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setText("")}if(t){this._oControl._oHomeIcon.setVisible(!this.bIsMegaMenuConfigured);this._oControl.invalidate()}};s.prototype._adaptSearch=function(){var t=this._oControl._oManagedSearch,o;if(!t||this.sCurrentRange==="Phone"){return}o=t.$().width();if(this._oControl._bSearchPlaceHolder){if(o>=this._iMinSearchWidth){this._oControl._bSearchPlaceHolder=false;this._toggleAllControlsExceptSearch(false)}}else if(o<this._iMinSearchWidth){this._oControl._bSearchPlaceHolder=true;this._toggleAllControlsExceptSearch(true)}else if(t.hasStyleClass("sapFShellBarSearchOpenTick")){t.removeStyleClass("sapFShellBarSearchOpenTick");this._adaptSearch()}return this};s.prototype._toggleAllControlsExceptSearch=function(t){var o=this._oControl._oManagedSearch;this._oControl.toggleStyleClass("sapFShellBarFullSearch",t);o&&o.toggleStyleClass("sapFShellBarSearchFullWidth",t)};s.prototype._cacheControlsLayoutData=function(){var t=this._oControl._getOverflowToolbar().getContent();this._oCachedLayoutData={};t.forEach(function(t){this._oCachedLayoutData[t.getId()]=t.getLayoutData()},this)};s.prototype._restoreControlsLayoutData=function(){var t=this._oControl._getOverflowToolbar().getContent();t.forEach(function(t){var o=this._oCachedLayoutData[t.getId()];if(o){t.setLayoutData(o)}},this)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/Search", ["sap/ui/core/Control","sap/f/shellBar/SearchRenderer","sap/m/SearchField","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","sap/m/Button","sap/ui/events/KeyCodes","./Accessibility","sap/m/library"],function(e,t,s,r,o,a,i,n,l){"use strict";var h=l.ButtonType;var u=l.OverflowToolbarPriority;var p=e.extend("sap.f.shellBar.Search",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.f",properties:{isOpen:{type:"boolean",defaultValue:false},phoneMode:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_searchField:{type:"sap.m.SearchField",multiple:false},_searchButton:{type:"sap.m.OverflowToolbarButton",multiple:false},_cancelButton:{type:"sap.m.Button",multiple:false}},events:{search:{parameters:{query:{type:"string"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},renderer:t});p.prototype.init=function(){this._sOldValue="";this._shouldFocusSearch=false;this._layoutDataWhenOpen=new o({priority:u.NeverOverflow});this._layoutDataWhenClosed=new o({priority:u.Low});this._layoutDataPhoneWhenClosed=new o({priority:u.AlwaysOverflow});this._oAcc=new n;this._bUserOpened=false};p.prototype.onBeforeRendering=function(){this._switchOpenStateOnSearch()};p.prototype.onAfterRendering=function(){setTimeout(function(){if(this._shouldFocusSearch){this._getSearchField().getFocusDomRef().focus();this._shouldFocusSearch=false}}.bind(this),0)};p.prototype.exit=function(){if(this._layoutDataWhenOpen){this._layoutDataWhenOpen.destroy()}if(this._layoutDataWhenClosed){this._layoutDataWhenClosed.destroy()}};p.prototype._getSearchField=function(){var e=this.getAggregation("_searchField");if(!e){e=new s({showSearchButton:false,search:this._onSearch.bind(this),liveChange:this._onLiveChange.bind(this),suggest:this._onSuggest.bind(this)});this.setAggregation("_searchField",e)}return e};p.prototype._getSearchButton=function(){var e=this.getAggregation("_searchButton");if(!e){e=new r({text:"Search",icon:"sap-icon://search",type:h.Transparent,press:this._onPressSearchButtonHandler.bind(this),tooltip:this._oAcc.getEntityTooltip("SEARCH")});this.setAggregation("_searchButton",e)}return e};p.prototype._getCancelButton=function(){var e=this.getAggregation("_cancelButton");if(!e){e=new a({text:"Cancel",type:h.Transparent,press:this._onPressCancelButtonHandler.bind(this)});e.addStyleClass("sapFShellBarSearchCancelButton");this.setAggregation("_cancelButton",e)}return e};p.prototype.toggleVisibilityOfSearchField=function(){var e=this.getIsOpen();this.setIsOpen(!e);this._shouldFocusSearch=!e;this.fireEvent("_updateVisualState",{isOpen:!e})};p.prototype._switchOpenStateOnSearch=function(){var e;if(this.getIsOpen()){e=this._layoutDataWhenOpen}else if(!this._bInOverflow&&!this.getPhoneMode()){e=this._layoutDataWhenClosed}else if(this.getPhoneMode()){e=this._layoutDataPhoneWhenClosed}if(!e||this.getLayoutData()===e){return}this.toggleStyleClass("sapFShellBarSearchOpenTick",this.getIsOpen());this.setLayoutData(e)};p.prototype._onPressSearchButtonHandler=function(){var e=this._getSearchField();if(e.getValue()&&this.getIsOpen()){this.fireSearch({query:e.getValue(),clearButtonPressed:false})}if(this.sCurrentRange==="ExtraLargeDesktop"){return}this.toggleVisibilityOfSearchField();this._bUserOpened=!this._bUserOpened};p.prototype._setMedia=function(e){this.sCurrentRange=e};p.prototype._onPressCancelButtonHandler=function(){this._bUserOpened=false;this.toggleVisibilityOfSearchField()};p.prototype._onSearch=function(e){var t=e.getParameters();t.id=this.getId();if(e.getParameter("clearButtonPressed")){this._shouldCloseOnNextEscape=false}this.fireSearch(t)};p.prototype._onLiveChange=function(e){var t=e.getParameters();delete t.refreshButtonPressed;delete t.suggestionItem;t.id=this.getId();this._shouldCloseOnNextEscape=!t.newValue;this.fireLiveChange(t)};p.prototype._onSuggest=function(e){var t=e.getParameters();t.id=this.getId();this.fireSuggest(t)};p.prototype.onkeyup=function(e){var t=this._getSearchField();if(e.keyCode===i.ESCAPE){if(t._oSuggest&&t._oSuggest.isOpen()){return}if(this._shouldCloseOnNextEscape){this._shouldCloseOnNextEscape=false;return}this.toggleVisibilityOfSearchField()}};p.prototype._onBeforeEnterOverflow=function(){var e=this._getSearchButton();this._bInOverflow=true;e._bInOverflow=true;e.addStyleClass("sapFShellBarSearchOverflowToolbar");this._switchOpenStateOnSearch()};p.prototype._onAfterExitOverflow=function(){var e=this._getSearchButton();this._bInOverflow=false;e._bInOverflow=false;e.removeStyleClass("sapFShellBarSearchOverflowToolbar")};p.prototype.getOverflowToolbarConfig=function(){var e={canOverflow:true};e.onBeforeEnterOverflow=this._onBeforeEnterOverflow.bind(this);e.onAfterExitOverflow=this._onAfterExitOverflow.bind(this);return e};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/f/shellBar/SearchRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,r){var n=r._getSearchField(),t=r._getCancelButton(),a=r._getSearchButton(),o=r.getIsOpen(),l=r.getPhoneMode();e.openStart("div",r);if(o){e.class("sapFShellBarSearch")}if(l){e.class("sapFShellBarSearchFullWidth")}e.openEnd();e.openStart("div");e.class("sapFShellBarSearchWrap");e.openEnd();if(o){e.renderControl(n)}e.renderControl(a);if(o){e.renderControl(t)}e.close("div");e.close("div")};return e},true);
sap.ui.require.preload({
	"sap/f/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.f","type":"library","embeds":[],"applicationVersion":{"version":"1.120.22"},"title":"SAPUI5 library with Fiori controls.","description":"SAPUI5 library with Fiori controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.22"},"sap.ui.layout":{"minVersion":"1.120.22"},"sap.m":{"minVersion":"1.120.22"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.f.Avatar","sap.f.AvatarGroup","sap.f.AvatarGroupItem","sap.f.cards.Header","sap.f.cards.NumericHeader","sap.f.cards.NumericIndicators","sap.f.cards.NumericSideIndicator","sap.f.CalendarInCard","sap.f.Card","sap.f.GridContainer","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.IllustratedMessage","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage","sap.f.GridList","sap.f.GridListItem","sap.f.PlanningCalendarInCardLegend","sap.f.ProductSwitch","sap.f.ProductSwitchItem","sap.f.ShellBar","sap.f.SidePanel","sap.f.Illustration"],"elements":["sap.f.DynamicPageAccessibleLandmarkInfo","sap.f.GridContainerItemLayoutData","sap.f.FlexibleColumnLayoutAccessibleLandmarkInfo","sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.EditAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MainAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction","sap.f.SearchManager","sap.f.SidePanelItem"],"types":["sap.f.AvatarImageFitType","sap.f.AvatarShape","sap.f.AvatarSize","sap.f.AvatarType","sap.f.AvatarColor","sap.f.AvatarGroupType","sap.f.cards.HeaderPosition","sap.f.cards.NumericHeaderSideIndicatorsAlignment","sap.f.DynamicPageTitleArea","sap.f.DynamicPageTitleShrinkRatio","sap.f.IllustratedMessageSize","sap.f.IllustratedMessageType","sap.f.LayoutType"],"interfaces":["sap.f.cards.IHeader","sap.f.ICard","sap.f.IShellBar","sap.f.IDynamicPageStickyContent","sap.f.dnd.IGridDroppable"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
