/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Bar","./Button","./InstanceManager","./library","./Title","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/theming/Parameters","sap/ui/Device","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/core/library","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/core/StaticArea","./PopoverRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/dom/getScrollbarSize","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Configuration","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(e,t,o,i,r,n,s,a,l,h,f,p,g,c,u,d,_,jQuery,m,v,P,y){"use strict";var C=i.PopupHelper;var w=p.OpenState;var O=i.PlacementType;var B=i.TitleAlignment;var H=l.get({name:"_sap_m_Popover_ArrowOffset",callback:function(e){H=parseFloat(e)}});var b=n.extend("sap.m.Popover",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Behavior",defaultValue:O.Right},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},title:{type:"string",group:"Appearance",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},offsetX:{type:"int",group:"Appearance",defaultValue:0},offsetY:{type:"int",group:"Appearance",defaultValue:0},showArrow:{type:"boolean",group:"Appearance",defaultValue:true},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentMinWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enableScrolling:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},horizontalScrolling:{type:"boolean",group:"Misc",defaultValue:true},bounce:{type:"boolean",group:"Behavior",defaultValue:null,deprecated:true},resizable:{type:"boolean",group:"Dimension",defaultValue:false},ariaModal:{type:"boolean",group:"Misc",defaultValue:true,visibility:"hidden"},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:B.Auto},ariaRoleApplication:{type:"boolean",group:"Misc",defaultValue:false,visibility:"hidden"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.ui.core.Control",multiple:false},subHeader:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},beginButton:{type:"sap.ui.core.Control",multiple:false},endButton:{type:"sap.ui.core.Control",multiple:false}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}}},designtime:"sap/m/designtime/Popover.designtime"},renderer:d});b._bIOS7=h.os.ios&&h.os.version>=7&&h.os.version<8&&h.browser.name==="sf";f.call(b.prototype,{header:{suffix:"intHeader"},subHeader:{selector:".sapMPopoverSubHeader .sapMIBar"},content:{suffix:"cont"},footer:{selector:".sapMPopoverFooter .sapMIBar"}});b.prototype.init=function(){this._marginTopInit=false;this._marginTop=48;this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._minDimensions={width:100,height:32};this._initialWindowDimensions={};this.oPopup=new s;this.oPopup.setShadow(true);this.oPopup.setAutoClose(true);this.oPopup.setAnimations(jQuery.proxy(this._openAnimation,this),jQuery.proxy(this._closeAnimation,this));this._placements=[O.Top,O.Right,O.Bottom,O.Left,O.Vertical,O.Horizontal,O.Auto,O.VerticalPreferedTop,O.VerticalPreferedBottom,O.HorizontalPreferedLeft,O.HorizontalPreferedRight,O.VerticalPreferredTop,O.VerticalPreferredBottom,O.HorizontalPreferredLeft,O.HorizontalPreferredRight,O.PreferredRightOrFlip,O.PreferredLeftOrFlip,O.PreferredTopOrFlip,O.PreferredBottomOrFlip];this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"];this._offsets=["0 -18","18 0","0 18","-18 0"];this._arrowOffset=18;this._followOfTolerance=32;this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer"];this._fnAdjustPositionAndArrow=jQuery.proxy(this._adjustPositionAndArrow,this);this._fnOrientationChange=jQuery.proxy(this._onOrientationChange,this);this._fnFollowOf=jQuery.proxy(function(e){var t=e.lastOfRect,o=e.currentOfRect;if(!h.system.desktop||Math.abs(t.top-o.top)<=this._followOfTolerance&&Math.abs(t.left-o.left)<=this._followOfTolerance||Math.abs(t.top+t.height-o.top-o.height)<=this._followOfTolerance&&Math.abs(t.left+t.width-o.left-o.width)<=this._followOfTolerance){this.oPopup._applyPosition(this.oPopup._oLastPosition,true)}else{this.close()}},this);this.setFollowOf(true);this._initResponsivePaddingsEnablement();this._oRestoreFocusDelegate={onBeforeRendering:function(){var e=g.closestTo(document.activeElement);this._sFocusControlId=e&&e.getId()},onAfterRendering:function(){if(this._sFocusControlId&&!_(this.getDomRef(),document.activeElement)){g.registry.get(this._sFocusControlId).focus()}}};var e=this;this.oPopup._applyPosition=function(t,o){var i=this.getOpenState(),r;if(i===w.CLOSING||i===w.CLOSED){return}if(o){e._storeScrollPosition()}e._clearCSSStyles();var n=e._placements.indexOf(e.getPlacement());if(n>3&&!e._bPosCalced){e._calcPlacement();return}e._bPosCalced=false;if(e._oOpenBy instanceof g){t.of=e._getOpenByDomRef()}if(!t.of){P.warning("sap.m.Popover: in function applyPosition, the openBy element doesn't have any DOM output. "+e);return}if(!_(document.documentElement,t.of)&&t.of.id){r=jQuery(document.getElementById(t.of.id));if(r){t.of=r}else{P.warning("sap.m.Popover: in function applyPosition, the openBy element's DOM is already detached from DOM tree and can't be found again by the same id. "+e);return}}var a=jQuery(t.of).rect();var l=jQuery(e.getWithinAreaDomRef());if(o&&l.height()==e._initialWindowDimensions.height&&(a.top+a.height<=0||a.top>=l.height()||a.left+a.width<=0||a.left>=l.width())){e.close();return}var f=e.getDomRef("scroll");if(!h.system.desktop){jQuery(window).scrollLeft(0)}e._deregisterContentResizeHandler();s.prototype._applyPosition.call(this,t);e._fnAdjustPositionAndArrow();e._restoreScrollPosition();e._registerContentResizeHandler(f)};this.oPopup.close=function(t){var o=typeof t==="boolean";var i=e.oPopup.getOpenState();var r=e._oOpenBy&&e._oOpenBy.getDomRef&&!!e._oOpenBy.getDomRef();if(t!==true&&(this.touchEnabled||!(this._isFocusInsidePopup()&&r))&&this.isOpen()&&!(i===w.CLOSED||i===w.CLOSING)){e.fireBeforeClose({openBy:e._oOpenBy})}e._deregisterContentResizeHandler();if(this._sTimeoutId&&arguments.length>1){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;var n=arguments[1];if(typeof n=="string"&&n=="autocloseBlur"&&this._isFocusInsidePopup()){return}}s.prototype.close.apply(this,o?[]:arguments);e.removeDelegate(e._oRestoreFocusDelegate)}};b.prototype.getWithinAreaDomRef=function(){return s.getWithinAreaDomRef()};b.prototype.onBeforeRendering=function(){var e,t,o,i=this.getHorizontalScrolling(),r=this.getVerticalScrolling(),s=!i||this.isPropertyInitial("horizontalScrolling"),l=!r||this.isPropertyInitial("verticalScrolling"),f=this.getCustomHeader()||this._internalHeader;if(this.hasStyleClass("sapUiPopupWithPadding")){P.warning("Usage of CSS class 'sapUiPopupWithPadding' is deprecated. Use 'sapUiContentPadding' instead",null,"sap.m.Popover")}if(!this._initialWindowDimensions.width||!this._initialWindowDimensions.height){o=jQuery(this.getWithinAreaDomRef());this._initialWindowDimensions={width:o.width(),height:o.height()}}this._hasSingleScrollableContent();if(!i&&!r){this._forceDisableScrolling=true}else if(s&&l&&this._singleScrollableContent){this._forceDisableScrolling=true;P.info("VerticalScrolling and horizontalScrolling in sap.m.Popover with ID "+this.getId()+" has been disabled because there's scrollable content inside")}else{this._forceDisableScrolling=false}if(!this._forceDisableScrolling){if(!this._oScroller){this._oScroller=new a(this,this.getId()+"-scroll",{horizontal:i,vertical:r,callBefore:true})}else{this._oScroller.setHorizontal(i);this._oScroller.setVertical(r)}}if(this._bContentChanged){this._bContentChanged=false;e=this._getSingleNavContent();t=this._getSinglePageContent();if(e&&!this.getModal()&&!h.system.phone){e.attachEvent("afterNavigate",function(e){var t=this.getDomRef();if(t){var o=this.$().firstFocusableDomRef()||t;o.focus()}},this)}if(e||t){t=t||e.getCurrentPage();if(t&&t._getAnyHeader){this.addStyleClass("sapMPopoverWithHeaderCont")}if(e){e.attachEvent("navigate",function(e){var t=e.getParameter("to");if(t instanceof n&&t.isA("sap.m.Page")){this.$().toggleClass("sapMPopoverWithHeaderCont",!!t._getAnyHeader())}},this)}}}this._setHeaderTitle();if(!h.system.desktop){this.setResizable(false)}if(f&&f.setTitleAlignment){f.setTitleAlignment(this.getTitleAlignment())}};b.prototype.onAfterRendering=function(){var e,t,o;if(!this._marginTopInit&&this.getShowArrow()){this._marginTop=2;if(this._oOpenBy){e=jQuery(this._getOpenByDomRef());if(!(e.closest("header.sapMIBar").length>0)){t=e.closest(".sapMPage");if(t.length>0){o=t.children("header.sapMIBar");if(o.length>0){this._marginTop+=o.outerHeight()}}}this._marginTopInit=true}}this._repositionOffset()};b.prototype.exit=function(){this._deregisterContentResizeHandler();h.resize.detachHandler(this._fnOrientationChange);o.removePopoverInstance(this);this.removeDelegate(this._oRestoreFocusDelegate);this._oRestoreFocusDelegate=null;if(this.oPopup){this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null}if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._internalHeader){this._internalHeader.destroy();this._internalHeader=null}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null}};b.prototype.openBy=function(e,t){var r=this.oPopup,n=this.oPopup.getOpenState(),a=this._getInitialFocusId(),f,p,g,c;f=e.getDomRef&&e.getDomRef()||e;c=jQuery(f).closest(".sapUiSizeCompact");g=l.get({name:"_sap_m_Popover_ForceCompactArrowOffset"})||"true";H=l.get({name:"_sap_m_Popover_ArrowOffset",callback:function(e){H=parseFloat(e)}})||8;g=g==="true";this._bSizeCompact=i._bSizeCompact||!!c.length||this.hasStyleClass("sapUiSizeCompact");this._bUseCompactArrow=this._bSizeCompact||g;this._adaptPositionParams();if(n===w.OPEN||n===w.OPENING){if(this._oOpenBy===e){return this}else{var u=function(){r.detachClosed(u,this);this.openBy(e)};r.attachClosed(u,this);this._oPreviousFocus=null;this.close();return this}}if(!e){return this}if(h.support.touch){h.resize.attachHandler(this._fnOrientationChange)}if(!this._oOpenBy||e!==this._oOpenBy){this._oOpenBy=e}this.fireBeforeOpen({openBy:this._oOpenBy});r.attachOpened(this._handleOpened,this);r.attachClosed(this._handleClosed,this);r.setInitialFocusId(a);p=this._placements.indexOf(this.getPlacement());if(p>-1){f=this._getOpenByDomRef();if(!f){P.error("sap.m.Popover id = "+this.getId()+": is opened by a control which isn't rendered yet.");return this}r.setExtraContent([e]);r.setContent(this);if(p<=3){r.setPosition(this._myPositions[p],this._atPositions[p],f,this._calcOffset(this._offsets[p]),"fit")}else{r._oPosition.of=f}var d=this;var _=function(){if(r.bIsDestroyed){return}if(r.getOpenState()===w.CLOSING){if(d._sOpenTimeout){clearTimeout(d._sOpenTimeout);d._sOpenTimeout=null}d._sOpenTimeout=setTimeout(_,150)}else{d._oPreviousFocus=s.getCurrentFocusInfo();r.open();d.addDelegate(d._oRestoreFocusDelegate,d);if(!t){o.addPopoverInstance(d)}}};_()}else{P.error(this.getPlacement()+"is not a valid value! It can only be top, right, bottom or left")}return this};b.prototype.close=function(){var e=this.oPopup.getOpenState(),t,o;if(e===w.CLOSED||e===w.CLOSING){return this}this.fireBeforeClose({openBy:this._oOpenBy});this.oPopup.close(true);if(this._oPreviousFocus){o=document.activeElement||{};t=this._oPreviousFocus.sFocusId===sap.ui.getCore().getCurrentFocusedControlId()||this._oPreviousFocus.sFocusId===o.id;if(!t){s.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null}}return this};b.prototype.isOpen=function(){return this.oPopup&&this.oPopup.isOpen()};b.prototype.setFollowOf=function(e){if(e){this.oPopup.setFollowOf(this._fnFollowOf)}else{this.oPopup.setFollowOf(false)}return this};b.prototype._clearCSSStyles=function(){if(!this.getDomRef()){return}var e=this.getDomRef().style,t=this.$("cont"),o=t.children(".sapMPopoverScroll"),i=t[0].style,r=o[0].style,n=this.getContentWidth(),s=this.getContentHeight(),a=this.$("arrow"),l,h,f=jQuery(this.getWithinAreaDomRef());if(n.indexOf("%")>0){l=f.width();n=C.calcPercentageSize(n,l)}if(s.indexOf("%")>0){h=f.height();s=C.calcPercentageSize(s,h)}i.width=n||"";i.height=s||"";i.maxWidth="";i.maxHeight="";e.left="";e.right="";e.top="";e.bottom="";e.width="";e.height="";e.overflow="";r.width="";r.display="";a.removeClass("sapMPopoverArrRight sapMPopoverArrLeft sapMPopoverArrDown sapMPopoverArrUp sapMPopoverCrossArr sapMPopoverFooterAlignArr sapMPopoverHeaderAlignArr sapContrast sapContrastPlus");a.css({left:"",top:""})};b.prototype._onOrientationChange=function(){var e=this.oPopup&&this.oPopup.getOpenState()||{};if(e!==w.OPEN&&e!==w.OPENING){return}this.oPopup._applyPosition(this.oPopup._oLastPosition,true);this._includeScrollWidth()};b.prototype._includeScrollWidth=function(){var e=this.getContentWidth(),t=this.$(),o=Math.floor(window.innerWidth*.9),i=this.$("cont");if(!i[0]){return}if(h.system.desktop&&!h.browser.chrome){var r=i[0].clientHeight<i[0].scrollHeight;if(r&&(!e||e==="auto")&&i.width()<o){t.addClass("sapMPopoverVerticalScrollIncluded")}else{t.removeClass("sapMPopoverVerticalScrollIncluded")}}};b.prototype._handleOpened=function(){var e=this;this.oPopup.detachOpened(this._handleOpened,this);if(!h.support.touch){setTimeout(function(){!e.bIsDestroyed&&h.resize.attachHandler(e._fnOrientationChange)},0)}var t=this._getInitialFocusId(),o=g.registry.get(t),i=t?window.document.getElementById(t):null;if(o&&o.getFocusDomRef()){o.getFocusDomRef().focus()}else if(!o&&i){i.focus()}this.fireAfterOpen({openBy:this._oOpenBy})};b.prototype._handleClosed=function(){this.oPopup.detachClosed(this._handleClosed,this);h.resize.detachHandler(this._fnOrientationChange);o.removePopoverInstance(this);if(!this.oPopup._bModal&&!h.system.desktop&&document.activeElement&&!jQuery(document.activeElement).is(":visible")){document.activeElement.blur()}this.fireAfterClose({openBy:this._oOpenBy})};b.prototype.onfocusin=function(e){var t=e.target,o=this.$(),i=this.getId()+"-firstfe",r=this.getId()+"-middlefe",n=this.getId()+"-lastfe";if(t.id===i){var s=o.lastFocusableDomRef();if(s){s.focus()}else{document.getElementById(r).focus()}}else if(t.id===n){var a=o.firstFocusableDomRef();if(a){a.focus()}else{document.getElementById(r).focus()}}};b.prototype.onkeydown=function(e){var t=v,o=e.which||e.keyCode,i=e.altKey;this._isSpacePressed=this._isSpacePressed||t.SPACE===o;if(!this._isSpacePressed&&o===t.ESCAPE||i&&o===t.F4){if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return}this.close();e.stopPropagation();e.preventDefault()}};b.prototype.onkeyup=function(e){var t=v,o=e.which||e.keyCode;if(t.SPACE===o){this._isSpacePressed=false}};b.prototype.onmousedown=function(e){var t=y.getRTL();if(!e.target.classList||!e.target.classList.contains("sapMPopoverResizeHandle")){return}var o=jQuery(document);var i=this.$();var r=this;i.addClass("sapMPopoverResizing");e.preventDefault();e.stopPropagation();var n={x:e.pageX,y:e.pageY,width:i.width(),height:i.height()};o.on("mousemove.sapMPopover",function(e){var o,i;if(t){o=n.width+n.x-e.pageX;i=n.height+(n.y-e.pageY)}else{o=n.width+e.pageX-n.x;i=n.height+(n.y-e.pageY)}r.setContentWidth(Math.max(o,r._minDimensions.width)+"px");r.setContentHeight(Math.max(i,r._minDimensions.height)+"px")});o.on("mouseup.sapMPopover",function(){i.removeClass("sapMPopoverResizing");o.off("mouseup.sapMPopover, mousemove.sapMPopover")})};b.prototype._hasSingleNavContent=function(){return!!this._getSingleNavContent()};b.prototype._getSingleNavContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof n&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof n&&e[0].isA("sap.m.NavContainer")){return e[0]}else{return null}};b.prototype._getSinglePageContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof n&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof n&&e[0].isA("sap.m.Page")){return e[0]}else{return null}};b.prototype._hasSinglePageContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof n&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof n&&e[0].isA("sap.m.Page")){return true}else{return false}};b.prototype._hasSingleScrollableContent=function(){var e=this._getAllContent();while(e.length===1&&e[0]instanceof n&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent()}if(e.length===1&&e[0]instanceof n&&e[0].isA(this._scrollContentList)){this._singleScrollableContent=true}else{this._singleScrollableContent=false}};b.prototype._getOffsetX=function(){var e=this.getPlacement(),t=0;if(this._bHorizontalFlip){var o=this._getOpenByDomRef();var i=o!==undefined;var r=i?o.getBoundingClientRect().width:0;t=e===O.PreferredRightOrFlip?Math.abs(r):-Math.abs(r)}var n=y.getRTL();var s=t*(n?-1:1)+this.getOffsetX()*(n?-1:1);return s};b.prototype._getOffsetY=function(){var e=this.getPlacement(),t=0;if(this._bVerticalFlip){var o=this._getOpenByDomRef();var i=o!==undefined;var r=i?o.getBoundingClientRect().height:0;t=e==="PreferredTopOrFlip"?-Math.abs(r):Math.abs(r)}return t+this.getOffsetY()};b.prototype._calcOffset=function(e){var t=this._getOffsetX(),o=this._getOffsetY();var i=e.split(" ");return parseInt(i[0])+t+" "+(parseInt(i[1])+o)};b.prototype._calcPlacement=function(){var e=this.getPlacement();var t=this._getOpenByDomRef();switch(e){case O.Auto:this._calcAuto();break;case O.Vertical:case O.VerticalPreferedTop:case O.VerticalPreferredTop:case O.VerticalPreferedBottom:case O.VerticalPreferredBottom:case O.PreferredTopOrFlip:case O.PreferredBottomOrFlip:this._calcVertical();break;case O.Horizontal:case O.HorizontalPreferedLeft:case O.HorizontalPreferredLeft:case O.HorizontalPreferedRight:case O.HorizontalPreferredRight:case O.PreferredRightOrFlip:case O.PreferredLeftOrFlip:this._calcHorizontal();break}this._bPosCalced=true;var o=this._placements.indexOf(this._oCalcedPos);this.oPopup.setPosition(this._myPositions[o],this._atPositions[o],t,this._calcOffset(this._offsets[o]),"fit")};b.prototype._getDocHeight=function(){var e=document.body,t=document.documentElement,o=this.getWithinAreaDomRef(),i=o!==window?jQuery(o).offset():{top:0};return i.top+Math.max(e.scrollHeight,e.offsetHeight,t.clientHeight,t.offsetHeight)};b.prototype._calcVertical=function(){var e=jQuery(this._getOpenByDomRef());var t=e[0]!==undefined;var o=this.getPlacement()===O.VerticalPreferedTop||this.getPlacement()===O.VerticalPreferredTop;var i=this.getPlacement()===O.VerticalPreferedBottom||this.getPlacement()===O.VerticalPreferredBottom;var r=this.getPlacement()===O.PreferredTopOrFlip;var n=this.getPlacement()===O.PreferredBottomOrFlip;var s=t?e[0].getBoundingClientRect().top:0;var a=t?e[0].getBoundingClientRect().height:0;var l=this._getOffsetY();var h=s-this._marginTop+l;var f=this.$().outerHeight();var p=this._getDocHeight()-(e.offset().top+a+this._marginBottom+l);if(o&&h>f+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=O.Top}else if(r){if(h>f+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=O.Top}else{this._bVerticalFlip=true;this._oCalcedPos=O.Bottom}}else if(i&&p>f+this._arrowOffset){this._oCalcedPos=O.Bottom;this._bVerticalFlip=false}else if(n){if(p>f+this._arrowOffset){this._bVerticalFlip=false;this._oCalcedPos=O.Bottom}else{this._bVerticalFlip=true;this._oCalcedPos=O.Top}}else if(h>p){this._oCalcedPos=O.Top}else{this._oCalcedPos=O.Bottom}};b.prototype._calcHorizontal=function(){var e=jQuery(this._getOpenByDomRef());var t=e[0]!==undefined;var o=this.getPlacement()===O.HorizontalPreferedLeft||this.getPlacement()===O.HorizontalPreferredLeft;var i=this.getPlacement()===O.HorizontalPreferedRight||this.getPlacement()===O.HorizontalPreferredRight;var r=t?e[0].getBoundingClientRect().left:0;var n=t?e[0].getBoundingClientRect().width:0;var s=this._getOffsetX();var a=r-this._marginLeft+s;var l=r+n;var h=jQuery(this.getWithinAreaDomRef());var f=h.width()-l-this._marginRight-s;var p=this.$().outerWidth();var g=this.getPlacement()===O.PreferredLeftOrFlip;var c=this.getPlacement()===O.PreferredRightOrFlip;var u=y.getRTL();if(o&&a>p+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=u?O.Right:O.Left}else if(g){if(a>p+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=u?O.Right:O.Left}else{this._bHorizontalFlip=true;this._oCalcedPos=u?O.Left:O.Right}}else if(i&&f>p+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=u?O.Left:O.Right}else if(c){if(f>p+this._arrowOffset){this._bHorizontalFlip=false;this._oCalcedPos=u?O.Left:O.Right}else{this._bHorizontalFlip=true;this._oCalcedPos=u?O.Right:O.Left}}else if(a>f){this._oCalcedPos=u?O.Right:O.Left}else{this._oCalcedPos=u?O.Left:O.Right}};b.prototype._calcAuto=function(){var e=jQuery(this.getWithinAreaDomRef());if(e.width()>e.height()){if(this._checkHorizontal()){this._calcHorizontal()}else if(this._checkVertical()){this._calcVertical()}else{this._calcBestPos()}}else if(this._checkVertical()){this._calcVertical()}else if(this._checkHorizontal()){this._calcHorizontal()}else{this._calcBestPos()}};b.prototype._checkHorizontal=function(){var e=jQuery(this._getOpenByDomRef());var t=e[0]!==undefined;var o=t?e[0].getBoundingClientRect().left:0;var i=t?e[0].getBoundingClientRect().width:0;var r=this._getOffsetX();var n=o-this._marginLeft+r;var s=o+i;var a=jQuery(this.getWithinAreaDomRef());var l=a.width()-s-this._marginRight-r;var h=this.$();var f=h.outerWidth()+this._arrowOffset;if(f<=n||f<=l){return true}};b.prototype._checkVertical=function(){var e=jQuery(this._getOpenByDomRef());var t=e[0]!==undefined;var o=t?e[0].getBoundingClientRect().top:0;var i=t?e[0].getBoundingClientRect().height:0;var r=this._getOffsetY();var n=o-this._marginTop+r;var s=this._getDocHeight()-e.offset().top-i-this._marginBottom-r;var a=this.$();var l=a.outerHeight()+this._arrowOffset;if(l<=n||l<=s){return true}};b.prototype._calcBestPos=function(){var e=this.$();var t=e.outerHeight();var o=e.outerWidth();var i=y.getRTL();var r=jQuery(this._getOpenByDomRef());var n=r[0]!==undefined;var s=n?r[0].getBoundingClientRect().left:0;var a=n?r[0].getBoundingClientRect().top:0;var l=n?r[0].getBoundingClientRect().width:0;var h=n?r[0].getBoundingClientRect().height:0;var f=this._getOffsetX();var p=this._getOffsetY();var g=a-this._marginTop+p;var c=this._getDocHeight()-r.offset().top-h-this._marginBottom-p;var u=s-this._marginLeft+f;var d=s+l;var _=jQuery(this.getWithinAreaDomRef());var m=_.width()-d-this._marginRight-f;var v=t*o;var P;var C;if(_.height()-this._marginTop-this._marginBottom>=t){P=t}else{P=_.height()-this._marginTop-this._marginBottom}if(_.width()-this._marginLeft-this._marginRight>=o){C=o}else{C=_.width()-this._marginLeft-this._marginRight}var w=P*u/v;var B=P*m/v;var H=C*g/v;var b=C*c/v;var R=Math.max(w,B);var A=Math.max(H,b);if(R>A){if(R===w){this._oCalcedPos=i?O.Right:O.Left}else if(R===B){this._oCalcedPos=i?O.Left:O.Right}}else if(A>R){if(A===H){this._oCalcedPos=O.Top}else if(A===b){this._oCalcedPos=O.Bottom}}else if(A===R){if(_.height()>_.width()){if(A===H){this._oCalcedPos=O.Top}else if(A===b){this._oCalcedPos=O.Bottom}}else{if(R===w){this._oCalcedPos=i?O.Right:O.Left}else if(R===B){this._oCalcedPos=i?O.Left:O.Right}}}};b.outerWidth=function(e,t){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().width}return jQuery(e).outerWidth(!!t)};b.outerHeight=function(e,t){if(typeof window.SVGElement!=="undefined"&&e instanceof window.SVGElement){return e.getBoundingClientRect().height}return jQuery(e).outerHeight(!!t)};b.prototype._getPositionParams=function(e,t,o,i){var r=window.getComputedStyle(e[0]),n=window.getComputedStyle(o[0]),s=jQuery(window),a=this.getDomRef().clientHeight!==this.getDomRef().scrollHeight?m().width:0,l=jQuery(this.getWithinAreaDomRef()),f=l[0]!==window?l.offset():{top:0,left:0},p={};p._$popover=e;p._$parent=jQuery(this._getOpenByDomRef());p._$arrow=t;p._$content=o;p._$scrollArea=i;p._$header=e.children(".sapMPopoverHeader");p._$subHeader=e.children(".sapMPopoverSubHeader");p._$footer=e.children(".sapMPopoverFooter");p._fWindowTop=s.scrollTop();p._fWindowRight=s.width();p._fWindowBottom=b._bIOS7&&h.orientation.landscape&&window.innerHeight?window.innerHeight:s.height();p._fWindowLeft=s.scrollLeft();p._fWindowWidth=window.innerWidth;p._fWindowHeight=window.innerHeight;p._fWithinAreaWidth=Math.min(l.outerWidth(),p._fWindowWidth);p._fWithinAreaHeight=Math.min(l.outerHeight(),p._fWindowHeight);p._fDocumentWidth=p._fWindowLeft+p._fWindowRight;p._fDocumentHeight=p._fWindowTop+p._fWindowBottom;p._fArrowHeight=t.outerHeight(true);p._fPopoverWidth=b.outerWidth(e[0]);p._fPopoverInnerWidth=p._$scrollArea?p._$scrollArea.width()+a:0;p._fPopoverHeight=b.outerHeight(e[0]);p._fHeaderHeight=p._$header.length>0?p._$header.outerHeight(true):0;p._fSubHeaderHeight=p._$subHeader.length>0?p._$subHeader.outerHeight(true):0;p._fFooterHeight=p._$footer.length>0?p._$footer.outerHeight(true):0;p._fPopoverOffset=e.offset();p._fPopoverOffsetX=this._getOffsetX();p._fPopoverOffsetY=this._getOffsetY();p._fPopoverMarginTop=p._fWindowTop+this._marginTop+f.top;p._fPopoverMarginLeft=p._fWindowLeft+this._marginLeft+f.left;p._fPopoverMarginRight=p._fWindowWidth-f.left-p._fWithinAreaWidth+this._marginRight;p._fPopoverMarginBottom=p._fWindowHeight-f.top-p._fWithinAreaHeight+this._marginBottom;p._fPopoverBorderTop=parseFloat(r.borderTopWidth);p._fPopoverBorderRight=parseFloat(r.borderRightWidth);p._fPopoverBorderBottom=parseFloat(r.borderBottomWidth);p._fPopoverBorderLeft=parseFloat(r.borderLeftWidth);p._fContentMarginTop=parseFloat(n.marginTop);p._fContentMarginBottom=parseFloat(n.marginBottom);return p};b.prototype._recalculateMargins=function(e,t){var o;var i=y.getRTL();switch(e){case O.Left:if(i){t._fPopoverMarginLeft=t._$parent.offset().left+b.outerWidth(t._$parent[0],false)+this._arrowOffset-t._fPopoverOffsetX}else{t._fPopoverMarginRight=t._fWindowWidth-t._$parent.offset().left+this._arrowOffset-t._fPopoverOffsetX}break;case O.Right:if(i){t._fPopoverMarginRight=t._fWindowWidth-b.outerWidth(t._$parent[0],false)-t._$parent.offset().left+this._arrowOffset}else{t._fPopoverMarginLeft=t._$parent.offset().left+b.outerWidth(t._$parent[0],false)+this._arrowOffset+t._fPopoverOffsetX}break;case O.Top:o=t._fWindowHeight-t._$parent.offset().top+this._arrowOffset-t._fPopoverOffsetY;t._fPopoverMarginBottom=o>t._fPopoverMarginBottom?o:t._fPopoverMarginBottom;break;case O.Bottom:t._fPopoverMarginTop=t._$parent.offset().top+b.outerHeight(t._$parent[0],false)+this._arrowOffset+t._fPopoverOffsetY;break}return t};b.prototype._getPopoverPositionCss=function(e){var t,o,i,r,n=e._fDocumentWidth-e._fPopoverOffset.left-e._fPopoverWidth,s=e._fDocumentHeight-e._fPopoverOffset.top-e._fPopoverHeight,a=e._fDocumentWidth-e._fPopoverMarginRight-e._fPopoverMarginLeft<e._fPopoverWidth,l=e._fDocumentHeight-e._fPopoverMarginTop-e._fPopoverMarginBottom<e._fPopoverHeight,h=e._fPopoverOffset.left<e._fPopoverMarginLeft,f=this.getVerticalScrolling()&&e._fPopoverWidth!==e._fPopoverInnerWidth?m().width:0,p=n<e._fPopoverMarginRight+f,g=e._fPopoverOffset.top<e._fPopoverMarginTop,c=s<e._fPopoverMarginBottom,u=y.getRTL();if(a){t=e._fPopoverMarginLeft;o=e._fPopoverMarginRight}else if(h){t=e._fPopoverMarginLeft;if(u){o=""}}else if(p){o=e._fPopoverMarginRight;t=""}if(l){i=e._fPopoverMarginTop;r=e._fPopoverMarginBottom}else if(g){i=e._fPopoverMarginTop}else if(c){r=e._fPopoverMarginBottom;i=""}var d={top:i,bottom:r-e._fWindowTop,left:t,right:typeof o==="number"?o-e._fWindowLeft:o};return d};b.prototype._getContentDimensionsCss=function(e){var t={},o=e._$content[0].getBoundingClientRect().height,i=this._getMaxContentWidth(e),r=this._getMaxContentHeight(e);r=Math.max(r,0);t["max-width"]=i+"px";if(this.getContentHeight()||o>r){t["height"]=Math.min(r,o)+"px"}else{t["height"]="";t["max-height"]=r+"px"}return t};b.prototype._getMaxContentWidth=function(e){var t=e._fPopoverBorderLeft+e._fPopoverBorderRight;return e._fDocumentWidth-e._fPopoverMarginLeft-e._fPopoverMarginRight-t};b.prototype._getMaxContentHeight=function(e){var t=e._fHeaderHeight+e._fSubHeaderHeight+e._fFooterHeight+e._fContentMarginTop+e._fContentMarginBottom+e._fPopoverBorderTop+e._fPopoverBorderBottom;return e._fDocumentHeight-e._fPopoverMarginTop-e._fPopoverMarginBottom-t};b.prototype._isHorizontalScrollbarNeeded=function(e){return this.getHorizontalScrolling()&&e._$scrollArea.outerWidth(true)<=e._$content.width()};b.prototype._getArrowOffsetCss=function(e,t){var o,i=y.getRTL();t._fPopoverWidth=t._$popover.outerWidth();t._fPopoverHeight=t._$popover.outerHeight();if(e===O.Left||e===O.Right){o=t._$parent.offset().top-t._$popover.offset().top-t._fPopoverBorderTop+t._fPopoverOffsetY+.5*(b.outerHeight(t._$parent[0],false)-t._$arrow.outerHeight(false));o=Math.max(o,H);o=Math.min(o,t._fPopoverHeight-H-t._$arrow.outerHeight());return{top:o}}else if(e===O.Top||e===O.Bottom){if(i){o=t._$popover.offset().left+b.outerWidth(t._$popover[0],false)-(t._$parent.offset().left+b.outerWidth(t._$parent[0],false))+t._fPopoverBorderRight+t._fPopoverOffsetX+.5*(b.outerWidth(t._$parent[0],false)-t._$arrow.outerWidth(false));o=Math.max(o,H);o=Math.min(o,t._fPopoverWidth-H-t._$arrow.outerWidth(false));return{right:o}}else{o=t._$parent.offset().left-t._$popover.offset().left-t._fPopoverBorderLeft+t._fPopoverOffsetX+.5*(b.outerWidth(t._$parent[0],false)-t._$arrow.outerWidth(false));o=Math.max(o,H);o=Math.min(o,t._fPopoverWidth-H-t._$arrow.outerWidth(false));return{left:o}}}};b.prototype._getArrowPositionCssClass=function(e){switch(e){case O.Left:return"sapMPopoverArrRight";case O.Right:return"sapMPopoverArrLeft";case O.Top:return"sapMPopoverArrDown";case O.Bottom:return"sapMPopoverArrUp"}};b.prototype._getArrowStyleCssClass=function(e){var t=e._$arrow.position(),o=e._$footer.position(),i=this._getSingleNavContent(),r=this._getSinglePageContent(),n=0;if(i||r){r=r||i.getCurrentPage();if(r){n=r._getAnyHeader().$().outerHeight()}}if(t.top+e._fArrowHeight<e._fHeaderHeight+e._fSubHeaderHeight||t.top+e._fArrowHeight<n){return"sapMPopoverHeaderAlignArr"}else if(t.top<e._fHeaderHeight+e._fSubHeaderHeight||t.top<n||e._$footer.length&&t.top+e._fArrowHeight>o.top&&t.top<o.top){return"sapMPopoverCrossArr"}else if(e._$footer.length&&t.top>o.top){return"sapMPopoverFooterAlignArr"}};b.prototype._getCalculatedPlacement=function(){return this._oCalcedPos||this.getPlacement()};b.prototype._adjustPositionAndArrow=function(){var e=this.oPopup.getOpenState();if(!(e===w.OPEN||e===w.OPENING)){return}this._beforeAdjustPositionAndArrowHook();var t=this.$(),o=this.$("arrow"),i=this.$("cont"),r=this.$("scroll"),n=this._getCalculatedPlacement(),s=this._getPositionParams(t,o,i,r);s=this._recalculateMargins(n,s);var a=this._getPopoverPositionCss(s),l=this._getContentDimensionsCss(s),h=this._isHorizontalScrollbarNeeded(s);t.css(a);i.css(l);if(h){r.css("display","block")}if(this.getShowArrow()){var f=this._getArrowOffsetCss(n,s),p=this._getArrowPositionCssClass(n),g,c;o.removeAttr("style");o.css(f);o.addClass(p);if(n===O.Top&&s._$footer&&s._$footer.length){c=true}if(n===O.Left||n===O.Right){g=this._getArrowStyleCssClass(s);if(g){o.addClass(g);if(g==="sapMPopoverFooterAlignArr"){c=true}}}if(c){o.addClass("sapContrast sapContrastPlus")}t.css("overflow","visible")}this._afterAdjustPositionAndArrowHook()};b.prototype._adaptPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=18;this._offsets=["0 -18","18 0","0 18","-18 0"];if(this._bUseCompactArrow){this._arrowOffset=9;this._offsets=["0 -9","9 0","0 9","-9 0"]}this._myPositions=["center bottom","begin center","center top","end center"];this._atPositions=["center top","end center","center bottom","begin center"]}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin center","begin top","end center"];this._atPositions=["begin top","end center","begin bottom","begin center"]}};b.prototype._afterAdjustPositionAndArrowHook=function(){};b.prototype._beforeAdjustPositionAndArrowHook=function(){};b.prototype._isPopupElement=function(e){var t=this._getOpenByDomRef();return!!jQuery(e).closest(u.getDomRef()).length||!!jQuery(e).closest(t).length};b.prototype._getAnyHeader=function(){if(this.getCustomHeader()){return this.getCustomHeader()}else if(this.getShowHeader()){this._createInternalHeader();return this._internalHeader}};b.prototype._createInternalHeader=function(){if(!this._internalHeader){var t=this;this._internalHeader=new e(this.getId()+"-intHeader",{titleAlignment:this.getTitleAlignment()});this.setAggregation("_internalHeader",this._internalHeader);this._internalHeader.addEventDelegate({onAfterRendering:function(){t._restoreFocus()}});return true}else{return false}};b.prototype._animation=function(e,t){var o=null;var i=function(){t.off("webkitTransitionEnd transitionend");clearTimeout(o);setTimeout(function(){e()})};t.on("webkitTransitionEnd transitionend",i);o=setTimeout(i,this._getAnimationDuration())};b.prototype._getAnimationDuration=function(){return 300};b.prototype._openAnimation=function(e,t,o){var i=this;setTimeout(function(){e.css("display","block");i._includeScrollWidth();i._animation(function(){if(!i.oPopup||i.oPopup.getOpenState()!==w.OPENING){return}o()},e)},h.browser.firefox?50:0)};b.prototype._closeAnimation=function(e,t,o){e.addClass("sapMPopoverTransparent");this._animation(function(){o();e.removeClass("sapMPopoverTransparent")},e)};b.prototype._getInitialFocusId=function(){return this.getInitialFocus()||this._getFirstVisibleButtonId()||this._getFirstFocusableContentElementId()||this.getId()};b.prototype._getFirstVisibleButtonId=function(){var e=this.getBeginButton(),t=this.getEndButton(),o="";if(e&&e.getVisible()&&e.getEnabled()){o=e.getId()}else if(t&&t.getVisible()&&t.getEnabled()){o=t.getId()}return o};b.prototype._getFirstFocusableContentElementId=function(){var e="";var t=this.$("cont");var o=t.firstFocusableDomRef();if(o){e=o.id}return e};b.prototype._restoreFocus=function(){if(this.isOpen()){var e=this._getInitialFocusId(),t=g.registry.get(e),o=e?window.document.getElementById(e):null;if(t&&t.getFocusDomRef()){t.getFocusDomRef().focus()}else if(!t&&o){o.focus()}}};b.prototype._registerContentResizeHandler=function(e){if(!this._sResizeListenerId){this._sResizeListenerId=c.register(e||this.getDomRef("scroll"),this._fnOrientationChange)}};b.prototype._deregisterContentResizeHandler=function(){if(this._sResizeListenerId){c.deregister(this._sResizeListenerId);this._sResizeListenerId=null}};b.prototype._storeScrollPosition=function(){var e=this.$("cont");if(e.length>0){this._oScrollPosDesktop={x:e.scrollLeft(),y:e.scrollTop()}}};b.prototype._restoreScrollPosition=function(){if(!this._oScrollPosDesktop){return}var e=this.$("cont");if(e.length>0){e.scrollLeft(this._oScrollPosDesktop.x).scrollTop(this._oScrollPosDesktop.y);this._oScrollPosDesktop=null}};b.prototype._repositionOffset=function(){var e=this.oPopup.getOpenState(),t,o;if(!(e===w.OPEN)){return this}t=this.oPopup._oLastPosition;o=this._placements.indexOf(this.getPlacement());if(o===-1){return this}if(o<4){t.offset=this._calcOffset(this._offsets[o]);this.oPopup._applyPosition(t)}else{this._calcPlacement()}return this};b.prototype._getOpenByDomRef=function(){if(!this._oOpenBy){return null}if(this._oOpenBy instanceof g){return this._oOpenBy.getPopupAnchorDomRef&&this._oOpenBy.getPopupAnchorDomRef()||this._oOpenBy.getFocusDomRef()}else{return this._oOpenBy}};b.prototype._getAccessibilityOptions=function(){var e,t={},o=this._getAnyHeader(),i=this.getCustomHeader();t.role="dialog";t.modal=this.getProperty("ariaModal");if(!this.getShowHeader()||!o||!o.getVisible()){return t}var r=i?i.getId():this.getHeaderTitle().getId();e=Array.prototype.concat(r,this.getAssociation("ariaLabelledBy",[]));t.labelledby=e.join(" ");return t};b.prototype._setHeaderTitle=function(){if(!this._headerTitle){this._headerTitle=new r(this.getId()+"-title",{text:this.getTitle(),level:"H1"});this._createInternalHeader();this._internalHeader.addContentMiddle(this._headerTitle);return}if(this._headerTitle.getText()!==this.getTitle()){this._headerTitle.setText(this.getTitle())}};b.prototype.getHeaderTitle=function(){return this._headerTitle};b.prototype.setPlacement=function(e){this.setProperty("placement",e,true);this._bVerticalFlip=false;this._bHorizontalFlip=false;var t=this._placements.indexOf(e);if(t<=3){this._oCalcedPos=e}return this};b.prototype.setBeginButton=function(e){var t=this.getBeginButton();if(t===e){return this}this._createInternalHeader();this._beginButton=e;if(e){if(t){this._internalHeader.removeAggregation("contentLeft",t,true)}this._internalHeader.addAggregation("contentLeft",e)}else{this._internalHeader.removeContentLeft(t)}return this};b.prototype.setEndButton=function(e){var t=this.getEndButton();if(t===e){return this}this._createInternalHeader();this._endButton=e;this._internalHeader.removeContentRight(t);if(e){this._internalHeader.addContentRight(e)}return this};b.prototype.setLeftButton=function(e){if(!(e instanceof t)){e=g.registry.get(e)}this.setBeginButton(e);return this.setAssociation("leftButton",e)};b.prototype.setRightButton=function(e){if(!(e instanceof t)){e=g.registry.get(e)}this.setEndButton(e);return this.setAssociation("rightButton",e)};b.prototype.setModal=function(e,t){if(e===this.getModal()){return this}this.oPopup.setModal(e,("sapMPopoverBLayer "+(t||"")).trim());this.setProperty("modal",e,true);return this};b.prototype.setEnableScrolling=function(e){this.setHorizontalScrolling(e);this.setVerticalScrolling(e);this.setProperty("enableScrolling",e);return this};b.prototype._setAriaModal=function(e){return this.setProperty("ariaModal",e)};b.prototype.getScrollDelegate=function(){return this._oScroller};b.prototype._setAriaRoleApplication=function(e){return this.setProperty("ariaRoleApplication",e)};b.prototype.setAggregation=function(e,t,o){if(e==="beginButton"||e==="endButton"){var i="set"+e.charAt(0).toUpperCase()+e.slice(1);return this[i](t)}else{return n.prototype.setAggregation.apply(this,arguments)}};b.prototype.getAggregation=function(e,t){if(e==="beginButton"||e==="endButton"){var o=this["_"+e];return o||t||null}else{return n.prototype.getAggregation.apply(this,arguments)}};b.prototype.destroyAggregation=function(e,t){var o=g.closestTo(document.activeElement);if(e==="beginButton"||e==="endButton"){var i=this["_"+e];if(i){i.destroy();this["_"+e]=null}}else{n.prototype.destroyAggregation.apply(this,arguments)}o&&o.getDomRef()?o.focus():this.focus();return this};b.prototype.invalidate=function(e){if(this.isOpen()){n.prototype.invalidate.apply(this,arguments)}return this};b.prototype.addAggregation=function(e,t,o){if(e==="content"){this._bContentChanged=true}n.prototype.addAggregation.apply(this,arguments)};b.prototype._getAllContent=function(){return this.getContent()};b.prototype._applyContextualSettings=function(){n.prototype._applyContextualSettings.call(this)};return b});
//# sourceMappingURL=Popover.js.map