/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/Device","./PullToRefreshRenderer","sap/ui/events/KeyCodes","sap/base/security/encodeXML","sap/ui/core/InvisibleText","sap/m/BusyIndicator","sap/m/ImageHelper"],function(jQuery,t,e,o,i,s,r,l,a,n){"use strict";var h=e.extend("sap.m.PullToRefresh",{metadata:{library:"sap.m",properties:{description:{type:"string",group:"Misc",defaultValue:null},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}},events:{refresh:{}}},renderer:i});h.ARIA_F5_REFRESH="PULL_TO_REFRESH_ARIA_F5";h.prototype.init=function(){this._bTouchMode=o.support.touch&&!o.system.combi;this._iState=0;this._sAriaF5Text=l.getStaticId("sap.m",h.ARIA_F5_REFRESH)};h.prototype._loadBI=function(){if(this.getVisible()&&!this._oBusyIndicator){this._oBusyIndicator=new a({size:"1.7rem"});this._oBusyIndicator.setParent(this)}};h.prototype._getAriaDescribedByReferences=function(){var t=this.getTooltip_AsString(),e=this._sAriaF5Text,o;if(t){o=l.getStaticId("sap.m",t);e+=" "+o}return e};h.prototype.onBeforeRendering=function(){this._loadBI();if(this._bTouchMode){jQuery(window).off("resize.sapMP2R",this.calculateTopTrigger);var t=this.getParent();this._oScroller=t&&t.getScrollDelegate?t.getScrollDelegate():null;if(this._oScroller){this._oScroller.setBounce(true);this._oScroller.setPullDown(this.getVisible()?this:null)}}};h.prototype.calculateTopTrigger=function(){this._iTopTrigger=1;if(this._oDomRef&&this._oDomRef.parentNode&&this._oDomRef.parentNode.parentNode&&this._oDomRef.parentNode.parentNode.offsetHeight<this._oDomRef.offsetHeight*1.5){this._iTopTrigger=this.getDomRef("T").offsetTop}};h.prototype.onAfterRendering=function(){this._oDomRef=this.getDomRef();if(this._bTouchMode){if(this._oScroller){this._oScroller.refresh()}if(this.getVisible()&&this._oScroller&&this._oScroller._bIScroll){jQuery(window).on("resize.sapMP2R",jQuery.proxy(this.calculateTopTrigger,this));this.calculateTopTrigger()}}};h.prototype.exit=function(){if(this._bTouchMode&&this._oScroller&&this._oScroller._bIScroll){jQuery(window).off("resize.sapMP2R",this.calculateTopTrigger)}if(this._oScroller){this._oScroller.setPullDown(null);this._oScroller=null}if(this._oCustomImage){this._oCustomImage.destroy();this._oCustomImage=null}if(this._oBusyIndicator){this._oBusyIndicator.destroy();this._oBusyIndicator=null}};h.prototype.doScrollMove=function(){if(!this._oScroller){return}var t=this._oDomRef;var e=this._oScroller._scroller;if(e.y>-this._iTopTrigger&&this._iState<1){this.setState(1);e.minScrollY=0}else if(e.y<-this._iTopTrigger&&this._iState===1){this.setState(0);e.minScrollY=-t.offsetHeight}};h.prototype.doPull=function(t){if(this._bTouchMode&&this._iState<2){this.setState(t>=-1?1:0)}};h.prototype.doRefresh=function(){this.setState(0)};h.prototype.doScrollEnd=function(){if(this._iState===1){this.setState(2);this.fireRefresh()}};h.prototype.setState=function(t){if(this._iState===t){return}this._iState=t;if(!this._oDomRef){return}var e=this.$();var o=e.find(".sapMPullDownText");var i=this._getRB();switch(t){case 0:e.toggleClass("sapMFlip",false).toggleClass("sapMLoading",false);o.html(i.getText(this._bTouchMode?"PULL2REFRESH_PULLDOWN":"PULL2REFRESH_REFRESH"));e.removeAttr("aria-live");e.find(".sapMPullDownInfo").html(r(this.getDescription()));break;case 1:e.toggleClass("sapMFlip",true);o.html(i.getText("PULL2REFRESH_RELEASE"));e.removeAttr("aria-live");break;case 2:e.toggleClass("sapMFlip",false).toggleClass("sapMLoading",true);this._oBusyIndicator.setVisible(true);o.html(i.getText("PULL2REFRESH_LOADING"));e.attr("aria-live","assertive");e.find(".sapMPullDownInfo").html(this._bTouchMode?i.getText("PULL2REFRESH_LOADING_LONG"):"");break}};h.prototype.getCustomIconImage=function(){var t={src:this.getCustomIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};var e=["sapMPullDownCIImg"];this._oCustomImage=n.getImageControl(null,this._oCustomImage,this,t,e);return this._oCustomImage};h.prototype.onclick=function(){if(!this._bTouchMode){this.setState(2);this.fireRefresh()}};h.prototype.onkeyup=function(t){if(t.which===s.SPACE&&this._iState===1){this.setState(2);this.fireRefresh()}};h.prototype.onkeydown=function(t){if(t.which===s.F5){this.onclick();t.stopPropagation();t.preventDefault()}else if(t.which===s.SHIFT){if(this._iState===1){this.setState(0);return}}};h.prototype.onsapenter=function(t){if(this._iState<1){this.setState(2);this.fireRefresh()}};h.prototype.onsapspace=function(t){t.preventDefault();if(this._iState<1){this.setState(1)}};h.prototype.hide=function(){this.setState(0);if(this._oScroller){this._oScroller.refresh()}};h.prototype.setVisible=function(t){if(this.getVisible()===t){return this}if(this._oDomRef&&this._oScroller&&this._oScroller._oControl){this._oScroller._oControl.invalidate()}return this.setProperty("visible",t)};h.prototype._getRB=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m")};return h});
//# sourceMappingURL=PullToRefresh.js.map