/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/theming/Parameters","sap/ui/Device","./library","./ListItemBase","./Image","./StandardListItemRenderer","sap/base/Log"],function(t,e,i,n,o,r,a,s,p){"use strict";var u=t.TextDirection;var h=t.ValueState;var l=r.extend("sap.m.StandardListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconInset:{type:"boolean",group:"Appearance",defaultValue:true},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},info:{type:"string",group:"Misc",defaultValue:null},infoState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:h.None},adaptTitleSize:{type:"boolean",group:"Appearance",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:u.Inherit},infoTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:u.Inherit},wrapping:{type:"boolean",group:"Behavior",defaultValue:false},infoStateInverted:{type:"boolean",group:"Appearance",defaultValue:false},wrapCharLimit:{type:"int",group:"Behavior",defaultValue:0}},aggregations:{avatar:{type:"sap.m.Avatar",multiple:false}},designtime:"sap/m/designtime/StandardListItem.designtime"},renderer:s});l.prototype.exit=function(){if(this._oImage){this._oImage.destroy("KeepDom")}r.prototype.exit.apply(this,arguments)};l.prototype.setIcon=function(t){var i=this.getIcon();this.setProperty("icon",t);if(this._oImage&&(!t||e.isIconURI(t)!=e.isIconURI(i))){this._oImage.destroy("KeepDom");this._oImage=undefined}return this};l.prototype.setAvatar=function(t){if(this.getAvatar()===t){return this}if(t){t.addStyleClass("sapMSLIAvatar");t.setDisplaySize=function(){return this}}this.setAggregation("avatar",t);return this};l.prototype.setWrapCharLimit=function(t){var e=this.getWrapCharLimit();if(e===t){return this}if(t<0){p.error("The property wrapCharLimit must be 0 or greater than 0 - "+this.getId());return this}this.setProperty("wrapCharLimit",t);return this};l.prototype._getImage=function(){var t=this._oImage;if(t){t.setSrc(this.getIcon());if(t.setDensityAware){t.setDensityAware(this.getIconDensityAware())}}else{t=e.createControlByURI({id:this.getId()+"-img",src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false},a).setParent(this,null,true)}var i=this.getIconInset()?"sapMSLIImg":"sapMSLIImgNoInset";t.addStyleClass(t instanceof a?i:i+"Icon",true);this._oImage=t;return this._oImage};l.prototype._getAvatar=function(){var t=this.getAvatar();var e=this.getIconInset()?o.AvatarSize.XS:o.AvatarSize.S;t.setProperty("displaySize",e,true);return t};l.prototype._activeHandlingInheritor=function(){if(this._oImage){var t=this.getActiveIcon();t&&this._oImage.setSrc(t)}};l.prototype._inactiveHandlingInheritor=function(){if(this._oImage){this._oImage.setSrc(this.getIcon())}};l.prototype.getContentAnnouncement=function(t){var e=this.getInfoState(),i=this.getTitle(),n,o=this.getDescription(),r,a,s,p=[],u=this.getInfo();if(this.getWrapping()){a=this.getDomRef("titleButton");s=this.getDomRef("descriptionButton");i=this._bTitleTextExpanded?i:this._getCollapsedText(i);o=this._bDescriptionTextExpanded?o:this._getCollapsedText(o);p.push(i);if(a){n=a.textContent+" "+t.getText("ACC_CTR_TYPE_BUTTON");n&&p.push(n)}p.push(o);if(s){r=s.textContent+" . "+t.getText("ACC_CTR_TYPE_BUTTON");r&&p.push(r)}}else{i&&p.push(i);o&&p.push(o)}u&&p.push(u);if(e!="None"&&e!=this.getHighlight()){p.push(t.getText("LIST_ITEM_STATE_"+e.toUpperCase()))}return p.join(" . ").trim()};l.prototype._measureInfoTextWidth=function(t){if(!l._themeInfo){l._themeInfo={}}var e=parseFloat(o.BaseFontSize)||16;if(!l._themeInfo.sFontFamily||t){l._themeInfo.sFontFamily=i.get({name:"sapUiFontFamily"})||"Arial"}if(!l._themeInfo.sFontStyleInfoStateInverted||t){l._themeInfo.sFontStyleInfoStateInverted="bold "+parseFloat(i.get({name:"sapMFontSmallSize"})||"0.75rem")*e+"px "+l._themeInfo.sFontFamily}if(!l._themeInfo.sFontStyle||t){l._themeInfo.sFontStyle=parseFloat(i.get({name:"sapMFontMediumSize"})||"0.875rem")*e+"px "+l._themeInfo.sFontFamily}if(!l._oCtx){l._oCtx=document.createElement("canvas").getContext("2d")}l._oCtx.font=l._themeInfo[this.getInfoStateInverted()?"sFontStyleInfoStateInverted":"sFontStyle"];return Math.ceil(l._oCtx.measureText(this.getInfo()).width)/e};l.prototype._getInfoTextMinWidth=function(t){if(this.getInfoStateInverted()&&t<=7.5){return t+.625+"rem"}if(t<=7.5){return t+"rem"}return"7.5rem"};l.prototype.ontap=function(t){this._checkExpandCollapse(t);return r.prototype.ontap.apply(this,arguments)};l.prototype.ontouchstart=function(t){var e=t.target&&t.target.id,i=this.getId();if(e===i+"-titleButton"||e===i+"-descriptionButton"){t.setMarked()}return r.prototype.ontouchstart.apply(this,arguments)};l.prototype.onsapspace=function(t){this._checkExpandCollapse(t,true);if(!t.isMarked()){return r.prototype.onsapspace.apply(this,arguments)}};l.prototype._checkExpandCollapse=function(t,e){var i=t.target,n=i&&i.id;if(n&&n===this.getId()+"-titleButton"){if(e){t.preventDefault()}t.setMarked();return this._toggleExpandCollapse("title",this._bTitleTextExpanded)}if(n&&n===this.getId()+"-descriptionButton"){if(e){t.preventDefault()}t.setMarked();return this._toggleExpandCollapse("description",this._bDescriptionTextExpanded)}};l.prototype._toggleExpandCollapse=function(t,e){var i=this.getDomRef(t+"Text"),n=this.getDomRef(t+"ThreeDots"),o=this.getDomRef(t+"Button"),r=t==="title"?this.getTitle():this.getDescription(),a=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!e){i.textContent=r;n.textContent=" ";o.textContent=a.getText("EXPANDABLE_TEXT_SHOW_LESS");e=true}else{i.textContent=this._getCollapsedText(r);n.textContent=" ... ";o.textContent=a.getText("EXPANDABLE_TEXT_SHOW_MORE");e=false}if(t==="title"){this._bTitleTextExpanded=e}else{this._bDescriptionTextExpanded=e}};l.prototype._getCollapsedText=function(t){return t.substr(0,this._getWrapCharLimit())};l.prototype._getWrapCharLimit=function(){return this.getWrapCharLimit()||(n.system.phone?100:300)};l.prototype.onThemeChanged=function(t){r.prototype.onThemeChanged.apply(this,arguments);var e=t.theme;if(!this._initialRender){this._initialRender=true;if(!l._themeInfo){l._themeInfo={}}if(!l._themeInfo.sCurrentTheme){l._themeInfo.sCurrentTheme=e}return}var i=this.getDomRef("info");if(i){var n;if(l._themeInfo.sCurrentTheme!==e){l._themeInfo.sCurrentTheme=e;n=this._measureInfoTextWidth(true)}else{n=this._measureInfoTextWidth()}i.style.minWidth=this._getInfoTextMinWidth(n)}};return l});
//# sourceMappingURL=StandardListItem.js.map