/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/events/KeyCodes","sap/ui/core/Core","sap/ui/core/ControlBehavior","./library","./ListBase","./ListItemBase","./CheckBox","./TableRenderer","sap/ui/base/Object","sap/ui/core/ResizeHandler","sap/ui/core/util/PasteHelper","sap/ui/thirdparty/jquery","sap/m/ListBaseRenderer","sap/ui/core/Icon","sap/m/table/Util","sap/ui/core/Lib","sap/base/Log","sap/ui/dom/jquery/Selectors"],function(e,t,i,s,o,n,r,a,l,u,p,jQuery,h,c,d,g,f){"use strict";var m=s.ListGrowingDirection;var y=s.BackgroundDesign;var C=s.PopinLayout;var b=s.ScreenSizes;var _=o.extend("sap.m.Table",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:y.Translucent},fixedLayout:{type:"any",group:"Behavior",defaultValue:true},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},popinLayout:{type:"sap.m.PopinLayout",group:"Appearance",defaultValue:C.Block},contextualWidth:{type:"string",group:"Behavior",defaultValue:"Inherit"},autoPopinMode:{type:"boolean",group:"Behavior",defaultValue:false},hiddenInPopin:{type:"sap.ui.core.Priority[]",group:"Behavior"}},aggregations:{columns:{type:"sap.m.Column",multiple:true,singularName:"column",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_noColumnsMessage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ColumnListItem"},column:{type:"sap.m.Column"}}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}},popinChanged:{parameters:{hasPopin:{type:"boolean"},visibleInPopin:{type:"sap.m.Column[]"},hiddenInPopin:{type:"sap.m.Column[]"}}}},designtime:"sap/m/designtime/Table.designtime"},renderer:a});_.prototype.sNavItemClass="sapMListTblRow";_.prototype.init=function(){this._iItemNeedsTypeColumn=0;o.prototype.init.call(this)};_.prototype.setContextualWidth=function(e){var t=this.getContextualWidth();if(e==t){return this}if(typeof e==="number"){this._sContextualWidth=e+"px";this._sContextualWidth=this._sContextualWidth.toLowerCase()}else{var i=e.toLowerCase(),s=b[i];if(s){this._sContextualWidth=s+"px"}else{this._sContextualWidth=e}}var o=this._validateContextualWidth(this._sContextualWidth);this._iLastContextualWidth=t;if(o){this.setProperty("contextualWidth",e,true)}else{return this}if(this._iLastContextualWidth.toLowerCase()==="auto"){this._deregisterResizeHandler()}if(this._sContextualWidth.toLowerCase()==="auto"){this._registerResizeHandler();this._applyContextualWidth(this.$().width())}else{this._applyContextualWidth(this._sContextualWidth)}return this};_.prototype._validateContextualWidth=function(e){if(!e){return}if(typeof e!="string"){throw new Error('expected string for property "contextualWidth" of '+this)}if(e.toLowerCase()==="auto"||e.toLowerCase()==="inherit"){return true}if(!/^\d+(\.\d+)?(px)$/i.test(e)){throw new Error('invalid CSS size("px", "Auto", "auto", Inherit", "inherit" required) or sap.m.ScreenSize enumeration for property "contextualWidth" of '+this)}return true};_.prototype._applyContextualWidth=function(e){e=parseFloat(e)||0;if(Math.abs(this._oContextualSettings.contextualWidth-e)<=16){return}if(e&&this._oContextualSettings.contextualWidth!=e){this._applyContextualSettings({contextualWidth:e})}};_.prototype.setNoData=function(e){o.prototype.setNoData.apply(this,arguments);if(e&&typeof e!=="string"&&e.isA("sap.m.IllustratedMessage")){var t=this.getAggregation("_noColumnsMessage");if(!t){t=d.getNoColumnsIllustratedMessage();this.setAggregation("_noColumnsMessage",t)}}else if(e&&(typeof e==="string"||!e.isA("sap.m.IllustratedMessage"))){this.removeAllAggregation("_noColumnsMessage")}if(!this.shouldRenderItems()){if(this.getAggregation("_noColumnsMessage")){this.invalidate()}else{this.$("nodata-text").text(g.getResourceBundleFor("sap.m").getText("TABLE_NO_COLUMNS"))}}return this};_.prototype._onResize=function(e){this._applyContextualWidth(e.size.width)};_.prototype._registerResizeHandler=function(){if(!this._iResizeHandlerId){var e=this;window.requestAnimationFrame(function(){e._iResizeHandlerId=u.register(e,e._onResize.bind(e))})}};_.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){u.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null}};_.prototype.onBeforeRendering=function(){o.prototype.onBeforeRendering.call(this);this._configureAutoPopin();this._applyContextualWidth(this._sContextualWidth);this._notifyColumns("TableRendering")};_.prototype.onAfterRendering=function(){o.prototype.onAfterRendering.call(this);if(this.shouldRenderItems()){var e=this.getNavigationRoot();e.setAttribute("aria-colcount",this._colHeaderAriaOwns.length);e.setAttribute("aria-rowcount",this.getAccessbilityPosition().setsize);if(this._hasPopin){this.getDomRef("tblHeader").setAttribute("aria-owns",this._colHeaderAriaOwns.join(" "))}}if(!this.isPropertyInitial("showOverlay")){this._handleOverlay()}if(this._bFirePopinChanged){this._firePopinChangedEvent()}else{var i=this._getPopins();if(this._aPopins&&this.getVisibleItems().length){if(this._aPopins.length!=i.length||!i.every(function(e){return this._aPopins.indexOf(e)>-1},this)){this._aPopins=i;this._firePopinChangedEvent()}}else if(this._aPopins==null){this._aPopins=i}}if(this._bCheckLastColumnWidth&&t.isThemeApplied()){window.requestAnimationFrame(this._checkLastColumnWidth.bind(this))}};_.prototype.setHiddenInPopin=function(e){var t=this.getHiddenInPopin()||[],i=e||[];this.setProperty("hiddenInPopin",e);if(i.length!==t.length){this._bFirePopinChanged=true}else{this._bFirePopinChanged=!i.every(function(e){return t.includes(e)})}this._aPopins=this._getPopins();return this};_.prototype._handleOverlay=function(){var e=this.$("overlay");if(this.getShowOverlay()){var t=this.getDomRef();if(!e[0]){e=jQuery("<div></div>",{id:this.getId()+"-overlay",class:"sapUiOverlay sapMTableOverlay",role:"region",tabindex:"0","aria-labelledby":[a.getAriaLabelledBy(this),a.getAriaAnnouncement("TABLE_INVALID")].join(" ").trimLeft()}).appendTo(t)}if(t.contains(document.activeElement)){this._bIgnoreFocusIn=true;e.trigger("focus")}}else{if(document.activeElement==e[0]){this.focus()}e.remove()}};_.prototype._checkLastColumnWidth=function(){var e=this.$();var t=this.getTableDomRef();if(!e.length||!t){return}if(e[0].clientWidth<t.clientWidth){e.find(".sapMListTblCell:visible").eq(0).addClass("sapMTableForcedColumn").width("")}this._bCheckLastColumnWidth=false};_.prototype.setShowOverlay=function(e){var t=this.getDomRef()!=null;this.setProperty("showOverlay",e,t);if(t){this._handleOverlay()}return this};_.prototype.exit=function(){o.prototype.exit.call(this);if(this._selectAllCheckBox){this._selectAllCheckBox.destroy();this._selectAllCheckBox=null}if(this._clearAllButton){this._clearAllButton.destroy();this._clearAllButton=null}if(this._aPopinHeaders){this._aPopinHeaders.forEach(function(e){e.destroy()});this._aPopinHeaders=null}};_.prototype.destroyItems=function(){this._notifyColumns("ItemsRemoved");return o.prototype.destroyItems.apply(this,arguments)};_.prototype.removeSelections=function(){o.prototype.removeSelections.apply(this,arguments);this.updateSelectAllCheckbox();return this};_.prototype.selectAll=function(){o.prototype.selectAll.apply(this,arguments);this.updateSelectAllCheckbox();return this};_.prototype.getColumns=function(e){var t=this.getAggregation("columns",[]);if(e){t.sort(function(e,t){return e.getOrder()-t.getOrder()})}return t};_.prototype.getRenderedColumns=function(){return this.getColumns(true).filter(function(e){return e.getVisible()&&(e.isPopin()||!e.isHidden())}).sort(function(e,t){var i=e.getIndex(),s=t.getIndex(),o=i-s;if(o==0){return 0}if(i<0){return 1}if(s<0){return-1}return o})};_.prototype.setFixedLayout=function(e){if(e==undefined||e=="true"){e=true}else if(e=="false"){e=false}if(typeof e=="boolean"||e=="Strict"){return this.setProperty("fixedLayout",e)}throw new Error('"'+e+'" is an invalid value, expected false, true or "Strict" for the property fixedLayout of '+this)};_.prototype.shouldRenderItems=function(){return this.getColumns().some(function(e){return e.getVisible()})};_.prototype.shouldGrowingSuppressInvalidation=function(){if(this.getAutoPopinMode()){return false}return o.prototype.shouldGrowingSuppressInvalidation.call(this)};_.prototype.onItemTypeColumnChange=function(e,t){this._iItemNeedsTypeColumn+=t?1:-1;if(this._iItemNeedsTypeColumn==1&&t){this._setTypeColumnVisibility(true)}else if(this._iItemNeedsTypeColumn==0){this._setTypeColumnVisibility(false)}};_.prototype.onItemSelectedChange=function(e,t){clearTimeout(this._iSelectAllCheckboxTimer);this._iSelectAllCheckboxTimer=setTimeout(this.updateSelectAllCheckbox.bind(this));o.prototype.onItemSelectedChange.apply(this,arguments)};_.prototype.getTableDomRef=function(){return this.getDomRef("listUl")};_.prototype.getItemsContainerDomRef=function(){return this.getDomRef("tblBody")};_.prototype.onmousedown=function(e){this._bMouseDown=true;var t;var i=e.target.closest(".sapMTblCellFocusable:not([aria-haspopup])");if(i&&!document.activeElement.classList.contains("sapMTblCellFocusable")){t=i.getAttribute("tabindex");i.removeAttribute("tabindex")}setTimeout(function(){this._bMouseDown=false;t&&i.setAttribute("tabindex",t)}.bind(this));o.prototype.onmousedown.apply(this,arguments)};_.prototype._onItemNavigationBeforeFocus=function(e){var t=e.getParameter("event");if(this._bMouseDown&&!t.target.hasAttribute("tabindex")){return}var i;var s=-1;var o=e.getParameter("index");var n=this._colHeaderAriaOwns.length+1;var r=e.getSource();if(this._bMouseDown){var a=o-o%n;if(this._headerHidden||a||!this._columnHeadersActive){s=a}}else{var l=r.getItemDomRefs();var u=l[o];if(t.target.classList.contains("sapMTblCellFocusable")){var p=l.indexOf(t.target);if(t.type=="saphome"&&p%n!=1){s=o-o%n+1}else if(t.type=="sapend"&&p%n==n-1){s=p-n+1}else if(t.type.startsWith("sappage")&&p%n!=o%n){s=o-o%n+p%n}}else if(t.target.classList.contains("sapMLIBFocusable")){if(t.type.startsWith("sappage")){s=o-o%n;if(t.type=="sappageup"&&s==0&&r.getFocusedIndex()>n){s=n}}else if(t.type=="saphome"){s=0}else if(t.type=="sapend"){s=l.length-n}}if(s==-1&&u.classList.contains("sapMGHLICell")){s=o-1;i=s+r.getFocusedIndex()%n}}if(s!=-1){t.preventDefault();e.preventDefault();r.setFocusedIndex(s);r.getItemDomRefs()[s].focus();i&&r.setFocusedIndex(i)}};_.prototype.setNavigationItems=function(e){var t=this.getNavigationRoot();var i=t.querySelectorAll(".sapMListTblRow,.sapMGHLI,.sapMTblCellFocusable,.sapMTblItemNav");e.setItemDomRefs(Array.from(i));var s=this._colHeaderAriaOwns.length+1;var o=Math.min(this.getVisibleItems().length,this.getGrowingThreshold());e.setTableMode(true,false);e.setColumns(s);e.setPageSize(o*s);e.detachEvent("BeforeFocus",this._onItemNavigationBeforeFocus,this);e.attachEvent("BeforeFocus",this._onItemNavigationBeforeFocus,this);e.detachEvent("FocusAgain",this._onItemNavigationBeforeFocus,this);e.attachEvent("FocusAgain",this._onItemNavigationBeforeFocus,this);if(e.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==m.Upwards){e.setFocusedIndex(i.length-s)}else{e.setFocusedIndex(this._headerHidden?0:s)}}};_.prototype.checkGrowingFromScratch=function(){if(this.hasPopin()){return false}return this.getColumns().some(function(e){return e.getVisible()&&e.getMergeDuplicates()})};_.prototype.onColumnPress=function(e){var t=e.getHeaderMenuInstance();t&&t.openBy(e);if(this.bActiveHeaders&&!t){this.fireEvent("columnPress",{column:e})}};_.prototype.onColumnResize=function(e){this._bFirePopinChanged=true;this.invalidate()};_.prototype._setTypeColumnVisibility=function(e){if(!this._bItemsBeingBound&&!this._bRendering){this.invalidate()}};_.prototype._notifyColumns=function(e,t,i){this.getColumns().forEach(function(s){s["on"+e](t,i)})};_.prototype._getClearAllButton=function(){if(!this._clearAllButton){this._clearAllButton=new c({id:this.getId()+"-clearSelection",src:"sap-icon://clear-all",tooltip:g.getResourceBundleFor("sap.m").getText("TABLE_CLEARBUTTON_TOOLTIP"),decorative:false,press:this.removeSelections.bind(this,false,true,false)}).setParent(this,null,true).addEventDelegate({onAfterRendering:function(){this._clearAllButton.getDomRef().setAttribute("tabindex",-1)}},this);this.updateSelectAllCheckbox()}return this._clearAllButton};_.prototype._getSelectAllCheckbox=function(){if(this.bPreventMassSelection){return}if(!this._selectAllCheckBox){this._selectAllCheckBox=new r({id:this.getId("sa"),activeHandling:false,tooltip:g.getResourceBundleFor("sap.m").getText("TABLE_SELECT_ALL_TOOLTIP")}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).attachSelect(function(){if(this._selectAllCheckBox.getSelected()){this.selectAll(true)}else{this.removeSelections(false,true)}},this);this._selectAllCheckBox.useEnabledPropagator(false);this.updateSelectAllCheckbox()}return this._selectAllCheckBox};_.prototype.updateSelectAllCheckbox=function(){if(this.getMode()!=="MultiSelect"){return}d.hideSelectionLimitPopover();if(this._selectAllCheckBox&&this.getMultiSelectMode()!="ClearAll"){var e=this.getItems(),t=this.getSelectedItems().length,i=e.filter(function(e){return e.isSelectable()}).length;var s=e.length>0&&t==i;this.$("tblHeader").find(".sapMTblCellFocusable").addBack().attr("aria-selected",s);this._selectAllCheckBox.setSelected(s)}else if(this._clearAllButton){this._clearAllButton.toggleStyleClass("sapMTableDisableClearAll",!this.getSelectedItems().length)}};_.prototype.enhanceAccessibilityState=function(e,t){if(e==this._clearAllButton){t.label=g.getResourceBundleFor("sap.m").getText("TABLE_ICON_DESELECT_ALL")}else if(e==this._selectAllCheckBox){t.label=g.getResourceBundleFor("sap.m").getText("TABLE_CHECKBOX_SELECT_ALL")}};_.prototype.getColCount=function(){return this._colCount||0};_.prototype.shouldRenderDummyColumn=function(){return Boolean(this._dummyColumn)};_.prototype.hasPopin=function(){return Boolean(this._hasPopin)};_.prototype.doItemsNeedTypeColumn=function(){return Boolean(this._iItemNeedsTypeColumn)};_.prototype.hasHeaderRow=function(){return!this._headerHidden};_.prototype.isHeaderRowEvent=function(e){var t=this.$("tblHeader");return!!jQuery(e.target).closest(t,this.getTableDomRef()).length};_.prototype.isFooterRowEvent=function(e){var t=this.$("tblFooter");return!!jQuery(e.target).closest(t,this.getTableDomRef()).length};_.prototype.getAccessibilityType=function(){return g.getResourceBundleFor("sap.m").getText("TABLE_ROLE_DESCRIPTION")};_.prototype.getAccessbilityPosition=function(e){var t=o.prototype.getAccessbilityPosition.apply(this,arguments);if(e){t.posinset+=!this._headerHidden}if(t.setsize!=-1){t.setsize+=!this._headerHidden+!!this._hasFooter}return t};_.prototype._setHeaderAnnouncement=function(){var e=g.getResourceBundleFor("sap.m"),t=e.getText("ACC_CTR_TYPE_HEADER_ROW")+" ";if(this.isAllSelectableSelected()){t+=e.getText("LIST_ALL_SELECTED")}this.getColumns(true).forEach(function(e,i){if(!e.getVisible()||e.isHidden()){return}var s=e.getHeader();if(s&&s.getVisible()){t+=n.getAccessibilityText(s,false,true)+" . "}});this.updateInvisibleText(t)};_.prototype._setFooterAnnouncement=function(){var e=g.getResourceBundleFor("sap.m").getText("ACC_CTR_TYPE_FOOTER_ROW")+" ";this.getColumns(true).forEach(function(t,i){if(!t.getVisible()||t.isHidden()){return}var s=t.getFooter();if(s&&s.getVisible()){var o=t.getHeader();if(o&&o.getVisible()){e+=n.getAccessibilityText(o)+" "}e+=n.getAccessibilityText(s)+" "}});this.updateInvisibleText(e)};_.prototype._setNoColumnsMessageAnnouncement=function(e){if(!this.shouldRenderItems()){var i=this.getNoData();var s=t.getLibraryResourceBundle("sap.m").getText("TABLE_NO_COLUMNS");if(i&&typeof i!=="string"&&i.isA("sap.m.IllustratedMessage")){s=n.getAccessibilityText(this.getAggregation("_noColumnsMessage"))}this.updateInvisibleText(s,e)}};_.prototype.onsapspace=_.prototype.onsapenter=function(e){if(e.isMarked()){return}if(e.target.id==this.getId("tblHeader")||e.target.id==this.getId("tblHeadModeCol")){e.preventDefault();e.setMarked();var t=this.getMultiSelectMode();if(this._selectAllCheckBox&&t!="ClearAll"){this._selectAllCheckBox.setSelected(!this._selectAllCheckBox.getSelected()).fireSelect()}else if(this._clearAllButton&&t=="ClearAll"&&!this._clearAllButton.hasStyleClass("sapMTableDisableClearAll")){this._clearAllButton.firePress()}}};_.prototype.onsaptabprevious=function(e){if(e.target.id===this.getId("overlay")){this._bIgnoreFocusIn=true;this.$().attr("tabindex","-1").trigger("focus").removeAttr("tabindex")}else{o.prototype.onsaptabprevious.apply(this,arguments)}};_.prototype.focus=function(e){this._oFocusInfo=e;o.prototype.focus.apply(this,arguments);delete this._oFocusInfo};_.prototype.getFocusDomRef=function(){var e=this._oFocusInfo&&this._oFocusInfo.targetInfo&&l.isObjectA(this._oFocusInfo.targetInfo,"sap.ui.core.message.Message");if(e){var t=this.$("tblHeader");var i=t.find(".sapMListTblCell:visible");if(i.length){return t[0]}var s=this.$("nodata");if(s.length){return s[0]}}return o.prototype.getFocusDomRef.apply(this,arguments)};_.prototype.onfocusin=function(e){var t=e.target;if(t.id==this.getId("tblHeader")){this._setHeaderAnnouncement();this._setFirstLastVisibleCells(t)}else if(t.id==this.getId("tblFooter")){this._setFooterAnnouncement();this._setFirstLastVisibleCells(t)}else if(t.id==this.getId("nodata")){this._setFirstLastVisibleCells(t)}else if(!this._bIgnoreFocusIn&&this.getShowOverlay()){this._bIgnoreFocusIn=true;this.$("overlay").trigger("focus")}o.prototype.onfocusin.call(this,e);this._setNoColumnsMessageAnnouncement(t)};_.prototype.onThemeChanged=function(){o.prototype.onThemeChanged.call(this);if(this._bCheckLastColumnWidth){this._checkLastColumnWidth()}};_.prototype.onpaste=function(e){if(e.isMarked()||/^(input|textarea)$/i.test(e.target.tagName)){return}var t=p.getPastedDataAs2DArray(e.originalEvent);if(!t||t.length===0||t[0].length===0){return}this.firePaste({data:t})};_.prototype.ondragenter=function(e){var t=e.dragSession;if(!t||!t.getDropControl()||!t.getDropControl().isA("sap.m.Column")){return}t.setIndicatorConfig({height:this.getTableDomRef().clientHeight})};_.prototype._configureAutoPopin=function(){if(!this.getAutoPopinMode()){return}var e=this.getColumns(true).filter(function(e){return e.getVisible()});if(!e.length){return}var t=this.getItems();var i={High:[],Medium:[],Low:[]};e.forEach(function(e){var t=e.getImportance();if(t==="None"){t="Medium"}i[t].push(e)});var s=Object.values(i);var o=s.find(String)[0];s.reduce(function(e,t){return _._updateAccumulatedWidth(t,o,e)},this._getInitialAccumulatedWidth(t))};_.prototype._getInitialAccumulatedWidth=function(e){var t=this.getInset()?4:0;var i=this.$(),o=3;if(i.closest(".sapUiSizeCompact").length||jQuery(document.body).hasClass("sapUiSizeCompact")){o=2}else{var n=false;i.find(".sapMTableTH[aria-hidden=true]:not(.sapMListTblHighlightCol):not(.sapMListTblDummyCell):not(.sapMListTblNavigatedCol)").get().forEach(function(e){var t=jQuery(e).width();if(!n&&t>0){o=t/parseFloat(s.BaseFontSize);n=true}})}var r=h.ModeOrder[this.getMode()]?o:0;var a=e.some(function(e){var t=e.getType();return t==="Detail"||t==="DetailAndActive"||t==="Navigation"})?o:0;return t+r+a+.25};_._updateAccumulatedWidth=function(e,t,i){e.forEach(function(e){var o=e.getWidth();var n=o.replace(/[^a-z]/gi,"");var r=parseFloat(s.BaseFontSize)||16;if(n==="px"){i+=parseFloat(o)/r}else if(n==="em"||n==="rem"){i+=parseFloat(o)}else{i+=e.getAutoPopinWidth()}e.setDemandPopin(e!==t);e.setMinScreenWidth(e!==t?parseFloat(i).toFixed(2)+"rem":"")});return i};_.prototype._getHiddenInPopin=function(){return this._getPopins().filter(function(e){return!e.isPopin()})};_.prototype._getVisiblePopin=function(){return this._getPopins().filter(function(e){return e.isPopin()})};_.prototype._getPopins=function(){return this.getColumns().filter(function(e){return e.getVisible()&&e.getDemandPopin()&&e.isHidden()})};_.prototype._firePopinChangedEvent=function(){this._bFirePopinChanged=false;this._iVisibleItemsLength=this.getVisibleItems().length;this.fireEvent("popinChanged",{hasPopin:this.hasPopin(),visibleInPopin:this._getVisiblePopin(),hiddenInPopin:this._getHiddenInPopin()})};_.prototype._fireUpdateFinished=function(e){o.prototype._fireUpdateFinished.apply(this,arguments);this.updateSelectAllCheckbox();var t=this.getNavigationRoot();if(t){t.setAttribute("aria-rowcount",this.getAccessbilityPosition().setsize)}var i=Boolean(this.getVisibleItems().length);var s=Boolean(this._iVisibleItemsLength);if(i^s){this._firePopinChangedEvent()}};_.prototype.onItemFocusIn=function(e,t){o.prototype.onItemFocusIn.apply(this,arguments);if(e!=t||!i.isAccessibilityEnabled()){return}this._setFirstLastVisibleCells(e.getDomRef())};_.prototype._setFirstLastVisibleCells=function(e,t){var i=jQuery(e);if(!t&&!i.hasClass("sapMTableRowCustomFocus")){return}i.find(".sapMTblLastVisibleCell").removeClass("sapMTblLastVisibleCell");i.find(".sapMTblFirstVisibleCell").removeClass("sapMTblFirstVisibleCell");for(var s=e.firstChild;s&&!s.clientWidth;s=s.nextSibling){}for(var o=e.lastChild.classList.contains("sapMListTblDummyCell")?e.lastChild.previousSibling:e.lastChild;o&&!o.clientWidth;o=o.previousSibling){}jQuery(s).addClass("sapMTblFirstVisibleCell");jQuery(o).addClass("sapMTblLastVisibleCell");var n=i.next();if(n.attr("id")==i.attr("id")+"-sub"){this._setFirstLastVisibleCells(n[0],true)}};_.prototype.getAriaRole=function(){return"grid"};_.prototype._updateAriaRowCount=function(){var e=this.getNavigationRoot();if(!e){return}var t=this.getAccessbilityPosition().setsize;e.setAttribute("aria-rowcount",t)};_.prototype.validateAggregation=function(e,t,i){var s=o.prototype.validateAggregation.apply(this,arguments);if(e==="items"&&!l.isA(t,"sap.m.ITableItem")){f.error(t+" is not a valid items aggregation of "+this+". Items aggregation in ResponsiveTable control only supports ITableItem.");return s}if(e==="items"&&!l.isA(t,"sap.m.ITableItem")){throw Error(t+" is not a valid items aggregation of "+this+". Items aggregation in ResponsiveTable control only supports ITableItem.")}return s};_.prototype.setLastGroupHeader=function(){};return _});
//# sourceMappingURL=Table.js.map