/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/base/ManagedObjectObserver","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/Item","sap/ui/layout/HorizontalLayout","sap/ui/layout/Grid","sap/m/SearchField","sap/m/RadioButton","sap/m/ColumnListItem","sap/m/Column","sap/m/Text","sap/m/Bar","sap/m/Table","sap/m/Page","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/CheckBox","sap/m/Dialog","sap/m/Input","sap/m/Label","sap/m/Title","sap/m/ResponsivePopover","sap/m/SelectList","sap/m/ObjectIdentifier","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/VBox","sap/m/HBox","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/library","sap/m/library"],function(e,t,i,a,n,o,s,r,l,h,g,p,u,d,f,c,_,m,y,v,T,V,M,S,A,b,C,I,x,E,D,N,R,O,w,P,F,L,K){"use strict";var B=K.OverflowToolbarPriority;var G=K.ButtonType;var k=K.FlexAlignItems;var U=K.PlacementType;var $=K.PopinDisplay;var j=K.ScreenSize;var H=K.ListKeyboardMode;var z=L.ValueState;var X=L.TextAlign;var W=L.TitleLevel;var q=r.extend("sap.m.VariantManagement",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl"],library:"sap.m",designtime:"sap/m/designtime/VariantManagement.designtime",properties:{supportDefault:{type:"boolean",group:"Misc",defaultValue:true},supportFavorites:{type:"boolean",group:"Misc",defaultValue:true},supportApplyAutomatically:{type:"boolean",group:"Misc",defaultValue:true},supportPublic:{type:"boolean",group:"Misc",defaultValue:true},supportContexts:{type:"boolean",group:"Misc",defaultValue:false},selectedKey:{type:"string",group:"Misc",defaultValue:""},defaultKey:{type:"string",group:"Misc",defaultValue:""},showSaveAs:{type:"boolean",group:"Misc",defaultValue:true},creationAllowed:{type:"boolean",group:"Misc",defaultValue:true},showFooter:{type:"boolean",group:"Misc",defaultValue:true},modified:{type:"boolean",group:"Misc",defaultValue:false},popoverTitle:{type:"string",group:"Misc",defaultValue:""},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},level:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:W.Auto},titleStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:W.Auto},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},_displayTextForExecuteOnSelectionForStandardVariant:{type:"string",group:"Misc",defaultValue:"",visibility:"hidden"},_showAsText:{type:"boolean",group:"Misc",defaultValue:false,visibility:"hidden"},_selectStategyForSameItem:{type:"boolean",group:"Misc",defaultValue:true,visibility:"hidden"},_standardKey:{type:"string",group:"Misc",defaultValue:"",visibility:"hidden"}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.VariantItem",multiple:true,singularName:"item"}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"},public:{type:"boolean"},contexts:{type:"object[]"},tile:{type:"boolean"}}},cancel:{},manageCancel:{},manage:{parameters:{renamed:{type:"object[]"},deleted:{type:"string[]"},exe:{type:"object[]"},fav:{type:"object[]"},def:{type:"string"},contexts:{type:"object[]"}}},select:{parameters:{key:{type:"string"}}}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).style("max-width",t.getMaxWidth()).class("sapMVarMngmt").openEnd();e.renderControl(t.oVariantLayout);e.close("div")}}});q.INNER_MODEL_NAME="$sapMInnerVariants";q.MAX_NAME_LEN=100;q.COLUMN_FAV_IDX=0;q.COLUMN_NAME_IDX=1;q.COLUMN_DEFAULT_IDX=3;q.prototype.init=function(){r.prototype.init.apply(this,arguments);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oManagedObjectModel=new t(this);this.setModel(this._oManagedObjectModel,"$mVariants");this._oObserver=new n(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["items"]})};q.prototype._observeChanges=function(e){var t;if(e.type==="aggregation"){if(e.name==="items"){t=e.child;switch(e.mutation){case"insert":if(!this._oObserver.isObserved(t,{properties:["title","favorite","executeOnSelect","contexts"]})){this._oObserver.observe(t,{properties:["title","favorite","executeOnSelect","contexts"]})}if(this.getSelectedKey()===t.getKey()){this.refreshTitle()}break;case"remove":if(this._oObserver.isObserved(t,{properties:["title","favorite","executeOnSelect","contexts"]})){this._oObserver.unobserve(t,{properties:["title","favorite","executeOnSelect","contexts"]})}break;default:F.error("operation "+e.mutation+" not yet implemented")}}}else if(e.type==="property"){if(e.object.isA&&e.object.isA("sap.m.VariantItem")){t=e.object;if(t){if(this.getSelectedKey()===t.getKey()){this.refreshTitle()}if(!this.oManagementTable||this.oManagementTable.getItems&&this.oManagementTable.getItems().length===0){if(e.name==="title"){t._setOriginalTitle(e.current)}else if(e.name==="favorite"){t._setOriginalFavorite(e.current)}else if(e.name==="executeOnSelect"){t._setOriginalExecuteOnSelect(e.current)}else if(e.name==="contexts"){t._setOriginalContexts(e.current)}}}}}};q.prototype.applySettings=function(e,t){r.prototype.applySettings.apply(this,arguments);this._createInnerModel();this._initializeControl()};q.prototype.getDisplayTextForExecuteOnSelectionForStandardVariant=function(){return this.getProperty("_displayTextForExecuteOnSelectionForStandardVariant")};q.prototype.setDisplayTextForExecuteOnSelectionForStandardVariant=function(e){this.setProperty("_displayTextForExecuteOnSelectionForStandardVariant",e);return this};q.prototype.setShowAsText=function(e){this.setProperty("_showAsText",e);this._reCreateVariantTextControl();return this};q.prototype.getShowAsText=function(){return this.getProperty("_showAsText")};q.prototype.setShowFooter=function(e){this.setProperty("showFooter",e);return this};q.prototype.setDefaultKey=function(e){this.setProperty("defaultKey",e);return this};q.prototype.setPopoverTitle=function(e){this.setProperty("popoverTitle",e);return this};q.prototype._createVariantTextControl=function(){var e=this.getShowAsText()?_:I;var t=new e(this.getId()+"-text",{text:{path:"/selectedKey",model:"$mVariants",formatter:function(e){var t="";if(e){t=this.getSelectedVariantText(e);this._setInvisibleText(t,this.getModified())}return t}.bind(this)}});if(t.isA("sap.m.Title")){t.bindProperty("level",{path:"/level",model:"$mVariants"});t.bindProperty("titleStyle",{path:"/titleStyle",model:"$mVariants"})}t.addStyleClass("sapMVarMngmtClickable");t.addStyleClass("sapMVarMngmtTitle");return t};q.prototype._initializeControl=function(){if(this.oVariantInvisibleText){return}this.oVariantInvisibleText=new s;this.oVariantText=this._createVariantTextControl();var e=new _(this.getId()+"-modified",{text:"*",visible:{path:"/modified",model:"$mVariants",formatter:function(e){var t=this.getSelectedKey();if(t){this._setInvisibleText(this.getSelectedVariantText(t),e)}return e===null||e===undefined?false:e}.bind(this)}});e.setVisible(false);e.addStyleClass("sapMVarMngmtModified");e.addStyleClass("sapMVarMngmtClickable");this.oVariantPopoverTrigger=new M(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:G.Transparent,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_TRIGGER_TT"),enabled:{path:"/isDesignMode",model:q.INNER_MODEL_NAME,formatter:function(e){return!e}}});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapMVarMngmtClickable");this.oVariantLayout=new g({content:[this.oVariantText,e,this.oVariantPopoverTrigger]});this.oVariantLayout.addStyleClass("sapMVarMngmtLayout");this.oVariantLayout.addStyleClass("sapMVarMngmtLayoutModifiedHidden");e.setVisible(false);this.oVariantModifiedText=e;this.oVariantInvisibleText.toStatic();this.addDependent(this.oVariantLayout)};q.prototype._reCreateVariantTextControl=function(){if(!this.getShowAsText()&&this.oVariantText&&this.oVariantText.isA("sap.m.Title)")){return}if(!this.getShowAsText()&&this.oVariantText&&this.oVariantText.isA("sap.m.Text)")){return}if(this.oVariantText){this.oVariantLayout.removeContent(0);this.oVariantText.destroy()}var e=this._createVariantTextControl();this.oVariantLayout.insertContent(e,0);this.oVariantText=e};q.prototype.getOverflowToolbarConfig=function(){return{canOverflow:false,invalidationEvents:["save","manage","select"]}};q.prototype.getTitle=function(){return this.oVariantText};q.prototype.refreshTitle=function(){if(this.oVariantText){this.oVariantText.getBinding("text").refresh(true)}};q.prototype._setInvisibleText=function(e,t){var i;if(e){if(t){i="VARIANT_MANAGEMENT_SEL_VARIANT_MOD";this.oVariantLayout.removeStyleClass("sapMVarMngmtLayoutModifiedHidden")}else{i="VARIANT_MANAGEMENT_SEL_VARIANT";this.oVariantLayout.addStyleClass("sapMVarMngmtLayoutModifiedHidden")}this.oVariantInvisibleText.setText(this._oRb.getText(i,[e]))}};q.prototype._createInnerModel=function(){var t=new e({showCreateTile:false,isDesignMode:false});this.setModel(t,q.INNER_MODEL_NAME)};q.prototype._getShowCreateTile=function(){return this._getInnerModelProperty("/showCreateTile")};q.prototype._setShowCreateTile=function(e){this._setInnerModelProperty("/showCreateTile",e)};q.prototype.getDesignMode=function(){return this._getInnerModelProperty("/isDesignMode")};q.prototype.setDesignMode=function(e){this._setInnerModelProperty("/isDesignMode",e)};q.prototype._setInnerModelProperty=function(e,t){var i=this.getModel(q.INNER_MODEL_NAME);if(i){i.setProperty(e,t)}};q.prototype._getInnerModelProperty=function(e){var t=this.getModel(q.INNER_MODEL_NAME);if(t){return t.getProperty(e)}return null};q.prototype._getItems=function(){return this.getItems()};q.prototype.getSelectedVariantText=function(e){var t=this._getItemByKey(e);if(t){return t.getTitle()}return""};q.prototype.getStandardVariantKey=function(){var e=this.getProperty("_standardKey");if(!e){return this._getFirstVisibleVariant()}return e};q.prototype.setStandardVariantKey=function(e){this.setProperty("_standardKey",e)};q.prototype._getFirstVisibleVariant=function(){var e=this._getItems();for(var t=0;t<e.length;t++){if(!this._isItemDeleted(e[t])){if(this.getSupportFavorites()){if(e[t].getFavorite()){return e[t].getKey()}}else{return e[t].getKey()}}}return null};q.prototype._clearDeletedItems=function(){this._aDeletedItems=[]};q.prototype._addDeletedItem=function(e){var t=e.getKey();if(this._aDeletedItems.indexOf(t)<0){this._aDeletedItems.push(t)}};q.prototype._getDeletedItems=function(){return this._aDeletedItems};q.prototype._clearRenamedItems=function(){this._aRenamedItems=[]};q.prototype._addRenamedItem=function(e){var t=e.getKey();if(this._aRenamedItems.indexOf(t)<0){this._aRenamedItems.push(t)}};q.prototype._removeRenamedItem=function(e){var t=e.getKey();var i=this._aRenamedItems.indexOf(t);if(i>=0){this._aRenamedItems.splice(i,1)}};q.prototype._getRenamedItems=function(){return this._aRenamedItems};q.prototype.getItemByKey=function(e){return this._getItemByKey(e)};q.prototype._getItemByKey=function(e){var t=null;var i=this._getItems();if(i){i.some(function(i){if(i.getKey()===e){t=i}return t!==null})}return t};q.prototype._obtainControl=function(e){if(e&&e.target&&e.target.id){var t=e.target.id;var i=t.indexOf("-inner");if(i>0){t=t.substring(0,i)}return sap.ui.getCore().byId(t)}return null};q.prototype.handleOpenCloseVariantPopover=function(e){if(!this.bPopoverOpen){this._oCtrlRef=this._obtainControl(e);this._openVariantList()}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close()}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close()}};q.prototype.getFocusDomRef=function(){return this.oVariantPopoverTrigger.getFocusDomRef()};q.prototype.onclick=function(e){if(this.getDesignMode()){return}if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus()}this.handleOpenCloseVariantPopover(e)};q.prototype.onkeyup=function(e){if(e.which===P.F4||e.which===P.SPACE||e.altKey===true&&e.which===P.ARROW_UP||e.altKey===true&&e.which===P.ARROW_DOWN){this._oCtrlRef=this._obtainControl(e);this._openVariantList()}};q.prototype.onAfterRendering=function(){if(this.oVariantText){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapMVarMngmtTriggerBtnHover")}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapMVarMngmtTriggerBtnHover")}.bind(this))}};q.prototype._openInErrorState=function(){var e;if(!this.oErrorVariantPopOver){e=new O({fitContainer:true,alignItems:k.Center,items:[new l({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new I({titleStyle:W.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new _({textAlign:X.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});e.addStyleClass("sapMVarMngmtErrorPopover");this.oErrorVariantPopOver=new x(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:"$mVariants"},contentWidth:"400px",placement:U.VerticalPreferredBottom,content:[new v(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[e]})],afterOpen:function(){this.bPopoverOpen=true}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false}.bind(this),200)}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close()}}.bind(this))}if(this.bPopoverOpen){return}this.oErrorVariantPopOver.openBy(this.oVariantLayout)};q.prototype._createVariantList=function(){if(this.oVariantPopOver){return}this.oVariantManageBtn=new M(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog()}.bind(this),layoutData:new R({priority:B.Low})});this.oVariantSaveBtn=new M(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave()}.bind(this),visible:{parts:[{path:"$mVariants>/creationAllowed"},{path:"$mVariants>/modified"},{path:"$mVariants>/selectedKey"}],formatter:function(e,t,i){var a=false;var n=this._getItemByKey(i);if(n){a=n.getChangeable()}return e&&t&&a}.bind(this)},type:G.Emphasized,layoutData:new R({priority:B.Low})});this.oVariantSaveAsBtn=new M(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog()}.bind(this),layoutData:new R({priority:B.Low}),visible:{parts:[{path:"$mVariants>/creationAllowed"},{path:"$mVariants>/showSaveAs"}],formatter:function(e,t){return e&&t}}});this.oVariantList=new E(this.getId()+"-list",{selectedKey:{path:"/selectedKey",model:"$mVariants"},itemPress:function(e){var t=null;if(e&&e.getParameters()){var i=e.getParameters().item;if(i){t=i.getKey()}}if(t){var a=this.getProperty("_selectStategyForSameItem");if(a||!a&&this.getSelectedKey()!==t){this.setSelectedKey(t);this.fireSelect({key:t})}this.oVariantPopOver.close()}}.bind(this)});this.oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var e=new h({key:"{$mVariants>key}",text:"{$mVariants>title}"});this.oVariantList.bindAggregation("items",{path:"/items",model:"$mVariants",template:e});this._oSearchField=new u(this.getId()+"-search");this._oSearchField.attachLiveChange(function(e){this._triggerSearch(e,this.oVariantList)}.bind(this));this.oVariantSelectionPage=new v(this.getId()+"-selpage",{subHeader:new T({content:[this._oSearchField]}),content:[this.oVariantList],footer:new N({content:[new V(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false});this.oVariantSelectionPage.bindProperty("showFooter",{path:"/showFooter",model:"$mVariants"});this.oVariantPopOver=new x(this.getId()+"-popover",{title:{path:"/popoverTitle",model:"$mVariants"},titleAlignment:"Auto",contentWidth:"400px",placement:U.VerticalPreferredBottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false}.bind(this),200)}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapMVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact")}this.addDependent(this.oVariantPopOver);this.oVariantPopOver.isPopupAdaptationAllowed=function(){return false}};q.prototype._determineEmphasizedFooterButton=function(){if(this.oVariantSaveBtn.getVisible()){this.oVariantSaveBtn.setType(G.Emphasized);this.oVariantSaveAsBtn.setType(G.Default)}else{this.oVariantSaveAsBtn.setType(G.Emphasized)}};q.prototype.setModified=function(e){this.setProperty("modified",e);return this};q.prototype._openVariantList=function(){if(this.getInErrorState()){this._openInErrorState();return}if(this.bPopoverOpen){return}this._createVariantList();this._oSearchField.setValue("");this.oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this.oVariantList.getItems().length>9);this._determineEmphasizedFooterButton();var e=this.oVariantList.getSelectedItem();if(e){this.oVariantPopOver.setInitialFocus(e.getId())}var t=this._oCtrlRef?this._oCtrlRef:this.oVariantLayout;this._oCtrlRef=null;this.oVariantPopOver.openBy(t)};q.prototype._triggerSearch=function(e,t){if(!e){return}var n=e.getParameters();if(!n){return}var o=n.newValue?n.newValue:"";var s=new i({path:"title",operator:a.Contains,value1:o});t.getBinding("items").filter(this._getFilters(s))};q.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new b(this.getId()+"-name",{liveChange:function(){this._checkVariantNameConstraints(this.oInputName)}.bind(this)});var e=new C(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")});e.setLabelFor(this.oInputName);e.addStyleClass("sapMVarMngmtSaveDialogLabel");this.oDefault=new S(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/supportDefault",model:"$mVariants"},select:function(e){if(this._sStyleClass){if(e.getParameter("selected")){var t=this._getContextInfoChanges();if(this._isRestricted(t)){this.oDefault.setValueState(z.Error);this.oDefault.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NO_DEFAULT_ON_RESTRICTED_VIEWS"));this.oDefault.focus()}else{this.oDefault.setValueState(z.None);this.oDefault.setValueStateText("")}}else if(this.oDefault.getValueState()!=z.None){this.oDefault.setValueState(z.None);this.oDefault.setValueStateText("")}}}.bind(this),width:"100%"});this.oPublic=new S(this.getId()+"-public",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASPUBLIC"),visible:{path:"/supportPublic",model:"$mVariants"},width:"100%"});this.oExecuteOnSelect=new S(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/supportApplyAutomatically",model:"$mVariants"},width:"100%"});this.oCreateTile=new S(this.getId()+"-tile",{text:this._oRb.getText("VARIANT_MANAGEMENT_CREATETILE"),enabled:true,visible:{path:"/showCreateTile",model:q.INNER_MODEL_NAME},width:"100%"});this.oSaveSave=new M(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),type:G.Emphasized,press:function(){if(!this._bSaveOngoing){this._checkVariantNameConstraints(this.oInputName);if(this.oInputName.getValueState()==="Error"){this.oInputName.focus();return}this._bSaveOngoing=true;this._bSaveCanceled=false;var e=this._handleVariantSaveAs(this.oInputName.getValue());if(!e){this._bSaveOngoing=false}}}.bind(this),enabled:true});var t=new p({defaultSpan:"L12 M12 S12"});t.addContent(this.oDefault);t.addContent(this.oPublic);t.addContent(this.oExecuteOnSelect);t.addContent(this.oCreateTile);this.oSaveAsDialog=new A(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),afterClose:function(){this._bSaveOngoing=false;if(this._sStyleClass){this.setSupportPublic(this._bShowPublic);this.oSaveAsDialog.removeStyleClass(this._sStyleClass);if(this._oRolesComponentContainer){this.oSaveAsDialog.removeContent(this._oRolesComponentContainer)}this._sStyleClass=undefined;this._oRolesComponentContainer=null}}.bind(this),beginButton:this.oSaveSave,endButton:new M(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:this._cancelPressed.bind(this)}),content:[e,this.oInputName,t],stretch:o.system.phone});this.oSaveAsDialog.isPopupAdaptationAllowed=function(){return false};this.oSaveAsDialog.addStyleClass("sapUiContentPadding");this.oSaveAsDialog.addStyleClass("sapMVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact")}this.addDependent(this.oSaveAsDialog)}};q.prototype._cancelPressed=function(){this._bSaveCanceled=true;this.fireCancel();this.oSaveAsDialog.close()};q.prototype._getSelectedContexts=function(){return this._oRolesComponentContainer.getComponentInstance().getSelectedContexts()};q.prototype._setSelectedContexts=function(e){if(!e||Object.keys(e).length===0){e={role:[]}}this._oRolesComponentContainer.getComponentInstance().setSelectedContexts(e)};q.prototype._isInErrorContexts=function(){return this._oRolesComponentContainer.getComponentInstance().hasErrorsAndShowErrorMessage()};q.prototype._isRestricted=function(e){if(!e){e={role:[]}}return e.role&&e.role.length>0};q.prototype._determineRolesSpecificText=function(e,t){if(t){t.setText(this._oRb.getText(this._isRestricted(e.getContexts())?"VARIANT_MANAGEMENT_VISIBILITY_RESTRICTED":"VARIANT_MANAGEMENT_VISIBILITY_NON_RESTRICTED"))}};q.prototype._checkAndAddRolesContainerToManageDialog=function(){if(this._oRolesComponentContainer&&this._oRolesDialog){var e=null;this._oRolesDialog.getContent().some(function(t){if(t===this._oRolesComponentContainer){e=t;return true}return false}.bind(this));if(!e){this._oRolesDialog.addContent(this._oRolesComponentContainer)}}};q.prototype._createRolesDialog=function(){if(!this._oRolesDialog){this._oRolesDialog=new A(this.getId()+"-roledialog",{draggable:true,resizable:true,contentWidth:"40%",title:this._oRb.getText("VARIANT_MANAGEMENT_SELECTROLES_DIALOG"),beginButton:new M(this.getId()+"-rolesave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),type:G.Emphasized,press:function(){if(!this._checkAndCreateContextInfoChanges(this._oCurrentContextsKey,this._oTextControl)){return}this._oRolesDialog.close()}.bind(this)}),endButton:new M(this.getId()+"-rolecancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._oRolesDialog.close()}.bind(this)}),content:[this._oRolesComponentContainer],stretch:o.system.phone});this._oRolesDialog.setParent(this);this._oRolesDialog.addStyleClass("sapUiContentPadding");this._oRolesDialog.addStyleClass(this._sStyleClass);this._oRolesDialog.isPopupAdaptationAllowed=function(){return false}}this._checkAndAddRolesContainerToManageDialog()};q.prototype._openRolesDialog=function(e,t){this._createRolesDialog();this._oCurrentContextsKey=e.getKey();this._oTextControl=t;this._setSelectedContexts(e.getContexts());this._oRolesDialog.open()};q.prototype._checkAndCreateContextInfoChanges=function(e,t){if(e){if(this._oRolesComponentContainer){try{if(!this._isInErrorContexts()){var i=this._getSelectedContexts();var a=this._getItemByKey(e);if(a){a.setContexts(i);this._determineRolesSpecificText(a,t);this._checkDefaultEnabled(a)}}else{return false}}catch(e){return false}}return true}return false};q.prototype._checkAndAddRolesContainerToSaveAsDialog=function(){if(this._oRolesComponentContainer&&this.oSaveAsDialog){var e=null;this.oSaveAsDialog.getContent().some(function(t){if(t===this._oRolesComponentContainer){e=t;return true}return false}.bind(this));this._setSelectedContexts({role:[]});if(!e){this.oSaveAsDialog.addContent(this._oRolesComponentContainer)}}};q.prototype.openSaveAsDialog=function(e,t){this._openSaveAsDialog(true);this.oSaveAsDialog.addStyleClass(e);this._sStyleClass=e;this._bShowPublic=this.getSupportPublic();this.setSupportPublic(false);if(t){Promise.all([t]).then(function(e){this._oRolesComponentContainer=e[0];this.setSupportContexts(!!this._oRolesComponentContainer);this._checkAndAddRolesContainerToSaveAsDialog();this.oSaveAsDialog.open()}.bind(this))}else{this.oSaveAsDialog.open()}};q.prototype._openSaveAsDialog=function(e){this._createSaveAsDialog();this.setSupportContexts(false);this.oInputName.setValue(this.getSelectedVariantText(this.getSelectedKey()));this.oInputName.setEnabled(true);this.oInputName.setValueState(z.None);this.oInputName.setValueStateText(null);this.oDefault.setEnabled(true);this.oDefault.setSelected(false);if(this.oDefault.getValueState()!==z.None){this.oDefault.setValueState(z.None);this.oDefault.setValueStateText("")}this.oPublic.setSelected(false);this.oExecuteOnSelect.setSelected(false);this.oCreateTile.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close()}if(!e){this.oSaveAsDialog.open()}};q.prototype._handleVariantSaveAs=function(e){var t=null;var i=e.trim();if(i===""){this.oInputName.setValueState(z.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return false}var a=this._getContextInfoChanges();var n=this._isRestricted(a);if(n&&this.oDefault.getSelected()){this.oDefault.setValueState(z.Error);this.oDefault.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NO_DEFAULT_ON_RESTRICTED_VIEWS"));this.oDefault.focus();return false}else if(!n){var o=this.oDefault.getValueState()!==z.None;this.oDefault.setValueState(z.None);this.oDefault.setValueStateText("");if(o){return false}}if(this.oSaveAsDialog){this.oSaveAsDialog.close()}var s={key:t,name:i,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected(),public:this.getSupportPublic()?this.oPublic.getSelected():undefined,contexts:a};if(this._getShowCreateTile()&&this.oCreateTile){s.tile=this.oCreateTile.getSelected()}this.destroyManageDialog();this.fireSave(s);return true};q.prototype._getContextInfoChanges=function(){if(this._oRolesComponentContainer){try{if(!this._isInErrorContexts()){return this._getSelectedContexts()}}catch(e){return undefined}}return undefined};q.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getSelectedKey());var t=false;if(this.getDefaultKey()===e.getKey()){t=true}if(this.oVariantPopOver){this.oVariantPopOver.close()}this.fireSave({name:e.getTitle(),overwrite:true,key:e.getKey(),def:t})};q.prototype.destroyManageDialog=function(){if(this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined}};q.prototype.openManagementDialog=function(e,t,i){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined}if(t){this._sStyleClass=t;this._bShowPublic=this.getSupportPublic();this.setSupportPublic(false);this.setSupportContexts(false)}if(i){Promise.all([i]).then(function(e){this._oRolesComponentContainer=e[0];this.setSupportContexts(!!this._oRolesComponentContainer);this._openManagementDialog();if(this._sStyleClass){this.oManagementDialog.addStyleClass(this._sStyleClass)}}.bind(this))}else{this._openManagementDialog();if(this._sStyleClass){this.oManagementDialog.addStyleClass(this._sStyleClass)}}};q.prototype._triggerSearchInManageDialog=function(e,t){if(!e){return}var i=e.getParameters();if(!i){return}var a;if(i.query){a=i.query}else{a=i.newValue?i.newValue:""}this._triggerSearchInManageDialogByValue(a,t)};q.prototype._triggerSearchInManageDialogByValue=function(e,t){var n=[this._getVisibleFilter(),new i({filters:[new i({path:"title",operator:a.Contains,value1:e}),new i({path:"author",operator:a.Contains,value1:e})],and:false})];t.getBinding("items").filter(n);this._bRebindRequired=true};q.prototype.getManageDialog=function(){return this.oManagementDialog};q.prototype._createManagementDialog=function(){if(!this.oManagementDialog||this.oManagementDialog.bIsDestroyed){this.oManagementTable=new y(this.getId()+"-managementTable",{contextualWidth:"Auto",fixedLayout:false,growing:true,keyboardMode:H.Edit,columns:[new c({header:new s({text:this._oRb.getText("VARIANT_MANAGEMENT_FAVORITE_COLUMN")}),width:"3rem",visible:{path:"/supportFavorites",model:"$mVariants"}}),new c({header:new _({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"16rem"}),new c({header:new _({text:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTTYPE"),wrappingType:"Hyphenated"}),visible:{path:"/supportPublic",model:"$mVariants"},demandPopin:true,popinDisplay:$.Inline,minScreenWidth:j.Tablet}),new c({header:new _({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT"),wrappingType:"Hyphenated"}),hAlign:X.Center,demandPopin:true,popinDisplay:$.Block,minScreenWidth:j.Tablet,visible:{path:"/supportDefault",model:"$mVariants"}}),new c({header:new _({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),wrappingType:"Hyphenated"}),hAlign:this.getDisplayTextForExecuteOnSelectionForStandardVariant()?X.Begin:X.Center,demandPopin:true,popinDisplay:$.Block,minScreenWidth:j.Tablet,visible:{path:"/supportApplyAutomatically",model:"$mVariants"}}),new c({header:new _({text:this._oRb.getText("VARIANT_MANAGEMENT_VISIBILITY"),wrappingType:"Hyphenated"}),width:"8rem",demandPopin:true,popinDisplay:$.Inline,minScreenWidth:j.Tablet,visible:{path:"/supportContexts",model:"$mVariants"}}),new c({header:new _({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR"),wrappingType:"Hyphenated"}),demandPopin:true,popinDisplay:$.Block,minScreenWidth:j.Tablet}),new c({header:new s({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")}),hAlign:X.Center}),new c({visible:false})]});this.oManagementSave=new M(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),enabled:true,type:G.Emphasized,press:function(){if(this._handleManageSavePressed()&&this.oManagementDialog){this.oManagementDialog.close()}}.bind(this)});this.oManagementCancel=new M(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._resumeManagementTableBinding();this._handleManageCancelPressed();if(this.oManagementDialog){this.oManagementDialog.close()}}.bind(this)});this.oManagementDialog=new A(this.getId()+"-managementdialog",{contentWidth:"64%",resizable:true,draggable:true,title:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG"),beginButton:this.oManagementSave,endButton:this.oManagementCancel,afterClose:function(){if(this._sStyleClass){this.setSupportPublic(this._bShowPublic,true);this.oManagementDialog.removeStyleClass(this._sStyleClass);this._sStyleClass=undefined;this._oRolesComponentContainer=null}}.bind(this),content:[this.oManagementTable],stretch:o.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false};this._oSearchFieldOnMgmtDialog=new u;this._oSearchFieldOnMgmtDialog.attachLiveChange(function(e){this._triggerSearchInManageDialog(e,this.oManagementTable)}.bind(this));this._oSearchFieldOnMgmtDialog.attachSearch(function(e){this._triggerSearchInManageDialog(e,this.oManagementTable)}.bind(this));var e=new m(this.getId()+"-mgmHeaderSearch",{contentMiddle:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);this.oManagementDialog.setInitialFocus(this._oSearchFieldOnMgmtDialog);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact")}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"/items",model:"$mVariants",factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bRebindRequired=false}};q.prototype._setFavoriteIcon=function(e,t){if(e){e.setSrc(t?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(t?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));e.setAlt(this._oRb.getText(t?"VARIANT_MANAGEMENT_FAV_DEL_ACC":"VARIANT_MANAGEMENT_FAV_ADD_ACC"))}};q.prototype._checkDefaultEnabled=function(e){var t=true;if(this._isRestricted(e.getContexts())){t=false;if(e.getKey()===this.getDefaultKey()){this.setDefaultKey(this.getStandardVariantKey())}}var i=this._getRowForKey(e.getKey());if(i){i.getCells()[q.COLUMN_DEFAULT_IDX].setEnabled(t);this._toggleIconActivityState(i.getCells()[0],e,false)}};q.prototype._templateFactoryManagementDialog=function(e,t){var i=null;var a;var n;var o;var s;var r=t.getObject();if(!r){F.error("couldn't obtain the item for '"+t.getPath()+"'");return undefined}var h=this._determineIndex(t.getPath());if(h<0){F.error("couldn't obtain item position for '"+t.getPath()+"'");return undefined}var g=this.getId()+"-manage";var p="$mVariants";var u=function(e){var t=e.oSource.getBindingContext(p).getObject();this._handleManageTitleChange(e.oSource,t)}.bind(this);var c=function(e){var t=e.oSource.getBindingContext(p).getObject();this._handleManageTitleChange(e.oSource,t)}.bind(this);var m=function(e){this._handleManageDefaultVariantChange(e.oSource,e.oSource.getBindingContext(p).getObject(),e.getParameters().selected)}.bind(this);var y=function(e){this._handleManageDeletePressed(e.oSource.getBindingContext(p).getObject());this._reCheckVariantNameConstraints()}.bind(this);var v=function(e){this._handleManageFavoriteChanged(e.oSource,e.oSource.getBindingContext(p).getObject())}.bind(this);var T=function(e){var t=e.oSource.getBindingContext(p).getObject();this._openRolesDialog(t,e.oSource.getParent().getItems()[0])}.bind(this);if(r.getRename()){n=new b(g+"-input-"+h,{liveChange:u,change:c,value:"{"+p+">title}"});if(r.getTitle()!==r._getOriginalTitle()){this._verifyVariantNameConstraints(n,r.getKey(),r.getTitle())}}else{n=new D(g+"-text-"+h,{title:"{"+p+">title}"});if(i){n.setTooltip(i)}}a=new M(g+"-del-"+h,{icon:"sap-icon://decline",enabled:true,type:G.Transparent,press:y,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:r.getRemove()});var V=new l(g+"-fav-"+h,{src:{path:"favorite",model:p,formatter:function(e){return e?"sap-icon://favorite":"sap-icon://unfavorite"}},tooltip:{path:"favorite",model:p,formatter:function(e){return this._oRb.getText(e?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP")}.bind(this)},press:v,decorative:false});if(this.getStandardVariantKey()===r.getKey()||this.getDefaultKey()===r.getKey()){this._setIconStyleClass(V,"sapMVarMngmtFavNonInteractiveColor")}else{this._setIconStyleClass(V,"sapMVarMngmtFavColor")}if(this.getDisplayTextForExecuteOnSelectionForStandardVariant()&&this.getStandardVariantKey()===r.getKey()){o=new S(g+"-exe-"+h,{wrapping:true,text:"{"+p+">/_displayTextForExecuteOnSelectionForStandardVariant}",selected:"{"+p+">executeOnSelect}"})}else{o=new S(g+"-exe-"+h,{text:"",selected:"{"+p+">executeOnSelect}"})}var A;if(this._sStyleClass&&this.getSupportContexts()&&r.getKey()!==this.getStandardVariantKey()){A=new _({wrapping:false});this._determineRolesSpecificText(r,A);var C=new l({src:"sap-icon://edit",press:T});C.addStyleClass("sapMVarMngmtRolesEdit");C.setTooltip(this._oRb.getText("VARIANT_MANAGEMENT_VISIBILITY_ICON_TT"));s=new w(g+"-role-"+h,{items:[A,C]})}else{s=new _}var I=new d(g+"-def-"+h,{groupName:this.getId(),select:m,selected:{path:"/defaultKey",model:p,formatter:function(e){return r.getKey()===e}}});if(A&&this._isRestricted(r.getContexts())){I.setEnabled(false);if(this.getDefaultKey()===r.getKey()){this.setDefaultKey(this.getStandardVariantKey())}}var x=new f({cells:[V,n,new _(g+"-type-"+h,{text:{path:"sharing",model:p,formatter:function(e){return this._oRb.getText(e==="private"?"VARIANT_MANAGEMENT_PRIVATE":"VARIANT_MANAGEMENT_PUBLIC")}.bind(this)},textAlign:"Center"}),I,o,s,new _(g+"-author-"+h,{text:"{"+p+">author}",textAlign:"Begin",wrappingType:"Hyphenated"}),a,new _({text:"{"+p+">key}"})]});if(this._isItemDeleted(r)){x.setVisible(false)}return x};q.prototype._openManagementDialog=function(){this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close()}this._suspendManagementTableBinding();this._clearDeletedItems();this._clearRenamedItems();this._sDefaultKey=this.getDefaultKey();this._sOriginalDefaultKey=this._sDefaultKey;this._oSearchFieldOnMgmtDialog.setValue("");if(this._bRebindRequired){this._bRebindRequired=false;if(!this.oManagementTable.getBinding("items")){this.oManagementTable.bindAggregation("items",{path:"/items",model:"$mVariants",factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()})}else{this.oManagementTable.getBinding("items").filter(this._getVisibleFilter())}}this.oManagementDialog.open()};q.prototype._toggleIconActivityState=function(e,t,i){if(!e){return}if(!t||t.getKey()===this.getStandardVariantKey()){return}if(i&&e.hasStyleClass("sapMVarMngmtFavColor")){e.removeStyleClass("sapMVarMngmtFavColor");this._setIconStyleClass(e,"sapMVarMngmtFavNonInteractiveColor")}else if(e.hasStyleClass("sapMVarMngmtFavNonInteractiveColor")){e.removeStyleClass("sapMVarMngmtFavNonInteractiveColor");this._setIconStyleClass(e,"sapMVarMngmtFavColor")}};q.prototype._setIconStyleClass=function(e,t){if(e){e.addStyleClass(t);e.setNoTabStop(t==="sapMVarMngmtFavNonInteractiveColor")}};q.prototype._handleManageTitleChange=function(e,t){this._checkVariantNameConstraints(e,t.getKey());this._addRenamedItem(t)};q.prototype._handleManageDefaultVariantChange=function(e,t,i){var a=t.getKey();if(e){var n=e.getParent().getCells()[q.COLUMN_FAV_IDX];if(i){if(this.getSupportFavorites()&&!t.getFavorite()){t.setFavorite(true);var o=this._getRowForKey(t.getKey());if(o){var s=o.getCells();if(s){n=s[q.COLUMN_FAV_IDX];this._setFavoriteIcon(n,true);s[q.COLUMN_FAV_IDX+3].focus()}}}this.setDefaultKey(a)}this._toggleIconActivityState(n,t,i)}};q.prototype._handleManageCancelPressed=function(){if(this._getDeletedItems().length>0){this._getDeletedItems().forEach(function(e){var t=this._getRowForKey(e);if(t&&!t.getVisible()){t.setVisible(true)}}.bind(this));this._clearDeletedItems()}this._resetToOriginal();if(this._sOriginalDefaultKey!==this.getDefaultKey()){var e=this.getDefaultKey();this.setDefaultKey(this._sOriginalDefaultKey);if(e!==this.getStandardVariantKey()){var t=this._getRowForKey(e);if(t){var i=t.getCells()[q.COLUMN_FAV_IDX];this._toggleIconActivityState(i,this._getItemByKey(e),false)}}}this._clearRenamedItems();this._bRebindRequired=true;this.oManagementTable.unbindItems();if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate()}this.fireManageCancel()};q.prototype._handleManageFavoriteChanged=function(e,t){if(this.getStandardVariantKey()===t.getKey()){return}if(this.getDefaultKey()===t.getKey()&&t.getFavorite()){return}t.setFavorite(!t.getFavorite());var i=this._getRowForKey(t.getKey());if(i){i.getCells()[q.COLUMN_FAV_IDX].focus()}};q.prototype._handleManageDeletePressed=function(e){var t=e.getKey();if(this.getStandardVariantKey()===t){return}this._addDeletedItem(e);if(t===this.getDefaultKey()){this.setDefaultKey(this.getStandardVariantKey());if(this.getSupportFavorites()){var i=this._getItemByKey(this.getStandardVariantKey());if(i&&!i.getFavorite()){var a=this._getRowForKey(this.getStandardVariantKey());if(a){i.setFavorite(true);this._setFavoriteIcon(a.getCells()[q.COLUMN_FAV_IDX],true)}}}}var n=this._getRowForKey(e.getKey());if(n){n.setVisible(false)}this.oManagementCancel.focus()};q.prototype._collectManageData=function(){var e={};var t=this.getDefaultKey();if(t!==this._sOriginalDefaultKey){e.def=t}this.getItems().forEach(function(t){const i=this._isItemDeleted(t);if(i){if(!e.deleted){e.deleted=[]}e.deleted.push(t.getKey())}if(!i&&t.getFavorite()!==t._getOriginalFavorite()){if(!e.fav){e.fav=[]}e.fav.push({key:t.getKey(),visible:t.getFavorite()});t._setOriginalFavorite(t.getFavorite())}if(!i&&t.getTitle()!==t._getOriginalTitle()){if(!e.renamed){e.renamed=[]}e.renamed.push({key:t.getKey(),name:t.getTitle()});t._setOriginalTitle(t.getTitle())}if(!i&&t.getExecuteOnSelect()!==t._getOriginalExecuteOnSelect()){if(!e.exe){e.exe=[]}e.exe.push({key:t.getKey(),exe:t.getExecuteOnSelect()});t._setOriginalExecuteOnSelect(t.getExecuteOnSelect())}if(!i&&this._hasContextsChanged(t)){if(!e.contexts){e.contexts=[]}e.contexts.push({key:t.getKey(),contexts:t.getContexts()});t._setOriginalContexts(t.getContexts())}}.bind(this));return e};q.prototype._resetToOriginal=function(){this.getItems().forEach(function(e){e.setTitle(e._getOriginalTitle());e.setFavorite(e._getOriginalFavorite());e.setExecuteOnSelect(e._getOriginalExecuteOnSelect());e.setContexts(e._getOriginalContexts())})};q.prototype._hasContextsChanged=function(e){return JSON.stringify(e.getContexts())!==JSON.stringify(e._getOriginalContexts())};q.prototype._handleManageSavePressed=function(){if(this._anyInErrorState(this.oManagementTable)){return false}if(this._getDeletedItems().length>0){this._bRebindRequired=true}if(this._getRenamedItems().length>0){this._bRebindRequired=true;if(this._getRenamedItems().indexOf(this.getSelectedKey())>=0){var e=this.oVariantText.getBinding("text");if(e){e.checkUpdate(true)}}}if(this._bRebindRequired){this.oManagementTable.unbindItems()}this.fireManage(this._collectManageData());if(this.oManagementDialog){this._resumeManagementTableBinding()}return true};q.prototype._resumeManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.resume()}}};q.prototype._suspendManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.suspend()}}};q.prototype._focusOnFirstInputInErrorState=function(e){if(e){e.getItems().some(function(e){var t=e.getCells()[q.COLUMN_NAME_IDX];if(t&&t.getValueState&&t.getValueState()===z.Error){t.getDomRef().scrollIntoView();t.focus();return true}return false})}};q.prototype._isItemDeleted=function(e){const t=this._getDeletedItems();if(!e||!t){return false}return t.indexOf(e.getKey())>-1};q.prototype._anyInErrorStateManageTable=function(e){var t=false;if(e){e.getItems().some(function(e){if(e.getVisible()){var i=e.getCells()[q.COLUMN_NAME_IDX];if(i&&i.getValueState&&i.getValueState()===z.Error){t=true}}return t})}return t};q.prototype._anyInErrorState=function(e){if(this._anyInErrorStateManageTable(e)){return true}var t=this._getRenamedItems();for(var i=t.length-1;i>=0;i--){var a=this._getItemByKey(t[i]);if(a){if(a.getTitle()===a._getOriginalTitle()){this._removeRenamedItem(a)}}}var n=false;this._getRenamedItems().some(function(e,t){var i=this._getItemByKey(e);if(i){n=this._checkIsDuplicateInModel(i.getTitle(),e)}return n}.bind(this));if(n){this._oSearchFieldOnMgmtDialog.setValue("");this._triggerSearchInManageDialogByValue("",e);this._focusOnFirstInputInErrorState(e)}return n};q.prototype._getRowForKey=function(e){var t=null;if(this.oManagementTable){this.oManagementTable.getItems().some(function(i){var a=i.getCells()[0].getParent();var n=this.getModel("$mVariants").getObject(a.getBindingContextPath());if(e===n.getKey()){t=i}return t!==null}.bind(this))}return t};q.prototype._determineIndex=function(e){var t=-1;var i=e.indexOf("/",1);if(i>0){t=parseInt(e.substring(i+1))}return t};q.prototype._getFilters=function(e){var t=[];if(e){t.push(e)}t.push(this._getVisibleFilter());if(this.getSupportFavorites()){t.push(this._getFavoriteFilter())}return t};q.prototype._getVisibleFilter=function(){return new i({path:"visible",operator:a.EQ,value1:true})};q.prototype._getFavoriteFilter=function(){return new i({path:"favorite",operator:a.EQ,value1:true})};q.prototype._verifyVariantNameConstraints=function(e,t,i){if(!e){return}var a=i||e.getValue();a=a.trim();if(!this._checkIsDuplicate(a,t)){if(a===""){e.setValueState(z.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"))}else if(a.indexOf("{")>-1){e.setValueState(z.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]))}else if(a.length>q.MAX_NAME_LEN){e.setValueState(z.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[q.MAX_NAME_LEN]))}else{e.setValueState(z.None);e.setValueStateText(null)}}else{e.setValueState(z.Error);if(this._oSearchFieldOnMgmtDialog&&this._oSearchFieldOnMgmtDialog.getValue()){e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE_SAVE"))}else{e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"))}}};q.prototype._checkVariantNameConstraints=function(e,t){this._verifyVariantNameConstraints(e,t);if(this.oManagementDialog&&this.oManagementDialog.isOpen()){this._reCheckVariantNameConstraints()}};q.prototype._reCheckVariantNameConstraints=function(){var e;var t=false;if(this.oManagementTable){e=this.oManagementTable.getItems();e.some(function(e){var i=e.getBindingContext("$mVariants").getObject();if(i&&i.getVisible()){var a=e.getCells()[q.COLUMN_NAME_IDX];if(a&&a.getValueState&&a.getValueState()===z.Error){this._verifyVariantNameConstraints(a,i.getKey());if(a.getValueState()===z.Error){t=true}}}return t}.bind(this))}return t};q.prototype._checkIsDuplicate=function(e,t){if(this.oManagementDialog&&this.oManagementDialog.isOpen()){var i=this._checkIsDuplicateInManageTable(e,t);if(this._oSearchFieldOnMgmtDialog&&this._oSearchFieldOnMgmtDialog.getValue()&&i){return i}}return this._checkIsDuplicateInModel(e,t)};q.prototype._checkIsDuplicateInModel=function(e,t){var i=false;var a=this._getItems();var n=e.toLowerCase();a.some(function(e){if(e.getTitle().toLowerCase()===n){if(t&&t===e.getKey()){return false}i=true}return i});return i};q.prototype._checkIsDuplicateInManageTable=function(e,t){var i;var a=false;var n=e.toLowerCase();if(this.oManagementTable){i=this.oManagementTable.getItems();i.some(function(e){var i;var o=e.getBindingContext("$mVariants").getObject();if(o&&o.getVisible()){var s=e.getCells()[q.COLUMN_NAME_IDX];if(s&&o.getKey()!==t){if(s.isA("sap.m.Input")){i=s.getValue().toLowerCase()}else{i=s.getTitle().toLowerCase()}if(i===n){a=true}}}return a})}return a};q.prototype._getToolbarInteractive=function(){return true};q.prototype.exit=function(){var e;this._oObserver.disconnect();this._oObserver=undefined;r.prototype.exit.apply(this,arguments);this._clearDeletedItems();this._clearRenamedItems();if(this.oVariantInvisibleText&&!this.oVariantInvisibleText._bIsBeingDestroyed){this.oVariantInvisibleText.destroy(true);this.oVariantInvisibleText=undefined}if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy()}this.oDefault=undefined;if(this.oPublic&&!this.oPublic._bIsBeingDestroyed){this.oPublic.destroy()}this.oPublic=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy()}this.oExecuteOnSelect=undefined;if(this.oCreateTile&&!this.oCreateTile._bIsBeingDestroyed){this.oCreateTile.destroy()}this.oCreateTile=undefined;this._oRb=undefined;this.oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantModifiedText=undefined;this.oVariantPopoverTrigger=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;this._sDefaultKey=undefined;this._oCtrlRef=undefined;e=this.getModel(q.INNER_MODEL_NAME);if(e){e.destroy()}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();this._oManagedObjectModel=undefined}this._oRolesComponentContainer=null;if(this._oRolesDialog&&!this._oRolesDialog._bIsBeingDestroyed){this._oRolesDialog.destroy();this._oRolesDialog=null}};return q});
//# sourceMappingURL=VariantManagement.js.map