//@ui5-bundle sap/m/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AccButton", ["./Button","./AccButtonRenderer"],function(e,a){"use strict";var n=e.extend("sap.m.AccButton",{metadata:{library:"sap.m",properties:{tabIndex:{type:"string",defaultValue:null,bindable:"bindable"},ariaHidden:{type:"string",defaultValue:null,bindable:"bindable"},ariaHaspopup:{type:"string",defaultValue:null,bindable:"bindable"}}},renderer:a});return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AccButtonRenderer", ["./ButtonRenderer","sap/ui/core/Renderer"],function(e,t){"use strict";var i=t.extend(e);i.apiVersion=2;i.renderAccessibilityAttributes=function(e,t){if(t.getTabIndex()){e.attr("tabindex",t.getTabIndex())}if(t.getAriaHidden()){e.attr("aria-hidden",t.getAriaHidden())}if(t.getAriaHaspopup()){e.attr("aria-haspopup",t.getAriaHaspopup())}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ActionListItem", ["./ListItemBase","./library","./ActionListItemRenderer"],function(t,e,n){"use strict";var r=e.ListMode;var i=e.ListType;var o=t.extend("sap.m.ActionListItem",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null}}},renderer:n});o.prototype.init=function(){this.setType(i.Active);t.prototype.init.apply(this,arguments)};o.prototype.getMode=function(){return r.None};o.prototype.onsapspace=o.prototype.onsapenter;o.prototype.getContentAnnouncement=function(){return this.getText()};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ActionListItemRenderer", ["./ListItemBaseRenderer","sap/ui/core/Renderer"],function(e,t){"use strict";var n=t.extend(e);n.apiVersion=2;n.renderLIAttributes=function(e,t){e.class("sapMALI")};n.renderLIContent=function(e,t){var n=t.getText();if(n){e.openStart("div").class("sapMALIText").openEnd();e.text(n);e.close("div")}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ActionSelect", ["./Select","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/core/Core","./ActionSelectRenderer"],function(t,e,o,s,i){"use strict";var n=t.extend("sap.m.ActionSelect",{metadata:{library:"sap.m",associations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"}}},renderer:i});n.prototype.init=function(){t.prototype.init.call(this);this.getList().addEventDelegate({onfocusin:this.onfocusinList},this)};n.prototype.hasContent=function(){return t.prototype.hasContent.call(this)||!!this.getButtons().length};n.prototype.addContentToFlex=function(){var t=this.getSimpleFixFlex();this.getButtons().forEach(function(e){t.addFlexContent(s.byId(e))})};n.prototype._onBeforeRenderingPopover=function(){t.prototype._onBeforeRenderingPopover.call(this);var e=this.getPicker();e&&e._setAriaRoleApplication(true);this._updateTutorMessage()};n.prototype.onAfterRenderingPicker=function(){t.prototype.onAfterRenderingPicker.call(this);var e=this.getPicker(),o=this.getRenderer();e.addStyleClass(o.CSS_CLASS+"Picker");e.addStyleClass(o.ACTION_SELECT_CSS_CLASS+"Picker");e.addStyleClass(o.ACTION_SELECT_CSS_CLASS+"Picker-CTX")};n.prototype.createPickerCloseButton=function(){};n.prototype.removeButton=function(t){var e=this.getSimpleFixFlex();if(e){if(typeof t==="number"){t=this.getButtons()[t]}e.removeFlexContent(t)}return this.removeAssociation("buttons",t)};n.prototype.removeAllButtons=function(){var t=this.getSimpleFixFlex();if(t){this.getButtons().forEach(function(e){t.removeFlexContent(s.byId(e))})}return this.removeAllAssociation("buttons")};n.prototype.onsaptabprevious=function(t){var e=this.getButtons(),o=this.getPicker(),i;this._bProcessChange=false;if(t.isMarked()||!this.getEnabled()){return}t.setMarked();if(o&&o.isOpen()&&e.length>0){for(i=e.length-1;i>=0;i--){if(s.byId(e[i]).getEnabled()){s.byId(e[i]).focus();t.preventDefault();break}}}};n.prototype.onsaptabnext=function(t){var e=this.getButtons(),o=this.getPicker(),i;this._bProcessChange=false;if(t.isMarked()||!this.getEnabled()){return}t.setMarked();if(o&&o.isOpen()&&e.length>0){for(i=0;i<e.length;i++){if(s.byId(e[i]).getEnabled()){s.byId(e[i]).focus();t.preventDefault();break}}}};n.prototype.onsapfocusleave=function(e){var o=this.getButtons();var s=o.indexOf(e.relatedControlId)===-1;if(s){t.prototype.onsapfocusleave.apply(this,arguments)}this._toggleListFocusIndication(true)};n.prototype.onfocusinList=function(t){if(document.activeElement!==this.getList().getDomRef()&&!o.system.phone){this.focus()}};n.prototype.onfocusin=function(){t.prototype.onfocusin.apply(this,arguments);this._toggleListFocusIndication(false)};n.prototype._toggleListFocusIndication=function(t){var e=this.getSelectedItem();if(this.isOpen()&&e){e.$().toggleClass("sapMActionSelectItemWithoutFocus",t)}};n.prototype._updateTutorMessage=function(){var t=this.getPicker(),o=t.getAriaLabelledBy(),i=!!this.getButtons().length,n;if(!this._sTutorMessageId){this._sTutorMessageId=this._getTutorMessageId();this._oTutorMessageText=new e(this._sTutorMessageId,{text:s.getLibraryResourceBundle("sap.m").getText("ACTION_SELECT_TUTOR_MESSAGE")}).toStatic()}n=o.indexOf(this._sTutorMessageId)===-1;if(n&&i){t.addAriaLabelledBy(this._sTutorMessageId)}else{if(!i){t.removeAriaLabelledBy(this._sTutorMessageId)}}};n.prototype._getTutorMessageId=function(){return this.getId()+"-tutorMessage"};n.prototype.exit=function(){t.prototype.exit.call(this);if(this._oTutorMessageText){this._oTutorMessageText.destroy();this._oTutorMessageText=null}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ActionSelectRenderer", ["sap/ui/core/Renderer","./SelectRenderer"],function(e,S){"use strict";var n=e.extend(S);n.ACTION_SELECT_CSS_CLASS="sapMActionSelect";n.apiVersion=2;n.addClass=function(e,S){e.class(n.ACTION_SELECT_CSS_CLASS)};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ActionSheet", ["./Dialog","./Popover","./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","sap/ui/Device","./ActionSheetRenderer","./Button","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(t,e,n,i,o,s,a,r,p,jQuery,l){"use strict";var c=n.ButtonType;var h=n.DialogType;var u=n.PlacementType;var f=i.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:u.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},defaultAggregation:"buttons",events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}},cancelButtonPress:{}},designtime:"sap/m/designtime/ActionSheet.designtime"},renderer:r});f.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);this._actionSelected=null};f.prototype.exit=function(){a.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null}this._clearItemNavigation()};f.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}};f.prototype._setItemNavigation=function(){var t=this._getAllButtons(),e=[],n=this.getDomRef();if(n){this._oItemNavigation.setRootDomRef(n);for(var i=0;i<t.length;i++){if(t[i].getEnabled()&&t[i].getVisible()){e.push(t[i].getFocusDomRef())}}if(this._oCancelButton){e.push(this._oCancelButton.getFocusDomRef())}this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]})}};f.prototype.onmousedown=function(t){if(t.srcControl.isA("sap.m.Button")&&this.getButtons().indexOf(t.srcControl)!==-1){this._actionSelected=t.srcControl}};f.prototype.onBeforeRendering=function(){var t,e;this._clearItemNavigation();t=this.getTitle();if(this._parent&&!this.isPropertyInitial("title")&&this._parent.getTitle()!==t){if(a.system.phone){this._parent.setTitle(t);this._parent.setShowHeader(!!t)}if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle")}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle")}}e=this.getPlacement();if(this._parent&&!a.system.phone&&!this.isPropertyInitial("placement")&&this._parent.setPlacement()!==e){this._parent.setPlacement(e)}};f.prototype.onAfterRendering=function(){this._oItemNavigation=new o;this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation()};f.prototype.sapfocusleave=function(){this.close()};f.prototype.openBy=function(n){var i=this;if(!this._parent){var o=this.getParent();if(o){this.setParent(null)}if(!a.system.phone){this._parent=new e({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){i.fireBeforeOpen()},afterOpen:function(){i.focus();i.fireAfterOpen()},beforeClose:function(){i.fireBeforeClose()},afterClose:function(){if(i.getShowCancelButton()){i.fireCancelButtonTap();i.fireCancelButtonPress()}i._onAfterClose(i._actionSelected);i._actionSelected=null},ariaLabelledBy:this.getPopupHiddenLabelId()||undefined}).addStyleClass("sapMActionSheetPopover");this._parent._setAriaRoleApplication(true)}else{this._parent=new t({title:this.getTitle(),type:h.Standard,content:[this],beforeOpen:function(){i.fireBeforeOpen()},afterOpen:function(){i.focus();i.fireAfterOpen()},beforeClose:function(t){i.fireBeforeClose({origin:t.getParameter("origin")})},afterClose:function(t){i._actionSelected=t.getParameter("origin");i._onAfterClose(i._actionSelected);i._actionSelected=null;a.resize.detachHandler(i._fnOrientationChange)}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle")}else{this._parent.addAriaLabelledBy(this.getPopupHiddenLabelId()||undefined)}if(!a.system.phone){this._parent.setBeginButton(this._getCancelButton())}if(a.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){t.prototype._setDimensions.apply(this);this.$("cont").css("max-height","")};this._parent._adjustScrollingPane=function(){var t=this.$().height();this.$("cont").css("max-height",t);if(this._oScroller){this._oScroller.refresh()}}}}if(o){o.addDependent(this._parent)}}if(!a.system.phone){this._parent.openBy(n)}else{this._parent.open();a.resize.attachHandler(this._fnOrientationChange)}};f.prototype.close=function(){if(this._parent){this._parent.close()}};f.prototype.isOpen=function(){return!!this._parent&&this._parent.isOpen()};f.prototype._createCancelButton=function(){if(!this._oCancelButton){var t=this.getCancelButtonText()?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),e=this;this._oCancelButton=new p(this.getId()+"-cancelBtn",{text:t,type:c.Reject,press:function(){if(a.system.phone&&e._parent){e._parent._oCloseTrigger=this}e.close();e.fireCancelButtonTap();e.fireCancelButtonPress()}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(a.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true)}}return this};f.prototype._getCancelButton=function(){if(a.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton}return null};f.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t)}return this};f.prototype._preProcessActionButton=function(t){var e=t.getType();if(e!==c.Accept&&e!==c.Reject){t.setType(c.Transparent)}t.addStyleClass("sapMBtnInverted");if(!t.getIcon()){t.addStyleClass("sapMActionSheetButtonNoIcon")}t.addStyleClass("sapMActionSheetButton");this._parent&&this._parent.invalidate();return this};f.prototype._buttonSelected=function(){if(a.system.phone&&this._parent){this._parent._oCloseTrigger=this}this.close()};f.prototype._orientationChange=function(){this._parent._adjustScrollingPane()};f.prototype._addAriaHiddenTexts=function(t){var e=t.getId(),n;if(l.getAccessibility()){n=new s(e+"-actionSheetHiddenText");this.addAggregation("_invisibleAriaTexts",n,false);t.addAriaDescribedBy(n.getId())}};f.prototype._removeAriaHiddenTexts=function(t){t.getAriaDescribedBy().forEach(function(e){var n=sap.ui.getCore().byId(e);if(n instanceof s&&e.indexOf("actionSheetHiddenText")>-1){this.removeAggregation("_invisibleAriaTexts",n,false);t.removeAriaDescribedBy(n);n.destroy()}},this)};f.prototype.addButton=function(t){this.addAggregation("buttons",t,false);this._addAriaHiddenTexts(t);this._preProcessActionButton(t);t.attachPress(this._buttonSelected,this);return this};f.prototype.insertButton=function(t,e){this.insertAggregation("buttons",t,e,false);this._addAriaHiddenTexts(t);this._preProcessActionButton(t);t.attachPress(this._buttonSelected,this);return this};f.prototype.removeButton=function(t){var e=this.removeAggregation("buttons",t,false);if(e){e.detachPress(this._buttonSelected,this);this._removeAriaHiddenTexts(e)}return e};f.prototype.removeAllButtons=function(){var t=this.removeAllAggregation("buttons",false),e=this;jQuery.each(t,function(t,n){n.detachPress(e._buttonSelected,e);e._removeAriaHiddenTexts(n)});return t};f.prototype.clone=function(){var t=this.getButtons();for(var e=0;e<t.length;e++){t[e].detachPress(this._buttonSelected,this)}var n=i.prototype.clone.apply(this,arguments);for(var o=0;o<t.length;o++){t[o].attachPress(this._buttonSelected,this)}return n};f.prototype._getAllButtons=function(){return this.getButtons()};f.prototype.getPopupHiddenLabelId=function(){return s.getStaticId("sap.m","ACTIONSHEET_AVAILABLE_ACTIONS")};f.prototype._applyContextualSettings=function(){i.prototype._applyContextualSettings.call(this)};f.prototype._onAfterClose=function(t){this.fireAfterClose({origin:t})};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ActionSheetRenderer", ["sap/ui/Device","sap/ui/core/Configuration"],function(e,t){"use strict";var i={apiVersion:2};i.render=function(i,n){var r=n._getAllButtons(),o=n.getAggregation("_invisibleAriaTexts"),s=sap.ui.getCore().getLibraryResourceBundle("sap.m"),a=r.length,l=t.getAccessibility(),u=r.filter(function(e){return e.getVisible()}).length,g,c,f,d,p=1,A=function(e){return o.filter(function(t){return t.getId().indexOf(e.getId())>-1})[0]};for(c=0;c<a;c++){d=r[c];if(d.getIcon()&&d.getVisible()){f=true}}i.openStart("div",n);i.class("sapMActionSheet");if(f){i.class("sapMActionSheetMixedButtons")}var C=n.getTooltip_AsString();if(C){i.attr("title",C)}l&&i.attr("role","presentation");i.openEnd();for(c=0;c<a;c++){d=r[c];i.renderControl(r[c]);if(l&&d.getVisible()){g=A(d);if(g){g.setText(s.getText("ACTIONSHEET_BUTTON_INDEX",[p,u]));i.renderControl(g)}p++}}if(e.system.phone&&n.getShowCancelButton()){i.renderControl(n._getCancelButton())}i.close("div")};return i},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/m/ActionTile", ["./library","sap/m/GenericTile","sap/m/ToDoCardRenderer","sap/m/GenericTileRenderer"],function(e,t,i,o){"use strict";var s=e.FrameType,r=e.GenericTileMode,n=e.LoadState;var a=t.extend("sap.m.ActionTile",{metadata:{library:"sap.m"},renderer:{apiVersion:2,render:function(e,t){if(!t.getHeaderImage()||t.getState()===n.Loading){i.render(e,t)}else{o.render(e,t)}}}});a.prototype.init=function(){this.addStyleClass("sapMAT");this.setMode(r.ActionMode);this.setFrameType(s.TwoByOne);t.prototype.init.apply(this,arguments)};a.prototype.onBeforeRendering=function(){if(this.getHeaderImage()){this.addStyleClass("sapMATSituationCard")}if(this.getEnableNavigationButton()){this.removeStyleClass("sapMATHideActionButton")}else{this.addStyleClass("sapMATHideActionButton")}t.prototype.onBeforeRendering.apply(this,arguments)};a.prototype.onAfterRendering=function(){if(this.getHeaderImage()&&this.getDomRef()){this._removeStyleClasses()}t.prototype.onAfterRendering.apply(this,arguments)};a.prototype._removeStyleClasses=function(){this.getDomRef().classList.remove("sapMGT");this.getDomRef().classList.remove("TwoByOne");this.getDomRef().classList.remove("sapMGTActionMode")};a.prototype._getSizeDescription=function(){return this._oRb.getText("ACTION_TILE_SIZE")};return a});
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/m/ActionTileContent", ["./library","sap/m/TileContent","sap/m/ActionTileContentRenderer"],function(t,e,r){"use strict";var i=t.Priority;var n=e.extend("sap.m.ActionTileContent",{metadata:{library:"sap.m",aggregations:{attributes:{type:"sap.m.CustomAttribute",multiple:true,singularName:"attribute"}}},renderer:{apiVersion:2,render:function(t,e){r.render(t,e)}}});n.prototype.getAltText=function(){var t="";var e=this.getPriorityText();var r=this.getAggregation("attributes");if(this.getPriority()!==i.None&&e){t+=e+"\n"}for(var n=0;n<r.length&&n<4;n++){t+=r[n].getLabel()+"\n"+r[n].getValue()+"\n"}return t.trim()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ActionTileContentRenderer", ["./library"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,r){var n=e.Priority;t.openStart("div",r);t.class("sapMATC");t.openEnd();if(r.getPriority()!==n.None&&r.getPriorityText()){this._renderPriority(t,r)}this._renderContent(t,r);t.close("div")};t._renderPriority=function(e,t){var r=t.getPriorityText();e.openStart("div",t.getId()+"-priority-value");e.class("sapMTilePriorityValue");e.class(t.getPriority());e.openEnd();e.text(r);e.close("div")};t._renderContent=function(e,t){e.openStart("div",t.getId()+"-contentContainer");e.class("sapMContainer");e.openEnd();t.getAttributes().forEach(function(r,n){this._renderAttribute(e,t,r,n)}.bind(this));e.close("div")};t._renderAttribute=function(e,t,r,n){e.openStart("div",t.getId()+"-wrapper-"+n);e.class("sapMElementWrapper");e.openEnd();this._renderElement(e,t,r,n,true);this._renderElement(e,t,r,n,false);e.close("div")};t._renderElement=function(e,t,r,n,i){var o=i?"sapMATCLabel":"sapMATCValue",a=i?"-label":"-value",s=i?r.getLabel():r.getValue();e.openStart("div",t.getId()+"-"+n+a);e.class(o);e.openEnd();e.text(s);e.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AdditionalTextButton", ["./Button","./AdditionalTextButtonRenderer"],function(t,e){"use strict";var r=t.extend("sap.m.AdditionalTextButton",{metadata:{library:"sap.m",properties:{additionalText:{type:"string",group:"Misc",defaultValue:""}}},renderer:e});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AdditionalTextButtonRenderer", ["./ButtonRenderer","sap/ui/core/Renderer","sap/ui/core/library","sap/ui/core/AccessKeysEnablement"],function(t,e,n,i){"use strict";var o=n.TextDirection;var r=e.extend(t);r.apiVersion=2;r.writeButtonText=function(t,e,n,r){t.openStart("span",e.getId()+"-content");t.class("sapMBtnContent");if(n!==o.Inherit){t.attr("dir",n.toLowerCase())}if(e.getProperty("highlightAccKeysRef")){t.class(i.CSS_CLASS)}t.openEnd();if(r){t.openStart("bdi",e.getId()+"-BDI-content");t.openEnd()}t.text(e.getText());if(r){t.close("bdi")}if(e.getAdditionalText()){var a=r?"bdi":"span";t.openStart(a,e.getId()+"-additionalText-BDI-content");t.class("sapMBtnContentAddText");t.openEnd();t.text(e.getAdditionalText());t.close(a)}t.close("span")};r.renderButtonAttributes=function(t){t.class("sapMBtnAdditionalTextContent")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/App", ["./NavContainer","./library","./AppRenderer","sap/ui/util/Mobile","sap/base/Log","sap/ui/thirdparty/jquery"],function(e,t,a,o,n,jQuery){"use strict";var r=e.extend("sap.m.App",{metadata:{library:"sap.m",properties:{homeIcon:{type:"any",group:"Misc",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1},mobileWebAppCapable:{type:"boolean",group:"Appearance",defaultValue:true},isTopLevel:{type:"boolean",group:"Behavior",defaultValue:true}},events:{orientationChange:{deprecated:true,parameters:{landscape:{type:"boolean"}}}}},renderer:a});r.prototype.init=function(){e.prototype.init.apply(this,arguments);this.addStyleClass("sapMApp");o.init({viewport:!this._debugZoomAndScroll,statusBar:"default",hideBrowser:true,preventScroll:!this._debugZoomAndScroll,rootId:this.getId()});jQuery(window).on("resize",jQuery.proxy(this._handleOrientationChange,this))};r.prototype.onBeforeRendering=function(){if(e.prototype.onBeforeRendering){e.prototype.onBeforeRendering.apply(this,arguments)}o.init({homeIcon:this.getHomeIcon(),mobileWebAppCapable:this.getMobileWebAppCapable()})};r.prototype.onAfterRendering=function(){if(e.prototype.onAfterRendering){e.prototype.onAfterRendering.apply(this,arguments)}if(this.getIsTopLevel()){this._adjustParentsHeight()}};r.prototype._adjustParentsHeight=function(){if(!this.getDomRef()){return}var e=this.getDomRef().parentNode;while(e&&e!==document.documentElement){var t=jQuery(e);if(t.attr("data-sap-ui-root-content")){break}if(!e.style.height){e.style.height="100%"}e=e.parentNode}};r.prototype.exit=function(){jQuery(window).off("resize",this._handleOrientationChange);if(this._sInitTimer){clearTimeout(this._sInitTimer)}};r.prototype._handleOrientationChange=function(){var e=jQuery(window);var t=e.width()>e.height();if(this._oldIsLandscape!==t){this.fireOrientationChange({landscape:t});this._oldIsLandscape=t}};r.prototype.setBackgroundOpacity=function(e){if(e>1||e<0){n.warning("Invalid value "+e+" for App.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this}this.$("BG").css("opacity",e);return this.setProperty("backgroundOpacity",e,true)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AppRenderer", ["./NavContainerRenderer","sap/ui/core/Renderer","sap/m/library"],function(e,r,n){"use strict";var a=n.BackgroundHelper;var t=r.extend(e);t.apiVersion=2;t.renderAttributes=function(e,r){a.addBackgroundColorStyles(e,r.getBackgroundColor(),r.getBackgroundImage())};t.renderBeforeContent=function(e,r){a.renderBackgroundImageTag(e,r,"sapMAppBG",r.getBackgroundImage(),r.getBackgroundRepeat(),r.getBackgroundOpacity())};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AssociativeOverflowToolbar", ["sap/base/Log","./OverflowToolbar","./OverflowToolbarRenderer","sap/ui/Device"],function(t,e,o,n){"use strict";var r=e.extend("sap.m.AssociativeOverflowToolbar",{metadata:{associations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},renderer:o});r.prototype.getContent=function(){var t=this.getAssociation("content")||[];var e=[];t.forEach(function(t){var o=sap.ui.getCore().byId(t);if(o){e.push(o)}});return e};r.prototype.insertContent=function(e,o){var n=e.getId(),r=this.getAssociation("content").filter(function(t){return t!==n});var i;if(o<0){i=0}else if(o>r.length){i=r.length}else{i=o}if(i!==o){t.warning("AssociativeOverflowToolbar.insertContent: index '"+o+"' out of range [0,"+r.length+"], forced to "+i)}r.splice(i,0,n);this.removeAllAssociation("content");r.forEach(function(t){this.addAssociation("content",t)},this);return this};r.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._callToolbarMethod("destroyContent",[true])};r.prototype.indexOfContent=function(t){var e=this.getAssociation("content")||[];return e.indexOf(t.getId())};r.prototype._handleResize=function(){if(n.system.phone){this._resetAndInvalidateToolbar()}else{this._bControlsInfoCached=false;e.prototype._handleResize.apply(this,arguments)}};r.prototype._callToolbarMethod=function(t,o){switch(t){case"addContent":return this.addAssociation("content",o[0]);case"getContent":return this.getContent();case"insertContent":return this.insertContent(o[0],o[1]);case"removeContent":return sap.ui.getCore().byId(this.removeAssociation("content",o[0],o[1],o[2]))||null;case"destroyContent":this.removeAllAssociation("content",o[0]);return this;case"removeAllContent":return this.removeAllAssociation("content",o[0]).map(function(t){return sap.ui.getCore().byId(t)});default:return e.prototype._callToolbarMethod.call(this,t,o)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Avatar", ["sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Icon","./library","sap/ui/core/library","sap/ui/core/InvisibleText","sap/m/imageUtils/getCacheBustedUrl"],function(e,t,a,i,s,o,r,n,l,p){"use strict";var u=r.AvatarType;var h=r.AvatarImageFitType;var c=r.AvatarColor;var g=r.AvatarSize;var d=r.AvatarShape;var f=n.aria.HasPopup;var I=n.ValueState;var _=Object.keys(c).filter(function(e){return e.indexOf("Accent")!==-1});var y=e.extend("sap.m.Avatar",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:d.Circle},displaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:g.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.m.AvatarImageFitType",group:"Appearance",defaultValue:h.Cover},fallbackIcon:{type:"string",group:"Data",defaultValue:null},backgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:c.Accent6},showBorder:{type:"boolean",group:"Appearance",defaultValue:false},badgeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},badgeTooltip:{type:"string",group:"Data",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:false},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:f.None},badgeValueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:I.None},enabled:{type:"boolean",group:"Behavior",defaultValue:true},active:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{detailBox:{type:"sap.m.LightBox",multiple:false,bindable:"bindable"},_badge:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/Avatar.designtime"},renderer:a});y.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";y.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";y.AVATAR_BADGE_TOOLTIP={"sap-icon://zoom-in":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_ZOOMIN"),"sap-icon://camera":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_CAMERA"),"sap-icon://edit":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_EDIT")};y.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;this._sImageFallbackType=null;this._sPickedRandomColor=null;this._badgeRef=null};y.prototype.onBeforeRendering=function(){if(this._getImageCustomData()&&!this._iCacheBustingValue){this._setNewCacheBustingValue()}};y.prototype.onAfterRendering=function(){this._checkInitialsHolderWidth()};y.prototype.onThemeChanged=function(){this._checkInitialsHolderWidth()};y.prototype.exit=function(){if(this._fnLightBoxOpen){this._fnLightBoxOpen=null}if(this._badgeRef){this._badgeRef.destroy()}if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}this._sPickedRandomColor=null};y.prototype.setDetailBox=function(e){var t=this.getDetailBox();if(e){if(e===t){return this}if(t){this.detachPress(this._fnLightBoxOpen,t)}this._fnLightBoxOpen=e.open;this.attachPress(this._fnLightBoxOpen,e)}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,t);this._fnLightBoxOpen=null}return this.setAggregation("detailBox",e)};y.prototype.setBadgeValueState=function(e){Object.keys(I).forEach(function(t){this.toggleStyleClass("sapFAvatar"+t,t===e)}.bind(this));this.setProperty("badgeValueState",e,true);return this};y.prototype.clone=function(){var t=e.prototype.clone.apply(this,arguments),a=t.getDetailBox();if(a){t.detachPress(this._fnLightBoxOpen,this.getDetailBox());t._fnLightBoxOpen=a.open;t.attachPress(t._fnLightBoxOpen,a)}return t};y.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);e.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button")}return this};y.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);e.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().attr("role","img")}return this};y.prototype.ontap=function(){this._handlePress()};y.prototype.onkeydown=function(e){if(e.which===i.SHIFT||e.which===i.ESCAPE){this._bShouldInterupt=this._bSpacePressed}if(e.which===i.SPACE){this._bSpacePressed=true;e.preventDefault()}if(e.which===i.ENTER){this._handlePress()}};y.prototype.onkeyup=function(e){if(e.which===i.SPACE){if(!this._bShouldInterupt){this._handlePress()}this._bShouldInterupt=false;this._bSpacePressed=false;e.stopPropagation()}};y.prototype._handlePress=function(){if(!this.getEnabled()){return}this.firePress({})};y.prototype._areInitialsValid=function(e){var t=/^[a-zA-Z\xc0-\xd6\xd8-\xdc\xe0-\xf6\xf8-\xfc]{1,3}$/;if(!t.test(e)){s.warning("Initials should consist of only 1,2 or 3 latin letters",this);this._sActualType=u.Icon;this._bIsDefaultIcon=true;return false}return true};y.prototype._validateSrc=function(e){if(t.isIconURI(e)){this._sActualType=u.Icon;this._bIsDefaultIcon=t.getIconInfo(e)?false:true}else{this._bIsDefaultIcon=true;this._sActualType=u.Image;this.preloadedImage=new window.Image;this.preloadedImage.src=e;this.preloadedImage.onload=this._onImageLoad.bind(this);this.preloadedImage.onerror=this._onImageError.bind(this)}return this};y.prototype._getDisplayIcon=function(e){return t.isIconURI(e)&&t.getIconInfo(e)?t.createControlByURI({src:e}):null};y.prototype._getActualDisplayType=function(){var e=this._getAvatarSrc(),t=this.getInitials();if(e){this._validateSrc(e)}else if(t&&this._areInitialsValid(t)){this._sActualType=u.Initials}else{s.warning("No src and initials were provided",this);this._sActualType=u.Icon;this._bIsDefaultIcon=true}return this._sActualType};y.prototype._getImageFallbackType=function(){var e=this.getInitials();this._sImageFallbackType=e&&this._areInitialsValid(e)?u.Initials:u.Icon;return this._sImageFallbackType};y.prototype._getDefaultIconPath=function(e){var a=null,i=this.getFallbackIcon();if(i&&t.isIconURI(i)){a=i}else if(e===d.Circle){a=y.DEFAULT_CIRCLE_PLACEHOLDER}else if(e===d.Square){a=y.DEFAULT_SQUARE_PLACEHOLDER}return a};y.prototype._getIcon=function(){var e=this.getSrc(),a=this.getAggregation("_icon"),i=this.getDisplayShape();if(this._bIsDefaultIcon){e=this._getDefaultIconPath(i)}if(!a){a=t.createControlByURI({alt:"Image placeholder",src:e});this.setAggregation("_icon",a)}else if(a.getSrc()!==e){a.setSrc(e)}return a};y.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP")};y.prototype._getBadgeIconSource=function(){var e;if(this.getDetailBox()){e="sap-icon://zoom-in"}else if(this.getBadgeIcon()!==""){if(this._getDisplayIcon(this.getBadgeIcon())){e=this.getBadgeIcon()}else{s.warning("No valid Icon URI source for badge affordance was provided")}}return e};y.prototype._getBadgeTooltip=function(){var e=this._getDefaultTooltip(),t=this.getBadgeIcon();if(this.getBadgeTooltip()){e=this.getBadgeTooltip()}else if(t&&y.AVATAR_BADGE_TOOLTIP[this.getBadgeIcon()]){e=y.AVATAR_BADGE_TOOLTIP[t]}return e};y.prototype._getBadge=function(){var e=this._getBadgeIconSource(),t=this._getBadgeTooltip();if(!e){return}if(!this._badgeRef){this.setAggregation("_badge",new o({src:e,tooltip:t}))}this._badgeRef=this.getAggregation("_badge");return this._badgeRef};y.prototype._onImageLoad=function(){delete this.preloadedImage};y.prototype._onImageError=function(){var e=this._getImageFallbackType();this.$().removeClass("sapFAvatarImage").addClass("sapFAvatar"+e);delete this.preloadedImage};y.prototype._getActualBackgroundColor=function(){var e=this.getBackgroundColor();if(e===c.Random){if(this._sPickedRandomColor){return this._sPickedRandomColor}e=this._sPickedRandomColor=c[_[_.length*Math.random()<<0]]}else{this._sPickedRandomColor=null}return e};y.prototype._checkInitialsHolderWidth=function(){var e=this.$(),t=this.getInitials().length;this.$oInitialsHolder=e.children(".sapFAvatarInitialsHolder");if(this.$oInitialsHolder.length!==0&&t===3){var a=e[0].offsetWidth,i=this.$oInitialsHolder[0].offsetWidth;if(i>a){this._wideInitialsIcon()}}};y.prototype._wideInitialsIcon=function(){var e=this.$(),t=e.children(".sapFAvatarHiddenIcon");t.removeClass("sapFAvatarHiddenIcon");this.$oInitialsHolder.css("display","none");e.removeClass("sapFAvatarInitials");e.addClass("sapFAvatarIcon")};y.prototype._getInvisibleText=function(){if(!this._oInvisibleText&&this.sInitials){this._oInvisibleText=new l({id:this.getId()+"-InvisibleText"});this._oInvisibleText.setText(this.sInitials).toStatic()}return this._oInvisibleText};y.prototype._getAriaLabelledBy=function(){var e=this.getAriaLabelledBy(),t;this.sInitials=this.getInitials();if(this.sInitials&&e.length>0){t=this._getInvisibleText().getId();e.push(t)}return e};y.prototype._getImageCustomData=function(e){var t=this.getCustomData().filter(function(e){return e.isA("sap.m.ImageCustomData")});return t.length?t[0]:undefined};y.prototype._setNewCacheBustingValue=function(){if(this._getImageCustomData()){this._iCacheBustingValue=Date.now()}};y.prototype._getAvatarSrc=function(){var e=this._getImageCustomData(),t=this.getSrc();if(e&&t){var a={sUrl:t,sParamName:e.getParamName(),sParamValue:this._iCacheBustingValue};return p(a)}return t};y.prototype.refreshAvatarCacheBusting=function(){this._setNewCacheBustingValue();this.invalidate()};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AvatarColor", [],function(){"use strict";var c={Accent1:"Accent1",Accent2:"Accent2",Accent3:"Accent3",Accent4:"Accent4",Accent5:"Accent5",Accent6:"Accent6",Accent7:"Accent7",Accent8:"Accent8",Accent9:"Accent9",Accent10:"Accent10",Random:"Random",Transparent:"Transparent",TileIcon:"TileIcon",Placeholder:"Placeholder"};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AvatarImageFitType", [],function(){"use strict";var n={Cover:"Cover",Contain:"Contain"};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AvatarRenderer", ["sap/m/library","sap/base/security/encodeCSS"],function(e,a){"use strict";var t=e.AvatarSize;var s=e.AvatarType;var l={apiVersion:2};l.render=function(e,l){var r=l.getEnabled(),i=l.getInitials(),n=l._getActualDisplayType(),o=l._getImageFallbackType(),p=l.getDisplaySize(),c=l.getDisplayShape(),d=l.getImageFitType(),g=l.getCustomDisplaySize(),y=l.getCustomFontSize(),f=l._getAvatarSrc(),u="sapFAvatar",b=l.getTooltip_AsString(),S=l._getAriaLabelledBy(),v=l.getAriaDescribedBy(),A=l.getAriaHasPopup(),I=l.hasListeners("press"),C=I?l._getBadge():null,h=l._getDefaultTooltip(),m=i.length,_=l.getActive()&&I;e.openStart("span",l);e.class(u);e.class("sapFAvatarColor"+l._getActualBackgroundColor());e.class(u+p);e.class(u+n);e.class(u+c);if(_){e.class("sapMAvatarPressed")}if(r){if(I){e.class("sapMPointer");e.class(u+"Focusable");e.attr("role","button");e.attr("tabindex",0)}else if(l.getDecorative()){e.attr("role","presentation");e.attr("aria-hidden","true")}else{e.attr("role","img")}}else{e.attr("disabled","disabled");e.class("sapMAvatarDisabled")}if(l.getShowBorder()){e.class("sapFAvatarBorder")}if(p===t.Custom){e.style("width",g);e.style("height",g);e.style("font-size",y)}if(b){e.attr("title",b);e.attr("aria-label",b)}else if(i){e.attr("aria-label",h+" "+i)}else{e.attr("aria-label",h)}if(S&&S.length>0){e.attr("aria-labelledby",S.join(" "))}if(v&&v.length>0){e.attr("aria-describedby",v.join(" "))}if(A&&A!=="None"){e.attr("aria-haspopup",A.toLowerCase())}e.openEnd();if(n===s.Icon||o===s.Icon){e.renderControl(l._getIcon().addStyleClass(u+"TypeIcon"))}else if(n===s.Initials||o===s.Initials){if(m===3){e.renderControl(l._getIcon().addStyleClass(u+"TypeIcon").addStyleClass(u+"HiddenIcon"))}e.openStart("span");e.class(u+"InitialsHolder");e.openEnd();e.text(i);e.close("span")}if(n===s.Image){e.openStart("span");e.class(u+"ImageHolder");e.class(u+n+d);e.style("background-image","url('"+a(f)+"')");e.openEnd();e.close("span")}if(C){e.openStart("div");e.class(u+"BadgeIconActiveArea");if(g){e.style("font-size",g)}e.openEnd();e.openStart("span");e.class(u+"BadgeIcon");e.openEnd();e.renderControl(C);e.close("span");e.close("div")}e.close("span")};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AvatarShape", [],function(){"use strict";var e={Circle:"Circle",Square:"Square"};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AvatarSize", [],function(){"use strict";var t={XS:"XS",S:"S",M:"M",L:"L",XL:"XL",Custom:"Custom"};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/AvatarType", [],function(){"use strict";var i={Icon:"Icon",Image:"Image",Initials:"Initials"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/BadgeCustomData", ["sap/ui/core/CustomData","sap/base/Log","sap/m/library"],function(t,e,i){"use strict";var a=i.BadgeAnimationType;var n=t.extend("sap.m.BadgeCustomData",{metadata:{properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},animation:{type:"sap.m.BadgeAnimationType",group:"Appearance",defaultValue:a.Full}}}});n.prototype.init=function(){var t=this.getParent();if(t&&!t.isA("sap.m.IBadge")){e.warning("BadgeCustomData must be attached only to controls, which implement sap.m.IBadge")}};n.prototype.setValue=function(e){if(this.getValue()===e){return this}if(e===null||e===undefined){e=""}var i=this.getParent();e=e.toString();t.prototype.setValue.call(this,e);if(i){i.updateBadgeValue(e)}return this};n.prototype.setVisible=function(t){if(this.getVisible()===t){return this}this.setProperty("visible",t,true);var e=this.getParent();if(e){e.updateBadgeVisibility(t)}return this};n.prototype.setAnimation=function(t){if(this.getAnimation()===t){return this}this.setProperty("animation",t,true);var e=this.getParent();if(e){e.updateBadgeAnimation(t)}return this};n.prototype.setKey=function(){return this};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/BadgeEnabler", ["sap/m/BadgeCustomData","sap/m/library","sap/ui/thirdparty/jquery"],function(t,a,jQuery){"use strict";var e="sapMBadge";var i={topLeft:"sapMBadgeTopLeft",topRight:"sapMBadgeTopRight",inline:"sapMBadgeInline"};var s=a.BadgeState;var n=a.BadgeStyle;var o=["","undefined","null",false];var d=function(){this.initBadgeEnablement=function(t,a){var e=a?a:this;this._oBadgeConfig=t||{};e.addEventDelegate({onAfterRendering:d},this)};function a(t,a){if(t.suffix){return a.$(t.suffix)}if(t.selector){return a.$().find(t.selector).first()}}function d(){this._isBadgeAttached=false;if(!this.getBadgeCustomData()||!this.getBadgeCustomData().getVisible()){return false}l.call(this);if(!Object.keys(this._oBadgeConfig).length){return this}return this}function g(){var t=r.call(this);t.removeClass("sapMBadgeAnimationUpdate");t.removeClass("sapMBadgeAnimationAdd");t.width();t.addClass("sapMBadgeAnimationRemove");t.on("animationend",function(){t.css("display","none");t.off()});t.removeAttr("aria-label");this._isBadgeAttached=false;f.call(this,"",s["Disappear"]);return this}function r(){return this.$(e)}function h(){return this.getId()+"-"+e}function l(){var t,o=h.call(this),d=r.call(this),g=typeof this.badgeValueFormatter==="function"&&this.badgeValueFormatter,l=B(g?g.call(this,this.getBadgeCustomData().getValue()):this.getBadgeCustomData().getValue())||"",C=this._oBadgeConfig.style?this._oBadgeConfig.style:n.Default,c=this.getBadgeCustomData().getAnimation();this._oBadgeContainer=this._oBadgeConfig&&this._oBadgeConfig.selector?a(this._oBadgeConfig.selector,this):this.$();if(d.length){d.remove()}t=jQuery("<div></div>").addClass(e+"Indicator");t.addClass(e+C);t.attr("id",o);t.attr("data-badge",l);t.attr("aria-label",u.call(this));t.appendTo(this._oBadgeContainer);t.addClass("sapMBadgeAnimationAdd");this._isBadgeAttached=true;this._oBadgeContainer.addClass(e);if(this._oBadgeConfig.position){this._oBadgeContainer.addClass(i[this._oBadgeConfig.position])}if(this._oBadgeConfig.accentColor){this._oBadgeContainer.addClass(e+this._oBadgeConfig.accentColor)}this._oBadgeContainer.addClass(this.getBadgeAnimationClass(this.getBadgeCustomData().getAnimation()));this._badgeAnimaionType=c;f.call(this,l,s["Appear"])}this.updateBadgeValue=function(t){var a=typeof this.badgeValueFormatter==="function"&&this.badgeValueFormatter,e;t=B(a?a.call(this,t):t)||"";if(!this.getBadgeCustomData().getVisible()){return false}e=r.call(this);e.removeClass("sapMBadgeAnimationUpdate");e.attr("data-badge",t);e.attr("aria-label",u.call(this));e.width();e.addClass("sapMBadgeAnimationUpdate");f.call(this,t,s["Updated"])};function u(){var t=this.getAriaLabelBadgeText;return t&&typeof t==="function"&&t.call(this)}function f(t,a){if(this.onBadgeUpdate&&typeof this.onBadgeUpdate==="function"){var e=h.call(this);return this.onBadgeUpdate(t,a,e)}}function B(t){return o.indexOf(t)===-1&&t}this.addCustomData=function(t){if(t.isA("sap.m.BadgeCustomData")){this.removeAggregation("customData",this._oBadgeCustomData,true);this._oBadgeCustomData=t;this.addAggregation("customData",t,true);return this.updateBadgeVisibility(t.getVisible())}return this.addAggregation("customData",t)};this.insertCustomData=function(t){if(t.isA("sap.m.BadgeCustomData")){this.removeAggregation("customData",this._oBadgeCustomData,true);this._oBadgeCustomData=t;this.addAggregation("customData",t,true);return this.updateBadgeVisibility(t.getVisible())}return this.insertAggregation("customData",t)};this.getBadgeCustomData=function(){var a=this.getCustomData().filter(function(a){return a instanceof t});return a.length?a[0]:undefined};this.getBadgeAnimationClass=function(t){return e+"AnimationType"+t};this.removeBadgeCustomData=function(){var t;t=this._oBadgeCustomData;this._oBadgeCustomData=null;return this.removeAggregation("customData",t,true)};this.setBadgeAccentColor=function(t){if(!this._oBadgeContainer){return false}this._oBadgeContainer.removeClass(e+this._oBadgeConfig.accentColor);this._oBadgeContainer.addClass(e+t);this._oBadgeConfig.accentColor=t};this.setBadgePosition=function(t){if(!this._oBadgeContainer){return false}this._oBadgeContainer.removeClass(e+this._oBadgeConfig.position);this._oBadgeContainer.addClass(i[t]);this._oBadgeConfig.position=t};this.updateBadgeVisibility=function(t){return t?l.call(this):g.call(this)};this._renderBadge=function(){d.call(this)};this.updateBadgeAnimation=function(t){if(this._oBadgeContainer){this._badgeAnimaionType&&this._oBadgeContainer.removeClass(this.getBadgeAnimationClass(this._badgeAnimaionType));this._oBadgeContainer.addClass(this.getBadgeAnimationClass(t))}this._badgeAnimaionType=t}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Bar", ["./BarInPageEnabler","./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/Device","./BarRenderer","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(t,e,i,r,s,o,jQuery,a){"use strict";var n=e.BarDesign;var l=e.TitleAlignment;var p=i.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:n.Auto},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:l.None}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/Bar.designtime",dnd:{draggable:false,droppable:true}},renderer:o});p.prototype.onBeforeRendering=function(){var t=this.getTitleAlignment(),e;this._removeAllListeners();for(e in l){if(e!==t){this.removeStyleClass("sapMBarTitleAlign"+e)}else{this.addStyleClass("sapMBarTitleAlign"+e)}}};p.prototype.onAfterRendering=function(){this._handleResize()};p.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this._sPrevTitleAlignmentClass=""};p.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null};p._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];p.prototype._removeAllListeners=function(){var t=this;p._aResizeHandlers.forEach(function(e){t._removeListenerFailsave(e)})};p.prototype._removeListenerFailsave=function(t){if(this[t]){r.deregister(this[t]);this[t]=null}};p.prototype._handleResize=function(){this._removeAllListeners();var t=!!this.getContentLeft().length,e=!!this.getContentMiddle().length,i=!!this.getContentRight().length;if(!e){e=this._oflexBox&&!!this._oflexBox.getItems().length}if(!this.getVisible()){return}if(!t&&!e&&!i){return}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._sResizeListenerId=r.register(this.getDomRef(),jQuery.proxy(this._handleResize,this));if(this.getEnableFlexBox()){this._updatePosition(t,e,i);return}if(t){this._sResizeListenerIdLeft=r.register(this._$LeftBar[0],jQuery.proxy(this._handleResize,this))}else{this._$LeftBar.addClass("sapMBarEmpty")}if(e){this._sResizeListenerIdMid=r.register(this._$MidBarPlaceHolder[0],jQuery.proxy(this._handleResize,this))}else{this._$MidBarPlaceHolder.addClass("sapMBarEmpty")}if(i){this._sResizeListenerIdRight=r.register(this._$RightBar[0],jQuery.proxy(this._handleResize,this))}else{this._$RightBar.addClass("sapMBarEmpty")}this._updatePosition(t,e,i)};p.prototype._updatePosition=function(t,e,i){if(!t&&e&&!i){return}if(t&&!e&&!i){return}if(!t&&!e&&i){return}var r=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});this._$MidBarPlaceHolder.css({position:"",width:"",visibility:"hidden"});var s=this._$RightBar.outerWidth(true);if(s>r){if(t){this._$LeftBar.css({width:"0px"})}if(e){this._$MidBarPlaceHolder.css({width:"0px"})}this._$RightBar.css({width:r+"px"});return}var o=this._getBarContainerWidth(this._$LeftBar);if(r<o+s){o=r-s;this._$LeftBar.css({width:o+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return}this._$MidBarPlaceHolder.css(this._getMidBarCss(s,r,o))};p.prototype._getMidBarCss=function(t,e,i){var r=this._$MidBarPlaceHolder.outerWidth(true),s=a.getRTL(),o={visibility:""};if(this.getEnableFlexBox()){var n=s?"right":"left";r=e-i-t-parseInt(this._$MidBarPlaceHolder.css("margin-left"))-parseInt(this._$MidBarPlaceHolder.css("margin-right"));o.position="absolute";o.width=r+"px";o[n]=i;return o}var p=e-i-t,d=e/2-r/2,h=i>d,g=e/2+r/2,u=e-t<g,f=this.getTitleAlignment();if(f!==l.None&&f!==l.Center||p>0&&(h||u)){o.position="absolute";o.width=p+"px";o.left=s?t:i}return o};p.prototype._getBarContainerWidth=function(t){var e,i=0,r=t.children(),o=0;if(s.browser.webkit||s.browser.firefox){for(e=0;e<r.length;e++){o+=jQuery(r[e]).outerWidth(true)}i=t.outerWidth(true)}else{var a;for(e=0;e<r.length;e++){a=window.getComputedStyle(r[e]);if(a.width=="auto"){o+=jQuery(r[e]).width()+1}else{o+=parseFloat(a.width)}o+=parseFloat(a.marginLeft);o+=parseFloat(a.marginRight);o+=parseFloat(a.paddingLeft);o+=parseFloat(a.paddingRight)}var n=window.getComputedStyle(t[0]);i+=parseFloat(n.width);i+=parseFloat(n.marginLeft);i+=parseFloat(n.marginRight);i+=parseFloat(n.paddingLeft);i+=parseFloat(n.paddingRight)}if(i<o){i=o}return i};var d=t.extend("sap.m.BarInAnyContentEnabler",{});d.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer"}};d.prototype.getContext=function(){var e=t.prototype.getContext.call();for(var i in d.mContexts){e[i]=d.mContexts[i]}return e};p.prototype.getContext=d.prototype.getContext;p.prototype.isContextSensitive=d.prototype.isContextSensitive;p.prototype.setHTMLTag=d.prototype.setHTMLTag;p.prototype.getHTMLTag=d.prototype.getHTMLTag;p.prototype.applyTagAndContextClassFor=d.prototype.applyTagAndContextClassFor;p.prototype._applyContextClassFor=d.prototype._applyContextClassFor;p.prototype._applyTag=d.prototype._applyTag;p.prototype._getContextOptions=d.prototype._getContextOptions;p.prototype._setRootAccessibilityRole=d.prototype._setRootAccessibilityRole;p.prototype._getRootAccessibilityRole=d.prototype._getRootAccessibilityRole;p.prototype._setRootAriaLevel=d.prototype._setRootAriaLevel;p.prototype._getRootAriaLevel=d.prototype._getRootAriaLevel;return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/BarInPageEnabler", ["sap/ui/base/Object","sap/m/library","sap/base/Log"],function(t,e,s){"use strict";var i=e.IBarHTMLTag;var r={footer:{contextClass:"sapMFooter-CTX sapContrast sapContrastPlus",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"},header:{contextClass:"sapMHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_HEADER"},subheader:{contextClass:"sapMSubHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_SUBHEADER"}};var n="sapMIBar";var a=t.extend("sap.m.BarInPageEnabler",{isContextSensitive:function(){return this.getDesign&&this.getDesign()==="Auto"},setHTMLTag:function(t){if(t===this.sTag){return this}this.sTag=t;return this},getHTMLTag:function(){if(!this.hasOwnProperty("sTag")){this.sTag=i.Div}return this.sTag},getContext:function(){return r},_getRootAccessibilityRole:function(){var t=this._sRootAccessibilityRole||"toolbar";return t},_setRootAccessibilityRole:function(t){this._sRootAccessibilityRole=t;return this},_getRootAriaLevel:function(){var t=this.sAriaLevel;return t},_setRootAriaLevel:function(t){this.sAriaLevel=t;return this},applyTagAndContextClassFor:function(t){this._applyTag(t);return this._applyContextClassFor(t)},_applyContextClassFor:function(t){var e=this._getContextOptions(t);if(!e){return this}if(!this.isContextSensitive){s.error("The bar control you are using does not implement all the members of the IBar interface",this);return this}if(!this.getRenderer().shouldAddIBarContext()){this.addStyleClass(n+"-CTX")}if(this.isContextSensitive()){this.addStyleClass(e.contextClass)}return this},_applyTag:function(t){var e=this._getContextOptions(t);if(!e){return this}if(!this.setHTMLTag){s.error("The bar control you are using does not implement all the members of the IBar interface",this);return this}this.setHTMLTag(e.tag);return this},_getContextOptions:function(t){var e;if(this.getContext){e=this.getContext()}else{e=r}var i=e[t];if(!i){s.error("The context "+t+" is not known",this);return null}return i},render:function(t,e){var s=e.getHTMLTag().toLowerCase();t.openStart(s,e);t.class(n);if(this.shouldAddIBarContext(e)){t.class(n+"-CTX")}a.renderTooltip(t,e);this.decorateRootElement(t,e);t.openEnd();this.renderBarContent(t,e);t.close(s)}});a.renderTooltip=function(t,e){var s=e.getTooltip_AsString();if(s){t.attr("title",s)}};a.addChildClassTo=function(t){t.addStyleClass("sapMBarChild")};return a});
/*!

 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/BarRenderer", ["./BarInPageEnabler","sap/ui/Device","sap/base/Log","sap/m/HBox","sap/ui/core/Configuration"],function(e,t,n,a,o){"use strict";var r={apiVersion:2};r.render=e.prototype.render;r.decorateRootElement=function(e,n){e.class("sapMBar");e.class(this.getContext(n));e.accessibilityState(n,{role:n._getRootAccessibilityRole(),level:n._getRootAriaLevel()});if(n.getTranslucent()&&t.support.touch){e.class("sapMBarTranslucent")}e.class("sapMBar-CTX")};r.shouldAddIBarContext=function(){return true};r.renderBarContent=function(e,t){e.openStart("div",t.getId()+"-BarLeft");e.class("sapMBarLeft");e.class("sapMBarContainer");s("left",e,t);e.openEnd();this.renderAllControls(t.getContentLeft(),e,t);e.close("div");e.openStart("div",t.getId()+"-BarMiddle");e.class("sapMBarMiddle");e.openEnd();var n=false;if(t.getEnableFlexBox()){n=true;t._oflexBox=t._oflexBox||new a(t.getId()+"-BarPH",{alignItems:"Center"}).addStyleClass("sapMBarPH").setParent(t,null,true);var r=!!t.getContentLeft().length,l=!!t.getContentMiddle().length,i=!!t.getContentRight().length;if(l&&!r&&!i){t._oflexBox.addStyleClass("sapMBarFlexBoxWidth100")}t.getContentMiddle().forEach(function(e){t._oflexBox.addItem(e)});e.renderControl(t._oflexBox)}if(!n){e.openStart("div",t.getId()+"-BarPH");e.class("sapMBarPH");e.class("sapMBarContainer");s("middle",e,t);e.openEnd();this.renderAllControls(t.getContentMiddle(),e,t);e.close("div")}e.close("div");e.openStart("div",t.getId()+"-BarRight");e.class("sapMBarRight");e.class("sapMBarContainer");if(o.getRTL()){e.class("sapMRTL")}s("right",e,t);e.openEnd();this.renderAllControls(t.getContentRight(),e,t);e.close("div")};r.renderAllControls=function(t,n,a){t.forEach(function(t){e.addChildClassTo(t,a);n.renderControl(t)})};r._mContexts={Header:"sapMHeader-CTX",SubHeader:"sapMSubHeader-CTX",Footer:"sapMFooter-CTX",Default:"sapMContent-CTX"};r.getContext=function(e){var t=e.getDesign(),n=r._mContexts;return n[t]||n.Default};function s(e,t,a){var o=!!a.getContentLeft().length,r=!!a.getContentMiddle().length,s=!!a.getContentRight().length;switch(e.toLowerCase()){case"left":if(o&&!r&&!s){t.style("width","100%")}break;case"middle":if(r&&!o&&!s){t.style("width","100%")}break;case"right":if(s&&!o&&!r){t.style("width","100%")}break;default:n.error("Cannot determine which of the three content aggregations is alone")}}return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Breadcrumbs", ["sap/ui/core/Control","sap/ui/dom/units/Rem","sap/ui/core/theming/Parameters","sap/ui/util/openWindow","sap/m/Text","sap/m/Link","sap/m/Select","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device","sap/m/library","./BreadcrumbsRenderer","sap/ui/base/ManagedObject","sap/ui/core/InvisibleText"],function(t,e,i,r,n,o,s,a,l,h,u,c,g,_,d,p){"use strict";var f=g.SelectType,m=g.BreadcrumbsSeparatorStyle,I=sap.ui.getCore().getLibraryResourceBundle("sap.m");var b=t.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",interfaces:["sap.m.IBreadcrumbs","sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl","sap.ui.core.IShrinkable"],designtime:"sap/m/designtime/Breadcrumbs.designtime",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null},separatorStyle:{type:"sap.m.BreadcrumbsSeparatorStyle",group:"Appearance",defaultValue:m.Slash}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links",associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}},renderer:_});b.STYLE_MAPPER={Slash:"/",BackSlash:"\\",DoubleSlash:"//",DoubleBackSlash:"\\\\",GreaterThan:">",DoubleGreaterThan:">>"};b._getResourceBundleText=function(t,e){return I.getText(t,e)};b.prototype.init=function(){this._sSeparatorSymbol=b.STYLE_MAPPER[this.getSeparatorStyle()];this._aCachedInvisibleTexts=[];this._getInvisibleText();this.MIN_WIDTH_IN_OFT=parseInt(i.get({name:"_sap_m_Breadcrumbs_MinWidth_OFT",callback:function(t){this.MIN_WIDTH_IN_OFT=parseInt(t);this._iMinWidth=this.MIN_WIDTH_IN_OFT}.bind(this)}));this._iMinWidth=this.MIN_WIDTH_IN_OFT};b.prototype.onBeforeRendering=function(){this.bRenderingPhase=true;if(this._sResizeListenerId){h.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this._bControlsInfoCached){this._updateSelect(true)}this._destroyInvisibleTexts();this._aCachedInvisibleTexts=this._buildInvisibleTexts()};b.prototype.onAfterRendering=function(){if(!this._sResizeListenerId){this._sResizeListenerId=h.register(this,this._handleScreenResize.bind(this))}if(!this._bControlsInfoCached){this._updateSelect(true);return}this._configureKeyboardHandling();this._setMinWidth();this.bRenderingPhase=false};b.prototype._setMinWidth=function(){var t=this._getCurrentLocation(),r,n;if(this.$().hasClass("sapMTBShrinkItem")){if(!this._iMinWidth||this._iMinWidth!==this.MIN_WIDTH_IN_OFT){return}this.$().removeClass("sapMTBShrinkItem");r=t.$().width();n=e.toPx(i.get({name:"_sap_m_Toolbar_ShrinkItem_MinWidth",callback:function(t){n=e.toPx(t)}}));this.$().addClass("sapMTBShrinkItem");if(r>n){this.$().css("min-width",r)}this.fireEvent("_minWidthChange");this._iMinWidth=r}};b.prototype.onThemeChanged=function(){this._resetControl()};b.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();this._destroyInvisibleTexts();if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};b.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;b.prototype._getAugmentedId=function(t){return this.getId()+"-"+t};b.prototype._getInvisibleText=function(){var t=b._getResourceBundleText("BREADCRUMB_LABEL");if(!this._oInvisibleText){this._oInvisibleText=new p({id:this.getId()+"-InvisibleText"});this._oInvisibleText.setText(t).toStatic()}return this._oInvisibleText};b.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new s({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:u.getIconURI("slim-arrow-down"),type:f.IconOnly,tooltip:b._getResourceBundleText("BREADCRUMB_SELECT_TOOLTIP")})),true)}return this.getAggregation("_select")};b.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){var t=new n({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation");t.addEventDelegate({onAfterRendering:function(){this._setCurrentLocationAccInfo(t)}.bind(this)});this.setAggregation("_currentLocation",t).addStyleClass("sapMBreadcrumbsCurrentLocation")}return this.getAggregation("_currentLocation")};b.prototype._setCurrentLocationAccInfo=function(t){var e=this._getControlsForBreadcrumbTrail(),i=b._getResourceBundleText("BREADCRUMB_ITEM_POS",[e.length,e.length]);t.$().attr("aria-current","page");t.$().attr("tabindex",0);t.$().attr("role","link");t.$().attr("aria-label",this.getCurrentLocationText()+" "+i)};function C(t,e){var i=Array.prototype.slice.apply(e);i.unshift(t);return i}b.prototype.insertLink=function(t,e){var i=this.insertAggregation.apply(this,C("links",arguments));this._registerControlListener(t);this._resetControl();return i};b.prototype.addLink=function(t){var e=this.addAggregation.apply(this,C("links",arguments));this._registerControlListener(t);this._resetControl();return e};b.prototype.removeLink=function(t){var e=this.removeAggregation.apply(this,C("links",arguments));this._deregisterControlListener(e);this._resetControl();return e};b.prototype.removeAllLinks=function(){var t=this.getAggregation("links",[]);var e=this.removeAllAggregation.apply(this,C("links",arguments));t.forEach(this._deregisterControlListener,this);this._resetControl();return e};b.prototype.destroyLinks=function(){var t=this.getAggregation("links",[]);var e=this.destroyAggregation.apply(this,C("links",arguments));t.forEach(this._deregisterControlListener,this);this._resetControl();return e};b.prototype._destroyInvisibleTexts=function(){var t;this._aCachedInvisibleTexts.forEach(function(e){t=sap.ui.getCore().byId(e.controlId);if(t&&t.removeAriaLabelledBy){t.removeAriaLabelledBy(e.invisibleText.getId())}e.invisibleText.destroy()});this._aCachedInvisibleTexts=[]};b.prototype._decorateSelect=function(t){t.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);t._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);t._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);t.onsapescape=this._onSelectEscPress.bind(this);return t};b.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation())};b.prototype._onSelectBeforeOpenDialog=function(){var t=this._getSelect();if(this.getCurrentLocationText()&&c.system.phone){t.setSelectedIndex(0)}else{t.setSelectedItem(null)}s.prototype._onBeforeOpenDialog.call(t);this._removeItemNavigation()};b.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation()};b.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation())};b.prototype._onSelectEscPress=function(){this._getSelect().close()};b.prototype._createSelectItem=function(t){return new a({key:t.getId(),text:d.escapeSettingsValue(t.getText())})};b.prototype._selectChangeHandler=function(t){var e,i,n,s=t.getParameter("selectedItem");if(!s){return}if(!this._getSelect().isOpen()){return}e=sap.ui.getCore().byId(s.getKey());if(!(e instanceof o)){return}i=e.getHref();n=e.getTarget();e.firePress();if(i){if(n){r(i,n)}else{window.location.href=i}}};b.prototype._getItemsForMobile=function(){var t=this.getLinks().filter(function(t){return t.getVisible()});if(this.getCurrentLocationText()){t.push(this._getCurrentLocation())}return t};b.prototype._updateSelect=function(t){var e=this._getSelect(),i,r=this._getControlDistribution();if(!this._bControlDistributionCached||t){e.destroyItems();i=c.system.phone?this._getItemsForMobile():r.aControlsForSelect;i.map(this._createSelectItem).reverse().forEach(e.insertItem,e);this._bControlDistributionCached=true;this.invalidate(this)}e.setVisible(!!r.aControlsForSelect.length);if(!this._sResizeListenerId&&!this.bRenderingPhase){this._sResizeListenerId=h.register(this,this._handleScreenResize.bind(this))}};b.prototype._getControlsForBreadcrumbTrail=function(){var t;if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail}t=this.getLinks().filter(function(t){return t.getVisible()});if(this.getCurrentLocationText()){return t.concat([this._getCurrentLocation()])}return t};b.prototype._getControlInfo=function(t){return{id:t.getId(),control:t,width:v(t.$().parent()),bCanOverflow:t instanceof o}};b.prototype._buildInvisibleTexts=function(){var t=this._getControlsForBreadcrumbTrail(),e=t.length,i,r=[];t.forEach(function(t,n){if(!t.isA("sap.m.Link")){return}i=new p({text:b._getResourceBundleText("BREADCRUMB_ITEM_POS",[n+1,e])}).toStatic();if(t.getAriaLabelledBy().indexOf(t.getId())===-1){t.addAriaLabelledBy(t.getId())}t.addAriaLabelledBy(i.getId());r.push({controlId:t.getId(),invisibleText:i})});return r};b.prototype._getControlDistribution=function(t){t=t||this._iContainerSize;this._iContainerSize=t;this._oDistributedControls=this._determineControlDistribution(t);return this._oDistributedControls};b.prototype._getSelectWidth=function(){return this._getSelect().getVisible()&&this._iSelectWidth||0};b.prototype._determineControlDistribution=function(t){var e,i,r=this._getControlsInfo().aControlInfo,n=this._getSelectWidth(),o=[],s=[],a=n;for(e=r.length-1;e>=0;e--){i=r[e];a+=i.width;if(r.length-1===e){s.push(i.control);continue}if(e===0){a-=n}if(a>t&&i.bCanOverflow){o.unshift(i.control)}else{s.unshift(i.control)}}return{aControlsForBreadcrumbTrail:s,aControlsForSelect:o}};b.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=v(this._getSelect().$().parent())||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=Math.ceil(v(this.$()));this._bControlsInfoCached=true}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize}};b.prototype._handleScreenResize=function(t){var e,i,r;if(t.size.width===t.oldSize.width||t.size.width===0){return this}e=this._oDistributedControls.aControlsForBreadcrumbTrail.length;i=this._getControlDistribution(Math.ceil(v(this.$())));r=i.aControlsForBreadcrumbTrail.length;if(e!==r){this._updateSelect(true)}return this};b.prototype._getItemsToNavigate=function(){var t=this._getControlsForBreadcrumbTrail().slice(),e=this._getSelect();if(e.getVisible()){t.unshift(e)}return t};b.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new l}return this._itemNavigation};b.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null}};b.prototype._configureKeyboardHandling=function(){var t=this._getItemNavigation(),e=-1,i=this._getItemsToNavigate(),r=[],n;if(i.length===0){return}i.forEach(function(t,e){n=t.getDomRef();if(n){n.setAttribute("tabindex",e===0?"0":"-1")}r.push(t.getFocusDomRef())});this.addDelegate(t);t.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt"],sapend:["alt"]});t.setCycling(false);t.setPageSize(b.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);t.setRootDomRef(this.getDomRef());t.setItemDomRefs(r);t.setSelectedIndex(e);return this};b.prototype._registerControlListener=function(t){if(t){t.attachEvent("_change",this._resetControl,this)}};b.prototype._deregisterControlListener=function(t){if(t){t.detachEvent("_change",this._resetControl,this)}};b.prototype.setCurrentLocationText=function(t){var e=this._getCurrentLocation(),i=this.setProperty("currentLocationText",t,true);if(e.getText()!==t){e.setText(t);this._iMinWidth=this.MIN_WIDTH_IN_OFT;this._resetControl()}return i};b.prototype.setSeparatorStyle=function(t){this.setProperty("separatorStyle",t);var e=b.STYLE_MAPPER[this.getSeparatorStyle()];if(e){this._sSeparatorSymbol=e}return this};b.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){h.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this};b.prototype.getOverflowToolbarConfig=function(){var t={canOverflow:true,getCustomImportance:function(){return"Medium"},invalidationEvents:["_minWidthChange"],onAfterExitOverflow:this._onAfterExitOverflow.bind(this)};return t};b.prototype._onAfterExitOverflow=function(){this._resetControl()};b.prototype._getToolbarInteractive=function(){return true};function v(t){var e;if(t.length){e=t.outerWidth(true)-t.outerWidth();return t.get(0).getBoundingClientRect().width+e}}return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/BreadcrumbsRenderer", ["sap/m/Text"],function(e){"use strict";var t={apiVersion:2};t.render=function(t,n){var r=n._getControlsForBreadcrumbTrail(),i=n._getSelect(),s=n._sSeparatorSymbol,a=n._getInvisibleText().getId(),l=n.getAriaLabelledBy().slice();t.openStart("nav",n);t.class("sapMBreadcrumbs");l.push(a);t.accessibilityState(null,{labelledby:{value:l.join(" "),append:true}});if(n._iMinWidth&&n._iMinWidth!==n.MIN_WIDTH_IN_OFT){t.style("min-width",n._iMinWidth+"px")}t.openEnd();t.openStart("ol");t.openEnd();if(i.getVisible()){this._renderControlInListItem(t,i,s,false,"sapMBreadcrumbsSelectItem")}r.forEach(function(n,i){this._renderControlInListItem(t,n,s,n instanceof e,undefined,i,r.length)},this);t.close("ol");t.close("nav")};t._renderControlInListItem=function(e,t,n,r,i,s,a){e.openStart("li");e.class("sapMBreadcrumbsItem");e.class(i);e.openEnd();e.renderControl(t);if(!r){e.openStart("span").class("sapMBreadcrumbsSeparator").openEnd().text(n).close("span")}e.close("li")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/BusyDialog", ["./library","sap/ui/core/Control","sap/m/Dialog","sap/m/BusyIndicator","sap/m/Label","sap/m/Button","sap/base/Log","sap/ui/core/Core","sap/ui/core/InvisibleText"],function(t,e,o,i,s,n,a,l,r){"use strict";var u=t.TitleAlignment;var c=e.extend("sap.m.BusyDialog",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:""},title:{type:"string",group:"Appearance",defaultValue:""},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1e3},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},cancelButtonText:{type:"string",group:"Misc",defaultValue:""},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:false},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:u.Auto}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{close:{parameters:{cancelPressed:{type:"boolean"}}}},designtime:"sap/m/designtime/BusyDialog.designtime"},renderer:{apiVersion:2,render:function(t,e){}}});c.prototype.init=function(){this._busyIndicator=new i(this.getId()+"-busyInd",{visible:true});this._oDialog=new o(this.getId()+"-Dialog",{content:this._busyIndicator,titleAlignment:this.getTitleAlignment(),showHeader:false,afterClose:this._fnCloseHandler.bind(this),initialFocus:this._busyIndicator.getId()+"-busyIndicator"}).addStyleClass("sapMBusyDialog");this._oDialog.close=function(){};this._oDialog.addEventDelegate({onBeforeRendering:function(){var t=this.getText(),e=this.getTitle(),o=this.getShowCancelButton()||this.getCancelButtonText();if(!t&&!e&&!o){this._oDialog.addStyleClass("sapMBusyDialog-Light")}else{this._oDialog.removeStyleClass("sapMBusyDialog-Light")}}},this);this._oDialog.oPopup.onsapescape=function(t){this.close(true)}.bind(this)};c.prototype.exit=function(){if(this._iOpenTimer){clearTimeout(this._iOpenTimer);this._iOpenTimer=null}this._busyIndicator.destroy();this._busyIndicator=null;if(this._cancelButton){this._cancelButton.destroy();this._cancelButton=null}if(this._oLabel){this._oLabel.destroy();this._oLabel=null}if(this._oDialog){this._oDialog.destroy();this._oDialog=null}};c.prototype.open=function(){var t=this.getAriaLabelledBy();a.debug("sap.m.BusyDialog.open called at "+Date.now());if(t&&t.length){if(!this._oDialog._$dialog){var e=this;t.forEach(function(t){e._oDialog.addAriaLabelledBy(t)})}}else if(!this._oDialog.getShowHeader()){this._oDialog.addAriaLabelledBy(r.getStaticId("sap.m","BUSYDIALOG_TITLE"))}if(!document.body||!l.isInitialized()){this._iOpenTimer=setTimeout(function(){this.open()}.bind(this),50)}else{this._oDialog.open()}return this};c.prototype.close=function(t){this._isClosedFromUserInteraction=t;if(this._iOpenTimer){clearTimeout(this._iOpenTimer);this._iOpenTimer=null}o.prototype.close.call(this._oDialog);return this};c.prototype._fnCloseHandler=function(){this.fireClose({cancelPressed:this._isClosedFromUserInteraction||false});if(this._oDialog){this._oDialog.removeAllAriaLabelledBy()}};c.prototype.setTitle=function(t){this.setProperty("title",t,true);this._oDialog.setTitle(t).setShowHeader(!!t);return this};c.prototype.setTitleAlignment=function(t){this.setProperty("titleAlignment",t,true);if(this._oDialog){this._oDialog.setTitleAlignment(t)}return this};c.prototype.setTooltip=function(t){this._oDialog.setTooltip(t);return this};c.prototype.getTooltip=function(){return this._oDialog.getTooltip()};c.prototype.setText=function(t){this.setProperty("text",t,true);if(!this._oLabel){if(t){this._oLabel=new s(this.getId()+"-TextLabel",{text:t}).addStyleClass("sapMBusyDialogLabel");this._oDialog.insertAggregation("content",this._oLabel,0);if(this._oDialog.getShowHeader()){this._oDialog.addAriaLabelledBy(this._oLabel.getId())}}}else{if(t){this._oLabel.setText(t).setVisible(true)}else{this._oLabel.setVisible(false)}}return this};c.prototype.setCustomIcon=function(t){this.setProperty("customIcon",t,true);this._busyIndicator.setCustomIcon(t);return this};c.prototype.setCustomIconRotationSpeed=function(t){this.setProperty("customIconRotationSpeed",t,true);this._busyIndicator.setCustomIconRotationSpeed(t);return this};c.prototype.setCustomIconDensityAware=function(t){this.setProperty("customIconDensityAware",t,true);this._busyIndicator.setCustomIconDensityAware(t);return this};c.prototype.setCustomIconWidth=function(t){this.setProperty("customIconWidth",t,true);this._busyIndicator.setCustomIconWidth(t);return this};c.prototype.setCustomIconHeight=function(t){this.setProperty("customIconHeight",t,true);this._busyIndicator.setCustomIconHeight(t);return this};c.prototype.setShowCancelButton=function(t){this.setProperty("showCancelButton",t,false);if(t){this._oDialog.setEndButton(this._getCancelButton())}else{this._destroyTheCancelButton()}return this};c.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,false);if(t){this._getCancelButton().setText(t);this._oDialog.setEndButton(this._getCancelButton())}else{this._destroyTheCancelButton()}return this};c.prototype.getDomRef=function(){return this._oDialog&&this._oDialog.getDomRef()};["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass"].forEach(function(t){c.prototype[t]=function(){if(this._oDialog&&this._oDialog[t]){this._oDialog[t].apply(this._oDialog,arguments);return this}}});c.prototype._destroyTheCancelButton=function(){this._oDialog.destroyEndButton();this._cancelButton=null};c.prototype._getCancelButton=function(){var t=this.getCancelButtonText();t=t?t:l.getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");return this._cancelButton?this._cancelButton:this._cancelButton=new n(this.getId()+"busyCancelBtn",{text:t,press:function(){this.close(true)}.bind(this)})};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/BusyIndicator", ["./library","sap/ui/core/Control","sap/ui/core/library","sap/m/Image","sap/m/Label","./BusyIndicatorRenderer"],function(t,e,i,s,o,a){"use strict";var n=i.TextDirection;var r=e.extend("sap.m.BusyIndicator",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:""},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:n.Inherit},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1e3},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"1rem"},design:{type:"string",group:"Appearance",defaultValue:"auto",deprecated:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}},renderer:a});r.prototype.init=function(){this.setBusyIndicatorDelay(0)};r.prototype.onBeforeRendering=function(){if(this.getCustomIcon()){this.setBusy(false)}else{this.setBusy(true,"busy-area")}if(this._busyLabel){this._busyLabel.setTextDirection(this.getTextDirection())}if(this._iconImage){this._iconImage.setDensityAware(this.getCustomIconDensityAware());this._iconImage.setSrc(this.getCustomIcon());this._iconImage.setWidth(this.getCustomIconWidth());this._iconImage.setHeight(this.getCustomIconHeight())}else if(!this._iconImage&&this.getCustomIcon()){this._createCustomIcon(this.getCustomIcon()).addStyleClass("sapMBsyIndIcon")}if(this._busyLabel){this._busyLabel.setText(this.getText());this._busyLabel.setTextDirection(this.getTextDirection())}else if(!this._busyLabel&&this.getText()){this._createLabel(this.getText())}};r.prototype.onAfterRendering=function(){this._setRotationSpeed()};r.prototype.exit=function(){if(this._iconImage){this._iconImage.destroy();this._iconImage=null}if(this._busyLabel){this._busyLabel.destroy();this._busyLabel=null}};r.prototype._createCustomIcon=function(t){this._iconImage=new s(this.getId()+"-icon",{src:t,width:this.getCustomIconWidth(),height:this.getCustomIconHeight(),densityAware:this.getCustomIconDensityAware()});return this._iconImage};r.prototype._createLabel=function(t){this._busyLabel=new o(this.getId()+"-label",{labelFor:this.getId(),text:t,textAlign:"Center",textDirection:this.getTextDirection()});return this._busyLabel};r.prototype._setRotationSpeed=function(){if(!this._iconImage){return}var t=this.getCustomIconRotationSpeed();if(t===this.getMetadata().getProperty("customIconRotationSpeed").getDefaultValue()){return}t=Math.max(0,t);var e=this._iconImage.$();var i=t+"ms";e.css("animation-duration",i);e.css("display","none");setTimeout(function(){e.css("display","inline")},0)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/BusyIndicatorRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var i=t.getTooltip_AsString();e.openStart("div",t).class("sapMBusyIndicator");e.style("font-size",t.getSize());e.accessibilityState(t);if(i){e.attr("title",i)}e.openEnd();if(t.getCustomIcon()){e.renderControl(t._iconImage)}else{e.openStart("div",t.getId()+"-busy-area");e.class("sapMBusyIndicatorBusyArea").openEnd().close("div")}if(t._busyLabel){e.renderControl(t._busyLabel)}e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Button", ["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/ShortcutHintsMixin","sap/ui/core/EnabledPropagator","sap/ui/core/AccessKeysEnablement","sap/ui/core/IconPool","sap/ui/Device","sap/ui/core/ContextMenuSupport","sap/ui/core/library","./ButtonRenderer","sap/ui/events/KeyCodes","sap/ui/core/LabelEnablement","sap/m/BadgeEnabler","sap/ui/core/InvisibleText","sap/base/Log","sap/m/Image"],function(e,t,i,s,a,n,o,r,c,u,h,l,p,g,d,f,_){"use strict";var b=u.TextDirection;var y=e.ButtonType;var m=e.ButtonAccessibilityType;var v=e.ButtonAccessibleRole;var I=e.BadgeState;var T=u.aria.HasPopup;var B=1,A=9999;var S=i.extend("sap.m.Button",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.IAccessKeySupport","sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:y.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:T.None},accessibleRole:{type:"sap.m.ButtonAccessibleRole",group:"Accessibility",defaultValue:v.Default},highlightAccKeysRef:{type:"boolean",defaultValue:false,visibility:"hidden"},accesskey:{type:"string",defaultValue:"",visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}},designtime:"sap/m/designtime/Button.designtime",dnd:{draggable:true,droppable:false}},renderer:h});a.call(S.prototype);c.apply(S.prototype);g.call(S.prototype);S.prototype.init=function(){this._onmouseenter=this._onmouseenter.bind(this);this._buttonPressed=false;s.addConfig(this,{event:"press",position:"0 0",addAccessibilityLabel:true},this);this.initBadgeEnablement({position:"topRight",selector:{suffix:"inner"}});this._oBadgeData={value:"",state:""};this._badgeMinValue=B;this._badgeMaxValue=A;n.registerControl(this)};S.prototype.badgeValueFormatter=function(e){var t=parseInt(e),i=this.getBadgeCustomData(),s=i.getVisible();if(isNaN(t)){return false}if(t<this._badgeMinValue){s&&i.setVisible(false)}else{!s&&i.setVisible(true);if(t>this._badgeMaxValue&&e.indexOf("+")===-1){e=this._badgeMaxValue<1e3?this._badgeMaxValue+"+":"999+"}}return e};S.prototype.setBadgeMinValue=function(e){var t=this.getBadgeCustomData().getValue();if(e&&!isNaN(e)&&e>=B&&e!=this._badgeMinValue&&e<=this._badgeMaxValue){this._badgeMinValue=e;this.badgeValueFormatter(t);this.invalidate()}else{f.warning("minValue is not valid (it is is less than minimum allowed badge value ["+B+"] or greater than maximum badge value ["+this._badgeMaxValue+"])",this)}return this};S.prototype.setBadgeMaxValue=function(e){if(e&&!isNaN(e)&&e<=A&&e!=this._badgeMaxValue&&e>=this._badgeMinValue){this._badgeMaxValue=e;this.invalidate()}else{f.warning("maxValue is not valid (it is is greater than than maximum allowed badge value ["+A+"] or less than minimum badge value ["+this._badgeMinValue+"])",this)}return this};S.prototype.onBadgeUpdate=function(e,t){if(this._oBadgeData.value!==e||this._oBadgeData.state!==t){if(t===I.Disappear){e=""}this._updateBadgeInvisibleText(e);this._oBadgeData={value:e,state:t}}};S.prototype._updateBadgeInvisibleText=function(e){var i=t.getLibraryResourceBundle("sap.m"),s,a;e=e.toString().trim();a=e.indexOf("+");if(a!==-1){s=i.getText("BUTTON_BADGE_MORE_THAN_ITEMS",[e.substr(0,a)])}else{switch(e){case"":s="";break;case"1":s=i.getText("BUTTON_BADGE_ONE_ITEM",[e]);break;default:s=i.getText("BUTTON_BADGE_MANY_ITEMS",[e])}}this._getBadgeInvisibleText().setText(s)};S.prototype._getBadgeInvisibleText=function(){if(!this._oBadgeInvisibleText){this._oBadgeInvisibleText=new d(this.getId()+"-badge").toStatic()}return this._oBadgeInvisibleText};S.prototype.exit=function(){if(this._image){this._image.destroy()}if(this._iconBtn){this._iconBtn.destroy()}if(this._oBadgeInvisibleText){this._oBadgeInvisibleText.destroy();this._oBadgeData=null}this._bFocused=null;this.$().off("mouseenter",this._onmouseenter)};S.prototype.setType=function(e){this.setProperty("type",e);switch(e){case y.Critical:this._sTypeIconURI="sap-icon://alert";break;case y.Negative:this._sTypeIconURI="sap-icon://error";break;case y.Success:this._sTypeIconURI="sap-icon://sys-enter-2";break;case y.Neutral:this._sTypeIconURI="sap-icon://information";break;case y.Back:case y.Up:this._sTypeIconURI="sap-icon://nav-back";break;default:this._sTypeIconURI=null}return this};S.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;this._updateAccessKey();this.$().off("mouseenter",this._onmouseenter)};S.prototype._updateAccessKey=function(){var e=this.getText();if(e){this.setProperty("accesskey",e[0].toLowerCase())}};S.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive}if(this._bFocused){this._toggleLiveChangeAnnouncement("polite")}this.$().on("mouseenter",this._onmouseenter)};S.prototype.ontouchstart=function(e){e.setMarked();if(this._bRenderActive){delete this._bRenderActive}if(e.targetTouches.length===1){this._buttonPressed=true;this._activeButton()}if(this.getEnabled()&&this.getVisible()){if((r.browser.safari||r.browser.firefox)&&(e.originalEvent&&e.originalEvent.type==="mousedown")){this._setButtonFocus()}this._sTouchStartTargetId=e.target.id.replace(this.getId(),"")}else{this._sTouchStartTargetId=""}};S.prototype.ontouchend=function(e){var t;this._buttonPressed=e.originalEvent&&e.originalEvent.buttons&1;this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;this.ontap(e,true)}t=e.target.id.replace(this.getId(),"");if(this._buttonPressed===0&&(this._sTouchStartTargetId==="-BDI-content"&&(t==="-content"||t==="-inner"||t==="-img")||this._sTouchStartTargetId==="-content"&&(t==="-inner"||t==="-img")||this._sTouchStartTargetId==="-img"&&t!=="-img")){this.ontap(e,true)}this._sTouchStartTargetId=""};S.prototype.ontouchcancel=function(){this._buttonPressed=false;this._sTouchStartTargetId="";this._inactiveButton()};S.prototype.ontap=function(e,t){e.setMarked();delete this._bRenderActive;if(this.bFromTouchEnd){return}if(this.getEnabled()&&this.getVisible()){if(e.originalEvent&&e.originalEvent.type==="touchend"){this.focus()}this.fireTap({});this.firePress({})}this.bFromTouchEnd=t;if(this.bFromTouchEnd){setTimeout(function(){delete this.bFromTouchEnd}.bind(this),0)}};S.prototype.onkeydown=function(e){if((e.which===l.SPACE||e.which===l.ENTER||e.which===l.ESCAPE||e.which===l.SHIFT)&&!e.ctrlKey&&!e.metaKey){if(e.which===l.SPACE||e.which===l.ENTER){e.setMarked();this._activeButton()}if(e.which===l.ENTER){this.firePress({})}if(e.which===l.SPACE){this._bPressedSpace=true}if(this._bPressedSpace){if(e.which===l.SHIFT||e.which===l.ESCAPE){this._bPressedEscapeOrShift=true;this._inactiveButton()}}}else{if(this._bPressedSpace){e.preventDefault()}}};S.prototype.onkeyup=function(e){if(e.which===l.ENTER){e.setMarked();this._inactiveButton()}if(e.which===l.SPACE){if(!this._bPressedEscapeOrShift){e.setMarked();this._inactiveButton();this.firePress({})}else{this._bPressedEscapeOrShift=false}this._bPressedSpace=false}if(e.which===l.ESCAPE){this._bPressedSpace=false}};S.prototype._onmouseenter=function(e){if(this._buttonPressed&&e.originalEvent&&e.originalEvent.buttons&1){this._activeButton()}};S.prototype.onfocusin=function(){this._bFocused=true;this._toggleLiveChangeAnnouncement("polite")};S.prototype.onfocusout=function(){this._buttonPressed=false;this._bFocused=false;this._sTouchStartTargetId="";this._inactiveButton();this._toggleLiveChangeAnnouncement("off")};S.prototype._toggleLiveChangeAnnouncement=function(e){if(this._getText()){this.$("BDI-content").attr("aria-live",e)}else if(this._getAppliedIcon()){this.$("tooltip").attr("aria-live",e)}};S.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive")}this._bActive=this.getEnabled();if(this._bActive){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon())}}};S.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive")}this._bActive=false;if(this.getEnabled()){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this._getAppliedIcon())}}};S.prototype._isHoverable=function(){return this.getEnabled()&&r.system.desktop};S.prototype._getImage=function(e,t,i,s){var a=o.isIconURI(t),n;if(this._image&&this._image.isA("sap.m.Image")&&a||this._image&&this._image.isA("sap.ui.core.Icon")&&!a){this._image.destroy();this._image=undefined}n=this.getIconFirst();if(this._image){this._image.setSrc(t);if(this._image.isA("sap.m.Image")){this._image.setActiveSrc(i);this._image.setDensityAware(s)}}else{this._image=o.createControlByURI({id:e,src:t,activeSrc:i,densityAware:s,useIconTooltip:false},_).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true)}this._image.addStyleClass("sapMBtnIcon");this._image.toggleStyleClass("sapMBtnIconLeft",n);this._image.toggleStyleClass("sapMBtnIconRight",!n);return this._image};S.prototype._getInternalIconBtn=function(e,t){var i=this._iconBtn;if(i){i.setSrc(t)}else{i=o.createControlByURI({id:e,src:t,useIconTooltip:false},_).setParent(this,null,true)}i.addStyleClass("sapMBtnIcon");i.addStyleClass("sapMBtnIconLeft");this._iconBtn=i;return this._iconBtn};S.prototype._isUnstyled=function(){var e=false;if(this.getType()===y.Unstyled){e=true}return e};S.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner")};S.prototype._getText=function(){return this.getText()};S.prototype._getTooltip=function(){var e,t;e=this.getTooltip_AsString();if(!e&&!this._getText()){t=o.getIconInfo(this._getAppliedIcon());if(t){e=t.text?t.text:t.name}}return e};S.prototype._getAppliedIcon=function(){return this.getIcon()||this._sTypeIconURI};S.prototype.getAccessibilityInfo=function(){var e=this._getText()||this.getTooltip_AsString(),i=this.getAccessibleRole();if(!e&&this._getAppliedIcon()){var s=o.getIconInfo(this._getAppliedIcon());if(s){e=s.text||s.name}}return{role:i===v.Default?"button":i.toLowerCase(),type:t.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:e,focusable:this.getEnabled(),enabled:this.getEnabled()}};S.prototype._setButtonFocus=function(){setTimeout(function(){this.focus()}.bind(this),0)};S.prototype._determineSelfReferencePresence=function(){var e=this.getAriaLabelledBy(),t=e.indexOf(this.getId())!==-1,i=p.getReferencingLabels(this).length>0,s=this.getParent(),a=!!(s&&s.enhanceAccessibilityState);return!t&&this._getText()&&(e.length>0||i||a||this._isBadgeButton())};S.prototype._determineAccessibilityType=function(){var e=this.getAriaLabelledBy().length>0,t=this.getAriaDescribedBy().length>0,i=p.getReferencingLabels(this).length>0,s=this.getType()!==y.Default,a=e||i||this._determineSelfReferencePresence(),n=t||s||this._isBadgeButton(),o;if(!a&&!n){o=m.Default}else if(a&&!n){o=m.Labelled}else if(!a&&n){o=m.Described}else if(a&&n){o=m.Combined}return o};S.prototype._isBadgeButton=function(){return this._oBadgeData&&this._oBadgeData.value!==""&&this._oBadgeData.State!==I.Disappear};S.prototype._getTitleAttribute=function(e){return this.getTooltip()};S.prototype._getToolbarInteractive=function(){return true};return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ButtonRenderer", ["sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/ShortcutHintsMixin","sap/m/library","sap/ui/core/InvisibleText","sap/ui/core/AccessKeysEnablement"],function(e,t,a,i,n,s){"use strict";var r=i.ButtonType;var c=i.ButtonAccessibilityType;var o=i.ButtonAccessibleRole;var l=e.TextDirection;var p=i.BadgeState;var d=e.aria.HasPopup;var u={apiVersion:2};u.render=function(e,i){var n=i.getId();var s=i.getType();var c=i.getEnabled();var o=i.getWidth();var p=i._getTooltip();var d=i._getText();var g=i.getTextDirection();var I=g===l.Inherit;var T=t.getIconURI("nav-back");var A;e.openStart("button",i);e.class("sapMBtnBase");e.attr("data-ui5-accesskey",i.getProperty("accesskey"));if(!i._isUnstyled()){e.class("sapMBtn");if((s===r.Back||s===r.Up)&&i._getAppliedIcon()&&!d){e.class("sapMBtnBack")}}var B=u.generateAccProps(i);if(this.renderAccessibilityAttributes){this.renderAccessibilityAttributes(e,i,B)}e.accessibilityState(i,B);if(!c){e.attr("disabled","disabled");if(!i._isUnstyled()){e.class("sapMBtnDisabled")}}else{switch(s){case r.Accept:case r.Reject:case r.Emphasized:case r.Attention:e.class("sapMBtnInverted");break;default:break}}if(p&&!a.isDOMIDRegistered(n)){e.attr("title",p)}if(o!=""||o.toLowerCase()==="auto"){e.style("width",o);if(i._getAppliedIcon()&&d){A="4rem"}else{A="2.25rem"}e.style("min-width",A)}b(i,e);e.openEnd();e.openStart("span",n+"-inner");if(!i._isUnstyled()){e.class("sapMBtnInner")}if(i._isHoverable()){e.class("sapMBtnHoverable")}if(c){e.class("sapMFocusable")}if(!i._isUnstyled()){if(d){e.class("sapMBtnText")}if(s===r.Back||s===r.Up){e.class("sapMBtnBack")}if(i._getAppliedIcon()){if(i.getIconFirst()){e.class("sapMBtnIconFirst")}else{e.class("sapMBtnIconLast")}}}if(this.renderButtonAttributes){this.renderButtonAttributes(e,i)}if(!i._isUnstyled()&&s!==""){e.class("sapMBtn"+s)}b(i,e);e.openEnd();if(s===r.Back||s===r.Up){this.writeInternalIconPoolHtml(e,i,T)}if(i.getIconFirst()&&i._getAppliedIcon()){this.writeImgHtml(e,i)}if(d){this.writeButtonText(e,i,g,I)}if(!i.getIconFirst()&&i._getAppliedIcon()){this.writeImgHtml(e,i)}e.close("span");if(p){e.openStart("span",n+"-tooltip");e.class("sapUiInvisibleText");e.openEnd();e.text(p);e.close("span")}e.close("button")};u.writeImgHtml=function(e,t){var a=t.getType(),i=t.getIcon(),n=a===r.Back||a===r.Up;if(!i&&n){return}e.renderControl(t._getImage(t.getId()+"-img",t._getAppliedIcon(),t.getActiveIcon(),t.getIconDensityAware()))};u.writeInternalIconPoolHtml=function(e,t,a){e.renderControl(t._getInternalIconBtn(t.getId()+"-iconBtn",a))};u.writeButtonText=function(e,t,a,i){e.openStart("span",t.getId()+"-content");e.class("sapMBtnContent");if(a!==l.Inherit){e.attr("dir",a.toLowerCase())}if(t.getProperty("highlightAccKeysRef")){e.class(s.CSS_CLASS)}e.openEnd();if(i){e.openStart("bdi",t.getId()+"-BDI-content");e.openEnd()}e.text(t.getText());if(i){e.close("bdi")}e.close("span")};function b(e,t){if(e._bExcludeFromTabChain){t.attr("tabindex",-1)}}var g={Accept:"BUTTON_ARIA_TYPE_ACCEPT",Reject:"BUTTON_ARIA_TYPE_REJECT",Attention:"BUTTON_ARIA_TYPE_ATTENTION",Emphasized:"BUTTON_ARIA_TYPE_EMPHASIZED",Critical:"BUTTON_ARIA_TYPE_CRITICAL",Negative:"BUTTON_ARIA_TYPE_NEGATIVE",Success:"BUTTON_ARIA_TYPE_SUCCESS"};u.getButtonTypeAriaLabelId=function(e){return n.getStaticId("sap.m",g[e])};u.getBadgeTextId=function(e){return e._oBadgeData&&e._oBadgeData.value!==""&&e._oBadgeData.state!==p.Disappear?e._getBadgeInvisibleText().getId():""};u.generateAccProps=function(e){var t=e._getText(),a=e.getAriaHasPopup(),i,n=e.getAccessibleRole();if(t){i=u.generateTextButtonAccProps(e)}else{i=u.generateIconOnlyButtonAccProps(e)}i["disabled"]=null;if(n===o.Link){i["role"]="link"}i["haspopup"]=a===d.None?null:a.toLowerCase();return i};u.generateIconOnlyButtonAccProps=function(e){var t=u.getButtonTypeAriaLabelId(e.getType()),a=this.getBadgeTextId(e),i=e._getTooltip(),n=e.getId()+"-tooltip",s=e._determineAccessibilityType(),r={},o;switch(s){case c.Default:r["label"]={value:i,append:true};break;case c.Described:r["label"]={value:i,append:true};o=(t+" "+a).trim();o&&(r["describedby"]={value:o,append:true});break;case c.Labelled:r["describedby"]={value:n,append:true};break;case c.Combined:r["describedby"]={value:(n+" "+t+" "+a).trim(),append:true};break;default:break}return r};u.generateTextButtonAccProps=function(e){var t=e.getId(),a=u.getButtonTypeAriaLabelId(e.getType()),i=this.getBadgeTextId(e),n=e._getTooltip()?t+"-tooltip":"",s=t+"-content",r=e._determineAccessibilityType(),o=e._determineSelfReferencePresence(),l={},p;switch(r){case c.Default:n&&(l["describedby"]={value:n,append:true});break;case c.Described:p=(n+" "+a+" "+i).trim();p&&(l["describedby"]={value:p,append:true});break;case c.Labelled:o&&(l["labelledby"]={value:s,append:true});n&&(l["describedby"]={value:n,append:true});break;case c.Combined:p=(n+" "+a+" "+i).trim();p&&(l["describedby"]={value:p,append:true});o&&(l["labelledby"]={value:s,append:true});break;default:break}return l};return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Carousel", ["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Configuration","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","./CarouselRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/base/util/isPlainObject","sap/m/ImageHelper","sap/ui/thirdparty/jquery","sap/ui/core/IconPool","./CarouselLayout","sap/ui/dom/jquery/Selectors"],function(e,t,i,s,a,r,o,n,h,g,l,u,d,p,f,jQuery){"use strict";var c=n.BusyIndicatorSize;var _=e.CarouselArrowsPlacement;var I=e.PlacementType;var m=e.BackgroundDesign;var v=e.BorderDesign;var P=10;var A=20;var y=t.getConfiguration().getRTL();function C(e){e=e.originalEvent||e;var t=e.touches&&e.touches[0];return{x:t?t.clientX:e.clientX,y:t?t.clientY:e.clientY}}function T(e,t){e.style["transform"]="translate3d("+t+"px, 0, 0)"}var S=i.extend("sap.m.Carousel",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Carousel.designtime",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:I.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:_.Content},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:m.Translucent},pageIndicatorBackgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:m.Solid},pageIndicatorBorderDesign:{type:"sap.m.BorderDesign",group:"Appearance",defaultValue:v.Solid}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"},customLayout:{type:"sap.m.CarouselLayout",multiple:false},_emptyPage:{type:"sap.m.IllustratedMessage",multiple:false,visibility:"hidden"}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"},activePages:{type:"array"}}},beforePageChanged:{parameters:{activePages:{type:"array"}}}}},renderer:l});S._INNER_SELECTOR=".sapMCrslInner";S._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";S._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";S._CONTROLS=".sapMCrslControls";S._ITEM_SELECTOR=".sapMCrslItem";S._LEFTMOST_CLASS="sapMCrslLeftmost";S._RIGHTMOST_CLASS="sapMCrslRightmost";S._MODIFIERNUMBERFORKEYBOARDHANDLING=10;S._BULLETS_TO_NUMBERS_THRESHOLD=9;S.prototype.init=function(){this._aAllActivePages=[];this._aAllActivePagesIndexes=[];this._bShouldFireEvent=true;this.data("sap-ui-fastnavgroup","true",true);this._oRb=t.getLibraryResourceBundle("sap.m")};S.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight}if(this._sResizeListenerId){o.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this.$().off("afterSlide");this._aAllActivePages=null;this._aAllActivePagesIndexes=null;if(this._bThemeChangedAttached){t.detachThemeChanged(this._handleThemeChanged,this);this._bThemeChangedAttached=false}};S.prototype.onBeforeRendering=function(){if(!this.getActivePage()&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true)}var e=this.getActivePage();if(e){this._updateActivePages(e)}if(this._sResizeListenerId){o.deregister(this._sResizeListenerId);this._sResizeListenerId=null}return this};S.prototype._resize=function(){var e=this.$().find("> .sapMCrslInner");if(this._iResizeTimeoutId){clearTimeout(this._iResizeTimeoutId);delete this._iResizeTimeoutId}e.addClass("sapMCrslNoTransition");e.addClass("sapMCrslHideNonActive");if(this.getPages().length>1){this._setWidthOfPages(this._getNumberOfItemsToShow())}this._updateTransformValue();this._iResizeTimeoutId=setTimeout(function(){e.removeClass("sapMCrslNoTransition");e.removeClass("sapMCrslHideNonActive")})};S.prototype._getNumberOfItemsToShow=function(){var e=this.getPages().length,t=this.getCustomLayout(),i=1;if(t&&t.isA("sap.m.CarouselLayout")){i=Math.max(t.getVisiblePagesCount(),1)}if(i>1&&e<i){return e}return i};S.prototype.onAfterRendering=function(){var e=this._getActivePageIndex();var i=this.$().find(S._INNER_SELECTOR)[0];var s=this.getPages().length;if(!s){return}this._iCurrSlideIndex=Math.min(e,s-this._getNumberOfItemsToShow());if(this.getPages().length&&this.getPages()[this._getPageIndex(this.getActivePage())].getId()!==this.getActivePage()){this.setAssociation("activePage",this.getPages()[e].getId(),true)}if(t.isThemeApplied()){this._initialize()}else if(!this._bThemeChangedAttached){this._bThemeChangedAttached=true;t.attachThemeChanged(this._handleThemeChanged,this)}this._sResizeListenerId=o.register(i,this._resize.bind(this))};S.prototype.getFocusDomRef=function(){return this.getDomRef(this.getActivePage()+"-slide")||this.getDomRef("noData")};S.prototype._handleThemeChanged=function(){this._initialize();t.detachThemeChanged(this._handleThemeChanged,this);this._bThemeChangedAttached=false};S.prototype._onBeforePageChanged=function(e,t){var i=this.getPages()[t].getId();this._updateActivePages(i);this.fireBeforePageChanged({activePages:this._aAllActivePagesIndexes})};S.prototype._onAfterPageChanged=function(e,t){var i=this.getPages().length>0;if(!i){return}var s;if(this._iNewActivePageIndex!==undefined){s=this._iNewActivePageIndex}else if(this._bPageIndicatorArrowPress||this._bSwipe){var a=e<t;var r=this._getPageIndex(this.getActivePage());if(this._isPageDisplayed(r)){s=r}else{if(a){s=r+1}else{s=r-1}if(!this._isPageDisplayed(s)){s=t}}}else{s=t}this._changeActivePage(s);delete this._bPageIndicatorArrowPress;delete this._bSwipe};S.prototype._setWidthOfPages=function(e){var t=this.$().find(".sapMCrslItem"),i;if(!t.length){return}i=this._calculatePagesWidth(e);t.each(function(e,t){t.style.width=i+"%"})};S.prototype._calculatePagesWidth=function(e){var t=this.$().width(),i=this.getDomRef().querySelector(".sapMCrslFluid .sapMCrslItem"),s=parseFloat(window.getComputedStyle(i).marginRight),a=(t-s*(e-1))/e,r=a/t*100;return r};S.prototype._moveToPage=function(e){if(!this._bIsInitialized||this.getPages().length===0){return}var t=this.$(),i=t.find("> .sapMCrslInner"),s=i.children(),a=this._iCurrSlideIndex,r=s.length,o=this._getNumberOfItemsToShow(),n=this.getLoop();if(n&&o!==1&&(e<0||e>r-1)){return}if(e<0){if(n){e=r-1}else{e=0}}else if(e>r-1){if(n){e=0}else{e=r-1}}if(e+o>r-1){e=r-o}var h=true;if(e===a){h=false}if(h){this._onBeforePageChanged(a,e)}this._iOffsetDrag=0;this._iCurrSlideIndex=e;this._updateTransformValue();this._initActivePages();if(h){this._onAfterPageChanged(a,e)}};S.prototype._changeActivePage=function(e){var t=this.getActivePage();if(this._sOldActivePageId){t=this._sOldActivePageId;delete this._sOldActivePageId}var i=this.getPages()[e].getId();this.setAssociation("activePage",i,true);if(!r.system.desktop){jQuery(document.activeElement).trigger("blur")}if(this._bShouldFireEvent){d.debug("sap.m.Carousel: firing pageChanged event: old page: "+t+", new page: "+i);this.firePageChanged({oldActivePageId:t,newActivePageId:i,activePages:this._aAllActivePagesIndexes})}if(this.getDomRef().contains(document.activeElement)&&!this.getFocusDomRef().contains(document.activeElement)||this._bPageIndicatorArrowPress){this.getFocusDomRef().focus({preventScroll:true})}this._adjustArrowsVisibility();this._updateItemsAttributes();this._updatePageIndicator()};S.prototype._updateItemsAttributes=function(){this.$().find(S._ITEM_SELECTOR).each(function(e,t){var i=t===this.getFocusDomRef();t.setAttribute("aria-selected",i);t.setAttribute("aria-hidden",!this._isPageDisplayed(e));t.setAttribute("tabindex",i?0:-1)}.bind(this))};S.prototype._updatePageIndicator=function(){this.$("slide-number").text(this._getPageIndicatorText(this._iCurrSlideIndex+1))};S.prototype._getPageIndicatorText=function(e){return this._oRb.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[e,this.getPages().length-this._getNumberOfItemsToShow()+1])};S.prototype._adjustArrowsVisibility=function(){if(r.system.desktop&&!this._loops()&&this.getPages().length>1){var e=this.$("hud");var t=this.$("arrow-previous");var i=this.$("arrow-next");var s=this._aAllActivePagesIndexes[0];var a=this._aAllActivePagesIndexes[this._aAllActivePagesIndexes.length-1];if(this.getArrowsPlacement()===_.Content){e.removeClass(S._LEFTMOST_CLASS).removeClass(S._RIGHTMOST_CLASS)}else{t.removeClass(S._LEFTMOST_CLASS);i.removeClass(S._RIGHTMOST_CLASS)}if(s===0){if(this.getArrowsPlacement()===_.Content){e.addClass(S._LEFTMOST_CLASS)}else{t.addClass(S._LEFTMOST_CLASS)}}if(a===this.getPages().length-1){if(this.getArrowsPlacement()===_.Content){e.addClass(S._RIGHTMOST_CLASS)}else{i.addClass(S._RIGHTMOST_CLASS)}}}};S.prototype.setActivePage=function(e){var t=null;if(typeof e=="string"){t=e}else if(e instanceof i){t=e.getId()}if(t){if(t===this.getActivePage()){return this}var s=this._getPageIndex(t);this._sOldActivePageId=this.getActivePage();this._moveToPage(s)}this.setAssociation("activePage",t,true);return this};S.prototype._getNavigationArrow=function(e){if(!this["_oArrow"+e]){this["_oArrow"+e]=f.getImageControl(this.getId()+"-arrowScroll"+e,this["_oArrow"+e],this,{src:"sap-icon://slim-arrow-"+e.toLowerCase(),useIconTooltip:false})}return this["_oArrow"+e]};S.prototype._getEmptyPage=function(){if(!this.getAggregation("_emptyPage")){var e=new h({illustrationType:g.NoData});this.setAggregation("_emptyPage",e)}return this.getAggregation("_emptyPage")};S.prototype.previous=function(){this._moveToPage(this._iCurrSlideIndex-1);return this};S.prototype.next=function(){this._moveToPage(this._iCurrSlideIndex+1);return this};S.prototype._getPageIndex=function(e){var t,i=0;for(t=0;t<this.getPages().length;t++){if(this.getPages()[t].getId()===e){i=t;break}}return i};S.prototype._getActivePageIndex=function(){var e=0,t=this.getActivePage();if(t){e=this._getPageIndex(t)}return e};S.prototype.onswipe=function(){this._bSwipe=true};S.prototype.ontouchstart=function(e){if(!this.getPages().length||!this._bIsInitialized){return}const t=e.target.tagName.toLowerCase();if(["input","textarea","select"].indexOf(t)>-1||e.target.isContentEditable){return}if(this._isPageIndicatorArrow(e.target)){e.preventDefault();this._bPageIndicatorArrowPress=true;return}if(e.target.draggable){e.target.draggable=false}if(e.isMarked("delayedMouseEvent")){return}var i=s.closestTo(e.target);if(i&&(i.isA("sap.m.Slider")||i.isA("sap.m.Switch")||i.isA("sap.m.IconTabBar"))){this._bDragCanceled=true;return}this._bDragging=true;this._bDragCanceled=false;this._mCurrentXY=C(e);this._iDx=0;this._iDy=0;this._bDragThresholdMet=false;this.$().addClass("sapMCrslDragging");this._bLockLeft=this._iCurrSlideIndex===1;this._bLockRight=this._iCurrSlideIndex===this.getPages().length-1};S.prototype.ontouchmove=function(e){if(this._isPageIndicatorArrow(e.target)){return}if(!this._bDragging||this._bDragCanceled||e.isMarked("delayedMouseEvent")){return}e.setMarked();var t=this.$().width();var i=C(e);this._iDx=this._mCurrentXY.x-i.x;this._iDy=this._mCurrentXY.y-i.y;if(this._bDragThresholdMet||Math.abs(this._iDx)>Math.abs(this._iDy)&&Math.abs(this._iDx)>P){this._bDragThresholdMet=true;if(p(e.touches[0])){e.preventDefault()}if(this._bLockLeft&&this._iDx<0){this._iDx=this._iDx*-t/(this._iDx-t)}else if(this._bLockRight&&this._iDx>0){this._iDx=this._iDx*t/(this._iDx+t)}this._iOffsetDrag=-this._iDx;this._updateTransformValue()}else if(Math.abs(this._iDy)>Math.abs(this._iDx)&&Math.abs(this._iDy)>P){this._bDragCanceled=true}};S.prototype.ontouchend=function(e){if(this._isPageIndicatorArrow(e.target)){return}if(!this._bDragging||e.isMarked("delayedMouseEvent")){return}this._bDragging=false;this.$().removeClass("sapMCrslDragging");if(!this._bDragCanceled&&Math.abs(this._iDx)>A){if(this._iDx>0){y?this.previous():this.next()}else{y?this.next():this.previous()}}else{this._iOffsetDrag=0;this._updateTransformValue()}};S.prototype.onsaptabprevious=function(e){this._bDirection=false;if(this._isSlide(e.target)||e.target===this.getDomRef("noData")){this._forwardTab(false)}};S.prototype.onsaptabnext=function(e){this._bDirection=true;var t=this._getActivePageTabbables();if(!t.length||e.target===t.get(-1)){this._forwardTab(true)}};S.prototype._forwardTab=function(e){this.getDomRef(e?"after":"before").focus()};S.prototype._getActivePageTabbables=function(){return this.$(this.getActivePage()+"-slide").find(":sapTabbable")};S.prototype._focusPrevious=function(e){var t=this.getFocusDomRef();if(!t){return}var i=jQuery(t);var s=this._getActivePageTabbables();i.add(s).eq(-1).trigger("focus")};S.prototype.onfocusin=function(e){if(e.target===this.getDomRef("before")&&!this.getDomRef().contains(e.relatedTarget)){this.getFocusDomRef().focus();return}if(e.target===this.getDomRef("after")&&!this.getDomRef().contains(e.relatedTarget)){this._focusPrevious(e);return}if(this._isSlide(e.target)){this.addStyleClass("sapMCrslShowArrows")}this._handlePageElemFocus(e.target);this.saveLastFocusReference(e);this._bDirection=undefined};S.prototype.onfocusout=function(e){if(this._isSlide(e.target)){this.removeStyleClass("sapMCrslShowArrows")}};S.prototype._handlePageElemFocus=function(e){var t;if(this._isSlide(e)){t=s.closestTo(jQuery(e).find(".sapMCrsPage")[0])}else{t=this._getClosestPage(e)}if(t){var i=t.getId();if(!this._isPageDisplayed(this._getPageIndex(i))){this.getFocusDomRef().focus({preventScroll:true})}else if(i!==this.getActivePage()){this._changeActivePage(this._getPageIndex(i))}}};S.prototype.onkeydown=function(e){if(e.keyCode==u.F7){this._handleF7Key(e);return}if(!this._isSlide(e.target)){return}switch(e.keyCode){case 189:case u.NUMPAD_MINUS:this._fnSkipToIndex(e,-1,false);break;case u.PLUS:case u.NUMPAD_PLUS:this._fnSkipToIndex(e,1,false);break}};S.prototype.onsapright=function(e){this._fnSkipToIndex(e,1,false)};S.prototype.onsapup=function(e){this._fnSkipToIndex(e,1,false)};S.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1,false)};S.prototype.onsapdown=function(e){this._fnSkipToIndex(e,-1,false)};S.prototype.onsaphome=function(e){this._fnSkipToIndex(e,-this._getActivePageIndex(),true)};S.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length-this._getActivePageIndex()-1,true)};S.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,S._MODIFIERNUMBERFORKEYBOARDHANDLING,true)}};S.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,S._MODIFIERNUMBERFORKEYBOARDHANDLING,true)}};S.prototype.onsappageup=function(e){this._fnSkipToIndex(e,S._MODIFIERNUMBERFORKEYBOARDHANDLING,true)};S.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-S._MODIFIERNUMBERFORKEYBOARDHANDLING,true)}};S.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-S._MODIFIERNUMBERFORKEYBOARDHANDLING,true)}};S.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-S._MODIFIERNUMBERFORKEYBOARDHANDLING,true)};S.prototype.saveLastFocusReference=function(e){var t=this._getClosestPage(e.target),i;if(this._bDirection===undefined){return}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={}}if(t){i=t.getId();this._lastFocusablePageElement[i]=e.target}};S.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this.getActivePage()]}};S.prototype._updateActivePages=function(e){var t=this._getPageIndex(e),i=this._getNumberOfItemsToShow(),s=this.getPages(),a;if(!s.length){return}if(t>s.length-i){t=s.length-i}a=t+i;this._aAllActivePages=[];this._aAllActivePagesIndexes=[];for(var r=t;r<a;r++){this._aAllActivePages.push(s[r].getId());this._aAllActivePagesIndexes.push(r)}};S.prototype._fnSkipToIndex=function(e,t,i){if(!this._isSlide(e.target)){return}e.preventDefault();var s=this._makeInRange(this._getPageIndex(this.getActivePage())+t,i);var a=this.getActivePage();var r=this._iCurrSlideIndex+t;if(i){r=Math.max(0,Math.min(r,this.getPages().length-this._getNumberOfItemsToShow()))}if(this._isPageDisplayed(s)){this._changeActivePage(s)}else{this._bShouldFireEvent=false;this._moveToPage(r);this._bShouldFireEvent=true;this._sOldActivePageId=a;this._changeActivePage(s)}};S.prototype._isPageDisplayed=function(e){return this._aAllActivePagesIndexes.includes(e)};S.prototype._handleF7Key=function(e){var t=this._getActivePageLastFocusedElement();if(this._isSlide(e.target)&&t){t.focus()}else{this.getFocusDomRef().focus()}};S.prototype._isSlide=function(e){return e.id.endsWith("slide")&&e.parentElement===this.getDomRef().querySelector(S._INNER_SELECTOR)};S.prototype._isPageIndicatorArrow=function(e){return e.classList.contains("sapMCrslArrow")};S.prototype._loops=function(){return this.getLoop()&&this._getNumberOfItemsToShow()===1};S.prototype._makeInRange=function(e,t){var i=this.getPages().length;var s=e;var a=this._loops();if(e>=i){if(a&&!t){s=0}else{s=i-1}}else if(e<0){if(a&&!t){s=i-1}else{s=0}}return s};S.prototype._getClosestPage=function(e){return s.closestTo(jQuery(e).closest(".sapMCrsPage")[0])};S.prototype.setShowBusyIndicator=function(){d.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this};S.prototype.getShowBusyIndicator=function(){d.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false};S.prototype.setBusyIndicatorSize=function(e){if(!(e in c)){e=c.Medium}return i.prototype.setBusyIndicatorSize.call(this,e)};S.prototype.onclick=function(e){var t=e.target;switch(t.id){case this.getId()+"-arrow-next":this.next();break;case this.getId()+"-arrow-previous":this.previous();break}};S.prototype._initialize=function(){var e=this.$().find("> .sapMCrslInner"),t=this._getNumberOfItemsToShow();this._bIsInitialized=false;if(this._iTimeoutId){clearTimeout(this._iTimeoutId);delete this._iTimeoutId}e.addClass("sapMCrslNoTransition");this._iOffsetDrag=0;this._initActivePages();this._bIsInitialized=true;if(t>1){this._setWidthOfPages(t)}this._adjustArrowsVisibility();this._updateItemsAttributes();this._updatePageIndicator();this._updateTransformValue();this._iTimeoutId=setTimeout(function(){e.removeClass("sapMCrslNoTransition")},50)};S.prototype._updateTransformValue=function(){if(this.getPages().length===0){return}var e=this.$(),t=e.find("> .sapMCrslInner"),i=t.children(),s=i.eq(0),a=i.eq(this._iCurrSlideIndex),r,o,n,h;if(!t.length){return}r=a.prop("offsetLeft")+a.prop("clientWidth");o=s.prop("offsetLeft")+s.prop("clientWidth");n=o-r;h=Math.round(n+this._iOffsetDrag);T(t[0],h)};S.prototype._initActivePages=function(){var e="sapMCrslActive",t=this.$(),i=t.find("> .sapMCrslInner"),s=i.children(),a=this.getDomRef().id,r=a.replace(/(:|\.)/g,"\\$1")+"-pageIndicator",o=this._iCurrSlideIndex,n;for(n=0;n<s.length;n++){if(n<o||n>o+this._getNumberOfItemsToShow()-1){s.eq(n).removeClass(e)}else{s.eq(n).addClass(e)}}t.find("span[data-slide]").removeClass(e);t.find("#"+r+" > [data-slide='"+(o+1)+"']").addClass(e)};return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CarouselLayout", ["sap/ui/base/ManagedObject"],function(e){"use strict";var a=e.extend("sap.m.CarouselLayout",{metadata:{library:"sap.m",properties:{visiblePagesCount:{type:"int",group:"Misc",defaultValue:1}}}});
/*!
	 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
	 */return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CarouselRenderer", ["sap/m/library","sap/base/strings/capitalize","sap/ui/core/Core","sap/ui/Device"],function(e,t,s,r){"use strict";var a=e.CarouselArrowsPlacement;var o=e.PlacementType;var n=s.getLibraryResourceBundle("sap.m");var i={apiVersion:2};i._BULLETS_TO_NUMBERS_THRESHOLD=9;i.render=function(e,t){var s=t.getPages(),n=s.length,i=t.getPageIndicatorPlacement(),l=t.getArrowsPlacement(),d=t._iCurrSlideIndex;this._renderOpeningDiv(e,t);this._renderDummyArea(e,t,"before");if(i===o.Top){this._renderPageIndicatorAndArrows(e,t,{iPageCount:n,iIndex:d,sArrowsPlacement:l,bBottom:false,bShowPageIndicator:t.getShowPageIndicator()})}this._renderInnerDiv(e,t,s,i);if(r.system.desktop&&n>t._getNumberOfItemsToShow()&&l===a.Content){this._renderHudArrows(e,t)}if(i===o.Bottom){this._renderPageIndicatorAndArrows(e,t,{iPageCount:n,iIndex:d,sArrowsPlacement:l,bBottom:true,bShowPageIndicator:t.getShowPageIndicator()})}this._renderDummyArea(e,t,"after");e.close("div")};i._renderOpeningDiv=function(e,t){var s=t.getTooltip_AsString();var r="sapMCrslBackground-"+t.getBackgroundDesign();e.openStart("div",t).class("sapMCrsl").class(r).class("sapMCrslFluid").style("width",t.getWidth()).style("height",t.getHeight()).attr("data-sap-ui-customfastnavgroup",true).accessibilityState(t,{role:"listbox"});if(s){e.attr("title",s)}e.openEnd()};i._renderInnerDiv=function(e,t,s,r){e.openStart("div").class("sapMCrslInner");if(!s.length){e.class("sapMCrslInnerNoPages")}if(s.length>1&&(t.getShowPageIndicator()||t.getArrowsPlacement()===a.PageIndicator)){if(r===o.Bottom){e.class("sapMCrslBottomOffset");if(t.getArrowsPlacement()===a.PageIndicator){e.class("sapMCrslBottomArrowsOffset")}}else{e.class("sapMCrslTopOffset");if(t.getArrowsPlacement()===a.PageIndicator){e.class("sapMCrslTopArrowsOffset")}}}e.openEnd();if(s.length){s.forEach(function(s,r,a){i._renderPage(e,s,t,r,a)})}else{i._renderNoData(e,t)}e.close("div")};i._renderPage=function(e,t,s,r,a){var o=s.getActivePage()===t.getId();e.openStart("div",s.getId()+"-"+t.getId()+"-slide").class("sapMCrslItem").accessibilityState(t,{role:"option",posinset:r+1,setsize:a.length,selected:o,hidden:!s._isPageDisplayed(r)}).attr("tabindex",o?0:-1).openEnd();i._renderPageInScrollContainer(e,s,t);e.close("div")};i._renderNoData=function(e,t){var s=t._getEmptyPage();var r=s.getAccessibilityInfo();e.openStart("div",t.getId()+"-noData").attr("tabindex",0).class("sapMCrslNoDataItem").accessibilityState({label:r.type+" "+r.description}).openEnd();e.renderControl(t._getEmptyPage());e.close("div")};i._renderPageIndicatorAndArrows=function(e,t,s){var o=s.iPageCount,l=r.system.desktop&&s.sArrowsPlacement===a.PageIndicator,d=t.getId(),c=[],p=t._getNumberOfItemsToShow(),g="sapMCrslControlsBackground-"+t.getPageIndicatorBackgroundDesign(),f="sapMCrslControlsBorder-"+t.getPageIndicatorBorderDesign();if(o<=t._getNumberOfItemsToShow()){return}if(!s.bShowPageIndicator&&!l){return}if(s.bBottom){c.push("sapMCrslControlsBottom")}else{c.push("sapMCrslControlsTop")}if(l){e.openStart("div").class("sapMCrslControls")}else{e.openStart("div").class("sapMCrslControlsNoArrows")}e.class(g).class(f);c.forEach(function(t){e.class(t)});e.openEnd();if(l){e.openStart("div").class("sapMCrslControlsContainer");c.forEach(function(t){e.class(t)});e.openEnd()}if(l){this._renderArrow(e,t,"previous")}e.openStart("div",d+"-pageIndicator");if(!s.bShowPageIndicator){e.style("opacity","0")}if(o<i._BULLETS_TO_NUMBERS_THRESHOLD){e.class("sapMCrslBulleted").openEnd();for(var C=1;C<=o-p+1;C++){e.openStart("span").attr("data-slide",C).accessibilityState({role:"img",label:n.getText("CAROUSEL_POSITION",[C,o])}).openEnd().close("span")}}else{e.class("sapMCrslNumeric").openEnd();var u=n.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[s.iIndex+1,o-p+1]);e.openStart("span",d+"-"+"slide-number").openEnd().text(u).close("span")}e.close("div");if(l){this._renderArrow(e,t,"next")}if(!l){e.close("div")}if(l){e.close("div").close("div")}};i._renderHudArrows=function(e,t){var s;if(t.getShowPageIndicator()){if(t.getPageIndicatorPlacement()===o.Top){s="sapMCrslHudTop"}else if(t.getPageIndicatorPlacement()===o.Bottom){s="sapMCrslHudBottom"}}else{s="sapMCrslHudMiddle"}e.openStart("div",t.getId()+"-hud").class("sapMCrslHud").class(s).openEnd();this._renderArrow(e,t,"previous");this._renderArrow(e,t,"next");e.close("div")};i._renderArrow=function(e,s,r){var a=r.slice(0,4),o=s.getLoop(),i=s._aAllActivePagesIndexes[0]===0,l=s._aAllActivePagesIndexes[s._aAllActivePagesIndexes.length-1]===s.getPages().length-1;e.openStart("span",s.getId()+"-arrow-"+r).class("sapMCrslArrow").class("sapMCrsl"+t(a)).attr("data-slide",a).attr("title",n.getText("PAGINGBUTTON_"+r.toUpperCase()));if(i&&r==="previous"&&!o){e.class("sapMCrslLeftmost")}else if(l&&r!=="previous"&&!o){e.class("sapMCrslRightmost")}e.openEnd();e.openStart("div").class("sapMCrslArrowInner").openEnd();e.renderControl(s._getNavigationArrow(r==="previous"?"Left":"Right"));e.close("div").close("span")};i._renderPageInScrollContainer=function(e,t,s){e.openStart("div").class("sapMScrollCont").class("sapMScrollContH").style("width","100%").style("height","100%").openEnd();e.openStart("div").class("sapMScrollContScroll").openEnd();e.openStart("div").class("sapMCrslItemTable").openEnd();e.openStart("div").class("sapMCrslItemTableCell");if(s.isA("sap.m.Image")){var o="sapMCrslImgNoArrows",n=r.system.desktop&&t.getArrowsPlacement()===a.PageIndicator;if(n){o="sapMCrslImg"}e.class(o)}e.openEnd();e.renderControl(s.addStyleClass("sapMCrsPage"));e.close("div");e.close("div");e.close("div");e.close("div")};i._renderDummyArea=function(e,t,s){e.openStart("div",t.getId()+"-"+s).class("sapMCrslDummyArea").attr("role","none").attr("tabindex",0).openEnd().close("div")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CheckBox", ["./Label","./library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/EnabledPropagator","sap/ui/core/AccessKeysEnablement","sap/ui/core/library","sap/ui/core/Lib","./CheckBoxRenderer","sap/ui/events/KeyCodes","sap/ui/core/LabelEnablement","sap/ui/core/message/MessageMixin"],function(e,t,i,a,r,o,n,s,l,p,u,c){"use strict";var g=n.ValueState;var h=n.TextAlign;var d=n.TextDirection;var y=i.extend("sap.m.CheckBox",{metadata:{interfaces:["sap.m.IToolbarInteractiveControl","sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent","sap.ui.core.IAccessKeySupport"],library:"sap.m",properties:{selected:{type:"boolean",group:"Data",defaultValue:false},partiallySelected:{type:"boolean",group:"Data",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:h.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},useEntireWidth:{type:"boolean",group:"Appearance",defaultValue:false},activeHandling:{type:"boolean",group:"Misc",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:g.None},valueStateText:{type:"string",group:"Misc",defaultValue:null,visibility:"hidden"},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},highlightAccKeysRef:{type:"boolean",defaultValue:false,visibility:"hidden"},accesskey:{type:"string",defaultValue:"",visibility:"hidden"}},aggregations:{_label:{type:"sap.m.Label",group:"Behavior",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selected:{type:"boolean"}}}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/CheckBox.designtime"},renderer:l});r.call(y.prototype);c.call(y.prototype);y.prototype.init=function(){this._handleReferencingLabels();o.registerControl(this)};y.prototype.onAccKeysHighlightStart=function(){this._getLabel().setProperty("highlightAccKeysRef",true)};y.prototype.onAccKeysHighlightEnd=function(){this._getLabel().setProperty("highlightAccKeysRef",false)};y.prototype.onBeforeRendering=function(){if(this.getText()){this.setProperty("accesskey",this.getText()[0].toLowerCase())}};y.prototype.exit=function(){this._oLabel=null;delete this._iTabIndex};y.prototype.setText=function(e){var t=this._getLabel();this.setProperty("text",e);t.setText(e);return this};y.prototype.setWidth=function(e){this.setProperty("width",e,true);this._setWidth();return this};y.prototype.setUseEntireWidth=function(e){this.setProperty("useEntireWidth",e,true);this._setWidth();return this};y.prototype.setTextDirection=function(e){var t=this._getLabel();this.setProperty("textDirection",e);t.setTextDirection(e);return this};y.prototype.setTextAlign=function(e){var t=this._getLabel();this.setProperty("textAlign",e);t.setTextAlign(e);return this};y.prototype.setValueStateText=function(e){return this.setProperty("valueStateText",e)};y.prototype.setWrapping=function(e){var t=this._getLabel();this.setProperty("wrapping",e);t.setWrapping(e);return this};y.prototype.getFormattedState=function(){var e=s.getResourceBundleFor("sap.m");return this.getSelected()?e.getText("ACC_CTR_STATE_CHECKED"):e.getText("ACC_CTR_STATE_NOT_CHECKED")};y.prototype.getFormFormattedValue=function(){return this.getFormattedState()};y.prototype.getFormValueProperty=function(){return"selected"};y.prototype.ontouchstart=function(e){e.originalEvent._sapui_handledByControl=true};y.prototype.ontap=function(e){var t;if(this.getEnabled()&&this.getEditable()&&!this.getDisplayOnly()){this.$().trigger("focus");t=this._getSelectedState();this.setSelected(t);this.setPartiallySelected(false);this.fireSelect({selected:t});e&&e.setMarked()}};y.prototype.onkeyup=function(e){if(e&&e.which===p.SPACE&&!e.shiftKey){this.ontap(e);e.preventDefault()}};y.prototype.onsapspace=function(e){e.preventDefault()};y.prototype.onsapenter=function(e){this.ontap(e)};y.prototype.setTabIndex=function(e){this._iTabIndex=e;this.$("CbBg").attr("tabindex",e);return this};y.prototype.getTabIndex=function(){if(this.hasOwnProperty("_iTabIndex")){return this._iTabIndex}return this.getEnabled()&&!this.getDisplayOnly()?0:-1};y.prototype._getLabel=function(){if(!this._oLabel){this._oLabel=new e(this.getId()+"-label").addStyleClass("sapMCbLabel");this._oLabel.getAccessKeysFocusTarget=function(){return this.getFocusDomRef()}.bind(this);this.setAggregation("_label",this._oLabel,true)}return this.getAggregation("_label")};y.prototype._setWidth=function(){var e=this._getLabel(),t=this.$(),i=this.getWidth();if(this.getUseEntireWidth()){e.setWidth("");t.outerWidth(i)}else{t.outerWidth("");e.setWidth(i)}};y.prototype._getSelectedState=function(){var e=this.getSelected(),t=this.getPartiallySelected();return e===t||!e&&t};y.prototype._getAriaChecked=function(){var e=this.getSelected();if(this.getPartiallySelected()&&e){return"mixed"}return e};y.prototype._fnLabelTapHandler=function(){this.$().trigger("focus")};y.prototype._handleReferencingLabels=function(){var e=u.getReferencingLabels(this),t=this;if(e.length>0){e.forEach(function(e){a.registry.get(e).addEventDelegate({ontap:function(){t._fnLabelTapHandler()}})})}};y.prototype.getAccessibilityInfo=function(){var e=s.getResourceBundleFor("sap.m"),t=this.getText();return{role:"checkbox",type:e.getText("ACC_CTR_TYPE_CHECKBOX"),description:(t?t+" ":"")+this.getFormattedState(),focusable:this.getEnabled()&&!this.getDisplayOnly(),enabled:this.getEnabled(),editable:this.getEditable()}};y.prototype._getToolbarInteractive=function(){return true};y.prototype.getFormDoNotAdjustWidth=function(){return this.getText()?false:true};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CheckBoxRenderer", ["sap/ui/core/library","sap/ui/core/ValueStateSupport","sap/ui/Device","sap/ui/core/Configuration"],function(e,t,a,s){"use strict";var i=e.ValueState;var r={apiVersion:2};r.render=function(e,t){var r=t.getId(),l=t.getEnabled(),c=t.getDisplayOnly(),n=t.getEditable(),d=l&&!c,p=l&&c,o=t.getAggregation("_label"),g=t.getValueState(),b=i.Error===g,f=i.Warning===g,u=i.Success===g,C=i.Information===g,y=t.getUseEntireWidth(),M=n&&l;e.openStart("div",t);e.class("sapMCb");e.attr("data-ui5-accesskey",t.getProperty("accesskey"));if(!n){e.class("sapMCbRo")}if(p){e.class("sapMCbDisplayOnly")}if(!l){e.class("sapMCbBgDis")}if(t.getText()){e.class("sapMCbHasLabel")}if(t.getWrapping()){e.class("sapMCbWrapped")}if(M){if(b){e.class("sapMCbErr")}else if(f){e.class("sapMCbWarn")}else if(u){e.class("sapMCbSucc")}else if(C){e.class("sapMCbInfo")}}if(y){e.style("width",t.getWidth())}var v=this.getTooltipText(t);if(v){e.attr("title",v)}if(d){e.attr("tabindex",t.getTabIndex())}e.accessibilityState(t,{role:"checkbox",selected:null,checked:t._getAriaChecked(),describedby:v&&M?r+"-Descr":undefined,labelledby:{value:o?o.getId():undefined,append:true}});if(p){e.attr("aria-readonly",true)}e.openEnd();e.openStart("div",t.getId()+"-CbBg");e.class("sapMCbBg");if(d&&n&&a.system.desktop){e.class("sapMCbHoverable")}if(!t.getActiveHandling()){e.class("sapMCbActiveStateOff")}e.class("sapMCbMark");if(t.getSelected()){e.class("sapMCbMarkChecked")}if(t.getPartiallySelected()){e.class("sapMCbMarkPartiallyChecked")}e.openEnd();e.voidStart("input",t.getId()+"-CB");e.attr("type","CheckBox");if(t.getSelected()){e.attr("checked","checked")}if(t.getName()){e.attr("name",t.getName())}if(!l){e.attr("disabled","disabled")}if(!n){e.attr("readonly","readonly")}e.voidEnd();e.close("div");e.renderControl(o);if(v&&s.getAccessibility()&&M){e.openStart("span",r+"-Descr");e.class("sapUiHidden");e.openEnd();e.text(v);e.close("span")}e.close("div")};r.getTooltipText=function(e){var a=e.getProperty("valueStateText"),s=e.getTooltip_AsString(),i=e.getEnabled(),r=e.getEditable();if(a){return(s?s+" - ":"")+a}else if(r&&i){return t.enrichTooltip(e,s)}return s};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColorPalette", ["sap/ui/core/Control","sap/ui/Device","sap/ui/base/DataType","sap/ui/core/library","sap/ui/core/delegate/ItemNavigation","./Button","./Dialog","./library","./ColorPaletteRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/unified/library","sap/ui/unified/ColorPickerDisplayMode","sap/ui/unified/ColorPicker"],function(t,e,o,r,i,n,s,a,l,h,u,jQuery,p,C,g){"use strict";var c=r.CSSColor;var f=p.ColorPickerMode;var _=a.ButtonType;var d=o.getType("boolean");var m="sapMColorPaletteSquare";var y=5;var v=2;var R=15;var I=sap.ui.getCore().getLibraryResourceBundle("sap.m");var D=t.extend("sap.m.ColorPalette",{metadata:{library:"sap.m",properties:{colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]}},aggregations:{_defaultColorButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_moreColorsButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{colorSelect:{parameters:{value:{type:"sap.ui.core.CSSColor"},defaultAction:{type:"boolean"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},renderer:l});D.prototype.init=function(){this._oDefaultColor=null;this._bShowDefaultColorButton=false;this._bShowMoreColorsButton=false;this._bShowRecentColorsSection=false;this._oDisplayMode=C.Default;this._oMoreColorsDialog=null;this._oPaletteColorItemNavigation=null;this._oRecentColorItemNavigation=null;this._recentColors=[]};D.prototype.exit=function(){if(this._oMoreColorsDialog){this._oMoreColorsDialog.destroy();delete this._oMoreColorsDialog}if(this._oPaletteColorItemNavigation){this.removeDelegate(this._oPaletteColorItemNavigation);this._oPaletteColorItemNavigation.destroy();delete this._oPaletteColorItemNavigation}if(this._oRecentColorItemNavigation){this.removeDelegate(this._oRecentColorItemNavigation);this._oRecentColorItemNavigation.destroy();delete this._oRecentColorItemNavigation}};D.prototype.setColors=function(t){t=this.validateProperty("colors",t);if(t.length<v||t.length>R){throw new Error("Cannot set property 'colors' - array must has minimum 2 and maximum 15 elements")}return this.setProperty("colors",t)};D.prototype._setDisplayMode=function(t){var e=this._getColorPicker();e.setDisplayMode(t);this._oDisplayMode=t;return this};D.prototype._getDisplayMode=function(){return this._oDisplayMode};D.prototype._getColorPicker=function(){return this._ensureMoreColorsDialog()._oColorPicker};D.prototype.ontap=function(t){var e=jQuery(t.target),o,r;r=e.closest("."+m);if(!r.length){return}o=r.attr("data-sap-ui-color");this._fireColorSelect(o,false,t)};D.prototype.onsaptabnext=D.prototype.onsaptabprevious=function(t){var e=this._getElementInfo(t.target);if(e.bIsMoreColorsButton){this.fireEvent("_colorNotSelected",{_originalEvent:t});return}if(e.bIsDefaultColorButton){this._fireColorSelect(this._getDefaultColor(),true,t);return}D.prototype.ontap.apply(this,arguments)};D.prototype.onsapenter=D.prototype.ontap;D.prototype.onsapspace=function(t){t.preventDefault()};D.prototype.onkeyup=function(t){if(t.which===u.SPACE){t.preventDefault();D.prototype.ontap.apply(this,arguments)}};D.prototype.onAfterRendering=function(){this._ensureItemNavigation()};D.prototype.pushToRecentColors=function(t){var e=this._recentColors.indexOf(t);if(e>-1){this._recentColors.splice(e,1)}else if(this._recentColors.length===5){this._recentColors.pop()}this._recentColors.unshift(t);this.invalidate()};D.prototype.setColorPickerSelectedColor=function(t){if(!c.isValid(t)){throw new Error("Cannot set the selected color - invalid value: "+t)}this._getColorPicker().setColorString(t);return this};D.prototype._createDefaultColorButton=function(){return new n(this.getId()+"-btnDefaultColor",{width:"100%",type:_.Transparent,text:I.getText("COLOR_PALETTE_DEFAULT_COLOR"),visible:this._getShowDefaultColorButton(),press:function(t){this._fireColorSelect(this._getDefaultColor(),true,t)}.bind(this)})};D.prototype._getDefaultColor=function(){return this._oDefaultColor};D.prototype._setDefaultColor=function(t){if(!c.isValid(t)){throw new Error("Cannot set internal property '_defaultColor' - invalid value: "+t)}this._oDefaultColor=t;return this};D.prototype._getShowDefaultColorButton=function(){return this._bShowDefaultColorButton};D.prototype._setShowDefaultColorButton=function(t){if(!d.isValid(t)){throw new Error("Cannot set internal property 'showDefaultColorButton' - invalid value: "+t)}this._bShowDefaultColorButton=t;if(t&&!this._getDefaultColorButton()){this.setAggregation("_defaultColorButton",this._createDefaultColorButton())}if(this._getDefaultColorButton()){this._getDefaultColorButton().setVisible(t)}return this};D.prototype._getDefaultColorButton=function(){return this.getAggregation("_defaultColorButton")};D.prototype._createMoreColorsButton=function(){return new n(this.getId()+"-btnMoreColors",{width:"100%",type:_.Transparent,text:I.getText("COLOR_PALETTE_MORE_COLORS"),visible:this._getShowMoreColorsButton(),press:this._openColorPicker.bind(this)})};D.prototype._getShowMoreColorsButton=function(){return this._bShowMoreColorsButton};D.prototype._getShowRecentColorsSection=function(){return this._bShowRecentColorsSection};D.prototype._getRecentColors=function(){return this._recentColors};D.prototype._setShowRecentColorsSection=function(t){if(!d.isValid(t)){throw new Error("Cannot set internal property 'showRecentColorsSection' - invalid value: "+t)}this._bShowRecentColorsSection=t;return this};D.prototype._setShowMoreColorsButton=function(t){if(!d.isValid(t)){throw new Error("Cannot set internal property 'showMoreColorsButton' - invalid value: "+t)}this._bShowMoreColorsButton=t;if(t&&!this._getMoreColorsButton()){this.setAggregation("_moreColorsButton",this._createMoreColorsButton())}if(this._getMoreColorsButton()){this._getMoreColorsButton().setVisible(t)}return this};D.prototype._getMoreColorsButton=function(){return this.getAggregation("_moreColorsButton")};D.prototype._openColorPicker=function(){this.fireEvent("_beforeOpenColorPicker");this._ensureMoreColorsDialog().open()};D.prototype._ensureMoreColorsDialog=function(){if(!this._oMoreColorsDialog){this._oMoreColorsDialog=this._createMoreColorsDialog()}return this._oMoreColorsDialog};D.prototype._createMoreColorsDialog=function(){var t=new s(this.getId()+"-moreColorsDialog",{stretch:!!e.system.phone,title:I.getText("COLOR_PALETTE_MORE_COLORS_TITLE")}).addStyleClass("CPDialog");t.addContent(t._oColorPicker=new g({mode:f.HSL,displayMode:this._oDisplayMode,liveChange:function(t){this.fireLiveChange(t.getParameters())}.bind(this)}));t.setBeginButton(new n({text:I.getText("COLOR_PALETTE_MORE_COLORS_CONFIRM"),press:function(e){t.close();if(t._oColorPicker.getColorString()){this._fireColorSelect(t._oColorPicker.getColorString(),false,e)}}.bind(this)}));t.setEndButton(new n({text:I.getText("COLOR_PALETTE_MORE_COLORS_CANCEL"),press:function(){t.close()}}));return t};D.prototype._focusFirstElement=function(){var t=this._getShowDefaultColorButton()?this._getDefaultColorButton().getDomRef():this._getAllPaletteColorSwatches()[0];t.focus()};D.prototype._fireColorSelect=function(t,e,o){this.fireColorSelect({value:t,defaultAction:e,_originalEvent:o});this.pushToRecentColors(t)};D.prototype._ensureItemNavigation=function(){var t=[],e=[];if(!this._oPaletteColorItemNavigation){this._oPaletteColorItemNavigation=new B(this);this._oPaletteColorItemNavigation.setColumns(y);this._oPaletteColorItemNavigation.setCycling(false);this.addDelegate(this._oPaletteColorItemNavigation);this._oPaletteColorItemNavigation.attachEvent(i.Events.BorderReached,this._onSwatchContainerBorderReached,this);this._oPaletteColorItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]})}if(!this._oRecentColorItemNavigation){this._oRecentColorItemNavigation=new B(this);this._oRecentColorItemNavigation.setColumns(y);this._oRecentColorItemNavigation.setCycling(false);this.addDelegate(this._oRecentColorItemNavigation);this._oRecentColorItemNavigation.attachEvent(i.Events.BorderReached,this._onSwatchContainerBorderReached,this);this._oRecentColorItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]})}t=t.concat(this._getAllPaletteColorSwatches());e=e.concat(this._getAllRecentColorSwatches());e=e.slice(0,this._getRecentColors().length);this._oPaletteColorItemNavigation.setRootDomRef(this.getDomRef("swatchCont-paletteColor"));this._oPaletteColorItemNavigation.setItemDomRefs(t);this._oRecentColorItemNavigation.setRootDomRef(this.getDomRef("swatchCont-recentColors"));this._oRecentColorItemNavigation.setItemDomRefs(e)};D.prototype._onSwatchContainerBorderReached=function(t){var e,o,r=["saphome","sapend"].indexOf(t.getParameter("event").type)>-1,i=this._getAllRecentColorSwatches()[0]?this._getElementInfo(t.mParameters.event.target).bIsRecentColorSwatch:false;if(t.getParameter(B.BorderReachedDirection)===B.BorderReachedDirectionForward){if(this._getShowMoreColorsButton()&&!i){e=this._getMoreColorsButton()}else if(!r&&this._bShowRecentColorsSection&&!i&&this._getRecentColors().length>0){e=this._getAllRecentColorSwatches()[0]}else if(!r&&this._getShowDefaultColorButton()){e=this._getDefaultColorButton()}else if(!r){e=this._getAllPaletteColorSwatches()[0]}}else{if(this._getShowDefaultColorButton()&&!i){e=this._getDefaultColorButton()}else if(!r&&this._bShowRecentColorsSection&&!i&&this._getRecentColors().length>0){e=this._getAllRecentColorSwatches()[0]}else if(!r&&this._getShowMoreColorsButton()){e=this._getMoreColorsButton()}else if(!r&&!this._getShowDefaultColorButton()){o=this._getAllPaletteColorSwatches();e=o[o.length-1]}else if(!r){o=this._getAllPaletteColorSwatches();e=o[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()]}}if(e){e.focus()}return e};D.prototype.onsapnext=function(t){var e,o=this._getElementInfo(t.target);if(!(o.bIsDefaultColorButton||o.bIsMoreColorsButton)){return}t.preventDefault();t.stopImmediatePropagation(true);if(o.bIsDefaultColorButton){e=this._getAllPaletteColorSwatches()[0]}else if(this._getRecentColors().length>0&&!o.bIsRecentColorSwatch&&this._bShowRecentColorsSection){e=this._getAllRecentColorSwatches()[0]}else{e=this._getShowDefaultColorButton()?this._getDefaultColorButton():this._getAllPaletteColorSwatches()[0]}e.focus()};D.prototype.onsapprevious=function(t){var e,o=this._getElementInfo(t.target),r;if(!(o.bIsDefaultColorButton||o.bIsMoreColorsButton||t.target===this._getAllRecentColorSwatches()[0])){return}t.preventDefault();t.stopImmediatePropagation(true);r=this._getAllPaletteColorSwatches();if(o.bIsMoreColorsButton||!o.bIsMoreColorsButton&&this.bIsRecentColorSwatch){e=t.keyCode===u.ARROW_UP?r[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()]:r[r.length-1]}else if(o.bIsRecentColorSwatch&&!this._bShowMoreColorsButton&&!this._bShowDefaultColorButton){r=this._getAllPaletteColorSwatches();e=r[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()]}else if(this._getRecentColors().length>0&&!o.bIsRecentColorSwatch&&this._bShowRecentColorsSection){e=this._getAllRecentColorSwatches()[0]}else if(this._getShowMoreColorsButton()){e=this._getMoreColorsButton()}else{e=r[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()]}e.focus()};D.prototype.onsaphome=function(t){var e=this._getElementInfo(t.target);if(!e.bIsMoreColorsButton){return}if(this._getShowDefaultColorButton()){this._getDefaultColorButton().focus()}t.preventDefault();t.stopImmediatePropagation(true)};D.prototype.onsapend=function(t){var e=this._getElementInfo(t.target);if(!e.bIsDefaultColorButton){return}if(this._getShowMoreColorsButton()){this._getMoreColorsButton().focus()}t.preventDefault();t.stopImmediatePropagation(true)};D.prototype._getAllPaletteColorSwatches=function(){return this.$().find("."+m).get().slice(0,this.getColors().length)};D.prototype._getAllRecentColorSwatches=function(){return this.$().find("."+m).get().slice(this.getColors().length)};D.prototype._getElementInfo=function(t){var e=this._getShowDefaultColorButton()&&h(t,this._getDefaultColorButton().getDomRef()),o=!e&&this._getShowMoreColorsButton()&&h(t,this._getMoreColorsButton().getDomRef()),r=this._getAllRecentColorSwatches().indexOf(t)>-1,i=this._getAllPaletteColorSwatches().indexOf(t)>-1;return{bIsDefaultColorButton:e,bIsMoreColorsButton:o,bIsASwatch:i,bIsRecentColorSwatch:r}};var B=i.extend("sap.m.ItemNavigationHomeEnd",{constructor:function(){i.apply(this,arguments);this.setHomeEndColumnMode(true);this.fireEvent=function(t,e){var o;if(t===i.Events.BorderReached){o=B.BorderReachedDirectionBackward;if(["sapnext","sapend"].indexOf(e.event.type)>-1){o=B.BorderReachedDirectionForward}e[B.BorderReachedDirection]=o}return i.prototype.fireEvent.apply(this,arguments)}}});B.BorderReachedDirection="direction";B.BorderReachedDirectionForward="BorderReachedDirectionForward";B.BorderReachedDirectionBackward="BorderReachedDirectionBackward";B.prototype.getColumns=function(){return this.iColumns};B.prototype.onsapprevious=function(t){var e=h(this.getRootDomRef(),t.target),o=t.keyCode===u.ARROW_UP&&this.getFocusedIndex()===0;if(!e){return}if(!o){i.prototype.onsapprevious.apply(this,arguments);return}t.preventDefault();this.fireEvent(i.Events.BorderReached,{index:0,event:t})};B.prototype.onsapnext=function(t){var e=h(this.getRootDomRef(),t.target),o,r,n;if(!e){return}if(t.keyCode!==u.ARROW_DOWN){i.prototype.onsapnext.apply(this,arguments);return}r=this.getFocusedIndex();n=this._getItemInfo(r);if(n.bIsLastItem&&n.bIsInTheLastColumn){t.preventDefault();this.fireEvent(i.Events.BorderReached,{index:r,event:t});return}if(n.bNextRowExists&&!n.bItemSameColumnNextRowExists){t.preventDefault();o=this.getItemDomRefs();o[o.length-1].focus();return}i.prototype.onsapnext.apply(this,arguments)};B.prototype.onsaphome=function(t){var e=h(this.getRootDomRef(),t.target),o;if(!e){return}o=this._getItemInfo(this.getFocusedIndex());if(!o.bIsInTheFirstColumn){i.prototype.onsaphome.apply(this,arguments);return}t.preventDefault();if(o.bIsFirstItem){this.fireEvent(i.Events.BorderReached,{index:0,event:t})}else{this.getItemDomRefs()[0].focus()}};B.prototype.onsapend=function(t){var e=h(this.getRootDomRef(),t.target),o;if(!e){return}o=this._getItemInfo(this.getFocusedIndex());if(!(o.bIsLastItem||o.bIsInTheLastColumn)){i.prototype.onsapend.apply(this,arguments);return}t.preventDefault();if(o.bIsLastItem){this.fireEvent(i.Events.BorderReached,{index:this.getItemDomRefs().length-1,event:t})}else{this.getItemDomRefs()[this.getItemDomRefs().length-1].focus()}};B.prototype._getItemInfo=function(t){var e=this.getItemDomRefs().length,o=t===e-1,r=e>this.getColumns()?this.getColumns():e,i=t%this.getColumns()===0,n=(t+1)%r===0,s=Math.floor(t/this.getColumns())+1,a,l;a=s*this.getColumns()<e;l=a&&t+this.getColumns()<e;return{bIsFirstItem:t===0,bIsLastItem:o,bIsInTheLastColumn:n,bIsInTheFirstColumn:i,bNextRowExists:a,bItemSameColumnNextRowExists:l}};B.prototype._getIndexOfTheFirstItemInLastRow=function(){return Math.floor((this.getItemDomRefs().length-1)/this.getColumns())*this.getColumns()};D.prototype._ItemNavigation=B;D.prototype._ColorsHelper={RGB_TO_NAMED_COLORS_MAP:{"#FFB200":"gold","#FF8C00":"darkorange","#CD5C5C":"indianred","#8B008B":"darkmagenta","#6495ED":"cornflowerblue","#00BFFF":"deepskyblue","#008B8B":"darkcyan","#6B8E23":"olivedrab","#2F4F4F":"darkslategray","#F0FFFF":"azure","#FFFFFF":"white","#D3D3D3":"lightgray","#A9A9A9":"darkgray","#696969":"dimgray","#000000":"black"},NAME_COLORS_TO_RGB_MAP:{gold:"#FFB200",darkorange:"#FF8C00",indianred:"#CD5C5C",darkmagenta:"#8B008B",cornflowerblue:"#6495ED",deepskyblue:"#00BFFF",darkcyan:"#008B8B",olivedrab:"#6B8E23",darkslategray:"#2F4F4F",azure:"#F0FFFF",white:"#FFFFFF",lightgray:"#D3D3D3",darkgray:"#A9A9A9",dimgray:"#696969",black:"#000000"},getNamedColor:function(t){var e="";if(!t||t.toLowerCase().indexOf("hsl")!==-1){return undefined}if(t.indexOf("#")===-1){return this.NAME_COLORS_TO_RGB_MAP[t.toLowerCase()]?t.toLowerCase():undefined}if(t.length===4){e=["#",t[1],t[1],t[2],t[2],t[3],t[3]].join("")}else{e=t}e=e.toUpperCase();return this.RGB_TO_NAMED_COLORS_MAP[e]}};return D});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColorPalettePopover", ["sap/ui/core/Control","sap/ui/Device","sap/ui/unified/ColorPickerDisplayMode","./Button","./ResponsivePopover","./ColorPalette","./library"],function(e,t,o,r,a,n,l){"use strict";var i=l.PlacementType;var s=e.extend("sap.m.ColorPalettePopover",{metadata:{library:"sap.m",publicMethods:["openBy","close"],properties:{defaultColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]},showDefaultColorButton:{type:"boolean",group:"Appearance",defaultValue:true},showMoreColorsButton:{type:"boolean",group:"Appearance",defaultValue:true},showRecentColorsSection:{type:"boolean",group:"Appearance",defaultValue:true},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:o.Default}},events:{colorSelect:{parameters:{value:{type:"sap.ui.core.CSSColor"},defaultAction:{type:"boolean"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},renderer:{apiVersion:2}});var p=sap.ui.getCore().getLibraryResourceBundle("sap.m");var u={COLOR_PALETTE_PROPS:{colors:"setColors",defaultColor:"_setDefaultColor",showDefaultColorButton:"_setShowDefaultColorButton",showMoreColorsButton:"_setShowMoreColorsButton",showRecentColorsSection:"_setShowRecentColorsSection",displayMode:"_setDisplayMode"},POPOVER_METHODS:{getDomRef:"",close:"",openBy:""}};s.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null};s.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null}};s.prototype.setColorPickerSelectedColor=function(e){this._getPalette().setColorPickerSelectedColor(e);return this};s.prototype._getPalette=function(){return this._ensurePopover().getContent()[0]};s.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover()}return this._oPopover};s.prototype._createPopover=function(){var e,o=this._createColorPalette(),n;e=new a(this.getId()+"-colorPalettePopover",{showHeader:t.system.phone,placement:i.VerticalPreferredBottom,showArrow:false,showCloseButton:false,title:p.getText("COLOR_PALETTE_TITLE"),content:o,afterOpen:o._focusFirstElement.bind(o)}).addStyleClass("sapMColorPaletteContainer");if(t.system.phone){e.setEndButton(new r({text:p.getText("COLOR_PALETTE_CANCEL"),press:function(){e.close()}}))}o.attachEvent("_beforeOpenColorPicker",function(){e.close()});o.attachEvent("_colorNotSelected",function(t){this._handleNextOrPreviousUponPaletteClose(t);e.close()}.bind(this));o.attachEvent("colorSelect",function(t){this._handleNextOrPreviousUponPaletteClose(t);e.close();this.fireColorSelect({value:t.getParameter("value"),defaultAction:t.getParameter("defaultAction")})}.bind(this));n={onAfterRendering:function(){var e=this.$();e.attr("aria-modal","true");e.attr("aria-label",this.getTitle())}};e.addEventDelegate(n,e);e._onAfterRenderingDelegate=n;return e};s.prototype._createColorPalette=function(){var e=new n(this.getId()+"-palette",{liveChange:function(e){this.fireLiveChange(e.getParameters())}.bind(this)});e._setShowDefaultColorButton(this.getShowDefaultColorButton());e._setShowMoreColorsButton(this.getShowMoreColorsButton());e._setShowRecentColorsSection(this.getShowRecentColorsSection());return e};s.prototype._handleNextOrPreviousUponPaletteClose=function(e){var t=e.getParameter("_originalEvent");if(!t){return}if(t.type==="saptabnext"||t.type==="saptabprevious"){t.stopPropagation();t.preventDefault()}};s.prototype.setProperty=function(t,o,r){var a;if(u.COLOR_PALETTE_PROPS[t]!==undefined){a=u.COLOR_PALETTE_PROPS[t]||t;n.prototype[a].call(this._getPalette(),o)}return e.prototype.setProperty.apply(this,arguments)};Object.keys(u.POPOVER_METHODS).forEach(function(e){var t=u.COLOR_PALETTE_PROPS[e]||e;s.prototype[e]=function(){if(this._bPopoverDestroying){return null}var e=this._ensurePopover();return e[t].apply(e,arguments)}});return s});
/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColorPaletteRenderer", ["sap/ui/Device"],function(e){"use strict";var t={apiVersion:2};var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");t.render=function(t,o){t.openStart("div",o);t.class("sapMColorPalette");t.openEnd();if(o._getShowDefaultColorButton()){this.renderDefaultColorButton(t,o);this.renderSeparator(t)}this.renderSwatches(t,o);if(o._getShowMoreColorsButton()){this.renderSeparator(t);this.renderMoreColorsButton(t,o);if(e.system.phone){this.renderSeparator(t)}}if(o._getShowRecentColorsSection()){if(!o._getShowMoreColorsButton()||!e.system.phone){this.renderSeparator(t)}this.renderRecentColorsSection(t,o);if(e.system.phone){this.renderSeparator(t)}}t.close("div")};t.renderSwatches=function(e,t){var r=t.getColors();e.openStart("div",t.getId()+"-swatchCont-paletteColor");e.class("sapMColorPaletteContent");e.accessibilityState(t,{role:"region",label:o.getText("COLOR_PALETTE_SWATCH_CONTAINER_TITLE")});e.openEnd();r.forEach(function(o,r){this.renderSquare(e,t,o,r,false)},this);e.close("div")};t.renderSquare=function(e,t,r,n,a){var s=t._ColorsHelper.getNamedColor(r),i=s===undefined?o.getText("COLOR_PALETTE_PREDEFINED_COLOR_CUSTOM"):o.getText("COLOR_PALETTE_PREDEFINED_COLOR_"+s.toUpperCase()),l=a?o.getText("COLOR_PALETTE_RECENT_COLOR",[n+1,i]):o.getText("COLOR_PALETTE_PREDEFINED_COLOR",[n+1,i]);e.openStart("div");e.class("sapMColorPaletteSquare");if(a&&r===""){e.class("sapMRecentColorSquareDisabled")}e.attr("data-sap-ui-color",r);e.attr("tabindex","-1");e.attr("title",l);e.accessibilityState(t,{role:"button",label:l});e.openEnd();e.openStart("div");e.style("background-color",r);e.openEnd();e.close("div");e.close("div")};t.renderSeparator=function(e){e.openStart("div");e.class("sapMColorPaletteSeparator");e.openEnd();e.voidStart("hr");e.voidEnd();e.close("div")};t.renderDefaultColorButton=function(e,t){e.renderControl(t._getDefaultColorButton())};t.renderMoreColorsButton=function(e,t){e.renderControl(t._getMoreColorsButton())};t.renderRecentColorsSection=function(e,t){var r,n=t._getRecentColors(),a=5,s=o.getText("COLOR_PALETTE_SWATCH_RECENT_COLOR_CONTAINER_TITLE");e.openStart("div",t.getId()+"-swatchCont-recentColors");e.class("sapMColorPaletteContent");e.attr("role","region");e.attr("aria-label",s);e.openEnd();for(var i=0;i<a;i++){if(n[i]){r=n[i]}else{r=""}this.renderSquare(e,t,r,i,true)}e.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Column", ["./library","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Renderer","sap/ui/core/library","sap/ui/Device","sap/ui/core/InvisibleText"],function(e,t,i,r,n,a,o){"use strict";var s=e.PopinDisplay;var p=n.VerticalAlign;var u=n.TextAlign;var d=n.SortOrder;var h=i.extend("sap.m.Column",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},hAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:u.Begin},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:p.Inherit},styleClass:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},minScreenWidth:{type:"string",group:"Behavior",defaultValue:null},demandPopin:{type:"boolean",group:"Behavior",defaultValue:false},popinHAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:u.Begin,deprecated:true},popinDisplay:{type:"sap.m.PopinDisplay",group:"Appearance",defaultValue:s.Block},mergeDuplicates:{type:"boolean",group:"Behavior",defaultValue:false},mergeFunctionName:{type:"string",group:"Misc",defaultValue:"getText"},sortIndicator:{type:"sap.ui.core.SortOrder",group:"Appearance",defaultValue:d.None},importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},autoPopinWidth:{type:"float",group:"Behavior",defaultValue:8}},defaultAggregation:"header",aggregations:{header:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false}},associations:{headerMenu:{type:"sap.ui.core.IColumnHeaderMenu",multiple:false}},designtime:"sap/m/designtime/Column.designtime"}});h.prototype._index=-1;h.prototype._media=null;h.prototype._bForcedColumn=false;h.prototype.exit=function(){this._clearMedia()};h.prototype.setParent=function(e){i.prototype.setParent.apply(this,arguments);if(!e){delete this._initialOrder}return this};h.prototype.getTable=function(){var e=this.getParent();if(e&&e.isA("sap.m.Table")){return e}};h.prototype.informTable=function(e,t,i){var r=this.getTable();if(r){var n="onColumn"+e;if(r[n]){r[n](this,t,i)}}};h.prototype.ontouchstart=function(e){this._bTouchStartMarked=e.isMarked()};h.prototype.ontap=function(e){if(!this._bTouchStartMarked&&!e.isMarked()){this.informTable("Press")}};h.prototype.onsapspace=function(e){if(e.srcControl===this){this.informTable("Press");e.preventDefault()}};h.prototype.onsapenter=h.prototype.onsapspace;h.prototype.oncontextmenu=function(e){var t=this.getHeaderMenuInstance();if(t){t.openBy(this);e.preventDefault()}};h.prototype.invalidate=function(){var e=this.getParent();if(e&&e.bOutput){i.prototype.invalidate.apply(this,arguments)}};h.prototype._clearMedia=function(){if(this._media&&this._minWidth){this._detachMediaContainerWidthChange(this._notifyResize,this,this.getId());a.media.removeRangeSet(this.getId());this._media=null}};h.prototype._addMedia=function(){delete this._bShouldAddMedia;if(this._minWidth){a.media.initRangeSet(this.getId(),[parseFloat(this._minWidth)]);this._attachMediaContainerWidthChange(this._notifyResize,this,this.getId());this._media=this._getCurrentMediaContainerRange(this.getId());if(this._media){this._media.matches=!!this._media.from}}};h.prototype._notifyResize=function(e){if(this._media.from===e.from){return}this._media=e;this._media.matches=!!e.from;if(this.getVisible()){this.informTable("Resize")}};h.prototype._validateMinWidth=function(t){if(!t){return}if(Object.prototype.toString.call(t)!="[object String]"){throw new Error('expected string for property "minScreenWidth" of '+this)}if(Object.keys(e.ScreenSizes).indexOf(t.toLowerCase())!=-1){return}if(!/^\d+(\.\d+)?(px|em|rem)$/i.test(t)){throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of '+this)}};h.prototype.getCssAlign=function(e){e=e||this.getHAlign();if(e===u.Begin||e===u.End||e===u.Initial){e=r.getTextAlign(e)}return e.toLowerCase()};h.prototype.setIndex=function(e){this._index=+e};h.prototype.getIndex=function(){return this._index};h.prototype.setOrder=function(e){this._order=+e};h.prototype.getOrder=function(){return this.hasOwnProperty("_order")?this._order:this.getInitialOrder()};h.prototype.setInitialOrder=function(e){this._initialOrder=+e};h.prototype.getInitialOrder=function(){if(this.hasOwnProperty("_initialOrder")){return this._initialOrder}var e=this.getTable();if(!e){return-1}return e.indexOfColumn(this)};h.prototype._setMinScreenWidth=function(t){this._clearMedia();this._minWidth=0;if(t){t=t.toLowerCase();var i=e.ScreenSizes[t];if(i){this._minWidth=i+"px"}else if(t.endsWith("px")){this._minWidth=t}else{var r=parseFloat(e.BaseFontSize);this._minWidth=parseFloat(t)*r+"px"}var n=this.getTable();if(n&&n.isActive()){this._addMedia()}else{this._bShouldAddMedia=true}}};h.prototype.setMinScreenWidth=function(e){e=e||"";if(e==this.getMinScreenWidth()){return this}this._validateMinWidth(e);this._setMinScreenWidth(e);return this.setProperty("minScreenWidth",e)};h.prototype.setSortIndicator=function(e){this.setProperty("sortIndicator",e,true);this.$().attr("aria-sort",this.getSortIndicator().toLowerCase());return this};h.prototype.isPopin=function(){if(!this.getDemandPopin()){return false}var e=this.getTable();if(e){var t=e.getHiddenInPopin()||[];var i=t.includes(this.getImportance());if(i){return false}}return this.isHidden()};h.prototype.isHidden=function(){return this._media?!this._media.matches:false};h.prototype.setLastValue=function(e){this._lastValue=e;return this};h.prototype.clearLastValue=function(){return this.setLastValue(NaN)};h.prototype.getLastValue=function(){return this._lastValue};h.prototype.onItemsRemoved=function(){this.clearLastValue()};h.prototype.onTableRendering=function(){this.clearLastValue();if(this._bShouldAddMedia){this._addMedia()}};h.prototype.getCalculatedMinScreenWidth=function(){return parseInt(this._minWidth)||0};h.prototype.setForcedColumn=function(e){if(this._bForcedColumn==e){return}this._bForcedColumn=e;this._setMinScreenWidth(e?"":this.getMinScreenWidth())};h.prototype.getHeaderMenuInstance=function(){return t.byId(this.getHeaderMenu())};h.prototype.setHeader=function(e){var t=this.getHeader();if(t&&t.isA("sap.m.Label")){t.detachEvent("_change",this._onLabelPropertyChange,this);t.setIsInColumnHeaderContext(false)}this.setAggregation("header",e);var i=this.getHeader();if(i&&i.isA("sap.m.Label")){i.attachEvent("_change",this._onLabelPropertyChange,this);i.setIsInColumnHeaderContext(true)}return this};h.prototype._onLabelPropertyChange=function(e){var t=this.getTable();if(!t||e.getParameter("name")!="required"){return}if(t.bActiveHeaders||this.getHeaderMenuInstance()){this.$()[e.getSource().getRequired()?"addAriaDescribedBy":"removeAriaDescribedBy"](o.getStaticId("sap.m","CONTROL_IN_COLUMN_REQUIRED"))}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColumnHeaderPopover", ["sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/StaticArea","sap/m/Toolbar","sap/m/Button","sap/m/ResponsivePopover","sap/m/ToolbarSpacer"],function(e,t,o,i,r,n,a){"use strict";var s=e.extend("sap.m.ColumnHeaderPopover",{metadata:{library:"sap.m",properties:{},aggregations:{items:{type:"sap.m.ColumnPopoverItem",multiple:true,singularName:"item",bindable:true},_popover:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},defaultAggregation:"items",associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}},renderer:null});s.prototype.init=function(){this._bPopoverCreated=false;this._oShownCustomContent=null;var e=this;this._minWidthDelegate=function(){this.$().css("min-width",e.minWidth)}};s.prototype.exit=function(){if(this._oToolbar){this._oToolbar.destroy();this._oToolbar=null}this._closeBtn=null;this._spacer=null;this._aButtons=null;this._oShownCustomContent=null};s.prototype._createPopover=function(){var e=this;this._oShownCustomContent=null;var o=t.getResourceBundleFor("sap.m"),s=o.getText("COLUMNHEADERPOPOVER_CLOSE_BUTTON");var l=new n(this.getId()+"-popover",{showArrow:false,showHeader:false,placement:"Bottom",verticalScrolling:true,horizontalScrolling:false,ariaLabelledBy:this.getAriaLabelledBy(),beforeClose:function(t){if(e._oShownCustomContent){e._oShownCustomContent.setVisible(false);e._oShownCustomContent=null}e._cleanSelection()}});l._oControl.addDelegate({onAfterRendering:this._minWidthDelegate},l._oControl);this.setAggregation("_popover",l);var p=new i(this.getId()+"-tb");this._spacer=new a;this._closeBtn=new r(p.getId()+"-closeBtn",{type:"Transparent",icon:"sap-icon://decline",tooltip:s,press:[l.close,l]});p.addContent(this._spacer);p.addContent(this._closeBtn);l.addContent(p);this._oToolbar=p};s.prototype._cleanSelection=function(e){var t=this._aButtons;if(t){t.forEach(function(t){if((!e||t!==e)&&t.getPressed&&t.getPressed()){t.setPressed(false)}})}};s.prototype.openBy=function(e){if(!this._bPopoverCreated){this._createPopover();this._bPopoverCreated=true}else{this._oToolbar.removeContent(this._spacer);this._oToolbar.removeContent(this._closeBtn);this._oToolbar.destroyContent()}var t=this.getAggregation("_popover");var i=[];var r=this.getItems();var n=5;for(var a=0;a<r.length&&i.length<n;a++){var s=r[a];if(s.getVisible()){var l=s._createButton(this._oToolbar.getId()+"-btn_"+a,this);l._sContentId=s._sContentId;i.push(l);this._oToolbar.insertContent(l,a)}}if(i.length===0){return}this._aButtons=i;this._oToolbar.addContent(this._spacer);this._oToolbar.addContent(this._closeBtn);if(!this._bAppendedToUIArea&&!this.getParent()){var p=o.getUIArea();p.addContent(this,true);this._bAppendedToUIArea=true}var h=e.getFocusDomRef();if(h){t.setOffsetY(-h.clientHeight);this.minWidth=h.clientWidth}t.openBy(e)};s.prototype.invalidate=function(t){var o=this.getAggregation("_popover");if(t===o){e.prototype.invalidate.apply(this,arguments)}return this};s.prototype.addAriaLabelledBy=function(e){var t=this.getAggregation("_popover");if(t){t.addAriaLabelledBy(e)}return this.addAssociation("ariaLabelledBy",e)};s.prototype.removeAriaLabelledBy=function(e){var t=this.getAggregation("_popover");if(t){t.removeAriaLabelledBy(e)}return this.removeAssociation("ariaLabelledBy",e)};s.prototype.removeAllAssociation=function(t,o){if(t==="ariaLabelledBy"){var i=this.getAggregation("_popover");if(i){i.removeAllAssociation(t,o)}}return e.prototype.removeAllAssociation.apply(this,arguments)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColumnListItem", ["sap/ui/core/Element","sap/ui/core/library","./library","./ListItemBase","./ColumnListItemRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(t,e,n,o,i,jQuery){"use strict";var s=n.ListType;var r=e.VerticalAlign;var a=o.extend("sap.m.ColumnListItem",{metadata:{interfaces:["sap.m.ITableItem"],library:"sap.m",properties:{vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:r.Inherit}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell",bindable:"bindable"}}},renderer:i});var p=t.extend("sap.m.TablePopin",{ontap:function(t){if(t.isMarked()||o.detectTextSelection(this.getDomRef())){return t.stopImmediatePropagation(true)}if(t.srcControl===this||!jQuery(t.target).is(":sapFocusable")){this.getParent().focus()}}});a.prototype.TagName="tr";a.prototype.init=function(){o.prototype.init.call(this);this._bNeedsTypeColumn=false;this._aClonedHeaders=[]};a.prototype.onBeforeRendering=function(){o.prototype.onBeforeRendering.call(this);this.aAriaOwns=[];if(this._oPopin&&this._oDomRef){this.$Popin().off()}};a.prototype.onAfterRendering=function(){if(this._oPopin){this.$().attr("aria-owns",this.aAriaOwns.join(" "));this.isActionable(true)&&this.$Popin().on("mouseenter mouseleave",function(t){this.previousSibling.classList.toggle("sapMPopinHovered",t.type=="mouseenter")})}o.prototype.onAfterRendering.call(this);this._checkTypeColumn()};a.prototype.exit=function(){o.prototype.exit.call(this);this._checkTypeColumn(false);this._destroyClonedHeaders();if(this._oPopin){this._oPopin.destroy(true);this._oPopin=null}};a.prototype.setVisible=function(t){o.prototype.setVisible.call(this,t);if(!t&&this.hasPopin()){this.removePopin()}return this};a.prototype.getTable=function(){var t=this.getParent();if(t&&t.isA("sap.m.Table")){return t}};a.prototype.getPopin=function(){if(!this._oPopin){this._oPopin=new p({id:this.getId()+"-sub"}).addDelegate({ontouchstart:this.ontouchstart,ontouchmove:this.ontouchmove,ontap:this.ontap,ontouchend:this.ontouchend,ontouchcancel:this.ontouchcancel,onsapup:this.onsapup,onsapdown:this.onsapdown,oncontextmenu:this.oncontextmenu,onkeydown:this.onkeydown,onfocusin:this.onfocusin,onfocusout:this.onfocusout},this).setParent(this,null,true)}return this._oPopin};a.prototype.$Popin=function(){return this.$("sub")};a.prototype.hasPopin=function(){return this._oPopin};a.prototype.removePopin=function(){this._oPopin&&this.$Popin().remove()};a.prototype.getTabbables=function(t){const e=t?this.$().find(".sapMListTblCell"):this.$();return e.add(this.$Popin()).find(":sapTabbable")};a.prototype.getDropAreaRect=function(){var t=null;var e=this.getDomRef();var n=e.getBoundingClientRect().toJSON();if(this._oPopin&&(t=this.getDomRef("sub"))){var o=t.getBoundingClientRect();n.bottom=o.bottom;n.height+=o.height}return n};a.prototype.getAccessibilityType=function(t){return t.getText("ACC_CTR_TYPE_ROW")};a.prototype.getContentAnnouncementOfCell=function(t){return l(t,this.getCells(),false)};function l(t,e,n){const i=e[t.getInitialOrder()];let s=o.getAccessibilityText(i,true);if(n){const e=t.getHeader();if(e&&e.getVisible()){s=o.getAccessibilityText(e)+" "+s}}return s}a.prototype.getContentAnnouncementOfPopin=function(){const t=this.getCells();const e=this.getTable()._getVisiblePopin().map(function(e){return l(e,t,true)});return e.filter(Boolean).join(" . ").trim()};a.prototype.getContentAnnouncement=function(){const t=this.getTable();if(!t){return}const e=this.getCells();const n=t.getRenderedColumns().map(function(t){return l(t,e,true)});return n.filter(Boolean).join(" . ").trim()};a.prototype.updateSelectedDOM=function(t,e){o.prototype.updateSelectedDOM.apply(this,arguments);e.find(".sapMTblCellFocusable").attr("aria-selected",t);if(this.hasPopin()){this.$("subcont").attr("aria-selected",t)}};a.prototype.onfocusin=function(e){if(e.isMarked()){return}if(e.srcControl===this){this.$().children(".sapMListTblCellDup").find(":sapTabbable").attr("tabindex",-1)}const n=this.getTable();const i=e.target;if(i.classList.contains("sapMListTblCell")){const o=t.getElementById(i.getAttribute("data-sap-ui-column"));n.updateInvisibleText(this.getContentAnnouncementOfCell(o));e.setMarked("contentAnnouncementGenerated")}else if(i.classList.contains("sapMListTblSubCnt")){n.updateInvisibleText(this.getContentAnnouncementOfPopin());e.setMarked("contentAnnouncementGenerated")}o.prototype.onfocusin.apply(this,arguments)};a.prototype.onfocusout=function(t){if(t.isMarked()){return}const e=t.target;if(e.matches(".sapMListTblCell")||e.matches(".sapMListTblSubCnt")){this.getTable().removeInvisibleTextAssociation(e)}o.prototype.onfocusout.apply(this,arguments)};a.prototype.onsapenter=a.prototype.onsapspace=function(t){if(t.isMarked()){return}var e=t.target.id;var n="on"+t.type;if(e==this.getId()+"-ModeCell"){t.target=this.getDomRef();n=this.getMode()=="Delete"?"onsapdelete":"onsapspace"}else if(e==this.getId()+"-TypeCell"){t.target=this.getDomRef();if(this.getType()=="Navigation"){n="onsapenter"}else{t.code="KeyE";t.ctrlKey=true;n="onkeydown"}}o.prototype[n].call(this,t)};a.prototype.setType=function(t){o.prototype.setType.call(this,t);this._checkTypeColumn();return this};a.prototype.setParent=function(){o.prototype.setParent.apply(this,arguments);this._checkTypeColumn();return this};a.prototype._checkTypeColumn=function(t){if(!this.getParent()){return}if(t==undefined){t=this._needsTypeColumn()}if(this._bNeedsTypeColumn!=t){this._bNeedsTypeColumn=t;this.informList("TypeColumnChange",t)}};a.prototype._needsTypeColumn=function(){var t=this.getType();return this.getVisible()&&(t==s.Detail||t==s.Navigation||t==s.DetailAndActive)};a.prototype._addClonedHeader=function(t){return this._aClonedHeaders.push(t)};a.prototype._destroyClonedHeaders=function(){if(this._aClonedHeaders.length){this._aClonedHeaders.forEach(function(t){t.destroy("KeepDom")});this._aClonedHeaders=[]}};a.prototype._activeHandlingInheritor=function(){this._toggleActiveClass(true)};a.prototype._inactiveHandlingInheritor=function(){this._toggleActiveClass(false)};a.prototype._toggleActiveClass=function(t){if(this.hasPopin()){this.$Popin().toggleClass("sapMLIBActive",t)}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColumnListItemRenderer", ["sap/ui/core/Renderer","sap/ui/core/library","sap/ui/core/Core","sap/ui/Device","sap/base/Log","./library","./ListItemBaseRenderer"],function(e,t,n,a,l,i,r){"use strict";var s=i.PopinDisplay;var o=t.VerticalAlign;var d=e.extend(r);d.apiVersion=2;d.render=function(e,t){var n=t.getTable();if(!n){return}r.render.apply(this,arguments);if(t.getVisible()&&n.hasPopin()){this.renderPopin(e,t,n)}};d.makeFocusable=function(e){if(a.system.desktop){e.attr("tabindex","-1");e.class("sapMTblCellFocusable")}};d.openStartGridCell=function(e,t,n,a,l){e.openStart(n,a);e.class(l);e.attr("role","gridcell");e.attr("aria-colindex",t.aAriaOwns.push(a));this.makeFocusable(e);if(t.isSelectable()){e.attr("aria-selected",t.getSelected())}return e};d.renderHighlight=function(e,t){e.openStart("td");e.class("sapMListTblHighlightCell");e.attr("role","presentation");e.openEnd();r.renderHighlight.apply(this,arguments);e.close("td")};d.renderNavigated=function(e,t){e.openStart("td");e.class("sapMListTblNavigatedCell");e.attr("role","presentation");e.openEnd();r.renderNavigated.apply(this,arguments);e.close("td")};d.renderType=function(e,t){var n=t.getTable();if(!n||!n.doItemsNeedTypeColumn()){return}this.openStartGridCell(e,t,"td",t.getId()+"-TypeCell","sapMListTblNavCol").openEnd();r.renderType.apply(this,arguments);e.close("td")};d.renderModeContent=function(e,t){this.openStartGridCell(e,t,"td",t.getId()+"-ModeCell","sapMListTblSelCol").openEnd();r.renderModeContent.apply(this,arguments);e.close("td")};d.renderCounter=function(e,t){};d.getAriaRole=function(e){return"row"};d.getAccessbilityPosition=function(e){var t=e.getTable();if(t){var n=t.getVisibleItems().indexOf(e)+t.hasHeaderRow()+1;return{rowindex:n}}};d.renderLIAttributes=function(e,t){e.class("sapMListTblRow");var n=t.getVAlign();if(n!=o.Inherit){e.class("sapMListTblRow"+n)}var a=t.getTable();if(a){if(a.getAlternateRowColors()){e.class("sapMListTblRowAlternate")}}};d.renderLIContentWrapper=function(e,t){var a=t.getTable();if(!a){return}var i=a.getColumns(true),r=t.getCells();t._destroyClonedHeaders();i.forEach(function(i,s){if(!i.getVisible()||i.isHidden()){return}var d=i.getStyleClass().split(" ").filter(Boolean),p=t.getId()+"-cell"+s,u=r[i.getInitialOrder()],c=i.getVAlign(),g=true;this.openStartGridCell(e,t,"td",p,"sapMListTblCell");e.attr("data-sap-ui-column",i.getId());e.style("text-align",i.getCssAlign());d.forEach(function(t){e.class(t)});if(c!=o.Inherit){e.style("vertical-align",c.toLowerCase())}if(u&&!a.hasPopin()&&i.getMergeDuplicates()){var b=i.getMergeFunctionName(),f=b.split("#"),C=f[1],L=f[0];if(typeof u[L]!="function"){l.warning("mergeFunctionName property is defined on "+i+" but this is not function of "+u)}else if(a._bRendering||!u.bOutput){var y=i.getLastValue(),h=u[L](C);if(y===h){g=n.getConfiguration().getAccessibility();u.addStyleClass("sapMListTblCellDupCnt");e.class("sapMListTblCellDup")}else{i.setLastValue(h)}}else if(u.hasStyleClass("sapMListTblCellDupCnt")){e.class("sapMListTblCellDup")}}e.openEnd();if(u&&g){this.applyAriaLabelledBy(i.getHeader(),u,true);e.renderControl(u)}e.close("td")},this)};d.renderDummyCell=function(e,t){e.openStart("td");e.class("sapMListTblDummyCell");e.attr("role","presentation");e.openEnd();e.close("td")};d.applyAriaLabelledBy=function(e,t,n){if(!e||!e.getText||!e.getVisible()||!t.getAriaLabelledBy){return}if(n){t.removeAriaLabelledBy(e)}else if(!t.getAriaLabelledBy().includes(e.getId())){t.addAriaLabelledBy(e)}};d.renderPopin=function(e,t,a){e.openStart("tr",t.getPopin());e.class("sapMListTblSubRow");e.attr("role","none");e.attr("tabindex","-1");e.attr("data-sap-ui-related",t.getId());e.openEnd();this.renderHighlight(e,t);e.openStart("td",t.getId()+"-subcell");e.class("sapMListTblSubRowCell");e.attr("role","none");e.attr("colspan",a.getColCount()-2);e.openEnd();this.openStartGridCell(e,t,"div",t.getId()+"-subcont","sapMListTblSubCnt");e.class("sapMListTblSubCnt"+a.getPopinLayout());e.openEnd();var l=t.getCells(),i=a.getColumns(true);i.forEach(function(i){if(!i.getVisible()||!i.isPopin()){return}var r=l[i.getInitialOrder()];var o=i.getHeader();if(!o&&!r){return}var d=i.getStyleClass().split(" ").filter(Boolean),p=i.getPopinDisplay(),u=o;e.openStart("div");e.class("sapMListTblSubCntRow");if(p==s.Inline){e.class("sapMListTblSubCntRowInline")}d.forEach(function(t){e.class(t)});e.openEnd();if(o&&p!=s.WithoutHeader){e.openStart("div").class("sapMListTblSubCntHdr").openEnd();if(a._aPopinHeaders.indexOf(o)===-1){a._aPopinHeaders.push(u)}o=o.clone();i.addDependent(o);t._addClonedHeader(o);e.renderControl(o);e.openStart("span").class("sapMListTblSubCntSpr");e.attr("data-popin-colon",n.getLibraryResourceBundle("sap.m").getText("TABLE_POPIN_LABEL_COLON"));e.openEnd().close("span");e.close("div")}if(r){e.openStart("div");e.class("sapMListTblSubCntVal");e.class("sapMListTblSubCntVal"+p);e.openEnd();this.applyAriaLabelledBy(u,r);e.renderControl(r);e.close("div")}e.close("div")},this);e.close("div");e.close("td");this.renderNavigated(e,t);e.close("tr")};d.addLegacyOutlineClass=function(e,t){var n=t.getTable();if(n){if(n.hasPopin()||n.shouldRenderDummyColumn()){e.class("sapMTableRowCustomFocus")}}};d.renderContentLatter=function(e,t){var n=t.getTable();if(n&&n.shouldRenderDummyColumn()){if(!n.hasPopin()){r.renderContentLatter.apply(this,arguments);d.renderDummyCell(e,n)}else{d.renderDummyCell(e,n);r.renderContentLatter.apply(this,arguments)}}else{r.renderContentLatter.apply(this,arguments)}};return d},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColumnPopoverActionItem", ["./ColumnPopoverItem","sap/m/Button"],function(t,e){"use strict";var o=t.extend("sap.m.ColumnPopoverActionItem",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},events:{press:{}}}});o.prototype._createButton=function(t,o){return new e(t,{icon:this.getIcon(),type:"Transparent",tooltip:this.getText(),visible:this.getVisible(),press:[function(t){if(o._oShownCustomContent){o._oShownCustomContent.setVisible(false);o._oShownCustomContent=null;o._cleanSelection(this)}var e=o.getAggregation("_popover");e.close();this.firePress()},this]})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColumnPopoverCustomItem", ["./ColumnPopoverItem","sap/m/ToggleButton"],function(t,e){"use strict";var o=t.extend("sap.m.ColumnPopoverCustomItem",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}},events:{beforeShowContent:{}}}});o.prototype._createButton=function(t,o){var n=o.getAggregation("_popover");var s=this.getContent();if(s){s.setVisible(false);this._sContentId=s.sId}n.addContent(s);var i=this;return new e(t,{icon:this.getIcon(),type:"Transparent",tooltip:this.getText(),visible:this.getVisible(),press:function(){if(o._oShownCustomContent){o._oShownCustomContent.setVisible(false)}if(this.getPressed()){o._cleanSelection(this);i.fireBeforeShowContent();if(s){s.setVisible(true);o._oShownCustomContent=s}}else if(s){s.setVisible(false);o._oShownCustomContent=null}}})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColumnPopoverItem", ["sap/ui/core/Element"],function(t){"use strict";var e=t.extend("sap.m.ColumnPopoverItem",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}}}});e.prototype._createButton=function(){throw new Error("Abstract function _create Button must be implemented in your Item (that extends this abstract object).")};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColumnPopoverSelectListItem", ["./ColumnPopoverItem","sap/m/ToggleButton","sap/m/Button","sap/m/StandardListItem","sap/m/List"],function(e,t,n,o,i){"use strict";var s=e.extend("sap.m.ColumnPopoverSelectListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null}},events:{action:{parameters:{property:{type:"string"}}}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:true}}}});s.prototype._createButton=function(e,s){var a=this.getLabel(),r=this.getItems(),l=this;if(r.length>1){var p=s.getAggregation("_popover");var u=new i;for(var g=0;g<r.length;g++){var m=new o({title:r[g].getText(),type:"Active"});u.addItem(m);m.data("key",r[g].getKey())}u.attachEvent("itemPress",function(e){p.close();var t=e.getParameter("listItem");l.fireAction({property:t.data("key")})});u.setVisible(false);p.addContent(u);return new t(e,{icon:this.getIcon(),type:"Transparent",tooltip:a,visible:this.getVisible(),press:function(){if(s._oShownCustomContent){s._oShownCustomContent.setVisible(false)}if(this.getPressed()){s._cleanSelection(this);if(u){u.setVisible(true);s._oShownCustomContent=u}}else if(u){u.setVisible(false);s._oShownCustomContent=null}}})}else{return new n(e,{icon:this.getIcon(),type:"Transparent",tooltip:a,visible:this.getVisible(),press:function(){var e=s.getAggregation("_popover");if(s._oShownCustomContent){s._oShownCustomContent.setVisible(false);s._oShownCustomContent=null;s._cleanSelection(this)}e.close();l.fireAction({property:r[0]?r[0].getKey():null})}})}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ColumnPopoverSortItem", ["sap/ui/core/Core","./ColumnPopoverItem","sap/m/ToggleButton","sap/m/Button","sap/m/StandardListItem","sap/m/List"],function(e,t,o,s,n,i){"use strict";var r=t.extend("sap.m.ColumnPopoverSortItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null}},events:{sort:{parameters:{property:{type:"string"}}}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:true}}}});r.prototype._createButton=function(t,r){var a=e.getLibraryResourceBundle("sap.m"),l=a.getText("COLUMNHEADERPOPOVER_SORT_BUTTON"),p=this.getItems(),u=this;if(p.length>1){var m=r.getAggregation("_popover");var g=new i;for(var c=0;c<p.length;c++){var f=new n({title:p[c].getText(),type:"Active"});g.addItem(f);f.data("key",p[c].getKey())}g.attachEvent("itemPress",function(e){m.close();var t=e.getParameter("listItem");u.fireSort({property:t.data("key")})});g.setVisible(false);m.addContent(g);return new o(t,{icon:"sap-icon://sort",type:"Transparent",tooltip:l,visible:this.getVisible(),press:function(){if(r._oShownCustomContent){r._oShownCustomContent.setVisible(false)}if(this.getPressed()){r._cleanSelection(this);if(g){g.setVisible(true);r._oShownCustomContent=g}}else if(g){g.setVisible(false);r._oShownCustomContent=null}}})}else{return new s(t,{icon:"sap-icon://sort",type:"Transparent",tooltip:l,visible:this.getVisible(),press:function(){var e=r.getAggregation("_popover");if(r._oShownCustomContent){r._oShownCustomContent.setVisible(false);r._oShownCustomContent=null;r._cleanSelection(this)}e.close();u.fireSort({property:p[0]?p[0].getKey():null})}})}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ComboBox", ["./ComboBoxTextField","./ComboBoxBase","./List","./library","sap/ui/Device","sap/ui/core/Item","./ComboBoxRenderer","sap/ui/dom/containsOrEquals","sap/m/inputUtils/scrollToItem","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/typeAhead","sap/m/inputUtils/filterItems","sap/m/inputUtils/ListHelpers","sap/m/inputUtils/itemsVisibilityHandler","sap/m/inputUtils/selectionRange","sap/m/inputUtils/calculateSelectionStart","sap/ui/events/KeyCodes","sap/ui/core/Core","sap/base/Log"],function(e,t,s,i,o,n,r,a,l,h,p,c,u,d,g,f,m,y,I){"use strict";var S=i.ListMode;var v=t.extend("sap.m.ComboBox",{metadata:{interfaces:["sap.m.IToolbarInteractiveControl"],library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},_open:{type:"boolean",defaultValue:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}},dnd:{draggable:false,droppable:true}},renderer:r});function P(e){var t=this.getSelectedItem(),s=u.getListItem(t),i=t&&s&&s.getDomRef(),o=i&&i.offsetTop,n=i&&i.offsetHeight,r=this.getPicker(),a=r.getDomRef("cont"),l=a.clientHeight;if(t&&o+n>l){if(!e){this._getList().$().css("visibility","hidden")}else{a.scrollTop=o-n/2;this._getList().$().css("visibility","visible")}}}v.prototype._getSelectedItemText=function(e){e=e||this.getSelectedItem();if(!e){e=this.getDefaultSelectedItem()}if(e){return e.getText()}return""};v.prototype.setSelectedIndex=function(e,t){var s;t=t||this.getItems();e=e>t.length-1?t.length-1:Math.max(0,e);s=t[e];if(s){this.setSelection(s)}};v.prototype.revertSelection=function(){var e,t=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){e=this._sValueBeforeOpen}else{e=this._oSelectedItemBeforeOpen.getText()}t&&t.setValue(e)};v.prototype._filterStartsWithItems=function(e,t){var s=e.toLowerCase();var i=this.getItems(),o=i.filter(function(e){return e[t]&&e[t]().toLowerCase().startsWith(s)});return o};v.prototype.setSelection=function(e){var t=this._getList(),s,i;this.setAssociation("selectedItem",e);this._setPropertyProtected("selectedItemId",e instanceof n?e.getId():e,true);if(typeof e==="string"){e=y.byId(e)}if(t){s=u.getListItem(e);if(s){t.setSelectedItem(s,true)}else{t.removeSelections(true)}}i=e?e.getKey():this.getMetadata().getProperty("selectedKey").defaultValue;this._setPropertyProtected("selectedKey",i)};v.prototype.isSelectionSynchronized=function(){var e=this.getSelectedItem();return this.getSelectedKey()===(e&&e.getKey())};v.prototype.isItemSelected=function(e){return e&&e.getId()===this.getAssociation("selectedItem")};v.prototype.setAssociation=function(e,s,i){var o=this._getList();if(o&&e==="selectedItem"){if(!(s instanceof n)){s=this.findItem("id",s)}o.setSelectedItem(u.getListItem(s),true)}return t.prototype.setAssociation.apply(this,arguments)};v.prototype.removeAllAssociation=function(e,i){var o=this._getList();if(o&&e==="selectedItem"){s.prototype.removeAllAssociation.apply(o,arguments)}return t.prototype.removeAllAssociation.apply(this,arguments)};v.prototype.init=function(){t.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;if(o.system.phone){this.attachEvent("_change",this.onPropertyChange,this)}this.setLastFocusedListItem(null)};v.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);var e=this.getItems();if(this.getRecreateItems()){u.fillList(e,this._getList(),this._mapItemToListItem.bind(this));this.setRecreateItems(false)}this.synchronizeSelection();if(!this.isOpen()&&document.activeElement===this.getFocusDomRef()&&this.getEnabled()){this.addStyleClass("sapMFocus")}if(this.getSelectedItem()&&e.indexOf(this.getSelectedItem())===-1){var s=this.getValue();this.clearSelection();this.setValue(s)}if(this.getShowClearIcon()){this._getClearIcon().setVisible(this.shouldShowClearIcon())}else if(this._oClearIcon){this._getClearIcon().setVisible(false)}};v.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oSelectedItemBeforeOpen=null;this._bInputFired=null;this.setLastFocusedListItem(null)};v.prototype.onBeforeRenderingPicker=function(){var e=this["onBeforeRendering"+this.getPickerType()];e&&e.call(this)};v.prototype.onBeforeRenderingDropdown=function(){var e=this.getPicker(),t=this.$().outerWidth()/parseFloat(i.BaseFontSize)+"rem";if(e){e.setContentMinWidth(t)}};v.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var e=this._getList(),t=this.getFocusDomRef();if(e){e.setBusy(true)}if(t){t.setAttribute("aria-busy","true")}}};v.prototype.onAfterRenderingPicker=function(){var e=this["onAfterRendering"+this.getPickerType()];var t=this.getDomRef().getBoundingClientRect().width;var s=getComputedStyle(this.getDomRef()).getPropertyValue("--sPopoverMaxWidth");e&&e.call(this);P.call(this,false);if(t<=parseInt(s)&&!o.system.phone){this.getPicker().addStyleClass("sapMSuggestionPopoverDefaultWidth")}else{this.getPicker().getDomRef().style.setProperty("max-width",t+"px");this.getPicker().addStyleClass("sapMSuggestionPopoverInputWidth")}};v.prototype.onAfterRenderingList=function(){var e=this.getSelectedItem(),t=u.getListItem(e);if(this.bProcessingLoadItemsEvent&&!this.bItemsUpdated&&this.getItems().length===0){return}var s=this._getList(),i=this.getFocusDomRef();this.highlightList(this._sInputValueBeforeOpen);if(e){s.setSelectedItem(t);this.setLastFocusedListItem(t)}if(s){s.setBusy(false)}if(i){i.removeAttribute("aria-busy")}};v.prototype.filterItems=function(e){return c(this,this.getItems(),e,true,this.getFilterSecondaryValues(),this.fnFilter||h)};v.prototype._mapItemToListItem=function(e){var t=u.createListItemFromCoreItem(e,this.getShowSecondaryValues());if(e.isA("sap.ui.core.Item")){this.setSelectable(e,e.getEnabled())}if(e.isA("sap.ui.core.SeparatorItem")){t.addAriaLabelledBy(this._getGroupHeaderInvisibleText().getId())}t.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"NonInteractiveItem");return t};v.prototype.oninput=function(e){t.prototype.oninput.apply(this,arguments);this.syncPickerContent();if(e.isMarked("invalid")){return}this._bInputFired=true;this.loadItems(function(){this.handleInputValidation(e)},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&this.getPickerType()==="Dropdown"){if(this.isOpen()&&!this.getValue()){this.close()}else{this.open()}}if(this.getLastFocusedListItem()){this.getLastFocusedListItem().removeStyleClass("sapMLIBFocused");this.setLastFocusedListItem(null)}this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true)}};v.prototype.handleInputValidation=function(e){var t,s,i,o,n=this.getSelectedItem(),r=e.target.value,a=r==="",h=e.srcControl,p=this.getPickerType()==="Dropdown",c=u.getListItem(n),g=this.filterItems(r);if(a&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){t=this.getItems()}else{t=g.items;d(this.getItems(),g)}i=t[0];o=t.some(function(e){return e.getKey()===this.getSelectedKey()},this);s=this.intersectItems(this._filterStartsWithItems(r,"getText"),t);if(i&&this.getSelectedKey()&&!o){this.setSelection(null)}if(!a&&h&&h._bDoTypeAhead){this.handleTypeAhead(h,t,r)}else if(!a&&s[0]&&r===s[0].getText()){this.setSelection(s[0])}else{this.setSelection(null)}if(n!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});c=u.getListItem(this.getSelectedItem())}this._sInputValueBeforeOpen=r;if(this.isOpen()){setTimeout(function(){this.highlightList(r)}.bind(this))}if(i){if(a&&!this.bOpenedByKeyboardOrButton){this.close()}else if(p){this.open();l(c,this.getPicker())}}else if(this.isOpen()){if(p&&!this.bOpenedByKeyboardOrButton){this.close()}}else{this.clearFilter()}};v.prototype.handleTypeAhead=function(e,t,s){var i,o=this.getFilterSecondaryValues(),n=p(s,e,t,function(e){i=[e.getText()];if(o){i.push(e.getAdditionalText())}return i});this.setSelection(n[0]);this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus")};v.prototype.onSelectionChange=function(e){var t=u.getItemByListItem(this.getItems(),e.getParameter("listItem")),s=this.getChangeEventParams(),i=t!==this.getSelectedItem();t&&this.updateDomValue(t.getText());this.setSelection(t);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(i){s.itemPressed=true;this.onChange(null,s)}};v.prototype.onItemPress=function(e){var t=e.getParameter("listItem"),s=t.getTitle(),i=this.getChangeEventParams(),o=t!==u.getListItem(this.getSelectedItem());if(t.isA("sap.m.GroupHeaderListItem")){return}this.setLastFocusedListItem(t);this.updateDomValue(s);if(!o){i.itemPressed=true;this.onChange(null,i)}this._setPropertyProtected("value",s,true);if(this.getPickerType()==="Dropdown"&&!this.isPlatformTablet()){this.selectText(this.getValue().length,this.getValue().length)}this.close()};v.prototype.onBeforeOpen=function(){t.prototype.onBeforeOpen.apply(this,arguments);var e=this._getSuggestionsPopover();var s=this["onBeforeOpen"+this.getPickerType()];this.setProperty("_open",true);if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems()}this.addContent();s&&s.call(this);e.resizePopup(this)};v.prototype.onBeforeOpenDialog=function(){var e=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();this.getSelectedItem()&&d(this.getItems(),this.filterItems(""));e.setValue(this._sValueBeforeOpen)};v.prototype.onAfterOpen=function(){var e=this.getSelectedItem(),t=g(this.getFocusDomRef()),s=this.isPlatformTablet();this.closeValueStateMessage();P.call(this,true);if(!s&&e&&t.start===t.end&&t.start>1){setTimeout(function(){this.selectText(0,t.end)}.bind(this),0)}};v.prototype.onBeforeClose=function(){t.prototype.onBeforeClose.apply(this,arguments);var e=this.getFocusDomRef();this.setProperty("_open",false);if(document.activeElement===e){this.updateFocusOnClose()}this.toggleIconPressedStyle(false)};v.prototype.onAfterClose=function(){this.clearFilter();this._sInputValueBeforeOpen="";if(this.isPickerDialog()){t.prototype.closeValueStateMessage.apply(this,arguments)}};v.prototype.onItemChange=function(e){var s=this.getAssociation("selectedItem"),i=e.getParameter("newValue"),o=e.getParameter("name");if(s===e.getParameter("id")){switch(o){case"text":if(!this.isBound("value")){this.setValue(i)}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(i)}break}}return t.prototype.onItemChange.call(this,e,this.getShowSecondaryValues())};v.prototype.onkeydown=function(e){var s=e.srcControl;t.prototype.onkeydown.apply(s,arguments);if(!s.getEnabled()||!s.getEditable()){return}var i=m;s._bDoTypeAhead=!o.os.android&&e.which!==i.BACKSPACE&&e.which!==i.DELETE};v.prototype.oncut=function(e){var s=e.srcControl;t.prototype.oncut.apply(s,arguments);s._bDoTypeAhead=false};v.prototype.onsapenter=function(e){var s=e.srcControl,i=s.getSelectedItem();if(i&&this.getFilterSecondaryValues()){s.updateDomValue(i.getText())}t.prototype.onsapenter.apply(s,arguments);if(!s.getEnabled()||!s.getEditable()){return}if(s.isOpen()&&!this.isComposingCharacter()){s.close()}};["onsapup","onsapdown","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(e){v.prototype[e]=function(t){this.handleListNavigation(t,e)}});v.prototype.handleListNavigation=function(e,t){var s=e.srcControl;if(!s.getEnabled()||!s.getEditable()){return}e.preventDefault();this.loadItems(function(){this.syncPickerContent();if(!this.isOpen()){this.handleInlineListNavigation(t)}else{var s=this._getSuggestionsPopover();s&&s.handleListNavigation(this,e,t)}e.setMarked()})};v.prototype.handleInlineListNavigation=function(e){var t=this.getItems(),s=u.getSelectableItems(t),i=this.getSelectedItem(),o;switch(e){case"onsapdown":o=s.indexOf(i)+1;break;case"onsapup":o=i?s.indexOf(i)-1:s.length-1;break;case"onsapend":o=s.length-1;break;case"onsaphome":o=0;break;case"onsappagedown":o=Math.min(s.length-1,s.indexOf(i)+10);break;case"onsappageup":o=Math.max(0,s.indexOf(i)-10);break}this.handleSelectionFromList(s[o])};v.prototype.handleSelectionFromList=function(e){if(!e){return}var t=this.getFocusDomRef(),s=t.value.substring(0,t.selectionStart),i=this.getSelectedItem(),o=this.getLastFocusedListItem(),n,r,a,l;if(e.isA("sap.m.StandardListItem")||e.isA("sap.m.GroupHeaderListItem")){n=e;e=u.getItemByListItem(this.getItems(),e)}else{n=u.getListItem(e)}this.setSelection(e);this.setLastFocusedListItem(n);if(e.isA("sap.ui.core.SeparatorItem")){this.setSelectedItem(null);this.updateDomValue(s);this.fireSelectionChange({selectedItem:null});this._getGroupHeaderInvisibleText().setText(this._oRb.getText("LIST_ITEM_GROUP_HEADER")+" "+e.getText());return}if(e!==i){r=e.getText();l=o&&o.isA("sap.m.GroupHeaderListItem");a=f(g(t,l),r,s,l);this.updateDomValue(r);this.fireSelectionChange({selectedItem:e});e=this.getSelectedItem();this.selectText(a,t.value.length)}};v.prototype.setLastFocusedListItem=function(e){this._oLastFocusedListItem=e};v.prototype.getLastFocusedListItem=function(){return this._oLastFocusedListItem};v.prototype.onsapshow=function(e){var s,i,o=this.getEditable(),n;t.prototype.onsapshow.apply(this,arguments);this.syncPickerContent();if(!this.getValue()&&o){s=u.getSelectableItems(this.getItems());i=s[0];if(i){n=u.getListItem(i);if(this.isOpen()){this._getSuggestionsPopover().updateFocus(this,n);this.setLastFocusedListItem(n)}else{this.addStyleClass("sapMFocus")}this.setSelection(i);this.updateDomValue(i.getText());this.fireSelectionChange({selectedItem:i});setTimeout(function(){this.selectText(0,i.getText().length)}.bind(this),0)}}};v.prototype.onsaphide=v.prototype.onsapshow;v.prototype.ontap=function(e){if(!this.getEnabled()){return}this.updateFocusOnClose()};v.prototype.updateFocusOnClose=function(){var e=this.getFocusDomRef(),t=this._getSuggestionsPopover();this.setLastFocusedListItem(null);if(t){t.setValueStateActiveState(false);t.updateFocus(this)}e.removeAttribute("aria-activedescendant")};v.prototype.onmouseup=function(){if(this.getPickerType()==="Dropdown"&&document.activeElement===this.getFocusDomRef()&&!this.getSelectedText()){this.selectText(0,this.getValue().length)}};v.prototype.onfocusin=function(e){var t=this.getPickerType()==="Dropdown";if(this._bIsBeingDestroyed){return}if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(t&&!this.isPlatformTablet()){this.focus()}}else{if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage()}this.bOpenValueStateMessage=true}if(this.getEnabled()&&(!this.isOpen()||!this.getSelectedItem()||!this._getList().hasStyleClass("sapMListFocus"))){this.addStyleClass("sapMFocus")}};v.prototype.onsapfocusleave=function(e){var s,i,o,n,r=this.getSelectedItem();if(r&&this.getFilterSecondaryValues()){this.updateDomValue(r.getText())}t.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return}i=this.getPicker();if(!e.relatedControlId||!i){return}s=this.isPlatformTablet();o=y.byId(e.relatedControlId);n=o&&o.getFocusDomRef();if(a(i.getFocusDomRef(),n)&&!s&&!this._getSuggestionsPopover().getValueStateActiveState()){this.focus()}};v.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return}var e=this.getSelectedKey(),t=this.getItemByKey(""+e);if(t&&e!==""){this.setAssociation("selectedItem",t,true);this._setPropertyProtected("selectedItemId",t.getId(),true);this.setValue(t.getText());this._sValue=this.getValue()}};v.prototype.configPicker=function(e){var t=this.getRenderer(),s=t.CSS_CLASS_COMBOBOXBASE;e.setHorizontalScrolling(false).addStyleClass(s+"Picker").addStyleClass(s+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this)};v.prototype._configureList=function(e){var t=this.getRenderer();if(!e){return}e.applyAriaRole("listbox");e.setMode(S.SingleSelectMaster).addStyleClass(t.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(t.CSS_CLASS_COMBOBOX+"List");e.attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);e.addEventDelegate({onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this)};v.prototype.getDefaultSelectedItem=function(){return null};v.prototype.getChangeEventParams=function(){return{itemPressed:false}};v.prototype.clearSelection=function(){this.setAssociation("selectedItem",null);this.setSelectedItemId("");this.setSelectedKey("")};v.prototype.selectText=function(e,s){t.prototype.selectText.apply(this,arguments);return this};v.prototype.clone=function(e){var s=t.prototype.clone.apply(this,arguments),i=this._getList();s.setAssociation("selectedItem",null);if(!this.isBound("items")&&i){s.syncPickerContent();s.setSelectedIndex(this.indexOfItem(this.getSelectedItem()))}return s};v.prototype.open=function(){this.syncPickerContent();t.prototype.open.call(this);var e=u.getListItem(this.getSelectedItem());if(!this._bInputFired){this._getSuggestionsPopover()&&this._getSuggestionsPopover().updateFocus(this,e)}this._bInputFired=false;return this};v.prototype.syncPickerContent=function(){var e,t=this.getPicker(),s=this.getInputForwardableProperties();if(!t){var i,o;t=this.createPicker(this.getPickerType());e=this.getPickerTextField();u.fillList(this.getItems(),this._getList(),this._mapItemToListItem.bind(this));d(this.getItems(),this.filterItems(""));if(e){s.forEach(function(t){t=t.charAt(0).toUpperCase()+t.slice(1);i="set"+t;o="get"+t;if(e[i]){e[i](this[o]())}},this)}this._getSuggestionsPopover().updateValueState(this.getValueState(),this.getValueStateText(),this.getShowValueStateMessage())}this.synchronizeSelection();return t};v.prototype.findAggregatedObjects=function(){var e=this._getList();if(e){return s.prototype.findAggregatedObjects.apply(e,arguments)}return[]};v.prototype.setSelectedItem=function(e){if(typeof e==="string"){this.setAssociation("selectedItem",e,true);e=y.byId(e)}if(!(e instanceof n)&&e!==null){return this}if(!e){e=this.getDefaultSelectedItem()}this.setSelection(e);this.setValue(this._getSelectedItemText(e));return this};v.prototype.setSelectedItemId=function(e){e=this.validateProperty("selectedItemId",e);if(!e){e=this.getDefaultSelectedItem()}this.setSelection(e);e=this.getSelectedItem();this.setValue(this._getSelectedItemText(e));return this};v.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);var t=this.shouldResetSelection(e),s=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(t){this.setSelection(null);if(!s){this.setValue("")}return this}var i=this.getItemByKey(e);if(i){this.setSelection(i);if(!s){this.setValue(this._getSelectedItemText(i))}return this}this._sValue=this.getValue();return this._setPropertyProtected("selectedKey",e)};v.prototype.shouldResetSelection=function(e){return e===this.getMetadata().getProperty("selectedKey").defaultValue};v.prototype._setPropertyProtected=function(e,t,s){try{return this.setProperty(e,t,s)}catch(e){I.warning("setSelectedKey update failed due to exception. Loggable in support mode log",null,null,function(){return{exception:e}})}};v.prototype.getSelectedItem=function(){var e=this.getAssociation("selectedItem");return e===null?null:y.byId(e)||null};v.prototype._decoratePopupInput=function(e){t.prototype._decoratePopupInput.apply(this,arguments);if(!e||!e.isA(["sap.m.InputBase"])){return}e.addEventDelegate({onsapenter:function(){var t=e.getValue();this.updateDomValue(t);this.onChange();if(t){this.updateDomValue(t);this.onChange();this.close()}}},this);e.attachChange(this._handleInnerInputChange.bind(this));return e};v.prototype._handleInnerInputChange=function(e){if(e.getParameter("value")===""){this.clearSelection();this.clearFilter()}};v.prototype.applyShowItemsFilters=function(){var e,t;this.syncPickerContent();e=this.getPicker();t=function(){e.detachBeforeOpen(t,this);e=null;d(this.getItems(),this.filterItems(this.getValue()||"_"))};e.attachBeforeOpen(t,this)};v.prototype.showItems=function(e){var s,i,o=Array.prototype.slice.call(arguments),n=this.fnFilter,r=function(){this.setFilterFunction(e||function(){return true});i=this.filterItems(this.getValue()||"_");d(this.getItems(),i);this.setFilterFunction(n);s=i.items;if(s&&s.length){t.prototype.showItems.apply(this,o)}}.bind(this);this.attachLoadItems(r);this.loadItems(r)};v.prototype._getFormattedValueStateText=function(){if(this.isOpen()){return this._getSuggestionsPopover()._getValueStateHeader().getFormattedText()}else{return e.prototype.getFormattedValueStateText.call(this)}};v.prototype.handleClearIconPress=function(e){var t=this.getSelectedItem(),s=this.getChangeEventParams();if(!(this.getEnabled()&&this.getEditable())){return}if(this.getValue()!==""){this.clearSelection();this.bOpenedByKeyboardOrButton?this.clearFilter():this.close();this.setProperty("effectiveShowClearIcon",false)}if(t){this.fireSelectionChange({selectedItem:null});this.fireChangeEvent(null,s)}};v.prototype._getToolbarInteractive=function(){return true};return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ComboBoxBase", ["./Input","./ComboBoxTextField","./ComboBoxBaseRenderer","./SuggestionsPopover","sap/ui/base/ManagedObjectObserver","sap/ui/core/SeparatorItem","sap/ui/core/InvisibleText","sap/ui/base/ManagedObject","sap/base/Log","./library","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/m/inputUtils/forwardItemProperties","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/highlightItemsWithContains","sap/m/inputUtils/ListHelpers","sap/ui/core/IconPool","sap/ui/core/Core"],function(t,e,i,s,o,n,r,a,u,p,l,h,c,jQuery,d,g,f,I,y,m){"use strict";var b=p.PlacementType;var v=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];var S=e.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m",abstract:true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},open:{type:"boolean",defaultValue:false},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}},renderer:i});S.prototype.oncompositionend=function(t){e.prototype.oncompositionend.apply(this,arguments);if(!l.browser.firefox){this.handleInputValidation(t,this.isComposingCharacter())}};S.prototype.shouldShowClearIcon=function(){return this.getProperty("effectiveShowClearIcon")&&!!this.getValue()&&this.getEditable()&&this.getEnabled()};S.prototype.updateItems=function(t){this.bItemsUpdated=false;var e=this.getItems().length;var i;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){if(this.isOpen()){I.fillList(this.getItems(),this._getList(),this._mapItemToListItem.bind(this));this.setRecreateItems(false)}this.onItemsLoaded()}i=this._getList();if(i&&e===this.getItems().length){i.setBusy(false);i.setShowNoData(!this.getItems().length);this.bInitialBusyIndicatorState=false}};S.prototype.setFilterFunction=function(t){if(t===null||t===undefined){this.fnFilter=null;return this}if(typeof t!=="function"){u.warning("Passed filter is not a function and the default implementation will be used")}else{this.fnFilter=t}return this};S.prototype.highlightList=function(t){var e=[];e=this._getList().$().find(".sapMSLIInfo [id$=-infoText], .sapMSLITitleOnly [id$=-titleText]");if(this.useHighlightItemsWithContains()){f(e,t)}else{g(e,t)}};S.prototype.useHighlightItemsWithContains=function(){return false};S.prototype._decoratePopupInput=function(t){if(t){this.setTextFieldHandler(t);t.setShowClearIcon(this.getShowClearIcon())}return t};S.prototype.setTextFieldHandler=function(t){var e=this,i=t._handleEvent;t._handleEvent=function(t){i.apply(this,arguments);if(/keydown|keyup|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(t.type)){e._handleEvent(t)}}};S.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items")};S.prototype.loadItems=function(t,e){var i=typeof t==="function";if(this.hasLoadItemsEventListeners()&&this.getItems().length===0){this._bOnItemsLoadedScheduled=false;if(i){e=jQuery.extend({action:t,busyIndicator:true,busyIndicatorDelay:300},e);this.aMessageQueue.push(e);if(this.iLoadItemsEventInitialProcessingTimeoutID===-1&&e.busyIndicator){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function t(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true)}.bind(this),e.busyIndicatorDelay)}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems()}}else if(i){t.call(this)}};S.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState)}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay)}for(var t=0,e,i,s;t<this.aMessageQueue.length;t++){e=this.aMessageQueue.shift();t--;s=t+1===this.aMessageQueue.length;i=s?null:this.aMessageQueue[t+1];if(typeof e.action==="function"){if(e.name==="input"&&!s&&i.name==="input"){continue}e.action.call(this)}}};S.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems")};S.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0)}};S.prototype.getPickerInvisibleTextId=function(){return r.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS")};S.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new r;this._oGroupHeaderInvisibleText.toStatic()}return this._oGroupHeaderInvisibleText};S.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(t){return!t.getVisible()&&I.getItemByListItem(this.getItems(),t).getEnabled()},this)};S.prototype.getSelectable=function(t){return t._bSelectable};S.prototype._setItemsShownWithFilter=function(t){this._bItemsShownWithFilter=t};S.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter};S.prototype._getClearIcon=function(){if(this._oClearIcon){return this._oClearIcon}this._oClearIcon=this.addEndIcon({src:y.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:this.handleClearIconPress.bind(this)},0);this._oClearIcon.addStyleClass("sapMComboBoxBaseClearIcon");return this._oClearIcon};S.prototype.handleClearIconPress=function(t){};S.prototype.onkeyup=function(t){if(!this.getEnabled()||!this.getEditable()){return}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!this.getValue())};S.prototype.setValue=function(t){e.prototype.setValue.apply(this,arguments);this.setProperty("effectiveShowClearIcon",!!t);return this};S.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oRb=m.getLibraryResourceBundle("sap.m");this.setPickerType(l.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getArrowIcon().addEventDelegate({onmousedown:function(t){this._bShouldClosePicker=this.isOpen()}},this);this.getArrowIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true,this));this.fnFilter=null;var t=new o(function(t){var e=t.mutation;var i=t.child;var s={remove:"detachEvent",insert:"attachEvent"};var o={remove:"handleItemRemoval",insert:"handleItemInsertion"};if(!i[s[e]]||!this[o[e]]){return}i[s[e]]("_change",this.onItemChange,this);this.setRecreateItems(true);this[o[e]](i)}.bind(this));t.observe(this,{aggregations:["items"]})};S.prototype.handleItemRemoval=function(t){};S.prototype.handleItemInsertion=function(t){};S.prototype.setRecreateItems=function(t){this._bRecreateItems=t};S.prototype.getRecreateItems=function(){return this._bRecreateItems};S.prototype.onBeforeRendering=function(){var t=this.isOpen(),i=t?this._getSuggestionsPopover()._getValueStateHeader().getText():null,s=t?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;e.prototype.onBeforeRendering.apply(this,arguments);if(t&&(this.getValueStateText()&&i!==this.getValueStateText()||this.getValueState()!==s||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState()}};S.prototype._handlePopupOpenAndItemsLoad=function(t,e){var i;if(!this.getEnabled()||!this.getEditable()){return}if(t&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return}this.loadItems();this.bOpenedByKeyboardOrButton=t;if(this.isPlatformTablet()){this.syncPickerContent();i=this.getPicker();i.setInitialFocus(i)}if(e){i=this.getPicker();i&&i.setInitialFocus(e)}this.open()};S.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oRb=null;if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null}if(this._oSuggestionPopover){this._oSuggestionPopover.destroy();this._oSuggestionPopover=null}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null};S.prototype.onsapshow=function(t){if(!this.getEnabled()||!this.getEditable()){return}t.setMarked();if(t.keyCode===c.F4){this.onF4(t)}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return}if(this.isOpen()){this.close();return}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open()};S.prototype.onF4=function(t){t.preventDefault()};S.prototype.onsapescape=function(t){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){t.setMarked();t.preventDefault();this.close()}else{e.prototype.onsapescape.apply(this,arguments)}};S.prototype.onsaphide=S.prototype.onsapshow;S.prototype.onsapfocusleave=function(t){if(!t.relatedControlId){e.prototype.onsapfocusleave.apply(this,arguments);return}var i=sap.ui.getCore().byId(t.relatedControlId);if(i===this){return}var s=this.getPicker(),o=i&&i.getFocusDomRef();if(s&&h(s.getFocusDomRef(),o)){return}e.prototype.onsapfocusleave.apply(this,arguments)};S.prototype.getPopupAnchorDomRef=function(){return this.getDomRef()};S.prototype.addContent=function(t){};S.prototype.getList=function(){u.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList()};S.prototype._getList=function(){var t=this._oSuggestionPopover&&this._oSuggestionPopover.getItemsContainer();if(this.bIsDestroyed||!t){return null}return t};S.prototype.setPickerType=function(t){this._sPickerType=t};S.prototype.getPickerType=function(){return this._sPickerType};S.prototype._updateSuggestionsPopoverValueState=function(){var t=this._getSuggestionsPopover();if(!t){return}var e=this.getValueState(),i=this.getValueState()!==t._getValueStateHeader().getValueState(),s=this.getFormattedValueStateText(),o=this.getValueStateText(),n=s||i;if(t.isOpen()&&!n){this.setFormattedValueStateText(t._getValueStateHeader().getFormattedText())}t.updateValueState(e,s||o,this.getShowValueStateMessage())};S.prototype.shouldValueStateMessageBeOpened=function(){var t=e.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return t&&!this.isOpen()};S.prototype.onPropertyChange=function(t,e){var i=t.getParameter("newValue"),s=t.getParameter("name"),o="set"+s.charAt(0).toUpperCase()+s.slice(1),n=e&&e.srcControl||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(s)>-1&&n&&typeof n[o]==="function"){n[o](i)}};S.prototype.getInputForwardableProperties=function(){return v};S.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog"};S.prototype.isPlatformTablet=function(){var t=!l.system.combi,e=l.system.tablet&&t;return e};S.prototype.getDropdownSettings=function(){return{showArrow:false,placement:b.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined}};S.prototype._configureList=function(){};S.prototype.createPicker=function(t){var e=this.getAggregation("picker");if(e){return e}this._oSuggestionPopover=this._createSuggestionsPopover();e=this._oSuggestionPopover.getPopover();this.setAggregation("picker",e,true);this.configPicker(e);return e};S.prototype.configPicker=function(t){};S.prototype._hasShowSelectedButton=function(){return false};S.prototype._createSuggestionsPopover=function(){var e=new s(this);e.decorateParent(this);e.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()},t);this._decoratePopupInput(e.getInput());e.initContent(this.getId());this.forwardEventHandlersToSuggPopover(e);this._configureList(e.getItemsContainer());return e};S.prototype.forwardEventHandlersToSuggPopover=function(t){t.setOkPressHandler(this._handleOkPress.bind(this));t.setCancelPressHandler(this._handleCancelPress.bind(this));t.setInputLabels(this.getLabels.bind(this))};S.prototype._handleOkPress=function(){var t=this,e=t.getPickerTextField();t.updateDomValue(e.getValue());t.onChange();t.close()};S.prototype._handleCancelPress=function(){this.close();this.revertSelection()};S.prototype.setSelectable=function(t,e){if(this.indexOfItem(t)<0){return}t._bSelectable=e;var i=I.getListItem(t);if(i){i.setVisible(e)}};S.prototype.onBeforeOpen=function(){this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true)}};S.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState()};S.prototype.getPicker=function(){var t=this.getAggregation("picker");if(t&&!t.bIsDestroyed&&!this.bIsDestroyed){return t}return null};S.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover};S.prototype.getValueStateLinks=function(){var t=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",e=t&&this.getPicker().getCustomHeader().getFormattedText(),i=e&&e.getControls();return i||[]};S.prototype.getPickerTextField=function(){var t=this._getSuggestionsPopover();return t?t.getInput():null};S.prototype.getPickerTitle=function(){var t=this.getPicker(),e=t&&t.getCustomHeader();if(this.isPickerDialog()&&e){return e.getContentMiddle()[0]}return null};S.prototype.revertSelection=function(){};S.prototype.hasContent=function(){return this.getItems().length>0};S.prototype.syncPickerContent=function(){};S.prototype.open=function(){var t=this.getPicker();if(t){t.open()}return this};S.prototype.getVisibleItems=function(){return I.getVisibleItems(this.getItems())};S.prototype.isItemSelected=function(){};S.prototype.getKeys=function(t){t=t||this.getItems();for(var e=0,i=[];e<t.length;e++){i[e]=t[e].getKey()}return i};S.prototype.findItem=function(t,e){var i="get"+t.charAt(0).toUpperCase()+t.slice(1);for(var s=0,o=this.getItems();s<o.length;s++){if(o[s][i]()===e){return o[s]}}return null};S.prototype.getItemByText=function(t){return this.findItem("text",t)};S.prototype.clearFilter=function(){this.getItems().forEach(function(t){var e=I.getListItem(t);if(e){e.setVisible(t.getEnabled()&&this.getSelectable(t))}},this)};S.prototype.onItemChange=function(t,e){d({item:t.getSource(),propName:t.getParameter("name"),propValue:t.getParameter("newValue")},e)};S.prototype.clearSelection=function(){};S.prototype.setInternalBusyIndicator=function(t){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments)};S.prototype.setInternalBusyIndicatorDelay=function(t){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments)};S.prototype.getItemAt=function(t){return this.getItems()[+t]||null};S.prototype.getFirstItem=function(){return this.getItems()[0]||null};S.prototype.getLastItem=function(){var t=this.getItems();return t[t.length-1]||null};S.prototype.getEnabledItems=function(t){return I.getEnabledItems(t||this.getItems())};S.prototype.getItemByKey=function(t){return this.findItem("key",t)};S.prototype.addItemGroup=function(t,e,i){e=e||new n({text:a.escapeSettingsValue(t.text)||a.escapeSettingsValue(t.key)});this.addAggregation("items",e,i);if(this._getList()&&e.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(e))}return e};S.prototype.isOpen=function(){var t=this.getPicker();return!!(t&&t.isOpen())};S.prototype.close=function(){var t=this.getPicker();if(t){t.close()}return this};S.prototype.intersectItems=function(t,e){return t.filter(function(t){return e.map(function(t){return t.getId()}).indexOf(t.getId())!==-1})};S.prototype.showItems=function(t){var e=this.fnFilter,i=function(){if(!this.getItems().length){return}this.detachLoadItems(i);this.setFilterFunction(t||function(){return true});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false,this);this.setFilterFunction(e)}.bind(this);if(!this.getEnabled()||!this.getEditable()){return}this._setItemsShownWithFilter(true);this.attachLoadItems(i);this.loadItems(i)};S.prototype.applyShowItemsFilters=function(){};return S});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ComboBoxBaseRenderer", ["./ComboBoxTextFieldRenderer","sap/ui/core/Renderer"],function(e,s){"use strict";var t=s.extend(e);t.apiVersion=2;t.CSS_CLASS_COMBOBOXBASE="sapMComboBoxBase";t.getAccessibilityState=function(s){var t=e.getAccessibilityState.call(this,s),a=s.getPicker();if(a){t.controls=a.getId()}return t};t.addOuterClasses=function(s,a){e.addOuterClasses.apply(this,arguments);var i=t.CSS_CLASS_COMBOBOXBASE;s.class(i);if(!a.getEnabled()){s.class(i+"Disabled")}if(!a.getEditable()){s.class(i+"Readonly")}};t.addButtonClasses=function(s,a){e.addButtonClasses.apply(this,arguments);s.class(t.CSS_CLASS_COMBOBOXBASE+"Arrow")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ComboBoxRenderer", ["./ComboBoxBaseRenderer","sap/ui/core/Renderer","sap/m/inputUtils/ListHelpers"],function(e,t,a){"use strict";var s=t.extend(e);s.apiVersion=2;s.CSS_CLASS_COMBOBOX="sapMComboBox";s.addOuterClasses=function(t,a){e.addOuterClasses.apply(this,arguments);t.class(s.CSS_CLASS_COMBOBOX)};s.addInnerClasses=function(t,a){e.addInnerClasses.apply(this,arguments);t.class(s.CSS_CLASS_COMBOBOX+"Inner")};s.addButtonClasses=function(t,a){e.addButtonClasses.apply(this,arguments);t.class(s.CSS_CLASS_COMBOBOX+"Arrow")};s.addPlaceholderClasses=function(t,a){e.addPlaceholderClasses.apply(this,arguments);t.class(s.CSS_CLASS_COMBOBOX+"Placeholder")};s.writeInnerAttributes=function(t,s){var r=s.isOpen(),i,n,d;var l=s._getSuggestionsPopover();e.writeInnerAttributes.apply(this,arguments);t.attr("aria-expanded",r);if(!l){return}var o=l.getFocusedListItem();var u=l.getValueStateActiveState();if(!r||!o&&!u){return}if(u){t.attr("aria-activedescendant",s._getFormattedValueStateText().getId());return}i=o.isA("sap.m.GroupHeaderListItem")||o.isA("sap.ui.core.SeparatorItem");n=s.getSelectedItem();d=n&&a.getListItem(n);o=i?o:d;if(o){t.attr("aria-activedescendant",o.getId())}};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ComboBoxTextField", ["./InputBase","./library","sap/ui/core/LabelEnablement","./ComboBoxTextFieldRenderer"],function(e,t,o,r){"use strict";var i=e.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}}},renderer:r});var n=sap.ui.getCore().getLibraryResourceBundle("sap.m");i.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oArrowIcon=this.addEndIcon({id:this.getId()+"-arrow",src:"sap-icon://slim-arrow-down",noTabStop:true,alt:n.getText("COMBOBOX_BUTTON"),decorative:false})};i.prototype.getArrowIcon=function(){return this._oArrowIcon};i.prototype.getIcon=i.prototype.getArrowIcon;i.prototype.toggleIconPressedStyle=function(t){this.toggleStyleClass(e.ICON_PRESSED_CSS_CLASS,t)};i.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments);var t=o.getReferencingLabels(this)||[],r=this.getArrowIcon();r.setVisible(this.getShowButton());t.forEach(function(e){if(r.getAriaLabelledBy().indexOf(e)===-1){r.addAssociation("ariaLabelledBy",e,true)}},this)};i.prototype.getOpenArea=function(){var e=this.getArrowIcon().getDomRef();return e?e.parentNode:e};i.prototype.onsapenter=function(t){e.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return}this._bCheckDomValue&&t.setMarked();var o=this.getValue(),r=o.length;this.setValue(o);this.selectText(r,r)};i.prototype.getValue=function(){var e=this.getFocusDomRef();if(e){return e.value}return this.getProperty("value")};i.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef()};i.prototype.getAccessibilityInfo=function(){var t=e.prototype.getAccessibilityInfo.apply(this,arguments);t.type=n.getText("ACC_CTR_TYPE_COMBO");return t};i.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oArrowIcon=null};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ComboBoxTextFieldRenderer", ["./InputBaseRenderer","sap/ui/core/Renderer"],function(t,e){"use strict";var a=e.extend(t);a.apiVersion=2;a.CSS_CLASS_COMBOBOXTEXTFIELD="sapMComboBoxTextField";a.writeInnerAttributes=function(t,e){t.attr("role","combobox");t.attr("aria-haspopup","listbox");t.attr("aria-autocomplete","both");t.attr("aria-expanded","false");t.attr("autocomplete","off");t.attr("autocorrect","off");t.attr("autocapitalize","off");t.attr("type","text")};a.getAriaRole=function(){};a.addOuterStyles=function(t,e){t.style("max-width",e.getMaxWidth())};a.writeIcons=function(t,e){t.openStart("div").attr("tabindex","-1").attr("aria-hidden","true").class("sapMInputBaseIconContainer").openEnd();e.forEach(t.renderControl,t);t.close("div")};return a},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/m/CustomAttribute", ["sap/ui/core/Control"],function(e){"use strict";var r=e.extend("sap.m.CustomAttribute",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null}}},renderer:{apiVersion:2,render:function(e,r){}}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CustomListItem", ["./ListItemBase","./library","./CustomListItemRenderer"],function(t,e,i){"use strict";var n=t.extend("sap.m.CustomListItem",{metadata:{library:"sap.m",defaultAggregation:"content",properties:{accDescription:{type:"string",group:"Behavior"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/CustomListItem.designtime"},renderer:i});n.prototype.setAccDescription=function(t){this.setProperty("accDescription",t,true);return this};n.prototype.getContentAnnouncement=function(){var e=this.getAccDescription();if(e){return e}return this.getContent().map(function(e){return t.getAccessibilityText(e)}).join(" ").trim()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CustomListItemRenderer", ["./ListItemBaseRenderer","sap/ui/core/Renderer"],function(e,n){"use strict";var r=n.extend(e);r.apiVersion=2;r.renderLIAttributes=function(e,n){e.class("sapMCLI")};r.renderLIContent=function(e,n){n.getContent().forEach(e.renderControl,e)};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CustomTile", ["./Tile","./library","./CustomTileRenderer"],function(e,t,i){"use strict";var r=e.extend("sap.m.CustomTile",{metadata:{library:"sap.m",deprecated:true,designtime:"sap/m/designtime/CustomTile.designtime",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}}},renderer:i});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CustomTileRenderer", ["./TileRenderer","sap/ui/core/Renderer"],function(e,t){"use strict";var i=t.extend(e);i.apiVersion=2;i.render=function(e,t){var i,n;e.openStart("div",t).attr("tabindex","0");e.class("sapMCustomTile");if(t._invisible){e.style("visibility","hidden")}if(t.getParent()&&t.getParent().isA("sap.m.TileContainer")){i=t.getParent();n=i._getVisibleTiles();e.accessibilityState(t,{role:"option",posinset:i._indexOfVisibleTile(t,n)+1,setsize:n.length})}e.openEnd();e.openStart("div",t.getId()+"-remove").class("sapMTCRemove").openEnd().close("div");e.openStart("div").class("sapMCustomTileContent").openEnd();this._renderContent(e,t);e.close("div").close("div")};i._renderContent=function(e,t){e.renderControl(t.getContent())};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CustomTreeItem", ["./TreeItemBase","./ListItemBase","./library","./CustomTreeItemRenderer"],function(e,t,n,r){"use strict";var i=e.extend("sap.m.CustomTreeItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}},renderer:r});i.prototype.getContentAnnouncement=function(){return this.getContent().map(function(e){return t.getAccessibilityText(e)}).join(" ").trim()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/CustomTreeItemRenderer", ["./TreeItemBaseRenderer","sap/ui/core/Renderer"],function(e,r){"use strict";var n=r.extend(e);n.apiVersion=2;n.renderLIAttributes=function(r,n){r.class("sapMCTI");e.renderLIAttributes.apply(this,arguments)};n.renderLIContent=function(e,r){r.getContent().forEach(function(r){e.renderControl(r)})};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DatePicker", ["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/core/Element","./InputBase","./DateTimeField","./Button","./ResponsivePopover","sap/ui/core/date/UniversalDate","./library","sap/ui/core/Control","sap/ui/core/library","./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","./InstanceManager","sap/ui/unified/Calendar","sap/ui/unified/DateRange","sap/ui/unified/DateTypeRange","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/core/LabelEnablement","sap/ui/unified/library","sap/ui/core/Configuration","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/date/UI5Date","sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/Core","sap/ui/dom/jquery/cursorPos"],function(jQuery,e,t,a,i,s,n,o,r,p,l,u,h,d,g,c,f,_,y,D,m,C,v,T,P,b,V,S,M){"use strict";var I=l.CalendarType;var w=sap.ui.getCore().getLibraryResourceBundle("sap.m");var E=i.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showFooter:{type:"boolean",group:"Misc",defaultValue:false},showCurrentDateButton:{type:"boolean",group:"Behavior",defaultValue:false},hideInput:{type:"boolean",group:"Misc",defaultValue:false},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}},afterValueHelpOpen:{},afterValueHelpClose:{}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}},renderer:u});E.prototype.init=function(){i.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=V.getInstance(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=V.getInstance(9999,11,31,23,59,59,999);var t=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,decorative:!e.support.touch||e.system.desktop?true:false,useIconTooltip:false,alt:w.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;t.addEventDelegate({onmousedown:function(e){this._bShouldClosePicker=!!this.isOpen()}},this);t.attachPress(function(){this.toggleOpen(this._bShouldClosePicker)},this)};E.prototype.isValidValue=function(){return this._bValid};E.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen()};E.prototype.toggleOpen=function(e){if(this.getEditable()&&this.getEnabled()){if(e){F.call(this)}else{R.call(this)}}};E.prototype.getIconSrc=function(){return c.getIconURI("appointment-2")};E.prototype.exit=function(){a.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close()}delete this._oPopup}if(this._getCalendar()){if(this._oCalendarAfterRenderDelegate){this._getCalendar().removeDelegate(this._oCalendarAfterRenderDelegate)}this._getCalendar().destroy();delete this._getCalendar()}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar)}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined};E.prototype.invalidate=function(e){if(!e||e!=this._getCalendar()){p.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(k.bind(this),0)}};E.prototype.onBeforeRendering=function(){i.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var e=this._getValueHelpIcon();if(e){e.setProperty("visible",this.getEditable())}};E.prototype.setDisplayFormat=function(e){this.setProperty("displayFormat",e);if(this._oCalendar){this._oCalendar.removeDelegate(this._oCalendarAfterRenderDelegate);this._oCalendar.destroy();this._oCalendar=null;this._createPopupContent()}return this};E.prototype.setWidth=function(e){return a.prototype.setWidth.call(this,e||"100%")};E.prototype.getWidth=function(e){return this.getProperty("width")||"100%"};E.prototype.applyFocusInfo=function(t){this._bFocusNoPopup=true;if(!e.support.touch||e.system.desktop){a.prototype.applyFocusInfo.apply(this,arguments)}};E.prototype.onfocusin=function(e){if(!jQuery(e.target).hasClass("sapUiIcon")){i.prototype.onfocusin.apply(this,arguments)}this._bFocusNoPopup=undefined};E.prototype.onsapshow=function(e){this.toggleOpen(this.isOpen());e.preventDefault()};E.prototype.onsaphide=E.prototype.onsapshow;E.prototype.onsapescape=function(e){var t=this.getLastValue(),a=this._parseValue(this._getInputValue(),true),i=this._formatValue(a,true);if(i!==t){e.setMarked();e.preventDefault();this.updateDomValue(t);this.onValueRevertedByEscape(t,i)}};E.prototype.onsappageup=function(e){var t=this._getCalendarConstructor().getMetadata().getName();e.preventDefault();if(t!="sap.ui.unified.Calendar"){return}this._increaseDate(1,"day")};E.prototype.onsappageupmodifiers=function(e){var t=this._getCalendarConstructor().getMetadata().getName();e.preventDefault();if(!e.ctrlKey&&e.shiftKey){if(t=="sap.ui.unified.internal.CustomYearPicker"){return}this._increaseDate(1,"month")}else{this._increaseDate(1,"year")}};E.prototype.onsappagedown=function(e){var t=this._getCalendarConstructor().getMetadata().getName();e.preventDefault();if(t!="sap.ui.unified.Calendar"){return}this._increaseDate(-1,"day")};E.prototype.onsappagedownmodifiers=function(e){var t=this._getCalendarConstructor().getMetadata().getName();e.preventDefault();if(!e.ctrlKey&&e.shiftKey){if(t=="sap.ui.unified.internal.CustomYearPicker"){return}this._increaseDate(-1,"month")}else{this._increaseDate(-1,"year")}};E.prototype.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return}var t=this._getFormatter(true);var a=String.fromCharCode(e.charCode);if(a&&t.sAllowedCharacters&&t.sAllowedCharacters.indexOf(a)<0){e.preventDefault()}};E.prototype._getValueHelpIcon=function(){var e=this.getAggregation("_endIcon");return e&&e[0]};E.prototype._dateValidation=function(e){this._bValid=true;if(e&&(e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime())){this._bValid=false;d(this._bValid,"Date must be in valid range")}this.setProperty("dateValue",e);return e};E.prototype.setMinDate=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(h(this.getMinDate(),e)){return this}if(e){var t=e.getFullYear();if(t<1||t>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this)}this._oMinDate=V.getInstance(e.getTime());var a=this.getDateValue();if(a&&a.getTime()<e.getTime()){this._bValid=false;this._bOutOfAllowedRange=true;g.warning("DateValue not in valid date range",this)}}else{this._oMinDate=V.getInstance(1,0,1);this._oMinDate.setFullYear(1)}this.setProperty("minDate",e);if(this._getCalendar()){this._getCalendar().setMinDate(e)}this._oMinDate.setHours(0,0,0,0);return this};E.prototype.setMaxDate=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(h(this.getMaxDate(),e)){return this}if(e){var t=e.getFullYear();if(t<1||t>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this)}this._oMaxDate=V.getInstance(e.getTime());var a=this.getDateValue();if(a&&a.getTime()>e.getTime()){this._bValid=false;this._bOutOfAllowedRange=true;g.warning("DateValue not in valid date",this)}}else{this._oMaxDate=V.getInstance(9999,11,31,23,59,59,999)}this.setProperty("maxDate",e);if(this._getCalendar()){this._getCalendar().setMaxDate(e)}this._oMaxDate.setHours(23,59,59,999);return this};E.prototype.setCurrentDateButton=function(e){var t=this._getCalendar();t&&t.setCurrentDateButton(e);return this.setProperty("showCurrentDateButton",e)};E.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){g.warning("minDate > MaxDate -> dates switched",this);var e=V.getInstance(this._oMinDate.getTime());var t=V.getInstance(this._oMaxDate.getTime());e.setHours(23,59,59,999);t.setHours(0,0,0,0);this._oMinDate=V.getInstance(t.getTime());this._oMaxDate=V.getInstance(e.getTime());this.setProperty("minDate",t,true);this.setProperty("maxDate",e,true);if(this._getCalendar()){this._getCalendar().setMinDate(t);this._getCalendar().setMaxDate(e)}}var a=this.getDateValue();if(a&&(a.getTime()<this._oMinDate.getTime()||a.getTime()>this._oMaxDate.getTime())){this._bValid=false;g.error("dateValue "+a.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this)}};E.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType")};E.prototype._handleDateValidation=function(e){this._bValid=true;if(!e||e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){this._bValid=false;g.warning("Value can not be converted to a valid date",this)}var t=this._formatValue(e,true);if(t!==this.getValue()){this.setLastValue(t)}this.setProperty("value",t);this.setProperty("dateValue",e)};E.prototype.setDisplayFormatType=function(e){if(e){var t=false;for(var a in I){if(a==e){t=true;break}}if(!t){throw new Error(e+" is not a valid calendar type"+this)}}this.setProperty("displayFormatType",e,true);this.setDisplayFormat(this.getDisplayFormat());return this};E.prototype.setSecondaryCalendarType=function(e){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",e,true);if(this._getCalendar()){this._getCalendar().setSecondaryCalendarType(e)}return this};E.prototype.setShowFooter=function(e){var t=this._oPopup,a=this._getCalendar();this.setProperty("showFooter",e);if(!t||!a){return this}t._getButtonFooter().setVisible(e);return this};E.prototype.addSpecialDate=function(e){B.call(this,e);this.addAggregation("specialDates",e,true);k.call(this);return this};E.prototype.insertSpecialDate=function(e,t){B.call(this,e);this.insertAggregation("specialDates",e,t,true);k.call(this);return this};E.prototype.removeSpecialDate=function(e){var t=this.removeAggregation("specialDates",e,true);k.call(this);return t};E.prototype.removeAllSpecialDates=function(){var e=this.removeAllAggregation("specialDates",true);k.call(this);return e};E.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);k.call(this);return this};E.prototype.setLegend=function(e){this.setAssociation("legend",e,true);var t=this.getLegend();if(t){var a=sap.ui.require("sap/ui/unified/CalendarLegend");e=sap.ui.getCore().byId(t);if(e&&!(typeof a=="function"&&e instanceof a)){throw new Error(e+" is not an sap.ui.unified.CalendarLegend. "+this)}}if(this._getCalendar()){this._getCalendar().setLegend(t)}return this};E.prototype.onChange=function(e){if(!this.getEditable()||!this.getEnabled()){return}var t=this._$input.val(),a=this._formatValue(this.getDateValue()),i;if(t==a&&this._bValid){return}if(this.getShowFooter()&&this._oPopup&&!t){this._oPopup.getBeginButton().setEnabled(false)}this._bValid=true;if(t!=""){i=this._parseValue(t,true);if(!i||i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime()){this._bValid=false;i=undefined}else{t=this._formatValue(i)}}if(this.getDomRef()&&this._$input.val()!==t){this._$input.val(t);this._curpos=this._$input.cursorPos()}if(i){t=this._formatValue(i,true)}if(this.getLastValue()!==t||i&&this.getDateValue()&&i.getFullYear()!==this.getDateValue().getFullYear()){this.setLastValue(t);this.setProperty("value",t,true);var s=this.getValue();if(this._bValid&&t==s){this.setProperty("dateValue",i,true)}t=s;if(this.isOpen()){if(this._bValid){i=this.getDateValue()}this._getCalendar().focusDate(i);var n=this._oDateRange.getStartDate();if(!n&&i||n&&i&&n.getTime()!=i.getTime()){this._oDateRange.setStartDate(V.getInstance(i.getTime()))}else if(n&&!i){this._oDateRange.setStartDate(undefined)}}this.fireChangeEvent(t,{valid:this._bValid})}};E.prototype.updateDomValue=function(e){if(this.isActive()&&this._$input.val()!==e){this._bCheckDomValue=true;e=typeof e=="undefined"?this._$input.val():e.toString();this._curpos=this._$input.cursorPos();var t=this._parseValue(e,true);e=this._formatValue(t);if(this._bPreferUserInteraction){this.handleInputValueConcurrency(e)}else{this._$input.val(e);if(document.activeElement===this._$input[0]){this._$input.cursorPos(this._curpos)}}}return this};function R(e){this._createPopup();this._createPopupContent();var t;var a=this.getBinding("value");if(a&&a.oType&&a.oType.oOutputFormat){t=a.oType.oOutputFormat.oFormatOptions.calendarType}else if(a&&a.oType&&a.oType.oFormat){t=a.oType.oFormat.oFormatOptions.calendarType}if(!t){t=this.getDisplayFormatType()}if(t){this._getCalendar().setPrimaryCalendarType(t)}var i=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(i!=this._$input.val()){this.onChange()}this._fillDateRange();this._openPopup(e);this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar()),afterPopupOpened:true})}E.prototype._createPopup=function(){var a="";if(!this._oPopup){this._oPopup=new n(this.getId()+"-RP",{showCloseButton:false,showArrow:false,showHeader:false,placement:r.PlacementType.VerticalPreferredBottom,contentWidth:this.$().closest(".sapUiSizeCompact").length>0?"18rem":"21rem",beginButton:new s({type:r.ButtonType.Emphasized,text:w.getText("DATEPICKER_SELECTION_CONFIRM"),press:this._handleOKButton.bind(this)}),afterOpen:x.bind(this),afterClose:O.bind(this)}).addStyleClass("sapMRPCalendar");if(this.getShowFooter()){this._oPopup.addStyleClass("sapMLandscapePadding")}this._oPopup._getPopup().setAutoClose(true);if(e.system.phone){a=v.getReferencingLabels(this).concat(this.getAriaLabelledBy()).reduce(function(e,a){var i=t.registry.get(a);return e+" "+(i.getText?i.getText():"")},"").trim();this._oPopup.setTitle(a);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true)}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new s({text:w.getText("DATEPICKER_SELECTION_CANCEL"),press:this._handleCancelButton.bind(this)}))}this.setAggregation("_popup",this._oPopup,true)}};E.prototype._openPopup=function(e){if(!this._oPopup){return}if(!e){e=this.getDomRef()}this._oPopup._getPopup().setExtraContent([e]);this._oPopup.openBy(e||this)};E.prototype.openBy=function(e){R.call(this,e)};E.prototype._getVisibleDatesRange=function(e){var t=e._getVisibleDays();return new y({startDate:t[0].toLocalJSDate(),endDate:t[t.length-1].toLocalJSDate()})};E.prototype._createPopupContent=function(){var e=this._getCalendarConstructor();if(!this._getCalendar()){this._oCalendar=new e(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),calendarWeekNumbering:this.getCalendarWeekNumbering(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar())})}.bind(this)});this._oCalendar.setShowCurrentDateButton(this.getShowCurrentDateButton());this._oDateRange=new y;this._getCalendar().addSelectedDate(this._oDateRange);this._getCalendar()._setSpecialDatesControlOrigin(this);this._getCalendar().attachCancel(F,this);if(this.$().closest(".sapUiSizeCompact").length>0){this._getCalendar().addStyleClass("sapUiSizeCompact")}if(this._bSecondaryCalendarTypeSet){this._getCalendar().setSecondaryCalendarType(this.getSecondaryCalendarType())}if(this._bOnlyCalendar){this._getCalendar().attachSelect(this._handleCalendarSelect,this);this._getCalendar().attachEvent("_renderMonth",A,this);this._oPopup._getButtonFooter().setVisible(this.getShowFooter());this._getCalendar()._bSkipCancelButtonRendering=true;if(!this._oPopup.getContent().length){var t=this._getValueStateHeader();this._oPopup.addContent(this._getValueStateHeader());t.setPopup(this._oPopup._oControl)}this._oPopup.addContent(this._getCalendar());if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false)}}this._attachAfterRenderingDelegate()}};E.prototype._attachAfterRenderingDelegate=function(){this._oCalendarAfterRenderDelegate={onAfterRendering:function(){var e=this._oPopup&&this._oPopup._getPopup();e&&e._oLastPosition&&e._applyPosition(e._oLastPosition);if(this._oPopup.isOpen()){this._oCalendar.focus()}}.bind(this)};this._oCalendar.addDelegate(this._oCalendarAfterRenderDelegate)};E.prototype._getCalendarConstructor=function(){var e=this._getFormatter(true).aFormatArray.map(function(e){return e.type.toLowerCase()}),t=e.indexOf("day")>=0,a=e.indexOf("month")>=0||e.indexOf("monthstandalone")>=0,i=e.indexOf("year")>=0;if(t&&a&&i){return _}else if(a&&i){return m}else if(i){return C}else{g.warning("Not valid date pattern! Default Calendar constructor function is returned",this);return _}};E.prototype._fillDateRange=function(){var e=this.getDateValue();if(e&&e.getTime()>=this._oMinDate.getTime()&&e.getTime()<=this._oMaxDate.getTime()){this._getCalendar().focusDate(V.getInstance(e.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=e.getTime()){this._oDateRange.setStartDate(V.getInstance(e.getTime()))}}else{var t=this.getInitialFocusedDateValue();var a=t?t:V.getInstance();if(a.getTime()<this._oMinDate.getTime()){a=this._oMinDate}else if(a.getTime()>this._oMaxDate.getTime()){a=this._oMaxDate}this._getCalendar().focusDate(a);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined)}}};E.prototype.getAccessibilityInfo=function(){var e=this.getRenderer();var t=a.prototype.getAccessibilityInfo.apply(this,arguments);var i=this.getValue()||"";var s=this.getRequired()?M.getLibraryResourceBundle("sap.m").getText("ELEMENT_REQUIRED"):"";if(this._bValid){var n=this.getDateValue();if(n){i=this._formatValue(n)}}t.type=w.getText("ACC_CTR_TYPE_DATEINPUT");t.description=[i||this._getPlaceholder(),e.getLabelledByAnnouncement(this),e.getDescribedByAnnouncement(this),s].join(" ").trim();return t};E.prototype._selectDate=function(){var t=this.getDateValue(),a=this._getSelectedDate(),i="";if(!h(a,t)){this.setDateValue(V.getInstance(a.getTime()));i=this.getValue();this.fireChangeEvent(i,{valid:true});this._focusInput()}else if(!this._bValid){i=this._formatValue(a);if(i!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(i);this.setLastValue(i)}i=this._formatValue(a,true);this.setProperty("value",i,true);this.fireChangeEvent(i,{valid:true});this._focusInput()}}else if(e.system.desktop||!e.support.touch){this.focus()}this._oPopup.close()};E.prototype._handleCalendarSelect=function(){if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(true);return}this._selectDate()};E.prototype._getTimezone=function(e){return P.getTimezone()};E.prototype._focusInput=function(){if(this.getDomRef()&&(e.system.desktop||!e.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos)}return this};E.prototype._getCalendar=function(){return this._oCalendar};E.prototype._getSelectedDate=function(){var e=this._getCalendar().getSelectedDates(),t;if(e.length>0){t=e[0].getStartDate()}return t};E.prototype._handleOKButton=function(){this._selectDate()};E.prototype._handleCancelButton=function(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false)}this._oPopup.close()};function F(t){if(this.isOpen()){this._oPopup.close();if(e.system.desktop||!e.support.touch){this.focus()}}}E.prototype._increaseDate=function(e,t){var a=this.getDateValue();var i=this._$input.cursorPos();if(a&&this.getEditable()&&this.getEnabled()){var s;var n=this.getBinding("value");if(n&&n.oType&&n.oType.oOutputFormat){s=n.oType.oOutputFormat.oFormatOptions.calendarType}else if(n&&n.oType&&n.oType.oFormat){s=n.oType.oFormat.oFormatOptions.calendarType}if(!s){s=this.getDisplayFormatType()}var r=o.getInstance(V.getInstance(a.getTime()),s);a=o.getInstance(V.getInstance(a.getTime()),s);switch(t){case"day":r.setDate(r.getDate()+e);break;case"month":r.setMonth(r.getMonth()+e);var p=(a.getMonth()+e)%12;if(p<0){p=12+p}while(r.getMonth()!=p){r.setDate(r.getDate()-1)}break;case"year":r.setFullYear(r.getFullYear()+e);while(r.getMonth()!=a.getMonth()){r.setDate(r.getDate()-1)}break;default:break}if(r.getTime()<this._oMinDate.getTime()){r=new o(this._oMinDate.getTime())}else if(r.getTime()>this._oMaxDate.getTime()){r=new o(this._oMaxDate.getTime())}if(!h(this.getDateValue(),r.getJSDate())){this.setDateValue(V.getInstance(r.getTime()));this._curpos=i;this._$input.cursorPos(this._curpos);var l=this.getValue();this.fireChangeEvent(l,{valid:true})}}};E.prototype._getSpecialDates=function(){var e=this.getSpecialDates();for(var t=0;t<e.length;t++){var a=e[t].getSecondaryType()===T.CalendarDayType.NonWorking&&e[t].getType()!==T.CalendarDayType.NonWorking;if(a){var i=new D;i.setType(e[t].getSecondaryType());i.setStartDate(e[t].getStartDate());if(e[t].getEndDate()){i.setEndDate(e[t].getEndDate())}e.push(i)}}return e};function x(){this.addStyleClass(a.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._getCalendar().$("-Month0-days").find(".sapUiCalItem").length;f.addPopoverInstance(this._oPopup);this._oCalendar.focus();this.fireAfterValueHelpOpen()}function O(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false)}this.removeStyleClass(a.ICON_PRESSED_CSS_CLASS);this._getCalendar()._closePickers();f.removePopoverInstance(this._oPopup);this.fireAfterValueHelpClose()}function A(e){var t=e.getParameter("days"),a=this._oPopup._getPopup();if(t>this._renderedDays){this._renderedDays=t;a._applyPosition(a._oLastPosition)}}function B(e){var t=sap.ui.require("sap/ui/unified/DateTypeRange");if(e&&!(t&&e instanceof t)){throw new Error(e+'is not valid for aggregation "specialDates" of '+this)}}function k(){if(this.isOpen()){this._getCalendar()._bDateRangeChanged=false;this._getCalendar().invalidate()}}return E});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DatePickerRenderer", ["sap/ui/core/Renderer","./DateTimeFieldRenderer","sap/ui/core/library"],function(e,t,a){"use strict";var i=e.extend(t);i.apiVersion=2;i.writeInnerValue=function(e,t){if(t._inPreferredUserInteraction()){e.attr("value",t._$input.val())}else if(t._bValid||t._bOutOfAllowedRange){e.attr("value",t._formatValue(t.getDateValue()))}else{e.attr("value",t.getValue())}};i.writeInnerAttributes=function(e,t){e.attr("type","text");if(t._bMobile){e.attr("readonly","readonly")}};i.getAccessibilityState=function(e){var i=t.getAccessibilityState.apply(this,arguments);i["roledescription"]=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");if(e.getEditable()&&e.getEnabled()){i["haspopup"]=a.aria.HasPopup.Grid.toLowerCase()}i["disabled"]=null;if(e._bMobile&&e.getEnabled()&&e.getEditable()){i["readonly"]=false}return i};i.addOuterClasses=function(e,a){if(a.getHideInput()){e.class("sapMDatePickerHiddenInput")}t.addOuterClasses.apply(this,arguments)};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DateRangeSelection", ["sap/ui/Device","./DatePicker","./library","sap/ui/core/LocaleData","sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","./DateRangeSelectionRenderer","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/base/util/deepEqual","sap/base/Log","sap/base/assert","sap/ui/core/Configuration","sap/ui/core/date/UI5Date","sap/ui/core/Core","sap/ui/dom/jquery/cursorPos"],function(e,t,a,i,s,r,n,o,l,u,h,g,p,c,f){"use strict";var d=t.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:"-"},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}},designtime:"sap/m/designtime/DateRangeSelection.designtime",dnd:{draggable:false,droppable:true}},renderer:n});var D=String.fromCharCode(45),_=String.fromCharCode(8211),m=String.fromCharCode(8212);d.prototype.init=function(){t.prototype.init.apply(this,arguments);this._bIntervalSelection=true};d.prototype._createPopupContent=function(){t.prototype._createPopupContent.apply(this,arguments);var e=this._getCalendar();if(e instanceof o){e._getMonthPicker().setIntervalSelection(true)}if(e instanceof l){e._getYearPicker().setIntervalSelection(true)}this._getCalendar().detachWeekNumberSelect(this._handleWeekSelect,this);this._getCalendar().attachWeekNumberSelect(this._handleWeekSelect,this);this._getCalendar().getSelectedDates()[0].setStartDate(this._oDateRange.getStartDate());this._getCalendar().getSelectedDates()[0].setEndDate(this._oDateRange.getEndDate())};d.prototype.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return}var t=S.call(this);var a=T.call(this);var i=t.sAllowedCharacters+a+" ";var s=String.fromCharCode(e.charCode);if(s&&t.sAllowedCharacters&&i.indexOf(s)<0){e.preventDefault()}};d.prototype._getPlaceholder=function(){var e=this.getPlaceholder(),t,a,s,r,n;if(!e){t=this.getBinding("value");s=p.getFormatSettings().getFormatLocale();r=i.getInstance(s);if(t&&t.getType()&&t.getType().isA("sap.ui.model.type.DateInterval")){a=t.getType();if(a.oFormatOptions&&a.oFormatOptions.format){e=r.getCustomDateTimePattern(a.oFormatOptions.format)}else{n=Object.assign({interval:true,singleIntervalValue:true},a.oFormatOptions);return this._getDateFormatPlaceholderText(n)}}else{e=this.getDisplayFormat();if(!e){e="medium"}if(this._checkStyle(e)){n=Object.assign({interval:true,singleIntervalValue:true,intervalDelimiter:T.call(this)},S.call(this).oFormatOptions);return this._getDateFormatPlaceholderText(n)}}var o=T.call(this);if(o&&o!==""){e=e+" "+o+" "+e}}return e};d.prototype._getDateFormatPlaceholderText=function(e){return s.getDateInstance(e).getPlaceholderText()};d.prototype.setValue=function(e){var t;e=this.validateProperty("value",e);if(e!==this.getValue()){this.setLastValue(e)}else{return this}t=this._parseAndValidateValue(e);this.setProperty("dateValue",this._normalizeDateValue(t[0]),this._bPreferUserInteraction);this.setProperty("secondDateValue",this._normalizeDateValue(t[1]),this._bPreferUserInteraction);this._formatValueAndUpdateOutput(t);this.setProperty("value",e,this._bPreferUserInteraction);return this};d.prototype._parseAndValidateValue=function(e){this._bValid=true;var t=[undefined,undefined];if(e){t=this._parseValue(e);if(!v.call(this,t[0],t[1])[0]){this._bValid=false;h.warning("Value can not be converted to a valid dates",this)}}return t};d.prototype._formatValueAndUpdateOutput=function(e){if(!this.getDomRef()){return}var t=this._formatValue(e[0],e[1]);if(this._bPreferUserInteraction){this.handleInputValueConcurrency(t)}else if(this._$input.val()!==t){this._$input.val(t);this._curpos=this._$input.cursorPos()}};d.prototype._normalizeDateValue=function(e){switch(typeof e){case"number":return c.getInstance(e);case"string":return S.call(this).parse(e);default:return e}};d.prototype._denormalizeDateValue=function(e){return e&&e.getTime?e.getTime():e};d.prototype.setValueFormat=function(e){this.setProperty("valueFormat",e,true);h.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this};d.prototype.setDisplayFormat=function(e){t.prototype.setDisplayFormat.apply(this,arguments);var a=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",a,true);if(this.getDomRef()&&this._$input.val()!==a){this._$input.val(a);this._curpos=this._$input.cursorPos()}return this};d.prototype.setFrom=function(e){this.setDateValue(e);return this};d.prototype.getFrom=function(){return this.getDateValue()};d.prototype.setTo=function(e){this.setSecondDateValue(e);return this};d.prototype.getTo=function(){return this.getSecondDateValue()};d.prototype.setDateValue=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(u(this.getDateValue(),e)){return this}t.prototype._dateValidation.call(this,e);this._syncDateObjectsToValue(e,this.getSecondDateValue());return this};d.prototype.setSecondDateValue=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(u(this.getSecondDateValue(),e)){return this}this._bValid=true;if(e&&(e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime())){this._bValid=false;g(this._bValid,"Date must be in valid range")}this.setProperty("secondDateValue",e);this._syncDateObjectsToValue(this.getDateValue(),e);return this};d.prototype.setMinDate=function(e){t.prototype.setMinDate.apply(this,arguments);if(e){var a=this.getSecondDateValue();if(a&&a.getTime()<this._oMinDate.getTime()){h.warning("SecondDateValue not in valid date range",this)}}return this};d.prototype.setMaxDate=function(e){t.prototype.setMaxDate.apply(this,arguments);if(e){var a=this.getSecondDateValue();if(a&&a.getTime()>this._oMaxDate.getTime()){h.warning("SecondDateValue not in valid date range",this)}}return this};d.prototype._checkMinMaxDate=function(){t.prototype._checkMinMaxDate.apply(this,arguments);var e=this.getSecondDateValue();if(e&&(e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime())){h.error("secondDateValue "+e.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain secondDateValue/value accordingly.",this)}};d.prototype._parseValue=function(e){var t;var a=[];var i,s;var r=this.getBinding("value");if(r&&r.getType()&&r.getType().isA("sap.ui.model.type.DateInterval")){try{a=r.getType().parseValue(e,"string")}catch(e){return[undefined,undefined]}if(r.getType().oFormatOptions&&r.getType().oFormatOptions.UTC){a=a.map(function(e){return c.getInstance(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds())})}return a}var n=T.call(this);if(n&&e){e=e.trim();e=C(e,[n," "]);a=this._splitValueByDelimiter(e,n);if(a.length===2){if(a[0].slice(a[0].length-1,a[0].length)==" "){a[0]=a[0].slice(0,a[0].length-1)}if(a[1].slice(0,1)==" "){a[1]=a[1].slice(1)}}else{a=e.split(" "+n+" ")}if(e.indexOf(n)===-1){var o=e.split(" ");if(o.length===2){a=o}}}if(e&&a.length<=2){t=S.call(this);if(!n||n===""||a.length===1){i=t.parse(e)}else if(a.length===2){i=t.parse(a[0]);s=t.parse(a[1]);if(!i||!s){i=undefined;s=undefined}}}return[i,s]};d.prototype._splitValueByDelimiter=function(e,t){var a=[D,_,m],i;if(t){if(a.indexOf(t)===-1){return e.split(t)}}for(i=0;i<a.length;i++){if(e.indexOf(a[i])>0){return e.split(a[i])}}return e?e.split(" "):[]};d.prototype._formatValue=function(e,t){var a="",i=T.call(this),s=S.call(this),r,n,o,l;o=e;l=t;if(o){r=this.getBinding("value");if(r&&r.getType()&&r.getType().isA("sap.ui.model.type.DateInterval")){if(r.getType().oFormatOptions&&r.getType().oFormatOptions.source&&r.getType().oFormatOptions.source.pattern==="timestamp"){a=r.getType().formatValue([this._denormalizeDateValue(e),this._denormalizeDateValue(t)],"string")}else{n=r.getType();if(n.oFormatOptions&&r.getType().oFormatOptions.UTC){o=c.getInstance(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds()));if(t){l=c.getInstance(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds()))}}if(n.oInputFormat&&typeof o==="object"){o=s.format(o)}if(n.oInputFormat&&typeof l==="object"){l=s.format(l)}a=r.getType().formatValue([o,l],"string")}}else{if(i&&i!==""&&l){a=s.format(o)+" "+i+" "+s.format(l)}else{a=s.format(o)}}}return a};d.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return}var e=this._$input.val();var t=e;var a=[undefined,undefined];if(this.getShowFooter()&&this._oPopup&&!t){this._oPopup.getBeginButton().setEnabled(false)}this._bValid=true;if(t!=""){a=this._parseValue(t);a[0]=this._normalizeDateValue(a[0]);a[1]=this._normalizeDateValue(a[1]);a[1]&&a[1].setHours(23,59,59,999);a=v.call(this,a[0],a[1]);if(a[0]){t=this._formatValue(a[0],a[1])}else{this._bValid=false}}if(t!==this.getLastValue()){if(this.getDomRef()&&this._$input.val()!==t){this._$input.val(t);this._curpos=this._$input.cursorPos()}this.setLastValue(t);this.setProperty("value",t,true);if(this._bValid){this.setProperty("dateValue",this._normalizeDateValue(a[0]),true);this.setProperty("secondDateValue",this._normalizeDateValue(a[1]),true)}if(this._oPopup&&this._oPopup.isOpen()){var i=this.getDateValue();if(i){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==i.getTime()){this._oDateRange.setStartDate(c.getInstance(i.getTime()));this._getCalendar().focusDate(i)}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined)}}var s=this.getSecondDateValue();if(s){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==s.getTime()){this._oDateRange.setEndDate(c.getInstance(s.getTime()));this._getCalendar().focusDate(s)}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined)}}}y.call(this,this._bValid)}else if(e!==this.getLastValue()&&t===this.getLastValue()){if(this.getDomRef()&&this._$input.val()!==t){this._$input.val(t);this._curpos=this._$input.cursorPos()}}};d.prototype.updateDomValue=function(e){this._bCheckDomValue=true;e=typeof e=="undefined"?this._$input.val():e.toString();this._curpos=this._$input.cursorPos();var t=this._parseValue(e);e=this._formatValue(t[0],t[1]);if(this._bPreferUserInteraction){this.handleInputValueConcurrency(e)}else{if(this.isActive()&&this._$input.val()!==e){this._$input.val(e);this._$input.cursorPos(this._curpos)}}return this};d.prototype.onsapescape=function(e){var t=this.getLastValue(),a=this._parseValue(this._getInputValue(),true),i=this._formatValue(a[0],a[1],true);if(i!==t){e.setMarked();e.preventDefault();this.updateDomValue(t);this.onValueRevertedByEscape(t,i)}};d.prototype._fillDateRange=function(){t.prototype._fillDateRange.apply(this,arguments);var e=this.getSecondDateValue();if(e&&e.getTime()>=this._oMinDate.getTime()&&e.getTime()<=this._oMaxDate.getTime()){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==e.getTime()){this._oDateRange.setEndDate(c.getInstance(e.getTime()))}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined)}}};d.prototype._selectDate=function(){var t=this._getCalendar().getSelectedDates();if(t.length>0){var a=t[0].getStartDate();var i=t[0].getEndDate();if(a&&i){var s=this.getDateValue();var r=this.getSecondDateValue();i.setHours(23,59,59,999);var n;if(!u(a,s)||!u(i,r)){if(u(i,r)){this.setDateValue(a)}else{this.setProperty("dateValue",a,true);this.setSecondDateValue(i)}n=this.getValue();y.call(this,true);if(e.system.desktop||!e.support.touch){this._curpos=n.length;this._$input.cursorPos(this._curpos)}}else if(!this._bValid){n=this._formatValue(a,i);if(n!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(n)}y.call(this,true)}}this._oDateRange.setStartDate(this._getCalendar().getSelectedDates()[0].getStartDate());this._oDateRange.setEndDate(this._getCalendar().getSelectedDates()[0].getEndDate());this._oPopup.close()}}};d.prototype._handleCalendarSelect=function(){var e=this._getCalendar().getSelectedDates(),t=e[0].getStartDate(),a=e[0].getEndDate();if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(!!(t&&a));return}this._selectDate()};d.prototype._handleWeekSelect=function(e){var t=e.getParameter("weekDays"),a=t.getStartDate(),i=t.getEndDate();if(!t){return}if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(!!(a&&i));return}this._getCalendar().getSelectedDates()[0].setStartDate(a);this._getCalendar().getSelectedDates()[0].setEndDate(i);this._oDateRange.setStartDate(a);this._oDateRange.setEndDate(i);this._selectDate()};d.prototype.getAccessibilityInfo=function(){var e=this.getRenderer();var a=t.prototype.getAccessibilityInfo.apply(this,arguments);var i=this.getValue()||"";var s=this.getRequired()?f.getLibraryResourceBundle("sap.m").getText("ELEMENT_REQUIRED"):"";if(this._bValid){var r=this.getDateValue();if(r){i=this._formatValue(r,this.getSecondDateValue())}}a.type=f.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATERANGEINPUT");a.description=[i||this._getPlaceholder(),e.getLabelledByAnnouncement(this),e.getDescribedByAnnouncement(this),s].join(" ").trim();return a};d.prototype._syncDateObjectsToValue=function(e,t){var a=this._formatValue(e,t);if(a!==this.getValue()){this.setLastValue(a)}this.setProperty("value",a);if(this.getDomRef()){var i=this._formatValue(e,t);if(this._$input.val()!==i){this._$input.val(i);this._curpos=this._$input.cursorPos()}}};function y(e){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:e})}function v(e,t){var a,i;if(e&&e.getTime){a=e.getTime()}else if(typeof e==="number"){a=e}if(t&&t.getTime){i=t.getTime()}else if(typeof t==="number"){i=t}if(e&&t&&a>i){var s=e;e=t;t=s}if(e&&(a<this._oMinDate.getTime()||a>this._oMaxDate.getTime())||t&&(i<this._oMinDate.getTime()||i>this._oMaxDate.getTime())){return[undefined,undefined]}else{return[e,t]}}d.prototype._increaseDate=function(e,t){var a=this._$input.val(),i=this._parseValue(a),r=i[0]||null,n=i[1]||null,o,l,g,p,f,d,D;if(!r||!this.getEditable()||!this.getEnabled()){return}if(!v.call(this,r,n)[0]){h.warning("Value can not be converted to a valid dates or dates are outside of the min/max range",this);this._bValid=false;y.call(this,this._bValid);return}var _={interval:true,singleIntervalValue:true,intervalDelimiter:T.call(this)};_=this.getBinding("value")?Object.assign(_,this.getBinding("value").getType().oFormatOptions):Object.assign(_,S.call(this).oFormatOptions);var m=s.getDateInstance(_);a=m.format([r,n]);o=this._$input.cursorPos();l=r?m.format([r,null]).length:0;g=n?m.format([n,null]).length:0;p=a.length;f=o<=l+1;d=o>=p-g-1&&o<=p;if(f&&r){D=V.call(this,r,e,t);if(!u(this.getDateValue(),D.getJSDate())){this.setDateValue(c.getInstance(D.getTime()));this._curpos=o;this._$input.cursorPos(this._curpos);this.fireChangeEvent(this.getValue(),{valid:this._bValid})}}else if(d&&n){D=V.call(this,n,e,t);if(!u(this.getSecondDateValue(),D.getJSDate())){this.setSecondDateValue(c.getInstance(D.getTime()));this._curpos=o;this._$input.cursorPos(this._curpos);this.fireChangeEvent(this.getValue(),{valid:this._bValid})}}};function V(e,t,a){var i=this.getBinding("value"),s,n,o,l;if(i&&i.oType&&i.oType.oOutputFormat){s=i.oType.oOutputFormat.oFormatOptions.calendarType}else if(i&&i.oType&&i.oType.oFormat){s=i.oType.oFormat.oFormatOptions.calendarType}if(!s){s=this.getDisplayFormatType()}o=r.getInstance(c.getInstance(e.getTime()),s);l=o.getMonth();switch(a){case"day":o.setDate(o.getDate()+t);break;case"month":o.setMonth(o.getMonth()+t);n=(l+t)%12;if(n<0){n=12+n}while(o.getMonth()!=n){o.setDate(o.getDate()-1)}break;case"year":o.setFullYear(o.getFullYear()+t);while(o.getMonth()!=l){o.setDate(o.getDate()-1)}break;default:break}if(o.getTime()<this._oMinDate.getTime()){o=new r(this._oMinDate.getTime())}else if(o.getTime()>this._oMaxDate.getTime()){o=new r(this._oMaxDate.getTime())}return o}function T(){var e=this.getDelimiter();if(!e){if(!this._sLocaleDelimiter){var t=p.getFormatSettings().getFormatLocale();var a=i.getInstance(t);var s=a.getIntervalPattern();var r=s.indexOf("{0}")+3;var n=s.indexOf("{1}");e=s.slice(r,n);if(e.length>1){if(e.slice(0,1)==" "){e=e.slice(1)}if(e.slice(e.length-1,e.length)==" "){e=e.slice(0,e.length-1)}}this._sLocaleDelimiter=e}else{e=this._sLocaleDelimiter}}return e}function S(){var e=this.getDisplayFormat()||"medium";var t;var a=this.getDisplayFormatType();if(e==this._sUsedDisplayPattern&&a==this._sUsedDisplayCalendarType){t=this._oDisplayFormat}else{if(this._checkStyle(e)){t=s.getInstance({style:e,strictParsing:true,calendarType:a})}else{t=s.getInstance({pattern:e,strictParsing:true,calendarType:a})}this._sUsedDisplayPattern=e;this._sUsedDisplayCalendarType=a;this._oDisplayFormat=t}return t}function b(e,t){return e&&t&&e.lastIndexOf(t)===e.length-t.length}function P(e,t){return e&&t&&e.indexOf(t)===0}function C(e,t){var a=0,i=t;if(!i){i=[" "]}while(a<i.length){if(b(e,i[a])){e=e.substring(0,e.length-i[a].length);a=0;continue}a++}a=0;while(a<i.length){if(P(e,i[a])){e=e.substring(i[a].length);a=0;continue}a++}return e}return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DateRangeSelectionRenderer", ["sap/ui/core/Renderer","./DatePickerRenderer"],function(e,t){"use strict";var r=e.extend(t);r.apiVersion=2;r.writeInnerValue=function(e,t){if(t._inPreferredUserInteraction()){e.attr("value",t._$input.val())}else if(t._bValid){e.attr("value",t._formatValue(t.getDateValue(),t.getSecondDateValue()))}else{e.attr("value",t.getValue())}};r.getAccessibilityState=function(e){var r=t.getAccessibilityState.apply(this,arguments);r["roledescription"]=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATERANGEINPUT");return r};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DateTimeField", ["sap/ui/model/type/Date","sap/ui/model/odata/type/ODataType","sap/ui/model/odata/type/DateTimeBase","./InputBase","./ValueStateHeader","sap/ui/core/Core","sap/ui/core/LocaleData","sap/ui/core/library","sap/ui/core/format/DateFormat","./DateTimeFieldRenderer","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/core/date/UI5Date","sap/ui/unified/calendar/CalendarUtils","sap/ui/dom/jquery/cursorPos"],function(t,e,a,r,i,s,o,n,u,l,p,h,jQuery,g,c,f){"use strict";var y=n.CalendarType;var d=n.ValueState;var _=r.extend("sap.m.DateTimeField",{metadata:{abstract:true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null},initialFocusedDateValue:{type:"object",group:"Data",defaultValue:null}},events:{liveChange:{parameters:{value:{type:"string"},previousValue:{type:"string"}}}}},renderer:l});_.prototype.setValue=function(t){t=this.validateProperty("value",t);var e=this.getValue();if(t===e){return this}else{this.setLastValue(t)}var a=this._parseAndValidateValue(t);this.setProperty("dateValue",a,this._bPreferUserInteraction);this._formatValueAndUpdateOutput(a,t);this.setProperty("value",t,this._bPreferUserInteraction);return this};_.prototype._parseAndValidateValue=function(t){this._bValid=true;var e;if(t){try{e=this._parseValue(t)}catch(t){}if(Array.isArray(e)){e=e[0]}if(!e||!e.getTime||e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){this._bValid=false;h.warning("Value can not be converted to a valid date",this)}}return e};_.prototype._formatValueAndUpdateOutput=function(t,e){if(!this.getDomRef()){return}var a=t?this._formatValue(t):e;if(this._bPreferUserInteraction){this.handleInputValueConcurrency(a)}else if(this._$input.val()!==a){this._$input.val(a);this._curpos=this._$input.cursorPos()}};_.prototype._inPreferredUserInteraction=function(){if(this._bPreferUserInteraction&&this.getDomRef()){var t=this.getFocusDomRef(),e=t&&this._getInputValue(),a=this.getProperty("value"),r=document.activeElement===t;return r&&e&&a!==e}return false};_.prototype.setDateValue=function(t){if(!this._isValidDate(t)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(p(this.getDateValue(),t)){return this}t=this._dateValidation(t);var e=this._formatValue(t,true);if(e!==this.getValue()){this.setLastValue(e)}this.setProperty("value",e);if(this.getDomRef()){var a=this._formatValue(t);if(this._$input.val()!==a){this._$input.val(a);this._curpos=this._$input.cursorPos()}}return this};_.prototype.setValueFormat=function(t){this.setProperty("valueFormat",t,true);var e=this.getValue();if(e){this._handleDateValidation(this._parseValue(e))}return this};_.prototype.setDisplayFormat=function(t){this.setProperty("displayFormat",t,true);this.updateDomValue(this._formatValue(this.getDateValue()));this.setPlaceholder(this._getPlaceholder());return this};_.prototype.getDisplayFormatType=function(){return null};_.prototype.onfocusin=function(t){if(!jQuery(t.target).hasClass("sapUiIcon")){this.addStyleClass("sapMFocus")}if(!jQuery(t.target).hasClass("sapMInputBaseIconContainer")&&!(this._oPopup&&this._oPopup.isOpen())){this.openValueStateMessage()}else if(this._oValueStateHeader){this._oValueStateHeader.setValueState(this.getValueState()).setText(this._getTextForPickerValueStateContent()).setVisible(this.getValueState()!==d.None)}this._sPreviousValue=this.getDOMValue()};_.prototype.oninput=function(t){r.prototype.oninput.call(this,t);if(t.isMarked("invalid")){return}var e=this.getDOMValue();if(e!==this._sPreviousValue){this.fireLiveChange({value:e,previousValue:this._sPreviousValue});this._sPreviousValue=e}};_.prototype.getDOMValue=function(){return this._$input.val()};_.prototype._getValueStateHeader=function(){var t;if(!this._oValueStateHeader){t=this.getValueState();this._oValueStateHeader=new i({text:this._getTextForPickerValueStateContent(),valueState:t,visible:t!==d.None})}return this._oValueStateHeader};_.prototype._dateValidation=function(t){this._bValid=true;this.setProperty("dateValue",t);return t};_.prototype._handleDateValidation=function(t){this._bValid=true;this.setProperty("dateValue",t)};_.prototype._getPlaceholder=function(){var a=this.getPlaceholder(),r=this.getBinding("value"),i=r&&r.getType&&r.getType(),s;if(!a){if(i instanceof t){return i.getPlaceholderText()}if(i instanceof e&&i.oFormat){return i.oFormat.getPlaceholderText()}s=!!this._getDisplayFormatPattern();a=this._getFormatter(s).getPlaceholderText()}return a};_.prototype._getLocaleBasedPattern=function(t){return o.getInstance(g.getFormatSettings().getFormatLocale()).getDatePattern(t)};_.prototype._parseValue=function(t,e){var r=this.getBinding("value"),i=r&&r.getType&&r.getType(),s=this._getFormatter(e),o,n,u;if(this._isSupportedBindingType(i)){try{u=i.parseValue(t,"string");if(typeof u==="string"&&i instanceof a){u=a.prototype.parseValue.call(i,t,"string")}o=i.oFormatOptions;if(o&&o.source&&o.source.pattern=="timestamp"){u=c.getInstance(u)}else if(o&&o.source&&typeof o.source.pattern==="string"){u=i.oInputFormat.parse(t)}}catch(t){}if(u&&(i.oFormatOptions&&this._isFormatOptionsUTC(i.oFormatOptions)||i.oConstraints&&i.oConstraints.isDateOnly)){n=c.getInstance(u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate(),u.getUTCHours(),u.getUTCMinutes(),u.getUTCSeconds(),u.getUTCMilliseconds());n.setFullYear(u.getUTCFullYear());u=n}return u}return s.parse(t)};_.prototype._formatValue=function(t,e){if(!t){return""}var a=this.getBinding("value"),r=a&&a.getType&&a.getType(),i,s;if(this._isSupportedBindingType(r)){if(r.oFormatOptions&&r.oFormatOptions.UTC||r.oConstraints&&r.oConstraints.isDateOnly){s=f._createUTCDate(t,true);s.setUTCFullYear(t.getFullYear());t=s}i=r.oFormatOptions;if(i&&i.source&&i.source.pattern=="timestamp"){t=t.getTime()}else if(r.oOutputFormat){return r.oOutputFormat.format(t)}return r.formatValue(t,"string")}return this._getFormatter(!e).format(t)};_.prototype._isSupportedBindingType=function(t){return!!t&&t.isA(["sap.ui.model.type.Date","sap.ui.model.odata.type.DateTime","sap.ui.model.odata.type.DateTimeOffset"])};_.prototype._isFormatOptionsUTC=function(t){return t.UTC||t.source&&t.source.UTC};_.prototype._getDefaultDisplayStyle=function(){return"medium"};_.prototype._getDefaultValueStyle=function(){return"short"};_.prototype._getFormatter=function(t){var e=this._getBoundValueTypePattern(),a=false,r,i=this.getBinding("value"),s;if(i&&i.oType&&i.oType.oOutputFormat){a=!!i.oType.oOutputFormat.oFormatOptions.relative;s=i.oType.oOutputFormat.oFormatOptions.calendarType}if(!e){if(t){e=this.getDisplayFormat()||this._getDefaultDisplayStyle();s=this.getDisplayFormatType()}else{e=this.getValueFormat()||this._getDefaultValueStyle();s=y.Gregorian}}if(!s){s=g.getCalendarType()}if(t){if(e===this._sUsedDisplayPattern&&s===this._sUsedDisplayCalendarType){r=this._oDisplayFormat}}else{if(e===this._sUsedValuePattern&&s===this._sUsedValueCalendarType){r=this._oValueFormat}}if(r){return r}return this._getFormatterInstance(r,e,a,s,t)};_.prototype._getFormatterInstance=function(t,e,a,r,i){if(this._checkStyle(e)){t=this._getFormatInstance({style:e,strictParsing:true,relative:a,calendarType:r},i)}else{t=this._getFormatInstance({pattern:e,strictParsing:true,relative:a,calendarType:r},i)}if(i){this._sUsedDisplayPattern=e;this._sUsedDisplayCalendarType=r;this._oDisplayFormat=t}else{this._sUsedValuePattern=e;this._sUsedValueCalendarType=r;this._oValueFormat=t}return t};_.prototype._getFormatInstance=function(t,e){return u.getInstance(t)};_.prototype._checkStyle=function(t){return t==="short"||t==="medium"||t==="long"||t==="full"};_.prototype._getDisplayFormatPattern=function(){var t=this._getBoundValueTypePattern();if(t){return t}t=this.getDisplayFormat();if(this._checkStyle(t)){t=this._getLocaleBasedPattern(t)}return t};_.prototype._getBoundValueTypePattern=function(){var a=this.getBinding("value"),r=a&&a.getType&&a.getType();if(r instanceof t){return r.getOutputPattern()}if(r instanceof e&&r.getFormat){return r.getFormat().oFormatOptions.pattern}return undefined};_.prototype._isValidDate=function(t){return!t||Object.prototype.toString.call(t)==="[object Date]"};_.prototype._getTextForPickerValueStateContent=function(){return this.getValueStateText()||this._getDefaultTextForPickerValueStateContent()};_.prototype._getDefaultTextForPickerValueStateContent=function(){var t=this.getValueState(),e,a;if(t===d.None){a=""}else{e=s.getLibraryResourceBundle("sap.ui.core");a=e.getText("VALUE_STATE_"+t.toUpperCase())}return a};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DateTimeFieldRenderer", ["sap/ui/core/Renderer","./InputBaseRenderer"],function(e,r){"use strict";var n=e.extend(r);n.apiVersion=2;n.getAriaRole=function(e){return""};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DateTimeInput", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","./library","./DatePicker","./DateTimePicker","./TimePicker","sap/ui/model/type/Date","sap/ui/model/type/Time","sap/ui/model/type/DateTime","sap/ui/model/odata/type/ODataType","sap/ui/core/library","sap/ui/Device","./DateTimeInputRenderer","sap/ui/core/Configuration","sap/ui/core/date/UI5Date"],function(jQuery,e,t,a,r,i,s,o,l,u,n,p,c,h,y){"use strict";var g=t.DateTimeInputType;var d=n.TextDirection;var m=n.TextAlign;var f=n.ValueState;var v=e.extend("sap.m.DateTimeInput",{metadata:{interfaces:["sap.m.IToolbarInteractiveControl"],library:"sap.m",deprecated:true,designtime:"sap/m/designtime/DateTimeInput.designtime",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:f.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:m.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:g.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}},renderer:c});!function(e,a,r){var i=t.getLocaleData();jQuery.extend(e,{_types:{Date:{valueFormat:i.getDatePattern("short"),displayFormat:i.getDatePattern("medium")},Time:{valueFormat:i.getTimePattern("short"),displayFormat:i.getTimePattern("short")},DateTime:{valueFormat:i.getDateTimePattern("short"),displayFormat:i.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,a){["valueFormat","displayFormat"].forEach(function(r){var i=e._types;i.DateTime[r]=i.DateTime[r].replace("{"+a+"}",i[t][r])})})}(v.prototype,jQuery,p);v.prototype.init=function(){this.setType(g.Date)};v.prototype.onBeforeRendering=function(){V.call(this)};v.prototype.getFocusDomRef=function(){var e=T.call(this);return e.getFocusDomRef()};v.prototype.getIdForLabel=function(){var e=T.call(this);return e.getIdForLabel()};function D(e){var t;switch(e){case g.DateTime:t=new r(this.getId()+"-Picker");break;case g.Time:t=new i(this.getId()+"-Picker",{localeId:h.getFormatSettings().getFormatLocale().toString()});break;default:t=new a(this.getId()+"-Picker");break}t.setDisplayFormat(this.getDisplayFormat()||this._types[e].displayFormat);t.setValueFormat(this.getValueFormat()||this._types[e].valueFormat);if(this.getDateValue()){t.setDateValue(this.getDateValue())}t.setEnabled(this.getEnabled());t.setEditable(this.getEditable());t.setValueState(this.getValueState());t.setValueStateText(this.getValueStateText());t.setShowValueStateMessage(this.getShowValueStateMessage());t.setName(this.getName());t.setPlaceholder(this.getPlaceholder());t.setTextAlign(this.getTextAlign());t.setTextDirection(this.getTextDirection());t.setWidth("100%");t.attachChange(b,this);var s=this.getAriaLabelledBy();for(var o=0;o<s.length;o++){t.addAriaLabelledBy(s[o])}return t}v.prototype.setType=function(e){if(e==this.getType()&&T.call(this)){return this}this.destroyAggregation("_picker");var t=D.call(this,e);this.setAggregation("_picker",t);this.setProperty("type",e);return this};v.prototype.setWidth=function(e){this.setProperty("width",e);if(this.getDomRef()){e=this.getWidth();this.$().css("width",e)}return this};v.prototype.setValue=function(e){V.call(this);e=this.validateProperty("value",e);if(e.toLowerCase()=="now"){return this.setDateValue(y.getInstance())}if(e===this.getValue()){return this}this.setProperty("value",e,true);var t=T.call(this);t.setValue(e);var a=t.getDateValue();this.setProperty("dateValue",a,true);return this};v.prototype.setDateValue=function(e){if(!this._isValidDate(e)){throw new Error("Date must be a JavaScript date object; "+this)}V.call(this);this.setProperty("dateValue",e,true);var t=T.call(this);t.setDateValue(e);var a=t.getValue();this.setProperty("value",a,true);return this};v.prototype.setDisplayFormat=function(e){this.setProperty("displayFormat",e,true);var t=T.call(this);t.setDisplayFormat(e||this._types[this.getType()].displayFormat);return this};v.prototype.setValueFormat=function(e){this.setProperty("valueFormat",e,true);var t=T.call(this);t.setValueFormat(e||this._types[this.getType()].ValueFormat);return this};v.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);var t=T.call(this);t.setEnabled(e);return this};v.prototype.setEditable=function(e){this.setProperty("editable",e,true);var t=T.call(this);t.setEditable(e);return this};v.prototype.setValueState=function(e){this.setProperty("valueState",e,true);var t=T.call(this);t.setValueState(e);return this};v.prototype.setValueStateText=function(e){this.setProperty("valueStateText",e,true);var t=T.call(this);t.setValueStateText(e);return this};v.prototype.setShowValueStateMessage=function(e){this.setProperty("showValueStateMessage",e,true);var t=T.call(this);t.setShowValueStateMessage(e);return this};v.prototype.setName=function(e){this.setProperty("name",e,true);var t=T.call(this);t.setName(e);return this};v.prototype.setPlaceholder=function(e){this.setProperty("placeholder",e,true);var t=T.call(this);t.setPlaceholder(e);return this};v.prototype.setTextAlign=function(e){this.setProperty("textAlign",e,true);var t=T.call(this);t.setTextAlign(e);return this};v.prototype.setTextDirection=function(e){this.setProperty("textDirection",e,true);var t=T.call(this);t.setTextDirection(e);return this};v.prototype.addAriaLabelledBy=function(e){this.addAssociation("ariaLabelledBy",e,true);var t=T.call(this);t.addAriaLabelledBy(e);return this};v.prototype.removeAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=T.call(this);t.removeAriaLabelledBy(e);return this};v.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var e=T.call(this);e.removeAllAriaLabelledBy();return this};v.prototype.getAccessibilityInfo=function(){var e=T.call(this);return e&&e.getAccessibilityInfo?e.getAccessibilityInfo():null};v.prototype._getPickerByTypeAndPattern=function(e,t,a){var r=/[DdYyMLWwGQUur]/,i=/[HhKkmsa]/,s=i.test(a),o=r.test(a),l=s&&!o,u=o&&!s,n=o&&s,p,c;switch(e){case g.Time:case g.Date:case g.DateTime:if(l&&t.getMetadata().getName()!=="sap.m.TimePicker"){p=g.Time}else if(u&&t.getMetadata().getName()!=="sap.m.DatePicker"){p=g.Date}else if(n&&t.getMetadata().getName()!=="sap.m.DateTimePicker"){p=g.DateTime}break;default:{throw"Invalid type: "+e+". Expected is one of the sap.m.DateTimeInputType"}}if(p){this.destroyAggregation("_picker");c=D.call(this,p);this.setAggregation("_picker",c)}return c||t};v.prototype._getBoundValueTypePattern=function(){var e=this.getBinding("value"),t=e&&e.getType()&&e.getType();if(t instanceof s||t instanceof o||t instanceof l){return t.getOutputPattern()}if(t instanceof u&&t.oFormat){return t.oFormat.oFormatOptions.pattern}return undefined};v.prototype._getToolbarInteractive=function(){return true};function T(){return this.getAggregation("_picker")}v.prototype._isValidDate=function(e){return!e||Object.prototype.toString.call(e)==="[object Date]"};function V(){if(this._getBoundValueTypePattern()){var e=this._getBoundValueTypePattern();var t=T.call(this);t=this._getPickerByTypeAndPattern(this.getType(),t,e);if(t.getValueFormat()!=e){t.setValueFormat(e)}if(t.getDisplayFormat()!=e){t.setDisplayFormat(e)}}}function b(e){var t=e.getParameter("value");var a;var r=e.getParameter("valid");this.setProperty("value",t,true);if(r){a=e.oSource.getDateValue();this.setProperty("dateValue",a,true)}this.fireChange({value:t,newValue:t,valid:r,dateValue:a,newDateValue:a})}return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DateTimeInputRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,r){e.openStart("div",r);e.class("sapMDTI");var i=r.getWidth();if(i){e.style("width",i)}e.openEnd();var t=r.getAggregation("_picker");if(t){e.renderControl(t)}e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DateTimePicker", ["sap/ui/thirdparty/jquery","./InputBase","./DatePicker","sap/ui/model/type/Date","./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/Device","sap/ui/core/format/DateFormat","sap/ui/core/LocaleData","sap/ui/core/Core","sap/ui/core/format/TimezoneUtil","./TimePickerClocks","./DateTimePickerRenderer","./SegmentedButton","./SegmentedButtonItem","./ResponsivePopover","./Button","sap/ui/core/IconPool","sap/ui/core/Theming","sap/ui/core/Configuration","sap/ui/core/date/UI5Date","sap/ui/dom/jquery/cursorPos"],function(jQuery,e,t,i,o,s,n,a,r,p,l,u,h,g,c,d,f,m,_,y,T,C){"use strict";var P=o.PlacementType,S=o.ButtonType,D="Phone";var v=t.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",properties:{minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1},showCurrentTimeButton:{type:"boolean",group:"Behavior",defaultValue:false},showTimezone:{type:"boolean",group:"Behavior"},timezone:{type:"string",group:"Data"},showFooter:{type:"boolean",group:"Misc",defaultValue:false}},designtime:"sap/m/designtime/DateTimePicker.designtime",dnd:{draggable:false,droppable:true}},constructor:function(e,i,o){var s;if(typeof e!=="string"&&e!==undefined){o=i;i=e;e=i&&i.id}s=i?Object.keys(i).sort(function(e,t){if(e==="timezone"){return-1}else if(t==="timezone"){return 1}return 0}).reduce(function(e,t){e[t]=i[t];return e},{}):i;t.call(this,e,s,o)},renderer:g});var z={Short:"short",Medium:"medium",Long:"long",Full:"full"};var w=n.extend("sap.m.internal.DateTimePickerPopup",{metadata:{library:"sap.m",properties:{forcePhoneView:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},clocks:{type:"sap.ui.core.Control",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t);e.class("sapMDateTimePopupCont").class("sapMTimePickerDropDown");e.openEnd();var i=t.getAggregation("_switcher");if(i){e.openStart("div");e.class("sapMTimePickerSwitch");e.openEnd();e.renderControl(i);e.close("div")}var o=t.getCalendar();if(o){e.renderControl(o)}e.openStart("div");e.class("sapMTimePickerSep");e.openEnd();e.close("div");var s=t.getClocks();if(s){e.renderControl(s)}e.close("div")}},init:function(){},onBeforeRendering:function(){var e=this.getAggregation("_switcher");if(!e){var t=l.getLibraryResourceBundle("sap.m");var i=t.getText("DATETIMEPICKER_DATE");var o=t.getText("DATETIMEPICKER_TIME");e=new c(this.getId()+"-Switch",{selectedKey:"Cal",items:[new d(this.getId()+"-Switch-Cal",{key:"Cal",text:i}),new d(this.getId()+"-Switch-Clk",{key:"Clk",text:o})]});e.attachSelectionChange(this._handleSelectionChange,this);this.setAggregation("_switcher",e)}if(a.system.phone||jQuery("html").hasClass("sapUiMedia-Std-Phone")||this.getForcePhoneView()){e.setVisible(true);e.setSelectedKey("Cal");this.getCalendar().attachSelect(function(){this._addCalendarDelegate()}.bind(this));this._addCalendarDelegate()}else{e.setVisible(false)}},_addCalendarDelegate:function(){var e=this.getAggregation("_switcher"),t={onAfterRendering:function(){this._switchVisibility(e.getSelectedKey());this.getCalendar().removeDelegate(t)}.bind(this)};this.getCalendar().addDelegate(t)},_handleSelectionChange:function(e){var t=e.getParameter("item").getKey();this._switchVisibility(t);if(t==="Clk"){this.getClocks()._focusActiveButton()}},_switchVisibility:function(e){var t=this.getCalendar(),i=this.getClocks();if(!t||!i){return}if(e==="Cal"){t.$().css("display","");i.$().css("display","none");t.getFocusDomRef()&&t.getFocusDomRef().focus()}else{t.$().css("display","none");i.$().css("display","")}},switchToTime:function(){var e=this.getAggregation("_switcher");if(e&&e.getVisible()){e.setSelectedKey("Clk");this._switchVisibility("Clk")}},getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates()}});v.prototype.init=function(){t.prototype.init.apply(this,arguments);this._bOnlyCalendar=false};v.prototype.setShowFooter=function(){return this};v.prototype.setTimezone=function(e){var t,i,o;if(this.getTimezone()===e){return this}this.setProperty("timezone",e);if(this._oTimezonePopup){this._oTimezonePopup.setTitle(this._getTranslatedTimezone(true))}if(this._isTimezoneBinding()){t=this.getDateValue()||this._parseValue(this.getValue(),false);i=this._formatValue(t,false);o=this._parseValue(i,true);if(o){this.setProperty("dateValue",o);this.setProperty("value",this._formatValue(o,true))}}return this};v.prototype.ontap=function(e){if(e.target.parentElement.classList.contains("sapMDTPTimezoneLabel")){this._togglePopoverOpen(this._getTimezoneNamePopup(),e.target);return}t.prototype.ontap.apply(this,arguments)};v.prototype.onAfterRendering=function(){t.prototype.onAfterRendering.apply(this,arguments);if(this._getShowTimezone()){y.attachApplied(this._adjustInnerMaxWidth.bind(this))}};v.prototype._formatValueAndUpdateOutput=function(e,t){delete this._prefferedValue;var i=e?this._formatValue(e):t;if(!e){var o=this._fallbackParse(t);if(typeof o==="string"){this._bValid=true;this._prefferedValue=o;i=o}}if(!this.getDomRef()){return}if(this._bPreferUserInteraction){this.handleInputValueConcurrency(i)}else if(this._$input.val()!==i){this._$input.val(i);this._curpos=this._$input.cursorPos()}};v.prototype._fallbackParse=function(e){return this._getFallbackParser().parse(e)?"":null};v.prototype._getFallbackParser=function(){if(!this._fallbackParser){this._fallbackParser=r.getDateTimeWithTimezoneInstance({showDate:false,showTime:false,showTimezone:true})}return this._fallbackParser};v.prototype.getIconSrc=function(){return _.getIconURI("date-time")};v.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oClocks){this._oClocks.destroy();delete this._oClocks}this._oTimezonePopup=undefined;this._oPopupContent=undefined;y.detachApplied(this._adjustInnerMaxWidth);a.media.detachHandler(this._handleWindowResize,this)};v.prototype.setDisplayFormat=function(e){t.prototype.setDisplayFormat.apply(this,arguments);if(this._oClocks){this._oClocks.setValueFormat(I.call(this));this._oClocks.setDisplayFormat(I.call(this))}return this};v.prototype.setMinutesStep=function(e){this.setProperty("minutesStep",e,true);if(this._oClocks){this._oClocks.setMinutesStep(e)}return this};v.prototype._getDefaultValueStyle=function(){return z.Medium};v.prototype.setMinDate=function(e){t.prototype.setMinDate.call(this,e);if(e){this._oMinDate.setHours(e.getHours(),e.getMinutes(),e.getSeconds())}return this};v.prototype.setMaxDate=function(e){t.prototype.setMaxDate.call(this,e);if(e){this._oMaxDate.setHours(e.getHours(),e.getMinutes(),e.getSeconds())}return this};v.prototype.setSecondsStep=function(e){this.setProperty("secondsStep",e,true);if(this._oClocks){this._oClocks.setSecondsStep(e)}return this};v.prototype.setShowCurrentTimeButton=function(e){var t=this._oClocks;t&&t.setShowCurrentTimeButton(e);return this.setProperty("showCurrentTimeButton",e)};v.prototype._adjustInnerMaxWidth=function(){var e=this.$().find(".sapMDummyContent"),t;if(!e||!e.length){return}t=e[0].getBoundingClientRect().width;this.$("inner").css("max-width",t+2+"px")};v.prototype._getTimezoneNamePopup=function(){var e;if(this._oTimezonePopup){this._oTimezonePopup.setTitle(this._getTranslatedTimezone(true));return this._oTimezonePopup}this._oTimezonePopup=new f({showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:3,horizontalScrolling:false,title:this._getTimezone(true)});this.addDependent(this._oTimezonePopup);if(a.system.phone){e=l.getLibraryResourceBundle("sap.m");this._oTimezonePopup.setEndButton(new m({text:e.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),type:S.Emphasized,press:function(){this._oTimezonePopup.close()}.bind(this)}))}return this._oTimezonePopup};v.prototype._getFormatInstance=function(e){return r.getDateTimeInstance(e)};v.prototype._togglePopoverOpen=function(e,t){if(e.isOpen()){e.close()}else{e.openBy(t||this.getDomRef())}};v.prototype._getFormatterWithTimezoneInstance=function(e){var t=this._getTimezoneFormatterCacheName(e);if(!this[t]){this[t]=r.getDateTimeWithTimezoneInstance(this._getTimezoneFormatOptions(e))}return this[t]};v.prototype._getBindingFormatOptions=function(){var e=this.getBinding("value")||this.getBinding("dateValue"),t;if(e){t=e.getType()}if(this._isSupportedBindingType(t)){return jQuery.extend({},t.getFormatOptions())}};v.prototype._getTimezoneFormatOptions=function(e){var t=this._getBindingFormatOptions()||{},i=e?this.getDisplayFormat():this.getValueFormat(),o=this.getBinding("value")||this.getBinding("dateValue"),s=o&&o.getType&&o.getType();if(e||!this._getTimezone()||s&&!s.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])){t.showTimezone=false}if(!e&&s&&s.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])){t.showTimezone=true}if(t.relative===undefined){t.relative=false}if(t.calendarType===undefined){t.calendarType=e?this.getDisplayFormatType():T.getCalendarType()}if(t.strictParsing===undefined){t.strictParsing=true}if(i&&!this._isSupportedBindingType(s)){t[this._checkStyle(i)?"style":"pattern"]=i}t.showDate=true;t.showTime=true;return t};v.prototype._getTimezoneFormatterCacheName=function(e){return e?"_oDisplayFormatWithTimezone":"_oValueFormatWithTimezone"};v.prototype._getShowTimezone=function(){var e=this.getBinding("value")||this.getBinding("dateValue"),t=e&&e.getType();if(this.getShowTimezone()===undefined&&t&&t.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])){return t.getFormatOptions().showTimezone!==false}return this.getShowTimezone()};v.prototype._getTimezone=function(e){var t=this.getBinding("value")||this.getBinding("dateValue"),i=t&&t.getType();if(!this.getTimezone()&&i&&i.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])&&t.aValues[1]){return t.aValues[1]}return this.getTimezone()||e&&l.getConfiguration().getTimezone()};v.prototype._getTranslatedTimezone=function(e){return p.getInstance(l.getConfiguration().getFormatSettings().getFormatLocale()).getTimezoneTranslations()[this._getTimezone(e)]};v.prototype._checkStyle=function(e){if(t.prototype._checkStyle.apply(this,arguments)){return true}else if(e.indexOf("/")>0){var i=[z.Short,z.Medium,z.Long,z.Long];var o=false;for(var s=0;s<i.length;s++){var n=i[s];for(var a=0;a<i.length;a++){var r=i[a];if(e==n+"/"+r){o=true;break}}if(o){break}}return o}return false};v.prototype._isTimezoneBinding=function(){var e=this.getBinding("value")||this.getBinding("dateValue"),t=e&&e.getType();return t&&t.isA(["sap.ui.model.odata.type.DateTimeWithTimezone"])};v.prototype._parseValue=function(e,i,o){if(this._isTimezoneBinding()){var s=this._getFormatterWithTimezoneInstance().parse(e,o||this._getTimezone(true));if(s){return s[0]}return null}return t.prototype._parseValue.apply(this,arguments)};v.prototype._formatValue=function(e,i,o){if(!e){return""}if(this._isTimezoneBinding()){return this._getFormatterWithTimezoneInstance(!i).format(e,o||this._getTimezone(true))}return t.prototype._formatValue.apply(this,arguments)};v.prototype._getPickerParser=function(){if(!this._isTimezoneBinding()){return t.prototype._getFormatter.apply(this,arguments)}if(!this._clocksParser){this._clocksParser=r.getDateTimeWithTimezoneInstance({showTimezone:false,calendarType:this.getDisplayFormatType()})}return this._clocksParser};v.prototype._getLocaleBasedPattern=function(e){var t=p.getInstance(l.getConfiguration().getFormatSettings().getFormatLocale()),i=e.indexOf("/");if(i>0){return t.getCombinedDateTimePattern(e.substr(0,i),e.substr(i+1))}else{return t.getCombinedDateTimePattern(e,e)}};v.prototype._createPopup=function(){var e,t,i,o,s,n;if(!this._oPopup){i=l.getLibraryResourceBundle("sap.m");o=i.getText("TIMEPICKER_SET");s=i.getText("TIMEPICKER_CANCEL");this._oPopupContent=new w(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oOKButton=new m(this.getId()+"-OK",{text:o,type:S.Emphasized,press:k.bind(this)});var r=this._getValueStateHeader();this._oPopup=new f(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:P.VerticalPreferedBottom,beginButton:this._oOKButton,content:[r,this._oPopupContent],afterOpen:b.bind(this),afterClose:V.bind(this)});r.setPopup(this._oPopup._oControl);if(a.system.phone){e=this.$("inner").attr("aria-labelledby");t=e?document.getElementById(e).textContent:"";this._oPopup.setTitle(t);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true)}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new m(this.getId()+"-Cancel",{text:s,press:B.bind(this)}))}this._oPopup.addStyleClass("sapMDateTimePopup");n=this._oPopup.getAggregation("_popup");if(n.setShowArrow){n.setShowArrow(false)}this.setAggregation("_popup",this._oPopup,true)}};v.prototype._openPopup=function(t){if(!this._oPopup){return}if(!t){t=this.getDomRef()}this.addStyleClass(e.ICON_PRESSED_CSS_CLASS);var i=this._oPopup.getAggregation("_popup");i.oPopup.setExtraContent([t]);this._oPopup.openBy(t||this)};v.prototype._createPopupContent=function(){var e=!this._oCalendar;t.prototype._createPopupContent.apply(this,arguments);if(e){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(F,this)}if(!this._oClocks){this._oClocks=new h(this.getId()+"-Clocks",{minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep(),valueFormat:I.call(this),displayFormat:I.call(this),localeId:this.getLocaleId(),showCurrentTimeButton:this.getShowCurrentTimeButton()});this._oPopupContent.setClocks(this._oClocks)}};v.prototype._attachAfterRenderingDelegate=function(){};v.prototype._selectFocusedDateValue=function(e){var t=this._oCalendar;t.removeAllSelectedDates();t.addSelectedDate(e);return this};v.prototype._fillDateRange=function(){var e=this.getDateValue(),t=true,i;if(e){e=C.getInstance(e.getTime());this._oOKButton.setEnabled(true)}else{t=false;e=this.getInitialFocusedDateValue();if(!e){e=C.getInstance();this._oCalendar.removeAllSelectedDates()}if(e.getTime()<this._oMinDate.getTime()){e=this._oMinDate}else if(e.getTime()>this._oMaxDate.getTime()){e=this._oMaxDate}this._oOKButton.setEnabled(false)}if(this._isTimezoneBinding()){i=this._getPickerParser().format(e,this._getTimezone(true));e=this._getPickerParser().parse(i)[0]}this._oCalendar.focusDate(e);if(t){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=e.getTime()){this._oDateRange.setStartDate(e)}}this._oClocks._setTimeValues(e)};v.prototype._getSelectedDate=function(){var e=t.prototype._getSelectedDate.apply(this,arguments),i,o,s,n;if(e){i=this._oClocks.getTimeValues();o=this._oClocks._getDisplayFormatPattern();if(o.search("h")>=0||o.search("H")>=0){e.setHours(i.getHours())}if(o.search("m")>=0){e.setMinutes(i.getMinutes())}if(o.search("s")>=0){e.setSeconds(i.getSeconds())}if(e.getTime()<this._oMinDate.getTime()){e=C.getInstance(this._oMinDate.getTime())}else if(e.getTime()>this._oMaxDate.getTime()){e=C.getInstance(this._oMaxDate.getTime())}}if(this._isTimezoneBinding()){s=this._getPickerParser().format(e);n=this._getPickerParser().parse(s,this._getTimezone(true));e=n&&n[0]}return e};v.prototype.getLocaleId=function(){return l.getConfiguration().getFormatSettings().getFormatLocale().toString()};v.prototype.getAccessibilityInfo=function(){var e=t.prototype.getAccessibilityInfo.apply(this,arguments);e.type=l.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return e};function k(e){this._handleCalendarSelect()}function B(e){this.onsaphide(e);if(!this.getDateValue()){this._oCalendar.removeAllSelectedDates()}}v.prototype._handleWindowResize=function(e){var t=this.getAggregation("_popup").getContent()[1].getAggregation("_switcher"),i=this.getAggregation("_popup").getContent()[1].getCalendar(),o=this.getAggregation("_popup").getContent()[1].getClocks();if(e.name===D){t.setVisible(true);this.getAggregation("_popup").getContent()[1]._switchVisibility(t.getSelectedKey())}else{t.setVisible(false);o.$().css("display","");i.$().css("display","")}};function b(e){this._oCalendar.focus();a.media.attachHandler(this._handleWindowResize,this);this.fireAfterValueHelpOpen()}function V(){this.removeStyleClass(e.ICON_PRESSED_CSS_CLASS);this._oCalendar._closePickers();a.media.detachHandler(this._handleWindowResize,this);this.fireAfterValueHelpClose()}function I(){var e=this.getDisplayFormat();var t;var o=this.getBinding("value");if(o&&o.oType&&o.oType instanceof i){e=o.oType.getOutputPattern()}else if(o&&o.oType&&o.oType.oFormat){e=o.oType.oFormat.oFormatOptions.pattern}else{e=this.getDisplayFormat()}if(!e){e=z.Medium}var s=e.indexOf("/");if(s>0&&this._checkStyle(e)){e=e.substr(s+1)}if(e==z.Short||e==z.Medium||e==z.Long||e==z.Full){var n=l.getConfiguration().getFormatSettings().getFormatLocale();var a=p.getInstance(n);t=a.getTimePattern(e)}else{t=e}return t}function F(e){this._oPopupContent.switchToTime();this._oPopupContent.getClocks()._focusActiveButton();this._oOKButton.setEnabled(true)}return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DateTimePickerRenderer", ["sap/ui/core/Renderer","./DatePickerRenderer","./DateTimeFieldRenderer","sap/ui/core/library","sap/ui/core/date/UI5Date"],function(e,t,n,a,r){"use strict";var i=e.extend(t);i.apiVersion=2;i.writeInnerValue=function(e,n){if(!n.getDateValue()&&typeof n._prefferedValue==="string"){e.attr("value",n._prefferedValue)}else{t.writeInnerValue.apply(this,arguments)}};i.getDescribedByAnnouncement=function(e){var t=n.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATETIMEPICKER_TYPE")+" "+t};i.getAccessibilityState=function(e){var n=t.getAccessibilityState.apply(this,arguments);if(e.getEditable()&&e.getEnabled()){n["haspopup"]=a.aria.HasPopup.Dialog.toLowerCase()}return n};i.writeAdditionalContent=function(e,t){var n=t._getTranslatedTimezone(true)||t._getTimezone(true);if(!t._getShowTimezone()){return}e.openStart("div",t.getId()+"-timezoneLabel");e.class("sapMDTPTimezoneLabel");e.openEnd();e.openStart("span",t.getId()+"-timezoneID");e.openEnd();e.text(n);e.close("span");e.close("div");e.openStart("span");e.class("sapMDummyContent");e.openEnd();e.text(t._getFormatter(true).format(r.getInstance(2e3,10,20,10,10,10)));e.close("span")};i.addOuterClasses=function(e,n){t.addOuterClasses(e,n);e.class("sapMDTP");if(n._getShowTimezone()){e.class("sapMDTPWithTimezone")}};i.getAriaDescribedBy=function(e){var t=n.getAriaDescribedBy.apply(this,arguments);if(e._getShowTimezone()){t+=" "+e.getId()+"-timezoneID"}return t};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Dialog", ["sap/ui/core/ControlBehavior","sap/base/i18n/Localization","sap/ui/core/Lib","./Bar","./InstanceManager","./AssociativeOverflowToolbar","./ToolbarSpacer","./Title","./library","sap/m/Image","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/RenderManager","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","sap/ui/core/theming/Parameters","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/Device","sap/ui/core/library","sap/ui/events/KeyCodes","./TitlePropagationSupport","./DialogRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/dom/units/Rem","sap/ui/dom/jquery/Focusable"],function(t,e,i,o,s,n,a,r,l,h,u,p,g,c,d,f,_,y,b,m,S,v,T,R,D,A,jQuery,I,C,B){"use strict";var M=v.OpenState;var P=l.ButtonType;var H=l.DialogType;var w=l.DialogRoleType;var O=v.ValueState;var x=v.TitleLevel;var z=l.TitleAlignment;var E=t.getAnimationMode();var F=E!==C.AnimationMode.none&&E!==C.AnimationMode.minimal;var L=F?300:10;var V=17;var W=B.toPx(1);var $=5;var N=3;var k=u.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:H.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:O.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"function",group:"Behavior",defaultValue:null},role:{type:"sap.m.DialogRoleType",group:"Data",defaultValue:w.Dialog,visibility:"hidden"},closeOnNavigation:{type:"boolean",group:"Behavior",defaultValue:true},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:z.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},footer:{type:"sap.m.Toolbar",multiple:false},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"},renderer:D});m.call(k.prototype,{header:{suffix:"header"},subHeader:{selector:".sapMDialogSubHeader .sapMIBar"},content:{selector:".sapMDialogScrollCont"},footer:{selector:".sapMDialogFooter .sapMIBar"}});R.call(k.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false});k._bPaddingByDefault=C.getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0;k._initIcons=function(){if(k._mIcons){return}k._mIcons={};k._mIcons[O.Success]=g.getIconURI("sys-enter-2");k._mIcons[O.Warning]=g.getIconURI("alert");k._mIcons[O.Error]=g.getIconURI("error");k._mIcons[O.Information]=g.getIconURI("information")};k._getHeaderToolbarAriaLabelledByText=function(){if(!k._oHeaderToolbarInvisibleText){k._oHeaderToolbarInvisibleText=new _("__headerActionsToolbar-invisibleText",{text:i.getResourceBundleFor("sap.m").getText("ARIA_LABEL_TOOLBAR_HEADER_ACTIONS")}).toStatic()}return k._oHeaderToolbarInvisibleText};k._getFooterToolbarAriaLabelledByText=function(){if(!k._oFooterToolbarInvisibleText){k._oFooterToolbarInvisibleText=new _("__footerActionsToolbar-invisibleText",{text:i.getResourceBundleFor("sap.m").getText("ARIA_LABEL_TOOLBAR_FOOTER_ACTIONS")}).toStatic()}return k._oFooterToolbarInvisibleText};k.prototype.init=function(){var t=this;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=e.getRTL();this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer","sap.m.SplitContainer","sap.m.MultiInput","sap.m.SimpleFixFlex"];this.oPopup=new c;this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");this.oPopup.setModal(true);this.oPopup.setAnimations(jQuery.proxy(this._openAnimation,this),jQuery.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(e,i){t._setDimensions();t._adjustScrollingPane();if(t._oManuallySetPosition){e.at={left:t._oManuallySetPosition.x,top:t._oManuallySetPosition.y}}else{e.at=t._calcPosition()}t._deregisterContentResizeHandler();c.prototype._applyPosition.call(this,e);t._registerContentResizeHandler()};if(k._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding")}this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement();this._oAriaDescribedbyText=new _({id:this.getId()+"-ariaDescribedbyText"})};k.prototype.onBeforeRendering=function(){this._loadVerticalMargin();var e=this._getAnyHeader();if(!k._bPaddingByDefault&&this.hasStyleClass("sapUiPopupWithPadding")){A.warning("Usage of CSS class 'sapUiPopupWithPadding' is deprecated. Use 'sapUiContentPadding' instead",null,"sap.m.Dialog")}if(this._hasSingleScrollableContent()){this.setVerticalScrolling(false);this.setHorizontalScrolling(false);A.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside")}else if(!this._oScroller){this._oScroller=new d(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()})}if(this._oScroller){this._oScroller.setVertical(this.getVerticalScrolling());this._oScroller.setHorizontal(this.getHorizontalScrolling())}this._createToolbarButtons();if(t.isAccessibilityEnabled()&&this.getState()!=O.None){if(!this._oValueState){this._oValueState=new _;this.setAggregation("_valueState",this._oValueState);this.addAriaLabelledBy(this._oValueState.getId())}this._oValueState.setText(this.getValueStateString(this.getState()))}if(e&&e.setTitleAlignment){e.setTitleAlignment(this.getTitleAlignment())}if(e&&this._getTitles(e).length===0){e._setRootAccessibilityRole("heading");e._setRootAriaLevel("2")}this._oAriaDescribedbyText.setText(this._getAriaDescribedByText())};k.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus()}};k.prototype.exit=function(){s.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null}if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._header){this._header.destroy();this._header=null}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null}if(this._iconImage){this._iconImage.destroy();this._iconImage=null}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null}if(this._oAriaDescribedbyText){this._oAriaDescribedbyText.destroy();this._oAriaDescribedbyText=null}};k.prototype.open=function(){var t=this.oPopup;t.setInitialFocusId(this.getId());var e=t.getOpenState();switch(e){case M.OPEN:case M.OPENING:return this;case M.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();t.attachOpened(this._handleOpened,this);this._iLastWidthAndHeightWithScroll=null;t.setContent(this);t.open();this._registerResizeHandler();s.addDialogInstance(this);return this};k.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass("sapDialogDisableTransition");this._deregisterResizeHandler();var t=this.oPopup;var e=this.oPopup.getOpenState();if(!(e===M.CLOSED||e===M.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});t.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;t.close();this._deregisterContentResizeHandler()}return this};k.prototype.isOpen=function(){return!!this.oPopup&&this.oPopup.isOpen()};k.prototype.setIcon=function(t){this._bHasCustomIcon=true;return this.setProperty("icon",t)};k.prototype.setState=function(t){var e;this.setProperty("state",t);if(this._bHasCustomIcon){return this}if(t===O.None){e=""}else{k._initIcons();e=k._mIcons[t]}this.setProperty("icon",e);return this};k.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen()};k.prototype._handleClosed=function(){if(!this.oPopup){return}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){f.preserveContent(this.getDomRef());this.$().remove()}s.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open()}};k.prototype.onfocusin=function(t){var e=t.target;if(e.id===this.getId()+"-firstfe"){var i=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef()||this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef();if(i){i.focus()}}else if(e.id===this.getId()+"-lastfe"){var o=this._getFocusableHeader()||this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef()||this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef()||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(o){o.focus()}}};k.prototype._getPromiseWrapper=function(){var t=this;return{reject:function(){t.currentPromise.reject()},resolve:function(){t.currentPromise.resolve()}}};k.prototype.onsapescape=function(t){var e=this.getEscapeHandler(),i={},o=this;if(this._isSpaceOrEnterPressed){return}if(t.originalEvent&&t.originalEvent._sapui_handledByControl){return}this._oCloseTrigger=null;if(typeof e==="function"){new Promise(function(t,s){i.resolve=t;i.reject=s;o.currentPromise=i;e(o._getPromiseWrapper())}).then(function(t){o.close()}).catch(function(){A.info("Disallow dialog closing")})}else{this.close()}t.stopPropagation()};k.prototype.onkeyup=function(t){if(this._isSpaceOrEnter(t)){this._isSpaceOrEnterPressed=false}};k.prototype.onkeydown=function(t){if(this._isSpaceOrEnter(t)){this._isSpaceOrEnterPressed=true}var e=t.which||t.keyCode;if((t.ctrlKey||t.metaKey)&&e===T.ENTER){var i=this._findFirstPositiveButton();if(i){i.firePress();t.stopPropagation();t.preventDefault();return}}this._handleKeyboardDragResize(t)};k.prototype._findFirstPositiveButton=function(){var t;if(this.getFooter()){t=this.getFooter().getContent().filter(function(t){return t.isA("sap.m.Button")})}else{t=this.getButtons()}for(var e=0;e<t.length;e++){var i=t[e];if(i.getType()===P.Accept||i.getType()===P.Emphasized){return i}}};k.prototype._handleKeyboardDragResize=function(t){if(t.target!==this._getFocusableHeader()||[T.ARROW_LEFT,T.ARROW_RIGHT,T.ARROW_UP,T.ARROW_DOWN].indexOf(t.keyCode)===-1){return}if(!this.getResizable()&&t.shiftKey||!this.getDraggable()&&!t.shiftKey){return}var e=this._$dialog,i=this.getDomRef().getBoundingClientRect(),o={left:i.x,top:i.y},s=this._getAreaDimensions(),n=e.width(),a=e.height(),r=e.outerHeight(true),l=t.shiftKey,h,u;this._bDisableRepositioning=true;e.addClass("sapDialogDisableTransition");if(l){this._oManuallySetSize=true;this.$("cont").height("").width("")}switch(t.keyCode){case T.ARROW_LEFT:if(l){n-=W}else{o.left-=W}break;case T.ARROW_RIGHT:if(l){n+=W}else{o.left+=W}break;case T.ARROW_UP:if(l){a-=W}else{o.top-=W}break;case T.ARROW_DOWN:if(l){a+=W}else{o.top+=W}break}if(l){u=s.bottom-o.top-r+a;if(t.keyCode===T.ARROW_DOWN){u-=W}h={width:Math.min(n,s.right-o.left),height:Math.min(a,u)}}else{h={left:Math.min(Math.max(s.left,o.left),s.right-n),top:Math.min(Math.max(s.top,o.top),s.bottom-r)}}e.css(h)};k.prototype._isSpaceOrEnter=function(t){var e=t.which||t.keyCode;return e==T.SPACE||e==T.ENTER};k.prototype._openAnimation=function(t,e,i){t.addClass("sapMDialogOpen");setTimeout(i,L)};k.prototype._closeAnimation=function(t,e,i){t.removeClass("sapMDialogOpen");setTimeout(i,L)};k.prototype._setDimensions=function(){var t=this.$(),e=this.getStretch(),i=this.getStretchOnPhone()&&S.system.phone,o=this.getType()===H.Message,s={};if(!e){if(!this._oManuallySetSize){s.width=this.getContentWidth()||undefined;s.height=this.getContentHeight()||undefined}else{s.width=this._oManuallySetSize.width;s.height=this._oManuallySetSize.height}}if(s.width=="auto"){s.width=undefined}if(s.height=="auto"){s.height=undefined}if(e&&!o||i){this.$().addClass("sapMDialogStretched")}t.css(s);t.css(this._calcMaxSizes());if(!this._oManuallySetSize&&!this._bDisableRepositioning){t.css(this._calcPosition())}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){t.find("> footer").css({bottom:"0.001px"})}};k.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh()}};k.prototype._onResize=function(){var t=this.$(),e=this.$("cont"),i=this.getContentWidth(),o=this._calcMaxSizes().maxWidth;if(this._oManuallySetSize){e.css({width:"auto"});return}if(S.system.desktop&&!S.browser.chrome){var s=e.width()+"x"+e.height(),n=t.css("min-width")!==t.css("width");if(s!==this._iLastWidthAndHeightWithScroll&&n){if(this._hasVerticalScrollbar()&&(!i||i=="auto")&&!this.getStretch()&&e.width()<o){t.addClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":V});this._iLastWidthAndHeightWithScroll=s}else{t.removeClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null}}else if(!this._hasVerticalScrollbar()||!n){t.removeClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null}}if(!this._oManuallySetSize&&!this._bDisableRepositioning){this._positionDialog()}};k.prototype._hasVerticalScrollbar=function(){var t=this.$("cont");return t[0].clientHeight<t[0].scrollHeight};k.prototype._positionDialog=function(){var t=this.$();t.css(this._calcMaxSizes());t.css(this._calcPosition())};k.prototype._calcPosition=function(){var t=this._getAreaDimensions(),e=this.$(),i,o,s;if(S.system.phone&&this.getStretch()){i=0;o=0}else if(this.getStretch()){i=this._percentOfSize(t.width,$);o=this._percentOfSize(t.height,N)}else{i=(t.width-e.outerWidth())/2;o=(t.height-e.outerHeight())/2}s={top:Math.round(t.top+o)};if(this._bRTL){s.right=Math.round(window.innerWidth-t.right+i)}else{s.left=Math.round(t.left+i)}return s};k.prototype._calcMaxSizes=function(){var t=this._getAreaDimensions(),e=this.$(),i=e.find(".sapMDialogTitleGroup").height()||0,o=e.find(".sapMDialogSubHeader").height()||0,s=e.find("> footer").height()||0,n=i+o+s,a,r;if(S.system.phone&&this.getStretch()){r=t.width;a=t.height-n}else{r=this._percentOfSize(t.width,100-2*$);a=this._percentOfSize(t.height,100-2*N)-n}return{maxWidth:Math.floor(r),maxHeight:Math.floor(a)}};k.prototype._getAreaDimensions=function(){var t=c.getWithinAreaDomRef(),e;if(t===window){e={left:0,top:0,width:t.innerWidth,height:t.innerHeight}}else{var i=t.getBoundingClientRect(),o=jQuery(t);e={left:i.left+parseFloat(o.css("border-left-width")),top:i.top+parseFloat(o.css("border-top-width")),width:t.clientWidth,height:t.clientHeight}}e.right=e.left+e.width;e.bottom=e.top+e.height;return e};k.prototype._percentOfSize=function(t,e){return Math.round(t*e/100)};k.prototype._createHeader=function(){if(!this._header){this._header=new o(this.getId()+"-header",{titleAlignment:this.getTitleAlignment(),ariaLabelledBy:k._getHeaderToolbarAriaLabelledByText()});this.setAggregation("_header",this._header)}};k.prototype._applyTitleToHeader=function(){var t=this.getProperty("title");if(this._headerTitle){this._headerTitle.setText(t)}else{this._headerTitle=new r(this.getId()+"-title",{text:t,level:x.H1}).addStyleClass("sapMDialogTitle");this._header.addContentMiddle(this._headerTitle)}};k.prototype._hasSingleScrollableContent=function(){var t=this.getContent();while(t.length===1&&t[0]instanceof u&&t[0].isA("sap.ui.core.mvc.View")){t=t[0].getContent()}if(t.length===1&&t[0]instanceof u&&t[0].isA(this._scrollContentList)){return true}return false};k.prototype._getFocusDomRef=function(){var t=this.getInitialFocus();if(t){return document.getElementById(t)}return this._getFocusableHeader()||this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElement()||this._getFirstVisibleButtonDomRef()||this.getDomRef()};k.prototype._getFirstVisibleButtonDomRef=function(){var t=this.getBeginButton(),e=this.getEndButton(),i=this.getButtons(),o;if(t&&t.getVisible()){o=t.getDomRef()}else if(e&&e.getVisible()){o=e.getDomRef()}else if(i&&i.length>0){for(var s=0;s<i.length;s++){if(i[s].getVisible()){o=i[s].getDomRef();break}}}return o};k.prototype._getFocusableHeader=function(){if(!this._isDraggableOrResizable()){return null}return this.$().find("header .sapMDialogTitleGroup")[0]};k.prototype._getFirstFocusableContentSubHeader=function(){var t=this.$().find(".sapMDialogSubHeader");return t.firstFocusableDomRef()};k.prototype._getFirstFocusableContentElement=function(){var t=this.$("cont");return t.firstFocusableDomRef()};k.prototype._setInitialFocus=function(){var t=this._getFocusDomRef(),e;if(t&&t.id){e=I.byId(t.id)}if(e){if(e.getVisible&&!e.getVisible()){this.focus();return}t=e.getFocusDomRef()}if(!t){this.setInitialFocus("");t=this._getFocusDomRef()}if(!this.getInitialFocus()){this.setAssociation("initialFocus",t?t.id:this.getId(),true)}if(S.system.desktop||t&&!/input|textarea|select/i.test(t.tagName)){if(t){t.focus()}}else{this.focus()}};k.prototype.getScrollDelegate=function(){return this._oScroller};k.prototype._isToolbarEmpty=function(){var t=this._oToolbar.getContent().filter(function(t){return t.getMetadata().getName()!=="sap.m.ToolbarSpacer"});return t.length===0};k.prototype._getAnyHeader=function(){var t=this.getCustomHeader();if(t){return t}else{var e=this.getShowHeader();if(!e){return null}this._createHeader();this._applyTitleToHeader();this._applyIconToHeader();return this._header}};k.prototype._deregisterResizeHandler=function(){var t=c.getWithinAreaDomRef();if(t===window){S.resize.detachHandler(this._onResize,this)}else{y.deregister(this._withinResizeListenerId);this._withinResizeListenerId=null}};k.prototype._registerResizeHandler=function(){var t=c.getWithinAreaDomRef();if(t===window){S.resize.attachHandler(this._onResize,this)}else{this._withinResizeListenerId=y.register(t,this._onResize.bind(this))}this._onResize()};k.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){y.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null}};k.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=y.register(this.getDomRef("scrollCont"),jQuery.proxy(this._onResize,this))}this._onResize()};k.prototype._attachHandler=function(t){var e=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){e._oCloseTrigger=this},onkeyup:function(){e._oCloseTrigger=this},onkeydown:function(){e._oCloseTrigger=this}}}if(t){t.addDelegate(this._oButtonDelegate,true,t)}};k.prototype._createToolbarButtons=function(){if(this.getFooter()){return}var t=this._getToolbar();var e=this.getButtons();var i=this.getBeginButton();var o=this.getEndButton(),s=this,n=[i,o];n.forEach(function(t){if(t&&s._oButtonDelegate){t.removeDelegate(s._oButtonDelegate)}});t.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new a}t.addContent(this._toolbarSpacer);n.forEach(function(t){s._attachHandler(t)});if(e&&e.length){e.forEach(function(e){t.addContent(e)})}else{if(i){t.addContent(i)}if(o){t.addContent(o)}}};k.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new n(this.getId()+"-footer",{ariaLabelledBy:k._getFooterToolbarAriaLabelledByText()}).addStyleClass("sapMTBNoBorders");this._oToolbar.addDelegate({onAfterRendering:function(){if(this.getType()===H.Message){this.$("footer").removeClass("sapContrast sapContrastPlus")}}},false,this);this.setAggregation("_toolbar",this._oToolbar)}return this._oToolbar};k.prototype.getValueStateString=function(t){var e=i.getResourceBundleFor("sap.m");switch(t){case O.Success:return e.getText("LIST_ITEM_STATE_SUCCESS");case O.Warning:return e.getText("LIST_ITEM_STATE_WARNING");case O.Error:return e.getText("LIST_ITEM_STATE_ERROR");case O.Information:return e.getText("LIST_ITEM_STATE_INFORMATION");default:return""}};k.prototype._isDraggableOrResizable=function(){return!this.getStretch()&&(this.getDraggable()||this.getResizable())};k.prototype._getAriaDescribedByText=function(){var t=i.getResourceBundleFor("sap.m");if(this.getResizable()&&this.getDraggable()){return t.getText("DIALOG_HEADER_ARIA_DESCRIBEDBY_DRAGGABLE_RESIZABLE")}if(this.getDraggable()){return t.getText("DIALOG_HEADER_ARIA_DESCRIBEDBY_DRAGGABLE")}if(this.getResizable()){return t.getText("DIALOG_HEADER_ARIA_DESCRIBEDBY_RESIZABLE")}return""};k.prototype._loadVerticalMargin=function(){N=b.get({name:"_sap_m_Dialog_VerticalMargin",callback:function(t){N=parseFloat(t)}});if(N){N=parseFloat(N)}else{N=3}};k.prototype.setSubHeader=function(t){this.setAggregation("subHeader",t);if(t){t.setVisible=function(e){t.setProperty("visible",e);this.invalidate()}.bind(this)}return this};k.prototype.setLeftButton=function(t){if(typeof t==="string"){t=I.byId(t)}this.setBeginButton(t);return this.setAssociation("leftButton",t)};k.prototype.setRightButton=function(t){if(typeof t==="string"){t=I.byId(t)}this.setEndButton(t);return this.setAssociation("rightButton",t)};k.prototype.getLeftButton=function(){var t=this.getBeginButton();return t?t.getId():null};k.prototype.getRightButton=function(){var t=this.getEndButton();return t?t.getId():null};k.prototype.setBeginButton=function(t){if(t&&t.isA("sap.m.Button")){t.addStyleClass("sapMDialogBeginButton")}return this.setAggregation("beginButton",t)};k.prototype.setEndButton=function(t){if(t&&t.isA("sap.m.Button")){t.addStyleClass("sapMDialogEndButton")}return this.setAggregation("endButton",t)};k.prototype.getAggregation=function(t,e,i){var o=u.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(t==="buttons"&&o&&o.length===0){this.getBeginButton()&&o.push(this.getBeginButton());this.getEndButton()&&o.push(this.getEndButton())}return o};k.prototype.getAriaLabelledBy=function(){var t=this._getAnyHeader(),e=this.getAssociation("ariaLabelledBy",[]).slice();var i=this.getSubHeader();if(i){var o=this._getTitles(i);if(o.length){e=o.map(function(t){return t.getId()}).concat(e)}}if(t){var s=this._getTitles(t);if(s.length){e=s.map(function(t){return t.getId()}).concat(e)}else{e.unshift(t.getId())}}return e};k.prototype._applyIconToHeader=function(){var t=this.getIcon();if(!t){if(this._iconImage){this._iconImage.destroy();this._iconImage=null}return}if(!this._iconImage){this._iconImage=g.createControlByURI({id:this.getId()+"-icon",src:t,useIconTooltip:false},h).addStyleClass("sapMDialogIcon");this._header.insertAggregation("contentMiddle",this._iconImage,0)}this._iconImage.setSrc(t)};k.prototype.setInitialFocus=function(t){return this.setAssociation("initialFocus",t,true)};k.prototype.invalidate=function(t){if(this.isOpen()){u.prototype.invalidate.call(this,t)}};function G(t){var e=jQuery(t);var i=p.closestTo(t);if(e.parents(".sapMDialogSection").length){return false}if(!i||i.isA("sap.m.IBar")){return true}return e.hasClass("sapMDialogTitleGroup")}if(S.system.desktop){k.prototype.ondblclick=function(t){if(G(t.target)){var e=this.$("cont");this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);e.css({height:"100%"})}};k.prototype.onmousedown=function(t){if(t.which===3){return}if(!this._isDraggableOrResizable()){return}var e;var i=this;var o=jQuery(document);var s=jQuery(t.target);var n=s.hasClass("sapMDialogResizeHandler")&&this.getResizable();var a=function(t){e=e?clearTimeout(e):setTimeout(function(){t()},0)};var r=this._getAreaDimensions();var l=this.getDomRef().getBoundingClientRect();var h={x:t.clientX,y:t.clientY,width:i._$dialog.width(),height:i._$dialog.height(),outerHeight:i._$dialog.outerHeight(),position:{x:l.x,y:l.y}};var u;function p(){var t=i.$(),e=i.$("cont"),s,a;o.off("mouseup",p);o.off("mousemove",u);if(n){i._$dialog.removeClass("sapMDialogResizing");s=parseInt(t.height());a=parseInt(t.css("border-top-width"))+parseInt(t.css("border-bottom-width"));e.height(s+a)}}if(G(t.target)&&this.getDraggable()||n){i._bDisableRepositioning=true;i._$dialog.addClass("sapDialogDisableTransition")}if(G(t.target)&&this.getDraggable()){u=function(e){e.preventDefault();if(e.buttons===0){p();return}a(function(){i._bDisableRepositioning=true;i._oManuallySetPosition={x:Math.max(r.left,Math.min(e.clientX-t.clientX+h.position.x,r.right-h.width)),y:Math.max(r.top,Math.min(e.clientY-t.clientY+h.position.y,r.bottom-h.outerHeight))};i._$dialog.css({top:i._oManuallySetPosition.y,left:i._oManuallySetPosition.x,right:i._bRTL?"":undefined})})}}else if(n){i._$dialog.addClass("sapMDialogResizing");var g={};var c=parseInt(i._$dialog.css("min-width"));var d=h.x+h.width-c;var f=s.width()-t.offsetX;var _=s.height()-t.offsetY;u=function(t){a(function(){i._bDisableRepositioning=true;i.$("cont").height("").width("");if(t.clientY+_>r.bottom){t.clientY=r.bottom-_}if(t.clientX+f>r.right){t.clientX=r.right-f}i._oManuallySetSize={width:h.width+t.clientX-h.x,height:h.height+t.clientY-h.y};if(i._bRTL){g.left=Math.min(Math.max(t.clientX,0),d);i._oManuallySetSize.width=h.width+h.x-Math.max(t.clientX,0)}g.width=i._oManuallySetSize.width;g.height=i._oManuallySetSize.height;i._$dialog.css(g)})}}else{return}o.on("mousemove",u);o.on("mouseup",p);t.stopPropagation()}}k.prototype._applyContextualSettings=function(){u.prototype._applyContextualSettings.call(this)};k.prototype._getTitles=function(t){return t.findAggregatedObjects(true,function(t){return t.isA("sap.m.Title")})};return k});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DialogRenderer", ["sap/m/library","sap/ui/Device","sap/ui/core/library","sap/ui/core/Lib"],function(e,a,o,s){"use strict";var t=e.DialogType;var i=e.DialogRoleType;var l=o.ValueState;var r={apiVersion:2};r._mStateClasses={};r._mStateClasses[l.None]="";r._mStateClasses[l.Success]="sapMDialogSuccess";r._mStateClasses[l.Warning]="sapMDialogWarning";r._mStateClasses[l.Error]="sapMDialogError";r._mStateClasses[l.Information]="sapMDialogInformation";r.render=function(o,n){var p=n.getId(),g=n._getAnyHeader(),c=n.getSubHeader(),d=n.getBeginButton(),D=n.getEndButton(),S=n.getState(),b=n.getStretch(),f=n.getStretchOnPhone()&&a.system.phone,C=n.getAggregation("_valueState"),M=n.getFooter();o.openStart("div",n).style("width",n.getContentWidth()).style("height",n.getContentHeight()).class("sapMDialog").class("sapMDialog-CTX").class("sapMPopup-CTX");if(n.isOpen()){o.class("sapMDialogOpen")}if(window.devicePixelRatio>1){o.class("sapMDialogHighPixelDensity")}if(n._bDisableRepositioning){o.class("sapMDialogTouched")}if(b||f){o.class("sapMDialogStretched")}o.class(r._mStateClasses[S]);var u=!n._oToolbar&&!d&&!D;var _=n._oToolbar&&n._isToolbarEmpty()&&!d&&!D;var v=n._oToolbar&&!n._oToolbar.getVisible();var y=!u&&!_&&!v||M;if(!y){o.class("sapMDialog-NoFooter")}if(!g){o.class("sapMDialog-NoHeader")}var h=n.getProperty("role");if(S===l.Error||S===l.Warning){h=i.AlertDialog}o.accessibilityState(n,{role:h,modal:true});if(c&&c.getVisible()){o.class("sapMDialogWithSubHeader");if(c.getDesign()==e.ToolbarDesign.Info){o.class("sapMDialogSubHeaderInfoBar")}}if(n.getType()===t.Message){o.class("sapMMessageDialog")}if(!n.getVerticalScrolling()){o.class("sapMDialogVerScrollDisabled")}if(!n.getHorizontalScrolling()){o.class("sapMDialogHorScrollDisabled")}if(a.system.phone){o.class("sapMDialogPhone")}if(n.getDraggable()&&!b){o.class("sapMDialogDraggable")}if(e._bSizeCompact){o.class("sapUiSizeCompact")}var E=n.getTooltip_AsString();if(E){o.attr("title",E)}o.attr("tabindex","-1");o.openEnd();if(a.system.desktop){if(n.getResizable()&&!b){o.icon("sap-icon://resize-corner",["sapMDialogResizeHandler"],{title:"","aria-label":""})}o.openStart("span",p+"-firstfe").class("sapMDialogFirstFE").attr("role","none").attr("tabindex","0").openEnd().close("span")}if(g||c){o.openStart("header").openEnd();if(g){g._applyContextClassFor("header");o.openStart("div").class("sapMDialogTitleGroup");if(n._isDraggableOrResizable()){o.attr("tabindex",0).accessibilityState(g,{role:"group",roledescription:s.getResourceBundleFor("sap.m").getText("DIALOG_HEADER_ARIA_ROLE_DESCRIPTION"),describedby:{value:n.getId()+"-ariaDescribedbyText",append:true}})}o.openEnd().renderControl(g).renderControl(n._oAriaDescribedbyText).close("div")}if(c&&c.getVisible()){c._applyContextClassFor("subheader");o.openStart("div").class("sapMDialogSubHeader").openEnd().renderControl(c).close("div")}o.close("header")}if(C){o.renderControl(C)}o.openStart("section",p+"-cont").class("sapMDialogSection").openEnd();o.openStart("div",p+"-scroll").class("sapMDialogScroll").openEnd();o.openStart("div",p+"-scrollCont").class("sapMDialogScrollCont");if(n.getStretch()||n.getContentHeight()){o.class("sapMDialogStretchContent")}o.openEnd();n.getContent().forEach(o.renderControl,o);o.close("div").close("div").close("section");if(y){o.openStart("footer").class("sapMDialogFooter").openEnd();if(M){M._applyContextClassFor("footer");o.renderControl(M)}else{n._oToolbar._applyContextClassFor("footer");o.renderControl(n._oToolbar)}o.close("footer")}if(a.system.desktop){o.openStart("span",p+"-lastfe").class("sapMDialogLastFE").attr("role","none").attr("tabindex","0").openEnd().close("span")}o.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DisplayListItem", ["sap/ui/core/library","./library","./ListItemBase","./DisplayListItemRenderer"],function(e,t,r,a){"use strict";var i=e.TextDirection;var n=r.extend("sap.m.DisplayListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null},valueTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:i.Inherit}}},renderer:a});n.prototype.getContentAnnouncement=function(){return this.getLabel()+" "+this.getValue()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DisplayListItemRenderer", ["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(e,t,r){"use strict";var a=e.TextDirection;var n=t.extend(r);n.apiVersion=2;n.renderLIAttributes=function(e,t){e.class("sapMDLI")};n.renderLIContent=function(e,t){var r=t.getLabel();if(r){e.openStart("label");e.attr("for",t.getId()+"-value");e.class("sapMDLILabel");e.openEnd();e.text(r);e.close("label")}var n=t.getValue();if(n){e.openStart("div",t.getId()+"-value");e.class("sapMDLIValue");var i=t.getValueTextDirection();if(i!=a.Inherit){e.attr("dir",i.toLowerCase())}e.openEnd();e.text(n);e.close("div")}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DraftIndicator", ["sap/ui/core/Control","sap/m/Label","sap/m/library","./DraftIndicatorRenderer"],function(e,t,a,i){"use strict";var r=a.DraftIndicatorState;var o=e.extend("sap.m.DraftIndicator",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DraftIndicator.designtime",properties:{state:{type:"sap.m.DraftIndicatorState",group:"Behavior",defaultValue:r.Clear},minDisplayTime:{type:"int",group:"Behavior",defaultValue:1500}},aggregations:{_label:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}},renderer:i});var s=sap.ui.getCore().getLibraryResourceBundle("sap.m");o._oTEXTS={};o._oTEXTS[r.Saving]=s.getText("DRAFT_INDICATOR_SAVING_DRAFT");o._oTEXTS[r.Saved]=s.getText("DRAFT_INDICATOR_DRAFT_SAVED");o._oTEXTS[r.Clear]="";o.prototype.init=function(){this.aQueue=[];this.iDelayedCallId=null};o.prototype.exit=function(){this._resetDraftTimer()};o.prototype.setState=function(e){this.setProperty("state",e);this._addToQueue(e);if(e===r.Saving){this._addToQueue(r.Clear)}return this};o.prototype._getLabel=function(){var e=this.getAggregation("_label");if(!e){var e=new t({id:this.getId()+"-label"});this.setAggregation("_label",e,true);e=this.getAggregation("_label")}return e};o.prototype.showDraftSaving=function(){this._addToQueue(r.Saving);this._addToQueue(r.Clear)};o.prototype.showDraftSaved=function(){this._addToQueue(r.Saved)};o.prototype.clearDraftState=function(){this._addToQueue(r.Clear)};o.prototype._addToQueue=function(e){this.aQueue.push(e);this._processQueue()};o.prototype._processQueue=function(){if(this.iDelayedCallId){return}var e=this.aQueue.shift();var t=this.getMinDisplayTime();if(!e){return}this._applyState(e);if(e===r.Clear){this._proceed();return}this.iDelayedCallId=setTimeout(this._proceed.bind(this),t)};o.prototype._proceed=function(){this._resetDraftTimer();this._processQueue()};o.prototype._applyState=function(e){this._getLabel().setText(o._oTEXTS[e])};o.prototype._resetDraftTimer=function(){clearTimeout(this.iDelayedCallId);this.iDelayedCallId=null};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DraftIndicatorRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,r){e.openStart("div",r);e.class("sapMDraftIndicator");e.openEnd();var n=r._getLabel();e.renderControl(n);e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DynamicDate", ["sap/m/DynamicDateUtil","sap/ui/core/date/UI5Date","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/base/util/each"],function(e,t,a,i,n,r,o){"use strict";var s=a.extend("sap.m.DynamicDate",{constructor:function(){this.sName="DynamicDate";a.apply(this,arguments)}});s.prototype.formatValue=function(t){var a={};if(!t){return}a.operator=t.operator;a.values=t.values.slice(0);var i=e.getOption(t.operator).getValueTypes();a.values=a.values.map(function(e,t){if(i[t]==="date"||i[t]==="datetime"){return u.parse(e)}return e},this);return a};s.prototype.parseValue=function(t){var a={},i;if(!t){return}if(t.operator==="PARSEERROR"){throw new n(t.values[0])}a.operator=t.operator;a.values=t.values.slice(0);i=e.getOption(t.operator).getValueTypes();a.values=a.values.map(function(e,t){if(i[t]==="date"||i[t]==="datetime"){return u.format(e)}return e},this);return a};s.prototype.validateValue=function(a){if(this.oConstraints){var i=sap.ui.getCore().getLibraryResourceBundle(),n=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=[],u=[],p=e.getOption(a.operator),m=p.toDates(this.formatValue(a)).map(function(e){return e.getTime()});if(m[0]===m[1]){m.length=1}m.forEach(function(e,a){var r="DynamicDate.Invalid"+(a===0?"Start":"End");o(this.oConstraints,function(a,o){switch(a){case"minimum":if(e<o){s.push("minimum");u.push(n.getText(r,[t.getInstance(e).toDateString()]));u.push(i.getText("Date.Minimum",[t.getInstance(o).toDateString()]))}break;case"maximum":if(e>o){s.push("maximum");u.push(n.getText(r,[t.getInstance(e).toDateString()]));u.push(i.getText("Date.Maximum",[t.getInstance(o).toDateString()]))}break}})},this);if(s.length>0){throw new r(this.combineMessages(u),s)}}};var u={format:function(e){if(e instanceof Date){return e.getTime()}return null},parse:function(e){if(isNaN(e)){throw new i("Cannot format date: "+e+" is not a valid Timestamp")}else if(typeof e!=="number"){e=parseInt(e)}e=t.getInstance(e);return e}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DynamicDateFormat", ["sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/core/format/NumberFormat","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/base/util/deepExtend","sap/ui/unified/calendar/CalendarUtils","./library","sap/ui/core/Configuration"],function(t,e,a,r,n,i,o,s,m){"use strict";var u=function(){throw new Error};var c=sap.ui.getCore().getLibraryResourceBundle("sap.m");var l={};var T={};var f={DATE:["date"],DATETIME:["datetime"],DATERANGE:["date","date"],DATETIMERANGE:["datetime","datetime"],LASTMINUTES:["int"],LASTHOURS:["int"],LASTDAYS:["int"],LASTWEEKS:["int"],LASTMONTHS:["int"],LASTQUARTERS:["int"],LASTYEARS:["int"],NEXTMINUTES:["int"],NEXTHOURS:["int"],NEXTDAYS:["int"],NEXTWEEKS:["int"],NEXTMONTHS:["int"],NEXTQUARTERS:["int"],NEXTYEARS:["int"],FROM:["date"],TO:["date"],FROMDATETIME:["datetime"],TODATETIME:["datetime"],SPECIFICMONTH:["month"],SPECIFICMONTHINYEAR:["month","int"],TODAYFROMTO:["int","int"]};var E=Object.keys(s.StandardDynamicDateRangeKeys);for(var d=0;d<E.length;d++){var O=E[d];var p=c.getText("DYNAMIC_DATE_"+O.toUpperCase()+"_FORMAT");var F=p.split("{").map(function(t){var e=t.indexOf("}");if(e!==-1){return t.slice(e+1)}return t});l[O]=F;var A=[];var D=p.indexOf("{");var h=-1;var g=-1;while(D!==-1){h=p.indexOf("}");g=parseInt(p.slice(D+1,h-h-1));A.push(g);p=p.slice(h+1);D=p.indexOf("{")}T[O]=A}u.getInstance=function(t,e){return this.createInstance(t,e)};u.oDefaultDynamicDateFormat={date:{},datetime:{},month:{pattern:"MMMM"},year:{pattern:"yyyy"},int:{}};u.createInstance=function(t,o){var s=Object.create(this.prototype);if(t instanceof r){o=t;t=undefined}if(!o){o=m.getFormatSettings().getFormatLocale()}s.oLocale=o;s.oLocaleData=n.getInstance(o);s.oOriginalFormatOptions=i({},u.oDefaultDynamicDateFormat,t);s._dateFormatter=e.getInstance(s.oOriginalFormatOptions["date"]);s._dateTimeFormatter=e.getDateTimeInstance(s.oOriginalFormatOptions["datetime"]);[s._dateFormatter].concat(s._dateFormatter.aFallbackFormats).forEach(function(t){t.parseRelative=function(){return null}});[s._dateTimeFormatter].concat(s._dateTimeFormatter.aFallbackFormats).forEach(function(t){t.parseRelative=function(){return null}});s._monthFormatter=e.getInstance(s.oOriginalFormatOptions["month"]);s._yearFormatter=e.getInstance(s.oOriginalFormatOptions["year"]);s._numberFormatter=a.getInstance(s.oOriginalFormatOptions["int"]);s._resourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");return s};u.prototype.format=function(e,a){var r=e.operator,n=e.values.slice(0);if(r==="SPECIFICMONTH"){var i=t.getInstance();i.setMonth(n[0]);n[0]=this._monthFormatter.format(i)}else if(r==="SPECIFICMONTHINYEAR"){var i=t.getInstance();i.setMonth(n[0]);i.setYear(n[1]);n[0]=this._monthFormatter.format(i);n[1]=this._yearFormatter.format(i)}else if(r==="LASTDAYS"&&n[0]===1&&!a){r="YESTERDAY";n=[]}else if(r==="NEXTDAYS"&&n[0]===1&&!a){r="TOMORROW";n=[]}else if((r==="LASTDAYS"||r==="NEXTDAYS")&&n[0]===0){r="TODAY";n=[]}else if(r==="DATETIME"){n[0]=this._dateTimeFormatter.format(e.values[0])}else if(r==="TODAYFROMTO"){n[0]=-n[0];if(n[0]>n[1]){n=[n[1],n[0]]}}var o=n.map(function(t){var e=t;if(t.getJSDate){e=t.getJSDate()}if(e instanceof Date){if(r==="DATETIMERANGE"||r==="FROMDATETIME"||r==="TODATETIME"||r==="DATETIME"){return this._dateTimeFormatter.format(e)}return this._dateFormatter.format(e)}if(typeof e==="number"){return this._numberFormatter.format(e)}else{return e.toString()}},this);if(r==="TODAYFROMTO"){o.forEach(function(t,e,a){if(t==="0"){a[e]=(e===0?this.oLocaleData.getNumberSymbol("minusSign"):this.oLocaleData.getNumberSymbol("plusSign"))+t}else{a[e]=n[e]<0?t.toString():this.oLocaleData.getNumberSymbol("plusSign")+t}},this)}if(o.length===0){o=null}return this._resourceBundle.getText("DYNAMIC_DATE_"+r.toUpperCase()+"_FORMAT",o)};u.prototype.parse=function(e,a){var r,n=l[a],i="^"+n.join("(.*)")+"$",s=new RegExp(i,"i"),m=e.match(s);if(m){r={};r.values=[];for(var u=0;u<T[a].length;u++){var c=T[a][u];var E=f[a][c];var d;var O=m[u+1];switch(E){case"date":d=this._dateFormatter.parse(O);break;case"datetime":d=this._dateTimeFormatter.parse(O);break;case"month":var p=[0,1,2,3,4,5,6,7,8,9,10,11].map(function(e){var a=t.getInstance();a.setMonth(e);return this._monthFormatter.format(a)},this);var F=p.indexOf(O);d=F!==-1?F:null;break;case"int":d=this._numberFormatter.parse(O);break;case"string":d=O;break;default:break}if(d&&(E==="date"||E==="datetime")){try{o._checkYearInValidRange(d.getFullYear())}catch(t){d=null}}if(!d&&d!==0){r=null;break}r.values[c]=d}if(a==="TODAYFROMTO"&&r){if(r.values[0]>r.values[1]){r.values=[r.values[1],r.values[0]]}r.values[0]=-r.values[0]}if(r){r.operator=a;return r}}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DynamicDateOption", ["sap/ui/core/date/UI5Date","sap/ui/core/Element","./Label","./StepInput","./DateTimePicker","sap/ui/unified/Calendar","sap/ui/unified/DateRange","sap/ui/unified/calendar/MonthPicker","sap/ui/unified/calendar/CustomMonthPicker","sap/ui/core/format/TimezoneUtil"],function(e,t,a,r,n,o,i,s,c,u){"use strict";var l=t.extend("sap.m.DynamicDateOption",{metadata:{library:"sap.m",properties:{key:{type:"string"},valueTypes:{type:"string[]"}}}});l.prototype.getText=function(e){return this.getKey()};l.prototype.getValueHelpUITypes=function(e){throw new Error("Need implementation for method getValueHelpUITypes. Option: "+this.getKey())};l.prototype.createValueHelpUI=function(e,t){var r=e.getValue()&&Object.assign({},e.getValue()),n=this.getValueHelpUITypes(e),o=n.length,i=[],s;if(!e.aControlsByParameters){e.aControlsByParameters={}}e.aControlsByParameters[this.getKey()]=[];if(r&&r.values){r.values=r.values.map(function(e){return e})}for(var c=0;c<n.length;c++){if(n[c].getText()){i.push(new a({text:n[c].getText(),width:"100%"}))}s=this._createControl(c,n[c].getType(),r,t,o);i.push(s);e.aControlsByParameters[this.getKey()].push(s)}return i};l.prototype.validateValueHelpUI=function(e){var t=this.getValueHelpUITypes();for(var a=0;a<t.length;a++){var r=e.aControlsByParameters[this.getKey()][a];switch(t[a].getType()){case"int":if(r._isLessThanMin(r.getValue())||r._isMoreThanMax(r.getValue())){return false}break;case"month":case"custommonth":case"date":case"daterange":if(!r.getSelectedDates()||r.getSelectedDates().length==0){return false}break;case"datetime":if(!r.getDateValue()){return false}break}}return true};l.prototype.getValueHelpOutput=function(e){var t=this.getValueHelpUITypes(),a={},r;a.operator=this.getKey();a.values=[];for(var n=0;n<t.length;n++){var o=e.aControlsByParameters[this.getKey()][n];switch(t[n].getType()){case"int":r=o.getValue();break;case"month":case"date":if(!o.getSelectedDates().length){return null}r=o.getSelectedDates()[0].getStartDate();break;case"custommonth":if(!o.getSelectedDates()||!o.getSelectedDates().length){return null}r=[o.getSelectedDates()[0].getStartDate().getMonth(),o.getSelectedDates()[0].getStartDate().getFullYear()];break;case"datetime":if(!o.getDateValue()){return null}r=o.getDateValue();break;case"daterange":if(!o.getSelectedDates().length){return null}var i=o.getSelectedDates()[0].getEndDate()||o.getSelectedDates()[0].getStartDate();r=[o.getSelectedDates()[0].getStartDate(),i];break;default:break}if(Array.isArray(r)){a.values=Array.prototype.concat.apply(a.values,r)}else{r&&a.values.push(r)}}return a};l.prototype.getGroup=function(){return 0};l.prototype.getGroupHeader=function(){var e=this.getGroup()>-1&&this.getGroup()<7?this.getGroup():0;return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DDR_OPTIONS_GROUP_"+e)};l.prototype.format=function(e){throw new Error("Need implementation for method format. Option: "+this.getKey())};l.prototype.parse=function(e){throw new Error("Need implementation for method parse. Option: "+this.getKey())};l.prototype.toDates=function(e){throw new Error("Need implementation for method toDates. Option: "+this.getKey())};l.prototype.enhanceFormattedValue=function(){return false};l.prototype._createControl=function(e,t,a,r,n){var o;switch(t){case"int":o=this._createIntegerControl(a,e,r);break;case"date":o=this._createDateControl(a,e,r);break;case"datetime":if(n===1){o=this._createDateTimeInnerControl(a,e,r)}else if(n===2){o=this._createDateTimeControl(a,e,r)}break;case"daterange":o=this._createDateRangeControl(a,e,r);break;case"month":o=this._createMonthControl(a,e,r);break;case"custommonth":o=this._createCustomMonthControl(a,e,r);break;default:break}return o};l.prototype._createIntegerControl=function(e,t,a){var n=new r({width:"120px"});if(e&&this.getKey()===e.operator){n.setValue(e.values[t])}if(a instanceof Function){n.attachChange(function(){a(this)},this)}return n};l.prototype._createDateTimeControl=function(e,t,a,r,o){var i=new n({timezone:u.getLocalTimezone(),calendarWeekNumbering:o});if(e&&this.getKey()===e.operator){i.setDateValue(e.values[t])}if(a instanceof Function){i.attachChange(function(){a(this)},this)}return i};l.prototype._createDateControl=function(t,a,r,n){var s=new o({width:"100%",calendarWeekNumbering:n});var c;if(t&&this.getKey()===t.operator){c=e.getInstance(t.values[a].getTime());s.addSelectedDate(new i({startDate:c}))}if(r instanceof Function){s.attachSelect(function(){r(this)},this)}return s};l.prototype._createDateTimeInnerControl=function(t,a,r,o){var s=new n({width:"100%",calendarWeekNumbering:o}),c;s._createPopup();s._createPopupContent();c=s._oPopupContent;c.setForcePhoneView(true);c.getCalendar().removeAllSelectedDates();if(t&&this.getKey()===t.operator){var u=e.getInstance(t.values[a]);c.getCalendar().addSelectedDate(new i({startDate:u}));c.getClocks()._setTimeValues(u)}if(r instanceof Function){c.getClocks().getAggregation("_clocks").forEach(function(e){e.attachChange(function(e){r(this)}.bind(this))}.bind(this));if(c.getClocks().getAggregation("_buttonAmPm")){c.getClocks().getAggregation("_buttonAmPm").attachSelectionChange(function(e){r(this)}.bind(this))}c.getCalendar().attachSelect(function(){r(this)},this)}return c};l.prototype._createDateRangeControl=function(t,a,r,n){var s=new o({intervalSelection:true,width:"100%",calendarWeekNumbering:n});if(t&&this.getKey()===t.operator){var c=e.getInstance(t.values[a].getTime());var u=e.getInstance(t.values[a+1].getTime());s.addSelectedDate(new i({startDate:c,endDate:u}))}if(r instanceof Function){s.attachSelect(function(){r(this)},this)}return s};l.prototype._createMonthControl=function(t,a,r){var n=new s,o=e.getInstance(),c=t&&this.getKey()===t.operator?t.values[a]:o.getMonth();n.setMonth(c);n.addSelectedDate(new i({startDate:o}));if(r instanceof Function){n.attachSelect(function(){r(this)},this)}return n};l.prototype._createCustomMonthControl=function(t,a,r){var n=new c,o=e.getInstance(),s=t&&a>=0&&this.getKey()===t.operator?t.values[a]:o.getMonth(),u=t&&a>=0&&this.getKey()===t.operator?t.values[a+1]:o.getFullYear();o.setDate(1);o.setMonth(s);o.setFullYear(u);n.addSelectedDate(new i({startDate:o}));if(r instanceof Function){n.attachSelect(function(){r(this)},this)}return n};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DynamicDateRange", ["sap/base/Log","sap/ui/core/InvisibleText","sap/ui/core/Element","sap/ui/core/Control","sap/ui/core/ListItem","sap/ui/core/library","sap/ui/core/Renderer","sap/ui/core/message/MessageMixin","sap/m/DynamicDateFormat","sap/ui/core/IconPool","sap/ui/core/Icon","sap/ui/core/LabelEnablement","sap/ui/core/date/UniversalDate","sap/ui/core/format/DateFormat","sap/ui/core/format/TimezoneUtil","sap/ui/base/ManagedObjectObserver","sap/ui/Device","./Label","./GroupHeaderListItem","./StandardListItem","./StandardListItemRenderer","./Button","./List","./Input","./InputRenderer","./Toolbar","./ResponsivePopover","./Page","./NavContainer","./DynamicDateRangeRenderer","./StandardDynamicDateOption","./library","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/unified/calendar/CalendarUtils","sap/ui/core/CustomData"],function(e,t,i,o,n,a,s,r,u,p,l,h,T,g,d,f,c,E,A,y,_,S,R,O,v,D,I,m,N,b,C,L,jQuery,M,Y,P){"use strict";var F=a.ValueState,H=L.ToolbarDesign,V=L.ToolbarStyle,w=L.ListType,U=L.ListMode,k=L.ListSeparators,G=sap.ui.getCore().getLibraryResourceBundle("sap.m");var x={TODAY:new C({key:"TODAY",valueTypes:[]}),YESTERDAY:new C({key:"YESTERDAY",valueTypes:[]}),TOMORROW:new C({key:"TOMORROW",valueTypes:[]}),FIRSTDAYWEEK:new C({key:"FIRSTDAYWEEK",valueTypes:[]}),LASTDAYWEEK:new C({key:"LASTDAYWEEK",valueTypes:[]}),FIRSTDAYMONTH:new C({key:"FIRSTDAYMONTH",valueTypes:[]}),LASTDAYMONTH:new C({key:"LASTDAYMONTH",valueTypes:[]}),FIRSTDAYQUARTER:new C({key:"FIRSTDAYQUARTER",valueTypes:[]}),LASTDAYQUARTER:new C({key:"LASTDAYQUARTER",valueTypes:[]}),FIRSTDAYYEAR:new C({key:"FIRSTDAYYEAR",valueTypes:[]}),LASTDAYYEAR:new C({key:"LASTDAYYEAR",valueTypes:[]}),THISWEEK:new C({key:"THISWEEK",valueTypes:[]}),THISMONTH:new C({key:"THISMONTH",valueTypes:[]}),THISQUARTER:new C({key:"THISQUARTER",valueTypes:[]}),THISYEAR:new C({key:"THISYEAR",valueTypes:[]}),LASTWEEK:new C({key:"LASTWEEK",valueTypes:[]}),LASTMONTH:new C({key:"LASTMONTH",valueTypes:[]}),LASTQUARTER:new C({key:"LASTQUARTER",valueTypes:[]}),LASTYEAR:new C({key:"LASTYEAR",valueTypes:[]}),NEXTWEEK:new C({key:"NEXTWEEK",valueTypes:[]}),NEXTMONTH:new C({key:"NEXTMONTH",valueTypes:[]}),NEXTQUARTER:new C({key:"NEXTQUARTER",valueTypes:[]}),NEXTYEAR:new C({key:"NEXTYEAR",valueTypes:[]}),LASTMINUTES:new C({key:"LASTMINUTES",valueTypes:["int"]}),LASTHOURS:new C({key:"LASTHOURS",valueTypes:["int"]}),LASTDAYS:new C({key:"LASTDAYS",valueTypes:["int"]}),LASTWEEKS:new C({key:"LASTWEEKS",valueTypes:["int"]}),LASTMONTHS:new C({key:"LASTMONTHS",valueTypes:["int"]}),LASTQUARTERS:new C({key:"LASTQUARTERS",valueTypes:["int"]}),LASTYEARS:new C({key:"LASTYEARS",valueTypes:["int"]}),NEXTMINUTES:new C({key:"NEXTMINUTES",valueTypes:["int"]}),NEXTHOURS:new C({key:"NEXTHOURS",valueTypes:["int"]}),NEXTDAYS:new C({key:"NEXTDAYS",valueTypes:["int"]}),NEXTWEEKS:new C({key:"NEXTWEEKS",valueTypes:["int"]}),NEXTMONTHS:new C({key:"NEXTMONTHS",valueTypes:["int"]}),NEXTQUARTERS:new C({key:"NEXTQUARTERS",valueTypes:["int"]}),NEXTYEARS:new C({key:"NEXTYEARS",valueTypes:["int"]}),FROM:new C({key:"FROM",valueTypes:["date"]}),TO:new C({key:"TO",valueTypes:["date"]}),FROMDATETIME:new C({key:"FROMDATETIME",valueTypes:["datetime"]}),TODATETIME:new C({key:"TODATETIME",valueTypes:["datetime"]}),YEARTODATE:new C({key:"YEARTODATE",valueTypes:[]}),DATETOYEAR:new C({key:"DATETOYEAR",valueTypes:[]}),TODAYFROMTO:new C({key:"TODAYFROMTO",valueTypes:["int","int"]}),QUARTER1:new C({key:"QUARTER1",valueTypes:[]}),QUARTER2:new C({key:"QUARTER2",valueTypes:[]}),QUARTER3:new C({key:"QUARTER3",valueTypes:[]}),QUARTER4:new C({key:"QUARTER4",valueTypes:[]}),SPECIFICMONTH:new C({key:"SPECIFICMONTH",valueTypes:["int"]}),SPECIFICMONTHINYEAR:new C({key:"SPECIFICMONTHINYEAR",valueTypes:["int","int"]}),DATERANGE:new C({key:"DATERANGE",valueTypes:["date","date"]}),DATE:new C({key:"DATE",valueTypes:["date"]}),DATETIME:new C({key:"DATETIME",valueTypes:["datetime"]}),DATETIMERANGE:new C({key:"DATETIMERANGE",valueTypes:["datetime","datetime"]})};var K=["DATE","TODAY","YESTERDAY","TOMORROW","FIRSTDAYWEEK","LASTDAYWEEK","FIRSTDAYMONTH","LASTDAYMONTH","FIRSTDAYQUARTER","LASTDAYQUARTER","FIRSTDAYYEAR","LASTDAYYEAR","DATERANGE","DATETIMERANGE","FROM","TO","FROMDATETIME","TODATETIME","YEARTODATE","DATETOYEAR","LASTMINUTES","LASTHOURS","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS","NEXTMINUTES","NEXTHOURS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS","TODAYFROMTO","THISWEEK","LASTWEEK","NEXTWEEK","SPECIFICMONTH","SPECIFICMONTHINYEAR","THISMONTH","LASTMONTH","NEXTMONTH","THISQUARTER","LASTQUARTER","NEXTQUARTER","QUARTER1","QUARTER2","QUARTER3","QUARTER4","THISYEAR","LASTYEAR","NEXTYEAR","DATETIME"];var X={SingleDates:1,DateRanges:2,Weeks:3,Month:4,Quarters:5,Years:6};var B=o.extend("sap.m.DynamicDateRange",{metadata:{library:"sap.m",properties:{value:{type:"object"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:F.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},required:{type:"boolean",group:"Misc",defaultValue:false},enableGroupHeaders:{type:"boolean",group:"Behavior",defaultValue:true},formatter:{type:"object"},standardOptions:{type:"string[]",group:"Behavior",defaultValue:["DATE","TODAY","YESTERDAY","TOMORROW","FIRSTDAYWEEK","LASTDAYWEEK","FIRSTDAYMONTH","LASTDAYMONTH","FIRSTDAYQUARTER","LASTDAYQUARTER","FIRSTDAYYEAR","LASTDAYYEAR","DATERANGE","DATETIMERANGE","FROM","TO","FROMDATETIME","TODATETIME","YEARTODATE","DATETOYEAR","LASTMINUTES","LASTHOURS","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS","NEXTMINUTES","NEXTHOURS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS","TODAYFROMTO","THISWEEK","LASTWEEK","NEXTWEEK","SPECIFICMONTH","SPECIFICMONTHINYEAR","THISMONTH","LASTMONTH","NEXTMONTH","THISQUARTER","LASTQUARTER","NEXTQUARTER","QUARTER1","QUARTER2","QUARTER3","QUARTER4","THISYEAR","LASTYEAR","NEXTYEAR","DATETIME"]},hideInput:{type:"boolean",group:"Misc",defaultValue:false},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null},showClearIcon:{type:"boolean",defaultValue:false}},aggregations:{customOptions:{type:"sap.m.DynamicDateOption",multiple:true},_input:{type:"sap.m.Input",multiple:false,visibility:"hidden"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"object"},valid:{type:"boolean"}}}}},renderer:b});r.call(B.prototype);var W=["LASTMINUTES","LASTHOURS"];var Q=["NEXTMINUTES","NEXTHOURS"];var j=W.concat(Q);var q=["LASTMINUTES","LASTHOURS","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS"];var z=["NEXTMINUTES","NEXTHOURS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS"];B.prototype.init=function(){var e=!c.support.touch||c.system.desktop?true:false;this._oInput=new $(this.getId()+"-input",{showValueHelp:true,valueHelpIconSrc:p.getIconURI("sap-icon://check-availability"),valueHelpRequest:this._toggleOpen.bind(this),showSuggestion:true,suggest:this._handleSuggest.bind(this)});this._oListItemDelegate=undefined;this._onBeforeInputRenderingDelegate={onBeforeRendering:function(){this._oInput._getValueHelpIcon().setVisible(true)}};this._oInput._getValueHelpIcon().setDecorative(e);this._oInput.addDelegate(this._onBeforeInputRenderingDelegate,this);this.setAggregation("_input",this._oInput,false);this._oInput._setControlOrigin(this);this._oInput.attachChange(this._handleInputChange,this);this.oValueObserver=new f(function(){delete this.oBoundValueFormatter}.bind(this));this.oValueObserver.observe(this,{bindings:["value"]})};B.prototype.exit=function(){this._oInput.removeDelegate(this._onBeforeInputRenderingDelegate);this._onBeforeInputRenderingDelegate=undefined;this.oValueObserver.destroy();this._infoDatesFooter=undefined;this.aInputControls=undefined;this._removeAllListItemDelegates()};B.prototype._removeAllListItemDelegates=function(){if(this._oOptionsList){this._oOptionsList.getItems().forEach(function(e){e.removeDelegate(this._oListItemDelegate)},this)}};B.prototype.getValue=function(){return this.getProperty("value")};B.prototype.getFormatter=function(){return this.getProperty("formatter")};B.prototype.setFormatter=function(e){this.setProperty("formatter",e);return this};B.prototype.setTooltip=function(e){this._oInput.setTooltip(e);return o.prototype.setTooltip.apply(this,arguments)};B.prototype.setShowClearIcon=function(e){this.setProperty("showClearIcon",e);this._oInput.setShowClearIcon(e);return this};B.prototype.onBeforeRendering=function(){this._updateInputValue(this.getValue());this._oInput.setEditable(this.getEditable());this._oInput.setEnabled(this.getEnabled());this._oInput.setRequired(this.getRequired());this._oInput.setName(this.getName());this._oInput.setWidth(this.getWidth());this._oInput.setPlaceholder(this.getPlaceholder());this._oInput.setValueState(this.getValueState());this._oInput.setValueStateText(this.getValueStateText());this.setValue(this._substituteMissingValue(this.getValue()))};B.prototype.setValue=function(e){var t=e&&e.operator;e=this._substituteValue(e);this.setProperty("value",e);this._oSelectedOption=this.getOption(t);this._updateInputValue(e);return this};B.prototype._toggleOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){this._closePopup()}else{this.open()}};B.prototype.open=function(e){if(this.getEditable()&&this.getEnabled()){this._createPopup();this._createPopupContent();if(!this._oListItemDelegate){this._oListItemDelegate={onsapshow:this._closePopup.bind(this),onsaphide:this._closePopup.bind(this)}}this._removeAllListItemDelegates();this._oOptionsList.destroyAggregation("items");this._collectValueHelpItems(this._getOptions(),true).map(function(e){if(typeof e==="string"){return this._createHeaderListItem(e)}if(e.getKey()==="FROMDATETIME"){e._bAdditionalTimeText=!!this._findOption("FROM")}else if(e.getKey()==="TODATETIME"){e._bAdditionalTimeText=!!this._findOption("TO")}else if(e.getKey()==="DATETIMERANGE"){e._bAdditionalTimeText=!!this._findOption("DATERANGE")}return this._createListItem(e)},this).forEach(function(e){e.addDelegate(this._oListItemDelegate,this);this._oOptionsList.addItem(e)},this);this._oNavContainer.to(this._oNavContainer.getPages()[0]);this._openPopup(e)}};B.prototype._findOption=function(e){return this._getOptions().find(function(t){return t.getKey()===e})};B.prototype.addStandardOption=function(e){var t=this.getStandardOptions();if(t.indexOf(e)===-1){t.push(e)}this.setStandardOptions(t)};B.prototype.getFocusDomRef=function(){return this.getAggregation("_input")&&this.getAggregation("_input").getFocusDomRef()};B.prototype._updateInputValue=function(e){var t;if(e&&e.operator!=="PARSEERROR"){t=this._enhanceInputValue(this._formatValue(e),e);this._oInput.setValue(t)}else if(e===undefined){this._oInput.setValue("")}};B.prototype._handleSuggest=function(e){this._bSuggestionMode=true;if(this._oPopup&&this._oPopup.isOpen()){this._closePopup()}var t=e.getParameter("suggestValue");this._oInput.removeAllSuggestionItems();var i=this._getOptions().filter(function(e){var i={operator:e.getKey(),values:[]},o=e.getValueHelpUITypes(this);if(o.length&&o[0].getType()){return false}var n=this.getOption(i.operator).format(i,this._getFormatter()).toLowerCase();var a=n.indexOf(t.toLowerCase());return a===0||a>0&&n[a-1]===" "},this);this._collectValueHelpItems(i,true).forEach(function(e){if(e.getKey){var t={operator:e.getKey(),values:[]};this._addSuggestionItem(t)}else{this._addSuggestionGroupItem(e)}},this);var o=t.match(/\d+/);if(!o){this._bSuggestionMode=false;return}i=this._getOptions().filter(function(e){return e.getValueHelpUITypes(this).length===1&&e.getValueHelpUITypes(this)[0].getType()==="int"},this);this._collectValueHelpItems(i,false).forEach(function(e){if(e.getKey){var t={operator:e.getKey(),values:[parseInt(o[0])]};this._addSuggestionItem(t)}else{this._addSuggestionGroupItem(e)}},this);this._bSuggestionMode=false};B.prototype.getOption=function(e){return this._getOptions().find(function(t){return t.getKey()===e})};B.prototype.toDates=function(e){var t=e.operator;return this.getOption(t).toDates(e,this.getCalendarWeekNumbering())};B.prototype._getGroups=function(){if(!this.oDynamicDateRangeGroups){this.oDynamicDateRangeGroups=JSON.parse(JSON.stringify(X))}return this.oDynamicDateRangeGroups};B.prototype._getCustomGroupHeader=function(e){var t=this._customGroupHeaders.find(t=>t.name===e);return t.header};B.prototype.addGroup=function(e,t){this._getGroups()[e]=Object.keys(this._getGroups()).length+1;if(!this._customGroupHeaders){this._customGroupHeaders=[]}this._customGroupHeaders.push({name:e,header:t})};B.prototype.setGroupHeader=function(e,t){this._customGroupHeaders.find(t=>t.name===e).header=t};B.prototype.removeCustomGroups=function(){const e=Object.keys(X).length;for(const t in this._getGroups()){if(this._getGroups()[t]>e){delete this._getGroups()[t]}}delete this._customGroupHeaders};B.prototype._getOptions=function(){var e=this.getStandardOptions();var t=e.map(function(e){return x[e]},this);var i=t.filter(Boolean);var o=this.getAggregation("customOptions");if(o){return i.concat(o)}return i};B.prototype._getValueHelpTypeForFormatter=function(){var e=this._oSelectedOption?this._oSelectedOption.getKey():"",t=q.indexOf(e),i=z.indexOf(e),o=this._oNavContainer?this._oNavContainer.getPages()[1].getContent()[3]||[]:[],n=o.getButtons?o.getButtons():[],a=this.getAggregation("_input").getAggregation("suggestionItems"),s=this.getValue(),r=this.getStandardOptions(),u="",p=[],l=[],h,T,g,d,f;if(!s&&(!n[0]||!n[0].getDomRef())&&a&&a.length&&a[a.length-1].getCustomData){h=a[a.length-1].getCustomData()[0]}if(this._bSuggestionMode&&a&&a.length&&a[a.length-1].getCustomData){h=a[a.length-1].getCustomData()[0]}r.forEach(function(e){if(q.indexOf(e)>-1){p.push(e)}else if(z.indexOf(e)>-1){l.push(e)}});if(h){f=h.getValue();t=W.indexOf(f);i=Q.indexOf(f)}if(h&&f){if(j.indexOf(f)>-1){g="datetime";return g}}if(this._oNavContainer&&!n.length||this._oNavContainer&&n.length&&(t>-1||i>-1)){d=n[0]?n[0].getParent().getSelectedIndex():0;if(W.indexOf(e)>-1){u=p[d]}else if(Q.indexOf(e)>-1){u=l[d]}if(j.indexOf(u)>-1){g="datetime";return g}}T=this._oSelectedOption?this._oSelectedOption.getValueHelpUITypes():[];return T&&T.length?T[0].getType():""};B.prototype._getDatesLabelFormatter=function(){var e,t=this._getValueHelpTypeForFormatter();switch(t){case"datetime":e=Object.create(this._getFormatter()._dateTimeFormatter.oFormatOptions);e.singleIntervalValue=true;e.interval=true;this._oDatesLabelFormatter=g.getDateTimeInstance(e);break;default:e=Object.create(this._getFormatter()._dateFormatter.oFormatOptions);e.singleIntervalValue=true;e.interval=true;this._oDatesLabelFormatter=g.getInstance(e)}return this._oDatesLabelFormatter};B.prototype._destroyInputControls=function(){if(!this.aInputControls){return}this.aInputControls.forEach(function(e){e.destroy()});this.aInputControls=undefined};B.prototype._addSuggestionItem=function(e){var t=this.toDates(e,this.getCalendarWeekNumbering());var i=[];for(var o=0;o<t.length;o++){i[o]=t[o]}var a=new n({text:this.getOption(e.operator).format(e,this._getFormatter()),additionalText:"",customData:[new P({key:"operator",value:e.operator})]});this._oInput.addSuggestionItem(a);a.setAdditionalText(this._getDatesLabelFormatter().format(i))};B.prototype._addSuggestionGroupItem=function(e){this._oInput.addSuggestionItemGroup({text:e})};B.prototype._handleInputChange=function(e){var t=e.getParameter("value");var i=this._parseValue(this._stripValue(t));var o=this.getValue();var n=t.trim()===""||!!i;if(this._isDateRange(i)){this._swapDates(i.values)}if(!n){this.setValue({operator:"PARSEERROR",values:[G.getText("DDR_WRONG_VALUE"),t]})}else{this.setValue(i)}this.fireChange({value:this.getValue(),prevValue:o,valid:n})};B.prototype._isDateRange=function(e){return Boolean(e&&(e.operator==="DATERANGE"||e.operator==="DATETIMERANGE"))};B.prototype._swapDates=function(e){if(e.length>1&&e[0].getTime()>e[1].getTime()){e.reverse()}};B.prototype._enhanceInputValue=function(e,t){var i=this.getOption(t.operator);if(!i){return null}if(i.enhanceFormattedValue()||t.operator==="LASTDAYS"&&t.values[0]<=1||t.operator==="NEXTDAYS"&&t.values[0]<=1){return e+" ("+this._toDatesString(t)+")"}return e};B.prototype._stripValue=function(e){var t=e.indexOf("(");var i=e.lastIndexOf(")");var o=e;if(t!==-1&&i!==-1&&t<i){o=e.slice(0,t)+e.slice(i+1);o=o.trim()}return o};B.prototype._toDatesString=function(e){var t=this.toDates(e,this.getCalendarWeekNumbering());var i=[];for(var o=0;o<t.length;o++){i[o]=t[o]}return this._getDatesLabelFormatter().format(i)};B.prototype._getPickerParser=function(){if(!this._calendarParser){this._calendarParser=g.getDateTimeWithTimezoneInstance({showTimezone:false})}return this._calendarParser};B.prototype._createPopup=function(){if(!this._oPopup){this._oPopup=new I(this.getId()+"-RP",{contentHeight:"512px",contentWidth:"320px",showCloseButton:false,showArrow:false,showHeader:false,placement:L.PlacementType.VerticalPreferedBottom,ariaLabelledBy:[t.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")]});this._oPopup.addStyleClass("sapMDDRPopover");this._oPopup.attachValidationError(function(e){e.bCancelBubble=true});if(c.system.phone){this._oPopup.addStyleClass("sapUiNoContentPadding")}else{this._oPopup._oControl._getSingleNavContent=function(){return null}}this._oPopup.attachAfterOpen(function(){var e=this._oNavContainer.getPages()[0];this._applyNavContainerPageFocus(e);this.invalidate()},this);this._oPopup.attachAfterClose(function(){this._oPreviousSelectedOption=this._oSelectedOption;this._setFooterVisibility(false);this.invalidate()},this);this._oPopup.setBeginButton(new S({type:L.ButtonType.Emphasized,text:G.getText("DYNAMIC_DATE_RANGE_CONFIRM"),press:this._applyValue.bind(this)}));this._oPopup.setEndButton(new S({text:G.getText("DYNAMIC_DATE_RANGE_CANCEL"),press:function(){this._oSelectedOption=this._oPreviousSelectedOption;this._oDatesLabelFormatter=null;this._closePopup()}.bind(this)}));this._setFooterVisibility(false);this._oPopup._getPopup().setAutoClose(true);this.setAggregation("_popup",this._oPopup,true)}};B.prototype._collectValueHelpItems=function(e,t){var i;var o;var n=[];var a=e;a.sort(function(e,t){var i=Number(e.getGroup())?e.getGroup():this._getGroups()[e.getGroup()];var o=Number(t.getGroup())?t.getGroup():this._getGroups()[t.getGroup()];var n=i-o;if(n){return n}return K.indexOf(e.getKey())-K.indexOf(t.getKey())}.bind(this));if(t){a=a.reduce(function(e,t){if(C.LastXKeys.indexOf(t.getKey())!==-1){if(i){return e}i=true}if(C.NextXKeys.indexOf(t.getKey())!==-1){if(o){return e}o=true}e.push(t);return e},[])}if(this.getEnableGroupHeaders()){a=a.reduce(function(e,t){var i=Number(t.getGroup())?t.getGroup():this._getGroups()[t.getGroup()];var o=Object.keys(this._getGroups()).find(e=>this._getGroups()[e]===i);var a=this._customGroupHeaders&&this._customGroupHeaders.find(e=>e.name===o);var s=a?this.getGroupHeader(o):t.getGroupHeader();if(n.indexOf(s)===-1){n.push(s);e.push(s)}e.push(t);return e}.bind(this),[])}return a};B.prototype.getGroupHeader=function(e){var t=this._getGroups()[e];if(t>=this._getGroups()["SingleDates"]&&t<=this._getGroups()["Years"]){return G.getText("DDR_OPTIONS_GROUP_"+t)}return this._getCustomGroupHeader(e)};B.prototype._createListItem=function(e){var t=this._isFixedOption(e);return new Z(this.getId()+"-option-"+e.getKey().replaceAll(" ",""),{type:t?w.Active:w.Navigation,title:e.getText(this),wrapping:true,optionKey:e.getKey(),press:this._handleOptionPress.bind(this)})};B.prototype._createHeaderListItem=function(e){var t=new A;t.setTitle(e);t._bGroupHeader=true;return t};B.prototype._handleOptionPress=function(e){var t=e.getSource().getOptionKey(),i=this.getOption(t);if(this._oPreviousSelectedOption&&this._oPreviousSelectedOption.getKey()!==t){this._oDatesLabelFormatter=null}this._oPreviousSelectedOption=this._oSelectedOption;this._oSelectedOption=i;if(this._isFixedOption(i)){this._applyValue()}else{var o=this._createInfoDatesFooter();this._destroyInputControls();this.aInputControls=i.createValueHelpUI(this,this._updateInternalControls.bind(this));var n=this._oNavContainer.getPages()[1];n.removeAllContent();this.aInputControls.forEach(function(e){n.addContent(e)});n.setFooter(o);n.setTitle(i.getText(this));this._setFooterVisibility(true);this._updateInternalControls(i);this._oNavContainer.to(n)}};B.prototype._isFixedOption=function(e){return!e.getValueHelpUITypes(this).length};B.prototype._createInfoDatesFooter=function(){this._infoDatesFooter=new D({design:H.Info,style:V.Clear,content:[new E({text:G.getText("DDR_INFO_DATES_EMPTY_HINT")})]});return this._infoDatesFooter};B.prototype._getDatesLabel=function(){return this._infoDatesFooter.getContent()[0]};B.prototype._updateDatesLabel=function(){var e=this._oSelectedOption.getValueHelpOutput(this),t=[],i,o;var n=this.toDates(e,this.getCalendarWeekNumbering());if(!e||!e.operator||!this.getOption(e.operator)){return}for(var a=0;a<n.length;a++){t[a]=Y._createUTCDate(n[a],true)}if(this._isDateRange(e)){this._swapDates(t)}if(t){o=this._oSelectedOption.getKey();if(o==="FROMDATETIME"||o==="TODATETIME"||o==="FROM"||o==="TO"){t.push(null)}i=this._getDatesLabelFormatter().format(t,true);this._getDatesLabel().setText(G.getText("DDR_INFO_DATES",[i]))}};B.prototype._setApplyButtonEnabled=function(e){if(!this._oPopup){return}var t=this._oPopup.getBeginButton();if(t.getVisible()){t.setEnabled(e)}};B.prototype._updateInternalControls=function(e){var t=e.validateValueHelpUI(this);if(t){this._updateDatesLabel()}this._setApplyButtonEnabled(t)};B.prototype._setFooterVisibility=function(e){var t;if(!this._oPopup){return}t=this._oPopup.getAggregation("_popup");if(c.system.phone){this._oPopup.getBeginButton().setVisible(e)}else{t.getFooter().setVisible(e)}t.invalidate();return this};B.prototype._createPopupContent=function(){var e=new m({showHeader:false,showNavButton:false}),t=new m({showHeader:true,showNavButton:true}).addStyleClass("sapMDynamicDateRangePopover");t.attachNavButtonPress(function(){this._setFooterVisibility(false);this._oNavContainer.back()},this);if(c.system.phone){e.setShowHeader(true);e.setTitle(this._getOptionsPageTitleText())}if(!this._oOptionsList){this._oOptionsList=new R({showSeparators:k.None,mode:U.SingleSelectMaster})}if(!this._oNavContainer){this._oNavContainer=new N({autoFocus:false});this._oNavContainer.addPage(e);this._oNavContainer.setInitialPage(e);this._oNavContainer.addPage(t);this._oNavContainer.attachAfterNavigate(this._navContainerAfterNavigate,this);this._oPopup.addContent(this._oNavContainer)}this._oNavContainer.getPages()[0].removeAllContent();this._oNavContainer.getPages()[0].addContent(this._oOptionsList);return this._oOptionsList};B.prototype._determineOptionFocus=function(e){var t=this._oOptionsList.getItems(),i=t.filter(function(t){return t.getOptionKey&&t.getOptionKey()===e.operator})[0];if(!i){if(q.indexOf(e.operator)>-1){i=t.filter(function(e){return e.getOptionKey&&e.getOptionKey()===q[0]})[0]}else if(z.indexOf(e.operator)>-1){i=t.filter(function(e){return e.getOptionKey&&e.getOptionKey()===z[0]})[0]}}return i};B.prototype._applyNavContainerPageFocus=function(e){var t=this.getValue(),i=this._oNavContainer.getPages()[0],o;if(e===i&&t){o=this._determineOptionFocus(t)||o}if(!e.getDomRef()){return}if(!o){o=jQuery(e.getDomRef().querySelector("section")).firstFocusableDomRef()}if(t&&t.operator!=="PARSEERROR"&&o){o.setSelected&&o.setSelected(true)}if(o){o.focus()}this._reApplyFocusToElement(e,t)};B.prototype._reApplyFocusToElement=function(e,t){};B.prototype._getOptionsPageTitleText=function(){return h.getReferencingLabels(this).concat(this.getAriaLabelledBy()).reduce(function(e,t){var o=i.registry.get(t);return e+" "+(o.getText?o.getText():"")},"").trim()};B.prototype._navContainerAfterNavigate=function(e){var t=this._oNavContainer.getPages()[1],i=e.getParameters()["to"];if(i===t){this.aInputControls.forEach(function(e){if(e.$().firstFocusableDomRef()){e.addAriaLabelledBy&&e.addAriaLabelledBy(i.getId()+"-title");if(!this._isCalendarBasedControl(e)&&e.addAriaDescribedBy){e.addAriaDescribedBy(i.getFooter().getContent()[0])}}},this)}if(this._oPopup&&this._oPopup.isOpen()){this._applyNavContainerPageFocus(i)}else{this.focus()}};B.prototype._isCalendarBasedControl=function(e){return e.isA("sap.ui.unified.Calendar")||e.isA("sap.ui.unified.calendar.CustomMonthPicker")||e.isA("sap.ui.unified.calendar.MonthPicker")||e.isA("sap.ui.unified.calendar.YearPicker")||e.isA("sap.ui.unified.calendar.YearRangePicker")||e.isA("sap.ui.unified.calendar.Month")};B.prototype.openBy=function(e){this.open(e)};B.prototype._openPopup=function(e){if(!this._oPopup){return}this._oPopup._getPopup().setExtraContent([this._oInput.getDomRef()]);this._oPopup.openBy(e||this._oInput)};B.prototype._applyValue=function(){this._oOutput=this._oSelectedOption.getValueHelpOutput(this);var e=this.toDates(this._oOutput,this.getCalendarWeekNumbering());for(var t=0;t<e.length;t++){if(this._oOutput.values[t]instanceof Date&&e[t]instanceof T){this._oOutput.values[t]=e[t].getJSDate()}}if(this._isDateRange(this._oOutput)){this._swapDates(this._oOutput.values)}var i=this.getValue();this.setValue(this._oOutput);this.fireChange({prevValue:i,value:this.getValue(),valid:true});this._closePopup()};B.prototype._closePopup=function(){this._setFooterVisibility(false);this._oNavContainer.to(this._oNavContainer.getPages()[0]);this._oPopup.close()};B.prototype._getFormatter=function(){var e=this.getFormatter(),t;if(e){return e}if(this.oBoundValueFormatter){return this.oBoundValueFormatter}t=this.getBinding("value");if(t&&t.getType()){this.oBoundValueFormatter=u.getInstance(t.getType().oFormatOptions);return this.oBoundValueFormatter}if(!this.oDefaultFormatter){this.oDefaultFormatter=u.getInstance()}return this.oDefaultFormatter};B.prototype._formatValue=function(e){var t=this.getOption(e.operator);return t?t.format(e,this._getFormatter()):""};B.prototype._parseValue=function(e){var t=this.parse(e,this._getFormatter(),this._getOptions()).filter(function(e){return this._getOptions().find(function(t){return t.getKey()===e.operator})},this);return t.length?t[0]:null};B.prototype.parse=function(t,i){if(typeof t!=="string"){e.error("DynamicDateFormat can only parse a String.");return[]}var o=[],n;var a=this._getOptions();for(var s=0;s<a.length;s++){n=a[s]&&a[s].parse(t.trim(),i);if(n){n.operator=a[s].getKey();o.push(n)}}return o};B.prototype._substituteValue=function(e){var t,i,o;if(!e||!e.operator||!e.values){return e}t=e.operator;i=e.values;if(t==="LASTDAYS"&&i[0]===1&&this.getStandardOptions().includes("YESTERDAY")){o={operator:"YESTERDAY",values:[]}}else if(t==="NEXTDAYS"&&i[0]===1&&this.getStandardOptions().includes("TOMORROW")){o={operator:"TOMORROW",values:[]}}else if((t==="LASTDAYS"||t==="NEXTDAYS")&&i[0]===0){o={operator:"TODAY",values:[]}}return o?o:e};B.prototype.getIdForLabel=function(){return this.getAggregation("_input").getIdForLabel()};B.prototype._substituteMissingValue=function(e){var t=e;if(e&&e.operator==="YESTERDAY"&&!this.getStandardOptions().includes("YESTERDAY")&&this.getStandardOptions().includes("LASTDAYS")){t={operator:"LASTDAYS",values:[1]}}else if(e&&e.operator==="TOMORROW"&&!this.getStandardOptions().includes("TOMORROW")&&this.getStandardOptions().includes("NEXTDAYS")){t={operator:"NEXTDAYS",values:[1]}}return t};B.toDates=function(e,t){return x[e.operator].toDates(e,t).map(function(e){if(e instanceof Date){return e}return e.getJSDate()})};var J=s.extend(v);J.apiVersion=2;J.writeInnerAttributes=function(e,t){if(t.getShowSuggestion()||t.getShowValueStateMessage()){e.attr("autocomplete","off")}var i=t._getControlOrigin?t._getControlOrigin():null,o=this.getAccessibilityState(t);if(i&&i.isA("sap.m.DynamicDateRange")){e.accessibilityState(i,o)}e.attr("type","text")};J.getAccessibilityState=function(e){var t=v.getAccessibilityState(e),i=e._getControlOrigin(),o=i.getAriaLabelledBy(),n=h.getReferencingLabels(i),s=i.getAriaDescribedBy().join(" "),r;r=n.concat(o).join(" ");if(s){t.describedby=s}if(r){t.labelledby=r}t.roledescription=G.getText("ACC_CTR_TYPE_DYNAMIC_DATE_RANGE");t.role=this.getAriaRole();if(e.getEditable()&&e.getEnabled()){t.haspopup=a.aria.HasPopup.ListBox.toLowerCase()}t.controls=i._oPopup&&i._oPopup.getDomRef()?i._oPopup.getDomRef().id:undefined;return t};var $=O.extend("sap.m.internal.DynamicDateRangeInput",{metadata:{library:"sap.m"},renderer:J});$.prototype._setControlOrigin=function(e){this._oOriginControl=e;return this._oOriginControl};$.prototype._getControlOrigin=function(){return this._oOriginControl};$.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering};$.prototype.shouldSuggetionsPopoverOpenOnMobile=function(e){var t=e.srcControl instanceof l;return this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&!t&&!this._bClearButtonPressed};$.prototype.onfocusin=function(e){var t=this._getControlOrigin()._oPopup;O.prototype.onfocusin.apply(this,arguments);if(t&&t.isOpen()&&!c.system.tablet&&!c.system.mobile){this._getControlOrigin()._closePopup()}};var Z=y.extend("sap.m.DynamicDateRangeListItem",{metadata:{library:"sap.m",properties:{optionKey:{type:"string",group:"Misc",defaultValue:null}}},renderer:_});Z.prototype.hasActiveType=function(){return true};Z.prototype.isIncludedIntoSelection=function(){return false};Z.prototype.onsapspace=function(e){e.preventDefault()};Z.prototype.getNavigationControl=function(){var e=y.prototype.getNavigationControl.apply(this,arguments),t=this.getOptionKey(),i=["SPECIFICMONTH","DATE","DATERANGE","FROM","TO"].includes(t),o=["DATETIME","DATETIMERANGE","FROMDATETIME","TODATETIME"].includes(t),n;if(i||o){e.addStyleClass("sapMDDRDateOption");n=i?p.getIconURI("appointment-2"):p.getIconURI("date-time")}else{n=p.getIconURI("slim-arrow-right")}e.setSrc(n);return e};return B});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DynamicDateRangeRenderer", [],function(){"use strict";var n={apiVersion:2};n.render=function(n,e){n.openStart("div",e);n.class("sapMDynamicDateRange");if(e.getHideInput()){n.class("sapMDDRHiddenInput")}n.openEnd();n.renderControl(e._oInput);n.close("div")};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DynamicDateUtil", ["./StandardDynamicDateOption","sap/base/Log","./library","sap/ui/core/format/TimezoneUtil","sap/ui/core/Core","sap/ui/core/date/UI5Date"],function(e,T,E,A,n,R){"use strict";var S=["DATE","TODAY","YESTERDAY","TOMORROW","FIRSTDAYWEEK","LASTDAYWEEK","FIRSTDAYMONTH","LASTDAYMONTH","FIRSTDAYQUARTER","LASTDAYQUARTER","FIRSTDAYYEAR","LASTDAYYEAR","DATETIMERANGE","FROMDATETIME","TODATETIME","DATERANGE","FROM","TO","YEARTODATE","DATETOYEAR","LASTMINUTES","LASTHOURS","LASTDAYS","LASTWEEKS","LASTMONTHS","LASTQUARTERS","LASTYEARS","NEXTMINUTES","NEXTHOURS","NEXTDAYS","NEXTWEEKS","NEXTMONTHS","NEXTQUARTERS","NEXTYEARS","TODAYFROMTO","THISWEEK","LASTWEEK","NEXTWEEK","SPECIFICMONTH","THISMONTH","LASTMONTH","NEXTMONTH","THISQUARTER","LASTQUARTER","NEXTQUARTER","QUARTER1","QUARTER2","QUARTER3","QUARTER4","THISYEAR","LASTYEAR","NEXTYEAR"];var y={_options:{TODAY:new e({key:"TODAY",valueTypes:[]}),YESTERDAY:new e({key:"YESTERDAY",valueTypes:[]}),TOMORROW:new e({key:"TOMORROW",valueTypes:[]}),FIRSTDAYWEEK:new e({key:"FIRSTDAYWEEK",valueTypes:[]}),LASTDAYWEEK:new e({key:"LASTDAYWEEK",valueTypes:[]}),FIRSTDAYMONTH:new e({key:"FIRSTDAYMONTH",valueTypes:[]}),LASTDAYMONTH:new e({key:"LASTDAYMONTH",valueTypes:[]}),FIRSTDAYQUARTER:new e({key:"FIRSTDAYQUARTER",valueTypes:[]}),LASTDAYQUARTER:new e({key:"LASTDAYQUARTER",valueTypes:[]}),FIRSTDAYYEAR:new e({key:"FIRSTDAYYEAR",valueTypes:[]}),LASTDAYYEAR:new e({key:"LASTDAYYEAR",valueTypes:[]}),THISWEEK:new e({key:"THISWEEK",valueTypes:[]}),THISMONTH:new e({key:"THISMONTH",valueTypes:[]}),THISQUARTER:new e({key:"THISQUARTER",valueTypes:[]}),THISYEAR:new e({key:"THISYEAR",valueTypes:[]}),LASTWEEK:new e({key:"LASTWEEK",valueTypes:[]}),LASTMONTH:new e({key:"LASTMONTH",valueTypes:[]}),LASTQUARTER:new e({key:"LASTQUARTER",valueTypes:[]}),LASTYEAR:new e({key:"LASTYEAR",valueTypes:[]}),NEXTWEEK:new e({key:"NEXTWEEK",valueTypes:[]}),NEXTMONTH:new e({key:"NEXTMONTH",valueTypes:[]}),NEXTQUARTER:new e({key:"NEXTQUARTER",valueTypes:[]}),NEXTYEAR:new e({key:"NEXTYEAR",valueTypes:[]}),LASTMINUTES:new e({key:"LASTMINUTES",valueTypes:["int"]}),LASTHOURS:new e({key:"LASTHOURS",valueTypes:["int"]}),LASTDAYS:new e({key:"LASTDAYS",valueTypes:["int"]}),LASTWEEKS:new e({key:"LASTWEEKS",valueTypes:["int"]}),LASTMONTHS:new e({key:"LASTMONTHS",valueTypes:["int"]}),LASTQUARTERS:new e({key:"LASTQUARTERS",valueTypes:["int"]}),LASTYEARS:new e({key:"LASTYEARS",valueTypes:["int"]}),NEXTMINUTES:new e({key:"NEXTMINUTES",valueTypes:["int"]}),NEXTHOURS:new e({key:"NEXTHOURS",valueTypes:["int"]}),NEXTDAYS:new e({key:"NEXTDAYS",valueTypes:["int"]}),NEXTWEEKS:new e({key:"NEXTWEEKS",valueTypes:["int"]}),NEXTMONTHS:new e({key:"NEXTMONTHS",valueTypes:["int"]}),NEXTQUARTERS:new e({key:"NEXTQUARTERS",valueTypes:["int"]}),NEXTYEARS:new e({key:"NEXTYEARS",valueTypes:["int"]}),FROM:new e({key:"FROM",valueTypes:["date"]}),TO:new e({key:"TO",valueTypes:["date"]}),FROMDATETIME:new e({key:"FROMDATETIME",valueTypes:["datetime"]}),TODATETIME:new e({key:"TODATETIME",valueTypes:["datetime"]}),YEARTODATE:new e({key:"YEARTODATE",valueTypes:[]}),DATETOYEAR:new e({key:"DATETOYEAR",valueTypes:[]}),TODAYFROMTO:new e({key:"TODAYFROMTO",valueTypes:["int","int"]}),QUARTER1:new e({key:"QUARTER1",valueTypes:[]}),QUARTER2:new e({key:"QUARTER2",valueTypes:[]}),QUARTER3:new e({key:"QUARTER3",valueTypes:[]}),QUARTER4:new e({key:"QUARTER4",valueTypes:[]}),SPECIFICMONTH:new e({key:"SPECIFICMONTH",valueTypes:["int"]}),SPECIFICMONTHINYEAR:new e({key:"SPECIFICMONTHINYEAR",valueTypes:["int","int"]}),DATERANGE:new e({key:"DATERANGE",valueTypes:["date","date"]}),DATE:new e({key:"DATE",valueTypes:["date"]}),DATETIME:new e({key:"DATETIME",valueTypes:["datetime"]}),DATETIMERANGE:new e({key:"DATETIMERANGE",valueTypes:["datetime","datetime"]})},_allKeys:S.slice(0)};y.addOption=function(e){if(!e||!e.getKey()){return}var T=e.getKey();y._options[T]=e;if(y._allKeys.indexOf(T)===-1){y._allKeys.push(T)}};y.getAllOptionKeys=function(){return y._allKeys.slice(0)};y.getOption=function(e){return y._options[e]};y.getStandardKeys=function(){return S.slice(0)};y.parse=function(e,E,A){if(typeof e!=="string"){T.error("DynamicDateFormat can only parse a String.");return[]}var n=[],R,S=y.getStandardKeys();A=A||Object.keys(y._options);var a=A.sort(function(e,T){return S.indexOf(e)-S.indexOf(T)}).map(function(e){return y._options[e]});for(var t=0;t<a.length;t++){R=a[t]&&a[t].parse(e.trim(),E);if(R){R.operator=a[t].getKey();n.push(R)}}return n};y.toDates=function(e,T){var E=e.operator;return y._options[E].toDates(e,T)};y.removeTimezoneOffset=function(e){var T=R.getInstance(e);var E=n.getConfiguration().getTimezone();var S=A.calculateOffset(T,E)-T.getTimezoneOffset()*60;T.setSeconds(T.getSeconds()-S);return T};return y},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/DynamicDateValueHelpUIType", ["sap/ui/core/Element"],function(e){"use strict";var t=e.extend("sap.m.DynamicDateValueHelpUIType",{metadata:{library:"sap.m",properties:{type:{type:"string"},text:{type:"string"},additionalText:{type:"string"},options:{type:"string[]",defaultValue:null}}}});return t});
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/m/ExpandableText", ["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/library","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/base/ManagedObject","sap/m/Link","sap/m/Text","sap/m/Button","sap/m/ResponsivePopover","sap/m/HyphenationSupport","./ExpandableTextRenderer"],function(e,t,r,i,a,n,o,p,s,l,d,g,u){"use strict";var h=t.getLibraryResourceBundle("sap.m");var c=h.getText("EXPANDABLE_TEXT_SHOW_MORE");var y=h.getText("EXPANDABLE_TEXT_SHOW_LESS");var x=h.getText("MSGBOX_CLOSE");var f=i.TextAlign;var T=i.TextDirection;var _=i.aria.HasPopup;var v=e.WrappingType;var A=e.PlacementType;var b=e.ExpandableTextOverflowMode;var m=e.EmptyIndicatorMode;var L=e.LinkAccessibleRole;function E(e){return e.replace(/ {2,}/g," ").replace(/\t{2,}/g," ")}var P=r.extend("sap.m.ExpandableText",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IHyphenation"],library:"sap.m",properties:{text:{type:"string",defaultValue:"",bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:v.Normal},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Begin},renderWhitespace:{type:"boolean",group:"Appearance",defaultValue:false},overflowMode:{type:"sap.m.ExpandableTextOverflowMode",group:"Appearance",defaultValue:b.InPlace},maxCharacters:{type:"int",group:"Appearance",defaultValue:100},expanded:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:m.Off}},aggregations:{_showMoreLink:{type:"sap.m.Link",multiple:false,visibility:"hidden"},_ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/ExpandableText.designtime"},renderer:u});P.prototype.init=function(){this.setAggregation("_ariaLabelledBy",new a)};P.prototype.onBeforeRendering=function(){this._updateAriaLabelledByText()};P.prototype._onAfterLinkRendering=function(){var e;if(!this._isExpandable()||this.getOverflowMode()===b.Popover){return}e=this._getShowMoreLink().getDomRef();e.setAttribute("aria-expanded",this.getProperty("expanded"));e.setAttribute("aria-controls",this.getId()+"-string")};P.prototype.getText=function(e){var t=this.getProperty("text");if(e){return t.replace(/\r\n|\n\r|\r/g,"\n")}return t};P.prototype.getTextDomRef=function(){if(!this.getVisible()){return null}return this.getDomRef("string")};P.prototype._isExpandable=function(){var e=this.getText();if(!this.getRenderWhitespace()){e=E(e)}return e.length>this._getMaxCharacters()+c.length};P.prototype._getMaxCharacters=function(){return Math.max(0,this.getMaxCharacters())};P.prototype._getDisplayedText=function(){var e=this.getText(true);if(this.getProperty("expanded")||!this._isExpandable()){return e}if(!this.getRenderWhitespace()){e=E(e)}return e.substring(0,this._getMaxCharacters())};P.prototype._getShowMoreLink=function(){var e=this.getAggregation("_showMoreLink");if(!e){e=new p(this.getId()+"-showMoreLink",{accessibleRole:L.Button,text:this.getProperty("expanded")?y:c,ariaLabelledBy:this.getAggregation("_ariaLabelledBy"),press:function(t){var r,i,a;if(this.getOverflowMode()===b.InPlace){i=!this.getProperty("expanded");e.setText(i?y:c);this.setProperty("expanded",i)}else{r=new s({text:o.escapeSettingsValue(this.getText()),textDirection:this.getTextDirection(),wrappingType:this.getWrappingType(),textAlign:this.getTextAlign(),renderWhitespace:this.getRenderWhitespace()}).addStyleClass("sapUiSmallMargin").addStyleClass("sapMExTextPopover");a=this._oPopover;if(a&&a.isOpen()){a.close();return}if(!a){a=this._oPopover=new d({showHeader:false,placement:A.HorizontalPreferredRight,beforeClose:this._onPopoverBeforeClose.bind(this)});if(n.system.phone){a.setEndButton(new l({text:x,press:function(){a.close()}}))}this.addDependent(a)}e.setText(y);e.rerender();a.removeAllAriaLabelledBy();a.destroyContent();a.addAriaLabelledBy(r);a.addContent(r);a.openBy(t.getSource());this._updateAriaLabelledByText(true)}}.bind(this)});e.addEventDelegate({onAfterRendering:this._onAfterLinkRendering},this);this.setAggregation("_showMoreLink",e,true)}e.setAriaHasPopup(this.getOverflowMode()===b.InPlace?_.None:_.Dialog);return e};P.prototype._onPopoverBeforeClose=function(){this._getShowMoreLink().setText(c);this._updateAriaLabelledByText()};P.prototype._updateAriaLabelledByText=function(e){var t="";e=e||this.getProperty("expanded");if(this.getOverflowMode()===b.Popover){t=h.getText(e?"EXPANDABLE_TEXT_SHOW_LESS_POPOVER_ARIA_LABEL":"EXPANDABLE_TEXT_SHOW_MORE_POPOVER_ARIA_LABEL")}this.getAggregation("_ariaLabelledBy").setText(t)};P.prototype.exit=function(){if(this._oPopover){this._oPopover.destroy();this._oPopover=null}};P.prototype.getAccessibilityInfo=function(){return{description:this.getText()}};P.prototype.getTextsToBeHyphenated=function(){return{main:this._getDisplayedText(true)}};P.prototype.getDomRefsForHyphenatedTexts=function(){return{main:this.getTextDomRef()}};g.mixInto(P.prototype);return P});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ExpandableTextRenderer", ["sap/ui/core/Core","sap/ui/core/Renderer","sap/ui/core/library","sap/m/HyphenationSupport","./library"],function(e,t,a,n,r){"use strict";var s=a.TextDirection;var i=r.WrappingType;var p=r.EmptyIndicatorMode;var o=e.getLibraryResourceBundle("sap.m");var d={apiVersion:2};d.render=function(e,a){var r=a._getDisplayedText(),p=a.getTextDirection(),o=a.getTooltip_AsString(),l=a.getWrappingType(),c=a.getTextAlign(),g=a.getRenderWhitespace(),x=a._isExpandable(),T=a.getProperty("expanded"),E=T?" ":"... ",u=a.getAggregation("_ariaLabelledBy");e.openStart("div",a);e.class("sapMExText");e.class("sapUiSelectable");if(l!==i.Hyphenated){if(r&&r.length>0&&!/\s/.test(r)){e.class("sapMExTextBreakWord")}}e.attr("dir",p!==s.Inherit?p.toLowerCase():"auto");if(o){e.attr("title",o)}if(c){c=t.getTextAlign(c,p);if(c){e.style("text-align",c)}}if(g){e.class("sapMExTextRenderWhitespaceWrap")}n.writeHyphenationClass(e,a);e.openEnd();e.openStart("span",a.getId()+"-string");e.class("sapMExTextString");e.openEnd();d.renderText(e,a);e.close("span");if(x){e.openStart("span");e.class("sapMExTextEllipsis");e.openEnd();e.unsafeHtml(E);e.close("span");e.renderControl(a._getShowMoreLink())}e.renderControl(u);e.close("div")};d.renderText=function(e,t){if(t.getEmptyIndicatorMode()!==p.Off&&!t.getText()){this.renderEmptyIndicator(e,t)}else{e.text(n.getTextForRender(t,"main"))}};d.renderEmptyIndicator=function(e,t){e.openStart("span");e.class("sapMEmptyIndicator");if(t.getEmptyIndicatorMode()===p.Auto){e.class("sapMEmptyIndicatorAuto")}e.openEnd();e.openStart("span");e.attr("aria-hidden",true);e.openEnd();e.text(o.getText("EMPTY_INDICATOR"));e.close("span");e.openStart("span");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(o.getText("EMPTY_INDICATOR_TEXT"));e.close("span");e.close("span")};return d},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/m/FacetFilter", ["./NavContainer","./library","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/Element","sap/ui/core/IconPool","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","sap/ui/core/IntervalTrigger","sap/ui/Device","sap/ui/core/Icon","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","./FacetFilterRenderer","sap/ui/events/KeyCodes","sap/base/assert","sap/base/Log","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery","sap/m/Button","sap/m/ToolbarSpacer","sap/m/OverflowToolbar","sap/m/Text","sap/m/Toolbar","sap/m/Popover","sap/m/SearchField","sap/m/Bar","sap/m/Dialog","sap/m/List","sap/m/StandardListItem","sap/m/CheckBox","sap/m/Page","sap/ui/core/date/UI5Date","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/Selectors"],function(e,t,i,s,a,r,o,n,l,g,h,u,d,p,c,f,v,_,m,jQuery,y,I,F,T,b,S,L,C,A,R,E,x,w,N){"use strict";var B=t.ToolbarDesign;var D=t.ListType;var P=t.ListMode;var M=t.FacetFilterListDataType;var O=t.ButtonType;var k=t.PlacementType;var V=t.FacetFilterType;var H=500;var K=i.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:V.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}},renderer:c});K.SCROLL_STEP=264;K.prototype.setType=function(e){var t,i;if(g.system.phone){this.setProperty("type",V.Light);i=true}else{this.setProperty("type",e);i=e===V.Light}t=this._getSummaryBar();t.setActive(i);if(e===V.Light){if(this.getShowReset()){this._addResetToSummary(t)}else{this._removeResetFromSummary(t)}}return this};K.prototype.setShowReset=function(e){this.setProperty("showReset",e);var t=this._getSummaryBar();if(e){if(this.getShowSummaryBar()||this.getType()===V.Light){this._addResetToSummary(t)}}else{if(this.getShowSummaryBar()||this.getType()===V.Light){this._removeResetFromSummary(t)}}return this};K.prototype.setShowSummaryBar=function(e){this.setProperty("showSummaryBar",e);if(e){var t=this._getSummaryBar();if(this.getShowReset()){this._addResetToSummary(t)}else{this._removeResetFromSummary(t)}t.setActive(this.getType()===V.Light)}return this};K.prototype.setLiveSearch=function(e){this.setProperty("liveSearch",e);if(this._displayedList){var t=this._displayedList;var i=sap.ui.getCore().byId(t.getAssociation("search"));i.detachLiveChange(t._handleSearchEvent,t);if(e){i.attachLiveChange(t._handleSearchEvent,t)}}return this};K.prototype.getLists=function(){var e=this.getAggregation("lists");if(!e){e=[]}if(this._displayedList){e.splice(this._listAggrIndex,0,this._displayedList)}e.forEach(function(e){if(!e.hasListeners("listItemsChange")){e.attachEvent("listItemsChange",q.bind(this))}}.bind(this));return e};function q(e){var t=e.getSource();if(this._oAllCheckBoxBar){this._oAllCheckBoxBar.setVisible(Boolean(t.getItems(true).length))}}K.prototype.removeAggregation=function(){var e=i.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(e)}return e};K.prototype.openFilterDialog=function(){var e=this._getFacetDialog();var t=this._getFacetDialogNavContainer();e.addContent(t);this.getLists().forEach(function(e){if(e.getMode()===P.MultiSelect){e._preserveOriginalActiveState()}});e.setInitialFocus(t.getPages()[0].getContent()[0].getItems()[0]);e.open();return this};K.prototype.init=function(){this._pageSize=5;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._popoverClosing=false;this._getAddFacetButton();this.setAggregation("resetButton",this._createResetButton());if(m.touchEventMode==="ON"&&!g.system.phone){this._enableTouchSupport()}if(g.system.phone){this.setType(V.Light)}};K.prototype.exit=function(){var e;l.removeListener(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy()}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(t){e=sap.ui.getCore().byId(t);if(e){e.destroy()}});this._aOwnedLabels=null}if(this._oAllCheckBoxBar){this._oAllCheckBoxBar=undefined}};K.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===V.Light){var e=this._getSummaryBar();var t=e.getContent()[0];t.setText(this._getSummaryText())}l.removeListener(this._checkOverflow,this)};K.prototype.onAfterRendering=function(){var e=this.getShowSummaryBar(),t=this.getType(),i=this._getSummaryBar().$();if(t!==V.Light&&!g.system.phone){l.addListener(this._checkOverflow,this)}if(t!==V.Light){this._startItemNavigation();this.addDelegate(this.oItemNavigation)}if(t===V.Light){i.attr("aria-roledescription",this._bundle.getText("FACETFILTER_ACTIVE_TITLE"));i.attr("role","group")}else if(e){i.attr("aria-roledescription",this._bundle.getText("FACETFILTER_TITLE"))}};K.prototype._startItemNavigation=function(){var e=this.getDomRef(),t=e.getElementsByClassName("sapMFFHead"),i=[];if(t.length>0){for(var s=0;s<t[0].childNodes.length;s++){if(t[0].childNodes[s].id.indexOf("ff")<0&&t[0].childNodes[s].id.indexOf("icon")<0&&t[0].childNodes[s].id.indexOf("add")<0){i.push(t[0].childNodes[s])}if(t[0].childNodes[s].id.indexOf("add")>=0){i.push(t[0].childNodes[s])}}}if(i!=""){this._aDomRefs=i}if(!this.oItemNavigation){this.oItemNavigation=new o}this._aRows=t;for(var s=0;s<this.$().find(":sapTabbable").length;s++){if(this.$().find(":sapTabbable")[s].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[s];break}}this.oItemNavigation.setRootDomRef(e);if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false}this.oItemNavigation.setItemDomRefs(i);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);this.oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]})};K.prototype.onsapdelete=function(e){var t,i;if(this.getType()===V.Light){return}if(!this.getShowPersonalization()){return}t=sap.ui.getCore().byId(e.target.id);if(!t){return}i=sap.ui.getCore().byId(t.getAssociation("list"));if(!i){return}if(!i.getShowRemoveFacetIcon()){return}i.removeSelections(true);i.setSelectedKeys();i.setProperty("active",false,true);this.invalidate();var s=this.$().find(":sapTabbable");jQuery(s[s.length-1]).trigger("focus");var a=this.oItemNavigation.getFocusedIndex();jQuery(e.target).trigger("blur");this.oItemNavigation.setFocusedIndex(a+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var r=0;r<this.$().find(":sapTabbable").length-1;r++){if(s[r].id.indexOf("add")>=0){jQuery(s[r]).trigger("focus")}}}};K.prototype.onsaptabnext=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFHead"){for(var t=0;t<this.$().find(":sapTabbable").length;t++){if(this.$().find(":sapTabbable")[t].parentNode.className=="sapMFFResetDiv"){jQuery(this.$().find(":sapTabbable")[t]).trigger("focus");this._invalidateFlag=false;e.preventDefault();e.setMarked();return}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false}};K.prototype.onsaptabprevious=function(e){if(this.getType()===V.Light){return}if(e.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){jQuery(this.$().find(":sapTabbable")[0]).trigger("focus");e.preventDefault();e.setMarked();return}if(e.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=e.target.id){jQuery(this._previousTarget).trigger("focus");e.preventDefault();e.setMarked();return}if(e.target.id.indexOf("add")>=0||e.target.parentNode.className=="sapMFFHead"){this._previousTarget=e.target;jQuery(this.$().find(":sapTabbable")[0]).trigger("focus")}};K.prototype.onsapend=function(e){if(this.getType()===V.Light){return}if(this._addTarget!=null){jQuery(this._addTarget).trigger("focus");e.preventDefault();e.setMarked()}else{jQuery(this._aRows[this._aRows.length-1]).trigger("focus");e.preventDefault();e.setMarked()}this._previousTarget=e.target};K.prototype.onsaphome=function(e){if(this.getType()===V.Light){return}jQuery(this._aRows[0]).trigger("focus");e.preventDefault();e.setMarked();this._previousTarget=e.target};K.prototype.onsappageup=function(e){this._previousTarget=e.target};K.prototype.onsappagedown=function(e){this._previousTarget=e.target};K.prototype.onsapincreasemodifiers=function(e){if(this.getType()===V.Light){return}if(e.which==f.ARROW_RIGHT){this._previousTarget=e.target;var t=this.oItemNavigation.getFocusedIndex()-1;var i=t+this._pageSize;jQuery(e.target).trigger("blur");this.oItemNavigation.setFocusedIndex(i);this.focus()}};K.prototype.onsapdecreasemodifiers=function(e){if(this.getType()===V.Light){return}var t=0;if(e.which==f.ARROW_LEFT){this._previousTarget=e.target;t=this.oItemNavigation.getFocusedIndex()+1;var i=t-this._pageSize;jQuery(e.target).trigger("blur");this.oItemNavigation.setFocusedIndex(i);this.focus()}};K.prototype.onsapdownmodifiers=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;var t=0;t=this.oItemNavigation.getFocusedIndex()-1;var i=t+this._pageSize;jQuery(e.target).trigger("blur");this.oItemNavigation.setFocusedIndex(i);this.focus()};K.prototype.onsapupmodifiers=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;var t=0;t=this.oItemNavigation.getFocusedIndex();if(t!=0){t=t+1}var i=t-this._pageSize;jQuery(e.target).trigger("blur");this.oItemNavigation.setFocusedIndex(i);this.focus()};K.prototype.onsapexpand=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;var t=this.oItemNavigation.getFocusedIndex()+1;jQuery(e.target).trigger("blur");this.oItemNavigation.setFocusedIndex(t);this.focus()};K.prototype.onsapcollapse=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;var t=this.oItemNavigation.getFocusedIndex()-1;jQuery(e.target).trigger("blur");this.oItemNavigation.setFocusedIndex(t);this.focus()};K.prototype.onsapdown=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){jQuery(e.target).trigger("focus");e.preventDefault();e.setMarked();return}};K.prototype.onsapup=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){jQuery(e.target).trigger("focus");e.preventDefault();e.setMarked()}};K.prototype.onsapleft=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){jQuery(e.target).trigger("focus");e.preventDefault();e.setMarked()}var t=this.oItemNavigation.aItemDomRefs,i=this.oItemNavigation.getFocusedIndex(),s=i-1>=0?i-1:i,r=a.closestTo(t[s]),o=this._calculateScrollIntoView(r);this._scroll(o,H)};K.prototype.onsapright=function(e){if(this.getType()===V.Light){return}this._previousTarget=e.target;if(e.target.parentNode.className=="sapMFFResetDiv"){jQuery(e.target).trigger("focus");e.preventDefault();e.setMarked()}var t=this.oItemNavigation.aItemDomRefs,i=this.oItemNavigation.getFocusedIndex(),s=t.length>i+1?i+1:i,r=a.closestTo(t[s]),o=this._calculateScrollIntoView(r);this._scroll(o,H)};K.prototype.onsapescape=function(e){if(this.getType()===V.Light){return}if(e.target.parentNode.className=="sapMFFResetDiv"){return}var t=this._lastCategoryFocusIndex;jQuery(e.target).trigger("blur");this.oItemNavigation.setFocusedIndex(t);this.focus()};K.prototype._getPopover=function(){var e=this.getAggregation("popover");if(!e){var t=this;e=new S({placement:k.Bottom,beforeOpen:function(e){if(t._displayedList){t._displayedList._bSearchEventDefaultBehavior&&t._displayedList._setSearchValue("")}this.setCustomHeader(t._createFilterItemsSearchFieldBar(t._displayedList));var s=this.getSubHeader();if(!s){this.setSubHeader(t._createSelectAllCheckboxBar(t._displayedList))}i(t._displayedList)},beforeClose:function(){t._popoverClosing=true},afterClose:function(e){this._popoverClosing=false;t._handlePopoverAfterClose()},horizontalScrolling:false});this.setAggregation("popover",e,true);e.setContentWidth("30%");e.addStyleClass("sapMFFPop");var i=function(e){if(!e){return}var i=t._getFacetRemoveIcon(e);if(i){i._bTouchStarted=false}}}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(e)}else{e.destroyAggregation("footer")}return e};K.prototype._handlePopoverAfterClose=function(){var e=this.getAggregation("popover"),t=this._displayedList;if(!e){return}var i=this._getFacetRemoveIcon(t);if(i&&i._bTouchStarted){return}this._restoreListFromDisplayContainer(e);this._displayRemoveIcon(false,t);t._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){setTimeout(function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined}.bind(this),0)}};K.prototype._fireConfirmEvent=function(){this.fireEvent("confirm")};K.prototype._openPopover=function(e,t){var i;if(!e.isOpen()){var s=sap.ui.getCore().byId(t.getAssociation("list"));v(s,"The facet filter button should be associated with a list.");i=!s.fireListOpen({});s.attachUpdateFinished(q.bind(this));this._moveListToDisplayContainer(s,e);e.openBy(t);if(s.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,s)}if(s.getWordWrap()){e.setContentWidth("30%")}if(!i){s._applySearch()}}return this};K.prototype._getAddFacetButton=function(){var e=this.getAggregation("addFacetButton");if(!e){e=new y(this.getId()+"-add",{icon:r.getIconURI("add-filter"),type:O.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(e){this.openFilterDialog()}.bind(this)});this.setAggregation("addFacetButton",e,true)}return e};K.prototype._getButtonForList=function(e){if(this._buttons[e.getId()]){this._setButtonText(e);return this._buttons[e.getId()]}var t=this;var i=new y({type:O.Transparent,press:function(i){var s=this;var a=function(){var e=t._getPopover();t._openPopover(e,s)};if(e.getMode()===P.MultiSelect){e._preserveOriginalActiveState()}var r=t._getPopover();if(r.isOpen()){setTimeout(function(){if(r.isOpen()){return}t._oOpenPopoverDeferred=jQuery.Deferred();t._oOpenPopoverDeferred.promise().done(a)},100)}else{setTimeout(a.bind(this),100)}}});this._buttons[e.getId()]=i;this.addAggregation("buttons",i);i.setAssociation("list",e.getId(),true);this._setButtonText(e);return i};K.prototype._setButtonText=function(e){var t=this._buttons[e.getId()];if(e._iAllItemsCount===undefined&&e.getMaxItemsCount()||!e._bSearchEventDefaultBehavior){e._iAllItemsCount=e.getMaxItemsCount()}if(t){var i="";var s=Object.getOwnPropertyNames(e._oSelectedKeys);var a=s.length;if(a===1){var r=e._oSelectedKeys[s[0]];i=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[e.getTitle(),r])}else if(a>0&&a===(e._iAllItemsCount?e._iAllItemsCount:0)){i=this._bundle.getText("FACETFILTER_ALL_SELECTED",[e.getTitle()])}else if(a>0){i=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[e.getTitle(),a])}else{i=e.getTitle()}t.setText(i)}};K.prototype._getFacetRemoveIcon=function(e){var t=this,i=this._removeFacetIcons[e.getId()];if(!i){i=new h({src:r.getIconURI("decline"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){i._bPressed=true}});i.addDelegate({ontouchstart:function(){i._bTouchStarted=true;i._bPressed=false},ontouchend:function(){t._displayRemoveIcon(false,e);i._bTouchStarted=false;setTimeout(s.bind(this),100)}},true);var s=function(){if(i._bPressed){e.removeSelections(true);e.setSelectedKeys();e.setProperty("active",false,true)}t._handlePopoverAfterClose()};i.setAssociation("list",e.getId(),true);i.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[e.getId()]=i;this.addAggregation("removeFacetIcons",i);this._displayRemoveIcon(false,e)}return i};K.prototype._displayRemoveIcon=function(e,t){if(this.getShowPersonalization()){var i=this._removeFacetIcons[t.getId()];if(e){i.removeStyleClass("sapMFFLHiddenRemoveIcon");i.addStyleClass("sapMFFLVisibleRemoveIcon")}else{i.removeStyleClass("sapMFFLVisibleRemoveIcon");i.addStyleClass("sapMFFLHiddenRemoveIcon")}}};K.prototype._getFacetDialogNavContainer=function(){var t=new e({autoFocus:false});var i=this._createFacetPage();t.addPage(i);t.setInitialPage(i);t.attachAfterNavigate(function(e){var t=e.getParameters()["to"];var s=e.getParameters()["from"];if(s===i){var a=this._displayedList.getMode()===P.MultiSelect?t.getContent(0)[1].getItems()[0]:t.getContent(0)[0].getItems()[0];if(a){a.focus()}else if(t.getContent()[1]){t.getContent()[1].focus()}}if(t===i){s.destroySubHeader();v(this._displayedList===null,"Filter items list should have been placed back in the FacetFilter aggregation before page content is destroyed.");s.destroyContent();this._selectedFacetItem.invalidate();t.invalidate();this._selectedFacetItem.focus();this._selectedFacetItem=null}}.bind(this));return t};K.prototype._createFacetPage=function(){var e=this._createFacetList();var t=new L({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(t){var i=e.getBinding("items");if(i){var s=new u("text",d.Contains,t.getParameters()["newValue"]);i.filter([s])}}});var i=new w({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new C({contentMiddle:t}),content:[e]});return i};K.prototype._createFilterItemsPage=function(){var e=new w({showNavButton:true,enableScrolling:true,navButtonPress:function(e){var t=e.getSource().getParent();this._navFromFilterItemsPage(t)}.bind(this)});return e};K.prototype._getFilterItemsPage=function(e){var t=e.getPages()[1];if(t){e.removePage(t);t.destroy()}var i=this._createFilterItemsPage();e.addPage(i);return i};K.prototype._createFilterItemsSearchFieldBar=function(e){var t=true;if(e.getDataType()!=M.String){t=false}var i=new L({value:e._getSearchValue(),width:"100%",enabled:t,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(e){this._displayedList._handleSearchEvent(e)}.bind(this)});if(this.getLiveSearch()){i.attachLiveChange(e._handleSearchEvent,e)}var s=new C({contentMiddle:i});e.setAssociation("search",i);return s};K.prototype._getFacetDialog=function(){var e=this.getAggregation("dialog");if(!e){var t=this;e=new A({showHeader:false,stretch:g.system.phone?true:false,afterClose:function(){t._invalidateFlag=true;var e=this.getContent()[0];var i=e.getPages()[1];if(e.getCurrentPage()===i){var s=t._restoreListFromDisplayContainer(i);if(s.getMode()===P.MultiSelect){s._updateActiveState();t._bCheckForAddListBtn=true}s._fireListCloseEvent();s._bSearchEventDefaultBehavior&&s._search("")}this.destroyAggregation("content",true);t.invalidate()},beginButton:new y({text:this._bundle.getText("FACETFILTER_ACCEPT"),type:O.Emphasized,press:function(){t._closeDialog()}}),contentHeight:"500px",ariaLabelledBy:[n.getStaticId("sap.m","FACETFILTER_AVAILABLE_FILTER_NAMES")]});e.addStyleClass("sapMFFDialog");e.onsapentermodifiers=function(e){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){var i=this.getContent()[0];t._navFromFilterItemsPage(i)}};this.setAggregation("dialog",e,true)}return e};K.prototype._closeDialog=function(){var e=this.getAggregation("dialog");if(e&&e.isOpen()){e.close();this._fireConfirmEvent()}};K.prototype._closePopover=function(){var e=this.getAggregation("popover");if(e&&e.isOpen()){e.close()}};K.prototype._createFacetList=function(){var e=this._oFacetList=new R({mode:P.None,items:{path:"/items",template:new E({title:"{text}",counter:"{count}",type:D.Navigation,customData:[new s({key:"index",value:"{index}"})]})}});var t=this._getMapFacetLists();var i=new p({items:t});if(t.length>100){i.setSizeLimit(t.length)}var a=this;e.attachUpdateFinished(function(){for(var t=0;t<e.getItems().length;t++){var i=this.getItems()[t];i.detachPress(a._handleFacetListItemPress,a);i.attachPress(a._handleFacetListItemPress,a)}});e.setModel(i);return e};K.prototype.refreshFacetList=function(){this._oFacetList.getModel().setData({items:this._getMapFacetLists()});return this};K.prototype._getMapFacetLists=function(){return this.getLists().map(function(e,t){return{text:e.getTitle(),count:e.getAllCount(),index:t}})};K.prototype._createSelectAllCheckboxBar=function(e){if(e.getMode()!==P.MultiSelect){return null}var t=e.getActive()&&e.getItems().length>0&&Object.getOwnPropertyNames(e._oSelectedKeys).length===e.getItems().length;var i=new x(e.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:t,select:function(t){i.setSelected(t.getParameter("selected"));e._handleSelectAllClick(t.getParameter("selected"))}});e.setAssociation("allcheckbox",i);var s=new C({visible:Boolean(e.getItems(true).length)});s.addEventDelegate({ontap:function(t){if(t.srcControl===this){e._handleSelectAllClick(i.getSelected())}}},s);s.addContentLeft(i);s.addStyleClass("sapMFFCheckbar");this._oAllCheckBoxBar=s;return s};K.prototype._handleFacetListItemPress=function(e){this._navToFilterItemsPage(e.getSource())};K.prototype._navToFilterItemsPage=function(e){this._selectedFacetItem=e;var t=this.getAggregation("dialog").getContent()[0];var i=e.getCustomData();v(i.length===1,"There should be exactly one custom data for the original facet list item index");var s=i[0].getValue();var a=this.getLists()[s];this._listIndexAgg=this.indexOfAggregation("lists",a);if(this._listIndexAgg==s){var r=this._getFilterItemsPage(t);a.fireListOpen({});a.attachUpdateFinished(q.bind(this));this._moveListToDisplayContainer(a,r);r.setSubHeader(this._createFilterItemsSearchFieldBar(a));var o=this._createSelectAllCheckboxBar(a);if(o){r.insertContent(o,0)}r.setTitle(a.getTitle());t.to(r)}};K.prototype._navFromFilterItemsPage=function(e){var t=e.getPages()[1];var i=this._restoreListFromDisplayContainer(t);if(i.getMode()===P.MultiSelect){i._updateActiveState()}i._fireListCloseEvent();i._bSearchEventDefaultBehavior&&i._search("");this._selectedFacetItem.setCounter(i.getAllCount());e.backToTop()};K.prototype._moveListToDisplayContainer=function(e,t){this._listAggrIndex=this.indexOfAggregation("lists",e);v(this._listAggrIndex>-1,"The lists index should be valid.");i.prototype.removeAggregation.call(this,"lists",e,true);t.addAggregation("content",e,false);e.setAssociation("facetFilter",this,true);this._displayedList=e};K.prototype._restoreListFromDisplayContainer=function(e){var t=e.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",t,this._listAggrIndex,t.getActive());this._listAggrIndex=-1;this._displayedList=null;return t};K.prototype._getSequencedLists=function(){var e=-1;var t=[];var i=this.getLists();if(i.length>0){for(var s=0;s<i.length;s++){if(i[s].getActive()){if(i[s].getSequence()<-1){i[s].setSequence(-1)}else if(i[s].getSequence()>e){e=i[s].getSequence()}t.push(i[s])}else if(!i[s].getRetainListSequence()){i[s].setSequence(-1)}}for(var a=0;a<t.length;a++){if(t[a].getSequence()<=-1){e+=1;t[a].setSequence(e)}}if(t.length>1){t.sort(function(e,t){return e.getSequence()-t.getSequence()})}}return t};K.prototype._getSummaryBar=function(){var e=this.getAggregation("summaryBar"),t=this.getType();if(!e){var i=new T({maxLines:1});e=new b({content:[i],active:t===V.Light?true:false,design:B.Info,ariaLabelledBy:i,press:function(e){this.openFilterDialog()}.bind(this)});e._setRootAccessibilityRole("group");this.setAggregation("summaryBar",e)}return e};K.prototype._handleReset=function(){this.fireReset();this.invalidate()};K.prototype._createResetButton=function(){var e=new y({type:O.Transparent,icon:r.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(e){this._invalidateFlag=true;if(this._popoverClosing){setTimeout(this._handleReset.bind(this),S.prototype._getAnimationDuration())}else{this._handleReset()}var t=this.getLists();for(var i=0;i<t.length;i++){t[i]._setSearchValue("");t[i]._applySearch();var s=t[i].getItems()[0];if(s){s.focus()}}}.bind(this)});return e};K.prototype._addOKButtonToPopover=function(e){var t=e.getFooter(),i;if(!t){i=new y({text:this._bundle.getText("FACETFILTER_ACCEPT"),type:O.Emphasized,press:function(){this._closePopover()}.bind(this)});t=new F({content:[new I,i]});e.setFooter(t)}};K.prototype._getSummaryText=function(){var e=", ";var t=" ";var i="";var s=true;var a=this.getLists();if(a.length>0){for(var r=0;r<a.length;r++){var o=a[r];if(o.getActive()){var n=this._getSelectedItemsText(o);var l="";for(var g=0;g<n.length;g++){l=l+n[g]+e}if(l){l=l.substring(0,l.lastIndexOf(e)).trim();if(s){i=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[o.getTitle(),l]);s=false}else{i=i+t+this._bundle.getText("FACETFILTER_INFOBAR_AND")+t+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[o.getTitle(),l])}}}}}if(!i){i=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS")}return i};K.prototype._getSelectedItemsText=function(e){var t=e.getSelectedItems().map(function(e){return e.getText()});e._oSelectedKeys&&Object.getOwnPropertyNames(e._oSelectedKeys).forEach(function(i){t.indexOf(e._oSelectedKeys[i])===-1&&t.push(e._oSelectedKeys[i])});return t};K.prototype._addResetToSummary=function(e){if(e.getContent().length===1){e.addContent(new I({width:""}));var t=this._createResetButton();e.addContent(t);t.addStyleClass("sapUiSizeCompact");t.addStyleClass("sapMFFRefresh");t.addStyleClass("sapMFFBtnHoverable")}};K.prototype._removeResetFromSummary=function(e){if(e.getContent().length===3){var t=e.removeAggregation("content",1);t.destroy();var i=e.removeAggregation("content",1);i.destroy()}};K.prototype._removeList=function(e){if(e){var t=this._buttons[e.getId()];if(t){this.removeAggregation("buttons",t);t.destroy()}var i=this._removeFacetIcons[e.getId()];if(i){this.removeAggregation("removeIcons",i);i.destroy()}delete this._buttons[e.getId()];delete this._removeFacetIcons[e.getId()]}};K.prototype._calculateScrollIntoView=function(e){var t=this.$("head").width(),i=0;if(!t||!e){return i}var s=e.$(),a=s.outerWidth(true),r=s.position().left,o=r+a;if(o>t){i=o-t}else if(r<0){i=r}return i};K.prototype._getScrollingArrow=function(e){var t=null;var i={src:"sap-icon://navigation-"+e+"-arrow"};if(e==="left"){t=this.getAggregation("arrowLeft");if(!t){i.id=this.getId()+"-arrowScrollLeft";t=r.createControlByURI(i);var s=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var a=0;a<s.length;a++){t.addStyleClass(s[a]);t.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"))}this.setAggregation("arrowLeft",t)}}else if(e==="right"){t=this.getAggregation("arrowRight");if(!t){i.id=this.getId()+"-arrowScrollRight";t=r.createControlByURI(i);var o=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var a=0;a<o.length;a++){t.addStyleClass(o[a]);t.setTooltip(this._bundle.getText("FACETFILTER_NEXT"))}this.setAggregation("arrowRight",t)}}else{_.error("Scrolling arrow name "+e+" is not valid")}return t};K.prototype._checkOverflow=function(){var e=this.getDomRef("head"),t=jQuery(e),i=this.$(),s=false,a=false,r=false,o=null,n=null,l=null;if(e){o=e.scrollLeft;n=e.scrollWidth;l=e.clientWidth;if(n>l){if(n-l==1){n=l}else{r=true}}i.toggleClass("sapMFFScrolling",r);i.toggleClass("sapMFFNoScrolling",!r);this._lastScrolling=r;if(!this._bRtl){s=o>0;a=n>l&&n>o+l}else{a=t.scrollLeftRTL()>0;s=t.scrollRightRTL()>0}if(a!=this._bPreviousScrollForward||s!=this._bPreviousScrollBack){i.toggleClass("sapMFFNoScrollBack",!s);i.toggleClass("sapMFFNoScrollForward",!a)}}};K.prototype.onclick=function(e){var t=e.target,i=this.getId();if(!t.id){t=t.parentElement}if(!t.id){return}e.preventDefault();if(t.id==i+"-arrowScrollLeft"){t.tabIndex=-1;t.focus();this._scroll(-K.SCROLL_STEP,H)}else if(t.id==i+"-arrowScrollRight"){t.tabIndex=-1;t.focus();this._scroll(K.SCROLL_STEP,H)}};K.prototype._scroll=function(e,t){var i=this.getDomRef("head");var s=i.scrollLeft;if(this._bRtl){e=-e}var a=s+e;jQuery(i).stop(true,true).animate({scrollLeft:a},t)};K.prototype._enableTouchSupport=function(){var e=function(e){var t=this.getType();if(t===V.Light){return}e.preventDefault();if(this._iInertiaIntervalId){window.clearInterval(this._iInertiaIntervalId)}this.startScrollX=this.getDomRef("head").scrollLeft;this.startTouchX=e.touches[0].pageX;this._bTouchNotMoved=true;this._lastMoveTime=N.getInstance().getTime()}.bind(this);var t=function(e){var t=this.getType();if(t===V.Light){return}var i=e.touches[0].pageX-this.startTouchX;var s=this.getDomRef("head");var a=s.scrollLeft;var r=this.startScrollX-i;s.scrollLeft=r;this._bTouchNotMoved=false;var o=N.getInstance().getTime()-this._lastMoveTime;this._lastMoveTime=N.getInstance().getTime();if(o>0){this._velocity=(r-a)/o}e.preventDefault()}.bind(this);var i=function(e){var t=this.getType();if(t===V.Light){return}if(this._bTouchNotMoved===false){e.preventDefault();var i=this.getDomRef("head");var s=50;var a=Math.abs(this._velocity/10);this._iInertiaIntervalId=window.setInterval(function(){this._velocity=this._velocity*.8;var e=this._velocity*s;i.scrollLeft=i.scrollLeft+e;if(Math.abs(this._velocity)<a){window.clearInterval(this._iInertiaIntervalId);this._iInertiaIntervalId=undefined}}.bind(this),s)}else if(this._bTouchNotMoved===true){this.onclick(e);e.preventDefault()}this._bTouchNotMoved=undefined;this._lastMoveTime=undefined}.bind(this);this.addEventDelegate({ontouchstart:e},this);this.addEventDelegate({ontouchend:i},this);this.addEventDelegate({ontouchmove:t},this)};return K});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FacetFilterItem", ["./ListItemBase","./library","./FacetFilterItemRenderer"],function(t,e,r){"use strict";var i=t.extend("sap.m.FacetFilterItem",{metadata:{library:"sap.m",properties:{key:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},count:{type:"int",group:"Misc",defaultValue:null,deprecated:true}}},renderer:r});i.prototype.setCount=function(t){this.setProperty("count",t);this.setProperty("counter",t);return this};i.prototype.setCounter=function(t){this.setProperty("count",t);this.setProperty("counter",t);return this};i.prototype.init=function(){this.attachEvent("_change",this._itemTextChange);t.prototype.init.apply(this);this.addStyleClass("sapMFFLI")};i.prototype.exit=function(){t.prototype.exit.apply(this);this.detachEvent("_change",this._itemTextChange)};i.prototype._itemTextChange=function(t){if(t.getParameter("name")==="text"){this.informList("TextChange",t.getParameter("newValue"))}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FacetFilterItemRenderer", ["./ListItemBaseRenderer","sap/ui/core/Renderer"],function(e,t){"use strict";var r=t.extend(e);r.apiVersion=2;r.renderLIContent=function(e,t){e.openStart("div",t);if(t.getParent()&&t.getParent().getWordWrap()){e.class("sapMFFLITitleWrap")}else{e.class("sapMFFLITitle")}e.openEnd();e.text(t.getText());e.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FacetFilterList", ["./List","./library","sap/ui/model/ChangeReason","sap/ui/model/Filter","./FacetFilterListRenderer","./FacetFilterItem","sap/base/Log","sap/ui/model/FilterOperator","sap/ui/model/FilterType"],function(e,t,i,s,r,o,a,l,n){"use strict";var c=t.ListMode;var h=t.FacetFilterListDataType;var u=e.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:h.String}},events:{listOpen:{allowPreventDefault:true},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}},search:{allowPreventDefault:true,parameters:{term:{type:"string"}}}}},renderer:r});u.prototype.setTitle=function(e){this.setProperty("title",e,true);this._updateFacetFilterButtonText();return this};u.prototype.setMultiSelect=function(e){this.setProperty("multiSelect",e,true);var t=e?c.MultiSelect:c.SingleSelectMaster;this.setMode(t);return this};u.prototype.setMode=function(t){if(t===c.MultiSelect||t===c.SingleSelectMaster){e.prototype.setMode.call(this,t);this.setProperty("multiSelect",t===c.MultiSelect?true:false,true)}return this};u.prototype._applySearch=function(){var e=this._getSearchValue();if(e===null){return}this._bSearchEventDefaultBehavior&&this._search(e,true);this._updateSelectAllCheckBox()};u.prototype.getSelectedItems=function(){var t=[];var i={};var s=e.prototype.getSelectedItems.apply(this,arguments);s.forEach(function(e){t.push(new o({text:e.getText(),key:e.getKey(),selected:true}));i[e.getKey()]=true});var r=this.getSelectedKeys();var a=Object.getOwnPropertyNames(r);if(s.length<a.length){a.forEach(function(e){if(!i[e]){t.push(new o({text:r[e],key:e,selected:true}))}})}return t};u.prototype.getSelectedItem=function(){var t=e.prototype.getSelectedItem.apply(this,arguments);var i=Object.getOwnPropertyNames(this.getSelectedKeys());if(!t&&i.length>0){t=new o({text:this.getSelectedKeys()[i[0]],key:i[0],selected:true})}return t};u.prototype.removeSelections=function(t){if(this._allowRemoveSelections){t?this.setSelectedKeys():e.prototype.removeSelections.call(this,t)}return this};u.prototype.getSelectedKeys=function(){var e={};var t=this._oSelectedKeys;Object.getOwnPropertyNames(t).forEach(function(i){e[i]=t[i]});return e};u.prototype.setSelectedKeys=function(t){this._oSelectedKeys={};var i=false;t&&Object.getOwnPropertyNames(t).forEach(function(e){this._addSelectedKey(e,t[e]);i=true},this);if(i){if(this.getMode()===c.MultiSelect){this.setActive(true)}this._selectItemsByKeys()}else{e.prototype.removeSelections.call(this)}};u.prototype._getNonGroupItems=function(){var e=[];this.getItems().forEach(function(t){if(t.getMode()!==c.None){e.push(t)}});return e};u.prototype.removeSelectedKey=function(e,t){if(this._removeSelectedKey(e,t)){this._getNonGroupItems().forEach(function(t){var i=t.getKey()||t.getText();e===i&&t.setSelected(false)})}};u.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};e.prototype.removeSelections.call(this,true)};u.prototype.removeItem=function(t){var i=e.prototype.removeItem.apply(this,arguments);if(!this._filtering){i&&i.getSelected()&&this.removeSelectedKey(i.getKey(),i.getText());return i}};u.prototype.init=function(){this._firstTime=true;this._bSearchEventDefaultBehavior=true;this._saveBindInfo;this._oSelectedKeys={};e.prototype.init.call(this);this.setMode(c.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue="";this.attachUpdateFinished(function(e){var t=e.getParameter("reason");t=t?t.toLowerCase():t;if(t==="change"){var s=this.getBinding("items"),r=s?s.getModel():null;if(r&&r.getProperty(s.getPath())){this._iAllItemsCount=r.getProperty(s.getPath()).length||0}this._oSelectedKeys={};this._getNonGroupItems().forEach(function(e){if(e.getSelected()){this._addSelectedKey(e.getKey(),e.getText())}},this)}if(t!==i.Filter.toLowerCase()){this._selectItemsByKeys()}this._updateFacetFilterButtonText();this._updateSelectAllCheckBox()});this._allowRemoveSelections=true;this._bOriginalActiveState;this._iAllItemsCount};u.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._setSearchValue("");this._allowRemoveSelections=false;e.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true}};u.prototype._fireListCloseEvent=function(){var e=this.getSelectedItems();var t=this.getSelectedKeys();var i=this.isAllSelectableSelected();this._firstTime=true;this.fireListClose({selectedItems:e,selectedKeys:t,allSelected:i})};u.prototype._updateActiveState=function(){var e=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||e&&e.getSelected()){this.setActive(true)}};u.prototype._handleSearchEvent=function(e){var t=e.getParameters()["query"];if(t===undefined){t=e.getParameters()["newValue"]}this._bSearchEventDefaultBehavior=this.fireSearch({term:t,clearButtonPressed:e.getParameters()["clearButtonPressed"]});this._bSearchEventDefaultBehavior?this._search(t):this._setSearchValue(t);this._updateSelectAllCheckBox()};u.prototype._search=function(e,t){var i,r,o,c,h,u,p,d,f=0,y=this.getBinding("items"),g=this.getBindingInfo("items");function S(e){return e&&(e.isA("sap.ui.model.odata.ODataModel")||e.isA("sap.ui.model.odata.v2.ODataModel")||e.isA("sap.ui.model.odata.v4.ODataModel"))}if(t||e!==this._searchValue){this._searchValue=e;if(g&&g.binding){i=g.binding.aFilters;if(i.length>0){f=i[0].aFilters.length;if(this._firstTime){this._saveBindInfo=i[0].aFilters[0][0];this._firstTime=false}}}if(y){if(e||f>0){d=g.template?g.template:g.factory();r=d.getBindingInfo("text").parts;h=r[0].path;if(h||h===""){o=[];r.forEach(function(t){o.push(new s(t.path,l.Contains,e))});if(this.getEnableCaseInsensitiveSearch()&&S(y.getModel())){o.forEach(function(e){e.bCaseSensitive=false})}p=new s(o,false);if(f>1){u=new s([p,this._saveBindInfo],true)}else{if(this._saveBindInfo>""&&c.sPath!=this._saveBindInfo.sPath){u=new s([p,this._saveBindInfo],true)}else{if(e==""){u=[]}else{u=new s([p],true)}}}y.filter(u,n.Control)}}else{y.filter([],n.Control)}}else{a.warning("No filtering performed","The list must be defined with a binding for search to work",this)}}};u.prototype._getSearchValue=function(){return this._searchValue};u.prototype._updateSelectAllCheckBox=function(){var e=this._getNonGroupItems(),t=e.length,i,s,r;function o(e){return e.getSelected()}if(this.getMode()===c.MultiSelect){i=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));s=t>0&&t===e.filter(o).length;r=this.getActive()&&s;i&&i.setSelected(r)}};u.prototype._addSelectedKey=function(e,t){if(!e&&!t){a.error("Both sKey and sText are not defined. At least one must be defined.");return}if(this.getMode()===c.SingleSelectMaster){this.removeSelectedKeys()}if(!e){e=t}this._oSelectedKeys[e]=t||e};u.prototype._removeSelectedKey=function(e,t){if(!e&&!t){a.error("Both sKey and sText are not defined. At least one must be defined.");return false}if(!e){e=t}delete this._oSelectedKeys[e];return true};u.prototype._setSearchValue=function(e){this._searchValue=e};u.prototype._isItemSelected=function(e){return!!this._oSelectedKeys[e&&(e.getKey()||e.getText())]};u.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this)}};u.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(e){e.setSelected(this._isItemSelected(e))},this);this._updateFacetFilterButtonText()};u.prototype._handleSelectAllClick=function(e){var t,i,s=this._getNonGroupItems(),r=s.length;s.forEach(function(t){if(e){this._addSelectedKey(t.getKey(),t.getText())}else{this._removeSelectedKey(t.getKey(),t.getText())}t.setSelected(e,true)},this);function o(e){return e.getSelected()}if(this.getMode()===c.MultiSelect){i=r>0&&r===s.filter(o).length;t=this._getOriginalActiveState()||e&&i;this.setActive(t)}setTimeout(this._updateSelectAllCheckBox.bind(this),0)};u.prototype.onItemTextChange=function(e,t){var i=e.getKey();if(this._oSelectedKeys[i]&&t&&!this._filtering){this._oSelectedKeys[i]=t}};u.prototype.onItemSelectedChange=function(t,i){var s;if(i){this._addSelectedKey(t.getKey(),t.getText())}else{this._removeSelectedKey(t.getKey(),t.getText())}e.prototype.onItemSelectedChange.apply(this,arguments);if(this.getMode()===c.MultiSelect){s=this._getOriginalActiveState()||i||this.getSelectedItems().length>1;this.setActive(s)}!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();setTimeout(this._updateSelectAllCheckBox.bind(this),0)};u.prototype.updateItems=function(t){var s=document.activeElement;this._filtering=t===i.Filter;e.prototype.updateItems.apply(this,arguments);this._filtering=false;if(s&&s.getAttribute("id")!==document.activeElement.getAttribute("id")){this.focus()}if(!this.getGrowing()||t===i.Filter){this._selectItemsByKeys()}};u.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState};u.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive()};u.prototype._showBusyIndicator=function(){e.prototype._showBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange")};u.prototype._hideBusyIndicator=function(){e.prototype._hideBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange")};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FacetFilterListRenderer", ["./ListRenderer","sap/ui/core/Renderer"],function(e,r){"use strict";var i=r.extend(e);i.apiVersion=2;return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FacetFilterRenderer", ["sap/m/library","sap/ui/Device","sap/ui/core/InvisibleText"],function(e,t,r){"use strict";var n=e.FacetFilterType;var i={apiVersion:2};i.render=function(e,t){if(t.getType()===n.Light||t.getShowSummaryBar()){i.renderSummaryBar(e,t)}else{i.renderSimpleFlow(e,t)}};i.renderSimpleFlow=function(e,r){e.openStart("div",r);e.class("sapMFF");e.accessibilityState({role:"toolbar",roledescription:r._bundle.getText("FACETFILTER_TITLE")});if(r._lastScrolling){e.class("sapMFFScrolling")}else{e.class("sapMFFNoScrolling")}if(r.getShowReset()){e.class("sapMFFResetSpacer")}e.openEnd();if(t.system.desktop){e.renderControl(r._getScrollingArrow("left"))}e.openStart("div",r.getId()+"-head");e.class("sapMFFHead");e.openEnd();i.renderFacetFilterListButtons(r,e);if(r.getShowPersonalization()){i.renderAddFilterButton(r,e)}e.close("div");if(t.system.desktop){e.renderControl(r._getScrollingArrow("right"))}if(r.getShowReset()){e.openStart("div");e.class("sapMFFResetDiv");e.openEnd();e.renderControl(r.getAggregation("resetButton"));e.close("div")}e.close("div")};i.renderSummaryBar=function(e,t){e.openStart("div",t);e.class("sapMFF");e.openEnd();e.renderControl(t.getAggregation("summaryBar"));e.close("div")};i.getAriaAnnouncement=function(e,t){return r.getStaticId("sap.m",t||"FACETFILTER_"+e.toUpperCase())};i.renderFacetFilterListButtons=function(e,t){var r=e._getSequencedLists(),o=r.length,a=e.getShowPersonalization(),s=a&&e.getType()===n.Simple,d=s?o+1:o,l,c;for(c=0;c<o;c++){var g=r[c].getItems().length>0,u=r[c].getActive(),F=e._bCheckForAddListBtn&&(g||u);if(!e._bCheckForAddListBtn||F){l=e._getButtonForList(r[c]);i.addPositionInfoForButton(e,l,c+1,d);if(a){l.addAriaDescribedBy(i.getAriaAnnouncement("ARIA_REMOVE"))}t.renderControl(l);if(a){t.renderControl(e._getFacetRemoveIcon(r[c]))}}}return this};i.renderAddFilterButton=function(e,t){var r=e.getAggregation("addFacetButton"),n=e._getSequencedLists().length+1;i.addPositionInfoForButton(e,r,n,n);t.renderControl(r);return this};i.addPositionInfoForButton=function(e,t,r,n){var o=i.createStaticPositioningLabel(e,r,n);i.clearOldPositioningLabels(e,t);t.addAriaDescribedBy(o);return this};i.clearOldPositioningLabels=function(e,t){var r=t.removeAllAriaDescribedBy(),n=this.getAriaAnnouncement("ARIA_REMOVE"),i;r.forEach(function(e){if(n===e){return}i=sap.ui.getCore().byId(e);i&&i.destroy()});return this};i.createStaticPositioningLabel=function(e,t,n){var i=sap.ui.getCore().getLibraryResourceBundle("sap.m"),o=i.getText("FACETFILTER_ARIA_FACET_FILTER"),a=i.getText("FACETFILTERLIST_ARIA_POSITION",[t,n]),s=new r({text:o+" "+a}).toStatic();e._aOwnedLabels.push(s.getId());return s};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FeedContent", ["./library","sap/ui/core/Control","sap/m/Text","sap/ui/Device","./FeedContentRenderer","sap/ui/events/KeyCodes"],function(t,e,i,n,o,s){"use strict";var r=t.Size;var a=e.extend("sap.m.FeedContent",{metadata:{library:"sap.m",properties:{size:{type:"sap.m.Size",group:"Misc",defaultValue:r.Auto,deprecated:true},contentText:{type:"string",group:"Misc",defaultValue:null},subheader:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueColor:{type:"sap.m.ValueColor",group:"Misc",defaultValue:null},truncateValueTo:{type:"int",group:"Misc",defaultValue:4}},defaultAggregation:"_contentTextAgr",aggregations:{_contentTextAgr:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:o});a.prototype.init=function(){this._oContentText=new i(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentTextAgr",this._oContentText,true);this.setTooltip("{AltText}")};a.prototype.onBeforeRendering=function(){this.$().off("mouseenter");this.$().off("mouseleave")};a.prototype.onAfterRendering=function(){this.$().on("mouseenter",this._addTooltip.bind(this));this.$().on("mouseleave",this._removeTooltip.bind(this))};a.prototype.exit=function(){this._oContentText=null};a.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString())};a.prototype._removeTooltip=function(){this.$().attr("title",null)};a.prototype.getAltText=function(){var t="";var e=true;if(this.getAggregation("_contentTextAgr").getText()){t+=this.getAggregation("_contentTextAgr").getText();e=false}if(this.getSubheader()){if(e){t+=""+this.getSubheader()}else{t+="\n"+this.getSubheader()}e=false}if(this.getValue()){if(e){t+=""+this.getValue()}else{t+="\n"+this.getValue()}}return t};a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var e=this.getAltText();if(typeof t==="string"||t instanceof String){e=t.split("{AltText}").join(e).split("((AltText))").join(e);return e}if(t){return t}else{return""}};a.prototype.setContentText=function(t){this._oContentText.setText(t);return this};a.prototype.ontap=function(t){if(n.browser.msie){this.$().trigger("focus")}this.firePress()};a.prototype.onkeydown=function(t){if(t.which===s.ENTER||t.which===s.SPACE){this.firePress();t.preventDefault()}};a.prototype.attachEvent=function(t,i,n,o){e.prototype.attachEvent.call(this,t,i,n,o);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer")}return this};a.prototype.detachEvent=function(t,i,n){e.prototype.detachEvent.call(this,t,i,n);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer")}return this};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FeedContentRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var s=t.getSubheader();var a=t.getValue();var r=t.getTooltip_AsString();if(typeof r!=="string"){r=""}e.openStart("div",t);e.attr("role","presentation");e.attr("aria-label",r);e.class("sapMFC");if(t.hasListeners("press")){e.attr("tabindex","0");e.class("sapMPointer")}e.openEnd();if(a){e.openStart("div",t.getId()+"-value");e.class("sapMFCValue");e.class(t.getValueColor());e.openEnd();var n=t.getTruncateValueTo();if(a.length>=n&&(a[n-1]==="."||a[n-1]===",")){e.text(a.substring(0,n-1))}else if(a){e.text(a.substring(0,n))}else{e.text("")}e.close("div")}e.openStart("div");e.class("sapMFCCTxt");e.openEnd();e.renderControl(t._oContentText);e.close("div");e.openStart("div",t.getId()+"-subheader");e.class("sapMFCSbh");e.openEnd();e.text(s);e.close("div");e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FeedInput", ["./library","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/TextArea","sap/m/Button","./FeedInputRenderer","sap/ui/thirdparty/jquery","sap/base/security/URLListValidator","sap/base/security/sanitizeHTML","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize","sap/ui/core/Lib"],function(t,e,s,i,a,r,jQuery,o,n,l,u,p,h){"use strict";var g=t.ButtonType;var c=15,d=2,y=0;var f=e.extend("sap.m.FeedInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedInput.designtime",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},rows:{type:"int",group:"Appearance",defaultValue:2},showExceededText:{type:"boolean",group:"Behavior",defaultValue:false},maxLength:{type:"int",group:"Behavior",defaultValue:0},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingMaxLines:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Appearance",defaultValue:"Post something here"},value:{type:"string",group:"Data",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:u.Circle},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:p.M},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},buttonTooltip:{type:"sap.ui.core.TooltipBase",group:"Accessibility",defaultValue:"Submit"},ariaLabelForPicture:{type:"string",group:"Accessibility",defaultValue:null}},aggregations:{_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}},events:{post:{parameters:{value:{type:"string"}}}}},renderer:r});var T={ATTRIBS:{style:1,class:1,"a::href":1,"a::target":1},ELEMENTS:{a:{cssClass:"sapMLnk"},abbr:1,blockquote:1,br:1,cite:1,code:1,em:1,h1:{cssClass:"sapMTitle sapMTitleStyleH1"},h2:{cssClass:"sapMTitle sapMTitleStyleH2"},h3:{cssClass:"sapMTitle sapMTitleStyleH3"},h4:{cssClass:"sapMTitle sapMTitleStyleH4"},h5:{cssClass:"sapMTitle sapMTitleStyleH5"},h6:{cssClass:"sapMTitle sapMTitleStyleH6"},p:1,pre:1,strong:1,span:1,u:1,dl:1,dt:1,dd:1,ol:1,ul:1,li:1}};f.prototype._renderingRules=T;function v(t,e){var s,i,a=t==="a";var r=this._renderingRules.ELEMENTS[t]&&this._renderingRules.ELEMENTS[t].cssClass?this._renderingRules.ELEMENTS[t].cssClass:"";for(var n=0;n<e.length;n+=2){s=e[n];i=e[n+1];if(!this._renderingRules.ATTRIBS[s]&&!this._renderingRules.ATTRIBS[t+"::"+s]){e[n+1]=null;continue}if(s=="href"){if(!o.validate(i)){e[n+1]="#";a=false}}if(s=="target"){a=false}if(r&&s.toLowerCase()=="class"){e[n+1]=r+" "+i;r=""}}if(a){e.push("target");e.push("_blank")}if(r){e.push("class");e.push(r)}return e}function x(t,e){return v.call(this,t,e)}f.prototype._sanitizeHTML=function(t){return n(t,{tagPolicy:x.bind(this),uriRewriter:function(t){if(o.validate(t)){return t}}})};f.prototype.init=function(){var t=h.getResourceBundleFor("sap.m");this.setProperty("placeholder",t.getText("FEEDINPUT_PLACEHOLDER"),true);this.setProperty("buttonTooltip",t.getText("FEEDINPUT_SUBMIT"),true)};f.prototype.exit=function(){if(this._oTextArea){this._oTextArea.destroy()}if(this._oButton){this._oButton.destroy()}if(this.oAvatar){this.oAvatar.destroy()}};f.prototype.setRows=function(t){var e=this.getProperty("growingMaxLines");if(t>c){t=c}else if(t<d){t=d}if(t>e&&e!==0){this.setProperty("growingMaxLines",t,true);this._getTextArea().setGrowingMaxLines(t)}this.setProperty("rows",t,true);this._getTextArea().setRows(t);return this};f.prototype.setShowExceededText=function(t){this.setProperty("showExceededText",t,true);this._getTextArea().setShowExceededText(t);return this};f.prototype.setMaxLength=function(t){this.setProperty("maxLength",t,true);this._getTextArea().setMaxLength(t);return this};f.prototype.setGrowing=function(t){this.setProperty("growing",t,true);this._getTextArea().setGrowing(t);return this};f.prototype.setGrowingMaxLines=function(t){var e=this.getProperty("rows");if(t!==y){if(t<e){t=e}else if(t>c){t=c}}this.setProperty("growingMaxLines",t,true);this._getTextArea().setGrowingMaxLines(t);return this};f.prototype.setValue=function(t){this.setProperty("value",t,true);this._getTextArea().setValue(t);this._enablePostButton();return this};f.prototype.setPlaceholder=function(t){this.setProperty("placeholder",t,true);this._getTextArea().setPlaceholder(t);return this};f.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);if(this.getDomRef("outerContainer")){if(t){this.getDomRef("outerContainer").classList.remove("sapMFeedInDisabled")}else{this.getDomRef("outerContainer").classList.add("sapMFeedInDisabled")}}this._getTextArea().setEnabled(t);this._enablePostButton();return this};f.prototype.setButtonTooltip=function(t){this.setProperty("buttonTooltip",t,true);this._getPostButton().setTooltip(t);return this};f.prototype._getTextArea=function(){var t=this;if(!this._oTextArea){this._oTextArea=new i(this.getId()+"-textArea",{value:this.getValue(),maxLength:this.getMaxLength(),placeholder:this.getPlaceholder(),growing:this.getGrowing(),growingMaxLines:this.getGrowingMaxLines(),showExceededText:this.getShowExceededText(),rows:this.getRows(),liveChange:jQuery.proxy(function(t){var e=t.getParameter("value");this.setProperty("value",e,true);this._enablePostButton()},this)});this._oTextArea.setParent(this);this._oTextArea.addEventDelegate({onAfterRendering:function(){t.$("counterContainer").empty();t.$("counterContainer").html(t._oTextArea.getAggregation("_counter").$())}})}return this._oTextArea};f.prototype._getPostButton=function(){if(!this._oButton){this._oButton=new a(this.getId()+"-button",{enabled:false,type:g.Default,icon:"sap-icon://paper-plane",tooltip:this.getButtonTooltip(),press:jQuery.proxy(function(){this._oTextArea.focus();this.firePost({value:this._sanitizeHTML(this.getValue())});this.setValue(null)},this)});this._oButton.setParent(this)}return this._oButton};f.prototype._enablePostButton=function(){var t=this._isControlEnabled();var e=this._getPostButton();e.setEnabled(t)};f.prototype._isControlEnabled=function(){var t=this.getValue();return this.getEnabled()&&(typeof t==="string"||t instanceof String)&&t.trim().length>0};f.prototype._getAvatar=function(){var t=this.getIcon();var e=this.getId()+"-icon";this.oAvatar=this.getAggregation("_avatar");if(!this.oAvatar){this.oAvatar=new l({id:e,src:t,displayShape:this.getIconDisplayShape(),initials:this.getIconInitials(),displaySize:this.getIconSize()}).addStyleClass("sapMFeedInImage");if(t){this.oAvatar.addStyleClass("sapMFeedInImageBgColor")}}else{this.oAvatar.setSrc(t).setDisplayShape(this.getIconDisplayShape()).setInitials(this.getIconInitials()).setDisplaySize(this.getIconSize())}this.setAggregation("_avatar",this.oAvatar);return this.oAvatar};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FeedInputRenderer", ["sap/ui/core/Lib"],function(e){"use strict";var n=e.getResourceBundleFor("sap.m");var t={apiVersion:2};t.render=function(e,t){var a=t.getId();e.openStart("div",t);e.class("sapMFeedInBase");e.attr("role","group");e.attr("aria-label",n.getText("FEED_INPUT_ARIA_LABEL"));e.openEnd();e.openStart("div",a+"-outerContainer");e.class("sapMFeedIn");if(!t.getShowIcon()){e.class("sapMFeedInNoIcon")}if(!t.getEnabled()){e.class("sapMFeedInDisabled")}e.openEnd();if(t.getShowIcon()){this._addImage(e,t,a)}e.openStart("div",a+"-container");e.class("sapMFeedInContainer");e.openEnd();var o=t._getTextArea();e.renderControl(o);e.renderControl(t._getPostButton());e.close("div");e.close("div");e.openStart("div",a+"-counterContainer");e.class("sapMFeedInCounter");e.openEnd();e.close("div");e.close("div")};t._addImage=function(e,n,t){e.openStart("figure",t+"-figure").class("sapMFeedInFigure");if(!n.getIcon()){e.class("sapMFeedListItemIsDefaultIcon")}e.openEnd();e.renderControl(n._getAvatar());e.close("figure")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FeedListItem", ["./ListItemBase","./Link","./library","./FormattedText","sap/ui/core/IconPool","sap/m/Button","sap/ui/Device","./FeedListItemRenderer","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize","sap/ui/util/openWindow","sap/ui/core/Configuration","sap/ui/core/Lib"],function(t,e,i,a,o,s,n,r,l,p,h,g,u,d){"use strict";var c=i.ListType;var f=i.LinkConversion;var _=i.ButtonType;var x=t.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedListItem.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:p.Circle},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:h.S},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},moreLabel:{type:"string",group:"Data",defaultValue:null},lessLabel:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:f.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},defaultAggregation:"actions",aggregations:{actions:{type:"sap.m.FeedListItemAction",multiple:true},_text:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_actionButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}},renderer:r});x._oRb=d.getResourceBundleFor("sap.m");x._nMaxCharactersMobile=300;x._nMaxCharactersDesktop=500;x._sTextShowMore=x._oRb.getText("TEXT_SHOW_MORE");x._sTextShowLess=x._oRb.getText("TEXT_SHOW_LESS");x.prototype.init=function(){t.prototype.init.apply(this);this.setAggregation("_text",new a(this.getId()+"-formattedText"),true);this.setAggregation("_actionButton",new s({id:this.getId()+"-actionButton",type:_.Transparent,icon:"sap-icon://overflow",press:[this._onActionButtonPress,this]}),true)};x.prototype._onActionButtonPress=function(){sap.ui.require(["sap/m/ActionSheet"],this._openActionSheet.bind(this))};x.prototype._openActionSheet=function(t){var e=this.getAggregation("_actionSheet");var i=this.getActions();var a;if(!(e&&e instanceof t)){e=new t({id:this.getId()+"-actionSheet",beforeOpen:[this._onBeforeOpenActionSheet,this]});this.setAggregation("_actionSheet",e,true)}e.destroyAggregation("buttons",true);for(var o=0;o<i.length;o++){a=i[o];e.addButton(new s({icon:a.getIcon(),text:a.getText(),visible:a.getVisible(),enabled:a.getEnabled(),press:a.firePress.bind(a,{item:this})}))}e.openBy(this.getAggregation("_actionButton"))};x.prototype._onBeforeOpenActionSheet=function(t){var e,i;if(n.system.phone){return}i=u.getTheme();e=t.getSource().getParent();e.removeStyleClass("sapContrast sapContrastPlus");if(i==="sap_belize"){e.addStyleClass("sapContrast")}else if(i==="sap_belize_plus"){e.addStyleClass("sapContrastPlus")}};x.prototype.invalidate=function(){t.prototype.invalidate.apply(this,arguments);var e=x._sTextShowMore;if(this.getMoreLabel()){e=this.getMoreLabel()}delete this._bTextExpanded;if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.setProperty("text",e,true)}};x.prototype.onBeforeRendering=function(){this.$("realtext").find('a[target="_blank"]').off("click");var t=this.getAggregation("_text");t.setProperty("convertLinksToAnchorTags",this.getConvertLinksToAnchorTags(),true);t.setProperty("convertedLinksDefaultTarget",this.getConvertedLinksDefaultTarget(),true);if(this.getConvertLinksToAnchorTags()===f.None){t.setHtmlText(this.getText())}else{t.setProperty("htmlText",this.getText(),true)}this._sFullText=t._getDisplayHtml().replace(/\n/g,"<br>");this._sShortText=this._getCollapsedText();if(this._sShortText){this._sShortText=this._sShortText.replace(/<br>/g," ")}this._bEmptyTagsInShortTextCleared=false};x.prototype.onAfterRendering=function(){var t=this.getAggregation("_text"),e=this.getDomRef();if(document.getElementById(this.getAggregation("_actionButton"))){document.getElementById(this.getAggregation("_actionButton").getId()).setAttribute("aria-haspopup","menu")}if(this._checkTextIsExpandable()&&!this._bTextExpanded){this._clearEmptyTagsInCollapsedText()}this.$("realtext").find('a[target="_blank"]').on("click",v);e&&t&&t._sanitizeCSSPosition(e.querySelector(".sapMFeedListItemText"))};x.prototype.exit=function(){this.$("realtext").find('a[target="_blank"]').off("click",v);if(this._oLinkControl){this._oLinkControl.destroy()}if(this.oAvatar){this.oAvatar.destroy()}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy()}t.prototype.exit.apply(this)};function v(t){if(t.originalEvent.defaultPrevented){return}t.preventDefault();g(t.currentTarget.href,t.currentTarget.target)}x.prototype.ontap=function(e){if(e.srcControl){if(!this.getIconActive()&&this.oAvatar&&e.srcControl.getId()===this.oAvatar.getId()||!this.getSenderActive()&&this._oLinkControl&&e.srcControl.getId()===this._oLinkControl.getId()||(!this.oAvatar||e.srcControl.getId()!==this.oAvatar.getId()&&(!this._oLinkControl||e.srcControl.getId()!==this._oLinkControl.getId())&&(!this._oLinkExpandCollapse||e.srcControl.getId()!==this._oLinkExpandCollapse.getId()))){t.prototype.ontap.apply(this,[e])}}};x.prototype.onfocusin=function(t){var e=t.srcControl,i=e.getDomRef(),a=this.getParent().getAccessbilityPosition(e);if(e instanceof x){i.setAttribute("aria-posinset",a.posInset);i.setAttribute("aria-setsize",a.setSize)}};x.prototype._getAvatar=function(){var t=this.getIcon();var e=this.getId()+"-icon";this.oAvatar=this.getAggregation("_avatar");this.oAvatar=this.oAvatar||new l(e);this.oAvatar.applySettings({src:t,displayShape:this.getIconDisplayShape(),initials:this.getIconInitials(),displaySize:this.getIconSize(),ariaLabelledBy:this.getSender()});var i=this;if(this.getIconActive()){this.oAvatar.addStyleClass("sapMFeedListItemImage");if(!this.oAvatar.hasListeners("press")){this.oAvatar.attachPress(function(){i.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)})})}}else{this.oAvatar.addStyleClass("sapMFeedListItemImageInactive")}this.setAggregation("_avatar",this.oAvatar);return this.oAvatar};x.prototype._getLinkSender=function(t){if(!this._oLinkControl){var i=this;this._oLinkControl=new e({press:function(){i.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)})}});this._oLinkControl.setParent(this,null,true)}if(t){this._oLinkControl.setText(this.getSender()+x._oRb.getText("COLON"))}else{this._oLinkControl.setText(this.getSender())}this._oLinkControl.setEnabled(this.getSenderActive());return this._oLinkControl};x.prototype._activeHandlingInheritor=function(){var t=this.getActiveIcon();if(this.oAvatar&&t){this.oAvatar.setSrc(t)}};x.prototype._inactiveHandlingInheritor=function(){var t=this.getIcon()?this.getIcon():o.getIconURI("person-placeholder");if(this.oAvatar){this.oAvatar.setSrc(t)}};x.prototype._getCollapsedText=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(n.system.phone){this._nMaxCollapsedLength=x._nMaxCharactersMobile}else{this._nMaxCollapsedLength=x._nMaxCharactersDesktop}}var t=this._convertHtmlToPlainText(this._sFullText);var e=null;if(t&&t.length>this._nMaxCollapsedLength){var i=t.substring(0,this._nMaxCollapsedLength);var a=i.lastIndexOf(" ");if(a>0){i=i.substr(0,a)}if(t.length===this._sFullText.length){e=i}else{e=this._convertPlainToHtmlText(i)}}return e};x.prototype._clearEmptyTagsInCollapsedText=function(){var t;if(this._bEmptyTagsInShortTextCleared){return}this._bEmptyTagsInShortTextCleared=true;do{t=this.$("realtext").find(":empty").remove()}while(t.length>0);this._sShortText=this.$("realtext").html()};x.prototype._toggleTextExpanded=function(){var t=this.$("realtext");var e=this.$("threeDots");var i=x._sTextShowMore;var a=x._sTextShowLess;var o=this.getAggregation("_text");if(this.getMoreLabel()){i=this.getMoreLabel()}if(this.getLessLabel()){a=this.getLessLabel()}t.find('a[target="_blank"]').off("click");if(this._bTextExpanded){t.html(this._sShortText.replace(/&#xa;/g,"<br>"));o._sanitizeCSSPosition(t[0]);e.text(" ... ");this._oLinkExpandCollapse.setText(i);this._bTextExpanded=false;this._clearEmptyTagsInCollapsedText()}else{t.html(this._sFullText.replace(/&#xa;/g,"<br>"));o._sanitizeCSSPosition(t[0]);e.text("  ");this._oLinkExpandCollapse.setText(a);this._bTextExpanded=true}t.find('a[target="_blank"]').on("click",v)};x.prototype._getLinkExpandCollapse=function(){var t=x._sTextShowMore;if(this.getMoreLabel()){t=this.getMoreLabel()}if(!this._oLinkExpandCollapse){this._oLinkExpandCollapse=new e({text:t,press:[this._toggleTextExpanded,this]});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true)}return this._oLinkExpandCollapse};x.prototype._convertHtmlToPlainText=function(t){var e=/(<([^>]+)>)/gi;return t.replace(e,"")};x.prototype._convertPlainToHtmlText=function(t){var e=this._sFullText;var i=/(<([^>]+)>)/gi;var a=e.split(i);var o="";for(var s=0;s<a.length;s++){if(a[s].length===0){continue}if(t.length>0&&a[s].indexOf(t.trim())!==-1){a[s]=t}if(/^<.+>$/.test(a[s])){o=o+a[s];a[s+1]="";continue}if(t.indexOf(a[s].trim())===-1){continue}else{t=t.replace(a[s],"")}o=o+a[s]}return o};x.prototype._checkTextIsExpandable=function(){return this._sShortText!==null};x.prototype.setType=function(t){if(this.getType()!==t){if(t===c.Navigation){this.setProperty("type",c.Active)}else{this.setProperty("type",t)}}return this};return x});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FeedListItemAction", ["sap/ui/core/Element"],function(e){"use strict";var a=e.extend("sap.m.FeedListItemAction",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},key:{type:"string",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Appearance",defaultValue:true},enabled:{type:"boolean",group:"Appearance",defaultValue:true}},events:{press:{}}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FeedListItemRenderer", ["./ListItemBaseRenderer","sap/ui/core/Renderer","sap/ui/Device","sap/ui/core/Configuration"],function(e,t,s,a){"use strict";var n=t.extend(e);n.apiVersion=2;n.renderLIAttributes=function(e,t){e.class("sapMFeedListItemTitleDiv");e.class("sapMFeedListShowSeparatorsAll")};n.renderLIContent=function(e,t){var n=t.getId(),i=s.system.phone;e.openStart("div");e.class("sapMFeedListItem");e.openEnd();if(t.getShowIcon()){this._writeAvatarControl(e,t,n)}if(t.getActions().length>0){var p=t.getActions().every(function(e){return e.getVisible()===false});if(!p){e.openStart("div",n+"-action-button");e.class("sapMFeedListItemActionButton");e.openEnd();e.renderControl(t.getAggregation("_actionButton"));e.close("div")}}if(i){e.openStart("div").class("sapMFeedListItemHeader").class("sapUiSelectable");if(t.getShowIcon()){e.class("sapMFeedListItemHasFigure")}if(t.getSender()&&t.getTimestamp()){e.class("sapMFeedListItemFullHeight")}e.openEnd();if(t.getSender()){e.openStart("p",n+"-name").class("sapMFeedListItemTextName").class("sapUiSelectable").openEnd();e.renderControl(t._getLinkSender(false));e.close("p")}if(t.getTimestamp()){e.openStart("p",n+"-timestamp").class("sapMFeedListItemTimestamp").class("sapUiSelectable").openEnd();e.text(t.getTimestamp());e.close("p")}e.close("div");e.openStart("div").class("sapMFeedListItemText").class("sapUiSelectable").openEnd();this._writeText(e,t,n,i);if(t._checkTextIsExpandable()){this._writeCollapsedText(e,t,n)}else{e.unsafeHtml(t._sFullText);e.close("span")}e.close("div");if(t.getInfo()){e.openStart("p").class("sapMFeedListItemFooter").class("sapUiSelectable").openEnd();if(t.getInfo()){e.openStart("span",n+"-info").class("sapMFeedListItemInfo").class("sapUiSelectable").openEnd();e.text(t.getInfo());e.close("span")}e.close("p")}}else{e.openStart("div").class("sapMFeedListItemText");if(t.getShowIcon()){e.class("sapMFeedListItemHasFigure")}e.openEnd();e.openStart("div",n+"-text").class("sapMFeedListItemTextText").class("sapUiSelectable").openEnd();if(t.getSender()){e.openStart("span",n+"-name").class("sapMFeedListItemTextName").class("sapUiSelectable").openEnd();e.renderControl(t._getLinkSender(true));e.close("span")}this._writeText(e,t,n,i);if(t._checkTextIsExpandable()){this._writeCollapsedText(e,t,n)}else{e.unsafeHtml(t._sFullText);e.close("span")}e.close("div");if(t.getInfo()||t.getTimestamp()){e.openStart("p").class("sapMFeedListItemFooter").class("sapUiSelectable").openEnd();if(!a.getRTL()){if(t.getInfo()){this._writeInfo(e,t,n);if(t.getTimestamp()){e.openStart("span").openEnd();e.text("  ·  ");e.close("span")}}if(t.getTimestamp()){this._writeTimestamp(e,t,n)}}else{if(t.getTimestamp()){this._writeTimestamp(e,t,n)}if(t.getInfo()){if(t.getTimestamp()){e.openStart("span").openEnd();e.text("  ·  ");e.close("span")}this._writeInfo(e,t,n)}}e.close("p")}e.close("div")}e.close("div")};n._writeAvatarControl=function(e,t,s){e.openStart("figure",s+"-figure");e.class("sapMFeedListItemFigure");if(!t.getIcon()){e.class("sapMFeedListItemIsDefaultIcon")}e.openEnd();e.renderControl(t._getAvatar());e.close("figure")};n._writeCollapsedText=function(e,t,s){if(t._bTextExpanded){e.unsafeHtml(t._sFullText);e.close("span");e.openStart("span",s+"-threeDots").class("sapMFeedListItemTextString").openEnd();e.text(" ");e.close("span")}else{e.unsafeHtml(t._sShortText);e.close("span");e.openStart("span",s+"-threeDots").class("sapMFeedListItemTextString").openEnd();e.text(" ... ");e.close("span")}var a=t._getLinkExpandCollapse();a.addStyleClass("sapMFeedListItemLinkExpandCollapse");e.renderControl(a)};n._writeTimestamp=function(e,t,s){e.openStart("span",s+"-timestamp");e.class("sapMFeedListItemTimestampText");e.class("sapUiSelectable");if(t.getUnread()){e.class("sapMFeedListItem-Unread")}e.openEnd();e.text(t.getTimestamp());e.close("span")};n._writeInfo=function(e,t,s){e.openStart("span",s+"-info");e.class("sapMFeedListItemInfoText");e.class("sapUiSelectable");if(t.getUnread()){e.class("sapMFeedListItem-Unread")}e.openEnd();e.text(t.getInfo());e.close("span")};n._writeText=function(e,t,s,a){e.openStart("span",s+"-realtext");e.class(a?"sapMFeedListItemText":"sapMFeedListItemTextString");e.class("sapMFeedListItemText");e.class("sapUiSelectable");if(t.getUnread()){e.class("sapMFeedListItem-Unread")}e.openEnd()};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Fiori20Adapter", ["sap/ui/base/Object","sap/ui/base/EventProvider","sap/ui/base/ManagedObjectObserver","sap/ui/core/Core","sap/ui/Device","sap/base/Log","sap/ui/thirdparty/jquery"],function(e,t,n,a,i,o,jQuery){"use strict";var r=new t,s,d,g;var u=e.extend("HeaderAdapter",{constructor:function(e,t){if(!e||!t){o.error("Cannot initialize: Invalid arguments.");return}this._oHeader=e;this._oStyledPage=null;this._oTitleInfo=null;this._oSubTitleInfo=null;this._oBackButtonInfo=null;this._oAdaptOptions=t}});u.prototype.adapt=function(){var e=this._oAdaptOptions.bStylePage,t=this._oAdaptOptions.bCollapseHeader;if(e){this._toggleStyle("sapF2Adapted",true,true)}this._adaptTitle();this._adaptBackButton();if(t){this._collapseHeader()}return this.getAdaptedContent()};u.prototype.getAdaptedContent=function(){return{oTitleInfo:this._oTitleInfo,oSubTitleInfo:this._oSubTitleInfo,oBackButtonInfo:this._oBackButtonInfo,oStyledPage:this._oStyledPage}};u.prototype._adaptTitle=function(){if(!u._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bMoveTitle!==true){return false}this._oTitleInfo=this._detectTitle();this._oSubTitleInfo=this._detectSubTitle();var e=!!this._oTitleInfo||!!this._oSubTitleInfo;if(this._oTitleInfo){this._oTitleInfo.oControl.toggleStyleClass("sapF2AdaptedTitle",true)}return e};u.prototype._adaptBackButton=function(){if(!u._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bHideBackButton!==true){return false}var e,t=false;this._oBackButtonInfo=this._detectBackButton();if(this._oBackButtonInfo){e=this._oBackButtonInfo.oControl.getVisible();this._oBackButtonInfo.oControl.toggleStyleClass("sapF2AdaptedNavigation",e);t=true}return t};u.prototype._toggleStyle=function(e,t,n){var a=this._oHeader.getParent();if(!a){return}this._oStyledPage=a;if(t===true){a.addStyleClass(e,n)}else if(t===false){a.removeStyleClass(e,n)}else if(t===undefined){a.hasStyleClass(e)?a.removeStyleClass(e,n):a.addStyleClass(e,n)}};u._isAdaptableHeader=function(e){if(!e||!c(e,"sap/m/Bar")){return false}var t=e.getParent();return t&&(c(t,"sap/m/Page")||c(t,"sap/m/MessagePage")||c(t,"sap/uxap/ObjectPageHeader"))};u.prototype._detectTitle=function(){var e;if(u._isAdaptableHeader(this._oHeader)){var t=this._oHeader.getContentMiddle();if(t.length===1&&f(t[0])){var n=t[0];e={id:n.getId(),text:n.getText(),oControl:n,sChangeEventId:"_change",sPropertyName:"text"}}}return e};u.prototype._detectSubTitle=function(e){if(c(e,"sap/uxap/ObjectPageHeader")){var t=e.getHeaderTitle();if(t){return{id:t.getId(),text:t.getObjectTitle(),oControl:t,sChangeEventId:"_titleChange",sPropertyName:"objectTitle"}}}};u.prototype._detectBackButton=function(){var e,t;if(u._isAdaptableHeader(this._oHeader)){e=this._oHeader.getContentLeft();if(e.length>0&&c(e[0],"sap/m/Button")&&(e[0].getType()==="Back"||e[0].getType()==="Up"||e[0].getIcon()==="sap-icon://nav-back")){t=e[0];return{id:t.getId(),oControl:t,sChangeEventId:"_change",sPropertyName:"visible"}}}};u.prototype._collapseHeader=function(){var e=this._oTitleInfo,t=this._oBackButtonInfo,n,a,i,o,r,s,d;if(u._isAdaptableHeader(this._oHeader)){n=this._oHeader.getContentLeft();a=this._oHeader.getContentMiddle();i=this._oHeader.getContentRight();o=n.length===1&&(C(n[0])||t);r=a.length===1&&(C(a[0])||e);s=i.length===1&&C(i[0]);d=(n.length===0||o)&&(a.length===0||r)&&(i.length===0||s);this._toggleStyle("sapF2CollapsedHeader",d,true)}};var l=e.extend("sap.m.Fiori20Adapter",{});l.attachViewChange=function(e,t){r.attachEvent("adaptedViewChange",e,t)};l.detachViewChange=function(e,t){r.detachEvent("adaptedViewChange",e,t)};l.traverse=function(e,t){s={aViewTitles:{},aViewSubTitles:{},aViewBackButtons:{}};d={};g=null;this._doBFS([{oNode:e,oAdaptOptions:t}]);var n=this._getCurrentlyAdaptedTopViewId();if(n&&a.byId(n)){this._fireViewChange(n,t)}};l._doBFS=function(e){var t=e.shift();if(!t){return}var n=t.oNode,a=t.oAdaptOptions,i=a.iSearchDepth;a=this._applyRules(a,n);if(!this._isAdaptationRequired(n,a)||i<=0){return}var o=this._isTopNavigableView(n);if(o){this._setAsCurrentlyAdaptedTopViewId(n.getId())}var r=this._processNode(n,a);var s=this._getNodeChildren(n),d=jQuery.extend({},a,{iSearchDepth:this._updateSearchDepth(i,n)});if(r){var g=!!r.oTitleInfo,u=!!r.oBackButton,l=!!r.oStyledPage;d=jQuery.extend(d,{bMoveTitle:a.bMoveTitle&&!g,bHideBackButton:a.bHideBackButton&&!u,bStylePage:a.bStylePage&&!l})}s.forEach(function(t){if(t){e.push({oNode:t,oAdaptOptions:d})}});this._doBFS(e)};l._processNode=function(e,t){this._attachDefferedAdaptationListeners(e,t);if(u._isAdaptableHeader(e)){return this._adaptHeader(e,t)}if(e.getParent()&&c(e.getParent(),"sap/m/NavContainer")){return this._getCachedViewInfoToMerge(e.getId())}};l._attachDefferedAdaptationListeners=function(e,t){this._attachAdaptableContentChange(e,t);this._attachNavigablePageChange(e,t);if(c(e,"sap/m/Page")||c(e,"sap/ui/core/mvc/XMLView")){this._observeAddAggregation(e,"content",t)}if(c(e,"sap/m/NavContainer")){this._observeRemoveAggregation(e,"pages",t)}if(t.bLateAdaptation===true&&c(e,"sap/m/Bar")){this._observeAddAggregation(e,"contentLeft",t,e);this._observeAddAggregation(e,"contentMiddle",t,e);this._observeAddAggregation(e,"contentRight",t,e)}if(c(e,"sap/ui/core/ComponentContainer")){var n=e.getComponentInstance();if(!n&&e.getName()&&!e.getDomRef()){var a=this;var i={onBeforeRendering:function(){e.removeEventDelegate(i);a._doBFS([{oNode:e.getComponentInstance(),oAdaptOptions:t}]);if(a._getCurrentlyAdaptedTopViewId()){a._fireViewChange(a._getCurrentlyAdaptedTopViewId(),t)}}};e.addEventDelegate(i,this)}}};l._checkHasListener=function(e,t){var n=d[e.getId()];return n&&n[t]};l._setHasListener=function(e,t,n){var a=d[e.getId()];if(!a){a={};d[e.getId()]=a}a[t]=n};l._attachAdaptableContentChange=function(e,t){if(typeof e._getAdaptableContent!=="function"){return}if(this._checkHasListener(e,"_adaptableContentChange")){return}var n=this._getCurrentlyAdaptedTopViewId(),i;var o=function(e){var o=e.getParameter("adaptableContent");this._setAsCurrentlyAdaptedTopViewId(n);this._doBFS([{oNode:o,oAdaptOptions:t}]);i=this._getCurrentlyAdaptedTopViewId();if(i&&a.byId(i)){this._fireViewChange(i,t)}}.bind(this);e.attachEvent("_adaptableContentChange",o);this._setHasListener(e,"_adaptableContentChange",o)};l._attachNavigablePageChange=function(e,t){if(!c(e,"sap/m/NavContainer")){return}if(this._checkHasListener(e,"navigate")){return}var n=function(e){var n,i=e.getParameter("to");t=this._applyRules(t,i);this._doBFS([{oNode:i,oAdaptOptions:t}]);n=this._getCurrentlyAdaptedTopViewId();if(n&&a.byId(n)){this._fireViewChange(n,t)}}.bind(this);e.attachNavigate(n);this._setHasListener(e,"navigate",n)};l._observeAddAggregation=function(e,t,i,o){if(this._checkHasListener(e,t)){return}var r=this._getCurrentlyAdaptedTopViewId(),s,d=function(e){var t=e.mutation,n=e.object;if(t==="add"||t==="insert"){this._setAsCurrentlyAdaptedTopViewId(r);this._doBFS([{oNode:o?o:n,oAdaptOptions:i}]);s=this._getCurrentlyAdaptedTopViewId();if(s&&a.byId(s)){this._fireViewChange(s,i)}}}.bind(this),g=new n(d);g.observe(e,{aggregations:[t]});this._setHasListener(e,t,g)};l._observeRemoveAggregation=function(e,t,a){if(this._checkHasListener(e,t)){return}var i=new n(this._onRemoveAggregation.bind(this));i.observe(e,{aggregations:[t]});this._setHasListener(e,t,i)};l._removeFromMergeInfo=function(e,t){Object.keys(e).forEach(function(n){var a=e[n];if(a.oControl===t||v(a.oControl,t)){this._detachAllListeners(a.oControl);delete e[n]}},this)};l._detachAllListeners=function(e){var t=d[e.getId()];if(!t){return}Object.keys(t).forEach(function(a){var i=t[a];if(i instanceof n){i.disconnect()}else{e.detachEvent(a,i)}delete t[a]})};l._onRemoveAggregation=function(e){var t=e.mutation,n;if(t==="remove"){n=e.child;this._detachAllListeners(n);this._removeFromMergeInfo(s.aViewTitles,n);this._removeFromMergeInfo(s.aViewSubTitles,n);this._removeFromMergeInfo(s.aViewBackButtons,n)}};l._getNodeChildren=function(e){if(typeof e._getAdaptableContent==="function"){var t=[e._getAdaptableContent()];if(c(e,"sap/m/Page")){t=t.concat(e.getContent())}return t}if(c(e,"sap/m/SplitContainer")){return[].concat(e.getAggregation("_navMaster"),e.getAggregation("_navDetail"))}if(c(e,"sap/uxap/ObjectPageLayout")){return[e.getHeaderTitle()]}if(c(e,"sap/ui/core/ComponentContainer")){return[e.getComponentInstance()]}if(c(e,"sap/ui/core/UIComponent")){return[e.getAggregation("rootControl")]}return e.findAggregatedObjects(false,_)};l._updateSearchDepth=function(e,t){if(c(t,"sap/ui/core/mvc/View")||c(t,"sap/ui/core/Component")||c(t,"sap/ui/core/ComponentContainer")){return e}return e-1};l._getTotalCachedInfoToMerge=function(e){var t=sap.ui.getCore().byId(e),n=this._getCachedViewInfoToMerge(e),a,o,r,s,d,g,u;if(!i.system.phone&&this._isTopSplitContainerSubView(t)){g=t.getParent();d=g&&g.getParent();if(d){a=d._oMasterNav&&d._oMasterNav.getId()===g.getId();o=d._oDetailNav&&d._oDetailNav.getId()===g.getId()}}if(a){r=d.getCurrentDetailPage();s=r&&r.getId();u=this._getCachedViewInfoToMerge(s);n=this._mergeSplitViewInfos(n,u)}if(o){r=d.getCurrentMasterPage();s=r&&r.getId();u=this._getCachedViewInfoToMerge(s);n=this._mergeSplitViewInfos(u,n)}n.sViewId=a||o?d.getId():e;return n};l._isTopSplitContainerSubView=function(e){var t=e&&e.getParent();return this._isTopmostNavContainer(t)&&c(t.getParent(),"sap/m/SplitContainer")};l._mergeSplitViewInfos=function(e,t){jQuery.each(e,function(n,a){e[n]=a||t[n]});return e};l._getCachedViewInfoToMerge=function(e){var t=s.aViewBackButtons[e]?s.aViewBackButtons[e].oControl:undefined;return{oTitleInfo:s.aViewTitles[e],oSubTitleInfo:s.aViewSubTitles[e],oBackButton:t}};l._applyRules=function(e,t){var n=t.getParent();if(c(n,"sap/m/SplitContainer")){var a=i.system.phone,o=e.bMoveTitle,r=e.bHideBackButton;if(o){o=a}if(r&&!i.system.phone){r="initialPage"}return jQuery.extend({},e,{bMoveTitle:o,bHideBackButton:r})}if(c(n,"sap/m/NavContainer")){if(e.bHideBackButton==="initialPage"){var s=n._getActualInitialPage()&&n._getActualInitialPage().getId()===t.getId();return jQuery.extend({},e,{bHideBackButton:s})}}if(e.bMoveTitle===false||e.bHideBackButton===false){return jQuery.extend({},e,{bCollapseHeader:false})}return e};l._getCurrentlyAdaptedTopViewId=function(){return g};l._setAsCurrentlyAdaptedTopViewId=function(e){g=e};l._isTopNavigableView=function(e){var t=e.getParent();return t&&this._isTopmostNavContainer(t)};l._isTopmostNavContainer=function(e){var t,n=e;while(n){if(c(n,"sap/m/NavContainer")){t=n}n=n.getParent()}return t&&t.getId()===e.getId()};l._adaptHeader=function(e,t){if(!e||!t){return}var n=new u(e,t),a=n.adapt();var i=this._getCurrentlyAdaptedTopViewId();if(a.oTitleInfo){s.aViewTitles[i]=a.oTitleInfo;this._registerTextChangeListener(s.aViewTitles,i,t)}if(a.oSubTitleInfo){s.aViewSubTitles[i]=a.oSubTitleInfo;this._registerTextChangeListener(s.aViewSubTitles,i,t)}if(a.oBackButtonInfo){if(a.oBackButtonInfo.oControl.getVisible()){s.aViewBackButtons[i]=a.oBackButtonInfo}this._registerVisibilityChangeListener(a.oBackButtonInfo,s.aViewBackButtons,i,t)}return a};l._registerTextChangeListener=function(e,t,n){var a=e[t];if(a&&a.oControl&&a.sChangeEventId){if(this._checkHasListener(a.oControl,a.sChangeEventId)){return}var i=function(a){var i=e[t];if(a.getParameter("name")!==i.sPropertyName){return}i.text=a.getParameter("newValue");this._fireViewChange(t,n)}.bind(this);a.oControl.attachEvent(a.sChangeEventId,i);this._setHasListener(a.oControl,a.sChangeEventId,i)}};l._registerVisibilityChangeListener=function(e,t,n,a){var i;if(e&&e.oControl&&e.sChangeEventId){if(this._checkHasListener(e.oControl,e.sChangeEventId)){return}var o=function(o){if(o.getParameter("name")!==e.sPropertyName){return}i=o.getParameter("newValue");if(!i){jQuery.each(t,function(n,a){if(a.oControl.getId()===e.oControl.getId()){delete t[n]}})}var r=e.oControl.getParent();if(u._isAdaptableHeader(r)){l._adaptHeader(r,a);this._fireViewChange(n,a)}}.bind(this);e.oControl.attachEvent(e.sChangeEventId,o);this._setHasListener(e.oControl,e.sChangeEventId,o)}};l._fireViewChange=function(e,t){var n=this._getTotalCachedInfoToMerge(e);n.oAdaptOptions=t;r.fireEvent("adaptedViewChange",n)};l._isAdaptationRequired=function(e,t){if(!e||this._isNonAdaptableControl(e)){return false}for(var n in t){if(t.hasOwnProperty(n)&&(t[n]===true||t[n]==="initialPage")){return true}}return false};l._isNonAdaptableControl=function(e){return h(e)};function f(e){return p(e,["sap/m/Label","sap/m/Text","sap/m/Title"])}function h(e){return p(e,["sap/m/List","sap/m/SelectList","sap/m/Table","sap/ui/table/Table","sap/ui/table/TreeTable","sap/ui/comp/variants/VariantManagement"])}function p(e,t){if(!e||!t){return}return t.some(function(t){return c(e,t)})}function c(e,t){var n=sap.ui.require(t);return n&&e instanceof n}function _(e){return e&&e.sParentAggregationName!=="dependents"}function C(e){return e&&typeof e.getVisible==="function"&&e.getVisible()===false}function v(e,t){var n=e&&e.getParent();while(n){if(n===t){return true}n=n.getParent()}return false}return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FlexBox", ["./FlexBoxStylingHelper","./FlexItemData","./library","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/core/InvisibleRenderer","./FlexBoxRenderer","sap/ui/thirdparty/jquery"],function(e,t,i,r,n,a,s,jQuery){"use strict";var o=i.BackgroundDesign;var p=i.FlexAlignContent;var l=i.FlexWrap;var u=i.FlexAlignItems;var d=i.FlexJustifyContent;var g=i.FlexRendertype;var m=i.FlexDirection;var c=n.extend("sap.m.FlexBox",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},displayInline:{type:"boolean",group:"Appearance",defaultValue:false},direction:{type:"sap.m.FlexDirection",group:"Appearance",defaultValue:m.Row},fitContainer:{type:"boolean",group:"Appearance",defaultValue:false},renderType:{type:"sap.m.FlexRendertype",group:"Misc",defaultValue:g.Div},justifyContent:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:d.Start},alignItems:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:u.Stretch},wrap:{type:"sap.m.FlexWrap",group:"Appearance",defaultValue:l.NoWrap},alignContent:{type:"sap.m.FlexAlignContent",group:"Appearance",defaultValue:p.Stretch},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:o.Transparent}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"}},designtime:"sap/m/designtime/FlexBox.designtime",dnd:{draggable:false,droppable:true}},renderer:s});c.prototype.init=function(){this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._oItemsObserver=new r(this._onItemsChange.bind(this));this._oItemsObserver.observe(this,{aggregations:["items"]})};c.prototype.exit=function(){if(this._oItemsObserver){this._oItemsObserver.disconnect();this._oItemsObserver=null}};c.prototype._onItemsChange=function(e){if(e.name==="items"&&e.child){if(e.mutation==="insert"){this._onItemInserted(e.child)}else if(e.mutation==="remove"){this._onItemRemoved(e.child)}}else if(e.name==="visible"){this._onItemVisibilityChange(e)}};c.prototype._onItemInserted=function(e){if(e&&!(e instanceof c)){this._oItemsObserver.observe(e,{properties:["visible"]});if(this.getRenderType()===g.Bare){e.addEventDelegate(this._oItemDelegate,e)}}};c.prototype._onItemRemoved=function(e){if(e&&!(e instanceof c)){this._oItemsObserver.unobserve(e,{properties:["visible"]});if(this.getRenderType()===g.Bare){e.removeEventDelegate(this._oItemDelegate,e)}}};c.prototype._onItemVisibilityChange=function(e){var t=e.object,i;if(this.getRenderType()!==g.List&&this.getRenderType()!==g.Div){return}if(t.getLayoutData()){i=jQuery(document.getElementById(t.getLayoutData().getId()))}else{i=jQuery(document.getElementById(a.createInvisiblePlaceholderId(t))).parent()}if(e.current){i.removeClass("sapUiHiddenPlaceholder").removeAttr("aria-hidden")}else{i.addClass("sapUiHiddenPlaceholder").attr("aria-hidden","true")}};c.prototype._onAfterItemRendering=function(){var i=this.getLayoutData();if(i instanceof t){e.setFlexItemStyles(null,i)}};c.prototype.setRenderType=function(e){var t=this.getRenderType(),i=this.getItems();if(e===t){return this}this.setProperty("renderType",e);if(t==="Bare"){i.forEach(this._onItemRemoved,this)}if(e==="Bare"){i.forEach(this._onItemInserted,this)}return this};c.prototype.getAccessibilityInfo=function(){return{children:this.getItems()}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FlexBoxRenderer", ["./FlexBoxStylingHelper","sap/m/library","sap/base/Log","sap/m/FlexItemData"],function(e,t,s,a){"use strict";var l=t.FlexDirection;var i=t.FlexRendertype;var n={apiVersion:2};n.render=function(t,s){var a=s.getRenderType()===i.List?"ul":"div";t.openStart(a,s);var r=s.getParent();if(r&&r.isA("sap.m.FlexBox")){if(!s.hasStyleClass("sapMFlexItem")){t.class("sapMFlexItem")}var o=s.getLayoutData();if(o&&o.isA("sap.m.FlexItemData")){e.setFlexItemStyles(t,o)}}else if(s.getFitContainer()){t.class("sapMFlexBoxFit")}t.class("sapMFlexBox");if(s.getDisplayInline()){t.class("sapMFlexBoxInline")}if(s.getDirection()===l.Column||s.getDirection()===l.ColumnReverse){t.class("sapMVBox")}else{t.class("sapMHBox")}if(s.getDirection()===l.RowReverse||s.getDirection()===l.ColumnReverse){t.class("sapMFlexBoxReverse")}t.class("sapMFlexBoxJustify"+s.getJustifyContent());t.class("sapMFlexBoxAlignItems"+s.getAlignItems());t.class("sapMFlexBoxWrap"+s.getWrap());t.class("sapMFlexBoxAlignContent"+s.getAlignContent());var g="sapMFlexBoxBG"+s.getBackgroundDesign();if(!s.hasStyleClass(g)){t.class(g)}t.style("height",s.getHeight());t.style("width",s.getWidth());var p=s.getTooltip_AsString();if(p){t.attr("title",p)}t.openEnd();n.renderItems(s,t);t.close(a)};n.renderItems=function(e,t){var s=e.getItems(),a="";for(var l=0;l<s.length;l++){if(s[l].isA("sap.m.FlexBox")||e.getRenderType()===i.Bare){a=""}else if(e.getRenderType()===i.List){a="li"}else{a="div"}n.renderItem(s[l],a,t)}};n.renderItem=function(t,l,i){var r=t.getLayoutData();if(l&&!r){t.setAggregation("layoutData",new a,true);r=t.getLayoutData()}if(!(r instanceof a)){if(r){s.warning(r+" set on "+t+" is not of type sap.m.FlexItemData")}if(l){i.openStart(l)}}else{if(l){i.openStart(l,r.getId())}if(r.getStyleClass()){n.addItemClass(r.getStyleClass(),t,l,i)}n.addItemClass("sapMFlexItemAlign"+r.getAlignSelf(),t,l,i);n.addItemClass("sapMFlexBoxBG"+r.getBackgroundDesign(),t,l,i);if(l){e.setFlexItemStyles(i,r)}}n.addItemClass("sapMFlexItem",t,l,i);if(l){if(t.isA("sap.m.ScrollContainer")){i.class("sapMFlexBoxScroll")}if(!t.getVisible()){i.class("sapUiHiddenPlaceholder")}i.openEnd()}i.renderControl(t);if(l){i.close(l)}};n.addItemClass=function(e,t,s,a){if(s){a.class(e)}else{t.addStyleClass(e)}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FlexBoxStylingHelper", ["sap/base/strings/hyphenate"],function(e){"use strict";var t={};t.setFlexItemStyles=function(e,i){e=e||null;var n=""+i.getOrder(),f=""+i.getGrowFactor(),s=""+i.getShrinkFactor(),l=i.getBaseSize().toLowerCase(),r=i.getMinHeight(),y=i.getMaxHeight(),d=i.getMinWidth(),o=i.getMaxWidth();if(typeof n!=="undefined"){t.setStyle(e,i,"order",n)}if(typeof f!=="undefined"){t.setStyle(e,i,"flex-grow",f)}if(typeof s!=="undefined"){t.setStyle(e,i,"flex-shrink",s)}if(typeof l!=="undefined"){t.setStyle(e,i,"flex-basis",l)}if(typeof r!=="undefined"){t.setStyle(e,i,"min-height",r)}if(typeof y!=="undefined"){t.setStyle(e,i,"max-height",y)}if(typeof d!=="undefined"){t.setStyle(e,i,"min-width",d)}if(typeof o!=="undefined"){t.setStyle(e,i,"max-width",o)}};t.setStyle=function(i,n,f,s){if(typeof s==="string"){s=e(s)}else if(typeof s==="number"){s=s.toString()}t.writeStyle(i,n,f,s)};t.writeStyle=function(e,t,i,n){if(e){if(n==="0"||n){e.style(i,n)}}else{if(t.$().length){if(n!=="0"&&!n){t.$().css(i,null)}else{t.$().css(i,n)}}else{if(t.getParent()){if(n!=="0"&&!n){t.getParent().$().css(i,null)}else{t.getParent().$().css(i,n)}}}}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FlexItemData", ["./FlexBoxStylingHelper","./library","sap/ui/core/LayoutData"],function(t,e,i){"use strict";var s=e.BackgroundDesign;var r=e.FlexAlignSelf;var a=i.extend("sap.m.FlexItemData",{metadata:{library:"sap.m",properties:{alignSelf:{type:"sap.m.FlexAlignSelf",group:"Misc",defaultValue:r.Auto},order:{type:"int",group:"Misc",defaultValue:0},growFactor:{type:"float",group:"Misc",defaultValue:0},shrinkFactor:{type:"float",group:"Misc",defaultValue:1},baseSize:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},styleClass:{type:"string",group:"Misc",defaultValue:""},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:s.Transparent}}}});a.prototype.setAlignSelf=function(t){var e=this.getAlignSelf();this.setProperty("alignSelf",t,true);this.$().removeClass("sapMFlexItemAlign"+e).addClass("sapMFlexItemAlign"+this.getAlignSelf());return this};a.prototype.setOrder=function(e){this.setProperty("order",e,true);t.setStyle(null,this,"order",this.getOrder());return this};a.prototype.setGrowFactor=function(e){this.setProperty("growFactor",e,true);t.setStyle(null,this,"flex-grow",this.getGrowFactor());return this};a.prototype.setShrinkFactor=function(e){this.setProperty("shrinkFactor",e,true);t.setStyle(null,this,"flex-shrink",this.getShrinkFactor());return this};a.prototype.setBaseSize=function(e){this.setProperty("baseSize",e,true);t.setStyle(null,this,"flex-basis",this.getBaseSize());return this};a.prototype.setMinHeight=function(t){this.setProperty("minHeight",t,true);this.$().css("min-height",this.getMinHeight());return this};a.prototype.setMaxHeight=function(t){this.setProperty("maxHeight",t,true);this.$().css("max-height",this.getMaxHeight());return this};a.prototype.setMinWidth=function(t){this.setProperty("minWidth",t,true);this.$().css("min-width",this.getMinWidth());return this};a.prototype.setMaxWidth=function(t){this.setProperty("maxWidth",t,true);this.$().css("max-width",this.getMaxWidth());return this};a.prototype.setBackgroundDesign=function(t){var e=this.getBackgroundDesign();this.setProperty("backgroundDesign",t,true);this.$().removeClass("sapMFlexBoxBG"+e).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this};a.prototype.setStyleClass=function(t){var e=this.getStyleClass();this.setProperty("styleClass",t,true);this.$().removeClass(e).addClass(this.getStyleClass());return this};a.prototype.getDomRef=function(t){var e,s=i.prototype.getDomRef.call(this,t);if(s){return s}e=this.getParent();if(!e){return null}return e.getDomRef(t)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FormattedText", ["./library","sap/ui/core/library","sap/ui/core/Control","./FormattedTextAnchorGenerator","./FormattedTextRenderer","sap/base/Log","sap/base/security/URLListValidator","sap/base/security/sanitizeHTML","sap/ui/util/openWindow","sap/ui/core/Core"],function(e,t,r,i,s,a,n,o,l,u){"use strict";var p=e.LinkConversion,c=t.TextDirection,f=t.TextAlign;var g=r.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:p.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:c.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Begin}},aggregations:{controls:{type:"sap.m.Link",multiple:true,singularName:"control"}}},renderer:s});var h={ATTRIBS:{style:1,class:1,"a::href":1,"a::target":1,dir:1},ELEMENTS:{a:{cssClass:"sapMLnk"},abbr:1,bdi:1,blockquote:1,br:1,cite:1,code:1,em:1,h1:{cssClass:"sapMTitle sapMTitleStyleH1"},h2:{cssClass:"sapMTitle sapMTitleStyleH2"},h3:{cssClass:"sapMTitle sapMTitleStyleH3"},h4:{cssClass:"sapMTitle sapMTitleStyleH4"},h5:{cssClass:"sapMTitle sapMTitleStyleH5"},h6:{cssClass:"sapMTitle sapMTitleStyleH6"},p:1,pre:1,strong:1,span:1,u:1,dl:1,dt:1,dd:1,ol:1,ul:1,li:1}},d={ATTRIBS:{"a::href":1,"a::target":1},ELEMENTS:{a:{cssClass:"sapMLnk"},br:1,em:1,strong:1,u:1}};g.prototype._renderingRules=h;g.prototype.init=function(){};function T(e,t){var r;var i,s,o=e==="a";var l=this._renderingRules.ELEMENTS[e].cssClass||"";for(var u=0;u<t.length;u+=2){i=t[u];s=t[u+1];if(!this._renderingRules.ATTRIBS[i]&&!this._renderingRules.ATTRIBS[e+"::"+i]){r="FormattedText: <"+e+"> with attribute ["+i+'="'+s+'"] is not allowed';a.warning(r,this);t[u+1]=null;continue}if(i=="href"){if(!n.validate(s)){a.warning("FormattedText: incorrect href attribute:"+s,this);t[u+1]="#";o=false}}if(i=="target"){o=false}if(l&&i.toLowerCase()=="class"){t[u+1]=l+" "+s;l=""}}if(o){t.push("target");t.push("_blank")}if(l){t.push("class");t.push(l)}return t}function y(e,t){if(this._renderingRules.ELEMENTS[e]){return T.call(this,e,t)}else{var r="<"+e+"> is not allowed";a.warning(r,this)}}function m(e){return o(e,{tagPolicy:y.bind(this),uriRewriter:function(e){if(n.validate(e)){return e}}})}function R(t){if(t.originalEvent.defaultPrevented){return}t.preventDefault();var r=u.byId(t.currentTarget.id);if(r&&r.isA("sap.m.Link")&&(r.getAccessibleRole()===e.LinkAccessibleRole.Button||!r.getHref())){return}l(t.currentTarget.href,t.currentTarget.target)}g.prototype.onAfterRendering=function(){this.$().find("a").on("click",R);var e=this.getControls(),t;e.forEach(function(e,r){t=this.getDomRef("$"+r);if(t){t.replaceWith(e.getDomRef())}else{e.getDomRef().style.display="none"}}.bind(this));this._sanitizeCSSPosition(this.getDomRef())};g.prototype.onBeforeRendering=function(){this.$().find("a").off("click",R)};g.prototype._sanitizeCSSPosition=function(e){if(!e){return}var t=document.createTreeWalker(e,NodeFilter.SHOW_ELEMENT),r=t.nextNode();while(r){r.style.setProperty("position","static","important");r=t.nextNode()}};g.prototype._getDisplayHtml=function(){var e=this.getHtmlText(),t=this.getConvertLinksToAnchorTags();if(t===p.None){return e}e=i.generateAnchors(e,t,this.getConvertedLinksDefaultTarget());return m.call(this,e)};g.prototype.setHtmlText=function(e){return this.setProperty("htmlText",m.call(this,e))};g.prototype._setUseLimitedRenderingRules=function(e){this._renderingRules=e?d:h};g.prototype.getFocusDomRef=function(){return this.getDomRef()&&this.getDomRef().querySelector("a")};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FormattedTextAnchorGenerator", ["sap/ui/base/Object","sap/m/library","sap/base/security/URLListValidator"],function(e,t,r){"use strict";var n=t.LinkConversion;var i=e.extend("sap.m.FormattedTextAnchorGenerator",{getInterface:function(){return this}});var o=/(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;()$]*[-A-Z0-9+&@#\/%=~_|])/gim;var s=/(www\.[^\s><]+(\b|$))/gim;var a="//";var c=/<(?:"[^"]*"['"]*|'[^']*'['"]*|[^'">])+(?!\/\s\*)>/gim;var u=/<a[^>]*>([^<]+)<\/a>/gim;var f=[c,u];i.generateAnchors=function(e,t,r){if(t===n.ProtocolOnly){e=i._createAnchors(e,o,r)}if(t===n.All){e=i._createAnchors(e,o,r);e=i._createAnchors(e,s,r,a)}return e};i._createPositionObject=function(e,t){return{iStartPos:e,iEndPos:e+t}};i._isNested=function(e,t){return e.iStartPos<t.iStartPos&&e.iEndPos>t.iEndPos};i._isAllowed=function(e,t){return e.some(function(e){return i._isNested(e,t)})};i._shouldBeProcessed=function(e,t,n){return r.validate(e)&&!i._isAllowed(n,t)};i._scanForEntitiesToSkip=function(e,t){var r=[],n;while((n=e.exec(t))!==null){r.push(i._createPositionObject(n.index,n[0].length))}return r};i._getEntitiesToSkipWhileSearchingForLinks=function(e){return f.map(function(t){return i._scanForEntitiesToSkip(t,e)}).reduce(function(e,t){return e.concat(t)})};i._createAnchors=function(e,t,r,n){var o=i._getEntitiesToSkipWhileSearchingForLinks(e),s;n=n||"";s=function(e){var t=i._createPositionObject(arguments[3],e.length);if(!i._shouldBeProcessed(e,t,o)){return e}return'<a href="'+n+e+'" target="'+r+'">'+e+"</a>"};return e.replace(t,s)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/FormattedTextRenderer", ["sap/ui/core/library"],function(t){"use strict";var e={apiVersion:2};var i=t.TextDirection;var r=t.TextAlign;e.render=function(t,e){var n=e.getWidth(),l=e.getHeight(),a=e.getTextDirection(),o=e.getTextAlign(),s=e._getDisplayHtml();t.openStart("div",e);t.class("sapMFT");if(n){t.class("sapMFTOverflowWidth")}if(l){t.class("sapMFTOverflowHeight")}if(a!==i.Inherit){t.attr("dir",a.toLowerCase())}if(o&&o!=r.Initial){t.style("text-align",o.toLowerCase())}if(e.getTooltip_AsString()){t.attr("title",e.getTooltip_AsString())}t.style("width",n||null);t.style("height",l||null);t.openEnd();e.getControls().forEach(function(e){t.renderControl(e)});s=s.replace(/\%\%(\d+)/g,function(t){return'<template id="'+e.getId()+"-$"+t.split("%%")[1]+'"></template>'});t.unsafeHtml(s);t.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GenericTag", ["sap/ui/core/Control","sap/ui/events/KeyCodes","./library","sap/ui/core/library","sap/ui/core/Icon","./GenericTagRenderer"],function(e,t,r,o,i,n){"use strict";var a=r.GenericTagDesign,s=r.GenericTagValueState,c=o.ValueState,l={Error:"sap-icon://error",Warning:"sap-icon://alert",Success:"sap-icon://sys-enter-2",Information:"sap-icon://information"};var u=e.extend("sap.m.GenericTag",{metadata:{library:"sap.m",interfaces:["sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl","sap.m.IOverflowToolbarFlexibleContent"],properties:{text:{type:"string",defaultValue:""},status:{type:"sap.ui.core.ValueState",defaultValue:c.None},design:{type:"sap.m.GenericTagDesign",defaultValue:a.Full},valueState:{type:"sap.m.GenericTagValueState",defaultValue:s.None}},defaultAggregation:"value",associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},aggregations:{value:{type:"sap.m.ObjectNumber",multiple:false},_statusIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_errorIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:n});u.CLASSNAME_OVERFLOW_TOOLBAR="sapMGenericTagOverflowToolbar";u.prototype.setStatus=function(e){this.setProperty("status",e,false);this._getStatusIcon().setSrc(e!==c.None?l[e]:null);return this};u.prototype.setValue=function(e){var t=this.getValue();if(t){e.detachEvent("_change",this._fireValueChanged,this)}this.setAggregation("value",e);e.attachEvent("_change",this._fireValueChanged,this);this._fireValueChanged();return this};u.prototype._fireValueChanged=function(){this.fireEvent("_valueChanged")};u.prototype._getStatusIcon=function(){var e=this.getAggregation("_statusIcon");if(!e){e=new i(this.getId()+"-statusIcon").addStyleClass("sapMGenericTagIcon");this.setAggregation("_statusIcon",e)}return e};u.prototype._getErrorIcon=function(){var e=this.getAggregation("_errorIcon");if(!e){e=new i(this.getId()+"-errorIcon",{src:l[c.Error]}).addStyleClass("sapMGenericTagErrorIcon");this.setAggregation("_errorIcon",e)}return e};u.prototype.ontouchstart=function(){this._toggleActiveGenericTag(true)};u.prototype.ontouchend=function(){this._toggleActiveGenericTag(false)};u.prototype.ontouchcancel=function(){this._toggleActiveGenericTag(false)};u.prototype.onkeydown=function(e){if(e.which===t.SPACE||e.which===t.ENTER){this._toggleActiveGenericTag(true)}if(e.which===t.SHIFT||e.which===t.ESCAPE){this._bShouldInterupt=this._bSpacePressed}if(e.which===t.SPACE){this._bSpacePressed=true;e.preventDefault()}if(e.which===t.ENTER){this.firePress()}};u.prototype.onkeyup=function(e){if(e.which===t.SPACE||e.which===t.ENTER){this._toggleActiveGenericTag(false)}if(e.which===t.SPACE){if(!this._bShouldInterupt){this.firePress()}this._bShouldInterupt=false;this._bSpacePressed=false}};u.prototype.onclick=function(){this.firePress()};u.prototype.onfocusout=function(){this._toggleActiveGenericTag(false)};u.prototype._toggleActiveGenericTag=function(e){this.toggleStyleClass("sapMGenericTagActive",e)};u.prototype._onBeforeEnterOverflow=function(e){e.addStyleClass(u.CLASSNAME_OVERFLOW_TOOLBAR)};u.prototype._onAfterExitOverflow=function(e){e.removeStyleClass(u.CLASSNAME_OVERFLOW_TOOLBAR)};u.prototype.getOverflowToolbarConfig=function(){var e={canOverflow:true,invalidationEvents:["_valueChanged"]};e.onBeforeEnterOverflow=this._onBeforeEnterOverflow;e.onAfterExitOverflow=this._onAfterExitOverflow;return e};u.prototype._getToolbarInteractive=function(){return true};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GenericTagRenderer", ["./library","sap/ui/core/library","sap/ui/core/Core"],function(e,t,a){"use strict";var r=e.GenericTagDesign,n=e.GenericTagValueState,s=t.ValueState,i={apiVersion:2};i.render=function(e,t){var r=this._getAriaLabelledBy(t),n=a.getLibraryResourceBundle("sap.m"),s=t.getTooltip_AsString();e.openStart("div",t);e.class("sapMGenericTag");e.attr("tabindex",0);e.class("sapMGenericTag"+t.getStatus());e.accessibilityState(t,{role:"button",roledescription:n.getText("GENERICTAG_ROLEDESCRIPTION"),labelledby:r.join(" ")});if(s){e.attr("title",s)}e.openEnd();e.openStart("div");e.class("sapMGenericTagWrap");e.openEnd();this.renderElements(e,t);e.close("div");e.close("div")};i.renderElements=function(e,t){var a=t.getDesign()===r.StatusIconHidden,i=t.getValueState()===n.Error,o=t.getValue();if(!a&&t.getStatus()!==s.None){e.renderControl(t._getStatusIcon())}this.renderText(e,t);if(i){e.renderControl(t._getErrorIcon())}else if(o){e.renderControl(o.addStyleClass("sapMGenericTagValue"))}this.renderHiddenARIAElement(e,t)};i.renderText=function(e,t){e.openStart("span",t.getId()+"-text");e.class("sapMGenericTagText");e.openEnd();e.text(t.getText());e.close("span")};i.renderHiddenARIAElement=function(e,t){if(t.getStatus()===s.None){return}e.openStart("span",t.getId()+"-status");e.class("sapUiInvisibleText");e.attr("aria-hidden","true");e.openEnd();e.text(this._getGenericTagStatusText(t));e.close("span")};i._getAriaLabelledBy=function(e){var t=e.getAriaLabelledBy().slice(),a=e.getId(),r=this._getTagValueId(e),i=this._getTagValueState(e),o=e.getStatus();if(o!==s.None&&o!==i){t.push(a+"-status")}t.push(a+"-text");t.push(e.getValueState()===n.Error?a+"-errorIcon":r);return t};i._getGenericTagStatusText=function(e){var t=sap.ui.getCore().getLibraryResourceBundle("sap.m"),a;switch(e.getStatus()){case s.Error:a=t.getText("GENERICTAG_ARIA_VALUE_STATE_ERROR");break;case s.Warning:a=t.getText("GENERICTAG_ARIA_VALUE_STATE_WARNING");break;case s.Success:a=t.getText("GENERICTAG_ARIA_VALUE_STATE_SUCCESS");break;case s.Information:a=t.getText("GENERICTAG_ARIA_VALUE_STATE_INFORMATION");break;default:}return a};i._getTagValueId=function(e){var t=e.getValue();return t?t.getId():""};i._getTagValueState=function(e){var t=e.getValue();return t?t.getState():""};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GenericTile", ["./library","sap/ui/core/Control","sap/m/Text","sap/ui/core/HTML","sap/ui/core/Icon","sap/ui/core/IconPool","sap/m/Button","sap/m/GenericTileRenderer","sap/m/GenericTileLineModeRenderer","sap/m/Image","sap/ui/Device","sap/ui/core/ResizeHandler","sap/base/strings/camelize","sap/base/util/deepEqual","sap/ui/events/PseudoEvents","sap/ui/core/theming/Parameters","sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/core/Configuration","sap/ui/core/InvisibleText","sap/ui/core/Core","sap/ui/core/Theming"],function(e,t,i,s,o,n,a,r,l,h,p,d,c,g,u,f,jQuery,_,T,y,m,v){"use strict";var M=e.GenericTileScope,I=e.LoadState,A=_.CSSColor,S=e.FrameType,C=e.Size,b=e.GenericTileMode,R=e.TileSizeBehavior,L=e.WrappingType,x=e.URLHelper,B;B=f.get({name:"sapLegendColor9",callback:function(e){B=e}});var E="GenericTileDeviceSet";var D={};var P=t.extend("sap.m.GenericTile",{metadata:{library:"sap.m",properties:{mode:{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:b.ContentMode},header:{type:"string",group:"Appearance",defaultValue:null},subheader:{type:"string",group:"Appearance",defaultValue:null},failedText:{type:"string",group:"Appearance",defaultValue:null},size:{type:"sap.m.Size",group:"Misc",defaultValue:C.Auto,deprecated:true},frameType:{type:"sap.m.FrameType",group:"Misc",defaultValue:S.OneByOne},systemInfo:{type:"string",group:"Misc",defaultValue:null},appShortcut:{type:"string",group:"Misc",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},headerImage:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},state:{type:"sap.m.LoadState",group:"Misc",defaultValue:I.Loaded},imageDescription:{type:"string",group:"Accessibility",defaultValue:null},scope:{type:"sap.m.GenericTileScope",group:"Misc",defaultValue:M.Display},sizeBehavior:{type:"sap.m.TileSizeBehavior",defaultValue:R.Responsive},ariaLabel:{type:"string",group:"Accessibility",defaultValue:null},ariaRole:{type:"string",group:"Accessibility",defaultValue:null},ariaRoleDescription:{type:"string",group:"Accessibility",defaultValue:null},url:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},enableNavigationButton:{type:"boolean",group:"Misc",defaultValue:false},pressEnabled:{type:"boolean",group:"Misc",defaultValue:true},navigationButtonText:{type:"string",group:"Misc",defaultValue:null},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:L.Normal},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},additionalTooltip:{type:"string",group:"Accessibility",defaultValue:null},tileIcon:{type:"sap.ui.core.URI"},backgroundColor:{type:"string",group:"Appearance",defaultValue:B},valueColor:{type:"sap.m.ValueColor",group:"Appearance",defaultValue:"None"},iconLoaded:{type:"boolean",group:"Misc",defaultValue:true},renderOnThemeChange:{type:"boolean",group:"Misc",defaultValue:false},tileBadge:{type:"string",group:"Misc",defaultValue:""},dropAreaOffset:{type:"int",group:"Misc",defaultValue:0}},defaultAggregation:"tileContent",aggregations:{tileContent:{type:"sap.m.TileContent",multiple:true,bindable:"bindable"},linkTileContents:{type:"sap.m.LinkTileContent",multiple:true,singularName:"linkTileContent"},icon:{type:"sap.ui.core.Control",multiple:false,deprecated:true},actionButtons:{type:"sap.m.Button",multiple:true,bindable:"bindable"},_titleText:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_failedMessageText:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_invisibleText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_tileIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_tileIconImage:{type:"sap.m.Image",multiple:false,visibility:"hidden"}},events:{press:{parameters:{scope:{type:"sap.m.GenericTileScope"},action:{type:"string"},domRef:{type:"any"}}}}},renderer:{apiVersion:2,render:function(e,t){if(t.getMode()===b.LineMode){l.render(e,t)}else{r.render(e,t)}}}});P._Action={Press:"Press",Remove:"Remove",More:"More"};P.LINEMODE_SIBLING_PROPERTIES=["state","subheader","header","scope"];P.prototype.init=function(){this._oRb=m.getLibraryResourceBundle("sap.m");if(!p.media.hasRangeSet(E)){p.media.initRangeSet(E,[450],"px",["small","large"])}this._oTitle=new i(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._oAppShortcut=new i(this.getId()+"-appShortcut");this._oAppShortcut.cacheLineHeight=false;this.addDependent(this._oAppShortcut);this._oSystemInfo=new i(this.getId()+"-systemInfo");this._oSystemInfo.cacheLineHeight=false;this.addDependent(this._oSystemInfo);this._oSubTitle=new i(this.getId()+"-subTitle");this._oSubTitle.cacheLineHeight=false;this.addDependent(this._oSubTitle);this._sFailedToLoad=this._oRb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._oRb.getText("INFOTILE_LOADING");this._oFailedText=new i(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oInvisibleText=new y(this.getId()+"-ariaText");this.setAggregation("_invisibleText",this._oInvisibleText,true);this._oErrorIcon=new o(this.getId()+"-warn-icon",{src:"sap-icon://error",size:"1.375rem"});this._oErrorIcon.addStyleClass("sapMGTFtrFldIcnMrk");var e=f.get({name:"sapNegativeTextColor",callback:function(e){this._oErrorIcon.setColor(e)}.bind(this)});if(e){this._oErrorIcon.setColor(e)}this._oBusy=new s(this.getId()+"-overlay");this._oBusy.setBusyIndicatorDelay(0);this._bTilePress=true;this._sBGColor=B;this._bThemeApplied=false;m.ready(this._handleCoreInitialized.bind(this));this._oNavigateAction=new a(this.getId()+"-navigateAction");this._oNavigateAction._bExcludeFromTabChain=true;this.addDependent(this._oNavigateAction)};P.prototype.setWrappingType=function(e){this.setProperty("wrappingType",e,true);this._oTitle.setWrappingType(e);this._oFailedText.setWrappingType(e);this._oSubTitle.setWrappingType(e);this._oAppShortcut.setWrappingType(e);this._oSystemInfo.setWrappingType(e);return this};P.prototype.setSubheader=function(e){this.setProperty("subheader",e);this._oSubTitle.setText(e);return this};P.prototype.setAppShortcut=function(e){this.setProperty("appShortcut",e);this._oAppShortcut.setText(e);return this};P.prototype.setSystemInfo=function(e){this.setProperty("systemInfo",e);this._oSystemInfo.setText(e);return this};P.prototype._handleCoreInitialized=function(){v.attachApplied(this._handleThemeApplied.bind(this))};P.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._oTitle.clampHeight();v.detachApplied(this._handleThemeApplied.bind(this))};P.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getRenderOnThemeChange()){this.invalidate()}};P.prototype._initScopeContent=function(e){if(!this.getState||this.getState()!==I.Disabled){if(this._oMoreIcon){this._oMoreIcon.destroy();this._oMoreIcon=null}if(this.isA("sap.m.GenericTile")&&this._isIconMode()&&this.getFrameType()===S.TwoByHalf){this._oMoreIcon=this._oMoreIcon||new a({id:this.getId()+"-action-more",icon:"sap-icon://overflow",type:"Transparent",tooltip:this._oRb.getText("GENERICTILE_MORE_ACTIONBUTTON_TEXT")}).addStyleClass("sapMPointer").addStyleClass(e+"MoreIcon").addStyleClass(e+"ActionMoreButton");this._oMoreIcon.ontouchstart=function(){this.removeFocus()}.bind(this)}else{this._oMoreIcon=this._oMoreIcon||new a({id:this.getId()+"-action-more",icon:"sap-icon://overflow",type:"Unstyled"}).addStyleClass("sapMPointer").addStyleClass(e+"MoreIcon");this._oMoreIcon._bExcludeFromTabChain=true}this._oRemoveButton=this._oRemoveButton||new a({id:this.getId()+"-action-remove",icon:"sap-icon://decline",tooltip:this._oRb.getText("GENERICTILE_REMOVEBUTTON_TEXT")}).addStyleClass("sapUiSizeCompact").addStyleClass(e+"RemoveButton");this._oRemoveButton._bExcludeFromTabChain=true;switch(this.getScope()){case M.Actions:this._oMoreIcon.setVisible(true);this._oRemoveButton.setVisible(true);break;case M.ActionMore:this._oMoreIcon.setVisible(true);this._oRemoveButton.setVisible(false);break;case M.ActionRemove:this._oRemoveButton.setVisible(true);this._oMoreIcon.setVisible(false);break;default:}}};P.prototype._addClassesForButton=function(){this._oMoreIcon.getDomRef().classList.add("sapMBtn");this._oMoreIcon.getDomRef("inner").classList.add("sapMBtnInner");this._oMoreIcon.getDomRef("inner").classList.add("sapMBtnTransparent")};P.prototype.removeFocus=function(){this.getDomRef().classList.add("sapMGTActionButtonPress");this._oMoreIcon._activeButton()};P.prototype._isSmall=function(){return this.getSizeBehavior()===R.Small||window.matchMedia("(max-width: 374px)").matches};P.prototype.exit=function(){if(this._sParentResizeListenerId){d.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null}if(this._sGenericTileResizeListenerId){d.deregister(this._sGenericTileResizeListenerId);this._sGenericTileResizeListenerId=null}p.media.detachHandler(this._handleMediaChange,this,E);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());this._$RootNode=null}this._clearAnimationUpdateQueue();this._oErrorIcon.destroy();if(this._oImage){this._oImage.destroy()}this._oBusy.destroy();if(this._oMoreIcon){this._oMoreIcon.destroy()}if(this._oRemoveButton){this._oRemoveButton.destroy()}if(this._oNavigateAction){this._oNavigateAction.destroy()}};P.prototype.onBeforeRendering=function(){var e=!!this.getSubheader();if(this.getMode()===b.HeaderMode||this.getMode()===b.IconMode){this._applyHeaderMode(e)}else{this._applyContentMode(e)}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setDisabled(this.getState()===I.Disabled)}this._initScopeContent("sapMGT");this._generateFailedText();this.$().off("mouseenter");this.$().off("mouseleave");if(this._sParentResizeListenerId){d.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null}if(this._sGenericTileResizeListenerId){d.deregister(this._sGenericTileResizeListenerId);this._sGenericTileResizeListenerId=null}var s=this.getParent();if(s&&s.isA("sap.f.GridContainer")){this._applyNewDim()}p.media.detachHandler(this._handleMediaChange,this,E);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents())}if(this.getFrameType()===S.Auto){this.setFrameType(S.OneByOne)}if(this.getMode()!==b.LineMode&&(this.getAppShortcut()||this.getSystemInfo())){this._setMaxLines()}if(this._isNavigateActionEnabled()){var o=this.getNavigationButtonText()?this.getNavigationButtonText():this._oRb.getText("ACTION_READ_MORE");this._oNavigateAction.setText(o);this._oNavigateAction.detachPress(this._navigateEventHandler,this)}if(this._isIconMode()){this._validateBackgroundColor()}this._isLinkTileContentPresent=this.getLinkTileContents().length>0};P.prototype.onAfterRendering=function(){this._setupResizeClassHandler();var e=this.getMode();var i=this._isScreenLarge();this._sGenericTileResizeListenerId=d.register(this,this._handleResizeOnTile.bind(this));this._handleResizeOnTile();if(e===b.LineMode){var s=this.$().parent();if(i){this._updateHoverStyle(true);if(this.getParent()instanceof t){this._sParentResizeListenerId=d.register(this.getParent(),this._handleResize.bind(this))}else{this._sParentResizeListenerId=d.register(s,this._handleResize.bind(this))}}}if(e===b.LineMode&&this._bUpdateLineTileSiblings){this._updateLineTileSiblings();this._bUpdateLineTileSiblings=false}if(e===b.LineMode){p.media.attachHandler(this._handleMediaChange,this,E)}if(this._isNavigateActionEnabled()){this._oNavigateAction.attachPress(this._navigateEventHandler,this)}if(this._oMoreIcon&&this._oMoreIcon.getDomRef()&&!this._isIconMode()){this._oMoreIcon.getDomRef().firstChild.classList.remove("sapMBtnHoverable");this._oMoreIcon.getDomRef().firstChild.classList.remove("sapMFocusable")}if(this._isIconMode()&&this.getFrameType()===S.TwoByHalf&&this._oMoreIcon.getDomRef()){this._addClassesForButton()}if(this.getFrameType()===S.TwoByOne&&(this.getMode()===b.ActionMode||this._isLinkTileContentPresent)&&this.getState()===I.Loaded&&!this.isA("sap.m.ActionTile")){this._applyExtraHeight()}if(this.getTooltip()&&this.getDomRef()){this.getDomRef().setAttribute("aria-describedby",this.getAggregation("_invisibleText").getId())}this.onDragComplete();if(this.getDomRef()&&this.getParent()&&this.getParent().isA("sap.m.SlideTile")){this.getDomRef().setAttribute("tabindex","-1")}};P.prototype._applyExtraHeight=function(){var e=this.getDomRef("hdr-text").offsetHeight,t=parseInt(getComputedStyle(this.getDomRef("title")).lineHeight.slice(0,2)),i=Math.ceil(e/t);if(i===1&&!this.getHeaderImage()){this.getDomRef("content").classList.add("sapMGTFtrMarginTop")}else{this.getDomRef("content").classList.remove("sapMGTFtrMarginTop")}if(this._isLinkTileContentPresent){this._adjustFocusOnLinkTiles(this.getDomRef().classList.contains("sapMTileSmallPhone"),i)}};P.prototype._adjustFocusOnLinkTiles=function(e,t){var i=e?5:6;i=t===2?--i:i;var s;for(s=this.getLinkTileContents().length-1;s>i-1;--s){this.getLinkTileContents()[s]._getLink().getDomRef().setAttribute("tabindex",-1)}while(s>=0){this.getLinkTileContents()[s]._getLink().getDomRef().setAttribute("tabindex",0);s--}};P.prototype._validateBackgroundColor=function(){var e=this.getBackgroundColor();if(A.isValid(e)){this._sBGColor=e}else{var t=f.get({name:e,callback:function(e){this._sBGColor=e?e:B}.bind(this)});if(t){this._sBGColor=t}}};P.prototype._setMaxLines=function(){var e=this.getFrameType(),t=e===S.OneByOne||e===S.TwoByHalf?1:2;this._oAppShortcut.setMaxLines(t);this._oSystemInfo.setMaxLines(t);if(this.getFrameType()===S.TwoByHalf){var i=this.getAppShortcut().length>11,s=this.getSystemInfo().length>11;if(i&&s||i){this._oAppShortcut.setMaxLines(2)}else if(s){this._oSystemInfo.setMaxLines(2)}}};P.prototype.onDragComplete=function(){if(this.hasStyleClass("sapMGTPressActive")){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive")}if(this.getMode()===b.LineMode){this.removeStyleClass("sapMGTLineModePress")}}if(this.getDomRef()){this.getDomRef().removeEventListener("mouseenter",this._updateAriaAndTitle.bind(this));this.getDomRef().removeEventListener("mouseleave",this._removeTooltipFromControl.bind(this));this.getDomRef().addEventListener("mouseenter",this._updateAriaAndTitle.bind(this));this.getDomRef().addEventListener("mouseleave",this._removeTooltipFromControl.bind(this))}};P.prototype._handleResize=function(){if(this.getMode()===b.LineMode&&this._isScreenLarge()&&this.getParent()){this._queueAnimationEnd()}};P.prototype._handleResizeOnTile=function(){if(this._isIconMode()&&this.getFrameType()===S.OneByOne){this._handleResizeOnIconTile()}};P.prototype._handleResizeOnIconTile=function(){var e=this._oTitle.getDomRef();var t=window.matchMedia("(max-width: 600px)").matches;var i=window.matchMedia("(max-width: 374px)").matches;if(e){var s=parseInt(getComputedStyle(e).height.slice(0,2));var o=parseInt(getComputedStyle(e).lineHeight.slice(0,2));var n=s/o;if(n===1){this.addStyleClass("sapMGTHeaderOneLine")}else{this.removeStyleClass("sapMGTHeaderOneLine")}if(!(t||i)&&n===3&&this._oSubTitle.getDomRef()){this._oSubTitle.setMaxLines(1);this.addStyleClass("sapMGTHeaderThreeLine")}else{this.removeStyleClass("sapMGTHeaderThreeLine");this._oSubTitle.setMaxLines(2)}}};P.prototype._setupResizeClassHandler=function(){var e=function(){var e=this.getParent();if(e&&e.isA("sap.f.GridContainer")){this._applyNewDim()}if(this.getSizeBehavior()===R.Small||window.matchMedia("(max-width: 374px)").matches||this._isSmallStretchTile()){this.$().addClass("sapMTileSmallPhone");if(this._isSmallStretchTile()){this.addStyleClass("sapMGTStretch")}}else{this.$().removeClass("sapMTileSmallPhone");this.removeStyleClass("sapMGTStretch")}if(this.__isLinkTileContentPresent){this._applyExtraHeight()}}.bind(this);jQuery(window).on("resize",e);e()};P.prototype._isSmallStretchTile=function(){return this.getFrameType()===S.Stretch&&window.matchMedia("(max-width: 600px)").matches};P.prototype._isCompact=function(){return jQuery("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0};P.prototype._calculateStyleData=function(){this.$("lineBreak").remove();if(!this._isScreenLarge()||!this.getDomRef()||this.$().is(":hidden")){return null}var e=this.$(),t=this.$("endMarker"),i=this.$("startMarker");if(t.length===0||i.length===0){return null}var s=this._getLineCount(),o,n,a=Math.ceil(l._getCSSPixelValue(this,"margin-top")),r,h=this.$().parent().innerWidth(),d=Math.ceil(l._getCSSPixelValue(this,"min-height")),c=l._getCSSPixelValue(this,"line-height"),g=this.$().is(":not(:first-child)")&&s>1,u=jQuery("<span><br></span>"),f=0,_=T.getRTL(),y=t.position();if(g){u.attr("id",this.getId()+"-lineBreak");e.prepend(u);s=this._getLineCount();y=t.position()}var m={rtl:_,lineBreak:g,startOffset:i.offset(),endOffset:t.offset(),availableWidth:h,lines:[]};var v;if(p.browser.msie||p.browser.edge){v=u.find("br").position()}else{v=u.position()}var M=v;if(!(p.browser.mozilla||p.browser.msie||p.browser.edge)&&v.left<y.left){M=y}m.positionLeft=g?v.left:e.position().left;m.positionRight=g?e.width()-M.left:m.availableWidth-e.position().left;if(!g&&s>1){m.positionRight=i.parent().innerWidth()-(i.position().left+i.width())}for(f;f<s;f++){if(g&&f===0){continue}if(s===1){o=_?m.availableWidth-m.positionLeft:m.positionLeft;r=e.width()}else if(f===s-1){o=0;r=_?e.width()-y.left:y.left}else if(g&&f===1){o=0;r=h}else{o=0;r=h}n=f*c+a;m.lines.push({offset:{x:o,y:n},width:r,height:d})}return m};P.prototype._getStyleData=function(){var e=this._calculateStyleData();if(!g(this._oStyleData,e)){delete this._oStyleData;this._oStyleData=e;return true}return false};P.prototype._getAnimationEvents=function(){return"transitionend.sapMGT$id animationend.sapMGT$id".replace(/\$id/g,c(this.getId()))};P.prototype._updateHoverStyle=function(e){if(!this._getStyleData()&&!e){return}this._clearAnimationUpdateQueue();this._cHoverStyleUpdates=-1;this._oAnimationEndCallIds={};if(this._oStyleData&&this._oStyleData.lineBreak&&this.getUIArea()){this._$RootNode=jQuery(this.getUIArea().getRootNode());this._$RootNode.on(this._getAnimationEvents(),this._queueAnimationEnd.bind(this))}this._queueAnimationEnd()};P.prototype._queueAnimationEnd=function(e){if(e){var t=jQuery(e.target);if(t.is(".sapMGT, .sapMGT *")){return false}}if(typeof this._cHoverStyleUpdates!=="number"){this._cHoverStyleUpdates=-1}if(!this._oAnimationEndCallIds){this._oAnimationEndCallIds={}}this._cHoverStyleUpdates++;this._oAnimationEndCallIds[this._cHoverStyleUpdates]=setTimeout(this._handleAnimationEnd.bind(this,this._cHoverStyleUpdates),10)};P.prototype._handleAnimationEnd=function(e){delete this._oAnimationEndCallIds[e];if(this._cHoverStyleUpdates===e){this._getStyleData();l._updateHoverStyle.call(this)}};P.prototype._clearAnimationUpdateQueue=function(){for(var e in this._oAnimationEndCallIds){clearTimeout(this._oAnimationEndCallIds[e]);delete this._oAnimationEndCallIds[e]}};P.prototype._getLineCount=function(){var e=this.getDomRef().getBoundingClientRect(),t=l._getCSSPixelValue(this,"line-height");return Math.round(e.height/t)};P.prototype.getBoundingRects=function(){var e=this.$().offset();return[{offset:{x:e.left,y:e.top},width:this.$().outerWidth(),height:this.$().height()}]};P.prototype._updateLineTileSiblings=function(){var e=this.getParent();if(this.getMode()===b.LineMode&&this._isScreenLarge()&&e){var t=e.indexOfAggregation(this.sParentAggregationName,this);var i=e.getAggregation(this.sParentAggregationName).splice(t+1);for(t=0;t<i.length;t++){var s=i[t];if(s instanceof P&&s.getMode()===b.LineMode){s._updateHoverStyle()}}}};P.prototype.ontouchstart=function(e){if(e&&e.target.id.indexOf("-action-more")===-1&&this.getDomRef()){this.getDomRef().classList.remove("sapMGTActionButtonPress")}this.addStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive")}if(this.getMode()===b.LineMode){this.addStyleClass("sapMGTLineModePress")}};P.prototype.ontouchcancel=function(){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive")}};P.prototype.ontouchend=function(){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive")}if(this.getMode()===b.LineMode){this.removeStyleClass("sapMGTLineModePress")}};P.prototype.ondragend=function(){this.onDragComplete()};P.prototype.ontap=function(e){if(!w(e,this)&&!this._isLinkPressed(e)){var t;if((this._bTilePress||this._isActionMoreButtonVisibleIconMode(e))&&this.getState()!==I.Disabled){this.$().trigger("focus");t=this._getEventParams(e);if(!(this.isInActionRemoveScope()&&t.action===P._Action.Press)){this.firePress(t)}e.preventDefault()}}};var G=false;P.prototype.onkeydown=function(e){if(!w(e,this)&&!this._isLinkPressed(e)){G=e.keyCode===16||e.keyCode===27?true:false;var t=D[e.keyCode];if(!t){D[e.keyCode]=true;if(D[32]||D[13]){e.preventDefault()}}if(u.events.sapselect.fnCheck(e)&&this.getState()!==I.Disabled){this.addStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive")}e.preventDefault()}}};P.prototype._updateAriaLabel=function(){var e=this._getAriaText(),t=this.$(),i=false;if(t.attr("aria-label")!==e){t.attr("aria-label",e);i=true}return i};P.prototype.onsaptabnext=function(e){if(this._isIconMode()&&this.getFrameType()===S.TwoByHalf&&e&&e.keyCode){if(e.keyCode===9&&e.srcControl.getId()==this._oMoreIcon.getId()){this._oMoreIcon.removeStyleClass("sapMGTVisible")}else if(e.keyCode===9){this._oMoreIcon.addStyleClass("sapMGTVisible")}}};P.prototype.onsaptabprevious=function(){if(this._isIconMode()&&this.getFrameType()===S.TwoByHalf){this._oMoreIcon.removeStyleClass("sapMGTVisible")}};P.prototype.onkeyup=function(e){if(!w(e,this)&&!this._isLinkPressed(e)){var t=D[e.keyCode];if(t){delete D[e.keyCode]}var i,s=false,o=this.getScope(),n=o===M.Actions||o===M.ActionRemove;if(n&&(u.events.sapdelete.fnCheck(e)||u.events.sapbackspace.fnCheck(e))){i={scope:o,action:P._Action.Remove,domRef:this._oRemoveButton.getPopupAnchorDomRef()};s=true}if(D[16]&&e.keyCode!==16&&this.getState()!==I.Disabled){G===false}if((u.events.sapselect.fnCheck(e)||G)&&this.getState()!==I.Disabled){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive")}i=this._getEventParams(e);s=true}if(!G&&s&&(this._bTilePress||this._isActionMoreButtonVisibleIconMode(e))){this.firePress(i);e.preventDefault()}this._updateAriaLabel()}};P.prototype.setProperty=function(e){t.prototype.setProperty.apply(this,arguments);if(this.getMode()===b.LineMode&&P.LINEMODE_SIBLING_PROPERTIES.indexOf(e)!==-1){this._bUpdateLineTileSiblings=true}return this};P.prototype.getHeader=function(){return this._oTitle.getText()};P.prototype.setHeader=function(e){this.setProperty("header",e);this._oTitle.setText(e);return this};P.prototype.setHeaderImage=function(e){var t=!g(this.getHeaderImage(),e);if(t){if(this._oImage){this._oImage.destroy();this._oImage=undefined}if(e){this._oImage=n.createControlByURI({id:this.getId()+"-icon-image",src:e},h);this._oImage.addStyleClass("sapMGTHdrIconImage")}}return this.setProperty("headerImage",e)};P.prototype._applyHeaderMode=function(e){var t=this.getFrameType();if(this._isIconMode()){var i,s;s=t===S.TwoByHalf?1:2;if(t===S.OneByOne){i=4}else if(t===S.TwoByHalf){i=e?1:2}this._oTitle.setMaxLines(i);this._oSubTitle.setMaxLines(s)}else if(t===S.TwoByOne&&(this.getLinkTileContents()>0||this.getMode()===b.ActionMode)){this._oTitle.setMaxLines(2)}else if(t===S.OneByHalf||t===S.TwoByHalf){this._oTitle.setMaxLines(2)}else{if(e){this._oTitle.setMaxLines(4)}else{this._oTitle.setMaxLines(5)}}this._changeTileContentContentVisibility(false)};P.prototype._applyContentMode=function(e){var t=this.getFrameType();var i=this.getTileContent();var s=false;if(t===S.TwoByHalf||t===S.OneByHalf){if(i.length){for(var o=0;o<i.length;o++){var n=i[o].getAggregation("content");if(n!==null){if(t===S.OneByHalf&&n.getMetadata().getName()==="sap.m.ImageContent"){s=true;this._oTitle.setMaxLines(2);break}else{this._oTitle.setMaxLines(1);break}}this._oTitle.setMaxLines(2)}}else{this._oTitle.setMaxLines(2)}}else if(t===S.TwoByOne&&(this.getLinkTileContents().length>0||this.getMode()===b.ActionMode)){if(e){this._oTitle.setMaxLines(1)}else{this._oTitle.setMaxLines(2)}}else if(e){this._oTitle.setMaxLines(2)}else{this._oTitle.setMaxLines(3)}this._changeTileContentContentVisibility(true,t,s)};P.prototype._changeTileContentContentVisibility=function(e,t,i){var s;s=this.getTileContent();for(var o=0;o<s.length;o++){if(t==S.OneByHalf&&i){s[o].setRenderContent(false)}else{s[o].setRenderContent(e)}}};P.prototype._getHeaderAriaAndTooltipText=function(){var e="";var t=true;if(this.getHeader()){e+=this.getHeader();t=false}if(this.getSubheader()){e+=(t?"":"\n")+this.getSubheader();t=false}if(this.getImageDescription()){e+=(t?"":"\n")+this.getImageDescription()}return e};P.prototype._getContentAriaAndTooltipText=function(){var e="";var t=true;var i=this.getTileContent();var s=this.getAdditionalTooltip();if(!this._isInActionScope()&&(this.getMode()===b.ContentMode||this.getMode()===b.ArticleMode||this.getMode()===b.ActionMode)){for(var o=0;o<i.length;o++){if(i[o].getVisible()){if(typeof i[o]._getAriaAndTooltipText==="function"){e+=(t?"":"\n")+i[o]._getAriaAndTooltipText()}else if(i[o].getTooltip_AsString()){e+=(t?"":"\n")+i[o].getTooltip_AsString()}t=false}}}if(s){e+=(t?"":"\n")+s}return e};P.prototype._getAriaAndTooltipText=function(){var e=this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText();switch(this.getState()){case I.Disabled:return"";case I.Loading:return e+"\n"+this._sLoading;case I.Failed:return e+"\n"+this._oFailedText.getText();default:if(e.trim().length===0){return""}else{return e}}};P.prototype._getAriaText=function(e){var t=this._getAriaAndTooltipText();var i=this.getAriaLabel();if(!t||this._isTooltipSuppressed()){t=this._getAriaAndTooltipText()}if(this._isInActionScope()&&this.getScope()!==M.ActionMore){t=this._oRb.getText("GENERICTILE_ACTIONS_ARIA_TEXT")+" "+t}if(i){t=i+" "+t}if(!e){t=t.trim();if(this.getLinkTileContents().length>0){t+="\n"+this._oRb.getText("GENERICTILE_LINK_TILE_CONTENT_DESCRIPTION")}else{t+="\n"+this._getSizeDescription()}}return t.trim()};P.prototype._getSizeDescription=function(){var e="",t=this.getFrameType();if(this.getMode()===b.LineMode){var i=this.getUrl()&&!this._isInActionScope()&&this.getState()!==I.Disabled;var s=this.hasListeners("press");if(i||s){e="GENERIC_TILE_LINK"}else{e="GENERIC_TILE_LINE_SIZE"}}else if(t===S.OneByHalf){e="GENERIC_TILE_FLAT_SIZE"}else if(t===S.TwoByHalf){e="GENERIC_TILE_FLAT_WIDE_SIZE"}else if(t===S.TwoByOne){e="GENERIC_TILE_WIDE_SIZE"}else if(t===S.OneByOne){e="GENERIC_TILE_ROLE_DESCRIPTION"}return this._oRb.getText(e)};P.prototype._getTooltipText=function(){var e=this.getTooltip_Text();if(this._isTooltipSuppressed()===true){e=null}return e};P.prototype._checkFooter=function(e,t){var i=t.getState();var s=this._isInActionScope()||this._bShowActionsView===true;var o=this.getFrameType();var n=e.getAggregation("content");if(this._isIconMode()){e.setRenderFooter(false)}else if(i===I.Failed||s&&i!==I.Disabled){e.setRenderFooter(false)}else if(o===S.TwoByHalf&&(n!==null||this.getSubheader())){e.setRenderFooter(false)}else if(o===S.OneByHalf&&(n!==null&&n.getMetadata().getName()!=="sap.m.ImageContent"||this.getSubheader())){e.setRenderFooter(false)}else{e.setRenderFooter(true);return true}};P.prototype._isInActionScope=function(){return this.getScope()===M.Actions||this.getScope()===M.ActionMore||this.getScope()===M.ActionRemove};P.prototype._isLinkPressed=function(e){var t=e.target.id;var i=this.getLinkTileContents().find(function(e){return e._getLink().getDomRef().id===t});return!!i};P.prototype.isInActionRemoveScope=function(){return this.getScope()===M.ActionRemove};P.prototype._isActionMoreButtonVisibleIconMode=function(e){return(this.getScope()===M.ActionMore||this.getScope()===M.Actions)&&this._isIconMode()&&this.getFrameType()===S.TwoByHalf&&e.target.id.indexOf("-action-more")>-1};P.prototype._generateFailedText=function(){var e=this.getFailedText();var t=e?e:this._sFailedToLoad;this._oFailedText.setText(t);this._oFailedText.setTooltip(t)};P.prototype._isTooltipSuppressed=function(){var e=this.getTooltip_Text();if(e&&e.length>0&&e.trim().length===0){return true}else{return false}};P.prototype._isHeaderTextTruncated=function(){var e,t,i,s;if(this.getMode()===b.LineMode){i=this.$("hdr-text");if(i.length>0){s=Math.ceil(i[0].getBoundingClientRect().width);return i[0]&&s<i[0].scrollWidth}else{return false}}else{e=this.getAggregation("_titleText").getDomRef("inner");t=this.getAggregation("_titleText").getClampHeight(e);return t<e.scrollHeight}};P.prototype._isSubheaderTextTruncated=function(){var e;if(this.getMode()===b.LineMode){e=this.$("subHdr-text")}else{e=this.$("subTitle")}if(e.length>0){var t=Math.ceil(e[0].getBoundingClientRect().width);return e[0]&&t<e[0].scrollWidth}else{return false}};P.prototype._setTooltipFromControl=function(){var e=this._getAriaAndTooltipText();if(e&&!this._getTooltipText()&&!this._isTooltipSuppressed()){this.$().attr("title",e.trim());this._bTooltipFromControl=true}};P.prototype._updateAriaAndTitle=function(){var e=this._getAriaAndTooltipText();var t=this._getAriaText();var i=this.$();if(i.attr("title")!==e){i.attr("aria-label",t)}if(this._isInActionScope()){i.find("*:not(.sapMGTRemoveButton,.sapMGTActionMoreButton)").removeAttr("aria-label").removeAttr("title").off("mouseenter")}else{i.find("*").removeAttr("aria-label").removeAttr("title").off("mouseenter")}this._setTooltipFromControl()};P.prototype._removeTooltipFromControl=function(){if(this._bTooltipFromControl){this.$().removeAttr("title");this._bTooltipFromControl=false}};P.prototype._isScreenLarge=function(){return this._getCurrentMediaContainerRange(E).name==="large"};P.prototype._getEventParams=function(e){var t,i=P._Action.Press,s=this.getScope(),o=this.getDomRef();if((s===M.Actions||M.ActionRemove)&&e.target.id.indexOf("-action-remove")>-1){i=P._Action.Remove;o=this._oRemoveButton.getPopupAnchorDomRef()}else if((s===M.Actions||s===M.ActionMore)&&this._isIconMode&&this._isIconMode()&&e.target.id.indexOf("-action-more")>-1){i=P._Action.More;o=this._oMoreIcon.getDomRef()}else if(s===M.Actions||s===M.ActionMore){o=this._oMoreIcon.getDomRef()}t={scope:s,action:i,domRef:o};return t};P.prototype._handleMediaChange=function(){this._bUpdateLineTileSiblings=true;this.invalidate()};P.prototype.setPressEnabled=function(e){this._bTilePress=e;this.setProperty("pressEnabled",e);return this};P.prototype.showActionsView=function(e){if(this._bShowActionsView!==e){this._bShowActionsView=e;this.invalidate()}};P.prototype._generateIconAggregation=function(e){var t="";this._oIcon=n.createControlByURI({size:this.getFrameType()===S.OneByOne?"2rem":"1.25rem",useIconTooltip:false,src:e});if(!this._oIcon){this._oIcon=n.createControlByURI({height:this.getFrameType()===S.OneByOne?"2rem":"1.25rem",width:this.getFrameType()===S.OneByOne?"2rem":"1.25rem",useIconTooltip:false,src:e},h).addStyleClass("sapMPointer").addStyleClass("sapMGTTileIcon")}this._oIcon.addStyleClass("sapMPointer").addStyleClass("sapMGTTileIcon");if(this._oIcon instanceof h){t="_tileIconImage"}else if(this._oIcon instanceof o){t="_tileIcon"}if(t){this.setAggregation(t,this._oIcon)}return t};P.prototype._isIconMode=function(){var e=this.getMode(),t=this.getFrameType(),i=this.getTileIcon(),s=this.getBackgroundColor(),o=this.getIconLoaded();this._sTileBadge=t===S.TwoByHalf&&this.getTileBadge().trim().substring(0,3);return e===b.IconMode&&(t===S.OneByOne||t===S.TwoByHalf)&&(i&&s||this._sTileBadge&&s||!o)};P.prototype._isNavigateActionEnabled=function(){return this.getMode()===b.ArticleMode&&this.getUrl()&&this.getEnableNavigationButton()};P.prototype._applyNewDim=function(e){var t=e?e.getActiveLayoutSettings().getGap():this.getParent().getActiveLayoutSettings().getGap();var i=t==="16px"||t==="1rem";if(i){this.addStyleClass("sapMGTGridContainerOneRemGap")}else if(!i&&this.hasStyleClass("sapMGTGridContainerOneRemGap")){this.removeStyleClass("sapMGTGridContainerOneRemGap")}};P.prototype._isActionMode=function(){return this.getFrameType()===S.TwoByOne&&this.getMode()===b.ActionMode&&this.getActionButtons().length};P.prototype._getNavigateAction=function(){return this._oNavigateAction};P.prototype._navigateEventHandler=function(e){e.preventDefault();var t=e.getSource().getParent().getUrl();x.redirect(t,true)};P.prototype.getDropAreaRect=function(e){var t=this.getDomRef().getBoundingClientRect().toJSON();var i=this.getDropAreaOffset();if(e==="Horizontal"){t.left-=i;t.right+=i}else{t.top-=i;t.bottom+=i}return t};function w(e,t){var i=false,s=false;if(t._isActionMode()){var o=document.querySelector('[id="'+t.getId()+"-actionButtons"+'"]');i=o&&o!==e.target&&o.contains(e.target)}if(t._isNavigateActionEnabled()){var n=document.querySelector('[id="'+t.getId()+"-navigateActionContainer"+'"]');s=n&&n!==e.target&&n.contains(e.target)}return i||s}return P});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GenericTileLineModeRenderer", ["sap/m/library","sap/base/security/encodeCSS","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,jQuery,s){"use strict";var n=e.GenericTileScope;var r=e.LoadState;var a={apiVersion:2};a.render=function(e,a){var o=a._getTooltipText(),i=a._isScreenLarge(),p=a._getAriaText(),c=a.getScope(),l,d=false,S=a.hasListeners("press"),f=a.getState(),g=a.getAriaRoleDescription(),h=a.getAriaRole();var T=a.getUrl()&&!a._isInActionScope()&&f!==r.Disabled;this._bRTL=s.getRTL();if(c===n.Actions){if(f!==r.Disabled){l=t("sapMGTScopeActions")}}else if(c===n.ActionMore||c===n.ActionRemove){d=true;if(f!==r.Disabled){l=t("sapMGTScopeSingleAction")}}else{l=t("sapMGTScopeDisplay")}if(T){e.openStart("a",a);e.attr("href",a.getUrl());e.attr("rel","noopener noreferrer")}else{e.openStart("span",a)}e.attr("aria-label",p);if(g){e.attr("aria-roledescription",g)}if(h){e.attr("role",h)}else if(!T){e.attr("role",S?"button":"presentation")}else{e.attr("role","link")}e.class("sapMGT");e.class(l);if(c===n.ActionMore){e.style("padding-right","3.3rem")}if(f!==r.Disabled&&c===n.ActionRemove){e.class("sapMGTAcionRemove")}e.class("sapMGTLineMode");if(a.getSystemInfo()||a.getAppShortcut()){e.class("sapMGTInfoRendered");if(!i){e.class("sapMGTLineModeSmall")}}this._writeDirection(e);if(o){e.attr("title",o)}if(f!==r.Disabled){if(!a.isInActionRemoveScope()){e.class("sapMPointer");e.style("pointer-events","auto")}e.attr("tabindex","0")}else{e.class("sapMGTDisabled")}if(f===r.Failed){e.class("sapMGTFailed")}e.openEnd();if(o){a.getAggregation("_invisibleText").setText(o);e.renderControl(a.getAggregation("_invisibleText"))}if(a.getState()!==r.Disabled){this._renderFocusDiv(e,a)}if(i){e.openStart("div",a.getId()+"-startMarker");e.class("sapMGTStartMarker");e.openEnd();e.close("div");this._renderFailedIcon(e,a);e.openStart("span",a.getId()+"-lineWrapper");e.class("sapMGTLineWrapper");e.openEnd();e.openStart("span",a.getId()+"-headerWrapper");e.class("sapMGTHeaderWrapper");e.openEnd();this._renderHeader(e,a);if(a.getSubheader()){this._renderSubheader(e,a)}e.close("span");if(a.getSystemInfo()||a.getAppShortcut()){this._renderInfoContainer(e,a)}e.close("span");e.openStart("div",a.getId()+"-endMarker");e.class("sapMGTEndMarker");e.openEnd();if(a._isInActionScope()){this._renderActionsScope(e,a,d)}e.close("div");e.openStart("div",a.getId()+"-styleHelper");e.class("sapMGTStyleHelper");e.openEnd();e.close("div")}else if(a.getSystemInfo()||a.getAppShortcut()){e.openStart("div",a.getId()+"-touchArea");e.class("sapMGTTouchArea");e.openEnd();this._renderFailedIcon(e,a);e.openStart("span",a.getId()+"-lineModeHelpContainer");e.class("sapMGTLineModeHelpContainer");e.openEnd();e.openStart("span",a.getId()+"-headerWrapper");e.class("sapMGTHeaderWrapper");e.openEnd();this._renderHeader(e,a);if(a.getSubheader()){this._renderSubheader(e,a)}e.close("span");if(a.getSystemInfo()||a.getAppShortcut()){this._renderInfoContainer(e,a)}e.close("span");if(a._isInActionScope()){this._renderActionsScope(e,a,d)}e.close("div")}else{e.openStart("div",a.getId()+"-touchArea");e.class("sapMGTTouchArea");e.openEnd();this._renderFailedIcon(e,a);e.openStart("span",a.getId()+"-lineModeHelpContainer");e.class("sapMGTLineModeHelpContainer");e.openEnd();this._renderHeader(e,a);if(a.getSubheader()){this._renderSubheader(e,a)}e.close("span");if(a._isInActionScope()){this._renderActionsScope(e,a,d)}e.close("div")}if(a._isInActionScope()&&a.getState()!==r.Disabled){e.renderControl(a._oRemoveButton)}if(T){e.close("a")}else{e.close("span")}};a._renderInfoContainer=function(e,t){e.openStart("span",t.getId()+"-sapMGTTInfoWrapper");e.class("sapMGTTInfoWrapper").openEnd();e.openStart("span",t.getId()+"-sapMGTTInfo");e.class("sapMGTTInfo");if(!(t.getSystemInfo()&&t.getAppShortcut())){e.class("sapMGTInfoNotContainsSeperator")}e.openEnd();if(t.getAppShortcut()){e.openStart("span",t.getId()+"-appShortcut");e.class("sapMGTAppShortcutText").openEnd();e.renderControl(t._oAppShortcut);e.close("span")}if(t.getSystemInfo()){this._renderSystemInfo(e,t)}e.close("span");e.close("span")};a._writeDirection=function(e){if(this._bRTL){e.attr("dir","rtl")}};a._renderSystemInfo=function(e,t){e.openStart("span",t.getId()+"-systemInfoText");this._writeDirection(e);e.class("sapMGTSystemInfoText");if(t.getSystemInfo()&&t.getAppShortcut()){e.class("sapMGTSeperatorPresent")}e.openEnd();e.text(t._oSystemInfo.getText());e.close("span")};a._renderFailedIcon=function(e,t){if(t.getState()===r.Failed){if(t._isCompact()){t._oErrorIcon.setSize("1.25rem")}else{t._oErrorIcon.setSize("1.375rem")}e.renderControl(t._oErrorIcon.addStyleClass("sapMGTLineModeFailedIcon"))}};a._renderHeader=function(e,t){e.openStart("span",t.getId()+"-hdr-text");this._writeDirection(e);e.class("sapMGTHdrTxt");e.openEnd();e.text(t._oTitle.getText());e.close("span")};a._renderSubheader=function(e,t){e.openStart("span",t.getId()+"-subHdr-text");this._writeDirection(e);e.class("sapMGTSubHdrTxt");e.openEnd();e.text(t._oSubTitle.getText());e.close("span")};a._renderActionsScope=function(e,t,s){if(t.getState()!==r.Disabled){e.openStart("span",t.getId()+"-actions");e.class("sapMGTActionsContainer");if(s){e.class("sapMGTScopeSingleActionContainer")}e.openEnd();e.renderControl(t._oMoreIcon);e.close("span")}};a._updateHoverStyle=function(){var e=this.$("styleHelper");e.empty();if(!this._oStyleData||this.$().is(":hidden")){return}if(this._oStyleData.rtl){e.css("right",-this._oStyleData.positionRight)}else{e.css("left",-this._oStyleData.positionLeft)}this._oStyleData.lines.forEach(function(t){var s=jQuery("<div class='sapMGTLineStyleHelper'><div class='sapMGTLineStyleHelperInner'></div></div>");if(this._oStyleData.rtl){s.css("right",t.offset.x+"px")}else{s.css("left",t.offset.x+"px")}s.css({top:t.offset.y+"px",width:t.width+"px"});e.append(s)},this)};a._renderFocusDiv=function(e,t){e.openStart("div",t.getId()+"-focus");e.class("sapMGTFocusDiv");e.openEnd();e.close("div")};a._getCSSPixelValue=function(e,t){var s=e instanceof jQuery?e:e.$(),n=(s.css(t)||"").match(/([^a-zA-Z\%]*)(.*)/),r=parseFloat(n[1]),a=n[2];return a==="px"?r:r*16};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GenericTileRenderer", ["sap/m/library","sap/base/security/encodeCSS","sap/ui/core/Configuration"],function(e,o,t){"use strict";var n=e.GenericTileMode;var a=e.LoadState;var s=e.FrameType;var r=e.ValueColor;var i={apiVersion:2};i.render=function(e,t){var i=t._getTooltipText();var l=t._getAriaText();var d=t.getHeaderImage();var c=t.hasListeners("press");var p=t.getState();var f=o("sapMGTState"+p);var g;var v=t.getFrameType();var T=t.getAriaRoleDescription();var h=t.getAriaRole();var S=v===s.OneByHalf||v===s.TwoByHalf;var M=t._sBGColor;var I=t._isIconMode()&&v===s.OneByOne;var u=t.getLinkTileContents();var m=t.getUrl()&&(!t._isInActionScope()||t.getMode()===n.IconMode)&&p!==a.Disabled&&!t._isNavigateActionEnabled()&&!t._isActionMode();if(t._isInActionScope()){g=o("sapMGTScopeActions")}else{g=o("sapMGTScopeDisplay")}if(m){e.openStart("a",t);e.attr("href",t.getUrl());e.attr("rel","noopener noreferrer");if(!this._isDragabble(t)){e.attr("draggable","false")}}else{e.openStart("div",t)}if(i&&p!==a.Loading){e.attr("title",i)}e.class("sapMGT");e.class(f);e.class(g);if(!t._isInActionScope()&&t._bShowActionsView){e.class("sapMGTScopeActions")}if(t._isIconMode()){if(v===s.OneByOne){var C="sapMGTOneByOne"}else if(v===s.TwoByHalf){var C="TwoByHalf"}}e.class(t._isIconMode()?C:v);var y=t.getMode()===n.ArticleMode,_=t.getMode()===n.ActionMode;if(_){e.class("sapMGTActionMode")}if(y){e.class("sapMGTArticleMode")}if(t._isIconMode()){e.class("sapMGTIconMode");if(this._isThemeHighContrast()){e.class("HighContrastTile")}}if(!y&&!_&&v!==s.OneByHalf&&(t.getSystemInfo()||t.getAppShortcut())){e.class("tileWithAppInfo")}if(t._isIconMode()){if(v===s.TwoByHalf){e.class("sapMGTTwoByHalf")}else if(v===s.OneByOne){if(!this._isThemeHighContrast()){e.style("background-color",M)}else{e.style("border-color",M);e.style("box-shadow","0 0 0 1px"+M)}}}if(h){e.attr("role",h)}else if(!m){e.attr("role",c?"button":"presentation")}else{e.attr("role","link")}if(p===a.Loaded){e.attr("aria-label",l)}if(T){e.attr("aria-roledescription",T)}if(p!==a.Disabled){if(!t.isInActionRemoveScope()&&t.getPressEnabled()){e.class("sapMPointer")}if(!t.getPressEnabled()){e.class("sapMAutoPointer")}e.attr("tabindex","0")}if(t.getWidth()){e.style("width",t.getWidth())}if(t.getBackgroundImage()){e.style("background-image","url('"+o(t.getBackgroundImage())+"')");e.class("sapMGTBackgroundImage")}if(t.getMode()===n.HeaderMode){e.class("sapMGTHeaderMode")}var G=t.getTileContent();var B=G.length;if(this._isNewsContentPresent(G,B)){e.class("sapMGTNewsContent")}if(u.length>0){e.class("sapMGTLinkTileContent")}e.openEnd();if(i){t.getAggregation("_invisibleText").setText(i);e.renderControl(t.getAggregation("_invisibleText"))}var O=false;var H=false;function b(e,o){if(v===s.OneByOne){e.openStart("div").class("sapMGTContentShimmerPlaceholderItemOneByOne");e.class("sapMGTContentShimmerPlaceholderWithDescriptionOneByOne");e.openEnd();e.openStart("div").class("sapMGTContentShimmerPlaceholderRowsOneByOne").openEnd();e.openStart("div").class("sapMGTContentShimmerPlaceholderIconOneByOne").class("sapMGTLoadingShimmer").openEnd().close("div");if(o){e.openStart("div").class("sapMGTContentShimmerPlaceholderItemTextOneByOne").class("sapMGTLoadingShimmer").openEnd().close("div")}}else{e.openStart("div").class("sapMGTContentShimmerPlaceholderItemTwoByHalf");e.class("sapMGTContentShimmerPlaceholderWithDescriptionTwoByHalf");if(!t.getIconLoaded()&&!o){e.class("sapMGTContentShimmerPlaceholderWithDescriptionTwoByHalfIconLoaded")}e.openEnd();e.openStart("div").class("sapMGTContentShimmerPlaceholderRowsTwoByHalf").openEnd();e.openStart("div").class("sapMGTContentShimmerPlaceholderIconTwoByHalf").class("sapMGTLoadingShimmer").openEnd().close("div");if(o){e.openStart("div").class("sapMGTContentShimmerPlaceholderItemTextTwoByHalf").class("sapMGTLoadingShimmer").openEnd().close("div")}}e.close("div");e.close("div")}if(p===a.Loading){if(t._isIconMode()){b(e,true)}else{e.openStart("div").class("sapMGTContentShimmerPlaceholderItem");e.class("sapMGTContentShimmerPlaceholderWithDescription");e.openEnd();e.openStart("div").class("sapMGTContentShimmerPlaceholderRows").openEnd();e.openStart("div").class("sapMGTContentShimmerPlaceholderItemHeader").class("sapMGTLoadingShimmer").openEnd().close("div");e.openStart("div").class("sapMGTContentShimmerPlaceholderItemText").class("sapMGTLoadingShimmer").openEnd().close("div");if(!S){for(var E=0;E<B;E++){e.renderControl(G[E])}}e.close("div");e.close("div")}}else{if(!_&&this._isValueColorValid(t.getValueColor())){e.openStart("div");e.class("sapMGTCriticalBorder");e.class(t.getValueColor());e.openEnd();e.close("div")}if(t._isIconMode()){if(!t.getIconLoaded()){b(e,false)}else{if(v===s.OneByOne){e.openStart("div");e.class("sapMGTHideOverflow");e.openEnd();e.openStart("div");e.class("sapMGTIconWrapper");e.openEnd()}e.openStart("div");if(v===s.OneByOne){e.class("sapMGTOneByOneIcon")}else{e.class("sapMGTTwoByHalfIcon");if(t._sTileBadge){e.class("sapMGTIconBadge")}else if(!this._isThemeHighContrast()){e.style("background-color",M)}else{e.class("HighContrastTile");e.style("border-color",M);e.style("box-shadow","0 0 0 1px"+M)}}e.openEnd();if(t.getTileIcon()||t._sTileBadge){var w=t._generateIconAggregation(t._sTileBadge?"sap-icon://folder-full":t.getTileIcon());if(w){var A=t.getAggregation(w);if(t._sTileBadge){A.setColor(M)}e.renderControl(A)}if(t._sTileBadge){e.openStart("div",t.getId()+"-tileBadge").class("sapMGTileBadge").openEnd();e.text(t._sTileBadge);e.close("div")}}e.close("div")}}if(this._shouldRenderInfoContainer(t)&&v===s.TwoByHalf){e.openStart("div",t.getId()+"-wrapper").class("sapMGTWrapper").openEnd();e.openStart("div",t.getId()+"-wrapper-content").class("sapMGTWrapperCnt").openEnd()}e.openStart("div");e.class("sapMGTHdrContent");if(t._isIconMode()){if(v===s.OneByOne){var C="sapMGTOneByOne";if(!t.getIconLoaded()){C=C.concat(" sapMGTOneByOneIconLoaded")}}else if(v===s.TwoByHalf){var C="TwoByHalf"}}e.class(t._isIconMode()?C:v);if(i){e.attr("title",i)}if(_&&t.getFrameType()===s.TwoByOne&&d){e.class("sapMGTHdrImage")}e.openEnd();if(d){t._oImage.removeStyleClass(r.None);if(this._sPreviousStyleClass){t._oImage.removeStyleClass(this._sPreviousStyleClass)}this._sPreviousStyleClass=this._isValueColorValid(t.getValueColor())?t.getValueColor():r.None;t._oImage.addStyleClass(this._sPreviousStyleClass);e.renderControl(t._oImage)}this._renderHeader(e,t);if(I){e.close("div");e.close("div")}for(var E=0;E<B;E++){O=t._checkFooter(G[E],t)&&(G[E].getFooter()||G[E].getUnit());var P=G[E].getContent();if(P){if(v===s.OneByHalf&&P.getMetadata().getElementName()==="sap.m.ImageContent"){H=false}else{H=true;break}}}if(!(S&&H)&&t.getSubheader()){this._renderSubheader(e,t)}e.close("div");if(!t._isIconMode()){e.openStart("div",t.getId()+"-content");e.class("sapMGTContent");if(v===s.TwoByOne){e.class("TwoByOne")}if(t.getSystemInfo()||t.getAppShortcut()){if(G.length===0){e.class("appInfoWithoutTileCnt")}if(O&&v!==s.OneByHalf){e.class("appInfoWithFooter")}else{e.class("appInfoWithoutFooter")}}e.openEnd();if(u.length>0){e.openStart("div",t.getId()+"-linkTileContent").class("sapMGTLinkTileContentWrapper").openEnd();for(var E=0;E<u.length;E++){e.renderControl(u[E].getLinkTileContentInstance())}e.close("div")}for(var E=0;E<B;E++){e.renderControl(G[E])}if(this._shouldRenderInfoContainer(t)&&v!==s.TwoByHalf){this._renderInfoContainer(e,t)}e.close("div")}if(this._shouldRenderInfoContainer(t)&&v===s.TwoByHalf){e.close("div");this._renderInfoContainer(e,t);e.close("div")}}if(p!==a.Loaded&&p!==a.Loading){this._renderStateOverlay(e,t,i)}if(p!==a.Disabled){this._renderHoverOverlay(e,t);this._renderFocusDiv(e,t)}if(t._isInActionScope()){this._renderActionsScope(e,t)}if(m){e.close("a")}else{e.close("div")}};i._isDragabble=function(e){var o=e.getDragDropConfig().some(function(o){return o.isDraggable(e)});if(!o){var t=e.getParent();if(t&&t.getDragDropConfig){o=t.getDragDropConfig().some(function(o){return o.isDraggable(e)})}}return o};i._shouldRenderInfoContainer=function(e){var o=e.getFrameType(),t=e.getMode()===n.ArticleMode,a=e.getMode()===n.ActionMode,r=e.getMode()===n.IconMode;if(o===s.OneByOne&&r){return true}return!t&&!a&&!r&&o!==s.OneByHalf&&(e.getSystemInfo()||e.getAppShortcut())};i._renderInfoContainer=function(e,o){e.openStart("div",o.getId()+"-tInfo");e.class("sapMGTTInfoContainer");e.openEnd();e.openStart("div",o.getId()+"-tInfo-content");e.class("sapMGTTInfo");e.openEnd();if(o.getAppShortcut()){e.openStart("div",o.getId()+"-appShortcutWrapper");e.class("sapMGTAppShortcutText").openEnd();e.renderControl(o._oAppShortcut);e.close("div")}if(o.getSystemInfo()){e.openStart("div",o.getId()+"-sytemInfoWrapper");e.class("sapMGTSystemInfoText").openEnd();e.renderControl(o._oSystemInfo);e.close("div")}e.close("div");e.close("div")};i._renderFocusDiv=function(e,o){e.openStart("div",o.getId()+"-focus");e.class("sapMGTFocusDiv");e.openEnd();e.close("div")};i._renderStateOverlay=function(e,o,t){var n=o.getState();e.openStart("div",o.getId()+"-overlay");e.class("sapMGTOverlay");if(t){e.attr("title",t)}e.openEnd();switch(n){case a.Loading:o._oBusy.setBusy(n==a.Loading);e.renderControl(o._oBusy);break;case a.Failed:e.openStart("div",o.getId()+"-failed-ftr");e.class("sapMGenericTileFtrFld");e.openEnd();e.openStart("div",o.getId()+"-failed-icon");e.class("sapMGenericTileFtrFldIcn");e.openEnd();e.renderControl(o._oErrorIcon);e.close("div");if(!o._isInActionScope()&&!o._bShowActionsView){e.openStart("div",o.getId()+"-failed-text");e.class("sapMGenericTileFtrFldTxt");e.openEnd();e.renderControl(o.getAggregation("_failedMessageText"));e.close("div")}e.close("div");break;default:}e.close("div")};i._renderActionsScope=function(e,o){if(o.getState()!==a.Disabled){e.renderControl(o._oRemoveButton);e.renderControl(o._oMoreIcon)}};i._renderHoverOverlay=function(e,o){e.openStart("div",o.getId()+"-hover-overlay");if(o.getBackgroundImage()){e.class("sapMGTWithImageHoverOverlay")}else{e.class("sapMGTWithoutImageHoverOverlay");if(o._isIconMode()){if(o.getFrameType()===s.OneByOne){e.style("border-radius","1rem")}else{e.style("border-radius","0.75rem")}}}e.openEnd();e.close("div")};i._renderHeader=function(e,o){e.openStart("div",o.getId()+"-hdr-text");e.class("sapMGTHdrTxt");if(o._isActionMode()&&this._isValueColorValid(o.getValueColor())){e.class("sapMGTCriticalHdrTxt");e.class(o.getValueColor())}e.openEnd();e.renderControl(o._oTitle);e.close("div")};i._renderSubheader=function(e,o){e.openStart("div",o.getId()+"-subHdr-text");e.class("sapMGTSubHdrTxt");e.openEnd();e.renderControl(o._oSubTitle);e.close("div")};i._isValueColorValid=function(e){if(e==r.Good||e==r.Error||e==r.Neutral||e==r.Critical){return true}return false};i._isThemeHighContrast=function(){return/(hcw|hcb)/g.test(t.getTheme())};i._isNewsContentPresent=function(e,o){var t=false;for(var n=0;n<o;n++){var a=e[n].getContent();if(a&&a.isA("sap.m.NewsContent")){t=true;break}}return t};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GroupHeaderListItem", ["sap/ui/core/library","./library","./ListItemBase","./GroupHeaderListItemRenderer"],function(e,t,r,a){"use strict";var n=t.ListMode;var o=e.TextDirection;var i=r.extend("sap.m.GroupHeaderListItem",{metadata:{interfaces:["sap.m.ITableItem"],library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},count:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:o.Inherit}}},renderer:a});i.prototype.getMode=function(){return n.None};i.prototype.shouldClearLastValue=function(){return true};i.prototype.getTable=function(){var e=this.getParent();if(e&&e.isA("sap.m.Table")){return e}};i.prototype.onBeforeRendering=function(){var e=this.getTable();if(e){e.getColumns().forEach(function(e){e.clearLastValue()});this.TagName="tr";this.aAriaOwns=[]}};i.prototype.getAccessibilityType=function(e){};i.prototype.getContentAnnouncement=function(){return this.getTitle()};i.prototype.getGroupAnnouncement=function(){};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GroupHeaderListItemRenderer", ["sap/ui/core/Core","sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer","./ColumnListItemRenderer"],function(e,t,n,r,a){"use strict";var i=t.TextDirection;var o=n.extend(r);o.apiVersion=2;o.renderType=function(e,t){var n=t.getTable();if(!n||!n.doItemsNeedTypeColumn()){return}e.openStart("td",t.getId()+"-TypeCell");e.class("sapMListTblNavCol");e.attr("role","presentation");e.openEnd().close("td")};o.renderNavigated=function(e,t){var n=t.getTable()?a:r;n.renderNavigated.apply(n,arguments)};o.renderContentLatter=function(e,t){a.renderContentLatter.apply(this,arguments)};o.renderMode=function(){};o.renderCounter=function(){};o.renderHighlight=function(e,t){if(t.getTable()){e.openStart("td");e.class("sapMListTblHighlightCell");e.attr("role","presentation");e.openEnd();e.close("td")}else{r.renderHighlight(e,t)}};o.getAccessbilityPosition=a.getAccessbilityPosition;o.renderLIAttributes=function(t,n){t.class("sapMGHLI");if(n.getUpperCase()){t.class("sapMGHLIUpperCase")}var r=n.getTable();if(r){t.attr("aria-roledescription",e.getLibraryResourceBundle("sap.m").getText("TABLE_GROUP_ROW"))}};o.renderLIContentWrapper=function(e,t){var n=t.getTable();if(n){e.openStart("td",t.getId()+"-cell");e.class("sapMGHLICell");e.attr("role","gridcell");a.makeFocusable(e);e.attr("colspan",n.getColCount()-n.doItemsNeedTypeColumn()-n.shouldRenderDummyColumn()-2);e.openEnd()}r.renderLIContentWrapper.apply(this,arguments);if(n){for(var i=1;i<n._colHeaderAriaOwns.length;i++){e.openStart("div").class("sapMTblItemNav").openEnd().close("div")}e.close("td")}};o.renderLIContent=function(e,t){var n=t.getTitleTextDirection();e.openStart("span");e.class("sapMGHLITitle");if(n!=i.Inherit){e.attr("dir",n.toLowerCase())}e.openEnd();e.text(t.getTitle());e.close("span");var r=t.getCount()||t.getCounter();if(r){e.openStart("span");e.class("sapMGHLICounter");e.openEnd();e.text(" ("+r+")");e.close("span")}};o.addLegacyOutlineClass=function(e,t){var n=t.getTable()?a:r;n.addLegacyOutlineClass.apply(this,arguments)};o.getAriaRole=function(e){return e.getTable()?"row":"listitem"};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GrowingEnablement", ["sap/ui/base/Object","sap/ui/core/Lib","sap/ui/core/RenderManager","sap/ui/core/format/NumberFormat","sap/m/library","sap/ui/model/ChangeReason","sap/ui/base/ManagedObjectMetadata","sap/ui/base/ManagedObjectObserver","sap/ui/core/HTML","sap/m/CustomListItem","sap/base/security/encodeXML","sap/ui/thirdparty/jquery"],function(t,e,i,s,o,r,n,a,l,h,g,jQuery){"use strict";var d=o.ListType;var u=o.ListGrowingDirection;var _=t.extend("sap.m.GrowingEnablement",{constructor:function(e){t.apply(this);this._oControl=e;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var i=this._oControl.getItems(true).length;this._iRenderedDataItems=i;this._iLimit=i;this._bLoading=false;this._bDataRequested=false;this._bSkippedItemsUpdateUntilDataReceived=false;this._iLastItemsCount=0;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;this._aItemsPool=[]},destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null}if(this._oRM){this._oRM.destroy();this._oRM=null}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}this.clearItemsPool();this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oControl=null},render:function(t){t.openStart("div",this._oControl.getId()+"-triggerList");t.class("sapMListUl").class("sapMGrowingList");t.style("display","none");t.openEnd();t.renderControl(this._getTrigger());t.close("div")},onAfterRendering:function(){var t=this._oControl;if(t.getGrowingScrollToLoad()){var e=o.getScrollDelegate(t);if(e){this._oScrollDelegate=e;e.setGrowingList(this.onScrollToLoad.bind(this),t.getGrowingDirection(),this._updateTrigger.bind(this,false))}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null}if(!this._bLoading){this._updateTriggerDelayed(false)}},onsapdown:function(t){var e=this._oControl;if(e._oItemNavigation&&!t.isMarked()){var i=e._oItemNavigation;var s=i.getItemDomRefs();var o=s[0];var r=s[s.length-i.iColumns];var n=e.getGrowingDirection();if(n!=u.Upwards&&t.type=="sapdown"&&t.target===r||n==u.Upwards&&t.type=="sapup"&&t.target===o){var a=e.$("trigger");a.trigger("focus");t.setMarked();t.stopImmediatePropagation()}else if((n==u.Upwards&&t.type=="sapdown"||n!=u.Upwards&&t.type=="sapup")&&t.target===e.getDomRef("trigger")){jQuery(t.type=="sapdown"?o:r).trigger("focus");t.setMarked();t.stopImmediatePropagation()}}},onsapup:function(t){return this.onsapdown(t)},setTriggerText:function(t){this._oControl.$("triggerText").text(t)},reset:function(t){this._iLimit=0;if(t){return}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}this.clearItemsPool();var e=this._oControl.getBindingInfo("items");this._oControl.oExtendedChangeDetectionConfig=!e||!e.template?null:{replace:true}},clearItemsPool:function(){this._aItemsPool.forEach(function(t){t.destroy()});this._aItemsPool=[]},shouldReset:function(t){var e=r;return t==e.Sort||t==e.Filter||t==e.Context},getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems}},onScrollToLoad:function(){if(this._bLoading){return}if(this._oControl.getGrowingDirection()==u.Upwards){var t=this._oScrollDelegate;this._oScrollPosition={left:t.getScrollLeft(),top:t.getScrollHeight()}}this.requestNewPage()},requestNewPage:function(){if(!this._oControl||this._bLoading){return}var t=this._oControl.getBinding("items");if(t&&!t.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){this._oControl._bBusy=true;this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing")}},_onBeforePageLoaded:function(t){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),t)},_onAfterPageLoaded:function(t){if(!this._oControl){return}this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),t)},_getTrigger:function(){var t=this._oControl.getId()+"-trigger",i=this._oControl.getGrowingTriggerText();i=i||e.getResourceBundleFor("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(i);return this._oTrigger}this._oTrigger=new h({id:t,busyIndicatorDelay:0,type:d.Active,content:new l({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLIDiv sapMGrowingListTriggerText">'+'<span class="sapMSLITitle" id="'+t+'Text">'+g(i)+"</span>"+"</div>"+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'<div class="sapUiInvisibleText" id="'+t+'Message"></div>'+"</div>"})});this._oTrigger.getList=function(){};this._oTrigger.TagName="div";this._oTrigger.setGroupedItem=function(){};this._oTrigger.setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addDelegate({onsapenter:function(t){this.requestNewPage();t.preventDefault()},onsapspace:function(t){this._bSpaceKeyPressed=true;this._oTrigger.setActive(true);t.preventDefault()},onkeydown:function(t){this._bSpaceKeyCancelled=this._bSpaceKeyCancelled||(t.shiftKey||t.which==27)},onkeyup:function(t){this._bSpaceKeyPressed&&!this._bSpaceKeyCancelled&&this.requestNewPage();this._bSpaceKeyPressed=this._bSpaceKeyCancelled=false;this._oTrigger.setActive(false)},onAfterRendering:function(e){var i=this._oTrigger.$();i.removeAttr("aria-selected");i.removeAttr("aria-roledescription");i.removeAttr("aria-posinset").removeAttr("aria-setsize");i.attr({tabindex:0,role:"button","aria-labelledby":t+"Text","aria-describedby":t+"Message"})}},this);return this._oTrigger},_getListItemInfo:function(){var t=this._getItemCounts();var e=s.getFloatInstance();return"[ "+e.format(t[0])+" / "+e.format(t[1])+" ]"},_getItemCounts:function(){return[this._iRenderedDataItems,this._oControl.getMaxItemsCount()]},_getGroupingPath:function(t){var e=t.aSorters||[];var i=e[0]||{};return i.fnGroup?i.sPath||"":undefined},_getDomIndex:function(t){if(typeof t!="number"){return t}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return t*2}return t},_getHasScrollbars:function(){if(!this._oScrollDelegate){return false}if(this._getDomIndex(this._iRenderedDataItems)>window.innerHeight/32){return true}return this._oScrollDelegate.getMaxScrollTop()>this._oControl.getDomRef("triggerList").offsetHeight},destroyListItems:function(t){this._oControl.destroyItems(t);this._iRenderedDataItems=0;this._aChunk=[]},addListItem:function(t,e,i){var s=this._oControl,o=e.binding,r=this.createListItem(t,e);if(o.isGrouped()){var n=s.getItems(true),a=n[n.length-1],l=e.model,h=o.getGroup(r.getBindingContext(l));if(a&&a.isGroupHeader()){s.removeAggregation("items",a,true);s.setLastGroupHeader(a);this._fnAppendGroupItem=this.appendGroupItem.bind(this,h,a,i);a=n[n.length-1]}if(!a||h.key!==o.getGroup(a.getBindingContext(l)).key){var g=e.groupHeaderFactory?e.groupHeaderFactory(h):s.getGroupHeaderTemplate(h);if(s.getGrowingDirection()==u.Upwards){this.applyPendingGroupItem();s.setLastGroupHeader(g);this._fnAppendGroupItem=this.appendGroupItem.bind(this,h,g,i)}else{this.appendGroupItem(h,g,i)}}var d=s.getLastGroupHeader();if(d){d.invalidate()}}s.addAggregation("items",r,i);if(i){this._aChunk.push(r)}},applyPendingGroupItem:function(){if(this._fnAppendGroupItem){this._fnAppendGroupItem();this._fnAppendGroupItem=undefined}},appendGroupItem:function(t,e,i){e=this._oControl.addItemGroup(t,e,i);if(i){this._aChunk.push(e)}},fillItemsPool:function(){if(!this._oControl||!this._iLimit||this._iRenderedDataItems||this._aItemsPool.length){return}var t=this._oControl.getBindingInfo("items");var e=t.template;if(!e){return}for(var i=0,s=Math.min(this._iLimit,100);i<s;i++){this._aItemsPool.push(t.factory())}if(e.getCells){this._oObserver=new a(this.clearItemsPool.bind(this));this._oObserver.observe(e,{aggregations:["cells"]})}},createListItem:function(t,e){this._iRenderedDataItems++;if(this._aItemsPool.length){return this._aItemsPool.shift().setBindingContext(t,e.model)}return _.createItem(t,e)},updateItemsBindingContext:function(t,e){if(!t.length){return}var i=this._oControl.getItems(true);for(var s=0,o=0,r;s<i.length;s++){r=i[s];if(!r.isGroupHeader()){r.setBindingContext(t[o++],e)}}},applyChunk:function(t,e){if(!this._oControl){return}this.applyPendingGroupItem();var s=this._iChunkTimer;var o=this._aChunk.length;var r=this._oControl.getItemsContainerDomRef();if(s){this._iChunkTimer=clearTimeout(s)}if(!o||!r||!this._oControl.shouldRenderItems()){this._aChunk=[];return}if(s&&!e){this._oControl.invalidate();this._aChunk=[];return}if(this._oControl.getGrowingDirection()==u.Upwards){this._aChunk.reverse();if(t===true){t=0}else if(typeof t=="number"){t=this._iRenderedDataItems-o-t}}this._oRM=this._oRM||new i;for(var n=0;n<o;n++){this._oRM.renderControl(this._aChunk[n])}this._bHadFocus=t==false&&r.contains(document.activeElement);this._oRM.flush(r,false,this._getDomIndex(t));this._bHadFocus&&this._oControl.focus();if(!this._oControl.getBusy()){this._bHadFocus=false}this._aChunk=[]},applyChunkAsync:function(t){if(this._bApplyChunkAsync){this._iChunkTimer=setTimeout(this.applyChunk.bind(this,t,true))}else{this.applyChunk(t)}},addListItems:function(t,e,i){for(var s=0;s<t.length;s++){this.addListItem(t[s],e,i)}},rebuildListItems:function(t,e,i){this.destroyListItems(i);this.addListItems(t,e,i);if(i){this.applyChunkAsync(false)}else{this.applyPendingGroupItem()}},insertListItem:function(t,e,i){var s=this.createListItem(t,e);this._oControl.insertAggregation("items",s,i,true);this._aChunk.push(s)},deleteListItem:function(t){var e=this._oControl.getItems(true)[t];if(e){this._oControl.getItems(true)[t].destroy(true);this._iRenderedDataItems--}},refreshItems:function(t){var e=this._oControl;var i=e.getBinding("items");this._bApplyChunkAsync=i.isA("sap.ui.model.odata.v4.ODataListBinding")&&e.checkGrowingFromScratch();if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(t)}if(!this._iLimit||this.shouldReset(t)||!e.getItems(true).length){this._iLimit=e.getGrowingThreshold()}if(!i.isA("sap.ui.model.odata.ODataListBinding")){if(e._bBusy){setTimeout(this.fillItemsPool.bind(this))}else{i.attachEventOnce("dataRequested",function(){setTimeout(this.fillItemsPool.bind(this))},this)}}i.getContexts(0,this._iLimit)},updateItems:function(t){var e=this._oControl,i=e.getBinding("items"),s=e.getBindingInfo("items"),o=e.getItems(true),n=this._sGroupingPath;if(!this._iLimit||this.shouldReset(t)||!o.length){this._iLimit=e.getGrowingThreshold()}this._bSkippedItemsUpdateUntilDataReceived=false;if(this._bDataRequested){this._bDataRequested=false}else{this._onBeforePageLoaded(t)}var a=i.getContexts(0,this._iLimit)||[];if(a.dataRequested){this._bDataRequested=true;if(a.diff&&!a.diff.length){if(t===r.Context){this._bSkippedItemsUpdateUntilDataReceived=true}return}}this._sGroupingPath=this._getGroupingPath(i);var l=a.diff;if(!a.length){this.destroyListItems()}else if(!o.length&&!e.getItemsContainerDomRef()){this.rebuildListItems(a,s)}else if(!l||!o.length&&l.length){this.rebuildListItems(a,s,e.shouldGrowingSuppressInvalidation())}else{var h=false,g=true;if(i.isGrouped()||e.checkGrowingFromScratch()){if(n!=this._sGroupingPath){h=true}else{for(var d=0;d<l.length;d++){var u=l[d],_=a[u.index];if(u.type=="delete"||u.type=="replace"){h=true;break}else if(u.index!=this._iRenderedDataItems){h=true;break}else{this.addListItem(_,s,true)}}}}else{if(n!=undefined&&this._sGroupingPath==undefined){e.removeGroupHeaders(true)}g=-1;var f=-1;for(var d=0;d<l.length;d++){var u=l[d],p=u.index,_=a[p];if(u.type=="delete"){if(g!=-1){this.applyChunk(g);f=-1;g=-1}this.deleteListItem(p)}else if(u.type=="insert"){if(g==-1){g=p}else if(f>-1&&p!=f+1){this.applyChunk(g);g=p}this.insertListItem(_,s,p);f=p}}}if(h){this.rebuildListItems(a,s,true)}else{this.updateItemsBindingContext(a,s.model);this.applyChunkAsync(g)}}if(!this._bDataRequested){this._onAfterPageLoaded(t)}},_onBindingDataReceivedListener:function(t){if(this._bSkippedItemsUpdateUntilDataReceived&&!t.getParameter("data")){this._bSkippedItemsUpdateUntilDataReceived=false;this.destroyListItems();this._onAfterPageLoaded()}},_updateTriggerDelayed:function(t){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&clearTimeout(this._iTriggerTimer);this._iTriggerTimer=setTimeout(this._updateTrigger.bind(this,t))}else{this._updateTrigger(t)}},_updateTrigger:function(t){var i=this._oTrigger,s=this._oControl,o=s&&s.getVisibleItems().length>0,r=s&&s.getBinding("items");if(!i||!s||!o||!r||!s.shouldRenderItems()||!s.getDomRef()){this._bHadFocus=false;return}i.setBusy(t);i.$().toggleClass("sapMGrowingListBusyIndicatorVisible",t);if(t){i.setActive(false);s.$("triggerList").css("display","")}else{var n=s.getItems(true),a=n.length,l=r.getLength()||0,h=r.isLengthFinal(),g=s.getGrowingScrollToLoad(),d=i.getDomRef();if(this._bHadFocus){this._bHadFocus=false;jQuery(this._oControl.getNavigationRoot()).trigger("focus")}else if(!this._iFocusTimer&&d&&d.contains(document.activeElement)){var _=n[this._iLastItemsCount]||n[a-1]||s;this._iFocusTimer=setTimeout(function(){this._iFocusTimer=0;_.focus()}.bind(this))}if(!a||!this._iLimit||!l||h&&this._iLimit>=l||g&&this._getHasScrollbars()){s.$("triggerList").css("display","none");s.$("listUl").removeClass("sapMListHasGrowing")}else{var f=e.getResourceBundleFor("sap.m");if(h){s.$("triggerInfo").css("display","block").text(this._getListItemInfo());var p=this._getItemCounts();s.$("triggerMessage").text(f.getText(s.isA("sap.m.Table")?"LOAD_MORE_ROWS_ACC_WITH_COUNT":"LOAD_MORE_DATA_ACC_WITH_COUNT",p))}else{s.$("triggerMessage").text(f.getText("LOAD_MORE_DATA_ACC"))}s.$("triggerList").css("display","");s.$("listUl").addClass("sapMListHasGrowing");i.$().removeClass("sapMGrowingListBusyIndicatorVisible");this.adaptTriggerButtonWidth()}this._iLastItemsCount=this._oControl.getItems(true).length;if(g&&this._oScrollPosition===undefined&&s.getGrowingDirection()==u.Upwards){this._oScrollPosition={left:0,top:0}}if(a>0&&this._oScrollPosition){var c=this._oScrollDelegate,m=this._oScrollPosition;c.scrollTo(m.left,c.getScrollHeight()-m.top);this._oScrollPosition=null}}},adaptTriggerButtonWidth:function(){var t=this._oControl;if(!t.isA("sap.m.Table")||t.hasPopin()||!t.shouldRenderDummyColumn()){return}window.requestAnimationFrame(function(){var e=this._oTrigger&&this._oTrigger.getDomRef();if(!e){return}var i=Array.from(t.getDomRef("tblHeader").childNodes).slice(0,-1).map(function(t){var e=t.style.width;if(!e||!e.includes("%")){return t.getBoundingClientRect().width+"px"}else{return e}}).join(" + ");e.style.width="calc("+i+" + 1px)";e.classList.add("sapMGrowingListDummyColumn")}.bind(this))}});_.createItem=function(t,e,i){var s=e.factory(n.uid(i?i:"clone"),t);return s.setBindingContext(t,e.model)};return _});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GrowingList", ["./List","./library","./GrowingListRenderer","sap/ui/core/Configuration"],function(t,e,r,o){"use strict";var i=t.extend("sap.m.GrowingList",{metadata:{deprecated:true,library:"sap.m",properties:{threshold:{type:"int",group:"Misc",defaultValue:20},triggerText:{type:"string",group:"Appearance",defaultValue:null},scrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false}}},renderer:r});i.prototype._isIncompatible=function(){return o.getCompatibilityVersion("sapMGrowingList").compareTo("1.16")>=0};i.prototype.init=function(){t.prototype.init.call(this);if(!this._isIncompatible()){this.setGrowing()}};i.prototype.setGrowing=function(){return t.prototype.setGrowing.call(this,true)};!function(t,e){["Threshold","TriggerText","ScrollToLoad"].forEach(function(r){t["set"+r]=e["setGrowing"+r];t["get"+r]=e["getGrowing"+r]})}(i.prototype,t.prototype);return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/GrowingListRenderer", ["./ListRenderer","sap/ui/core/Renderer","sap/base/Log"],function(e,i,r){"use strict";var n=i.extend(e);n.apiVersion=2;n.render=function(i,n){if(n._isIncompatible()){r.warning("Does not render sap.m.GrowingList#"+n.getId()+" when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!")}else{e.render.call(this,i,n)}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/HBox", ["./FlexBox","./library","./HBoxRenderer"],function(e,r,i){"use strict";var a=e.extend("sap.m.HBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/HBox.designtime"},renderer:i});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/HBoxRenderer", ["./FlexBoxRenderer"],function(e){"use strict";var r={apiVersion:2};r.render=function(r,n){e.render.apply(this,[r,n])};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/HeaderContainer", ["./library","./Button","./ScrollContainer","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/Element","sap/ui/Device","sap/m/HeaderContainerItemNavigator","sap/ui/core/delegate/ItemNavigation","sap/ui/core/library","sap/ui/core/IntervalTrigger","sap/ui/core/Icon","./HeaderContainerRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/core/Lib","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/Selectors"],function(t,e,i,r,o,s,a,n,l,h,c,g,p,d,f,u,jQuery,v,_){"use strict";var m=h.Orientation;var S=t.ScreenSizes;var b=o.extend("sap.m.HeaderContainerItemContainer",{metadata:{defaultAggregation:"item",properties:{position:{type:"int",defaultValue:null},setSize:{type:"int",defaultValue:null},ariaLabelledBy:{type:"string",defaultValue:null}},aggregations:{item:{type:"sap.ui.core.Control",multiple:false}}},renderer:{apiVersion:2,render:function(t,e){var i=e.getAggregation("item");if(!i||!i.getVisible()){return}t.openStart("div",e);t.class("sapMHdrCntrItemCntr");t.class("sapMHrdrCntrInner");t.attr("aria-setsize",e.getSetSize());t.attr("aria-posinset",e.getPosition());t.attr("role","listitem");if(e.getAriaLabelledBy()){t.attr("aria-labelledby",e.getAriaLabelledBy())}t.openEnd();t.renderControl(i);t.close("div")}}});var C=o.extend("sap.m.HeaderContainer",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{scrollStep:{type:"int",defaultValue:300,group:"Behavior"},scrollStepByItem:{type:"int",defaultValue:1,group:"Behavior"},scrollTime:{type:"int",defaultValue:500,group:"Behavior"},showOverflowItem:{type:"boolean",defaultValue:true,group:"Behavior"},showDividers:{type:"boolean",defaultValue:true,group:"Appearance"},orientation:{type:"sap.ui.core.Orientation",defaultValue:m.Horizontal,group:"Appearance"},backgroundDesign:{type:"sap.m.BackgroundDesign",defaultValue:t.BackgroundDesign.Transparent,group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"},gridLayout:{type:"boolean",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_scrollContainer:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},_prevButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{scroll:{}}},renderer:p});C.prototype.init=function(){this._aItemEnd=[];this._bRtl=v.getRTL();this._oRb=_.getResourceBundleFor("sap.m");this._oScrollCntr=new i(this.getId()+"-scrl-cntnr",{width:"100%",height:"100%",horizontal:!a.system.desktop});this.setAggregation("_scrollContainer",this._oScrollCntr,true);if(a.system.desktop){this._oArrowPrev=new e({id:this.getId()+"-scrl-prev-button",type:t.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_PREV_SECTION"),press:function(t){t.cancelBubble();this._scroll(this._getScrollValue(false),this.getScrollTime())}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this._oArrowPrev._bExcludeFromTabChain=true;this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new e({id:this.getId()+"-scrl-next-button",type:t.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_NEXT_SECTION"),press:function(t){t.cancelBubble();this._scroll(this._getScrollValue(true),this.getScrollTime())}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this._oArrowNext._bExcludeFromTabChain=true;this.setAggregation("_nextButton",this._oArrowNext,true)}else if(a.system.phone||a.system.tablet){if(!this._isMobileView()){this._oArrowPrev=new g({id:this.getId()+"-scrl-prev-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft").addStyleClass("sapMHdrCntrBtnIcon");this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new g({id:this.getId()+"-scrl-next-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight").addStyleClass("sapMHdrCntrBtnIcon");this.setAggregation("_nextButton",this._oArrowNext,true)}}this._oScrollCntr.addDelegate({onAfterRendering:function(){if(a.system.desktop){var t=this._oScrollCntr.getDomRef("scroll");var e=this._oScrollCntr.$("scroll");var i=e.find(".sapMHrdrCntrInner").attr("tabindex","0");t.setAttribute("role","list");if(!this._oItemNavigation){this._oItemNavigation=new n;this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(l.Events.BorderReached,this._handleBorderReached,this);this._oItemNavigation.attachEvent(l.Events.AfterFocus,this._handleAfterFocus,this);this._oItemNavigation.attachEvent(l.Events.BeforeFocus,this._handleBeforeFocus,this)}this._oItemNavigation.setRootDomRef(t);this._oItemNavigation.setItemDomRefs(i);this._oItemNavigation.setTabIndex0();this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this._handleMobileScrolling()}if(this._isMobileView()){this._oScrollCntr.attachBrowserEvent("scrollstart",function(t){var e=this._filterVisibleItems();this.aItemSize=[];this.aItemScrollValue=[0];var i=function(t){if(t.getDomRef()&&t.getDomRef().parentElement){return t.getDomRef().parentElement.offsetWidth+parseFloat(getComputedStyle(t.getDomRef().parentElement).marginLeft)+parseFloat(getComputedStyle(t.getDomRef().parentElement).marginRight)}};for(var r=0;r<e.length;r++){this.aItemSize.push(i(e[r]));this.aItemScrollValue.push(this.aItemScrollValue[r]?this.aItemScrollValue[r]+this.aItemSize[r]:this.aItemSize[r])}this.triggerScrollStop=false}.bind(this));this._oScrollCntr.attachBrowserEvent("scrollstop",function(t){if(!this.triggerScrollStop){var e=this._filterVisibleItems();this.triggerScrollStop=true;var i=0,r=15;var o=e[e.length-1];var s=this._oScrollCntr.getDomRef();if(s&&o){var a=o.getParent().getDomRef();var n=o.getDomRef();var l=s.scrollLeft;var h=l+s.clientWidth;var c=a.offsetLeft;var g=c+n.clientWidth;var p=g<=h&&c>=l;var d=this._bRtl?Math.abs(t.currentTarget.scrollLeft):t.currentTarget.scrollLeft;if(p){i=this.aItemScrollValue[e.length-1]-r-d;this.triggerScrollStop=false}else{var f=this.aItemScrollValue.reduce(function(t,e){var i=Math.abs(t-d);var r=Math.abs(e-d);if(i==r){return t>e?t:e}else{return r<i?e:t}});if(d==0){i=0;this.triggerScrollStop=false}else{i=f-r-d}}this._scroll(i,this.getScrollTime())}}}.bind(this))}}.bind(this)});c.addListener(this._checkOverflow,this)};C.prototype.onBeforeRendering=function(){var t=this.getOrientation()===m.Horizontal,e=t?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up",i=t?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down";if(!this.getHeight()){d.warning("No height provided",this)}if(!this.getWidth()){d.warning("No width provided",this)}if(a.system.desktop){this._oArrowPrev.setIcon(e);this._oArrowNext.setIcon(i)}else if(a.system.phone||a.system.tablet){this._oArrowPrev.setSrc(e);this._oArrowNext.setSrc(i)}this.getContent()};C.prototype.onAfterRendering=function(){this._bRtl=v.getRTL();this._checkOverflow()};C.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null}c.removeListener(this._checkOverflow,this)};C.prototype.onsaptabnext=function(t){var e=this.$().find(":focusable");var i=e.index(t.target);var r=e.eq(i+1).get(0);var o=this._getParentCell(t.target);var s;if(r){s=this._getParentCell(r)}if(o&&s&&o.id!==s.id||r&&r.id===this.getId()+"-after"||r&&r.id===this.getId()+"-scrl-prev-button"||r&&r.id===this.getId()+"-scrl-next-button"){var a=e.last().get(0);if(a){this._bIgnoreFocusIn=true;a.focus()}}};C.prototype.onsaptabprevious=function(t){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");var e=this.$().find(":focusable");var i=e.index(t.target);var r=e.eq(i-1).get(0);var o=this._getParentCell(t.target);var s;if(r){s=this._getParentCell(r)}if(!s||o&&o.id!==s.id){var a=this.$().attr("tabindex");this.$().attr("tabindex","0");this.$().trigger("focus");if(!a){this.$().removeAttr("tabindex")}else{this.$().attr("tabindex",a)}}};C.prototype.setOrientation=function(t){this.setProperty("orientation",t);if(t===m.Horizontal&&!a.system.desktop){this._oScrollCntr.setHorizontal(true);this._oScrollCntr.setVertical(false)}else if(!a.system.desktop){this._oScrollCntr.setHorizontal(false);this._oScrollCntr.setVertical(true)}return this};C.prototype.validateAggregation=function(t,e,i){return this._callSuperMethod("validateAggregation",t,e,i)};C.prototype.getAggregation=function(t,e,i){return this._callSuperMethod("getAggregation",t,e,i)};C.prototype.setAggregation=function(t,e,i){return this._callSuperMethod("setAggregation",t,e,i)};C.prototype.indexOfAggregation=function(t,e){return this._callSuperMethod("indexOfAggregation",t,e)};C.prototype.insertAggregation=function(t,e,i,r){return this._callSuperMethod("insertAggregation",t,e,i,r)};C.prototype.addAggregation=function(t,e,i){return this._callSuperMethod("addAggregation",t,e,i)};C.prototype.removeAggregation=function(t,e,i){return this._callSuperMethod("removeAggregation",t,e,i)};C.prototype.removeAllAggregation=function(t,e){return this._callSuperMethod("removeAllAggregation",t,e)};C.prototype.destroyAggregation=function(t,e){return this._callSuperMethod("destroyAggregation",t,e)};C.prototype.onkeydown=function(t){var e=this.getOrientation()===m.Horizontal,i=this.$("prev-button-container"),r=this.$("next-button-container"),o,s=0,a=this._filterVisibleItems();if(t.which===f.ARROW_RIGHT&&e){o=a[t.srcControl.mProperties.position-1].$().parent().outerWidth(true);if(o<this._getSize(i.is(":visible"))){this._scroll(o-s,this.getScrollTime())}}else if(t.which===f.ARROW_LEFT&&e){o=a[t.srcControl.mProperties.position-1].$().parent().outerWidth(true);if(o<this._getSize(r.is(":visible"))){if(!r.is(":visible")){var n=10;if(o+n<this._getSize(true)){s=r.width()+n}else{s=r.width()}}this._scroll(-(o-s),this.getScrollTime())}}if(t.which===f.ARROW_DOWN&&!e){o=a[t.srcControl.mProperties.position-1].$().parent().outerHeight(true);if(o<this._getSize(i.is(":visible"))){this._scroll(o-s,this.getScrollTime())}}else if(t.which===f.ARROW_UP&&!e){o=a[t.srcControl.mProperties.position-1].$().parent().outerHeight(true);if(o<this._getSize(r.is(":visible"))){if(!r.is(":visible")){var n=10;if(o+n<this._getSize(true)){s=r.height()+n}else{s=r.wheightidth()}}this._scroll(-(o-s),this.getScrollTime())}}};C.prototype._setScrollInProcess=function(t){this.bScrollInProcess=t};C.prototype._scroll=function(t,e){this._setScrollInProcess(true);this.fireScroll();setTimeout(this._setScrollInProcess.bind(this,false),e+300);if(this.getOrientation()===m.Horizontal){this._hScroll(t,e)}else{this._vScroll(t,e)}};C.prototype._vScroll=function(t,e){var i=this._oScrollCntr.getDomRef(),r=i.scrollTop,o=i.scrollHeight,s=r+t,a=i.clientHeight,n=parseFloat(this.$("scroll-area").css("padding-top")),l;if(s<=0){l=this._calculateRemainingScrolling(t,e,r);this.$("scroll-area").css("transition","padding "+l+"s");this.$().removeClass("sapMHrdrTopPadding")}else if(s+a+n>=o){l=this._calculateRemainingScrolling(t,e,o-a-r);this.$("scroll-area").css("transition","padding "+l+"s");if(a+t>o&&a!==o){this.$().removeClass("sapMHrdrBottomPadding");this.$().addClass("sapMHrdrTopPadding")}else{this.$().removeClass("sapMHrdrBottomPadding")}}else{this.$("scroll-area").css("transition","padding "+e/1e3+"s")}this._oScrollCntr.scrollTo(0,s,e)};C.prototype._hScroll=function(t,e){var i=this._oScrollCntr.getDomRef();var r,o,s,a,n,l;if(!this._bRtl){o=i.scrollLeft;a=i.scrollWidth;s=i.clientWidth;r=o+t;n=parseFloat(this.$("scroll-area").css("padding-left"));if(r<=0){l=this._calculateRemainingScrolling(t,e,o);this.$("scroll-area").css("transition","padding "+l+"s");this.$().removeClass("sapMHrdrLeftPadding")}else if(r+i.clientWidth+n>=a){l=this._calculateRemainingScrolling(t,e,a-s-o);this.$("scroll-area").css("transition","padding "+l+"s");if(s+t>a&&s!==a){this.$().removeClass("sapMHrdrRightPadding");this.$().addClass("sapMHrdrLeftPadding")}else{this.$().removeClass("sapMHrdrRightPadding")}}else{this.$("scroll-area").css("transition","padding "+e/1e3+"s")}this._oScrollCntr.scrollTo(r,0,e)}else{r=jQuery(i).scrollRightRTL()+t;this._oScrollCntr.scrollTo(r>0?r:0,0,e)}};C.prototype._collectItemSize=function(){var t=0,e=this._filterVisibleItems(),i=this.getOrientation()===m.Horizontal?"outerWidth":"outerHeight";this._aItemEnd=[];e.forEach(function(e,r){t+=e.$().parent()[i](true);this._aItemEnd[r]=t},this)};C.prototype._getScrollValue=function(t){if(!this._oScrollCntr){return 0}var e=this.getOrientation()===m.Horizontal,i=this._oScrollCntr.$(),r=this.$("prev-button-container"),o=this.$("next-button-container"),s=e?i[0].scrollLeft:i[0].scrollTop,a=0,n=0,l,h=this._filterVisibleItems();var c=function(t){var i=0,s=0;var a=10;if(this._bRtl&&e){if(!r.is(":visible")){s=r.width()}if(!o.is(":visible")){s=o.width()}}for(var n=0;n<h.length&&n<t;n++){i+=g(h[n])}return i!==0?i+a-s:0}.bind(this);var g=function(t){return e?t.$().parent().outerWidth(true):t.$().parent().outerHeight(true)};var p=function(){var t=this._getSize(true),e,i=0;for(var r=a;r<h.length;r++){if(!h[r].$().is(":visible")){e=g(h[r])+c(r)-t-s;for(var o=a;o<h.length&&o<r;o++){if(l+i>e){break}a++;i+=g(h[o])}l+=i;break}}}.bind(this);if(this.getScrollStepByItem()>0){s=e&&this._bRtl?i.scrollRightRTL():s;for(var d=0;d<h.length;d++){n+=g(h[d]);if(n>=s){a=d;break}}a=(t?1:-1)*this.getScrollStepByItem()+a;if(a<0){a=0}if(a>=h.length){a=h.length-1}l=c(a)-s;if(t&&!this.getShowOverflowItem()){p()}return l}return t?this.getScrollStep():-this.getScrollStep()};C.prototype._calculateRemainingScrolling=function(t,e,i){return Math.abs(i*e/(1e3*t))};C.prototype._checkOverflow=function(){if(this.getOrientation()===m.Horizontal){this._checkHOverflow()}else{this._checkVOverflow()}};C.prototype._filterVisibleItems=function(){return this.getContent().filter(function(t){return t.getVisible()})};C.prototype._getFirstItemOffset=function(t){var e=this._filterVisibleItems()[0],i=e&&e.$(),r=i&&i.parent(),o=r&&r[0]&&r[0][t];return o||0};C.prototype._checkVOverflow=function(){var t=this._oScrollCntr.getDomRef(),e,i;if(t){var r=this._getFirstItemOffset("offsetTop");var o=Math.ceil(t.scrollTop);var s=false;var a=false;var n=t.scrollHeight;var l=t.offsetHeight;if(Math.abs(n-l)===1){n=l}if(o>r){s=true}if(n>l&&o+l<n){a=true}a=this._checkForOverflowItem(a);i=this.$("prev-button-container");e=i.is(":visible");if(e&&!s){i.hide();this.$().removeClass("sapMHrdrTopPadding")}if(!e&&s){i.show();this.$().addClass("sapMHrdrTopPadding")}i=this.$("next-button-container");var h=i.is(":visible");if(h&&!a){i.hide();this.$().removeClass("sapMHrdrBottomPadding")}if(!h&&a){i.show();this.$().addClass("sapMHrdrBottomPadding")}}};C.prototype._handleMobileScrolling=function(){if(a.browser.mobile){var t=this.$("scrl-cntnr-scroll"),e=this.getOrientation()===m.Horizontal,i=e?"clientX":"clientY",r=0,o=this,s=false;t.on("touchstart",function(t){s=true;r=t.targetTouches[0][i]});t.on("touchmove",function(t){if(s){var a=t.targetTouches[0][i],n=r-a,l=o._oScrollCntr.getDomRef();e?l.scrollLeft+=n:l.scrollTop+=n;r=a;t.preventDefault()}});t.on("touchend",function(){s=false})}};C.prototype._checkHOverflow=function(){var t=this._oScrollCntr.getDomRef(),e;if(t){var i=this._getFirstItemOffset("offsetLeft");var r=Math.ceil(t.scrollLeft);var o=false;var s=false;var a=t.scrollWidth;var n=t.offsetWidth;if(Math.abs(a-n)===1){a=n}if(this._bRtl){var l=jQuery(t).scrollLeftRTL();if(l>0){s=true}}else if(r>i){o=true}if(a-5>n){if(this._bRtl){if(jQuery(t).scrollRightRTL()>1){o=true}}else if(r+n<a){s=true}}e=this.$("prev-button-container");s=this._checkForOverflowItem(s);var h=e.is(":visible");if(h&&!o&&!this._isMobileView()){e.hide();this.$().removeClass("sapMHrdrLeftPadding")}if(!h&&o&&!this._isMobileView()){e.show();this.$().addClass("sapMHrdrLeftPadding")}e=this.$("next-button-container");var c=e.is(":visible");if(c&&!s&&!this._isMobileView()){e.hide();this.$().removeClass("sapMHrdrRightPadding")}if(!c&&s&&!this._isMobileView()){e.show();this.$().addClass("sapMHrdrRightPadding")}}};C.prototype._getSize=function(t){var e=this._oScrollCntr.$(),i=this.getOrientation()===m.Horizontal,r=this.$("next-button-container"),o=!r.is(":visible")&&t,s=i?"width":"height";return e[s]()-(o?r[s]():0)};C.prototype._checkForOverflowItem=function(t){if(this._oScrollCntr&&!this.getShowOverflowItem()){var e=this._oScrollCntr.$(),i=this.getOrientation()===m.Horizontal,r=!i?e[0].scrollTop:this._bRtl?e.scrollRightRTL():e[0].scrollLeft,o=i?"width":"height",s=this._getSize(t),a=this._filterVisibleItems();this._collectItemSize();this._aItemEnd.forEach(function(e,i){var n=a[i].$(),l=n.parent(),h=n.is(":visible");if(t&&e>r+s){if(i===0||this._aItemEnd[i-1]<=r){l.css(o,"auto");n.show()}else if(h){l[o](l[o]());n.hide();t=true}}else{if(!h){l.css(o,"auto");n.show()}}},this)}return t};C.prototype._handleBorderReached=function(t){var e=t.getParameter("index");if(e===0){this._scroll(this._getScrollValue(false),this.getScrollTime())}else if(e===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime())}};C.prototype._handleAfterFocus=function(t){var e=t.getParameter("index");if(e===0){this._scroll(this._getScrollValue(false),this.getScrollTime())}else if(e===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime())}};C.prototype._handleFocusAgain=function(t){t.getParameter("event").preventDefault()};C.prototype._handleBeforeFocus=function(t){var e=t.getParameter("event");if(jQuery(e.target).hasClass("sapMHdrCntrItemCntr")||jQuery(e.target).hasClass("sapMScrollContScroll")||u.events.sapprevious.fnCheck(e)||u.events.sapnext.fnCheck(e)){this.$().find(".sapMHdrCntrItemCntr").css("border-color","")}else{this.$().find(".sapMHdrCntrItemCntr").css("border-color","transparent")}};C.prototype._isMobileView=function(){return this.getGridLayout()&&this.getOrientation()===m.Horizontal&&a.resize.width>=S.xsmall&&a.resize.width<S.tablet};C.prototype._unWrapHeaderContainerItemContainer=function(t){if(t instanceof b){t=t.getItem()}else if(Array.isArray(t)){for(var e=0;e<t.length;e++){if(t[e]instanceof b){t[e]=t[e].getItem()}}}return t};C._AGGREGATION_FUNCTIONS=["validateAggregation","getAggregation","setAggregation","indexOfAggregation","removeAggregation"];C._AGGREGATION_FUNCTIONS_FOR_INSERT=["insertAggregation","addAggregation"];C.prototype._callSuperMethod=function(t,e){var i=Array.prototype.slice.call(arguments);if(e==="content"){var r=i[2];i[1]="content";if(r instanceof o){if(C._AGGREGATION_FUNCTIONS.indexOf(t)>-1&&r.getParent()instanceof b){i[2]=r.getParent()}else if(C._AGGREGATION_FUNCTIONS_FOR_INSERT.indexOf(t)>-1){i[2]=new b({item:r})}}var s=[];this._oScrollCntr.getContent().forEach(function(t,e){if(!t.getItem()){s.push(e)}});for(var a=0;a<s.length;a++){this._oScrollCntr.removeContent(s[a])}var n=this._oScrollCntr[t].apply(this._oScrollCntr,i.slice(1));if(t!=="removeAllAggregation"){var l=this._oScrollCntr.getContent();var h=this.getAriaLabelledBy();var c=1;var g=l.filter(function(t){return t.getItem().getVisible()}).length;for(var a=0;a<l.length;a++){var p=l[a];if(p.getItem().getVisible()){p.setVisible(true);p.setPosition(c);p.setSetSize(g);p.setAriaLabelledBy(h[a]);c++}else{p.setVisible(false)}}}return this._unWrapHeaderContainerItemContainer(n)}else{return o.prototype[t].apply(this,i.slice(1))}};C.prototype._callMethodInManagedObject=function(){throw new TypeError("Method no longer exists: HeaderContainer.prototype._callMethodInManagedObject")};C.prototype._getParentCell=function(t){return jQuery(t).parents(".sapMHrdrCntrInner").andSelf(".sapMHrdrCntrInner").get(0)};C.prototype.onfocusin=function(t){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;return}if(t.target.id===this.getId()+"-after"){this._restoreLastFocused()}};C.prototype._restoreLastFocused=function(){if(!this._oItemNavigation){return}var t=this._oItemNavigation.getItemDomRefs();var e=this._oItemNavigation.getFocusedIndex();var i=jQuery(t[e]);var r=s.closestTo(i[0])||{};var o=r.getTabbables?r.getTabbables():i.find(":sapTabbable");o.eq(-1).add(i).eq(-1).trigger("focus")};return C});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/HeaderContainerItemNavigator", ["sap/ui/core/delegate/ItemNavigation"],function(t){"use strict";var e=t.extend("sap.m.HeaderContainerItemNavigator");e.prototype.focusItem=function(t,e){if(e.type==="mousedown"){var o=this.aItemDomRefs[t].focus;this.aItemDomRefs[t].focus=function(){};this._callParent("focusItem",arguments);this.aItemDomRefs[t].focus=o;return}this._callParent("focusItem",arguments)};e.prototype._callParent=function(e,o){if(typeof t.prototype[e]==="function"){t.prototype[e].apply(this,o)}};e.prototype.onsaphome=function(t){if(this._skipNavigation(t)){return}this._callParent("onsaphome",arguments)};e.prototype.onsapend=function(t){if(this._skipNavigation(t)){return}this._callParent("onsapend",arguments)};e.prototype.onsapnext=function(t){if(this._skipNavigation(t)){return}this._callParent("onsapnext",arguments)};e.prototype.onsapprevious=function(t){if(this._skipNavigation(t,true,false)){return}this._callParent("onsapprevious",arguments)};e.prototype._skipNavigation=function(t){return Array.prototype.indexOf.call(this.aItemDomRefs,t.target)===-1};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/HeaderContainerRenderer", ["sap/ui/core/library"],function(t){"use strict";var e=t.Orientation;var r={apiVersion:2};r.render=function(t,r){var n=r.getTooltip_AsString();var i=r.getOrientation();var a="sapMHdrCntrBG"+r.getBackgroundDesign();t.openStart("div",r);if(n){t.attr("title",n)}t.class("sapMHdrCntr");t.class(i);if(r.getShowDividers()){t.class("sapMHrdrCntrDvdrs")}if(r.getHeight()){t.style("height",r.getHeight())}else{t.style("height",r.getOrientation()===e.Horizontal?"auto":"100%")}if(r.getWidth()){t.style("width",r.getWidth())}else{t.style("width",r.getOrientation()===e.Horizontal?"100%":"auto")}t.openEnd();t.openStart("div",r.getId()+"-scroll-area");t.class("sapMHdrCntrCntr");t.class(i);t.class(a);t.openEnd();t.renderControl(r.getAggregation("_scrollContainer"));t.close("div");var s=r.getAggregation("_prevButton");if(s){t.openStart("div",r.getId()+"-prev-button-container");t.class("sapMHdrCntrBtnCntr");t.class("sapMHdrCntrLeft");t.class(i);t.openEnd();t.renderControl(s);t.close("div")}s=r.getAggregation("_nextButton");if(s){t.openStart("div",r.getId()+"-next-button-container");t.class("sapMHdrCntrBtnCntr");t.class("sapMHdrCntrRight");t.class(i);t.openEnd();t.renderControl(s);t.close("div")}t.openStart("div",r.getId()+"-after");t.attr("tabindex","0");t.openEnd().close("div");t.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/HyphenationSupport", ["sap/base/config","./library","sap/ui/core/hyphenation/Hyphenation","sap/base/Log"],function(e,n,t,i){"use strict";var a=n.WrappingType;function r(){return e.get({name:"sapUiXxHyphenation",type:e.Type.String,external:true})}function o(e){if(!e.isA("sap.m.IHyphenation")){i.error("[UI5 Hyphenation] The given control does not implement interface sap.m.IHyphenation and can not use HyphenationSupport mixin.");return false}return true}function s(e,n){var t=e.getTextsToBeHyphenated();if(typeof t!=="object"){i.error("[UI5 Hyphenation] The result of getTextsToBeHyphenated method is not a map object.",e.getId());return false}if(Object.keys(t).indexOf(n)<0){i.error("[UI5 Hyphenation] The key "+n+" is not found in the result of getTextsToBeHyphenated method.",e.getId());return false}return true}function p(e,n){n=n||"";var t=e.childNodes;if(t.length===1&&t[0].nodeType===window.Node.TEXT_NODE){t[0].nodeValue=n}else{e.textContent=n}}function h(e,n){var t=[];Object.keys(e).forEach(function(i){if(!(i in n&&e[i]===n[i])){t.push(i)}});return t}function u(){var e=r(),n=t.getInstance();if(e==="native"||e==="disable"){return false}if(e==="thirdparty"){return true}return n.isLanguageSupported()&&!n.canUseNativeHyphenation()&&n.canUseThirdPartyHyphenation()}function f(e){var n=r();if(n==="disable"){return false}return(!e.getWrapping||e.getWrapping())&&e.getWrappingType()===a.Hyphenated}function y(e){if(!f(e)||!u()){e._mHyphenatedTexts={};e._mUnhyphenatedTexts={};return}var n=e.getTextsToBeHyphenated(),i=h(n,e._mUnhyphenatedTexts);if(i.length>0){e._mUnhyphenatedTexts=n;i.forEach(function(n){delete e._mHyphenatedTexts[n]});var a=t.getInstance();if(!a.isLanguageInitialized()){a.initialize().then(function(){var t=e.isActive()?e.getDomRefsForHyphenatedTexts():null,r=false;i.forEach(function(i){e._mHyphenatedTexts[i]=a.hyphenate(n[i]);if(t&&i in t){p(t[i],e._mHyphenatedTexts[i])}else{r=true}});if(r){e.invalidate()}})}else{i.forEach(function(t){e._mHyphenatedTexts[t]=a.hyphenate(n[t])})}}}var d={};d.mixInto=function(e){if(!o(e)){return}var n=e.init;e.init=function(e){var t=n.apply(this,arguments);this._mHyphenatedTexts={};this._mUnhyphenatedTexts={};return t};var t=e.onBeforeRendering;e.onBeforeRendering=function(){var e=t.apply(this,arguments);y(this);return e}};d.writeHyphenationClass=function(e,n){if(!o(n)){return}if(f(n)&&!u()){e.class("sapUiHyphenation")}};d.getTextForRender=function(e,n){if(!o(e)){return null}if(!s(e,n)){return null}var t=e.getTextsToBeHyphenated();if(f(e)&&u()){if(t[n]!==e._mUnhyphenatedTexts[n]){y(e)}if(n in e._mHyphenatedTexts){return e._mHyphenatedTexts[n]}}return t[n]};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabBar", ["./library","sap/ui/core/Core","sap/ui/core/Control","./IconTabBarRenderer","./IconTabHeader","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/thirdparty/jquery"],function(e,t,n,r,a,o,jQuery){"use strict";var i=e.IconTabHeaderMode;var s=e.BackgroundDesign;var d=e.IconTabDensityMode;var p=e.TabsOverflowMode;var l=n.extend("sap.m.IconTabBar",{metadata:{interfaces:["sap.m.ObjectHeaderContainer","sap.f.IDynamicPageStickyContent"],library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},stretchContentHeight:{type:"boolean",group:"Appearance",defaultValue:false},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:s.Solid},headerMode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:i.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},headerBackgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:s.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:d.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null},tabsOverflowMode:{type:"sap.m.TabsOverflowMode",group:"Behavior",defaultValue:p.End}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",forwarding:{getter:"_getIconTabHeader",aggregation:"items",forwardBinding:true}},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_header:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},previousKey:{type:"string"},selectedItem:{type:"sap.m.IconTabFilter"},selectedKey:{type:"string"}}},expand:{parameters:{expand:{type:"boolean"},collapse:{type:"boolean"}}}},designtime:"sap/m/designtime/IconTabBar.designtime"},renderer:r});o.call(l.prototype,{header:{selector:".sapMITH"},content:{suffix:"content"}});l._CLASSES_TO_COPY=["sapUiResponsiveContentPadding","sapUiNoContentPadding","sapUiContentPadding"];l.prototype.init=function(){this._initResponsivePaddingsEnablement()};l.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);if(this.$().length){this._toggleExpandCollapse(this.getProperty("expanded"))}return this};l.prototype.setHeaderMode=function(e){var t=this._getIconTabHeader();this.setProperty("headerMode",e,true);if(t){t.setMode(e)}return this};l.prototype.setTabDensityMode=function(e){var t=this._getIconTabHeader();this.setProperty("tabDensityMode",e);if(t){t.setTabDensityMode(e)}return this};l.prototype.setHeaderBackgroundDesign=function(e){var t=this._getIconTabHeader();this.setProperty("headerBackgroundDesign",e,true);if(t){t.setBackgroundDesign(e)}return this};l.prototype.setEnableTabReordering=function(e){var t=this._getIconTabHeader();this.setProperty("enableTabReordering",e,true);if(t){t.setEnableTabReordering(e)}return this};l.prototype.setAriaTexts=function(e){var t=this._getIconTabHeader();this.setProperty("ariaTexts",e,true);if(t){t.setAriaTexts(e)}return this};l.prototype.addStyleClass=function(e,t){var r=this._getIconTabHeader();if(r){e.split(/\s+/).forEach(e=>{if(l._CLASSES_TO_COPY.includes(e)){r.addStyleClass(e,true)}})}return n.prototype.addStyleClass.apply(this,arguments)};l.prototype.removeStyleClass=function(e,t){var r=this._getIconTabHeader();if(r){e.split(/\s+/).forEach(e=>{if(l._CLASSES_TO_COPY.includes(e)){r.removeStyleClass(e,true)}})}return n.prototype.removeStyleClass.apply(this,arguments)};l.prototype._rerenderContent=function(e){var n=this.$("content");if(e&&n.length>0){var r=t.createRenderManager();for(var a=0;a<e.length;a++){r.renderControl(e[a])}r.flush(n[0]);r.destroy()}};l.prototype._toggleExpandCollapse=function(e){var t=this.$("content");var n=this._getIconTabHeader().oSelectedItem;if(e===undefined){e=!this.getExpanded()}if(n){n.$().toggleClass("sapMITBSelected",e);n.$().attr({"aria-expanded":e});if(e){n.$().attr({"aria-selected":e})}else{n.$().removeAttr("aria-selected")}}this._iAnimationCounter=this._iAnimationCounter===undefined?1:++this._iAnimationCounter;if(e){if(n){if(this.$("content").children().length===0){var r=n.getContent();if(r.length>0){this._rerenderContent(r)}else{this._rerenderContent(this.getContent())}}t.stop(true,true).slideDown("400",jQuery.proxy(this.onTransitionEnded,this,e));this.$("containerContent").toggleClass("sapMITBContentClosed",!e)}}else{this.$("contentArrow").hide();t.stop(true,true).slideUp("400",jQuery.proxy(this.onTransitionEnded,this,e))}if(!e||n){this.setProperty("expanded",e,true)}this.fireExpand({expand:e,collapse:!e});return this};l.prototype.onTransitionEnded=function(e){var t=this.$("content"),n=this.$("containerContent"),r=this.$("contentArrow");if(this._iAnimationCounter===1){n.toggleClass("sapMITBContentClosed",!e);if(e){r.show();t.css("display","block")}else{r.hide();t.css("display","none")}}this._iAnimationCounter=this._iAnimationCounter>0?--this._iAnimationCounter:0;return this};l.prototype._getIconTabHeader=function(){if(this.isDestroyStarted()){return null}var e=this.getAggregation("_header");if(!e){e=new a(this.getId()+"--header",{});this.setAggregation("_header",e,true)}return e};l.prototype._getStickyContent=function(){return this._getIconTabHeader()};l.prototype._returnStickyContent=function(){if(this.bIsDestroyed){return}this._getStickyContent().$().prependTo(this.$())};l.prototype._setStickySubheaderSticked=function(e){this._bStickyContentSticked=e};l.prototype._getStickySubheaderSticked=function(){return this._bStickyContentSticked};l.prototype.onBeforeRendering=function(){var e=this._getIconTabHeader(),t=e.$();e.setMaxNestingLevel(this.getMaxNestingLevel());e.setTabsOverflowMode(this.getTabsOverflowMode());if(this._bStickyContentSticked&&t){delete this._bStickyContentSticked;this._getIconTabHeader().$().remove()}};l.prototype.setShowSelection=function(e){var t=this._getIconTabHeader();if(t){t.setShowSelection(e)}this.setProperty("showSelection",e,true);return this};l.prototype.setSelectedKey=function(e){var t=this._getIconTabHeader();if(t){t.setSelectedKey(e)}return this};l.prototype.getSelectedKey=function(){var e=this._getIconTabHeader();if(e){return e.getSelectedKey()}return this.getMetadata().getProperty("selectedKey").getDefaultValue()};l.prototype.setSelectedItem=function(e,t){return this._getIconTabHeader().setSelectedItem(e,t)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabBarDragAndDropUtil", ["sap/ui/core/dnd/DragInfo","sap/ui/core/dnd/DropInfo","sap/ui/events/KeyCodes","sap/ui/core/library","sap/ui/core/Configuration"],function(e,t,r,i,a){"use strict";var n=i.dnd.DropPosition;var s="Before",o="insertBefore",g="insertAfter",f,l="IconTabReorder",c="Forward",u="Backward";var d={_insertControl:function(e,t,r,i){var a=t.$(),n=r.$(),s=[],o=[];if(t._getNestedLevel()>1&&r._getNestedLevel()>1){s=t._getRootTab()._getSelectList().getItems().filter(function(e){return t._getRealTab()._isParentOf(e._getRealTab())});o=r._getRootTab()._getSelectList().getItems().filter(function(e){return r._getRealTab()._isParentOf(e._getRealTab())})}if(i){var f=t._getRootTab().getParent()._getOverflow()._getSelectList().getItems();s=f.filter(function(e){return t._getRealTab()._isParentOf(e._getRealTab())});o=f.filter(function(e){return r._getRealTab()._isParentOf(e._getRealTab())})}if(e===g){a.insertAfter(n)}else{a.insertBefore(n)}s.reverse().forEach(function(e){e.$().insertAfter(a)});o.reverse().forEach(function(e){e.$().insertAfter(n)})},handleDrop:function(e,t,r,i,l,c){var u=e.indexOfItem(r),_=e.indexOfItem(i),b=0,p=a.getRTL(),h=t===s,I=i._getNestedLevel()-1;if(r._isParentOf(i)){return}if(I===c&&t===n.On){return}if(p&&!l){if(h){b=u<_?_:_+1;f=g}else{b=u<_?_-1:_;f=o}}else{if(h){b=u<_?_-1:_;f=o}else{b=u<_?_:_+1;f=g}}if(e.isA("sap.m.IconTabFilter")||!r.getParent().isA("sap.m.IconTabHeader")){if(h){b=_}else{b=_+1}}d._insertControl(f,r,i);if(t===n.On){if(i===r){return}b=e.getAggregation("items").length}d._handleConfigurationAfterDragAndDrop.call(e,r,b)},_updateAccessibilityInfo:function(){var e=this.getItems(),t=1,r;e.forEach(function(e){r=e.getDomRef();if(r&&r.getAttribute("aria-posinset")!==null){r.setAttribute("aria-posinset",t++)}})},_handleConfigurationAfterDragAndDrop:function(e,t){var r=[],i=this.isA("sap.m.IconTabHeader")?this:this._getIconTabHeader();if(this.isA("sap.m.IconTabBarSelectList")){r=this.getItems().filter(function(t){return e._getRealTab()._isParentOf(t._getRealTab())})}i._setPreserveSelection(true);this.removeAggregation("items",e,true);this.insertAggregation("items",e,t,true);r.forEach(function(e){this.removeAggregation("items",e,true)}.bind(this));var a=1+this.indexOfAggregation("items",e);r.reverse().forEach(function(e){this.insertAggregation("items",e,a,true)}.bind(this));i._setPreserveSelection(false);d._updateAccessibilityInfo.call(this)},_decreaseDropIndex:function(e,t){var r=e-1;while(r>=0&&(t[e]._getRealTab()._getNestedLevel()!==t[r]._getRealTab()._getNestedLevel()||!t[r].getVisible()||!t[e].$().hasClass("sapMITBFilterHidden")&&t[r].$().hasClass("sapMITBFilterHidden"))){r--}if(r<0){f=g;return e}f=o;return r},_increaseDropIndex:function(e,t,r){var i=e+1;while(i<t.length&&(t[e]._getRealTab()._getNestedLevel()!==t[i]._getRealTab()._getNestedLevel()||!t[i].getVisible())){i++}if(i>r){f=o;return e}f=g;return i},moveItem:function(e,t,i){var n=this.getItems(),s=this.indexOfItem(e),l=a.getRTL(),_,b;if(this.isA("sap.m.IconTabFilter")){n=this._getRealTab().getItems()}switch(t){case r.HOME:_=0;f=o;break;case r.END:_=n.length-1;f=g;break;case r.ARROW_LEFT:if(l){b=d.preventDragBetweenSubItems(e,c,this);_=d._increaseDropIndex(s,n,i)}else{b=d.preventDragBetweenSubItems(e,u,this);_=d._decreaseDropIndex(s,n)}break;case r.ARROW_RIGHT:if(l){b=d.preventDragBetweenSubItems(e,u,this);_=d._decreaseDropIndex(s,n)}else{b=d.preventDragBetweenSubItems(e,c,this);_=d._increaseDropIndex(s,n,i)}break;case r.ARROW_DOWN:b=d.preventDragBetweenSubItems(e,c,this);_=d._increaseDropIndex(s,n,i);break;case r.ARROW_UP:b=d.preventDragBetweenSubItems(e,u,this);_=d._decreaseDropIndex(s,n);break;default:return false}if(b){return false}if(!this.isA("sap.m.IconTabFilter")){var p=n[_];d._insertControl(f,e,p,this._oTabFilter&&this._oTabFilter._bIsOverflow)}d._handleConfigurationAfterDragAndDrop.call(this,e,_);return true},setDragDropAggregations:function(r,i,a){var n=r._oIconTabHeader?r._oIconTabHeader:r;var s=n.getId();r.addDragDropConfig(new e({sourceAggregation:"items",groupName:l+s}));r.addDragDropConfig(new t({targetAggregation:"items",dropPosition:a,dropLayout:i,drop:r._handleDragAndDrop.bind(r),groupName:l+s}))},preventDragBetweenSubItems:function(e,t,r){var i=false;if(r.isA("sap.m.IconTabBarSelectList")){var a=e._getRealTab(),n=a.getParent(),s=n.getItems();if(s.indexOf(a)===0&&t===u||s.indexOf(a)+1===s.length&&t===c||s.length===1){i=true}}return i}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabBarRenderer", [],function(){"use strict";var e={apiVersion:2};e._aAllIconColors=["sapMITBFilterCritical","sapMITBFilterPositive","sapMITBFilterNegative","sapMITBFilterDefault"];e.render=function(e,t){var n=t.getContent(),a=t._getIconTabHeader();e.openStart("div",t).class("sapMITB");if(t.getStretchContentHeight()){e.class("sapMITBStretch")}if(!t.getApplyContentPadding()){e.class("sapMITBNoContentPadding")}e.class("sapMITBBackgroundDesign"+t.getBackgroundDesign()).openEnd();if(!t._bHideHeader){e.renderControl(a)}e.openStart("div",t.getId()+"-containerContent").class("sapMITBContainerContent");if(!t.getExpanded()){e.class("sapMITBContentClosed")}e.openEnd();e.openStart("div",t.getId()+"-content").class("sapMITBContent").attr("role","tabpanel");if(!t.getExpanded()){e.style("display","none")}if(a.oSelectedItem){e.accessibilityState({labelledby:a.oSelectedItem._getRootTab().getId()})}e.openEnd();if(t.getExpanded()){if(a.oSelectedItem&&a.oSelectedItem.getContent()){var o=a.oSelectedItem.getContent();if(o.length>0){n=o}}n.forEach(function(t){e.renderControl(t)})}e.close("div").close("div").close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabBarSelectList", ["./library","./IconTabBarDragAndDropUtil","./IconTabBarSelectListRenderer","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/theming/Parameters","sap/ui/core/library","sap/ui/events/KeyCodes"],function(e,t,i,o,n,a,r,s){"use strict";var g=r.dnd.DropPosition;var l=o.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:true}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}},renderer:i});l.prototype.init=function(){this._oItemNavigation=new n;this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);this._oItemNavigation.setPageSize(10);this._oIconTabHeader=null;this._oTabFilter=null};l.prototype.exit=function(){this._oItemNavigation.destroy();this._oItemNavigation=null;this._oIconTabHeader=null;this._oTabFilter=null};l.prototype.onBeforeRendering=function(){if(!this._oIconTabHeader){return}this.destroyDragDropConfig();this._setsDragAndConfiguration()};l.prototype.onAfterRendering=function(){this._initItemNavigation();this.getItems().forEach(function(e){if(e._onAfterParentRendering){e._onAfterParentRendering()}})};l.prototype._setsDragAndConfiguration=function(){if(this._oIconTabHeader.getEnableTabReordering()&&!this.getDragDropConfig().length){t.setDragDropAggregations(this,"Vertical",this._oIconTabHeader._getDropPosition())}};l.prototype._initItemNavigation=function(){var e=this.getItems(),t=[],i=this._oIconTabHeader.oSelectedItem,o=-1,n,a;for(a=0;a<e.length;a++){n=e[a];if(n.isA("sap.m.IconTabFilter")){var r=n._getAllSubFiltersDomRefs();t=t.concat(n.getDomRef(),r)}if(i&&this.getSelectedItem()&&this.getSelectedItem()._getRealTab()===i){o=a}}if(i&&t.indexOf(i.getDomRef())!==-1){o=t.indexOf(i.getDomRef())}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(t).setSelectedIndex(o)};l.prototype.getVisibleItems=function(){return this.getItems().filter(function(e){return e.getVisible()})};l.prototype.getVisibleTabFilters=function(){return this.getVisibleItems().filter(function(e){return e.isA("sap.m.IconTabFilter")})};l.prototype.setSelectedItem=function(e){this._selectedItem=e};l.prototype.getSelectedItem=function(){return this._selectedItem};l.prototype._getIconTabHeader=function(){return this._oIconTabHeader};l.prototype._getParams=function(){var e=Object.assign({_sap_m_IconTabBar_SelectListItem_PaddingLeft:"0.5rem",_sap_m_IconTabBar_SelectListItem_PaddingLeftAdditional:"0"},a.get({name:["_sap_m_IconTabBar_SelectListItem_PaddingLeft","_sap_m_IconTabBar_SelectListItem_PaddingLeftAdditional"],callback:this.invalidate.bind(this)}));return{fNestedItemPaddingLeft:Number.parseFloat(e["_sap_m_IconTabBar_SelectListItem_PaddingLeft"]),fAdditionalPadding:Number.parseFloat(e["_sap_m_IconTabBar_SelectListItem_PaddingLeftAdditional"])}};l.prototype._checkTextOnly=function(){return this.getItems().every(function(e){return e.isA("sap.m.IconTabSeparator")||!e.getIcon()})};l.prototype.onkeydown=function(e){switch(e.which){case s.ENTER:this._selectItem(e);e.preventDefault();break;case s.SPACE:e.preventDefault();break}};l.prototype.onkeyup=function(e){if(e.which===s.SPACE){this._selectItem(e)}};l.prototype.ontap=function(e){this._selectItem(e)};l.prototype._selectItem=function(e){var t=e.srcControl;if(!t){return}if(!t.isA("sap.m.IconTabFilter")){return}if(this._oIconTabHeader._isUnselectable(t)){return}e.preventDefault();if(t!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:t})}};l.prototype.checkIconOnly=function(){this._bIconOnly=this.getVisibleTabFilters().every(function(e){return!e.getText()&&!e.getCount()});return this._bIconOnly};l.prototype._handleDragAndDrop=function(e){var i=e.getParameter("dropPosition"),o=e.getParameter("draggedControl"),n=e.getParameter("droppedControl"),a=n._getRealTab().getParent(),r=this._oIconTabHeader.getMaxNestingLevel();if(this._oTabFilter._isOverflow()){a=this._oIconTabHeader}if(i===g.On){a=n._getRealTab()}t.handleDrop(a,i,o._getRealTab(),n._getRealTab(),true,r);this._oIconTabHeader._setItemsForStrip();this._oIconTabHeader._initItemNavigation();this._oTabFilter._setSelectListItems();this._initItemNavigation();n._getRealTab().getParent().$().trigger("focus")};l.prototype.ondragrearranging=function(e){if(!this._oIconTabHeader.getEnableTabReordering()){return}var i=e.srcControl,o=e.keyCode,n=this.indexOfItem(i),a=this;t.moveItem.call(a,i,o,a.getItems().length-1);this._initItemNavigation();i.$().trigger("focus");if(n===this.indexOfItem(i)){return}a=i._getRealTab().getParent();if(this._oTabFilter._isOverflow()&&i._getRealTab()._getNestedLevel()===1){this._oIconTabHeader._moveTab(i._getRealTab(),o,this._oIconTabHeader.getItems().length-1)}else{t.moveItem.call(a,i._getRealTab(),o,a.getItems().length-1)}};l.prototype.onsaphomemodifiers=l.prototype.ondragrearranging;l.prototype.onsapendmodifiers=l.prototype.ondragrearranging;l.prototype.onsapincreasemodifiers=l.prototype.ondragrearranging;l.prototype.onsapdecreasemodifiers=l.prototype.ondragrearranging;return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabBarSelectListRenderer", ["sap/ui/core/library"],function(e){"use strict";var t=e.IconColor;var i={apiVersion:2};i.render=function(e,i){var r=i._getParams(),n=i.getVisibleItems(),a=i._oIconTabHeader,s=i._checkTextOnly(),l=a.getVisibleTabFilters().length,o=r.fNestedItemPaddingLeft,c=false;var f=n.filter(function(e){return e.isA("sap.m.IconTabFilter")}).some(function(e){return e.getIconColor()!==t.Default});i.checkIconOnly();var u=r.fAdditionalPadding;if(f&&u){o+=u;c=true}this.renderList(e,n,i,a,s,o,c,l)};i.renderList=function(e,t,i,r,n,a,s,l){if(!t.length){return}e.openStart("ul",i).attr("role","menu").class("sapMITBSelectList");if(n){e.class("sapMITBSelectListTextOnly")}e.openEnd();for(var o=0;o<t.length;o++){var c=t[o],f;if(r&&c.isA("sap.m.IconTabFilter")){f=r.getVisibleTabFilters().indexOf(c._getRealTab())}if(c.isA("sap.m.IconTabFilter")&&c._getRootTab()._getSelectList()===i){f=o;l=t.length}var u=c._getNestedLevel()-2;if(s){u++}if(i._bIsOverflow){u++}c.renderInSelectList(e,i,f,l,a*u)}e.close("ul")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabFilter", ["./library","./AccButton","./IconTabFilterExpandButtonBadge","sap/ui/core/library","sap/ui/core/Core","sap/ui/core/Item","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/core/InvisibleMessage","sap/ui/Device","sap/m/BadgeCustomData","sap/m/Button","sap/m/ResponsivePopover","sap/m/IconTabBarSelectList","sap/m/BadgeEnabler","sap/m/ImageHelper"],function(e,t,o,i,s,a,n,r,l,p,g,d,h,c,u,f){"use strict";var _=i.TextAlign;var I=i.TextDirection;var v=e.ButtonType;var T=e.PlacementType;var b=e.IconTabFilterDesign;var B=e.BadgeStyle;var m=e.BadgeState;var y=i.IconColor;var C=i.aria.HasPopup;var S=3e3;var D=i.InvisibleMessageMode;var x=-8;var O=a.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface","sap.m.IBadge"],library:"sap.m",designtime:"sap/m/designtime/IconTabFilter.designtime",properties:{count:{type:"string",group:"Data",defaultValue:""},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:y.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:b.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},items:{type:"sap.m.IconTab",multiple:true,singularName:"item"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButtonBadge:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});u.call(O.prototype);var E=s.getLibraryResourceBundle("sap.m");O._aAllIconColors=["sapMITBFilterCritical","sapMITBFilterPositive","sapMITBFilterNegative","sapMITBFilterDefault","sapMITBFilterNeutral"];O.prototype._getImageControl=function(e,t,o){var i={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(i.src){this._oImageControl=f.getImageControl(this.getId()+"-icon",this._oImageControl,t,i,e,o)}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null}return this._oImageControl};O.prototype.init=function(){this._oDragEventDelegate={onlongdragover:this._handleOnLongDragOver,ondragover:this._handleOnDragOver,ondragleave:this._handleOnDragLeave,ondrop:this._handleOnDrop};this.initBadgeEnablement({style:B.Attention,selector:{selector:".sapMITBBadgeHolder"}});this._oCloneInList=null;this.setAggregation("_expandButtonBadge",new o)};O.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy()}if(a.prototype.exit){a.prototype.exit.call(this,e)}if(this._oPopover){this._oPopover.destroy();this._oPopover=null}if(this._oExpandButton){this._oExpandButton.removeEventDelegate(this._oDragEventDelegate);this._oExpandButton.destroy();this._oExpandButton=null}this.removeEventDelegate(this._oDragEventDelegate);this._oDragEventDelegate=null;if(this._iHideBadgeTimeout){clearTimeout(this._iHideBadgeTimeout)}};O.prototype.invalidate=function(){var e=this.getParent(),t,o;if(!e){return}t=e.getParent();if(!(t&&t.isA("sap.m.IconTabBar"))){e.invalidate();return}o=t.getParent();if(o&&o.isA("sap.m.ObjectHeader")){o.invalidate()}else{t.invalidate()}};O.prototype.setProperty=function(e,t,o){switch(e){case"textDirection":case"text":case"count":case"showAll":case"icon":case"iconColor":case"iconDensityAware":case"design":if(this.getProperty(e)===t){return this}a.prototype.setProperty.call(this,e,t,true);if(!o){var i=this.getParent();if(i&&i.isA("sap.m.IconTabHeader")){i.invalidate()}}break;default:a.prototype.setProperty.apply(this,arguments);break}return this};O.prototype._getNonEmptyKey=function(){var e=this.getKey();if(e){return e}return this.getId()};O.prototype._getRealTab=function(){return this._oRealItem||this};O.prototype._getRootTab=function(){var e=this._getRealTab(),t=e.getParent();while(t&&t.isA("sap.m.IconTabFilter")){e=t;t=t.getParent()}return e};O.prototype._getNestedLevel=function(){var e=this._getRealTab().getParent(),t;for(t=1;e&&e.isA("sap.m.IconTabFilter");t++){e=e.getParent()}return t};O.prototype.render=function(e,t,o){if(!this.getVisible()){return}var i=this.getParent(),s=i.getParent();if(i.getEnableTabReordering()){this._prepareDragEventDelegate()}var a=i._isInsideIconTabBar(),n={role:"tab"},l=this.getId(),p=this.getCount(),g=this.getText(),d=this.getIcon(),h=this.getIconColor(),c=this.getEnabled(),u=this._shouldReadIconColor(),f=this.getDesign()===b.Horizontal,_=i._bTextOnly,v=i._bInLine||i.isInlineMode(),T=this.getShowAll(),B=this.getTextDirection(),m=i._isUnselectable(this);if(this._isOverflow()){n.role="button"}if(a){n.controls=s.getId()+"-content"}if(this.getItems().length){n.roledescription=E.getText("ICONTABFILTER_SPLIT_TAB")}if(g.length||p!==""||d){var y=[];if(p!==""&&!v){y.push(l+"-count")}if(g.length){y.push(l+"-text")}if(d){y.push(l+"-icon")}if(u){y.push(l+"-iconColor")}n.labelledby=y.join(" ")}if(t!==undefined&&o!==undefined){Object.assign(n,{posinset:t+1,setsize:o})}e.openStart("div",this).accessibilityState(n).class("sapMITBItem");if(!p){e.class("sapMITBItemNoCount")}if(f){e.class("sapMITBHorizontal")}else{e.class("sapMITBVertical")}if(T){e.class("sapMITBAll")}else{e.class("sapMITBFilter")}if(!T&&c){e.class("sapMITBFilter"+h)}if(m){e.class("sapMITHUnselectable")}if(this.getItems().length>0){e.class("sapMITBFilterWithItems")}if(!c){e.class("sapMITBDisabled").attr("aria-disabled",true)}e.attr("tabindex","-1");if(!this._isOverflow()){e.attr("aria-selected",false)}var C=this.getTooltip_AsString();if(C){e.attr("title",C)}if(this._isOverflow()||m){e.attr("aria-haspopup","menu")}e.openEnd();if(u){this._renderIconColorDescription(e)}e.openStart("div").class("sapMITBFilterWrapper").openEnd();if(!v){e.openStart("div",l+"-tab").class("sapMITBTab").openEnd();if(!T||!d){var S=["sapMITBFilterIcon","sapMITBBadgeHolder"];if(c){S.push("sapMITBFilter"+h)}e.renderControl(this._getImageControl(S,i,O._aAllIconColors))}if(!T&&!d&&!_){e.openStart("span").class("sapMITBFilterNoIcon").openEnd().close("span")}if(f&&!T){e.close("div");e.openStart("div").class("sapMITBHorizontalWrapper").openEnd()}e.openStart("span",l+"-count").class("sapMITBCount");if(T||!d&&!g.length){e.class("sapMITBBadgeHolder")}e.openEnd();if(p===""&&f){e.unsafeHtml("&nbsp;")}else{e.text(p)}e.close("span");if(!f){e.close("div")}}if(g.length){e.openStart("div",l+"-text").class("sapMITBText");if(!d&&!T){e.class("sapMITBBadgeHolder")}if(a&&s.getUpperCase()){e.class("sapMITBTextUpperCase")}e.openEnd();if(v&&d){this._renderIcon(e)}e.openStart("span").class("sapMITHTextContent").attr("dir",B!==I.Inherit?B.toLowerCase():"auto");e.openEnd().text(i._getDisplayText(this)).close("span");if(this._isOverflow()||this.getItems().length&&m){e.openStart("span",this.getId()+"-expandButton").class("sapMITHShowSubItemsIcon").openEnd();e.icon(r.getIconURI("slim-arrow-down"),null,{title:null,"aria-hidden":true});e.close("span")}e.close("div")}if(!v&&f){e.close("div")}e.openStart("div").class("sapMITBContentArrow").openEnd().close("div");e.close("div");if(this.getItems().length&&!m){e.openStart("span").class("sapMITBFilterExpandBtnSeparator").accessibilityState({role:"separator"}).openEnd().close("span");e.renderControl(this._getExpandButton())}e.renderControl(this.getAggregation("_expandButtonBadge"));if(this.getItems().length){this._updateExpandButtonBadge()}e.close("div")};O.prototype.renderInSelectList=function(e,t,o,i,s){if(!this.getVisible()){return}var a=t._bIconOnly,n=true,r=t._oIconTabHeader,l=this.getIconColor(),p=this.getEnabled();if(r){n=t._checkTextOnly()}e.openStart("li",this).class("sapMITBSelectItem").attr("tabindex","-1").attr("role","menuitem");if(s){e.style("padding-left",s+"rem")}if(o!==undefined&&i!==undefined){e.attr("aria-posinset",o+1);e.attr("aria-setsize",i)}var g=this.getTooltip_AsString();if(g){e.attr("title",g)}if(r._isUnselectable(this)){e.class("sapMITHUnselectable")}if(!p){e.class("sapMITBDisabled").attr("aria-disabled",true)}if(t.getSelectedItem()==this){e.class("sapMITBSelectItemSelected");e.attr("aria-selected",true)}if(p){e.class("sapMITBFilter"+l)}var d=this.getId(),h=this._shouldReadIconColor(),c=[];if(!a){c.push(d+"-text")}if(!n&&this.getIcon()){c.push(d+"-icon")}if(h){c.push(d+"-iconColor")}e.accessibilityState({labelledby:c.join(" ")}).openEnd();if(h){this._renderIconColorDescription(e)}if(!n){this._renderIcon(e,a)}if(!a){this._renderText(e)}e.close("li")};O.prototype._onAfterParentRendering=function(){this._renderBadge();l.getInstance()};O.prototype._renderIcon=function(e,t){var o=this.getIcon();if(o){var i=r.getIconInfo(o),s=["sapMITBSelectItemIcon"];if(i&&!i.suppressMirroring){s.push("sapUiIconMirrorInRTL")}if(t){s.push("sapMITBBadgeHolder")}if(this._getIconTabHeader().isInlineMode()){s.push("sapMITBInlineIcon")}e.icon(o,s,{id:this.getId()+"-icon","aria-hidden":true})}else{e.openStart("span").class("sapUiIcon").openEnd().close("span")}};O.prototype._renderIconColorDescription=function(e){e.openStart("div",this.getId()+"-iconColor").style("display","none").openEnd().text(E.getText("ICONTABBAR_ICONCOLOR_"+this.getIconColor().toUpperCase())).close("div")};O.prototype._renderText=function(e){var t=this.getText(),o=this.getCount(),i=s.getConfiguration().getRTL(),a=this.getTextDirection();e.openStart("span",this.getId()+"-text").attr("dir",a!==I.Inherit?a.toLowerCase():"auto").class("sapMText").class("sapMTextNoWrap").class("sapMITBText").class("sapMITBBadgeHolder");var r=n.getTextAlign(_.Begin,a);if(r){e.style("text-align",r)}if(o){if(i){t="("+o+") "+t}else{t+=" ("+o+")"}}e.openEnd().text(t).close("span")};O.prototype._getSelectList=function(){if(!this._oSelectList){this._oSelectList=new c({selectionChange:function(e){var t=e.getParameter("selectedItem");this._oIconTabHeader.setSelectedItem(t._getRealTab());this._oTabFilter._closePopover()}});this._oSelectList._oIconTabHeader=this.getParent();this._oSelectList._oTabFilter=this;this._oSelectList._bIsOverflow=this._isOverflow()}return this._oSelectList};O.prototype._prepareDragEventDelegate=function(){if(this.getEnabled()){this.addEventDelegate(this._oDragEventDelegate,this)}else{this.removeEventDelegate(this._oDragEventDelegate)}};O.prototype._updateTabCountText=function(){if(!this._isOverflow()){return}var e=this._getIconTabHeader()._getItemsForOverflow(this._bIsStartOverflow,true).filter(function(e){return e.isA("sap.m.IconTabFilter")}).length;this.setText("+"+e)};O.prototype._getExpandButton=function(){this._oExpandButton=this.getAggregation("_expandButton");if(!this._oExpandButton){this._oExpandButton=new t(this.getId()+"-expandButton",{type:v.Transparent,icon:r.getIconURI("slim-arrow-down"),tooltip:E.getText("ICONTABHEADER_OVERFLOW_MORE"),tabIndex:"-1",ariaHasPopup:C.Menu,press:this._expandButtonPress.bind(this)}).addStyleClass("sapMITBFilterExpandBtn");this.setAggregation("_expandButton",this._oExpandButton)}return this._oExpandButton};O.prototype._updateExpandButtonBadge=function(){var e=this.getAggregation("_expandButtonBadge"),t=e.getBadgeCustomData()&&e.getBadgeCustomData().getVisible(),o=this._hasChildWithBadge();if(o&&!t){e.addCustomData(new g({visible:true}))}else if(!o&&t){e.getBadgeCustomData().setVisible(false)}};O.prototype._hasChildWithBadge=function(){var e=this._isOverflow()?this._getIconTabHeader()._getItemsForOverflow(this._bIsStartOverflow):this._getAllSubItems();return e.some(function(e){return e.isA("sap.m.IBadge")&&e.getBadgeCustomData()&&e.getBadgeCustomData().getVisible()})};O.prototype._expandButtonPress=function(){if(!this.getEnabled()){return}this.$().trigger("focus");if(!this._oPopover){this._oPopover=new h({showArrow:false,showHeader:false,offsetY:0,offsetX:0,placement:T.VerticalPreferredBottom}).addStyleClass("sapMITBFilterPopover");this._oPopover.attachBeforeClose(function(){this._getSelectList().destroyItems()},this);if(p.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton())}if(this._getIconTabHeader()._isInsideToolHeader()){this._oPopover.addStyleClass("sapMITBFilterPopoverInToolHeader");this._oPopover.setOffsetY(x);if(!p.system.phone){this._oPopover.addEventDelegate({onAfterRendering:function(e){this._oPopover.getDomRef().style.minWidth=this.$().outerWidth(true)+"px"}.bind(this)})}}this.addDependent(this._oPopover);this._oPopover._oControl._adaptPositionParams=function(){var e=this.$().parents().hasClass("sapUiSizeCompact");this._arrowOffset=0;if(e){this._offsets=["0 0","0 0","0 4","0 0"]}else{this._offsets=["0 0","0 0","0 5","0 0"]}this._atPositions=["end top","end top","end bottom","begin top"];this._myPositions=["end bottom","begin top","end top","end top"]}}var e=this._setSelectListItems();var t=this._getSelectList();this._oPopover.removeAllContent();if(this.getItems().length||this._isOverflow()){this._oPopover.addContent(t);this._oPopover.setInitialFocus(e?t.getSelectedItem():t.getVisibleTabFilters()[0]);this._oPopover.openBy(this)}};O.prototype._getAllSubItems=function(){var e=[];this._getRealTab().getItems().forEach(function(t){if(t.isA("sap.m.IconTabFilter")){e=e.concat(t,t._getAllSubItems())}else{e=e.concat(t)}});return e};O.prototype._getAllSubFilters=function(){return this._getAllSubItems().filter(function(e){return e.isA("sap.m.IconTabFilter")})};O.prototype._getAllSubFiltersDomRefs=function(){return this._getAllSubFilters().filter(function(e){return Boolean(e._getRealTab().getDomRef())}).map(function(e){return e._getRealTab().getDomRef()})};O.prototype._getFirstAvailableSubFilter=function(){var e=this._getAllSubFilters();for(var t=0;t<e.length;t++){var o=e[t];if(o.getContent().length&&o.getVisible()){return o}}return this};O.prototype._isParentOf=function(e){var t=this._getAllSubFilters();for(var o=0;o<t.length;o++){if(t[o]._getRealTab()===e){return true}}return false};O.prototype._createPopoverCloseButton=function(){return new d({text:E.getText("SELECT_CANCEL_BUTTON"),press:this._closePopover.bind(this)})};O.prototype._closePopover=function(){if(this._oPopover){this._oPopover.close();this._oPopover.removeAllContent()}if(this._isOverflow()&&this.getParent().oSelectedItem){(this.getParent()._oSelectedRootItem||this.getParent().oSelectedItem._getRootTab()).$().trigger("focus")}};O.prototype._handleOnDragOver=function(e){if(this._isDropPossible(e)){this.getDomRef().classList.add("sapMITHDragOver");e.preventDefault()}};O.prototype._handleOnLongDragOver=function(e){if(this._isDropPossible(e)){if(this._oPopover&&this._oPopover.isOpen()){return}this._expandButtonPress()}};O.prototype._handleOnDrop=function(){this.getDomRef().classList.remove("sapMITHDragOver")};O.prototype._handleOnDragLeave=function(){this.getDomRef().classList.remove("sapMITHDragOver")};O.prototype._isDropPossible=function(e){var t=this._getIconTabHeader(),o=e.dragSession.getDragControl()._getRealTab(),i=t.oSelectedItem;if(t!==o._getIconTabHeader()){return false}if(o===this||o._isParentOf(this)){return false}if(!this._isOverflow()&&!t.getMaxNestingLevel()){return false}if(this._isOverflow()&&i&&(i===o||i._getRootTab()===o)){return false}return true};O.prototype._setSelectListItems=function(){var e=this.getParent(),t=this._getSelectList(),o=this._getAllSubItems(),i=e.oSelectedItem,s=false,a,n,r,l,p;if(this._isOverflow()){o=e._getItemsForOverflow(this._bIsStartOverflow)}t.destroyItems();t.setSelectedItem(null);for(l=0;l<o.length;l++){a=o[l];n=a.clone(undefined,undefined,{cloneChildren:false,cloneBindings:true});a._oCloneInList=n;r=a.getCustomData();for(p=0;p<r.length;p++){n.addCustomData(r[p].clone())}n._oRealItem=a;t.addItem(n);if(a.isA("sap.m.IconTabSeparator")){continue}if(n._getRealTab()===i){t.setSelectedItem(n);s=true;continue}if(n._getRealTab()._isParentOf(i)){t.setSelectedItem(i._getRealTab());s=true}}return s};O.prototype._isOverflow=function(){return this._bIsOverflow||this._bIsStartOverflow};O.prototype._getIconTabHeader=function(){return this._getRootTab().getParent()};O.prototype.onsapdown=function(e){if(!this.getEnabled()){return}if(this._isOverflow()||this._getNestedLevel()===1&&this._getRealTab()===this&&this._getRealTab().getItems().length!==0){e.stopImmediatePropagation();this._expandButtonPress()}};O.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),S);if(this._getRootTab()!==this){this._getRootTab()._updateExpandButtonBadge()}};O.prototype._hideBadge=function(){var e=this.getBadgeCustomData();if(!e){return}e.setVisible(false);if(this._getRootTab()!==this){this._getRootTab()._updateExpandButtonBadge()}if(this._oCloneInList&&!this._oCloneInList.bIsDestroyed&&this._oCloneInList.getBadgeCustomData()){this._oCloneInList.getBadgeCustomData().setVisible(false);this._oCloneInList=null}if(this._isInOverflow()){this._getIconTabHeader()._getOverflow()._updateExpandButtonBadge()}if(this._isInStartOverflow()){this._getIconTabHeader()._getStartOverflow()._updateExpandButtonBadge()}this._iHideBadgeTimeout=null};O.prototype._isInOverflow=function(){return!this._bIsOverflow&&this._getIconTabHeader()._getItemsInStrip().indexOf(this._getRealTab())===-1};O.prototype._isInStartOverflow=function(){return!this._bIsStartOverflow&&this._getIconTabHeader()._getItemsInStrip().indexOf(this._getRealTab())===-1};O.prototype.onBadgeUpdate=function(e,t,o){var i=this.getDomRef(),s=this._getIconTabHeader(),a,n,r,p,d,h,c,u;if(!s){return}if(i){r=i.getAttribute("aria-labelledby")||"";switch(t){case m.Appear:r=o+" "+r;break;case m.Disappear:r=r.replace(o,"").trim();break}i.setAttribute("aria-labelledby",r)}if(!s._isRendered()){return}a=this._getRootTab();if(a._isInOverflow()){d=this._getIconTabHeader()._getOverflow();d._updateExpandButtonBadge()}if(a._isInStartOverflow()){h=this._getIconTabHeader()._getStartOverflow();h._updateExpandButtonBadge()}else if(a!==this){a._updateExpandButtonBadge()}if(t!==m.Appear){return}this._enableMotion();if((this._isInOverflow()||this._isInStartOverflow())&&this._oCloneInList){this._oCloneInList.addCustomData(new g)}n=l.getInstance();p=this.getText();if(a._isInOverflow()){c="ICONTABFILTER_SUB_ITEM_BADGE";u=[p,d.getText()]}if(a._isInStartOverflow()){c="ICONTABFILTER_SUB_ITEM_BADGE";u=[p,h.getText()]}else{if(a!==this){c="ICONTABFILTER_SUB_ITEM_BADGE";u=[p,a.getText()]}else{c="ICONTABFILTER_BADGE_MSG";u=[p]}}n.announce(E.getText(c,u),D.Assertive)};O.prototype.getAriaLabelBadgeText=function(){return E.getText("ICONTABFILTER_BADGE")};O.prototype._enableMotion=function(){if(this._getRealTab()._isInOverflow()||this._getRealTab()._isInStartOverflow()){if(this._oCloneInList&&this._oCloneInList.getDomRef()){this._oCloneInList.getDomRef().classList.add("sapMITBFilterBadgeMotion")}}else if(this.getDomRef()){this.getDomRef().classList.add("sapMITBFilterBadgeMotion")}};O.prototype._shouldReadIconColor=function(){var e=this.getIconColor();return this.getEnabled()&&(e==="Positive"||e==="Critical"||e==="Negative"||e==="Neutral")};return O});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabFilterExpandButtonBadge", ["./BadgeEnabler","sap/ui/core/Control","sap/ui/core/Core"],function(e,t,a){"use strict";var n=a.getLibraryResourceBundle("sap.m");var r=t.extend("sap.m.IconTabFilterExpandButtonBadge",{metadata:{library:"sap.m",interfaces:["sap.m.IBadge"]},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).class("sapMITFExpandButtonBadge").openEnd().close("div")}}});e.call(r.prototype);r.prototype.init=function(){this.initBadgeEnablement({style:"Attention"})};r.prototype.getAriaLabelBadgeText=function(){return n.getText("ICONTABFILTER_SUB_ITEMS_BADGES")};r.prototype.onBadgeUpdate=function(){var e=this.getParent();e.onBadgeUpdate.apply(e,arguments)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabHeader", ["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","sap/ui/Device","sap/m/Button","sap/m/IconTabFilter","sap/m/IconTabSeparator","sap/m/IconTabBarDragAndDropUtil","sap/ui/core/library","sap/m/IconTabHeaderRenderer","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/events/KeyCodes"],function(e,t,i,s,r,o,a,n,l,d,h,f,p,g,jQuery,c,u){"use strict";var v=p.dnd.DropPosition;var I=e.BackgroundDesign;var m=e.IconTabHeaderMode;var _=e.IconTabDensityMode;var y=e.TabsOverflowMode;var b=i.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:m.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:I.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:_.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null},tabsOverflowMode:{type:"sap.m.TabsOverflowMode",group:"Behavior",defaultValue:y.End}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_overflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"},_startOverflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},previousKey:{type:"string"}}}}},renderer:g});var T=t.getLibraryResourceBundle("sap.m");s.apply(b.prototype,[true]);b.prototype.init=function(){this._bFireSelectEvent=false;this._aTabKeys=[];this._oAriaHeadText=null;this._bIsRendered=false};b.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}if(this._sResizeListenerId){a.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this._aTabKeys){this._aTabKeys=null}if(this._oOverflow){this._oOverflow.removeEventDelegate(this._oOverflowEventDelegate);this._oOverflowEventDelegate=null;this._oOverflow=null}if(this._oStartOverflow){this._oStartOverflow.removeEventDelegate(this._oStartOverflowEventDelegate);this._oStartOverflowEventDelegate=null;this._oStartOverflow=null}if(this._oAriaHeadText){this._oAriaHeadText.destroy();this._oAriaHeadText=null}this._bRtl=null};b.prototype.onBeforeRendering=function(){this._bIsRendered=false;this._bRtl=t.getConfiguration().getRTL();if(this._sResizeListenerId){a.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this._updateSelection();this.destroyDragDropConfig();this._setsDragAndDropConfigurations()};b.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this.oSelectedItem){this._applySelectionToFilters();this.oSelectedItem._hideBadge()}if(t.isThemeApplied()){this._setItemsForStrip()}else{t.attachThemeChanged(this._handleThemeLoad,this)}this._initItemNavigation();this._sResizeListenerId=a.register(this.getDomRef(),jQuery.proxy(this._fnResize,this));this.getItems().forEach(function(e){if(e._onAfterParentRendering){e._onAfterParentRendering()}});this._bIsRendered=true};b.prototype._isRendered=function(){return this._bIsRendered};b.prototype._getSelectList=function(){return this._getOverflow()._getSelectList()};b.prototype._getOverflow=function(){var e=this.getAggregation("_overflow");if(!e){e=new d({id:this.getId()+"-overflow",text:T.getText("ICONTABHEADER_OVERFLOW_MORE")});e._bIsOverflow=true;this._oOverflowEventDelegate={onsapnext:e.onsapdown};e.addEventDelegate(this._oOverflowEventDelegate,e);this.setAggregation("_overflow",e);this._oOverflow=e}return e};b.prototype._getStartOverflow=function(){var e=this.getAggregation("_startOverflow");if(!e){e=new d({id:this.getId()+"-startOverflow",text:T.getText("ICONTABHEADER_OVERFLOW_MORE")});e._bIsStartOverflow=true;this._oStartOverflowEventDelegate={onsapprevious:e.onsapdown};e.addEventDelegate(this._oStartOverflowEventDelegate,e);this.setAggregation("_startOverflow",e);this._oStartOverflow=e}return e};b.prototype._getInvisibleHeadText=function(){var e=this.getAriaTexts()||{};if(!this._oAriaHeadText){this._oAriaHeadText=new o({id:this.getId()+"-ariaHeadText"})}this._oAriaHeadText.setText(e.headerDescription);return this._oAriaHeadText};b.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return}var e=this._oItemNavigation.getItemDomRefs().indexOf(this.oSelectedItem._getRootTab().getDomRef());this._oItemNavigation.setFocusedIndex(e)};b.prototype.getTabFilters=function(){var e=[];this.getItems().forEach(function(t){if(t instanceof d){e.push(t)}});return e};b.prototype._setsDragAndDropConfigurations=function(){if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){f.setDragDropAggregations(this,"Horizontal",this._getDropPosition())}};b.prototype._getDropPosition=function(){return this.getMaxNestingLevel()===0?v.Between:v.OnOrBetween};b.prototype.setSelectedKey=function(e){if(e===this.getSelectedKey()){if(this._isInsideIconTabBar()){this.getParent().setProperty("selectedKey",e,true)}return this}var t=this.getTabFilters(),i=this._isInsideIconTabBar(),s=true,r;if(t.length>0){e=e||t[0]._getNonEmptyKey()}if(this.$().length){r=this._findItemByKey(e);if(r){this.setSelectedItem(r,s)}else if(!i&&e){this.setSelectedItem(null)}}this.setProperty("selectedKey",e,true);return this};b.prototype.setSelectedItem=function(e,t){if(!e){if(this.oSelectedItem){this._removeSelectionFromFilters();this.oSelectedItem=null}return this}if(this._isUnselectable(e)){return this}var i=this.getParent();var s=this._isInsideIconTabBar();var r=this.getSelectedKey();var o=false;if(e.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){o=true}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!t&&s&&i.getExpandable()||this.oSelectedItem!==e)){this._removeSelectionFromFilters()}if(e.getVisible()){if(this.oSelectedItem===e){if(!t&&s&&i.getExpandable()){i._toggleExpandCollapse()}}else{if(s){i.$("content").attr("aria-labelledby",e._getRootTab().getId())}this.oSelectedItem=e;this._applySelectionToFilters();this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(s&&(i.getExpandable()||i.getExpanded())){var a=this.oSelectedItem.getContent();if(a.length>0){i._rerenderContent(a)}else{if(!o){i._rerenderContent(i.getContent())}}if(!t&&i.getExpandable()&&!i.getExpanded()){i._toggleExpandCollapse(true)}}}}this.oSelectedItem=e;var n=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",n,true);if(s){i.setProperty("selectedKey",n,true)}if(s){t=t&&!i._bFireSelectEvent}else{t=t&&!this._bFireSelectEvent}if(!t){if(s){i.fireSelect({selectedItem:this.oSelectedItem,selectedKey:n,item:this.oSelectedItem,key:n,previousKey:r})}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:n,item:this.oSelectedItem,key:n,previousKey:r})}}this.oSelectedItem._startBadgeHiding();var l=this.oSelectedItem._getRootTab().getDomRef();if(!l||l.classList.contains("sapMITBFilterHidden")||this.getTabsOverflowMode()===y.End){this._setItemsForStrip()}return this};b.prototype.getVisibleTabFilters=function(){return this.getTabFilters().filter(function(e){return e.getVisible()})};b.prototype._initItemNavigation=function(){var e=[],t=-1,i=this.oSelectedItem&&this.oSelectedItem._getRootTab();if(this.$().hasClass("sapMITHStartOverflowList")){var s=this._getStartOverflow().getFocusDomRef();s.setAttribute("tabindex","-1");e.push(s)}this.getTabFilters().forEach(function(s){var r=this.getFocusDomRef(s);if(!r){return}r.setAttribute("tabindex","-1");e.push(r);if(s===i||s===this.oSelectedItem){t=e.indexOf(r)}}.bind(this));if(this.$().hasClass("sapMITHEndOverflowList")){var o=this._getOverflow().getFocusDomRef();o.setAttribute("tabindex","-1");e.push(o)}if(!this._oItemNavigation){this._oItemNavigation=(new r).setCycling(false).attachEvent(r.Events.FocusLeave,this._onItemNavigationFocusLeave,this).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation)}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(e).setPageSize(e.length).setSelectedIndex(t)};b.prototype.onThemeChanged=function(){this._applyTabDensityMode()};b.prototype._applyTabDensityMode=function(){var e=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(e){case _.Compact:this.$().addClass("sapUiSizeCompact");break;case _.Inherit:if(this.$().closest(".sapUiSizeCompact").length){this.$().addClass("sapUiSizeCompact")}break}};b.prototype._handleThemeLoad=function(){setTimeout(this._setItemsForStrip.bind(this),350);t.detachThemeChanged(this._handleThemeLoad,this)};b.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");return this};b.prototype.addItem=function(e){if(!(e instanceof h)){var t=e.getKey();if(this._aTabKeys.indexOf(t)!==-1){c.warning("sap.m.IconTabHeader: duplicate key '"+t+"' inside the IconTabFilter. Please use unique keys.")}this._aTabKeys.push(t)}this.addAggregation("items",e);this._invalidateParentIconTabBar();return this};b.prototype.insertItem=function(e,t){if(!(e instanceof h)){var i=e.getKey();if(this._aTabKeys.indexOf(i)!==-1){c.warning("sap.m.IconTabHeader: duplicate key '"+i+"' inside the IconTabFilter. Please use unique keys.")}this._aTabKeys.push(i)}this.insertAggregation("items",e,t);this._invalidateParentIconTabBar()};b.prototype.removeAllItems=function(){var e=this.removeAllAggregation("items");this._aTabKeys=[];this.oSelectedItem=null;this._invalidateParentIconTabBar();return e};b.prototype.removeItem=function(e){e=this.removeAggregation("items",e);if(e&&!(e instanceof h)){var t=e.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(t),1)}if(this.oSelectedItem===e){this.oSelectedItem=null}this._invalidateParentIconTabBar();return e};b.prototype.updateAggregation=function(){this.oSelectedItem=null;i.prototype.updateAggregation.apply(this,arguments);this.invalidate()};b.prototype.removeAggregation=function(e,t,s){var r=this.getTabFilters();var o=i.prototype.removeAggregation.apply(this,arguments);if(s){return o}if(!this._getPreserveSelection()&&o&&o==this.oSelectedItem&&e=="items"){var a=r?Array.prototype.indexOf.call(r,o):-1;r=this.getTabFilters();a=Math.max(0,Math.min(a,r.length-1));var n=r[a];if(n){this.setSelectedItem(n,true)}else{var l=this.getParent();if(this._isInsideIconTabBar()&&l.getExpanded()){l.$("content").children().remove()}}}return o};b.prototype.removeAllAggregation=function(e,t){if(e=="items"){var s=this.getParent();if(this._isInsideIconTabBar()&&s.getExpanded()){s.$("content").children().remove()}}return i.prototype.removeAllAggregation.apply(this,arguments)};b.prototype._getPreserveSelection=function(){return this._bPreserveSelection};b.prototype._setPreserveSelection=function(e){this._bPreserveSelection=e};b.prototype._getDisplayText=function(e){var t=e.getText();if(this.isInlineMode()){var i=e.getCount();if(i){if(this._bRtl){t="("+i+") "+t}else{t+=" ("+i+")"}}}return t};b.prototype.isInlineMode=function(){return this.getMode()===m.Inline};b.prototype._checkTextOnly=function(){this._bTextOnly=this.getItems().every(function(e){return e instanceof h||!e.getIcon()});return this._bTextOnly};b.prototype._checkNoText=function(e){if(e.length>0){for(var t=0;t<e.length;t++){if(!(e[t]instanceof h)){if(e[t].getText().length>0){return false}}}}return true};b.prototype._checkInLine=function(e){var t;if(e.length>0){for(var i=0;i<e.length;i++){t=e[i];if(!(t instanceof h)){if(t.getIcon()||t.getCount()){this._bInLine=false;return false}}}}this._bInLine=true;return true};b.prototype._getItemsInStrip=function(){return this.getItems().filter(function(e){var t=e.getDomRef();return t&&!t.classList.contains("sapMITBFilterHidden")})};b.prototype._setItemsForStrip=function(){var e=this.getVisibleTabFilters();if(!t.isThemeApplied()||!e.length){return}var i=this.getDomRef("head");if(!i){return}var s=this._getStartOverflow(),r=this._getOverflow(),o=this.getItems().filter(function(e){return e.getDomRef()}).map(function(e){return e.getDomRef()}),a=this.oSelectedItem&&this.oSelectedItem.getVisible()?this.oSelectedItem:e[0],n=(a._getRootTab()||a).getDomRef();if(!o.length||!n){return}s.$().removeClass("sapMITHOverflowVisible");r.$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHStartOverflowList");this.$().removeClass("sapMITHEndOverflowList");o.forEach(function(e){e.classList.remove("sapMITBFilterHidden")});var l=o.reduce(function(e,t){return e+jQuery(t).outerWidth(true)},0),d=l>i.offsetWidth;if(!d){return}switch(this.getTabsOverflowMode()){case y.StartAndEnd:this._updateStartAndEndOverflow(o,n);break;case y.End:default:this._updateEndOverflow(o,n);break}};b.prototype._updateEndOverflow=function(e,t){var i=this._getOverflow(),s=this.getDomRef("head"),r,o,a,n;i.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");r=s.offsetWidth;a=this._getSelectedItemIndexAndSize(e,t);o=this._findLastVisibleItem(e,r,a.width);for(n=o+1;n<e.length;n++){e[n].classList.add("sapMITBFilterHidden")}i._updateExpandButtonBadge()};b.prototype._updateStartAndEndOverflow=function(e,t){var i=this._getStartOverflow(),s=this._getOverflow(),r=this.getDomRef("head"),o=r.offsetWidth,a=this._getSelectedItemIndexAndSize(e,t),n=this._hasStartOverflow(o,e,a),l=this._hasEndOverflow(o,e,a),d,h,f;if(!n){s.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");o=r.offsetWidth;h=this._findLastVisibleItem(e,o,a.width);for(f=h+1;f<e.length;f++){e[f].classList.add("sapMITBFilterHidden")}s._updateTabCountText();s._updateExpandButtonBadge();return}if(!l){i.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");o=r.offsetWidth;d=this._findFirstVisibleItem(e,o,a.width);for(f=d-1;f>=0;f--){e[f].classList.add("sapMITBFilterHidden")}i._updateTabCountText();i._updateExpandButtonBadge();return}i.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");s.$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");o=r.offsetWidth;d=this._findFirstVisibleItem(e,o,a.width,a.index-1);h=this._findLastVisibleItem(e,o,a.width,d);for(f=d-1;f>=0;f--){e[f].classList.add("sapMITBFilterHidden")}for(f=h+1;f<e.length;f++){e[f].classList.add("sapMITBFilterHidden")}i._updateExpandButtonBadge();i._updateTabCountText();s._updateTabCountText();s._updateExpandButtonBadge()};b.prototype._hasStartOverflow=function(e,t,i){if(i.index===0){return false}var s,r=0;for(s=i.index-1;s>=0;s--){r+=this._getItemSize(t[s])}var o=e<r+i.width;if(!o){this._getOverflow().$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHEndOverflowList");e=this.getDomRef("head").offsetWidth;o=e<r+i.width;this._getOverflow().$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHEndOverflowList")}return o};b.prototype._hasEndOverflow=function(e,t,i){if(i.index>=t.length){return false}var s,r=0;for(s=i.index;s<t.length;s++){r+=this._getItemSize(t[s])}var o=e<r+i.width;if(!o){this._getStartOverflow().$().addClass("sapMITHOverflowVisible");this.$().addClass("sapMITHStartOverflowList");e=this.getDomRef("head").offsetWidth;o=e<r+i.width;this._getStartOverflow().$().removeClass("sapMITHOverflowVisible");this.$().removeClass("sapMITHStartOverflowList")}return o};b.prototype._getSelectedItemIndexAndSize=function(e,t){var i=e.indexOf(t),s=this._getItemSize(t),r;if(e[i-1]&&e[i-1].classList.contains("sapMITBSep")){r=e[i-1];s+=this._getItemSize(r)}e.splice(i,1);if(r){e.splice(i-1,1);i--}return{index:i,width:s}};b.prototype._findFirstVisibleItem=function(e,t,i,s){var r,o,a;if(s===undefined){s=e.length-1}r=s+1;for(o=s;o>=0;o--){a=this._getItemSize(e[o]);if(t<i+a){break}i+=a;r=o}return r};b.prototype._findLastVisibleItem=function(e,t,i,s){var r,o,a;s=s||0;r=s-1;for(o=s;o<e.length;o++){a=this._getItemSize(e[o]);if(t<i+a){break}i+=a;r=o}var n=e[o-1];if(n&&n.classList.contains("sapMITBSep")){r-=1}return r};b.prototype._getItemSize=function(e){var t=window.getComputedStyle(e),i=e.offsetWidth,s=Number.parseInt(t.marginLeft)+Number.parseInt(t.marginRight);return i+s};b.prototype._hasSubItems=function(){var e=this.getTabFilters(),t;for(t=0;t<e.length;t++){if(e[t].getItems().length>0){return true}}return false};b.prototype._handleActivation=function(e){var i=e.target.id,s=e.srcControl,r,o=jQuery(e.target);if(s instanceof l){return}var a=jQuery(document.getElementById(i));if(a.parents()&&Array.prototype.indexOf.call(a.parents(),this.$("content")[0])>-1){}else{if(i){e.preventDefault();if(o.hasClass("sapMITBFilterIcon")||o.hasClass("sapMITBCount")||o.hasClass("sapMITBText")||o.hasClass("sapMITBTab")||o.hasClass("sapMITBContentArrow")||o.hasClass("sapMITBSep")||o.hasClass("sapMITBSepIcon")){r=e.srcControl.getId().replace(/-icon$/,"");s=t.byId(r);if(s.getMetadata().isInstanceOf("sap.m.IconTab")&&!(s instanceof h)){if(this._isUnselectable(s)){if(s.getItems().length||s._isOverflow()){s._expandButtonPress()}return}if(s===this._getOverflow()||s===this._getStartOverflow()){s._expandButtonPress();return}this.setSelectedItem(s)}}else if(s.getMetadata().isInstanceOf("sap.m.IconTab")&&!(s instanceof h)){if(this._isUnselectable(s)){if(s.getItems().length||s._isOverflow()){s._expandButtonPress()}return}if(s===this._getOverflow()||s===this._getStartOverflow()){s._expandButtonPress();return}this.setSelectedItem(s)}}else{if(s.getMetadata().isInstanceOf("sap.m.IconTab")&&!(s instanceof h)){if(this._isUnselectable(s)){if(s.getItems().length||s._isOverflow()){s._expandButtonPress()}return}if(s===this._getOverflow()||s===this._getStartOverflow()){s._expandButtonPress();return}this.setSelectedItem(s)}}}};b.prototype._fnResize=function(){if(this._getOverflow()._oPopover){this._getOverflow()._oPopover.close()}if(this._getStartOverflow()._oPopover){this._getStartOverflow()._oPopover.close()}this._setItemsForStrip();this._initItemNavigation()};b.prototype._isUnselectable=function(e){var t=e._getRealTab();return!t.getEnabled()||this._isInsideIconTabBar()&&!this.getParent().getContent().length&&t._getNestedLevel()===1&&t.getItems().length&&!t.getContent().length||t._isOverflow()};b.prototype._isInsideIconTabBar=function(){var e=this.getParent();return e instanceof i&&e.isA("sap.m.IconTabBar")};b.prototype._isInsideToolHeader=function(){var e=this.getParent();return e instanceof i&&e.isA("sap.tnt.ToolHeader")};b.prototype._invalidateParentIconTabBar=function(){if(this._isInsideIconTabBar()){this.getParent().invalidate()}};b.prototype.getFocusDomRef=function(e){var t=e||this.oSelectedItem;if(!t){return null}return t.getDomRef()};b.prototype.applyFocusInfo=function(e){if(e.focusDomRef){jQuery(e.focusDomRef).trigger("focus")}};b.prototype._updateSelection=function(){var e=this.getItems(),t=this.getSelectedKey(),i=0,s=this._isInsideIconTabBar(),r=this._isInsideToolHeader();if(!e.length){return}if(!this.oSelectedItem||t&&t!==this.oSelectedItem._getNonEmptyKey()){if(t){this.oSelectedItem=this._findItemByKey(t)}if(!this.oSelectedItem&&(s||!t)){for(i=0;i<e.length;i++){if(!(e[i]instanceof h)&&e[i].getVisible()){this.oSelectedItem=e[i];break}}}}if(!r&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<e.length;i++){if(!(e[i]instanceof h)&&e[i].getVisible()){this.oSelectedItem=e[i];break}}}if(!this.oSelectedItem){return}if(this._isUnselectable(this.oSelectedItem)){this.setSelectedItem(this.oSelectedItem._getFirstAvailableSubFilter(),true);return}this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true)};b.prototype._findItemByKey=function(e){var t=this.getTabFilters(),i;for(var s=0;s<t.length;s++){if(t[s]._getNonEmptyKey()===e){return t[s]}i=t[s]._getAllSubFilters();for(var r=0;r<i.length;r++){if(i[r]._getNonEmptyKey()===e){return i[r]}}}};b.prototype._applySelectionToFilters=function(){if(this._isInsideIconTabBar()&&!this.getParent().getExpanded()){return}this.oSelectedItem.$().addClass("sapMITBSelected").attr({"aria-selected":true});if(this.oSelectedItem._getNestedLevel()!==1){var e=this.oSelectedItem._getRootTab();e.$().addClass("sapMITBSelected").attr({"aria-selected":true})}};b.prototype._removeSelectionFromFilters=function(){this.oSelectedItem.$().removeClass("sapMITBSelected").attr({"aria-selected":false});if(this.oSelectedItem._getNestedLevel()!==1){var e=this.oSelectedItem._getRootTab();e.$().removeClass("sapMITBSelected").attr({"aria-selected":false})}};b.prototype._getItemsForOverflow=function(e,t){var i=this._getItemsInStrip(),s=this.getTabsOverflowMode()===y.StartAndEnd,r,o=this.getItems(),a=[];if(s){r=o.indexOf(i[0]);o=e?o.slice(0,r):o.slice(r,o.length)}o.forEach(function(e){if(!n.system.phone&&i.indexOf(e)>-1){return}a.push(e);if(e.isA("sap.m.IconTabFilter")&&!t){e._getAllSubItems().forEach(function(e){a.push(e)})}});return a};b.prototype.ontouchstart=function(e){var t=e.targetTouches[0];this._iActiveTouch=t.identifier};b.prototype.ontouchend=function(e){if(this._iActiveTouch===undefined){return}var t=0;var i=1;var s;if(e.which===s||e.which===t||e.which===i){this._handleActivation(e)}this._iActiveTouch=undefined};b.prototype.ontouchcancel=b.prototype.ontouchend;b.prototype.onkeydown=function(e){switch(e.which){case u.ENTER:this._handleActivation(e);e.preventDefault();break;case u.SPACE:e.preventDefault();break}};b.prototype.onkeyup=function(e){if(e.which===u.SPACE){this._handleActivation(e)}};b.prototype._handleDragAndDrop=function(e){var t=e.getParameter("dropPosition"),i=e.getParameter("draggedControl"),s=e.getParameter("droppedControl"),r=this,o=this.getMaxNestingLevel();if(t===v.On){r=s._getRealTab()}f.handleDrop(r,t,i._getRealTab(),s,false,o);if(i._getNestedLevel()>1){i._getRootTab()._closePopover()}this._setItemsForStrip();this._initItemNavigation();this._getOverflow()._setSelectListItems();this._getStartOverflow()._setSelectListItems();this._getSelectList()._initItemNavigation();i._getRealTab().$().trigger("focus");if(t===v.On){s._getRealTab().$().trigger("focus")}};b.prototype._moveTab=function(e,t,i){f.moveItem.call(this,e,t,i);this._setItemsForStrip();this._initItemNavigation()};b.prototype.ondragrearranging=function(e){if(!this.getEnableTabReordering()){return}var t=e.srcControl,i=this.indexOfItem(this._getItemsInStrip().pop());e.preventDefault();this._moveTab(t,e.keyCode,i);t.$().trigger("focus")};b.prototype.onsaphomemodifiers=b.prototype.ondragrearranging;b.prototype.onsapendmodifiers=b.prototype.ondragrearranging;b.prototype.onsapincreasemodifiers=b.prototype.ondragrearranging;b.prototype.onsapdecreasemodifiers=b.prototype.ondragrearranging;return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabHeaderRenderer", ["./library","sap/ui/core/Core","sap/ui/core/InvisibleText"],function(e,t,i){"use strict";var s={apiVersion:2};var a=e.TabsOverflowMode;s.getInvisibleSplitTabDescriptionText=function(){if(!this.oInvisibleSplitTabDescriptionText){this.oInvisibleSplitTabDescriptionText=new i({text:t.getLibraryResourceBundle("sap.m").getText("ICONTABHEADER_SPLIT_TAB_DESCRIPTION")}).toStatic()}return this.oInvisibleSplitTabDescriptionText};s.render=function(e,t){if(!t.getVisible()){return}var i=t.getId(),n=t.getItems(),r=t.getVisibleTabFilters().length,l=0,o=t._checkTextOnly(),c=t._checkNoText(n),p=t._checkInLine(n)||t.isInlineMode();var d=t.getParent(),T=d&&d.isA("sap.m.IconTabBar")&&d.getUpperCase(),b=t.getAriaTexts()||{};e.openStart("div",t).class("sapMITH").class("sapContrastPlus").class("sapMITHBackgroundDesign"+t.getBackgroundDesign());if(T){e.class("sapMITBTextUpperCase")}if(o){e.class("sapMITBTextOnly")}if(c){e.class("sapMITBNoText")}if(p){e.class("sapMITBInLine");e.class("sapMITBTextOnly")}e.accessibilityState(t,{role:"navigation"});if(b.headerLabel){e.accessibilityState(t,{label:b.headerLabel})}e.openEnd();if(n.length&&t.getTabsOverflowMode()===a.StartAndEnd){e.openStart("div").class("sapMITHStartOverflow").openEnd();t._getStartOverflow().render(e);e.close("div")}if(b.headerDescription){e.renderControl(t._getInvisibleHeadText())}e.openStart("div",i+"-head").class("sapMITBHead");e.accessibilityState({role:"tablist",orientation:"horizontal"});if(b.headerDescription){e.accessibilityState({describedby:{value:t._getInvisibleHeadText().getId(),append:true}})}if(t._hasSubItems()){e.accessibilityState({describedby:{value:s.getInvisibleSplitTabDescriptionText().getId(),append:true}})}e.openEnd();for(var I=0;I<n.length;I++){var v=n[I];v.render(e,l,r);if(v.isA("sap.m.IconTabFilter")){if(v.getVisible()){l++}}}e.close("div");if(n.length){e.openStart("div").class("sapMITHEndOverflow").openEnd();t._getOverflow().render(e);e.close("div")}e.close("div")};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IconTabSeparator", ["sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Item","sap/m/IconTabFilter","sap/m/ImageHelper"],function(e,t,o,a,r){"use strict";var i=t.extend("sap.m.IconTabSeparator",{metadata:{interfaces:["sap.m.IconTab"],library:"sap.m",designtime:"sap/m/designtime/IconTabSeparator.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}}}});i.prototype._getImageControl=function(e,t){var o={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=r.getImageControl(this.getId()+"-icon",this._oImageControl,t,o,e);return this._oImageControl};i.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy()}t.prototype.exit.call(this,e)};i.prototype._getRealTab=function(){return a.prototype._getRealTab.call(this)};i.prototype._getNestedLevel=function(){return a.prototype._getNestedLevel.call(this)};i.prototype.render=function(t){if(!this.getVisible()){return}var o=this.getIcon(),a=this.getParent(),r=e.getLibraryResourceBundle("sap.m"),i={};if(o){i.role="img";i.label=r.getText("ICONTABBAR_NEXTSTEP")}else{i.role="separator"}t.openStart("div",this).accessibilityState(i).class("sapMITBItem").class("sapMITBSep");if(!o){t.class("sapMITBSepLine")}t.openEnd();if(o){t.renderControl(this._getImageControl(["sapMITBSepIcon"],a))}t.close("div")};i.prototype.renderInSelectList=function(t,o,a,r,i){if(!this.getVisible()){return}var s=this.getIcon(),n=o._oIconTabHeader,l=e.getLibraryResourceBundle("sap.m"),p={};if(s){p.role="img";p.label=l.getText("ICONTABBAR_NEXTSTEP")}else{p.role="separator"}t.openStart("li",this).class("sapMITBSelectItem").class("sapMITBSep").accessibilityState(p);if(i&&!s){t.style("padding-left",i+"rem")}if(!s){t.class("sapMITBSepLine")}t.openEnd();if(s){t.renderControl(this._getImageControl(["sapMITBSepIcon"],n))}t.close("li")};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IllustratedMessage", ["./library","sap/m/Text","sap/m/Title","sap/m/FormattedText","sap/m/Illustration","sap/base/Log","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/library","sap/ui/core/ResizeHandler","sap/ui/thirdparty/jquery","./IllustratedMessageRenderer"],function(e,t,i,s,a,l,o,r,n,u,jQuery,p){"use strict";var d=e.IllustratedMessageSize;var T=e.IllustratedMessageType;var g=n.TextAlign;var I=n.TitleLevel;var h=o.extend("sap.m.IllustratedMessage",{metadata:{library:"sap.m",properties:{description:{type:"string",group:"Misc",defaultValue:""},enableDefaultTitleAndDescription:{type:"boolean",group:"Appearance",defaultValue:true},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false},enableVerticalResponsiveness:{type:"boolean",group:"Appearance",defaultValue:false},illustrationSize:{type:"sap.m.IllustratedMessageSize",group:"Appearance",defaultValue:d.Auto},illustrationType:{type:"string",group:"Appearance",defaultValue:T.NoSearchResults},title:{type:"string",group:"Misc",defaultValue:""},ariaTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:I.Auto}},aggregations:{additionalContent:{type:"sap.m.Button",multiple:true},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_illustration:{type:"sap.m.Illustration",visibility:"hidden",multiple:false},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_title:{type:"sap.m.Title",multiple:false,visibility:"hidden"}},associations:{illustrationAriaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"illustrationAriaLabelledBy"}},dnd:{draggable:false,droppable:true}},renderer:p});h.ORIGINAL_TEXTS={UnableToLoad:"UnableToLoad",UnableToUpload:"UnableToUpload",NoActivities:"NoActivities",BeforeSearch:"BeforeSearch",NoSearchResults:"NoSearchResults",NoEntries:"NoEntries",NoData:"NoData",NoNotifications:"NoNotifications",BalloonSky:"BalloonSky",SuccessScreen:"SuccessScreen",NoMail:"NoMail",NoSavedItems:"NoSavedItems",NoTasks:"NoTasks",UploadToCloud:"UploadToCloud",NoDimensionsSet:"NoDimensionsSet",AddDimensions:"AddDimensions"};h.FALLBACK_TEXTS={ReloadScreen:h.ORIGINAL_TEXTS.UnableToLoad,Connection:h.ORIGINAL_TEXTS.UnableToLoad,ErrorScreen:h.ORIGINAL_TEXTS.UnableToUpload,EmptyCalendar:h.ORIGINAL_TEXTS.NoActivities,SearchEarth:h.ORIGINAL_TEXTS.BeforeSearch,SearchFolder:h.ORIGINAL_TEXTS.NoSearchResults,EmptyList:h.ORIGINAL_TEXTS.NoEntries,Tent:h.ORIGINAL_TEXTS.NoData,SleepingBell:h.ORIGINAL_TEXTS.NoNotifications,SimpleBalloon:h.ORIGINAL_TEXTS.BalloonSky,SimpleBell:h.ORIGINAL_TEXTS.NoNotifications,SimpleCalendar:h.ORIGINAL_TEXTS.NoActivities,SimpleCheckMark:h.ORIGINAL_TEXTS.SuccessScreen,SimpleConnection:h.ORIGINAL_TEXTS.UnableToLoad,SimpleEmptyDoc:h.ORIGINAL_TEXTS.NoData,SimpleEmptyList:h.ORIGINAL_TEXTS.NoEntries,SimpleError:h.ORIGINAL_TEXTS.UnableToUpload,SimpleMagnifier:h.ORIGINAL_TEXTS.BeforeSearch,SimpleMail:h.ORIGINAL_TEXTS.NoMail,SimpleNoSavedItems:h.ORIGINAL_TEXTS.NoSavedItems,SimpleNotFoundMagnifier:h.ORIGINAL_TEXTS.NoSearchResults,SimpleReload:h.ORIGINAL_TEXTS.UnableToLoad,SimpleTask:h.ORIGINAL_TEXTS.NoTasks,SuccessBalloon:h.ORIGINAL_TEXTS.BalloonSky,SuccessCheckMark:h.ORIGINAL_TEXTS.SuccessScreen,SuccessHighFive:h.ORIGINAL_TEXTS.BalloonSky};h.PREPENDS={DESCRIPTION:"IllustratedMessage_DESCRIPTION_",TITLE:"IllustratedMessage_TITLE_"};h.BREAK_POINTS={DIALOG:679,SPOT:319,DOT:259,BASE:159};h.BREAK_POINTS_HEIGHT={DIALOG:451,SPOT:296,DOT:154,BASE:87};h.MEDIA={BASE:"sapMIllustratedMessage-Base",DOT:"sapMIllustratedMessage-Dot",SPOT:"sapMIllustratedMessage-Spot",DIALOG:"sapMIllustratedMessage-Dialog",SCENE:"sapMIllustratedMessage-Scene"};h.RESIZE_HANDLER_ID={CONTENT:"_sContentResizeHandlerId"};h.prototype.init=function(){this._sLastKnownMedia=null;this._updateInternalIllustrationSetAndType(this.getIllustrationType());r.getEventBus().subscribe("sapMIllusPool-assetLdgFailed",this._handleMissingAsset.bind(this))};h.prototype.onBeforeRendering=function(){this._detachResizeHandlers()};h.prototype.onAfterRendering=function(){this._updateDomSize();this._attachResizeHandlers();this._preventWidowWords(this._getTitle().getDomRef());this._preventWidowWords(this._getDescription().getDomRef());this._setDefaultIllustrationLabel()};h.prototype.exit=function(){this._detachResizeHandlers()};h.prototype.setIllustrationType=function(e){if(this.getIllustrationType()===e){return this}if(typeof e==="string"){this._updateInternalIllustrationSetAndType(e)}return this.setProperty("illustrationType",e)};h.prototype._setDefaultIllustrationLabel=function(e){var t=this.getAssociation("ariaLabelledBy"),i=this._getTitle().sId;if(!t||!t.length){this.addIllustrationAriaLabelledBy(i)}};h.prototype._getDefaultDescription=function(){return this._findDefaultText(h.PREPENDS.DESCRIPTION)};h.prototype._getDefaultTitle=function(){return this._findDefaultText(h.PREPENDS.TITLE)};h.prototype._findDefaultText=function(e){var t=this._getResourceBundle();return t.getText(e+this._sIllustrationType,undefined,true)||t.getText(e+this._sIllustrationType.substr(0,this._sIllustrationType.indexOf("_v")),undefined,true)||t.getText(e+h.FALLBACK_TEXTS[this._sIllustrationType],undefined,true)};h.prototype._shouldRenderTitle=function(){return this._getTitle().getText().length!==0};h.prototype._shouldRenderDescription=function(){var e=this._getDescription();if(this.getEnableFormattedText()){return e.getHtmlText().length!==0}else{return e.getText().length!==0}};h.prototype._getDescription=function(){return this.getEnableFormattedText()?this._getFormattedText():this._getText()};h.prototype._getFormattedText=function(){var e=this.getDescription(),t=this.getAggregation("_formattedText");if(!t){t=new s({textAlign:g.Center});this.setAggregation("_formattedText",t)}if(!e&&this.getEnableDefaultTitleAndDescription()){t.setHtmlText(this._getDefaultDescription())}else{t.setHtmlText(e)}return t};h.prototype._getIllustration=function(){var e=this.getAggregation("_illustration");if(!e){e=new a;this.setAggregation("_illustration",e)}return e};h.prototype._getResourceBundle=function(){return r.getLibraryResourceBundle("sap.m")};h.prototype._getText=function(){var e=this.getDescription(),i=this.getAggregation("_text");if(!i){i=new t({textAlign:g.Center});this.setAggregation("_text",i)}if(!e&&this.getEnableDefaultTitleAndDescription()){i.setText(this._getDefaultDescription())}else{i.setText(e)}return i};h.prototype._getTitle=function(){var e=this.getTitle(),t=this.getAggregation("_title");if(!t){t=new i({wrapping:true});this.setAggregation("_title",t)}if(!e&&this.getEnableDefaultTitleAndDescription()){t.setText(this._getDefaultTitle())}else{t.setText(e)}return t};h.prototype._preventWidowWords=function(e){var t,i,s=window.HTMLElement;if(!(s&&e instanceof s)){return}t=jQuery(e);i=t.html();i=i.replace(/ ([^ ]*)$/,"&nbsp;$1");t.html(i)};h.prototype._updateDomSize=function(){var e=this.getDomRef(),t,i;if(e){t=this.getIllustrationSize();if(t===d.Auto){this._updateMedia(e.getBoundingClientRect().width,e.getBoundingClientRect().height)}else{i=h.MEDIA[t.toUpperCase()];this._updateSymbol(i);this._updateMediaStyle(i)}}};h.prototype._updateInternalIllustrationSetAndType=function(e){var t=e.split("-");this._sIllustrationSet=t[0];this._sIllustrationType=t[1]};h.prototype._onResize=function(e){var t=e.size.width,i=e.size.height;this._updateMedia(t,i)};h.prototype._updateMedia=function(e,t){var i=this.getEnableVerticalResponsiveness(),s;if(!e&&!t){return}if(e<=h.BREAK_POINTS.BASE||t<=h.BREAK_POINTS_HEIGHT.BASE&&i){s=h.MEDIA.BASE}else if(e<=h.BREAK_POINTS.DOT||t<=h.BREAK_POINTS_HEIGHT.DOT&&i){s=h.MEDIA.DOT}else if(e<=h.BREAK_POINTS.SPOT||t<=h.BREAK_POINTS_HEIGHT.SPOT&&i){s=h.MEDIA.SPOT}else if(e<=h.BREAK_POINTS.DIALOG||t<=h.BREAK_POINTS_HEIGHT.DIALOG&&i){s=h.MEDIA.DIALOG}else{s=h.MEDIA.SCENE}this._updateSymbol(s);this._updateMediaStyle(s)};h.prototype._updateMediaStyle=function(e){if(this._sLastKnownMedia!==e){this._sLastKnownMedia=e}else{return}Object.keys(h.MEDIA).forEach(function(t){var i=e===h.MEDIA[t];this.toggleStyleClass(h.MEDIA[t],i)},this)};h.prototype._updateSymbol=function(e){if(e===h.MEDIA.BASE){return}var t=e.substring(e.indexOf("-")+1);this._getIllustration().setSet(this._sIllustrationSet,true).setMedia(t,true).setType(this._sIllustrationType)};h.prototype._getFallbackMedia=function(){var e=this._sLastKnownMedia,t=Object.values(h.MEDIA),i=t.indexOf(e);if(i>-1&&i<t.length-1){return t[i+1]}else{return t[t.length-1]}};h.prototype._handleMissingAsset=function(){var e,t=Object.values(h.MEDIA),i="";if(this._sLastKnownMedia!==t[t.length-1]){e=this._getIllustration();i=this._getFallbackMedia();e.setMedia(i.substring(i.indexOf("-")+1));l.warning(this._sLastKnownMedia+" is unavailable, retrying with larger size...",this)}else{l.warning("No larger fallback asset available, no SVG will be displayed.",this)}};h.prototype._attachResizeHandlers=function(){var e=this.getIllustrationSize();if(this.getDomRef()&&e===d.Auto){this._registerResizeHandler(h.RESIZE_HANDLER_ID.CONTENT,this,this._onResize.bind(this))}};h.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(h.RESIZE_HANDLER_ID.CONTENT)};h.prototype._registerResizeHandler=function(e,t,i){if(!this[e]){this[e]=u.register(t,i)}};h.prototype._deRegisterResizeHandler=function(e){if(this[e]){u.deregister(this[e]);this[e]=null}};h.prototype.getAccessibilityReferences=function(){return{title:this._getTitle().getId(),description:this._getDescription().getId()}};h.prototype.getAccessibilityInfo=function(){var e=this._getTitle().getText(),t=this._getDescription().getText(),i=this.getAdditionalContent();return{type:this._getResourceBundle().getText("ACC_CTR_ILLUSTRATED_MESSAGE"),description:e+". "+t,focusable:!!i.length,children:i}};h.prototype.addIllustrationAriaLabelledBy=function(e){var t=this.getAssociation("ariaLabelledBy"),i=this._getTitle().sId,s=this._getIllustration();this.addAssociation("ariaLabelledBy",e,true);if(t&&t.includes(i)){this.removeIllustrationAriaLabelledBy(i)}s.addAriaLabelledBy(e);return this};h.prototype.removeIllustrationAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=this._getIllustration();t.removeAriaLabelledBy(e);this._setDefaultIllustrationLabel();return this};h.prototype.removeAllAriaLabelledBy=function(e){this.removeAssociation("ariaLabelledBy",e,true);var t=this._getIllustration();t.removeAllAriaLabelledBy(e);this._setDefaultIllustrationLabel();return this};h.prototype.setAriaTitleLevel=function(e){this.setProperty("ariaTitleLevel",e,true);this._getTitle().setLevel(e);return this};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IllustratedMessageRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,t){var n=t._getIllustration(),s=t._getTitle(),a=t._getDescription(),r=t.getAdditionalContent(),o=t.getEnableVerticalResponsiveness(),i=t._shouldRenderTitle(),l=t._shouldRenderDescription();e.openStart("figure",t);e.class("sapMIllustratedMessage");if(o){e.class("sapMIllustratedMessageScalable")}e.openEnd();e.openStart("div");e.class("sapMIllustratedMessageMainContent");e.openEnd();e.renderControl(n);if(i||l){e.openStart("figcaption").openEnd();if(i){e.renderControl(s)}if(l){e.renderControl(a.addStyleClass("sapMIllustratedMessageDescription"))}e.close("figcaption")}e.close("div");e.openStart("div");e.class("sapMIllustratedMessageAdditionalContent");e.openEnd();r.forEach(function(t){e.renderControl(t)});e.close("div");e.close("figure")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IllustratedMessageSize", [],function(){"use strict";var e={Auto:"Auto",Base:"Base",Dot:"Dot",Spot:"Spot",Dialog:"Dialog",Scene:"Scene"};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IllustratedMessageType", [],function(){"use strict";var l={BeforeSearch:"sapIllus-BeforeSearch",NoActivities:"sapIllus-NoActivities",NoData:"sapIllus-NoData",NoMail:"sapIllus-NoMail",NoMailV1:"sapIllus-NoMail_v1",NoEntries:"sapIllus-NoEntries",NoNotifications:"sapIllus-NoNotifications",NoSavedItems:"sapIllus-NoSavedItems",NoSavedItemsV1:"sapIllus-NoSavedItems_v1",NoSearchResults:"sapIllus-NoSearchResults",NoTasks:"sapIllus-NoTasks",NoTasksV1:"sapIllus-NoTasks_v1",NoDimensionsSet:"sapIllus-NoDimensionsSet",NoColumnsSet:"sapIllus-NoColumnsSet",UnableToLoad:"sapIllus-UnableToLoad",UnableToLoadImage:"sapIllus-UnableToLoadImage",UnableToUpload:"sapIllus-UnableToUpload",UploadToCloud:"sapIllus-UploadToCloud",AddColumn:"sapIllus-AddColumn",AddPeople:"sapIllus-AddPeople",AddDimensions:"sapIllus-AddDimensions",BalloonSky:"sapIllus-BalloonSky",Connection:"sapIllus-Connection",EmptyCalendar:"sapIllus-EmptyCalendar",EmptyList:"sapIllus-EmptyList",EmptyPlanningCalendar:"sapIllus-EmptyPlanningCalendar",ErrorScreen:"sapIllus-ErrorScreen",FilterTable:"sapIllus-FilterTable",GroupTable:"sapIllus-GroupTable",NoFilterResults:"sapIllus-NoFilterResults",PageNotFound:"sapIllus-PageNotFound",ReloadScreen:"sapIllus-ReloadScreen",ResizeColumn:"sapIllus-ResizeColumn",SearchEarth:"sapIllus-SearchEarth",SearchFolder:"sapIllus-SearchFolder",SimpleBalloon:"sapIllus-SimpleBalloon",SimpleBell:"sapIllus-SimpleBell",SimpleCalendar:"sapIllus-SimpleCalendar",SimpleCheckMark:"sapIllus-SimpleCheckMark",SimpleConnection:"sapIllus-SimpleConnection",SimpleEmptyDoc:"sapIllus-SimpleEmptyDoc",SimpleEmptyList:"sapIllus-SimpleEmptyList",SimpleError:"sapIllus-SimpleError",SimpleMagnifier:"sapIllus-SimpleMagnifier",SimpleMail:"sapIllus-SimpleMail",SimpleNoSavedItems:"sapIllus-SimpleNoSavedItems",SimpleNotFoundMagnifier:"sapIllus-SimpleNotFoundMagnifier",SimpleReload:"sapIllus-SimpleReload",SimpleTask:"sapIllus-SimpleTask",SleepingBell:"sapIllus-SleepingBell",SortColumn:"sapIllus-SortColumn",SuccessBalloon:"sapIllus-SuccessBalloon",SuccessCheckMark:"sapIllus-SuccessCheckMark",SuccessHighFive:"sapIllus-SuccessHighFive",SuccessScreen:"sapIllus-SuccessScreen",Survey:"sapIllus-Survey",Tent:"sapIllus-Tent",UploadCollection:"sapIllus-UploadCollection"};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Illustration", ["sap/base/Log","sap/ui/core/Control","./IllustrationRenderer","./IllustrationPool","sap/ui/core/Core"],function(e,t,i,o,a){"use strict";var r={sap_horizon:"v5/",sap_horizon_dark:"v5/",sap_horizon_hcb:"v5/hc/",sap_horizon_hcw:"v5/hc/"};var s=t.extend("sap.m.Illustration",{metadata:{library:"sap.m",properties:{set:{type:"string",defaultValue:null},media:{type:"string",defaultValue:null},type:{type:"string",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},dnd:{draggable:true,droppable:false}},renderer:i});s.CAN_NOT_BUILD_SYMBOL_MSG="Some of the Control's properties are missing. Can't build Symbol ID. No SVG will be displayed.";s.prototype.init=function(){this._sId=this.getId()};s.prototype.onBeforeRendering=function(){this._buildSymbolId();if(this._sSymbolId){o.loadAsset(this._sSymbolId,this._sId,this._sIdPrefix)}else{e.warning(s.CAN_NOT_BUILD_SYMBOL_MSG)}};s.prototype.onThemeChanged=function(){this.invalidate()};s.prototype._buildSymbolId=function(){var e=this.getSet(),t=this.getMedia(),i=this.getType(),o;this._sSymbolId="";this._sIdPrefix="";if(e&&t&&i){o=this._formatType(e,i);this._sSymbolId=e+"-"+t+"-"+o.mappedType;this._sIdPrefix=o.prefix}};s.prototype._formatType=function(e,t){var i=t,s="",n=o.getIllustrationSetMetadata(e),l=a.getConfiguration().getTheme(),p=r[l];if(p&&n&&n.aCollections&&n.aCollections.length){n.aCollections.forEach(function(e){if(e.prefix===p&&e.mappings[t]){i=e.mappings[t];s=e.prefix}})}return{mappedType:i,prefix:s}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IllustrationPool", ["sap/base/Log","./library","sap/ui/core/Core","sap/ui/thirdparty/jquery","sap/ui/core/StaticArea"],function(e,t,r,jQuery,s){"use strict";var a="sap-ui-illustration-pool",o="-Patterns",i="sapIllus",n=sap.ui.require.toUrl("sap/m/themes/base/illustrations/"),l=Object.keys(t.IllustratedMessageType);var u=Object.create(null);u[i]={sPath:n,aSymbols:l,bIsPending:false,aCollections:[]};var d=[],f=Object.create(null),c=Object.create(null),b=Object.create(null);var g={};g.loadAsset=function(t,r,s){var a,o;s=s||"";if(t===""){e.error("ID of the asset can not be blank/empty.");return}o=s+t;if(r){b[r]=o}if(f[o]){e.info("The asset with ID '"+t+"' is either loaded or being loaded.");if(r&&c[o]){g._updateDOMPool()}return}a=t.split("-")[0];if(!u[a]){e.error("The illustration set '"+a+"' is not registered. Please register it before requiring one of its assets.");return}f[o]=true;g._requireSVG(a,t,r,s)};g.getIllustrationSetMetadata=function(t){if(!u[t]){e.error("The illustration set '"+t+"' is not registered. Please register it before requiring one of its assets.");return null}return u[t]};g.loadRestOfTheAssets=function(e){var t;if(!u[e]){throw new Error("The illustration set '"+e+"' is not registered. Please register it before requiring rest of its assets.")}t=u[e].aSymbols;if(Array.isArray(t)){t.forEach(function(t){g.loadAsset(e+"-Dot-"+t);g.loadAsset(e+"-Spot-"+t);g.loadAsset(e+"-Dialog-"+t);g.loadAsset(e+"-Scene-"+t)})}};g.registerIllustrationSet=function(t,r){var s=t.setFamily,a=t.setURI;if(u[s]){if(u[s].bIsPending){e.warning("Illustration Set is currently being loaded.")}else{e.warning("Illustration Set already registered.")}return}if(a.substr(a.length-1)!=="/"){a+="/"}u[s]=Object.create(null);u[s].sPath=a;u[s].bIsPending=true;g._loadMetadata(s,a,r)};g._addAssetToDOMPool=function(e,t){g._getDOMPool().insertAdjacentHTML("beforeend",e);if(t){d.push(t)}};g._getDOMPool=function(){var e=document.getElementById(a);if(e===null){e=document.createElement("div");e.id=a;e.setAttribute("aria-hidden","true");s.getDomRef().appendChild(e);g.loadAsset(i+o)}return e};g._loadMetadata=function(t,r,s){var a=r+"metadata.json";return new Promise(function(r){jQuery.ajax(a,{type:"GET",dataType:"json",success:function(a){e.info("Metadata for illustration set ("+t+") successfully loaded");g._metadataLoaded(t,a,s);r(a)},error:function(s,o){if(o!=="abort"){e.error("Metadata from: "+a+" file path could not be loaded");delete u[t];r()}}})})};g._metadataLoaded=function(e,t,r){var s=t.symbols,a=t.collections,i=t.requireCustomPatterns;u[e].aSymbols=s;u[e].aCollections=a;if(i){g.loadAsset(e+o)}if(r){g.loadRestOfTheAssets(e)}u[e].bIsPending=false};g._removeAssetFromDOMPool=function(e){var t=document.getElementById(a),r=e.split("/").pop(),s;if(t!==null){s=document.getElementById(r);if(s!==null){t.removeChild(s);d.splice(d.indexOf(e),1)}}};g._requireSVG=function(t,s,a,i){var n=i+s;i=i||"";return new Promise(function(l){jQuery.ajax(u[t].sPath+i+s+".svg",{type:"GET",dataType:"html",success:function(e){if(s.indexOf(o)===-1){c[n]=e;if(a){g._updateDOMPool()}}else{g._addAssetToDOMPool(e)}l(e)},error:function(t,a){if(a!=="abort"){delete f[n];r.getEventBus().publish("sapMIllusPool-assetLdgFailed");e.error(s+" asset could not be loaded");l()}}})})};g._updateDOMPool=function(){var e=Object.create(null),t=Object.create(null),r,s;for(var a in b){r=b[a];s=d.indexOf(r);if(s===-1){t[r]=true}else{e[r]=true}}for(var o=0;o<d.length;o++){r=d[o];if(!e[r]){g._removeAssetFromDOMPool(r);o--}}for(var i in t){r=c[i];if(r){g._addAssetToDOMPool(r,i)}}};return g},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/IllustrationRenderer", [],function(){"use strict";var t={apiVersion:2};t.render=function(t,e){var s=e._sSymbolId;t.openStart("svg",e);t.class("sapMIllustration");t.accessibilityState(e);t.openEnd();t.openStart("use");t.attr("href","#"+s);t.attr("width","100%");t.attr("height","100%");t.openEnd();t.close("use");t.close("svg")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Image", ["./library","sap/ui/core/Control","sap/ui/base/DataType","sap/base/security/URLListValidator","./ImageRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeCSS","sap/ui/Device","sap/ui/core/library"],function(t,e,i,r,o,a,jQuery,s,n,p){"use strict";var h=t.ImageMode;var u=p.aria.HasPopup;var g=e.extend("sap.m.Image",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Image.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null},densityAware:{type:"boolean",group:"Misc",defaultValue:false},activeSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},mode:{type:"sap.m.ImageMode",group:"Misc",defaultValue:"Image"},backgroundSize:{type:"string",group:"Appearance",defaultValue:"cover"},backgroundPosition:{type:"string",group:"Appearance",defaultValue:"initial"},backgroundRepeat:{type:"string",group:"Appearance",defaultValue:"no-repeat"},lazyLoading:{type:"boolean",defaultValue:false},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:u.None}},aggregations:{detailBox:{type:"sap.m.LightBox",multiple:false,bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDetails:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDetails"}},events:{tap:{},press:{},load:{},error:{}},dnd:{draggable:true,droppable:false}},renderer:o});g._currentDevicePixelRatio=function(){var t=window.devicePixelRatio===undefined?1:window.devicePixelRatio;if(t<=1){t=1}else{t*=2;t=Math.round(t);t/=2}if(t>2){t=2}return t}();g.prototype.init=function(){this._oSvgCachedData={}};g.prototype.onload=function(t){var e,i;if(!this._defaultEventTriggered){this._defaultEventTriggered=true}this._bVersion2Tried=false;var r=this.$(),o=r[0];if(this.getMode()===h.Background){r.css("background-image",'url("'+s(this._oImage.src)+'")')}if(!this._isWidthOrHeightSet()){if(this._iLoadImageDensity>1){e=Math.round(o.getBoundingClientRect().width);i=Math.round(o.getBoundingClientRect().height);if(e===o.naturalWidth&&i===o.naturalHeight){r.width(e/this._iLoadImageDensity)}}}r.removeClass("sapMNoImg");this.fireLoad()};g.prototype.onerror=function(t){if(!this._defaultEventTriggered){this._defaultEventTriggered=true}var e=this.$(),i=this.getMode(),r=i===h.Image?this._getDomImg().attr("src"):this._oImage.src,o=g._currentDevicePixelRatio,a=this._isActiveState?this.getActiveSrc():this.getSrc();e.addClass("sapMNoImg");if(!r||this._iLoadImageDensity===1){if(this.getAlt()&&!this.getDecorative()){e.removeClass("sapMNoImg")}this.fireError();return}if(o===2||o<1){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(a,1))}else if(o===1.5){if(this._bVersion2Tried){setTimeout(jQuery.proxy(function(){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(a,1))},this),0)}else{setTimeout(jQuery.proxy(function(){this._iLoadImageDensity=2;this._updateDomSrc(this._generateSrcByDensity(a,2));this._bVersion2Tried=true},this),0)}}};g.prototype.setDetailBox=function(t){var e=this.getDetailBox();if(t){if(t===e){return this}if(e){this.detachPress(this._fnLightBoxOpen,e)}this._fnLightBoxOpen=t.open;this.attachPress(this._fnLightBoxOpen,t)}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,e);this._fnLightBoxOpen=null}return this.setAggregation("detailBox",t)};g.prototype.setSrc=function(t){var e=this.getSrc(),i=this.setProperty("src",t);if(t&&e!==this.getSrc()&&this.getMode()===h.InlineSvg){t.endsWith("svg")&&this._loadSvg()}return i};g.prototype.clone=function(){var t=e.prototype.clone.apply(this,arguments),i=t.getDetailBox();if(i){t.detachPress(this._fnLightBoxOpen,this.getDetailBox());t._fnLightBoxOpen=i.open;t.attachPress(t._fnLightBoxOpen,i)}return t};g.prototype.onBeforeRendering=function(){this._defaultEventTriggered=false;if(this.getMode()==h.Image){var t=this.getDetailBox()?this.$().find(".sapMImg"):this.$();t.off("load").off("error")}if(this.getMode()===h.InlineSvg){this._loadSvg()}};g.prototype.onAfterRendering=function(){var t=this.getDetailBox()?this.$().find(".sapMImg"):this.$(),e=this.getMode(),i;if(e===h.Image){t.on("load",jQuery.proxy(this.onload,this));t.on("error",jQuery.proxy(this.onerror,this));i=t[0]}if(e===h.Background){i=this._oImage}if(i&&i.complete&&!this._defaultEventTriggered){if(n.browser.firefox&&this.getSrc().indexOf(".svg")>-1){return}if(i.naturalWidth>0){this.onload({})}else{this.onerror({})}}};g.prototype.exit=function(){if(this._oImage){jQuery(this._oImage).off("load",this.onload).off("error",this.onerror);this._oImage=null}else{this.$().off("load",this.onload).off("error",this.onerror)}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null}this._oSvgCachedData=null};g.prototype.ontouchstart=function(t){if(t.srcControl.mEventRegistry["press"]||t.srcControl.mEventRegistry["tap"]){t.setMarked()}if(t.targetTouches.length===1&&this.getActiveSrc()){this._updateDomSrc(this._getDensityAwareActiveSrc());this._isActiveState=true}};g.prototype.ontouchend=function(t){if(t.targetTouches.length===0&&this.getActiveSrc()){this._isActiveState=false;this._updateDomSrc(this._getDensityAwareSrc());this.$().removeClass("sapMNoImg")}};g.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);e.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button")}return this};g.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);e.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation")}else{this.$().removeAttr("role")}}return this};g.prototype.ontap=function(t){this.fireTap({});this.firePress({})};g.prototype.onkeyup=function(t){if(t.which===a.SPACE||t.which===a.ENTER){this.firePress({});t.stopPropagation()}};g.prototype.onsapspace=function(t){t.preventDefault()};g.prototype._loadSvg=function(){var t=this,e=this.getSrc(),i;if(!this._oSvgCachedData[e]){t._oSvgCachedData[e]={};jQuery.get(this.getSrc(),function(r){i=jQuery(r).find("svg")[0];if(i){sap.ui.require(["sap/m/_thirdparty/purify"],function(r){t._oSvgCachedData[e].oSvgDomRef=r.sanitize(i,{RETURN_DOM:true});t.invalidate()})}}).done(function(){t.fireLoad()}).fail(function(){t.fireError()})}};g.prototype._getSvgCachedData=function(){var t=this.getSrc();if(this._oSvgCachedData[t]&&typeof this._oSvgCachedData[t].oSvgDomRef==="object"){return this._oSvgCachedData[t].oSvgDomRef}};g.prototype._isHrefValid=function(t){return r.validate(t)};g.prototype._updateDomSrc=function(t){var e=this.$(),i=this.getMode();if(e.length){if(i===h.Image){this._getDomImg().attr("src",t)}else{e.addClass("sapMNoImg");jQuery(this._oImage).attr("src",t)}}};g.prototype._getDomImg=function(){var t=this.$();return this.getDetailBox()?t.children("img"):t};g.prototype._preLoadImage=function(t){if(this.getMode()!==h.Background){return}var e=jQuery(this._oImage);if(!this._oImage){this._oImage=new window.Image;e=jQuery(this._oImage);e.on("load",jQuery.proxy(this.onload,this)).on("error",jQuery.proxy(this.onerror,this))}this._oImage.src=t};g.prototype._isWidthOrHeightSet=function(){return this.getWidth()&&this.getWidth()!==""||this.getHeight()&&this.getHeight()!==""};g.prototype._getDensityAwareSrc=function(){var t=this.getSrc(),e=this.getDensityAware(),i=e?g._currentDevicePixelRatio:1;this._iLoadImageDensity=i;return this._generateSrcByDensity(t,i)};g.prototype._getDensityAwareActiveSrc=function(){var t=this.getActiveSrc(),e=this.getDensityAware(),i=e?g._currentDevicePixelRatio:1;this._iLoadImageDensity=i;return this._generateSrcByDensity(t,i)};g.prototype._generateSrcByDensity=function(t,e){if(!t){return""}if(this._isDataUri(t)){this._iLoadImageDensity=1;return t}if(e===1){return t}var i=t.lastIndexOf("."),r=t.lastIndexOf("/"),o=t.substring(0,i),a=t.substring(i);if(i===-1||r>i){return t+"@"+e}o=o+"@"+e;return o+a};g.prototype._isDataUri=function(t){return t?t.indexOf("data:")===0:false};g.prototype._isValidBackgroundSizeValue=function(t){t=l(t);return c(t.split(" "),["auto","cover","contain","initial"])||i.getType("sap.ui.core.CSSSizeShortHand").isValid(t)};g.prototype._isValidBackgroundPositionValue=function(t){t=l(t);return c(t.split(" "),["left","right","top","center","bottom","initial"])||i.getType("sap.ui.core.CSSSizeShortHand").isValid(t)};g.prototype.getAccessibilityInfo=function(){var t=this.hasListeners("press");if(this.getDecorative()&&!this.getUseMap()&&!t){return null}return{role:t?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(t?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||"",focusable:t}};g.prototype.getFocusDomRef=function(){return this.getDomRef("inner")||this.getDomRef()};g.prototype.getFormDoNotAdjustWidth=function(){return true};function c(t,e){function i(t){return e.indexOf(t)<0}return t&&e&&!t.some(i)}function l(t){var e=/\s+/g;return t==null?"":String(t).trim().replace(e," ")}return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ImageContent", ["./library","sap/ui/core/Control","sap/m/Image","sap/ui/core/IconPool","sap/ui/Device","./ImageContentRenderer","sap/ui/events/KeyCodes"],function(t,e,i,s,r,n,o){"use strict";var a=e.extend("sap.m.ImageContent",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},description:{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"_content",aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{}}},renderer:n});a.prototype.onBeforeRendering=function(){var t,e,r;t=this.getAggregation("_content");e=this.getSrc();r=this.getDescription();if(!t||e!==t.getSrc()||r!==t.getAlt()){if(t){t.destroy();t=null}t=s.createControlByURI({id:this.getId()+"-icon-image",src:e,alt:r,decorative:true},i);this.setAggregation("_content",t,true);this._setPointerOnImage()}if(r){this.setTooltip(r.trim())}};a.prototype._setPointerOnImage=function(){var t=this.getAggregation("_content");if(t&&this.hasListeners("press")){t.addStyleClass("sapMPointer")}else if(t&&t.hasStyleClass("sapMPointer")){t.removeStyleClass("sapMPointer")}};a.prototype.ontap=function(t){if(r.browser.msie){this.$().trigger("focus")}this.firePress()};a.prototype.onkeydown=function(t){if(t.which===o.ENTER||t.which===o.SPACE){this.firePress();t.preventDefault()}};a.prototype.attachEvent=function(t,i,s,r){e.prototype.attachEvent.call(this,t,i,s,r);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnImage()}return this};a.prototype.detachEvent=function(t,i,s){e.prototype.detachEvent.call(this,t,i,s);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnImage()}return this};a.prototype.getAltText=function(){var t=this.getAggregation("_content");if(t&&t.getAlt()!==""){return t.getAlt()}else if(t&&t.getAccessibilityInfo()){return t.getAccessibilityInfo().description}else{return""}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ImageContentRenderer", [],function(){"use strict";var t={apiVersion:2};t.render=function(t,e){t.openStart("div",e);t.class("sapMImageContent");var n=e.getTooltip_AsString();if(n){t.attr("title",n)}if(e.hasListeners("press")){t.class("sapMPointer");t.attr("tabindex","0")}t.openEnd();var a=e.getAggregation("_content");if(a){a.addStyleClass("sapMImageContentImageIcon");t.renderControl(a)}t.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ImageCustomData", ["sap/ui/core/CustomData"],function(a){"use strict";var t=a.extend("sap.m.ImageCustomData",{metadata:{properties:{paramName:{type:"string",group:"Misc"}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ImageHelper", ["sap/m/library","sap/base/strings/capitalize","sap/base/assert","sap/m/Image","sap/ui/core/Icon","sap/ui/core/IconPool"],function(e,r,t,a,n,s){"use strict";var i={};function o(e,t,a){if(a!==undefined){var n=e["set"+r(t)];if(typeof n==="function"){n.call(e,a);return true}}return false}i.getImageControl=function(e,r,i,c,f,l){t(c.src,"sap.m.ImageHelper.getImageControl: mProperties do not contain 'src'");if(r&&r.getSrc()!=c.src){r.destroy();r=undefined}if(r&&(r instanceof a||r instanceof n)){for(var u in c){o(r,u,c[u])}}else{var p=Object.assign({},c,{id:e});r=s.createControlByURI(p,a);r.setParent(i,null,true)}if(l){for(var g=0,d=l.length;g!==d;g++){r.removeStyleClass(l[g])}}if(f){for(var m=0,I=f.length;m!==I;m++){r.addStyleClass(f[m])}}return r};e.ImageHelper=i;return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ImageRenderer", ["sap/m/library","sap/base/security/encodeCSS","sap/ui/core/library"],function(e,t,a){"use strict";var i=e.ImageMode;var r=a.aria.HasPopup;var n={apiVersion:2};n.render=function(e,a){var n=a.getMode(),s=a.getAlt(),o=a.getTooltip_AsString(),l=a.hasListeners("press"),g=a.getDetailBox(),d=a.getUseMap(),c=a.getAriaLabelledBy(),p=a.getAriaDescribedBy(),f=a.getAriaDetails(),u=n===i.Image,h=n===i.InlineSvg,v=n===i.Background,S=a.getLazyLoading(),y=a.getAriaHasPopup();if(g){e.openStart("span",a);e.class("sapMLightBoxImage");e.openEnd();e.openStart("span").class("sapMLightBoxMagnifyingGlass").openEnd().close("span")}if(u){e.voidStart("img",!g?a:a.getId()+"-inner");if(S){e.attr("loading","lazy")}}else if(h){e.openStart("div",a)}else{e.openStart("span",!g?a:a.getId()+"-inner")}if(!a.getDecorative()){if(c&&c.length>0){e.attr("aria-labelledby",c.join(" "))}if(p&&p.length>0){e.attr("aria-describedby",p.join(" "))}if(f&&f.length>0){e.attr("aria-details",f.join(" "))}}if(u){e.attr("src",a._getDensityAwareSrc())}else if(v){a._preLoadImage(a._getDensityAwareSrc());if(a._isValidBackgroundSizeValue(a.getBackgroundSize())){e.style("background-size",a.getBackgroundSize())}if(a._isValidBackgroundPositionValue(a.getBackgroundPosition())){e.style("background-position",a.getBackgroundPosition())}e.style("background-repeat",t(a.getBackgroundRepeat()))}e.class("sapMImg");if(a.hasListeners("press")||a.hasListeners("tap")){e.class("sapMPointer")}if(d||!a.getDecorative()||l){e.class("sapMImgFocusable")}if(d){if(!d.startsWith("#")){d="#"+d}e.attr("usemap",d)}if(a.getDecorative()&&!d&&!l){e.attr("role","presentation");e.attr("aria-hidden","true");e.attr("alt","")}else if(s||o){e.attr("alt",s||o)}if(s||o){e.attr("aria-label",s||o)}if(o){e.attr("title",o)}if(y!==r.None){e.attr("aria-haspopup",y.toLowerCase())}if(l){e.attr("role","button");e.attr("tabindex",0)}e.style("width",a.getWidth());e.style("height",a.getHeight());if(u){e.voidEnd()}else if(h){e.openEnd();this._renderSvg(e,a);e.close("div")}else{e.openEnd().close("span")}if(g){e.close("span")}};n._renderSvg=function(e,t){var a=t._getSvgCachedData(),i;if(!a){return}i=a.children;this._renderSvgChildren(e,i,t)};n._renderSvgAttributes=function(e,t,a){for(var i=0;i<t.length;i++){var r=t[i],n=r.name.indexOf(":"),s=n<0?r.name:r.name.slice(n+1);if(s==="href"&&!a._isHrefValid(r.value)){continue}e.attr(s,r.value)}};n._renderSvgChildren=function(e,t,a){var i=[].slice.call(t).filter(function(e){return e.nodeType!==Node.TEXT_NODE||e.nodeType===Node.TEXT_NODE&&e.textContent.trim()!==""});i.forEach(function(t){var i=t.tagName,r=t.attributes,n=t.childNodes;if(t.nodeType!==Node.TEXT_NODE){e.openStart(i);this._renderSvgAttributes(e,r,a);e.openEnd();n.length&&this._renderSvgChildren(e,n,a);e.close(i)}else{t.textContent.length&&e.text(t.textContent.trim())}},this)};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Input", ["./InputBase","sap/ui/core/Element","sap/ui/core/Item","sap/ui/core/Core","sap/ui/core/LabelEnablement","sap/ui/core/AccessKeysEnablement","./ColumnListItem","./GroupHeaderListItem","sap/ui/core/SeparatorItem","./Table","./library","sap/ui/core/IconPool","sap/ui/Device","./SuggestionsPopover","./Toolbar","./ToolbarSpacer","./Button","sap/ui/core/ResizeHandler","sap/ui/dom/containsOrEquals","sap/base/assert","sap/base/util/deepEqual","sap/m/inputUtils/wordStartsWithValue","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/typeAhead","sap/ui/events/KeyCodes","sap/m/inputUtils/filterItems","sap/m/inputUtils/ListHelpers","sap/m/inputUtils/calculateSelectionStart","sap/m/inputUtils/selectionRange","./InputRenderer","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectObserver","sap/ui/core/Lib","sap/ui/dom/jquery/selectText"],function(e,t,s,i,o,n,u,r,a,g,l,p,h,c,f,d,S,_,y,m,v,I,T,b,P,V,w,R,A,C,D,F,L,M){"use strict";var H=l.ListType;var x=l.InputTextFormatMode;var O=l.InputType;var E=l.ListMode;var B=l.ListSeparators;var U=e.extend("sap.m.Input",{metadata:{interfaces:["sap.ui.core.IAccessKeySupport","sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:O.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:"YYYY-MM-dd",deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpIconSrc:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:"sap-icon://value-help"},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"50%"},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:x.Value},textFormatter:{type:"function",group:"Misc",defaultValue:null},suggestionRowValidator:{type:"function",group:"Misc",defaultValue:null},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true},enableTableAutoPopinMode:{type:"boolean",group:"Behavior",defaultValue:false},autocomplete:{type:"boolean",group:"Behavior",defaultValue:true},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"},separateSuggestions:{type:"boolean",defaultValue:true,visibility:"hidden"},highlightAccKeysRef:{type:"boolean",defaultValue:false,visibility:"hidden"},accesskey:{type:"string",defaultValue:"",visibility:"hidden"}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ITableItem",multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_suggestionPopup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"},renderer:D});p.insertFontFaceStyle();U._DEFAULTFILTER_TABULAR=function(e,t){var s=t.getCells(),i=0;for(;i<s.length;i++){if(s[i].getText){if(I(s[i].getText(),e)){return true}}}return false};U._DEFAULTRESULT_TABULAR=function(e){if(!e||e.isA("sap.m.GroupHeaderListItem")){return""}var t=e.getCells(),s=0;for(;s<t.length;s++){if(t[s].getText){return t[s].getText()}}return""};U.prototype.init=function(){e.prototype.init.call(this);this._iSetCount=0;this._sProposedItemText=null;this._oRb=M.getResourceBundleFor("sap.m");if(this.getId().indexOf("popup-input")===-1){this._createSuggestionsPopover()}this._setTypedInValue("");this._bDoTypeAhead=false;this._isValueInitial=false;this._previousInputType=this.getType();this._bClearButtonPressed=false;this._bAfterOpenFinisihed=false;n.registerControl(this)};var K=function(e){var t=o.getReferencingLabels(this);t.forEach(function(t){i.byId(t).setProperty("highlightAccKeysRef",e)},this)};U.prototype.getAccessKeysFocusTarget=function(){return this.getFocusDomRef()};U.prototype.onAccKeysHighlightStart=function(){K.call(this,true)};U.prototype.onAccKeysHighlightEnd=function(){K.call(this,false)};U.prototype.exit=function(){e.prototype.exit.call(this);this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=null}this._destroySuggestionsTable();if(this._getSuggestionsPopover()){this._oSuggestionPopup=null;this._oSuggPopover.destroy();this._oSuggPopover=null}this.$().off("click")};U.prototype.onBeforeRendering=function(){var t=this.getSelectedKey(),s=this.getShowValueHelp()&&this.getEnabled()&&this.getEditable(),i=this.getProperty("effectiveShowClearIcon")&&this.getEnabled()&&this.getEditable(),o=this._oValueHelpIcon,n=this._getSuggestionsPopover(),u=n&&this._isSuggestionsPopoverOpen(),r=n&&n.getInput(),a=u?n._getValueStateHeader().getText():null,g=u?n._getValueStateHeader().getValueState():"";e.prototype.onBeforeRendering.call(this);if(!this.getDomRef()&&this.getValue()){this._isValueInitial=true}if(this.getShowClearIcon()){this._getClearIcon().setProperty("visible",i)}else if(this._oClearButton){this._getClearIcon().setProperty("visible",false)}this._deregisterEvents();if(t&&!this.getSelectedItem()&&this.getSuggestionItemByKey(t)){this.setSelectedKey(t)}if(this.getShowSuggestion()){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton()}else{this._removeShowMoreButton()}if(r){r.setType(this.getType())}}if(s){o=this._getValueHelpIcon();o.setVisible(true)}else if(o){o.setVisible(false)}if(!this.getWidth()){this.setWidth("100%")}if(this._hasTabularSuggestions()){this._getSuggestionsTable().setAutoPopinMode(this.getEnableTableAutoPopinMode());this._getSuggestionsTable().setContextualWidth(this.getEnableTableAutoPopinMode()?"Auto":"Inherit")}if(u&&(this.getValueStateText()&&a!==this.getValueStateText()||this.getValueState()!==g||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState()}};U.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.call(this);if((this._isValueInitial||this.getType()!==this._previousInputType)&&this.getType()===O.Password){this.getDomRef("inner").value=this.getProperty("value");this._isValueInitial=false}this._previousInputType=this.getType()};U.prototype._getDisplayText=function(e){var t=this.getTextFormatter();if(t){return t(e)}var s=e.getText(),i=e.getKey(),o=this.getTextFormatMode();switch(o){case x.Key:return i;case x.ValueKey:return s+" ("+i+")";case x.KeyValue:return"("+i+") "+s;default:return s}};U.prototype._onValueUpdated=function(e){if(this._bSelectingItem||e===this._sSelectedValue){return}var t=this.getSelectedKey(),s,i=this._getSuggestionsPopover(),o=i&&i.getItemsContainer();if(!this._hasTabularSuggestions()&&t===""){return}if(this._hasTabularSuggestions()){s=this._getSuggestionsTable()&&!!this._getSuggestionsTable().getSelectedItem()}else{s=o&&!!o.getSelectedItem()}if(s){return}this.setProperty("selectedKey","",true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true)};U.prototype.setSelectionItem=function(e,t){this._bSelectingItem=true;if(!e){this.setAssociation("selectedItem",null,true);this.setValue("");return}var s=this._iSetCount,i;this.setAssociation("selectedItem",e,true);this.setProperty("selectedKey",e.getKey(),true);if(t){this.fireSuggestionItemSelected({selectedItem:e})}if(s!==this._iSetCount){i=this.getValue()}else{i=this._getDisplayText(e)}this._sSelectedValue=i;this.setSelectionUpdatedFromList(false);this.updateInputField(i);if(this.bIsDestroyed){return}if(!(this.isMobileDevice()&&this.isA("sap.m.MultiInput"))){this._closeSuggestionPopup()}this._bSelectingItem=false;this._resetTypeAhead()};U.prototype.addSuggestionRowGroup=function(e,t,s){t=t||new r({title:F.escapeSettingsValue(e.text)||F.escapeSettingsValue(e.key)});this._createSuggestionPopupContent(true);this.addAggregation("suggestionRows",t,s);return t};U.prototype.addSuggestionItemGroup=function(e,t,s){t=t||new a({text:F.escapeSettingsValue(e.text)||F.escapeSettingsValue(e.key)});this._createSuggestionPopupContent(false);this.addAggregation("suggestionItems",t,s);return t};U.prototype.setSelectedItem=function(e){if(typeof e==="string"){e=t.registry.get(e)}if(e!==null&&!(e instanceof s)){return this}this.setSelectionItem(e);return this};U.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);this.setProperty("selectedKey",e,true);if(this._hasTabularSuggestions()){return this}if(!e){this.setSelectionItem();return this}var t=this.getSuggestionItemByKey(e);this.setSelectionItem(t);return this};U.prototype.getSuggestionItemByKey=function(e){var t=this.getSuggestionItems()||[],s,i;for(i=0;i<t.length;i++){s=t[i];if(s.getKey()===e){return s}}};U.prototype._getFormattedValueStateText=function(){var t=this._isSuggestionsPopoverOpen(),s=t?this._getSuggestionsPopover()._getValueStateHeader().getFormattedText():null;if(t&&s){return s}else{return e.prototype.getFormattedValueStateText.call(this)}};U.prototype.setSelectionRow=function(e,t){if(!e){this.setAssociation("selectedRow",null,true);return}this._bSelectingItem=true;var i,o=this.getSuggestionRowValidator();if(o){i=o(e);if(!(i instanceof s)){i=null}}var n=this._iSetCount,u="",r;this.setAssociation("selectedRow",e,true);if(i){u=i.getKey()}this.setProperty("selectedKey",u,true);if(t){this.fireSuggestionItemSelected({selectedRow:e})}if(n!==this._iSetCount){r=this.getValue()}else{if(i){r=this._getDisplayText(i)}else{r=this._getRowResultFunction()(e)}}this._sSelectedValue=r;this.setSelectionUpdatedFromList(false);this.updateInputField(r);if(this.bIsDestroyed){return}if(!(this.isMobileDevice()&&this.isA("sap.m.MultiInput")&&this._isMultiLineMode)){this._closeSuggestionPopup()}this._bSelectingItem=false;this._resetTypeAhead()};U.prototype.setSelectedRow=function(e){if(typeof e==="string"){e=t.registry.get(e)}if(e!==null&&!(e instanceof u)){return this}this.setSelectionRow(e);return this};U.prototype._getValueHelpIcon=function(){var e=this,t=this.getValueHelpIconSrc();if(!this._oValueHelpIcon){this._oValueHelpIcon=this.addEndIcon({id:this.getId()+"-vhi",src:t,useIconTooltip:false,alt:this._oRb.getText("INPUT_VALUEHELP_BUTTON"),decorative:false,noTabStop:true,press:function(t){if(e.getValueHelpOnly()){return}var s=this.getParent(),i;if(h.support.touch){i=s.$("inner");i.attr("readonly","readonly");s.focus();i.removeAttr("readonly")}else{s.focus()}e.bValueHelpRequested=true;e._fireValueHelpRequest(false)}})}else if(this._oValueHelpIcon.getSrc()!==t){this._oValueHelpIcon.setSrc(t)}return this._oValueHelpIcon};U.prototype._getClearIcon=function(){var e=this;if(this._oClearButton){return this._oClearButton}this._oClearButton=this.addEndIcon({src:p.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:function(){if(e.getValue()!==""){e.setValue("");e.fireChange({value:""});e.fireLiveChange({value:""});e._bClearButtonPressed=true;setTimeout(function(){if(h.system.desktop){e.focus();e._closeSuggestionPopup()}},0)}}},0);return this._oClearButton};U.prototype._fireValueHelpRequest=function(e){var t="";if(this.getShowSuggestion()&&!this.isMobileDevice()){t=this._getTypedInValue()||""}else{t=this.getDOMValue()}this.fireValueHelpRequest({fromSuggestions:e,_userInputValue:t})};U.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){if(h.system.phone){this.focus()}this._fireValueHelpRequest(false)}};U.prototype.ontap=function(t){e.prototype.ontap.call(this,t);if(this.isValueHelpOnlyOpener(t.target)){this._fireValueHelpRequestForValueHelpOnly()}if(this.shouldSuggetionsPopoverOpenOnMobile(t)){this._openSuggestionsPopover()}this._bClearButtonPressed=false};U.prototype.shouldSuggetionsPopoverOpenOnMobile=function(e){return this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&!this._bClearButtonPressed&&e.target.id!==this.getId()+"-vhi"};U.prototype.setFilterFunction=function(e){if(e===null||e===undefined){this._fnFilter=T;return this}m(typeof e==="function","Input.setFilterFunction: first argument fnFilter must be a function on "+this);this._fnFilter=e;return this};U.prototype._getFilterFunction=function(e){if(typeof this._fnFilter==="function"&&!e){return this._fnFilter}return!this._hasTabularSuggestions()?T:U._DEFAULTFILTER_TABULAR};U.prototype.setRowResultFunction=function(e){var t;if(e===null||e===undefined){this._fnRowResultFilter=U._DEFAULTRESULT_TABULAR;return this}m(typeof e==="function","Input.setRowResultFunction: first argument fnFilter must be a function on "+this);this._fnRowResultFilter=e;t=this.getSelectedRow();if(t){this.setSelectedRow(t)}return this};U.prototype._getRowResultFunction=function(e){if(typeof this._fnRowResultFilter==="function"&&!e){return this._fnRowResultFilter}return U._DEFAULTRESULT_TABULAR};U.prototype.closeSuggestions=function(){this._closeSuggestionPopup()};U.prototype._doSelect=function(e,t){var s=this._$input[0];if(s){var i=this._$input;s.focus();i.selectText(e?e:0,t?t:i.val().length)}return this};U.prototype._isIncrementalType=function(){var e=this.getType();if(e==="Number"||e==="Date"||e==="Datetime"||e==="Month"||e==="Time"||e==="Week"){return true}return false};U.prototype.onsapescape=function(t){if(this._isSuggestionsPopoverOpen()){t.originalEvent._sapui_handledByControl=true;this._revertPopupSelection();if(this._getTypedInValue()!==this.getValue()){this.setValue(this._getTypedInValue())}return}if(this.getValueLiveUpdate()){this.setProperty("value",this.getLastValue(),true)}if(e.prototype.onsapescape){e.prototype.onsapescape.apply(this,arguments)}};U.prototype.onsapenter=function(t){const s=this._isSuggestionsPopoverOpen();const i=!this.hasStyleClass("sapMFocus")&&s;const o=this._hasTabularSuggestions()?this.getSuggestionRows():this.getSuggestionItems();const n=this._getSuggestionsPopover();const u=n?.getItemsContainer()?.getSelectedItem();const r=u?.getTitle?.()||u?.getCells?.()[0]?.getText?.()||"";const a=!!this._iSuggestDelay&&!r.toLowerCase().includes(this._getTypedInValue().toLowerCase());let g=this.getEnabled()&&this.getEditable();let l;this.cancelPendingSuggest();i&&this.setSelectionUpdatedFromList(true);if(this.getShowSuggestion()&&this._bDoTypeAhead&&s&&!this.isComposingCharacter()&&!a){if(this._hasTabularSuggestions()){u&&this.setSelectionRow(u,true)}else{u&&this.setSelectionItem(R.getItemByListItem(o,u),true)}}if(s&&!this.isComposingCharacter()){this._closeSuggestionPopup();l=this.getDOMValue()?this.getDOMValue().length:null;this.selectText(l,l)}!i&&e.prototype.onsapenter.apply(this,arguments);g=g&&!(this.getShowValueHelp()&&this.getValueHelpOnly());if(g){this.fireSubmit({value:this.getValue()})}if(!this.isMobileDevice()){this._resetTypeAhead()}};U.prototype.onsapfocusleave=function(s){var i=this._getSuggestionsPopover(),o=i&&i.getPopover(),n=o&&o.isA("sap.m.Popover"),u=s.relatedControlId&&t.registry.get(s.relatedControlId),r=u&&u.getFocusDomRef(),a=o&&r&&y(o.getDomRef(),r);if(n){if(a&&!i.getValueStateActiveState()){this._bPopupHasFocus=true;if(h.system.desktop&&v(o.getFocusDomRef(),r)||u.isA("sap.m.GroupHeaderListItem")){this.focus()}}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null}}}if(!a){e.prototype.onsapfocusleave.apply(this,arguments)}this.bValueHelpRequested=false;if(!this._getProposedItemText()||this.isMobileDevice()){return}if(this.getShowSuggestion()&&this._bAfterOpenFinisihed){this.setSelectionUpdatedFromList(true)}else{var g=this.getSuggestionItems().filter(function(e){return e.getText()===this._getProposedItemText()}.bind(this))[0];if(g){this.setSelectionItem(g,true);this.selectText(0,0)}}};U.prototype.onmousedown=function(e){if(this._isSuggestionsPopoverOpen()){e.stopPropagation()}};["onsapup","onsapdown","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(e){U.prototype[e]=function(t){if((e==="onsapup"||e==="onsapdown")&&this.isComposingCharacter()){return}if(this.getShowSuggestion()){this._getSuggestionsPopover().handleListNavigation(this,t);if(this._isIncrementalType()){t.setMarked()}this.setSelectionUpdatedFromList(true)}}});U.prototype.setSelectionUpdatedFromList=function(e){this._bSelectionUpdatedFromList=e};U.prototype.getSelectionUpdatedFromList=function(){return this._bSelectionUpdatedFromList};U.prototype.updateSelectionFromList=function(e){if(this._hasTabularSuggestions()&&this.getSelectedRow()!==e){this.setSelectionRow(e,true)}else{var t=R.getItemByListItem(this.getSuggestionItems(),e);t&&this.getSelectedItem()!==t.getId()&&this.setSelectionItem(t,true)}this.setSelectionUpdatedFromList(false)};U.prototype._deregisterEvents=function(){this._deregisterPopupResize();if(this.isMobileDevice()&&this._getSuggestionsPopover()&&this._getSuggestionsPopover().getPopover()){this.$().off("click")}};U.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this};U.prototype.invalidate=function(){if(!this._bSuspendInvalidate){e.prototype.invalidate.apply(this,arguments)}};U.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay);this._iSuggestDelay=null}};U.prototype._triggerSuggest=function(e){var t=this._getSuggestionsPopover().getItemsContainer();this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!e){e=""}if(e.length>=this.getStartSuggestion()){this._iSuggestDelay=setTimeout(function(){if(this._sPrevSuggValue!==e){this._bBindingUpdated=false;this.fireSuggest({suggestValue:e});if(!this._bBindingUpdated){this._refreshItemsDelayed()}this._sPrevSuggValue=e}}.bind(this),300)}else if(this.isMobileDevice()){if(t instanceof g){t.addStyleClass("sapMInputSuggestionTableHidden")}else if(t&&t.destroyItems){t.destroyItems()}}else if(this._isSuggestionsPopoverOpen()){setTimeout(function(){var e=this.getDOMValue()||"";if(e.length<this.getStartSuggestion()){this._closeSuggestionPopup()}}.bind(this),0)}};U.prototype._shouldTriggerSuggest=function(){return!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()&&this.getShowSuggestion()};U.prototype.onchange=function(e){if(this.getShowValueHelp()||this.getShowSuggestion()||this.getProperty("effectiveShowClearIcon")){return}this.onChange(e)};U.prototype.oninput=function(t){e.prototype.oninput.call(this,t);if(t.isMarked("invalid")){return}var s=this.getDOMValue(),i,o,n;if(this.getValueLiveUpdate()){this.setProperty("value",s,true)}this.fireLiveChange({value:s,newValue:s});this.addStyleClass("sapMFocus");if(this.getShowSuggestion()&&!this.isMobileDevice()){i=this._getSuggestionsPopover();o=i.getItemsContainer();this._triggerSuggest(s);if(o&&!i.getValueStateActiveState()){n=o&&o.getSelectedItem();o.removeStyleClass("sapMListFocus");n&&n.removeStyleClass("sapMLIBFocused")}else if(i.getValueStateActiveState()&&document.activeElement.tagName!=="A"){i._getValueStateHeader().removeStyleClass("sapMPseudoFocus")}}this._handleTypeAhead(this)};U.prototype.onkeydown=function(e){this._bDoTypeAhead=!h.os.android&&this.getAutocomplete()&&e.which!==V.BACKSPACE&&e.which!==V.DELETE};U.prototype.onkeyup=function(e){var t=this.getValue();var s=this.getLastValue();var i=e.which===V.ARROW_DOWN||e.which===V.ARROW_UP;var o,n,u;if(!this._bDoTypeAhead&&!t){this.getShowSuggestion()&&this.setSelectedKey(null);s!==t&&this.setLastValue(s)}else if(!this._bDoTypeAhead&&!i&&t){o=this.getShowSuggestion()&&this._getSuggestionsPopover();n=o&&o.getItemsContainer();u=n&&n.getSelectedItem();this._setProposedItemText(null);if(u){u.setSelected(false)}}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!t)};U.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value")};U.prototype._refreshItemsDelayed=function(){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=setTimeout(this._refreshListItems.bind(this),0)};U.prototype._clearSuggestionPopupItems=function(){var e=this._getSuggestionsPopover().getItemsContainer();if(!e){return}if(e instanceof g){e.removeSelections(true)}else{e.destroyItems()}};U.prototype._hideSuggestionPopup=function(){var e=this._getSuggestionsPopover(),t=e.getPopover(),s=e.getItemsContainer();if(!this.isMobileDevice()){if(this._isSuggestionsPopoverOpen()){this._sCloseTimer=setTimeout(function(){this.cancelPendingSuggest();if(this._getTypedInValue()){this.setDOMValue(this._getTypedInValue())}t.close()}.bind(this),0)}}else if(this._hasTabularSuggestions()&&s){s.addStyleClass("sapMInputSuggestionTableHidden")}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant")};U.prototype._openSuggestionPopup=function(e){if(!this.isMobileDevice()){if(this._sCloseTimer){clearTimeout(this._sCloseTimer);this._sCloseTimer=null}if(!this._isSuggestionsPopoverOpen()&&!this._sOpenTimer&&e!==false&&this.getShowSuggestion()){this._sOpenTimer=setTimeout(function(){this._sOpenTimer=null;this._getSuggestionsPopover()&&this._openSuggestionsPopover()}.bind(this),0)}}};U.prototype._applySuggestionAcc=function(e){var t="",s=this._oRb;setTimeout(function(){if(!this.getSuggestionItems().length&&!this._hasTabularSuggestions()){return this.$("SuggDescr").text("")}if(e===1){t=s.getText("INPUT_SUGGESTIONS_ONE_HIT")}else if(e>1){t=s.getText("INPUT_SUGGESTIONS_MORE_HITS",[e])}else{t=s.getText("INPUT_SUGGESTIONS_NO_HIT")}this.$("SuggDescr").text(t)}.bind(this),0)};U.prototype._refreshListItems=function(){var e=this.getShowSuggestion(),t=this._bDoTypeAhead?this._getTypedInValue():this.getDOMValue()||"",s,i;if(!e||!this._bShouldRefreshListItems||!this.getDomRef()||!this.isMobileDevice()&&!this.$().hasClass("sapMInputFocused")){return null}this._clearSuggestionPopupItems();if(t.length<this.getStartSuggestion()){this._hideSuggestionPopup();return false}s=this._getFilteredSuggestionItems(t);i=s.items.length;var o=i>0;o=o&&!this.getValueHelpOnly();if(o){this._openSuggestionPopup(this.getValue().length>=this.getStartSuggestion())}else{this._hideSuggestionPopup()}this._applySuggestionAcc(i)};U.prototype.addSuggestionItem=function(e){this.addAggregation("suggestionItems",e,true);this._synchronizeSuggestions();this._createSuggestionPopupContent();return this};U.prototype.updateSuggestionRows=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionRows");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this};U.prototype.insertSuggestionItem=function(e,t){this.insertAggregation("suggestionItems",t,e,true);this._synchronizeSuggestions();this._createSuggestionPopupContent();return this};U.prototype.removeSuggestionItem=function(e){var t=this.removeAggregation("suggestionItems",e,true);this._synchronizeSuggestions();return t};U.prototype.removeAllSuggestionItems=function(){var e=this.removeAllAggregation("suggestionItems",true);this._synchronizeSuggestions();return e};U.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._synchronizeSuggestions();return this};U.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){this._createSuggestionPopupContent(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true}return e.prototype.bindAggregation.apply(this,arguments)};U.prototype._closeSuggestionPopup=function(){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._isSuggestionsPopoverOpen()&&this._getSuggestionsPopover().getPopover().close();if(!this.isMobileDevice()&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage()}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null};U.prototype._synchronizeSuggestions=function(){var e=this._getSuggestionsPopover(),t=e&&e.getInput(),s=t&&t.getFocusDomRef();if(document.activeElement===this.getFocusDomRef()||document.activeElement===s){this._bShouldRefreshListItems=true;this._refreshItemsDelayed()}if(!this.getDomRef()||this._isSuggestionsPopoverOpen()){return}this._synchronizeSelection()};U.prototype._synchronizeSelection=function(){var e=this.getSelectedKey();if(!e){return}if(this.getValue()&&!this.getSelectedItem()&&!this.getSelectedRow()){return}this.setSelectedKey(e)};U.prototype.onfocusin=function(t){e.prototype.onfocusin.apply(this,arguments);this.addStyleClass("sapMInputFocused");if(!this.isMobileDevice()&&this._isSuggestionsPopoverOpen()){this.closeValueStateMessage()}if(this._shouldTriggerSuggest()){this._triggerSuggest(this.getValue())}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null};U.prototype.oncompositionend=function(t){e.prototype.oncompositionend.apply(this,arguments);if(!h.browser.firefox){this._handleTypeAhead(this)}};U.prototype._getEffectiveTypeAhead=function(){var e=this._getSuggestionsPopover();var t=e&&e.getInput();if(!this.isMobileDevice()||this._bDoTypeAhead!==null){return this._bDoTypeAhead&&document.activeElement===this.getFocusDomRef()}return t._bDoTypeAhead&&(!!t&&document.activeElement===t.getFocusDomRef())};U.prototype._handleTypeAhead=function(e){var t=this.getValue();var s=e.getFocusDomRef();var i={value:"",selectedItem:null};var o;var n=e._getSuggestionsPopover()&&e._getSuggestionsPopover().getItemsContainer();var u=this._getEffectiveTypeAhead();if(s.selectionStart!==s.selectionEnd){this._setTypedInValue(s.value.substring(0,s.selectionStart))}else{this._setTypedInValue(s.value)}if((e&&e.getValue().toLowerCase())===(this._getProposedItemText()&&this._getProposedItemText().toLowerCase())){return}e._setProposedItemText(null);if(!u){return}var r=e._hasTabularSuggestions(),a=r?e.getSuggestionRows():e.getSuggestionItems(),g=function(t){if(!t){return""}return r?e._getRowResultFunction()(t):t.getText()};if(this.isMobileDevice()&&n&&!a.length){o={onBeforeRendering:function(){if(n.getItems().length){this._handleTypeAhead(e)}},onAfterRendering:function(){if(n.getItems().length){n.removeDelegate(o)}}};n.addDelegate(o,this);return}var l=P(t,this,a,function(e){return this._formatTypedAheadValue(g(e))}.bind(this));i.value=g(l[0]);i.selectedItem=l[0];e._setProposedItemText(i.value);this._mTypeAheadInfo=i;return i};U.prototype._resetTypeAhead=function(e){e=e||this;e._setProposedItemText(null);this._setTypedInValue("")};U.prototype.onsapright=function(){var e=this.getValue(),t=this.getFocusDomRef();if(!this.getAutocomplete()){return}if(this._getTypedInValue()!==e){this._setTypedInValue(t.value.substring(0,t.selectionStart));this.fireLiveChange({value:e,newValue:e})}};U.prototype._formatTypedAheadValue=function(e){var t=this._getTypedInValue();if(e.toLowerCase().indexOf(t.toLowerCase())===0){return t.concat(e.substring(t.length,e.length))}else{return e}};U.prototype.onsapshow=function(e){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return}this.bValueHelpRequested=true;this._fireValueHelpRequest(false);e.preventDefault();e.stopPropagation()};U.prototype.onsaphide=U.prototype.onsapshow;U.prototype.onsapselect=function(e){this._fireValueHelpRequestForValueHelpOnly()};U.prototype.onfocusout=function(t){e.prototype.onfocusout.apply(this,arguments);this.removeStyleClass("sapMInputFocused");this.$("SuggDescr").text("")};U.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length)};U.prototype._getSuggestionsTable=function(){if(this._bIsBeingDestroyed){return null}if(!this._oSuggestionsTable){this._oSuggestionsTable=this._createSuggestionsTable()}return this._oSuggestionsTable};U.prototype._destroySuggestionsTable=function(){if(this._oSuggestionsTable){this._oSuggestionsTable.destroy();this._oSuggestionsTable=null}};U.prototype._createSuggestionsTable=function(){var e;var t=new g(this.getId()+"-popup-table",{mode:E.SingleSelectMaster,showNoData:false,showSeparators:this.getProperty("separateSuggestions")?B.Inner:B.None,width:"100%",enableBusyIndicator:false,rememberSelections:false,itemPress:function(e){if(h.system.desktop){this.focus()}var t=e.getParameter("listItem");this.setSelectionRow(t,true)}.bind(this),sticky:[l.Sticky.ColumnHeaders]});t.addEventDelegate({onAfterRendering:function(){var e;if(!this.getEnableSuggestionsHighlighting()){return}e=t.$().find("tbody .sapMText, tbody .sapMLabel");b(e,this._getTypedInValue())}},this);if(this.isMobileDevice()){t.addStyleClass("sapMInputSuggestionTableHidden")}t.updateItems=function(){g.prototype.updateItems.apply(this,arguments);this._refreshItemsDelayed();return this};e=new L(function(e){var t=e.mutation;var s=e.child;var i=e.name==="items";switch(t){case"insert":if(i){s.setType(H.Active);this._createSuggestionPopupContent(true);this._synchronizeSuggestions()}break;case"remove":if(i){this._synchronizeSuggestions()}break;default:break}}.bind(this));e.observe(t,{aggregations:["items","columns"]});return t};U.prototype.clone=function(){var t=e.prototype.clone.apply(this,arguments);t.setRowResultFunction(this._fnRowResultFilter);t.setValue(this.getValue());return t};U.prototype.setValue=function(t){this._iSetCount++;e.prototype.setValue.call(this,t);this._onValueUpdated(t);this._setTypedInValue("");this.setProperty("effectiveShowClearIcon",!!t);return this};U.prototype.setDOMValue=function(e){this._$input.val(e)};U.prototype.getDOMValue=function(){return this._$input.val()};U.prototype._getInputValue=function(){var t=e.prototype._getInputValue.apply(this,arguments);return t};U.prototype.updateInputField=function(e){if(this._isSuggestionsPopoverOpen()&&this.isMobileDevice()){this._getSuggestionsPopover().getInput().setValue(e)._doSelect()}else{e=this._getInputValue(e);this.setDOMValue(e);this.onChange(null,null,e)}};U.prototype.getAccessibilityInfo=function(){var t=e.prototype.getAccessibilityInfo.apply(this,arguments);t.description=((t.description||"")+" "+this.getDescription()).trim();return t};U.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering||this.bValueHelpRequested};U.prototype._getShowMoreButton=function(){return this._getSuggestionsPopover().getShowMoreButton()};U.prototype._getShowMoreButtonPress=function(){var e,t=this._getTypedInValue();if(this.getShowTableSuggestionValueHelp()){if(t){e=t;this.updateDomValue(e);this._resetTypeAhead();this._setTypedInValue(e)}this._fireValueHelpRequest(true);this._closeSuggestionPopup()}};U.prototype._addShowMoreButton=function(){var e=this._getSuggestionsPopover();var t=e&&e.getPopover();if(!t||!this._hasTabularSuggestions()||this._getShowMoreButton()){return}var s=new S({text:this._oRb.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:this._getShowMoreButtonPress.bind(this)});if(t.isA("sap.m.Dialog")){e.setShowMoreButton(s)}else{e.setShowMoreButton(new f({content:[new d,s]}))}};U.prototype._removeShowMoreButton=function(){var e=this._getSuggestionsPopover();var t=e&&e.getPopover();if(t&&this._hasTabularSuggestions()&&this._getShowMoreButton()){e.removeShowMoreButton()}};U.prototype._hasShowSelectedButton=function(){return false};U.prototype._createSuggestionPopupContent=function(e){var t=this._getSuggestionsPopover();var s=t.getItemsContainer();if(s&&(s.isA("sap.m.Table")&&!e||s.isA("sap.m.List")&&e)){s.destroy();s=null;this._destroySuggestionsTable()}if(this._bIsBeingDestroyed||!t||s){return}t.initContent(this.getId(),e?this._getSuggestionsTable():null);if(!this._hasTabularSuggestions()&&!e){this._decorateSuggestionsPopoverList(t.getItemsContainer())}else{this._decorateSuggestionsPopoverTable()}};U.prototype._decorateSuggestionsPopoverList=function(e){if(!e||!e.isA("sap.m.List")){return}e.addEventDelegate({onAfterRendering:function(){var t,s;if(!this.getEnableSuggestionsHighlighting()){return}t=e.$().find(".sapMSLIInfo [id$=-infoText], .sapMSLITitleOnly [id$=-titleText]");s=this._bDoTypeAhead?this._getTypedInValue():this.getValue();s=(s||"").toLowerCase();b(t,s)}},this);e.attachItemPress(function(e){if(h.system.desktop){this.focus()}var t=e.getParameter("listItem");if(!t.isA("sap.m.GroupHeaderListItem")){this.setSelectionItem(R.getItemByListItem(this.getSuggestionItems(),t),true)}},this)};U.prototype._decorateSuggestionsPopoverTable=function(){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton()}};U.prototype._decoratePopupInput=function(e){if(!e){return}e.setValueLiveUpdate(true);e.setValueState(this.getValueState());e.setShowValueHelp(this.getShowValueHelp());e.attachValueHelpRequest(function(){this.fireValueHelpRequest({fromSuggestions:true});this._getSuggestionsPopover().iPopupListSelectedIndex=-1;this._closeSuggestionPopup()}.bind(this));e.attachLiveChange(function(e){var t=e.getParameter("newValue");this.setDOMValue(this._getInputValue(this._getSuggestionsPopover().getInput().getValue()));this._triggerSuggest(t);this.fireLiveChange({value:t,newValue:t})}.bind(this));e._handleTypeAhead=function(){U.prototype._handleTypeAhead.call(e,this)}.bind(this);e._resetTypeAhead=function(){U.prototype._resetTypeAhead.call(e,this)}.bind(this);e.addEventDelegate({onsapenter:function(){this.setValue(this._getProposedItemText())}},this);return e};U.prototype.forwardEventHandlersToSuggPopover=function(e){e.setOkPressHandler(this._closeSuggestionPopup.bind(this));e.setCancelPressHandler(this._revertPopupSelection.bind(this))};U.prototype._revertPopupSelection=function(){var e=this._getSuggestionsPopover(),t=e&&e.getInput();this._setProposedItemText(null);this.setSelectionUpdatedFromList(false);if(this.isMobileDevice()){t&&t.setDOMValue(this.getLastValue())}this._closeSuggestionPopup()};U.prototype._getSuggestionsPopover=function(){return this._oSuggPopover};U.prototype._createSuggestionsPopover=function(){var e=this._oSuggPopover=new c(this);e.decorateParent(this);e.setInputLabels(this.getLabels.bind(this));this._createSuggestionsPopoverPopup();this.forwardEventHandlersToSuggPopover(e);e.attachEvent(c.M_EVENTS.SELECTION_CHANGE,function(e){var t=e.getParameter("newItem"),s=this.calculateNewValue(t),i=t&&t.isA("sap.m.GroupHeaderListItem"),o=this.getFocusDomRef(),n=o&&o.value.substring(0,o.selectionStart),u=e.getParameter("previousItem"),r=u&&u.isA("sap.m.GroupHeaderListItem"),a=A(C(o,r),s,n,r);if(!t||i){this.setDOMValue(n)}else{this.setDOMValue(s);a=a===0&&s.indexOf(n)===0?n.length:a;this._doSelect(a)}this._sSelectedSuggViaKeyboard=s},this);if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton()}return this._oSuggPopover};U.prototype.calculateNewValue=function(e){if(!e||e&&e.isA("sap.m.GroupHeaderListItem")){return""}if(e.isA("sap.m.ColumnListItem")){return this._getInputValue(this._getRowResultFunction()(e))}if(e.isA("sap.m.StandardListItem")){return this._getInputValue(e.getTitle())}};U.prototype._createSuggestionsPopoverPopup=function(){var e=this._getSuggestionsPopover();var t;e.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()},U);this._decoratePopupInput(e.getInput());t=e.getPopover();t.attachBeforeOpen(function(){this._updateSuggestionsPopoverValueState()},this);t.attachBeforeClose(function(){this._updateSuggestionsPopoverValueState()},this);t.attachAfterOpen(function(){var e;var t=this.getShowSuggestion()&&this._getSuggestionsPopover();var s=t&&t.getItemsContainer();var i;e=this._handleTypeAhead(this);if(!(this._getProposedItemText()&&s&&!s.getSelectedItem()&&e&&e.selectedItem)){return}i=this._hasTabularSuggestions()?e.selectedItem:R.getListItem(e.selectedItem);i.setSelected(true);this.setSelectionUpdatedFromList(true)},this);if(this.isMobileDevice()){t.attachBeforeClose(function(){this.setDOMValue(this._getInputValue(e.getInput().getValue()));this.onChange()},this).attachAfterClose(function(){var t=e.getItemsContainer();if(!t){return}var s=t&&t.getSelectedItem();if(this._getProposedItemText()&&s){this.setSelectionUpdatedFromList(true)}if(this.getSelectionUpdatedFromList()){this.updateSelectionFromList(s)}if(g&&!(t instanceof g)){t.destroyItems()}else{t.removeSelections(true)}},this).attachAfterOpen(function(){this._triggerSuggest(this.getValue());this._refreshListItems()},this).attachBeforeOpen(function(){var t=e.getInput();["placeholder","maxLength","value","showClearIcon","effectiveShowClearIcon"].forEach(function(e){t.setProperty(e,this.getProperty(e))},this)},this)}else{t.attachAfterClose(function(){const t=e.getItemsContainer();const s=this._getSuggestionsPopover();const i=s?.getItemsContainer()?.getSelectedItem();const o=this.getDomRef();const n=i?.getTitle?.()||i?.getCells?.()[0]?.getText?.()||"";const u=!!this._iSuggestDelay&&!n.toLowerCase().includes(this.getValue().toLowerCase());if(u){return}if(this.getSelectionUpdatedFromList()){this.updateSelectionFromList(i)}if(!t){return}this._bAfterOpenFinisihed=false;if(t instanceof g){i?.removeStyleClass("sapMLIBFocused");t.removeSelections(true)}else{t.destroyItems()}this._deregisterPopupResize();if(o&&o.contains(document.activeElement)){this.addStyleClass("sapMFocus")}},this).attachBeforeOpen(function(){e._sPopoverContentWidth=this.getMaxSuggestionWidth();e.resizePopup(this);this._registerPopupResize();this._bAfterOpenFinisihed=false},this);t.addEventDelegate({onAfterRendering:function(){var t=this.getDomRef().getBoundingClientRect().width;var s=getComputedStyle(this.getDomRef()).getPropertyValue("--sPopoverMaxWidth");this._bAfterOpenFinisihed=true;if(this.getMaxSuggestionWidth()){return}if(t<=parseInt(s)&&!h.system.phone){e.getPopover().addStyleClass("sapMSuggestionPopoverDefaultWidth")}else{e.getPopover().getDomRef().style.setProperty("max-width",t+"px");e.getPopover().addStyleClass("sapMSuggestionPopoverInputWidth")}e.getPopover().getDomRef().style.setProperty("min-width",t+"px")}},this)}this.setAggregation("_suggestionPopup",t);this._oSuggestionPopup=t};U.prototype._registerPopupResize=function(){var e=this._getSuggestionsPopover();this._sPopupResizeHandler=_.register(this,e.resizePopup.bind(e,this))};U.prototype._deregisterPopupResize=function(){if(this._sPopupResizeHandler){this._sPopupResizeHandler=_.deregister(this._sPopupResizeHandler)}};U.prototype.showItems=function(e){var t,s,i=this._getFilterFunction(),o=!this.getEnabled()||!this.getEditable();o=o||this.getValueHelpOnly();if(o){return}this.setFilterFunction(e||function(){return true});this._clearSuggestionPopupItems();t=this._getFilteredSuggestionItems(this.getDOMValue());s=t.items.length;if(s>0){this._openSuggestionPopup()}else{this._hideSuggestionPopup()}this._applySuggestionAcc(s);this.setFilterFunction(i)};U.prototype.shouldValueStateMessageBeOpened=function(){var t=e.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);if(!t||this._isSuggestionsPopoverOpen()){return false}return true};U.prototype._isSuggestionsPopoverOpen=function(){return this._getSuggestionsPopover()&&this._getSuggestionsPopover().isOpen()};U.prototype.isMobileDevice=function(){return h.system.phone};U.prototype._openSuggestionsPopover=function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState();this._getSuggestionsPopover().getPopover().open()};U.prototype._updateSuggestionsPopoverValueState=function(){var e=this._getSuggestionsPopover(),t=this.getValueState(),s=this.getValueState()!==e._getValueStateHeader().getValueState(),i=this.getFormattedValueStateText(),o=this.getValueStateText();if(!e){return}if(this._isSuggestionsPopoverOpen()&&!i&&!s){this.setFormattedValueStateText(e._getValueStateHeader().getFormattedText())}e.updateValueState(t,i||o,this.getShowValueStateMessage());if(this.isMobileDevice()){e.getInput().setValueState(t)}};U.prototype.setShowValueHelp=function(e){var t=this._getSuggestionsPopover()&&this._getSuggestionsPopover().getInput();this.setProperty("showValueHelp",e);if(t){t.setShowValueHelp(e)}return this};U.prototype.isValueHelpOnlyOpener=function(e){return true};U.prototype._getFilteredSuggestionItems=function(e){var t,s=this._getSuggestionsPopover(),i=s.getItemsContainer(),o=s&&s.getInput(),n=false;if(this.isMobileDevice()){n=!o._getProposedItemText()&&!o._mTypeAheadInfo||o._mTypeAheadInfo&&!o._mTypeAheadInfo.value}else{n=this._getProposedItemText()&&!this._mTypeAheadInfo||this._mTypeAheadInfo&&!this._mTypeAheadInfo.value}if(n){this._handleTypeAhead(this)}if(this._hasTabularSuggestions()){if(this.isMobileDevice()&&i){i.removeStyleClass("sapMInputSuggestionTableHidden")}t=this.filterTabularItems(this.getSuggestionRows(),e)}else{t=w(this,this.getSuggestionItems(),e,this.getFilterSuggests(),true,this._getFilterFunction());this._mapItems(t)}return t};U.prototype.filterTabularItems=function(e,t){var s,i=this.getFilterSuggests(),o=[],n=[],u=false,r=this._getFilterFunction();e.forEach(function(e){if(e.isA("sap.m.GroupHeaderListItem")){n.push({header:e,visible:false})}else{s=!i||r(t,e);e.setVisible(s);s&&o.push(e);if(!u&&s&&this._getProposedItemText()===this._getRowResultFunction()(e)){e.setSelected(true);u=true}if(n.length&&s){n[n.length-1].visible=true}}},this);n.forEach(function(e){e.header.setVisible(e.visible)});this._getSuggestionsTable().invalidate();return{items:o,groups:n}};U.prototype._mapItems=function(e){var t=this.getSuggestionItems(),s=e.items,i=e.groups,o=i.map(function(e){return e.header}),n=false,u=this._getSuggestionsPopover().getItemsContainer(),r,a;t.filter(function(e){return s.indexOf(e)>-1||o.indexOf(e)>-1}).map(function(e){r=R.createListItemFromCoreItem(e,true);u.addItem(r);if(!n&&this._getProposedItemText()===e.getText()){r.setSelected(true);n=true}return e},this).filter(function(e){return o.indexOf(e)>-1}).forEach(function(e){a=o.indexOf(e);if(a>-1){r=R.getListItem(e);r&&r.setVisible(i[a].visible)}})};U.prototype._setTypedInValue=function(e){this._sTypedInValue=e;return this};U.prototype._getTypedInValue=function(){return this._sTypedInValue};U.prototype._setSeparateSuggestions=function(e){var t=this._getSuggestionsTable();this.setProperty("separateSuggestions",e);if(t){t.setShowSeparators(e?B.Inner:B.None)}return this};U.prototype._setProposedItemText=function(e){this._sProposedItemText=e;return this};U.prototype._getProposedItemText=function(){return this._sProposedItemText};U.prototype._getToolbarInteractive=function(){return true};return U});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/InputBase", ["./library","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/IconPool","./delegate/ValueStateMessage","sap/ui/core/message/MessageMixin","sap/ui/core/InvisibleMessage","sap/ui/core/library","sap/ui/Device","./InputBaseRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/core/Lib","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/getSelectedText","sap/ui/dom/jquery/selectText"],function(e,t,a,s,i,n,o,r,u,l,p,c,jQuery,h){"use strict";var g=r.TextDirection;var f=r.TextAlign;var d=r.ValueState;var y=t.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:d.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:g.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{change:{parameters:{value:{type:"string"}}}},aggregations:{formattedValueStateText:{type:"sap.m.FormattedText",multiple:false},_invisibleFormattedValueStateText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_endIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_beginIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"}},designtime:"sap/m/designtime/InputBase.designtime"},renderer:l});a.call(y.prototype);s.insertFontFaceStyle();n.call(y.prototype);y.ICON_PRESSED_CSS_CLASS="sapMInputBaseIconPressed";y.ICON_CSS_CLASS="sapMInputBaseIcon";y.prototype.bShowLabelAsPlaceholder=!u.support.input.placeholder;y.prototype._getPlaceholder=function(){return this.getPlaceholder()||""};y.prototype._getInputValue=function(e){return e===undefined?this.$("inner").val()||"":e.toString()};y.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName}return this._sInputTagElementName};y.prototype.init=function(){this.setLastValue("");this.bRenderingPhase=false;this._oValueStateMessage=new i(this);this._bIsComposingCharacter=false;this.setLastValueStateText("");this.setErrorMessageAnnouncementState(false);this.fnCloseValueStateOnClick=function(){this.closeValueStateMessage()}};y.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true};y.prototype.oncompositionend=function(e){this._bIsComposingCharacter=false;if(!u.browser.firefox){this._bCheckDomValue=true}};y.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter};y.prototype.onBeforeRendering=function(){var e=this.getFocusDomRef();var t=this.getFormattedValueStateText();var a;if(!this._oInvisibleMessage){this._oInvisibleMessage=o.getInstance()}if(this._bCheckDomValue&&!this.bRenderingPhase){if(this.isActive()){this._sDomValue=this._getInputValue()}else{this._bCheckDomValue=false}}if(!t){a=false}else{var s=this.getAggregation("_invisibleFormattedValueStateText");a=t.getHtmlText()!==(s&&s.getHtmlText())}if(this.getValueState()===d.Error&&e){var i=a||this.getValueStateText()!==this.getLastValueStateText();this.setErrorMessageAnnouncementState(!e.hasAttribute("aria-invalid")||i)}if(a){s&&s.destroy();this.setAggregation("_invisibleFormattedValueStateText",t.clone())}this.bRenderingPhase=true};y.prototype.onAfterRendering=function(){var e=this.getValueState();var t=this.getFocusDomRef()===document.activeElement;var a=e===d.None;var s=document.getElementById(this.getValueStateMessageId()+"-sr");if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue)}if(this.getErrorMessageAnnouncementState()&&this.hasStyleClass("sapMFocus")){s&&this._oInvisibleMessage.announce(s.textContent);this.setErrorMessageAnnouncementState(false)}this.$("message").text(this.getValueStateText());this._bCheckDomValue=false;this.bRenderingPhase=false;if(t){this[a?"closeValueStateMessage":"openValueStateMessage"]()}if(this.getAggregation("_invisibleFormattedValueStateText")){this.getAggregation("_invisibleFormattedValueStateText").getControls().forEach(function(e){e.getDomRef()&&e.getDomRef().setAttribute("tabindex",-1)})}this.setLastValueStateText(this.getValueStateText())};y.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy()}if(this._oInvisibleMessage){this._oInvisibleMessage.destroy();this._oInvisibleMessage=null}this._oValueStateMessage=null};y.prototype.ontouchstart=function(e){e.setMarked()};y.prototype.onfocusin=function(e){this.addStyleClass("sapMFocus");this.openValueStateMessage()};y.prototype.onfocusout=function(e){this.removeStyleClass("sapMFocus");if(!this._bClickOnValueStateLink(e)){this.closeValueStateMessage()}};y.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e)}};y.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering};y.prototype.getChangeEventParams=function(){return{}};y.prototype.ontap=function(e){return};y.prototype.onChange=function(e,t,a){t=t||this.getChangeEventParams();if(this.getDomRef()&&(!this.getEditable()||!this.getEnabled())){return}var s=this._getInputValue(a);if(s!==this.getLastValue()){this.setValue(s);s=this.getValue();this.setLastValue(s);this.fireChangeEvent(s,t);return true}else{this._bCheckDomValue=false}};y.prototype.fireChangeEvent=function(e,t){var a=jQuery.extend({value:e,newValue:e},t);this.fireChange(a)};y.prototype.onValueRevertedByEscape=function(e,t){this.fireEvent("liveChange",{value:e,escPressed:true,previousValue:t,newValue:e})};y.prototype.onsapenter=function(e){if(u.browser.safari&&this.isComposingCharacter()){e.setMarked("invalid");return}this.onChange(e)};y.prototype.onsapescape=function(e){var t=this._getInputValue();if(t!==this.getLastValue()){e.setMarked();e.preventDefault();this.updateDomValue(this.getLastValue());this.onValueRevertedByEscape(this.getLastValue(),t)}};y.prototype.oninput=function(e){this._bCheckDomValue=true};y.prototype.onkeydown=function(e){if(this.getDomRef("inner")&&this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==c.BACKSPACE){e.preventDefault()}};y.prototype.oncut=function(e){};y.prototype.selectText=function(e,t){this.$("inner").selectText(e,t);return this};y.prototype.getSelectedText=function(){return this.$("inner").getSelectedText()};y.prototype.setProperty=function(e,a,s){if(e=="value"){this._bCheckDomValue=false}return t.prototype.setProperty.apply(this,arguments)};y.prototype.getFocusInfo=function(){var e=t.prototype.getFocusInfo.call(this),a=this.getFocusDomRef();jQuery.extend(e,{cursorPos:0,selectionStart:0,selectionEnd:0});if(a){e.cursorPos=jQuery(a).cursorPos();try{e.selectionStart=a.selectionStart;e.selectionEnd=a.selectionEnd}catch(e){}}return e};y.prototype.applyFocusInfo=function(e){t.prototype.applyFocusInfo.call(this,e);this.$("inner").cursorPos(e.cursorPos);this.selectText(e.selectionStart,e.selectionEnd);return this};y.prototype.updateDomValue=function(e){var t=this.getFocusDomRef();if(!this.isActive()){return this}e=this._getInputValue(e);if(this._getInputValue()===e){return this}this._bCheckDomValue=true;if(this._bPreferUserInteraction){this.handleInputValueConcurrency(e)}else{t.value=e}return this};y.prototype._aValueStateLinks=function(){if(this.getFormattedValueStateText()&&this.getFormattedValueStateText().getHtmlText()&&this.getFormattedValueStateText().getControls().length){return this.getFormattedValueStateText().getControls()}else{return[]}};y.prototype._bClickOnValueStateLink=function(e){var t=this._aValueStateLinks();return t.some(function(t){return e.relatedTarget===t.getDomRef()})};y.prototype._attachValueStateLinkPress=function(){this._aValueStateLinks().forEach(function(e){e.attachPress(this.fnCloseValueStateOnClick,this)},this)};y.prototype._detachValueStateLinkPress=function(){this._aValueStateLinks().forEach(function(e){e.detachPress(this.fnCloseValueStateOnClick,this)},this)};y.prototype.handleInputValueConcurrency=function(e){var t=this.getFocusDomRef(),a=t&&this._getInputValue(),s=this.getProperty("value"),i=document.activeElement===t,n=this.isBound("value")&&this.getBindingInfo("value").skipModelUpdate;if(i&&n&&a&&s!==a){return this}t.value=e;if(i&&n&&!a){t.select()}};y.prototype._setPreferUserInteraction=function(e){this._bPreferUserInteraction=e};y.prototype.closeValueStateMessage=function(){setTimeout(function(){if(this._oValueStateMessage){this._detachValueStateLinkPress();this._oValueStateMessage.close()}}.bind(this),0)};y.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef("content")};y.prototype.getPopupAnchorDomRef=function(){return this.getDomRef()};y.prototype.iOpenMessagePopupDuration=0;y.prototype.getValueStateMessageId=function(){return this.getId()+"-message"};y.prototype.getErrorMessageAnnouncementState=function(){return this._bErrorStateShouldBeAnnounced};y.prototype.setErrorMessageAnnouncementState=function(e){this._bErrorStateShouldBeAnnounced=e};y.prototype.setLastValueStateText=function(e){this._sLastValueStateText=e};y.prototype.getLastValueStateText=function(){return this._sLastValueStateText};y.prototype.getLabels=function(){var e=this.getAriaLabelledBy().map(function(e){return sap.ui.getCore().byId(e)});var t=sap.ui.require("sap/ui/core/LabelEnablement");if(t){e=e.concat(t.getReferencingLabels(this).map(function(e){return sap.ui.getCore().byId(e)}))}return e};y.prototype.openValueStateMessage=function(){if(this._oValueStateMessage&&this.shouldValueStateMessageBeOpened()){setTimeout(function(){if(!this.bIsDestroyed){this._detachValueStateLinkPress();this._attachValueStateLinkPress();this._oValueStateMessage.open()}}.bind(this),0)}};y.prototype.shouldValueStateMessageBeOpened=function(){return this.getValueState()!==d.None&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage()};y.prototype._calculateIconsSpace=function(){var e=this.getAggregation("_endIcon")||[],t=this.getAggregation("_beginIcon")||[],a=e.concat(t),s,i;return a.reduce(function(e,t){s=t&&t.getDomRef()?parseFloat(getComputedStyle(t.getDomRef()).marginRight):0;i=t&&t.getDomRef()?t.getDomRef().offsetWidth:0;return e+i+s},0)};y.prototype.setValue=function(e){e=this.validateProperty("value",e);e=this._getInputValue(e);this.updateDomValue(e);if(e!==this.getProperty("value")){this.setLastValue(e)}this.setProperty("value",e,true);return this};y.prototype.getFocusDomRef=function(){return this.getDomRef("inner")};y.prototype.getIdForLabel=function(){return this.getId()+"-inner"};y.prototype.getAccessibilityInfo=function(){var e=h.getResourceBundleFor("sap.m"),t=this.getRequired()?e.getText("ELEMENT_REQUIRED"):"",a=this.getRenderer();return{role:a.getAriaRole(this),type:e.getText("ACC_CTR_TYPE_INPUT"),description:[this.getValueDescriptionInfo(),a.getLabelledByAnnouncement(this),a.getDescribedByAnnouncement(this),t].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()}};y.prototype.getValueDescriptionInfo=function(){return this.getValue()||h.getResourceBundleFor("sap.m").getText("INPUTBASE_VALUE_EMPTY")};y.prototype._addIcon=function(e,t,a){if(["begin","end"].indexOf(e)===-1){p.error('icon position is not "begin", neither "end", please check again the passed setting');return null}var i=s.createControlByURI(t).addStyleClass(y.ICON_CSS_CLASS);if(a!==undefined){this.insertAggregation("_"+e+"Icon",i,a)}else{this.addAggregation("_"+e+"Icon",i)}return i};y.prototype.addBeginIcon=function(e){return this._addIcon("begin",e)};y.prototype.addEndIcon=function(e,t){return this._addIcon("end",e,t)};Object.defineProperty(y.prototype,"_$input",{get:function(){return this.$("inner")}});y.prototype.setLastValue=function(e){this._lastValue=e;return this};y.prototype.getLastValue=function(){return this._lastValue};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/InputBaseRenderer", ["sap/ui/core/Renderer","sap/ui/core/library","sap/ui/core/ValueStateSupport","sap/ui/Device","sap/ui/core/Configuration","sap/ui/core/Lib"],function(e,t,n,a,i,s){"use strict";var r=t.TextDirection;var l=t.ValueState;var d={apiVersion:2};d.render=function(t,n){var s=n.getValueState(),d=n.getTextDirection(),o=e.getTextAlign(n.getTextAlign(),d),u=i.getAccessibility(),c=n.getAggregation("_beginIcon")||[],g=n.getAggregation("_endIcon")||[],p,f;t.openStart("div",n);this.addOuterStyles(t,n);this.addControlWidth(t,n);t.class("sapMInputBase");this.addPaddingClass(t,n);this.addCursorClass(t,n);this.addOuterClasses(t,n);if(!n.getEnabled()){t.class("sapMInputBaseDisabled")}if(!n.getEditable()){t.class("sapMInputBaseReadonly")}if(s!==l.None&&n.getEditable()&&n.getEnabled()){t.class("sapMInputBaseState")}if(c.length){p=c.filter(function(e){return e.getVisible()});p.length&&t.class("sapMInputBaseHasBeginIcons")}if(g.length){f=g.filter(function(e){return e.getVisible()});f.length&&t.class("sapMInputBaseHasEndIcons")}this.writeOuterAttributes(t,n);var b=n.getTooltip_AsString();if(b){t.attr("title",b)}t.openEnd();t.openStart("div",n.getId()+"-content");t.class("sapMInputBaseContentWrapper");if(!n.getEnabled()){t.class("sapMInputBaseDisabledWrapper")}else if(!n.getEditable()){t.class("sapMInputBaseReadonlyWrapper")}if(s!==l.None&&n.getEditable()&&n.getEnabled()){this.addValueStateClasses(t,n)}this.addWrapperStyles(t,n);t.openEnd();if(c.length){this.writeIcons(t,c)}this.prependInnerContent(t,n);this.openInputTag(t,n);if(n.getName()){t.attr("name",n.getName())}if(!n.bShowLabelAsPlaceholder&&n._getPlaceholder()){t.attr("placeholder",n._getPlaceholder())}if(n.getMaxLength&&n.getMaxLength()>0){t.attr("maxlength",n.getMaxLength())}if(!n.getEnabled()){t.attr("disabled","disabled")}else if(!n.getEditable()){t.attr("readonly","readonly")}if(d!=r.Inherit){t.attr("dir",d.toLowerCase())}this.writeInnerValue(t,n);if(u){this.writeAccessibilityState(t,n)}if(a.browser.mozilla){if(b){t.attr("x-moz-errormessage",b)}else{t.attr("x-moz-errormessage"," ")}}this.writeInnerAttributes(t,n);t.class("sapMInputBaseInner");this.addInnerClasses(t,n);t.style("text-align",o);this.addInnerStyles(t,n);this.endInputTag(t,n);this.writeInnerContent(t,n);this.closeInputTag(t,n);this.writeAdditionalContent(t,n);if(g.length){this.writeIcons(t,g)}t.close("div");this.writeDecorations(t,n);if(u){this.renderAriaLabelledBy(t,n);this.renderAriaDescribedBy(t,n);this.renderValueStateAccDom(t,n)}t.close("div")};d.getAriaRole=function(e){return"textbox"};d.getAriaLabelledBy=function(e){if(this.getLabelledByAnnouncement(e)){return e.getId()+"-labelledby"}};d.getLabelledByAnnouncement=function(e){return""};d.renderAriaLabelledBy=function(e,t){var n=this.getLabelledByAnnouncement(t);if(n){e.openStart("span",t.getId()+"-labelledby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(n.trim()).close("span")}};d.getAriaDescribedBy=function(e){if(this.getDescribedByAnnouncement(e)){return e.getId()+"-describedby"}};d.getDescribedByAnnouncement=function(e){return""};d.renderAriaDescribedBy=function(e,t){var n=this.getDescribedByAnnouncement(t);if(n){e.openStart("span",t.getId()+"-describedby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(n.trim()).close("span")}};d.renderValueStateAccDom=function(e,t){var a=t.getValueState();if(a===l.None||!t.getEditable()||!t.getEnabled()){return}var i=t.getAggregation("_invisibleFormattedValueStateText");var r;r=s.getResourceBundleFor("sap.m").getText("INPUTBASE_VALUE_STATE_"+a.toUpperCase());e.openStart("div",t.getValueStateMessageId()+"-sr").class("sapUiPseudoInvisibleText");e.openEnd().text(r).text(" ");if(i){e.renderControl(i)}else{e.text(t.getValueStateText()||n.getAdditionalText(t))}e.close("div")};d.getAccessibilityState=function(e){var t=this.getAriaLabelledBy(e),n=this.getAriaDescribedBy(e),a=this.getAriaRole(e),i=e.getValueStateMessageId()+"-sr",s={};if(a){s.role=a}if(e.getValueState()===l.Error&&e.getEditable()&&e.getEnabled()){s.invalid=true;s.errormessage=i}else if(e.getValueState()!==l.None&&e.getEditable()&&e.getEnabled()){n=n?i+" "+n:i}if(t){s.labelledby={value:t.trim(),append:true}}if(n){s.describedby={value:n.trim(),append:true}}s.disabled=null;s.readonly=null;return s};d.writeAccessibilityState=function(e,t){e.accessibilityState(t,this.getAccessibilityState(t))};d.openInputTag=function(e,t){e.voidStart("input",t.getId()+"-"+this.getInnerSuffix())};d.endInputTag=function(e,t){e.voidEnd()};d.writeInnerValue=function(e,t){e.attr("value",t.getValue())};d.addCursorClass=function(e,t){};d.addPaddingClass=function(e,t){e.class("sapMInputBaseHeightMargin")};d.addOuterStyles=function(e,t){};d.addControlWidth=function(e,t){if(!t.getProperty("width")){e.class("sapMInputBaseNoWidth")}e.style("width",t.getWidth())};d.addOuterClasses=function(e,t){};d.writeOuterAttributes=function(e,t){};d.addInnerStyles=function(e,t){};d.addWrapperStyles=function(e,t){e.style("width","100%")};d.addInnerClasses=function(e,t){};d.writeInnerAttributes=function(e,t){};d.prependInnerContent=function(e,t){};d.writeInnerContent=function(e,t){};d.writeAdditionalContent=function(e,t){};d.writeIcons=function(e,t){e.openStart("div").attr("tabindex","-1").class("sapMInputBaseIconContainer").openEnd();t.forEach(e.renderControl,e);e.close("div")};d.writeDecorations=function(e,t){};d.closeInputTag=function(e,t){};d.addPlaceholderStyles=function(e,t){};d.addPlaceholderClasses=function(e,t){};d.addValueStateClasses=function(e,t){e.class("sapMInputBaseContentWrapperState");e.class("sapMInputBaseContentWrapper"+t.getValueState())};d.getInnerSuffix=function(){return"inner"};return d},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/InputListItem", ["sap/ui/core/library","./library","./ListItemBase","./InputListItemRenderer"],function(e,t,n,i){"use strict";var r=e.TextDirection;var a=n.extend("sap.m.InputListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},labelTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:r.Inherit}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/InputListItem.designtime"},renderer:i});a.prototype.getContentAnnouncement=function(){var e=this.getLabel()+" . ";this.getContent().forEach(function(t){e+=n.getAccessibilityText(t)+" "});return e.trim()};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/InputListItemRenderer", ["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(e,a,r){"use strict";var t=e.TextDirection;var n=a.extend(r);n.apiVersion=2;n.renderLIAttributes=function(e,a){e.class("sapMILI")};n.renderLIContent=function(e,a){var r=a.getLabel();var n=a.getId()+"-label";if(r){e.openStart("span",n);e.class("sapMILILabel");var i=a.getLabelTextDirection();if(i!==t.Inherit){e.attr("dir",i.toLowerCase())}e.openEnd();e.text(r);e.close("span")}e.openStart("div").class("sapMILIDiv").class("sapMILI-CTX").openEnd();a.getContent().forEach(function(a){if(a.addAriaLabelledBy&&a.getAriaLabelledBy().indexOf(n)===-1){a.addAriaLabelledBy(n)}e.renderControl(a)});e.close("div")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/InputRenderer", ["sap/ui/core/InvisibleText","sap/ui/core/Renderer","./InputBaseRenderer","sap/m/library","sap/ui/core/Configuration"],function(e,t,i,a,s){"use strict";var r=a.InputType;var n=t.extend(i);n.apiVersion=2;n.addOuterClasses=function(e,t){e.class("sapMInput");if(t.getDescription()){e.class("sapMInputWithDescription")}};n.writeInnerAttributes=function(e,t){var i=t.getShowSuggestion();var a=!t.getEnabled()&&t.getType()=="Password"||t.getShowSuggestion()&&t.isMobileDevice();e.attr("type",t.getType().toLowerCase());if(t.getType()==r.Number){e.attr("step","any")}if(t.getType()==r.Number&&s.getRTL()){e.attr("dir","ltr").style("text-align","right")}if(i||t.getShowValueStateMessage()){e.attr("autocomplete","off")}a=a||t.getValueHelpOnly()&&t.getEnabled()&&t.getEditable()&&t.getShowValueHelp();if(a){e.attr("readonly","readonly")}};n.writeOuterAttributes=function(e,t){e.attr("data-ui5-accesskey",t.getProperty("accesskey"))};n.addInnerClasses=function(e,t){};n.writeDescription=function(e,t){e.openStart("div").class("sapMInputDescriptionWrapper").style("width","calc(100% - "+t.getFieldWidth()+")").openEnd();e.openStart("span",t.getId()+"-descr").class("sapMInputDescriptionText").openEnd().text(t.getDescription()).close("span");e.close("div")};n.writeDecorations=function(e,t){if(t.getDescription()){this.writeDescription(e,t)}if(s.getAccessibility()){if(t.getShowSuggestion()&&t.getEnabled()&&t.getEditable()){e.openStart("span",t.getId()+"-SuggDescr").class("sapUiPseudoInvisibleText").attr("role","status").attr("aria-live","polite").openEnd().close("span")}}};n.addWrapperStyles=function(e,t){e.style("width",t.getDescription()?t.getFieldWidth():"100%")};n.getAriaDescribedBy=function(t){var a=i.getAriaDescribedBy.apply(this,arguments);function s(e){a=a?a+" "+e:e}if(t.getDescription()){s(t.getId()+"-descr")}if(t.getShowValueHelp()&&t.getEnabled()&&t.getEditable()){s(e.getStaticId("sap.m","INPUT_VALUEHELP"));if(t.getValueHelpOnly()){s(e.getStaticId("sap.m","INPUT_DISABLED"))}}return a};n.getAriaRole=function(e){return""};n.writeInnerValue=function(e,t){if(t.getType()!==r.Password){e.attr("value",t.getValue())}};n.getAccessibilityState=function(e){var t=e.getShowSuggestion();var a=i.getAccessibilityState.apply(this,arguments);if(t){a["haspopup"]="listbox"}return a};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/InstanceManager", ["sap/base/assert","sap/base/Log","sap/ui/thirdparty/jquery"],function(e,n,jQuery){"use strict";var t={};var a={},r=[];var o="_POPOVER_",s="_DIALOG_",c="_LIGHTBOX_";t.addInstance=function(n,t){e(n,"In sap.m.InstanceManager.addInstance method, the parameter sCategoryId can't be null or empty string");e(t instanceof Object,"In sap.m.InstanceManager.addInstance method, the parameter oInstance should be an object");if(!a[n]){a[n]=[]}if(a[n].indexOf(t)===-1){a[n].push(t)}return this};t.removeInstance=function(n,t){var r=a[n],o;e(n,"In sap.m.InstanceManager.removeInstance method, the parameter sCategoryId can't be null or empty string");e(t instanceof Object,"In sap.m.InstanceManager.removeInstance method, the parameter oInstance should be an object");if(!r){return null}o=r.indexOf(t);return o===-1?null:r.splice(o,1)};t.getInstancesByCategoryId=function(n){e(n,"In sap.m.InstanceManager.getInstancesByCategoryId method, the parameter sCategoryId can't be null or empty string");return a[n]||r};t.isInstanceManaged=function(n,t){e(n,"In sap.m.InstanceManager.isInstanceManaged method, the parameter sCategoryId can't be null or empty string");e(t instanceof Object,"In sap.m.InstanceManager.isInstanceManaged method, the parameter oInstance should be an object");var r=a[n];if(!r||!t){return false}return r.indexOf(t)!==-1};t.isCategoryEmpty=function(n){e(n,"In sap.m.InstanceManager.isCategoryEmpty method, the parameter sCategoryId can't be null or empty string");var t=a[n];return!t||t.length===0};t.addPopoverInstance=function(e){if(typeof e.close==="function"){t.addInstance(o,e)}else{n.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.")}return this};t.addDialogInstance=function(e){if(typeof e.close==="function"){t.addInstance(s,e)}else{n.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.")}return this};t.addLightBoxInstance=function(e){if(typeof e.close==="function"){t.addInstance(c,e)}else{n.warning("In method addLightBoxInstance: the parameter doesn't have a close method and can't be managed.")}return this};t.removePopoverInstance=function(e){return t.removeInstance(o,e)};t.removeDialogInstance=function(e){return t.removeInstance(s,e)};t.removeLightBoxInstance=function(e){return t.removeInstance(c,e)};t.hasOpenPopover=function(){return!t.isCategoryEmpty(o)};t.hasOpenDialog=function(){return!t.isCategoryEmpty(s)};t.hasOpenLightBox=function(){return!t.isCategoryEmpty(c)};t.isDialogOpen=function(e){return t.isInstanceManaged(s,e)};t.isPopoverOpen=function(e){return t.isInstanceManaged(o,e)};t.isLightBoxOpen=function(e){return t.isInstanceManaged(c,e)};t.getOpenPopovers=function(){return t.getInstancesByCategoryId(o)};t.getOpenDialogs=function(){return t.getInstancesByCategoryId(s)};t.getOpenLightBoxes=function(){return t.getInstancesByCategoryId(c)};t.closeAllPopovers=function(){var e=t.getOpenPopovers(),n;for(n=0;n<e.length;n++){e[n].close()}return this};t.closeAllDialogs=function(e){var n,a=[],r=t.getOpenDialogs(),o,s;for(s=0;s<r.length;s++){o=r[s];if(!o.getCloseOnNavigation()){continue}if(e){n=(new jQuery.Deferred).done();a.push(n);o.attachEvent("afterClose",function(e){return function(){e.resolve()}}(n))}o.close()}if(e){jQuery.when.apply(this,a).then(e)}return this};t.closeAllLightBoxes=function(){var e=t.getOpenLightBoxes(),n=e.length,a;for(a=0;a<n;a+=1){e[a].close()}return this};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Label", ["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/LabelEnablement","sap/m/HyphenationSupport","sap/ui/core/library","./LabelRenderer"],function(e,t,a,r,o,i,n){"use strict";var p=i.TextDirection;var l=i.TextAlign;var s=e.LabelDesign;var u=i.VerticalAlign;var c=e.WrappingType;var g=a.extend("sap.m.Label",{metadata:{interfaces:["sap.ui.core.Label","sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IToolbarInteractiveControl","sap.m.IHyphenation","sap.ui.core.IAccessKeySupport"],library:"sap.m",properties:{design:{type:"sap.m.LabelDesign",group:"Appearance",defaultValue:s.Standard},text:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:l.Begin},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:p.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},required:{type:"boolean",group:"Misc",defaultValue:false},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:c.Normal},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:u.Inherit},showColon:{type:"boolean",group:"Appearance",defaultValue:false},highlightAccKeysRef:{type:"boolean",defaultValue:false,visibility:"hidden"}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/m/designtime/Label.designtime"},renderer:n});g.prototype.getAccessibilityInfo=function(){var e=this.getText();return{description:e,required:this.isRequired()}};g.prototype.onBeforeRendering=function(){this._handleAccessKeysHighlighting()};g.prototype._handleAccessKeysHighlighting=function(){var e=this.getLabelFor();var a=this.getText();if(!e||!a){return}var r=t.byId(e);if(r&&r.isA("sap.m.Input")&&r.getProperty("highlightAccKeysRef")){t.byId(e).setProperty("accesskey",a[0].toLowerCase())}};g.prototype.getOverflowToolbarConfig=function(){var e={canOverflow:true,propsUnrelatedToSize:["design","required","displayOnly"]};function t(e){var t=e&&e.getLayoutData();if(f(t,"sap/m/OverflowToolbarLayoutData")){return t.getGroup()}}e.onBeforeEnterOverflow=function(e){var a=false,r,o,i,n,p;r=e.getParent();if(!f(r,"sap/m/OverflowToolbar")){return}o=e.getLabelFor();i=o&&sap.ui.getCore().byId(o);if(!i||r.indexOfContent(i)<0){return}n=t(e);p=t(i);a=n&&n===p;e.toggleStyleClass("sapMLabelMediumMarginTop",a,true)};e.onAfterExitOverflow=function(e){e.toggleStyleClass("sapMLabelMediumMarginTop",false,true)};return e};g.prototype.getTextsToBeHyphenated=function(){return{main:this.getText()}};g.prototype.getDomRefsForHyphenatedTexts=function(){return{main:this.$("bdi")[0]}};g.prototype.setIsInColumnHeaderContext=function(e){this._isInColumnHeaderContext=!!e};g.prototype._getToolbarInteractive=function(){return false};r.enrich(g.prototype);o.mixInto(g.prototype);function f(e,t){if(e&&t){var a=sap.ui.require(t);return typeof a==="function"&&e instanceof a}}return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/LabelRenderer", ["sap/ui/core/Lib","sap/ui/core/Renderer","sap/ui/core/AccessKeysEnablement","sap/m/library","sap/ui/core/library","sap/m/HyphenationSupport","sap/ui/core/LabelEnablement"],function(e,t,a,i,s,n,l){"use strict";var r=s.TextDirection;const o=s.TextAlign;var c=s.VerticalAlign;var p=i.LabelDesign;var g={apiVersion:2};g.render=function(t,i){var s=i.getTextDirection(),o=i.getTextAlign(),d=i.getWidth(),f=i.getText(),b=i.getTooltip_AsString(),u=i.getLabelForRendering(),L=u?"label":"span",x=i.isDisplayOnly(),y=i.getVAlign();t.openStart(L,i);t.class("sapMLabel");t.class("sapUiSelectable");if(i.isWrapping()){t.class("sapMLabelWrapped")}if(i.getDesign()==p.Bold){t.style("font-weight","bold")}if(i.isRequired()){t.class("sapMLabelRequired")}if(i.getShowColon()){t.class("sapMLabelShowColon")}if(u){l.writeLabelForAttribute(t,i)}if(s!==r.Inherit){t.attr("dir",s.toLowerCase())}if(d){t.style("width",d)}else{t.class("sapMLabelMaxWidth")}if(o){const e=g.getTextAlign(o,s);if(e){t.style("text-align",e)}}if(f==""){t.class("sapMLabelNoText")}if(x){t.class("sapMLabelDisplayOnly")}if(y!=c.Inherit){t.style("vertical-align",y.toLowerCase())}n.writeHyphenationClass(t,i);if(b){t.attr("title",b)}t.openEnd();t.openStart("div").class("sapMLabelInner");if(o){const e=g.textAlignToJustifyContent(o);if(e){t.style("justify-content",e)}}t.openEnd();t.openStart("span",i.getId()+"-text");t.class("sapMLabelTextWrapper");if(i.getProperty("highlightAccKeysRef")){t.class(a.CSS_CLASS)}t.openEnd();t.openStart("bdi",i.getId()+"-bdi");if(s!==r.Inherit){t.attr("dir",s.toLowerCase())}t.openEnd();if(f){f=n.getTextForRender(i,"main");t.text(f)}t.close("bdi");t.close("span");t.openStart("span");t.class("sapMLabelColonAndRequired");t.attr("data-colon",e.getResourceBundleFor("sap.m").getText("LABEL_COLON"));if(u||i._isInColumnHeaderContext){t.accessibilityState({hidden:"true"})}t.openEnd();t.close("span");t.close("div");t.close(L)};g.getTextAlign=t.getTextAlign;g.textAlignToJustifyContent=function(e){let t;switch(e){case o.Begin:t="flex-start";break;case o.End:t="flex-end";break;case o.Left:t="left";break;case o.Right:t="right";break;case o.Center:t="center";break;default:t=""}return t};return g},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/LightBox", ["./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/Core","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/m/Button","sap/ui/core/ResizeHandler","sap/ui/Device","./InstanceManager","sap/ui/core/InvisibleText","sap/ui/core/library","./LightBoxRenderer","sap/m/BusyIndicator","sap/ui/thirdparty/jquery","sap/ui/dom/units/Rem"],function(e,t,i,s,o,n,r,a,h,p,g,u,l,_,d,jQuery,c){"use strict";var f=e.ButtonType;var m=e.LightBoxLoadingStates;var I=l.OpenState;var y=t.extend("sap.m.LightBox",{metadata:{library:"sap.m",interfaces:["sap.ui.core.PopupInterface"],aggregations:{imageContent:{type:"sap.m.LightBoxItem",multiple:true,bindable:"bindable"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_errorMessage:{type:"sap.m.IllustratedMessage",multiple:false,visibility:"hidden"},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},defaultAggregation:"imageContent",events:{},designtime:"sap/m/designtime/LightBox.designtime"},renderer:_});y.prototype.init=function(){this._createPopup();this._iWidth=0;this._iHeight=0;this._isRendering=true;this._iResizeListenerId=null;this._$lightBox=null;this._oRB=s.getLibraryResourceBundle("sap.m");this.setAggregation("_invisiblePopupText",new u)};y.prototype.onBeforeRendering=function(){var e=this._getImageContent(),t=e._getNativeImage(),i=e.getImageSrc(),s=e._getImageState(),o=this._oRB.getText("LIGHTBOX_ARIA_ENLARGED",[e.getTitle(),e.getSubtitle()]);this._createErrorControls();if(t.getAttribute("src")!==i){t.src=i}if(this._iResizeListenerId){p.resize.detachHandler(this._fnResizeListener);h.deregister(this._iResizeListenerId);this._iResizeListenerId=null}switch(s){case m.Loading:if(!this._iTimeoutId){this._iTimeoutId=setTimeout(function(){e._setImageState(m.TimeOutError)},1e4)}break;case m.Loaded:clearTimeout(this._iTimeoutId);this._calculateSizes(t);break;case m.Error:case m.TimeOutError:clearTimeout(this._iTimeoutId);break;default:break}if(e){this.getAggregation("_invisiblePopupText").setText(o)}this._isRendering=true};y.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._iResizeListenerId){this._fnResizeListener=this._onResize.bind(this);p.resize.attachHandler(this._fnResizeListener);this._iResizeListenerId=h.register(this,this._fnResizeListener)}};y.prototype.forceInvalidate=t.prototype.invalidate;y.prototype.invalidate=function(e){var t=this._getImageContent();if(this.isOpen()){if(t&&t.getImageSrc()){this.forceInvalidate(e)}else{this.close()}}return this};y.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnPopupOpened,this);this._oPopup.detachClosed(this._fnPopupClosed,this);this._oPopup.destroy();this._oPopup=null}if(this._iResizeListenerId){p.resize.detachHandler(this._fnResizeListener);h.deregister(this._iResizeListenerId);this._iResizeListenerId=null}g.removeLightBoxInstance(this)};y.prototype.open=function(){var e=this._getImageContent();this._oPopup.setContent(this);if(e&&e.getImageSrc()){this._oPopup.open(300,i.Dock.CenterCenter,i.Dock.CenterCenter,window,null);g.addLightBoxInstance(this)}return this};y.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true}return false};y.prototype.close=function(){if(this._iResizeListenerId){p.resize.detachHandler(this._fnResizeListener);h.deregister(this._iResizeListenerId);this._iResizeListenerId=null}this._oPopup.close();g.removeLightBoxInstance(this);return this};y.prototype._getCloseButton=function(){var e=this.getAggregation("_closeButton");if(!e){e=new a({id:this.getId()+"-closeButton",text:this._oRB.getText("LIGHTBOX_CLOSE_BUTTON"),type:f.Transparent,press:this.close.bind(this)});this.setAggregation("_closeButton",e,true)}return e};y.prototype._getBusyIndicator=function(){var e=this.getAggregation("_busy");if(!e){e=new d;this.setAggregation("_busy",e,true)}return e};y.prototype._imageStateChanged=function(e){if(e!==m.Loading&&!this._isRendering){this.invalidate()}};y.prototype._createPopup=function(){this._oPopup=new i(this,true,true);this._oPopup.attachOpened(this._fnPopupOpened,this);this._oPopup.attachClosed(this._fnPopupClosed,this)};y.prototype._fnPopupOpened=function(){this._onResize();jQuery("#sap-ui-blocklayer-popup").on("click",function(){this.close()}.bind(this))};y.prototype._fnPopupClosed=function(){jQuery("#sap-ui-blocklayer-popup").off("click")};y.prototype._createErrorControls=function(){var e=this._oRB.getText("LIGHTBOX_IMAGE_TIMED_OUT"),t=this._oRB.getText("LIGHTBOX_IMAGE_TIMED_OUT_DETAILS"),i;if(this.getAggregation("_errorMessage")){if(this._getImageContent()._getImageState()===m.TimeOutError){this.getAggregation("_errorMessage").setTitle(e);this.getAggregation("_errorMessage").setDescription(t)}return}if(this._getImageContent()._getImageState()!==m.TimeOutError){e=this._oRB.getText("LIGHTBOX_IMAGE_ERROR");t=this._oRB.getText("LIGHTBOX_IMAGE_ERROR_DETAILS")}i=new o({illustrationType:n.UnableToLoadImage,illustrationSize:p.system.phone?r.Auto:r.Scene,enableVerticalResponsiveness:true,title:e,description:t});this.setAggregation("_errorMessage",i)};y.prototype._onResize=function(){var e=this.getDomRef();if(!e){return}var t,i,s,o,n=Math.round(window.scrollY),r=Math.round(window.scrollX),a,h,p=this._getImageContent();if(p._getImageState()===m.Loaded){this._calculateSizes(p._getNativeImage());t=this._iWidth;i=this._iHeight;this._$lightBox.width(t);this._$lightBox.height(i)}else{t=e.clientWidth;i=e.clientHeight}s=window.innerHeight-i;o=window.innerWidth-t;a=n+Math.round(s/2);h=r+Math.round(o/2);this._$lightBox.css({top:a,left:h})};y.prototype._calculateSizes=function(e){var t=this._calculateFooterHeightInPx(),i=288-t,s=this._getImageContent().getAggregation("_image"),o;this._setImageSize(s,e.naturalWidth,e.naturalHeight);this._calculateAndSetLightBoxSize(s);o=this._pxToNumber(s.getHeight());this.toggleStyleClass("sapMLightBoxMinSize",o<i);this._isBusy=false};y.prototype._calculateFooterHeightInPx=function(){var e=this.$().parents().hasClass("sapUiSizeCompact"),t=this._getImageContent().getSubtitle(),i=3;if(e&&!t){i-=.5}if(t){i+=.5}return c.toPx(i)};y.prototype._calculateAndSetLightBoxSize=function(e){var t,i,s=20*16,o=18*16,n=this._calculateFooterHeightInPx();t=this._pxToNumber(e.getHeight());i=this._pxToNumber(e.getWidth());this._iWidth=Math.max(s,i);this._iHeight=Math.max(o,t+n);this._bIsLightBoxBiggerThanMinDimensions=i>=s&&t>=o-n};y.prototype._setImageSize=function(e,t,i){var s=this._calculateFooterHeightInPx(),o=this._getDimensions(t,i,s);e.setWidth(o.width+"px");e.setHeight(o.height+"px")};y.prototype._getDimensions=function(e,t,i){var s=20*16,o=18*16,n=jQuery(window),r=n.height(),a=n.width(),h=this._calculateOffset(),p=Math.max(a-h,s),g=Math.max(r-h,o),u;g-=i;if(t<=g){if(e<=p){}else{t*=p/e;e=p}}else if(e<=p){e*=g/t;t=g}else{u=Math.max(e/p,t/g);e/=u;t/=u}return{width:Math.round(e),height:Math.round(t)}};y.prototype._pxToNumber=function(e){return e.substring(0,e.length-2)*1};y.prototype._getImageContent=function(){var e=this.getAggregation("imageContent");return e&&e[0]};y.prototype._calculateOffset=function(){if(p.system.desktop){return 4*16}if(p.system.tablet){return 2*16}if(p.system.phone&&p.resize.width>320){return 1*16}return 0};y.prototype.onsapescape=function(e){var t=this._oPopup.getOpenState();if(t!==I.CLOSED||t!==I.CLOSING){this.close();e.stopPropagation()}};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/LightBoxItem", ["./library","sap/ui/core/library","sap/ui/core/Element","sap/m/Image","sap/m/Title","sap/m/Label"],function(t,e,a,i,s,r){"use strict";var g=t.LightBoxLoadingStates;var n=e.OpenState;var o=e.TitleLevel;var p=a.extend("sap.m.LightBoxItem",{metadata:{library:"sap.m",properties:{imageSrc:{type:"sap.ui.core.URI",group:"Appearance",multiple:false,defaultValue:""},alt:{type:"string",group:"Appearance",multiple:false,defaultValue:""},title:{type:"string",group:"Appearance",multiple:false,defaultValue:""},subtitle:{type:"string",group:"Appearance",multiple:false,defaultValue:""}},aggregations:{_image:{type:"sap.m.Image",multiple:false,visibility:"hidden"},_title:{type:"sap.m.Title",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});p.prototype.init=function(){this._createNativeImage();this.setAggregation("_image",new i({decorative:false,densityAware:false}),true);this.setAggregation("_title",new s({level:o.H2,wrapping:false}),true);this.setAggregation("_subtitle",new r({wrapping:false}),true)};p.prototype._createNativeImage=function(){var t=this;this._sImageState=g.Loading;this._oImage=new window.Image;this._oImage.onload=function(){if(this.complete&&t._sImageState===g.Loading){t._setImageState(g.Loaded)}};this._oImage.onerror=function(){t._setImageState(g.Error)}};p.prototype.exit=function(){this._oImage=null};p.prototype._setImageState=function(t){if(t!==this._sImageState){this._sImageState=t;if(this.getParent()){this.getParent()._imageStateChanged(t)}}};p.prototype._getImageState=function(){return this._sImageState};p.prototype._getNativeImage=function(){return this._oImage};p.prototype.setImageSrc=function(t){var e=this.getAggregation("_image"),a=this.getParent();if(this.getImageSrc()===t){return this}this._sImageState=g.Loading;if(a&&a._oPopup.getOpenState()===n.OPEN){this._oImage.src=t}this.setProperty("imageSrc",t,false);e.setSrc(t);return this};p.prototype.setAlt=function(t){var e=this.getAggregation("_image");this.setProperty("alt",t,false);e.setAlt(t);return this};p.prototype.setTitle=function(t){var e=this.getAggregation("_title");this.setProperty("title",t,false);e.setText(t);return this};p.prototype.setSubtitle=function(t){var e=this.getAggregation("_subtitle");this.setProperty("subtitle",t,false);e.setText(t);return this};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/LightBoxRenderer", ["sap/m/library"],function(e){"use strict";var t=e.LightBoxLoadingStates;var r={apiVersion:2};r.render=function(e,r){var i=r._getImageContent();var o=i._getImageState();var s=r.getAggregation("_invisiblePopupText");e.openStart("div",r).class("sapMLightBox").attr("tabindex","-1").accessibilityState({role:"dialog",modal:true,labelledby:s&&s.getId()});if(i.getSubtitle()){e.class("sapMLightBoxTwoLines")}if(r._bIsLightBoxBiggerThanMinDimensions){e.class("sapMLightBoxTopCornersRadius")}if(o===t.TimeOutError||o===t.Error){e.class("sapMLightBoxError");e.style("width","auto");e.style("height","auto")}else{e.style("width",r._iWidth+"px");e.style("height",r._iHeight+"px")}e.openEnd();e.renderControl(s);if(o===t.Loading){this.renderBusyState(e,r)}else if(o===t.TimeOutError||o===t.Error){this.renderError(e,r)}else{this.renderImage(e,r)}this.renderFooter(e,r,i);e.close("div");r._isRendering=false};r.renderImage=function(e,t){var r=t._getImageContent();e.openStart("div",r);if(r.getSubtitle()){e.class("sapMLightBoxImageContainerTwoLines")}else{e.class("sapMLightBoxImageContainer")}e.openEnd();e.renderControl(r.getAggregation("_image"));e.close("div")};r.renderError=function(e,t){var r=t._getImageContent();e.openStart("div");if(r&&r.getSubtitle()){e.class("sapMLightBoxErrorContainerTwoLines")}else{e.class("sapMLightBoxErrorContainer")}e.openEnd();e.renderControl(t.getAggregation("_errorMessage"));e.close("div")};r.renderBusyState=function(e,t){e.renderControl(t._getBusyIndicator())};r.renderFooter=function(e,t,r){var i=r.getAggregation("_title"),o=r.getAggregation("_subtitle");e.openStart("div").class("sapMLightBoxFooter").class("sapContrast").class("sapContrastPlus");if(r.getSubtitle()){e.class("sapMLightBoxFooterTwoLines")}e.openEnd();e.openStart("div").class("sapMLightBoxTitleSection").accessibilityState({hidden:true}).openEnd();if(i){e.renderControl(i.addStyleClass("sapMLightBoxTitle"))}if(o&&o.getText()){e.renderControl(o.addStyleClass("sapMLightBoxSubtitle"))}e.close("div");e.renderControl(t._getCloseButton());e.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Link", ["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/core/EnabledPropagator","sap/ui/core/AccessKeysEnablement","sap/ui/core/LabelEnablement","sap/ui/core/library","sap/ui/Device","./LinkRenderer","sap/ui/events/KeyCodes","sap/base/security/URLListValidator"],function(e,t,i,r,a,s,o,n,p,l,u,c){"use strict";var f=n.TextDirection;var h=n.TextAlign;var d=n.aria.HasPopup;var y=e.LinkAccessibleRole;var g=e.EmptyIndicatorMode;var b=i.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent","sap.ui.core.ITitleContent","sap.ui.core.IAccessKeySupport","sap.m.IToolbarInteractiveControl"],library:"sap.m",designtime:"sap/m/designtime/Link.designtime",properties:{text:{type:"string",group:"Data",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},rel:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},validateUrl:{type:"boolean",group:"Data",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:h.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:f.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:d.None},accessibleRole:{type:"sap.m.LinkAccessibleRole",group:"Accessibility",defaultValue:y.Default},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:g.Off},highlightAccKeysRef:{type:"boolean",defaultValue:false,visibility:"hidden"},accesskey:{type:"string",defaultValue:"",visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true,parameters:{ctrlKey:{type:"boolean"},metaKey:{type:"boolean"}}}},dnd:{draggable:true,droppable:false}},renderer:l});a.call(b.prototype);b.prototype.init=function(){s.registerControl(this)};b.prototype.onBeforeRendering=function(){};b.prototype.getAccessKeysFocusTarget=function(){return this.getFocusDomRef()};b.prototype.onAccKeysHighlightStart=function(){m.call(this,true)};b.prototype.onAccKeysHighlightEnd=function(){m.call(this,false)};b.prototype.onAfterRendering=function(){if(p.system.phone||p.system.tablet){var e=this.getDomRef();if(!e){return}e.removeEventListener("touchstart",this._onTouchStart);if(e.getAttribute("href")==="#"){e.addEventListener("touchstart",this._onTouchStart)}}};b.prototype.exit=function(){if(p.system.phone||p.system.tablet){var e=this.getDomRef();if(!e){return}e.removeEventListener("touchstart",this._onTouchStart)}};b.prototype._onTouchStart=function(e){e.preventDefault()};b.prototype.onkeydown=function(e){if(e.which===u.SPACE||e.which===u.SHIFT||e.which===u.ESCAPE){if(e.which===u.SPACE){if(this.getEnabled()||this.getHref()){e.setMarked();e.preventDefault();this._bPressedSpace=true}}if(this._bPressedSpace&&(e.which===u.ESCAPE||e.which===u.SHIFT)){this._bPressedEscapeOrShift=true}}else{if(this._bPressedSpace){e.preventDefault()}}};b.prototype.onkeyup=function(e){if(e.which===u.SPACE){if(!this._bPressedEscapeOrShift){this._handlePress(e);if(this.getHref()&&!e.isDefaultPrevented()){e.preventDefault();e.setMarked();var t=document.createEvent("MouseEvents");t.initEvent("click",false,true);this.getDomRef().dispatchEvent(t)}}else{this._bPressedEscapeOrShift=false}this._bPressedSpace=false}};b.prototype._handlePress=function(e){var t=e.target,i;if(this.getEnabled()){e.setMarked();i=t.classList.contains("sapMLnk")&&t.getAttribute("href")=="#";if(!this.firePress({ctrlKey:!!e.ctrlKey,metaKey:!!e.metaKey})||i){e.preventDefault()}}else{e.preventDefault()}};b.prototype.onsapenter=b.prototype._handlePress;b.prototype.onclick=b.prototype._handlePress;b.prototype.ontouchstart=function(e){if(this.getEnabled()){e.setMarked()}};b.prototype.setSubtle=function(e){this.setProperty("subtle",e);if(e&&!b.prototype._sAriaLinkSubtleId){b.prototype._sAriaLinkSubtleId=r.getStaticId("sap.m","LINK_SUBTLE")}return this};b.prototype.setEmphasized=function(e){this.setProperty("emphasized",e);if(e&&!b.prototype._sAriaLinkEmphasizedId){b.prototype._sAriaLinkEmphasizedId=r.getStaticId("sap.m","LINK_EMPHASIZED")}return this};b.prototype._isHrefValid=function(e){return this.getValidateUrl()?c.validate(e):true};b.prototype.getAccessibilityInfo=function(){var e=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=this.getEmphasized()?e.getText("LINK_EMPHASIZED"):"",i=this.getSubtle()?e.getText("LINK_SUBTLE"):"",r=this.getText(),a=r,s=this.getAccessibleRole(),o;if(r){o=s===y.Default?e.getText("ACC_CTR_TYPE_LINK"):e.getText("ACC_CTR_TYPE_BUTTON");t&&(a+=" "+t);i&&(a+=" "+i)}return{role:s===y.Default?"link":s,type:o,description:a,focusable:this.getEnabled(),enabled:this.getEnabled()}};b.prototype.getFormDoNotAdjustWidth=function(){return true};b.prototype._getTabindex=function(){return this.getText()&&this.getEnabled()?"0":"-1"};b.prototype._determineSelfReferencePresence=function(){var e=this.getAriaLabelledBy(),t=e.indexOf(this.getId())!==-1,i=o.getReferencingLabels(this).length>0,r=this.getParent(),a=!!(r&&r.enhanceAccessibilityState);return!t&&(e.length>0||i||a)};b.prototype._getToolbarInteractive=function(){return true};var m=function(e){var i=this.getAriaLabelledBy();if(i.length){var r=t.byId(i[0]);r.setProperty("highlightAccKeysRef",e);if(r.getText&&r.getText()){this.setProperty("accesskey",r.getText()[0].toLowerCase())}}};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/LinkRenderer", ["sap/ui/core/Renderer","sap/ui/core/library","sap/ui/core/AccessKeysEnablement","sap/ui/util/defaultLinkTypes","./library","sap/ui/core/Core"],function(e,t,a,i,r,s){"use strict";var n=t.TextDirection;var o=t.aria.HasPopup;var p=r.LinkAccessibleRole;var l={apiVersion:2};var d=r.EmptyIndicatorMode;var c=s.getLibraryResourceBundle("sap.m");l.render=function(t,a){var r=a.getTextDirection(),s=e.getTextAlign(a.getTextAlign(),r),l=a._determineSelfReferencePresence(),c=a.getAriaHasPopup(),g=i(a.getRel(),a.getTarget()),u=a.getHref(),f=a.getAccessibleRole(),T={labelledby:l?{value:a.getId(),append:true}:undefined,haspopup:c===o.None?null:c.toLowerCase()},b=a.getEnabled(),E="",y=a.getProperty("accesskey");t.openStart("a",a);t.class("sapMLnk");if(a.getSubtle()){t.class("sapMLnkSubtle");E+=a._sAriaLinkSubtleId}if(a.getEmphasized()){t.class("sapMLnkEmphasized");E+=" "+a._sAriaLinkEmphasizedId}if(y){t.attr("data-ui5-accesskey",y)}switch(f){case p.Button:T.role=p.Button.toLowerCase();break;default:u=u&&a._isHrefValid(u)&&a.getEnabled()?u:"#";t.attr("href",u)}T.describedby=E?{value:E.trim(),append:true}:undefined;if(!b){t.class("sapMLnkDsbl");t.attr("aria-disabled","true")}t.attr("tabindex",a._getTabindex());if(a.getWrapping()){t.class("sapMLnkWrapping")}if(a.getEmptyIndicatorMode()!==d.Off&&!a.getText()){t.class("sapMLinkContainsEmptyIdicator")}if(a.getTooltip_AsString()){t.attr("title",a.getTooltip_AsString())}if(a.getTarget()){t.attr("target",a.getTarget())}if(g){t.attr("rel",g)}if(a.getWidth()){t.style("width",a.getWidth())}else{t.class("sapMLnkMaxWidth")}if(s){t.style("text-align",s)}if(r!==n.Inherit){t.attr("dir",r.toLowerCase())}a.getDragDropConfig().forEach(function(e){if(!e.getEnabled()){t.attr("draggable",false)}});t.accessibilityState(a,T);t.openEnd();if(this.writeText){this.writeText(t,a)}else{this.renderText(t,a)}t.close("a")};l.renderText=function(e,t){var a=t.getText();if(t.getEmptyIndicatorMode()!==d.Off&&!t.getText()){this.renderEmptyIndicator(e,t)}else{e.text(a)}};l.renderEmptyIndicator=function(e,t){e.openStart("span");e.class("sapMEmptyIndicator");e.class("sapMLnkDsbl");if(t.getEmptyIndicatorMode()===d.Auto){e.class("sapMEmptyIndicatorAuto")}e.openEnd();e.openStart("span");e.attr("aria-hidden",true);e.openEnd();e.text(c.getText("EMPTY_INDICATOR"));e.close("span");e.openStart("span");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(c.getText("EMPTY_INDICATOR_TEXT"));e.close("span");e.close("span")};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/LinkTileContent", ["sap/ui/core/Element","sap/m/HBox","sap/m/Link","sap/ui/core/Icon"],function(t,e,n,i){"use strict";const o=t.extend("sap.m.LinkTileContent",{metadata:{library:"sap.m",properties:{iconSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},linkText:{type:"string",group:"Data",defaultValue:""},linkHref:{type:"sap.ui.core.URI",group:"Data",defaultValue:null}},events:{linkPress:{allowPreventDefault:true,parameters:{ctrlKey:{type:"boolean"},metaKey:{type:"boolean"}}}}}});o.prototype.init=function(){this._linkTileContent=null};o.prototype.getLinkTileContentInstance=function(){if(!this._linkTileContent){this._linkTileContent=new e;this._addItem(this._linkTileContent);this._linkTileContent.addStyleClass("sapLTC")}return this._linkTileContent};o.prototype._addItem=function(t){const{iconSrc:e,linkText:o,linkHref:s}=this.mProperties;this._oIcon=new i({size:"1rem",src:e});this._oLink=new n({text:o,href:s,press:this._onLinkPress.bind(this)});t.addItem(this._oIcon);t.addItem(this._oLink)};o.prototype._getLink=function(){return this._oLink};o.prototype._getIcon=function(){return this._oIcon};o.prototype._onLinkPress=function(t){const{ctrlKey:e,metaKey:n}=t.mParameters;this.fireLinkPress({ctrlKey:e,metaKey:n})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/List", ["./library","./ListBase","./ListRenderer"],function(e,r,a){"use strict";var t=e.BackgroundDesign;var i=r.extend("sap.m.List",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:t.Solid}}},renderer:a});i.prototype.getAriaRole=function(){return this._sAriaRole||"list"};i.prototype.applyAriaRole=function(e){this._sAriaRole=e};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ListBase", ["sap/base/i18n/Localization","sap/ui/core/ControlBehavior","sap/ui/events/KeyCodes","sap/ui/Device","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/ui/core/LabelEnablement","sap/ui/core/delegate/ItemNavigation","./library","sap/ui/core/library","./InstanceManager","./GrowingEnablement","./GroupHeaderListItem","./ListItemBase","./ListBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/core/InvisibleMessage","sap/m/table/Util","sap/ui/core/Lib","sap/ui/dom/jquery/Selectors","sap/ui/dom/jquery/Aria"],function(e,t,i,s,o,n,r,a,l,u,h,p,d,c,g,f,m,v,jQuery,y,I,_,S){"use strict";var b=h.ListType;var w=h.ListGrowingDirection;var T=h.SwipeDirection;var C=h.ListSeparators;var B=h.ListMode;var D=h.ListHeaderDesign;var R=h.Sticky;var M=h.MultiSelectMode;var x=p.TitleLevel;var L=n.extend("sap.m.ListBase",{metadata:{library:"sap.m",dnd:true,properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Misc",defaultValue:x.Auto},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:D.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:B.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:C.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:T.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:w.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:"Navigation"},sticky:{type:"sap.m.Sticky[]",group:"Appearance"},multiSelectMode:{type:"sap.m.MultiSelectMode",group:"Behavior",defaultValue:M.Default}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable",selector:"#{id} .sapMListItems",dnd:true},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",multiple:false,altTypes:["string"]}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},delete:{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"},swipeDirection:{type:"sap.m.SwipeDirection"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}}},designtime:"sap/m/designtime/ListBase.designtime"},renderer:m});L.prototype.bAnnounceDetails=true;L.getInvisibleText=function(){if(!this.oInvisibleText){this.oInvisibleText=(new a).toStatic()}return this.oInvisibleText};L.prototype.sNavItemClass="sapMLIB";L.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this._iItemNeedsNavigated=0;this._bItemsBeingBound=false;this._bSkippedInvalidationOnRebind=false;this.data("sap-ui-fastnavgroup","true",true)};L.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent()};L.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();this._startItemNavigation(true)};L.prototype.exit=function(){this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation()};L.prototype.refreshItems=function(e){this._bRefreshItems=true;if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(e)}else{if(!this._bReceivingData){this._updateStarted(e);this._bReceivingData=true}this.refreshAggregation("items")}};L.prototype.updateItems=function(e,t){if(t&&t.detailedReason==="AddVirtualContext"){A(this);if(this._oGrowingDelegate){this._oGrowingDelegate.reset(true)}return}else if(t&&t.detailedReason==="RemoveVirtualContext"){N(this);return}if(this._bSkippedInvalidationOnRebind&&this.getBinding("items").getLength()===0){this.invalidate()}if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(e)}else{if(this._bReceivingData){this._bReceivingData=false}else{this._updateStarted(e)}this.updateAggregation("items");this._updateFinished()}this._bSkippedInvalidationOnRebind=false};function A(e){var t=e.getBinding("items");var i=e.getBindingInfo("items");var s=e.getGrowing()?e.getGrowingThreshold():i.length;var o=e.getGrowing()||!i.startIndex?0:i.startIndex;var n=t.getContexts(o,s)[0];N(e);e._oVirtualItem=c.createItem(n,i,"virtual");e.addAggregation("dependents",e._oVirtualItem,true)}function N(e){if(e._oVirtualItem){e._oVirtualItem.destroy();delete e._oVirtualItem}}L.prototype.setBindingContext=function(e,t){var i=(this.getBindingInfo("items")||{}).model;if(i===t){this._resetItemsBinding()}return n.prototype.setBindingContext.apply(this,arguments)};L.prototype.bindAggregation=function(e){this._bItemsBeingBound=e==="items";N(this);n.prototype.bindAggregation.apply(this,arguments);this._bItemsBeingBound=false;return this};L.prototype._bindAggregation=function(e,t){function i(e,t,i){e.events=e.events||{};if(!e.events[t]){e.events[t]=i}else{var s=e.events[t];e.events[t]=function(){i.apply(this,arguments);s.apply(this,arguments)}}}if(e==="items"){this._resetItemsBinding();i(t,"dataRequested",this._onBindingDataRequestedListener.bind(this));i(t,"dataReceived",this._onBindingDataReceivedListener.bind(this))}n.prototype._bindAggregation.call(this,e,t)};L.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId}};L.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId}this._dataReceivedHandlerId=setTimeout(function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId}.bind(this),0);if(this._oGrowingDelegate){this._oGrowingDelegate._onBindingDataReceivedListener(e)}};L.prototype.destroyItems=function(e){if(!this.getItems(true).length){return this}this.destroyAggregation("items","KeepDom");if(!e){if(this._bItemsBeingBound){this._bSkippedInvalidationOnRebind=true}else{this.invalidate()}}return this};L.prototype.getItems=function(e){if(e){return this.mAggregations["items"]||[]}return this.getAggregation("items",[])};L.prototype.getId=function(e){var t=this.sId;return e?t+"-"+e:t};L.prototype.setGrowing=function(e){e=!!e;if(this.getGrowing()!=e){this.setProperty("growing",e,!e);if(e){this._oGrowingDelegate=new c(this)}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null}}return this};L.prototype.setGrowingThreshold=function(e){return this.setProperty("growingThreshold",e,true)};L.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);this._hideBusyIndicator();return this};L.prototype.setNoData=function(e){this.setAggregation("noData",e,true);if(typeof e==="string"){this.$("nodata-text").text(e)}else if(e){this.invalidate()}else if(!e){this.$("nodata-text").text(this.getNoDataText())}return this};L.prototype.setNoDataText=function(e){this.setProperty("noDataText",e,true);if(!this.getNoData()){this.$("nodata-text").text(this.getNoDataText())}return this};L.prototype.getNoDataText=function(e){if(e&&this._bBusy){return""}var t=this.getProperty("noDataText");t=t||S.getResourceBundleFor("sap.m").getText("LIST_NO_DATA");return t};L.prototype.getSelectedItem=function(){var e=this.getItems(true);for(var t=0;t<e.length;t++){if(e[t].getSelected()){return e[t]}}return null};L.prototype.setSelectedItem=function(e,t,i){if(this.indexOfItem(e)<0){y.warning("setSelectedItem is called without valid ListItem parameter on "+this);return}if(this._bSelectionMode){e.setSelected(t===undefined?true:!!t);i&&this._fireSelectionChangeEvent([e])}};L.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(e){return e.getSelected()})};L.prototype.setSelectedItemById=function(e,t){var i=o.byId(e);return this.setSelectedItem(i,t)};L.prototype.getSelectedContexts=function(e){const t=this.getBindingInfo("items");const i=t?.model;const s=this.getModel(i);if(!t||!s){return[]}if(e&&this.getRememberSelections()){if(s.isA("sap.ui.model.odata.v4.ODataModel")){const e=this.getBinding("items").getAllCurrentContexts?.()||[];return e.filter(e=>this._aSelectedPaths.includes(e.getPath()))}return this._aSelectedPaths.map(e=>s.getContext(e))}return this.getSelectedItems().map(e=>e.getBindingContext(i))};L.prototype.removeSelections=function(e,t,i){var s=[];this._oSelectedItem=null;if(e){this._aSelectedPaths=[];if(!i){const e=this.getBinding("items");const t=e?.getAllCurrentContexts?.()||[];t[0]?.setSelected&&t.forEach(e=>e.setSelected(false))}}this.getItems(true).forEach(function(t){if(!t.getSelected()){return}if(i&&t.isSelectedBoundTwoWay()){return}t.setSelected(false,true);s.push(t);!e&&this._updateSelectedPaths(t)},this);if(t&&s.length){this._fireSelectionChangeEvent(s)}return this};L.prototype.selectAll=function(e){if(this.getMode()!="MultiSelect"||this.getMultiSelectMode()==M.ClearAll){return this}var t=[];this.getItems(true).forEach(function(e){if(e.isSelectable()&&!e.getSelected()){e.setSelected(true,true);t.push(e);this._updateSelectedPaths(e)}},this);if(e&&t.length){this._fireSelectionChangeEvent(t,e)}var i=this.getItems().filter(function(e){return e.isSelectable()}).length;if(e&&this.getGrowing()&&this.getMultiSelectMode()==="SelectAll"&&this.getBinding("items").getLength()>i){var s=this._getSelectAllCheckbox?this._getSelectAllCheckbox():undefined;if(s){_.showSelectionLimitPopover(i,s)}}return this};L.prototype.getLastMode=function(e){return this._sLastMode};L.prototype.setMode=function(e){e=this.validateProperty("mode",e);var t=this.getMode();if(t==e){return this}this._bSelectionMode=e.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true)}else{var i=this.getSelectedItems();if(i.length>1){this.removeSelections(true)}else if(t===B.MultiSelect){this._oSelectedItem=i[0]}}return this.setProperty("mode",e)};L.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null};L.prototype.setRememberSelections=function(e){this.setProperty("rememberSelections",e,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this};L.prototype.setSelectedContextPaths=function(e){this._aSelectedPaths=e||[]};L.prototype.getSelectedContextPaths=function(e){if(!e||e&&this.getRememberSelections()){return this._aSelectedPaths.slice(0)}return this.getSelectedItems().map(function(e){return e.getBindingContextPath()})};L.prototype.isAllSelectableSelected=function(){if(this.getMode()!=B.MultiSelect){return false}var e=this.getItems(true),t=this.getSelectedItems().length,i=e.filter(function(e){return e.isSelectable()}).length;return e.length>0&&t==i};L.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(e){return e.getVisible()})};L.prototype.getActiveItem=function(){return this._bActiveItem};L.prototype.onItemDOMUpdate=function(e){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true)}var t=this.getVisibleItems().length>0;if(!t&&!this._bInvalidatedForNoData){this.invalidate();this._bInvalidatedForNoData=true}else if(t&&this._bInvalidatedForNoData){this.invalidate();this._bInvalidatedForNoData=false}};L.prototype.onItemActiveChange=function(e,t){this._bActiveItem=t};L.prototype.onItemHighlightChange=function(e,t){this._iItemNeedsHighlight+=t?1:-1;if(this._iItemNeedsHighlight==1&&t){this.$("listUl").addClass("sapMListHighlight")}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight")}};L.prototype.onItemNavigatedChange=function(e,t){this._iItemNeedsNavigated+=t?1:-1;if(this._iItemNeedsNavigated==1&&t){this.$("listUl").addClass("sapMListNavigated")}else if(this._iItemNeedsNavigated==0){this.$("listUl").removeClass("sapMListNavigated")}};L.prototype.onItemSelectedChange=function(e,t){if(this.getMode()==B.MultiSelect){this._updateSelectedPaths(e,t);return}if(t){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=e}else if(this._oSelectedItem===e){this._oSelectedItem=null}this._updateSelectedPaths(e,t)};L.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl")};L.prototype.getStickyFocusOffset=function(){return 0};L.prototype.checkGrowingFromScratch=function(){};L.prototype.onBeforePageLoaded=function(e,t){this._fireUpdateStarted(t,e);this.fireGrowingStarted(e)};L.prototype.onAfterPageLoaded=function(e,t){this._fireUpdateFinished(e);this.fireGrowingFinished(e)};L.prototype.addNavSection=function(e){this._aNavSections.push(e);return e};L.prototype.getMaxItemsCount=function(){var e=this.getBinding("items");if(e&&e.getLength){return e.getLength()||0}return this.getItems(true).length};L.prototype.shouldRenderItems=function(){return true};L.prototype.shouldGrowingSuppressInvalidation=function(){return true};L.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation&&document.activeElement.id!=this.getId("nodata")){this._oItemNavigation.iFocusedIndex=-1}}};L.prototype._updateStarted=function(e){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(e)}};L.prototype._fireUpdateStarted=function(e,t){this._sUpdateReason=v(e||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:t?t.actual:this.getItems(true).length,total:t?t.total:this.getMaxItemsCount()})};L.prototype.onThemeChanged=function(){if(this._oGrowingDelegate){this._oGrowingDelegate._updateTrigger()}};L.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false}};L.prototype._fireUpdateFinished=function(e){setTimeout(function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:e?e.actual:this.getItems(true).length,total:e?e.total:this.getMaxItemsCount()})}.bind(this),0)};L.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this.setBusy(true,"listUl")}};L.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;if(this.getEnableBusyIndicator()){this.setBusy(false,"listUl")}}};L.prototype.setBusy=function(e,t){if(this.getBusy()==e){return this}n.prototype.setBusy.apply(this,arguments);if(!e||!window.IntersectionObserver){clearTimeout(this._iBusyTimer);return this}this._iBusyTimer=setTimeout(function(){var e=this.getDomRef(t);var i=this.getDomRef("busyIndicator");var s=h.getScrollDelegate(this,true);if(!e||!i||!s){return}var o=new window.IntersectionObserver(function(e){o.disconnect();var t=e.pop();var s=t.intersectionRatio;if(s<=0||s>=1){return}var n=i.firstChild.style;if(t.intersectionRect.height>=t.rootBounds.height){n.position="sticky"}else{n.top=((t.boundingClientRect.top<0?1-s:0)+s/2)*100+"%"}},{root:s.getContainerDomRef()});o.observe(e)}.bind(this),this.getBusyIndicatorDelay());return this};L.prototype.onItemBindingContextSet=function(e){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return}if(e.isSelectedBoundTwoWay()){return}var t=e.getBindingContextPath();if(t){var i=this._aSelectedPaths.indexOf(t)>-1;e.setSelected(i)}};L.prototype.onItemRemoved=function(e){e._bGroupHeader=false;if(this._oLastGroupHeader==e){this._oLastGroupHeader=null}if(this._oSelectedItem==e){this._oSelectedItem=null}};L.prototype.onItemInserted=function(e,t){if(this._oLastGroupHeader&&!e.isGroupHeader()){this._oLastGroupHeader.setGroupedItem(e)}if(t){this.onItemSelectedChange(e,true)}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||e.isSelectedBoundTwoWay()||e.getSelected()){return}var i=e.getBindingContextPath();if(i&&this._aSelectedPaths.indexOf(i)>-1){e.setSelected(true)}};L.prototype.onItemSelect=function(e,t){var i=this.getMode();if(this._mRangeSelection){if(!this._mRangeSelection.selected){this._fireSelectionChangeEvent([e]);this._mRangeSelection.index=this.getVisibleItems().indexOf(e);this._mRangeSelection.selected=t;return}if(!t){e.setSelected(true);return}var s=this.indexOfItem(e),o=this.getItems(),n,r,a=[],l;if(s<this._mRangeSelection.index){n=this._mRangeSelection.index-s;l=-1}else{n=s-this._mRangeSelection.index;l=1}for(var u=1;u<=n;u++){r=o[this._mRangeSelection.index+u*l];if(r.isSelectable()&&r.getVisible()&&!r.getSelected()){r.setSelected(true);a.push(r)}else if(r===e){a.push(r)}}this._fireSelectionChangeEvent(a);return}if(i===B.MultiSelect||this._bSelectionMode&&t){this._fireSelectionChangeEvent([e]);if(this.getAriaRole()==="list"&&document.activeElement===e.getDomRef()){var h=S.getResourceBundleFor("sap.m");I.getInstance().announce(t?h.getText("LIST_ITEM_SELECTED"):h.getText("LIST_ITEM_NOT_SELECTED"),"Assertive")}}};L.prototype._fireSelectionChangeEvent=function(e,t){var i=e&&e[0];if(!i){return}this.fireSelectionChange({listItem:i,listItems:e,selected:i.getSelected(),selectAll:!!t});if(this.getGrowing()){this._bSelectAll=t}this.fireSelect({listItem:i})};L.prototype.onItemDelete=function(e){this.fireDelete({listItem:e})};L.prototype.onItemPress=function(e,t){if(e.getType()==b.Inactive){return}setTimeout(function(){this.fireItemPress({listItem:e,srcControl:t})}.bind(this),0)};L.prototype.onItemKeyDown=function(e,t){if(!t.shiftKey||t.ctrlKey||t.altKey||t.metaKey||t.code=="Tab"||this.getMode()!==B.MultiSelect||!e.isSelectable()||t.which===i.F6){if(this._mRangeSelection){this._mRangeSelection=null}return}var s=this.getVisibleItems(),o=s.some(function(e){return!!e.getSelected()});if(!o){return}if(!this._mRangeSelection){this._mRangeSelection={index:this.indexOfItem(e),selected:e.getSelected()}}};L.prototype.onItemKeyUp=function(e,t){if(t.which===i.SHIFT){this._mRangeSelection=null}};L.prototype._updateSelectedPaths=function(e,t){if(!this.getRememberSelections()||!this.isBound("items")){return}const i=this.getBindingInfo("items").model;const s=e.getBindingContext(i);const o=s?.getPath();if(!o){return}const n=this._aSelectedPaths.indexOf(o);t=t===undefined?e.getSelected():t;if(t){n<0&&this._aSelectedPaths.push(o)}else{n>-1&&this._aSelectedPaths.splice(n,1)}if(s.setSelected&&!s.isTransient()){s.setSelected(t)}};L.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null}};L.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null}};L.prototype._getTouchBlocker=function(){return this.$().children()};L.prototype._getSwipeContainer=function(){if(!this._$swipeContainer){this._$swipeContainer=jQuery("<div>",{id:this.getId("swp"),class:"sapMListSwp"})}return this._$swipeContainer};L.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top)}};L.prototype._renderSwipeContent=function(){var e=this._swipedItem.$(),t=this._getSwipeContainer();this.$().prepend(t.css({top:e.position().top,height:e.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var i=o.createRenderManager();i.render(this.getSwipeContent(),t.empty()[0]);i.destroy()}return this};L.prototype._swipeIn=function(){var e=this,t=e._getTouchBlocker(),i=e._getSwipeContainer();e._isSwipeActive=true;e._renderSwipeContent();d.addPopoverInstance(e);window.document.activeElement.blur();jQuery(window).on("resize.swp",function(){e._setSwipePosition()});t.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!i[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation()}});i.on("webkitAnimationEnd animationend",function(){jQuery(this).off("webkitAnimationEnd animationend");i.css("opacity",1).trigger("focus");t.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(t){if(!i[0].firstChild.contains(t.target)){e.swipeOut()}})}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim")};L.prototype._onSwipeOut=function(e){this._getSwipeContainer().css("opacity",0).remove();jQuery(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof e=="function"){e.call(this,this._swipedItem,this.getSwipeContent())}this._isSwipeActive=false;d.removePopoverInstance(this)};L.prototype.swipeOut=function(e){if(!this._isSwipeActive){return this}var t=this,i=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");i.on("webkitAnimationEnd animationend",function(){jQuery(this).off("webkitAnimationEnd animationend");t._onSwipeOut(e)}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this};L.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut()}};L.prototype.close=L.prototype._removeSwipeContent;L.prototype._onSwipe=function(e,t){var i=this.getSwipeContent(),o=e.srcControl;if(i&&o&&!this._isSwipeActive&&this!==o&&!this._eventHandledByControl&&s.support.touch){for(var n=o;n&&!(n instanceof f);n=n.oParent);if(n instanceof f){this._swipedItem=n;this.fireSwipe({listItem:this._swipedItem,swipeContent:i,srcControl:o,swipeDirection:t},true)&&this._swipeIn()}}};L.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked()};L.prototype.onswipeleft=function(t){var i=e.getRTL();var s=i?T.EndToBegin:T.BeginToEnd;var o=this.getSwipeDirection();if(o===T.LeftToRight){o=T.BeginToEnd}else if(o===T.RightToLeft){o=T.EndToBegin}if(o!=s){if(o==T.Both){o=i?T.BeginToEnd:T.EndToBegin}this._onSwipe(t,o)}};L.prototype.onswiperight=function(t){var i=e.getRTL();var s=i?T.BeginToEnd:T.EndToBegin;var o=this.getSwipeDirection();if(o===T.LeftToRight){o=T.BeginToEnd}else if(o===T.RightToLeft){o=T.EndToBegin}if(o!=s){if(o==T.Both){o=i?T.EndToBegin:T.BeginToEnd}this._onSwipe(t,o)}};L.prototype.setSwipeDirection=function(e){return this.setProperty("swipeDirection",e,true)};L.prototype.getSwipedItem=function(){return this._isSwipeActive?this._swipedItem:null};L.prototype.setSwipeContent=function(e){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!e);return this.setAggregation("swipeContent",e,!this._isSwipeActive)};L.prototype.invalidate=function(e){if(e&&e===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return}return n.prototype.invalidate.apply(this,arguments)};L.prototype.addItemGroup=function(e,t,i){if(!t){t=this.getGroupHeaderTemplate(e)}t._bGroupHeader=true;this.addAggregation("items",t,i);this.setLastGroupHeader(t);return t};L.prototype.getGroupHeaderTemplate=function(e){var t=new g;t.setTitle(e.text||e.key);return t};L.prototype.setLastGroupHeader=function(e){this._oLastGroupHeader=e};L.prototype.getLastGroupHeader=function(){return this._oLastGroupHeader};L.prototype.removeGroupHeaders=function(e){this.getItems(true).forEach(function(t){if(t.isGroupHeader()){t.destroy(e)}})};L.prototype.getAccessibilityType=function(){return S.getResourceBundleFor("sap.m").getText("ACC_CTR_TYPE_LIST")};L.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return""}var e="",t=B,i=this.getMode(),s=S.getResourceBundleFor("sap.m");if(l.isRequired(this)){e+=s.getText("LIST_REQUIRED")+" "}if(i==t.Delete){e+=s.getText("LIST_DELETABLE")+" . "}else if(this.getAriaRole()=="list"){if(i==t.MultiSelect){e+=s.getText("LIST_MULTISELECTABLE")+" . "}else if(i!=t.None){e+=s.getText("LIST_SELECTABLE")+" . "}}if(this.isGrouped()){e+=s.getText("LIST_GROUPED")+" . "}return e};L.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityStates().trim(),focusable:true}};L.prototype.getAccessbilityPosition=function(e){var t,i,s=this.getVisibleItems(),o=this.getAriaRole(),n=o==="list"||o==="listbox";if(n){s=s.filter(function(e){return!e.isGroupHeader()})}if(e){i=s.indexOf(e)+1}var r=this.getBinding("items");if(r&&this.getGrowing()&&this.getGrowingScrollToLoad()){t=r.getLength();if(!n&&r.isGrouped()){t+=s.filter(function(e){return e.isGroupHeader()}).length}}else{t=s.length}return{setsize:t,posinset:i}};L.prototype.onItemFocusIn=function(e,i,s){this._handleStickyItemFocus(e.getDomRef());if(e!==i||s.isMarked("contentAnnouncementGenerated")||!t.isAccessibilityEnabled()){return}var o=e.getDomRef();if(!e.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",o.id)}else{var n=e.getAccessibilityInfo(),r=S.getResourceBundleFor("sap.m"),a=n.type?n.type+" . ":"";if(this.isA("sap.m.Table")){var l=this.getAccessbilityPosition(e);a+=r.getText("LIST_ITEM_POSITION",[l.posinset,l.setsize])+" . "}a+=n.description;this.updateInvisibleText(a,o);return a}};L.prototype.onItemFocusOut=function(e){this.removeInvisibleTextAssociation(e.getDomRef())};L.prototype.removeInvisibleTextAssociation=function(e){const t=L.getInvisibleText(),i=jQuery(e||document.activeElement);i.removeAriaLabelledBy(t.getId())};L.prototype.updateInvisibleText=function(e,t,i){var s=L.getInvisibleText(),o=jQuery(t||document.activeElement);if(this.bAnnounceDetails){this.bAnnounceDetails=false;e=this.getAccessibilityInfo().description+" "+e}s.setText(e.trim());o.addAriaLabelledBy(s.getId(),i)};L.prototype.getNavigationRoot=function(){return this.getDomRef("listUl")};L.prototype.getFocusDomRef=function(){return this.getNavigationRoot()};L.prototype._startItemNavigation=function(e){var t=this.getDomRef();if(!s.system.desktop||!t){return}if(!this.getShowNoData()&&!this.getVisibleItems().length&&t){t.classList.add("sapMListPreventFocus");this._destroyItemNavigation();return}if(t){t.classList.remove("sapMListPreventFocus")}var i=this.getNavigationRoot();if(e&&i&&!i.contains(document.activeElement)){this._bItemNavigationInvalidated=true;i.tabIndex="0";return}if(!this._oItemNavigation){this._oItemNavigation=new u;this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setTabIndex0(0);this._oItemNavigation.iActiveTabIndex=-1;this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"]})}this._oItemNavigation.setPageSize(this.getGrowingThreshold());this._oItemNavigation.setRootDomRef(i);this.setNavigationItems(this._oItemNavigation,i);this._bItemNavigationInvalidated=false;if(document.activeElement==i){jQuery(i).trigger("focus")}};L.prototype.setNavigationItems=function(e,t){var i=jQuery(t).children(".sapMLIB").get();e.setItemDomRefs(i);if(e.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==w.Upwards){e.setFocusedIndex(i.length-1)}else{e.setFocusedIndex(0)}}};L.prototype.getItemNavigation=function(){return this._oItemNavigation};L.prototype.forwardTab=function(e){this._bIgnoreFocusIn=true;this.$(e?"after":"before").trigger("focus")};L.prototype.onsaptabnext=L.prototype.onsaptabprevious=function(e){if(e.isMarked()||e.target.id==this.getId("trigger")){return}if(e.target.matches(".sapMLIBFocusable,.sapMTblCellFocusable")||e.target===jQuery(this.getNavigationRoot()).find(":sapTabbable").get(e.type=="saptabnext"?-1:0)){this.forwardTab(e.type=="saptabnext");e.setMarked()}};L.prototype._navToSection=function(e){var t;var i=0;var s=e?1:-1;var o=this._aNavSections.length;this._aNavSections.some(function(e,t){var s=e?window.document.getElementById(e):null;if(s&&s.contains(document.activeElement)){i=t;return true}});var n=this.getItemsContainerDomRef();var r=jQuery(document.getElementById(this._aNavSections[i]));if(r[0]===n&&this._oItemNavigation){r.data("redirect",this._oItemNavigation.getFocusedIndex())}this._aNavSections.some(function(){i=(i+s+o)%o;t=jQuery(document.getElementById(this._aNavSections[i]));if(t[0]===n&&this._oItemNavigation){var e=t.data("redirect");var r=this._oItemNavigation.getItemDomRefs();var a=r[e]||n.children[0];t=jQuery(a)}if(t.is(":focusable")){t.trigger("focus");return true}},this);return t};L.prototype.onsapshow=function(e){if(e.isMarked()||e.which==i.F4||e.target.id!=this.getId("trigger")&&!jQuery(e.target).hasClass(this.sNavItemClass)){return}if(this._navToSection(true)){e.preventDefault();e.setMarked()}};L.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!jQuery(e.target).hasClass(this.sNavItemClass)){return}if(this._navToSection(false)){e.preventDefault();e.setMarked()}};L.prototype.onkeydown=function(e){if(e.isMarked()){return}var t=jQuery(e.target);var i=t.closest(".sapMLIBFocusable").next(".sapMListTblSubRow").addBack();if(!i[0]){i=t.closest(".sapMListTblSubRow").prev(".sapMLIBFocusable").addBack()}if(!i[0]){return}var s=t.hasClass("sapMLIBFocusable");var o=function(){e.preventDefault();e.setMarked()};if(e.code=="KeyA"&&(e.metaKey||e.ctrlKey)&&s&&this.getMode()==B.MultiSelect){var n=this.getMultiSelectMode()==M.ClearAll;if(e.shiftKey){if(n){this.removeSelections(false,true)}}else if(!n){if(this.isAllSelectableSelected()){this.removeSelections(false,true)}else{this.selectAll(true)}}return o()}if((e.code=="Enter"||e.code=="F2")&&t.hasClass("sapMTblCellFocusable")){t.find(":sapTabbable").first().trigger("focus");return o()}if(e.code=="F2"&&s||e.code=="F7"&&s&&this._iFocusIndexOfItem==undefined){i.find(":sapTabbable").first().trigger("focus");return o()}if(e.code=="F2"&&!s){jQuery(t.closest(".sapMTblCellFocusable")[0]||i[0]).trigger("focus");return o()}if(e.code=="F7"){if(s){i.find(":sapFocusable").eq(this._iFocusIndexOfItem).trigger("focus")}else{this._iFocusIndexOfItem=i.find(":sapFocusable").index(t);i.eq(0).trigger("focus")}return o()}};L.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation()}if(e.shiftKey&&this._mRangeSelection&&e.srcControl.getId().includes("-selectMulti")){e.preventDefault()}};L.prototype.focusPrevious=function(){if(!this._oItemNavigation){return}var e=this._oItemNavigation.getItemDomRefs();var t=this._oItemNavigation.getFocusedIndex();var i=jQuery(e[t]);this.bAnnounceDetails=true;if(this.getKeyboardMode()=="Edit"){var s=i.find(":sapTabbable").first();s[0]?s.trigger("focus"):i.trigger("focus")}else{i.trigger("focus")}};L.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return}if(this._bItemNavigationInvalidated){this._startItemNavigation()}var t=e.target;if(t.id==this.getId("nodata")){var i=this.getNoData();var s=i||this.getNoDataText();if(i&&typeof i!=="string"){s=f.getAccessibilityText(i)}this.updateInvisibleText(s,t)}else if(t.id==this.getId("listUl")&&this.getKeyboardMode()=="Edit"){this.focusPrevious();e.stopImmediatePropagation(true);return}if(this._oItemNavigation&&!t.matches(".sapMLIBFocusable,.sapMTblCellFocusable")){var o=t.closest(".sapMLIBFocusable,.sapMTblCellFocusable");if(o){var n=this._oItemNavigation.getItemDomRefs().indexOf(o);if(n>=0){this._oItemNavigation.iFocusedIndex=this.getKeyboardMode()=="Edit"?n:n-n%this._oItemNavigation.iColumns}}}if(e.isMarked()||!this._oItemNavigation||t.id!=this.getId("after")){return}this.focusPrevious();e.setMarked()};L.prototype.onsapfocusleave=function(e){if(this._oItemNavigation&&!this.bAnnounceDetails&&!this.getNavigationRoot().contains(document.activeElement)){this.bAnnounceDetails=true}};L.prototype.onItemArrowUpDown=function(e,t){if(t.target instanceof HTMLTextAreaElement){return}var i=this.getVisibleItems(true),s=t.type=="sapup"||t.type=="sapupmodifiers"?-1:1,o=i.indexOf(e)+s,n=i[o];if(n&&n.isGroupHeader()){n=i[o+s]}if(!n){return}var r=n.getTabbables(),a=e.getTabbables().index(t.target),l=r.eq(r[a]?a:-1);l[0]?l.trigger("focus"):n.focus();l[0]&&l[0].select&&l[0].select();t.preventDefault();t.setMarked()};L.prototype.onItemContextMenu=function(e,t){var i=this.getContextMenu();if(!i){return}var s=this.fireBeforeOpenContextMenu({listItem:e,column:o.byId(jQuery(t.target).closest(".sapMListTblCell",this.getNavigationRoot()).attr("data-sap-ui-column"))});if(s){t.setMarked();t.preventDefault();var n,r=this.getBindingInfo("items");if(r){n=e.getBindingContext(r.model);i.setBindingContext(n,r.model)}i.openAsContextMenu(t,e)}};L.prototype.onItemUpDownModifiers=function(e,t,i){if(t.srcControl!=e){if(!t.shiftKey&&(t.metaKey||t.ctrlKey)){this.onItemArrowUpDown(e,t)}return}if(!this._mRangeSelection){return}var s=this.getVisibleItems(),o=s.indexOf(e),n=s[o+i];if(!n){if(this._mRangeSelection){this._mRangeSelection=null}t.setMarked();return}var r=n.getSelected();if(this._mRangeSelection.direction===undefined){this._mRangeSelection.direction=i}else if(this._mRangeSelection.direction!==i){if(this._mRangeSelection.index!==s.indexOf(e)){n=e;r=n.getSelected();if(this._mRangeSelection.selected&&r){this.setSelectedItem(n,false,true);return}}else{this._mRangeSelection.direction=i}}if(this._mRangeSelection.selected!==r&&n.isSelectable()){this.setSelectedItem(n,this._mRangeSelection.selected,true)}};L.prototype.isGrouped=function(){var e=this.getBinding("items");return e&&e.isGrouped()};L.prototype.setContextMenu=function(e){this.setAggregation("contextMenu",e,true);return this};L.prototype.destroyContextMenu=function(){this.destroyAggregation("contextMenu",true);return this};L.prototype.getStickyStyleValue=function(){var e=this.getSticky();if(!e||!e.length){this._iStickyValue=0;return this._iStickyValue}var t=0,i=this.getHeaderText(),s=this.getHeaderToolbar(),o=i||s&&s.getVisible(),n=this.getInfoToolbar(),r=n&&n.getVisible(),a=false;if(this.isA("sap.m.Table")){a=this.getColumns().some(function(e){return e.getVisible()&&e.getHeader()})}e.forEach(function(e){if(e===R.HeaderToolbar&&o){t+=1}else if(e===R.InfoToolbar&&r){t+=2}else if(e===R.ColumnHeaders&&a){t+=4}});this._iStickyValue=t;return this._iStickyValue};L.prototype._handleStickyItemFocus=function(e){if(!this._iStickyValue){return}var t=h.getScrollDelegate(this,true);if(!t){return}var i=0,s=0,o=0,n=0,r=0,a=0,l=this.getStickyFocusOffset();if(this._iStickyValue&4){var u=this.getDomRef("tblHeader").firstChild;var p=u.getBoundingClientRect();s=parseInt(p.bottom);i=parseInt(p.height)}if(this._iStickyValue&2){var d=this.getDomRef().querySelector(".sapMListInfoTBarContainer");if(d){var c=d.getBoundingClientRect();n=parseInt(c.bottom);o=parseInt(c.height)}}if(this._iStickyValue&1){var g=this.getDomRef().querySelector(".sapMListHdr");if(g){var f=g.getBoundingClientRect();a=parseInt(f.bottom);r=parseInt(f.height)}}var m=Math.round(e.getBoundingClientRect().top);if(s>m||n>m||a>m){window.requestAnimationFrame(function(){t.scrollToElement(e,0,[0,-i-o-r-l],true)})}};L.prototype.setHeaderToolbar=function(e){return this._setToolbar("headerToolbar",e)};L.prototype.setInfoToolbar=function(e){return this._setToolbar("infoToolbar",e)};L.prototype.scrollToIndex=function(e){return new Promise(function(t,i){var s,o;o=h.getScrollDelegate(this,true);if(!o){return i()}s=E(this,e);if(!s){return i()}setTimeout(function(){try{o.scrollToElement(s.getDomRef(),null,[0,this._getStickyAreaHeight()*-1],true);t()}catch(e){i(e)}}.bind(this),0)}.bind(this))};L.prototype.requestItems=function(e){if(e<=0||!this.getGrowing()||!this._oGrowingDelegate){throw new Error("The prerequisites to use 'requestItems' are not met. Please read the documentation for more details.")}if(e!=null){var t=this.getGrowingThreshold();this.setGrowingThreshold(e);this._oGrowingDelegate.requestNewPage();this.setGrowingThreshold(t)}else{this._oGrowingDelegate.requestNewPage()}};function E(e,t){var i=e.getVisibleItems();var s=i.length;if(typeof t!=="number"||t<-1){t=0}if(t>=s||t===-1){t=s-1}return i[t]}L.prototype._setFocus=function(e,t){return new Promise(function(i,s){var o=E(this,e);if(!o){return s()}if(t===true){var n=o.getTabbables(true);if(n.length){n[0].focus();return i()}}o.focus();return i()}.bind(this))};L.prototype._getStickyAreaHeight=function(){var e=this.getSticky();if(!(e&&e.length)){return 0}return e.reduce(function(e,t){var i,s;switch(t){case R.HeaderToolbar:i=this.getHeaderToolbar();s=i&&i.getDomRef()||this.getDomRef("header");break;case R.InfoToolbar:i=this.getInfoToolbar();s=i&&i.getDomRef();break;case R.ColumnHeaders:s=this.getDomRef("tblHeader");break;default:}return e+(s?s.offsetHeight:0)}.bind(this),0)};L.prototype._setToolbar=function(e,t){var i=this.getAggregation(e);if(i){i.detachEvent("_change",this._onToolbarPropertyChanged,this)}this.setAggregation(e,t);if(t){t.attachEvent("_change",this._onToolbarPropertyChanged,this)}return this};L.prototype._onToolbarPropertyChanged=function(e){if(e.getParameter("name")!=="visible"){return}var t=this._iStickyValue,i=this.getStickyStyleValue();if(t!==i){var s=this.getDomRef();if(s){var o=s.classList;o.toggle("sapMSticky",!!i);o.remove("sapMSticky"+t);o.toggle("sapMSticky"+i,!!i)}}};L.prototype.getAriaRole=function(){return"list"};return L});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ListBaseRenderer", ["sap/m/library","sap/ui/core/library","sap/ui/Device","sap/ui/core/InvisibleText","./ListItemBaseRenderer"],function(e,t,r,a,i){"use strict";var s=e.ListGrowingDirection;var n=e.ToolbarDesign;var o=t.TitleLevel;var l={apiVersion:2};l.ModeOrder={None:0,Delete:1,MultiSelect:-1,SingleSelect:1,SingleSelectLeft:-1,SingleSelectMaster:0};l.render=function(e,t){e.openStart("div",t);e.class("sapMList");if(t.getInset()){e.class("sapMListInsetBG")}e.style("width",t.getWidth());if(t.getBackgroundDesign){e.class("sapMListBG"+t.getBackgroundDesign())}var r=t.getTooltip_AsString();if(r){e.attr("title",r)}var a=t.getStickyStyleValue();if(a){e.class("sapMSticky");e.class("sapMSticky"+a)}this.renderContainerAttributes(e,t);e.openEnd();e.renderControl(t.getAggregation("_messageStrip"));var i=t.getHeaderText();var l=t.getHeaderToolbar();if(l){l.setDesign(n.Transparent,true);l.addStyleClass("sapMListHdr");l.addStyleClass("sapMListHdrTBar");l.addStyleClass("sapMTBHeader-CTX");e.renderControl(l)}else if(i){e.openStart("div",t.getId("header"));e.attr("role","heading");var d=t.getHeaderLevel();if(d!=o.Auto){e.attr("aria-level",d[d.length-1])}e.class("sapMListHdr").class("sapMListHdrText").openEnd();e.text(i);e.close("div")}var g=t.getInfoToolbar();if(g){g.setDesign(n.Info,true);g.addStyleClass("sapMListInfoTBar");e.openStart("div").class("sapMListInfoTBarContainer").openEnd();e.renderControl(g);e.close("div")}var c=t.getItems(),p=t.getShowNoData(),f=t.shouldRenderItems()&&c.length,u=t.getGrowingDirection()==s.Upwards&&t.getGrowing();if(u){this.renderGrowing(e,t)}this.renderDummyArea(e,t,"before","-1");this.renderListStartAttributes(e,t);e.class("sapMListUl");if(t._iItemNeedsHighlight){e.class("sapMListHighlight")}if(f||p){e.attr("tabindex","0")}e.class("sapMListShowSeparators"+t.getShowSeparators());e.class("sapMListMode"+t.getMode());if(t._iItemNeedsNavigated){e.class("sapMListNavigated")}e.openEnd();this.renderListHeadAttributes(e,t);if(f){if(u){c.reverse()}for(var v=0;v<c.length;v++){e.renderControl(c[v])}}var S=t.getVisibleItems().length>0;if(p&&(!f||!S)){this.renderNoData(e,t)}this.renderListEndAttributes(e,t);this.renderDummyArea(e,t,"after","0");if(!u){this.renderGrowing(e,t)}if(t.getFooterText()){e.openStart("footer",t.getId("footer")).class("sapMListFtr").openEnd();e.text(t.getFooterText());e.close("footer")}e.close("div")};l.renderContainerAttributes=function(e,t){};l.renderListHeadAttributes=function(e,t){};l.renderListStartAttributes=function(e,t){e.openStart("ul",t.getId("listUl"));e.class("sapMListItems");t.addNavSection(t.getId("listUl"));e.accessibilityState(t,this.getAccessibilityState(t))};l.getNoDataAriaRole=function(e){return null};l.getAriaLabelledBy=function(e){var t=e.getHeaderToolbar();if(t){var r=t.getTitleControl();if(r){var a=r.getId();if(e.getAriaLabelledBy().indexOf(a)===-1){return a}}}else if(e.getHeaderText()){return e.getId("header")}};l.getAriaDescribedBy=function(e){if(e.getFooterText()){return e.getId("footer")}};l.getAccessibilityState=function(e){var t=e.getAriaRole();return{role:t,multiselectable:t!="list"&&e._bSelectionMode?e.getMode()=="MultiSelect":undefined,labelledby:{value:this.getAriaLabelledBy(e),append:true},describedby:{value:this.getAriaDescribedBy(e),append:true}}};l.renderListEndAttributes=function(e,t){e.close("ul")};l.renderNoData=function(e,t){e.openStart("li",t.getId("nodata"));e.attr("tabindex","-1");var r=this.getNoDataAriaRole(t);if(r){e.attr("role",r)}e.class("sapMLIB").class("sapMListNoData").class("sapMLIBTypeInactive");i.addFocusableClasses.call(i,e);e.openEnd();e.openStart("div",t.getId("nodata-text")).class("sapMListNoDataText");var a=t.getNoData();if(a&&typeof a!=="string"){e.class("sapMListNoDataContent")}e.openEnd();this.renderNoDataArea(e,t);e.close("div");e.close("li")};l.renderNoDataArea=function(e,t){var r=t.getNoData()||t.getNoDataText();if(typeof r==="string"){e.text(r)}else{e.renderControl(r)}};l.renderDummyArea=function(e,t,a,i){e.openStart("div",t.getId(a)).attr("role","none").attr("tabindex",i);if(r.system.desktop){e.class("sapMListDummyArea");if(a=="after"){e.class("sapMListDummyAreaSticky")}}e.openEnd().close("div")};l.renderGrowing=function(e,t){var r=t._oGrowingDelegate;if(r){r.render(e)}};l.getAriaAnnouncement=function(e){return a.getStaticId("sap.m",e)};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ListItemBase", ["sap/ui/base/DataType","sap/ui/model/BindingMode","sap/ui/Device","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Icon","sap/ui/core/InvisibleText","sap/ui/core/theming/Parameters","sap/ui/core/ShortcutHintsMixin","./library","./Button","./CheckBox","./RadioButton","./ListItemBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/ui/core/Lib","sap/ui/dom/jquery/Selectors"],function(t,e,i,o,s,n,r,a,l,c,h,u,p,d,f,g,jQuery,y){"use strict";var I=h.ListMode;var T=h.ListType;var S=h.ButtonType;var _=o.MessageType;var m=s.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:T.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designtime:"sap/m/designtime/ListItemBase.designtime",dnd:true},renderer:f});m.getAccessibilityText=function(t,e,i){var o=y.getResourceBundleFor("sap.m");if(!t||!t.getVisible||!t.getVisible()){return e?o.getText("CONTROL_EMPTY"):""}var s;if(t.getAccessibilityInfo){s=t.getAccessibilityInfo()}if(!s||!t.getAccessibilityInfo){s=this.getDefaultAccessibilityInfo(t.getDomRef())}s=jQuery.extend({type:"",description:"",children:[]},s);var n=s.type+" "+s.description+" ",r=t.getTooltip_AsString();if(s.required===true){n+=o.getText(i?"CONTROL_IN_COLUMN_REQUIRED":"ELEMENT_REQUIRED")+" "}if(s.enabled===false){n+=o.getText("CONTROL_DISABLED")+" "}if(s.editable===false){n+=o.getText("CONTROL_READONLY")+" "}if(!s.type&&r&&n.indexOf(r)==-1){n=r+" "+n}s.children.forEach(function(t){n+=m.getAccessibilityText(t)+" "});n=n.trim();if(e&&!n){n=o.getText("CONTROL_EMPTY")}return n};m.getDefaultAccessibilityInfo=function(t){if(!t){return null}var e=[],i=window.Node,o=window.NodeFilter,s=document.createTreeWalker(t,o.SHOW_TEXT+o.SHOW_ELEMENT);while(s.nextNode()){var n=s.currentNode;if(n.nodeType===i.TEXT_NODE){var r=(n.nodeValue||"").trim();if(r){e.push(r)}}}return{description:e.join(" ")}};m.prototype.DetailIconURI=n.getIconURI("edit");m.prototype.NavigationIconURI=n.getIconURI("slim-arrow-right");m.prototype.TagName="li";m.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;this._bNeedsNavigated=false};m.prototype.onBeforeRendering=function(){this._oDomRef=this.getDomRef()};m.prototype.onAfterRendering=function(){if(!this._oDomRef||this._oDomRef!==this.getDomRef()){this.informList("DOMUpdate",true)}this._oDomRef=undefined;this._checkHighlight();this._checkNavigated()};m.prototype.invalidate=function(){if(!this.bOutput){return}s.prototype.invalidate.apply(this,arguments)};m.prototype.getBindingContextPath=function(t){var e=this.getList();if(e&&!t){t=(e.getBindingInfo("items")||{}).model}var i=this.getBindingContext(t);if(i){return i.getPath()}};m.prototype.isSelectedBoundTwoWay=function(){var t=this.getBinding("selected");if(t&&t.getBindingMode()==e.TwoWay){return true}};m.prototype.getList=function(){var t=this.getParent();if(t&&t.isA("sap.m.ListBase")){return t}};m.prototype.getListProperty=function(t,e){var i=this.getList();if(i){t=g(t);return i["get"+t]()}return e};m.prototype.informList=function(t,e,i){var o=this.getList();if(o){var s="onItem"+t;if(o[s]){o[s](this,e,i)}}};m.prototype.informSelectedChange=function(t){var e=this.getList();if(e){e.onItemSelectedChange(this,t);this.bSelectedDelayed=undefined}else{this.bSelectedDelayed=t}};m.prototype.getAccessibilityType=function(t){return this.getListProperty("ariaRole")=="list"?t.getText("ACC_CTR_TYPE_LISTITEM"):""};m.prototype.getGroupAnnouncement=function(){return this.$().prevAll(".sapMGHLI:first").text()};m.prototype.getAccessibilityDescription=function(t){var e=[],i=this.getType(),o=this.getHighlight(),s=this.getListProperty("ariaRole")==="tree";if(this.getSelected()&&!s){e.push(t.getText("LIST_ITEM_SELECTED"))}if(o!==_.None){var n=this.getHighlightText();if(o in _&&!n){n=t.getText("LIST_ITEM_STATE_"+o.toUpperCase())}e.push(n)}if(this.getUnread()&&this.getListProperty("showUnread")){e.push(t.getText("LIST_ITEM_UNREAD"))}if(this.getCounter()){e.push(t.getText("LIST_ITEM_COUNTER",[this.getCounter()]))}if(i==T.Navigation){e.push(t.getText("LIST_ITEM_NAVIGATION"))}else{if(i==T.Active||i==T.DetailAndActive){e.push(t.getText("LIST_ITEM_ACTIVE"))}}var r=this.getGroupAnnouncement()||"";if(r){e.push(r)}if(this.getContentAnnouncement){var a=(this.getContentAnnouncement(t)||"").trim();a&&e.push(a)}if(this.getListProperty("ariaRole")=="list"&&!s&&this.isSelectable()&&!this.getSelected()){e.push(t.getText("LIST_ITEM_NOT_SELECTED"))}return e.join(" . ")};m.prototype.getAccessibilityInfo=function(){var t=y.getResourceBundleFor("sap.m");return{type:this.getAccessibilityType(t),description:this.getAccessibilityDescription(t),focusable:true}};m.prototype.getMode=function(){return this.getListProperty("mode","")};m.prototype.updateAccessibilityState=function(t){var e=this.$();if(!e.length){return}var i=e.parent().children(".sapMLIB");e.attr(jQuery.extend({"aria-setsize":i.length,"aria-posinset":i.index(e)+1},t))};m.prototype.getDeleteControl=function(t){if(!t||this._oDeleteControl){return this._oDeleteControl}if(!this.DeleteIconURI){m.prototype.DeleteIconURI=n.getIconURI(l.get({name:"_sap_m_ListItemBase_DeleteIcon"})||"decline")}this._oDeleteControl=new u({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:S.Transparent,tooltip:y.getResourceBundleFor("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(t){this.informList("Delete")},this);c.addConfig(this._oDeleteControl,{messageBundleKey:"LIST_ITEM_DELETE_SHORTCUT"},this._oDeleteControl);this._oDeleteControl.useEnabledPropagator(false);return this._oDeleteControl};m.prototype.onThemeChanged=function(){m.prototype.DeleteIconURI=n.getIconURI(l.get({name:"_sap_m_ListItemBase_DeleteIcon"}));if(this._oDeleteControl){this._oDeleteControl.setIcon(this.DeleteIconURI)}};m.prototype.getDetailControl=function(t){if(!t||this._oDetailControl){return this._oDetailControl}this._oDetailControl=new u({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:S.Transparent,tooltip:y.getResourceBundleFor("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress()},this);c.addConfig(this._oDetailControl,{messageBundleKey:i.os.macintosh?"LIST_ITEM_EDIT_SHORTCUT_MAC":"LIST_ITEM_EDIT_SHORTCUT"},this._oDetailControl);this._oDetailControl.useEnabledPropagator(false);return this._oDetailControl};m.prototype.getNavigationControl=function(t){if(!t||this._oNavigationControl){return this._oNavigationControl}this._oNavigationControl=new r({id:this.getId()+"-imgNav",src:this.NavigationIconURI,tooltip:y.getResourceBundleFor("sap.m").getText("LIST_ITEM_NAVIGATION_ICON"),useIconTooltip:false,decorative:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl};m.prototype.getSingleSelectControl=function(t){if(!t||this._oSingleSelectControl){t&&this._oSingleSelectControl.setSelected(this.getSelected());return this._oSingleSelectControl}this._oSingleSelectControl=new d({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected(),ariaLabelledBy:a.getStaticId("sap.m","LIST_ITEM_SELECTION")}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).attachSelect(function(t){var e=t.getParameter("selected");this.setSelected(e);this.informList("Select",e)},this);this._oSingleSelectControl.useEnabledPropagator(false);return this._oSingleSelectControl};m.prototype.getMultiSelectControl=function(t){if(!t||this._oMultiSelectControl){t&&this._oMultiSelectControl.setSelected(this.getSelected());return this._oMultiSelectControl}this._oMultiSelectControl=new p({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected(),ariaLabelledBy:a.getStaticId("sap.m","LIST_ITEM_SELECTION")}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).addEventDelegate({onkeydown:function(t){this.informList("KeyDown",t)},onkeyup:function(t){this.informList("KeyUp",t)}},this).attachSelect(function(t){var e=t.getParameter("selected");this.setSelected(e);this.informList("Select",e)},this);this._oMultiSelectControl.useEnabledPropagator(false);return this._oMultiSelectControl};m.prototype.getModeControl=function(t){var e=this.getMode();if(!e||e==I.None){return}if(e==I.Delete){return this.getDeleteControl(t)}if(e==I.MultiSelect){return this.getMultiSelectControl(t)}return this.getSingleSelectControl(t)};m.prototype.getTypeControl=function(t){var e=this.getType();if(e==T.Detail||e==T.DetailAndActive){return this.getDetailControl(t)}if(e==T.Navigation){return this.getNavigationControl(t)}};m.prototype.destroyControls=function(t){t.forEach(function(t){t="_o"+t+"Control";if(this[t]){this[t].destroy("KeepDom");this[t]=null}},this)};m.prototype.isActionable=function(t){if(t&&!i.system.desktop){return false}return this.isIncludedIntoSelection()||this.getType()!=T.Inactive&&this.getType()!=T.Detail};m.prototype.exit=function(){this._oDomRef=null;this._oLastFocused=null;this._checkHighlight(false);this._checkNavigated(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"])};m.prototype.setHighlight=function(e){if(e==null){e=_.None}else if(!t.getType("sap.ui.core.MessageType").isValid(e)&&!t.getType("sap.ui.core.IndicationColor").isValid(e)){throw new Error('"'+e+'" is not a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor for property "highlight" of '+this)}return this.setProperty("highlight",e)};m.prototype.isSelectable=function(){var t=this.getMode();return!(t==I.None||t==I.Delete)};m.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected")}return false};m.prototype.isSelected=m.prototype.getSelected;m.prototype.setSelected=function(t,e){t=this.validateProperty("selected",t);if(!this.isSelectable()||t==this.getSelected()){return this}if(!e){this.informSelectedChange(t)}var i=this.getModeControl();if(i){i.setSelected(t)}this.updateSelectedDOM(t,this.$());this.setProperty("selected",t,true);return this};m.prototype.updateSelectedDOM=function(t,e){e.toggleClass("sapMLIBSelected",t);if(e.attr("role")!=="listitem"){e.attr("aria-selected",t)}};m.prototype.setParent=function(t){if(!t){this.informList("Removed")}s.prototype.setParent.apply(this,arguments);this.informList("Inserted",this.bSelectedDelayed);return this};m.prototype.setBindingContext=function(){s.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this};m.prototype.isGroupHeader=function(){return this._bGroupHeader};m.prototype.setGroupedItem=function(t){this._aGroupedItems=this._aGroupedItems||[];this._aGroupedItems.push(t.getId())};m.prototype.getGroupedItems=function(){return this._aGroupedItems};m.prototype.isIncludedIntoSelection=function(){if(!this.isSelectable()){return false}var t=this.getMode();return t==I.SingleSelectMaster||this.getListProperty("includeItemInSelection")&&(t==I.SingleSelectLeft||t==I.SingleSelect||t==I.MultiSelect)};m.prototype._checkHighlight=function(t){if(t==undefined){t=this.getVisible()&&this.getHighlight()!=_.None}if(this._bNeedsHighlight!=t){this._bNeedsHighlight=t;this.informList("HighlightChange",t)}};m.prototype._checkNavigated=function(t){if(t==undefined){t=this.getVisible()&&this.getNavigated()}if(this._bNeedsNavigated!=t){this._bNeedsNavigated=t;this.informList("NavigatedChange",t)}};m.prototype.hasActiveType=function(){var t=this.getType();return t==T.Active||t==T.Navigation||t==T.DetailAndActive};m.prototype.setActive=function(t){if(t==this._active){return this}if(t&&this.getListProperty("activeItem")){return this}var e=this.$();this._active=t;this._activeHandling(e);if(this.getType()==T.Navigation){this._activeHandlingNav(e)}if(t){this._activeHandlingInheritor(e)}else{this._inactiveHandlingInheritor(e)}this.informList("ActiveChange",t)};m.detectTextSelection=function(t){var e=window.getSelection(),i=e.toString().replace("\n","");return i&&(t!==e.focusNode&&t.contains(e.focusNode))};m.prototype.ontap=function(t){if(this._eventHandledByControl){return t.setMarked()}if(m.detectTextSelection(this.getDomRef())){return}if(this.isIncludedIntoSelection()){if(this.getMode()==I.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected())}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true)}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(document.activeElement!=this.getFocusDomRef()){this.focus()}setTimeout(function(){this.setActive(false)}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress()}.bind(this),0)}this.informList("Press",t.srcControl)};m.prototype.ontouchstart=function(t){this._eventHandledByControl=t.isMarked();var e=t.targetTouches[0];this._touchedY=e.clientY;this._touchedX=e.clientX;if(this._eventHandledByControl||t.touches.length!=1||!this.hasActiveType()){if(this.getListProperty("includeItemInSelection")&&this.getList()._mRangeSelection){t.preventDefault()}return}this._timeoutIdStart=setTimeout(function(){this.setActive(true)}.bind(this),100)};m.prototype.ontouchmove=function(t){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-t.targetTouches[0].clientY)>10||Math.abs(this._touchedX-t.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false)}};m.prototype.ontouchend=function(t){if(this.hasActiveType()){this._timeoutIdEnd=setTimeout(function(){this.setActive(false)}.bind(this),100)}};m.prototype.ontouchcancel=m.prototype.ontouchend;m.prototype.ondragend=m.prototype.ontouchend;m.prototype._activeHandlingNav=function(){};m.prototype._activeHandlingInheritor=function(){};m.prototype._inactiveHandlingInheritor=function(){};m.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(this.isActionable(true)){t.toggleClass("sapMLIBHoverable",!this._active)}};m.prototype.onsapspace=function(t){if(t.srcControl!==this||t.target!==this.getDomRef()){return}t.preventDefault();if(t.isMarked()||!this.isSelectable()){return}if(this.getMode()==I.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected())}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true)}t.setMarked()};m.prototype.onsapenter=function(t){var e=this.getList();if(t.isMarked()||!e){return}if(t.srcControl!==this||t.target!==this.getDomRef()){return}if(this.isIncludedIntoSelection()){t.type="sapspace";this.onsapspace(t)}else if(this.hasActiveType()){t.setMarked();this.setActive(true);setTimeout(function(){this.setActive(false)}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress()}.bind(this),0)}e.onItemPress(this,t.srcControl)};m.prototype.onsapdelete=function(t){if(t.isMarked()||t.srcControl!==this||this.getMode()!=I.Delete||t.target!==this.getDomRef()){return}this.informList("Delete");t.preventDefault();t.setMarked()};m.prototype.onkeydown=function(t){if(t.isMarked()){return}if(t.code=="KeyE"&&(t.metaKey||t.ctrlKey)){if(t.target===this.getDomRef()&&(this.hasListeners("detailPress")||this.hasListeners("detailTap"))){this.fireDetailTap();this.fireDetailPress();t.preventDefault();t.setMarked()}}if(t.srcControl!==this||t.target!==this.getDomRef()){return}this.informList("KeyDown",t)};m.prototype.onkeyup=function(t){if(t.isMarked()||t.srcControl!==this||t.target!==this.getDomRef()){return}this.informList("KeyUp",t)};m.prototype.onsapupmodifiers=function(t){if(t.isMarked()){return}this.informList("UpDownModifiers",t,-1)};m.prototype.onsapdownmodifiers=function(t){if(t.isMarked()){return}this.informList("UpDownModifiers",t,1)};m.prototype.getTabbables=function(t){return this.$(t?"content":"").find(":sapTabbable")};m.prototype.onfocusin=function(t){const e=this.getList();if(!e||t.isMarked()){return}this.informList("FocusIn",t.srcControl,t);t.setMarked()};m.prototype.onfocusout=function(t){if(t.isMarked()||t.srcControl!==this){return}this.informList("FocusOut",t.srcControl);t.setMarked()};m.prototype.onsapup=m.prototype.onsapdown=function(t){if(t.isMarked()||t.srcControl===this||t.target instanceof HTMLInputElement||t.target instanceof HTMLTextAreaElement||t.target.classList.contains("sapMTblCellFocusable")){return}this.informList("ArrowUpDown",t)};m.prototype.oncontextmenu=function(t){if(this._bGroupHeader){return}if(t.srcControl==this.getModeControl()||document.activeElement.matches(".sapMLIB,.sapMListTblCell,.sapMListTblSubRow")){this.informList("ContextMenu",t)}};return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ListItemBaseRenderer", ["sap/ui/core/ControlBehavior","./library","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/InvisibleRenderer","sap/ui/core/Configuration","sap/ui/core/Lib"],function(e,t,n,i,r,s,a){"use strict";var o=t.ListType;var d=t.ListMode;var l={apiVersion:2};l.renderInvisible=function(e,t){r.render(e,t,t.TagName)};l.renderHighlight=function(e,t){var n=t.getHighlight();if(n=="None"){return}e.openStart("div");e.class("sapMLIBHighlight");e.class("sapMLIBHighlight"+n);e.openEnd();e.close("div")};l.isModeMatched=function(e,t){var n=(sap.ui.require("sap/m/ListBaseRenderer")||{}).ModeOrder||{};return n[e]==t};l.renderMode=function(e,t,n){var i=t.getMode();if(!this.isModeMatched(i,n)){return}var r=t.getModeControl(true);if(r){this.renderModeContent(e,t,r)}};l.renderModeContent=function(e,t,n){this.decorateMode(n,t);e.renderControl(n)};l.decorateMode=function(t,n){t.removeStyleClass("sapMLIBSelectAnimation sapMLIBUnselectAnimation");if(e.getAnimationMode()===s.AnimationMode.none||!n.getListProperty("modeAnimationOn")){return}var i=n.getMode(),r=n.getListProperty("lastMode");if(!r||r==i){return}if(i==d.None){t.addStyleClass("sapMLIBUnselectAnimation")}else{t.addStyleClass("sapMLIBSelectAnimation")}};l.renderCounter=function(e,t){var n=t.getCounter();if(n){this.renderCounterContent(e,t,n)}};l.renderCounterContent=function(e,t,n){e.openStart("div",t.getId()+"-counter");e.attr("aria-label",a.getResourceBundleFor("sap.m").getText("LIST_ITEM_COUNTER",[n]));e.class("sapMLIBCounter");e.openEnd();e.text(n);e.close("div")};l.renderType=function(e,t){var n=t.getTypeControl(true);if(n){e.renderControl(n)}};l.openItemTag=function(e,t){e.openStart(t.TagName,t)};l.closeItemTag=function(e,t){e.close(t.TagName)};l.renderTabIndex=function(e,t){e.attr("tabindex","-1")};l.renderTooltip=function(e,t){var n=t.getTooltip_AsString();if(n){e.attr("title",n)}};l.addFocusableClasses=function(e,t){if(n.system.desktop){e.class("sapMLIBFocusable");this.addLegacyOutlineClass(e,t)}};l.addLegacyOutlineClass=function(e,t){};l.getAriaAnnouncement=function(e,t){return i.getStaticId("sap.m",t||"LIST_ITEM_"+e.toUpperCase())};l.getAriaRole=function(e){if(e.isGroupHeader()){return"listitem"}var t=e.getList();return t&&t.getAriaRole()=="listbox"?"option":"listitem"};l.getAriaLabelledBy=function(e){if(!e.getContentAnnouncement&&e.getAriaLabelledBy().length){return e.getId()}};l.getAriaDescribedBy=function(e){if(e.getContentAnnouncement){return""}var t=[],n=e.getType();if(e.getListProperty("showUnread")&&e.getUnread()){t.push(this.getAriaAnnouncement("unread"))}if(e.getMode()==d.Delete){t.push(this.getAriaAnnouncement("delete"))}if(n==o.Navigation){t.push(this.getAriaAnnouncement("navigation"))}else{if(n==o.Detail||n==o.DetailAndActive){t.push(this.getAriaAnnouncement("detail"))}if(n==o.Active||n==o.DetailAndActive){t.push(this.getAriaAnnouncement("active"))}}return t.join(" ")};l.getAccessbilityPosition=function(e){var t=e.getList();return t&&t.getAccessbilityPosition&&t.getAccessbilityPosition(e)};l.getAccessibilityState=function(e){var t=this.getAriaLabelledBy(e),n=this.getAriaDescribedBy(e),i=this.getAriaRole(e),r=true,s={role:i};if(t){s.labelledby={value:t.trim(),append:true}}if(n){s.describedby={value:n.trim(),append:true}}if(e.getNavigated()){s.current=true}if(i==="listitem"){s.selected=null;if(e.isGroupHeader()){r=false;s.role="group";s.roledescription=a.getResourceBundleFor("sap.m").getText("LIST_ITEM_GROUP_HEADER");var o=e.getGroupedItems();if(o&&o.length){s.owns=o.join(" ")}}}else if(e.isSelectable()){s.selected=e.getSelected()}if(r){var d=this.getAccessbilityPosition(e);Object.assign(s,d)}return s};l.renderLIContent=function(e,t){};l.renderLIAttributes=function(e,t){};l.renderContentFormer=function(e,t){this.renderHighlight(e,t);this.renderMode(e,t,-1)};l.renderContentLatter=function(e,t){this.renderCounter(e,t);this.renderType(e,t);this.renderMode(e,t,1);this.renderNavigated(e,t)};l.renderLIContentWrapper=function(e,t){e.openStart("div",t.getId()+"-content").class("sapMLIBContent").openEnd();this.renderLIContent(e,t);e.close("div")};l.renderNavigated=function(e,t){if(!t.getNavigated()){return}e.openStart("div");e.class("sapMLIBNavigated");e.openEnd();e.close("div")};l.render=function(t,n){if(!n.getVisible()){this.renderInvisible(t,n);return false}this.openItemTag(t,n);t.class("sapMLIB");t.class("sapMLIB-CTX");t.class("sapMLIBShowSeparator");t.class("sapMLIBType"+n.getType());if(n.isActionable(true)){t.class("sapMLIBActionable");t.class("sapMLIBHoverable")}if(n.getSelected()){t.class("sapMLIBSelected")}if(n.getListProperty("showUnread")&&n.getUnread()){t.class("sapMLIBUnread")}this.addFocusableClasses(t,n);this.renderTooltip(t,n);this.renderTabIndex(t,n);if(e.isAccessibilityEnabled()){t.accessibilityState(n,this.getAccessibilityState(n))}this.renderLIAttributes(t,n);t.openEnd();this.renderContentFormer(t,n);this.renderLIContentWrapper(t,n);this.renderContentLatter(t,n);this.closeItemTag(t,n)};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/ListRenderer", ["sap/ui/core/Renderer","./ListBaseRenderer"],function(e,t){"use strict";var i=e.extend(t);i.apiVersion=2;i.getNoDataAriaRole=function(e){return e.getAriaRole()==="listbox"?"option":"listitem"};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MaskEnabler", ["sap/ui/core/Control","./InputBase","sap/ui/Device","sap/ui/core/library","sap/ui/core/IconPool","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/thirdparty/jquery","sap/m/MaskInputRule","sap/ui/core/Configuration","sap/ui/dom/jquery/cursorPos"],function(t,e,i,s,n,o,r,jQuery,a,l){"use strict";var h=s.TextDirection;var u=function(){var s="^";this.init=u.init=function(){e.prototype.init.call(this);this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._setDefaultRules();this._setupMaskVariables()};this.exit=u.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null};this.onBeforeRendering=function(){if(this._isMaskEnabled()){var t=this._validateDependencies();if(t){r.warning("Invalid mask input: "+t)}}e.prototype.onBeforeRendering.apply(this,arguments);this.getShowClearIcon&&this.getShowClearIcon()&&this._getClearIcon().setVisible(this.getProperty("effectiveShowClearIcon"))};this.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments)};this.onfocusin=u.onfocusin=function(t){this._sOldInputValue=this._getInputValue();e.prototype.onfocusin.apply(this,arguments);if(this._isMaskEnabled()){if(!this._oTempValue.differsFromOriginal()||!this._isValidInput(this._sOldInputValue)){this._applyMask()}this._positionCaret(true)}};this.onfocusout=function(t){if(this._isMaskEnabled()){this.bFocusoutDueRendering=this.bRenderingPhase;this.removeStyleClass("sapMFocus");jQuery(document).off(".sapMIBtouchstart");if(this.bRenderingPhase){return}this.closeValueStateMessage();this._inputCompletedHandler()}else{this._inputCompletedHandlerNoMask();e.prototype.onfocusout.apply(this,arguments)}};this.oninput=function(t){if(this._isChromeOnAndroid()){this._onInputForAndroidHandler(t);return}e.prototype.oninput.apply(this,arguments);if(this._isMaskEnabled()){this._applyMask();this._positionCaret(false)}var i=this.getDOMValue();if(!this._isMaskEnabled()&&i!==this._sPreviousValue){this._fireLiveChange(i,this._sPreviousValue);this._sPreviousValue=i}};this.onkeypress=function(t){if(this._isMaskEnabled()){this._keyPressHandler(t)}if(this.getDOMValue()!==""){this._setClearIconVisibility()}};this.onkeydown=u.onkeydown=function(t){if(this._isMaskEnabled()){var i=this._parseKeyBoardEvent(t);e.prototype.onkeydown.apply(this,arguments);this._keyDownHandler(t,i);if(this.getDOMValue()!==""){this._setClearIconVisibility()}}else{var i=this._parseKeyBoardEvent(t);if(i.bEnter){this._inputCompletedHandlerNoMask()}e.prototype.onkeydown.apply(this,arguments)}};this.onsapenter=function(t){};this.onsapfocusleave=function(t){};this.onsapescape=function(t){if(this._oTempValue._aContent.join("")!==this._oTempValue._aInitial.join("")){e.prototype.onsapescape.call(this,t)}this._bCheckForLiveChange=true};this._setClearIconVisibility=function(t){var e=t!==undefined?t:!this._isValueEmpty();if(this.getShowClearIcon&&this.getShowClearIcon()){this.setProperty("effectiveShowClearIcon",e);this._getClearIcon().setVisible(this.getProperty("effectiveShowClearIcon"))}};this._getClearIcon=function(){if(this._oClearButton){return this._oClearButton}this._oClearButton=this.addEndIcon({src:n.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,press:function(){if(!this._isValueEmpty()){this.fireChange({value:""});this.setValue("");this.setProperty("effectiveShowClearIcon",false);this._getClearIcon().setVisible(false);setTimeout(function(){if(i.system.desktop){this.focus()}},0)}}.bind(this)});return this._oClearButton};this._isValueEmpty=function(){var t=this.getDOMValue(),e=this._oTempValue._aInitial.join("");return t==e};this.getDOMValue=function(){return this._$input.val()};this.setValue=u.setValue=function(t){t=this.validateProperty("value",t);e.prototype.setValue.call(this,t);this._sOldInputValue=t;if(this._isMaskEnabled()){if(!this._oTempValue){this._setupMaskVariables()}if(this._oTempValue._aInitial.join("")!==t){this._applyRules(t)}}this._setClearIconVisibility(t!=="");return this};this.addAggregation=function(e,i,s){if(e==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(i)){return this}this._removeRuleWithSymbol(i.getMaskFormatSymbol());t.prototype.addAggregation.apply(this,arguments);if(!this._bSkipSetupMaskVariables){this._setupMaskVariables()}return this}return t.prototype.addAggregation.apply(this,arguments)};this.insertAggregation=function(e,i,s,n){if(e==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(i)){return this}this._removeRuleWithSymbol(i.getMaskFormatSymbol());t.prototype.insertAggregation.apply(this,arguments);this._setupMaskVariables();return this}return t.prototype.insertAggregation.apply(this,arguments)};this._validateRegexAgainstPlaceHolderSymbol=function(t){if(new RegExp(t.getRegex()).test(this.getPlaceholderSymbol())){r.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false}return true};this.setPlaceholderSymbol=function(t){var e;if(!/^.$/i.test(t)){r.error("Invalid placeholder symbol string given");return this}e=this.getRules().some(function(e){return new RegExp(e.getRegex()).test(t)});if(e){r.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.")}else{this.setProperty("placeholderSymbol",t);this._setupMaskVariables()}return this};this.setMask=function(t){if(!t){var e="Setting an empty mask is pointless. Make sure you set it with a non-empty value.";r.warning(e);return this}this.setProperty("mask",t,true);this._setupMaskVariables();return this};this._isCharAllowed=function(t,e){return this._oRules.applyCharAt(t,e)};this._feedReplaceChar=function(t,e,i){return t};this._inputCompletedHandlerNoMask=function(){var t=this._getInputValue();if(this._sOldInputValue!==t){e.prototype.setValue.call(this,this._getAlteredUserInputValue?this._getAlteredUserInputValue(t):t);this._sOldInputValue=t;if(this.onChange&&!this.onChange({value:t})){this.fireChangeEvent(t)}}};var p=function(t){this._aInitial=t.slice(0);this._aContent=t};p.prototype.setCharAt=function(t,e){this._aContent[e]=t};p.prototype.charAt=function(t){return this._aContent[t]};p.prototype.toString=function(){return this._aContent.join("")};p.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial)};p.prototype.differsFrom=function(t){var e=0;if(t.length!==this._aContent.length){return true}for(;e<t.length;e++){if(t[e]!==this._aContent[e]){return true}}return false};p.prototype.getSize=function(){return this._aContent.length};var f=function(t){this._aRules=t};f.prototype.nextTo=function(t){if(typeof t==="undefined"){t=-1}do{t++}while(t<this._aRules.length&&!this._aRules[t]);return t};f.prototype.previousTo=function(t){do{t--}while(!this._aRules[t]&&t>0);return t};f.prototype.hasRuleAt=function(t){return!!this._aRules[t]};f.prototype.applyCharAt=function(t,e){return this._aRules[e].test(t)};this.updateDomValue=function(t){e.prototype.updateDomValue.call(this,t);if(this._bCheckForLiveChange&&t!==this._sPreviousValue){this._fireLiveChange(t,this._sPreviousValue);this._sPreviousValue=t}this._bCheckForLiveChange=false};this._fireLiveChange=function(t,e){this.fireLiveChange&&this.fireLiveChange({value:t,previousValue:e})};this._setDefaultRules=function(){this._bSkipSetupMaskVariables=true;this.addRule(new a({maskFormatSymbol:"a",regex:"[A-Za-z]"}),true);this.addRule(new a({maskFormatSymbol:"9",regex:"[0-9]"}),true);this._bSkipSetupMaskVariables=false};this._validateDependencies=function(){var t=this.getPlaceholderSymbol(),e=this.getRules(),i=[],s=[];if(!this.getMask()){s.push("Empty mask")}if(e.length){i=[];e.every(function(e){var n=e.getMaskFormatSymbol(),o=n!==t,r;r=!i.some(function(t){return n===t});i.push(n);if(!o){s.push("Placeholder symbol is the  same as the existing rule's mask format symbol")}if(!r){s.push("Duplicated rule's maskFormatSymbol ["+n+"]")}return o&&r})}return s.length?s.join(". "):null};this._removeRuleWithSymbol=function(t){var e=this._findRuleBySymbol(t,this.getRules());if(e){this.removeAggregation("rules",e.oRule);e.oRule.destroy()}};this._findRuleBySymbol=function(t,e){var i=null;if(typeof t!=="string"||t.length!==1){r.error(t+" is not a valid mask rule symbol");return null}jQuery.each(e,function(e,s){if(s.getMaskFormatSymbol()===t){i={oRule:s,iIndex:e};return false}});return i};this._getTextSelection=function(){var t=jQuery(this.getFocusDomRef());if(!t&&(t.length===0||t.is(":hidden"))){return{}}return{iFrom:t[0].selectionStart,iTo:t[0].selectionEnd,bHasSelection:t[0].selectionEnd-t[0].selectionStart!==0}};this._setCursorPosition=function(t){if(t<0){t=0}jQuery(this.getFocusDomRef()).cursorPos(t);return this};this._getCursorPosition=function(){return jQuery(this.getFocusDomRef()).cursorPos()};this._setupMaskVariables=function(){var t=this.getRules(),e=this.getMask(),i=this._getSkipIndexes(e),s=this._getMaskArray(e,i),n=this.getPlaceholderSymbol(),o=this._buildMaskValueArray(s,n,t,i),r=this._buildRules(s,t,i);this._oTempValue=new p(o);this._iMaskLength=r.length;this._oRules=new f(r);this._iUserInputStartPosition=this._oRules.nextTo()};this._getMaskArray=function(t,e){var i=Array.isArray(e)?e.length:0,s=t?t.split(""):[],n;for(n=0;n<i;n++){s.splice(e[n],1)}return s};this._getSkipIndexes=function(t){var e=t?t.length:0,i,n=[],o=0,r=false;for(i=0;i<e;i++){if(t[i]===s&&!r){n.push(i-o);r=true;o++}else{r=false}}return n};this._applyMask=function(){var t=this._getInputValue();if(!this.getEditable()){return}this._applyAndUpdate(t)};this._resetTempValue=function(t,e){var i,s=this.getPlaceholderSymbol();if(typeof t==="undefined"||t===null){t=0;e=this._oTempValue.getSize()-1}for(i=t;i<=e;i++){if(this._oRules.hasRuleAt(i)){this._oTempValue.setCharAt(s,i)}}};this._applyAndUpdate=function(t){if(this._oTempValue&&(this._sPreviousValue===undefined||this._sPreviousValue==="")){this._sPreviousValue=this._oTempValue.toString();this._bCheckForLiveChange=false}else if(!this._bCutInProgress){this._bCheckForLiveChange=true}this._applyRules(t);this.updateDomValue(this._oTempValue.toString())};this._findFirstPlaceholderPosition=function(){return this._oTempValue.toString().indexOf(this.getPlaceholderSymbol())};this._applyRules=function(t){var e,i=0,s,n=this.getPlaceholderSymbol(),o;if(this._oTempValue.toString()===t){return}for(s=0;s<this._iMaskLength;s++){if(this._oRules.hasRuleAt(s)){this._oTempValue.setCharAt(n,s);o=false;if(t.length){do{e=t.charAt(i);i++;if(this._oRules.applyCharAt(e,s)){this._oTempValue.setCharAt(e,s);o=true}}while(!o&&i<t.length)}if(!o){this._resetTempValue(s+1,this._iMaskLength-1);break}}else{if(this._oTempValue.charAt(s)===t.charAt(i)){i++}}}};this._keyPressHandler=function(t,e){var i,s,n;if(!this.getEditable()){return}e=e||this._parseKeyBoardEvent(t);if(e.bCtrlKey||e.bAltKey||e.bMetaKey||e.bBeforeSpace){return}i=this._getTextSelection();if(!e.bEnter&&!e.bShiftLeftOrRightArrow&&!e.bHome&&!e.bEnd&&!(e.bShift&&e.bDelete)&&!(e.bCtrlKey&&e.bInsert)&&!(e.bShift&&e.bInsert)){if(i.bHasSelection){this._resetTempValue(i.iFrom,i.iTo-1);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,i.iFrom))}s=this._oRules.nextTo(i.iFrom-1);if(s<this._iMaskLength){n=this._feedReplaceChar(e.sChar,s,this._getInputValue());this._feedNextString(n,s)}t.preventDefault()}};this.oncut=function(t){var i=this._getTextSelection(),s=this._getMinBrowserDelay(),n=i.iFrom,o=i.iTo;e.prototype.oncut(t);if(!i.bHasSelection||!this._isMaskEnabled()){return}o=o-1;this._resetTempValue(n,o);this._bCutInProgress=true;setTimeout(function t(e,i,n){this._oTempValue._aContent=n;this._bCheckForLiveChange=true;this._bCutInProgress=false;this.updateDomValue(e);setTimeout(this._setCursorPosition.bind(this,i),s)}.bind(this,this._oTempValue.toString(),Math.max(this._iUserInputStartPosition,n),this._oTempValue._aContent.slice(0)),s)};this.onpaste=function(){this._bCheckForLiveChange=true};this._keyDownHandler=function(t,i){var s,n,o,r,i=i||this._parseKeyBoardEvent(t);if(!this.getEditable()){return}if(!i.bShift&&(i.bArrowRight||i.bArrowLeft)){o=this._getCursorPosition();n=this._getTextSelection();s=this._determineArrowKeyDirection(i,n);if(this._isRtlMode()&&n.bHasSelection){r=this._determineRtlCaretPositionFromSelection(s)}else{r=this._oRules[s](o)}if(this._isWebkitProblematicCase()){r=this._fixWebkitBorderPositions(r,s)}this._setCursorPosition(r);t.preventDefault()}else if(i.bEscape){this._applyAndUpdate(this._sOldInputValue);this._positionCaret(true);t.preventDefault()}else if(i.bEnter){this._inputCompletedHandler(t)}else if(i.bCtrlKey&&i.bInsert||i.bShift&&i.bInsert){e.prototype.onkeydown.apply(this,arguments)}else if(!i.bShift&&i.bDelete||i.bBackspace){this._revertKey(i);t.preventDefault()}else if(this._isChromeOnAndroid()){this._oKeyDownStateAndroid={sValue:this._oTempValue.toString(),iCursorPosition:this._getCursorPosition(),oSelection:this._getTextSelection()}}};this._revertKey=function(t,e){e=e||this._getTextSelection();var i=e.iFrom,s=e.iTo;if(!e.bHasSelection){if(t.bBackspace){i=this._oRules.previousTo(i)}}if(t.bBackspace||t.bDelete&&e.bHasSelection){s=s-1}this._resetTempValue(i,s);this._bCheckForLiveChange=true;this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,i))};this._feedNextString=function(t,e){var i,s=false,n=t.split(""),o;while(n.length){o=n.splice(0,1)[0];if(this._oRules.applyCharAt(o,e)){s=true;this._oTempValue.setCharAt(o,e);e=this._oRules.nextTo(e)}}if(s){i=e;this._bCheckForLiveChange=true;this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(i)}};this._inputCompletedHandler=function(){var t=this._getInputValue(),i,s,n,o;if(this._oTempValue.differsFrom(t)){this._applyAndUpdate(t)}i=this._oTempValue.differsFromOriginal();s=i?this._oTempValue.toString():"";n=!this._sOldInputValue||!this.getValue();o=!t;if(n&&(o||!i)){this.updateDomValue("");return}if(this._sOldInputValue!==this._oTempValue.toString()){e.prototype.setValue.call(this,this._getAlteredUserInputValue?this._getAlteredUserInputValue(s):s);this._sOldInputValue=s;if(this.onChange&&!this.onChange({value:s})){this.fireChangeEvent(s)}}};this._buildMaskValueArray=function(t,e,i,s){return t.map(function(t,n){var o=s.indexOf(n)===-1,r=this._findRuleBySymbol(t,i);return o&&r?e:t},this)};this._buildRules=function(t,e,i){var s=[],n,o=t.length,r=0;for(;r<o;r++){if(i.indexOf(r)===-1){n=this._findRuleBySymbol(t[r],e);s.push(n?new RegExp(n.oRule.getRegex()):null)}else{s.push(null)}}return s};this._parseKeyBoardEvent=function(t){var e=t.which||t.keyCode,s=o,n=e===s.ARROW_RIGHT,r=e===s.ARROW_LEFT,a=t.shiftKey;return{iCode:e,sChar:String.fromCharCode(e),bCtrlKey:t.ctrlKey,bAltKey:t.altKey,bMetaKey:t.metaKey,bShift:a,bInsert:e===o.INSERT,bBackspace:e===s.BACKSPACE,bDelete:e===s.DELETE,bEscape:e===s.ESCAPE,bEnter:e===s.ENTER,bIphoneEscape:i.system.phone&&i.os.ios&&e===127,bArrowRight:n,bArrowLeft:r,bHome:e===o.HOME,bEnd:e===o.END,bShiftLeftOrRightArrow:a&&(r||n),bBeforeSpace:e<s.SPACE}};this._positionCaret=function(t){var e=this.getMask(),i=this._getMinBrowserDelay(),s;clearTimeout(this._iCaretTimeoutId);s=this._findFirstPlaceholderPosition();if(s<0){s=e.length}this._iCaretTimeoutId=setTimeout(function(){if(this.getFocusDomRef()!==document.activeElement){return}if(t&&s===e.length){this.selectText(0,s)}else{this._setCursorPosition(s)}}.bind(this),i);this._setClearIconVisibility()};this._getMinBrowserDelay=function(){return 4};this._isValidInput=function(t){var e=t.length,i=0,s;for(;i<e;i++){s=t[i];if(this._oRules.hasRuleAt(i)&&(!this._oRules.applyCharAt(s,i)&&s!==this.getPlaceholderSymbol())){return false}if(!this._oRules.hasRuleAt(i)&&s!==this._oTempValue.charAt(i)){return false}}return true};this._isRtlChar=function(t){var e="A-Za-zÀ-ÖØ-öø-ʸ̀-֐ࠀ-῿"+"Ⰰ-﬜﷾-﹯﻽-￿",i="֑-߿יִ-﷽ﹰ-ﻼ",s=new RegExp("^[^"+e+"]*["+i+"]");return s.test(t)};this._fixWebkitBorderPositions=function(t,e){var i=this._oTempValue.toString().length;if(e==="nextTo"){if(t===0||t===i||t===1){t=0}else if(t===i+1){t=1}}else{if(t===0||t===i-1){t=i}else if(t===-1||t===i){t=i-1}}return t};this._containsRtlChars=function(){var t=this._oTempValue.toString(),e=false;for(var i=0;i<t.length;i++){e=this._isRtlChar(t[i])}return e};this._isRtlMode=function(){return l.getRTL()||this.getTextDirection()===h.RTL};this._isWebkitProblematicCase=function(){return i.browser.webkit&&this._isRtlMode()&&!this._containsRtlChars()};this._determineArrowKeyDirection=function(t,e){var i;if(!this._isRtlMode()||!this._containsRtlChars()||e.bHasSelection){if(t.bArrowRight){i="nextTo"}else{i="previousTo"}}else{if(t.bArrowRight){i="previousTo"}else{i="nextTo"}}return i};this._determineRtlCaretPositionFromSelection=function(t,e){var i,s=this._getTextSelection();if(e){if(t==="nextTo"){if(!this._containsRtlChars()){i=s.iFrom}else{i=s.iTo}}else{if(!this._containsRtlChars()){i=s.iTo}else{i=s.iFrom}}}else{if(t==="nextTo"){if(!this._containsRtlChars()){i=s.iTo}else{i=s.iFrom}}else{if(!this._containsRtlChars()){i=s.iFrom}else{i=s.iTo}}}return i};this._onInputForAndroidHandler=function(t){var e;if(!this._oKeyDownStateAndroid){return}e=this._buildKeyboardEventInfo(this._oKeyDownStateAndroid.sValue,this._getInputValue(),this._oKeyDownStateAndroid.oSelection);this.updateDomValue(this._oKeyDownStateAndroid.sValue);setTimeout(function(t,e,i){this._setCursorPosition(e.iCursorPosition);if(i.bBackspace){this._revertKey(i,e.oSelection);if(e.oSelection.bHasSelection&&i.sChar){this._keyPressHandler(t,i)}}else{this._keyPressHandler(t,i)}}.bind(this,t,this._oKeyDownStateAndroid,e),0);delete this._oKeyDownStateAndroid;t.preventDefault()};this._buildKeyboardEventInfo=function(t,e,i){var s="",n,o={},r;if(!t&&!e){return{}}if(t&&e&&e.length<t.length){o.bBackspace=true}for(n=0;n<e.length;n++){r=i.bHasSelection&&i.iFrom===n;if(r||t[n]!==e[n]){s=e[n];break}}o.sChar=s;return o};this._isChromeOnAndroid=function(){return i.browser.chrome&&i.os.android}};return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MaskInput", ["./InputBase","./MaskEnabler","./MaskInputRenderer"],function(e,a,t){"use strict";var r=e.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}},events:{liveChange:{parameters:{value:{type:"string"},previousValue:{type:"string"}}}},dnd:{draggable:false,droppable:true}},renderer:t});a.call(r.prototype);r.prototype._isMaskEnabled=function(){return true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MaskInputRenderer", ["sap/ui/core/Renderer","./InputBaseRenderer"],function(e,t){"use strict";var n=e.extend(t);n.apiVersion=2;n.getAccessibilityState=function(e){var n=sap.ui.getCore().getLibraryResourceBundle("sap.m"),r=n.getText("MASKINPUT_ROLE_DESCRIPTION"),i=t.getAccessibilityState.apply(this,arguments);i["roledescription"]=r;return i};n.getLabelledByAnnouncement=function(e){var n=e.getMask();if(n&&n.length){return e.getPlaceholder()||""}return t.getLabelledByAnnouncement.apply(this,arguments)};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MaskInputRule", ["sap/ui/core/Element","sap/base/Log"],function(t,e){"use strict";var r=t.extend("sap.m.MaskInputRule",{metadata:{library:"sap.m",properties:{maskFormatSymbol:{type:"string",group:"Misc",defaultValue:"*"},regex:{type:"string",group:"Misc",defaultValue:"[a-zA-Z0-9]"}}}});r.prototype.setMaskFormatSymbol=function(t){var e=s.call(this,t);if(e){this.setProperty("maskFormatSymbol",t)}return this};r.prototype.setRegex=function(t){var e=a.call(this,t);if(e){this.setProperty("regex",t)}return this};r.prototype.toString=function(){return this.getMaskFormatSymbol()+":"+this.getRegex()};function s(t){if(/^.$/i.test(t)){return true}e.error("The mask format symbol '"+t+"' is not valid");return false}function a(t){if(/.+/i.test(t)){return true}e.error("The regex value '"+t+"' is not valid");return false}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/Menu", ["./library","sap/ui/core/Control","./Button","./Dialog","./NavContainer","./List","./Page","./MenuListItem","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/Device","sap/ui/core/EnabledPropagator","sap/ui/thirdparty/jquery","sap/ui/core/Popup","sap/ui/base/ManagedObject","sap/ui/core/Element"],function(t,e,i,n,s,o,a,r,g,l,u,p,jQuery,h,m,d){"use strict";var _=h.Dock;var I=t.ListType;var f=t.ListMode;var c=e.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}},renderer:null});p.call(c.prototype);c.UNIFIED_MENU_ITEMS_ID_SUFFIX="-unifiedmenu";c.UNFIFIED_MENU_ITEMS_PROPS=l.getMetadata().getAllProperties();c.LIST_ITEMS_ID_SUFFIX="-menuinnerlist";c.MENU_LIST_ITEMS_PROPS=r.getMetadata().getAllProperties();c.prototype.init=function(){if(u.system.phone){this._initDialog()}this._bIsInitialized=false;this.attachEvent("propertyChanged",this._onPropertyChanged,this);this.attachEvent("aggregationChanged",this._onAggregationChanged,this)};c.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null}if(this._bIsInitialized){this._bIsInitialized=null}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this)}};c.prototype.invalidate=function(){};c.prototype.setTitle=function(t){var e=this._getNavContainer();this.setProperty("title",t,true);if(e&&e.getPages().length){e.getPages()[0].setTitle(t)}return this};c.prototype.openBy=function(t,e,i,n,s){if(u.system.phone){this._openDialog()}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true}if(!i){i=_.BeginTop}if(!n){n=_.BeginBottom}if(!s){s="0 -2"}this._getMenu().open(e,t,i,n,t,s)}};c.prototype.close=function(){if(u.system.phone){this._getDialog()&&this._getDialog().close()}else{this._getVisualParent()&&this._getVisualParent().close()}};c.prototype.isOpen=function(){if(u.system.phone){return this._getDialog()&&this._getDialog().isOpen()}else{return this._getVisualParent()&&this._getVisualParent().isOpen()}};c.prototype._initDialog=function(){var t=new n({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});t.addStyleClass("sapMRespMenuDialog");t.addStyleClass("sapUiNoContentPadding");this.setAggregation("_dialog",t,true);t.attachAfterClose(this._menuClosed,this)};c.prototype._getDialog=function(){return this.getAggregation("_dialog")};c.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open()};c.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems())};c.prototype._setCustomEnhanceAccStateFunction=function(t){this._fnEnhanceUnifiedMenuAccState=t};c.prototype._initMenuForItems=function(t,e){var i=new g;i._setCustomEnhanceAccStateFunction(this._fnEnhanceUnifiedMenuAccState);i.isCozy=this._isMenuCozy.bind(this,i);this.addStyleClass("sapMMenu");i.aCustomStyleClasses=this.aCustomStyleClasses;i.mCustomStyleClassMap=this.mCustomStyleClassMap;t.forEach(function(t){this._addVisualMenuItemFromItem(t,i)}.bind(this));if(e){e.setSubmenu(i)}else{i.getPopup().attachClosed(this._menuClosed,this);this.setAggregation("_menu",i,true)}i.attachItemSelect(this._handleMenuItemSelect,this)};c.prototype._menuClosed=function(){this.fireClosed()};c.prototype._getMenu=function(){return this.getAggregation("_menu")};c.prototype._initCloseButton=function(){var t=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new i({text:t.getText("MENU_CLOSE"),press:y.bind(this)})};function y(){this._getDialog().close()}c.prototype._initNavContainer=function(){var t=new s;this._navContainerId=t.getId();return t};c.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId)};c.prototype._initAllPages=function(){this._initPageForParent(this)};c.prototype._initPageForParent=function(t){var e=t.getItems(),i=t instanceof c,n=i?t.getTitle():t.getText(),s=new o({mode:f.None}),r=new a({title:n,showNavButton:!i,content:s});if(!i){this._setBackButtonTooltipForPageWithParent(t,r)}r.attachNavButtonPress(function(){this._getNavContainer().back()},this);this._getNavContainer().addPage(r);e.forEach(function(t){this._addListItemFromItem(t,r)},this);this._updateListInset(s);s.attachEvent("itemPress",this._handleListItemPress,this);return r};c.prototype._handleListItemPress=function(t){var e=t.getParameter("listItem"),i=sap.ui.getCore().byId(e.getMenuItem()),n=i._getVisualChild();if(n){this._getNavContainer().to(n)}else{this._getDialog().close();this.fireItemSelected({item:i})}i.firePress()};c.prototype._setBackButtonTooltipForPageWithParent=function(t,e){var i=t.getParent(),n=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=i instanceof c?i.getTitle():i.getText();s=n.getText("MENU_PAGE_BACK_BUTTON")+" "+s;e.setNavButtonTooltip(s)};c.prototype._createMenuListItemFromItem=function(t){var e=this._generateListItemId(t.getId()),i=d.registry.get(e);if(i){return i}i=new r({id:e,type:t.getEnabled()?I.Active:I.Inactive,icon:t.getIcon(),title:this._handleSettingsValue(t.getText()),startsSection:t.getStartsSection(),menuItem:t,tooltip:this._handleSettingsValue(t.getTooltip()),visible:t.getVisible(),enabled:t.getEnabled()});t.aDelegates.forEach(function(t){i.addEventDelegate(t.oDelegate,t.vThis)});return i};c.prototype._createVisualMenuItemFromItem=function(t){var e=this._generateUnifiedMenuItemId(t.getId()),i=d.registry.get(e),n=t.getCustomData(),s;if(i){return i}i=new l({id:e,icon:t.getIcon(),text:this._handleSettingsValue(t.getText()),startsSection:t.getStartsSection(),tooltip:this._handleSettingsValue(t.getTooltip()),visible:t.getVisible(),enabled:t.getEnabled()});for(s=0;s<n.length;s++){t._addCustomData(i,n[s])}t.aDelegates.forEach(function(t){i.addEventDelegate(t.oDelegate,t.vThis)});return i};c.prototype._addVisualMenuItemFromItem=function(t,e,i){var n=this._createVisualMenuItemFromItem(t);t._setVisualParent(e);t._setVisualControl(n);if(t.getItems().length!==0){this._initMenuForItems(t.getItems(),n);t._setVisualChild(t.getItems()[0]._getVisualParent())}if(i===undefined){e.addItem(n)}else{e.insertItem(n,i)}};c.prototype._addListItemFromItem=function(t,e,i){var n=this._createMenuListItemFromItem(t),s=e.getContent()[0];t._setVisualParent(e);t._setVisualControl(n);if(t.getItems().length!==0){this._initPageForParent(t);t._setVisualChild(t.getItems()[0]._getVisualParent())}if(i===undefined){s.addItem(n)}else{s.insertItem(n,i)}s.invalidate()};c.prototype._connectVisualItem=function(t,e,i){if(!e||sap.ui.getCore().byId(t._getVisualControl())){return}if(u.system.phone){this._addListItemFromItem(t,e,i);var n=e.getContent()[0];this._updateListInset(n)}else{this._addVisualMenuItemFromItem(t,e,i)}};c.prototype._updateListInset=function(t){var e=false,i="sapMListIcons",n=t.getItems();for(var s=0;s<n.length;s++){if(n[s].getIcon()){e=true;break}}if(e){t.addStyleClass(i)}else{t.removeStyleClass(i)}};c.prototype._handleMenuItemSelect=function(t){var e=t.getParameter("item"),i;if(!e){return}i=this._findMenuItemByUnfdMenuItem(e);if(i&&!i.getItems().length){this.fireItemSelected({item:i})}if(i){i.firePress()}};c.prototype._generateListItemId=function(t){return t+c.LIST_ITEMS_ID_SUFFIX};c.prototype._generateUnifiedMenuItemId=function(t){return t+c.UNIFIED_MENU_ITEMS_ID_SUFFIX};c.prototype._findMenuItemByUnfdMenuItem=function(t){var e=[],i=t,n,s,o;do{e.push(i.getId());i=i.getParent().getParent()}while(i instanceof l);n=this.getItems();do{s=e.pop();for(o=0;o<n.length;o++){if(n[o]._getVisualControl()===s){if(e.length===0){return n[o]}else{n=n[o].getItems();break}}}}while(e.length);return null};c.prototype._isMenuCozy=function(t){if(!t.bCozySupported){return false}if(t.hasStyleClass("sapUiSizeCozy")){return true}if(C(t.oOpenerRef)){return true}return false};function C(t){if(!t){return false}t=t.$?t.$():jQuery(t);var e=t.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return!e.hasClass("sapUiSizeCompact")&&!e.hasClass("sapUiSizeCondensed")||e.hasClass("sapUiSizeCozy")}c.prototype.addAggregation=function(t,i,n){e.prototype.addAggregation.apply(this,arguments);if(t==="items"){this._connectVisualItem(i,this._getVisualParent())}return this};c.prototype.insertAggregation=function(t,i,n,s){e.prototype.insertAggregation.apply(this,arguments);if(t==="items"){this._connectVisualItem(i,this._getVisualParent(),n)}return this};c.prototype.removeAggregation=function(t,i,n){var s=e.prototype.removeAggregation.apply(this,arguments);if(t==="items"){this._removeVisualItem(s)}return s};c.prototype.removeAllAggregation=function(t,i){var n=e.prototype.removeAllAggregation.apply(this,arguments);if(t==="items"){for(var s=0;s<n.length;s++){this._removeVisualItem(n[s])}}return n};c.prototype._removeVisualItem=function(t,e){var i=sap.ui.getCore().byId(t._getVisualControl()),n;if(i){n=i.getParent();n.removeItem(i);if(u.system.phone){this._removeSubPageForItem(t);if(n.getItems().length===0){if(e){e._setVisualChild(null);sap.ui.getCore().byId(e._getVisualControl()).rerender()}}if(n){n.invalidate()}}}};c.prototype.destroyAggregation=function(t,i){if(t==="items"){for(var n=0;n<this.getItems().length;n++){this._removeVisualItem(this.getItems()[n])}}return e.prototype.destroyAggregation.apply(this,arguments)};c.prototype._removeSubPageForItem=function(t,e){var i;if(!e){for(var n=0;n<t.getItems().length;n++){this._removeSubPageForItem(t.getItems()[n])}}if(t._getVisualChild()){i=sap.ui.getCore().byId(t._getVisualChild());if(this._getNavContainer()&&i){this._getNavContainer().removePage(i)}!!i&&i.destroy()}};c.prototype._getVisualParent=function(){var t=this._getNavContainer(),e=this._getMenu();if(t&&t.getPages().length){return t.getPages()[0]}else{return e}};c.prototype._onPropertyChanged=function(t){t.cancelBubble();var e=t.getParameter("propertyKey"),i=t.getParameter("propertyValue"),n=u.system.phone?c.MENU_LIST_ITEMS_PROPS:c.UNFIFIED_MENU_ITEMS_PROPS,s=u.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,o,a;if(u.system.phone&&e==="text"){e="title"}if(!n[e]){return}o=s(t.getSource().getId());a=d.registry.get(o);if(a){a.setProperty(e,i);if(u.system.phone&&this._getDialog().isOpen()){this._getDialog().close()}}};c.prototype._onAggregationChanged=function(t){t.cancelBubble();var e=t.getParameter("aggregationName");switch(e){case"items":this._onItemsAggregationChanged(t);break;case"tooltip":this._onTooltipAggregationChanged(t);break;default:}};c.prototype._onTooltipAggregationChanged=function(t){var e=t.getSource()._getVisualControl(),i=t.getParameter("methodName"),n=t.getParameter("methodParams"),s;if(!e){return}s=sap.ui.getCore().byId(e);if(i==="set"){s.setTooltip(n.item)}if(i==="destroy"){s.destroyTooltip()}};c.prototype._onItemsAggregationChanged=function(t){var e=t.getSource(),i=t.getParameter("methodName"),n=t.getParameter("methodParams"),s;if(i==="add"||i==="insert"){if(i==="insert"){s=n.index}this._addOrInsertItem(e,n.item,s)}if(i==="remove"){this._removeVisualItem(n.item,e)}if(i==="removeall"){for(var o=0;o<n.items.length;o++){this._removeVisualItem(n.items[o],e)}}if(i==="destroy"){this._destroyItem(e)}};c.prototype._addOrInsertItem=function(t,e,i){var n;if(t._getVisualChild()){this._connectVisualItem(e,sap.ui.getCore().byId(t._getVisualChild()),i)}else{if(u.system.phone){this._initPageForParent(t);t._setVisualChild(t.getItems()[0]._getVisualParent());n=sap.ui.getCore().byId(t._getVisualControl());n&&n.invalidate()}else{this._initMenuForItems(t.getItems(),sap.ui.getCore().byId(t._getVisualControl()));t._setVisualChild(t.getItems()[0]._getVisualParent())}}};c.prototype._destroyItem=function(t){var e=sap.ui.getCore().byId(t._getVisualControl());if(e&&e.setMenuItem){e.setMenuItem(null)}this._removeSubPageForItem(t,true);t._setVisualChild(null);if(e&&e.setMenuItem){e.invalidate();e.setMenuItem(t)}};c.prototype.getDomRefId=function(){if(u.system.phone){return this._getDialog().getId()}else{return this._getMenu().getId()}};c.prototype.openAsContextMenu=function(t,e){if(u.system.phone){this._openDialog()}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true}this._getMenu().openAsContextMenu(t,e)}};["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(t){c.prototype[t]=function(i,n){var s=this._getDialog();e.prototype[t].apply(this,arguments);if(s){s[t].apply(s,arguments)}return this}});c.prototype._handleSettingsValue=function(t){if(typeof t!=="string"){return t}try{m.bindingParser(t);return t}catch{return m.escapeSettingsValue(t)}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MenuButton", ["./library","sap/ui/core/Control","./Button","./SplitButton","sap/ui/Device","sap/ui/core/EnabledPropagator","sap/ui/core/library","sap/ui/core/Popup","sap/ui/core/LabelEnablement","./MenuButtonRenderer","sap/ui/events/KeyCodes"],function(t,e,o,i,n,r,s,a,u,p,l){"use strict";var h=t.MenuButtonMode;var c=s.TextDirection;var g=t.ButtonType;var f=a.Dock;var d=["buttonMode","useDefaultActionOnly","width","menuPosition"];var y=e.extend("sap.m.MenuButton",{metadata:{interfaces:["sap.m.IToolbarInteractiveControl"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:g.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:c.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:h.Regular},menuPosition:{type:"sap.ui.core.Popup.Dock",group:"Misc",defaultValue:f.BeginBottom},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{defaultAction:{},beforeMenuOpen:{}},defaultAggregation:"menu",designtime:"sap/m/designtime/MenuButton.designtime",dnd:{draggable:true,droppable:false}},renderer:p});r.call(y.prototype);y.prototype.init=function(){this._initButtonControl()};y.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null}if(this._sDefaultIcon){this._sDefaultIcon=null}if(this._lastActionItemId){this._lastActionItemId=null}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this)}};y.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText()}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon()}this._updateButtonControl();this._attachMenuEvents()};y.prototype._getTextBtnContentDomRef=function(){return this._getButtonControl()._getTextButton().getDomRef("content")};y.prototype.onAfterRendering=function(){if(this._activeButton){this._activeButton.$().attr("aria-expanded","false");this._activeButton=null}};y.prototype.setButtonMode=function(t){var o=this.getTooltip(),i,n;e.prototype.setProperty.call(this,"buttonMode",t,true);this._getButtonControl().destroy();this._initButtonControl();i=this._getButtonControl();n=i.getMetadata().getAllProperties();for(var r in this.mProperties){if(this.mProperties.hasOwnProperty(r)&&d.indexOf(r)<0&&n.hasOwnProperty(r)){i.setProperty(r,this.mProperties[r],true)}}if(o){i.setTooltip(o)}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText)}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText())}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon)}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon())}this.invalidate();return this};y.prototype._initButton=function(){var t=new o(this.getId()+"-internalBtn",{width:"100%",ariaHasPopup:s.aria.HasPopup.Menu});t.attachPress(this._handleButtonPress,this);t.onkeydown=this.handleKeydown;return t};y.prototype._initSplitButton=function(){var t=new i(this.getId()+"-internalSplitBtn",{width:"100%"});t.attachPress(this._handleActionPress,this);t.attachArrowPress(this._handleButtonPress,this);t._getArrowButton().onkeydown=this.handleKeydown;return t};y.prototype._initButtonControl=function(){var t;if(this._isSplitButton()){t=this._initSplitButton()}else{t=this._initButton()}this.setAggregation("_button",t,true)};y.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText())};y.prototype._getButtonControl=function(){return this.getAggregation("_button")};y.prototype._handleButtonPress=function(t){var e=this.getMenu(),o={zero:"0 0",plus2_right:"0 +2",minus2_right:"0 -2",plus2_left:"+2 0",minus2_left:"-2 0"};this.fireBeforeMenuOpen();if(!e){return}if(this._bPopupOpen&&!t.getParameter("keyboard")){this.getMenu().close();this._bPopupOpen=false;return}if(!e.getTitle()){e.setTitle(this.getText())}var i=[this,t.getParameter("keyboard")];switch(this.getMenuPosition()){case f.BeginTop:i.push(f.BeginBottom,f.BeginTop,o.plus2_right);break;case f.BeginCenter:i.push(f.BeginCenter,f.BeginCenter,o.zero);break;case f.LeftTop:i.push(f.RightBottom,f.LeftBottom,o.plus2_left);break;case f.LeftCenter:i.push(f.RightCenter,f.LeftCenter,o.plus2_left);break;case f.LeftBottom:i.push(f.RightTop,f.LeftTop,o.plus2_left);break;case f.CenterTop:i.push(f.CenterBottom,f.CenterTop,o.plus2_left);break;case f.CenterCenter:i.push(f.CenterCenter,f.CenterCenter,o.zero);break;case f.CenterBottom:i.push(f.CenterTop,f.CenterBottom,o.minus2_right);break;case f.RightTop:i.push(f.LeftBottom,f.RightBottom,o.minus2_left);break;case f.RightCenter:i.push(f.LeftCenter,f.RightCenter,o.minus2_left);break;case f.RightBottom:i.push(f.LeftTop,f.RightTop,o.minus2_left);break;case f.EndTop:i.push(f.EndBottom,f.EndTop,o.plus2_right);break;case f.EndCenter:i.push(f.EndCenter,f.EndCenter,o.zero);break;case f.EndBottom:i.push(f.EndTop,f.EndBottom,o.minus2_right);break;case f.BeginBottom:default:i.push(f.BeginTop,f.BeginBottom,o.minus2_right);break}e.openBy.apply(e,i);if(this.getMenu()){this._bPopupOpen=true}this._writeAriaAttributes();if(this._isSplitButton()&&!n.system.phone){this._getButtonControl().setArrowState(true)}};y.prototype._handleActionPress=function(){var t=this._getLastSelectedItem(),e;if(!this.getUseDefaultActionOnly()&&t){e=sap.ui.getCore().byId(t);this.getMenu().fireItemSelected({item:e})}else{this.fireDefaultAction()}};y.prototype._menuClosed=function(){var t=this._getButtonControl(),e=t,o=this.getMenu(),i=o&&o._getMenu&&o._getMenu();if(this._isSplitButton()){t.setArrowState(false);e=t._getArrowButton()}if(i&&i._bLeavingMenu){this._bPopupOpen=false}e.$().removeAttr("aria-controls");e.$().attr("aria-expanded","false")};y.prototype._menuItemSelected=function(t){var e=t.getParameter("item");this.fireEvent("_menuItemSelected",{item:e});this._bPopupOpen=false;if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!e){return}this._lastActionItemId=e.getId();!!this._sDefaultText&&this.setText(e.getText());!!this._sDefaultIcon&&this.setIcon(e.getIcon())};y.prototype._getLastSelectedItem=function(){return this._lastActionItemId};y.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this)}};y.prototype._isSplitButton=function(){return this.getButtonMode()===h.Split};y.prototype.setProperty=function(t,o,i){function n(t){var e=[g.Up,g.Back,g.Unstyled];return e.indexOf(t)!==-1}if(t==="type"&&n(o)){return this}if(t==="text"){this._sDefaultText=o}switch(t){case"activeIcon":case"iconDensityAware":case"textDirection":case"visible":case"enabled":this._getButtonControl().setProperty(t,o);break}return e.prototype.setProperty.apply(this,arguments)};y.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return e.prototype.setTooltip.apply(this,arguments)};y.prototype.setText=function(t){e.prototype.setProperty.call(this,"text",t);this._getButtonControl().setText(t);return this};y.prototype.setType=function(t){e.prototype.setProperty.call(this,"type",t);this._getButtonControl().setType(t);return this};y.prototype.setIcon=function(t){e.prototype.setProperty.call(this,"icon",t);this._getButtonControl().setIcon(t);return this};y.prototype.addAriaLabelledBy=function(t){this.getAggregation("_button").addAssociation("ariaLabelledBy",t);return e.prototype.addAssociation.call(this,"ariaLabelledBy",t)};y.prototype.addAriaDescribedBy=function(t){this.getAggregation("_button").addAssociation("ariaDescribedBy",t);return e.prototype.addAssociation.call(this,"ariaDescribedBy",t)};y.prototype.removeAriaLabelledBy=function(t){this.getAggregation("_button").removeAssociation("ariaLabelledBy",t);return e.prototype.removeAssociation.call(this,"ariaLabelledBy",t)};y.prototype.removeAriaDescribedBy=function(t){this.getAggregation("_button").removeAssociation("ariaDescribedBy",t);return e.prototype.removeAssociation.call(this,"ariaDescribedBy",t)};y.prototype.removeAllAriaLabelledBy=function(t){this.getAggregation("_button").removeAllAssociation("ariaLabelledBy");return e.prototype.removeAllAssociation.call(this,"ariaLabelledBy")};y.prototype.removeAllAriaDescribedBy=function(){this.getAggregation("_button").removeAllAssociation("ariaDescribedBy");return e.prototype.removeAllAssociation.call(this,"ariaDescribedBy")};y.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef()};y.prototype.onsapescape=function(t){var e=this.getMenu(),o=e&&e._getMenu&&e._getMenu();if(o&&this._bPopupOpen){o._bLeavingMenu=true;o.close();this._menuClosed();t.preventDefault()}};y.prototype.onsapup=function(t){this.openMenuByKeyboard();t.stopPropagation()};y.prototype.onsapdown=function(t){this.openMenuByKeyboard();t.stopPropagation()};y.prototype.onsapupmodifiers=function(t){this.openMenuByKeyboard();t.stopPropagation()};y.prototype.onsapdownmodifiers=function(t){this.openMenuByKeyboard();t.stopPropagation()};y.prototype.onsapshow=function(t){this.openMenuByKeyboard();!!t&&t.preventDefault()};y.prototype.ontouchstart=function(){this._bPopupOpen=this.getMenu()&&this.getMenu()._getMenu()&&this.getMenu()._getMenu().getPopup().isOpen()};y.prototype.handleKeydown=function(t){if((t.keyCode===l.ENTER||t.keyCode===l.TAB)&&this._bPopupOpen){this.getMenu().close();this._bPopupOpen=false}o.prototype.onkeydown.call(this,t)};y.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(Object.create(null,{getParameter:{value:function(){return true}}}))}};y.prototype._writeAriaAttributes=function(){var t=this._getButtonControl(),e=this._isSplitButton()?t._getArrowButton():t,o=this.getMenu();if(o){e.$().attr("aria-controls",o.getDomRefId());e.$().attr("aria-expanded","true")}};y.prototype._getToolbarInteractive=function(){return true};y.prototype.getIdForLabel=function(){return this.getId()+"-internalBtn"};y.prototype._ensureBackwardsReference=function(){var t=this._getButtonControl(),e=t.getAriaLabelledBy(),o=u.getReferencingLabels(this);o.forEach(function(o){if(e&&e.indexOf(o)===-1){t.addAriaLabelledBy(o)}});return this};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MenuButtonRenderer", [],function(){"use strict";var t={apiVersion:2};t.CSS_CLASS="sapMMenuBtn";t.render=function(e,n){var o=n.getWidth();e.openStart("div",n);e.class(t.CSS_CLASS).class(t.CSS_CLASS+n.getButtonMode());if(o!=""){e.style("width",o)}e.openEnd();n._ensureBackwardsReference();e.renderControl(n._getButtonControl());n._activeButton=n._isSplitButton()?n._getButtonControl()._getArrowButton():n._getButtonControl();e.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MenuItem", ["./library","sap/ui/core/Item","sap/ui/base/ManagedObjectObserver"],function(t,e,a){"use strict";var o=e.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"string"},methodName:{type:"string"},methodParams:{type:"object"}}}}}});o.UNIFIED_MENU_ITEMS_ID_SUFFIX="-unifiedmenu";o.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null}if(this._sVisualParent){this._sVisualParent=null}if(this._sVisualControl){this._sVisualControl=null}};o.prototype.setProperty=function(t,a){e.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:t,propertyValue:a},false,true)};o.prototype.setAggregation=function(t,a,o){e.prototype.setAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"set",methodParams:{item:a}},false,true);return this};o.prototype.addAggregation=function(t,a,o){var r=this._getVisualControl(),s;e.prototype.addAggregation.apply(this,arguments);if(t==="customData"&&r){s=sap.ui.getCore().byId(r);this._addCustomData(s,a)}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"add",methodParams:{item:a}},false,true);return this};o.prototype.insertAggregation=function(t,a,r,s){var i=this._getVisualControl(),n;e.prototype.insertAggregation.apply(this,arguments);if(t==="customData"&&i){n=sap.ui.getCore().byId(i);n.insertCustomData(a.clone(o.UNIFIED_MENU_ITEMS_ID_SUFFIX),r);this._observeCustomDataChanges(a)}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"insert",methodParams:{item:a,index:r}},false,true);return this};o.prototype.removeAggregation=function(t,a,o){var r=e.prototype.removeAggregation.apply(this,arguments);if(t==="customData"){if(this.getCustomData().length===1){this._disconnectAndDestroyCustomDataObserver()}else if(a&&this._oCustomDataObserver){this._oCustomDataObserver.unobserve(a,{properties:["value"]})}}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"remove",methodParams:{item:r}},false,true);return r};o.prototype.removeAllAggregation=function(t,a){var o=e.prototype.removeAllAggregation.apply(this,arguments);if(t==="customData"){this._disconnectAndDestroyCustomDataObserver()}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"removeall",methodParams:{items:o}},false,true);return o};o.prototype.destroyAggregation=function(t,a){if(t==="customData"){this._disconnectAndDestroyCustomDataObserver()}this.fireEvent("aggregationChanged",{aggregationName:t,methodName:"destroy"},false,true);return e.prototype.destroyAggregation.apply(this,arguments)};o.prototype.destroy=function(){var t=sap.ui.getCore().byId(this._getVisualControl());if(t){t.destroy()}return e.prototype.destroy.apply(this,arguments)};o.prototype.addEventDelegate=function(t,a){e.prototype.addEventDelegate.apply(this,arguments);if(this._getVisualControl()){var o=sap.ui.getCore().byId(this._getVisualControl());o.addEventDelegate(t,a)}return this};o.prototype.removeEventDelegate=function(t){e.prototype.removeEventDelegate.apply(this,arguments);if(this._getVisualControl()){var a=sap.ui.getCore().byId(this._getVisualControl());a.removeEventDelegate(t)}return this};o.prototype._addCustomData=function(t,e){t.addCustomData(e.clone(o.UNIFIED_MENU_ITEMS_ID_SUFFIX,undefined,{bCloneChildren:false,bCloneBindings:true}));this._observeCustomDataChanges(e)};o.prototype._observeCustomDataChanges=function(t){this._getCustomDataObserver().observe(t,{properties:["value"]})};o.prototype._customDataObserverCallbackFunction=function(t){sap.ui.getCore().byId(t.object.getId()+"-"+o.UNIFIED_MENU_ITEMS_ID_SUFFIX).setValue(t.current)};o.prototype._getCustomDataObserver=function(){if(!this._oCustomDataObserver){this._oCustomDataObserver=new a(this._customDataObserverCallbackFunction)}return this._oCustomDataObserver};o.prototype._disconnectAndDestroyCustomDataObserver=function(){if(this._oCustomDataObserver){this._oCustomDataObserver.disconnect();this._oCustomDataObserver.destroy();this._oCustomDataObserver=null}};o.prototype._setVisualChild=function(t){this._setInternalRef(t,"_sVisualChild")};o.prototype._setVisualParent=function(t){this._setInternalRef(t,"_sVisualParent")};o.prototype._setVisualControl=function(t){this._setInternalRef(t,"_sVisualControl")};o.prototype._setInternalRef=function(t,e){if(!t||typeof t==="string"){this[e]=t}else if(t.getId){this[e]=t.getId()}};o.prototype._getVisualChild=function(){return this._sVisualChild};o.prototype._getVisualParent=function(){return this._sVisualParent};o.prototype._getVisualControl=function(){return this._sVisualControl};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MenuListItem", ["./ListItemBase","./library","sap/ui/core/IconPool","sap/ui/core/library","./MenuListItemRenderer","sap/m/Image"],function(e,t,i,r,a,s){"use strict";var o=r.TextDirection;var n=t.ListType;var p=e.extend("sap.m.MenuListItem",{metadata:{library:"sap.m",properties:{enabled:{type:"boolean",group:"Misc",defaultValue:true},title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:o.Inherit},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{menuItem:{type:"sap.m.MenuItem",multiple:false}}},renderer:a});p.prototype.exit=function(){if(this._image){this._image.destroy()}if(this._imageRightArrow){this._imageRightArrow.destroy()}e.prototype.exit.apply(this,arguments)};p.prototype._getImage=function(e,t,r,a){var o=this._image;if(o){o.setSrc(r);if(o.isA("sap.m.Image")){o.setDensityAware(a)}}else{o=i.createControlByURI({id:e,src:r,densityAware:a,useIconTooltip:false},s).setParent(this,null,true)}if(o.isA("sap.m.Image")){o.addStyleClass(t,true)}else{o.addStyleClass(t+"Icon",true)}this._image=o;return this._image};p.prototype._getIconArrowRight=function(){if(!this._imageRightArrow){this._imageRightArrow=i.createControlByURI({id:this.getId()+"-arrowRight",src:"sap-icon://slim-arrow-right",useIconTooltip:false},s).setParent(this,null,true);this._imageRightArrow.addStyleClass("sapMMenuLIArrowRightIcon",true)}return this._imageRightArrow};p.prototype._hasSubItems=function(){return!!(this.getMenuItem()&&sap.ui.getCore().byId(this.getMenuItem()).getItems().length)};p.prototype.setProperty=function(t,i){e.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:t,propertyValue:i});if(t==="enabled"){this.setType(i?n.Active:n.Inactive)}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MenuListItemRenderer", ["./ListItemBaseRenderer","sap/ui/core/Renderer","sap/m/library","sap/ui/core/library"],function(e,t,i,s){"use strict";var n=s.TextDirection;var a=i.ListType;var r=t.extend(e);r.apiVersion=2;r.openItemTag=function(t,i){if(i.getStartsSection()){t.openStart("li");t.attr("role","separator");t.class("sapUiMnuDiv");t.openEnd();t.openStart("div");t.class("sapUiMnuDivL");t.openEnd();t.close("div");t.voidStart("hr").voidEnd();t.openStart("div");t.class("sapUiMnuDivR");t.openEnd();t.close("div");t.close("li")}e.openItemTag(t,i)};r.renderLIAttributes=function(e,t){e.class("sapMSLI");if(t.getIcon()){e.class("sapMSLIIcon")}if(t.getType()==a.Detail||t.getType()==a.DetailAndActive){e.class("sapMSLIDetail")}if(t._hasSubItems()){e.class("sapMMenuLIHasChildren")}if(!t.getEnabled()){e.class("sapMMLIDisabled")}};r.renderLIContent=function(e,t){var i=t.getTitleTextDirection();if(t.getIcon()){e.renderControl(t._getImage(t.getId()+"-img","sapMMenuLIImgThumb",t.getIcon(),t.getIconDensityAware()))}e.openStart("div");e.class("sapMSLIDiv");e.class("sapMSLITitleDiv");e.openEnd();if(t._bNoFlex){e.openStart("div");e.class("sapMLIBNoFlex");e.openEnd()}e.openStart("div");e.class("sapMSLITitleOnly");if(i!==n.Inherit){e.attr("dir",i.toLowerCase())}e.openEnd();e.text(t.getTitle());e.close("div");if(t._bNoFlex){e.close("div")}e.close("div");if(t._hasSubItems()){e.renderControl(t._getIconArrowRight())}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessageBox", ["./Button","./Dialog","./Text","./FormattedText","./Link","./MessageStrip","./VBox","sap/ui/core/IconPool","sap/ui/core/ElementMetadata","sap/ui/core/library","sap/ui/core/Control","sap/m/library","sap/ui/thirdparty/jquery"],function(e,t,i,n,s,o,a,l,r,c,u,d,jQuery){"use strict";var f=d.DialogType;var g=d.DialogRoleType;var O=d.ButtonType;var p=d.TitleAlignment;var I=d.FlexRendertype;var T=d.FlexAlignItems;var R=d.LinkAccessibleRole;var S=c.MessageType;var E=c.TextDirection;var y={};y.Action={OK:"OK",CANCEL:"CANCEL",YES:"YES",NO:"NO",ABORT:"ABORT",RETRY:"RETRY",IGNORE:"IGNORE",CLOSE:"CLOSE",DELETE:"DELETE"};y.Icon={NONE:undefined,INFORMATION:"INFORMATION",WARNING:"WARNING",ERROR:"ERROR",SUCCESS:"SUCCESS",QUESTION:"QUESTION"};var x=y.Action,A=y.Icon;function C(){if(y._rb!==sap.ui.getCore().getLibraryResourceBundle("sap.m")){y._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m")}}function N(e){if(typeof e==="object"){return"<pre>"+JSON.stringify(e,null,"\t").replace(/{/gi,"&#x007B;")+"</pre>"}return e}function M(e,t,i,l){var r,c,u,d,f=false,g=new a({renderType:I.Bare,alignItems:T.Start,items:[t]});if(!e.details){return g}function O(e){r.setHtmlText(N(e));var t=i.getInitialFocus();i.addAriaLabelledBy(r);r.setVisible(true);c.setVisible(false);i._setInitialFocus();if(!t||t===c.getId()){l.focus()}}function p(){c.setBusyIndicatorDelay(0).setBusy(true);c.getDomRef("busyIndicator").focus();e.details().then(function(e){if(i.isDestroyed()){return}O(e)}).catch(function(){if(i.isDestroyed()){return}if(document.activeElement===c.getDomRef("busyIndicator")){f=true}c.setVisible(false);u.setVisible(true)})}r=new n({visible:false});c=new s({accessibleRole:R.Button,text:y._rb.getText("MSGBOX_LINK_TITLE"),press:function(){if(typeof e.details==="function"){p()}else{O(e.details)}}});d=new s({text:y._rb.getText("MSGBOX_DETAILS_RETRY_LOADING"),accessibleRole:R.Button,press:function(){c.setVisible(true);u.setVisible(false);var e={onAfterRendering:function(){c.removeEventDelegate(e);p()}};c.addEventDelegate(e)}});d.addEventDelegate({onAfterRendering:function(){if(f){d.focus()}f=false}});u=new o({text:y._rb.getText("MSGBOX_DETAILS_LOAD_ERROR"),type:S.Error,visible:false,link:d});c.addStyleClass("sapMMessageBoxLinkText");u.addStyleClass("sapMMessageBoxErrorText");r.addStyleClass("sapMMessageBoxDetails");g.addItem(c);g.addItem(u);g.addItem(r);return g}y.show=function(n,s){var o,a,c,d=null,I=[],T,R,S,N,h,b,v,B={id:r.uid("mbox"),initialFocus:null,textDirection:E.Inherit,verticalScrolling:true,horizontalScrolling:true,details:"",contentWidth:null},m={INFORMATION:"sapMMessageBoxInfo",WARNING:"sapMMessageBoxWarning",ERROR:"sapMMessageBoxError",SUCCESS:"sapMMessageBoxSuccess",QUESTION:"sapMMessageBoxQuestion",STANDARD:"sapMMessageBoxStandard"},_={INFORMATION:l.getIconURI("information"),WARNING:l.getIconURI("alert"),ERROR:l.getIconURI("error"),SUCCESS:l.getIconURI("sys-enter-2"),QUESTION:l.getIconURI("sys-help-2")};C();if(typeof s==="string"||arguments.length>2){R=arguments[1];S=arguments[2];N=arguments[3];h=arguments[4];b=arguments[5];v=arguments[6];s={icon:R,title:S,actions:N,onClose:h,id:b,styleClass:v}}if(s&&s.hasOwnProperty("details")){B.icon=A.INFORMATION;B.emphasizedAction=x.OK;B.actions=[x.OK,x.CANCEL];s=jQuery.extend({},B,s)}s=jQuery.extend({},B,s);if(typeof s.actions!=="undefined"&&!Array.isArray(s.actions)){if(s.emphasizedAction!==null){s.emphasizedAction=s.actions}s.actions=[s.actions]}if(!s.actions||s.actions.length===0){s.emphasizedAction=x.OK;s.actions=[x.OK]}function L(t,i){var n;if(y.Action.hasOwnProperty(t)){n=y._rb.getText("MSGBOX_"+t)}var s=new e({id:r.uid("mbox-btn-"),text:n||t,type:i,press:function(){d=t;o.close()}});return s}var D;for(T=0;T<s.actions.length;T++){D=s.emphasizedAction===s.actions[T]?O.Emphasized:O.Default;I.push(L(s.actions[T],D))}function F(){if(typeof s.onClose==="function"){s.onClose(d)}o.detachAfterClose(F);o.destroy()}function w(){var e=0;var t=null;if(s.initialFocus){if(s.initialFocus instanceof u){t=s.initialFocus}if(typeof s.initialFocus==="string"){for(e=0;e<I.length;e++){if(y.Action.hasOwnProperty(s.initialFocus)){if(y._rb.getText("MSGBOX_"+s.initialFocus).toLowerCase()===I[e].getText().toLowerCase()){t=I[e];break}}else{if(s.initialFocus.toLowerCase()===I[e].getText().toLowerCase()){t=I[e];break}}}}}return t}if(typeof n==="string"){c=new i({textDirection:s.textDirection}).setText(n).addStyleClass("sapMMsgBoxText");a=c}else if(n instanceof u){c=n.addStyleClass("sapMMsgBoxText")}o=new t({id:s.id,type:f.Message,title:s.title,titleAlignment:p.Auto,icon:_[s.icon],initialFocus:w(),verticalScrolling:s.verticalScrolling,horizontalScrolling:s.horizontalScrolling,afterClose:F,buttons:I,ariaLabelledBy:a?a.getId():undefined,contentWidth:s.contentWidth,closeOnNavigation:s.closeOnNavigation}).addStyleClass("sapMMessageBox");if(s.hasOwnProperty("details")&&s.details!==""){c=M(s,c,o,I[0])}o.addContent(c);o.setProperty("role",g.AlertDialog);if(m[s.icon]){o.addStyleClass(m[s.icon])}else{o.addStyleClass(m.STANDARD)}if(s.styleClass){o.addStyleClass(s.styleClass)}o.open()};y.alert=function(e,t){C();var i={icon:A.NONE,title:y._rb.getText("MSGBOX_TITLE_ALERT"),emphasizedAction:t&&t.actions?null:x.OK,actions:x.OK,id:r.uid("alert"),initialFocus:null},n,s,o,a;if(typeof t==="function"||arguments.length>2){n=arguments[1];s=arguments[2];o=arguments[3];a=arguments[4];t={onClose:n,title:s,id:o,styleClass:a}}t=jQuery.extend({},i,t);y.show(e,t)};y.confirm=function(e,t){C();var i={icon:A.QUESTION,title:y._rb.getText("MSGBOX_TITLE_CONFIRM"),emphasizedAction:t&&t.actions?null:x.OK,actions:[x.OK,x.CANCEL],id:r.uid("confirm"),initialFocus:null},n,s,o,a;if(typeof t==="function"||arguments.length>2){n=arguments[1];s=arguments[2];o=arguments[3];a=arguments[4];t={onClose:n,title:s,id:o,styleClass:a}}t=jQuery.extend({},i,t);y.show(e,t)};y.error=function(e,t){C();var i={icon:A.ERROR,title:y._rb.getText("MSGBOX_TITLE_ERROR"),emphasizedAction:null,actions:x.CLOSE,id:r.uid("error"),initialFocus:null};t=jQuery.extend({},i,t);y.show(e,t)};y.information=function(e,t){C();var i={icon:A.INFORMATION,title:y._rb.getText("MSGBOX_TITLE_INFO"),emphasizedAction:t&&t.actions?null:x.OK,actions:x.OK,id:r.uid("info"),initialFocus:null};t=jQuery.extend({},i,t);y.show(e,t)};y.warning=function(e,t){C();var i={icon:A.WARNING,title:y._rb.getText("MSGBOX_TITLE_WARNING"),emphasizedAction:t&&t.actions?null:x.OK,actions:x.OK,id:r.uid("warning"),initialFocus:null};t=jQuery.extend({},i,t);y.show(e,t)};y.success=function(e,t){C();var i={icon:A.SUCCESS,title:y._rb.getText("MSGBOX_TITLE_SUCCESS"),emphasizedAction:t&&t.actions?null:x.OK,actions:x.OK,id:r.uid("success"),initialFocus:null};t=jQuery.extend({},i,t);y.show(e,t)};return y},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessageItem", ["./library","sap/ui/core/Item","sap/ui/core/library","sap/base/Log"],function(e,t,a,r){"use strict";var s=a.MessageType;var i=t.extend("sap.m.MessageItem",{metadata:{library:"sap.m",properties:{type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:s.Error},title:{type:"string",group:"Appearance",defaultValue:""},subtitle:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Appearance",defaultValue:""},markupDescription:{type:"boolean",group:"Appearance",defaultValue:false},longtextUrl:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},counter:{type:"int",group:"Misc",defaultValue:null},groupName:{type:"string",group:"Misc",defaultValue:""},activeTitle:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"}}}});i.prototype.setProperty=function(e,a,r){var s=this.getParent(),i=this.getType().toLowerCase(),p=["description","type","groupName"],o=function(e,t){if(t._oMessagePopoverItem.getId()===this.getId()&&t.getMetadata().getProperty(e)){t.setProperty(e,a)}};if(p.indexOf(e)===-1&&s&&"_bItemsChanged"in s&&!s._bItemsChanged){s._oLists&&s._oLists.all&&s._oLists.all.getItems&&s._oLists.all.getItems().forEach(o.bind(this,e));s._oLists&&s._oLists[i]&&s._oLists[i].getItems&&s._oLists[i].getItems().forEach(o.bind(this,e))}if(typeof this._updatePropertiesFn==="function"){this._updatePropertiesFn()}return t.prototype.setProperty.apply(this,arguments)};i.prototype._updateProperties=function(e){this._updatePropertiesFn=e};i.prototype.setType=function(e){if(e===s.None){e=s.Information;r.warning("The provided None type is handled and rendered as Information type")}return this.setProperty("type",e,true)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessageListItem", ["sap/ui/core/library","sap/ui/core/InvisibleText","./library","./StandardListItem","./Link","./MessageListItemRenderer"],function(e,t,i,r,s,n){"use strict";var a=e.MessageType;var o=i.ListType;var p=r.extend("sap.m.MessageListItem",{metadata:{library:"sap.m",properties:{activeTitle:{type:"boolean",group:"Misc",defaultValue:false},messageType:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:a.Error}},aggregations:{link:{type:"sap.m.Link",group:"Misc",multiple:false},linkAriaDescribedBy:{type:"sap.ui.core.Control",group:"Misc",multiple:false}},events:{activeTitlePress:{}}},renderer:n});p.prototype.onBeforeRendering=function(){r.prototype.onBeforeRendering.apply(this,arguments);var e=this.getLink(),t;if(!e&&this.getActiveTitle()){e=new s({press:[this.fireActiveTitlePress,this]});this.setLink(e)}if(e&&!e.getAriaDescribedBy().length){t=this._getLinkAriaDescribedBy();e.setText(this.getTitle());e.addAriaDescribedBy(t.getId());this.setLinkAriaDescribedBy(t)}};p.prototype._getLinkAriaDescribedBy=function(){var e=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("MESSAGE_VIEW_LINK_FOCUS_TEXT_"+this.getMessageType().toUpperCase());return new t(this.getId()+"-link",{text:e})};p.prototype.onkeydown=function(e){if(this.getActiveTitle()&&e.altKey&&e.key==="Enter"){this.fireActiveTitlePress(this)}};p.prototype.getContentAnnouncement=function(e){var t=r.prototype.getContentAnnouncement.apply(this,arguments),i,s,n;if(this.getActiveTitle()){n=this.getMessageType().toUpperCase();i=e.getText("MESSAGE_LIST_ITEM_FOCUS_TEXT_LOCATION_"+n);s=this.getType()===o.Navigation?e.getText("MESSAGE_LIST_ITEM_FOCUS_TEXT_DESCRIPTION"):"";t+=". ".concat(i,". ",s)}return t};p.prototype.getTitleRef=function(){var e=this.getActiveTitle();var t=this.getDescription();if(e){return this.getDomRef().querySelector("a")}if(t){return this.getDomRef().querySelector(".sapMSLITitle")}return this.getDomRef().querySelector(".sapMSLITitleOnly")};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessageListItemRenderer", ["./StandardListItemRenderer","sap/ui/core/Renderer"],function(e,r){"use strict";var t=r.extend(e);t.apiVersion=2;t.renderTitle=function(r,t){if(t.getActiveTitle()){r.renderControl(t.getLink());r.renderControl(t.getLinkAriaDescribedBy())}else{e.renderTitle.apply(this,arguments)}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessagePage", ["./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/base/ManagedObject","sap/m/Text","sap/m/Image","sap/m/Button","sap/m/Title","sap/m/Bar","sap/m/FormattedText","./MessagePageRenderer","sap/ui/thirdparty/jquery"],function(t,e,i,r,s,o,n,a,g,p,u,l,jQuery){"use strict";var c=e.TextAlign;var d=e.TextDirection;var h=t.ButtonType;var y=t.BarDesign;var m=e.TitleLevel;var f=i.extend("sap.m.MessagePage",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:"No matching items found."},description:{type:"string",group:"Misc",defaultValue:"Check the filter settings."},title:{type:"string",group:"Misc",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:m.Auto},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:"sap-icon://documents"},iconAlt:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{customText:{type:"sap.m.Link",multiple:false},customDescription:{type:"sap.m.Link",multiple:false},buttons:{type:"sap.m.Button",multiple:true},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_description:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{navButtonPress:{}},designtime:"sap/m/designtime/MessagePage.designtime"},renderer:l});f.ARIA_ROLE_DESCRIPTION="MESSAGE_PAGE_ROLE_DESCRIPTION";f.prototype.init=function(){var t=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTitle=null;this._oNavButton=new a(this.getId()+"-navButton",{type:h.Back,press:jQuery.proxy(function(){this.fireNavButtonPress()},this)});this.setAggregation("_internalHeader",new p(this.getId()+"-intHeader",{design:y.Header}));this.setProperty("text",t.getText("MESSAGE_PAGE_TEXT"),true);this.setProperty("description",t.getText("MESSAGE_PAGE_DESCRIPTION"),true);this._sAriaRoleDescription=t.getText(f.ARIA_ROLE_DESCRIPTION)};f.prototype.exit=function(){if(this._oNavButton){this._oNavButton.destroy();this._oNavButton=null}};f.prototype.setTitle=function(t){this.setProperty("title",t,true);this._getTitle().setText(t);return this};f.prototype.setTitleLevel=function(t){this.setProperty("titleLevel",t,true);this._getTitle().setLevel(t);return this};f.prototype.setText=function(t){this.setProperty("text",t,true);var e=this.getAggregation("_text");e&&e.setText(t);return this};f.prototype.setDescription=function(t){this.setProperty("description",t,true);var e=this.getAggregation("_formattedText"),i=this.getAggregation("_description");e&&e.setHtmlText(t);i&&i.setText(t);return this};f.prototype.setShowNavButton=function(t){this.setProperty("showNavButton",t,true);var e=this._getInternalHeader();if(t){e.addContentLeft(this._oNavButton)}else{e.removeAllContentLeft()}return this};f.prototype.setIcon=function(t){this.setProperty("icon",t,true);var e=this.getAggregation("_icon");e&&e.setSrc(t);return this};f.prototype.setEnableFormattedText=function(t){var e;if(t){e=this._getFormattedText();e.setHtmlText(this.getDescription())}return this.setProperty("enableFormattedText",t)};f.prototype._getIconControl=function(){var t=this.getAggregation("_icon");if(t){t.destroy()}t=r.createControlByURI({id:this.getId()+"-pageIcon",src:this.getIcon(),height:"8rem",width:"8rem",useIconTooltip:true,decorative:false,alt:this.getIconAlt()},n).addStyleClass("sapMMessagePageIcon");this.setAggregation("_icon",t,true);return t};f.prototype._getText=function(){if(this.getAggregation("customText")){return this.getAggregation("customText")}if(!this.getAggregation("_text")){var t=new o(this.getId()+"-text",{id:this.getId()+"-customText",text:s.escapeSettingsValue(this.getText()),textAlign:c.Center,textDirection:this.getTextDirection()});this.setAggregation("_text",t)}return this.getAggregation("_text")};f.prototype._getTitle=function(){if(!this._oTitle){this._oTitle=new g(this.getId()+"-title",{level:this.getTitleLevel()});this._getInternalHeader().addContentMiddle(this._oTitle)}return this._oTitle};f.prototype._getDescription=function(){if(this.getAggregation("customDescription")){return this.getAggregation("customDescription")}if(this.getEnableFormattedText()){return this._getFormattedText()}if(!this.getAggregation("_description")){var t=new o(this.getId()+"-description",{id:this.getId()+"-customDescription",text:s.escapeSettingsValue(this.getDescription()),textAlign:c.Center,textDirection:this.getTextDirection()});this.setAggregation("_description",t)}return this.getAggregation("_description")};f.prototype._getAnyHeader=function(){return this._getInternalHeader()};f.prototype._getInternalHeader=function(){return this.getAggregation("_internalHeader")};f.prototype._getFormattedText=function(){var t=this.getAggregation("_formattedText");if(!t){t=new u(this.getId()+"-formattedText");this.setAggregation("_formattedText",t)}return t};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessagePageRenderer", ["sap/ui/core/library"],function(e){"use strict";var n=e.TextDirection;var t={apiVersion:2};t.render=function(e,n){this.startOpeningDiv(e,n);this.renderHeader(e,n);this.startInnerDivs(e);this.renderContent(e,n);this.endInnerDivs(e);this.endOpeningDiv(e)};t.startOpeningDiv=function(e,t){e.openStart("div",t);e.attr("aria-roledescription",t._sAriaRoleDescription);e.class("sapMMessagePage");if(t.getTextDirection()!==n.Inherit){e.attr("dir",t.getTextDirection().toLowerCase())}e.openEnd()};t.renderHeader=function(e,n){if(n.getShowHeader()){e.renderControl(n.getAggregation("_internalHeader"))}};t.startInnerDivs=function(e){e.openStart("div");e.class("sapMMessagePageInner");e.openEnd();e.openStart("div");e.class("sapMMessagePageContentWrapper");e.openEnd()};t.renderContent=function(e,n){if(n.getIcon()){e.renderControl(n._getIconControl())}e.renderControl(n._getText().addStyleClass("sapMMessagePageMainText"));e.renderControl(n._getDescription().addStyleClass("sapMMessagePageDescription"));this.renderButtons(e,n)};t.renderButtons=function(e,n){var t=n.getButtons();if(t.length>0){e.openStart("div");e.class("sapMMessagePageButtonsWrapper");e.openEnd();for(var r=0;r<t.length;r++){e.renderControl(t[r])}e.close("div")}};t.endInnerDivs=function(e){e.close("div");e.close("div")};t.endOpeningDiv=function(e){e.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessagePopover", ["sap/ui/core/Core","./ResponsivePopover","./Button","./Toolbar","./Bar","sap/ui/core/Control","sap/ui/core/IconPool","./semantic/SemanticPage","./Popover","./MessageView","./MessageItem","sap/ui/Device","./MessagePopoverRenderer","sap/base/Log","sap/ui/base/ManagedObjectObserver","sap/ui/thirdparty/jquery"],function(e,t,o,s,i,n,r,a,p,g,l,c,h,u,d,jQuery){"use strict";var f=n.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"function",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"function",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true},groupItems:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item",forwarding:{getter:"_getMessageView",aggregation:"items"}},headerButton:{type:"sap.m.Button",multiple:false,forwarding:{idSuffix:"-messageView",aggregation:"headerButton"}}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}},renderer:h});function _(e){return e.charAt(0).toUpperCase()+e.slice(1)}var y="sapMMsgPopover",m="320px",v="440px",P={back:r.getIconURI("nav-back"),close:r.getIconURI("decline"),information:r.getIconURI("message-information"),warning:r.getIconURI("message-warning"),error:r.getIconURI("message-error"),success:r.getIconURI("message-success")},M=["asyncDescriptionHandler","asyncURLHandler"],B={asyncDescriptionHandler:function(e){var t=e.item.getLongtextUrl();if(t){jQuery.ajax({type:"GET",url:t,success:function(t){e.item.setDescription(t);e.promise.resolve()},error:function(){var o="A request has failed for long text data. URL: "+t;u.error(o);e.promise.reject(o)}})}}};f.setDefaultHandlers=function(e){M.forEach(function(t){if(e.hasOwnProperty(t)){B[t]=e[t]}})};f.prototype.init=function(){var s=this;var i;this._oOpenByControl=null;this._oResourceBundle=e.getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._oMessageView.addEventDelegate({onBeforeRendering:function(){var e=s._oMessageView._oSegmentedButton.getVisible(),t=!s.getInitiallyExpanded()||e;s._oMessageView._oSegmentedButton.setVisible(t);s._oMessageView._listPage.setShowHeader(true)}});this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new t(this.getId()+"-messagePopover",{showHeader:false,contentWidth:v,contentHeight:m,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(e){s.fireAfterOpen({openBy:e.getParameter("openBy")});s.getInitiallyExpanded()&&s._oMessageView._restoreFocus()},afterClose:function(e){s._oMessageView._navContainer.removeAllPages().forEach(function(e){s._oMessageView._navContainer.addPage(e)});s.fireAfterClose({openBy:e.getParameter("openBy")})},beforeOpen:function(e){var t=s.getItems();if(!s.getBindingInfo("items")&&!t.length){s._bindToMessageModel()}s.fireBeforeOpen({openBy:e.getParameter("openBy")})},beforeClose:function(e){s.fireBeforeClose({openBy:e.getParameter("openBy")})}}).addStyleClass(y);this._oPopover._setAriaModal(false);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);i=this._oPopover.getAggregation("_popup");i.oPopup.setAutoClose(false);i.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(c.system.phone){this._oPopover.setBeginButton(new o({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}))}M.forEach(function(e){if(B.hasOwnProperty(e)){this["set"+_(e)](B[e])}},this);this._observeItems()};f.prototype._bindToMessageModel=function(){var t=this;this.setModel(e.getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new l({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate})};f.prototype._observeItems=function(){var e=new d(function(e){var t=e.mutation;var o=e.child;switch(t){case"insert":o.attachEvent("_change",this.invalidate,this);break;case"remove":o.detachEvent("_change",this.invalidate,this);break;default:break}}.bind(this));e.observe(this._oMessageView,{aggregations:["items"]})};f.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover)}this._oPopover.setPlacement(this.getPlacement())};f.prototype.onBeforeRenderingPopover=function(){this._setInitialFocus();if(this._oOpenByControl&&!this._oOpenByControl.getVisible()){this._oPopover.close()}this._syncMessageView()};f.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null}};f.prototype.exit=function(){this._oResourceBundle=null;this._oOpenByControl=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null}if(this._oPopover){this._oPopover.destroy();this._oPopover=null}};f.prototype.openBy=function(e){var t=this._oPopover.getAggregation("_popup"),o=e.getParent();this._oOpenByControl=e;if(t instanceof p){if(o instanceof s||o instanceof i||o instanceof a){t._minDimensions={width:400,height:128};t.setShowArrow(false);t.setResizable(true)}else{t.setShowArrow(true)}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(e)}return this};f.prototype.close=function(){if(this._oPopover){this._oPopover.close()}return this};f.prototype.isOpen=function(){return this._oPopover?this._oPopover.isOpen():false};f.prototype.toggle=function(e){if(this.isOpen()){this.close()}else{this.openBy(e)}return this};f.prototype.getDomRef=function(e){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(e)};f.prototype._initMessageView=function(){var e=this,t;t=new g(this.getId()+"-messageView",{activeTitlePress:function(t){if(c.system.phone){e.close()}e.fireActiveTitlePress({item:t.getParameter("item")})},listSelect:function(t){e.fireListSelect({messageTypeFilter:t.getParameter("messageTypeFilter")})},itemSelect:function(t){e.fireItemSelect({messageTypeFilter:t.getParameter("messageTypeFilter"),item:t.getParameter("item")})},longtextLoaded:function(){e.fireLongtextLoaded()},urlValidated:function(){e.fireUrlValidated()}});t._makeAutomaticBinding=function(){var t=e.getItems();if(!e.getBindingInfo("items")&&!t.length){this._bindToMessageModel()}};return t};f.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(y+"-init")){this._expandMsgPopover()}};f.prototype._restoreExpansionDefaults=function(){if(this._oMessageView&&!this.getInitiallyExpanded()&&this.getItems().length!=1){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none")}else{this._expandMsgPopover()}};f.prototype._expandMsgPopover=function(){var e=m,t=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&t!=="0px"){e=parseFloat(t)?t:e}this._oPopover.setContentHeight(e).removeStyleClass(y+"-init")};f.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(y+"-init").setContentHeight("auto")};f.prototype._insertCloseBtn=function(e){var t=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),s=new o({icon:P["close"],visible:!c.system.phone,tooltip:t,press:this.close.bind(this)}).addStyleClass(y+"CloseBtn");e.insertContent(s,3,true)};f.prototype._setInitialFocus=function(){if(this._oMessageView&&this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||"all"])}};f.prototype._syncMessageView=function(){if(this._oMessageView){this._oMessageView.setProperty("asyncDescriptionHandler",this.getAsyncDescriptionHandler(),true);this._oMessageView.setProperty("asyncURLHandler",this.getAsyncURLHandler(),true);this._oMessageView.setProperty("groupItems",this.getGroupItems(),false)}};f.prototype._getMessageView=function(){return this._oMessageView};f.prototype.setModel=function(e,t){if(this._oMessageView){this._oMessageView.setModel(e,t)}return n.prototype.setModel.apply(this,arguments)};f.prototype.navigateBack=function(){if(this._oMessageView){this._oMessageView.navigateBack()}};["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(e){f.prototype[e]=function(){if(this._oPopover&&this._oPopover[e]){var t=this._oPopover;var o=t[e].apply(t,arguments);return o===t?this:o}}});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(e){f.prototype["_"+e+"Old"]=f.prototype[e];f.prototype[e]=function(){var t=f.prototype["_"+e+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate()}if(["removeAggregation","removeAllAggregation"].indexOf(e)!==-1){return t}return this}});return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessagePopoverItem", ["./library","./MessageItem"],function(e,t){"use strict";var a=t.extend("sap.m.MessagePopoverItem",{metadata:{deprecated:true}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessagePopoverRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,n){};return e},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/m/MessageStrip", ["./library","sap/ui/core/Control","./MessageStripUtilities","./Text","./Link","./FormattedText","sap/ui/core/library","./MessageStripRenderer","sap/base/Log","sap/m/Button","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/core/InvisibleText"],function(e,t,i,s,a,o,n,r,l,p,g,u,d){"use strict";var c=n.MessageType;var y=e.ButtonType;var f=t.extend("sap.m.MessageStrip",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MessageStrip.designtime",properties:{text:{type:"string",group:"Appearance",defaultValue:""},type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:c.Information},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},showCloseButton:{type:"boolean",group:"Appearance",defaultValue:false},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{close:{}},dnd:{draggable:true,droppable:false}},renderer:r});f.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this.setAggregation("_text",new s);this._initCloseButton()};f.prototype.onBeforeRendering=function(){this._normalizeType(this.getType());this._setButtonAriaLabelledBy(this.getType())};f.prototype.setText=function(e){var t=this.getAggregation("_formattedText");if(t){t.setHtmlText(e)}this.getAggregation("_text").setText(e);return this.setProperty("text",e)};f.prototype.close=function(){var e=u.getAnimationMode(),t=e!==u.AnimationMode.none&&e!==u.AnimationMode.minimal;var s=function(){this.setVisible(false);this.fireClose()}.bind(this);if(!t){s();return}i.closeTransitionWithCSS.call(this,s)};f.prototype.setEnableFormattedText=function(e){var t=this.getAggregation("_formattedText");if(e){if(!t){t=new o;t._setUseLimitedRenderingRules(true);this.setAggregation("_formattedText",t)}t.setHtmlText(this.getText())}return this.setProperty("enableFormattedText",e)};f.prototype.setAggregation=function(e,i,s){if(e==="link"&&i instanceof a){var o=this.getId()+"-info"+" "+this.getAggregation("_text").getId(),n=i.getAriaDescribedBy();if(!n.includes(o)){i.addAriaDescribedBy(o)}}t.prototype.setAggregation.call(this,e,i,s);return this};r.getAccessibilityState=function(){var e=i.getAccessibilityState.call(this),t=this.getLink(),s=g.getLibraryResourceBundle("sap.m");if(!t){e.labelledby=this.getId()}e.roledescription=s.getText("MESSAGE_STRIP_ARIA_ROLE_DESCRIPTION");return e};f.prototype.ontouchmove=function(e){e.setMarked()};f.prototype._normalizeType=function(e){if(e===c.None){l.warning(i.MESSAGES.TYPE_NOT_SUPPORTED);this.setProperty("type",c.Information,true)}};f.prototype._initCloseButton=function(){var e=g.getLibraryResourceBundle("sap.m"),t=this.getAggregation("_closeButton");if(!t){var s=new p({type:y.Transparent,tooltip:e.getText("MESSAGE_STRIP_TITLE"),icon:"sap-icon://decline",press:this.close.bind(this)}).addStyleClass(i.CLASSES.CLOSE_BUTTON).addStyleClass("sapUiSizeCompact");this.setAggregation("_closeButton",s);this._setButtonAriaLabelledBy(this.getType())}};f.prototype._setButtonAriaLabelledBy=function(e){var t=this.getAggregation("_closeButton"),i=g.getLibraryResourceBundle("sap.m"),s=i.getText("MESSAGE_STRIP_"+e.toUpperCase()+"_CLOSE_BUTTON");if(!this._oInvisibleText){this._oInvisibleText=new d({text:s}).toStatic()}else{this._oInvisibleText.setText(s)}if(t){t.removeAllAssociation("ariaLabelledBy",true);t.addAssociation("ariaLabelledBy",this._oInvisibleText.getId(),true)}};f.prototype.exit=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessageStripRenderer", ["./MessageStripUtilities","sap/ui/core/IconPool"],function(e,t){"use strict";var n={apiVersion:2};n.render=function(e,t){this.startMessageStrip(e,t);this.renderAriaTypeText(e,t);if(t.getShowIcon()){this.renderIcon(e,t)}this.renderTextAndLink(e,t);if(t.getShowCloseButton()){this.renderCloseButton(e,t)}this.endMessageStrip(e)};n.startMessageStrip=function(t,n){t.openStart("div",n);t.class(e.CLASSES.ROOT);t.class(e.CLASSES.ROOT+n.getType());t.attr(e.ATTRIBUTES.CLOSABLE,n.getShowCloseButton());t.accessibilityState(n,this.getAccessibilityState.call(n));t.openEnd()};n.renderAriaTypeText=function(t,n){t.openStart("span",n.getId()+"-info");t.class("sapUiPseudoInvisibleText");t.openEnd();t.text(e.getAriaTypeText.call(n));t.close("span")};n.renderIcon=function(t,n){t.openStart("div");t.class(e.CLASSES.ICON);t.openEnd();t.icon(e.getIconURI.call(n),null,{title:null,"aria-hidden":true});t.close("div")};n.renderTextAndLink=function(t,n){var i=n.getAggregation("_formattedText");t.openStart("div",n.getId()+"-content");t.class(e.CLASSES.MESSAGE);t.openEnd();if(n.getEnableFormattedText()&&i){t.renderControl(i)}else{t.renderControl(n.getAggregation("_text"))}t.renderControl(n.getLink());t.close("div")};n.renderCloseButton=function(e,t){e.renderControl(t.getAggregation("_closeButton"))};n.endMessageStrip=function(e){e.close("div")};return n},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/m/MessageStripUtilities", ["sap/ui/core/IconPool"],function(e){"use strict";var t={};t.MESSAGES={TYPE_NOT_SUPPORTED:"Value 'sap.ui.core.MessageType.None' for property 'type' is not supported. "+"Defaulting to 'sap.ui.core.MessageType.Information'"};t.CLASSES={ROOT:"sapMMsgStrip",ICON:"sapMMsgStripIcon",MESSAGE:"sapMMsgStripMessage",CLOSE_BUTTON:"sapMMsgStripCloseButton",CLOSING_TRANSITION:"sapMMsgStripClosing"};t.ATTRIBUTES={CLOSABLE:"data-sap-ui-ms-closable"};t.RESOURCE_BUNDLE=sap.ui.getCore().getLibraryResourceBundle("sap.m");t.getIconURI=function(){var t=this.getType(),s=this.getCustomIcon(),n;var o={Error:"error",Warning:"alert",Success:"sys-enter-2",Information:"information"};n=e.getIconURI(o[t]);return s||n};t.getAriaTypeText=function(){var e="MESSAGE_STRIP_"+this.getType().toUpperCase(),s=t.RESOURCE_BUNDLE.getText(e);if(this.getShowCloseButton()){s+=" "+t.RESOURCE_BUNDLE.getText("MESSAGE_STRIP_CLOSABLE")}return s};t.isMSCloseButtonPressed=function(e){return e.className.indexOf(t.CLASSES.CLOSE_BUTTON)!==-1||e.parentNode.className.indexOf(t.CLASSES.CLOSE_BUTTON)!==-1};t.closeTransitionWithCSS=function(e){this.$().addClass(t.CLASSES.CLOSING_TRANSITION).one("webkitTransitionEnd transitionend",e)};t.getAccessibilityState=function(){return{role:"note"}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessageToast", ["./InstanceManager","sap/ui/core/Popup","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/UIArea","sap/ui/Device","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration"],function(e,t,o,i,n,s,a,r,jQuery,l){"use strict";var u=o.Dock;var f=o.CSSSize;var d={};var c="0 -64",p="sapMMessageToast",m="sapUiSelectable",v="sapContrast",_="sapContrastPlus";d._mSettings={duration:3e3,width:"15em",my:"center bottom",at:"center bottom",of:document.defaultView,offset:"0 0",collision:"fit fit",onClose:null,animationTimingFunction:"ease",animationDuration:1e3,autoClose:true,closeOnBrowserNavigation:true};d._aPopups=[];d._iOpenedPopups=0;d._bBoundedEvents=false;d._mOptions={};d._sMessage="";d._validateSettings=function(e){d._isFiniteInteger(e.duration);d._validateWidth(e.width);d._validateDockPosition(e.my);d._validateDockPosition(e.at);d._validateOf(e.of);d._validateOffset(e.offset);d._validateCollision(e.collision);d._validateOnClose(e.onClose);d._validateAutoClose(e.autoClose);d._validateAnimationTimingFunction(e.animationTimingFunction);d._isFiniteInteger(e.animationDuration)};d._isFiniteInteger=function(e){if(typeof e!=="number"||!isFinite(e)||!(Math.floor(e)===e)||e<=0){r.error('"iNumber" needs to be a finite positive nonzero integer on '+d+"._isFiniteInteger")}};d._validateWidth=function(e){if(!f.isValid(e)){r.error(e+" is not of type "+'"sap.ui.core.CSSSize" for property "width" on '+d+"._validateWidth")}};d._validateDockPosition=function(e){if(!u.isValid(e)){r.error('"'+e+'"'+" is not of type "+'"sap.ui.core.Popup.Dock" on '+d+"._validateDockPosition")}};d._validateOf=function(e){if(!(e instanceof jQuery)&&!(e&&e.nodeType===1)&&!(e instanceof i)&&e!==window){r.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on '+d+"._validateOf")}};d._validateOffset=function(e){if(typeof e!=="string"){r.error(e+" is of type "+typeof e+', expected "string" for property "offset" on '+d+"._validateOffset")}};d._validateCollision=function(e){var t=/^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;if(!t.test(e)){r.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on '+d+"._validateOffset")}};d._validateOnClose=function(e){if(typeof e!=="function"&&e!==null){r.error('"onClose" should be a function or null on '+d+"._validateOnClose")}};d._validateAutoClose=function(e){if(typeof e!=="boolean"){r.error('"autoClose" should be a boolean on '+d+"._validateAutoClose")}};d._validateAnimationTimingFunction=function(e){var t=/^(ease|linear|ease-in|ease-out|ease-in-out)$/i;if(!t.test(e)){r.error('"animationTimingFunction" should be a string, expected values: '+"ease, linear, ease-in, ease-out, ease-in-out on "+d+"._validateAnimationTimingFunction")}};function y(e){for(var t=["my","at","of","offset"],o=0;o<t.length;o++){if(e[t[o]]!==undefined){return false}}return true}function g(e){var t=document.createElement("div");t.className=p+" "+m+" "+v+" "+_;if(l.getAccessibility()){t.setAttribute("role","alert")}t.style.width=e.width;t.appendChild(document.createTextNode(e.message));return t}function h(e){if(e){if(y(e)){e.offset=c}if(e.of&&e.of.nodeType===9){e.of=document.defaultView}}else{e={offset:c}}return e}d._handleResizeEvent=function(){if(a.system.phone||a.system.tablet){d._resetPosition(d._aPopups)}setTimeout(d["_applyPositions"].bind(d,d._aPopups),0)};d._handleMouseDownEvent=function(e){var t=e.target.hasAttribute("class")&&e.target.getAttribute("class").indexOf(p)!==-1;if(t||e.isMarked("delayedMouseEvent")){return}d._aPopups.forEach(function(e){e&&e.__bAutoClose&&e.close()})};d._resetPosition=function(e){for(var t=0,o;t<e.length;t++){o=e[t]&&e[t].getContent();if(o){o.style.visibility="hidden";o.style.left=0}}};d._applyPositions=function(e){for(var t=0,o,i;t<e.length;t++){o=e[t];if(o){i=o._oPosition;if(a.system.phone||a.system.tablet){setTimeout(d["_applyPosition"].bind(d,o,i),0)}else{o.setPosition(i.my,i.at,i.of,i.offset)}}}};d._applyPosition=function(e,t){t=t||e._oPosition;var o=e.getContent();e.setPosition(t.my,t.at,t.of,t.offset);o.style.visibility="visible"};d._setCloseAnimation=function(e,t,o,i){var n="opacity "+i.animationTimingFunction+" "+i.animationDuration+"ms",s="webkitTransitionEnd."+p+" transitionend."+p,a=l.getAnimationMode(),r=a!==l.AnimationMode.none&&a!==l.AnimationMode.minimal;if(r&&i.animationDuration>0){e[0].style.webkitTransition=n;e[0].style.transition=n;e[0].style.opacity=0;e.on(s,function t(){e.off(s);o()})}else{o()}};d._fnKeyDown=function(e){var t;var o=this._aPopups[0];var i=e.shiftKey;var n=a.os.macintosh?e.metaKey:e.ctrlKey;if(o&&o.isOpen()&&i&&n&&e.code==="KeyM"){e.preventDefault();t=document.querySelector(".sapMMessageToastHiddenFocusable");o.getContent().classList.add("sapMFocus");t.focus();clearTimeout(this._iCloseTimeoutId)}};function b(e){var t=e.shiftKey;var o=a.os.macintosh?e.metaKey:e.ctrlKey;var i=this._aPopups[0];if(e.code==="Escape"||t&&o&&e.code==="KeyM"){e.preventDefault();setTimeout(function(){this._mSettings.opener&&this._mSettings.opener.focus()}.bind(this),0);i.close()}}d.show=function(o,i){var s=n.closestTo(document.activeElement);var r=s&&s.getUIArea&&s.getUIArea();var l;var u=d,f=jQuery.extend({},d._mSettings,{message:o}),c=new t,m,v,_="mousedown."+p+" touchstart."+p,y;d._mSettings.opener=s;if(!this._oRootNode||this._oRootNode&&r&&r.getRootNode()!==this._oRootNode){this._oRootNode=r?r.getRootNode():document.documentElement}i=h(i);jQuery.extend(f,i);d._validateSettings(f);v=g(f);m=d._aPopups.push(c)-1;c.setContent(v);c.setPosition(f.my,f.at,f.of,f.offset,f.collision);c.setAnimations(function e(t,o,i){i()},function e(t,o,i){u._setCloseAnimation(t,o,i,f)});c.setShadow(false);c.__bAutoClose=f.autoClose;if(f.closeOnBrowserNavigation){e.addPopoverInstance(c)}if(!d._bBoundedEvents){jQuery(window).on("resize."+p,d._handleResizeEvent.bind(d));jQuery(document).on(_,d._handleMouseDownEvent.bind(d));d._bBoundedEvents=true}l=document.createElement("span");l.setAttribute("tabIndex",0);l.setAttribute("class","sapMMessageToastHiddenFocusable");c.getContent().prepend(l);if(this._oRootNode){this._oRootNode.removeEventListener("keydown",u._fnKeyDown.bind(u));this._oRootNode.addEventListener("keydown",u._fnKeyDown.bind(u));l.addEventListener("keydown",b.bind(this))}c.open();d._iOpenedPopups++;function C(){e.removePopoverInstance(u._aPopups[m]);jQuery(u._aPopups[m].getContent()).remove();u._aPopups[m].detachClosed(C);u._aPopups[m].destroy();u._aPopups[m]=null;u._iOpenedPopups--;if(u._iOpenedPopups===0){u._aPopups=[];jQuery(window).off("resize."+p);jQuery(document).off(_);u._bBoundedEvents=false}if(typeof f.onClose==="function"){f.onClose.call(u)}}c.attachClosed(C);this._iCloseTimeoutId=setTimeout(c["close"].bind(c),f.duration);function P(){clearTimeout(u._iCloseTimeoutId);u._iCloseTimeoutId=null;function e(){y=setTimeout(c["close"].bind(c),f.duration);c.getContent().removeEventListener("mouseleave",e)}c.getContent().addEventListener("mouseleave",e);clearTimeout(y);y=null}c.getContent().addEventListener("touchstart",P);c.getContent().addEventListener("mouseover",P);if(a.system.desktop){c.getContent().addEventListener("mouseleave",function(){if(document.activeElement!==c.getContent()){this._iCloseTimeoutId=setTimeout(c["close"].bind(c),f.duration)}})}};d.toString=function(){return"sap.m.MessageToast"};return d},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/m/MessageView", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./List","./MessageListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./MessageItem","./GroupHeaderListItem","sap/ui/core/InvisibleText","sap/ui/core/library","sap/ui/base/ManagedObject","./MessageViewRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/URLListValidator","sap/ui/thirdparty/caja-html-sanitizer"],function(jQuery,e,t,i,s,a,n,o,r,l,g,u,c,p,d,h,f,_,m,y,v,I,L,T,M,C){"use strict";var B=v.ValueState;var P=v.MessageType;var S=u.ListType;var w=e.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"function",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"function",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false},showDetailsPageHeader:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false},_navContainer:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}},deprecated:true},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}},renderer:L});var D="sapMMsgView";var E={back:i.getIconURI("nav-back"),close:i.getIconURI("decline"),information:i.getIconURI("information"),warning:i.getIconURI("alert"),error:i.getIconURI("error"),success:i.getIconURI("sys-enter-2")};var H=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var k={asyncDescriptionHandler:function(e){var t=e.item.getLongtextUrl();if(t){jQuery.ajax({type:"GET",url:t,success:function(t){e.item.setDescription(t);e.promise.resolve()},error:function(){var i="A request has failed for long text data. URL: "+t;M.error(i);e.promise.reject(i)}})}}};w.setDefaultHandlers=function(e){A.forEach(function(t){if(e.hasOwnProperty(t)){k[t]=e[t]}})};w.prototype.init=function(){var e=this;this._bHasHeaderButton=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(t){if(k.hasOwnProperty(t)){e.setProperty(t,k[t])}})};w.prototype._afterNavigate=function(){setTimeout(this["_restoreFocus"].bind(this),0);setTimeout(this["_restoreItemsType"].bind(this),0)};w.prototype._restoreFocus=function(){if(this._isListPage()&&this.getItems().length){this._oLists[this._sCurrentList||"all"].focus()}else if(this._oBackButton){this._oBackButton.focus()}};w.prototype._restoreItemsType=function(){if(this._isListPage()&&this.getItems().length>1){var e=this;this._oLists[this._sCurrentList||"all"].getItems().forEach(function(t){if(t.isA("sap.m.MessageListItem")){e._setItemType(t)}})}};w.prototype._setItemType=function(e){var t=e.getTitleRef();if(t&&t.offsetWidth<t.scrollWidth){e.setType(S.Navigation);if(this.getItems().length===1){this._fnHandleForwardNavigation(e,"show")}}};w.prototype.onBeforeRendering=function(){var e,t,i=this.getItems();this._clearLists();this._detailsPage.setShowHeader(this.getShowDetailsPageHeader());if(this.getGroupItems()){e=this._groupItems(i);this._fillGroupedLists(e)}else{this._fillLists(i)}var s=this.getHeaderButton();if(s){this._bHasHeaderButton=true;this._oListHeader.insertContent(s,2)}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");t=this._oLists.all.getItems().filter(function(e){return e.isA("sap.m.MessageListItem")});if(t.length===1&&t[0].getType()===S.Navigation){this._fnHandleForwardNavigation(t[0],"show");this._navContainer._pageStack[this._navContainer._pageStack.length-1].transition="slide"}else if(t.length===0){this._navContainer.backToTop()}this._makeAutomaticBinding()};w.prototype._fillGroupedLists=function(e){var t=Object.keys(e),i=t.indexOf(""),s;if(i!==-1){s=e[""];this._fillLists(s);delete e[""];t.splice(i,1)}t.forEach(function(t){this._fillListsWithGroups(t,e[t])},this)};w.prototype._fillListsWithGroups=function(e,t){var i=new m({title:e});this._oLists["all"].addAggregation("items",i,true);["error","warning","success","information"].forEach(function(e){if(this._hasGroupItemsOfType(t,e)){this._oLists[e].addAggregation("items",i.clone(),true)}},this);this._fillLists(t)};w.prototype._hasGroupItemsOfType=function(e,t){return e.some(function(e){return e.getType().toLowerCase()===t})};w.prototype.exit=function(){if(this._oLists){this._destroyLists()}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy()}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null};w.prototype._makeAutomaticBinding=function(){var e=this.getItems();if(!this.getBindingInfo("items")&&!e.length){this._bindToMessageModel()}};w.prototype._bindToMessageModel=function(){var e=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new _({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:e._oMessageItemTemplate})};w.prototype._groupItems=function(e){var t={},i;e.forEach(function(e){i=e.getGroupName();t[i]=t[i]||[];t[i].push(e)});return t};w.prototype._onkeypress=function(e){if(e.shiftKey&&e.keyCode==T.ENTER){this.navigateBack()}};w.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader()};w.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader()};w.prototype._createListHeader=function(){var e=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var t=this.getId()+"-CloseBtnDescr";var i=new s(t,{content:'<span id="'+t+'" class="sapMMsgViewHiddenContainer">'+e+"</span>"});var a=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING"),n=this.getId()+"-HeadingDescr",l=y.getStaticId("sap.m","MESSAGEVIEW_SEGMENTED_BTN_DESCRIPTION"),g=new s(n,{content:'<span id="'+n+'" class="sapMMsgViewHiddenContainer" role="heading">'+a+"</span>"});this._oSegmentedButton=new p(this.getId()+"-segmented",{ariaLabelledBy:l}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new o({content:[this._oSegmentedButton,new r,i,g]});return this._oListHeader};w.prototype._createDetailsHeader=function(){var e=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var t=this.getId()+"-CloseBtnDetDescr";var i=new s(t,{content:'<span id="'+t+'" class="sapMMsgViewHiddenContainer">'+e+"</span>"});var a=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var l=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var g=this.getId()+"-BackBtnDetDescr";var u=new s(g,{content:'<span id="'+g+'" class="sapMMsgViewHiddenContainer">'+l+"</span>"});this._oBackButton=new n({icon:E["back"],press:this.navigateBack.bind(this),ariaLabelledBy:u,tooltip:a}).addStyleClass(D+"BackBtn");this._oDetailsHeader=new o({content:[this._oBackButton,new r,i,u]});return this._oDetailsHeader};w.prototype._createNavigationPages=function(){this._listPage=new d(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new d(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()}).addStyleClass("sapMMsgViewDetailsPage");this._detailsPage.addEventDelegate({onclick:function(e){var t=e.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgViewItemDisabledLink")!==-1||t.className.indexOf("sapMMsgViewItemPendingLink")!==-1)){e.preventDefault()}}});this._navContainer=new h(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage],afterNavigate:this._afterNavigate.bind(this)});this.setAggregation("_navContainer",this._navContainer);return this};w.prototype._createLists=function(){this._oLists={};H.forEach(function(e){this._oLists[e]=new l({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[e],true)},this);return this};w.prototype._clearLists=function(){H.forEach(function(e){if(this._oLists[e]){this._oLists[e].destroyAggregation("items",true)}},this);return this};w.prototype._destroyLists=function(){H.forEach(function(e){this._oLists[e]=null},this);this._oLists=null};w.prototype._fillLists=function(e){e.forEach(function(e){var t=this._mapItemToListItem(e),i=this._mapItemToListItem(e);this._oLists["all"].addAggregation("items",t,true);this._oLists[e.getType().toLowerCase()].addAggregation("items",i,true)},this)};w.prototype._mapItemToListItem=function(e){if(!e){return null}var t=e.getType(),i=this,s=this._getItemType(e),a=new g({title:I.escapeSettingsValue(e.getTitle()),description:I.escapeSettingsValue(e.getSubtitle()),counter:e.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"",type:s,messageType:e.getType(),activeTitle:e.getActiveTitle(),activeTitlePress:function(){i.fireActiveTitlePress({item:e})}}).addStyleClass(D+"Item").addStyleClass(D+"Item"+t).toggleStyleClass(D+"ItemActive",e.getActiveTitle());if(s!==S.Navigation){a.addEventDelegate({onAfterRendering:function(){i._setItemType(a)}},this)}a._oMessageItem=e;return a};w.prototype._mapInfoState=function(e){if(!e){return null}switch(e){case P.Warning:return B.Warning;case P.Error:return B.Error;case P.Success:return B.Success;case P.Information:case P.None:return B.None;default:M.warning("The provided MessageType is not mapped to a specific ValueState",e);return null}};w.prototype._mapIcon=function(e){if(!e){return null}return E[e.toLowerCase()]};w.prototype._getItemType=function(e){return e.getDescription()||e.getMarkupDescription()||e.getLongtextUrl()?S.Navigation:S.Inactive};w.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true)}return this};w.prototype._fillSegmentedButton=function(){var e=this;var t=function(t){return function(){e._fnFilterList(t)}};H.forEach(function(e){var i=this._oLists[e],s=e=="all"?"MESSAGEPOPOVER_ALL":"MESSAGEVIEW_BUTTON_TOOLTIP_"+e.toUpperCase(),a=i.getItems().filter(function(e){return e instanceof g}).length,o;if(a>0){o=new n(this.getId()+"-"+e,{text:e=="all"?this._oResourceBundle.getText(s):a,tooltip:e==="all"?"":this._oResourceBundle.getText(s),icon:E[e],press:t(e)}).addStyleClass(D+"Btn"+e.charAt(0).toUpperCase()+e.slice(1));this._oSegmentedButton.addButton(o,true)}},this);var i=this._oSegmentedButton.getButtons().length>2;this._oSegmentedButton.setVisible(i);if(!i){this._oSegmentedButton.setSelectedButton(this._oSegmentedButton.getButtons()[0]);this._fnFilterList("all")}var s=i||this._bHasHeaderButton;this._listPage.setShowHeader(s);return this};w.prototype._setIcon=function(e,t){this._previousIconTypeClass=D+"DescIcon"+e.getType();this._oMessageIcon=new a({src:t.getIcon()}).addStyleClass(D+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon)};w.prototype._setTitle=function(e,t){var i=e.getActiveTitle(),s,a=this,n=I.escapeSettingsValue(e.getTitle()),o=this.getId()+"MessageTitleText";if(i){s=new f(o,{text:n,ariaDescribedBy:t.getId()+"-link",press:function(){a.fireActiveTitlePress({item:e})}})}else{s=new c(o,{text:n})}s.addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",s)};w.prototype._setDescription=function(e){var t=e.getLink();var i=e.getDescription();if(e.getMarkupDescription()){var a=this._getTagPolicy();i=html.sanitizeWithPolicy(i,a)}this._oLastSelectedItem=e;if(e.getMarkupDescription()){this._oMessageDescriptionText=new s(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+I.escapeSettingsValue(i)+"</div>"})}else{this._oMessageDescriptionText=new c(this.getId()+"MessageDescriptionText",{text:I.escapeSettingsValue(i)}).addStyleClass("sapMMsgViewDescriptionText")}this._detailsPage.addContent(this._oMessageDescriptionText);if(t){var n=this._createLinkCopy(t);this._detailsPage.addContent(n);n.addStyleClass("sapMMsgViewDescriptionLink")}};w.prototype._createLinkCopy=function(e){var i,s=e.clone("","",{cloneChildren:false,cloneBindings:false}),a=e.getCustomData()||[];i=Object.keys(e.getMetadata().getProperties());i.forEach(function(t){s.setProperty(t,e.getProperty(t))});s.destroyCustomData();a.forEach(function(e){var i=new t({key:e.getKey(),value:e.getValue()});s.addCustomData(i)});return s};w.prototype._iNextValidationTaskId=0;w.prototype._validateURL=function(e){if(C.validate(e)){return e}M.warning("You have entered invalid URL");return""};w.prototype._queueValidation=function(e){var t=this.getAsyncURLHandler();var i=++this._iNextValidationTaskId;var s={};var a=new Promise(function(a,n){s.resolve=a;s.reject=n;var o={url:e,id:i,promise:s};t(o)});a.id=i;return a};w.prototype._getTagPolicy=function(){var e=this,t;var i=html.makeTagPolicy(this._validateURL());return function s(a,n){var o,r=false;if(a.toUpperCase()==="A"){for(t=0;t<n.length;){if(n[t]==="href"){r=true;o=n[t+1];n.splice(0,2);continue}t+=2}}n=i(a,n);if(r&&typeof e.getAsyncURLHandler()==="function"){n=n||[];var l="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink sapMLnk";var g=n.indexOf("class");if(g>-1){n[g+1]+=l}else{n.unshift(l);n.unshift("class")}var u=n.indexOf("id");if(u>-1){n.splice(u+1,1);n.splice(u,1)}var c=e._queueValidation(o);n.push("href");n.push(o);n.push("target");n.push("_blank");n.push("id");n.push("sap-ui-"+e.getId()+"-link-under-validation-"+c.id);c.then(function(t){var i=jQuery(document.getElementById("sap-ui-"+e.getId()+"-link-under-validation-"+t.id));if(t.allowed){M.info("Allow link "+o)}else{M.info("Disallow link "+o)}i.removeClass("sapMMsgViewItemPendingLink");i.toggleClass("sapMMsgViewItemDisabledLink",!t.allowed);e.fireUrlValidated()}).catch(function(){M.warning("Async URL validation could not be performed.")})}return n}};w.prototype._fnHandleForwardNavigation=function(e,t){var i=e._oMessageItem,s=this.getAsyncDescriptionHandler();this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:i,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._clearDetailsPage.call(this);if(typeof s==="function"&&i.getLongtextUrl()){i.setMarkupDescription(true);var a={};var n=new Promise(function(e,t){a.resolve=e;a.reject=t});var o=function(){this._clearDetailsPage.call(this);this._detailsPage.setBusy(false);this._navigateToDetails.call(this,i,e,t,true)}.bind(this);n.then(o).catch(function(){M.warning("Async description loading could not be performed.");o()});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);s({promise:a,item:i})}else{this._navigateToDetails.call(this,i,e,t,false)}this._listPage.$().attr("aria-hidden","true")};w.prototype._fnHandleItemPress=function(e){this._fnHandleForwardNavigation(e.getParameter("listItem"),"slide")};w.prototype._navigateToDetails=function(e,t,i,s){this._setTitle(e,t);this._setDescription(e);this._setIcon(e,t);this._detailsPage.invalidate();this.fireLongtextLoaded();if(!s){this._navContainer.to(this._detailsPage,i)}};w.prototype._clearDetailsPage=function(){this._detailsPage.getContent().forEach(function(e){e.destroy()},this)};w.prototype.nav