//@ui5-bundle sap/tnt/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/InfoLabel", ["./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/Core","./InfoLabelRenderer"],function(e,t,r,a,i){"use strict";var o=e.RenderMode;var n=t.TextDirection;var p=r.extend("sap.tnt.InfoLabel",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.tnt",properties:{text:{type:"string",defaultValue:"",bindable:"bindable"},renderMode:{type:"sap.tnt.RenderMode",defaultValue:o.Loose,group:"Appearance"},colorScheme:{type:"int",group:"Misc",defaultValue:7},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:n.Inherit},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""}}},renderer:i});p.prototype.init=function(){if(a.getConfiguration().getAccessibility()&&!i._sAriaText){var e=a.getLibraryResourceBundle("sap.tnt");i._sAriaText=e.getText("INFOLABEL_DEFAULT");i._sAriaTextEmpty=e.getText("INFOLABEL_EMPTY")}};p.prototype.getFormDoNotAdjustWidth=function(){return true};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/InfoLabelRenderer", ["./library","sap/ui/core/library","sap/base/Log","sap/ui/core/IconPool"],function(e,t,n,a){"use strict";var o=e.RenderMode;var s=t.TextDirection;var i={apiVersion:2};i.render=function(e,t){var r=t.getColorScheme(),l=t.getText(),c=t.getTextDirection(),p=t.getWidth(),f=t.getTooltip(),d=t.getIcon();if(r<1||r>10){r=7;n.warning("sap.tnt.InfoLabel: colorScheme value is set to the default value of 7. Provided value should be between 1 and 10")}e.openStart("div",t).class("sapTntInfoLabel");if(t.getRenderMode()===o.Narrow){e.class("sapTntInfoLabelRenderModeNarrow")}if(t.getDisplayOnly()){e.class("sapTntInfoLabelDisplayOnly")}if(l===""){e.class("sapTntInfoLabelNoText")}if(p){e.style("width",p)}if(d){e.class("sapTntInfoLabelWithIcon")}if(f){e.attr("title",f)}e.class("backgroundColor"+r).openEnd();e.openStart("span").class("sapTntInfoLabelInner");if(c!==s.Inherit){e.attr("dir",c.toLowerCase())}e.openEnd();if(d){if(l&&d){e.icon(d,[],{title:""})}else{e.icon(d)}}e.openStart("span").class("sapTntInfoLabelText").openEnd();e.text(l);e.close("span");e.close("span");if(i._sAriaText){e.openStart("span").class("sapUiPseudoInvisibleText").openEnd();if(l){e.text(i._sAriaText)}else if(!d){e.text(i._sAriaTextEmpty)}else{if(f){e.text(f+" "+i._sAriaText)}else if(a.getIconInfo(t.getIcon()).text){e.text(a.getIconInfo(t.getIcon()).text+" "+i._sAriaText)}else{e.text(a.getIconInfo(t.getIcon()).name+" "+i._sAriaText)}}e.close("span")}e.close("div")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationList", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/Popup","sap/m/Popover","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleText","./NavigationListItem","./NavigationListRenderer","sap/m/Menu","sap/m/MenuItem","sap/base/Log"],function(jQuery,e,t,i,s,o,a,n,r,p,l,m,d,f,g){"use strict";var u=s.extend("sap.tnt.NavigationList",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"},_overflowItem:{type:"sap.tnt.NavigationListItem",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}}}},renderer:m});u.prototype.init=function(){this._itemNavigation=new r;this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);this._itemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]})};u.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();var e=this.getSelectedKey();this.setSelectedKey(e)};u.prototype.onAfterRendering=function(){this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(this._getDomRefs());if(this.getExpanded()){return}this.getDomRef().scrollTop=0;this._resizeListenerId=o.register(this.getDomRef().parentNode,this._resize.bind(this));if(t.isThemeApplied()){this._updateOverflowItems()}else{t.attachThemeChanged(this._handleThemeLoad,this)}};u.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){o.deregister(this._resizeListenerId);this._resizeListenerId=null}};u.prototype._handleThemeLoad=function(){this._updateOverflowItems();t.detachThemeChanged(this._handleThemeLoad,this)};u.prototype._resize=function(){this._updateOverflowItems()};u.prototype._updateOverflowItems=function(){var e=this.getDomRef(),t,i,s,o,a,n=0;if(this.getExpanded()||!e){return}i=e.querySelectorAll("li:not(.sapTnTNavLIOverflow)");s=e.querySelector(".sapTnTNavLIOverflow");if(!s){return}s.classList.add("sapTnTNavLIHiddenItem");i.forEach(function(e){e.classList.remove("sapTnTNavLIHiddenItem");n+=e.offsetHeight});t=window.getComputedStyle(e);a=e.offsetHeight-parseFloat(t.paddingTop)-parseFloat(t.paddingBottom);if(a>=n){return}s.classList.remove("sapTnTNavLIHiddenItem");n=s.offsetHeight;o=e.querySelector(".sapTntNavLIItemSelected");if(o){o=o.parentNode;n+=o.offsetHeight;t=window.getComputedStyle(o);n+=parseFloat(t.marginTop)+parseFloat(t.marginBottom)}i.forEach(function(e){if(e===o){return}n+=e.offsetHeight;t=window.getComputedStyle(e);n+=parseFloat(t.marginTop)+parseFloat(t.marginBottom);if(n>=a){e.classList.add("sapTnTNavLIHiddenItem")}})};u.prototype._getOverflowItem=function(){var e=this.getAggregation("_overflowItem");if(!e){e=new l({text:t.getLibraryResourceBundle("sap.tnt").getText("NAVIGATION_LIST_NAVIGATION_OVERFLOW"),icon:"sap-icon://overflow",selectable:false,select:this._overflowPress.bind(this)});e._isOverflow=true;this.setAggregation("_overflowItem",e)}return e};u.prototype._overflowPress=function(e){var t=e.getSource();t.getDomRef().querySelector(".sapTntNavLIItem").classList.add("sapTntNavLIActive");var i=this._createOverflowMenu(t);i.openBy(t,false,a.Dock.EndCenter)};u.prototype._createOverflowMenu=function(e){var t=new d({items:this._createNavigationMenuItems(),itemSelected:function(e){var i=e.getParameter("item"),s;this._selectItem({item:i._navItem});s=this.getDomRef().querySelector(".sapTntNavLIItemSelected");if(s){s.parentNode.focus()}t.close();t.destroy()}.bind(this),closed:function(){e.getDomRef().querySelector(".sapTntNavLIItem").classList.remove("sapTntNavLIActive")}});t.addStyleClass("sapTntNavLIMenu");t._handleMenuItemSelect=function(e){var t=e.getParameter("item"),i;if(!t){return}i=this._findMenuItemByUnfdMenuItem(t);if(i){this.fireItemSelected({item:i})}}.bind(t);this.addDependent(t);return t};u.prototype._createNavigationMenuItems=function(){var e=this.getItems(),t=[];e.forEach(function(e){if(!e.getVisible()||!e.getDomRef().classList.contains("sapTnTNavLIHiddenItem")){return}var i=new f({icon:e.getIcon(),text:e.getText(),enabled:e.getEnabled()});i._navItem=e;e.getItems().forEach(function(e){var t=new f({icon:e.getIcon(),text:e.getText(),enabled:e.getEnabled()});t._navItem=e;i.addItem(t)});t.push(i)});return t};u.prototype._updateNavItems=function(){this._itemNavigation.setItemDomRefs(this._getDomRefs())};u.prototype._getDomRefs=function(){var e=[],t=this.getItems(),i=this.getExpanded(),s=this.getAggregation("_overflowItem").getDomRef();for(var o=0;o<t.length;o++){if(i){jQuery.merge(e,t[o]._getDomRefs())}else{e.push(t[o].getDomRef())}}if(!i&&s){e.push(s)}return e};u.prototype._adaptPopoverPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=8;this._offsets=["0 -8","8 0","0 8","-8 0"];this._myPositions=["center bottom","begin top","center top","end top"];this._atPositions=["center top","end top","center bottom","begin top"]}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin top","begin top","end top"];this._atPositions=["begin top","end top","begin bottom","begin top"]}};u.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy()}if(this._popover){this._popover.destroy()}this._deregisterResizeHandler()};u.prototype._selectItem=function(e){this.fireItemSelect(e);var t=e.item;this.setSelectedItem(t,true)};u.prototype._findItemByKey=function(e){var t=this.getItems(),i,s,o,a,n;for(a=0;a<t.length;a++){i=t[a];if(i._getUniqueKey()===e){return i}s=i.getItems();for(n=0;n<s.length;n++){o=s[n];if(o._getUniqueKey()===e){return o}}}return null};u.prototype.setSelectedKey=function(e){var t=this._findItemByKey(e);this.setSelectedItem(t,true);this.setProperty("selectedKey",e,true);return this};u.prototype.getSelectedItem=function(){var e=this.getAssociation("selectedItem");if(!e){return null}return sap.ui.getCore().byId(e)};u.prototype.setSelectedItem=function(e){var t,s,o;if(this._selectedItem){this._selectedItem._unselect()}if(!e){this._selectedItem=null}o=e instanceof i&&e.isA("sap.tnt.NavigationListItem");if(typeof e!=="string"&&!o){g.warning("Type of selectedItem association should be string or instance of sap.tnt.NavigationListItem. New value was not set.");this.setAssociation("selectedItem",null,true);this._updateOverflowItems();return this}this.setAssociation("selectedItem",e,true);if(typeof e==="string"){t=sap.ui.getCore().byId(e)}else{t=e}s=t?t._getUniqueKey():"";this.setProperty("selectedKey",s,true);if(t){t._select();this._selectedItem=t;this._updateOverflowItems();return this}g.warning("Type of selectedItem association should be a valid NavigationListItem object or ID. New value was not set.");return this};u.prototype._openPopover=function(e,t){var i=this;var s=e.$().find(".sapTntNavLIItem").addClass("sapTntNavLIActive");var o=t.getSelectedItem();if(o&&t.isGroupSelected){o=null}var a=this._popover=new n({showHeader:false,horizontalScrolling:false,verticalScrolling:true,initialFocus:o,afterClose:function(){if(i._popover){i._popover.destroy();i._popover=null;s.removeClass("sapTntNavLIActive")}},content:t,ariaLabelledBy:p.getStaticId("sap.tnt","NAVIGATION_LIST_DIALOG_TITLE")}).addStyleClass("sapContrast sapContrastPlus sapTntNavLIPopover");a._adaptPositionParams=this._adaptPopoverPositionParams;a.openBy(e)};u.prototype._closePopover=function(){if(this._popover){this._popover.close()}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListItem", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Core","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/core/InvisibleText","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/events/KeyCodes","sap/ui/core/library","sap/ui/util/openWindow","sap/ui/util/defaultLinkTypes","sap/ui/dom/jquery/Aria"],function(jQuery,t,e,i,s,a,n,r,o,p,l,c){"use strict";var d=p.TextAlign;var u=p.TextDirection;var g=i.extend("sap.tnt.NavigationListItem",{metadata:{library:"sap.tnt",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},selectable:{type:"boolean",group:"Behavior",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"},_expandIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.ui.core.Item"}}}},designtime:"sap/tnt/designtime/NavigationListItem.designtime"}});g.expandIcon="sap-icon://navigation-right-arrow";g.collapseIcon="sap-icon://navigation-down-arrow";g.selectionIndicatorIcon="sap-icon://circle-task-2";g._getInvisibleText=function(){if(!this._invisibleText){this._invisibleText=(new a).toStatic()}return this._invisibleText};g.prototype.init=function(){this._resourceBundle=e.getLibraryResourceBundle("sap.ui.core");this._resourceBundleMLib=e.getLibraryResourceBundle("sap.m");this._resourceBundleTNTLib=e.getLibraryResourceBundle("sap.tnt")};g.prototype._getUniqueKey=function(){var t=this.getKey();if(t){return t}return this.getId()};g.prototype._getExpandIconControl=function(){var t=this.getAggregation("_expandIconControl");if(!t){var e=this.getExpanded();t=new s({src:e?g.collapseIcon:g.expandIcon,visible:this.getItems().length>0&&this.getHasExpander(),useIconTooltip:false,tooltip:this._getExpandIconTooltip(!e)}).addStyleClass("sapTntNavLIExpandIcon");this.setAggregation("_expandIconControl",t,true)}return t};g.prototype._getExpandIconTooltip=function(t){if(!this.getEnabled()){return""}var e=t?"Icon.expand":"Icon.collapse";return this._resourceBundle.getText(e)};g.prototype.getLevel=function(){var t=0;var e=this.getParent();if(e.getMetadata().getName()=="sap.tnt.NavigationListItem"){return e.getLevel()+1}return t};g.prototype.getNavigationList=function(){var t=this.getParent();while(t&&t.getMetadata().getName()!="sap.tnt.NavigationList"){t=t.getParent()}return t};g.prototype.getFocusDomRef=function(){var t=this.getDomRef("focusable");if(t){return t}return this.getDomRef()};g.prototype._isListExpanded=function(){var t=this.getNavigationList();return t.getExpanded()||t.hasStyleClass("sapTntNavLIPopup")};g.prototype.createPopupList=function(){var t=[],e=this.getNavigationList(),i=e.getSelectedItem(),s,a,n,r=this.getItems();for(var o=0;o<r.length;o++){a=r[o];if(a.getVisible()){n=new g({key:a.getId(),text:a.getText(),textDirection:a.getTextDirection(),enabled:a.getEnabled(),selectable:a.getSelectable(),href:a.getHref(),target:a.getTarget(),tooltip:a.getTooltip()});t.push(n);if(i===a){s=n}}}var p=new g({expanded:true,hasExpander:false,selectable:this.getSelectable(),key:this.getId(),text:this.getText(),enabled:this.getEnabled(),textDirection:this.getTextDirection(),href:this.getHref(),target:this.getTarget(),tooltip:this.getTooltip(),items:t});var l=e.getMetadata().getClass().prototype.constructor;var c=new l({itemSelect:this.onPopupItemSelect.bind(this),items:[p]}).addStyleClass("sapTntNavLIPopup");if(i==this){s=p;c.isGroupSelected=true}c.setSelectedItem(s);return c};g.prototype.onPopupItemSelect=function(t){var i=t.getParameter("item");i=e.byId(i.getKey());i._selectItem(t)};g.prototype._selectItem=function(t){var e={item:this},i=this.getNavigationList();this.fireSelect(e);if(this.getSelectable()){i._selectItem(e)}this._openUrl()};g.prototype._openUrl=function(){var t=this.getHref();if(t){l(t,this.getTarget()||"_self")}};g.prototype.onkeydown=function(t){if(t.isMarked("subItem")){return}t.setMarked("subItem");if(this.getLevel()>0){return}var i=e.getConfiguration().getRTL();if(t.shiftKey&&t.which==189||t.which==o.NUMPAD_MINUS||t.which==o.ARROW_RIGHT&&i||t.which==o.ARROW_LEFT&&!i){if(this.collapse()){t.preventDefault();t.stopPropagation()}}else if(t.which==o.NUMPAD_PLUS||t.shiftKey&&t.which==o.PLUS||t.which==o.ARROW_LEFT&&i||t.which==o.ARROW_RIGHT&&!i){if(this.expand()){t.preventDefault();t.stopPropagation()}}};g.prototype.expand=function(t){if(this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()>0){return}this.setProperty("expanded",true,true);this.$().find(".sapTntNavLIGroup").attr("aria-expanded",true);var e=this._getExpandIconControl();e.setSrc(g.collapseIcon);e.setTooltip(this._getExpandIconTooltip(false));var i=this.$().find(".sapTntNavLIGroupItems");var s=this.getDomRef();i.stop(true,true).slideDown(t||"fast",function(){s.querySelector(".sapTntNavLIGroupItems").classList.toggle("sapTntNavLIHiddenGroupItems")});this.getNavigationList()._updateNavItems();return true};g.prototype.collapse=function(t){if(!this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()>0){return}this.setProperty("expanded",false,true);this.$().find(".sapTntNavLIGroup").attr("aria-expanded",false);var e=this._getExpandIconControl();e.setSrc(g.expandIcon);e.setTooltip(this._getExpandIconTooltip(true));var i=this.$().find(".sapTntNavLIGroupItems");var s=this.getDomRef();i.stop(true,true).slideUp(t||"fast",function(){s.querySelector(".sapTntNavLIGroupItems").classList.toggle("sapTntNavLIHiddenGroupItems")});this.getNavigationList()._updateNavItems();return true};g.prototype.ontap=function(t){var e=this.getNavigationList(),i=jQuery(t.target).closest(".sapUiIcon"),s=this.getLevel(),a,n;if(t.isMarked("subItem")){return}t.setMarked("subItem");if(!this.getEnabled()){return}if(s===1){a=this.getParent();if(this.getEnabled()&&a.getEnabled()){this._selectItem(t)}return}if(e.getExpanded()||!this.getItems().length){if(!i.length||!i.hasClass("sapTntNavLIExpandIcon")){this._selectItem(t);return}t.preventDefault();if(this.getExpanded()){this.collapse()}else{this.expand()}}else{n=this.createPopupList();e._openPopover(this,n)}};g.prototype.onsapenter=g.prototype.ontap;g.prototype.onsapspace=g.prototype.ontap;g.prototype.render=function(t,e){if(!this.getVisible()){return}if(this.getLevel()===0){this.renderFirstLevelNavItem(t,e)}else{this.renderSecondLevelNavItem(t,e)}};g.prototype.renderGroupItem=function(t,e){var i=this._isListExpanded(),s=this.getExpanded(),a=this._getVisibleItems(this),n=a.length,r=this.getText(),o=this.getHref(),p=this.getTarget(),l=this.getSelectable(),d,u={level:"1",role:"treeitem",roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE_ITEM")},h=this.getItems().length>0&&this.getHasExpander();if(i){t.openStart("div",this.getId()+"-focusable")}else{t.openStart("div")}t.class("sapTntNavLIItem");t.class("sapTntNavLIGroup");if(l){if(e._selectedItem===this){u.selected=true;t.class("sapTntNavLIItemSelected")}else{u.selected=false}}if(!this.getEnabled()){t.class("sapTntNavLIItemDisabled")}if(!i&&this._hasSelectedChild(e._selectedItem)){t.class("sapTntNavLIItemSelected")}if(h){t.class("sapTntNavLIItemWithExpander")}if(i){d=this.getTooltip_AsString()||r;if(d){t.attr("title",d)}if(this.getEnabled()){t.attr("tabindex","-1")}if(n>0){u.expanded=s}t.accessibilityState(u)}t.openEnd();t.openStart("a",this.getId()+"-a");t.attr("tabindex","-1");t.accessibilityState({role:"link"});if(!i){t.accessibilityState({hidden:true})}if(o){t.attr("href",o)}if(p){t.attr("target",p);t.attr("rel",c("",p))}t.openEnd();this._renderIcon(t);this._renderText(t);if(e.getExpanded()){var I=this._getExpandIconControl();I.setVisible(h);I.setSrc(this.getExpanded()?g.collapseIcon:g.expandIcon);I.setTooltip(this._getExpandIconTooltip(!this.getExpanded()));t.icon(g.selectionIndicatorIcon,["sapTntNavLISelectionIndicator"]);t.renderControl(I)}t.close("a");t.close("div")};g.prototype.renderFirstLevelNavItem=function(t,e){var i,s=this._getVisibleItems(this),a=s.length,n=this.getExpanded(),r=this._isListExpanded(),o,p=this.getSelectable(),l={role:p?"menuitemradio":"menuitem",roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUITEM")};t.openStart("li",this);if(!r){if(this.getEnabled()){t.attr("tabindex","-1")}o=this.getTooltip_AsString()||this.getText();if(o){t.attr("title",o)}if(a>0){if(this.getEnabled()){t.class("sapTnTNavLINotExpandedTriangle")}l.haspopup="tree"}if(this._isOverflow){t.class("sapTnTNavLIOverflow");t.class("sapTnTNavLIHiddenItem");t.attr("tabindex","-1");l.haspopup="menu"}if(p){l.checked=e._selectedItem===this}t.accessibilityState(l)}else{t.attr("aria-hidden","true")}t.openEnd();this.renderGroupItem(t,e);if(r){t.openStart("ul");t.attr("aria-hidden","true");t.attr("role","group");t.class("sapTntNavLIGroupItems");if(!n){t.class("sapTntNavLIHiddenGroupItems")}t.openEnd();for(var c=0;c<a;c++){i=s[c];i.render(t,e,c,a)}t.close("ul")}t.close("li")};g.prototype.renderSecondLevelNavItem=function(t,e){var i=this.getParent(),s=this.getHref(),a=this.getTarget(),n=this.getSelectable(),r={role:"treeitem",level:"2",roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE_ITEM")};t.openStart("li",this);t.class("sapTntNavLIItem");t.class("sapTntNavLIGroupItem");if(n){if(e._selectedItem===this){r.selected=true;t.class("sapTntNavLIItemSelected")}else{r.selected=false}}if(!this.getEnabled()||!i.getEnabled()){t.class("sapTntNavLIItemDisabled")}else{t.attr("tabindex","-1")}var o=this.getText();var p=this.getTooltip_AsString()||o;if(p){t.attr("title",p)}t.accessibilityState(r);t.openEnd();t.openStart("a",this.getId()+"-a");t.attr("tabindex","-1");t.accessibilityState({role:"link"});if(s){t.attr("href",s)}if(a){t.attr("target",a);t.attr("rel",c("",a))}t.openEnd();this._renderText(t);t.icon("sap-icon://circle-task-2",["sapTntNavLISelectionIndicator"]);t.close("a");t.close("li")};g.prototype._renderIcon=function(t){var e=this.getIcon(),i=r.getIconInfo(e);if(e){t.openStart("span");t.class("sapUiIcon");t.class("sapTntNavLIGroupIcon");t.attr("aria-hidden",true);if(i&&!i.suppressMirroring){t.class("sapUiIconMirrorInRTL")}if(i){t.attr("data-sap-ui-icon-content",i.content);t.style("font-family","'"+i.fontFamily+"'")}t.openEnd();t.close("span")}else{t.openStart("span");t.class("sapUiIcon");t.class("sapTntNavLIGroupIcon");t.attr("aria-hidden",true);t.openEnd();t.close("span")}};g.prototype._renderText=function(t){t.openStart("span");t.class("sapMText");t.class("sapTntNavLIText");t.class("sapMTextNoWrap");var e=this.getTextDirection();if(e!==u.Inherit){t.attr("dir",e.toLowerCase())}var i=n.getTextAlign(d.Begin,e);if(i){t.style("text-align",i)}t.openEnd();t.text(this.getText());t.close("span")};g.prototype._unselect=function(){var t=this.$(),e=this.getNavigationList();if(!e){return}if(this._isListExpanded()){if(this.getLevel()===0){t=t.find(".sapTntNavLIGroup")}t.attr("aria-selected",false)}else{t.attr("aria-checked",false);t=t.find(".sapTntNavLIGroup");if(this.getParent().isA("sap.tnt.NavigationListItem")){this.getParent().$().find(".sapTntNavLIGroup").removeClass("sapTntNavLIItemSelected")}}t.removeClass("sapTntNavLIItemSelected")};g.prototype._select=function(){var t=this.$(),e=this.getNavigationList();if(!e){return}if(this._isListExpanded()){if(this.getLevel()===0){t=t.find(".sapTntNavLIGroup")}t.attr("aria-selected",true)}else{t.attr("aria-checked",true);t=t.find(".sapTntNavLIGroup");if(this.getParent().isA("sap.tnt.NavigationListItem")){this.getParent().$().find(".sapTntNavLIGroup").addClass("sapTntNavLIItemSelected sapTntNavLIItemNoHoverEffect")}e._closePopover()}t.addClass("sapTntNavLIItemSelected")};g.prototype._getDomRefs=function(){var t=[];if(!this.getEnabled()){return t}var e=this.$();t.push(e.find(".sapTntNavLIGroup")[0]);if(this.getExpanded()){var i=e.find(".sapTntNavLIGroupItem");for(var s=0;s<i.length;s++){t.push(i[s])}}return t};g.prototype._getVisibleItems=function(t){var e=[];var i=t.getItems();var s;for(var a=0;a<i.length;a++){s=i[a];if(s.getVisible()){e.push(s)}}return e};g.prototype.onclick=function(t){if(this.getHref()){t.preventDefault()}};g.prototype.onfocusout=function(){var t=this.getDomRef()&&this.getDomRef().querySelector(".sapTntNavLIGroup");if(t){t.classList.remove("sapTntNavLIItemNoHoverEffect")}};g.prototype.onmouseover=g.prototype.onfocusout;g.prototype.onmousedown=function(t){if(this.getHref()){t.preventDefault()}};g.prototype.onfocusin=function(t){if(t.srcControl!==this){return}this._updateAccessibilityText()};g.prototype._updateAccessibilityText=function(){var t=this.getNavigationList(),e=g._getInvisibleText();if(!t.getExpanded()){e.setText("");return}var i=this._resourceBundleMLib,s=this._getAccessibilityItem(),a=t._selectedItem===this?i.getText("LIST_ITEM_SELECTED"):"",n=i.getText("ACC_CTR_TYPE_TREEITEM"),r=this._getAccessibilityPosition(),o=i.getText("LIST_ITEM_POSITION",[r.index,r.size]),p=this.getText(),l=n+" "+a+" "+p+" "+o;e.setText(l);s.addAriaLabelledBy(e.getId())};g.prototype._getAccessibilityPosition=function(){var t=this.getParent(),e=this._getVisibleItems(t),i=e.length,s=e.indexOf(this)+1;return{index:s,size:i}};g.prototype._getAccessibilityItem=function(){var t=this.$(),e=this.getNavigationList(),i=e.getExpanded();if(i&&this.getLevel()===0){t=t.find(".sapTntNavLIGroup")}return t};g.prototype._hasSelectedChild=function(t){var e=this.getItems(),i;for(i=0;i<e.length;i++){if(e[i]===t){return true}}return false};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/NavigationListRenderer", ["sap/ui/core/Core"],function(e){"use strict";var t={apiVersion:2};var a=e.getLibraryResourceBundle("sap.tnt");t.render=function(e,t){var r,i=t.getItems(),n=t.getExpanded(),s=[],o=false,l=t._getOverflowItem();i.forEach(function(e){if(e.getVisible()){s.push(e);if(e.getIcon()){o=true}}});e.openStart("ul",t);var I=t.getWidth();if(I&&n){e.style("width",I)}e.class("sapTntNavLI");if(!n){e.class("sapTntNavLICollapsed")}if(!o){e.class("sapTntNavLINoIcons")}r=!n&&!t.hasStyleClass("sapTntNavLIPopup")?"menubar":"tree";e.attr("role",r);if(r==="menubar"){e.attr("aria-orientation","vertical");e.attr("aria-roledescription",a.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUBAR"))}else{e.attr("aria-roledescription",a.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE"))}e.openEnd();s.forEach(function(a){a.render(e,t)});if(!n){l.render(e,t)}e.close("ul")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/SideNavigation", ["./library","sap/ui/core/Control","sap/ui/core/theming/Parameters","sap/ui/core/Icon","./SideNavigationRenderer"],function(e,t,i,a,s){"use strict";var r=t.extend("sap.tnt.SideNavigation",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data"},ariaLabel:{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"item",aggregations:{item:{type:"sap.tnt.NavigationList",multiple:false,bindable:"bindable"},fixedItem:{type:"sap.tnt.NavigationList",multiple:false},footer:{type:"sap.tnt.NavigationList",multiple:false}},associations:{selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}}}},renderer:s});r.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true)};r.prototype.setAggregation=function(e,i){if(i&&i.attachItemSelect){i.attachItemSelect(this._itemSelectionHandler.bind(this))}return t.prototype.setAggregation.apply(this,arguments)};r.prototype.setExpanded=function(e){if(this.getExpanded()===e){return this}var t=this,i=t.getAggregation("item"),a=t.getAggregation("fixedItem");this.setProperty("expanded",e);if(i){i.setExpanded(e)}if(a){a.setExpanded(e)}return this};r.prototype.onBeforeRendering=function(){var e=this.getSelectedItem(),t=this.getSelectedKey();if(t){this.setSelectedKey(t)}else if(e){this.setSelectedItem(e)}};r.prototype.setSelectedKey=function(e){var t,i=this.getItem(),a=this.getFixedItem();if(e&&i){t=i._findItemByKey(e);if(!t&&a){t=a._findItemByKey(e)}}if(t){this.setSelectedItem(t)}this.setProperty("selectedKey",e,true);return this};r.prototype.setSelectedItem=function(e){var i=this.getAggregation("item");var a=this.getAggregation("fixedItem");var s;var r;if(!e){if(i){i.setSelectedItem(null)}if(a){a.setSelectedItem(null)}}if(typeof e==="string"){s=sap.ui.getCore().byId(e)}else{s=e}r=s?s._getUniqueKey():"";this.setProperty("selectedKey",r,true);var n=s&&s.getNavigationList&&s.getNavigationList()===i;var o=s&&s.getNavigationList&&s.getNavigationList()===a;if(n){i.setSelectedItem(s);if(a){a.setSelectedKey(null)}}if(o){a.setSelectedItem(s);if(i){i.setSelectedKey(null)}}return t.prototype.setAssociation.call(this,"selectedItem",s,true)};r.prototype.exit=function(){this._mThemeParams=null};r.prototype._itemSelectionHandler=function(e){var t=e.getParameter("item");this.setSelectedItem(t);this.fireItemSelect({item:t})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/SideNavigationRenderer", ["sap/ui/core/Core"],function(e){"use strict";var t={apiVersion:2};var a=e.getLibraryResourceBundle("sap.tnt");t.render=function(e,t){this.startSideNavigation(e,t);this.renderItem(e,t);this.renderFixedItem(e,t);this.renderFooter(e,t);this.endSideNavigation(e,t)};t.startSideNavigation=function(e,t){var i=t.getAggregation("item");var n=t.getAggregation("fixedItem");var r=t.getExpanded();var o=t.getAriaLabel();e.openStart("div",t);const d=t.getWidth();if(d&&r){e.style("width",d)}e.attr("role","navigation");e.attr("aria-roledescription",a.getText("SIDENAVIGATION_ROLE_DESCRIPTION"));if(o){e.accessibilityState(t,{label:o})}e.class("sapTntSideNavigation");e.class("sapContrast");e.class("sapContrastPlus");if(!r){e.class("sapTntSideNavigationNotExpanded");e.class("sapTntSideNavigationNotExpandedWidth")}if(!r&&i){i.setExpanded(false)}if(!r&&n){n.setExpanded(false)}e.openEnd()};t.endSideNavigation=function(e,t){e.close("div")};t.renderItem=function(e,t){var a=t.getAggregation("item");e.openStart("div",t.getId()+"-Flexible");e.attr("tabindex","-1");e.class("sapTntSideNavigationFlexible");e.openEnd();e.openStart("div",t.getId()+"-Flexible-Content");e.class("sapTntSideNavigationFlexibleContent");e.openEnd();e.renderControl(a);e.close("div");e.close("div")};t.renderFixedItem=function(e,t){var i=t.getAggregation("fixedItem");if(i===null){return}if(i.getExpanded()===false){i.setExpanded(false)}e.openStart("div");e.attr("role","separator");e.attr("aria-roledescription",a.getText("SIDENAVIGATION_ROLE_DESCRIPTION_SEPARATOR"));e.attr("aria-orientation","horizontal");e.class("sapTntSideNavigationSeparator");e.openEnd();e.close("div");e.openStart("div");e.class("sapTntSideNavigationFixed");e.openEnd();e.renderControl(i);e.close("div")};t.renderFooter=function(e,t){if(t.getAggregation("footer")){e.openStart("footer");e.class("sapTntSideNavigationFooter");e.openEnd();e.renderControl(t.getAggregation("footer"));e.close("footer")}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeader", ["./library","sap/m/OverflowToolbar","sap/m/OverflowToolbarAssociativePopover","./ToolHeaderRenderer","sap/ui/Device","sap/m/library"],function(e,t,o,a,r,s){"use strict";var p=s.PlacementType;var n=t.extend("sap.tnt.ToolHeader",{metadata:{interfaces:["sap.tnt.IToolHeader"],library:"sap.tnt",properties:{},aggregations:{}},renderer:a});n.prototype.init=function(){t.prototype.init.apply(this,arguments);this.addStyleClass("sapTntToolHeader sapContrast sapContrastPlus")};n.prototype._getPopover=function(){var e=this.getAggregation("_popover");if(!e){e=new o(this.getId()+"-popover",{showHeader:false,showArrow:r.system.phone?false:true,modal:false,horizontalScrolling:r.system.phone?false:true,contentWidth:r.system.phone?"100%":"auto"}).addStyleClass("sapTntToolHeaderPopover sapContrast sapContrastPlus");if(r.system.phone){e.attachBeforeOpen(this._shiftPopupShadow,this);e.attachAfterOpen(this._shiftPopupShadow,this)}e.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",e,true)}return e};n.prototype._getBestActionSheetPlacement=function(){return p.Bottom};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeaderRenderer", ["sap/m/library","sap/ui/core/Renderer","sap/m/OverflowToolbarRenderer","sap/m/BarInPageEnabler"],function(e,r,t,n){"use strict";var o=e.OverflowToolbarPriority;var i=r.extend(t);i.apiVersion=2;i.renderBarContent=function(e,r){var t=false,i;if(r.getActive()){e.renderControl(r._getActiveButton())}r._getVisibleContent().forEach(function(l){n.addChildClassTo(l,r);i=l.isA("sap.tnt.ToolHeaderUtilitySeparator");if(i&&!t){this._renderOverflowButton(e,r);t=true}if(r._getControlPriority(l)!==o.AlwaysOverflow){e.renderControl(l)}}.bind(this));if(t){return}this._renderOverflowButton(e,r)};i._renderOverflowButton=function(e,r){var n=r.getContent().some(function(e){return e.getVisible()&&r._getControlPriority(e)===o.AlwaysOverflow}),i=r.getContent().some(function(e){return e.getVisible()});if(n||r._getOverflowButtonNeeded()){t.renderOverflowButton(e,r)}if(i){t.renderOverflowButtonClone(e,r)}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolHeaderUtilitySeparator", ["./library","sap/ui/core/Control"],function(r,e){"use strict";var t=e.extend("sap.tnt.ToolHeaderUtilitySeparator",{metadata:{library:"sap.tnt",properties:{}},renderer:{apiVersion:2,render:function(){}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolPage", ["./library","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","./ToolPageRenderer"],function(e,t,i,n,r,s,o){"use strict";var a=t.PageBackgroundDesign;var d=n.extend("sap.tnt.ToolPage",{metadata:{library:"sap.tnt",properties:{sideExpanded:{type:"boolean",group:"Misc",defaultValue:true},contentBackgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:a.Standard}},aggregations:{header:{type:"sap.tnt.IToolHeader",multiple:false},subHeader:{type:"sap.tnt.IToolHeader",multiple:false},sideContent:{type:"sap.tnt.SideNavigation",multiple:false},mainContents:{type:"sap.ui.core.Control",multiple:true,singularName:"mainContent"}},events:{}},renderer:o});d.prototype.init=function(){this._oContentObserver=new i(this._onContentChange.bind(this));this._oContentObserver.observe(this,{aggregations:["subHeader","sideContent"]});this._oContentVisibilityObserver=new i(this._onContentVisibilityChange.bind(this));this._deregisterControl()};d.prototype.exit=function(){this._deregisterControl();if(this._oContentObserver){this._oContentObserver.disconnect();this._oContentObserver=null}if(this._oContentVisibilityObserver){this._oContentVisibilityObserver.disconnect();this._oContentVisibilityObserver=null}};d.prototype.onBeforeRendering=function(){this._deregisterControl()};d.prototype.onAfterRendering=function(){this._ResizeHandler=s.register(this.getDomRef(),this._mediaQueryHandler.bind(this));this._updateLastMediaQuery()};d.prototype.toggleSideContentMode=function(){return this.setSideExpanded(!this.getSideExpanded())};d.prototype.setSideExpanded=function(e){this.setProperty("sideExpanded",e,true);var t=this.getSideContent();if(t){var i=r.system.phone?true:e;t.setExpanded(i)}else{return this}var n=this.getDomRef();if(!n){return this}if(e){n.querySelector(".sapTntToolPageContentWrapper").classList.remove("sapTntToolPageAsideCollapsed")}else{n.querySelector(".sapTntToolPageContentWrapper").classList.add("sapTntToolPageAsideCollapsed")}return this};d.prototype._deregisterControl=function(){if(this._ResizeHandler){s.deregister(this._ResizeHandler);this._ResizeHandler=null}};d.prototype._mediaQueryHandler=function(){var e=this.getSideContent();if(e===null){return}this._currentMediaQuery=this._getDeviceAsString();if(this._getLastMediaQuery()===this._currentMediaQuery){return}switch(this._currentMediaQuery){case"Combi":this.setSideExpanded(true);break;case"Tablet":this.setSideExpanded(false);break;case"Phone":this.setSideExpanded(false);e.setExpanded(true);break;default:this.setSideExpanded(true)}this._updateLastMediaQuery()};d.prototype._getLastMediaQuery=function(){return this._lastMediaQuery};d.prototype._updateLastMediaQuery=function(){this._lastMediaQuery=this._getDeviceAsString();return this};d.prototype._getDeviceAsString=function(){if(r.system.combi){return"Combi"}if(r.system.phone){return"Phone"}if(r.system.tablet){return"Tablet"}return"Desktop"};d.prototype._onContentChange=function(e){switch(e.mutation){case"insert":this._oContentVisibilityObserver.observe(e.child,{properties:["visible"]});break;case"remove":this._oContentVisibilityObserver.unobserve(e.child,{properties:["visible"]});break}};d.prototype._onContentVisibilityChange=function(e){this.invalidate()};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/ToolPageRenderer", ["sap/ui/Device"],function(e){"use strict";var n={apiVersion:2};n.render=function(e,n){e.openStart("div",n).class("sapTntToolPage").openEnd();this.renderHeader(e,n);this.renderContent(e,n);e.close("div")};n.renderHeader=function(e,n){var t=n.getHeader(),a=n.getSubHeader();if(t||a){e.openStart("div").class("sapTntToolPageHeaderWrapper");if(t&&a&&a.getVisible()){e.class("sapTntToolPageHeaderWithSubHeaderWrapper")}e.openEnd();e.openStart("header").openEnd()}if(t){e.openStart("div",n.getId()+"-header").class("sapTntToolPageHeader").openEnd();e.renderControl(t);e.close("div")}if(a&&a.getVisible()){e.openStart("div",n.getId()+"-subHeader").class("sapTntToolPageHeader").openEnd();e.renderControl(a);e.close("div")}if(t||a){e.close("header");e.close("div")}};n.renderContent=function(n,t){n.openStart("div").class("sapTntToolPageContentWrapper");if(!e.system.desktop||!t.getSideExpanded()){n.class("sapTntToolPageAsideCollapsed")}n.openEnd();this.renderAsideContent(n,t);this.renderMainContent(n,t);n.close("div")};n.renderAsideContent=function(n,t){var a=t.getSideContent();if(!a||!a.getVisible()){return}n.openStart("aside",t.getId()+"-aside").class("sapTntToolPageAside").openEnd();n.openStart("div").class("sapTntToolPageAsideContent").openEnd();var o=t.getSideExpanded();if(a&&a.getExpanded()!==o){a.setExpanded(o)}if(!e.system.desktop){t.setSideExpanded(false)}n.renderControl(a);n.close("div");n.close("aside")};n.renderMainContent=function(e,n){var t=n.getMainContents();if(!t){return}e.openStart("div",n.getId()+"-main").class("sapTntToolPageMain").class("sapTntToolPageMainBackground-"+n.getContentBackgroundDesign()).openEnd();e.openStart("div").class("sapTntToolPageMainContent").openEnd();e.openStart("div").class("sapTntToolPageMainContentWrapper").openEnd();t.forEach(e.renderControl,e);e.close("div");e.close("div");e.close("div")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/flexibility/NavigationListItem.flexibility", ["sap/ui/fl/changeHandler/BaseRename"],function(e){"use strict";return{hideControl:"default",rename:e.createRenameChangeHandler({propertyName:"text",translationTextType:"XBUT"}),unhideControl:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/tnt/library", ["sap/ui/core/library","sap/m/library"],function(){"use strict";var t=sap.ui.getCore().initLibrary({name:"sap.tnt",version:"1.120.22",dependencies:["sap.ui.core","sap.m"],designtime:"sap/tnt/designtime/library.designtime",types:["sap.tnt.RenderMode"],interfaces:["sap.tnt.IToolHeader"],controls:["sap.tnt.NavigationList","sap.tnt.ToolHeaderUtilitySeparator","sap.tnt.ToolHeader","sap.tnt.SideNavigation","sap.tnt.ToolPage","sap.tnt.InfoLabel"],elements:["sap.tnt.NavigationListItem"],extensions:{flChangeHandlers:{"sap.tnt.NavigationListItem":"sap/tnt/flexibility/NavigationListItem"}}});t.RenderMode={Narrow:"Narrow",Loose:"Loose"};return t});
sap.ui.require.preload({
	"sap/tnt/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.tnt","type":"library","embeds":[],"applicationVersion":{"version":"1.120.22"},"title":"SAPUI5 library with responsive controls.","description":"SAPUI5 library with responsive controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.22"},"sap.m":{"minVersion":"1.120.22"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.tnt.NavigationList","sap.tnt.ToolHeaderUtilitySeparator","sap.tnt.ToolHeader","sap.tnt.SideNavigation","sap.tnt.ToolPage","sap.tnt.InfoLabel"],"elements":["sap.tnt.NavigationListItem"],"types":["sap.tnt.RenderMode"],"interfaces":["sap.tnt.IToolHeader"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
