/*!
 # * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/delegate/ItemNavigation","./ToolbarRenderer","sap/base/assert","sap/ui/dom/containsOrEquals","sap/ui/core/ResizeHandler","sap/ui/core/Element","sap/ui/events/KeyCodes","sap/ui/core/Configuration"],function(jQuery,e,t,i,o,s,n,r,a,h,p,l){"use strict";var u=e.ToolbarDesign;var f=t.extend("sap.ui.commons.Toolbar",{metadata:{interfaces:["sap.ui.core.Toolbar"],library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},design:{type:"sap.ui.commons.ToolbarDesign",group:"Appearance",defaultValue:u.Flat},standalone:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"item"},rightItems:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"rightItem"}}}});f.prototype.init=function(){this.bOpen=false;this.oDomRef=null;this.oInnerRef=null;this.oOverflowDomRef=null;this._oOverflowPopup=null;this.sOriginalStylePropertyWidth=null;this.bHasRightItems=false;this._bRendering=false;this.bRtl=l.getRTL();this._detectVisibleItemCountChangeTimer=null;var e=this;this.oItemDelegate={onAfterRendering:jQuery.proxy(e._itemRendered,e)};this.data("sap-ui-fastnavgroup","true",true)};f.prototype.onBeforeRendering=function(){s.emptyOverflowPopup(this,false);this.cleanup();this.$("mn").off("keydown",this._handleKeyDown);this.bFirstTime=true;this._bRendering=true};f.prototype.onAfterRendering=function(){this._bRendering=false;this.oDomRef=this.getDomRef();this.oInnerRef=this.oDomRef.firstChild.firstChild;jQuery(this.oInnerRef).css("visibility","visible");this.oOverflowDomRef=this.getDomRef("mn");if(!this.oItemNavigation){this.oItemNavigation=new o;this.addDelegate(this.oItemNavigation)}this.$("mn").on("keydown",jQuery.proxy(this._handleKeyDown,this));this.sResizeListenerId=a.register(this.oDomRef,jQuery.proxy(this.ontoolbarresize,this));var e=this.getRightItems().length;this.bHasRightItems=e>0;if(this.bHasRightItems){this.sRightSideResizeListenerId=a.register(this.oDomRef.lastChild,jQuery.proxy(this.onrightsideresize,this));this.updateAfterResize(true);this._observeVisibleItemCountChange(40)}else{this.updateAfterResize(true);this._observeVisibleItemCountChange(350)}};f.prototype._handleKeyDown=function(e){if(e.keyCode==p.SPACE&&e.target.id===this.getId()+"-mn"){this.handleOverflowButtonTriggered();e.preventDefault();e.stopPropagation()}};f.prototype.exit=function(){this.cleanup();if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}this.oItemDelegate=undefined;jQuery(window).off("resize",this.onwindowresize);I.call(this)};f.prototype.updateAfterResize=function(e){if(this._bRendering){return}var t=this.getVisibleItemInfo();this._oLastVisibleItem=t.oLastVisibleItem;this._oFirstInvisibleItem=t.oFirstInvisibleItem;this._iLastVisibleItemTop=t.iLastVisibleItemTop;this.updateItemNavigation(t.iAllItemsBeforeBreak,e);this.updateOverflowIcon(t.bOverflow);if(this.sUpdateItemNavigationTimer){clearTimeout(this.sUpdateItemNavigationTimer);this.sUpdateItemNavigationTimer=null}};f.prototype._detectVisibleItemCountChange=function(){if(!this.getDomRef()){if(this._detectVisibleItemCountChangeTimer){clearTimeout(this._detectVisibleItemCountChangeTimer);this._detectVisibleItemCountChangeTimer=null}return}if(this._oLastVisibleItem&&this._oFirstInvisibleItem){var e=this._oLastVisibleItem.offsetLeft;var t=this._oFirstInvisibleItem.offsetLeft;var i=this._oLastVisibleItem.offsetTop;var o=this.bRtl?t<e:t>e;if(i!=this._iLastVisibleItemTop||!this.bOpen&&o){if(this.bOpen){this.closePopup(true)}this.updateAfterResize(false)}}else if(this._oLastVisibleItem&&!this._oFirstInvisibleItem){if(this._oLastVisibleItem.offsetTop!=this._iLastVisibleItemTop){this.updateAfterResize(false)}}this._observeVisibleItemCountChange(350);if(this.bFirstTime&&this.bHasRightItems){this.onrightsideresize();this.bFirstTime=false}};f.prototype._observeVisibleItemCountChange=function(e){this._detectVisibleItemCountChangeTimer=setTimeout(function(){this._detectVisibleItemCountChange()}.bind(this),e)};f.prototype.updateItemNavigation=function(e,t){this.oItemNavigation.setRootDomRef(this.oDomRef);var i=g.call(this);var o=[];for(var s=0;s<e;s++){var n=i[s].getFocusDomRef();if(n){o.push(n)}}o.push(this.oOverflowDomRef);this.iLeftItemDomRefCount=o.length;var r=this.getRightItems();for(var s=0;s<r.length;s++){var n=r[s].getFocusDomRef();if(n){o.push(n)}}this.oItemNavigation.setItemDomRefs(o);this.iItemDomRefCount=o.length;if(t){for(var s=e;s<i.length;s++){var n=i[s].getFocusDomRef();var a=jQuery(n);if(n&&a.attr("tabindex")=="0"){a.attr("tabIndex",-1)}}}};f.prototype.getVisibleItemInfo=function(e){var t=0;if(this.oInnerRef){var i=e?this.oInnerRef.childNodes:this.oInnerRef.parentNode.querySelectorAll("#"+this.oInnerRef.id+" > :not(.sapUiHiddenPlaceholder)");this.bRtl=l.getRTL();var o,s,r=0,a,h,p=0,u=null,f=null,m,g,I=false;for(var v=1,b=i.length;v<b;v++){s=i[v];a=s.offsetLeft;if(v==1){h=i[0].offsetWidth;p=i[0].offsetLeft}if(this.bRtl){r=s.offsetWidth;o=!d.call(this,s)&&a+r>=p+h}else{o=!d.call(this,s)&&a<=p&&s.offsetTop>i[0].offsetTop}if(o){t=v;u=i[v-1];f=s;m=u.offsetTop;I=true;break}else if(d.call(this,s)){t=v;n(t===b-1,"visible items ("+t+") must be one less than the items count ("+b+")");u=i[v-1];f=null;m=u.offsetTop;I=false;break}else{p=a;h=r}}g=c.call(this,u)}return{count:t,oLastVisibleItem:u,oFirstInvisibleItem:f,iLastVisibleItemTop:m,iAllItemsBeforeBreak:g,bOverflow:I}};f.prototype.updateOverflowIcon=function(e){this.oOverflowDomRef.style.display=e||this.bOpen?"block":"none"};f.prototype.onclick=function(e){if(e.target.id===this.getId()+"-mn"){this.handleOverflowButtonTriggered();e.preventDefault();e.stopPropagation()}};f.prototype.onsapdown=function(e){if(e.target.id===this.getId()+"-mn"){if(!this.bOpen){this.handleOverflowButtonTriggered();e.preventDefault();e.stopImmediatePropagation()}}};f.prototype.onsapup=function(e){if(e.target.id===this.getId()+"-mn"){if(this.bOpen){this.handleOverflowButtonTriggered();e.preventDefault();e.stopPropagation()}}};f.prototype.handleOverflowButtonTriggered=function(){if(!this.bPopupInitialized){this._oOverflowPopup=new m(this);this.popup=new i(this._oOverflowPopup,false,true,true);this.popup.setAutoCloseAreas([this.getId()+"-mn"]);this.bPopupInitialized=true}if(this.bOpen){this.closePopup(false)}else{this.openPopup()}};f.prototype.openPopup=function(){this.getRenderer().setActive(this);var e=jQuery(this.getDomRef());this.sOriginalStylePropertyWidth=e.prop("style").width;e.width(e.width());s.fillOverflowPopup(this);this.popup.attachEvent("opened",this.handlePopupOpened,this);this.popup.attachEvent("closed",this.handlePopupClosed,this);jQuery(window).on("resize",jQuery.proxy(this.onwindowresize,this));var t=0;this.popup.open(t,i.Dock.EndTop,i.Dock.EndBottom,this.$("mn"),"","fit",true)};f.prototype.handlePopupOpened=function(){var e=g.call(this);var t=this.getVisibleItemInfo().iAllItemsBeforeBreak;this.bOpen=true;var i=[];for(var o=t;o<e.length;o++){var s=e[o].getFocusDomRef();if(s){i.push(s)}}this.popup.getContent().initItemNavigation(i)};f.prototype.closePopup=function(e){this._bResetFocus=e;this.popup.close();jQuery(window).off("resize",this.onwindowresize)};f.prototype.handlePopupClosed=function(){this.getRenderer().unsetActive(this);this.bOpen=false;s.emptyOverflowPopup(this);var e=this.getVisibleItemInfo().iAllItemsBeforeBreak;this.updateItemNavigation(e,true);if(this._bResetFocus){this.oItemNavigation.focusItem(this.iLeftItemDomRefCount-1)}this._bResetFocus=false};f.prototype.prepareFocusInfoRedirect=function(e){if(e&&!e._orig_getFocusInfo){var t=this.getId();e._orig_getFocusInfo=e.getFocusInfo;e.getFocusInfo=function(){return{id:t,childInfo:this._orig_getFocusInfo()}};var i=this;e._orig_applyFocusInfo=e.applyFocusInfo;e.applyFocusInfo=function(e){return i.applyFocusInfo(e.childInfo)}}return e};f.prototype.cleanupFocusInfoRedirect=function(e){if(e){e.getFocusInfo=e._orig_getFocusInfo;delete e._orig_getFocusInfo;delete e._orig_applyFocusInfo}return e};f.prototype.insertItem=function(e,t){this.insertAggregation("items",this.prepareFocusInfoRedirect(e),t);e.addDelegate(this.oItemDelegate);return this};f.prototype.addItem=function(e){this.addAggregation("items",this.prepareFocusInfoRedirect(e));e.addDelegate(this.oItemDelegate);return this};f.prototype.removeItem=function(e){var t=this.removeAggregation("items",e);t.removeDelegate(this.oItemDelegate);return this.cleanupFocusInfoRedirect(t)};f.prototype.removeAllItems=function(){var e=this.removeAllAggregation("items");for(var t=0,i=e.length;t<i;t++){e[t]=this.cleanupFocusInfoRedirect(e[t]);e[t].removeDelegate(this.oItemDelegate)}return e};f.prototype.insertRightItem=function(e,t){this.insertAggregation("rightItems",this.prepareFocusInfoRedirect(e),t);e.addDelegate(this.oItemDelegate);return this};f.prototype.addRightItem=function(e){this.addAggregation("rightItems",this.prepareFocusInfoRedirect(e));e.addDelegate(this.oItemDelegate);return this};f.prototype.removeRightItem=function(e){var t=this.removeAggregation("rightItems",e);t.removeDelegate(this.oItemDelegate);return this.cleanupFocusInfoRedirect(t)};f.prototype.removeAllRightItems=function(){var e=this.removeAllAggregation("rightItems");for(var t=0,i=e.length;t<i;t++){e[t]=this.cleanupFocusInfoRedirect(e[t]);e[t].removeDelegate(this.oItemDelegate)}return e};f.prototype.getFocusInfo=function(){var e=this.getId();if(this.bOpen){return{id:e,childId:e}}else{return{id:e}}};f.prototype.applyFocusInfo=function(e){if(e){var t=e.childId;if(this.bOpen&&t){if(t===this.getId()){return}var i=sap.ui.getCore().byId(t);var o;if(i&&this.popup&&(o=this.popup.getContent())&&r(o.getDomRef(),i.getDomRef())){o.applyFocusInfo(e.childInfo);return}}}this.focus()};var m=h.extend("sap.ui.commons.ToolbarOverflowPopup",{constructor:function(e){this.oToolbar=e;var t=e.getId()+"-pu";h.call(this,t)},exit:function(){this.$().remove()},initItemNavigation:function(e){if(!this.oItemNavigation){this.oItemNavigation=new o;this.addDelegate(this.oItemNavigation)}this.oItemNavigation.setRootDomRef(s.getPopupArea(this.oToolbar));this.oItemNavigation.setItemDomRefs(e);this.oItemNavigation.focusItem(0)},getDomRef:function(){var e=s.getPopupArea(this.oToolbar);if(e){return e.parentNode}else{return null}},isActive:function(){return s.getPopupArea(this.oToolbar)!=null},onsapescape:function(e){this.oToolbar.closePopup(true)},onsaptabnext:function(e){this.oToolbar.closePopup(true);e.preventDefault();e.stopPropagation()},onsaptabprevious:function(e){this.oToolbar.closePopup(true);e.preventDefault();e.stopPropagation()}});f.prototype._itemRendered=function(){if(this.oItemNavigation){this.updateAfterResize(true)}else{if(!this.sUpdateItemNavigationTimer){this.sUpdateItemNavigationTimer=setTimeout(function(){this.updateAfterResize(true)}.bind(this),0)}}};f.prototype.onwindowresize=function(e){if(this.bOpen){this.closePopup(true)}};f.prototype.ontoolbarresize=function(e){if(this.bOpen){this.closePopup(true)}};f.prototype.onrightsideresize=function(){if(!this.getDomRef()){this.cleanup();return}if(this.getRightItems().length>0){var e=this.oDomRef.lastChild;var t=e.offsetWidth;if(this.bRtl){jQuery(this.oInnerRef).css("margin-left",t+10+"px")}else{jQuery(this.oInnerRef).css("margin-right",t+10+"px")}var i=this.oDomRef.firstChild.firstChild.firstChild;var o=this.getDomRef("mn").offsetWidth;var s=i.offsetWidth+t+o+20;jQuery(this.oDomRef).css("min-width",s+"px");jQuery(this.oInnerRef).css("visibility","visible")}};f.prototype.cleanup=function(){if(this._detectVisibleItemCountChangeTimer){clearTimeout(this._detectVisibleItemCountChangeTimer);this._detectVisibleItemCountChangeTimer=null}if(this.sUpdateItemNavigationTimer){clearTimeout(this.sUpdateItemNavigationTimer);this.sUpdateItemNavigationTimer=null}if(this.sResizeListenerId){a.deregister(this.sResizeListenerId);this.sResizeListenerId=null}if(this.sRightSideResizeListenerId){a.deregister(this.sRightSideResizeListenerId);this.sRightSideResizeListenerId=null}};function g(){var e=[];this.getItems().forEach(function(t){if(t instanceof sap.ui.commons.ToolbarSeparator||t.getVisible()){e.push(t)}});return e}function d(e){var t=this.getId()+"-mn";return e.id===t}function c(e){var t=0;var i=g.call(this);i.forEach(function(i,o){if(i.getDomRef()===e){t=o+1;return false}});return t}return f;function I(){if(this.bPopupInitialized){this._oOverflowPopup.destroy();this._oOverflowPopup=null;this.popup.detachOpened(this.handlePopupOpened,this);this.popup.detachClosed(this.handlePopupClosed,this);this.popup.destroy();this.popup=null;this.bPopupInitialized=false}}});
//# sourceMappingURL=Toolbar.js.map