/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/base/Log","./Control","./RenderManager","./HTMLRenderer","sap/base/security/sanitizeHTML"],function(jQuery,e,t,n,r,i){"use strict";var s=n.RenderPrefixes;var o=t.extend("sap.ui.core.HTML",{metadata:{library:"sap.ui.core",properties:{content:{type:"string",group:"Misc",defaultValue:null},preferDOM:{type:"boolean",group:"Misc",defaultValue:true},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{afterRendering:{parameters:{isPreservedDOM:{type:"boolean"}}}}},renderer:r});o.prototype.getDomRef=function(e){var t=e?this.getId()+"-"+e:this.getId();return document.getElementById(s.Dummy+t)||document.getElementById(t)};o.prototype.setContent=function(t){function n(e){if(jQuery.parseHTML){var t=jQuery.parseHTML(e);if(t){var n=0,r=t.length;while(n<r&&t[n].nodeType!=1){n++}while(n<r&&t[r-1].nodeType!=1){r--}if(n>0||r<t.length){t=t.slice(n,r)}return jQuery(t)}}return jQuery(e)}if(this.getSanitizeContent()){e.trace("sanitizing HTML content for "+this);t=i(t)}this.setProperty("content",t,true);if(this.getDomRef()){var r=n(this.getContent());jQuery(this.getDomRef()).replaceWith(r);this._postprocessNewContent(r)}else{this.invalidate()}return this};o.prototype.setSanitizeContent=function(e){this.setProperty("sanitizeContent",e,true);if(e){this.setContent(this.getContent())}return this};o.prototype.onBeforeRendering=function(){if(!this.getPreferDOM()){return}var e=this.getDomRef();if(e&&!n.isPreservedContent(e)){for(var t=e.id,r;e&&e.getAttribute("data-sap-ui-preserve")==t;e=r){r=e.nextElementSibling;n.preserveContent(e,true,false)}}};o.prototype.onAfterRendering=function(){if(!this.getVisible()){return}var e=jQuery(document.getElementById(s.Dummy+this.getId()));var t=n.findPreservedContent(this.getId());var r;var i=false;if(!this.getPreferDOM()||t.length==0){t.remove();r=new jQuery(this.getContent());e.replaceWith(r)}else if(t.length>0){e.replaceWith(t);r=t;i=true}else{e.remove()}this._postprocessNewContent(r);this.fireAfterRendering({isPreservedDOM:i})};o.prototype._postprocessNewContent=function(t){if(t&&t.length>0){if(t.length>1){e.warning("[Unsupported Feature]: "+this+" has rendered "+t.length+" root nodes!")}else{var r=t.attr("id");if(r&&r!=this.getId()){e.warning("[Unsupported Feature]: Id of HTML Control '"+this.getId()+"' does not match with content id '"+r+"'!")}}if(this.getPreferDOM()){n.markPreservableContent(t,this.getId())}if(t.find("#"+this.getId().replace(/(:|\.)/g,"\\$1")).length===0){t.filter(":not([id])").first().attr("id",this.getId())}}else{e.debug(""+this+" is empty after rendering, setting bOutput to false");this.bOutput=false}};o.prototype.setDOMContent=function(e){var t=jQuery(e);if(this.getDomRef()){jQuery(this.getDomRef()).replaceWith(t);this._postprocessNewContent(t)}else{t.appendTo(n.getPreserveAreaRef());if(this.getUIArea()){this.getUIArea().invalidate()}this._postprocessNewContent(t)}return this};o.prototype.setTooltip=function(){e.warning("The sap.ui.core.HTML control doesn't support tooltips. Add the tooltip to the HTML content instead.");return t.prototype.setTooltip.apply(this,arguments)};"hasStyleClass addStyleClass removeStyleClass toggleStyleClass".split(" ").forEach(function(n){o.prototype[n]=function(){e.warning("The sap.ui.core.HTML control doesn't support custom style classes. Manage custom CSS classes in the HTML content instead.");return t.prototype[n].apply(this,arguments)}});return o});
//# sourceMappingURL=HTML.js.map