/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/base/DataType","sap/ui/base/Event","sap/ui/base/ManagedObject","sap/ui/base/Object","sap/ui/base/ObjectPool","./Control","./Element","./EventBus","./FocusHandler","./IntervalTrigger","./RenderManager","./ResizeHandler","./library","./StaticArea","sap/base/assert","sap/base/Log","sap/base/i18n/Localization","sap/base/util/Version","sap/base/util/uid","sap/base/util/extend","sap/base/util/each","sap/base/util/deepExtend","sap/ui/events/F6Navigation","sap/ui/events/isMouseEventDelayed","sap/ui/base/EventProvider","sap/ui/thirdparty/jquery","sap/ui/thirdparty/jqueryui/jquery-ui-position","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(t,e,i,o,s,n,r,a,l,u,f,h,p,c,d,_,m,b,g,v,y,C,E,S,P,O,jQuery){"use strict";var I=c.CSSSize;var L=c.OpenState;var w=c.Collision;var x;var F;var k;var A="sapUiPopupResize";var R=new l;if(window.ResizeObserver){k=new window.ResizeObserver(function(t){N(jQuery("#sap-ui-blocklayer-popup"),t[0].target)})}else{k={observe:function(t){var e=t.dataset[A];if(!e){e=p.register(t,function(t){N(jQuery("#sap-ui-blocklayer-popup"),t.target)});t.dataset[A]=e}},unobserve:function(t){var e=t.dataset[A];if(e){p.deregister(e);delete t.dataset[A]}}}}function D(){if(x){return x}var t;try{x=d.getUIArea()}catch(t){m.error(t);throw new Error("Popup cannot be opened because static UIArea cannot be determined.")}t=new r;x.addDependent(t);x=t.getUIArea();t.destroy();return x}function T(t){var e;if(typeof t==="string"){e=document.querySelector(t)}else if(t instanceof a){e=t.getDomRef()}else{e=t}return e||window}function B(t){var e=["left","top","width","height"];if(t[0]){t[0].classList.remove("sapUiBLyWithin");e.forEach(function(e){t[0].style.removeProperty(e)})}}function N(t,e){var i=e.getBoundingClientRect();t.css({width:i.width,height:i.height}).addClass("sapUiBLyWithin").position({my:"left top",at:"left top",of:e})}var U=o.extend("sap.ui.core.Popup",{constructor:function(t,e,i,s){_(arguments.length==0||t&&typeof t==="object","oContent must be an object or there may be no arguments at all");_(e===undefined||e===true||e===false,"bModal must be true, false, or undefined");_(i===undefined||i===true||i===false,"bShadow must be true, false, or undefined");_(s===undefined||s===true||s===false,"bAutoClose must be true, false, or undefined");o.apply(this);this._popupUID=v();this.bOpen=false;this.eOpenState=L.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;this._mEvents["sap.ui.core.Popup.extendFocusInfo-"+this._popupUID]=this._extendFocusInfoEventBusWrapper;if(t){this.setContent(t)}this._oDefaultPosition={my:U.Dock.CenterCenter,at:U.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=Object.assign({},this._oDefaultPosition);this._bModal=!!e;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof i==="boolean"?i:true;this._bAutoClose=!!s;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(t){if(t.isMarked("delayedMouseEvent")||t.isMarked("cancelAutoClose")){return}if(this.eOpenState===L.CLOSING||this.eOpenState===L.CLOSED){return}if(!this._contains(t.target)){this.close()}}.bind(this)}this._F6NavigationHandler=function(t){var e={},i=this._sF6NavMode,o;if(i=="DOCK"){if(this._bModal){i="NONE"}else if(this._oLastPosition&&this._oLastPosition.of){o=this._getOfDom(this._oLastPosition.of);if(!o||o===document){o=null;i="NONE"}}}switch(i){case"SCOPE":e.scope=this._$()[0];break;case"DOCK":e.target=o;var s=jQuery(o).parents("[data-sap-ui-popup]");e.scope=s.length?s[0]:null;break;default:e.skip=true}S.handleF6GroupNavigation(t,e)}.bind(this)},metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","setExtraContent","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{childPopups:{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{opened:{},closed:{}}}});U.prototype.getChildPopups=function(){return this.getAssociation("childPopups",[])};U.prototype.addChildPopup=function(t){return this.addAssociation("childPopups",t)};U.prototype.removeChildPopup=function(t){return this.removeAssociation("childPopups",t)};U.blStack=[];U.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};e.registerEnum("sap.ui.core.Popup.Dock",U.Dock);U.prototype.touchEnabled=t.support.touch&&(t.browser.safari||!t.system.combi);U.prototype.preventBrowserFocus=t.support.touch&&!t.system.combi;var M=s.extend("sap.ui.core.Popup.Layer",{constructor:function(){s.call(this);var t=this.getDomString();this._$Ref=jQuery(t).appendTo(d.getDomRef())}});M.prototype.init=function(t,e){this._$Ref.css({visibility:"visible","z-index":e});this.update(t,e);this._$Ref.insertAfter(t).show()};M.prototype.update=function(t,e){if(t.length){var i=t.rect();this._$Ref.css({left:i.left,top:i.top});if(t.css("right")!="auto"&&t.css("right")!="inherit"){this._$Ref.css({right:t.css("right"),width:"auto"})}else{this._$Ref.css({width:i.width,right:"auto"})}if(t.css("bottom")!="auto"&&t.css("bottom")!="inherit"){this._$Ref.css({bottom:t.css("bottom"),height:"auto"})}else{this._$Ref.css({height:i.height,bottom:"auto"})}if(typeof e==="number"){this._$Ref.css("z-index",e)}}};M.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(d.getDomRef())}};M.prototype.getDomString=function(){m.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return""};var $=M.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){M.apply(this)}});$.prototype.getDomString=function(){return'<div class="sapUiPopupShield" id="sap-ui-shieldlayer-'+v()+'"></div>'};U.prototype.oShieldLayerPool=new n($);(function(){var t=0;var e=Math.pow(2,32)-1;U.setInitialZIndex=function(i){if(i>=e){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER")}t=Math.max(i,this.getLastZIndex())};U.getLastZIndex=function(){return t};U.prototype.getLastZIndex=function(){return U.getLastZIndex()};U.getNextZIndex=function(){t+=10;if(t>=e){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER")}return t};U.prototype.getNextZIndex=function(){return U.getNextZIndex()}})();var H=function(t,e){if(!t&&e||t&&!e){return false}if(!t&&!e){return true}var i=3;var o=Math.abs(t.left-e.left);var s=Math.abs(t.top-e.top);var n=Math.abs(t.width-e.width);var r=Math.abs(t.height-e.height);if(o>i||s>i||n>i||r>i){return false}return true};U.prototype.open=function(t,e,i,o,s,n,l,u){_(this.oContent,"Popup content must have been set by now");if(this.eOpenState!=L.CLOSED){return}if(typeof t=="string"){u=l;l=n;n=s;s=o;o=i;i=e;e=t;t=-1}if(typeof l==="boolean"||typeof l==="function"||l===U.CLOSE_ON_SCROLL){u=l;l=undefined}if(t===undefined){t=-1}_(t===-1||typeof t==="number"&&t%1==0,"iDuration must be an integer (or omitted)");_(e===undefined||typeof e==="string","my must be a string or empty");_(i===undefined||typeof i==="string","at must be a string or empty");_(!o||typeof o==="object"||typeof o==="function","of must be empty or an object");_(!s||typeof s==="string","offset must be empty or a string");_(!n||w.isValid(n),"collision must be empty or of type sap.ui.core.Collision");_(!l||l===window||typeof l==="string"||l instanceof a||l instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");_(!u||typeof u==="boolean"||typeof u==="function"||u===U.CLOSE_ON_SCROLL,"followOf must be either empty or a boolean");this.eOpenState=L.OPENING;var f=D(),h;this._bContentAddedToStatic=false;this._bUIAreaPatched=false;if(this.oContent instanceof r){if(!this.oContent.getParent()){f.addContent(this.oContent,true);this._bContentAddedToStatic=true}else if(!this.oContent.getUIArea()){this.oContent.getUIArea=function(){return f};this._bUIAreaPatched=true}h=this.oContent.getUIArea();if(U._bEnableUIAreaCheck&&h.getRootNode().id!==f.getRootNode().id){m.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!")}}this._oPreviousFocus=U.getCurrentFocusInfo();if(this.isInPopup(o)||this.isInPopup(this._oPosition.of)){var p=this.getParentPopupId(o)||this.getParentPopupId(this._oPosition.of);var c="";var b=this.getContent();if(b instanceof a){c=b.getId()}else if(typeof b==="object"){c=b.id}this.addChildToPopup(p,c);this.addChildToPopup(p,this._popupUID)}var g=this._$(true);var v="fast";if(t===0||t>0){v=t}else if(this._durations.open===0||this._durations.open>0){v=this._durations.open}var y;if(e||i||o||s||n||l){y=this._createPosition(e,i,o,s,n,l);this._oPosition=y}else{y=this._oPosition;if(!this._bOwnWithin&&F){this._oPosition.within=F}}if(!y.of){y.of=this._oPosition.of||document}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var C=d.getDomRef();g.css({position:"absolute",visibility:"hidden"});if(!(g[0].parentNode==C)){g.appendTo(C)}g.css("z-index",this._iZIndex);m.debug("position popup content "+g.attr("id")+" at "+JSON.stringify(y.at));this._applyPosition(y);if(u!==undefined){this.setFollowOf(u)}g.toggleClass("sapUiShd",this._bShadow);var E=g[0];if(E){E.style.display="none";E.style.visibility="visible"}var S=v==0;this._duringOpen(!S);if(S){this._opened()}else if(this._animations.open){this._animations.open.call(null,g,v,this._opened.bind(this))}else{g.fadeIn(v,this._opened.bind(this))}};U.prototype._getDomRefToFocus=function(){var t=this._$(false,true),e,i;if(this._shouldGetFocusAfterOpen()){if(this._sInitialFocusId){i=a.getElementById(this._sInitialFocusId);if(i){e=i.getFocusDomRef()}e=e||window.document.getElementById(this._sInitialFocusId)}e=e||t.firstFocusableDomRef()}return e};U.prototype._opened=function(){if(this.eOpenState!==L.OPENING){return}this.bOpen=true;var t=this._$(false,true);if(t[0]&&t[0].style){t[0].style.display="block"}if(this._shouldGetFocusAfterOpen()){var e=this._getDomRefToFocus();if(e){e.focus()}var i=this._getOfDom(this._oLastPosition.of);var o=jQuery(i).rect();if(this._oLastOfRect&&o&&!H(this._oLastOfRect,o)){this._applyPosition(this._oLastPosition)}}this.eOpenState=L.OPEN;if(this.getFollowOf()){U.DockTrigger.addListener(U.checkDocking,this)}this.fireOpened()};U.prototype._duringOpen=function(t){var e=this._$(false,true),i=d.getDomRef(),o=document.getElementById(i.id+"-firstfe");U._clearSelection();this._setupUserSelection();if(P()){if(this._oTopShieldLayer){clearTimeout(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject(e,this._iZIndex+1)}this._iTopShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null}.bind(this),500)}if(this._bModal){this._showBlockLayer()}if(!this.touchEnabled&&t&&o&&this._shouldGetFocusAfterOpen()&&!this.isInPopup(document.activeElement)&&this._getDomRefToFocus()!==document.activeElement){o.focus({preventScroll:true})}if(this.oContent instanceof a){this.oContent.addDelegate(this)}this.bOpen=true;this._activateFocusHandle();this._$(false,true).on("keydown",this._F6NavigationHandler)};U.prototype._shouldGetFocusAfterOpen=function(){return this._bModal||this._bAutoClose||this._sInitialFocusId};U.prototype._contains=function(t){var e=this._$().get(0);if(!e){return false}var i=e.contains(t);var o;if(!i){o=this.getChildPopups();i=o.some(function(e){var i=e?window.document.getElementById(e):null;var o=i&&i.contains(t);if(!o){var s="sap.ui.core.Popup.contains-"+e;var n={domRef:t};R.publish("sap.ui",s,n);o=n.contains}return o})}if(!i){G.forEach(function(e){i=i||jQuery(t).closest(e).length>0})}return i};U.prototype._containsEventBusWrapper=function(t,e,i){i.contains=this._contains(i.domRef)};U.prototype.onFocusEvent=function(e){var i=jQuery.event.fix(e);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){i=jQuery.event.fix(arguments[2])}var o=i.type=="focus"||i.type=="activate"?"focus":"blur";var s=false;if(o=="focus"){var n=this._$().get(0);if(n){s=this._contains(i.target);m.debug("focus event on "+i.target.id+", contains: "+s);if(this._bModal&&!s){var r=U.blStack.length>0&&U.blStack[U.blStack.length-1].popup===this;if(r){if(t.system.desktop||jQuery(i.target).is(":input")){if(this.oLastBlurredElement){setTimeout(function(){if(this.oLastBlurredElement){this.oLastBlurredElement.focus()}}.bind(this),0)}else{n.focus()}}}}else if(this._bAutoClose&&s&&this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null}}}else if(o=="blur"){m.debug("blur event on "+i.target.id);if(this._bModal){this.oLastBlurredElement=i.target}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(i.target===document.activeElement){return}var a=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=setTimeout(function(){this.close(a,"autocloseBlur");var t=this._oLastPosition&&this._oLastPosition.of;if(t){var e=this.getParentPopupId(t);if(e){var o="sap.ui.core.Popup.onFocusEvent-"+e;R.publish("sap.ui",o,i)}}}.bind(this),a)}}}};U.prototype.setInitialFocusId=function(t){_(!t||typeof t==="string","sId must be a string or empty");this._sInitialFocusId=t};U.prototype.close=function(t){if(U._autoCloseDebug){return}if(this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null}_(t===undefined||typeof t==="number"&&t%1==0,"iDuration must be empty or an integer");if(this.eOpenState==L.CLOSED||this.eOpenState==L.CLOSING){return}var e="fast";if(t===0||t>0){e=t}else if(this._durations.close===0||this._durations.close>0){e=this._durations.close}this.eOpenState=L.CLOSING;if(this.getFollowOf()){U.DockTrigger.removeListener(U.checkDocking,this)}if(this.oContent){if(this._bContentAddedToStatic){R.publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var i=d.getUIArea();i.removeContent(i.indexOfContent(this.oContent),true)}else if(this._bUIAreaPatched){delete this.oContent.getUIArea}}this._bContentAddedToStatic=false;this._bUIAreaPatched=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof a){this.oContent.removeDelegate(this)}var o=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents()}if(P()){if(this._oBottomShieldLayer){clearTimeout(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject(o,this._iZIndex-3)}this._iBottomShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null}.bind(this),500)}if(this.isInPopup(this._oLastPosition.of)){var s=this.getParentPopupId(this._oLastPosition.of);var n="";var r=this.getContent();if(r instanceof a){n=r.getId()}else if(typeof r==="object"){n=r.id}this.removeChildFromPopup(s,n);this.removeChildFromPopup(s,this._popupUID)}if(this._bModal&&this.preventBrowserFocus){o.one("mousedown",function(t){t.preventDefault()})}this._duringClose();if(e==0){this._closed()}else if(this._animations.close){this._animations.close.call(null,o,e,this._closed.bind(this))}else{o.fadeOut(e,this._closed.bind(this))}};U.prototype._closed=function(){var t=this._$(false,true);if(this._bModal){this._hideBlockLayer()}U._clearSelection();this._restoreUserSelection();if(t.length){var e=t.get(0);if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right=""}t=this._$(false,true);e=t.length?t[0]:null;if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right=""}}if(this._bModal){U.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null}this.bOpen=false;this.eOpenState=L.CLOSED;var i=this.getChildPopups();for(var o=0,s=i.length;o<s;o++){this.closePopup(i[o])}this.fireClosed()};U.prototype._duringClose=function(){if(this._resizeListenerId){p.deregister(this._resizeListenerId);this._resizeListenerId=null}};U.getCurrentFocusInfo=function(){var t=null;var e=a.closestTo(document.activeElement);if(e){t={sFocusId:e.getId(),oFocusInfo:e.getFocusInfo()}}else{t={sFocusId:document.activeElement.id,oFocusedElement:document.activeElement,oFocusInfo:{}}}if(t){t.popup=this}return t};U.applyFocusInfo=function(t){var e={preventScroll:true};if(t){var i=a.getElementById(t.sFocusId);if(i){i.applyFocusInfo(Object.assign(e,t.oFocusInfo))}else{var o=(t.sFocusId?window.document.getElementById(t.sFocusId):null)||t.oFocusedElement;if(o){o.focus(e)}}}};U.prototype.setContent=function(t){_(typeof t==="object","oContent must be an object");this.oContent=t;return this};U.prototype.getContent=function(){return this.oContent};U.prototype.setPosition=function(t,e,i,o,s,n){_(typeof t==="string","my must be a string");_(typeof e==="string"||typeof e==="object"&&typeof e.left==="number"&&typeof e.top==="number","my must be a string or an object with 'left' and 'top' properties");_(!i||typeof i==="object"||typeof i==="function","of must be empty or an object");_(!o||typeof o==="string","offset must be empty or a string");_(!s||w.isValid(s),"collision must be empty or of type sap.ui.core.Collision");_(!n||n===window||typeof n==="string"||n instanceof a||n instanceof HTMLElement,"within must be either empty, or the global window object, or a string, or a sap.ui.core.Element, or a DOM element");this._oPosition=this._createPosition(t,e,i,o,s,n);if(this.eOpenState!=L.CLOSED){this._applyPosition(this._oPosition)}return this};U.prototype._createPosition=function(t,e,i,o,s,n){var r=false;if(t&&(t.indexOf("+")>=0||t.indexOf("-")>=0)){r=true;if(o&&o!="0 0"){m.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition")}o=null}var a=y({},this._oDefaultPosition,{my:t||this._oDefaultPosition.my,at:e||this._oDefaultPosition.at,of:i,offset:o,collision:s});if(n||F){a.within=n||F}this._bOwnWithin=!!n;if(!jQuery.ui.version){if(U._bNewOffset==null){U._bNewOffset=true;var l=jQuery(document.createElement("div"));l.position({of:window,using:function(t,e){U._bNewOffset=e!==undefined}})}}var u=[];var f=[];if(U._bNewOffset||g(jQuery.ui.version).compareTo("1.8.23")>0){if(o&&o!="0 0"){u=a.my.split(" ");f=o.split(" ");var h=[parseInt(f[0])<0?"":"+",parseInt(f[1])<0?"":"+"];a.my=u[0]+h[0]+f[0]+" "+u[1]+h[1]+f[1];a.offset=null}}else if(r){u=a.my.split(" ");f=["",""];var p=u[0].indexOf("+");if(p<0){p=u[0].indexOf("-")}if(p>=0){f[0]=u[0].slice(p);u[0]=u[0].slice(0,p)}p=u[1].indexOf("+");if(p<0){p=u[1].indexOf("-")}if(p>=0){f[1]=u[1].slice(p);u[1]=u[1].slice(0,p)}a.my=u[0]+" "+u[1];a.offset=f[0]+" "+f[1]}return a};U.prototype._getPositionOffset=function(){var t=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var e=this._oPosition.my.split(" ");var i=e[0].indexOf("+");if(i<0){i=e[0].indexOf("-")}if(i>=0){t[0]=e[0].slice(i)}i=e[1].indexOf("+");if(i<0){i=e[1].indexOf("-")}if(i>=0){t[1]=e[1].slice(i)}}else if(this._oPosition.offset){t=this._oPosition.offset.split(" ")}return t};U.prototype._applyPosition=function(t){var e=b.getRTL();var i=this._$();if(i.length){var o=t.at;var s=i.get(0);if(typeof o==="string"){s.style.display="block";s.style.left="";s.style.right="";i.position(this._resolveReference(this._convertPositionRTL(t,e)));this._fixPositioning(t,e)}else if(I.isValid(o.left)&&I.isValid(o.top)){i.css({left:o.left,top:o.top})}else if(I.isValid(o.right)&&I.isValid(o.top)){i.css({right:o.right,top:o.top})}else if(typeof o.left==="number"&&typeof o.top==="number"){var n=i[0];if(n&&n.style.right){var r=i[0].getBoundingClientRect().width;i.css({right:document.documentElement.clientWidth-(o.left+r)+"px",top:o.top+"px"})}else{i.css({left:o.left+"px",top:o.top+"px"})}}this._oLastPosition=t;this._oLastOfRect=this._calcOfRect(t.of)}};U.prototype._calcOfRect=function(t){var e=this._getOfDom(t);if(e){return jQuery(e).rect()}return null};U.prototype._getOfDom=function(t){if(t instanceof jQuery.Event){return null}var e;if(typeof t==="string"){e=jQuery(document.getElementById(t))}else if(t instanceof jQuery){e=t}else{e=jQuery(t instanceof a?t.getDomRef():t)}return e[0]};U.prototype._convertPositionRTL=function(t,e){var i=Object.assign({},t);if(e){var o=false;if(i.my&&(i.my.indexOf("+")>=0||i.my.indexOf("-")>=0)){o=true}if((i.offset||o)&&(i.my.indexOf("begin")>-1||i.my.indexOf("end")>-1)&&(i.at.indexOf("begin")>-1||i.at.indexOf("end")>-1)){if(o){var s=i.my.split(" ");if(s.length==2){i.my="";if(s[0]){if(s[0].indexOf("begin")>-1||s[0].indexOf("end")>-1){if(s[0].indexOf("+")>-1){s[0]=s[0].replace("+","-")}else if(s[0].indexOf("-")>-1){s[0]=s[0].replace("-","+")}}i.my=s[0]}if(s[1]){if(s[1].indexOf("begin")>-1||s[1].indexOf("end")>-1){if(s[1].indexOf("+")>-1){s[1]=s[1].replace("+","-")}else if(s[1].indexOf("-")>-1){s[1]=s[1].replace("-","+")}}if(s[0]){i.my=i.my+" "}i.my=i.my+s[1]}}}else{i.offset=this._mirrorOffset(i.offset)}}i.my=i.my.replace("begin","right").replace("end","left");i.at=i.at.replace("begin","right").replace("end","left")}else{i.my=i.my.replace("end","right").replace("begin","left");i.at=i.at.replace("end","right").replace("begin","left")}return i};U.prototype._mirrorOffset=function(t){var e=String(t).trim().split(/\s/);var i=parseInt(e[0]);return-i+" "+e[e.length-1]};U.prototype._fixPositioning=function(t,e){var i=t.my;if(typeof i==="string"){if(U._isPositionFixingNeeded(i,e)){var o=this._$();var s=jQuery(window).width()-o[0].getBoundingClientRect().width-o.offset().left;o.css({right:s+"px",left:""})}}};U._isPositionFixingNeeded=function(t,e){return e&&(t.indexOf("right")>-1||t.indexOf("begin")>-1||t.indexOf("center")>-1)||!e&&(t.indexOf("right")>-1||t.indexOf("end")>-1)};U.prototype._resolveReference=function(t){var e,i=["of","within"];i.forEach(function(i){if(t[i]instanceof a){e=e||{};e[i]=t[i].getDomRef()}});return e?Object.assign({},t,e):t};U.prototype.setShadow=function(t){_(typeof t==="boolean","bShowShadow must be boolean");this._bShadow=t;if(this.eOpenState!=L.CLOSED){this._$().toggleClass("sapUiShd",t)}return this};U.prototype.setModal=function(t,e){_(typeof t==="boolean","bModal must be boolean");_(!e||typeof e==="string","sModalCSSClass must be empty or a string");var i=this._bModal;this._bModal=t;this._sModalCSSClass=e;if(this.isOpen()){if(i!==t){U._clearSelection();if(t){this._setupUserSelection();this._showBlockLayer()}else{this._hideBlockLayer();this._restoreUserSelection()}if(this.touchEnabled&&this._bAutoClose){if(!t){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}else{jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}}}}return this};U.prototype.getModal=function(){return this._bModal};U.prototype.setNavigationMode=function(t){if(t!="NONE"&&t!="DOCK"&&t!="SCOPE"){this._sF6NavMode="NONE"}this._sF6NavMode=t};U.prototype.setAutoClose=function(t){_(typeof t==="boolean","bAutoClose must be boolean");if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==t){if(!this._bModal){if(t){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}else{jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}}}this._bAutoClose=t;return this};U.prototype.setExtraContent=function(t){_(Array.isArray(t),"Extra popup content must be an array which contains either sap.ui.core.Element, DOM Element or an ID");if(!this._aExtraContent){this._aExtraContent=[]}var e=function(t){return{onBeforeRendering:function(){var e=t.getDomRef();if(e&&this.isOpen()){e.removeEventListener("blur",this.fnEventHandler,true)}},onAfterRendering:function(){var e=t.getDomRef();if(e&&this.isOpen()){e.addEventListener("blur",this.fnEventHandler,true)}}}};var i,o,s,n;for(var r=0,l=t.length;r<l;r++){o=t[r];if(o instanceof a){i=o.getId()}else if(typeof o==="object"){i=o.id}else if(typeof o==="string"){i=o}if(this.getChildPopups().indexOf(i)===-1){this.addChildPopup(i);n={id:i};if(o instanceof a){s=e(o);o.addEventDelegate(s,this);n.delegate=s}this._aExtraContent.push(n)}}return this};U.prototype.setAutoCloseAreas=U.prototype.setExtraContent;U.prototype.setAnimations=function(t,e){_(t===null||typeof t==="function","fnOpen must be a function");_(e===null||typeof e==="function","fnClose must be a function");if(t&&typeof t=="function"){this._animations.open=t}if(e&&typeof e=="function"){this._animations.close=e}return this};U.prototype.setDurations=function(t,e){_(t===null||typeof t==="number"&&t%1==0,"iOpenDuration must be null or an integer");_(!e||typeof e==="number"&&e%1==0,"iOpenDuration must be undefined or an integer");if(t>0||t===0){this._durations.open=t}if(e>0||e===0){this._durations.close=e}return this};U.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";U.prototype._fnCloseOnScroll=function(t){this.close()};U.prototype.setFollowOf=function(t){U.DockTrigger.removeListener(U.checkDocking,this);var e=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof t==="function"){this._followOfHandler=t;e=true}else if(typeof t==="boolean"){e=t}else if(t===U.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;e=true}else{this._bFollowOf=false;if(t!==null){m.error("Trying to set an invalid type to 'followOf: "+t)}}if(e&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of)}if(this._bFollowOf&&this.getOpenState()===L.OPEN){U.DockTrigger.addListener(U.checkDocking,this)}};U.prototype.getAutoClose=function(){return this._bAutoClose};U.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof this._followOfHandler==="function"?this._followOfHandler:true}return false};U.prototype.isOpen=function(){return this.bOpen};U.prototype.getOpenState=function(){return this.eOpenState};U.prototype.destroy=function(){if(this._resizeListenerId){p.deregister(this._resizeListenerId);this._resizeListenerId=null}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null)}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents()}if(this._iTopShieldRemoveTimer){clearTimeout(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null}if(this._iBottomShieldRemoveTimer){clearTimeout(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null}if(this._aExtraContent){var t;this._aExtraContent.forEach(function(e){if(e.delegate){t=a.closestTo(document.getElementById(e.id));if(t){t.removeEventDelegate(e.delegate)}}})}o.prototype.destroy.apply(this,arguments)};U.prototype.exit=function(){delete this._mEvents};U.prototype._addFocusEventListeners=function(){if(!this.fnEventHandler){this.fnEventHandler=this.onFocusEvent.bind(this)}var t=this._$();var e=this.getChildPopups();var i={};var o=0,s=0;if(t.length){document.addEventListener("focus",this.fnEventHandler,true);t.get(0).addEventListener("blur",this.fnEventHandler,true);for(o=0,s=e.length;o<s;o++){i=e[o]?window.document.getElementById(e[o]):null;if(i){i.addEventListener("blur",this.fnEventHandler,true)}}}};U.prototype._removeFocusEventListeners=function(){var t=this._$(false,true);if(!t.length){return}var e=this.getChildPopups();var i={};var o=0,s=0;document.removeEventListener("focus",this.fnEventHandler,true);t.get(0).removeEventListener("blur",this.fnEventHandler,true);for(o=0,s=e.length;o<s;o++){i=e[o]?window.document.getElementById(e[o]):null;if(i){i.removeEventListener("blur",this.fnEventHandler,true)}this.closePopup(e[o])}this.fnEventHandler=null};U.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners()}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){jQuery(document).on("touchstart mousedown",this._fAutoCloseHandler)}};U.prototype._deactivateFocusHandle=function(){if(this.fnEventHandler){this._removeFocusEventListeners()}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){jQuery(document).off("touchstart mousedown",this._fAutoCloseHandler)}};U.prototype._registerEventBusEvents=function(){var t=this;C(t._mEvents,function(e,i){R.subscribe("sap.ui",e,i,t)});this._bEventBusEventsRegistered=true};U.prototype._unregisterEventBusEvents=function(){var t=this;C(t._mEvents,function(e,i){R.unsubscribe("sap.ui",e,i,t)});delete this._bEventBusEventsRegistered};U.prototype._addFocusableArea=function(t,e,i){if(this.getChildPopups().indexOf(i.id)===-1){this.addChildPopup(i.id)}};U.prototype._removeFocusableArea=function(t,e,i){this.removeChildPopup(i.id)};U.prototype._closePopup=function(t,e,i){this.close(typeof this._durations.close==="string"?0:this._durations.close)};U.prototype._setIdentity=function(t){if(typeof t==="object"){t.attr("data-sap-ui-popup",this._popupUID)}else{m.warning("Incorrect DomRef-type for 'setIdentity': "+t,this);return}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents()}};U.prototype._$=function(t,e){var i;if(this.oContent instanceof r){i=this.oContent.$();if(t||i.length===0&&!e){m.info("Rendering of popup content: "+this.oContent.getId());if(i.length>0){h.preserveContent(i[0],true,false)}(new h).render(this.oContent,d.getDomRef());i=this.oContent.$()}}else if(this.oContent instanceof a){i=this.oContent.$()}else{i=jQuery(this.oContent)}this._setIdentity(i);return i};function j(t){if(U._blockLayerStateProvider){U._blockLayerStateProvider.fireEvent("blockLayerStateChange",t)}}U.attachBlockLayerStateChange=function(t,e,i){if(!U._blockLayerStateProvider){U._blockLayerStateProvider=new O}U._blockLayerStateProvider.attachEvent("blockLayerStateChange",t,e,i)};U.detachBlockLayerStateChange=function(t,e){if(U._blockLayerStateProvider){U._blockLayerStateProvider.detachEvent("blockLayerStateChange",t,e)}};function Z(t,e){if(e===window){B(t);document.documentElement.classList.add("sapUiBLyBack")}else{N(t,e);e.classList.add("sapUiBLyBack");k.observe(e)}}function z(t){if(t===window){document.documentElement.classList.remove("sapUiBLyBack")}else{t.classList.remove("sapUiBLyBack");k.unobserve(t)}}U.prototype._extendFocusInfo=function(t,e){var o=false,s="sap.ui.core.Popup.extendFocusInfo-",n;if(t instanceof i){n={info:e.info,element:t.getParameter("domRef")}}else{n=t}var r=this.getContent();var l=r instanceof a?r.getDomRef():r;if(l&&l.contains(n.element)){n.info.preventScroll=true;o=true}else{var u=this.getChildPopups();o=u.some(function(t){var e=s+t;R.publish("sap.ui",e,n);return n.extended})}return o};U.prototype._extendFocusInfoEventBusWrapper=function(t,e,i){i.contains=this._extendFocusInfo(i)};U.prototype._showBlockLayer=function(){var t=jQuery("#sap-ui-blocklayer-popup"),e="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:""),i;if(t.length===0){t=jQuery('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+e+'"></div>');t.appendTo(d.getDomRef())}else{t.removeClass().addClass(e)}var o=U.blStack[U.blStack.length-1];if(o){i=T(o.popup._oLastPosition.within);z(i)}i=T(this._oLastPosition.within);Z(t,i);U.blStack.push({zIndex:this._iZIndex-2,popup:this});t.css({"z-index":this._iZIndex-2,visibility:"visible"}).show();if(!this.isInPopup(this._oLastPosition.of)){this._bFocusExtenderAdded=true;u.addFocusInfoExtender(this._extendFocusInfo,this)}if(U.blStack.length===1){j({visible:true,zIndex:U.blStack[0].zIndex})}};U.prototype._hideBlockLayer=function(){var t=jQuery("#sap-ui-blocklayer-popup"),e=t[0],i=this,o,s;s=T(this._oLastPosition.within);z(s);if(t.length){if(this._bFocusExtenderAdded){this._bFocusExtenderAdded=false;u.removeFocusInfoExtender(this._extendFocusInfo,this)}if(U.blStack.length>1){U.blStack=U.blStack.filter(function(t){return t.popup!==i});o=U.blStack[U.blStack.length-1];e.style.zIndex=o.zIndex;e.style.visibility="visible";e.style.display="block";s=T(o.popup._oLastPosition.within);Z(t,s)}else{o=U.blStack.pop();e.style.visibility="hidden";e.style.display="none";j({visible:false,zIndex:o.zIndex})}}};U.prototype._isFocusInsidePopup=function(){var t=this._$(false).get(0);if(t&&t.contains(document.activeElement)){return true}return false};U.DockTrigger=f;U.checkDocking=function(){if(this.getOpenState()===L.OPEN){var t=this._getOfDom(this._oLastPosition.of),e;if(t){if(t===window||t===window.document||document.documentElement.contains(t)){e=jQuery(t).rect()}else if(t.id){var i=window.document.getElementById(t.id);var o=jQuery(i).rect();if(o&&!H(e,o)){e=o;this._oLastPosition.of=i}}}if(!e){this.close();return}else if(e.left===0&&e.top===0&&e.height===0&&e.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=window.document.getElementById(this._oLastPosition.of.id);t=this._getOfDom(this._oLastPosition.of);e=jQuery(t).rect();if(!e){this.close();return}}if(this._oLastOfRect){if(!H(this._oLastOfRect,e)){if(this._followOfHandler){var s=E({},this._oLastPosition),n=E({},this._oLastOfRect);this._followOfHandler({lastPosition:s,lastOfRect:n,currentOfRect:e})}else{this._applyPosition(this._oLastPosition)}}}}};U.prototype.ontouchstart=function(t){this.onmousedown(t,true);this._bMousedownCalled=true};U.prototype.onmousedown=function(t,e){if(this._bMousedownCalled&&!e){this._bMousedownCalled=false;return}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return}this._increaseMyZIndex("","mousedown",t)};U.prototype._increaseMyZIndex=function(t,e,i){var o=this.getParentPopup(this._oLastPosition.of);if(i&&i.type==="mousedown"||i&&i.isFromParentPopup||o.length===0){this._iZIndex=this.getNextZIndex();var s=this._$(false,true);s.css("z-index",this._iZIndex);if(i&&!i.type||i&&i.type!="mousedown"||e==="mousedown"){var n=this.getChildPopups();for(var r=0,a=n.length;r<a;r++){this.increaseZIndex(n[r],true)}}}else if(o.length>0){var l=jQuery(o.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(l,false)}};U.prototype.onAfterRendering=function(){var t=this.getContent();var e=t instanceof a?t.$():jQuery(t);e.toggleClass("sapUiShd",this._bShadow);U._clearSelection();this._setupUserSelection();e.css("position","absolute");this._setIdentity(e);var i=e[0];var o=i.style.left;var s=i.style.right;var n=i.style.top;var r=i.style.bottom;if(!(o&&o!="auto"||s&&s!="auto"||n&&n!="auto"||r&&r!="auto")){m.debug("reposition popup content "+e.attr("id")+" at "+JSON.stringify(this._oLastPosition.at));this._applyPosition(this._oLastPosition)}e.show().css({visibility:"visible","z-index":this._iZIndex});if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners()}this._$(false,true).on("keydown",this._F6NavigationHandler)};U.prototype.onBeforeRendering=function(){if(this._resizeListenerId){p.deregister(this._resizeListenerId);this._resizeListenerId=null}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners()}this._$(false,true).off("keydown",this._F6NavigationHandler)};U.prototype.isInPopup=function(t){var e=this.getParentPopup(t);return e&&e.length>0};U.prototype.getParentPopup=function(t){var e=t?t:this;var i=jQuery(e instanceof a?e.getDomRef():e);return i.closest("[data-sap-ui-popup]")};U.prototype.getParentPopupId=function(t){var e=this.getParentPopup(t);return e.attr("data-sap-ui-popup")};U.prototype.addChildToPopup=function(t,e){var i="sap.ui.core.Popup.addFocusableContent-"+t;R.publish("sap.ui",i,{id:e})};U.prototype.removeChildFromPopup=function(t,e){var i="sap.ui.core.Popup.removeFocusableContent-"+t;R.publish("sap.ui",i,{id:e})};U.prototype.closePopup=function(t){var e="sap.ui.core.Popup.closePopup-"+t;R.publish("sap.ui",e)};U.prototype.increaseZIndex=function(t,e){var i="sap.ui.core.Popup.increaseZIndex-"+t;R.publish("sap.ui",i,{isFromParentPopup:e?e:false})};U.prototype.focusTabChain=function(t){var e=t.event.target,i=t.that.getMetadata().getName(),o;if(!t.$FocusablesContent||!t.$FocusablesFooter||!t.$FocusablesContent.length&&!t.$FocusablesFooter.length){return}if(e.id===t.firstFocusable){m.debug("First dummy focus element was focused","",i);if(t.$FocusablesFooter.length>0){m.debug("Last footer element will be focused","",i);o=t.$FocusablesFooter[t.$FocusablesFooter.length-1]}else{m.debug("Last content element will be focused","",i);o=t.$FocusablesContent[t.$FocusablesContent.length-1]}}else if(e.id===t.lastFocusable){m.debug("Last dummy focus element was focues","",i);if(t.$FocusablesContent.length>0){m.debug("First content element will be focused","",i);o=t.$FocusablesContent[0]}else{m.debug("First footer element will be focused","",i);o=t.$FocusablesFooter[0]}}if(o){setTimeout(function(){var t=a.getElementById(o.id);if(t instanceof r){m.debug("Focus will be handled by "+t.getMetadata().getName(),"",i)}else{m.debug("oFocusDomRef will be focused","",i)}if(t){t.focus()}else if(o){o.focus()}return t?t.getId():o.id},0)}};U.prototype._setupUserSelection=function(){var t=this._$(false,true);U._markAsUserSelectable(t,this._bModal||U.blStack.length>0);if(this._bModal){if(U.blStack.length>0){var e=U.blStack[U.blStack.length-1];var i=function(t){return t.popup.getId()};if(U.blStack.map(i).indexOf(this.getId())===-1){U._markAsNotUserSelectable(e.popup._$(false,true),true)}else if(e.popup.getId()!==this.getId()){U._markAsNotUserSelectable(t,true)}}else{U._markAsNotUserSelectable(jQuery("html"),true);U._markExternalContentAsUserSelectable(true)}}};U.prototype._restoreUserSelection=function(){var t=this._$(false,true);U._markAsNotUserSelectable(t,false);if(U.blStack.length>0){U._markAsUserSelectable(U.blStack[U.blStack.length-1].popup._$(false,true),true)}else{U._markAsUserSelectable(jQuery("html"),false);U._markExternalContentAsNotUserSelectable(false)}};U._clearSelection=function(){var t=document.getSelection();if(!t.isCollapsed){t.removeAllRanges()}};U._markAsUserSelectable=function(t,e){t.removeClass("sapUiNotUserSelectable");if(e){t.addClass("sapUiUserSelectable")}};U._markAsNotUserSelectable=function(t,e){t.removeClass("sapUiUserSelectable");if(e){t.addClass("sapUiNotUserSelectable")}};var G=new Set,W="[data-sap-ui-integration-popup-content]";G.add(W);U.addExternalContent=function(t,e){if(!Array.isArray(t)){t=[t]}t.forEach(Set.prototype.add.bind(G));if(e){U.markExternalContentAsSelectable()}};U.removeExternalContent=function(t,e){if(!Array.isArray(t)){t=[t]}if(e){U.markExternalContentAsNotSelectable()}t.forEach(function(t){if(t!==W){G.delete(t)}})};U.markExternalContentAsSelectable=function(){U._clearSelection();if(U.blStack.length>0){U._markExternalContentAsUserSelectable(true)}};U.markExternalContentAsNotSelectable=function(){U._clearSelection();if(U.blStack.length>0){U._markExternalContentAsNotUserSelectable(false)}};U._getExternalContent=function(){var t=[];if(G.size>0){G.forEach(function(e){var i=jQuery(e);if(i.length>0){t.push(i)}})}return t};U._markExternalContentAsUserSelectable=function(t){var e=U._getExternalContent();e.forEach(function(e){U._markAsUserSelectable(e,t)})};U._markExternalContentAsNotUserSelectable=function(t){var e=U._getExternalContent();e.forEach(function(e){U._markAsNotUserSelectable(e,t)})};U.setWithinArea=function(t){F=t};U.getWithinArea=function(){return F};U.getWithinAreaDomRef=function(){return T(F)};return U});
//# sourceMappingURL=Popup.js.map