/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./View","./JSONViewRenderer","./ViewType","./EventHandlerResolver","sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/model/resource/ResourceModel","sap/base/Log","sap/base/util/LoaderExtensions"],function(e,t,n,r,i,o,s,a,u){"use strict";var c=e.extend("sap.ui.core.mvc.JSONView",{metadata:{library:"sap.ui.core"},renderer:t});c.create=function(t){var r=i({},t);for(var o in r){if(o==="preprocessors"){delete r["preprocessors"];a.warning("JSONView.create does not support the option preprocessors!")}}r.type=n.JSON;return e.create(r)};sap.ui.jsonview=function(e,t){return sap.ui.view(e,t,n.JSON)};c._sType=n.JSON;c.asyncSupport=true;c.prototype.initViewSettings=function(e){if(!e){throw new Error("mSettings must be given")}if(e.viewName&&e.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.")}else if(!e.viewName&&!e.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.")}var t=this;var n=function(){if((t._oJSONView.resourceBundleName||t._oJSONView.resourceBundleUrl)&&(!e.models||!e.models[t._oJSONView.resourceBundleAlias])){var n=new s({bundleName:t._oJSONView.resourceBundleName,bundleUrl:t._oJSONView.resourceBundleUrl,async:e.async});var r=n.getResourceBundle();if(r instanceof Promise){return r.then(function(){t.setModel(n,t._oJSONView.resourceBundleAlias)})}t.setModel(n,t._oJSONView.resourceBundleAlias)}};if(e.viewName){if(e.async){return this._loadTemplate(e.viewName,{async:true}).then(n)}else{this._loadTemplate(e.viewName);n()}}else if(e.viewContent){this.mProperties["viewContent"]=e.viewContent;if(typeof e.viewContent==="string"){this._oJSONView=JSON.parse(e.viewContent);if(!this._oJSONView){throw new Error("error when parsing viewContent: "+e.viewContent)}}else if(typeof e.viewContent==="object"){this._oJSONView=e.viewContent}else{throw new Error("viewContent must be a JSON string or object, but is a "+typeof e.viewContent)}if(e.async){return Promise.resolve().then(n)}else{n()}}};c.prototype.onControllerConnected=function(e){var t=this;o.runWithPreprocessors(function(){t.applySettings({content:t._oJSONView.content},e)},{id:function(e){return t.createId(e)},settings:function(n){var i=this.getMetadata(),o=i.getJSONKeys(),s,a,u;for(s in n){if((u=o[s])!==undefined){a=n[s];switch(u._iKind){case 3:if(typeof a==="string"){n[s]=t.createId(a)}break;case 5:if(typeof a==="string"){n[s]=r.resolveEventHandler(a,e)}break}}}}})};c.prototype._loadTemplate=function(e,t){var n=e.replace(/\./g,"/")+".view.json";if(!t||!t.async){this._oJSONView=u.loadResource(n)}else{var r=this;return u.loadResource(n,t).then(function(e){r._oJSONView=e})}};c.prototype.getControllerName=function(){return this._oJSONView.controllerName};return c});
//# sourceMappingURL=JSONView.js.map