/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/core/Element","sap/ui/core/ElementMetadata","../Plugin","sap/base/util/LoaderExtensions","sap/base/util/ObjectPath"],function(t,e,a,i,n,o){"use strict";var r=i.extend("sap.ui.core.support.plugins.Breakpoint",{constructor:function(t){i.apply(this,["sapUiSupportBreakpoint","",t]);this._methodType={clazz:1,proto:2};this._mBreakpointData={classes:{},instances:{}};this._idPrefix="id_";this._methodPrefix="method_";this._classPrefix="class_";this._bAlertNoDebugger=false;this._aEventIds=[this.getId()+"RequestInstanceMethods",this.getId()+"ChangeInstanceBreakpoint",this.getId()+"RequestClasses",this.getId()+"RequestClassMethods",this.getId()+"ChangeClassBreakpoint",this.getId()+"RemoveAllClassBreakpoints"]}});r.prototype.isToolPlugin=function(){return false};r.prototype.isAppPlugin=function(){return true};r.prototype.init=function(t){i.prototype.init.apply(this,arguments);window.bp=this;this.requestClasses("sapUiSupportDebuggingReceiveClasses")};r.prototype.onsapUiSupportBreakpointRequestInstanceMethods=function(t){var e=t.getParameter("callback"),a=t.getParameter("controlId");var i=this.getInstanceMethods(a);this._oStub.sendEvent(e,{methods:JSON.stringify(i),breakpointCount:JSON.stringify({active:i.filter(function(t,e){return t.active}).length,all:i.length}),controlId:a})};r.prototype.onsapUiSupportBreakpointChangeInstanceBreakpoint=function(t){var e={controlId:t.getParameter("controlId"),methodName:t.getParameter("methodName"),active:t.getParameter("active")},a=t.getParameter("callback");this.changeInstanceBreakpoint(e.controlId,e.methodName,e.active);var i=this.getInstanceMethods(e.controlId);e.breakpointCount=JSON.stringify({active:i.filter(function(t){return t.active}).length,all:i.length});e.methods=JSON.stringify(i);this._oStub.sendEvent(a,e)};r.prototype.requestClasses=function(t){this._oStub.sendEvent(t,{classes:JSON.stringify(this.getClasses())})};r.prototype.onsapUiSupportBreakpointRequestClasses=function(t){this.requestClasses(t.getParameter("callback"))};r.prototype.onsapUiSupportBreakpointRequestClassMethods=function(t){var e=t.getParameter("callback"),a=t.getParameter("className");var i=this.getClassMethods(a);this._oStub.sendEvent(e,{methods:JSON.stringify(i),breakpointCount:JSON.stringify({active:i.filter(function(t,e){return t.active}).length,all:i.length}),className:a})};r.prototype.onsapUiSupportBreakpointChangeClassBreakpoint=function(t){var e={className:t.getParameter("className"),methodName:t.getParameter("methodName"),active:t.getParameter("active"),type:t.getParameter("type")},a=t.getParameter("callback");this.changeClassBreakpoint(e.className,e.methodName,e.active,e.type);var i=this.getClassMethods(e.className);e.breakpointCount=JSON.stringify({active:i.filter(function(t,e){return t.active}).length,all:i.length});e.methods=JSON.stringify(i);this._oStub.sendEvent(a,e)};r.prototype.onsapUiSupportBreakpointRemoveAllClassBreakpoints=function(t){var e=t.getParameter("className");var a=this._mBreakpointData.classes[this._classPrefix+e];for(var i in a){this.changeClassBreakpoint(e,i.replace(this._methodPrefix,""),false)}};r.prototype.getInstanceMethods=function(t){var a=e.getElementById(t),i=[];if(!a){return i}for(var n in a){if(typeof a[n]!=="function"){continue}i.push({name:n,active:this.isInstanceBreakpointActive(a,n)})}return i.sort(function(t,e){if(t.name<e.name){return-1}else if(t.name>e.name){return 1}else{return 0}})};r.prototype.getClassMethods=function(t){var e=o.get(t);var a=[],i;if(!e){return a}for(i in e){if(typeof e[i]!=="function"){continue}a.push({name:i,type:this._methodType.clazz,active:this.isClassBreakpointActive(t,i)})}function n(t){return a.some(function(e){return e.name===t})}for(i in e.prototype){if(typeof e.prototype[i]!=="function"){continue}if(n(i)){continue}a.push({name:i,type:this._methodType.proto,active:this.isClassBreakpointActive(t,i)})}return a.sort(function(t,e){if(t.name<e.name){return-1}else if(t.name>e.name){return 1}else{return 0}})};r.prototype.getClasses=function(){function t(){var t=[];var e=n.getAllRequiredModules();for(var i=0;i<e.length;i++){if(t.indexOf(e[i])>-1){continue}var r=o.get(e[i]);if(typeof r==="undefined"||r===null){continue}if(typeof r.getMetadata==="function"&&r.getMetadata()instanceof a){t.push(r.getMetadata().getName())}}return t}return t().sort()};r.prototype.changeInstanceBreakpoint=function(t,a,i){var n=e.getElementById(t);if(!n||!a||!n[a]){return}if(this.isInstanceBreakpointActive(n,a)===i){return}if(i){this.applyInstanceMethodHook(t,n,a)}else{this.removeInstanceMethodHook(t,n,a)}};r.prototype.changeClassBreakpoint=function(t,e,a,i){var n=o.get(t);if(!n||!e){return}if(this.isClassBreakpointActive(t,e)===a){return}if(a){this.applyClassMethodHook(t,n,e,i)}else{this.removeClassMethodHook(t,n,e)}};r.prototype.getInstanceBreakpointData=function(t,e){if(typeof e==="undefined"){e=false}var a=this._mBreakpointData.instances[this._classPrefix+t.getMetadata().getName()];if(!a){if(e){this._mBreakpointData.instances[this._classPrefix+t.getMetadata().getName()]=a={}}else{return null}}var i=a[this._idPrefix+t.getId()];if(!i){if(e){a[this._idPrefix+t.getId()]=i={}}else{return null}}return i};r.prototype.getClassBreakpointData=function(t,e){if(typeof e==="undefined"){e=false}var a=this._mBreakpointData.classes[this._classPrefix+t];if(!a){if(e){this._mBreakpointData.classes[this._classPrefix+t]=a={}}else{return null}}return a};r.prototype.isInstanceBreakpointActive=function(t,e){var a=this.getInstanceBreakpointData(t);if(!a){return false}var i=a[this._methodPrefix+e];if(!i){return false}return i.active};r.prototype.isClassBreakpointActive=function(t,e){var a=this.getClassBreakpointData(t);if(!a){return false}var i=a[this._methodPrefix+e];if(!i){return false}return i.active};r.prototype.applyInstanceMethodHook=function(t,e,a){var i=this.getInstanceBreakpointData(e,true),n=i[this._methodPrefix+a]||(i[this._methodPrefix+a]={});n.originalMethod=e[a];n.active=true;e[a]=this.methodHook(n.originalMethod)};r.prototype.removeInstanceMethodHook=function(t,e,a){var i=this.getInstanceBreakpointData(e,true),n=i[this._methodPrefix+a];e[a]=n.originalMethod;delete n.originalMethod;n.active=false};r.prototype.applyClassMethodHook=function(t,e,a,i){var n=this.getClassBreakpointData(t,true),o=n[this._methodPrefix+a]||(n[this._methodPrefix+a]={});if(i===this._methodType.clazz){o.originalMethod=e[a];e[a]=this.methodHook(o.originalMethod)}else{o.originalMethod=e.prototype[a];e.prototype[a]=this.methodHook(o.originalMethod)}o.type=i;o.active=true};r.prototype.removeClassMethodHook=function(t,e,a){var i=this.getClassBreakpointData(t,true),n=i[this._methodPrefix+a];if(n.type===this._methodType.clazz){e[a]=n.originalMethod}else{e.prototype[a]=n.originalMethod}delete n.originalMethod;n.active=false};r.prototype.methodHook=function(t){var e=this;return function(){var a=Date.now();debugger;if(Date.now()-a<50){e._alertNoDebugger()}return t.apply(this,arguments)}};r.prototype._alertNoDebugger=function(){if(this._bAlertNoDebugger){return}var e=null;if(t.browser.chrome){e="Please open your debugger by pressing CTRL + SHIFT + I."}if(e==null){e="Please open your debugger."}this._bAlertNoDebugger=true;alert("There is no debugger attached.\n\n"+e)};return r});
//# sourceMappingURL=Breakpoint.js.map