/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/base/util/isPlainObject"],function(t,e){"use strict";var s=t.extend("sap.ui.dt.TaskManager",{metadata:{library:"sap.ui.dt",properties:{suppressEvents:{type:"boolean",defaultValue:false}},events:{add:{parameters:{taskId:"int"}},complete:{parameters:{taskId:"array"}}}},constructor:function(...e){t.apply(this,e);this._mQueuedTasks={};this._mPendingTasks={}},_iNextId:0,_iTaskCounter:0});function i(t){if(!e(t)||!t.type||typeof t.type!=="string"){throw new Error("Invalid task specified")}}function n(t){var e;if(typeof t==="string"){e=function(e){return e[t]}}else if(typeof t==="function"){e=t}else{throw new Error("Validator needs to be a function or a string")}return e}function r(t,e,s){if(t(s)===e){this._iTaskCounter--;return false}return true}s.prototype._removeTasksByIdentifier=function(t,e,s){if(e){var i=n(e);var u=i(t);if(this[s][t.type]&&u){this[s][t.type]=this[s][t.type].filter(r.bind(this,i,u))}}};s.prototype._removeTaskById=function(t,e){Object.keys(this[e]).forEach(function(s){this[e][s]=this[e][s].filter(function(e){if(e.id===t){this._iTaskCounter--;return false}return true}.bind(this))},this)};s.prototype._addTask=function(t){var e=this._iNextId++;this._mQueuedTasks[t.type]||=[];this._mQueuedTasks[t.type].push(Object.assign({},t,{id:e}));this._iTaskCounter++;if(!this.getSuppressEvents()){this.fireAdd({taskId:e})}return e};s.prototype.add=function(t,e){i(t);this._removeTasksByIdentifier(t,e,"_mQueuedTasks");return this._addTask(t)};s.prototype.complete=function(t){this._removeTaskById(t,"_mQueuedTasks");this._removeTaskById(t,"_mPendingTasks");if(!this.getSuppressEvents()){this.fireComplete({taskId:[t]})}};s.prototype.completeBy=function(t){i(t);var e=[];var s=function(s){return(s||[]).filter(function(s){var i=Object.keys(t).every(function(e){return s[e]&&s[e]===t[e]});if(i){this._iTaskCounter--;e.push(s.id);return false}return true}.bind(this))}.bind(this);this._mQueuedTasks[t.type]=s(this._mQueuedTasks[t.type]);this._mPendingTasks[t.type]=s(this._mPendingTasks[t.type]);if(!this.getSuppressEvents()){this.fireComplete({taskId:e})}};s.prototype.cancel=function(t){this.complete(t)};s.prototype.cancelBy=function(t,e){this._removeTasksByIdentifier(t,e,"_mQueuedTasks");this._removeTasksByIdentifier(t,e,"_mPendingTasks")};s.prototype.isEmpty=function(){return this._iTaskCounter===0};s.prototype.count=function(t){return this.getList(t).length};s.prototype._markAsPending=function(t,e){this._mPendingTasks[t]=(this._mPendingTasks[t]||[]).concat(e);this._mQueuedTasks[t]=[]};s.prototype._getTypedList=function(t,e){var s=[];if(this._mQueuedTasks[t]){s=this._mQueuedTasks[t].slice(0)}if(e){this._markAsPending(t,s)}else if(this._mPendingTasks[t]){s=s.concat(this._mQueuedTasks[t].slice(0))}return s};s.prototype._getAllTasks=function(t){var e=[];e=Object.keys(this._mQueuedTasks).reduce(function(e,s){e=e.concat(this._mQueuedTasks[s]);if(t){this._markAsPending(s,this._mQueuedTasks[s])}return e}.bind(this),[]);if(!t){e=e.concat(Object.keys(this._mPendingTasks).reduce(function(t,e){return t.concat(this._mPendingTasks[e])}.bind(this),[]))}return e};s.prototype.getList=function(t){if(t){return this._getTypedList(t,false)}return this._getAllTasks(false)};s.prototype.getQueuedTasks=function(t){if(t){return this._getTypedList(t,true)}return this._getAllTasks(true)};s.prototype.destroy=function(...e){this.setSuppressEvents(true);this.getList().forEach(function(t){this.cancel(t.id)},this);t.prototype.destroy.apply(this,e)};return s});
//# sourceMappingURL=TaskManager.js.map