/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/deepClone","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/base/util/restricted/_omit","sap/ui/base/ManagedObject","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/Layer","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(t,e,a,n,r,o,i,s,p,u){"use strict";var c=o.extend("sap.ui.fl.apply._internal.flexObjects.FlexObject",{metadata:{properties:{adaptationId:{type:"string"},state:{type:"string",defaultValue:i.LifecycleState.NEW},fileType:{type:"string",defaultValue:"change"},layer:{type:"string"},flexObjectMetadata:{type:"object",defaultValue:{}},supportInformation:{type:"object",defaultValue:{}},content:{type:"any",defaultValue:{}},texts:{type:"object",defaultValue:{}}}},constructor:function(...t){o.apply(this,t);var e=this.getFlexObjectMetadata();var a=e.reference;if(a){e.reference=a.endsWith(".Component")?a.replace(/\.Component(?!.*\.Component)/,""):a;e.namespace||=u.createNamespace({reference:a},this.getFileType());e.projectId||=a}this.setFlexObjectMetadata(e);var n=this.getSupportInformation();n.originalLanguage||=u.getCurrentLanguage();this.setSupportInformation(n)}});c.getMappingInfo=function(){return Object.assign({},{"flexObjectMetadata.changeType":"changeType","flexObjectMetadata.reference":"reference","flexObjectMetadata.namespace":"namespace","flexObjectMetadata.creation":"creation","flexObjectMetadata.projectId":"projectId","flexObjectMetadata.packageName":"packageName","flexObjectMetadata.moduleName":"moduleName","supportInformation.generator":"support.generator","supportInformation.clonedFrom":"support.clonedFrom","supportInformation.service":"support.service","supportInformation.sourceSystem":"sourceSystem","supportInformation.sourceClient":"sourceClient","supportInformation.user":"support.user","supportInformation.sapui5Version":"support.sapui5Version","supportInformation.sourceChangeFileName":"support.sourceChangeFileName","supportInformation.compositeCommand":"support.compositeCommand","supportInformation.command":"support.command","supportInformation.oDataInformation":"oDataInformation","supportInformation.originalLanguage":"originalLanguage",adaptationId:"adaptationId",layer:"layer",fileType:"fileType",id:"fileName",content:"content",texts:"texts"})};c.prototype.getMappingInfo=function(){return c.getMappingInfo()};c.prototype.setContent=function(t,e){this.setProperty("content",t);if(!e){this.setState(i.LifecycleState.DIRTY)}return this};c.prototype.getFlexObjectMetadata=function(){return Object.assign({},this.getProperty("flexObjectMetadata"))};c.prototype.getSupportInformation=function(){return Object.assign({},this.getProperty("supportInformation"))};function f(t,e){if(!Object.values(i.LifecycleState).includes(t)){return false}if(e===i.LifecycleState.NEW&&t===i.LifecycleState.DIRTY){return false}return true}c.prototype.setState=function(t){var e=this.getState();if(e!==t&&f(t,e)){this._sPreviousState=e;this.setProperty("state",t)}return this};c.prototype.isPersisted=function(){return this.getState()===i.LifecycleState.PERSISTED};c.prototype.markForDeletion=function(){this.setState(i.LifecycleState.DELETED)};c.prototype.restorePreviousState=function(){if(this._sPreviousState){this.setState(this._sPreviousState);delete this._sPreviousState}};c.prototype.isChangeFromOtherSystem=function(){var t=this.getSupportInformation().sourceSystem;var e=this.getSupportInformation().sourceClient;if(!t||!e){return false}var a=p.getInstanceOrUndef();if(!a){return true}var n=a.getSystem();var r=a.getClient();if(!n||!r){return false}return t!==n||e!==r};c.prototype.getNamespace=function(){return this.getFlexObjectMetadata().namespace};c.prototype.getChangeType=function(){return this.getFlexObjectMetadata().changeType};c.prototype.isUserDependent=function(){return this.getLayer()===s.USER};c.prototype.getText=function(t){var e=this.getTexts()[t]||{};return e.value||""};c.prototype.setText=function(t,e,a,n){var r=Object.assign({},this.getTexts());var o={value:e};if(a){o.type=a}r[t]=Object.assign({},r[t],o);this.setTexts(r);if(!n){this.setState(i.LifecycleState.DIRTY)}return this};c.prototype.setRequest=function(t){this._sRequest=t};c.prototype.getRequest=function(){return this._sRequest||""};c.prototype.getDefinition=function(){return this.convertToFileContent()};c.prototype.getCreation=function(){return this.getFlexObjectMetadata().creation};c.prototype.setCreation=function(t){var e=this.getFlexObjectMetadata();e.creation=t;this.setFlexObjectMetadata(e)};function l(t){return t.length?t.charAt(0).toUpperCase()+t.slice(1):t}function g(t){return typeof this[t]==="function"?this[t].bind(this):function(){throw new Error(`${t} is not a valid mutator`)}}function h(e){var a=e.split(".");a[0]=l(a[0]);var r=a.shift();var o=g.call(this,`get${r}`);var i=g.call(this,`set${r}`);return{getValue(){var e=t(o());if(a.length>0){return n.get(a,e)}return e},setValue:function(e){var r=t(o());if(a.length>0){n.set(a,e,r)}else{r=e}i(r);return this}.bind(this)}}c.prototype.convertToFileContent=function(){var t={};Object.entries(this.getMappingInfo()).forEach(function(e){var a=h.call(this,e[0]).getValue();if(a!==undefined){n.set(e[1],a,t)}}.bind(this));return t};function y(t,e){var a=h.call(this,t);var n=a.getValue();if(n!==e){a.setValue(e)}}c.mapFileContent=function(e,n){var r=Object.values(n);var o={};var i=function(t,e,s){var p=s?`${s}.${t}`:t;var u=r.indexOf(p);if(u>=0){var c=Object.keys(n)[u];o[c]=e}else if(a(e)){Object.entries(e).forEach(function(t){i(t[0],t[1],p)})}};Object.entries(t(e,15)).forEach(function(t){i(t[0],t[1])});return o};c.prototype.update=function(t){var e=r(t,["fileName"]);var a=c.mapFileContent(e,this.getMappingInfo());Object.entries(a).forEach(function(t){y.call(this,t[0],t[1])}.bind(this))};c.prototype.setResponse=function(t){if(!t||e(t)){return}this.update(t);this.setState(i.LifecycleState.PERSISTED)};c.prototype.cloneFileContentWithNewId=function(){var t=this.convertToFileContent();t.fileName=u.createDefaultFileName(t.fileName.split("_").pop());t.support.clonedFrom=this.getId();return t};return c});
//# sourceMappingURL=FlexObject.js.map