/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/Title","sap/m/Select","sap/m/ComboBox","sap/m/Popover","sap/m/Button","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/ui/core/ListItem","sap/m/VBox","sap/base/util/each","sap/base/util/restricted/_debounce","sap/ui/core/Core","sap/base/util/deepClone"],function(e,t,a,n,s,i,r,l,o,u,g,p,d,c,v,h){"use strict";var _=/parameters\.([^\}\}]+)/g;var f=["TODAY_ISO","NOW_ISO","LOCALE"];var T=e.extend("sap.ui.integration.editor.fields.StringField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});T.prototype.initVisualization=function(e){var n=e.visualization;var r;if(!n){var l=e.value?e.value.match(_):undefined;var o,u,p;if(l&&l.length>0){l=l.filter(function(e){var t=e.substring(11);return!f.includes(t)})}if(l&&l.length>0){o=l.map(function(e){if(this.isOrigLangField){return"items>"+e.substring(11)+"/_language/value"}return"items>"+e.substring(11)+"/value"}.bind(this));o.unshift("currentSettings>value");u={parts:o,formatter:function(e){var t=Array.prototype.slice.call(arguments,1);for(var a=0;a<t.length;a++){if(t[a]){e=e.replaceAll("{{"+l[a]+"}}",t[a])}}return e}};p=function(e){var t=e.getSource().getValue();var a=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(a+"/value",t);var n=this._settingsModel.getBindings();var s=a.substring(a.lastIndexOf("/")+1);d(n,function(e,t){if(t.sPath==="/form/items/"+s+"/value"){t.checkUpdate(true)}})}.bind(this)}if(this.getMode()==="translation"){if(e.editable){n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder}}}else{n={type:a,settings:{text:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},visible:e.visible,wrapping:false}}}}else if(e.enum){r=new g({key:{path:"currentSettings>"},text:{path:"currentSettings>"}});n={type:s,settings:{selectedKey:{path:"currentSettings>value"},forceSelection:false,editable:e.editable,visible:e.visible,showSecondaryValues:false,width:"100%",items:{path:"currentSettings>enum",template:r}}}}else if(e.values){r=this.formatListItem(e.values.item);if(!e.values.item.key){e.values.item.key=e.values.item.text}n={type:i,settings:{busy:{path:"currentSettings>_loading"},selectedKey:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:r}}};if(this.isFilterBackend()){n.settings.selectedKey={parts:["currentSettings>value","currentSettings>suggestValue"],formatter:function(e,t){if((!e||e==="")&&t){return t.replaceAll("''","'")}else{return e}}}}}else if(this.getMode()!=="translation"&&e.translatable){n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder,valueHelpIconSrc:"sap-icon://translate",showValueHelp:true,valueHelpRequest:this.openTranslationListPopup.bind(this),change:function(t){var a=t.getSource();var n=a.getValue();var s=v.getConfiguration().getLanguage().replaceAll("_","-");a.getParent().setTranslationValueInTexts(s,e.manifestpath,n)}}};if(o){delete n.settings.tooltip;n.settings.value=u;n.settings.change=p;n.settings.showValueHelp=false;delete n.settings.valueHelpRequest}}else{n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder}};if(o){delete n.settings.tooltip;n.settings.value=u;n.settings.change=p}}}else if(n.type==="TextArea"){n.type="sap/m/TextArea"}else if(n.type==="Select"&&e.values){r=this.formatListItem(e.values.item);var c=Object.assign({selectedKey:{path:"currentSettings>value"},forceSelection:false,editable:e.editable,visible:e.visible,showSecondaryValues:false,width:"100%",items:{path:"",template:r}},n.settings||{});n={type:s,settings:c}}this._visualization=n;this.attachAfterInit(this._afterInit)};T.prototype._afterInit=function(){var e=this.getAggregation("_field");if(e instanceof i){if(this.isFilterBackend()){this.onInput=c(this.onInput,500);e.oninput=this.onInput.bind(this);e.attachSelectionChange(this.onSelectionChange.bind(this))}}};T.prototype.onSelectionChange=function(e){var t=e.getParameter("selectedItem")||{};var a=t.getKey();var n=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(n+"/value",a)};T.prototype.onInput=function(e){var t=e.target.value;var a=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(a+"/suggestValue",t.replaceAll("'","''"));this._settingsModel.setProperty(a+"/_loading",true);this._settingsModel.setProperty(a+"/value","");var n=this._settingsModel.getBindings();var s=a.substring(a.lastIndexOf("/")+1);d(n,function(e,t){if(t.sPath==="/form/items/"+s+"/value"){t.checkUpdate(true)}});var i=e.srcControl;i.open();i.setValue(t);i.setSelection(null)};T.prototype.getOriginTranslatedValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();var n;if(e._translatedDefaultPlaceholder&&e._translatedDefaultPlaceholder.startsWith("{i18n>")&&e._translatedDefaultPlaceholder.endsWith("}")){n=e._translatedDefaultPlaceholder.substring(6,e._translatedDefaultPlaceholder.length-1)}else if(e._translatedDefaultPlaceholder&&e._translatedDefaultPlaceholder.startsWith("{{")&&e._translatedDefaultPlaceholder.endsWith("}}")){n=e._translatedDefaultPlaceholder.substring(2,e._translatedDefaultPlaceholder.length-2)}for(var s in a){var i=a[s];var r="";var l="";if(n&&i){var o=i.resourceBundle&&i.resourceBundle.getText(n,[],true);if(o!==undefined){r=o;l=o}else{r=e._translatedValue||"";l=e._translatedValue||""}}else{r=e._translatedDefaultPlaceholder||"";l=e._translatedDefaultPlaceholder||""}var u={key:s,description:i.language,value:r,originValue:l,editable:true};t.push(u)}return t};T.prototype.getTranslationValueInTexts=function(e,t){var a="/texts/"+e;var n=this._settingsModel.getProperty(a)||{};return n[t]};T.prototype.setTranslationValueInTexts=function(e,t,a){var n="/texts";var s=this._settingsModel.getData();if(!s){return}if(!s.hasOwnProperty("texts")){var i={};i[e]={};i[e][t]=a;this._settingsModel.setProperty(n,i)}else{n="/texts/"+e;var r;if(!s.texts.hasOwnProperty(e)){r={}}else{r=s.texts[e]}r[t]=a;this._settingsModel.setProperty(n,r)}};T.prototype.openTranslationListPopup=function(e){var s=this;var i=e.getSource();var g=i.getParent();var d=g.getParameterId();var c=g.getConfiguration();var v=g.getResourceBundle();var h=s.buildTranslationsData(g,i);var _;var f=g.getPopoverPlacement(i._oValueHelpIcon);if(!s._oTranslationPopover){var T=s.buildTranslationsList(d+"_translation_popover_value_list");s._oTranslationPopover=new r(d+"_translation_popover",{placement:f,contentWidth:"300px",contentHeight:"345px",customHeader:new p({items:[new n({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_TITLE")}).addStyleClass("sapMPopoverTitle"),new n({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")}).addStyleClass("sapMHeaderTitle"),new p({items:[new a(d+"_translation_popover_currentlanguage_description_label",{text:"{languages>/currentLanguage/description}"}),new t(d+"_translation_popover_currentlanguage_value_input",{value:"{languages>/currentLanguage/value}",editable:false})]}).addStyleClass("sapMCurrentLanguageVBox"),new n({text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_OTHERLANGUAGES")}).addStyleClass("sapMHeaderTitle")]}),content:T,footer:new o({content:[new u,new l(d+"_translation_popover_save_btn",{type:"Emphasized",text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var e=s._oTranslationPopover.getModel("languages").getData();var t=[];e.translatedLanguages.forEach(function(e){if(e.value!==e.originValue){g.setTranslationValueInTexts(e.key,c.manifestpath,e.value);t.push(e.key)}});if(e.currentLanguage.value!=e.currentLanguage.originValue){g.setTranslationValueInTexts(e.currentLanguage.key,c.manifestpath,e.currentLanguage.value);t.push(e.currentLanguage.key)}if(t.length>0){s._aUpdatedLanguages=t}s._oTranslationPopover.close()}}),new l(d+"_translation_popover_cancel_btn",{text:v.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),press:function(){s._oTranslationPopover.close()}})]})}).addStyleClass("sapUiIntegrationFieldTranslation");_=s.buildTranslationsModel(h);s._oTranslationPopover.setModel(_,"languages")}else{s._oTranslationPopover.setPlacement(f);_=s._oTranslationPopover.getModel("languages");_.setData(h);_.checkUpdate(true)}s._oTranslationPopover.openBy(i._oValueHelpIcon)};T.prototype.buildTranslationsData=function(e,t){var a=this;var n=e.getConfiguration();if(!a._aOriginTranslatedValues){a._aOriginTranslatedValues=e.getOriginTranslatedValues(n)}var s=h(a._aOriginTranslatedValues,500);var i=e.getResourceBundle();s.forEach(function(t){var s=e.getTranslationValueInTexts(t.key,n.manifestpath);if(s){t.value=s;if(Array.isArray(a._aUpdatedLanguages)&&!a._aUpdatedLanguages.includes(t.key)){t.originValue=t.value}}else if(n._beforeLayerChange){t.value=n._beforeLayerChange;if(Array.isArray(a._aUpdatedLanguages)&&!a._aUpdatedLanguages.includes(t.key)){t.originValue=t.value}}t.status=i.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");if(t.key===i.sLocale.replaceAll("_","-")){t.editable=false}});var r={currentLanguage:{},isUpdated:false,translatedLanguages:[]};if(s){s.forEach(function(s){if(Array.isArray(a._aUpdatedLanguages)&&a._aUpdatedLanguages.includes(s.key)){s.value=e.getTranslationValueInTexts(s.key,n.manifestpath);s.status=i.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED")}if(s.key===i.sLocale.replaceAll("_","-")){s.value=t.getValue();r.currentLanguage=s}else{r.translatedLanguages.push(s)}})}return r};return T});
//# sourceMappingURL=StringField.js.map