/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/integration/util/Measurement"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.util.DataProvider",{metadata:{library:"sap.ui.integration",properties:{settings:{type:"object"},settingsJson:{type:"string"},baseRuntimeUrl:{type:"string"}},events:{dataRequested:{parameters:{}},dataChanged:{parameters:{data:{type:"object"}}},error:{parameters:{message:{type:"string"}}}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});i.prototype.init=function(){this._iCurrentRequestNumber=0};i.prototype.setDestinations=function(t){this._oDestinations=t};i.prototype.setCsrfTokenHandler=function(t){this._oCsrfTokenHandler=t};i.prototype.setDependencies=function(t){this._aDependencies=t};i.prototype.setSettingsJson=function(t){this.setProperty("settingsJson",t);this.setSettings(JSON.parse(t));if(this._bActive){this._scheduleDataUpdate(0)}};i.prototype._getRuntimeUrl=function(t){if(t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//")){return t}var e=t&&t.trim().replace(/^\//,"");return this.getBaseRuntimeUrl()+e};i.prototype.triggerDataUpdate=function(){var t,e;this.fireDataRequested();t=this._waitDependencies();e=t.then(this._triggerDataUpdate.bind(this));if(!this._pInitialRequestPromise){this._pInitialRequestPromise=e}return e};i.prototype._triggerDataUpdate=function(){var t=this.getCard(),i;this._bActive=true;this._iCurrentRequestNumber++;if(t){i="UI5 Integration Cards "+t+" "+this.getId()+" getData#"+this._iCurrentRequestNumber;e.start(i,this.getDetails())}return this.getData().then(function(a){if(t){e.end(i)}this.fireDataChanged({data:a});this.onDataRequestComplete()}.bind(this)).catch(function(a){if(t){e.end(i)}if(Array.isArray(a)&&a.length>0){this.fireError({message:a[0],response:a[1],responseText:a[2],settings:a[3]})}else{this.fireError({message:a})}this.onDataRequestComplete()}.bind(this))};i.prototype.getData=function(){var t=this.getSettings();return new Promise(function(e,i){if(t.json){e(t.json)}else{i("Could not get card data.")}})};i.prototype.destroy=function(){if(this._iIntervalId){clearInterval(this._iIntervalId);this._iIntervalId=null}if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId);this._iDataUpdateCallId=null}t.prototype.destroy.apply(this,arguments)};i.prototype.getInitialRequestPromise=function(){return this._pInitialRequestPromise};i.prototype.onDataRequestComplete=function(){var t;var e=this.getSettings();if(!e||!e.updateInterval){return}t=parseInt(e.updateInterval);if(isNaN(t)){return}this._scheduleDataUpdate(t*1e3)};i.prototype._scheduleDataUpdate=function(t){if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId)}this._iDataUpdateCallId=setTimeout(this.triggerDataUpdate.bind(this),t)};i.prototype._waitDependencies=function(){var t=this._aDependencies||[],e=[];t.forEach(function(t){e.push(t.getInitialRequestPromise())});return Promise.all(e)};i.prototype.getDetails=function(){return"Static JSON data provided in the manifest."};return i});
//# sourceMappingURL=DataProvider.js.map