/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CardRenderer","../cards/Footer","../controls/ActionsToolbar","../controls/BlockingMessage","sap/ui/base/Interface","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/library","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/base/util/each","sap/ui/integration/util/DataProviderFactory","sap/ui/model/json/JSONModel","sap/ui/integration/model/ObservableModel","sap/ui/model/resource/ResourceModel","sap/ui/integration/model/ContextModel","sap/f/CardBase","sap/f/library","sap/ui/integration/library","sap/ui/integration/util/Destinations","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/ErrorHandler","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/cards/filters/FilterBarFactory","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/util/CardObserver","sap/m/IllustratedMessageType","sap/ui/integration/util/Utils","sap/ui/integration/util/ParameterMap","sap/ui/integration/util/Measurement"],function(t,e,i,a,r,jQuery,s,n,o,d,h,f,g,l,p,c,u,_,y,C,v,M,m,P,A,D,b,R,E,S,T,I,w,F,L,O){"use strict";var x={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",FOOTER:"/sap.card/footer",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations",CSRF_TOKENS:"/sap.card/configuration/csrfTokens",FILTERS:"/sap.card/configuration/filters",NO_DATA_MESSAGES:"/sap.card/configuration/messages/noData",MODEL_SIZE_LIMIT:"/sap.card/configuration/modelSizeLimit"};var B=["visibleItems","allItems"];var N=v.cards.HeaderPosition;var H=M.CardArea;var k=M.CardDataMode;var V=M.CardDesign;var z=M.CardDisplayVariant;var U=M.CardPreviewMode;var W=M.CardBlockingMessageType;var q="Card is destroyed!";var j="module:";var J=n.MessageType;var G=1e3;var Y=C.extend("sap.ui.integration.widgets.Card",{metadata:{library:"sap.ui.integration",properties:{referenceId:{type:"string",defaultValue:""},manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:k.Auto},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]"},useMockData:{type:"boolean",defaultValue:false,visibility:"hidden"},design:{type:"sap.ui.integration.CardDesign",group:"Appearance",defaultValue:V.Solid},displayVariant:{type:"sap.ui.integration.CardDisplayVariant",group:"Appearance",defaultValue:z.Standard},previewMode:{type:"sap.ui.integration.CardPreviewMode",group:"Behavior",defaultValue:U.Off}},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true,forwarding:{getter:"_getActionsToolbar",aggregation:"actionDefinitions"}},_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.integration.cards.filters.FilterBar",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_footer:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},configurationChange:{parameters:{changes:{type:"object"}}},manifestReady:{},manifestApplied:{},stateChanged:{}},associations:{host:{},openerReference:{visibility:"hidden"}}},renderer:t});Y.prototype.init=function(){C.prototype.init.call(this);this.setAggregation("_loadingProvider",new P);this._oIntegrationRb=s.getLibraryResourceBundle("sap.ui.integration");this._iModelSizeLimit=G;this._initModels();this._oContentFactory=new D(this);this._oCardObserver=new I(this);this._aSevereErrors=[];this._sPerformanceId="UI5 Integration Cards "+this.getId()+" ";this._aActiveLoadingProviders=[];this._fnOnDataReady=function(){this._bDataReady=true}.bind(this);this._fireStateChangedBound=this._fireStateChanged.bind(this);this._oLimitedInterface=new r(this,["getDomRef","setVisible","getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","refresh","refreshData","showMessage","getBaseUrl","getRuntimeUrl","getTranslatedText","getModel","triggerAction","addActionDefinition","removeActionDefinition","insertActionDefinition","getActionDefinition","indexOfActionDefinition","destroyActionDefinition","showLoadingPlaceholders","hideLoadingPlaceholders","showCard","hide","getOpener","validateControls","showBlockingMessage","hideBlockingMessage","getBlockingMessage"])};Y.prototype._initModels=function(){this._INTERNAL_MODELS={default:{init:()=>this.setModel(new c),reset:()=>this.getModel().setData({})},parameters:{init:()=>this.setModel(new c(L.getParamsForModel()),"parameters")},filters:{init:()=>this.setModel(new c,"filters"),reset:()=>this.getModel("filters").setData({})},paginator:{init:()=>this.setModel(new c({skip:0}),"paginator"),reset:()=>this.getModel("paginator").setData({skip:0})},form:{init:()=>this.setModel(new c,"form")},messages:{init:()=>this.setModel(new c({hasErrors:false,hasWarnings:false,records:[]}),"messages")},context:{init:()=>this.setModel(new y,"context")},i18n:{init:()=>this.setModel(new _({bundle:this._oIntegrationRb}),"i18n")}};for(const t in this._INTERNAL_MODELS){this._INTERNAL_MODELS[t].init()}};Y.prototype.clone=function(){var t=C.prototype.clone.apply(this,arguments);t._initModels();return t};Y.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_dataPassedToContent");this._awaitEvent("_headerReady");this._awaitEvent("_filterBarReady");this._awaitEvent("_contentReady");Promise.all(this._aReadyPromises).then(function(){this._onReady()}.bind(this));this.attachEventOnce("_dataReady",this._fnOnDataReady)};Y.prototype._clearReadyState=function(){this._bReady=false;this._bDataReady=false;this._aReadyPromises=[];this.detachEvent("_dataReady",this._fnOnDataReady)};Y.prototype.onBeforeRendering=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.setDesign(this.getDesign())}if(this.getDataMode()!==k.Active){return}this.startManifestProcessing()};Y.prototype.onAfterRendering=function(){if(this._isManifestReady){if(!O.hasEnded(this._sPerformanceId+"firstRenderingWithStaticData")){O.end(this._sPerformanceId+"firstRenderingWithStaticData")}if(this._bDataReady&&!O.hasEnded(this._sPerformanceId+"firstRenderingWithDynamicData")){O.end(this._sPerformanceId+"firstRenderingWithDynamicData")}}var t=this.getDomRef();if(this.getDataMode()===k.Auto){this._oCardObserver.observe(t)}else{this._oCardObserver.unobserve(t)}};Y.prototype.startManifestProcessing=function(){if(!F.isBindingSyntaxComplex()){this._logSevereError("Cannot parse manifest. Complex binding syntax is not enabled - "+"To enable it, set the 'compatVersion' configuration option to 'edge', e.g.: data-sap-ui-compatVersion='edge' - "+"sap.ui.integration.widgets.Card")}if(this._bApplyManifest||this._bApplyParameters){this._clearReadyState();this._initReadyState()}var t=this.getManifest();if(t&&this._bApplyManifest){this._cleanupOldManifest();this.createManifest(t,this.getBaseUrl())}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this._getContextAndRuntimeParams());this._applyManifestSettings()}this._bApplyManifest=false;this._bApplyParameters=false;this._refreshActionsMenu()};Y.prototype.setManifest=function(t){if(!g(this.getProperty("manifest"),t)){this.destroyActionDefinitions()}if(!t){this._destroyManifest()}this._bApplyManifest=true;this.setProperty("manifest",t);return this};Y.prototype.setManifestChanges=function(t){this.setProperty("manifestChanges",t);this._bApplyManifest=true;return this};Y.prototype.setParameters=function(t){this.setProperty("parameters",t);this._bApplyParameters=true;return this};Y.prototype.setParameter=function(t,e){var i=this.getParameters()||{};i[t]=e;this.setParameters(i);return this};Y.prototype.setHost=function(t){this.setAssociation("host",t);var e=this.getHostInstance();if(t&&!e){h.error("Host with id '"+t+"' is not available during card initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the card.","sap.ui.integration.widgets.Card");return this}this.getModel("context").setHost(e);if(this._oDestinations){this._oDestinations.setHost(e)}if(this._oDataProviderFactory){this._oDataProviderFactory.setHost(e)}if(e&&e.bUseExperimentalCaching){this.addStyleClass("sapFCardExperimentalCaching")}else{this.removeStyleClass("sapFCardExperimentalCaching")}return this};Y.prototype.createManifest=function(t,e){var i={};this._isManifestReady=false;if(typeof t==="string"){i.manifestUrl=t;t=null}if(this._oCardManifest){this._oCardManifest.destroy()}O.start(this._sPerformanceId+"initManifest","Load and initialize manifest.");O.start(this._sPerformanceId+"firstRenderingWithStaticData","First rendering with static data (includes initManifest).");O.start(this._sPerformanceId+"firstRenderingWithDynamicData","First rendering with dynamic card level data (includes firstRenderingWithStaticData).");this._oCardManifest=new o("sap.card",t,e,this.getManifestChanges());this._oCardManifest.load(i).then(function(){if(this.isDestroyed()){throw new Error(q)}if(!this._oCardManifest.get("/sap.app/id")){this._logSevereError("Card sap.app/id entry in the manifest is mandatory")}return this._oCardManifest.loadDependenciesAndIncludes()}.bind(this)).then(function(){if(this.isDestroyed()){throw new Error(q)}O.end(this._sPerformanceId+"initManifest");this._isManifestReady=true;this.fireManifestReady();return this._loadExtension()}.bind(this)).then(this._applyManifest.bind(this)).catch(function(t){if(t.message===q){return}this._logSevereError(t.message);this._applyManifest()}.bind(this))};Y.prototype._loadExtension=function(){var t=this._oCardManifest.get("/sap.card/extension"),e;if(!t){return null}if(t.startsWith(j)){e=t.replace(j,"")}else{e=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+t}return new Promise(function(t,i){sap.ui.require([e],function(e){var i=new e;i._setCard(this,this._oLimitedInterface);this.setAggregation("_extension",i);t()}.bind(this),function(t){this._logSevereError("Failed to load "+e+". Check if the path is correct. Reason: "+t);i(t)}.bind(this))}.bind(this))};Y.prototype._logSevereError=function(t){h.error(t);this._aSevereErrors.push(t)};Y.prototype.getSevereErrors=function(){return this._aSevereErrors};Y.prototype.validateControls=function(){this._validateContentControls(true);return!this.getModel("messages").getProperty("/hasErrors")};Y.prototype.getModelSizeLimit=function(){return this._iModelSizeLimit};Y.prototype._validateContentControls=function(t,e){var i=this.getCardContent();if(i&&i.isA("sap.ui.integration.cards.BaseContent")){i.validateControls(t,e)}};Y.prototype._applyManifest=function(){var t=this._oCardManifest;if(!t.get("/sap.card")){this._logSevereError("There must be a 'sap.card' section in the manifest.")}if(t&&t.getResourceBundle()){this._enhanceI18nModel(t.getResourceBundle())}this.getModel("context").resetHostProperties();if(this._hasContextParams()){this._resolveContextParams().then(function(t){this._oContextParameters=t;this._applyManifestWithParams()}.bind(this));return}this._applyManifestWithParams()};Y.prototype._applyManifestWithParams=function(){var t=this._oCardManifest,e=this._getContextAndRuntimeParams();t.processParameters(e);this._prepareToApplyManifestSettings().then(function(){this._applyManifestSettings()}.bind(this))};Y.prototype._enhanceI18nModel=function(t){var e=this.getModel("i18n"),i;i=new _({bundle:t,enhanceWith:[this._oIntegrationRb]});this.setModel(i,"i18n");e.destroy()};Y.prototype._hasContextParams=function(){var t=this._oCardManifest.get(x.PARAMS),e,i;for(e in t){i=t[e].value;if(typeof i==="string"&&i.indexOf("{context>")!==-1){return true}}return false};Y.prototype._resolveContextParams=function(){var t=this.getModel("context"),e=this._oCardManifest.get(x.PARAMS),i={},a,r;for(a in e){r=e[a].value;if(typeof r==="string"&&r.indexOf("{context>")!==-1){i[a]=r}}b.resolveValue(i,this,"/");return t.waitForPendingProperties().then(function(){return b.resolveValue(i,this,"/")}.bind(this))};Y.prototype._getContextAndRuntimeParams=function(){var t=this._oContextParameters||{},e=this.getParameters()||{};return f(t,e)};Y.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(e){this.attachEventOnce(t,function(){e()})}.bind(this)))};Y.prototype.isReady=function(){return this._bReady};Y.prototype.refresh=function(){if(this.getDataMode()===k.Active){this._bApplyManifest=true;this.invalidate()}};Y.prototype.setFilterValue=function(t,e){var i=this._oCardManifest.get(x.FILTERS);if(!i.hasOwnProperty(t)){h.error("Filter with key '"+t+"' does not exist in the manifest section 'filters'.","sap.ui.integration.widgets.Card");return}var a=this.getAggregation("_filterBar");if(!a){return}var r=a._getFilters().find(function(e){return e.getKey()===t});r.setValueFromOutside(e)};Y.prototype.setFormValues=function(t){var e=this.getCardContent();if(e&&!e.isA("sap.ui.integration.cards.ObjectContent")){h.error("Setting form element values is available only on an Object card","sap.ui.integration.widgets.Card");return}t.forEach(function(t){e.setFormFieldValue(t)})};Y.prototype.refreshData=function(){if(!this.isReady()){return}this.refreshAllData();this.resetPaginator()};Y.prototype.refreshAllData=function(){var t=this.getCardHeader(),e=this.getCardContent(),i=this.getAggregation("_filterBar");if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}if(t){t.refreshData()}if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.refreshData()}else{this._applyContentManifestSettings()}if(i){i.refreshData()}};Y.prototype._refreshActionsMenu=function(){var t=this.getCardHeader(),e=this.getHostInstance(),i=this.getAggregation("_extension"),a=[];if(!t){return}if(e){a=a.concat(e.getActions()||[])}if(i){a=a.concat(i.getActions()||[])}if(g(a,this._getActionsToolbar()._aActions)){return}this._getActionsToolbar().initializeContent(this)};Y.prototype.exit=function(){C.prototype.exit.call(this);this._destroyManifest();this._oCardObserver.destroy();this._oCardObserver=null;this._oContentFactory=null;this._oIntegrationRb=null;this._aActiveLoadingProviders=null;this._oContentMessage=null;this._oMessage=null;clearTimeout(this._iFireStateChangedCallId);if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null}};Y.prototype._destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null}if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null}this.destroyAggregation("_header");this.destroyAggregation("_content");this.destroyAggregation("_filterBar");this.destroyAggregation("_footer");this._cleanupOldManifest()};Y.prototype._cleanupOldManifest=function(){this._aReadyPromises=null;if(this._fnOnModelChange){this.getModel().detachEvent("change",this._fnOnModelChange,this);delete this._fnOnModelChange}for(const t in this._INTERNAL_MODELS){if(this._INTERNAL_MODELS[t].reset){this._INTERNAL_MODELS[t].reset()}}this._oContextParameters=null;this._deregisterCustomModels();this.destroyAggregation("_extension");if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null}this._setLoadingProviderState(false)};Y.prototype.getManifest=function(){var t=this.getProperty("manifest");if(t&&typeof t==="object"){return jQuery.extend(true,{},t)}return t};Y.prototype.getParameters=function(){var t=this.getProperty("parameters");if(t&&typeof t==="object"){return jQuery.extend(true,{},t)}return t};Y.prototype.getCombinedParameters=function(){if(!this._isManifestReady){h.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}var t=this._oCardManifest.getProcessedParameters(this._getContextAndRuntimeParams()),e={},i;for(i in t){e[i]=t[i].value}return e};Y.prototype.getManifestEntry=function(t){if(!this._isManifestReady){h.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}return this._oCardManifest.get(t)};Y.prototype.getManifestRawJson=function(){if(!this._oCardManifest||!this._oCardManifest){h.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{}}return this._oCardManifest.getInitialJson()};Y.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){h.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{}}return jQuery.extend(true,{},this._oCardManifest._oManifest.getRawJson())};Y.prototype.extendStaticConfiguration=function(t){if(this._oMessage){t.messageStrip=b.resolveValue(this._oMessage,this)}};Y.prototype.resolveDestination=function(t){return this._oDestinations.getUrl(t)};Y.prototype.processDestinations=function(t){return this._oDestinations.process(t)};Y.prototype.showMessage=function(t,e){var i=this.getCardContent();if(i&&i.isA("sap.ui.integration.cards.BaseContent")){i.showMessage(t,e);this._oMessage={text:t,type:e};this.scheduleFireStateChanged()}else{h.error("'showMessage' cannot be used before the card instance is ready. Consider using the event 'manifestApplied' event.","sap.ui.integration.widgets.Card")}};Y.prototype.hideMessage=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.hideMessage();this._oMessage=null;this.scheduleFireStateChanged()}else{h.error("'showMessage' cannot be used before the card instance is ready. Consider using the event 'manifestApplied' event.","sap.ui.integration.widgets.Card")}};Y.prototype.showBlockingMessage=function(t){var e=this.getCardContent();if(e){e.showBlockingMessage(t);this.scheduleFireStateChanged()}};Y.prototype.getBlockingMessage=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){return t.getBlockingMessage()}else if(t&&t.isA("sap.ui.integration.controls.BlockingMessage")){return{type:t.getType(),illustrationType:t.getIllustrationType(),illustrationSize:t.getIllustrationSize(),title:t.getTitle(),description:t.getDescription()}}return null};Y.prototype.hideBlockingMessage=function(){var t=this.getCardContent();if(t){t.hideBlockingMessage()}};Y.prototype.getTranslatedText=function(t,e,i){var a=this.getModel("i18n"),r;if(!a){h.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null}r=a.getResourceBundle();return r.getText(t,e,i)};Y.prototype.getDataProviderFactory=function(){if(!this._oDataProviderFactory){h.error("The DataProviderFactory instance is not ready yet. Consider using the event 'manifestApplied'.","sap.ui.integration.widgets.Card");return null}return this._oDataProviderFactory};Y.prototype.getRuntimeUrl=function(t){var e=this._oCardManifest?this._oCardManifest.get("/sap.app/id"):null,i,a=t&&t.trim().replace(/^\//,"");if(e===null){h.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}if(!e||t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//")){return t}i=e.replace(/\./g,"/");return sap.ui.require.toUrl(i)+"/"+a};Y.prototype._prepareToApplyManifestSettings=function(){var t=this._oCardManifest.get(x.APP_TYPE),e=this.getAggregation("_extension");if(t&&t!=="card"){h.error("sap.app/type entry in manifest is not 'card'")}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy()}this._oDestinations=new m({host:this.getHostInstance(),card:this,manifestConfig:this._oCardManifest.get(x.DESTINATIONS)});this._oIconFormatter=new E({card:this});return this.processDestinations(this._oCardManifest.getJson()).then(function(t){this._oCardManifest.setJson(t);this._oDataProviderFactory=new p({host:this.getHostInstance(),extension:e,csrfTokensConfig:this._oCardManifest.get(x.CSRF_TOKENS),card:this});this._registerCustomModels();if(e){e.onCardReady()}}.bind(this))};Y.prototype._applyManifestSettings=function(){this._setParametersModelData();this._checkMockPreviewMode();this._applyModelSizeLimit();this._applyServiceManifestSettings();this._applyFilterBarManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyContentManifestSettings();this._applyFooterManifestSettings();this.fireManifestApplied()};Y.prototype._setParametersModelData=function(){var t=L.getParamsForModel(),e={},i=this.getCombinedParameters(),a;for(a in i){if(B.indexOf(a)>=0){h.warning("The parameter name '"+a+"' is reserved for cards. Can not be used for creating custom parameter.")}else{e[a]={value:i[a]}}}this.getModel("parameters").setData(f(t,e))};Y.prototype._applyDataManifestSettings=function(){var t=this._oCardManifest.get(x.DATA),e;if(!t){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");return}this.bindObject(b.resolveValue(t.path||"/",this));if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t.name){e=this.getModel(t.name)}else if(this._oDataProvider){e=new u;e.setSizeLimit(this.getModelSizeLimit());this.setModel(e)}if(!e){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");return}this._fnOnModelChange=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.onCardDataChanged()}this.fireEvent("_dataPassedToContent");this.onDataRequestComplete()};e.attachEvent("change",this._fnOnModelChange,this);if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this._setLoadingProviderState(true)}.bind(this));this._oDataProvider.attachDataChanged(function(t){this.fireEvent("_dataReady");e.setData(t.getParameter("data"))}.bind(this));this._oDataProvider.attachError(function(t){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getSettings()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent")}};Y.prototype._applyServiceManifestSettings=function(){var t=this._oCardManifest.get(x.SERVICES);if(!t){return}if(!this._oServiceManager){this._oServiceManager=new d(t,this)}};Y.prototype._applyModelSizeLimit=function(){var t=this._oCardManifest.get(x.MODEL_SIZE_LIMIT);this._iModelSizeLimit=t!==undefined?t:G};Y.prototype.getCardHeader=function(){return this.getAggregation("_header")};Y.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top"}return this._oCardManifest.get(x.HEADER_POSITION)||N.Top};Y.prototype.getCardContent=function(){return this.getAggregation("_content")};Y.prototype.getCardFooter=function(){return this.getAggregation("_footer")};Y.prototype._getActionsToolbar=function(){if(!this._oActionsToolbar){this._oActionsToolbar=new i;this._oActionsToolbar.setCard(this);this._oActionsToolbar.setEnabled(false)}return this._oActionsToolbar};Y.prototype._applyHeaderManifestSettings=function(){var t=this.getAggregation("_header");if(t){t.setToolbar(null);this.destroyAggregation("_header")}var e=this.createHeader();if(!e){this.fireEvent("_headerReady");return}e.attachEvent("_error",function(t){this._handleError(t.getParameter("errorInfo"))}.bind(this));this.setAggregation("_header",e);if(e.isReady()){this.fireEvent("_headerReady")}else{e.attachEvent("_ready",function(){this.fireEvent("_headerReady")}.bind(this))}};Y.prototype._applyFilterBarManifestSettings=function(){var t=this.createFilterBar();this.destroyAggregation("_filterBar");if(!t){this.fireEvent("_filterBarReady");return}t.attachEventOnce("_filterBarDataReady",function(){this.fireEvent("_filterBarReady")}.bind(this));this.setAggregation("_filterBar",t)};Y.prototype._applyFooterManifestSettings=function(){var t=this.createFooter();this.destroyAggregation("_footer");if(t){this.setAggregation("_footer",t)}this.fireEvent("_footerReady")};Y.prototype.getHostInstance=function(){var t=this.getHost();if(!t){return null}return s.byId(t)};Y.prototype._applyContentManifestSettings=function(){var t=this._oCardManifest.get(x.TYPE),e=this.getContentManifest(),i=t+" "+this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD"),a;this.destroyAggregation("_content");this._ariaText.setText(i);if(!e||this.isTileDisplayVariant()){this.fireEvent("_contentReady");return}try{a=this.createContent({cardType:t,contentManifest:e,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,noDataConfiguration:this._oCardManifest.get(x.NO_DATA_MESSAGES)})}catch(t){this._handleError({illustrationType:w.ErrorScreen,title:this.getTranslatedText("CARD_ERROR_CONFIGURATION_TITLE"),description:this.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION"),details:t.message});return}this._setCardContent(a)};Y.prototype.isTileDisplayVariant=function(){const t=[z.TileStandard,z.TileStandardWide,z.TileFlat,z.TileFlatWide];return t.indexOf(this.getDisplayVariant())>-1};Y.prototype.createHeader=function(){var t=this._oCardManifest.get(x.HEADER),e=new A(this);return e.create(t,this._getActionsToolbar())};Y.prototype.createFilterBar=function(){var t=this._oCardManifest.get(x.FILTERS),e=new S(this);return e.create(t,this.getModel("filters"))};Y.prototype.createFooter=function(){var t=this._oCardManifest.get(x.FOOTER);if(!t){return null}return e.create(this,t)};Y.prototype.getContentManifest=function(){var t=this._oCardManifest.get(x.TYPE),e=t&&t.toLowerCase()==="component",i=this._oCardManifest.get(x.CONTENT),a=!!i;if(a&&!t){this._logSevereError("Card type property is mandatory!");return null}if(!a&&!e){return null}if(e){i=f(i,{componentManifest:this._oCardManifest.getJson()})}return i};Y.prototype.createContent=function(t){t.cardManifest=this._oCardManifest;return this._oContentFactory.create(t)};Y.prototype._setCardContent=function(t){t.attachEvent("_error",function(t){this._handleError(t.getParameter("errorInfo"))}.bind(this));this.setAggregation("_content",t);if(t.isReady()){this.fireEvent("_contentReady")}else{t.attachReady(function(){this.fireEvent("_contentReady")}.bind(this))}};Y.prototype._handleError=function(t){var e=t.requestErrorParams?t.requestErrorParams.message:t.description,i=this._oCardManifest.get(x.CONTENT),r=this._oCardManifest.get(x.TYPE)==="Component",s=this.getCardContent(),n;h.error(e,null,"sap.ui.integration.widgets.Card");this.fireEvent("_error",{message:e});if(t.requestErrorParams){n=R.configureDataRequestErrorInfo(t,this)}else{n=R.configureErrorInfo(t,this)}if(!this.isTileDisplayVariant()&&(i||r)){if(s&&s.isA("sap.ui.integration.cards.BaseContent")){this.showBlockingMessage(n)}else{this.destroyAggregation("_content");this.setAggregation("_content",a.create(n,this));this.fireEvent("_contentReady")}}else{this.getCardHeader().setAggregation("_error",a.create(n,this))}};Y.prototype.getContentMessage=function(){return this._oContentMessage};Y.prototype.setDataMode=function(t){if(this._oDataProviderFactory&&t===k.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null}this.setProperty("dataMode",t);if(this.getProperty("dataMode")===k.Active){this.refresh()}return this};Y.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime)}if(!this._oCardManifest){return new Promise(function(t,e){this.attachManifestReady(function(){this.loadDesigntime().then(t,e)}.bind(this))}.bind(this))}var t=this._oCardManifest.get("/sap.app/id");if(!t){return Promise.reject("App id not maintained")}return new Promise(function(t,e){var i=this._oCardManifest.get("/sap.card/configuration/editor");if(i===undefined){i=this._oCardManifest.get("/sap.card/designtime")}var a=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+i;if(a){sap.ui.require([a],function(e){e=new e;e._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=e;t(e)}.bind(this))}.bind(this),function(){e({error:a+" not found"})})}else{e()}}.bind(this))};Y.prototype.showLoadingPlaceholders=function(t){var e;switch(t){case H.Header:e=this.getCardHeader();if(e){e.showLoadingPlaceholders()}break;case H.Filters:e=this.getAggregation("_filterBar");if(e){e.showLoadingPlaceholders()}break;case H.Content:e=this.getCardContent();if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.showLoadingPlaceholders()}break;default:this.showLoadingPlaceholders(H.Header);this.showLoadingPlaceholders(H.Filters);this.showLoadingPlaceholders(H.Content);this._setLoadingProviderState(true)}return this};Y.prototype.hideLoadingPlaceholders=function(t){var e;switch(t){case H.Header:e=this.getCardHeader();if(e){e.hideLoadingPlaceholders()}break;case H.Filters:e=this.getAggregation("_filterBar");if(e){e.hideLoadingPlaceholders()}break;case H.Content:e=this.getCardContent();if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.hideLoadingPlaceholders()}break;default:this.hideLoadingPlaceholders(H.Header);this.hideLoadingPlaceholders(H.Filters);this.hideLoadingPlaceholders(H.Content);this._setLoadingProviderState(false)}return this};Y.prototype.isLoading=function(){return this.getAggregation("_loadingProvider").getLoading()};Y.prototype.getFocusDomRef=function(){var t=this.getCardHeader();if(t&&t.getFocusDomRef()){return t.getFocusDomRef()}return this.getDomRef()};Y.prototype.onDataRequestComplete=function(){var t=this.getCardContent();this.hideLoadingPlaceholders(H.Header);this.hideLoadingPlaceholders(H.Filters);if(t&&t.isA("sap.ui.integration.cards.BaseContent")&&t.isReady()){this.hideLoadingPlaceholders(H.Content)}this._setLoadingProviderState(false);this._fireContentDataChange()};Y.prototype.request=function(t){return this.processDestinations(t).then(function(t){return this._oDataProviderFactory.create({request:t}).setAllowCustomDataType(true).getData()}.bind(this))};Y.prototype.triggerAction=function(t){T.fireAction({card:this,host:this.getHostInstance(),action:t,parameters:t.parameters,source:this})};Y.prototype.hasNoData=function(){return this.getBlockingMessage()&&this.getBlockingMessage().type===W.NoData};Y.prototype.showNoData=function(t){this.showBlockingMessage({type:W.NoData,illustrationType:t.type,illustrationSize:t.size,title:t.title,description:t.description})};Y.prototype._setPreviewMode=function(t){if(t){this.setPreviewMode(U.Abstract)}else{this.setPreviewMode(U.Off)}};Y.prototype.setPreviewMode=function(t){var e=this.getPreviewMode();this.setProperty("previewMode",t);if(e!==this.getPreviewMode()){this._bApplyManifest=true}return this};Y.prototype.getBindingNamespaces=function(){var t={},e=this.getAggregation("_extension");if(e){t.extension={formatters:e.getFormatters()}}return t};Y.prototype._registerCustomModels=function(){var t=this._oCardManifest.findDataSections();if(!this._aCustomModels){this._aCustomModels=[]}this._deregisterCustomModels();t.forEach(function(t){var e=t&&t.name;if(!e){return}if(this._INTERNAL_MODELS[e]){h.error("The model name (data section name) '"+e+"' is reserved for cards. Can not be used for creating a custom model.");return}if(this._aCustomModels.indexOf(e)>-1){h.error("The model name (data section name) '"+e+"' is already used.");return}var i=new u;i.setSizeLimit(this.getModelSizeLimit());this.setModel(i,e);this._aCustomModels.push(e)}.bind(this))};Y.prototype._deregisterCustomModels=function(){if(!this._aCustomModels){return}this._aCustomModels.forEach(function(t){this.getModel(t).destroy();this.setModel(null,t)}.bind(this));this._aCustomModels=[]};Y.prototype._fireConfigurationChange=function(t){var e=this.getHostInstance();if(!this.isReady()){return}this.fireConfigurationChange({changes:t});if(e){e.fireCardConfigurationChange({card:this,changes:t})}};Y.prototype.scheduleFireStateChanged=function(){if(this._iFireStateChangedCallId){clearTimeout(this._iFireStateChangedCallId)}this._iFireStateChangedCallId=setTimeout(this._fireStateChangedBound,0)};Y.prototype._fireStateChanged=function(){var t=this.getHostInstance();if(!this.isReady()){return}this.fireStateChanged();if(t){t.fireCardStateChanged({card:this})}};Y.prototype._fireInitialized=function(){if(this._bInitializedFired){return}var t=this.getHostInstance();this.fireEvent("_initialized");this._bInitializedFired=true;if(t){t.fireCardInitialized({card:this})}};Y.prototype._fireDataChange=function(){this.fireEvent("_dataChange");this.scheduleFireStateChanged()};Y.prototype._fireContentDataChange=function(){this.fireEvent("_contentDataChange");this._fireDataChange()};Y.prototype._onReady=function(){this._bReady=true;this._setActionButtonsEnabled(true);this._validateContentControls(false,true);this.fireEvent("_ready");this._fireInitialized();this.scheduleFireStateChanged()};Y.prototype._setLoadingProviderState=function(t){var e=this.getAggregation("_loadingProvider");if(this._isDataProviderJson()){return}e.setLoading(t);if(t){this.addActiveLoadingProvider(e)}else{this.removeActiveLoadingProvider(e)}};Y.prototype.addActiveLoadingProvider=function(t){if(!this.isReady()){return}if(!this.hasActiveLoadingProvider()){this._setActionButtonsEnabled(false)}if(this._aActiveLoadingProviders.indexOf(t)===-1){this._aActiveLoadingProviders.push(t)}};Y.prototype.removeActiveLoadingProvider=function(t){if(!this.isReady()){return}var e=this._aActiveLoadingProviders,i=e.indexOf(t);e.splice(i,1);if(!this.hasActiveLoadingProvider()){this._setActionButtonsEnabled(true)}};Y.prototype._setActionButtonsEnabled=function(t){var e=this.getAggregation("_footer");if(e){e.setEnabled(t)}if(this._oActionsToolbar){this._oActionsToolbar.setEnabled(t)}};Y.prototype.hasActiveLoadingProvider=function(){return this._aActiveLoadingProviders.length>0};Y.prototype.isSkeleton=function(){return false};Y.prototype.getContentPageSize=function(t){var e,i,a=this.getCardFooter();if(a&&a.getPaginator()){return a.getPaginator().getPageSize()}e=b.resolveValue(t.maxItems,this);if(e==null){return null}i=parseInt(e);if(isNaN(i)){h.error("Value for maxItems must be integer.");return null}return i};Y.prototype.getContentMinItems=function(t){var e=b.resolveValue(t.minItems,this),i;if(e==null){return this.getContentPageSize(t)}i=parseInt(e);if(isNaN(i)){h.error("Value for minItems must be integer.");return null}return i};Y.prototype.hasPaginator=function(){var t=this._oCardManifest.get(x.FOOTER);return t&&t.paginator};Y.prototype.resetPaginator=function(){if(this.hasPaginator()){this.getCardFooter().getPaginator().reset()}};Y.prototype.showCard=function(t){var e=this._createChildCard(t);t._cardId=e.getId();this.triggerAction({type:"ShowCard",parameters:t});return Promise.resolve(e)};Y.prototype.hide=function(){this.triggerAction({type:"HideCard"})};Y.prototype.getOpener=function(){var t=s.byId(this.getAssociation("openerReference"));if(!t){return null}return t._oLimitedInterface};Y.prototype._createChildCard=function(t){var e=t.manifest,i=t.baseUrl,a=t.data,r=this._createCard({width:t.width,host:this.getHostInstance(),parameters:t.parameters,referenceId:this.getReferenceId()});r.setAssociation("openerReference",this);if(a){l(a,function(t,e){var i=new c(e);i.setSizeLimit(this.getModelSizeLimit());r.setModel(i,t)}.bind(this))}if(typeof e==="string"){r.setManifest(this.getRuntimeUrl(e));if(i){r.setBaseUrl(i)}}else{r.setManifest(e);r.setBaseUrl(i||this.getRuntimeUrl("/"))}return r};Y.prototype._createCard=function(t){return new Y(t)};Y.prototype._isDataProviderJson=function(){return this._oDataProvider&&this._oDataProvider.getSettings()&&this._oDataProvider.getSettings()["json"]};Y.prototype._checkMockPreviewMode=function(){if(this.getPreviewMode()!==U.MockData){return}var t=this._oCardManifest.findDataSections(),e;e=t.some(function(t){if(!p.isProvidingConfiguration(t)){return false}return!(t.mockData&&p.isProvidingConfiguration(t.mockData))});if(e){h.warning("'mockData' configuration is missing, but the card 'previewMode' is 'MockData'. Abstract mode will be used instead.",this);this.setProperty("previewMode",U.Abstract);this.attachEventOnce("manifestApplied",function(){this.showMessage(this._oIntegrationRb.getText("CARD_MISSING_PREVIEW_CONFIGURATION"),J.Information)}.bind(this))}};return Y});
//# sourceMappingURL=Card.js.map